/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import oracle.dbtools.plugin.api.di.InstanceLocator;
import oracle.dbtools.plugin.api.types.AnnotationSet;
import oracle.dbtools.plugin.api.types.TypeConstantField;
import oracle.dbtools.plugin.api.types.TypeDependencies;
import oracle.dbtools.plugin.api.types.TypeInstantiator;
import oracle.dbtools.plugin.api.types.TypeProvider;
import oracle.dbtools.plugin.api.types.TypeQualifier;

public class TypeReflection<T>
implements Comparable<TypeReflection<?>> {
    private final AnnotationSet annotations;
    private final List<TypeConstantField<?>> constantFields;
    private final TypeDependencies<T> dependencies;
    private final TypeInstantiator<T> instantiator;
    private final Set<TypeQualifier<?>> provides;
    private final int hashCode;

    TypeReflection(TypeDependencies<T> dependencies, TypeInstantiator<T> instantiator, Set<TypeQualifier<?>> provides, List<TypeConstantField<?>> constantFields, AnnotationSet annotations) {
        this.dependencies = dependencies;
        this.instantiator = instantiator;
        this.provides = provides;
        this.constantFields = constantFields;
        this.annotations = annotations;
        this.hashCode = Objects.hash(dependencies, instantiator, provides);
    }

    @Override
    public int compareTo(TypeReflection<?> o) {
        String name = this.type().getName();
        String otherName = o == null ? null : o.type().getName();
        return name.compareTo(otherName);
    }

    public List<TypeConstantField<?>> constantFields() {
        return this.constantFields;
    }

    public TypeDependencies<T> dependencies() {
        return this.dependencies;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeReflection)) {
            return false;
        }
        TypeReflection other = (TypeReflection)obj;
        return Objects.equals(this.dependencies, other.dependencies) && Objects.equals(this.instantiator, other.instantiator) && Objects.equals(this.provides, other.provides);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.annotations.getAnnotation(annotationClass);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public TypeInstantiator<T> instantiator() {
        return this.instantiator;
    }

    public boolean isConcrete() {
        return this.dependencies.isConcrete();
    }

    public Set<TypeQualifier<?>> provides() {
        return this.provides;
    }

    public Annotation scope() {
        return this.annotations.scope();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TypeReflection [dependencies=");
        builder.append(this.dependencies);
        builder.append(", provides=");
        builder.append(this.provides);
        builder.append("]");
        return builder.toString();
    }

    public Class<T> type() {
        return this.dependencies.type();
    }

    public TypeProvider<T> using(InstanceLocator locator) {
        return new TypeInstanceProvider<T>(this.instantiator(), locator);
    }

    TypeReflection<T> useInstantiator(TypeInstantiator<T> instantiator) {
        return new TypeReflection<T>(this.dependencies, instantiator, this.provides, this.constantFields, this.annotations);
    }

    private static final class TypeInstanceProvider<T>
    implements TypeProvider<T> {
        private final TypeInstantiator<T> instantiator;
        private final InstanceLocator locator;

        TypeInstanceProvider(TypeInstantiator<T> instantiator, InstanceLocator locator) {
            this.instantiator = instantiator;
            this.locator = locator;
        }

        @Override
        public boolean dependenciesSatisfied() {
            return this.instantiator.dependenciesSatisfied(this.locator);
        }

        @Override
        public T get() {
            return this.instantiator.load(this.locator);
        }
    }
}

