/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.Objects;
import oracle.dbtools.plugin.api.types.Primitive;
import oracle.dbtools.plugin.api.types.TypeQualifier;
import oracle.dbtools.plugin.api.types.TypeReflection;

class TypeQualifierImpl<T>
implements TypeQualifier<T> {
    private final transient int hashCode;
    private final TypeQualifier.MatchingMode matchingMode;
    private final String name;
    private final transient TypeQualifier<?> normalized;
    private final Class<T> type;

    private TypeQualifierImpl(Class<T> type, String name, TypeQualifier.MatchingMode matchingMode) {
        TypeQualifierImpl normalized;
        this.type = type;
        this.name = name;
        this.matchingMode = matchingMode;
        this.hashCode = Objects.hash(new Object[]{matchingMode, name, type});
        Primitive primitive = Primitive.valueOf(type);
        this.normalized = normalized = primitive.isPrimitive() ? this.withType(primitive.wrapperType()) : this;
    }

    @Override
    public String declaration() {
        StringBuilder b = new StringBuilder();
        b.append(TypeQualifier.class.getSimpleName());
        switch (this.matchingMode()) {
            case EXACT_TYPE: {
                b.append(".type(");
                b.append(this.type().getCanonicalName());
                b.append(".class");
                b.append(")");
                break;
            }
            case PROVIDER: {
                if (this.name == null) {
                    b.append(".provides(");
                    b.append(this.type().getCanonicalName());
                    b.append(".class");
                    b.append(")");
                    break;
                }
                b.append(".named(");
                b.append(this.type().getCanonicalName());
                b.append(".class,");
                b.append("\"");
                b.append(this.name);
                b.append("\"");
                b.append(")");
                break;
            }
            case ANY_PROVIDER: {
                b.append(".any(");
                b.append(this.type().getCanonicalName());
                b.append(".class");
                b.append(")");
            }
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeQualifierImpl)) {
            return false;
        }
        TypeQualifierImpl other = (TypeQualifierImpl)obj;
        return this.hashCode == other.hashCode && this.matchingMode == other.matchingMode && Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isEmpty() {
        return this.name == null;
    }

    @Override
    public boolean matches(TypeQualifier<?> other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.matchingMode == TypeQualifier.MatchingMode.ANY_PROVIDER) {
            return Objects.equals(this.type(), other.type());
        }
        return this.equals(other);
    }

    @Override
    public boolean matches(TypeReflection<?> type) {
        switch (this.matchingMode) {
            case EXACT_TYPE: {
                return this.type == type.type();
            }
            case PROVIDER: {
                return type.provides().contains(this);
            }
            case ANY_PROVIDER: {
                for (TypeQualifier<?> service : type.provides()) {
                    if (this.type != service.type()) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    public TypeQualifier.MatchingMode matchingMode() {
        return this.matchingMode;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public final TypeQualifier<?> normalize() {
        return this.normalized;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        switch (this.matchingMode()) {
            case EXACT_TYPE: {
                b.append("type ");
                b.append(this.type().getCanonicalName());
                break;
            }
            case PROVIDER: {
                b.append("provides ");
                if (this.name != null) {
                    b.append("@Named(");
                    b.append(this.name);
                    b.append(") ");
                }
                b.append(this.type().getCanonicalName());
                break;
            }
            case ANY_PROVIDER: {
                b.append("any ");
                b.append(this.type().getCanonicalName());
            }
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    @Override
    public <E> TypeQualifier<E> withType(Class<E> type) {
        return new TypeQualifierImpl<E>(type, this.name, this.matchingMode);
    }

    static <T> TypeQualifier<T> any(Class<T> type) {
        return new TypeQualifierImpl<T>(type, null, TypeQualifier.MatchingMode.ANY_PROVIDER);
    }

    static <T> TypeQualifier<T> from(Class<T> type, Iterable<? extends Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Named)) continue;
            return TypeQualifierImpl.named(type, ((Named)annotation).value());
        }
        return TypeQualifierImpl.provides(type);
    }

    static <T> TypeQualifier<T> named(Class<T> type, String name) {
        if (name == null) {
            return TypeQualifierImpl.provides(type);
        }
        return new TypeQualifierImpl<T>(type, name, TypeQualifier.MatchingMode.PROVIDER);
    }

    static <T> TypeQualifier<T> provides(Class<T> type) {
        return new TypeQualifierImpl<T>(type, null, TypeQualifier.MatchingMode.PROVIDER);
    }

    static <T> TypeQualifier<T> type(Class<T> type) {
        return new TypeQualifierImpl<T>(type, null, TypeQualifier.MatchingMode.EXACT_TYPE);
    }
}

