/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import jakarta.inject.Inject;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import oracle.dbtools.plugin.api.di.InstanceLocator;
import oracle.dbtools.plugin.api.di.InstanceProvider;
import oracle.dbtools.plugin.api.types.TypeDependency;
import oracle.dbtools.plugin.api.types.TypeDependencyNotAvailableException;
import oracle.dbtools.plugin.api.types.TypeReflections;

public class TypeDependencies<T>
implements Iterable<TypeDependency> {
    private final transient Constructor<T> ctor;
    private final transient MethodHandle ctorHandle;
    private final transient List<TypeDependency> deps;
    private final int hashCode;
    private final Class<T> type;

    TypeDependencies(Class<T> type, List<TypeDependency> deps, Constructor<T> ctor, MethodHandle ctorHandle) {
        this.type = type;
        this.deps = deps;
        this.ctor = ctor;
        this.ctorHandle = ctorHandle;
        this.hashCode = Objects.hash(type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeDependencies)) {
            return false;
        }
        TypeDependencies other = (TypeDependencies)obj;
        return Objects.equals(this.type, other.type);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isConcrete() {
        return this.isInstantiable();
    }

    public boolean isInstantiable() {
        return this.ctor != null;
    }

    @Override
    public Iterator<TypeDependency> iterator() {
        return this.deps.iterator();
    }

    public int size() {
        return this.deps.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TypeDependencies [type=");
        builder.append(this.type);
        builder.append(", deps=");
        builder.append(this.deps);
        builder.append("]");
        return builder.toString();
    }

    public Class<T> type() {
        return this.type;
    }

    public boolean dependenciesSatisfied(InstanceLocator locator) {
        block3: for (TypeDependency dependency : this.deps) {
            InstanceProvider<?> resolved = locator.select(dependency.qualifier());
            switch (dependency.kind()) {
                case OPTIONAL: 
                case MULTIPLE: 
                case PROVIDER: {
                    continue block3;
                }
            }
            if (!resolved.isUnsatisfied()) continue;
            return false;
        }
        return true;
    }

    T newInstance(InstanceLocator locator) throws TypeDependencyNotAvailableException {
        Object[] args = new Object[this.deps.size()];
        int argIndex = 0;
        for (TypeDependency dependency : this.deps) {
            InstanceProvider<?> resolved = locator.select(dependency.qualifier());
            switch (dependency.kind()) {
                case OPTIONAL: {
                    args[argIndex] = resolved.isUnsatisfied() ? null : resolved.get();
                    break;
                }
                case MULTIPLE: 
                case PROVIDER: {
                    args[argIndex] = resolved;
                    break;
                }
                default: {
                    try {
                        args[argIndex] = resolved.get();
                        break;
                    }
                    catch (Throwable t) {
                        throw TypeDependencyNotAvailableException.from(this.type, dependency, t);
                    }
                }
            }
            ++argIndex;
        }
        try {
            Object instance = this.ctorHandle.invokeWithArguments(args);
            return this.type.cast(instance);
        }
        catch (Throwable e) {
            throw TypeDependencyNotAvailableException.from(this.type, e);
        }
    }

    static <T> TypeDependencies<T> forType(Class<T> type) {
        if (TypeDependencies.instantiable(type)) {
            ArrayList<TypeDependency> dependencies = new ArrayList<TypeDependency>();
            Constructor<T> ctor = TypeDependencies.ctor(type);
            if (ctor == null) {
                return new TypeDependencies<T>(type, Collections.emptyList(), null, null);
            }
            for (Parameter parameter : ctor.getParameters()) {
                TypeDependency dep = TypeDependency.from(parameter);
                dependencies.add(dep);
            }
            MethodHandle ctorHandle = TypeDependencies.methodHandle(ctor);
            return new TypeDependencies<T>(type, dependencies, ctor, ctorHandle);
        }
        return new TypeDependencies<T>(type, Collections.emptyList(), null, null);
    }

    private static <T> Constructor<T> ctor(Class<T> type) {
        for (Constructor<?> ctor : type.getDeclaredConstructors()) {
            if (!ctor.isAnnotationPresent(Inject.class)) continue;
            Constructor<?> typed = ctor;
            return typed;
        }
        for (Constructor<?> ctor : type.getDeclaredConstructors()) {
            if (!Modifier.isPublic(ctor.getModifiers()) || ctor.getParameterCount() != 0) continue;
            Constructor<?> typed = ctor;
            return typed;
        }
        return null;
    }

    private static <T> boolean instantiable(Class<T> type) {
        return !type.isPrimitive() && !type.isArray() && !type.isInterface() && !Modifier.isAbstract(type.getModifiers());
    }

    private static <T> MethodHandle methodHandle(Constructor<T> ctor) {
        try {
            ctor.setAccessible(true);
            MethodHandle ctorHandle = TypeReflections.lookup().unreflectConstructor(ctor);
            return ctorHandle;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

