/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.apt;

import jakarta.inject.Inject;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

class InstantiableTypes {
    static final String FACTORY_SUFFIX = "__Factory__";

    InstantiableTypes() {
    }

    boolean isInstantiable(TypeElement type) {
        if (this.isConcreteType(type) && this.hasPackage(type)) {
            List<ExecutableElement> ctors = ElementFilter.constructorsIn(type.getEnclosedElements());
            ExecutableElement ctor = null;
            for (ExecutableElement c : ctors) {
                if (!this.isInjectableConstructor(c) && !this.isDefaultConstructor(c)) continue;
                ctor = c;
                break;
            }
            if (ctor != null) {
                return true;
            }
        }
        return false;
    }

    boolean isConcreteType(TypeElement type) {
        Element enclosingElement = type.getEnclosingElement();
        boolean isAbstract = type.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean isNested = enclosingElement != null && ElementKind.PACKAGE != enclosingElement.getKind();
        boolean isStatic = type.getModifiers().contains((Object)Modifier.STATIC);
        boolean isConcrete = ElementKind.CLASS == type.getKind() && !isAbstract && (!isNested || isStatic);
        return isConcrete;
    }

    private boolean hasPackage(TypeElement type) {
        boolean hasPackage = false;
        Element current = type;
        while (current != null) {
            Element parent = current.getEnclosingElement();
            if (parent != null && ElementKind.PACKAGE == parent.getKind()) {
                PackageElement enclosingPackage = (PackageElement)parent;
                return !enclosingPackage.isUnnamed();
            }
            current = parent;
        }
        return false;
    }

    private boolean isDefaultConstructor(ExecutableElement ctor) {
        return ctor.getParameters().isEmpty() && this.isVisible(ctor);
    }

    private boolean isInjectableConstructor(ExecutableElement ctor) {
        return ctor.getAnnotation(Inject.class) != null;
    }

    private boolean isVisible(ExecutableElement ctor) {
        boolean visible = true;
        Element current = ctor;
        while (current != null) {
            boolean isPublic = current.getModifiers().contains((Object)Modifier.PUBLIC);
            if (!isPublic) {
                visible = false;
                break;
            }
            if ((current = current.getEnclosingElement()) == null || current.getKind() != ElementKind.PACKAGE) continue;
            current = null;
        }
        return visible;
    }

    static PackageElement enclosingPackage(TypeElement type) {
        Element current = type;
        while (current != null) {
            PackageElement enclosingPackage;
            Element parent = current.getEnclosingElement();
            if (parent != null && ElementKind.PACKAGE == parent.getKind() && !(enclosingPackage = (PackageElement)parent).isUnnamed()) {
                return enclosingPackage;
            }
            current = parent;
        }
        return null;
    }
}

