import { ComponentChildren } from 'preact';
import { HTMLAttributesSignalExcluded } from '@oracle/oraclejet-preact/utils/UNSAFE_attributeUtils';
export type Slot = ComponentChildren;
export type TemplateSlot<Data extends object> = (data: Data) => Slot;
export type DynamicSlots = Record<string, Slot>;
export type DynamicTemplateSlots<Data> = Record<string, Data extends object ? TemplateSlot<Data> : never>;
export type ImplicitBusyContext = unknown;
export type PropertyChanged<T> = (value: T) => void;
export type ReadOnlyPropertyChanged<T> = (value: T) => void;
export type Action<Detail extends object = {}> = [keyof Detail] extends [never] ? (detail?: Detail) => void : (detail: Detail) => void;
export type CancelableAction<Detail extends object = {}> = [keyof Detail] extends [never] ? (detail?: Detail) => Promise<void> : (detail: Detail) => Promise<void>;
export type Bubbles = {};
export type ElementReadOnly<T> = T;
type GlobalEventHandlerProps = 'onBlur' | 'onBlurCapture' | 'onClick' | 'onClickCapture' | 'onContextMenu' | 'onContextMenuCapture' | 'onDblClick' | 'onDblClickCapture' | 'onDrag' | 'onDragCapture' | 'onDragEnd' | 'onDragEndCapture' | 'onDragEnter' | 'onDragEnterCapture' | 'onDragExit' | 'onDragExitCapture' | 'onDragLeave' | 'onDragLeaveCapture' | 'onDragOver' | 'onDragOverCapture' | 'onDragStart' | 'onDragStartCapture' | 'onDrop' | 'onDropCapture' | 'onFocus' | 'onFocusCapture' | 'onKeyDown' | 'onKeyDownCapture' | 'onKeyPress' | 'onKeyPressCapture' | 'onKeyUp' | 'onKeyUpCapture' | 'onMouseDown' | 'onMouseDownCapture' | 'onMouseEnter' | 'onMouseEnterCapture' | 'onMouseLeave' | 'onMouseLeaveCapture' | 'onMouseMove' | 'onMouseMoveCapture' | 'onMouseOut' | 'onMouseOutCapture' | 'onMouseOver' | 'onMouseOverCapture' | 'onMouseUp' | 'onMouseUpCapture' | 'onPointerOver' | 'onPointerOverCapture' | 'onPointerEnter' | 'onPointerEnterCapture' | 'onPointerDown' | 'onPointerDownCapture' | 'onPointerMove' | 'onPointerMoveCapture' | 'onPointerUp' | 'onPointerUpCapture' | 'onPointerCancel' | 'onPointerCancelCapture' | 'onPointerOut' | 'onPointerOutCapture' | 'onPointerLeave' | 'onPointerLeaveCapture' | 'onTouchCancel' | 'onTouchCancelCapture' | 'onTouchEnd' | 'onTouchEndCapture' | 'onTouchMove' | 'onTouchMoveCapture' | 'onTouchStart' | 'onTouchStartCapture' | 'onWheel' | 'onWheelCapture' | 'onFocusIn' | 'onFocusInCapture' | 'onFocusOut' | 'onFocusOutCapture';
export type GlobalProps = Readonly<Pick<HTMLAttributesSignalExcluded, 'accesskey' | 'accessKey' | 'autocapitalize' | 'autoCapitalize' | 'autofocus' | 'autoFocus' | 'class' | 'contenteditable' | 'contentEditable' | 'dir' | 'draggable' | 'enterkeyhint' | 'hidden' | 'id' | 'inputmode' | 'inputMode' | 'lang' | 'role' | 'slot' | 'spellcheck' | 'spellCheck' | 'style' | 'tabindex' | 'tabIndex' | 'title' | 'translate' | 'aria-activedescendant' | 'aria-atomic' | 'aria-autocomplete' | 'aria-busy' | 'aria-checked' | 'aria-colcount' | 'aria-colindex' | 'aria-colspan' | 'aria-controls' | 'aria-current' | 'aria-describedby' | 'aria-details' | 'aria-disabled' | 'aria-errormessage' | 'aria-expanded' | 'aria-flowto' | 'aria-haspopup' | 'aria-hidden' | 'aria-invalid' | 'aria-keyshortcuts' | 'aria-label' | 'aria-labelledby' | 'aria-level' | 'aria-live' | 'aria-modal' | 'aria-multiline' | 'aria-multiselectable' | 'aria-orientation' | 'aria-owns' | 'aria-placeholder' | 'aria-posinset' | 'aria-pressed' | 'aria-readonly' | 'aria-relevant' | 'aria-required' | 'aria-roledescription' | 'aria-rowcount' | 'aria-rowindex' | 'aria-rowspan' | 'aria-selected' | 'aria-setsize' | 'aria-sort' | 'aria-valuemax' | 'aria-valuemin' | 'aria-valuenow' | 'aria-valuetext' | GlobalEventHandlerProps> & {
    enterKeyHint?: HTMLAttributesSignalExcluded['enterkeyhint'];
    onfocusin?: HTMLAttributesSignalExcluded['onFocusIn'];
    onfocusinCapture?: HTMLAttributesSignalExcluded['onFocusInCapture'];
    onfocusout?: HTMLAttributesSignalExcluded['onFocusOut'];
    onfocusoutCapture?: HTMLAttributesSignalExcluded['onFocusOutCapture'];
}>;
type GlobalEventHandlerPropsExtended = GlobalEventHandlerProps | 'onfocusin' | 'onfocusinCapture' | 'onfocusout' | 'onfocusoutCapture';
export type ObservedGlobalProps<U extends Exclude<keyof GlobalProps, 'class' | 'style' | GlobalEventHandlerPropsExtended>> = Pick<GlobalProps, U>;
export type ExtendGlobalProps<Props> = Readonly<Props> & GlobalProps;
export {};
