/**
 * Copyright (c) 2017, Oracle and/or its affiliates.
 * All rights reserved.
 */

define(["../persistenceUtils","../persistenceStoreManager","./logger"],(function(e,r,t){"use strict";function n(){Object.defineProperty(this,"_endpointToOptionsMap",{value:{},writable:!0})}function o(e){for(var r=e.name,t=e.resourceIdentifier,n=e.keys,o=[],i=(new Date).toUTCString(),a=0;a<n.length;a++){var s={key:n[a],metadata:{lastUpdated:i,resourceIdentifier:t},value:e.data[a]};o.push(s)}var u={};return u[r]=o,u}n.prototype.constructRequestResponseCacheData=function(r,n){var o=this,i={};return t.log("Offline Persistence Toolkit DefaultCacheHandler: constructRequestResponseCacheData()"),e.requestToJSON(r).then((function(t){i.requestData=t;var a=o.hasShredder(r);return e.responseToJSON(n,{excludeBody:a})})).then((function(e){return i.responseData=e,{key:o._constructCacheKey(r,n),metadata:o.constructMetadata(r),value:i}}))},n.prototype.constructShreddedData=function(e,r){t.log("Offline Persistence Toolkit DefaultCacheHandler: constructShreddedData()");var n=this._getShredder(e);return n?n(r).then((function(e){return e&&Array.isArray(e)?e.map(o):null})):Promise.resolve()},n.prototype.shredResponse=function(e,r){t.log("Offline Persistence Toolkit DefaultCacheHandler: shredResponse()");var n=this._getShredder(e);return n?n(r):Promise.resolve()},n.prototype.cacheShreddedData=function(e,n){t.log("Offline Persistence Toolkit DefaultCacheHandler: cacheShreddedData()");var i=e.map(o),a=this;return function(e){var n=e.map((function(e){var n=Object.keys(e)[0],o=e[n];return o&&o.length?function(e,n){return t.log("Offline Persistence Toolkit DefaultCacheHandler: Updating store with shredded data"),r.openStore(e).then((function(e){return e.upsertAll(n)}))}(n,o):Promise.resolve()}));return Promise.all(n)}(i).then((function(){if(a._isCompleteCollection(n,e))return function(e){var t=e.map((function(e){var t=e.name,n={selector:{key:{$nin:e.keys}}};return r.openStore(t).then((function(e){return e.delete(n)}))}));return Promise.all(t)}(e)}))},n.prototype._isCompleteCollection=function(e,r){if(!e||"GET"!==e.method&&"HEAD"!==e.method)return!1;if(!function(e){if(!e)return!1;for(var r=0;r<e.length;r++)if("collection"!==e[r].resourceType)return!1;return!0}(r))return!1;if(e.url===e.baseUrl)return!0;var t=this._getQueryHandler(e.url);if(!t||"function"!=typeof t.normalizeQueryParameter)return!1;var n=t.normalizeQueryParameter(e.url);if(n.searchCriteria||0!==n.offset)return!1;var o=n.limit;return o<0||r[0].keys.length<o},n.prototype._constructCacheKey=function(e,r){var t=e.url+"$"+e.method+"$";if(r){var n=r.headers;if(n&&(s=n.get("vary")))if("*"===s)t=1e3*(new Date).getTime()+Math.floor(1e3*Math.random());else for(var o=e.headers,i=s.split(","),a=0;a<i.length;a++){var s,u=i[a];t+=(u=u.trim())+"="+(s=o&&o.get(u)?o.get(u):"undefined")+";"}}return t},n.prototype.getMatchedCacheKeys=function(e,r,t){var n,o;return n=r&&r.ignoreSearch?i(e.url):e.url,r&&r.ignoreMethod||(o=e.method),t.filter((function(t){var s=t.split("$");if(1===s.length){if(t.slice(0,n.length)!==n)return!1;if(r&&r.ignoreSearch&&"/"===t[n.length])return!1;if(o&&-1===(r&&r.ignoreSearch?t.slice(n.length):t.slice(n.length,n.length+e.method.length)).indexOf(o))return!1;if(!r||!r.ignoreVary){var u=t;if(!(u=o?(u=u.split(o))[u.length-1]:a(u)))return!0;var l=u.split("="),c=e.headers;if(2===l){if((f=c&&c.get(l[0])?c.get(l[0]):"undefined")!==l[1])return!1}else for(var d=0;d<l.length-1;d++){var h=l[d],f=c&&c.get(h)?c.get(h):"undefined",p=l[d+1].split(f);if(2!==p.length&&""!==p[0])return!1;if(p[1]&&p[1].startsWith(","))return!1;l[d+1]=p[1]}}return!0}if((r&&r.ignoreSearch?i(s[0]):s[0])!==n)return!1;if(o&&s[1]!==o)return!1;if(!r||!r.ignoreVary){if(!(u=s[2]))return!0;var g=u.split(";");if(1===g.length)return!1;for(c=e.headers,d=0;d<g.length-1;d++)if(h=g[d].split("="),(f=c&&c.get(h[0])?c.get(h[0]):"undefined")!=h[1])return!1}return!0}))},n.prototype.constructMetadata=function(e){var r=(new Date).getTime(),t=i(e.url);return{url:e.url,method:e.method,baseUrl:t,created:r,lastupdated:r}},n.prototype.constructResponse=function(r){return t.log("Offline Persistence Toolkit DefaultCacheHandler: constructResponse()"),e.responseFromJSON(r).then((function(r){return e.isCachedResponse(r)||r.headers.set("x-oracle-jscpt-cache-expiration-date",""),r}))},n.prototype.constructSearchCriteria=function(e,r){t.log("Offline Persistence Toolkit DefaultCacheHandler: constructSearchCriteria()");var n=!1;r&&void 0!==r.ignoreSearch&&(n=r.ignoreSearch);var o,a=!1;return r&&void 0!==r.ignoreMethod&&(a=r.ignoreMethod),o=n?{"metadata.baseUrl":i(e.url)}:{"metadata.url":e.url},a||(o["metadata.method"]=e.method),{selector:o,sort:["metadata.created"]}},n.prototype.registerEndpointOptions=function(e,r){if(!e)throw new Error({message:"a valid endpointKey must be provided."});if(this._endpointToOptionsMap[e])throw new Error({message:"endpointKey can only be registered once."});this._endpointToOptionsMap[e]=r},n.prototype.unregisterEndpointOptions=function(e){if(!e)throw new Error({message:"a valid endpointKey must be provided."});delete this._endpointToOptionsMap[e]},n.prototype.hasShredder=function(e){return null!==this._getShredder(e)},n.prototype._getShredder=function(e){var r=this._getJsonProcessor(e.url);return r?r.shredder:null},n.prototype._getUnshredder=function(e){var r=this._getJsonProcessor(e.url);return r?r.unshredder:null},n.prototype._getJsonProcessor=function(e){for(var r=Object.keys(this._endpointToOptionsMap),t=0;t<r.length;t++){var n=r[t];if(e===JSON.parse(n).url){var o=this._endpointToOptionsMap[n];return o&&o.jsonProcessor&&o.jsonProcessor.shredder&&o.jsonProcessor.unshredder?o.jsonProcessor:null}}return null},n.prototype._getQueryHandler=function(e){for(var r=Object.keys(this._endpointToOptionsMap),t=0;t<r.length;t++){var n=r[t];if(e===JSON.parse(n).url){var o=this._endpointToOptionsMap[n];return o&&o.queryHandler?o.queryHandler:null}}return null},n.prototype.fillResponseBodyWithShreddedData=function(e,n,o){t.log("Offline Persistence Toolkit DefaultCacheHandler: fillResponseBodyWithShreddedData()"),null!=e.url&&e.url.length>0&&null==o.headers.get("x-oracle-jscpt-response-url")&&o.headers.set("x-oracle-jscpt-response-url",e.url),n&&1===n.length&&"single"===n[0].resourceType&&o.headers.set("x-oracle-jscpt-resource-type","single");var i=this._getUnshredder(e),a=this._getShredder(e);if(!(i&&a&&o&&n&&n.length))return Promise.resolve(o);var s=n.map((function(e){return n=(t=e).name,r.openStore(n).then((function(e){if(t.keys&&t.keys.length){if(1===t.keys.length)return e.findByKey(t.keys[0]);var r={selector:{$or:t.keys.map((function(e){return{key:{$eq:e}}}))}};return e.find(r)}return[]})).then((function(e){return Array.isArray(e)||(e=[e]),t.data=e,t}));var t,n}));return Promise.all(s).then((function(e){return i(e,o)}))},n.prototype.deleteShreddedData=function(e){var t=[];return e.forEach((function(e){var n=e.name,o=e.keys;if(n&&o&&o.length){var i=r.openStore(n).then((function(e){var r={selector:{$or:o.map((function(e){return{key:{$eq:e}}}))}};return e.delete(r)}));t.push(i)}})),Promise.all(t)};var i=function(e){if(!e||"string"!=typeof e)return"";var r=/([^?]*)\?/.exec(e);return r&&2===r.length?r[1]:e},a=function(e){if(!e||"string"!=typeof e)return"";var r=e.split("").reverse().join(""),t=/(.*?)(TEG|TUP|ETELED|TSOP|HCTAP|TCENNOC|SNOITPO|ECART)/.exec(r);return t&&3===t.length?t[1].split("").reverse().join(""):e};return new n}));