/**
 * Copyright (c) 2017, Oracle and/or its affiliates.
 * All rights reserved.
 */

define(["./defaultCacheHandler","../persistenceStoreManager","../persistenceUtils","./logger"],(function(e,r,t,n){"use strict";function o(e,r){if(!e)throw TypeError("A name must be provided to create an OfflineCache!");if(!r)throw TypeError("A persistence store must be provided to create an OfflineCache!");this._name=e,this._storeName=r,this._shreddedNamesStoreName=this._storeName+"_OPT_INT_SHRED_STORE_NAMES_",this._store=null,this._cacheKeys=[],this._createStorePromise}function a(e,r,t){if(t&&t.length)for(var n=0;n<t.length;n++){var o=t[n];if(u(e,r,o.value))return o}return null}function i(e,r,t){return function(n){var o;return o=t?n[t]:n,u(e,r,o)}}function u(e,r,t){if(e)return!0;if(!t||!r)return!1;var o=t.requestData.headers,a=t.responseData.headers,i=r.headers,u=a.vary;if(n.log("Offline Persistence Toolkit OfflineCache: Processing HTTP Vary header"),!u)return!0;if("*"===u.trim())return!1;for(var s=u.split(","),c=0;c<s.length;c++){var l=s[c].toLowerCase();l=l.trim();var f=i.get(l),h=o[l];if(n.log("Offline Persistence Toolkit OfflineCache: HTTP Vary header name: "+l),n.log("Offline Persistence Toolkit OfflineCache: Request HTTP Vary header value: "+f),n.log("Offline Persistence Toolkit OfflineCache: Cached HTTP Vary header value: "+h),!(!h&&!f||h&&f&&h===f))return!1}return!0}function s(r,t,o){if(t){n.log("Offline Persistence Toolkit OfflineCache: Converting cached entry to Response object");var a=!1;o&&o.ignoreBody&&(a=!0);var i=t.bodyAbstract;return e.constructResponse(t).then((function(t){if(null!=r.url&&r.url.length>0&&null==t.headers.get("x-oracle-jscpt-response-url")&&t.headers.set("x-oracle-jscpt-response-url",r.url),!a&&i){var o;try{o=JSON.parse(i)}catch(e){n.error("error parsing json "+i)}return e.fillResponseBodyWithShreddedData(r,o,t)}return t}))}return Promise.resolve()}function c(r,t,n){if(t){var o=e.constructSearchCriteria(t,n);o.fields=["key","value"];var a=n&&n.ignoreVary;return r.find(o).then((function(e){return e&&e.length?e.filter(i(a,t,"value")).map((function(e){return e.key})):[]}))}return r.keys()}return o.prototype.getName=function(){return this._name},o.prototype.add=function(e){n.log("Offline Persistence Toolkit OfflineCache: add()");var r=this;return fetch(e).then((function(t){return r.put(e,t)}))},o.prototype.addAll=function(e){n.log("Offline Persistence Toolkit OfflineCache: addAll()");var r=e.map(this.add,this);return Promise.all(r)},o.prototype.match=function(e,r){return n.log("Offline Persistence Toolkit OfflineCache: match() for Request with url: "+e.url),this._getCacheEntries(e,r).then((function(t){var n=a(r&&r.ignoreVary,e,t);if(n)return s(e,n.value.responseData,r)})).catch((function(r){n.log("error finding match for request with url: "+e.url)}))},o.prototype._getCacheEntries=function(r,t){var n=this;return this._getStore().then((function(o){var a=e.getMatchedCacheKeys(r,t,n._cacheKeys);if(a&&a.length){var i=a.map((function(e){return o.findByKey(e).then((function(r){return{key:e,value:r}}))}));return Promise.all(i)}var u=e.constructSearchCriteria(r,t);return u.fields=["key","value"],o.find(u)}))},o.prototype._matchByKey=function(e,r,t){return this._getStore().then((function(e){return e.findByKey(r)})).then((function(r){return r?s(e,r.responseData,t):void 0}))},o.prototype._internalMatch=function(r,t){var o=this;return o._getStore().then((function(n){var a=e.getMatchedCacheKeys(r,t,o._cacheKeys);if(a&&a.length){var i=a.map((function(e){return n.findByKey(e)}));return Promise.all(i).then((function(e){return e.map((function(e,r){return{key:a[r],value:e}}))}))}var u=e.constructSearchCriteria(r,t);return u.fields=["key","value"],n.find(u)})).then((function(e){if(e){var o=a(t&&t.ignoreVary,r,e);if(o){var i={key:o.key},u=o.value.responseData.bodyAbstract;if(u)try{var s=JSON.parse(u);s?1===s.length&&"single"===s[0].resourceType?i.resourceType="single":i.resourceType="collection":i.resourceType="unknown"}catch(e){return void n.log("internal error: invalid body abstract")}else i.resourceType="unknown";return i}}})).catch((function(e){n.log("error finding match internal")}))},o.prototype.matchAll=function(e,r){return n.log("Offline Persistence Toolkit OfflineCache: matchAll() for Request with url: "+e.url),this._getCacheEntries(e,r).then((function(t){var n=function(e,r,t){var n=[];return t&&t.length&&(n=t.filter(i(e,r,"value")).map((function(e){return e.value.responseData}))),n}(r&&r.ignoreVary,e,t);return function(e,r,t){if(r&&r.length){var n=r.map((function(r){return s(e,r,t)}));return Promise.all(n)}return Promise.resolve()}(e,n,r)})).catch((function(r){n.log("error finding all matches for request with url: "+e.url)}))},o.prototype._getStore=function(){var e,t=this;return t._store?Promise.resolve(t._store):(t._createStorePromise||(t._createStorePromise=r.openStore(t._storeName,{index:["metadata.baseUrl","metadata.url","metadata.created"],skipMetadata:!0}).then((function(r){return e=r,r.keys()})).then((function(r){return t._cacheKeys=r,t._store=e,t._store}))),t._createStorePromise)},o.prototype._getShreddedNamesStore=function(){var e=this;return e._shreddedNamesStore?Promise.resolve(e._shreddedNamesStore):(e._createShreddedNamesStorePromise||(e._createShreddedNamesStorePromise=r.openStore(e._shreddedNamesStoreName,{index:["metadata.baseUrl","metadata.url","metadata.created"],skipMetadata:!0}).then((function(r){return e._shreddedNamesStore=r,e._shreddedNamesStore}))),e._createShreddedNamesStorePromise)},o.prototype.put=function(r,t){n.log("Offline Persistence Toolkit OfflineCache: put() for Request with url: "+r.url);var o,a=this;return a._getStore().then((function(){return e.constructRequestResponseCacheData(r,t)})).then((function(i){var u=a._store;return o=i.key,e.hasShredder(r)?e.shredResponse(r,t).then((function(r){if(r){var t=[];return i.value.responseData.bodyAbstract=function(e){var r=e.map((function(e){return{name:e.name,keys:e.keys?e.keys.reduce((function(e,r){return r?e.push(r):n.warn("should not have undefined key in the shredded data"),e}),[]):e.keys,resourceType:e.resourceType}}));return JSON.stringify(r)}(r),t.push(u.upsert(i.key,i.metadata,i.value)),t.push(e.cacheShreddedData(r,i.metadata)),a._updateShreddedStoreNames(r.map((function(e){return e.name}))).then((function(){return Promise.all(t)}))}o=null})):u.upsert(i.key,i.metadata,i.value)})).then((function(){o&&a._cacheKeys.indexOf(o)<0&&a._cacheKeys.push(o)})).catch((function(e){n.error("error in cache.put() for Request with url: "+r.url)}))},o.prototype._updateShreddedStoreNames=function(e){return this._getShreddedNamesStore().then((function(r){return e?r.keys().then((function(t){var n=[];if(e.forEach((function(e){t.indexOf(e)<0&&n.push(e)})),n.length>0){var o=[];return n.forEach((function(e){o.push({key:e,metadata:{},value:{}})})),r.upsertAll(o)}})):r.delete()}))},o.prototype._getShreddedStoreNames=function(){return this._getShreddedNamesStore().then((function(e){return e.keys()}))},o.prototype.delete=function(r,t){if(!r)return n.warn("Offline Persistence Toolkit OfflineCache: delete() request is a required parameter. To clear the cache, please call clear()"),Promise.resolve(!1);n.log("Offline Persistence Toolkit OfflineCache: delete() for Request with url: "+r.url);var o=this;return o._getStore().then((function(a){if(e.hasShredder(r)){var u=e.constructSearchCriteria(r,t);u.fields=["key","value"];var s=t&&t.ignoreVary;return a.find(u).then((function(t){if(t&&t.length){var u=t.filter(i(s,r,"value")),c=[];return u.forEach((function(r){c.push(a.removeByKey(r.key));var t=o._cacheKeys.indexOf(r.key);t>=0&&o._cacheKeys.splice(t,1),r.value.responseData.bodyAbstract&&r.value.responseData.bodyAbstract.length&&c.push(e.deleteShreddedData(JSON.parse(r.value.responseData.bodyAbstract)))})),Promise.all(c).then((function(){return n.log("Offline Persistence Toolkit OfflineCache: all matching entries are deleted from both the cache store and the shredded store."),!0}))}return!1}))}return c(a,r,t).then((function(e){if(e&&e.length){var r=e.map((function(e){var r=o._cacheKeys.indexOf(e);return r>=0&&o._cacheKeys.splice(r,1),a.removeByKey(e)}));return Promise.all(r)}return[]})).then((function(e){return!(!e||!e.length)}))})).catch((function(e){return n.log("Offline Persistence Toolkit OfflineCache: error occurred delete() for Request with url: "+r.url),!1}))},o.prototype.keys=function(e,r){e?n.log("Offline Persistence Toolkit OfflineCache: keys() for Request with url: "+e.url):n.log("Offline Persistence Toolkit OfflineCache: keys()");var o=this;return o._getStore().then((function(){return c(o._store,e,r)})).then((function(e){var r=[];return e.forEach((function(e){r.push(o._store.findByKey(e).then((function(e){return t.requestFromJSON(e.requestData)})))})),Promise.all(r)})).catch((function(r){return n.log("Offline Persistence Toolkit OfflineCache: keys() error for Request with url: "+e.url),[]}))},o.prototype.hasMatch=function(e,r){return n.log("Offline Persistence Toolkit OfflineCache: hasMatch() for Request with url: "+e.url),this._getCacheEntries(e,r).then((function(t){return null!==a(r&&r.ignoreVary,e,t)}))},o.prototype.clear=function(){n.log("Offline Persistence Toolkit OfflineCache: clear()");var e=this;return e._getStore().then((function(t){var n=[];return n.push(t.delete()),e._getShreddedStoreNames().then((function(t){return t.forEach((function(e){n.push(r.deleteStore(e))})),Promise.all(n).then((function(r){return e._updateShreddedStoreNames(null)})).then((function(){return e._cacheKeys=[],!0}))}))})).catch((function(e){n.log("Offline Persistence Toolkit OfflineCache: clear() error")}))},o}));