/**
 * This file contains valid types and string literal arrays for aria roles
 * https://www.w3.org/WAI/PF/aria/roles#role_definitions_header
 */
export type Role = (typeof roles)[number];
export type CompositeWidgetRole = (typeof compositeWidget)[number];
export type ContentRole = (typeof content)[number];
export type LandmarkRole = (typeof landmark)[number];
export type LiveRegionRole = (typeof liveRegion)[number];
export type WidgetRole = (typeof widget)[number];
declare const widget: readonly ["alertdialog", "button", "checkbox", "dialog", "gridcell", "link", "menuitem", "menuitemcheckbox", "menuitemradio", "option", "progressbar", "radio", "scrollbar", "slider", "spinbutton", "switch", "tab", "tabpanel", "textbox", "tooltip", "treeitem"];
declare const button: readonly ["checkbox", "link", "menuitem", "menuitemcheckbox", "menuitemradio", "radio", "switch", "tab"];
declare const compositeWidget: readonly ["combobox", "grid", "listbox", "menu", "menubar", "radiogroup", "tablist", "tree", "treegrid"];
declare const content: readonly ["article", "columnheader", "definition", "directory", "document", "group", "heading", "img", "list", "listitem", "math", "note", "presentation", "region", "row", "rowheader", "separator", "toolbar"];
declare const liveRegion: readonly ["alert", "log", "marquee", "status", "timer"];
declare const landmark: readonly ["application", "banner", "complementary", "contentinfo", "form", "main", "navigation", "search"];
declare const roles: Readonly<{
    [x: number]: "grid" | "button" | "checkbox" | "listbox" | "radio" | "region" | "row" | "menu" | "listitem" | "menubar" | "menuitem" | "progressbar" | "separator" | "tab" | "tabpanel" | "toolbar" | "tooltip" | "treeitem" | "scrollbar" | "article" | "dialog" | "form" | "img" | "link" | "main" | "marquee" | "option" | "search" | "switch" | "math" | "list" | "heading" | "log" | "tree" | "alert" | "alertdialog" | "application" | "banner" | "columnheader" | "combobox" | "complementary" | "contentinfo" | "definition" | "directory" | "document" | "gridcell" | "group" | "menuitemcheckbox" | "menuitemradio" | "navigation" | "note" | "presentation" | "radiogroup" | "rowheader" | "slider" | "spinbutton" | "status" | "tablist" | "textbox" | "timer" | "treegrid";
    0: "alertdialog";
    1: "button";
    2: "checkbox";
    3: "dialog";
    4: "gridcell";
    5: "link";
    6: "menuitem";
    7: "menuitemcheckbox";
    8: "menuitemradio";
    9: "option";
    10: "progressbar";
    11: "radio";
    12: "scrollbar";
    13: "slider";
    14: "spinbutton";
    15: "switch";
    16: "tab";
    17: "tabpanel";
    18: "textbox";
    19: "tooltip";
    20: "treeitem";
    length: 21;
    toString(): string;
    toLocaleString(): string;
    concat(...items: ConcatArray<"button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox">[]): ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[];
    concat(...items: ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox" | ConcatArray<"button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox">)[]): ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[];
    join(separator?: string | undefined): string;
    slice(start?: number | undefined, end?: number | undefined): ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[];
    indexOf(searchElement: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", fromIndex?: number | undefined): number;
    lastIndexOf(searchElement: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", fromIndex?: number | undefined): number;
    every<S extends "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox">(predicate: (value: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", index: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => value is S, thisArg?: any): this is readonly S[];
    every(predicate: (value: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", index: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => unknown, thisArg?: any): boolean;
    some(predicate: (value: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", index: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => unknown, thisArg?: any): boolean;
    forEach(callbackfn: (value: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", index: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => void, thisArg?: any): void;
    map<U>(callbackfn: (value: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", index: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => U, thisArg?: any): U[];
    filter<S_1 extends "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox">(predicate: (value: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", index: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => value is S_1, thisArg?: any): S_1[];
    filter(predicate: (value: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", index: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => unknown, thisArg?: any): ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[];
    reduce(callbackfn: (previousValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", currentValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", currentIndex: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox"): "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox";
    reduce(callbackfn: (previousValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", currentValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", currentIndex: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", initialValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox"): "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox";
    reduce<U_1>(callbackfn: (previousValue: U_1, currentValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", currentIndex: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => U_1, initialValue: U_1): U_1;
    reduceRight(callbackfn: (previousValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", currentValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", currentIndex: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox"): "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox";
    reduceRight(callbackfn: (previousValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", currentValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", currentIndex: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", initialValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox"): "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox";
    reduceRight<U_2>(callbackfn: (previousValue: U_2, currentValue: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", currentIndex: number, array: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => U_2, initialValue: U_2): U_2;
    find<S_2 extends "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox">(predicate: (value: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", index: number, obj: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => value is S_2, thisArg?: any): S_2 | undefined;
    find(predicate: (value: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", index: number, obj: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => unknown, thisArg?: any): "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox" | undefined;
    findIndex(predicate: (value: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", index: number, obj: readonly ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => unknown, thisArg?: any): number;
    entries(): IterableIterator<[number, "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox"]>;
    keys(): IterableIterator<number>;
    values(): IterableIterator<"button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox">;
    includes(searchElement: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", fromIndex?: number | undefined): boolean;
    flatMap<U_3, This = undefined>(callback: (this: This, value: "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox", index: number, array: ("button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox")[]) => U_3 | readonly U_3[], thisArg?: This | undefined): U_3[];
    flat<A, D extends number = 1>(this: A, depth?: D | undefined): FlatArray<A, D>[];
    [Symbol.iterator](): IterableIterator<"button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox">;
    [Symbol.unscopables]: {
        readonly [x: number]: boolean | undefined;
        readonly length?: boolean | undefined;
        toString?: boolean | undefined;
        toLocaleString?: boolean | undefined;
        concat?: boolean | undefined;
        join?: boolean | undefined;
        slice?: boolean | undefined;
        indexOf?: boolean | undefined;
        lastIndexOf?: boolean | undefined;
        every?: boolean | undefined;
        some?: boolean | undefined;
        forEach?: boolean | undefined;
        map?: boolean | undefined;
        filter?: boolean | undefined;
        reduce?: boolean | undefined;
        reduceRight?: boolean | undefined;
        find?: boolean | undefined;
        findIndex?: boolean | undefined;
        entries?: boolean | undefined;
        keys?: boolean | undefined;
        values?: boolean | undefined;
        includes?: boolean | undefined;
        flatMap?: boolean | undefined;
        flat?: boolean | undefined;
        [Symbol.iterator]?: boolean | undefined;
        readonly [Symbol.unscopables]?: boolean | undefined;
        at?: boolean | undefined;
    };
    at(index: number): "button" | "checkbox" | "radio" | "menuitem" | "progressbar" | "tab" | "tabpanel" | "tooltip" | "treeitem" | "scrollbar" | "dialog" | "link" | "option" | "switch" | "alertdialog" | "gridcell" | "menuitemcheckbox" | "menuitemradio" | "slider" | "spinbutton" | "textbox" | undefined;
}>;
export { button, compositeWidget, content, landmark, liveRegion, widget };
