import { StandardProperties } from 'csstype';
export type UseAnimationCssProperties = StandardProperties & TransformProperties;
type TransformProperties = Partial<Record<'translateX' | 'translateY' | 'translateZ' | 'rotateX' | 'rotateY' | 'rotateZ' | 'skewX' | 'skewY', string> & Record<'scaleX' | 'scaleY' | 'scaleZ', string | number>>;
/**
 * Converts animation CSS properties into Regular camel cased CSS properties.
 *
 * @param useAnimationCssProperties This include transform shorthand props.
 * @returns Regular camel cased CSS properties.
 */
export declare function convertUseAnimationCssPropertiesToRegularCSS(useAnimationCssProperties?: UseAnimationCssProperties): {
    transform?: string | undefined;
    accentColor?: import("csstype").Property.AccentColor | undefined;
    alignContent?: import("csstype").Property.AlignContent | undefined;
    alignItems?: import("csstype").Property.AlignItems | undefined;
    alignSelf?: import("csstype").Property.AlignSelf | undefined;
    alignTracks?: import("csstype").Property.AlignTracks | undefined;
    animationComposition?: import("csstype").Property.AnimationComposition | undefined;
    animationDelay?: import("csstype").Property.AnimationDelay<string & {}> | undefined;
    animationDirection?: import("csstype").Property.AnimationDirection | undefined;
    animationDuration?: import("csstype").Property.AnimationDuration<string & {}> | undefined;
    animationFillMode?: import("csstype").Property.AnimationFillMode | undefined;
    animationIterationCount?: import("csstype").Property.AnimationIterationCount | undefined;
    animationName?: import("csstype").Property.AnimationName | undefined;
    animationPlayState?: import("csstype").Property.AnimationPlayState | undefined;
    animationTimeline?: import("csstype").Property.AnimationTimeline | undefined;
    animationTimingFunction?: import("csstype").Property.AnimationTimingFunction | undefined;
    appearance?: import("csstype").Property.Appearance | undefined;
    aspectRatio?: import("csstype").Property.AspectRatio | undefined;
    backdropFilter?: import("csstype").Property.BackdropFilter | undefined;
    backfaceVisibility?: import("csstype").Property.BackfaceVisibility | undefined;
    backgroundAttachment?: import("csstype").Property.BackgroundAttachment | undefined;
    backgroundBlendMode?: import("csstype").Property.BackgroundBlendMode | undefined;
    backgroundClip?: import("csstype").Property.BackgroundClip | undefined;
    backgroundColor?: import("csstype").Property.BackgroundColor | undefined;
    backgroundImage?: import("csstype").Property.BackgroundImage | undefined;
    backgroundOrigin?: import("csstype").Property.BackgroundOrigin | undefined;
    backgroundPositionX?: import("csstype").Property.BackgroundPositionX<0 | (string & {})> | undefined;
    backgroundPositionY?: import("csstype").Property.BackgroundPositionY<0 | (string & {})> | undefined;
    backgroundRepeat?: import("csstype").Property.BackgroundRepeat | undefined;
    backgroundSize?: import("csstype").Property.BackgroundSize<0 | (string & {})> | undefined;
    blockOverflow?: import("csstype").Property.BlockOverflow | undefined;
    blockSize?: import("csstype").Property.BlockSize<0 | (string & {})> | undefined;
    borderBlockColor?: import("csstype").Property.BorderBlockColor | undefined;
    borderBlockEndColor?: import("csstype").Property.BorderBlockEndColor | undefined;
    borderBlockEndStyle?: import("csstype").Property.BorderBlockEndStyle | undefined;
    borderBlockEndWidth?: import("csstype").Property.BorderBlockEndWidth<0 | (string & {})> | undefined;
    borderBlockStartColor?: import("csstype").Property.BorderBlockStartColor | undefined;
    borderBlockStartStyle?: import("csstype").Property.BorderBlockStartStyle | undefined;
    borderBlockStartWidth?: import("csstype").Property.BorderBlockStartWidth<0 | (string & {})> | undefined;
    borderBlockStyle?: import("csstype").Property.BorderBlockStyle | undefined;
    borderBlockWidth?: import("csstype").Property.BorderBlockWidth<0 | (string & {})> | undefined;
    borderBottomColor?: import("csstype").Property.BorderBottomColor | undefined;
    borderBottomLeftRadius?: import("csstype").Property.BorderBottomLeftRadius<0 | (string & {})> | undefined;
    borderBottomRightRadius?: import("csstype").Property.BorderBottomRightRadius<0 | (string & {})> | undefined;
    borderBottomStyle?: import("csstype").Property.BorderBottomStyle | undefined;
    borderBottomWidth?: import("csstype").Property.BorderBottomWidth<0 | (string & {})> | undefined;
    borderCollapse?: import("csstype").Property.BorderCollapse | undefined;
    borderEndEndRadius?: import("csstype").Property.BorderEndEndRadius<0 | (string & {})> | undefined;
    borderEndStartRadius?: import("csstype").Property.BorderEndStartRadius<0 | (string & {})> | undefined;
    borderImageOutset?: import("csstype").Property.BorderImageOutset<0 | (string & {})> | undefined;
    borderImageRepeat?: import("csstype").Property.BorderImageRepeat | undefined;
    borderImageSlice?: import("csstype").Property.BorderImageSlice | undefined;
    borderImageSource?: import("csstype").Property.BorderImageSource | undefined;
    borderImageWidth?: import("csstype").Property.BorderImageWidth<0 | (string & {})> | undefined;
    borderInlineColor?: import("csstype").Property.BorderInlineColor | undefined;
    borderInlineEndColor?: import("csstype").Property.BorderInlineEndColor | undefined;
    borderInlineEndStyle?: import("csstype").Property.BorderInlineEndStyle | undefined;
    borderInlineEndWidth?: import("csstype").Property.BorderInlineEndWidth<0 | (string & {})> | undefined;
    borderInlineStartColor?: import("csstype").Property.BorderInlineStartColor | undefined;
    borderInlineStartStyle?: import("csstype").Property.BorderInlineStartStyle | undefined;
    borderInlineStartWidth?: import("csstype").Property.BorderInlineStartWidth<0 | (string & {})> | undefined;
    borderInlineStyle?: import("csstype").Property.BorderInlineStyle | undefined;
    borderInlineWidth?: import("csstype").Property.BorderInlineWidth<0 | (string & {})> | undefined;
    borderLeftColor?: import("csstype").Property.BorderLeftColor | undefined;
    borderLeftStyle?: import("csstype").Property.BorderLeftStyle | undefined;
    borderLeftWidth?: import("csstype").Property.BorderLeftWidth<0 | (string & {})> | undefined;
    borderRightColor?: import("csstype").Property.BorderRightColor | undefined;
    borderRightStyle?: import("csstype").Property.BorderRightStyle | undefined;
    borderRightWidth?: import("csstype").Property.BorderRightWidth<0 | (string & {})> | undefined;
    borderSpacing?: import("csstype").Property.BorderSpacing<0 | (string & {})> | undefined;
    borderStartEndRadius?: import("csstype").Property.BorderStartEndRadius<0 | (string & {})> | undefined;
    borderStartStartRadius?: import("csstype").Property.BorderStartStartRadius<0 | (string & {})> | undefined;
    borderTopColor?: import("csstype").Property.BorderTopColor | undefined;
    borderTopLeftRadius?: import("csstype").Property.BorderTopLeftRadius<0 | (string & {})> | undefined;
    borderTopRightRadius?: import("csstype").Property.BorderTopRightRadius<0 | (string & {})> | undefined;
    borderTopStyle?: import("csstype").Property.BorderTopStyle | undefined;
    borderTopWidth?: import("csstype").Property.BorderTopWidth<0 | (string & {})> | undefined;
    bottom?: import("csstype").Property.Bottom<0 | (string & {})> | undefined;
    boxDecorationBreak?: import("csstype").Property.BoxDecorationBreak | undefined;
    boxShadow?: import("csstype").Property.BoxShadow | undefined;
    boxSizing?: import("csstype").Property.BoxSizing | undefined;
    breakAfter?: import("csstype").Property.BreakAfter | undefined;
    breakBefore?: import("csstype").Property.BreakBefore | undefined;
    breakInside?: import("csstype").Property.BreakInside | undefined;
    captionSide?: import("csstype").Property.CaptionSide | undefined;
    caretColor?: import("csstype").Property.CaretColor | undefined;
    clear?: import("csstype").Property.Clear | undefined;
    clipPath?: import("csstype").Property.ClipPath | undefined;
    color?: import("csstype").Property.Color | undefined;
    colorAdjust?: import("csstype").Property.PrintColorAdjust | undefined;
    colorScheme?: import("csstype").Property.ColorScheme | undefined;
    columnCount?: import("csstype").Property.ColumnCount | undefined;
    columnFill?: import("csstype").Property.ColumnFill | undefined;
    columnGap?: import("csstype").Property.ColumnGap<0 | (string & {})> | undefined;
    columnRuleColor?: import("csstype").Property.ColumnRuleColor | undefined;
    columnRuleStyle?: import("csstype").Property.ColumnRuleStyle | undefined;
    columnRuleWidth?: import("csstype").Property.ColumnRuleWidth<0 | (string & {})> | undefined;
    columnSpan?: import("csstype").Property.ColumnSpan | undefined;
    columnWidth?: import("csstype").Property.ColumnWidth<0 | (string & {})> | undefined;
    contain?: import("csstype").Property.Contain | undefined;
    content?: import("csstype").Property.Content | undefined;
    contentVisibility?: import("csstype").Property.ContentVisibility | undefined;
    counterIncrement?: import("csstype").Property.CounterIncrement | undefined;
    counterReset?: import("csstype").Property.CounterReset | undefined;
    counterSet?: import("csstype").Property.CounterSet | undefined;
    cursor?: import("csstype").Property.Cursor | undefined;
    direction?: import("csstype").Property.Direction | undefined;
    display?: import("csstype").Property.Display | undefined;
    emptyCells?: import("csstype").Property.EmptyCells | undefined;
    filter?: import("csstype").Property.Filter | undefined;
    flexBasis?: import("csstype").Property.FlexBasis<0 | (string & {})> | undefined;
    flexDirection?: import("csstype").Property.FlexDirection | undefined;
    flexGrow?: import("csstype").Property.FlexGrow | undefined;
    flexShrink?: import("csstype").Property.FlexShrink | undefined;
    flexWrap?: import("csstype").Property.FlexWrap | undefined;
    float?: import("csstype").Property.Float | undefined;
    fontFamily?: import("csstype").Property.FontFamily | undefined;
    fontFeatureSettings?: import("csstype").Property.FontFeatureSettings | undefined;
    fontKerning?: import("csstype").Property.FontKerning | undefined;
    fontLanguageOverride?: import("csstype").Property.FontLanguageOverride | undefined;
    fontOpticalSizing?: import("csstype").Property.FontOpticalSizing | undefined;
    fontSize?: import("csstype").Property.FontSize<0 | (string & {})> | undefined;
    fontSizeAdjust?: import("csstype").Property.FontSizeAdjust | undefined;
    fontSmooth?: import("csstype").Property.FontSmooth<0 | (string & {})> | undefined;
    fontStretch?: import("csstype").Property.FontStretch | undefined;
    fontStyle?: import("csstype").Property.FontStyle | undefined;
    fontSynthesis?: import("csstype").Property.FontSynthesis | undefined;
    fontVariant?: import("csstype").Property.FontVariant | undefined;
    fontVariantAlternates?: import("csstype").Property.FontVariantAlternates | undefined;
    fontVariantCaps?: import("csstype").Property.FontVariantCaps | undefined;
    fontVariantEastAsian?: import("csstype").Property.FontVariantEastAsian | undefined;
    fontVariantLigatures?: import("csstype").Property.FontVariantLigatures | undefined;
    fontVariantNumeric?: import("csstype").Property.FontVariantNumeric | undefined;
    fontVariantPosition?: import("csstype").Property.FontVariantPosition | undefined;
    fontVariationSettings?: import("csstype").Property.FontVariationSettings | undefined;
    fontWeight?: import("csstype").Property.FontWeight | undefined;
    forcedColorAdjust?: import("csstype").Property.ForcedColorAdjust | undefined;
    gridAutoColumns?: import("csstype").Property.GridAutoColumns<0 | (string & {})> | undefined;
    gridAutoFlow?: import("csstype").Property.GridAutoFlow | undefined;
    gridAutoRows?: import("csstype").Property.GridAutoRows<0 | (string & {})> | undefined;
    gridColumnEnd?: import("csstype").Property.GridColumnEnd | undefined;
    gridColumnStart?: import("csstype").Property.GridColumnStart | undefined;
    gridRowEnd?: import("csstype").Property.GridRowEnd | undefined;
    gridRowStart?: import("csstype").Property.GridRowStart | undefined;
    gridTemplateAreas?: import("csstype").Property.GridTemplateAreas | undefined;
    gridTemplateColumns?: import("csstype").Property.GridTemplateColumns<0 | (string & {})> | undefined;
    gridTemplateRows?: import("csstype").Property.GridTemplateRows<0 | (string & {})> | undefined;
    hangingPunctuation?: import("csstype").Property.HangingPunctuation | undefined;
    height?: import("csstype").Property.Height<0 | (string & {})> | undefined;
    hyphenateCharacter?: import("csstype").Property.HyphenateCharacter | undefined;
    hyphens?: import("csstype").Property.Hyphens | undefined;
    imageOrientation?: import("csstype").Property.ImageOrientation | undefined;
    imageRendering?: import("csstype").Property.ImageRendering | undefined;
    imageResolution?: import("csstype").Property.ImageResolution | undefined;
    initialLetter?: import("csstype").Property.InitialLetter | undefined;
    inlineSize?: import("csstype").Property.InlineSize<0 | (string & {})> | undefined;
    inputSecurity?: import("csstype").Property.InputSecurity | undefined;
    inset?: import("csstype").Property.Inset<0 | (string & {})> | undefined;
    insetBlock?: import("csstype").Property.InsetBlock<0 | (string & {})> | undefined;
    insetBlockEnd?: import("csstype").Property.InsetBlockEnd<0 | (string & {})> | undefined;
    insetBlockStart?: import("csstype").Property.InsetBlockStart<0 | (string & {})> | undefined;
    insetInline?: import("csstype").Property.InsetInline<0 | (string & {})> | undefined;
    insetInlineEnd?: import("csstype").Property.InsetInlineEnd<0 | (string & {})> | undefined;
    insetInlineStart?: import("csstype").Property.InsetInlineStart<0 | (string & {})> | undefined;
    isolation?: import("csstype").Property.Isolation | undefined;
    justifyContent?: import("csstype").Property.JustifyContent | undefined;
    justifyItems?: import("csstype").Property.JustifyItems | undefined;
    justifySelf?: import("csstype").Property.JustifySelf | undefined;
    justifyTracks?: import("csstype").Property.JustifyTracks | undefined;
    left?: import("csstype").Property.Left<0 | (string & {})> | undefined;
    letterSpacing?: import("csstype").Property.LetterSpacing<0 | (string & {})> | undefined;
    lineBreak?: import("csstype").Property.LineBreak | undefined;
    lineHeight?: import("csstype").Property.LineHeight<0 | (string & {})> | undefined;
    lineHeightStep?: import("csstype").Property.LineHeightStep<0 | (string & {})> | undefined;
    listStyleImage?: import("csstype").Property.ListStyleImage | undefined;
    listStylePosition?: import("csstype").Property.ListStylePosition | undefined;
    listStyleType?: import("csstype").Property.ListStyleType | undefined;
    marginBlock?: import("csstype").Property.MarginBlock<0 | (string & {})> | undefined;
    marginBlockEnd?: import("csstype").Property.MarginBlockEnd<0 | (string & {})> | undefined;
    marginBlockStart?: import("csstype").Property.MarginBlockStart<0 | (string & {})> | undefined;
    marginBottom?: import("csstype").Property.MarginBottom<0 | (string & {})> | undefined;
    marginInline?: import("csstype").Property.MarginInline<0 | (string & {})> | undefined;
    marginInlineEnd?: import("csstype").Property.MarginInlineEnd<0 | (string & {})> | undefined;
    marginInlineStart?: import("csstype").Property.MarginInlineStart<0 | (string & {})> | undefined;
    marginLeft?: import("csstype").Property.MarginLeft<0 | (string & {})> | undefined;
    marginRight?: import("csstype").Property.MarginRight<0 | (string & {})> | undefined;
    marginTop?: import("csstype").Property.MarginTop<0 | (string & {})> | undefined;
    maskBorderMode?: import("csstype").Property.MaskBorderMode | undefined;
    maskBorderOutset?: import("csstype").Property.MaskBorderOutset<0 | (string & {})> | undefined;
    maskBorderRepeat?: import("csstype").Property.MaskBorderRepeat | undefined;
    maskBorderSlice?: import("csstype").Property.MaskBorderSlice | undefined;
    maskBorderSource?: import("csstype").Property.MaskBorderSource | undefined;
    maskBorderWidth?: import("csstype").Property.MaskBorderWidth<0 | (string & {})> | undefined;
    maskClip?: import("csstype").Property.MaskClip | undefined;
    maskComposite?: import("csstype").Property.MaskComposite | undefined;
    maskImage?: import("csstype").Property.MaskImage | undefined;
    maskMode?: import("csstype").Property.MaskMode | undefined;
    maskOrigin?: import("csstype").Property.MaskOrigin | undefined;
    maskPosition?: import("csstype").Property.MaskPosition<0 | (string & {})> | undefined;
    maskRepeat?: import("csstype").Property.MaskRepeat | undefined;
    maskSize?: import("csstype").Property.MaskSize<0 | (string & {})> | undefined;
    maskType?: import("csstype").Property.MaskType | undefined;
    mathDepth?: import("csstype").Property.MathDepth | undefined;
    mathShift?: import("csstype").Property.MathShift | undefined;
    mathStyle?: import("csstype").Property.MathStyle | undefined;
    maxBlockSize?: import("csstype").Property.MaxBlockSize<0 | (string & {})> | undefined;
    maxHeight?: import("csstype").Property.MaxHeight<0 | (string & {})> | undefined;
    maxInlineSize?: import("csstype").Property.MaxInlineSize<0 | (string & {})> | undefined;
    maxLines?: import("csstype").Property.MaxLines | undefined;
    maxWidth?: import("csstype").Property.MaxWidth<0 | (string & {})> | undefined;
    minBlockSize?: import("csstype").Property.MinBlockSize<0 | (string & {})> | undefined;
    minHeight?: import("csstype").Property.MinHeight<0 | (string & {})> | undefined;
    minInlineSize?: import("csstype").Property.MinInlineSize<0 | (string & {})> | undefined;
    minWidth?: import("csstype").Property.MinWidth<0 | (string & {})> | undefined;
    mixBlendMode?: import("csstype").Property.MixBlendMode | undefined;
    motionDistance?: import("csstype").Property.OffsetDistance<0 | (string & {})> | undefined;
    motionPath?: import("csstype").Property.OffsetPath | undefined;
    motionRotation?: import("csstype").Property.OffsetRotate | undefined;
    objectFit?: import("csstype").Property.ObjectFit | undefined;
    objectPosition?: import("csstype").Property.ObjectPosition<0 | (string & {})> | undefined;
    offsetAnchor?: import("csstype").Property.OffsetAnchor<0 | (string & {})> | undefined;
    offsetDistance?: import("csstype").Property.OffsetDistance<0 | (string & {})> | undefined;
    offsetPath?: import("csstype").Property.OffsetPath | undefined;
    offsetRotate?: import("csstype").Property.OffsetRotate | undefined;
    offsetRotation?: import("csstype").Property.OffsetRotate | undefined;
    opacity?: import("csstype").Property.Opacity | undefined;
    order?: import("csstype").Property.Order | undefined;
    orphans?: import("csstype").Property.Orphans | undefined;
    outlineColor?: import("csstype").Property.OutlineColor | undefined;
    outlineOffset?: import("csstype").Property.OutlineOffset<0 | (string & {})> | undefined;
    outlineStyle?: import("csstype").Property.OutlineStyle | undefined;
    outlineWidth?: import("csstype").Property.OutlineWidth<0 | (string & {})> | undefined;
    overflowAnchor?: import("csstype").Property.OverflowAnchor | undefined;
    overflowBlock?: import("csstype").Property.OverflowBlock | undefined;
    overflowClipBox?: import("csstype").Property.OverflowClipBox | undefined;
    overflowClipMargin?: import("csstype").Property.OverflowClipMargin<0 | (string & {})> | undefined;
    overflowInline?: import("csstype").Property.OverflowInline | undefined;
    overflowWrap?: import("csstype").Property.OverflowWrap | undefined;
    overflowX?: import("csstype").Property.OverflowX | undefined;
    overflowY?: import("csstype").Property.OverflowY | undefined;
    overscrollBehaviorBlock?: import("csstype").Property.OverscrollBehaviorBlock | undefined;
    overscrollBehaviorInline?: import("csstype").Property.OverscrollBehaviorInline | undefined;
    overscrollBehaviorX?: import("csstype").Property.OverscrollBehaviorX | undefined;
    overscrollBehaviorY?: import("csstype").Property.OverscrollBehaviorY | undefined;
    paddingBlock?: import("csstype").Property.PaddingBlock<0 | (string & {})> | undefined;
    paddingBlockEnd?: import("csstype").Property.PaddingBlockEnd<0 | (string & {})> | undefined;
    paddingBlockStart?: import("csstype").Property.PaddingBlockStart<0 | (string & {})> | undefined;
    paddingBottom?: import("csstype").Property.PaddingBottom<0 | (string & {})> | undefined;
    paddingInline?: import("csstype").Property.PaddingInline<0 | (string & {})> | undefined;
    paddingInlineEnd?: import("csstype").Property.PaddingInlineEnd<0 | (string & {})> | undefined;
    paddingInlineStart?: import("csstype").Property.PaddingInlineStart<0 | (string & {})> | undefined;
    paddingLeft?: import("csstype").Property.PaddingLeft<0 | (string & {})> | undefined;
    paddingRight?: import("csstype").Property.PaddingRight<0 | (string & {})> | undefined;
    paddingTop?: import("csstype").Property.PaddingTop<0 | (string & {})> | undefined;
    pageBreakAfter?: import("csstype").Property.PageBreakAfter | undefined;
    pageBreakBefore?: import("csstype").Property.PageBreakBefore | undefined;
    pageBreakInside?: import("csstype").Property.PageBreakInside | undefined;
    paintOrder?: import("csstype").Property.PaintOrder | undefined;
    perspective?: import("csstype").Property.Perspective<0 | (string & {})> | undefined;
    perspectiveOrigin?: import("csstype").Property.PerspectiveOrigin<0 | (string & {})> | undefined;
    placeContent?: import("csstype").Property.PlaceContent | undefined;
    pointerEvents?: import("csstype").Property.PointerEvents | undefined;
    position?: import("csstype").Property.Position | undefined;
    printColorAdjust?: import("csstype").Property.PrintColorAdjust | undefined;
    quotes?: import("csstype").Property.Quotes | undefined;
    resize?: import("csstype").Property.Resize | undefined;
    right?: import("csstype").Property.Right<0 | (string & {})> | undefined;
    rotate?: import("csstype").Property.Rotate | undefined;
    rowGap?: import("csstype").Property.RowGap<0 | (string & {})> | undefined;
    rubyAlign?: import("csstype").Property.RubyAlign | undefined;
    rubyMerge?: import("csstype").Property.RubyMerge | undefined;
    rubyPosition?: import("csstype").Property.RubyPosition | undefined;
    scale?: import("csstype").Property.Scale | undefined;
    scrollBehavior?: import("csstype").Property.ScrollBehavior | undefined;
    scrollMargin?: import("csstype").Property.ScrollMargin<0 | (string & {})> | undefined;
    scrollMarginBlock?: import("csstype").Property.ScrollMarginBlock<0 | (string & {})> | undefined;
    scrollMarginBlockEnd?: import("csstype").Property.ScrollMarginBlockEnd<0 | (string & {})> | undefined;
    scrollMarginBlockStart?: import("csstype").Property.ScrollMarginBlockStart<0 | (string & {})> | undefined;
    scrollMarginBottom?: import("csstype").Property.ScrollMarginBottom<0 | (string & {})> | undefined;
    scrollMarginInline?: import("csstype").Property.ScrollMarginInline<0 | (string & {})> | undefined;
    scrollMarginInlineEnd?: import("csstype").Property.ScrollMarginInlineEnd<0 | (string & {})> | undefined;
    scrollMarginInlineStart?: import("csstype").Property.ScrollMarginInlineStart<0 | (string & {})> | undefined;
    scrollMarginLeft?: import("csstype").Property.ScrollMarginLeft<0 | (string & {})> | undefined;
    scrollMarginRight?: import("csstype").Property.ScrollMarginRight<0 | (string & {})> | undefined;
    scrollMarginTop?: import("csstype").Property.ScrollMarginTop<0 | (string & {})> | undefined;
    scrollPadding?: import("csstype").Property.ScrollPadding<0 | (string & {})> | undefined;
    scrollPaddingBlock?: import("csstype").Property.ScrollPaddingBlock<0 | (string & {})> | undefined;
    scrollPaddingBlockEnd?: import("csstype").Property.ScrollPaddingBlockEnd<0 | (string & {})> | undefined;
    scrollPaddingBlockStart?: import("csstype").Property.ScrollPaddingBlockStart<0 | (string & {})> | undefined;
    scrollPaddingBottom?: import("csstype").Property.ScrollPaddingBottom<0 | (string & {})> | undefined;
    scrollPaddingInline?: import("csstype").Property.ScrollPaddingInline<0 | (string & {})> | undefined;
    scrollPaddingInlineEnd?: import("csstype").Property.ScrollPaddingInlineEnd<0 | (string & {})> | undefined;
    scrollPaddingInlineStart?: import("csstype").Property.ScrollPaddingInlineStart<0 | (string & {})> | undefined;
    scrollPaddingLeft?: import("csstype").Property.ScrollPaddingLeft<0 | (string & {})> | undefined;
    scrollPaddingRight?: import("csstype").Property.ScrollPaddingRight<0 | (string & {})> | undefined;
    scrollPaddingTop?: import("csstype").Property.ScrollPaddingTop<0 | (string & {})> | undefined;
    scrollSnapAlign?: import("csstype").Property.ScrollSnapAlign | undefined;
    scrollSnapMargin?: import("csstype").Property.ScrollMargin<0 | (string & {})> | undefined;
    scrollSnapMarginBottom?: import("csstype").Property.ScrollMarginBottom<0 | (string & {})> | undefined;
    scrollSnapMarginLeft?: import("csstype").Property.ScrollMarginLeft<0 | (string & {})> | undefined;
    scrollSnapMarginRight?: import("csstype").Property.ScrollMarginRight<0 | (string & {})> | undefined;
    scrollSnapMarginTop?: import("csstype").Property.ScrollMarginTop<0 | (string & {})> | undefined;
    scrollSnapStop?: import("csstype").Property.ScrollSnapStop | undefined;
    scrollSnapType?: import("csstype").Property.ScrollSnapType | undefined;
    scrollbarColor?: import("csstype").Property.ScrollbarColor | undefined;
    scrollbarGutter?: import("csstype").Property.ScrollbarGutter | undefined;
    scrollbarWidth?: import("csstype").Property.ScrollbarWidth | undefined;
    shapeImageThreshold?: import("csstype").Property.ShapeImageThreshold | undefined;
    shapeMargin?: import("csstype").Property.ShapeMargin<0 | (string & {})> | undefined;
    shapeOutside?: import("csstype").Property.ShapeOutside | undefined;
    tabSize?: import("csstype").Property.TabSize<0 | (string & {})> | undefined;
    tableLayout?: import("csstype").Property.TableLayout | undefined;
    textAlign?: import("csstype").Property.TextAlign | undefined;
    textAlignLast?: import("csstype").Property.TextAlignLast | undefined;
    textCombineUpright?: import("csstype").Property.TextCombineUpright | undefined;
    textDecorationColor?: import("csstype").Property.TextDecorationColor | undefined;
    textDecorationLine?: import("csstype").Property.TextDecorationLine | undefined;
    textDecorationSkip?: import("csstype").Property.TextDecorationSkip | undefined;
    textDecorationSkipInk?: import("csstype").Property.TextDecorationSkipInk | undefined;
    textDecorationStyle?: import("csstype").Property.TextDecorationStyle | undefined;
    textDecorationThickness?: import("csstype").Property.TextDecorationThickness<0 | (string & {})> | undefined;
    textEmphasisColor?: import("csstype").Property.TextEmphasisColor | undefined;
    textEmphasisPosition?: import("csstype").Property.TextEmphasisPosition | undefined;
    textEmphasisStyle?: import("csstype").Property.TextEmphasisStyle | undefined;
    textIndent?: import("csstype").Property.TextIndent<0 | (string & {})> | undefined;
    textJustify?: import("csstype").Property.TextJustify | undefined;
    textOrientation?: import("csstype").Property.TextOrientation | undefined;
    textOverflow?: import("csstype").Property.TextOverflow | undefined;
    textRendering?: import("csstype").Property.TextRendering | undefined;
    textShadow?: import("csstype").Property.TextShadow | undefined;
    textSizeAdjust?: import("csstype").Property.TextSizeAdjust | undefined;
    textTransform?: import("csstype").Property.TextTransform | undefined;
    textUnderlineOffset?: import("csstype").Property.TextUnderlineOffset<0 | (string & {})> | undefined;
    textUnderlinePosition?: import("csstype").Property.TextUnderlinePosition | undefined;
    top?: import("csstype").Property.Top<0 | (string & {})> | undefined;
    touchAction?: import("csstype").Property.TouchAction | undefined;
    transformBox?: import("csstype").Property.TransformBox | undefined;
    transformOrigin?: import("csstype").Property.TransformOrigin<0 | (string & {})> | undefined;
    transformStyle?: import("csstype").Property.TransformStyle | undefined;
    transitionDelay?: import("csstype").Property.TransitionDelay<string & {}> | undefined;
    transitionDuration?: import("csstype").Property.TransitionDuration<string & {}> | undefined;
    transitionProperty?: import("csstype").Property.TransitionProperty | undefined;
    transitionTimingFunction?: import("csstype").Property.TransitionTimingFunction | undefined;
    translate?: import("csstype").Property.Translate<0 | (string & {})> | undefined;
    unicodeBidi?: import("csstype").Property.UnicodeBidi | undefined;
    userSelect?: import("csstype").Property.UserSelect | undefined;
    verticalAlign?: import("csstype").Property.VerticalAlign<0 | (string & {})> | undefined;
    visibility?: import("csstype").Property.Visibility | undefined;
    whiteSpace?: import("csstype").Property.WhiteSpace | undefined;
    widows?: import("csstype").Property.Widows | undefined;
    width?: import("csstype").Property.Width<0 | (string & {})> | undefined;
    willChange?: import("csstype").Property.WillChange | undefined;
    wordBreak?: import("csstype").Property.WordBreak | undefined;
    wordSpacing?: import("csstype").Property.WordSpacing<0 | (string & {})> | undefined;
    wordWrap?: import("csstype").Property.WordWrap | undefined;
    writingMode?: import("csstype").Property.WritingMode | undefined;
    zIndex?: import("csstype").Property.ZIndex | undefined;
    zoom?: import("csstype").Property.Zoom | undefined;
    all?: import("csstype").Globals | undefined;
    animation?: import("csstype").Property.Animation<string & {}> | undefined;
    background?: import("csstype").Property.Background<0 | (string & {})> | undefined;
    backgroundPosition?: import("csstype").Property.BackgroundPosition<0 | (string & {})> | undefined;
    border?: import("csstype").Property.Border<0 | (string & {})> | undefined;
    borderBlock?: import("csstype").Property.BorderBlock<0 | (string & {})> | undefined;
    borderBlockEnd?: import("csstype").Property.BorderBlockEnd<0 | (string & {})> | undefined;
    borderBlockStart?: import("csstype").Property.BorderBlockStart<0 | (string & {})> | undefined;
    borderBottom?: import("csstype").Property.BorderBottom<0 | (string & {})> | undefined;
    borderColor?: import("csstype").Property.BorderColor | undefined;
    borderImage?: import("csstype").Property.BorderImage | undefined;
    borderInline?: import("csstype").Property.BorderInline<0 | (string & {})> | undefined;
    borderInlineEnd?: import("csstype").Property.BorderInlineEnd<0 | (string & {})> | undefined;
    borderInlineStart?: import("csstype").Property.BorderInlineStart<0 | (string & {})> | undefined;
    borderLeft?: import("csstype").Property.BorderLeft<0 | (string & {})> | undefined;
    borderRadius?: import("csstype").Property.BorderRadius<0 | (string & {})> | undefined;
    borderRight?: import("csstype").Property.BorderRight<0 | (string & {})> | undefined;
    borderStyle?: import("csstype").Property.BorderStyle | undefined;
    borderTop?: import("csstype").Property.BorderTop<0 | (string & {})> | undefined;
    borderWidth?: import("csstype").Property.BorderWidth<0 | (string & {})> | undefined;
    columnRule?: import("csstype").Property.ColumnRule<0 | (string & {})> | undefined;
    columns?: import("csstype").Property.Columns<0 | (string & {})> | undefined;
    flex?: import("csstype").Property.Flex<0 | (string & {})> | undefined;
    flexFlow?: import("csstype").Property.FlexFlow | undefined;
    font?: import("csstype").Property.Font | undefined;
    gap?: import("csstype").Property.Gap<0 | (string & {})> | undefined;
    grid?: import("csstype").Property.Grid | undefined;
    gridArea?: import("csstype").Property.GridArea | undefined;
    gridColumn?: import("csstype").Property.GridColumn | undefined;
    gridRow?: import("csstype").Property.GridRow | undefined;
    gridTemplate?: import("csstype").Property.GridTemplate | undefined;
    lineClamp?: import("csstype").Property.LineClamp | undefined;
    listStyle?: import("csstype").Property.ListStyle | undefined;
    margin?: import("csstype").Property.Margin<0 | (string & {})> | undefined;
    mask?: import("csstype").Property.Mask<0 | (string & {})> | undefined;
    maskBorder?: import("csstype").Property.MaskBorder | undefined;
    motion?: import("csstype").Property.Offset<0 | (string & {})> | undefined;
    offset?: import("csstype").Property.Offset<0 | (string & {})> | undefined;
    outline?: import("csstype").Property.Outline<0 | (string & {})> | undefined;
    overflow?: import("csstype").Property.Overflow | undefined;
    overscrollBehavior?: import("csstype").Property.OverscrollBehavior | undefined;
    padding?: import("csstype").Property.Padding<0 | (string & {})> | undefined;
    placeItems?: import("csstype").Property.PlaceItems | undefined;
    placeSelf?: import("csstype").Property.PlaceSelf | undefined;
    textDecoration?: import("csstype").Property.TextDecoration<0 | (string & {})> | undefined;
    textEmphasis?: import("csstype").Property.TextEmphasis | undefined;
    transition?: import("csstype").Property.Transition<string & {}> | undefined;
};
/**
 * Converts animation CSS properties into WAAPI keyframe properties.
 * Since keyframes have a difference between offset and cssOffset this collision is avoided here.
 *
 * @param useAnimationCssProperties This include transform shorthand props.
 * @returns WAAPI keyframe
 */
export declare function convertUseAnimationCssPropertiesToWAAPIKeyframe(useAnimationCssProperties?: UseAnimationCssProperties): {
    cssOffset?: (string & {}) | "-moz-initial" | "inherit" | "initial" | "revert" | "revert-layer" | "unset" | "none" | "bottom" | "left" | "right" | "top" | "auto" | "center" | "border-box" | "content-box" | "padding-box" | "fill-box" | "margin-box" | "stroke-box" | "view-box" | undefined;
    transform?: string | undefined;
    accentColor?: import("csstype").Property.AccentColor | undefined;
    alignContent?: import("csstype").Property.AlignContent | undefined;
    alignItems?: import("csstype").Property.AlignItems | undefined;
    alignSelf?: import("csstype").Property.AlignSelf | undefined;
    alignTracks?: import("csstype").Property.AlignTracks | undefined;
    animationComposition?: import("csstype").Property.AnimationComposition | undefined;
    animationDelay?: import("csstype").Property.AnimationDelay<string & {}> | undefined;
    animationDirection?: import("csstype").Property.AnimationDirection | undefined;
    animationDuration?: import("csstype").Property.AnimationDuration<string & {}> | undefined;
    animationFillMode?: import("csstype").Property.AnimationFillMode | undefined;
    animationIterationCount?: import("csstype").Property.AnimationIterationCount | undefined;
    animationName?: import("csstype").Property.AnimationName | undefined;
    animationPlayState?: import("csstype").Property.AnimationPlayState | undefined;
    animationTimeline?: import("csstype").Property.AnimationTimeline | undefined;
    animationTimingFunction?: import("csstype").Property.AnimationTimingFunction | undefined;
    appearance?: import("csstype").Property.Appearance | undefined;
    aspectRatio?: import("csstype").Property.AspectRatio | undefined;
    backdropFilter?: import("csstype").Property.BackdropFilter | undefined;
    backfaceVisibility?: import("csstype").Property.BackfaceVisibility | undefined;
    backgroundAttachment?: import("csstype").Property.BackgroundAttachment | undefined;
    backgroundBlendMode?: import("csstype").Property.BackgroundBlendMode | undefined;
    backgroundClip?: import("csstype").Property.BackgroundClip | undefined;
    backgroundColor?: import("csstype").Property.BackgroundColor | undefined;
    backgroundImage?: import("csstype").Property.BackgroundImage | undefined;
    backgroundOrigin?: import("csstype").Property.BackgroundOrigin | undefined;
    backgroundPositionX?: import("csstype").Property.BackgroundPositionX<0 | (string & {})> | undefined;
    backgroundPositionY?: import("csstype").Property.BackgroundPositionY<0 | (string & {})> | undefined;
    backgroundRepeat?: import("csstype").Property.BackgroundRepeat | undefined;
    backgroundSize?: import("csstype").Property.BackgroundSize<0 | (string & {})> | undefined;
    blockOverflow?: import("csstype").Property.BlockOverflow | undefined;
    blockSize?: import("csstype").Property.BlockSize<0 | (string & {})> | undefined;
    borderBlockColor?: import("csstype").Property.BorderBlockColor | undefined;
    borderBlockEndColor?: import("csstype").Property.BorderBlockEndColor | undefined;
    borderBlockEndStyle?: import("csstype").Property.BorderBlockEndStyle | undefined;
    borderBlockEndWidth?: import("csstype").Property.BorderBlockEndWidth<0 | (string & {})> | undefined;
    borderBlockStartColor?: import("csstype").Property.BorderBlockStartColor | undefined;
    borderBlockStartStyle?: import("csstype").Property.BorderBlockStartStyle | undefined;
    borderBlockStartWidth?: import("csstype").Property.BorderBlockStartWidth<0 | (string & {})> | undefined;
    borderBlockStyle?: import("csstype").Property.BorderBlockStyle | undefined;
    borderBlockWidth?: import("csstype").Property.BorderBlockWidth<0 | (string & {})> | undefined;
    borderBottomColor?: import("csstype").Property.BorderBottomColor | undefined;
    borderBottomLeftRadius?: import("csstype").Property.BorderBottomLeftRadius<0 | (string & {})> | undefined;
    borderBottomRightRadius?: import("csstype").Property.BorderBottomRightRadius<0 | (string & {})> | undefined;
    borderBottomStyle?: import("csstype").Property.BorderBottomStyle | undefined;
    borderBottomWidth?: import("csstype").Property.BorderBottomWidth<0 | (string & {})> | undefined;
    borderCollapse?: import("csstype").Property.BorderCollapse | undefined;
    borderEndEndRadius?: import("csstype").Property.BorderEndEndRadius<0 | (string & {})> | undefined;
    borderEndStartRadius?: import("csstype").Property.BorderEndStartRadius<0 | (string & {})> | undefined;
    borderImageOutset?: import("csstype").Property.BorderImageOutset<0 | (string & {})> | undefined;
    borderImageRepeat?: import("csstype").Property.BorderImageRepeat | undefined;
    borderImageSlice?: import("csstype").Property.BorderImageSlice | undefined;
    borderImageSource?: import("csstype").Property.BorderImageSource | undefined;
    borderImageWidth?: import("csstype").Property.BorderImageWidth<0 | (string & {})> | undefined;
    borderInlineColor?: import("csstype").Property.BorderInlineColor | undefined;
    borderInlineEndColor?: import("csstype").Property.BorderInlineEndColor | undefined;
    borderInlineEndStyle?: import("csstype").Property.BorderInlineEndStyle | undefined;
    borderInlineEndWidth?: import("csstype").Property.BorderInlineEndWidth<0 | (string & {})> | undefined;
    borderInlineStartColor?: import("csstype").Property.BorderInlineStartColor | undefined;
    borderInlineStartStyle?: import("csstype").Property.BorderInlineStartStyle | undefined;
    borderInlineStartWidth?: import("csstype").Property.BorderInlineStartWidth<0 | (string & {})> | undefined;
    borderInlineStyle?: import("csstype").Property.BorderInlineStyle | undefined;
    borderInlineWidth?: import("csstype").Property.BorderInlineWidth<0 | (string & {})> | undefined;
    borderLeftColor?: import("csstype").Property.BorderLeftColor | undefined;
    borderLeftStyle?: import("csstype").Property.BorderLeftStyle | undefined;
    borderLeftWidth?: import("csstype").Property.BorderLeftWidth<0 | (string & {})> | undefined;
    borderRightColor?: import("csstype").Property.BorderRightColor | undefined;
    borderRightStyle?: import("csstype").Property.BorderRightStyle | undefined;
    borderRightWidth?: import("csstype").Property.BorderRightWidth<0 | (string & {})> | undefined;
    borderSpacing?: import("csstype").Property.BorderSpacing<0 | (string & {})> | undefined;
    borderStartEndRadius?: import("csstype").Property.BorderStartEndRadius<0 | (string & {})> | undefined;
    borderStartStartRadius?: import("csstype").Property.BorderStartStartRadius<0 | (string & {})> | undefined;
    borderTopColor?: import("csstype").Property.BorderTopColor | undefined;
    borderTopLeftRadius?: import("csstype").Property.BorderTopLeftRadius<0 | (string & {})> | undefined;
    borderTopRightRadius?: import("csstype").Property.BorderTopRightRadius<0 | (string & {})> | undefined;
    borderTopStyle?: import("csstype").Property.BorderTopStyle | undefined;
    borderTopWidth?: import("csstype").Property.BorderTopWidth<0 | (string & {})> | undefined;
    bottom?: import("csstype").Property.Bottom<0 | (string & {})> | undefined;
    boxDecorationBreak?: import("csstype").Property.BoxDecorationBreak | undefined;
    boxShadow?: import("csstype").Property.BoxShadow | undefined;
    boxSizing?: import("csstype").Property.BoxSizing | undefined;
    breakAfter?: import("csstype").Property.BreakAfter | undefined;
    breakBefore?: import("csstype").Property.BreakBefore | undefined;
    breakInside?: import("csstype").Property.BreakInside | undefined;
    captionSide?: import("csstype").Property.CaptionSide | undefined;
    caretColor?: import("csstype").Property.CaretColor | undefined;
    clear?: import("csstype").Property.Clear | undefined;
    clipPath?: import("csstype").Property.ClipPath | undefined;
    color?: import("csstype").Property.Color | undefined;
    colorAdjust?: import("csstype").Property.PrintColorAdjust | undefined;
    colorScheme?: import("csstype").Property.ColorScheme | undefined;
    columnCount?: import("csstype").Property.ColumnCount | undefined;
    columnFill?: import("csstype").Property.ColumnFill | undefined;
    columnGap?: import("csstype").Property.ColumnGap<0 | (string & {})> | undefined;
    columnRuleColor?: import("csstype").Property.ColumnRuleColor | undefined;
    columnRuleStyle?: import("csstype").Property.ColumnRuleStyle | undefined;
    columnRuleWidth?: import("csstype").Property.ColumnRuleWidth<0 | (string & {})> | undefined;
    columnSpan?: import("csstype").Property.ColumnSpan | undefined;
    columnWidth?: import("csstype").Property.ColumnWidth<0 | (string & {})> | undefined;
    contain?: import("csstype").Property.Contain | undefined;
    content?: import("csstype").Property.Content | undefined;
    contentVisibility?: import("csstype").Property.ContentVisibility | undefined;
    counterIncrement?: import("csstype").Property.CounterIncrement | undefined;
    counterReset?: import("csstype").Property.CounterReset | undefined;
    counterSet?: import("csstype").Property.CounterSet | undefined;
    cursor?: import("csstype").Property.Cursor | undefined;
    direction?: import("csstype").Property.Direction | undefined;
    display?: import("csstype").Property.Display | undefined;
    emptyCells?: import("csstype").Property.EmptyCells | undefined;
    filter?: import("csstype").Property.Filter | undefined;
    flexBasis?: import("csstype").Property.FlexBasis<0 | (string & {})> | undefined;
    flexDirection?: import("csstype").Property.FlexDirection | undefined;
    flexGrow?: import("csstype").Property.FlexGrow | undefined;
    flexShrink?: import("csstype").Property.FlexShrink | undefined;
    flexWrap?: import("csstype").Property.FlexWrap | undefined;
    float?: import("csstype").Property.Float | undefined;
    fontFamily?: import("csstype").Property.FontFamily | undefined;
    fontFeatureSettings?: import("csstype").Property.FontFeatureSettings | undefined;
    fontKerning?: import("csstype").Property.FontKerning | undefined;
    fontLanguageOverride?: import("csstype").Property.FontLanguageOverride | undefined;
    fontOpticalSizing?: import("csstype").Property.FontOpticalSizing | undefined;
    fontSize?: import("csstype").Property.FontSize<0 | (string & {})> | undefined;
    fontSizeAdjust?: import("csstype").Property.FontSizeAdjust | undefined;
    fontSmooth?: import("csstype").Property.FontSmooth<0 | (string & {})> | undefined;
    fontStretch?: import("csstype").Property.FontStretch | undefined;
    fontStyle?: import("csstype").Property.FontStyle | undefined;
    fontSynthesis?: import("csstype").Property.FontSynthesis | undefined;
    fontVariant?: import("csstype").Property.FontVariant | undefined;
    fontVariantAlternates?: import("csstype").Property.FontVariantAlternates | undefined;
    fontVariantCaps?: import("csstype").Property.FontVariantCaps | undefined;
    fontVariantEastAsian?: import("csstype").Property.FontVariantEastAsian | undefined;
    fontVariantLigatures?: import("csstype").Property.FontVariantLigatures | undefined;
    fontVariantNumeric?: import("csstype").Property.FontVariantNumeric | undefined;
    fontVariantPosition?: import("csstype").Property.FontVariantPosition | undefined;
    fontVariationSettings?: import("csstype").Property.FontVariationSettings | undefined;
    fontWeight?: import("csstype").Property.FontWeight | undefined;
    forcedColorAdjust?: import("csstype").Property.ForcedColorAdjust | undefined;
    gridAutoColumns?: import("csstype").Property.GridAutoColumns<0 | (string & {})> | undefined;
    gridAutoFlow?: import("csstype").Property.GridAutoFlow | undefined;
    gridAutoRows?: import("csstype").Property.GridAutoRows<0 | (string & {})> | undefined;
    gridColumnEnd?: import("csstype").Property.GridColumnEnd | undefined;
    gridColumnStart?: import("csstype").Property.GridColumnStart | undefined;
    gridRowEnd?: import("csstype").Property.GridRowEnd | undefined;
    gridRowStart?: import("csstype").Property.GridRowStart | undefined;
    gridTemplateAreas?: import("csstype").Property.GridTemplateAreas | undefined;
    gridTemplateColumns?: import("csstype").Property.GridTemplateColumns<0 | (string & {})> | undefined;
    gridTemplateRows?: import("csstype").Property.GridTemplateRows<0 | (string & {})> | undefined;
    hangingPunctuation?: import("csstype").Property.HangingPunctuation | undefined;
    height?: import("csstype").Property.Height<0 | (string & {})> | undefined;
    hyphenateCharacter?: import("csstype").Property.HyphenateCharacter | undefined;
    hyphens?: import("csstype").Property.Hyphens | undefined;
    imageOrientation?: import("csstype").Property.ImageOrientation | undefined;
    imageRendering?: import("csstype").Property.ImageRendering | undefined;
    imageResolution?: import("csstype").Property.ImageResolution | undefined;
    initialLetter?: import("csstype").Property.InitialLetter | undefined;
    inlineSize?: import("csstype").Property.InlineSize<0 | (string & {})> | undefined;
    inputSecurity?: import("csstype").Property.InputSecurity | undefined;
    inset?: import("csstype").Property.Inset<0 | (string & {})> | undefined;
    insetBlock?: import("csstype").Property.InsetBlock<0 | (string & {})> | undefined;
    insetBlockEnd?: import("csstype").Property.InsetBlockEnd<0 | (string & {})> | undefined;
    insetBlockStart?: import("csstype").Property.InsetBlockStart<0 | (string & {})> | undefined;
    insetInline?: import("csstype").Property.InsetInline<0 | (string & {})> | undefined;
    insetInlineEnd?: import("csstype").Property.InsetInlineEnd<0 | (string & {})> | undefined;
    insetInlineStart?: import("csstype").Property.InsetInlineStart<0 | (string & {})> | undefined;
    isolation?: import("csstype").Property.Isolation | undefined;
    justifyContent?: import("csstype").Property.JustifyContent | undefined;
    justifyItems?: import("csstype").Property.JustifyItems | undefined;
    justifySelf?: import("csstype").Property.JustifySelf | undefined;
    justifyTracks?: import("csstype").Property.JustifyTracks | undefined;
    left?: import("csstype").Property.Left<0 | (string & {})> | undefined;
    letterSpacing?: import("csstype").Property.LetterSpacing<0 | (string & {})> | undefined;
    lineBreak?: import("csstype").Property.LineBreak | undefined;
    lineHeight?: import("csstype").Property.LineHeight<0 | (string & {})> | undefined;
    lineHeightStep?: import("csstype").Property.LineHeightStep<0 | (string & {})> | undefined;
    listStyleImage?: import("csstype").Property.ListStyleImage | undefined;
    listStylePosition?: import("csstype").Property.ListStylePosition | undefined;
    listStyleType?: import("csstype").Property.ListStyleType | undefined;
    marginBlock?: import("csstype").Property.MarginBlock<0 | (string & {})> | undefined;
    marginBlockEnd?: import("csstype").Property.MarginBlockEnd<0 | (string & {})> | undefined;
    marginBlockStart?: import("csstype").Property.MarginBlockStart<0 | (string & {})> | undefined;
    marginBottom?: import("csstype").Property.MarginBottom<0 | (string & {})> | undefined;
    marginInline?: import("csstype").Property.MarginInline<0 | (string & {})> | undefined;
    marginInlineEnd?: import("csstype").Property.MarginInlineEnd<0 | (string & {})> | undefined;
    marginInlineStart?: import("csstype").Property.MarginInlineStart<0 | (string & {})> | undefined;
    marginLeft?: import("csstype").Property.MarginLeft<0 | (string & {})> | undefined;
    marginRight?: import("csstype").Property.MarginRight<0 | (string & {})> | undefined;
    marginTop?: import("csstype").Property.MarginTop<0 | (string & {})> | undefined;
    maskBorderMode?: import("csstype").Property.MaskBorderMode | undefined;
    maskBorderOutset?: import("csstype").Property.MaskBorderOutset<0 | (string & {})> | undefined;
    maskBorderRepeat?: import("csstype").Property.MaskBorderRepeat | undefined;
    maskBorderSlice?: import("csstype").Property.MaskBorderSlice | undefined;
    maskBorderSource?: import("csstype").Property.MaskBorderSource | undefined;
    maskBorderWidth?: import("csstype").Property.MaskBorderWidth<0 | (string & {})> | undefined;
    maskClip?: import("csstype").Property.MaskClip | undefined;
    maskComposite?: import("csstype").Property.MaskComposite | undefined;
    maskImage?: import("csstype").Property.MaskImage | undefined;
    maskMode?: import("csstype").Property.MaskMode | undefined;
    maskOrigin?: import("csstype").Property.MaskOrigin | undefined;
    maskPosition?: import("csstype").Property.MaskPosition<0 | (string & {})> | undefined;
    maskRepeat?: import("csstype").Property.MaskRepeat | undefined;
    maskSize?: import("csstype").Property.MaskSize<0 | (string & {})> | undefined;
    maskType?: import("csstype").Property.MaskType | undefined;
    mathDepth?: import("csstype").Property.MathDepth | undefined;
    mathShift?: import("csstype").Property.MathShift | undefined;
    mathStyle?: import("csstype").Property.MathStyle | undefined;
    maxBlockSize?: import("csstype").Property.MaxBlockSize<0 | (string & {})> | undefined;
    maxHeight?: import("csstype").Property.MaxHeight<0 | (string & {})> | undefined;
    maxInlineSize?: import("csstype").Property.MaxInlineSize<0 | (string & {})> | undefined;
    maxLines?: import("csstype").Property.MaxLines | undefined;
    maxWidth?: import("csstype").Property.MaxWidth<0 | (string & {})> | undefined;
    minBlockSize?: import("csstype").Property.MinBlockSize<0 | (string & {})> | undefined;
    minHeight?: import("csstype").Property.MinHeight<0 | (string & {})> | undefined;
    minInlineSize?: import("csstype").Property.MinInlineSize<0 | (string & {})> | undefined;
    minWidth?: import("csstype").Property.MinWidth<0 | (string & {})> | undefined;
    mixBlendMode?: import("csstype").Property.MixBlendMode | undefined;
    motionDistance?: import("csstype").Property.OffsetDistance<0 | (string & {})> | undefined;
    motionPath?: import("csstype").Property.OffsetPath | undefined;
    motionRotation?: import("csstype").Property.OffsetRotate | undefined;
    objectFit?: import("csstype").Property.ObjectFit | undefined;
    objectPosition?: import("csstype").Property.ObjectPosition<0 | (string & {})> | undefined;
    offsetAnchor?: import("csstype").Property.OffsetAnchor<0 | (string & {})> | undefined;
    offsetDistance?: import("csstype").Property.OffsetDistance<0 | (string & {})> | undefined;
    offsetPath?: import("csstype").Property.OffsetPath | undefined;
    offsetRotate?: import("csstype").Property.OffsetRotate | undefined;
    offsetRotation?: import("csstype").Property.OffsetRotate | undefined;
    opacity?: import("csstype").Property.Opacity | undefined;
    order?: import("csstype").Property.Order | undefined;
    orphans?: import("csstype").Property.Orphans | undefined;
    outlineColor?: import("csstype").Property.OutlineColor | undefined;
    outlineOffset?: import("csstype").Property.OutlineOffset<0 | (string & {})> | undefined;
    outlineStyle?: import("csstype").Property.OutlineStyle | undefined;
    outlineWidth?: import("csstype").Property.OutlineWidth<0 | (string & {})> | undefined;
    overflowAnchor?: import("csstype").Property.OverflowAnchor | undefined;
    overflowBlock?: import("csstype").Property.OverflowBlock | undefined;
    overflowClipBox?: import("csstype").Property.OverflowClipBox | undefined;
    overflowClipMargin?: import("csstype").Property.OverflowClipMargin<0 | (string & {})> | undefined;
    overflowInline?: import("csstype").Property.OverflowInline | undefined;
    overflowWrap?: import("csstype").Property.OverflowWrap | undefined;
    overflowX?: import("csstype").Property.OverflowX | undefined;
    overflowY?: import("csstype").Property.OverflowY | undefined;
    overscrollBehaviorBlock?: import("csstype").Property.OverscrollBehaviorBlock | undefined;
    overscrollBehaviorInline?: import("csstype").Property.OverscrollBehaviorInline | undefined;
    overscrollBehaviorX?: import("csstype").Property.OverscrollBehaviorX | undefined;
    overscrollBehaviorY?: import("csstype").Property.OverscrollBehaviorY | undefined;
    paddingBlock?: import("csstype").Property.PaddingBlock<0 | (string & {})> | undefined;
    paddingBlockEnd?: import("csstype").Property.PaddingBlockEnd<0 | (string & {})> | undefined;
    paddingBlockStart?: import("csstype").Property.PaddingBlockStart<0 | (string & {})> | undefined;
    paddingBottom?: import("csstype").Property.PaddingBottom<0 | (string & {})> | undefined;
    paddingInline?: import("csstype").Property.PaddingInline<0 | (string & {})> | undefined;
    paddingInlineEnd?: import("csstype").Property.PaddingInlineEnd<0 | (string & {})> | undefined;
    paddingInlineStart?: import("csstype").Property.PaddingInlineStart<0 | (string & {})> | undefined;
    paddingLeft?: import("csstype").Property.PaddingLeft<0 | (string & {})> | undefined;
    paddingRight?: import("csstype").Property.PaddingRight<0 | (string & {})> | undefined;
    paddingTop?: import("csstype").Property.PaddingTop<0 | (string & {})> | undefined;
    pageBreakAfter?: import("csstype").Property.PageBreakAfter | undefined;
    pageBreakBefore?: import("csstype").Property.PageBreakBefore | undefined;
    pageBreakInside?: import("csstype").Property.PageBreakInside | undefined;
    paintOrder?: import("csstype").Property.PaintOrder | undefined;
    perspective?: import("csstype").Property.Perspective<0 | (string & {})> | undefined;
    perspectiveOrigin?: import("csstype").Property.PerspectiveOrigin<0 | (string & {})> | undefined;
    placeContent?: import("csstype").Property.PlaceContent | undefined;
    pointerEvents?: import("csstype").Property.PointerEvents | undefined;
    position?: import("csstype").Property.Position | undefined;
    printColorAdjust?: import("csstype").Property.PrintColorAdjust | undefined;
    quotes?: import("csstype").Property.Quotes | undefined;
    resize?: import("csstype").Property.Resize | undefined;
    right?: import("csstype").Property.Right<0 | (string & {})> | undefined;
    rotate?: import("csstype").Property.Rotate | undefined;
    rowGap?: import("csstype").Property.RowGap<0 | (string & {})> | undefined;
    rubyAlign?: import("csstype").Property.RubyAlign | undefined;
    rubyMerge?: import("csstype").Property.RubyMerge | undefined;
    rubyPosition?: import("csstype").Property.RubyPosition | undefined;
    scale?: import("csstype").Property.Scale | undefined;
    scrollBehavior?: import("csstype").Property.ScrollBehavior | undefined;
    scrollMargin?: import("csstype").Property.ScrollMargin<0 | (string & {})> | undefined;
    scrollMarginBlock?: import("csstype").Property.ScrollMarginBlock<0 | (string & {})> | undefined;
    scrollMarginBlockEnd?: import("csstype").Property.ScrollMarginBlockEnd<0 | (string & {})> | undefined;
    scrollMarginBlockStart?: import("csstype").Property.ScrollMarginBlockStart<0 | (string & {})> | undefined;
    scrollMarginBottom?: import("csstype").Property.ScrollMarginBottom<0 | (string & {})> | undefined;
    scrollMarginInline?: import("csstype").Property.ScrollMarginInline<0 | (string & {})> | undefined;
    scrollMarginInlineEnd?: import("csstype").Property.ScrollMarginInlineEnd<0 | (string & {})> | undefined;
    scrollMarginInlineStart?: import("csstype").Property.ScrollMarginInlineStart<0 | (string & {})> | undefined;
    scrollMarginLeft?: import("csstype").Property.ScrollMarginLeft<0 | (string & {})> | undefined;
    scrollMarginRight?: import("csstype").Property.ScrollMarginRight<0 | (string & {})> | undefined;
    scrollMarginTop?: import("csstype").Property.ScrollMarginTop<0 | (string & {})> | undefined;
    scrollPadding?: import("csstype").Property.ScrollPadding<0 | (string & {})> | undefined;
    scrollPaddingBlock?: import("csstype").Property.ScrollPaddingBlock<0 | (string & {})> | undefined;
    scrollPaddingBlockEnd?: import("csstype").Property.ScrollPaddingBlockEnd<0 | (string & {})> | undefined;
    scrollPaddingBlockStart?: import("csstype").Property.ScrollPaddingBlockStart<0 | (string & {})> | undefined;
    scrollPaddingBottom?: import("csstype").Property.ScrollPaddingBottom<0 | (string & {})> | undefined;
    scrollPaddingInline?: import("csstype").Property.ScrollPaddingInline<0 | (string & {})> | undefined;
    scrollPaddingInlineEnd?: import("csstype").Property.ScrollPaddingInlineEnd<0 | (string & {})> | undefined;
    scrollPaddingInlineStart?: import("csstype").Property.ScrollPaddingInlineStart<0 | (string & {})> | undefined;
    scrollPaddingLeft?: import("csstype").Property.ScrollPaddingLeft<0 | (string & {})> | undefined;
    scrollPaddingRight?: import("csstype").Property.ScrollPaddingRight<0 | (string & {})> | undefined;
    scrollPaddingTop?: import("csstype").Property.ScrollPaddingTop<0 | (string & {})> | undefined;
    scrollSnapAlign?: import("csstype").Property.ScrollSnapAlign | undefined;
    scrollSnapMargin?: import("csstype").Property.ScrollMargin<0 | (string & {})> | undefined;
    scrollSnapMarginBottom?: import("csstype").Property.ScrollMarginBottom<0 | (string & {})> | undefined;
    scrollSnapMarginLeft?: import("csstype").Property.ScrollMarginLeft<0 | (string & {})> | undefined;
    scrollSnapMarginRight?: import("csstype").Property.ScrollMarginRight<0 | (string & {})> | undefined;
    scrollSnapMarginTop?: import("csstype").Property.ScrollMarginTop<0 | (string & {})> | undefined;
    scrollSnapStop?: import("csstype").Property.ScrollSnapStop | undefined;
    scrollSnapType?: import("csstype").Property.ScrollSnapType | undefined;
    scrollbarColor?: import("csstype").Property.ScrollbarColor | undefined;
    scrollbarGutter?: import("csstype").Property.ScrollbarGutter | undefined;
    scrollbarWidth?: import("csstype").Property.ScrollbarWidth | undefined;
    shapeImageThreshold?: import("csstype").Property.ShapeImageThreshold | undefined;
    shapeMargin?: import("csstype").Property.ShapeMargin<0 | (string & {})> | undefined;
    shapeOutside?: import("csstype").Property.ShapeOutside | undefined;
    tabSize?: import("csstype").Property.TabSize<0 | (string & {})> | undefined;
    tableLayout?: import("csstype").Property.TableLayout | undefined;
    textAlign?: import("csstype").Property.TextAlign | undefined;
    textAlignLast?: import("csstype").Property.TextAlignLast | undefined;
    textCombineUpright?: import("csstype").Property.TextCombineUpright | undefined;
    textDecorationColor?: import("csstype").Property.TextDecorationColor | undefined;
    textDecorationLine?: import("csstype").Property.TextDecorationLine | undefined;
    textDecorationSkip?: import("csstype").Property.TextDecorationSkip | undefined;
    textDecorationSkipInk?: import("csstype").Property.TextDecorationSkipInk | undefined;
    textDecorationStyle?: import("csstype").Property.TextDecorationStyle | undefined;
    textDecorationThickness?: import("csstype").Property.TextDecorationThickness<0 | (string & {})> | undefined;
    textEmphasisColor?: import("csstype").Property.TextEmphasisColor | undefined;
    textEmphasisPosition?: import("csstype").Property.TextEmphasisPosition | undefined;
    textEmphasisStyle?: import("csstype").Property.TextEmphasisStyle | undefined;
    textIndent?: import("csstype").Property.TextIndent<0 | (string & {})> | undefined;
    textJustify?: import("csstype").Property.TextJustify | undefined;
    textOrientation?: import("csstype").Property.TextOrientation | undefined;
    textOverflow?: import("csstype").Property.TextOverflow | undefined;
    textRendering?: import("csstype").Property.TextRendering | undefined;
    textShadow?: import("csstype").Property.TextShadow | undefined;
    textSizeAdjust?: import("csstype").Property.TextSizeAdjust | undefined;
    textTransform?: import("csstype").Property.TextTransform | undefined;
    textUnderlineOffset?: import("csstype").Property.TextUnderlineOffset<0 | (string & {})> | undefined;
    textUnderlinePosition?: import("csstype").Property.TextUnderlinePosition | undefined;
    top?: import("csstype").Property.Top<0 | (string & {})> | undefined;
    touchAction?: import("csstype").Property.TouchAction | undefined;
    transformBox?: import("csstype").Property.TransformBox | undefined;
    transformOrigin?: import("csstype").Property.TransformOrigin<0 | (string & {})> | undefined;
    transformStyle?: import("csstype").Property.TransformStyle | undefined;
    transitionDelay?: import("csstype").Property.TransitionDelay<string & {}> | undefined;
    transitionDuration?: import("csstype").Property.TransitionDuration<string & {}> | undefined;
    transitionProperty?: import("csstype").Property.TransitionProperty | undefined;
    transitionTimingFunction?: import("csstype").Property.TransitionTimingFunction | undefined;
    translate?: import("csstype").Property.Translate<0 | (string & {})> | undefined;
    unicodeBidi?: import("csstype").Property.UnicodeBidi | undefined;
    userSelect?: import("csstype").Property.UserSelect | undefined;
    verticalAlign?: import("csstype").Property.VerticalAlign<0 | (string & {})> | undefined;
    visibility?: import("csstype").Property.Visibility | undefined;
    whiteSpace?: import("csstype").Property.WhiteSpace | undefined;
    widows?: import("csstype").Property.Widows | undefined;
    width?: import("csstype").Property.Width<0 | (string & {})> | undefined;
    willChange?: import("csstype").Property.WillChange | undefined;
    wordBreak?: import("csstype").Property.WordBreak | undefined;
    wordSpacing?: import("csstype").Property.WordSpacing<0 | (string & {})> | undefined;
    wordWrap?: import("csstype").Property.WordWrap | undefined;
    writingMode?: import("csstype").Property.WritingMode | undefined;
    zIndex?: import("csstype").Property.ZIndex | undefined;
    zoom?: import("csstype").Property.Zoom | undefined;
    all?: import("csstype").Globals | undefined;
    animation?: import("csstype").Property.Animation<string & {}> | undefined;
    background?: import("csstype").Property.Background<0 | (string & {})> | undefined;
    backgroundPosition?: import("csstype").Property.BackgroundPosition<0 | (string & {})> | undefined;
    border?: import("csstype").Property.Border<0 | (string & {})> | undefined;
    borderBlock?: import("csstype").Property.BorderBlock<0 | (string & {})> | undefined;
    borderBlockEnd?: import("csstype").Property.BorderBlockEnd<0 | (string & {})> | undefined;
    borderBlockStart?: import("csstype").Property.BorderBlockStart<0 | (string & {})> | undefined;
    borderBottom?: import("csstype").Property.BorderBottom<0 | (string & {})> | undefined;
    borderColor?: import("csstype").Property.BorderColor | undefined;
    borderImage?: import("csstype").Property.BorderImage | undefined;
    borderInline?: import("csstype").Property.BorderInline<0 | (string & {})> | undefined;
    borderInlineEnd?: import("csstype").Property.BorderInlineEnd<0 | (string & {})> | undefined;
    borderInlineStart?: import("csstype").Property.BorderInlineStart<0 | (string & {})> | undefined;
    borderLeft?: import("csstype").Property.BorderLeft<0 | (string & {})> | undefined;
    borderRadius?: import("csstype").Property.BorderRadius<0 | (string & {})> | undefined;
    borderRight?: import("csstype").Property.BorderRight<0 | (string & {})> | undefined;
    borderStyle?: import("csstype").Property.BorderStyle | undefined;
    borderTop?: import("csstype").Property.BorderTop<0 | (string & {})> | undefined;
    borderWidth?: import("csstype").Property.BorderWidth<0 | (string & {})> | undefined;
    columnRule?: import("csstype").Property.ColumnRule<0 | (string & {})> | undefined;
    columns?: import("csstype").Property.Columns<0 | (string & {})> | undefined;
    flex?: import("csstype").Property.Flex<0 | (string & {})> | undefined;
    flexFlow?: import("csstype").Property.FlexFlow | undefined;
    font?: import("csstype").Property.Font | undefined;
    gap?: import("csstype").Property.Gap<0 | (string & {})> | undefined;
    grid?: import("csstype").Property.Grid | undefined;
    gridArea?: import("csstype").Property.GridArea | undefined;
    gridColumn?: import("csstype").Property.GridColumn | undefined;
    gridRow?: import("csstype").Property.GridRow | undefined;
    gridTemplate?: import("csstype").Property.GridTemplate | undefined;
    lineClamp?: import("csstype").Property.LineClamp | undefined;
    listStyle?: import("csstype").Property.ListStyle | undefined;
    margin?: import("csstype").Property.Margin<0 | (string & {})> | undefined;
    mask?: import("csstype").Property.Mask<0 | (string & {})> | undefined;
    maskBorder?: import("csstype").Property.MaskBorder | undefined;
    motion?: import("csstype").Property.Offset<0 | (string & {})> | undefined;
    outline?: import("csstype").Property.Outline<0 | (string & {})> | undefined;
    overflow?: import("csstype").Property.Overflow | undefined;
    overscrollBehavior?: import("csstype").Property.OverscrollBehavior | undefined;
    padding?: import("csstype").Property.Padding<0 | (string & {})> | undefined;
    placeItems?: import("csstype").Property.PlaceItems | undefined;
    placeSelf?: import("csstype").Property.PlaceSelf | undefined;
    textDecoration?: import("csstype").Property.TextDecoration<0 | (string & {})> | undefined;
    textEmphasis?: import("csstype").Property.TextEmphasis | undefined;
    transition?: import("csstype").Property.Transition<string & {}> | undefined;
};
/**
 * Stops an animation.
 *
 * @param animation Animation that is going to be stopped.
 * @returns
 */
export declare function stopAnimation<E extends HTMLElement>(animation: Animation, node: E | null): void;
export {};
