import { ListProps } from '../UNSAFE_ListView/List.types';
/**
 * Props for the VirtualizedListView Component
 */
export type Props<K, D> = Pick<ListProps<K, D>, 'aria-label' | 'aria-labelledby' | 'children' | 'currentItemVariant' | 'currentKey' | 'data' | 'gridlines' | 'onCurrentKeyChange' | 'onItemAction' | 'onLoadRange' | 'onSelectionChange' | 'selectedKeys' | 'selectionMode' | 'viewportConfig'>;
/**
 * Component that renders items as a flat list.
 * In order to maximize performance, only items that are visible in the viewport are rendered.
 */
export declare function VirtualizedListView<K extends string | number, D>(props: Props<K, D>): import("preact").JSX.Element;
