import { ItemInfo, TagCloudItemData } from './tagCloud.type';
import { type Rect } from '../utils/PRIVATE_visLayoutUtils/layoutUtils';
import { HTMLAttributesSignalExcluded } from '../utils/UNSAFE_attributeUtils';
import { BundleType } from '../resources/nls/bundle';
import { TagItemProps } from './TagCloudItem';
import { GetTextDimensionsType } from '../hooks/PRIVATE_useTextDimensions';
import { DatatipType } from './tagCloud.type';
/**
 * helper layout functions for font size calc
 * @param {number} minValue
 * @param {number} maxValue
 * @param {number} range
 * @return {number}
 */
export declare const fontSizeCalc: (value: number, minValue: number, maxValue: number, range: number) => number;
/**
 * returns initial font size arr of items for layout
 * @param {Array} items
 * @return {Array}
 */
export declare function getInitialFontSize<K>(items: TagCloudItemData<K>[]): TagItemProps<K>[];
/**
 * Calculates the line breaks for rectangular layout
 * @param {Array} arDims an array of Dimension objects for each tag
 * @param {number} width the available width
 * @return {Array} an array containing the starting tag index for each line in the layout
 * @private
 */
export declare function calculateLineBreaks(arDims: Rect[], width: number): number[];
/**
 * Returns the items position and font size in cloud layout.
 * @param items
 * @param tagcloudH
 * @param tagcloudW
 */
export declare function getCloudLayout<K>(items: TagCloudItemData<K>[], tagcloudW: number, tagcloudH: number, isRTL: boolean, getTextDimensions: GetTextDimensionsType): TagItemProps<K>[];
/**
 * Returns the items position and font size in rectangle layout.
 * @param items
 * @param tagcloudH
 * @param tagcloudW
 * @param isRTL
 * @param getTextDimensions
 */
export declare function getRectangleLayout<K>(items: TagCloudItemData<K>[], tagcloudW: number, tagcloudH: number, isRTL: boolean, getTextDimensions: GetTextDimensionsType): {
    w: number;
    h: number;
    id: K;
    label: string;
    accessibleLabel?: string | undefined;
    value: number;
    fontSize: number;
    role?: import("preact").JSX.AriaRole | undefined;
    itemIdx?: number | undefined;
    supportsSelection?: boolean | undefined;
    supportsAction?: boolean | undefined;
    translations?: {
        accAnnounceMovedKey: (p: {
            itemKey: string;
            position: string;
            referenceKey: string;
        }) => string;
        accCommandKey: () => string;
        accControlKey: () => string;
        accPositionAfter: () => string;
        accPositionBefore: () => string;
        accReorderInstructions: (p: {
            keyPressed: string;
        }) => string;
        calendarDateConverter_parseError: (p: {
            dateExample: string;
        }) => string;
        calendarMonthConverter_parseError: (p: {
            dateExample: string;
        }) => string;
        chart_labelGroup: () => string;
        chart_labelSeries: () => string;
        chart_labelValue: () => string;
        checkboxSet_requiredMessageDetail: () => string;
        checkbox_requiredMessageDetail: () => string;
        close: () => string;
        collection_noData: () => string;
        collection_selectAllRows: () => string;
        collection_selectRow: (p: {
            ROW_NAME: string;
        }) => string;
        collection_sortDisabled: () => string;
        collection_sortEnabled: () => string;
        confirmation: () => string;
        datePicker_currentDate: () => string;
        datePicker_goToToday: () => string;
        datePicker_label: () => string;
        datePicker_month: () => string;
        datePicker_months: () => string;
        datePicker_next: () => string;
        datePicker_nextDecade: () => string;
        datePicker_nextMonth: () => string;
        datePicker_prev: () => string;
        datePicker_prevDecade: () => string;
        datePicker_prevMonth: () => string;
        datePicker_restricted: () => string;
        datePicker_selected: () => string;
        datePicker_today: () => string;
        datePicker_weekNum: (p: {
            NUM: string;
        }) => string;
        datePicker_weekNumColLabel: () => string;
        datePicker_year: () => string;
        datePicker_years: () => string;
        error: () => string;
        expandableList_expandCollapseInstructionText: () => string;
        expandableList_groupCollapse: () => string;
        expandableList_groupExpand: () => string;
        filePicker_addFiles: () => string;
        filePicker_dropzonePrimaryText: () => string;
        filePicker_dropzoneSecondaryText: () => string;
        filePicker_dropzoneSecondaryTextMultiple: () => string;
        filePicker_multipleFileTypeUploadError: (p: {
            fileTypes: string;
        }) => string;
        filePicker_singleFileUploadError: () => string;
        filePicker_singleTypeUploadError: (p: {
            fileType: string;
        }) => string;
        filePicker_unknownFileTypeUploadError: () => string;
        formControl_clear: () => string;
        formControl_day: () => string;
        formControl_helpAvailable: () => string;
        formControl_hide: () => string;
        formControl_limitReached: (p: {
            CHARACTER_LIMIT: number;
        }) => string;
        formControl_loading: () => string;
        formControl_maxLength: (p: {
            MAX_LENGTH: string;
        }) => string;
        formControl_maxLengthRemaining: (p: {
            CHARACTER_COUNT: string;
        }) => string;
        formControl_month: () => string;
        formControl_readOnly: () => string;
        formControl_requiredMessageDetail: () => string;
        formControl_show: () => string;
        formControl_year: () => string;
        gantt_labelDate: () => string;
        gantt_labelEnd: () => string;
        gantt_labelLabel: () => string;
        gantt_labelRow: () => string;
        gantt_labelStart: () => string;
        indexer_disabledLabel: (p: {
            SECTION: string;
        }) => string;
        indexer_keyboardInstructionText: () => string;
        indexer_othersLabel: () => string;
        indexer_separatorLabel: (p: {
            FROM_SECTION: string;
            TO_SECTION: string;
        }) => string;
        indexer_touchInstructionText: () => string;
        info: () => string;
        inputDateMask_date_cleared: () => string;
        inputDateMask_dayPlaceholder: () => string;
        inputDateMask_empty_segment: () => string;
        inputDateMask_monthPlaceholder: () => string;
        inputDateMask_yearPlaceholder: () => string;
        inputDatePicker_dateRangeOverflowMessageDetail: (p: {
            max: string;
        }) => string;
        inputDatePicker_dateRangeUnderflowMessageDetail: (p: {
            min: string;
        }) => string;
        inputDatePicker_dateRestrictionMessageDetail: () => string;
        inputDatePicker_instruction: () => string;
        inputDatePicker_selectDate: () => string;
        inputMonthMask_dateRangeOverflowMessageDetail: (p: {
            max: string;
        }) => string;
        inputMonthMask_dateRangeUnderflowMessageDetail: (p: {
            min: string;
        }) => string;
        inputNumber_converterParseError: () => string;
        inputNumber_decrease: () => string;
        inputNumber_increase: () => string;
        inputPassword_hidden: () => string;
        inputPassword_hide: () => string;
        inputPassword_show: () => string;
        inputSensitiveText_hidden: () => string;
        list_msgFetchCompleted: () => string;
        list_msgFetchingData: () => string;
        list_suggestion: () => string;
        messageToast_allMessagesClosed: () => string;
        message_close: () => string;
        message_confirmation: () => string;
        message_error: () => string;
        message_info: () => string;
        message_navigationFromMessagesRegion: () => string;
        message_navigationToMessagesRegion: () => string;
        message_warning: () => string;
        noData_message: () => string;
        overflowItemLabel: () => string;
        plural_separator: () => string;
        progressIndeterminate: () => string;
        radio_helpForRadio: () => string;
        radio_requiredMessageDetail: () => string;
        selectMultiple_apply: () => string;
        selectMultiple_back: () => string;
        selectMultiple_countPlus: (p: {
            COUNT: string;
        }) => string;
        selectMultiple_highlightSelectedTagsInstructionText: () => string;
        selectMultiple_removeSelectedTagInstructionText: () => string;
        selectMultiple_selectedValues: () => string;
        selectMultiple_showSelectedValues: () => string;
        selectMultiple_valuesSelected: (p: {
            VALUE_COUNT: string;
        }) => string;
        select_addToList: () => string;
        select_addToListAvailable: () => string;
        select_moreSearchOptions: () => string;
        select_moreSearchOptionsAvailable: () => string;
        select_noMatchesFound: () => string;
        select_oneMatchFound: () => string;
        select_requiredMessageDetail: () => string;
        select_sizeMatchesFound: (p: {
            TOTAL_SIZE: string;
        }) => string;
        select_sizeOrMoreMatchesFound: (p: {
            TOTAL_SIZE: string;
        }) => string;
        selectorAll_deselectAll: () => string;
        selectorAll_selectAll: () => string;
        selector_selected: () => string;
        selector_unselected: () => string;
        tabBarNavigationList_removeCueText: () => string;
        timeComponent_tooltipZoomIn: () => string;
        timeComponent_tooltipZoomOut: () => string;
        train_current: () => string;
        train_message_type: () => string;
        train_not_visited: () => string;
        train_status: (p: {
            currentStep: string;
            numberOfSteps: string;
        }) => string;
        train_visited: () => string;
        userAssistance_learnMore: () => string;
        userAssistance_required: () => string;
        vis_clearSelection: () => string;
        vis_drillable: () => string;
        vis_labelAndValue: (p: {
            LABEL: string;
            VALUE: string;
        }) => string;
        vis_labelCountWithTotal: (p: {
            itemCount: string;
            totalCount: string;
        }) => string;
        vis_marqueeSelectTooltip: () => string;
        vis_marqueeZoomTooltip: () => string;
        vis_noData: () => string;
        vis_panTooltip: () => string;
        vis_stateLoaded: () => string;
        vis_stateLoading: () => string;
        vis_stateSelected: () => string;
        vis_stateUnselected: () => string;
        warn: () => string;
    } | undefined;
    x?: number | undefined;
    y?: number | undefined;
    isHighlighted?: boolean | undefined;
    isSelected?: boolean | undefined;
    isCurrent?: boolean | undefined;
    isFocused?: boolean | undefined;
    isReadonly?: boolean | undefined;
    class?: string | undefined;
    style?: import("preact").JSX.CSSProperties | undefined;
    activeId?: string | undefined;
}[];
/**
 * Calls the right layout algorithm based on tagcloud type.
 * @param layout cloud or rectangle. cloud if not defined.
 * @param items
 * @param tagcloudW tagcloud width
 * @param tagcloudH tagcloud height
 * @param isRTL
 * @param getTextDimensions
 */
export declare function getLayout<K>(layout: string | undefined, items: TagCloudItemData<K>[], tagcloudW: number, tagcloudH: number, isRTL: boolean, getTextDimensions: GetTextDimensionsType): TagItemProps<K>[];
/**
 * Checks if the item is highlighted.
 * @param id Id of the item
 * @param highlighted The set of highlighted item
 */
export declare function isItemHighlighted<K>(id: K, highlightedIds?: K[]): boolean | undefined;
/**
 * Checks if the item is highlighted.
 * @param id Id of the item
 * @param selectedIds The set of highlighted item
 */
export declare function isItemSelected<K>(id: K, selectedIds?: K[]): boolean;
/**
 * Returns the aria properties for the tag cloud.
 * @param isReadOnly { boolean } If the tag cloud is readonly.
 * @param accessibleLabel { string } The aria-label set by the app.
 * @returns The aria props.
 */
export declare function getAriaProps(translations: BundleType, hasData?: boolean, accessibleLabel?: string, ariaDescribedBy?: string, ariaLabelledBy?: string): {
    'aria-label': HTMLAttributesSignalExcluded['aria-label'];
    role: HTMLAttributesSignalExcluded['role'];
    'aria-describedby': HTMLAttributesSignalExcluded['aria-describedby'];
    'aria-labelledby': HTMLAttributesSignalExcluded['aria-labelledby'];
};
/**
 * Returns the aria properties for the tag cloud.
 * @param isReadOnly { boolean } If the tag cloud is readonly.
 * @param accessibleLabel { string } The aria-label set by the app.
 * @returns The aria props.
 */
export declare function getItemAriaProps(supportsSelection: boolean, translations?: BundleType, isSelected?: boolean, accessibleLabel?: string, role?: HTMLAttributesSignalExcluded['role']): {
    'aria-label': HTMLAttributesSignalExcluded['aria-label'];
    role: HTMLAttributesSignalExcluded['role'];
};
/**
 * Returns the item props for BaseTagCloudItem.
 * @param item The tagcloud item.
 * @param itemIdx The item index of the item.
 * @param supportsSelection Whether the tagcloud supports selection
 * @param isReadOnly Whether the tagcloud is readonly.
 * @param hoveredItem The info of the currently hovered item.
 * @param selectedIds The selected ids.
 * @param focusedItem The info of currently focused item.
 * @param highlightedIds The highlighted ids.
 * @param activeId The active Id
 */
export declare function getItemProps<K>(item: TagCloudItemData<K>, itemIdx: number, supportsSelection: boolean, isReadOnly: boolean, hoveredItem?: ItemInfo, selectedIds?: Array<K>, focusedItem?: ItemInfo, highlightedIds?: Array<K>, activeId?: string): {
    id: K;
    label: string;
    accessibleLabel?: string | undefined;
    value: number;
    color?: import("csstype").Property.Color | undefined;
    role?: import("preact").JSX.AriaRole | undefined;
    isCurrent: boolean;
    isHighlighted: boolean | undefined;
    isSelected: boolean;
    isFocused: boolean;
    key: K;
    itemIdx: number;
    style: {
        color: string;
        backgroundColor: import("csstype").Property.Color | undefined;
        backgroundImage: undefined;
    } | {
        backgroundColor: string;
        color?: undefined;
        backgroundImage?: undefined;
    } | undefined;
    activeId: string | undefined;
    isReadOnly: boolean;
};
/**
 * Returns the text for the tag cloud datatip.
 * @param items The tag cloud items data.
 * @param focusedItem The item currently keyboard focused.
 * @param hoveredItem The item that is currently hovered.
 * @param datatip The datatip.
 */
export declare function getDatatipContent<D extends TagCloudItemData<number | string>>(items: D[], getItem: (itemInfo: ItemInfo, items: D[]) => D | undefined, focusedItem: ItemInfo, hoveredItem?: ItemInfo, datatip?: DatatipType<D>): {
    content?: import("preact").ComponentChildren;
    borderColor?: import("csstype").Property.BorderColor | undefined;
};
/**
 * Returns the value of the data-oj-item-index attribute for a given element.
 * @param element The HTML element.
 */
export declare function getItemInfo(element: HTMLElement): {
    idx: number;
} | undefined;
/**
 * Compares if two ItemInfo are equal
 * @param item1
 * @param item2
 * @returns
 */
export declare function isEqualItem(item1?: ItemInfo, item2?: ItemInfo): boolean;
/**
 * Checks if the item is the currentItem and if the focus ring
 * is visible.
 * @param itemInfo ItemInfo
 * @param itemId Item index
 */
export declare function hasFocusRing(itemInfo: ItemInfo, itemIdx: number): boolean;
/**
 * Returns KeyUp handler for Tagcloud.
 * @param triggerOnAction
 * @param updatefocusedItemInfo
 * @param focusedItemInfo
 * @returns
 */
export declare function getKeyUpHandler(triggerOnAction: () => void, updatefocusedItemInfo: (itemInfo: ItemInfo) => void, focusedItemInfo: ItemInfo): (event: KeyboardEvent) => void;
