import { ComponentChildren, ComponentProps } from 'preact';
import { DropdownArrow } from '../PRIVATE_SelectCommon';
import { TextField } from '../UNSAFE_TextField';
import { SelectedValuesCount } from './SelectedValuesCount';
import { IconButton } from '../UNSAFE_IconButton';
import { LayoutColumnSpan } from '../utils/UNSAFE_styles/Layout';
import type { TestIdProps } from "../hooks/UNSAFE_useTestId";
type TextFieldProps = ComponentProps<typeof TextField>;
type PassThroughTextFieldProps = TestIdProps & Pick<TextFieldProps, 'compactUserAssistance' | 'contentVariant' | 'id' | 'inlineUserAssistance' | 'label' | 'labelEdge' | 'labelStartWidth' | 'mainFieldRef' | 'onBlur' | 'onFocus' | 'onMouseDown' | 'statusVariant' | 'styleVariant'>;
type DropdownArrowProps = ComponentProps<typeof DropdownArrow>;
type IconButtonProps = ComponentProps<typeof IconButton>;
type SelectedValuesCountProps = ComponentProps<typeof SelectedValuesCount>;
type Props = PassThroughTextFieldProps & {
    children?: ComponentChildren;
    columnSpan?: LayoutColumnSpan;
    fieldLabel?: string;
    hasInsideLabel?: boolean;
    isBackButtonShown?: boolean;
    isClearButtonShown?: boolean;
    isDropdownArrowShown?: boolean;
    isDropdownSelectedOnlyView?: boolean;
    isSelectedValuesCountShown?: boolean;
    selectedValuesCount?: number;
    onBackButtonClick?: IconButtonProps['onAction'];
    onClearButtonClick?: IconButtonProps['onAction'];
    onDropdownArrowClick?: DropdownArrowProps['onClick'];
    onSelectedValuesCountKeyDown?: SelectedValuesCountProps['onKeyDown'];
    onSelectedValuesCountKeyUp?: SelectedValuesCountProps['onKeyUp'];
    onSelectedValuesCountMouseDown?: SelectedValuesCountProps['onMouseDown'];
    onSelectedValuesCountToggle?: SelectedValuesCountProps['onToggle'];
};
export declare function SelectMultipleField({ children, columnSpan, fieldLabel, hasInsideLabel, isBackButtonShown, isClearButtonShown, isDropdownArrowShown, isDropdownSelectedOnlyView, isSelectedValuesCountShown, selectedValuesCount, onBackButtonClick, onClearButtonClick, onDropdownArrowClick, onSelectedValuesCountKeyDown, onSelectedValuesCountKeyUp, onSelectedValuesCountMouseDown, onSelectedValuesCountToggle, ...passThroughTextFieldProps }: Props): import("preact").JSX.Element;
export {};
