import { ComponentThemeType, CompoundVariantStyles, VariantOptions } from '../../UNSAFE_Theme';
type RadioIconVariants = typeof variants;
type RadioIconVariantOptions = VariantOptions<RadioIconVariants>;
type RadioIconStyles = typeof styles;
type RadioIconTheme = ComponentThemeType<RadioIconVariants, RadioIconStyles>;
/*******************
 * Component Styles
 *******************/
declare const radioIconBaseStyle: string;
declare const radioSvgSelectedColor: string;
declare const radioSvgUnselectedColor: string;
declare const radioSvgDisabledColor: string;
declare const radioSvgPrimaryColor: string;
declare const radioSvgReadonlyColor: string;
declare const radioIconActive: string;
/*******************
 * Style Variants
 *******************/
declare const variants: {
    readonly disabled: {
        readonly isDisabled: "";
        readonly notDisabled: "";
    };
    readonly selected: {
        readonly isSelected: "";
        readonly notSelected: "";
    };
    readonly readonly: {
        readonly isReadonly: "";
        readonly notReadonly: "";
    };
    readonly active: {
        readonly isActive: "";
        readonly notActive: "";
    };
    readonly iconSize: {
        readonly '4xUnits': {
            readonly vars: {
                readonly [x: string]: string;
            };
        };
    };
};
declare const compoundVariants: CompoundVariantStyles<RadioIconVariantOptions>;
declare const styles: {
    radioIconBaseStyle: string;
    radioSvgSelectedColor: string;
    radioSvgUnselectedColor: string;
    radioSvgDisabledColor: string;
    radioSvgPrimaryColor: string;
    radioSvgReadonlyColor: string;
    radioIconActive: string;
};
export type { RadioIconVariantOptions, RadioIconStyles, RadioIconTheme };
export { radioIconBaseStyle, radioSvgSelectedColor, radioSvgUnselectedColor, radioSvgDisabledColor, radioSvgPrimaryColor, radioSvgReadonlyColor, radioIconActive, styles, compoundVariants, variants };
