/**
 * @license
 * Copyright (c) %FIRST_YEAR% %CURRENT_YEAR%, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
import { ComponentChildren, RefObject } from 'preact';
type Props = {
    children: ComponentChildren;
    /**
     * Optional Ref to an element to focus on when component mounts
     * @default - undefined - behavior is to focus on first tabbableElement
     */
    autoFocusRef?: RefObject<HTMLElement | null>;
    /**
     * Sets whether focus is managed and whether guards are present
     * @default false
     */
    isDisabled?: boolean;
    /**
     * Why a isDisabled prop as compared to ONLY supporting conditional rendering?
     *
     *   1) We need an actual HTML Element for the trap, conditional rendering an element potentially breaks consumer CSS
     *   2) Conditional rendering can short-circuit event bubbling in preact and lead to expected events not bubbling.
     */
    /**
     * Optional Ref to element to focus on when component un-mounts, false to disable.
     * @default - undefined - behavior is to focus on the original activeElement when focus trap was enabled
     */
    restoreFocusRef?: RefObject<HTMLElement> | false;
};
/**
 * Trap focus within a DOM node.  When a user hits Tab or Shift+Tab, focus remains in the focus trap.
 */
export declare const FocusTrap: ({ autoFocusRef, children, isDisabled, restoreFocusRef }: Props) => import("preact").JSX.Element;
export {};
