import { ComponentThemeType, VariantOptions } from '../../UNSAFE_Theme';
type FilePickerVariants = typeof variants;
type FilePickerVariantOptions = VariantOptions<FilePickerVariants>;
type FilePickerStyles = typeof styles;
type FilePickerTheme = ComponentThemeType<FilePickerVariants, FilePickerStyles>;
declare const baseStyle: string;
/*******************
 * Style Variants
 *******************/
declare const variants: {
    readonly disabledState: {
        readonly isDisabled: {
            backgroundColor: `var(--${string})` | `var(--${string}, ${string})` | `var(--${string}, ${number})`;
            borderColor: string;
            cursor: string;
        };
    };
    readonly hoveredState: {
        readonly isHover: string;
    };
    readonly pseudoHoveredState: {
        readonly isPseudoHover: {
            '@media': {
                '(hover: hover)': {
                    selectors: {
                        '&:hover:not(:active)': object;
                    };
                };
            };
        };
    };
};
declare const styles: {
    maxWidth: string;
    inner: string;
    activeStyle: string;
    innerNeedsEventsHoverStyle: string;
    innerPseudoHoverStyle: string;
    validDrop: string;
    invalidDrop: string;
    noChildrenMargin: string;
    primaryTextStyle: string;
    secondaryTextStyle: string;
    disabledPrimaryTextStyle: string;
    disabledSecondaryTextStyle: string;
};
export type { FilePickerVariantOptions, FilePickerStyles, FilePickerTheme };
export { baseStyle, variants, styles };
