/**
 * Stable theme tokens are manually updated and are not generated from Figma tokens
 */
declare const animation: {
    easing: {
        enter: string;
        persist: string;
        exit: string;
        linear: string;
    };
    anchor: {
        default: {
            vertical: string;
            horizontal: string;
        };
        startTopCorner: {
            vertical: string;
            horizontal: string;
        };
        top: {
            vertical: string;
            horizontal: string;
        };
        endTopCorner: {
            vertical: string;
            horizontal: string;
        };
        start: {
            vertical: string;
            horizontal: string;
        };
        end: {
            vertical: string;
            horizontal: string;
        };
        startBottomCorner: {
            vertical: string;
            horizontal: string;
        };
        bottom: {
            vertical: string;
            horizontal: string;
        };
        endBottomCorner: {
            vertical: string;
            horizontal: string;
        };
    };
    duration: {
        '2xs': string;
        xs: string;
        sm: string;
        md: string;
        lg: string;
        xl: string;
        '2xl': string;
    };
    delay: {
        none: string;
        sm: string;
        md: string;
        lg: string;
    };
    slide: {
        up: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
        down: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
        start: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
        end: {
            sm: string;
            md: string;
            lg: string;
            xl: string;
        };
    };
    scale: {
        down: {
            sm: {
                to: string;
                from: string;
            };
            md: {
                to: string;
                from: string;
            };
            full: {
                to: string;
                from: string;
            };
        };
        up: {
            sm: {
                to: string;
                from: string;
            };
            md: {
                to: string;
                from: string;
            };
            full: {
                to: string;
                from: string;
            };
        };
    };
    fade: {
        in: {
            sm: {
                to: string;
                from: string;
            };
            full: {
                to: string;
                from: string;
            };
        };
        out: {
            sm: {
                to: string;
                from: string;
            };
            full: {
                to: string;
                from: string;
            };
        };
    };
};
export { animation };
