/**
 * These theme tokens are manually updated and are not generated from Figma tokens. These will eventually be generated.
 */
export declare const colorScheme: {
    palette: {
        neutral: {
            '0': string;
            '10': string;
            '20': string;
            '30': string;
            '40': string;
            '50': string;
            '60': string;
            '70': string;
            '80': string;
            '90': string;
            '100': string;
            '110': string;
            '120': string;
            '130': string;
            '140': string;
            '150': string;
            '160': string;
            '170': string;
            '180': string;
            '190': string;
            '200': string;
        };
        danger: {
            '10': string;
            '20': string;
            '30': string;
            '40': string;
            '50': string;
            '60': string;
            '70': string;
            '80': string;
            '90': string;
            '100': string;
            '110': string;
            '120': string;
            '130': string;
            '140': string;
            '150': string;
            '160': string;
            '170': string;
            '180': string;
            '190': string;
        };
        success: {
            '10': string;
            '20': string;
            '30': string;
            '40': string;
            '50': string;
            '60': string;
            '70': string;
            '80': string;
            '90': string;
            '100': string;
            '110': string;
            '120': string;
            '130': string;
            '140': string;
            '150': string;
            '160': string;
            '170': string;
            '180': string;
            '190': string;
        };
        warning: {
            '10': string;
            '20': string;
            '30': string;
            '40': string;
            '50': string;
            '60': string;
            '70': string;
            '80': string;
            '90': string;
            '100': string;
            '110': string;
            '120': string;
            '130': string;
            '140': string;
            '150': string;
            '160': string;
            '170': string;
            '180': string;
            '190': string;
        };
        info: {
            '10': string;
            '20': string;
            '30': string;
            '40': string;
            '50': string;
            '60': string;
            '70': string;
            '80': string;
            '90': string;
            '100': string;
            '110': string;
            '120': string;
            '130': string;
            '140': string;
            '150': string;
            '160': string;
            '170': string;
            '180': string;
            '190': string;
        };
        brand: {
            '10': string;
            '20': string;
            '30': string;
            '40': string;
            '50': string;
            '60': string;
            '70': string;
            '80': string;
            '90': string;
            '100': string;
            '110': string;
            '120': string;
            '130': string;
            '140': string;
            '150': string;
            '160': string;
            '170': string;
            '180': string;
            '190': string;
        };
    };
    overlay: {
        hover: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        active: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        dangerHover: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        dangerActive: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        scrim: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        inverseHover: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        inverseActive: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
    };
    pageBackground: {
        neutral0: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        neutral10: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        neutral20: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        neutral30: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        neutral40: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
    };
    surface: {
        neutral0: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        neutral10: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        neutral20: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        neutral30: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        selected: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        disabled: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        popup: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        neutral: {
            low: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
            subtle: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
            strong: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        };
        success: {
            low: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
            subtle: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
            strong: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        };
        info: {
            low: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
            subtle: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
            strong: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        };
        warning: {
            low: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
            subtle: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
            strong: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        };
        danger: {
            low: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
            subtle: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
            strong: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        };
    };
    border: {
        enabled: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        disabled: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        divider: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        selected: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        dropLine: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        selectedNeutral: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        warning: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        danger: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        keyboardFocus: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
    };
    boxshadow: {
        shadowcolor: `var(--${string})` | `var(--${string}, ${string})` | `var(--${string}, ${number})`;
    };
    textIcon: {
        primary: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        secondary: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        disabled: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        inverse: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        link: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        success: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        info: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        warning: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        danger: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        onColor: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
    };
    textfield: {
        surface: {
            enabled: `var(--${string})` | `var(--${string}, ${string})` | `var(--${string}, ${number})`;
        };
        border: {
            enabled: `var(--${string})` | `var(--${string}, ${string})` | `var(--${string}, ${number})`;
        };
    };
    collection: {
        header: {
            text: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
            surface: {
                selected: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
                partialSelected: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
            };
        };
    };
    collectionGrid: {
        cell: {
            surfaceEdit: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        };
    };
    measure: {
        track: {
            enabled: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
            disabled: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        };
        fill: {
            enabled: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
            disabled: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        };
        thumb: {
            surface: import("@vanilla-extract/private").CSSVarFunction;
        };
        reference: {
            line: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
            lineContrast: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
            area: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        };
    };
    dvt: {
        contrastLine: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        paletteQualitative: {
            '1': string;
            '2': string;
            '3': string;
            '4': string;
            '5': string;
            '6': string;
            '7': string;
            '8': string;
            '9': string;
            '10': string;
            '11': string;
            '12': string;
        };
        threshold: {
            success: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
            warning: string;
            danger: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        };
        marquee: {
            border: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
            surface: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        };
        referenceObject: {
            area: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
            line: `rgba(var(--${string}), ${number})` | `rgba(var(--${string}, ${string}), ${number})` | `rgba(var(--${string}, ${number}), ${number})`;
        };
        overview: {
            background: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
            windowBackground: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
            windowBorder: `rgb(var(--${string}))` | `rgb(var(--${string}, ${string}))` | `rgb(var(--${string}, ${number}))`;
        };
    };
};
