/* @oracle/oraclejet-preact: undefined */
import { jsx, jsxs } from 'preact/jsx-runtime';
import { L as Label } from './Label-6674b3f2.js';
import { L as Link } from './Link-bfa35319.js';
import { T as Text } from './Text-da8588ce.js';
import 'preact/hooks';
import 'preact/compat';
import './TextFieldInput-3c39cb7b.js';
import './ObfuscatedTextFieldInputStyles.styles.css';
import { u as useAccessibleContext } from './useAccessibleContext-5744de8b.js';
import './FormContext-4d71f9c7.js';
import { u as useFormContext } from './useFormContext-875cacd7.js';
import './TabbableModeContext-7d8ad946.js';
import { t as textInterpolations } from './textAlign-ad252afa.js';
import { F as FormFieldContext } from './FormFieldContext-68eb5946.js';
import './logger-c92f309c.js';
import './ReadonlyTextFieldInputStyles.styles.css';
import './UNSAFE_TextField/themes/redwood/ReadonlyTextFieldInputVariants.css.js';
import './LayerHost-45f545d7.js';
import { R as ReadonlyTextField } from './StyledTextField-c79f5438.js';
import './Flex-24628925.js';
import './LabelValueLayoutStyles.styles.css';
import './UNSAFE_TextField/themes/TextFieldStyles.css.js';
import './SkeletonStyles.styles.css';
import './TextFieldLoadingStyles.styles.css';
import './TextFieldStyles.styles.css';
import './UNSAFE_TextField/themes/redwood/TextFieldBaseTheme.styles.css';
import './UNSAFE_TextField/themes/redwood/TextFieldVariants.css.js';
import './RadioStyles.styles.css';
import './UNSAFE_RadioItem/themes/redwood/RadioBaseTheme.styles.css';
import './UNSAFE_RadioItem/themes/redwood/RadioVariants.css.js';
import './LabelStyles.styles.css';
import './UNSAFE_Label/themes/redwood/LabelBaseTheme.styles.css';
import './UNSAFE_Label/themes/redwood/LabelVariants.css.js';
import './UNSAFE_TextField/themes/FormLayoutStyles.css.js';
import './UNSAFE_TextField/themes/redwood/FormLayoutBaseTheme.styles.css';
import './CheckboxStyles.styles.css';
import './UNSAFE_Checkbox/themes/redwood/CheckboxBaseTheme.styles.css';
import './UNSAFE_Checkbox/themes/redwood/CheckboxVariants.css.js';
import './InputGroupContext-20bdbd6e.js';
import './LiveRegionStyles.styles.css';
import './UserAssistanceStyles.styles.css';
import './UNSAFE_UserAssistance/themes/redwood/UserAssistanceBaseTheme.styles.css';
import './UNSAFE_UserAssistance/themes/redwood/UserAssistanceVariants.css.js';
import { a as InlineUserAssistance } from './InlineUserAssistance-bb690d93.js';
import './MessageBannerStyles.styles.css';
import './UNSAFE_MessageBanner/themes/redwood/MessageBannerBaseTheme.styles.css';
import './UNSAFE_MessageBanner/themes/redwood/MessageBannerVariants.css.js';
import 'preact';
import './useTooltipControlled-2044f639.js';
import './IconStyle.styles.css';
import './IconButton-37310d21.js';
import './MessageStyles.styles.css';
import './MessageFormattingUtils-34c9b1aa.js';
import './TransitionGroup-5fd80dc9.js';
import './MessagesContext-76544845.js';
import './HiddenAccessibleStyles.styles.css';
import './ComponentMessageStyles.styles.css';
import './UNSAFE_ComponentMessage/themes/redwood/ComponentMessageBaseTheme.styles.css';
import './UNSAFE_ComponentMessage/themes/redwood/ComponentMessageVariants.css.js';
import './Popup-8889a781.js';
import './UNSAFE_Separator/themes/SeparatorStyles.css.js';
import './UNSAFE_Popup/themes/redwood/PopupBaseTheme.styles.css';
import './UNSAFE_Popup/themes/redwood/PopupVariants.css.js';
import { V as View } from './View-6013acac.js';
import { u as useTextField } from './useTextField-f57cfb8d.js';
import { H as HiddenAccessible } from './HiddenAccessible-61197e7c.js';
import { c as classNames } from './classNames-4e12b00d.js';
import { u as useComponentTheme } from './useComponentTheme-d2f9e47f.js';
import { m as mergeInterpolations } from './mergeInterpolations-e2db2a66.js';
import { LabelledLinkRedwoodTheme } from './UNSAFE_LabelledLink/themes/redwood/LabelledLinkTheme.js';
import './useFormFieldContext-626574fd.js';
import './CompactLabelAssistance-fc9478aa.js';
import './useTooltip-9dec25b3.js';
import './useTranslationBundle-cd815e10.js';
import './CompactHelpSource-548938ff.js';
import './useTabbableMode-a3a351d0.js';
import './useId-03dbfdf0.js';
import './Help-6b4bade1.js';
import './Icon-90c3a630.js';
import './size-782ed57a.js';
import './utils-6eab3a64.js';
import './Common/themes/themeContract.css.js';
import './colorUtils-16eb823f.js';
import './_curry1-25297e59.js';
import './UNSAFE_Icon/themes/IconStyle.css.js';
import './useFocusWithin-30b1e2d8.js';
import './UNSAFE_UserAssistance/themes/UserAssistanceStyles.css.js';
import './UNSAFE_Label/themes/redwood/LabelTheme.js';
import './UNSAFE_Label/themes/LabelStyles.css.js';
import './UNSAFE_Label/themes/redwood/LabelBaseTheme.css.js';
import './vanilla-extract-recipes-createRuntimeFn.esm-2aaf8c98.js';
import './UNSAFE_TextField/themes/redwood/TextFieldTheme.js';
import './UNSAFE_TextField/themes/redwood/TextFieldBaseTheme.css.js';
import './TextFieldVariants.styles.css';
import './usePress-97fc1cf1.js';
import './useInteractionStyle-d65c72b6.js';
import './mergeProps-88ea8306.js';
import './clientHints-c76a913b.js';
import './useHover-d5088fcd.js';
import './useToggle-8b7fcefe.js';
import './useActive-7d9737a5.js';
import './UNSAFE_Link/themes/redwood/LinkTheme.js';
import './UNSAFE_Link/themes/LinkStyles.css.js';
import './LinkStyles.styles.css';
import './UNSAFE_Link/themes/redwood/LinkBaseTheme.css.js';
import './UNSAFE_Link/themes/redwood/LinkBaseTheme.styles.css';
import './UNSAFE_Link/themes/redwood/LinkVariants.css.js';
import './LinkVariants.styles.css';
import './useTestId-adde554c.js';
import './UNSAFE_Text/themes/TextStyles.css.js';
import './TextStyles.styles.css';
import './useTextFieldInputHandlers-fb7c06b4.js';
import './TextFieldUtils-8232bca7.js';
import './UNSAFE_TextField/themes/redwood/TextFieldInputTheme.js';
import './UNSAFE_TextField/themes/TextFieldInputStyles.css.js';
import './TextFieldInputStyles.styles.css';
import './UNSAFE_TextField/themes/redwood/TextFieldInputVariants.css.js';
import './TextFieldInputVariants.styles.css';
import './text.styles.css';
import './vanilla-extract-sprinkles-createRuntimeSprinkles.esm-2d655d37.js';
import './Common/themes/redwood/theme.js';
import './LabelValueLayout-23b74176.js';
import './UNSAFE_RadioItem/themes/redwood/RadioTheme.js';
import './UNSAFE_RadioItem/themes/RadioStyles.css.js';
import './UNSAFE_RadioItem/themes/redwood/RadioBaseTheme.css.js';
import './UNSAFE_TextField/themes/redwood/FormLayoutTheme.js';
import './UNSAFE_TextField/themes/redwood/FormLayoutBaseTheme.css.js';
import './UNSAFE_Checkbox/themes/redwood/CheckboxTheme.js';
import './UNSAFE_Checkbox/themes/CheckboxStyles.css.js';
import './UNSAFE_Checkbox/themes/redwood/CheckboxBaseTheme.css.js';
import './CheckboxVariants.styles.css';
import './UNSAFE_Skeleton/themes/redwood/SkeletonTheme.js';
import './UNSAFE_Skeleton/themes/SkeletonStyles.css.js';
import './UNSAFE_Skeleton/themes/redwood/SkeletonBaseTheme.css.js';
import './UNSAFE_Skeleton/themes/redwood/SkeletonBaseTheme.styles.css';
import './UNSAFE_Skeleton/themes/redwood/SkeletonVariants.css.js';
import './LayoutStyles.css-a679044e.js';
import './LayoutStyles.styles.css';
import './useInputGroupContext-1d19411e.js';
import './useUser-99920e02.js';
import './UNSAFE_TextField/themes/redwood/ReadonlyTextFieldTheme.js';
import './UNSAFE_TextField/themes/ReadonlyTextFieldStyles.css.js';
import './ReadonlyTextFieldStyles.styles.css';
import './UNSAFE_TextField/themes/redwood/ReadonlyTextFieldVariants.css.js';
import './ReadonlyTextFieldVariants.styles.css';
import './boxalignment-486c5ac9.js';
import './arrayUtils-35a58161.js';
import './boxalignment.styles.css';
import './dimensions-5229d942.js';
import './flexbox-529f25da.js';
import './flexbox.styles.css';
import './flexitem-7b7f7920.js';
import './flexitem.styles.css';
import './FlexStyles.styles.css';
import './ComponentMessageContainer-7d9228a3.js';
import './MessagesManager-0d60fea1.js';
import './SuccessS-b342103c.js';
import './ErrorS-e6e7e0e2.js';
import './InformationS-170eee52.js';
import './WarningS-67afbb93.js';
import './PRIVATE_Message/themes/MessageStyles.css.js';
import './soundUtils-88264cb5.js';
import './useAnimation-fe9990dc.js';
import './useMessagesContext-9e1dbe91.js';
import './Transition-f9501682.js';
import './UNSAFE_ComponentMessage/themes/redwood/ComponentMessageTheme.js';
import './UNSAFE_ComponentMessage/themes/ComponentMessageStyles.css.js';
import './UNSAFE_ComponentMessage/themes/redwood/ComponentMessageBaseTheme.css.js';
import './UNSAFE_UserAssistance/themes/redwood/UserAssistanceTheme.js';
import './UNSAFE_UserAssistance/themes/redwood/UserAssistanceBaseTheme.css.js';
import './InlineHelp-95ca55a5.js';
import './InlineHelpSource-b43def76.js';
import './MessageBannerVariants.styles.css';
import './Floating-9703160e.js';
import './useFloating-c99976f8.js';
import './positionUtils-1ec41fd0.js';
import './refUtils-b9d8d91a.js';
import './useOutsideClick-eb8324f6.js';
import './Layer-9b06412e.js';
import './UNSAFE_Layer/themes/LayerStyles.css.js';
import './LayerStyles.styles.css';
import './useThemeInterpolations-9bddc683.js';
import './useColorScheme-e1b17324.js';
import './useScale-d64a1a28.js';
import './theme-63551f30.js';
import './Theme-e6dec6db.js';
import './UNSAFE_Floating/themes/redwood/FloatingTheme.js';
import './UNSAFE_Floating/themes/FloatingStyles.css.js';
import './FloatingStyles.styles.css';
import './UNSAFE_Floating/themes/redwood/FloatingBaseTheme.css.js';
import './UNSAFE_Floating/themes/redwood/FloatingBaseTheme.styles.css';
import './UNSAFE_Floating/themes/redwood/FloatingVariants.css.js';
import './vanilla-extract-dynamic.esm-2955d60a.js';
import './UNSAFE_Floating/themes/FloatingContract.css.js';
import './useFocus-38c95977.js';
import './useTouch-4828df25.js';
import './hooks/UNSAFE_useTooltip/themes/redwood/TooltipContentTheme.js';
import './hooks/UNSAFE_useTooltip/themes/TooltipContentStyles.css.js';
import './TooltipContentStyles.styles.css';
import './hooks/UNSAFE_useTooltip/themes/redwood/TooltipContentBaseTheme.css.js';
import './hooks/UNSAFE_useTooltip/themes/redwood/TooltipContentBaseTheme.styles.css';
import './hooks/UNSAFE_useTooltip/themes/redwood/TooltipContentVariants.css.js';
import './TooltipContentVariants.styles.css';
import './EnvironmentProvider-f543a463.js';
import './LayerManager-625d2503.js';
import './BaseButton-5b2791b1.js';
import './UNSAFE_BaseButton/themes/redwood/BaseButtonTheme.js';
import './UNSAFE_BaseButton/themes/BaseButtonStyles.css.js';
import './BaseButtonStyles.styles.css';
import './UNSAFE_BaseButton/themes/redwood/BaseButtonVariants.css.js';
import './UNSAFE_BaseButton/themes/redwood/BaseButtonBaseTheme.styles.css';
import './ButtonLabelLayout-03cfed16.js';
import './UNSAFE_ButtonLabelLayout/themes/redwood/ButtonLabelLayoutTheme.js';
import './UNSAFE_ButtonLabelLayout/themes/ButtonLabelLayoutStyles.css.js';
import './ButtonLabelLayoutStyles.styles.css';
import './UNSAFE_ButtonLabelLayout/themes/redwood/ButtonLabelLayoutBaseTheme.css.js';
import './UNSAFE_ButtonLabelLayout/themes/redwood/ButtonLabelLayoutBaseTheme.styles.css';
import './UNSAFE_ButtonLabelLayout/themes/redwood/ButtonLabelLayoutVariants.css.js';
import './ButtonLabelLayoutVariants.styles.css';
import './buttonUtils-6f35c4f4.js';
import './id-83adac50.js';
import './getLocale-1c41e86a.js';
import './stringUtils-16f617bc.js';
import './tabbableUtils-dca964ca.js';
import './head-6f17c50c.js';
import './_arity-be492b9e.js';
import './_curry3-0b4222d7.js';
import './_curry2-34316bcf.js';
import './_isArray-694cc52d.js';
import './_isString-675f1de9.js';
import './FocusTrap-8ddd383f.js';
import './FocusTracker-a0621449.js';
import './PRIVATE_FocusTracker/themes/FocusTrackerStyles.css.js';
import './FocusTrackerStyles.styles.css';
import './Modal-6b11d8cb.js';
import './UNSAFE_Modal/themes/ModalStyles.css.js';
import './ModalStyles.styles.css';
import './WindowOverlay-e14f8324.js';
import './UNSAFE_WindowOverlay/themes/WindowOverlayStyles.css.js';
import './WindowOverlayStyles.styles.css';
import './UNSAFE_WindowOverlay/themes/WindowOverlayContract.css.js';
import './UNSAFE_WindowOverlay/themes/redwood/WindowOverlayTheme.js';
import './UNSAFE_WindowOverlay/themes/redwood/WindowOverlayBaseTheme.css.js';
import './UNSAFE_WindowOverlay/themes/redwood/WindowOverlayBaseTheme.styles.css';
import './UNSAFE_WindowOverlay/themes/redwood/WindowOverlayVariants.css.js';
import './usePopupAnimation-4be04290.js';
import './useAnimationStatus-9ef65f0c.js';
import './popupAnimationUtils-d4c27cd1.js';
import './UNSAFE_Popup/themes/PopupContract.css.js';
import './UNSAFE_Popup/themes/redwood/PopupTheme.js';
import './UNSAFE_Popup/themes/redwood/PopupBaseTheme.css.js';
import './PopupStyles.styles.css';
import './SeparatorStyles.styles.css';
import './borders-98a63040.js';
import './colors-aab9ed12.js';
import './padding-01bef196.js';
import './aria-efa0582c.js';
import './useDensity-60cfa748.js';
import './equals-160da165.js';
import './_isObject-1fab0f5b.js';
import './useMessageSeverity-65295e8f.js';
import './useFormFieldContextProps-d07cd618.js';
import './mergeDeepWithKey-08531060.js';
import './UNSAFE_LabelledLink/themes/LabelledLinkStyles.css.js';
import './LabelledLinkStyles.styles.css';
import './UNSAFE_LabelledLink/themes/redwood/LabelledLinkVariants.css.js';
import './LabelledLinkVariants.styles.css';

const HiddenLabel = ({ children, id }) => (jsx(HiddenAccessible, { isHidden: true, children: jsx(Label, { id: id, children: children }) }));

function useLabelledLinkAria({ 'aria-describedby': ariaDescribedBy, baseId, hasEmptyLabel, hasHiddenLabel, labelId: propLabelId }) {
    const containerId = `${baseId}--container`;
    const labelId = propLabelId ?? `${baseId}--hidden-label`;
    // JET-52089: add unsafe API for specifying an external label which is added to ariaLabelledBy on the input or div,
    // only when labelEdge is 'none' and label is ''. Since ariaLabelledBy takes precedence over all other
    // kinds of labels, this helps to ensure we don't override a meaningful label.
    const { UNSAFE_ariaLabelledBy } = useAccessibleContext();
    const ariaLabelledBy = classNames([
        labelId,
        hasEmptyLabel && hasHiddenLabel && UNSAFE_ariaLabelledBy,
        containerId
    ]);
    return {
        containerAria: {
            id: containerId
        },
        hiddenLabelAria: hasHiddenLabel
            ? {
                id: labelId
            }
            : {},
        linkAria: {
            'aria-describedby': ariaDescribedBy,
            'aria-labelledby': ariaLabelledBy
        }
    };
}

function useLabelledLinkTheme({ hasInsideLabel, isFormLayout, isFormReadonly, textAlign }) {
    // Style interpolations for text align
    const interpolations = [...Object.values(textInterpolations)];
    const styleInterpolations = mergeInterpolations(interpolations);
    // Calculate the style interpolation classes
    const { class: styleInterpolationClasses } = styleInterpolations({ textAlign });
    // Calculate the theme classes
    const { classes: themeClasses } = useComponentTheme(LabelledLinkRedwoodTheme, {
        formLayout: isFormLayout ? 'isFormLayout' : 'notFormLayout',
        readonlyForm: isFormReadonly ? 'isReadonlyForm' : 'notReadonlyForm',
        insideLabel: hasInsideLabel ? 'hasInsideLabel' : 'noInsideLabel'
    });
    // merge all the classes
    const classes = classNames([styleInterpolationClasses, themeClasses]);
    return { classes };
}

/**
 * LabelledLink component can be used to render a readonly form control field that
 * has a link for its content.
 */
const LabelledLink = ({ 'aria-describedby': ariaDescribedBy, children, columnSpan, href, label, labelEdge: propLabelEdge, labelStartWidth: propLabelStartWidth, onClick, target, textAlign: propTextAlign, userAssistanceDensity: propUserAssistanceDensity }) => {
    // Consume the form context to get the default values
    const { isFormLayout, isReadonly: isFormReadonly, labelEdge: formLabelEdge, labelStartWidth: formLabelStartWidth, textAlign: formTextAlign, userAssistanceDensity: formUserAssistanceDensity } = useFormContext();
    // default to FormContext values if component properties are not specified
    const labelEdge = propLabelEdge ?? formLabelEdge;
    const labelStartWidth = propLabelStartWidth ?? formLabelStartWidth;
    const textAlign = propTextAlign ?? formTextAlign;
    const userAssistanceDensity = propUserAssistanceDensity ?? formUserAssistanceDensity;
    // We will use the URL as text if the link text is not provided as a child
    const linkText = children ?? href;
    // Calculate the text field related props
    const { baseId, formFieldContext, labelProps, inputProps, userAssistanceProps } = useTextField({
        ariaDescribedBy,
        isReadonly: true,
        labelEdge,
        value: linkText
    });
    // Create the label component and the fieldLabelProps
    const labelComp = jsx(Label, { ...labelProps, children: label });
    const fieldLabelProps = {
        label: labelEdge !== 'none' ? labelComp : undefined,
        labelEdge: labelEdge !== 'none' ? labelEdge : undefined,
        labelStartWidth: labelEdge !== 'none' ? labelStartWidth : undefined
    };
    // save space for user assistance if density is 'efficient', even though we don't
    // render user assistance for readonly fields for now.
    const inlineUserAssistance = userAssistanceDensity === 'efficient' ? (jsx(InlineUserAssistance, { userAssistanceDensity: userAssistanceDensity, ...userAssistanceProps })) : undefined;
    // Get the theme classes
    const { classes } = useLabelledLinkTheme({
        hasInsideLabel: labelEdge === 'inside',
        isFormLayout,
        isFormReadonly,
        textAlign
    });
    // Get the aria props
    const hasEmptyLabel = label === '';
    const hasHiddenLabel = labelEdge === 'none';
    const { containerAria, hiddenLabelAria, linkAria } = useLabelledLinkAria({
        'aria-describedby': inputProps['aria-describedby'],
        baseId,
        hasEmptyLabel,
        hasHiddenLabel,
        labelId: labelProps.id
    });
    return (jsx(FormFieldContext.Provider, { value: formFieldContext, children: jsx(ReadonlyTextField, { columnSpan: columnSpan, role: "presentation", inlineUserAssistance: inlineUserAssistance, ...fieldLabelProps, mainContent: jsxs("div", { class: classes, ...containerAria, children: [hasHiddenLabel && jsx(HiddenLabel, { ...hiddenLabelAria, children: label }), jsx(View, { width: "100%", children: jsx(Link, { href: href, target: target, onClick: onClick, ...linkAria, children: jsx(Text, { size: "md", variant: "inherit", children: linkText }) }) })] }) }) }));
};

export { LabelledLink };
//# sourceMappingURL=UNSAFE_LabelledLink.js.map
