/* @oracle/oraclejet-preact: undefined */
import { jsx, jsxs } from 'preact/jsx-runtime';
import { Fragment } from 'preact';
import { s as sizeToCSS } from './size-782ed57a.js';
import { u as useTooltip } from './useTooltip-9dec25b3.js';
import './useTooltipControlled-2044f639.js';
import { styles } from './UNSAFE_Icon/themes/IconStyle.css.js';

const Icon = ({ size = '1em', color = 'currentColor', accessibleLabel = '', viewBox = 'none', children }) => (jsx(Svg, { height: "1em", width: "1em", viewBox: viewBox, accessibleLabel: accessibleLabel, class: styles[color], style: { fontSize: size === '1em' ? size : `${sizeToCSS(size)}` }, children: children }));
const Svg = ({ accessibleLabel, ...otherProps }) => accessibleLabel ? (jsx(SemanticSvg, { accessibleLabel: accessibleLabel, ...otherProps })) : (jsx(DecorativeSvg, { ...otherProps }));
const DecorativeSvg = (props) => jsx("svg", { ...props });
const SemanticSvg = ({ accessibleLabel, children, ...props }) => {
    // See JET-56791.
    // We want the same effect as specifying a SVG <title> element for showing a tooltip.
    // When <title> is used, the SVG is not keyboard focusable by default, and the tooltip only shows up
    // on mouse hover. Typically any accessibility requirements beyond this should be handled by making the parent
    // element accessible. This was the approved behavior by APO, and is consistent with the behavior of icons
    // from other libraries.
    //
    // We need to use useTooltip for displaying the tooltip, but it appears spreading the onFocus and onBlur event
    // handlers generated by the useTooltip hook onto the <svg> causes it to become keyboard focusable*.
    // To fix this we need to omit spreading the onFocus and onBlur event handlers from the tooltipProps.
    //
    // *Most browsers implement the SVG 1.1 spec. There's also a SVG 1.2 Tiny spec that's not
    // fully implemented in most browsers.
    // The non-draft version of SVG 1.1 doesn't document the focus conditions and behavior AFAICT.
    // However it appears browsers implemented the same behavior as the focusable="auto" behavior as described
    // in SVG 1.2 Tiny: https://www.w3.org/TR/SVGTiny12/interact.html#focus
    // In particular, it states that if the SVG element has focus related event listeners registered on it, then it becomes focusable.
    // The spec mentions focusin and focusout event handlers, but not focus event handlers. The reality is
    // that having a focus event handler registered also causes the <svg> to become focusable (tested on Chrome), and that's
    // probably because a focus event always precedes a focusin event.
    // Note also setting focusable="false", or setting tabindex="-1" on the <svg> to prevent it from becoming focusable
    // doesn't work based on my testing, and that's most probably because the focusable and tabindex attributes are not part
    // of the SVG 1.1 spec.
    const { tooltipContent, tooltipProps: { onFocus, onBlur, ...restTooltipProps } } = useTooltip({
        text: accessibleLabel,
        anchor: {
            x: 'element',
            y: 'element'
        }
    });
    return (jsxs(Fragment, { children: [jsx("svg", { role: "img", ...props, ...restTooltipProps, "aria-label": accessibleLabel, children: children }), tooltipContent] }));
};

export { Icon as I };
//# sourceMappingURL=Icon-90c3a630.js.map
