/* @oracle/oraclejet-preact: undefined */
'use strict';

var hooks = require('preact/hooks');
var LayerHost = require('./LayerHost-46e4d858.js');
require('preact/jsx-runtime');
require('preact/compat');

/**
 * @license
 * Copyright (c) %FIRST_YEAR% %CURRENT_YEAR%, Oracle and/or its affiliates.
 * The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
/**
 * useTranslationBundle is a hook to get a translation bundle from the EnvironmentProvider
 * @param bundleId
 * @returns a translation bundle of type T
 */
function useTranslationBundle(bundleId) {
    const translations = hooks.useContext(LayerHost.EnvironmentContext).translations;
    const bundle = translations?.[bundleId];
    if (!bundle) {
        throw new Error(`Translation bundle ${bundleId} is not loaded.`);
    }
    return bundle;
}

exports.useTranslationBundle = useTranslationBundle;
//# sourceMappingURL=useTranslationBundle-9da032d6.js.map
