/* @oracle/oraclejet-preact: undefined */
'use strict';

function _isPlaceholder(a) {
  return a != null && typeof a === 'object' && a['@@functional/placeholder'] === true;
}

/**
 * Optimized internal one-arity curry function.
 *
 * @private
 * @category Function
 * @param {Function} fn The function to curry.
 * @return {Function} The curried function.
 */

function _curry1(fn) {
  return function f1(a) {
    if (arguments.length === 0 || _isPlaceholder(a)) {
      return f1;
    } else {
      return fn.apply(this, arguments);
    }
  };
}

exports._curry1 = _curry1;
exports._isPlaceholder = _isPlaceholder;
//# sourceMappingURL=_curry1-e8f0d7ea.js.map
