/* @oracle/oraclejet-preact: undefined */
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var jsxRuntime = require('preact/jsx-runtime');
var preact = require('preact');
var hooks = require('preact/hooks');
var classNames = require('./classNames-c14c6ef3.js');
var TabBar = require('./TabBar-e77706d0.js');
var UNSAFE_OverflowTabBar_themes_OverflowTabBarStyles_css = require('./UNSAFE_OverflowTabBar/themes/OverflowTabBarStyles.css.js');
var useDetectHorizontalOverflow = require('./useDetectHorizontalOverflow-5802c78d.js');
var collectionUtils = require('./collectionUtils-1535080e.js');
var RemovableTabBarItem = require('./RemovableTabBarItem-df8144f5.js');
var TabBarItem = require('./TabBarItem-2b3039aa.js');
var OverflowTabBarItem = require('./OverflowTabBarItem-1de46588.js');
require('./LayerHost-46e4d858.js');
require('./Common/themes/redwood/theme.js');
require('./Common/themes/themeContract.css.js');
require('preact/compat');
require('./UNSAFE_Text/themes/TextStyles.css.js');

require('./vanilla-extract-recipes-createRuntimeFn.esm-d1301b2d.js');
require('./Flex-fbba4ad6.js');
require('./useTestId-8234ec1e.js');
require('./boxalignment-5ef612ee.js');
require('./size-4e606ce4.js');
require('./utils-b7099be5.js');
require('./colorUtils-fe6f2fbf.js');
require('./_curry1-e8f0d7ea.js');
require('./arrayUtils-7d8dcfc3.js');

require('./vanilla-extract-sprinkles-createRuntimeSprinkles.esm-d68f3e0f.js');
require('./dimensions-b48bf1ab.js');
require('./flexbox-2cae9a01.js');

require('./flexitem-fee13e26.js');

require('./mergeInterpolations-6727b536.js');
require('./mergeDeepWithKey-210b024d.js');
require('./_curry3-18677bca.js');
require('./_curry2-c15d89cd.js');
require('./_isObject-28636267.js');

require('./useTabBarContext-2a6a796c.js');
require('./logger-2b636482.js');


require('./UNSAFE_TabBarCommon/themes/redwood/TabBarItemVariants.css.js');

require('./ConveyorBeltContext-bfe84b44.js');
require('./useTooltipControlled-706a3651.js');
require('./useId-6c0eeb27.js');
require('./Floating-1280c2ce.js');
require('./useFloating-7800fd56.js');
require('./useUser-a6d15333.js');
require('./positionUtils-ae9279d7.js');
require('./refUtils-915b985d.js');
require('./useOutsideClick-7420644b.js');
require('./Layer-3700cd37.js');
require('./UNSAFE_Layer/themes/LayerStyles.css.js');

require('./useThemeInterpolations-25313f34.js');
require('./useColorScheme-d2c4adcc.js');
require('./useScale-74bd6456.js');
require('./theme-dfd6a9fe.js');
require('./Theme-f06687af.js');
require('./useComponentTheme-082fc8e4.js');
require('./UNSAFE_Floating/themes/redwood/FloatingTheme.js');
require('./UNSAFE_Floating/themes/FloatingStyles.css.js');

require('./UNSAFE_Floating/themes/redwood/FloatingBaseTheme.css.js');

require('./UNSAFE_Floating/themes/redwood/FloatingVariants.css.js');
require('./vanilla-extract-dynamic.esm-d5dffce7.js');
require('./UNSAFE_Floating/themes/FloatingContract.css.js');
require('./useHover-910b8e32.js');
require('./useToggle-3ebba7d8.js');
require('./useFocus-1b288fb9.js');
require('./useTouch-4dec8729.js');
require('./mergeProps-e3da7237.js');
require('./useAnimation-2f7dd313.js');
require('./hooks/UNSAFE_useTooltip/themes/redwood/TooltipContentTheme.js');
require('./hooks/UNSAFE_useTooltip/themes/TooltipContentStyles.css.js');

require('./hooks/UNSAFE_useTooltip/themes/redwood/TooltipContentBaseTheme.css.js');

require('./hooks/UNSAFE_useTooltip/themes/redwood/TooltipContentVariants.css.js');

require('./EnvironmentProvider-42b2b998.js');
require('./LayerManager-fa20a462.js');

require('./NavigationList-5218562e.js');
require('./UNSAFE_NavigationList/themes/NavigationListStyles.css.js');

require('./useCollectionFocusRing-ca37785b.js');
require('./useCurrentKey-3b4c8a44.js');
require('./keys-a4b54295.js');
require('./useNavigationListItem-74009187.js');
require('./usePress-00deca01.js');
require('./useInteractionStyle-442c6a12.js');
require('./clientHints-9e411b6e.js');
require('./useActive-b15c9e7e.js');
require('./UNSAFE_NavigationListCommon/themes/redwood/NavigationListItemTheme.js');
require('./UNSAFE_NavigationList/themes/NavigationListItemStyles.css.js');

require('./UNSAFE_NavigationList/themes/redwood/NavigationListItemBaseTheme.css.js');

require('./UNSAFE_NavigationList/themes/redwood/NavigationListItemVariants.css.js');

require('./keyboardUtils-f835e1ee.js');
require('./tabbableUtils-b49673af.js');
require('./head-68d0992f.js');
require('./_arity-c228159c.js');
require('./_isArray-73160ad5.js');
require('./_isString-f4443c9e.js');

require('./Sheet-a6267b5f.js');
require('./Modal-52fa4530.js');
require('./UNSAFE_Modal/themes/ModalStyles.css.js');

require('./WindowOverlay-d255542f.js');
require('./UNSAFE_WindowOverlay/themes/WindowOverlayStyles.css.js');

require('./UNSAFE_WindowOverlay/themes/WindowOverlayContract.css.js');
require('./UNSAFE_WindowOverlay/themes/redwood/WindowOverlayTheme.js');
require('./UNSAFE_WindowOverlay/themes/redwood/WindowOverlayBaseTheme.css.js');

require('./UNSAFE_WindowOverlay/themes/redwood/WindowOverlayVariants.css.js');
require('./UNSAFE_Sheet/themes/SheetStyles.css.js');

require('./useAnimationStatus-a3d51709.js');
require('./animationUtils-54852d03.js');

require('./TabBarLayout-c2efbeb3.js');
require('./UNSAFE_TabBar/themes/TabBarStyles.css.js');

require('./useTabBar-35edcdb1.js');

require('./Close-2adc0f0f.js');
require('./Icon-3ffd13dc.js');
require('./useTooltip-468c1c92.js');
require('./UNSAFE_Icon/themes/IconStyle.css.js');
require('./useTranslationBundle-9da032d6.js');
require('./EmbeddedIconButton-cadadca0.js');
require('./BaseButton-ff6f39f2.js');
require('./TabbableModeContext-e99d527e.js');
require('./useTabbableMode-5c8fd9e5.js');
require('./UNSAFE_BaseButton/themes/redwood/BaseButtonTheme.js');
require('./UNSAFE_BaseButton/themes/BaseButtonStyles.css.js');

require('./UNSAFE_BaseButton/themes/redwood/BaseButtonVariants.css.js');

require('./ButtonLabelLayout-3399b9e1.js');
require('./Text-aaacb6a0.js');
require('./UNSAFE_ButtonLabelLayout/themes/redwood/ButtonLabelLayoutTheme.js');
require('./UNSAFE_ButtonLabelLayout/themes/ButtonLabelLayoutStyles.css.js');

require('./UNSAFE_ButtonLabelLayout/themes/redwood/ButtonLabelLayoutBaseTheme.css.js');

require('./UNSAFE_ButtonLabelLayout/themes/redwood/ButtonLabelLayoutVariants.css.js');

require('./UNSAFE_TabBarCommon/themes/redwood/TabBarItemTheme.js');
require('./UNSAFE_TabBarCommon/themes/TabBarItemStyles.css.js');
require('./UNSAFE_TabBarCommon/themes/redwood/TabBarItemBaseTheme.css.js');
require('./useConveyorBeltItem-eb851d33.js');
require('./WarningS-d9a02d39.js');
require('./ErrorS-bfe081e3.js');
require('./InformationS-5bf32f4c.js');
require('./SuccessS-862e9e4b.js');
require('./UNSAFE_TabBarCommon/themes/TabBarItemContract.css.js');
require('./Badge-0e522f12.js');
require('./UNSAFE_Badge/themes/redwood/BadgeTheme.js');
require('./UNSAFE_Badge/themes/BadgeStyles.css.js');

require('./UNSAFE_Badge/themes/redwood/BadgeThemeBaseTheme.css.js');

require('./UNSAFE_Badge/themes/redwood/BadgeVariants.css.js');

require('./NavigationListItem-b80c41dc.js');
require('./BaseNavigationListItem-175a3f35.js');
require('./Dropdown-820dc3fe.js');
require('./usePopupAnimation-78a173e8.js');
require('./popupAnimationUtils-a3dfbdfd.js');
require('./UNSAFE_Dropdown/themes/dropdownStyles.css.js');
require('./useOutsideMousedown-a8c09ad9.js');
require('./UNSAFE_TabBarCommon/themes/OverflowTabBarItemStyles.css.js');
require('./RemovableNavigationListItem-eb2c8156.js');

/**
 * OverflowTabBar handles the rendering of overflowing tab items.
 */
function OverflowTabBar({ items, layout = 'stretch', display = 'standard', size = 'md', edge = 'top', selection, onSelect, onRemove, 'aria-label': ariaLabel, 'aria-labelledby': ariaLabelledby, testId }) {
    const displayStackProps = {
        display: display
    };
    const displayNonStackProps = {
        display: display,
        size: size
    };
    const itemSelector = '[role="tab"]';
    const displayProps = display === 'stacked' ? displayStackProps : displayNonStackProps;
    const rootRef = hooks.useRef(null);
    const tabBarRef = preact.createRef();
    const [isDropDownOpen, setIsDropDownOpen] = hooks.useState(false);
    const isOutsideMouseDown = hooks.useRef(false);
    const handleClose = (e) => {
        if (tabBarRef.current && ['itemAction', 'dismissed'].includes(e.reason)) {
            tabBarRef?.current?.focus();
        }
        if (e.reason === 'outsideMousedown') {
            isOutsideMouseDown.current = true;
        }
        setIsDropDownOpen(false);
    };
    const handleSelect = hooks.useCallback((e) => {
        if (e.value === 'more') {
            //If overflow item is clicked after dropdown is open, the reason is outsideMouseDown and it needs to be closed
            if (isOutsideMouseDown.current) {
                setIsDropDownOpen(false);
            }
            else {
                setIsDropDownOpen(true);
            }
        }
        else {
            onSelect?.(e);
        }
        isOutsideMouseDown.current = false;
    }, [onSelect]);
    const overflowItemKey = 'more';
    const keysArray = hooks.useMemo(() => items.map((item) => item.itemKey), [items]);
    const getWidth = hooks.useCallback((itemKey) => {
        const elem = collectionUtils.findElementByKey(rootRef.current, itemKey, itemSelector);
        const gapBetweenItems = 32;
        return elem ? elem.getBoundingClientRect().width + gapBetweenItems : 0;
    }, []);
    const { visibleItemKeys, overflowItemKeys } = useDetectHorizontalOverflow.useDetectHorizontalOverflow({
        rootRef,
        getWidth,
        keysArray
    });
    const overflowTabBarClass = classNames.classNames([UNSAFE_OverflowTabBar_themes_OverflowTabBarStyles_css.styles.overflowTabBarBase]);
    return (jsxRuntime.jsx("div", { ref: rootRef, class: overflowTabBarClass, children: jsxRuntime.jsxs(TabBar.TabBar, { ref: tabBarRef, selection: selection, onSelect: handleSelect, ...displayProps, layout: layout, edge: edge, onRemove: onRemove, "aria-label": ariaLabel, "aria-labelledby": ariaLabelledby, testId: testId, children: [visibleItemKeys != null &&
                    visibleItemKeys.length > 0 &&
                    items
                        .filter((item) => visibleItemKeys?.includes(item.itemKey))
                        .map((item) => item.isRemovable ? (jsxRuntime.jsx(RemovableTabBarItem.RemovableTabBarItem, { itemKey: item.itemKey, label: item.label, icon: item.icon, badge: item.badge, metadata: item.metadata, severity: item.severity, "aria-controls": item.tabPanelId })) : (jsxRuntime.jsx(TabBarItem.TabBarItem, { itemKey: item.itemKey, label: item.label, icon: item.icon, badge: item.badge, metadata: item.metadata, severity: item.severity, "aria-controls": item.tabPanelId }))), overflowItemKeys != null && overflowItemKeys.length > 0 && (jsxRuntime.jsx(OverflowTabBarItem.OverflowTabBarItem, { isOpen: isDropDownOpen, onClose: handleClose, overflowItemKey: overflowItemKey, overflowItems: items.filter((item) => overflowItemKeys.includes(item.itemKey)) }))] }) }));
}

exports.OverflowTabBar = OverflowTabBar;
//# sourceMappingURL=UNSAFE_OverflowTabBar.js.map
