/* @oracle/oraclejet-preact: undefined */
'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var jsxRuntime = require('preact/jsx-runtime');
var Label = require('./Label-d9ad059f.js');
var Link = require('./Link-98de6624.js');
var Text = require('./Text-aaacb6a0.js');
require('preact/hooks');
require('preact/compat');
require('./TextFieldInput-4904c227.js');

var useAccessibleContext = require('./useAccessibleContext-c49d8d1b.js');
require('./FormContext-9452bd30.js');
var useFormContext = require('./useFormContext-4c3091dc.js');
require('./TabbableModeContext-e99d527e.js');
var textAlign = require('./textAlign-f41f49db.js');
var FormFieldContext = require('./FormFieldContext-8418dc68.js');
require('./logger-2b636482.js');

require('./UNSAFE_TextField/themes/redwood/ReadonlyTextFieldInputVariants.css.js');
require('./LayerHost-46e4d858.js');
var StyledTextField = require('./StyledTextField-351ea57e.js');
require('./Flex-fbba4ad6.js');

require('./UNSAFE_TextField/themes/TextFieldStyles.css.js');




require('./UNSAFE_TextField/themes/redwood/TextFieldVariants.css.js');


require('./UNSAFE_RadioItem/themes/redwood/RadioVariants.css.js');


require('./UNSAFE_Label/themes/redwood/LabelVariants.css.js');
require('./UNSAFE_TextField/themes/FormLayoutStyles.css.js');



require('./UNSAFE_Checkbox/themes/redwood/CheckboxVariants.css.js');
require('./InputGroupContext-05f2a46f.js');



require('./UNSAFE_UserAssistance/themes/redwood/UserAssistanceVariants.css.js');
var InlineUserAssistance = require('./InlineUserAssistance-ad3fa8cc.js');


require('./UNSAFE_MessageBanner/themes/redwood/MessageBannerVariants.css.js');
require('preact');
require('./useTooltipControlled-706a3651.js');

require('./IconButton-94f8ca5c.js');

require('./MessageFormattingUtils-42d84399.js');
require('./TransitionGroup-b239d98f.js');
require('./MessagesContext-4e939750.js');



require('./UNSAFE_ComponentMessage/themes/redwood/ComponentMessageVariants.css.js');
require('./Popup-881aae20.js');
require('./UNSAFE_Separator/themes/SeparatorStyles.css.js');

require('./UNSAFE_Popup/themes/redwood/PopupVariants.css.js');
var View = require('./View-011404a7.js');
var useTextField = require('./useTextField-3ce8f0d0.js');
var HiddenAccessible = require('./HiddenAccessible-087eb49a.js');
var classNames = require('./classNames-c14c6ef3.js');
var useComponentTheme = require('./useComponentTheme-082fc8e4.js');
var mergeInterpolations = require('./mergeInterpolations-6727b536.js');
var UNSAFE_LabelledLink_themes_redwood_LabelledLinkTheme = require('./UNSAFE_LabelledLink/themes/redwood/LabelledLinkTheme.js');
require('./useFormFieldContext-20f419ef.js');
require('./CompactLabelAssistance-ae678fbd.js');
require('./useTooltip-468c1c92.js');
require('./useTranslationBundle-9da032d6.js');
require('./CompactHelpSource-f4e9198b.js');
require('./useTabbableMode-5c8fd9e5.js');
require('./useId-6c0eeb27.js');
require('./Help-23015ba0.js');
require('./Icon-3ffd13dc.js');
require('./size-4e606ce4.js');
require('./utils-b7099be5.js');
require('./Common/themes/themeContract.css.js');
require('./colorUtils-fe6f2fbf.js');
require('./_curry1-e8f0d7ea.js');
require('./UNSAFE_Icon/themes/IconStyle.css.js');
require('./useFocusWithin-eb7f956a.js');
require('./UNSAFE_UserAssistance/themes/UserAssistanceStyles.css.js');
require('./UNSAFE_Label/themes/redwood/LabelTheme.js');
require('./UNSAFE_Label/themes/LabelStyles.css.js');
require('./UNSAFE_Label/themes/redwood/LabelBaseTheme.css.js');
require('./vanilla-extract-recipes-createRuntimeFn.esm-d1301b2d.js');
require('./UNSAFE_TextField/themes/redwood/TextFieldTheme.js');
require('./UNSAFE_TextField/themes/redwood/TextFieldBaseTheme.css.js');

require('./usePress-00deca01.js');
require('./useInteractionStyle-442c6a12.js');
require('./mergeProps-e3da7237.js');
require('./clientHints-9e411b6e.js');
require('./useHover-910b8e32.js');
require('./useToggle-3ebba7d8.js');
require('./useActive-b15c9e7e.js');
require('./UNSAFE_Link/themes/redwood/LinkTheme.js');
require('./UNSAFE_Link/themes/LinkStyles.css.js');

require('./UNSAFE_Link/themes/redwood/LinkBaseTheme.css.js');

require('./UNSAFE_Link/themes/redwood/LinkVariants.css.js');

require('./useTestId-8234ec1e.js');
require('./UNSAFE_Text/themes/TextStyles.css.js');

require('./useTextFieldInputHandlers-7d653f39.js');
require('./TextFieldUtils-96baac38.js');
require('./UNSAFE_TextField/themes/redwood/TextFieldInputTheme.js');
require('./UNSAFE_TextField/themes/TextFieldInputStyles.css.js');

require('./UNSAFE_TextField/themes/redwood/TextFieldInputVariants.css.js');


require('./vanilla-extract-sprinkles-createRuntimeSprinkles.esm-d68f3e0f.js');
require('./Common/themes/redwood/theme.js');
require('./LabelValueLayout-24937fa5.js');
require('./UNSAFE_RadioItem/themes/redwood/RadioTheme.js');
require('./UNSAFE_RadioItem/themes/RadioStyles.css.js');
require('./UNSAFE_RadioItem/themes/redwood/RadioBaseTheme.css.js');
require('./UNSAFE_TextField/themes/redwood/FormLayoutTheme.js');
require('./UNSAFE_TextField/themes/redwood/FormLayoutBaseTheme.css.js');
require('./UNSAFE_Checkbox/themes/redwood/CheckboxTheme.js');
require('./UNSAFE_Checkbox/themes/CheckboxStyles.css.js');
require('./UNSAFE_Checkbox/themes/redwood/CheckboxBaseTheme.css.js');

require('./UNSAFE_Skeleton/themes/redwood/SkeletonTheme.js');
require('./UNSAFE_Skeleton/themes/SkeletonStyles.css.js');
require('./UNSAFE_Skeleton/themes/redwood/SkeletonBaseTheme.css.js');

require('./UNSAFE_Skeleton/themes/redwood/SkeletonVariants.css.js');
require('./LayoutStyles.css-8af668b9.js');

require('./useInputGroupContext-4c10bd57.js');
require('./useUser-a6d15333.js');
require('./UNSAFE_TextField/themes/redwood/ReadonlyTextFieldTheme.js');
require('./UNSAFE_TextField/themes/ReadonlyTextFieldStyles.css.js');

require('./UNSAFE_TextField/themes/redwood/ReadonlyTextFieldVariants.css.js');

require('./boxalignment-5ef612ee.js');
require('./arrayUtils-7d8dcfc3.js');

require('./dimensions-b48bf1ab.js');
require('./flexbox-2cae9a01.js');

require('./flexitem-fee13e26.js');


require('./ComponentMessageContainer-a9195577.js');
require('./MessagesManager-9cc43d3a.js');
require('./SuccessS-862e9e4b.js');
require('./ErrorS-bfe081e3.js');
require('./InformationS-5bf32f4c.js');
require('./WarningS-d18b9e00.js');
require('./PRIVATE_Message/themes/MessageStyles.css.js');
require('./soundUtils-ff3c9c0d.js');
require('./useAnimation-2f7dd313.js');
require('./useMessagesContext-23d62331.js');
require('./Transition-942950ed.js');
require('./UNSAFE_ComponentMessage/themes/redwood/ComponentMessageTheme.js');
require('./UNSAFE_ComponentMessage/themes/ComponentMessageStyles.css.js');
require('./UNSAFE_ComponentMessage/themes/redwood/ComponentMessageBaseTheme.css.js');
require('./UNSAFE_UserAssistance/themes/redwood/UserAssistanceTheme.js');
require('./UNSAFE_UserAssistance/themes/redwood/UserAssistanceBaseTheme.css.js');
require('./InlineHelp-020ee2df.js');
require('./InlineHelpSource-7b793104.js');

require('./Floating-1280c2ce.js');
require('./useFloating-7800fd56.js');
require('./positionUtils-ae9279d7.js');
require('./refUtils-915b985d.js');
require('./useOutsideClick-7420644b.js');
require('./Layer-3700cd37.js');
require('./UNSAFE_Layer/themes/LayerStyles.css.js');

require('./useThemeInterpolations-25313f34.js');
require('./useColorScheme-d2c4adcc.js');
require('./useScale-74bd6456.js');
require('./theme-dfd6a9fe.js');
require('./Theme-f06687af.js');
require('./UNSAFE_Floating/themes/redwood/FloatingTheme.js');
require('./UNSAFE_Floating/themes/FloatingStyles.css.js');

require('./UNSAFE_Floating/themes/redwood/FloatingBaseTheme.css.js');

require('./UNSAFE_Floating/themes/redwood/FloatingVariants.css.js');
require('./vanilla-extract-dynamic.esm-d5dffce7.js');
require('./UNSAFE_Floating/themes/FloatingContract.css.js');
require('./useFocus-1b288fb9.js');
require('./useTouch-4dec8729.js');
require('./hooks/UNSAFE_useTooltip/themes/redwood/TooltipContentTheme.js');
require('./hooks/UNSAFE_useTooltip/themes/TooltipContentStyles.css.js');

require('./hooks/UNSAFE_useTooltip/themes/redwood/TooltipContentBaseTheme.css.js');

require('./hooks/UNSAFE_useTooltip/themes/redwood/TooltipContentVariants.css.js');

require('./EnvironmentProvider-42b2b998.js');
require('./LayerManager-fa20a462.js');
require('./BaseButton-ff6f39f2.js');
require('./UNSAFE_BaseButton/themes/redwood/BaseButtonTheme.js');
require('./UNSAFE_BaseButton/themes/BaseButtonStyles.css.js');

require('./UNSAFE_BaseButton/themes/redwood/BaseButtonVariants.css.js');

require('./ButtonLabelLayout-3399b9e1.js');
require('./UNSAFE_ButtonLabelLayout/themes/redwood/ButtonLabelLayoutTheme.js');
require('./UNSAFE_ButtonLabelLayout/themes/ButtonLabelLayoutStyles.css.js');

require('./UNSAFE_ButtonLabelLayout/themes/redwood/ButtonLabelLayoutBaseTheme.css.js');

require('./UNSAFE_ButtonLabelLayout/themes/redwood/ButtonLabelLayoutVariants.css.js');

require('./buttonUtils-252661e7.js');
require('./id-86356250.js');
require('./getLocale-8e17dc46.js');
require('./stringUtils-4e4a6b2b.js');
require('./tabbableUtils-b49673af.js');
require('./head-68d0992f.js');
require('./_arity-c228159c.js');
require('./_curry3-18677bca.js');
require('./_curry2-c15d89cd.js');
require('./_isArray-73160ad5.js');
require('./_isString-f4443c9e.js');
require('./FocusTrap-0a03f5a2.js');
require('./FocusTracker-9cc329a3.js');
require('./PRIVATE_FocusTracker/themes/FocusTrackerStyles.css.js');

require('./Modal-52fa4530.js');
require('./UNSAFE_Modal/themes/ModalStyles.css.js');

require('./WindowOverlay-d255542f.js');
require('./UNSAFE_WindowOverlay/themes/WindowOverlayStyles.css.js');

require('./UNSAFE_WindowOverlay/themes/WindowOverlayContract.css.js');
require('./UNSAFE_WindowOverlay/themes/redwood/WindowOverlayTheme.js');
require('./UNSAFE_WindowOverlay/themes/redwood/WindowOverlayBaseTheme.css.js');

require('./UNSAFE_WindowOverlay/themes/redwood/WindowOverlayVariants.css.js');
require('./usePopupAnimation-78a173e8.js');
require('./useAnimationStatus-a3d51709.js');
require('./popupAnimationUtils-a3dfbdfd.js');
require('./UNSAFE_Popup/themes/PopupContract.css.js');
require('./UNSAFE_Popup/themes/redwood/PopupTheme.js');
require('./UNSAFE_Popup/themes/redwood/PopupBaseTheme.css.js');


require('./borders-4b8488cb.js');
require('./colors-ac3041c6.js');
require('./padding-b9ee87ac.js');
require('./aria-889aedd0.js');
require('./useDensity-6e80ddff.js');
require('./equals-098f7781.js');
require('./_isObject-28636267.js');
require('./useMessageSeverity-cfc4ae9d.js');
require('./useFormFieldContextProps-8c04ed0f.js');
require('./mergeDeepWithKey-210b024d.js');
require('./UNSAFE_LabelledLink/themes/LabelledLinkStyles.css.js');

require('./UNSAFE_LabelledLink/themes/redwood/LabelledLinkVariants.css.js');


const HiddenLabel = ({ children, id }) => (jsxRuntime.jsx(HiddenAccessible.HiddenAccessible, { isHidden: true, children: jsxRuntime.jsx(Label.Label, { id: id, children: children }) }));

function useLabelledLinkAria({ 'aria-describedby': ariaDescribedBy, baseId, hasEmptyLabel, hasHiddenLabel, labelId: propLabelId }) {
    const containerId = `${baseId}--container`;
    const labelId = propLabelId ?? `${baseId}--hidden-label`;
    // JET-52089: add unsafe API for specifying an external label which is added to ariaLabelledBy on the input or div,
    // only when labelEdge is 'none' and label is ''. Since ariaLabelledBy takes precedence over all other
    // kinds of labels, this helps to ensure we don't override a meaningful label.
    const { UNSAFE_ariaLabelledBy } = useAccessibleContext.useAccessibleContext();
    const ariaLabelledBy = classNames.classNames([
        labelId,
        hasEmptyLabel && hasHiddenLabel && UNSAFE_ariaLabelledBy,
        containerId
    ]);
    return {
        containerAria: {
            id: containerId
        },
        hiddenLabelAria: hasHiddenLabel
            ? {
                id: labelId
            }
            : {},
        linkAria: {
            'aria-describedby': ariaDescribedBy,
            'aria-labelledby': ariaLabelledBy
        }
    };
}

function useLabelledLinkTheme({ hasInsideLabel, isFormLayout, isFormReadonly, textAlign: textAlign$1 }) {
    // Style interpolations for text align
    const interpolations = [...Object.values(textAlign.textInterpolations)];
    const styleInterpolations = mergeInterpolations.mergeInterpolations(interpolations);
    // Calculate the style interpolation classes
    const { class: styleInterpolationClasses } = styleInterpolations({ textAlign: textAlign$1 });
    // Calculate the theme classes
    const { classes: themeClasses } = useComponentTheme.useComponentTheme(UNSAFE_LabelledLink_themes_redwood_LabelledLinkTheme.LabelledLinkRedwoodTheme, {
        formLayout: isFormLayout ? 'isFormLayout' : 'notFormLayout',
        readonlyForm: isFormReadonly ? 'isReadonlyForm' : 'notReadonlyForm',
        insideLabel: hasInsideLabel ? 'hasInsideLabel' : 'noInsideLabel'
    });
    // merge all the classes
    const classes = classNames.classNames([styleInterpolationClasses, themeClasses]);
    return { classes };
}

/**
 * LabelledLink component can be used to render a readonly form control field that
 * has a link for its content.
 */
const LabelledLink = ({ 'aria-describedby': ariaDescribedBy, children, columnSpan, href, label, labelEdge: propLabelEdge, labelStartWidth: propLabelStartWidth, onClick, target, textAlign: propTextAlign, userAssistanceDensity: propUserAssistanceDensity }) => {
    // Consume the form context to get the default values
    const { isFormLayout, isReadonly: isFormReadonly, labelEdge: formLabelEdge, labelStartWidth: formLabelStartWidth, textAlign: formTextAlign, userAssistanceDensity: formUserAssistanceDensity } = useFormContext.useFormContext();
    // default to FormContext values if component properties are not specified
    const labelEdge = propLabelEdge ?? formLabelEdge;
    const labelStartWidth = propLabelStartWidth ?? formLabelStartWidth;
    const textAlign = propTextAlign ?? formTextAlign;
    const userAssistanceDensity = propUserAssistanceDensity ?? formUserAssistanceDensity;
    // We will use the URL as text if the link text is not provided as a child
    const linkText = children ?? href;
    // Calculate the text field related props
    const { baseId, formFieldContext, labelProps, inputProps, userAssistanceProps } = useTextField.useTextField({
        ariaDescribedBy,
        isReadonly: true,
        labelEdge,
        value: linkText
    });
    // Create the label component and the fieldLabelProps
    const labelComp = jsxRuntime.jsx(Label.Label, { ...labelProps, children: label });
    const fieldLabelProps = {
        label: labelEdge !== 'none' ? labelComp : undefined,
        labelEdge: labelEdge !== 'none' ? labelEdge : undefined,
        labelStartWidth: labelEdge !== 'none' ? labelStartWidth : undefined
    };
    // save space for user assistance if density is 'efficient', even though we don't
    // render user assistance for readonly fields for now.
    const inlineUserAssistance = userAssistanceDensity === 'efficient' ? (jsxRuntime.jsx(InlineUserAssistance.InlineUserAssistance, { userAssistanceDensity: userAssistanceDensity, ...userAssistanceProps })) : undefined;
    // Get the theme classes
    const { classes } = useLabelledLinkTheme({
        hasInsideLabel: labelEdge === 'inside',
        isFormLayout,
        isFormReadonly,
        textAlign
    });
    // Get the aria props
    const hasEmptyLabel = label === '';
    const hasHiddenLabel = labelEdge === 'none';
    const { containerAria, hiddenLabelAria, linkAria } = useLabelledLinkAria({
        'aria-describedby': inputProps['aria-describedby'],
        baseId,
        hasEmptyLabel,
        hasHiddenLabel,
        labelId: labelProps.id
    });
    return (jsxRuntime.jsx(FormFieldContext.FormFieldContext.Provider, { value: formFieldContext, children: jsxRuntime.jsx(StyledTextField.ReadonlyTextField, { columnSpan: columnSpan, role: "presentation", inlineUserAssistance: inlineUserAssistance, ...fieldLabelProps, mainContent: jsxRuntime.jsxs("div", { class: classes, ...containerAria, children: [hasHiddenLabel && jsxRuntime.jsx(HiddenLabel, { ...hiddenLabelAria, children: label }), jsxRuntime.jsx(View.View, { width: "100%", children: jsxRuntime.jsx(Link.Link, { href: href, target: target, onClick: onClick, ...linkAria, children: jsxRuntime.jsx(Text.Text, { size: "md", variant: "inherit", children: linkText }) }) })] }) }) }));
};

exports.LabelledLink = LabelledLink;
//# sourceMappingURL=UNSAFE_LabelledLink.js.map
