/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","preact/jsx-runtime","preact","ojs/ojvcomponent","ojs/ojcore-base","ojs/ojdatacollection-common","ojs/ojanimation","ojs/ojthemeutils","ojs/ojtranslation","ojs/ojcontext","ojs/ojlogger","ojs/ojvcollection","ojs/ojdomutils"],function(t,e,s,i,o,n,l,r,a,h,c,d,u){"use strict";o=o&&Object.prototype.hasOwnProperty.call(o,"default")?o.default:o,h=h&&Object.prototype.hasOwnProperty.call(h,"default")?h.default:h;class m{constructor(t,e,s,i,o){this.dataProvider=t,this.fullWidth=e,this.gutterWidth=s,this.itemWidth=i,this.cache=o,this.columns=0,this.margin=0,this.columnsInfo=[],this.bottom=0,this.keys=[],t&&(this.modelEventHandler=this._handleModelEvent.bind(this),t.addEventListener("mutate",this.modelEventHandler)),null==this.cache&&(this.cache=new Map)}destroy(){this.dataProvider&&this.modelEventHandler&&this.dataProvider.removeEventListener("mutate",this.modelEventHandler)}_initializeColumnsInfo(){this.columns=Math.max(1,Math.floor(this.fullWidth/(this.itemWidth+this.gutterWidth))),this.margin=Math.max(this.gutterWidth,(this.fullWidth-this.columns*(this.itemWidth+this.gutterWidth))/2),this.columnsInfo.length=this.columns;for(let t=0;t<this.columns;t++)this.columnsInfo[t]=0}_populatePositions(t,e,s,i,o,n){for(let l=0;l<t.length;l++){const r=s(t[l]);if(null==r)continue;const a=l+e,h=a%this.columnsInfo.length;let c;const d=this.cache.get(r);if(d&&!isNaN(d.height)){if(c=d.height,!1!==d.valid&&!isNaN(d.top)&&!isNaN(d.left)){i(a,r,h,d);continue}}else c=o(t[l]);if(isNaN(c))return;let u,m=this.margin;if(a<this.columnsInfo.length)m+=h*(this.itemWidth+this.gutterWidth),u={top:this.gutterWidth,left:m,height:c,valid:!0},this.columnsInfo[h]=c+2*this.gutterWidth,this.bottom=Math.max(this.bottom,c);else{const t=this.columnsInfo.reduce((t,e)=>Math.min(t,e)),e=this.columnsInfo.indexOf(t);m+=e*(this.itemWidth+this.gutterWidth),u={top:t,left:m,height:c,valid:!0},this.columnsInfo[e]=this.columnsInfo[e]+c+this.gutterWidth,this.bottom=Math.max(this.bottom,t+c)}u&&(-1===this.keys.indexOf(r)&&this.keys.push(r),this.cache.set(r,u),n&&n(r,u))}}setWidth(t){this.fullWidth!==t&&(this.fullWidth=t,this.columnsInfo.length>0&&(this._initializeColumnsInfo(),this._invalidatePositions(0)))}getPositionForItems(t,e){const s=new Map;null==this.itemWidth&&t.length>0&&(this.itemWidth=t[0].element.offsetWidth),0===this.columnsInfo.length&&this._initializeColumnsInfo(),this._populatePositions(t,e,t=>t.key,(t,e,i,o)=>{s.set(e,o)},t=>t.element.offsetHeight,(t,e)=>{s.set(t,e)});let i=0;const o=new Set,n=Array.from(s.values());for(const t of n){const e=t.left;if(!o.has(e)&&(o.add(e),i=Math.max(i,t.top),o.size===this.columnsInfo.length))break}o.clear();let l=Number.MAX_VALUE;for(let t=n.length-1;t>=0;t--){const e=n[t].left;if(!o.has(e)&&(o.add(e),l=Math.min(l,n[t].top+n[t].height),o.size===this.columnsInfo.length))break}return{start:i,end:l,positions:s}}getItemWidth(){return this.itemWidth}getPositions(){return this.cache}getPosition(t){return this.cache.get(t)}getLastItemPosition(){return this.bottom}getColumnsInfo(){return this.columnsInfo.map((t,e)=>({top:t,left:this.margin+e*(this.itemWidth+this.gutterWidth)}))}_handleModelEvent(t){if("mutate"===t.type){const e=t.detail;if(e.add){const t=e.add.addBeforeKeys;if(null!=t){const s=Array.from(e.add.keys);this._insertKeys(t,s)}}if(e.remove){const t=Array.from(e.remove.keys);this._removeKeys(t)}if(e.update){const t=Array.from(e.update.keys);this._updateKeys(t)}}}_insertKeys(t,e){let s=Number.MAX_VALUE;t.forEach((t,i)=>{const o=this.keys.indexOf(t),n=e[i];o>-1&&(s=Math.min(s,o),this.keys.splice(o,0,n),this.cache.set(n,{top:void 0,left:void 0,height:void 0,valid:!1}))}),this._invalidatePositions(s)}_removeKeys(t){let e=Number.MAX_VALUE;t.forEach(t=>{this.cache.delete(t);const s=this.keys.indexOf(t);s>-1&&(e=Math.min(e,s),this.keys.splice(s,1))}),this._invalidatePositions(e)}_updateKeys(t){let e=Number.MAX_VALUE;t.forEach(t=>{const s=this.keys.indexOf(t);if(s>-1){e=Math.min(e,s+1);const i=this.getPosition(t);i&&(i.top=void 0,i.left=void 0,i.height=void 0,i.valid=!1)}}),this._invalidatePositions(e)}_invalidatePositions(t){for(let e=t;e<this.keys.length;e++){const t=this.cache.get(this.keys[e]);null!=t&&(t.valid=!1)}for(let t=0;t<this.columns;t++)this.columnsInfo[t]=0;this.recalculatePositions()}recalculatePositions(){this.bottom=0,this._populatePositions(this.keys,0,t=>t,(t,e,s,i)=>{const o=i.height;if(t<this.columnsInfo.length)this.columnsInfo[s]=o+2*this.gutterWidth,this.bottom=Math.max(this.bottom,o);else{const t=this.columnsInfo.reduce(function(t,e){return Math.min(t,e)}),e=this.columnsInfo.indexOf(t);this.columnsInfo[e]=this.columnsInfo[e]+o+this.gutterWidth,this.bottom=Math.max(this.bottom,t+o)}},t=>{})}}class p extends d.IteratingDataProviderContentHandler{constructor(t,e,s,i,o,n){super(t,e,s,i,o),this.root=t,this.dataProvider=e,this.callback=s,this.scrollPolicy=i,this.scrollPolicyOptions=o,this.gutterWidth=n,this.postRender=()=>{const t=this.root.lastElementChild.firstElementChild;if(t&&null==this.adjustPositionsResolveFunc){this.adjustPositionsResolveFunc=this.addBusyState("adjusting item positions");h.getContext(t).getBusyContext().whenReady().then(()=>{if(this.adjustPositionsResolveFunc&&(this.adjustPositionsResolveFunc(),this.adjustPositionsResolveFunc=null),this.callback){const t=this._adjustAllItems();if(t.done){if(this.newItemsTracker.clear(),this.domScroller&&!this.domScroller.checkViewport())return;this.callback.renderComplete(t.items),this.initialFetch=!1}}})}},this.newItemsTracker=new Set,this.vnodesCache=new Map}destroy(){super.destroy(),this.layout&&this.layout.destroy()}getLayout(){return null==this.layout&&(this.layout=new m(this.dataProvider,this.root.clientWidth,this.gutterWidth,null,null)),this.layout}_adjustAllItems(){let t=!0;const e=Array.from(this.root.querySelectorAll(".oj-waterfalllayout-item")).map(e=>("false"===e.getAttribute("data-oj-positioned")&&(t=!1),{key:this.getKey(e),element:e}));if(t)return this.scrollPolicyOptions.scroller!==this.root&&this.callback.setContentHeight(this.getLayout().getLastItemPosition()),{done:!0,items:e};const s=this.callback.getData().startIndex,i=this.getLayout().getPositionForItems(e,isNaN(s)?0:s);return this.callback.setPositions(i.positions),this.callback.setContentHeight(this.getLayout().getLastItemPosition()),this.domScroller&&this.domScroller.setViewportRange(i.start,i.end),{done:!1,items:e}}handleResizeWidth(t){this.initialFetch=!1,this.getLayout().setWidth(t)}fetchSuccess(t){null!=t&&this.newItemsTracker.clear(),this.initialFetch=!1,super.fetchSuccess(t)}beforeFetchByOffset(t,e){return this.isRenderingViewportOnly()&&this.vnodesCache.clear(),super.beforeFetchByOffset(t,e)}addItem(t,e,s,i){let o=-1,n=-1;const l=this.getLayout().getPosition(t);null!=l?isNaN(l.left)||isNaN(l.top)||(o=l.left,n=l.top):this.newItemsTracker.add(t);const r=this.isInitialFetch();null==this.callback.getCurrentItem()&&0==e&&this.callback.setCurrentItem(t);const a=this.renderItem(t,e,s);return this.decorateItem(a,t,o,n,r,i),a}renderItem(t,e,i){const o=this.callback.getItemRenderer()({data:i,index:e,key:t}),n=this.findItemVNode(o);let l;return null!=n?(this.decorateItemContent(n),l=[s.h("div",{},o)]):l=n,this.vnodesCache.set(t,{index:e,vnodes:l}),l}decorateItemContent(t){t.props.tabIndex=-1,this.setStyleClass(t,["oj-waterfalllayout-item-element"])}decorateItem(t,e,s,i,o,n){let l=this.findItemVNode(t);if(null!=l){l.key=e,l.props.role="gridcell",l.props["data-oj-positioned"]=-1!=s&&-1!=i?"true":"false",l.props["data-oj-key"]=e,"number"==typeof e&&(l.props["data-oj-key-type"]="number");const t=this.getItemStyleClass(n,s,i,this.newItemsTracker.has(e),o);this.setStyleClass(l,t);const r=this.getItemInlineStyle(n,s,i,o);l.props.style=l.props.style?l.props.style+";"+r:r}}getItemInlineStyle(t,e,s,i){let o=-1===e||-1===s?"top:0;left:0":"top:"+s+"px;left:"+e+"px";return t&&-1!=e&&-1!=s&&!i&&(o+=";visibility:visible"),o}getItemStyleClass(t,e,s,i,o){const n=[];return t&&(n.push("oj-waterfalllayout-item"),-1!=e&&-1!=s&&!o&&i&&n.push("oj-waterfalllayout-new-item")),n}renderSkeletonsForLoadMore(){const t=this.getLayout(),e=t.getColumnsInfo(),s=t.getItemWidth();let i=[];const o=Math.max(...e.map(t=>t.top));if(o>0){const t=o+100,n=e.map(e=>({left:e.left,top:e.top,height:t-e.top,width:s}));i=this.callback.renderSkeletons(n)}return i}handleCurrentRangeItemUpdated(t){const e=this.getLayout().getPosition(t);e&&(e.top=void 0,e.left=void 0),super.handleCurrentRangeItemUpdated(t)}handleItemsUpdated(t){t.keys.forEach(t=>{this.vnodesCache.delete(t)}),super.handleItemsUpdated(t)}handleItemsRemoved(t){t.keys.forEach(t=>{this.vnodesCache.delete(t)}),super.handleItemsRemoved(t)}handleModelRefresh(){this.vnodesCache.clear(),super.handleModelRefresh()}_log(t){c.info("[WaterfallLayoutContentHandler]=> "+t)}}var f,y=function(t,e,s,i){var o,n=arguments.length,l=n<3?e:null===i?i=Object.getOwnPropertyDescriptor(e,s):i;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)l=Reflect.decorate(t,e,s,i);else for(var r=t.length-1;r>=0;r--)(o=t[r])&&(l=(n<3?o(l):n>3?o(e,s,l):o(e,s))||l);return n>3&&l&&Object.defineProperty(e,s,l),l};t.WaterfallLayout=f=class extends s.Component{constructor(){super(),this.actionableMode=!1,this.renderCompleted=!1,this.ticking=!1,this.gutterWidth=16,this._findFocusItem=t=>null!=t?t.firstElementChild:t,this._handleFocusIn=t=>{const e=this._findFocusItem(this.currentItem);e&&this.focusInHandler(e)},this._handleFocusOut=t=>{const e=this._findFocusItem(this.currentItem);e&&this.focusOutHandler(e)},this._handleClick=t=>{this._handleTouchOrClickEvent(t)},this._handleKeyDown=t=>{if(this.currentItem){let e;switch(t.key){case"ArrowLeft":case"Left":e=this.currentItem.previousElementSibling;break;case"ArrowRight":case"Right":e=this.currentItem.nextElementSibling;break;case"F2":!1===this.actionableMode?this._enterActionableMode():this._exitActionableMode();break;case"Escape":case"Esc":!0===this.actionableMode&&this._exitActionableMode();break;case"Tab":!0===this.actionableMode&&this.currentItem&&(t.shiftKey?n.handleActionablePrevTab(t,this.currentItem):n.handleActionableTab(t,this.currentItem))}!1===this.actionableMode&&null!=e&&e.classList.contains(this.getItemStyleClass())&&this._updateCurrentItem(e)}},this._touchStartHandler=t=>{this._handleTouchOrClickEvent(t)},this.setRootElement=t=>{this.root=t},this.scrollListener=t=>{this.ticking||(window.requestAnimationFrame(()=>{this.isAvailable()&&this._updateScrollPosition(),this.ticking=!1}),this.ticking=!0)},this.state={renderedData:null,positions:null,skeletonPositions:null,width:0,height:0,contentHeight:0}}render(){let t,s;if(null==this.contentHandler)t=this._renderInitialSkeletons(null);else{s=this.getData();const i=this.state.skeletonPositions;if(s&&this.state.width>0)if(s.value&&0===s.value.data.length)t=this.contentHandler.renderNoData();else if(null!=i&&this.contentHandler.isInitialFetch()){t=this._renderInitialSkeletons(i.positions).concat(this.contentHandler.render(s))}else t=this.contentHandler.render(s),0===t?.[0]?.length&&t[0].push(e.jsx("div",{role:"gridcell"}));else null!=i&&(t=this._renderInitialSkeletons(i.positions))}return null==s?e.jsx(i.Root,{ref:this.setRootElement,style:this._getRootElementStyle(),"aria-label":this.props["aria-label"],"aria-labelledby":this.props["aria-labelledby"],children:e.jsx("div",{role:"grid","aria-label":this.props["aria-label"],"aria-labelledby":this.props["aria-labelledby"],children:e.jsx("div",{role:"row",style:this._getContentDivStyle(),tabIndex:0,"aria-label":a.getTranslatedString("oj-ojWaterfallLayout.msgFetchingData"),"data-oj-context":!0,children:t})})}):e.jsx(i.Root,{ref:this.setRootElement,style:this._getRootElementStyle(),"aria-label":this.props["aria-label"],"aria-labelledby":this.props["aria-labelledby"],children:e.jsx("div",{onClick:this._handleClick,onKeyDown:this._handleKeyDown,onfocusin:this._handleFocusIn,onfocusout:this._handleFocusOut,role:"grid","aria-label":this.props["aria-label"],"aria-labelledby":this.props["aria-labelledby"],children:e.jsx("div",{role:"row",style:this._getContentDivStyle(),"data-oj-context":!0,children:t})})})}_getScrollPolicyOptions(){return{fetchSize:this.props.scrollPolicyOptions.fetchSize,maxCount:this.props.scrollPolicyOptions.maxCount,scroller:this._getScroller()}}_debounce(t,e){let s=null;return(...i)=>{clearTimeout(s),s=setTimeout(()=>t(...i),e)}}componentDidMount(){const t=this.getRootElement();t.addEventListener("touchStart",this._touchStartHandler,{passive:!0}),this.props.data&&(this.contentHandler=new p(t,this.props.data,this,this.props.scrollPolicy,this._getScrollPolicyOptions(),this.gutterWidth));const e=t.clientWidth,s=t.clientHeight;this.setState({width:e,height:s});const i=t.querySelector(".oj-waterfalllayout-skeleton");if(i&&(this.skeletonWidth=i.clientWidth,this.contentHandler&&this._delayShowSkeletons()),window.ResizeObserver){const e=new window.ResizeObserver(this._debounce(e=>{e.forEach(e=>{if(e.target===t&&e.contentRect){const s=this.state.width,i=Math.round(e.contentRect.width);if(Math.abs(i-s)>f.minResizeWidthThreshold){const e=t.querySelector(".oj-waterfalllayout-skeleton");e&&0==this.skeletonWidth&&(this.skeletonWidth=e.clientWidth),this.setState({width:i}),null!=this.getSkeletonPositions()?this._updatePositionsForSkeletons(i):null!=this.getPositions()&&this.contentHandler&&(this.contentHandler.getLayout().setWidth(i),this.renderCompleted&&this.contentHandler.handleResizeWidth(i))}const o=this.state.height,n=Math.round(e.contentRect.height);Math.abs(n-o)>1&&n!==this.state.contentHeight&&this.setState({height:n})}})},f.debounceThreshold));e.observe(t),this.resizeObserver=e}u.makeFocusable({applyHighlight:!0,setupHandlers:(t,e)=>{const s=n.getNoJQFocusHandlers(t,e);this.focusInHandler=s.focusIn,this.focusOutHandler=s.focusOut}}),this._getScroller().addEventListener("scroll",this.scrollListener)}_handleNewData(){this.setState({renderedData:null,positions:null}),this.contentHandler&&this.contentHandler.destroy(),this.currentKey=null,this.currentItem=null;const t=this.getRootElement();this.contentHandler=new p(t,this.props.data,this,this.props.scrollPolicy,this._getScrollPolicyOptions(),this.gutterWidth),this._delayShowSkeletons()}componentDidUpdate(t,e){if(null!=this.getData()){if(this.props.data!=t.data){const t=this.addBusyState("apply exit animations on existing items");this._applyExitAnimation().then(()=>{t(),this._handleNewData()})}else if(null==e.positions&&null!=this.state.positions)if(null!=this.state.skeletonPositions){const t=this._findSkeletons();t.length>0&&this._applySkeletonExitAnimation(t).then(()=>{this.setState({skeletonPositions:null})})}else this._applyEntranceAnimation(),!this.renderCompleted&&this.contentHandler&&this.contentHandler.postRender();else null!=e.skeletonPositions&&null==this.state.skeletonPositions?(this._applyEntranceAnimation(),!this.renderCompleted&&this.contentHandler&&this.contentHandler.postRender()):null!=e.positions&&null!=this.state.positions&&e.positions.size<this.state.positions.size?(this._applyLoadMoreEntranceAnimation(),!this.renderCompleted&&this.contentHandler&&this.contentHandler.postRender()):this.contentHandler&&(this._isRenderedDataSizeChanged(e.renderedData,this.state.renderedData)||o.Object.compareValues(this.props.scrollPosition,t.scrollPosition))&&this.contentHandler.postRender();if(o.Object.compareValues(this.props.scrollPosition,t.scrollPosition)||o.Object.compareValues(this.props.scrollPosition,this.lastInternalScrollPositionUpdate)||this._syncScrollTopWithProps(),null==this.state.skeletonPositions&&null!=this.props.scrollPolicyOptions.scroller){const t=this._getContentDiv(),e=this.getRootElement().querySelector(".oj-waterfalllayout-skeleton");if(e){const s=parseInt(e.style.top)+parseInt(e.style.height);this.state.contentHeight!==s&&(t.style.height=s+"px")}else parseInt(t.style.height)!=this.state.contentHeight&&(t.style.height=this.state.contentHeight+"px")}}else if(this.props.data&&null==t.data)this._handleNewData();else if(null!=this.state.skeletonPositions&&!isNaN(this.state.skeletonPositions.end)&&null!=this.props.scrollPolicyOptions.scroller){this._getContentDiv().style.height=this.state.skeletonPositions.end+"px"}}componentWillUnmount(){this.contentHandler&&this.contentHandler.destroy(),this.contentHandler=null,this.resizeObserver&&this.resizeObserver.disconnect(),this.resizeObserver=null,this.scrollListener&&null!=this._getScroller()&&this._getScroller().removeEventListener("scroll",this.scrollListener)}_isRenderedDataSizeChanged(t,e){return!(t===e||t&&e&&t.value.data.length===e.value.data.length)}_delayShowSkeletons(){window.setTimeout(()=>{null==this.getData()&&this._updatePositionsForSkeletons(this.state.width)},this._getShowSkeletonsDelay())}_updatePositionsForSkeletons(t){const e=this._getPositionsForSkeletons(50,t,this.skeletonWidth);this.setState({skeletonPositions:e})}_getOptionDefaults(){return null==this.defaultOptions&&(this.defaultOptions=this._getStyleValues()),this.defaultOptions}_getStyleValues(){const t={};return Object.entries(f._CSS_Vars).forEach(([e,s])=>{t[e]=r.getCachedCSSVarValues([s])[0]}),t}_getShowSkeletonsDelay(){const t=this._getOptionDefaults(),e=u.getCSSTimeUnitAsMillis(t.showIndicatorDelay,10);return isNaN(e)?0:e}_getCardEntranceAnimationDelay(){const t=this._getOptionDefaults(),e=u.getCSSTimeUnitAsMillis(t.cardAnimationDelay,10);return isNaN(e)?0:e}addBusyState(t){const e=this.getRootElement();return h.getContext(e).getBusyContext().addBusyState({description:t})}_findSkeletons(){const t=this.getRootElement().querySelectorAll(".oj-waterfalllayout-skeleton");return t.length>1?t:[]}getRootElement(){return this.root}isAvailable(){return null!=this.contentHandler}getCurrentItem(){return this.currentKey}setCurrentItem(t){this.currentKey=t}getData(){return this.state.renderedData}setData(t){null!=t&&(this.renderCompleted=!1),this.setState({renderedData:t});const e=this._findSkeletons();null!=t&&0!==e.length||this.setState({skeletonPositions:null}),window.clearTimeout(this.delayShowSkeletonsTimeout)}updateData(t){this.renderCompleted=!1,this.setState(function(e){const s=e.renderedData;return t(s)}.bind(this))}getSkeletonPositions(){return this.state.skeletonPositions}setSkeletonPositions(t){this.setState({skeletonPositions:t})}getPositions(){return this.state.positions}setPositions(t){this.setState({positions:t})}setContentHeight(t){null!=this.props.scrollPolicyOptions.scroller&&this.state.contentHeight!==t&&this.setState({contentHeight:t})}getItemRenderer(){return this.props.itemTemplate}getItemStyleClass(){return"oj-waterfalllayout-item"}getExpanded(){}_applySkeletonExitAnimation(t){const e=this.addBusyState("apply skeleton exit animations");return new Promise((s,i)=>{let o;t.forEach(t=>{o=l.fadeOut(t)}),o&&o.then(()=>{e(),s(!0)})})}_applyEntranceAnimation(){const t=this.getRootElement().querySelectorAll("."+this.getItemStyleClass());if(0===t.length)return Promise.resolve(!0);const e=[];return t.forEach((t,s)=>{const i=t;i.style.visibility="visible";const o=i.style.transition;i.style.transition="none";const n=Math.min(1e3,s*this._getCardEntranceAnimationDelay())+"ms",r="300ms",a=l.slideIn(t,{offsetY:"300px",delay:n,duration:r});e.push(a),e.push(l.fadeIn(t,{delay:n,duration:r})),a.then(()=>{i.style.transition=o})}),Promise.all(e)}_applyExitAnimation(){const t=this.getRootElement().querySelectorAll("."+this.getItemStyleClass());if(0===t.length)return Promise.resolve(!0);const e=[];return t.forEach(t=>{const s="300ms";e.push(l.slideOut(t,{offsetY:"300px",duration:s,persist:"all"})),e.push(l.fadeOut(t,{duration:s,persist:"all"}))}),Promise.all(e)}_applyLoadMoreEntranceAnimation(){const t=this.getRootElement().querySelectorAll(".oj-waterfalllayout-new-item");if(0===t.length)return Promise.resolve(!0);const e=[];return t.forEach(t=>{t.classList.remove("oj-waterfalllayout-new-item"),e.push(l.fadeIn(t,{duration:"150ms"}))}),Promise.all(e)}_updateScrollPosition(){const t=this._getScroller().scrollTop,e=this.contentHandler.getLayout().getPositions().entries();let s,i=e.next(),o=0;for(;!i.done;){const n=i.value;i=e.next();const l=n[1].top;if(l>t){void 0===s&&(s=n[0]);break}l>o&&(s=n[0],o=l)}const n={y:t,key:s,offsetY:Math.abs(t-o)};this.lastInternalScrollPositionUpdate=n,this.props.onScrollPositionChanged?.(n)}_syncScrollTopWithProps(){const t=this.props.scrollPosition;let e;const s=t.key;if(s){const i=this.contentHandler.getLayout().getPosition(s);if(null==i)return;e=i.top;const o=t.offsetY;isNaN(o)||(e+=o)}else{const s=t.y;if(isNaN(s))return;e=s}e>this._getScroller().scrollHeight||(this._getScroller().scrollTop=e)}handleItemRemoved(t){}_handleTouchOrClickEvent(t){const e=t.target.closest("."+this.getItemStyleClass());this._updateCurrentItem(e)}_resetFocus(t){const e=this._findFocusItem(t);this.focusOutHandler(e),e.tabIndex=-1}_setFocus(t,e){const s=this._findFocusItem(t);s.tabIndex=0,e&&(this.focusInHandler(s),s.focus())}_updateCurrentItem(t){if(this.currentItem){const t=this.currentItem;this._resetFocus(t)}this.currentItem=t;const e=t;this.currentKey=this.contentHandler.getKey(e),this._setFocus(e,!0)}_getScroller(){let t=this.props.scrollPolicyOptions.scroller;return"string"==typeof t&&(t=document.querySelector(t)),null!=t?t:this.getRootElement()}_getContentDiv(){return this.getRootElement().firstElementChild.firstElementChild}_getContentDivStyle(){return{height:this.state.contentHeight+"px"}}_getRootElementStyle(){return null!=this.props.scrollPolicyOptions.scroller?{overflow:"hidden"}:null}_renderInitialSkeletons(t){const e=this._getScroller();if(null!=e&&(e.scrollTop=0),null==t)return[this._renderSkeleton(null,!0)];{const e=t.size,s=[];for(let i=0;i<e;i++){const e=t.get(i);s.push(this._renderSkeleton(e,!0))}return s}}_getPositionsForSkeletons(t,e,s){const i=[],o=new Map;for(let e=0;e<t;e++){const t=150+e%3*100;o.set(e,{height:t}),i.push({key:e})}return new m(null,e,this.gutterWidth,s,o).getPositionForItems(i,0)}_restoreCurrentItem(t){if(null!=this.currentKey){for(const e of t)if(e.key==this.currentKey){const t=e.element;this._setFocus(t,!1),this.currentItem=t;break}if((null==this.currentItem||null==this.currentItem.parentNode)&&t.length>0){this.currentKey=t[0].key;const e=t[0].element;this._setFocus(e,!1),this.currentItem=e}}}_disableAllTabbableElements(t){t.forEach(t=>{n.disableAllFocusableElements(t.element)})}_enterActionableMode(){if(this.actionableMode=!0,this.currentItem){const t=n.enableAllFocusableElements(this.currentItem,!0);t&&t.length>0&&t[0].focus()}}_exitActionableMode(){this.actionableMode=!1,this.currentItem&&(n.disableAllFocusableElements(this.currentItem),this._setFocus(this.currentItem,!0))}renderComplete(t){this.renderCompleted=!0,this.actionableMode=!1,this._disableAllTabbableElements(t),this._restoreCurrentItem(t),this.delayShowSkeletonsTimeout=window.setTimeout(()=>{if(this.isAvailable()){this._findSkeletons().forEach(t=>{t.style.visibility="visible"})}},this._getShowSkeletonsDelay())}renderSkeletons(t){const e=[];return t.forEach(t=>{e.push(this._renderSkeleton(t))}),e}_renderSkeleton(t,s){let i;return null==t?i={visibility:"hidden"}:(i={top:t.top+"px",left:t.left+"px",height:t.height+"px"},s||(i.visibility="hidden"),isNaN(t.width)||(i.width=t.width+"px")),e.jsx("div",{class:"oj-waterfalllayout-skeleton",style:i,children:e.jsx("div",{class:"oj-waterfalllayout-skeleton-content oj-animation-skeleton"})})}},t.WaterfallLayout.defaultProps={data:null,scrollPolicy:"loadMoreOnScroll",scrollPolicyOptions:{fetchSize:25,maxCount:500,scroller:null},scrollPosition:{y:0}},t.WaterfallLayout.minResizeWidthThreshold=10,t.WaterfallLayout.debounceThreshold=100,t.WaterfallLayout._CSS_Vars={showIndicatorDelay:"--oj-private-core-global-loading-indicator-delay-duration",cardAnimationDelay:"--oj-private-animation-global-card-entrance-delay-increment"},t.WaterfallLayout._metadata={properties:{data:{type:"object"},scrollPolicy:{type:"string",enumValues:["loadAll","loadMoreOnScroll"]},scrollPolicyOptions:{type:"object",properties:{fetchSize:{type:"number"},maxCount:{type:"number"},scroller:{type:"string|Element"}}},scrollPosition:{type:"object",properties:{y:{type:"number"},key:{type:"any"},offsetY:{type:"number"}},writeback:!0}},slots:{itemTemplate:{data:{}}},extension:{_WRITEBACK_PROPS:["scrollPosition"],_READ_ONLY_PROPS:[],_OBSERVED_GLOBAL_PROPS:["aria-label","aria-labelledby"]}},t.WaterfallLayout=f=y([i.customElement("oj-waterfall-layout")],t.WaterfallLayout),Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojwaterfalllayout.js.map