/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojcore-base","ojs/ojdatacollection-common","ojs/ojlogger","ojs/ojcachediteratorresultsdataprovider","ojs/ojdomscroller"],function(e,t,a,n,r,s){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r,s=s&&Object.prototype.hasOwnProperty.call(s,"default")?s.default:s;class l{constructor(e,t,a){this.root=e,this.dataProvider=t,this.callback=a,this.validKeyTypes=["string","number"],this.fetching=0,this.getKey=function(e){return e.key?e.key:"number"===e.dataset.ojKeyType?Number(e.dataset.ojKey):e.dataset.ojKey},t&&(this.modelEventHandler=this._handleModelEvent.bind(this),t.addEventListener("mutate",this.modelEventHandler),t.addEventListener("refresh",this.modelEventHandler))}setFetching(e){const t=e?this.fetching+1:this.fetching-1;this.fetching=Math.max(0,t)}isFetching(){return 0!==this.fetching}addBusyState(e){return null!=this.callback?this.callback.addBusyState("DataProviderContentHandler "+e):()=>{}}destroy(){this.callback=null,this.dataProvider&&this.modelEventHandler&&(this.dataProvider.removeEventListener("mutate",this.modelEventHandler),this.dataProvider.removeEventListener("refresh",this.modelEventHandler))}renderNoData(){return this.setFetching(!1),[]}render(e){return this.renderFetchedData(e)}postRender(){}getDataProvider(){return this.dataProvider}setDataProvider(e){this.dataProvider=e}isReady(){return!this.fetching}verifyKey(e){return this.validKeyTypes.indexOf(typeof e)>-1}setStyleClass(e,t){const a=e.props.class||""===e.props.class?"class":"className",n=e.props[a]?[e.props[a],...t]:t;e.props[a]=n.join(" ")}findItemVNode(e){if(Array.isArray(e)){for(const t of e)if(t.props)return null==t.type||"function"!=typeof t.type?t:this.findItemVNode(t.props.children);return null}return e}handleModelRefresh(e){this.callback.setData(null),this.fetchRows()}handleItemsAdded(e){}handleItemsRemoved(e){}handleItemsUpdated(e){}_handleModelEvent(e){const t=e.detail;if("refresh"===e.type)this.handleModelRefresh(t);else if("mutate"===e.type){if(null==this.callback.getData())return;const e=[];if(t.add&&t.remove&&t.remove.keys.forEach(a=>{t.add.keys.has(a)&&e.push(a)}),t.remove){const a=()=>{this.handleItemsRemoved(t.remove),t.remove.keys.forEach(t=>{-1==e.indexOf(t)&&this.callback.handleItemRemoved(t)})};this.getValidatedEventDetailPromise?this.getValidatedEventDetailPromise.then(()=>{a(),this.getValidatedEventDetailPromise=null}):a()}if(t.add){const a=t.add.keys,n=[...a],r=this.callback.getData()?.value.metadata,s={...t.add};r?.forEach(t=>{if(a.has(t.key)&&-1==e.indexOf(t.key)){const e=n.indexOf(t.key);s.addBeforeKeys?.splice(e,1),s.data?.splice(e,1),s.indexes?.splice(e,1),s.keys?.delete(t.key),s.metadata?.splice(e,1),s.parentKeys?.splice(e,1)}}),this.handleItemsAdded(s)}t.update&&this.handleItemsUpdated(t.update)}}_handleScrollerMaxRowCount(){n.info("ScrollPolicyOptions max count has been reached.")}getMaxCount(){return 1/0}truncateIfOverMaxCount(e,t){const a=e.data.length,n=a+t,r=this.getMaxCount()-n;r<0&&(e.data.splice(r,a),e.metadata.splice(r,a),this._handleScrollerMaxRowCount())}getValidatedEventDetail(e){const t=this.addBusyState("validating mutation add event detail");return a.getEventDetail(this.getDataProvider(),e).then(a=>{if(null===a)return void t();const n="."+this.callback.getItemStyleClass(),r=this.root.querySelectorAll(n);this.truncateIfOverMaxCount(a,r.length),e.data=a.data,e.metadata=a.metadata,t()})}}var i;(i=e.VirtualizationStrategy||(e.VirtualizationStrategy={}))[i.HIGH_WATER_MARK=0]="HIGH_WATER_MARK",i[i.VIEWPORT_ONLY=1]="VIEWPORT_ONLY";class o{constructor(e,t,a,n,r){this.element=e,this.dataProvider=t,this.asyncIterator=a,this.callback=n,this.options=r,this._handleScroll=e=>{const t=this.element,a=this._getScrollTop(t),n=t.scrollHeight-t.clientHeight;n>0&&this._handleScrollerScrollTop(a,n)},this._handleModelEvent=e=>{if("mutate"===e.type){const t=e.detail;if(t.add){let e=t.add.indexes;const a=t.add.addBeforeKeys;if(null!=a){const n=Array.from(t.add.keys);e=this._handleModelInsert(a,n)}null!=e&&(e=e.sort((e,t)=>e-t),this._handleItemsAddedOrRemoved(e,"added"),this.rowCount=this.rowCount+e.length)}if(t.remove){const e=Array.from(t.remove.keys);let a=this._handleModelDelete(e);a=a.sort((e,t)=>t-e),this._handleItemsAddedOrRemoved(a,"removed"),this.rowCount=Math.max(0,this.rowCount-a.length)}}},this.initialScrollTop=this.element.scrollTop,this.scrollListener=this._handleScroll.bind(this),this._getScrollEventElement().addEventListener("scroll",this.scrollListener),this.modelEventListener=this._handleModelEvent.bind(this),t.addEventListener("mutate",this.modelEventListener),this.fetchSize=r.fetchSize>0?r.fetchSize:25,this.maxCount=r.maxCount>0?r.maxCount:500,this.rowCount=null!=r.keys?r.keys.length:this.fetchSize,this.viewportSize=-1,this.viewportPixelSize=this.element.offsetHeight,this.currentScrollTop=0,this.currentRenderedPoint={startIndex:0,endIndex:isNaN(this.rowCount)?this.fetchSize:this.rowCount,maxCountLimit:!1,done:!1,keys:r.keys},this.lastFetchTrigger=0,this.checkViewportCount=0}checkViewport(){if(this.currentRenderedPoint.done||this.currentRenderedPoint.maxCountLimit)return!0;const e=this._isRangeValid(0,this.currentRenderedPoint.end);return e?this.checkViewportCount=0:(this.checkViewportCount+=1,this.checkViewportCount===a.CHECKVIEWPORT_THRESHOLD&&n.warn("Viewport not satisfied after multiple fetch, make sure the component is height constrained or specify a scroller."),this._doFetch()),e}setAsyncIterator(e){this.asyncIterator=e}_isRenderingViewportOnly(t){return this.options.strategy===e.VirtualizationStrategy.VIEWPORT_ONLY&&void 0!==t.getIndexForRange}setViewportRange(e,t){null!=this.currentRenderedPoint.start&&null!=this.currentRenderedPoint.end||(this.currentRenderedPoint.start=e,this.currentRenderedPoint.end=t,this._log(`got pixel range: ${e} to ${t} for renderedPoint: ${this.currentRenderedPoint.startIndex} ${this.currentRenderedPoint.endIndex}`)),this._checkRenderedPoints()&&(this.fetchPromise=null,this.currentScrollTop>=this.lastFetchTrigger&&(this.nextFetchTrigger=void 0))}destroy(){this._getScrollEventElement().removeEventListener("scroll",this.scrollListener),this.dataProvider.removeEventListener("mutate",this.modelEventListener)}_getScrollEventElement(){return this.element===document.body||this.element===document.documentElement?window:this.element}_getScrollTop(e){return e===document.documentElement&&(void 0===this.useBodyScrollTop&&(this.useBodyScrollTop=this.initialScrollTop===e.scrollTop),this.useBodyScrollTop)?0+document.body.scrollTop:0+e.scrollTop}_setRangeLocal(e,t,a,n,r,s){this._log(`rendering row: ${e} to ${t} covering range: ${null==a?"unknown":a} to ${null==n?"unknown":n}`),this.callback.beforeFetchByOffset(e,t),this.currentRenderedPoint={startIndex:e,endIndex:t,start:a,end:n,maxCountLimit:r,done:s,keys:[]};const l={offset:e,size:t-e};this.fetchByOffsetPromise=this.dataProvider.fetchByOffset(l).then(l=>{let i=!0;if(null!=a&&null!=n&&(i=this._isRangeValid(a,n)),i){this._log(`fetchByOffset ${e} to ${t} returned and result is still applicable`);const a=[],n=[],i=this.currentRenderedPoint.keys;l.results.forEach(e=>{a.push(e.data),n.push(e.metadata),i.push(e.metadata.key)});const o={};o.startIndex=e,o.maxCountLimit=r,o.done=s,o.value={},o.value.data=a,o.value.metadata=n,this.callback.fetchSuccess(o),this.fetchByOffsetPromise=null}else this._log(`fetchByOffset ${e} to ${t} returned but result is NO LONGER applicable`),this.fetchByOffsetPromise=null,this.callback.fetchError("notValid"),this._checkRenderedPoints()})}_handleScrollerScrollTop(e,t){if(this.currentScrollTop=e,!this.fetchPromise&&this.asyncIterator){if(isNaN(this.nextFetchTrigger)&&this.lastMaxScrollTop!==t&&(this.nextFetchTrigger=Math.max(0,(t-e)/2),this.lastFetchTrigger=e,this.lastMaxScrollTop=t,this._log("next fetch trigger point: "+Math.round(this.nextFetchTrigger))),null!=this.nextFetchTrigger&&e-this.lastFetchTrigger>this.nextFetchTrigger)return void this._doFetch();if(t-e<1)return void this._doFetch()}this.fetchPromise&&e>this.lastFetchTrigger||this._checkRenderedPoints()}_isRangeValid(e,t){const a=this.currentScrollTop;return this.viewportPixelSize=this.element.clientHeight,a>=e&&a+this.viewportPixelSize<=t}_checkRenderedPoints(){if(null==this.currentRenderedPoint.start||null==this.currentRenderedPoint.end)return!0;if(this._isRangeValid(this.currentRenderedPoint.start,this.currentRenderedPoint.end))return!0;if(this._isRenderingViewportOnly(this.callback)){const e=this.callback,t=Math.max(0,this.currentScrollTop-this.viewportPixelSize),a=Math.min(this.currentScrollTop+2*this.viewportPixelSize),n=e.getIndexForRange(t,a),r=Math.max(0,n.startIndex),s=null==n.endIndex?this.rowCount:Math.min(this.rowCount,n.endIndex);if(r<this.currentRenderedPoint.startIndex||s>this.currentRenderedPoint.endIndex){const e=s===this.lastIndex,n=s===this.maxCount;return this._setRangeLocal(r,s,t,a,n,e),!1}}return!0}_doFetch(){this._log("fetching next set of rows from asyncIterator");this.callback.beforeFetchNext()?(-1===this.viewportSize&&(this.viewportSize=this.currentRenderedPoint.endIndex-this.currentRenderedPoint.startIndex),this.fetchPromise=this._fetchMoreRows().then(e=>{if(e.maxCountLimit){this._log("reached max count");const t=e.size>0?null:this.currentRenderedPoint.start,a=e.size>0?null:this.currentRenderedPoint.end;this._setRangeLocal(this.currentRenderedPoint.startIndex,this.maxCount,t,a,!0,!1),this.fetchPromise=null,this.asyncIterator=null}else if(e.size>0||!0===e.done){let t=0;this._isRenderingViewportOnly(this.callback)&&(t=this.callback.getIndexForPosition(this.currentScrollTop));const a=t,n=this.currentRenderedPoint.endIndex+e.size;e.done&&(this.lastIndex=n),this._setRangeLocal(a,n,null,null,!1,e.done)}else this.fetchPromise=null,this.asyncIterator=null,this.callback.fetchSuccess(null)},e=>{this.callback.fetchError(e),this.fetchPromise=null,this.nextFetchTrigger=void 0})):(this._log("fetch is aborted due to beforeFetchCallback returning false"),this.nextFetchTrigger=void 0)}_fetchMoreRows(){if(!this.fetchPromise){const e=this.maxCount-this.rowCount;return e>0&&!this.currentRenderedPoint.done&&null!=this.asyncIterator?(this.fetchPromise=this.asyncIterator.next().then(t=>{let a;return this.fetchPromise=null,null!=t&&(a={done:t.done,maxCountLimit:t.maxCountLimit},null!=t.value&&(a.size=t.value.data.length,this.rowCount+=t.value.data.length,e<this.fetchSize&&(a.maxCountLimit=!0,t.value.data.length>e&&(a.size=e))),a.maxCountLimit&&(this.asyncIterator=null)),Promise.resolve(a)}),this.fetchPromise):Promise.resolve({maxCount:this.maxCount})}return this.fetchPromise}_handleModelInsert(e,t){const a=this.currentRenderedPoint.keys;e.forEach((e,n)=>{const r=a.indexOf(e),s=t[n];r>-1&&a.splice(r,0,s)});const n=[],r=this.currentRenderedPoint.startIndex;return t.forEach(e=>{const t=a.indexOf(e);t>-1?n.push(t+r):this.currentRenderedPoint.done=!1}),n.length>0&&(this.currentRenderedPoint.start=null,this.currentRenderedPoint.end=null),n}_handleModelDelete(e){const t=[],a=this.currentRenderedPoint.startIndex,n=this.currentRenderedPoint.keys,r=[];return e.forEach(e=>{const s=n.indexOf(e);s>-1&&(t.push(a+s),r.push(e))}),r.forEach(e=>{n.splice(n.indexOf(e),1)}),t.length>0&&(this.currentRenderedPoint.start=null,this.currentRenderedPoint.end=null),t}_updateRenderedPoint(e,t,a){e<t.startIndex?"added"===a?(t.startIndex=t.startIndex+1,t.endIndex=t.endIndex+1):"removed"===a&&(t.startIndex=t.startIndex-1,t.endIndex=t.endIndex-1):e<=t.endIndex&&("added"===a?t.endIndex=t.endIndex+1:"removed"===a&&(t.endIndex=t.endIndex-1))}_handleItemsAddedOrRemoved(e,t){e.forEach(e=>{this._updateRenderedPoint(e,this.currentRenderedPoint,t)})}_log(e){n.info("[VirtualizeDomScroller]=> "+e)}}class d extends l{constructor(t,a,n,r,l){super(t,a,n),this.root=t,this.dataProvider=a,this.callback=n,this.scrollPolicy=r,this.scrollPolicyOptions=l,this.fetchRows=()=>{if(this.isReady()){const e={clientId:this._clientId};e.size=this._isLoadMoreOnScroll()?this.getFetchSize():-1;const t=this.getDataProvider().fetchFirst(e)[Symbol.asyncIterator]();this._cachedIteratorsAndResults.root={iterator:t,cache:null};const a={value:{data:[],metadata:[]}};this._fetchNextFromIterator(t,null,e,a).then(e=>{this._setNewData(e)},()=>{this._setNewData(null)})}},this._fetchNextFromIterator=(e,t,a,n)=>{if(null==e)return Promise.resolve();this.setFetching(!0);const r=this.addBusyState("call next on iterator"),s=e.next(),l=a.size,i=t=>{if(t.done||-1!==l)return t;return e.next().then(function(e){return t.done=e.done,t.value.data=t.value.data.concat(e.value.data),t.value.metadata=t.value.metadata.concat(t.value.metadata),i(t)},function(e){return Promise.reject(e)})};return s.then(e=>i(e),e=>Promise.reject(e)).then(e=>{if(this.isFetching()){if(r(),this.setFetching(!1),null==this.callback||null==e)return;return this.initialFetch=!0,e.done&&this._cachedIteratorsAndResults[null===t?"root":t]&&(this._cachedIteratorsAndResults[null===t?"root":t].iterator=null),this.handleNextItemInResults(a,t,e,n)}},e=>(r(),this._handleFetchError(e),Promise.reject(e)))},this._setNewData=e=>{null!=this.callback&&this.callback.updateData(function(t){let a,n,r,s;return null==e?(n=[],r=[],s=!0):(n=e.value.data,r=e.value.metadata,s=this._checkIteratorAndCache()),a=null==t?{value:{data:n,metadata:r},done:s}:{value:{data:t.value.data.concat(n),metadata:t.value.metadata.concat(r)},done:s},{renderedData:a}}.bind(this))},this._checkIteratorAndCache=()=>{const e=this._cachedIteratorsAndResults,t=Object.keys(e).map(function(t){return e[t]});let a=!0;return t.forEach(function(e){!e||null==e.iterator&&null==e.cache||(a=!1)}),a},this.fetchMoreRows=()=>{if(this.isReady()){const e=this._getLastEntryMetadata();let t=e.key;!e.isLeaf&&this._isExpanded(t)||(t=e.parentKey);const a={};a.size=this._isLoadMoreOnScroll()?this.getFetchSize():-1;const n=this._cachedIteratorsAndResults[null===t?"root":t];let r=null,s=null;null!=n&&(r=n.cache,s=n.iterator);const l={value:{data:[],metadata:[]}};return this.handleNextItemInResults(a,t,r,l).then(()=>{let e,n=this._cachedIteratorsAndResults[null===t?"root":t];return null!=n&&(e=n.iterator),this._fetchFromAncestors(a,t,e,l)},e=>Promise.reject(e))}return Promise.resolve()},this._fetchFromAncestors=(e,t,a,n)=>{const r=this;if(r._checkFinalResults(e,n))return n.done=this._checkIteratorAndCache(),Promise.resolve(n);return this._fetchNextFromIterator(a,t,e,n).then(function(t,a){if(r._checkFinalResults(e,a)||null===t)return a.done=this._checkIteratorAndCache(),Promise.resolve(a);const n=r._getItemByKey(t,a).metadata.parentKey,s=this._cachedIteratorsAndResults[null===n?"root":n];let l=null,i=null;return null!=s&&(l=s.cache,i=s.iterator),this.handleNextItemInResults(e,n,l,a).then(this._fetchFromAncestors.bind(this,e,n,i,a))}.bind(this,t,n),e=>Promise.reject(e))},this._getLastEntryMetadata=()=>{const e=this.callback.getData();if(e&&e.value.metadata.length){const t=e.value.metadata;return t[t.length-1]}return null},this._isExpanded=e=>this.callback.getExpanded().has(e),this.getChildDataProvider=e=>null==e?this.dataProvider:this.dataProvider.getChildDataProvider(e),this.handleNextItemInResults=(e,t,a,n)=>{const r=null===a?null:{...a};if(null===r||0===r.value.data.length||this._checkFinalResults(e,n))return null!=r&&r.value.data.length?this._cachedIteratorsAndResults[null===t?"root":t]&&(this._cachedIteratorsAndResults[null===t?"root":t].cache=r):this._cachedIteratorsAndResults[null===t?"root":t]&&(this._cachedIteratorsAndResults[null===t?"root":t].cache=null),this._checkFinalResults(e,n)||null==this._cachedIteratorsAndResults[null===t?"root":t].iterator?(n.done=this._checkIteratorAndCache(),Promise.resolve(n)):this._fetchNextFromIterator(this._cachedIteratorsAndResults[null===t?"root":t].iterator,t,e,n);const s=[...r.value.data],l=[...r.value.metadata],i=s.shift(),o=l.shift();r.value.data=s,r.value.metadata=l;const d=this._updateMetadata(o,t,n);if(n.value.data.push(i),n.value.metadata.push(d),this._isExpanded(d.key)){const e=this.getChildDataProvider(d.key);if(null!=e){const a={clientId:this._clientId};a.size=this._isLoadMoreOnScroll()?this.getFetchSize():-1;const s=e.fetchFirst(a)[Symbol.asyncIterator]();this._cachedIteratorsAndResults[null===d.key?"root":d.key]={iterator:s,cache:null};return this._fetchNextFromIterator(s,d.key,a,n).then(this.handleNextItemInResults.bind(this,a,t,r,n))}}return this.handleNextItemInResults(e,t,r,n)},this._checkFinalResults=(e,t)=>t.value.data.length>=e.size&&-1!==e.size,this._updateMetadata=(e,t,a)=>{let n=0;const r=this._getLastItemByParentKey(t,a),s=null==r?0:r.metadata.indexFromParent+1,l=null===this.getChildDataProvider(e.key);if(null!=t){n=this._getItemByKey(t,a).metadata.treeDepth+1}const i=this._isExpanded(e.key);return{key:e.key,isLeaf:l,parentKey:t,indexFromParent:s,treeDepth:n,expanded:i}},this._updateAllMetadata=(e,t,a)=>{let n;return e&&e.length>0&&(n=[],e.forEach(e=>{n.push(this._updateMetadata(e,t,a))})),n},this._getIndexByKey=(e,t)=>{let a=-1;return t.some(function(t,n){if(t.key===e)return a=n,!0}),a},this._getLastItemByParentKey=(e,t)=>{let a=null;if(t&&t.value.metadata.slice().reverse().some(function(n,r){if(n.parentKey===e)return a={data:t.value.data[r],metadata:n},!0}),a)return a;const n=this.callback.getData();return n&&n.value.metadata.slice().reverse().some(function(t,r){if(t.parentKey===e)return a={data:n.value.data[r],metadata:t},!0}),a},this._getItemByKey=(e,t)=>{let a=null;if(t&&t.value.metadata.some(function(n,r){if(n.key===e)return a={data:t.value.data[r],metadata:n},!0}),a)return a;const n=this.callback.getData();return n&&n.value.metadata.some(function(t,r){if(t.key===e)return a={data:n.value.data[r],metadata:t},!0}),a},this.expand=e=>{const t=this.fetchNextFromChildDataProvider(e);if(null==t)return;const a=setTimeout(function(){this.callback?.getExpandingKeys().has(e)&&this.callback.updateSkeletonKeys(e)}.bind(this),250);t.then(function(t){null!=this.callback&&this.callback.updateExpand(function(n,r,s,l){if(a&&clearTimeout(a),r.has(e)&&(r=r.delete([e])),!s.has(e)||!l.has(e))return{expandedSkeletonKeys:r};if(null==t)return{expandedSkeletonKeys:r,expandingKeys:s.delete([e])};let i=this.getUpdatedData([t],n,[e]);return{expandedSkeletonKeys:r,expandingKeys:s=s.delete([e]),renderedData:i}}.bind(this))}.bind(this))},this._recacheData=(e,t)=>{for(let a=e.length-1;a>=0;a--){const n=e[a],r=t[a],s=r.parentKey,l=this._cachedIteratorsAndResults[null===s?"root":s].cache;null==l?this._cachedIteratorsAndResults[null===s?"root":s].cache={done:!1,value:{data:[n],metadata:[r]}}:(l.value.data.unshift(n),l.value.metadata.unshift(r))}},this._registerDomScroller=()=>{const t={asyncIterator:{next:this.fetchMoreRows.bind(this)},fetchSize:this.getFetchSize(),fetchTrigger:this.callback.getSkeletonHeight()*this.getLoadMoreCount(),maxCount:this.getMaxCount(),initialRowCount:this.getFetchSize(),strategy:e.VirtualizationStrategy.HIGH_WATER_MARK,isOverflow:this._getOverflowFunc(),success:this.handleFetchSuccess.bind(this),error:()=>{this._setNewData(null)},beforeFetch:()=>this.handleBeforeFetchNext(),beforeFetchByOffset:()=>{this.handleBeforeFetchByOffset()}};this.domScroller=new s(this._getScroller(),this.getDataProvider(),t)},this.getLoadMoreCount=()=>0,this._getOverflowFunc=()=>this._getScroller()!==this.root?this._isLastItemInViewport.bind(this):null,this._isLastItemInViewport=()=>{const e="."+this.callback.getItemStyleClass()+", ."+this.callback.getGroupStyleClass(),t=this.root.querySelectorAll(e),a=t[t.length-1];if(a){const e=a.getBoundingClientRect();if(e.top>=0&&e.bottom<=document.documentElement.clientHeight)return!1}return!0},this._cachedIteratorsAndResults={},this._clientId=Symbol(),this.fetchRows()}postRender(){this.initialFetch=!1}destroy(){super.destroy(),this.domScroller&&this.domScroller.destroy()}_isLoadMoreOnScroll(){return"loadMoreOnScroll"===this.scrollPolicy}_getScroller(){const e=this.scrollPolicyOptions.scroller;return null!=e?e:this.root}getFetchSize(){return this.scrollPolicyOptions.fetchSize}getMaxCount(){return this.scrollPolicyOptions.maxCount}isInitialFetch(){return this.initialFetch}renderSkeletonsForLoadMore(){}renderSkeletonsForExpand(e){}renderFetchedData(e){if(null==this.callback)return;const t=this._renderOutOfRangeData();if(null==e||null==e.value)return t;const a=e.value.data,r=e.value.metadata;return a.length===r.length?(t.push(this.renderData(a,r)),this._isLoadMoreOnScroll()&&(e.done||(0===a.length&&n.info("handleFetchedData: zero data returned while done flag is false"),e.maxCountLimit||(null==this.domScroller&&this._registerDomScroller(),t.push(this.renderSkeletonsForLoadMore()))),e.maxCountLimit&&this._handleScrollerMaxRowCount()),t):void 0}handleBeforeFetchNext(){return!this.isFetching()}handleBeforeFetchByOffset(){}handleFetchSuccess(e){null!=e&&this._setNewData(e)}_handleFetchError(e){this.setFetching(!1),n.error("iterating dataprovider content handler fetch error :"+e)}renderData(e,t){if(null==this.callback)return null;let a=[];const r=this.callback.getSkeletonKeys();for(let s=0;s<e.length;s++){if(null==e[s]||null==t[s])continue;if(!this.verifyKey(t[s].key)){n.error("encounted a key with invalid data type.  Acceptable data types for key are: "+this.validKeyTypes),a=[];break}const l=this.addItem(t[s],s,e[s],!0);l&&(a.push(l),r.has(t[s].key)&&a.push(this.renderSkeletonsForExpand(t[s].key)))}return a}_renderOutOfRangeData(){return[]}_handleItemsMutated(e,t,a,n){null!=this.callback&&this.callback.updateData(function(r,s){let l=s;const i={startIndex:r.startIndex,done:r.done,value:{data:r.value.data.slice(0),metadata:r.value.metadata.slice(0)}},o=Array.from(e[t]),d=o.map(e=>this._findIndex(r.value.metadata,e));this.domScroller&&a(d);const h=isNaN(r.startIndex)?0:r.startIndex,c=Math.max(h+r.value.data.length,this.getFetchSize());let u=!1;if(d.forEach((t,a)=>{const r=o[a],s=null!=e.data?e.data[a]:null,d=null!=e.metadata?e.metadata[a]:null;if(t>=h&&t<=c){const e=n(i,r,t,s,d,l);null!=e&&(l=e),u=!0}}),u)return l!==s?{renderedData:i,expandingKeys:l}:{renderedData:i}}.bind(this))}_findIndex(e,a){for(let n=0;n<e.length;n++)if(t.KeyUtils.equals(a,e[n].key))return n;return-1}_findKeyForLastChild(e,t,a){if(0===a)return n.warn("Maximum number of levels exceed"),null;const r=e.filter(e=>e.parentKey==t);if(r.length>0){const t=r[r.length-1].key;return this._findKeyForLastChild(e,t,a-1)||t}return null}_findIndexForNewGroup(e,t){if(0===t)return 0;const a=e.filter(e=>null==e.parentKey);if(0===a.length)return 0;const n=a[t-1].key,r=this._findKeyForLastChild(e,n,5);return(r?this._findIndex(e,r):this._findIndex(e,n))+1}_findIndexForLastItem(e,t){let a=-1;const n=this._getLastItemByParentKey(e,t);if(n){const e=t.value.metadata,r=this._findKeyForLastChild(e,n.metadata.key,5);a=r?this._findIndex(e,r):this._findIndex(e,n.metadata.key),a>-1&&(a+=1)}return null==n||-1===a?-1:a}handleModelRefresh(e){e?.keys?.size>0?this.handleModelRefreshChildren(e.keys):(this.domScroller&&this.domScroller.destroy(),this.domScroller=null,this._cachedIteratorsAndResults={},super.handleModelRefresh())}fetchNextFromChildDataProvider(e){const t=this.getChildDataProvider(e);if(null===t)return null;const a=this.getFetchSize();let n={clientId:this._clientId,size:a},r=t.fetchFirst(n)[Symbol.asyncIterator]();return this._cachedIteratorsAndResults[e]={iterator:r,cache:null},this._fetchNextFromIterator(r,e,n,{value:{data:[],metadata:[]}})}getUpdatedData(e,t,a){let n,r,s,l=t;if(l&&a.forEach((t,a)=>{let i=l.value.data,o=l.value.metadata,d=this._getIndexByKey(t,o);if(-1!==d){let t=e[a].value.data,h=e[a].value.metadata;const c=t.length;let u=i.slice(0,d+1).concat(t),m=o.slice(0,d+1).concat(h),f=l.done;c<this.getFetchSize()?(r=null,s=null,u=u.concat(i.slice(d+1)),m=m.concat(o.slice(d+1))):(r=i.slice(d+1),s=o.slice(d+1),r.length>0&&(f=!1,null!=this.domScroller&&this.domScroller.setAsyncIterator({next:this.fetchMoreRows.bind(this)}))),l={value:{data:u,metadata:m},done:f},n=l}}),null==n){let t=e.map(e=>e.value.data),a=e.map(e=>e.value.metadata);n={value:{data:t,metadata:a},done:!0}}return null!=r&&this._recacheData(r,s),n}handleModelRefreshChildren(e){const t=[],a=[];for(let n of e){const e=this.fetchNextFromChildDataProvider(n);null!=e&&(t.push(e),a.push(n))}Promise.all(t).then(e=>{null!=this.callback&&this.callback.updateData(t=>(t&&a.forEach(e=>{let a=t.value.metadata,n=this._getIndexByKey(e,a);if(-1!==n){const e=d.getLocalDescendentCount(a,n);t.value.data.splice(n+1,e),t.value.metadata.splice(n+1,e)}}),{renderedData:this.getUpdatedData(e,t,a)}))})}handleItemsAdded(e){if(null==this.callback)return;const t=()=>{this.callback.updateData((t,a)=>{const n={startIndex:t.startIndex,done:t.done,maxCountLimit:t.maxCountLimit,value:{data:t.value.data.slice(0),metadata:t.value.metadata.slice(0)}};let r=e.indexes;const s=e.addBeforeKeys,l=e.parentKeys,i=[];let o;return null!=r&&0!=r?.length||null!=s&&0!=s?.length||null!=l&&0!=l?.length?l?.length>0&&(null==r&&(r=[]),l.forEach((t,a)=>{const l=e.data[a],d=e.metadata[a];let h=-1;if(null===t||this._isExpanded(t)&&this._getItemByKey(t,null))if(null!=s){if(null!=s[a]){h=this._findIndex(n.value.metadata,s[a])}else if(h=this._findIndexForLastItem(t,n),-1===h)return}else if(a<r.length)if(null==t)h=this._findIndexForNewGroup(n.value.metadata,r[a]);else{if(h=this._findIndex(n.value.metadata,t),-1===h)return;h+=r[a]+1}else if(h=this._findIndexForLastItem(t,n),-1===h)return;h>-1?(n.value.data.splice(h,0,l),o=this._updateMetadata(d,t,n),n.value.metadata.splice(h,0,o),-1===r.indexOf(h)&&r.push(h),this._isExpanded(d.key)&&i.push(d.key)):this._isExpanded(t)&&n.done&&!n.maxCountLimit&&(n.value.data.push(l),n.value.metadata.push(d))})):n.done&&!n.maxCountLimit&&(n.value.data.push(...e.data),o=this._updateAllMetadata(e.metadata,null,n),n.value.metadata.push(...o)),this.domScroller&&this.domScroller.handleItemsAdded&&this.domScroller.handleItemsAdded(r),{expandingKeys:a.add(i),renderedData:n}}),super.handleItemsAdded(e)};null==e.data||null==e.metadata?this.getValidatedEventDetailPromise=this.getValidatedEventDetail(e).then(()=>{null!=e.data&&null!=e.metadata&&t()}):t()}handleItemsRemoved(e){this._handleItemsMutated(e,"keys",e=>{this.domScroller.handleItemsRemoved&&this.domScroller.handleItemsRemoved(e)},(e,t)=>{const a=this._findIndex(e.value.metadata,t);if(a>-1){const t=d.getLocalDescendentCount(e.value.metadata,a)+1;e.value.data.splice(a,t),e.value.metadata.splice(a,t)}}),super.handleItemsRemoved(e)}handleCurrentRangeItemUpdated(){}handleItemsUpdated(e){const t=()=>{this._handleItemsMutated(e,"keys",e=>{this.domScroller.handleItemsUpdated&&this.domScroller.handleItemsUpdated(e)},(e,t,a,n,r,s)=>{const l=e.value.metadata[a],i=l.isLeaf,o=this._updateMetadata(r,l.parentKey,{value:{data:[n],metadata:[r]}});return i&&!o.isLeaf&&(s=s.add([o.key])),e.value.data.splice(a,1,n),e.value.metadata.splice(a,1,o),this.handleCurrentRangeItemUpdated(),s}),super.handleItemsUpdated(e)};null==e.data||null==e.metadata?this.getValidatedEventDetailPromise=this.getValidatedEventDetail(e).then(()=>{null!=e.data&&null!=e.metadata&&t()}):t()}checkViewport(){if(this.domScroller&&this.isReady()){const e=this.domScroller.checkViewport();null!=e&&this.fetchPromise!==e&&(this.fetchPromise=e,e.then(function(e){this.fetchPromise=null,null!=e&&this.handleFetchSuccess(e)}.bind(this)))}}collapse(e){e.forEach(function(e){null!=this._cachedIteratorsAndResults[e]&&(this._cachedIteratorsAndResults[e].iterator=null,this._cachedIteratorsAndResults[e].cache=null)}.bind(this))}}d.getLocalDescendentCount=(e,t)=>{let a=0;const n=e[t].treeDepth,r=e.length;for(let s=t+1;s<r;s++){if(!(e[s].treeDepth>n))return a;a+=1}return a};class h extends HTMLElement{}e.IteratingDataProviderContentHandler=class extends l{constructor(t,a,n,r,s){super(t,a,n),this.root=t,this.dataProvider=a,this.callback=n,this.scrollPolicy=r,this.scrollPolicyOptions=s,this.fetchRows=()=>{if(this.isReady()){this.setFetching(!0);const e={clientId:this._clientId};e.size=this._isLoadMoreOnScroll()?this.getFetchSize():-1,this.dataProviderAsyncIterator=this.getDataProvider().fetchFirst(e)[Symbol.asyncIterator]();const t=this.addBusyState("call next on iterator"),a=this.dataProviderAsyncIterator.next(),n=e.size,r=e=>{if(e.done||-1!==n||"function"==typeof this.getDataProvider().getPageCount)return e;return this.dataProviderAsyncIterator.next().then(function(t){return e.done=t.done,e.value.data=e.value.data.concat(t.value.data),e.value.metadata=e.value.metadata.concat(t.value.metadata),r(e)},function(e){this.fetchError(e)})};a.then(e=>r(e),e=>(t(),this.setFetching(!1),this.fetchError(e),Promise.reject(e))).then(e=>{if(e){if(t(),null==this.callback)return;this.initialFetch=!0,this.callback.setData(e)}},e=>{if(null!=this.callback){const t={error:e,done:!0,value:{data:[],metadata:[]}};this.callback.setData(t)}})}},this._registerDomScroller=t=>{let a={fetchSize:this.getFetchSize(),maxCount:this.getMaxCount(),keys:t,strategy:this.isRenderingViewportOnly()?e.VirtualizationStrategy.VIEWPORT_ONLY:e.VirtualizationStrategy.HIGH_WATER_MARK};this.domScroller=new o(this._getScroller(),this.getDataProvider(),this.dataProviderAsyncIterator,this,a)},this._clientId=Symbol(),this.fetchRows()}getDataProvider(){if(null==this.wrappedDataProvider){const e=this.dataProvider.getCapability("fetchCapability");null==e||null==e.caching||"none"==e.caching?this.wrappedDataProvider=new r(this.dataProvider):this.wrappedDataProvider=this.dataProvider}return this.wrappedDataProvider}setDataProvider(e){this.wrappedDataProvider=null,this.dataProvider=e}postRender(){this.initialFetch=!1}destroy(){super.destroy(),this.domScroller&&this.domScroller.destroy()}isRenderingViewportOnly(){return!1}_isLoadMoreOnScroll(){return"loadMoreOnScroll"===this.scrollPolicy}_getScroller(){const e=this.scrollPolicyOptions.scroller;return null!=e?e:this.root}getFetchSize(){return this.scrollPolicyOptions.fetchSize}getMaxCount(){return this.scrollPolicyOptions.maxCount}isInitialFetch(){return this.initialFetch}checkViewport(){if(this.domScroller)return this.domScroller.checkViewport()}renderSkeletonsForLoadMore(){}renderFetchedData(e){if(null==this.callback)return;const t=[];if(null==e||null==e.value)return t;const a=e.value.data,r=e.value.metadata,s=void 0===e.startIndex?0:e.startIndex;if(a.length===r.length){if(t.push(this.renderData(a,r,s)),this._isLoadMoreOnScroll()){if(!e.done&&(0===a.length&&n.info("handleFetchedData: zero data returned while done flag is false"),!e.maxCountLimit)){if(null==this.domScroller){const e=r.map(e=>e.key);this._registerDomScroller(e)}t.push(this.renderSkeletonsForLoadMore())}e.maxCountLimit&&this._handleScrollerMaxRowCount()}return this.setFetching(!1),t}}beforeFetchNext(){return null==this.domScrollerFetchResolve&&(this.domScrollerFetchResolve=this.addBusyState("dom scroller call next on iterator"),!0)}beforeFetchByOffset(e,t){return null==this.domScrollerFetchResolve&&(this.domScrollerFetchResolve=this.addBusyState("dom scroller call next on iterator")),!0}fetchSuccess(e){this.domScrollerFetchResolve(),this.domScrollerFetchResolve=null,null!=e&&null!=this.callback&&this.callback.setData(e)}fetchError(e){this.domScrollerFetchResolve&&(this.domScrollerFetchResolve(),this.domScrollerFetchResolve=null),"notValid"!==e&&n.error("an error occurred during data fetch, reason: "+e)}renderData(e,t,a){if(null==this.callback)return null;let r=[];for(let s=0;s<e.length;s++){if(null==e[s]||null==t[s])continue;if(!this.verifyKey(t[s].key)){n.error("encounted a key with invalid data type.  Acceptable data types for key are: "+this.validKeyTypes),r=[];break}const l=this.addItem(t[s].key,s+a,e[s],!0);l&&r.push(l)}return r}_handleItemsMutated(e,t,a){this.callback.updateData(function(n){const r={startIndex:n.startIndex,done:n.done,value:{data:n.value.data.slice(0),metadata:n.value.metadata.slice(0)}};let s=e.indexes;const l=Array.from(e[t]);null==s&&(s=l.map(e=>this._findIndex(n.value.metadata,e)));const i=isNaN(n.startIndex)?0:n.startIndex,o=Math.max(i+n.value.data.length,this.getFetchSize());return s.forEach((t,n)=>{const s=l[n],d=null!=e.data?e.data[n]:null,h=null!=e.metadata?e.metadata[n]:null;t>=i&&t<=o&&a(r,s,t,d,h)}),{renderedData:r}}.bind(this))}_findIndex(e,a){for(let n=0;n<e.length;n++)if(t.KeyUtils.equals(a,e[n].key))return n;return-1}handleModelRefresh(){this.domScroller&&this.domScroller.destroy(),this.domScroller=null,super.handleModelRefresh()}handleItemsAdded(e){const t=()=>{this.callback.updateData(t=>{let a={startIndex:t.startIndex,done:t.done,maxCountLimit:t.maxCountLimit,value:{data:t.value.data.slice(0),metadata:t.value.metadata.slice(0)}};const n=e.indexes,r=e.addBeforeKeys,s=e.keys;if(null==n&&null==r)a.done&&!a.maxCountLimit&&(a.value.data.push(e.data),a.value.metadata.push(e.metadata));else{let t=0;s.forEach(()=>{const s=e.data[t],l=e.metadata[t];let i=-1;null!=n&&null!=n[t]?i=n[t]:null!=r&&null!=r[t]&&(i=this._findIndex(a.value.metadata,r[t])),i>-1&&(i<a.value.data.length||!this._isLoadMoreOnScroll())?(a.value.data.splice(i,0,s),a.value.metadata.splice(i,0,l)):a.done&&!a.maxCountLimit&&(a.done=!1,null==this.domScroller?this._registerDomScroller([]):this.domScroller.setAsyncIterator(this.dataProviderAsyncIterator)),t++})}return{renderedData:a}}),super.handleItemsAdded(e)};null==e.data||null==e.metadata?this.getValidatedEventDetailPromise=this.getValidatedEventDetail(e).then(()=>{null!=e.data&&null!=e.metadata&&t()}):t()}handleItemsRemoved(e){this._handleItemsMutated(e,"keys",(e,t)=>{const a=this._findIndex(e.value.metadata,t);a>-1&&(e.value.data.splice(a,1),e.value.metadata.splice(a,1))}),super.handleItemsRemoved(e)}handleCurrentRangeItemUpdated(e){}handleItemsUpdated(e){const t=()=>{this._handleItemsMutated(e,"keys",(e,t,a,n,r)=>{e.value.data.splice(a,1,n),e.value.metadata.splice(a,1,r),this.handleCurrentRangeItemUpdated(t)}),super.handleItemsUpdated(e)};null==e.data||null==e.metadata?this.getValidatedEventDetailPromise=this.getValidatedEventDetail(e).then(()=>{null!=e.data&&null!=e.metadata&&t()}):t()}},e.IteratingTreeDataProviderContentHandler=d,e.KeyedElement=h,e.VirtualizeDomScroller=o,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojvcollection.js.map