/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["require","ojs/ojcore-base","jquery","ojs/ojcontext","ojs/ojthemeutils","ojs/ojcomponentcore","ojs/ojanimation","ojs/ojdomutils","ojs/ojlogger","ojs/ojconfig","ojs/ojkeyset","ojs/ojselector","ojdnd","ojs/ojcustomelement-utils","ojs/ojdatacollection-common","ojs/ojtranslation"],function(e,t,n,s,i,a,o,r,l,h,d,c,_,u,E,f){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n,s=s&&Object.prototype.hasOwnProperty.call(s,"default")?s.default:s;class m{constructor(e,t={keyAttributes:"id",childrenAttribute:"children"},n=(e=>new Map(e)),s=(e=>new Set(e))){this.data=e,this.createOptimizedKeyMap=n,this.createOptimizedKeySet=s,this.keyAttr=t.keyAttributes,this.childrenAttr=t.childrenAttribute;const i=(e,t,n)=>{e.forEach(e=>{n.add(e[this.keyAttr]),e[this.childrenAttr]&&e[this.childrenAttr].length>0&&(t.set(e[this.keyAttr],e),i(e[this.childrenAttr],t,n))})};this.parentKeyNodeMap=this.createOptimizedKeyMap(),this.allKeys=this.createOptimizedKeySet(),i(this.data,this.parentKeyNodeMap,this.allKeys)}computeSelection(e,t=new d.KeySetImpl){const n=this.normalizeKeySet(e),s=this.normalizeKeySet(t),i=n.delete(s.values()),a=s.delete(n.values()),o=this.reduceToLeaves(a.values()),r={selectedLeaves:this.createOptimizedKeySet(new Set([...[...n.values()].filter(e=>!this.parentKeyNodeMap.has(e)),...this.reduceToLeaves(i.values())].filter(e=>!o.has(e)))),selectedParents:this.createOptimizedKeySet(),partialParents:this.createOptimizedKeySet()};return this.assignParentSelection({children:this.data},{selected:0,partial:0},r),r.selected=this.createOptimizedKeySet([...r.selectedLeaves.values(),...r.selectedParents.values()]),{selected:new d.KeySetImpl(r.selected),selectedLeaves:new d.KeySetImpl(r.selectedLeaves),selectedParents:new d.KeySetImpl(r.selectedParents),partialParents:new d.KeySetImpl(r.partialParents)}}reduceToLeaves(e){const t=(e,n)=>{this.parentKeyNodeMap.has(e[this.keyAttr])?e[this.childrenAttr].forEach(e=>t(e,n)):n.add(e[this.keyAttr])},n=this.createOptimizedKeySet();return e.forEach(e=>this.parentKeyNodeMap.has(e)?t(this.parentKeyNodeMap.get(e),n):n.add(e),this),n}assignParentSelection(e,t,n){if(void 0!==e[this.keyAttr]&&!this.parentKeyNodeMap.has(e[this.keyAttr]))n.selectedLeaves.has(e[this.keyAttr])&&(t.selected+=1);else{const s={selected:0,partial:0};if(e[this.childrenAttr].forEach(e=>this.assignParentSelection(e,s,n)),void 0===e[this.keyAttr]||s.selected+s.partial===0)return;s.selected===e[this.childrenAttr].length?(n.selectedParents.add(e[this.keyAttr]),t.selected+=1):(n.partialParents.add(e[this.keyAttr]),t.partial+=1)}}normalizeKeySet(e){return e.isAddAll()?new d.KeySetImpl(this.allKeys).delete(e.deletedValues()):e}}t.__registerWidget("oj.ojTreeView",n.oj.baseComponent,{version:"1.0.0",defaultElement:"<div>",widgetEventPrefix:"oj",options:{currentItem:null,data:null,dnd:{drag:null,drop:null},expanded:new d.KeySetImpl,item:{focusable:null,renderer:null,selectable:null},scrollPolicyOptions:{maxCount:500},selected:new d.KeySetImpl,selection:[],selectionMode:"none",animateEnd:null,animateStart:null,beforeCollapse:null,beforeCurrentItem:null,beforeExpand:null,collapse:null,expand:null},constants:{TREEVIEW_CONTENT_PADDING_REM:.5,PERIOD:".",OJ_COMPLETE:"oj-complete",OJ_TREEVIEW_LIST:"oj-treeview-list",ERROR_FETCHING_DATA:"Error fetching data: ",OJ_ITEM_DATA:"oj-item-data",OJ_ITEM_METADATA:"oj-item-metadata",OJ_TREEVIEW_ITEM_CONTENT:"oj-treeview-item-content",OJ_TREEVIEW_SELECTOR:"oj-treeview-selector",OJ_COMPONENT_ICON:"oj-component-icon",OJ_DRAGGABLE:"oj-draggable",OJ_TREEVIEW_SPACER:"oj-treeview-spacer",OJ_TREEVIEW_LEAF:"oj-treeview-leaf",OJ_TREEVIEW_DISCLOSURE_ICON:"oj-treeview-disclosure-icon",OJ_DEFAULT:"oj-default",OJ_EXPANDED:"oj-expanded",OJ_TREEVIEW_SKELETON_CONTAINER:"oj-treeview-skeleton-container",OJ_COLLAPSED:"oj-collapsed",OJ_TREEVIEW_ANIMATED:"oj-treeview-animated",OJ_SELECTED:"oj-selected",OJ_TREEVIEW_DRAG_SOURCE:"oj-treeview-drag-source",OJ_TREEVIEW_SKELETON_CONTENT:"oj-treeview-skeleton-content",OJ_ANIMATION_SKELETON:"oj-animation-skeleton",OJ_TREEVIEW_ITEM:"oj-treeview-item",OJ_HOVER:"oj-hover",OJ_CLICKABLE_ICON_NOCONTEXT:"oj-clickable-icon-nocontext",OJ_TREEVIEW_DROPLINE:"oj-treeview-drop-line",OJ_TREEVIEW_SELECT_SINGLE:"oj-treeview-select-single",OJ_TREEVIEW_ICON:"oj-treeview-icon",OJ_TREEVIEW_DRAG_IMAGE:"oj-treeview-drag-image",OJ_TREEVIEW_DRAG_IMAGE_ITEM:"oj-treeview-drag-image-item",OJ_FOCUS:"oj-focus",OJ_TREEVIEW_DROP_ZONE:"oj-treeview-drop-zone",OJ_FOCUS_HIGHLIGHT:"oj-focus-highlight",OJ_ANIMATION_SKELETON_FADE_IN:"oj-animation-skeleton-fade-in",OJ_TREEVIEW_SKELETON_CHILD:"oj-treeview-skeleton-child",OJ_TREEVIEW_SKELETON_CARROT:"oj-treeview-skeleton-carrot",OJ_TREEVIEW_SKELETON_ITEM:"oj-treeview-skeleton-item",OJ_TREEVIEW_SKELETON_LEAF:"oj-treeview-skeleton-leaf",OJ_TREEVIEW_ITEM_ICON:"oj-treeview-item-icon",OJ_TREEVIEW_SELECTED_TOP_ITEM:"oj-selected-item-content-top",OJ_TREEVIEW_SELECTED_BOTTOM_ITEM:"oj-selected-item-content-bottom",OJ_TREEVIEW_CSS_VARS:{expandAnimation:"--oj-private-tree-view-global-expand-animation",collapseAnimation:"--oj-private-tree-view-global-collapse-animation",dataFadeInDuration:"--oj-private-tree-view-global-data-fadein-duration",multipleSelectionAffordance:"--oj-private-tree-view-global-selection-affordance-default",loadIndicator:"--oj-private-tree-view-global-load-indicator-default",showIndicatorDelay:"--oj-private-core-global-loading-indicator-delay-duration"}},_ComponentCreate:function(){this._super()},_AfterCreate:function(){this._super(),this._initRender(),this._render(),this._isInitFetch=!0},_CompareOptionValues:function(e,n,s){switch(e){case"selection":return n&&void 0===n.inverted&&(n.inverted=!1),s&&void 0===s.inverted&&(s.inverted=!1),(!n||!s||n.inverted===s.inverted)&&t.KeyUtils.equals(n,s);case"selected":return E.areKeySetsEqual(n,s);default:return this._super(e,n,s)}},_initRender:function(){var e=this;this._on(this.element,{click:function(t){e._handleClick(t)},mouseover:function(t){e._handleMouseOver(t)},mouseout:function(t){e._handleMouseOut(t)},mousedown:function(t){e._handleMouseDown(t)},mouseup:function(t){e._handleMouseUp(t)},keydown:function(t){e._handleKeyDown(t)},dragstart:function(t){e._handleDragStart(t)},drag:function(t){e._handleDragSourceEvent(t,"drag")},dragend:function(t){e._handleDragSourceEvent(t,"dragEnd")},dragenter:function(t){e._handleDropTargetEvent(t,"dragEnter")},dragover:function(t){e._handleDropTargetEvent(t,"dragOver")},dragleave:function(t){e._handleDropTargetEvent(t,"dragLeave")},drop:function(t){e._handleDropTargetEvent(t,"drop")}}),r.isTouchSupported()&&(this.element[0].addEventListener("touchstart",function(t){e.isTouchDrag=!1,e.contextMenuOpen=!1,e.touchStartEvent=t},{passive:!0}),this.element[0].addEventListener("touchmove",function(t){e.isTouchDrag&&t.preventDefault()},{passive:!1}),this.element[0].addEventListener("touchcancel",function(){e.touchStartEvent=null,e.isTouchDrag=!1}),this.element[0].addEventListener("touchend",function(t){e.isTouchDrag=!1,e.touchStartEvent&&t.changedTouches.length&&document.elementFromPoint(t.changedTouches[0].clientX,t.changedTouches[0].clientY)!==e.touchStartEvent.target&&(e.touchStartEvent=null),e._handleMouseOut(t)})),this.element[0].addEventListener("focusin",e=>{this._getParents(e.target,this.constants.PERIOD+this.constants.OJ_TREEVIEW_SELECTOR).length>0&&this._getRoot().focus({preventScroll:!0})}),this._dropLine=document.createElement("div"),this._dropLine.classList.add(this.constants.OJ_TREEVIEW_DROPLINE),this.element[0].appendChild(this._dropLine);const t=document.createElement("div");t.classList.add("oj-helper-hidden-accessible"),t.setAttribute("role","status"),this.element[0].appendChild(t),this._dropLine.style.display="none",this._refreshId=0,this._uiExpanded=new d.KeySetImpl,this.m_fetching=new Map,this._expandedChildrenMap=new Map,this._syncSelectionState()},_syncSelectionState:function(){var e=d.KeySetUtils.toArray(this.options.selected),t=d.KeySetUtils.toKeySet(this.options.selection);e.length>0||e.inverted?this._userOptionChange("selection",e,null):(this.options.selection.length>0||this.options.selection.inverted)&&this._userOptionChange("selected",t,null)},_render:function(){var e=this;this.element[0].classList.remove(this.constants.OJ_COMPLETE),this._keyList=new Set;var t,n=this.element[0].querySelectorAll("ul");if(this.options.data){for(t=0;t<n.length;t++)n[t].parentNode.removeChild(n[t]);this._fetchChildren(null,function(t){var n=t.values[0];e._truncateIfOverMaxCount(n.value);var s={fetchListResult:n.value,parentElem:e.element[0]};e._renderItems(s).then(function(){e._resetFocus(),e.element[0].classList.add(e.constants.OJ_COMPLETE),e._decorateTree(),e._lastSelectedItem=null})})}else{for(t=0;t<n.length;t++)n[t].classList.add(this.constants.OJ_TREEVIEW_LIST),n[t].setAttribute("role","group");var s=this.element[0].querySelectorAll("li");for(t=0;t<s.length;t++){var i=this._getItemContent(s[t]);if(i){var a=this._getItemDisclosureIcon(i);a&&i.removeChild(a)}e._decorateItem(s[t])}this._resetFocus(),this._decorateTree(),this._isLeafOnlySelectionEnabled()&&(this._rawData=this._buildStaticRawData([],this._getRoot()),this._initLeafOnlySelectionMode()),this.element[0].classList.add(this.constants.OJ_COMPLETE)}},_buildStaticRawData:function(e,t){for(let n=0;n<t.children.length;n++){const s={key:this._getKey(t.children[n])};this._isLeaf(t.children[n])||(s.children=this._buildStaticRawData([],this._getSubtree(t.children[n]))),e.push(s)}return e},_getDataProvider:function(){var n,s=this;if(null==s.m_dataSource){if(n=s.options.data,!t.DataProviderFeatureChecker.isTreeDataProvider(n)){var i=new Promise(function(t,n){e(["ojs/ojtreedataprovideradapter"],function(e){t(function(e){if(e&&e.__esModule)return e;var t={};return e&&Object.keys(e).forEach(function(n){var s=Object.getOwnPropertyDescriptor(e,n);Object.defineProperty(t,n,s.get?s:{enumerable:!0,get:function(){return e[n]}})}),t.default=e,t}(e))},n)});if(!i)throw new Error("Error adapting a TreeDataSource");return i.then(e=>new e.default(n))}}else n=s.m_dataSource;return Promise.resolve(n)},_fetchChildren:function(e,t){var n=this,s=n._addBusyState("getting data provider",e),i=n._getDataProvider(),a=this._refreshId;i.then(function(i){if(s(),n._refreshId===a){n.m_dataSource=i;var o=null===e?i:i.getChildDataProvider(e);if(null!=o){var r=n._addBusyState("fetching data",e),h=n._getShowStatusDelay();n._isSkeletonSupported()&&(n._skeletonTimeout=setTimeout(function(){var t=n._expandedChildrenMap.get(null);if(null===e)n._changeStatusMessage(null,!1),n._renderInitialSkeletons();else if(!t&&!n._isParentSkeletonRendered(e)&&!n._isLeafOnlySelectionEnabled()){var s=n._getItemByKey(e);s&&(n._getSubtree(s)||(n._renderChildSkeletons(e),n._changeStatusMessage(e,!1)))}},h));var d=n._loadTemplateEngine();n._clientId=n._clientId||Symbol();var c={clientId:n._clientId,size:-1},_=o.fetchFirst(c)[Symbol.asyncIterator](),u=_.next(),E=function(t){if(t[0].done){if(n._clearSkeletonTimeout(),n._isLeafOnlySelectionEnabled()&&n._buildRawData(e,t[0]),n._isSkeletonSupported()){for(var s=[],i=t[0].value.data,o=0;o<i.length;o++){var h=t[0].value.metadata[o].key;n._isInitExpanded(h)&&n.m_dataSource.getChildDataProvider(h)&&s.push(h)}n._expandedChildrenMap.set(e,s);var d=n._expandedChildrenMap.get(e);if(d){var c=d.indexOf(e);c>-1&&d.splice(c,1)}if(!d||0===d.length)return{values:t,shouldRemoveSkeleton:!0}}return{values:t,shouldRemoveSkeleton:!1}}return _.next().then(function(e){return n._refreshId!==a?null:(t[0].done=e.done,t[0].value.data=t[0].value.data.concat(e.value.data),t[0].value.metadata=t[0].value.metadata.concat(e.value.metadata),E(t))},function(e){l.error(n.constants.ERROR_FETCHING_DATA+e),r()})};Promise.all([u,d]).then(function(e){return n._refreshId!==a?null:E(e)},function(e){return Promise.reject(e)}).then(function(e){n._refreshId===a?(t(e),r()):r()},function(e){l.error(n.constants.ERROR_FETCHING_DATA+e);var t=n._getSkeletonContainer(n.element[0]);n._isSkeletonSupported()&&t&&n._removeSkeleton(null),r()})}}},function(e){l.error(n.constants.ERROR_FETCHING_DATA+e),s(),n._expandedChildrenMap=new Map,n.m_fetching=new Map})},_clearSkeletonTimeout:function(){this._skeletonTimeout&&(clearTimeout(this._skeletonTimeout),this._skeletonTimeout=null)},_buildRawData:function(e,t){null===e?this._rawData=t.value.metadata:this._findParentAndAddChildren(this._rawData,t.value.metadata,e)},_findParentAndAddChildren:function(e,t,n){for(var s=0;s<e.length;s++){if(e[s].key===n)return void(e[s].children=t);e[s].children&&this._findParentAndAddChildren(e[s].children,t,n)}},_isParentSkeletonRendered:function(e){for(var t=this._getItemByKey(e),n=this._getParents(t,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM),s=0;s<n.length;s++){var i=this._getKey(n[s]);if(this._expandedChildrenMap.get(i))return!0}return!1},_getShowStatusDelay:function(){const e=this._getOptionDefaults();return r.getCSSTimeUnitAsMillis(e.showIndicatorDelay)},_renderItems:function(e){return new Promise(function(t){var n=document.createElement("ul");n.classList.add(this.constants.OJ_TREEVIEW_LIST),n.setAttribute("role","group");var s=this._getSkeletonContainer(this.element[0]);(s&&this._isSkeletonSupported()||this._isLeafOnlySelectionEnabled())&&(n.style.display="none"),e.parentElem.appendChild(n);for(var i=0;i<e.fetchListResult.data.length;i++)this._renderItem(n,e.fetchListResult,i);s&&this._isSkeletonSupported()&&!this._isLeafOnlySelectionEnabled()?this._toggleParentDisplay(e.parentElem,t):t()}.bind(this))},_getScrollPolicyOptions:function(){return this.options.scrollPolicyOptions},_validateScrollPolicyOptions:function(e){var t=this._getScrollPolicyOptions(),n=this._getTreeViewItemCount()+e;return t.maxCount<n&&l.info("ScrollPolicyOptions max count of ["+t.maxCount+"] has been reached."),n-t.maxCount},_truncateIfOverMaxCount:function(e){const t=e.data.length,n=this._validateScrollPolicyOptions(t);n===t?(e.data=[],e.metadata=[]):n>0&&(e.data.splice(-n,t),e.metadata.splice(-n,t))},_toggleParentDisplay:function(e,t){var n=this._getKey(e);e===this.element[0]&&(n=null);var s=this._expandedChildrenMap.get(n);if(s&&s.length>0)t();else{let e=null;for(e of this._expandedChildrenMap.keys()){var i,a,o=this._expandedChildrenMap.get(e);null===e?(i=this.element[0],a=this._getRoot()):(i=this._getItemByKey(e),a=this._getSubtree(i),this._setItemExpanded(i)),a&&0===o.length&&this._resolveNoChildren(e,i,a,t);for(var r=o.length-1;r>=0;r--)o[r]===n&&a&&(o.splice(r,1),0===o.length&&this._resolveNoChildren(e,i,a,t))}t()}},_resolveNoChildren:function(e,t,n,s){this._expandedChildrenMap.delete(e),this._getSkeletonContainer(t)&&!this._isLeafOnlySelectionEnabled()?this._foundSkeleton(e,n,s):this._isLeafOnlySelectionEnabled()||(n&&(n.style.display="block"),this._toggleParentDisplay(t,s))},_foundSkeleton:function(e,t,n){this._removeSkeleton(e).then(function(){t&&(t.style.display="block");var e=this._getOptionDefaults();o.fadeIn(t,{duration:e.dataFadeInDuration}),n()}.bind(this))},_renderItem:function(e,t,s,i,o){var r,l,h=this,d=t.data[s],c=t.metadata[s],_=c.key;if(!o){if(this._keyList.has(_))throw new Error("JET TreeView nodes should not have duplicated keys: "+_);this._keyList.add(_)}var u=document.createElement("li");if(o){var f=this._getItemByKey(_);if(!f)return;e=f.parentNode;var m=this._getSubtree(f);f.parentNode.replaceChild(u,f)}else null==i||i>=e.children.length?e.appendChild(u):e.insertBefore(u,e.children[i]);var p={parentElement:n(u),index:s,data:d,datasource:h.options.data,parentKey:h._getKey(h._getParentItem(u)),metadata:c,component:a.__GetWidgetConstructor(h.element)};h._FixRendererContext&&(p=h._FixRendererContext(p));var g=h.m_dataSource.getChildDataProvider(_);c.leaf=null===g,c.depth=this._getDepth(u);var v=Object.keys(c);for(r=0;r<v.length;r++){var I=v[r];p[I]=c[I]}var y=h.options.item.renderer;y=h._WrapCustomElementRenderer(y);var O=this._getItemTemplate(),S=this._getTemplateEngine();if(null!=y)E.applyRendererContent(u,y.call(h,p),!0);else if(null!=O&&null!=S){var T=h.element[0],C=S.execute(T,O,p,null);for(r=0;r<C.length;r++){if("LI"===C[r].tagName){u.parentNode.replaceChild(C[r],u),u=C[r];break}u.appendChild(C[r])}}else(l=document.createElement("span")).appendChild(document.createTextNode(null==d?"":d.toString())),u.appendChild(l);o&&m&&u.appendChild(m),u=e.children[null!=i?i:s],p.parentElement=n(u),u.hasAttribute("id")||u.setAttribute("id",this._getUniqueItemId()),u[this.constants.OJ_ITEM_DATA]=d,u[this.constants.OJ_ITEM_METADATA]=c,h._decorateItem(u)},_getDepth:function(e){for(var t=0,n=e;n&&n!==this.element[0];)n=n.parentElement.parentElement,t+=1;return t},_loadTemplateEngine:function(){return null!=this._getItemTemplate()&&null==this.options.item.renderer?new Promise(e=>{const t={customElement:this._GetCustomElement()};h.__getTemplateEngine(t).then(t=>{this.m_engine=t,e(t)},e=>{throw new Error("Error loading template engine: "+e)})}):Promise.resolve(null)},_getTemplateEngine:function(){return this.m_engine},_getItemTemplate:function(){if(void 0===this.m_template){this.m_template=null;var e=this._getSlotMap().itemTemplate;e&&e.length>0&&"template"===e[0].tagName.toLowerCase()&&(this.m_template=e[0])}return this.m_template},_getSlotMap:function(){return u.CustomElementUtils.getSlotMap(this.element[0])},_decorateTree:function(){var e=this,t=this._getRoot();if(t){this._focusable({element:n(t),applyHighlight:!0,setupHandlers:function(t,n){e._focusInHandler=t,e._focusOutHandler=n}}),t.setAttribute("tabIndex",0),n(t).on("focus",function(){e._focusInHandler(n(e._getItemContent(e._currentItem)))}).on("blur",function(){e._focusOutHandler(n(e._getItemContent(e._currentItem)))}),t.setAttribute("role","tree"),t.setAttribute("aria-labelledby",this.element[0].getAttribute("id"));var s=this.options.selectionMode;"none"!==s?t.setAttribute("aria-multiselectable",this._isMultiSelectionEnabled()||this._isLeafOnlySelectionEnabled()?"true":"false"):t.removeAttribute("aria-multiselectable"),"single"===s&&this.element[0].classList.add(this.constants.OJ_TREEVIEW_SELECT_SINGLE),this.element[0].setAttribute("tabIndex",-1),this.element[0].addEventListener("focus",()=>{this._getRoot().focus()}),this.element[0].addEventListener("blur",()=>{this._getRoot().blur()}),this._refreshTopAndBottomSelectionClasses()}},_isMultiSelectionEnabled:function(){return"multiple"===this.options.selectionMode},_isLeafOnlySelectionEnabled:function(){return"leafOnly"===this.options.selectionMode},_isDefaultCheckBoxesEnabled:function(){return"selector"===this._getOptionDefaults().multipleSelectionAffordance&&(this._isMultiSelectionEnabled()||this._isLeafOnlySelectionEnabled())},_refreshSelectionItems:function(){if("none"===this.options.selectionMode)return;const e=this._getSelected(),t=this._getItemsInSelectedKeySet(e),n=this._getSelectedItemContents();for(let e=n.length-1;e>=0;e--){const s=n[e].parentElement,i=t.indexOf(s);-1!==i?t.splice(i,1):this._setUnselected(s)}for(let e=0;e<t.length;e++)this._setSelected(t[e]);this._isLeafOnlySelectionEnabled()&&this._updateIndeterminateState(this._selectedKeysets.partialParents),this._refreshTopAndBottomSelectionClasses()},_getItemsInSelectedKeySet:function(e){const t=[];return e.isAddAll()?this._getItems().forEach(n=>{const s=this._getKey(n);!e.deletedValues().has(s)&&this._isActionable(n,"select")&&t.push(n)}):e.values().forEach(e=>{const n=this._getItemByKey(e);n&&this._isActionable(n,"select")&&t.push(n)}),t},_decorateItem:function(e){e.classList.add(this.constants.OJ_TREEVIEW_ITEM),e.setAttribute("role","treeitem");var t=this._getKey(e),n=this._getItemContent(e);if(!n){if((n=document.createElement("div")).classList.add(this.constants.OJ_TREEVIEW_ITEM_CONTENT),this._isDefaultCheckBoxesEnabled()&&this._isActionable(e,"focus")&&this._isActionable(e,"select")){var i=document.createElement("span");i.classList.add(this.constants.OJ_TREEVIEW_SELECTOR);var a=document.createElement("oj-selector");this._getSelected().has(t)?a.selectedKeys=new d.KeySetImpl([t]):a.selectedKeys=new d.KeySetImpl,a.setAttribute("aria-hidden","true"),a.setAttribute("data-oj-binding-provider","none"),a.setAttribute("selection-mode","multiple"),a.addEventListener("selectedKeysChanged",function(e){if("internal"===e.detail.updatedFrom){var t=this._getItemByKey(e.target.rowKey);this._focus(t,e);var n=this._getSelected();n.has(e.target.rowKey)?n=n.delete([e.target.rowKey]):(n=n.add([e.target.rowKey]),this._selectionAnchor=e.target.rowKey),this._userSelectedOptionChange(n,e)}}.bind(this)),a.rowKey=t,i.appendChild(a),n.appendChild(i),s.getContext(a).getBusyContext().whenReady().then(()=>{E.disableAllFocusableElements(a)})}if(e.firstChild)do{n.appendChild(e.firstChild)}while(e.childNodes.length>0);e.appendChild(n);var o=n.getElementsByTagName("ul")[0];o&&e.appendChild(o);var r=n.querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM_ICON);for(let e=0;e<r.length;e++)r[e].classList.add(this.constants.OJ_TREEVIEW_ICON),r[e].classList.add(this.constants.OJ_COMPONENT_ICON)}this._select(e),n.setAttribute("draggable",this._isDnD()?"true":"false");var l=this._getItemDisclosureIcon(n),h=this._getItemSpacer(n);l||(l=document.createElement("ins"),this._addTreeViewIconClass(l),h?n.insertBefore(l,h.nextElementSibling):n.insertBefore(l,n.children[0])),h||(h=document.createElement("span"),this._addTreeviewSpacerClass(h),n.insertBefore(h,l)),this._addIndentation(e,h),this._isDnD()&&(e.classList.add(this.constants.OJ_DRAGGABLE),n.classList.add(this.constants.OJ_DRAGGABLE)),this._isLeaf(e)?this._addTreeviewLeafClass(e):this._isInitExpanded(t)?(this._expand(e,!1),this._addDisclosureClasses(l)):(this._collapse(e,!1),this._addDisclosureClasses(l))},_addIndentation:function(e,t){let n=this._getDepth(e)-1;const s=t.style,a="redwood"===i.parseJSONFromFontFamily("oj-theme-json").behavior;let o=0;this._hasIcon(e)&&a&&(o=n*this.constants.TREEVIEW_CONTENT_PADDING_REM),this._isLeaf(e)&&(n+=1),s.width="calc(calc("+n+" * var(--oj-tree-view-indent-width)) + "+o+"rem)"},_hasIcon:function(e){return e.querySelectorAll(".oj-treeview-icon.oj-component-icon").length>0},_removeIndentation:function(e){e.style.removeProperty("width"),e.removeAttribute("class"),e.classList.add(this.constants.OJ_TREEVIEW_SPACER)},_addTreeviewSpacerClass:function(e){e.classList.add(this.constants.OJ_TREEVIEW_SPACER)},_addTreeViewIconClass:function(e){e.classList.add(this.constants.OJ_TREEVIEW_ICON)},_addTreeviewLeafClass:function(e){e.classList.add(this.constants.OJ_TREEVIEW_LEAF)},_removeTreeviewLeafClass:function(e){e.classList.remove(this.constants.OJ_TREEVIEW_LEAF)},_addDisclosureClasses:function(e){e.classList.add(this.constants.OJ_TREEVIEW_DISCLOSURE_ICON),e.classList.add(this.constants.OJ_COMPONENT_ICON),e.classList.add(this.constants.OJ_CLICKABLE_ICON_NOCONTEXT),e.classList.add(this.constants.OJ_DEFAULT)},_removeDisclosureClasses:function(e){e.classList.remove(this.constants.OJ_TREEVIEW_DISCLOSURE_ICON),e.classList.remove(this.constants.OJ_COMPONENT_ICON),e.classList.remove(this.constants.OJ_CLICKABLE_ICON_NOCONTEXT),e.classList.remove(this.constants.OJ_DEFAULT)},_getItems:function(){return this.element[0].querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM)},_getKey:function(e){if(!e)return null;var t=e[this.constants.OJ_ITEM_METADATA];return t?t.key:e.getAttribute("id")},_getItemByKey:function(e){for(var n,s=this.element[0].getElementsByTagName("li"),i=0;i<s.length;i++){var a=s[i][this.constants.OJ_ITEM_METADATA];if(a&&t.KeyUtils.equals(a.key,e)){n=s[i];break}}if(n)return n;if("string"==typeof e){var o=document.getElementById(e),r=this._getRoot();if(r&&o&&r.contains(o))return o}},_getItemContent:function(e){if(!e)return null;for(var t=e.children,n=0;n<t.length;n++)if(e.children[n].classList&&e.children[n].classList.contains(this.constants.OJ_TREEVIEW_ITEM_CONTENT))return e.children[n];return null},_getChildItems:function(e){var t=[],n=e.getElementsByClassName(this.constants.OJ_TREEVIEW_LIST)[0];if(n)for(var s=n.children,i=0;i<s.length;i++)t.push(s[i]);return t},_getParentItem:function(e){var t=this._getParents(e,".oj-treeview-list")[0];return this._getParents(t,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM)[0]},_getSubtree:function(e){return e.getElementsByClassName(this.constants.OJ_TREEVIEW_LIST)[0]},_getRoot:function(){return this.element[0].getElementsByClassName(this.constants.OJ_TREEVIEW_LIST)[0]},_isLeaf:function(e){if(!e)return null;var t=e[this.constants.OJ_ITEM_METADATA];return!(t?!t.leaf:void 0!==this._getSubtree(e))},_isInitExpanded:function(e,t){var n=null!=t?t:this.options.expanded;return!(!n||!n.has)&&n.has(e)},_isExpanded:function(e){return e.classList.contains(this.constants.OJ_EXPANDED)},_isDisclosing:function(e){return!(!e||!this.m_disclosing)&&this.m_disclosing.indexOf(e)>-1},_setDisclosing:function(e,t){if(null!=e)if(null==this.m_disclosing&&(this.m_disclosing=[]),t)this.m_disclosing.push(e);else for(var n=this.m_disclosing.indexOf(e);n>-1;)this.m_disclosing.splice(n,1),n=this.m_disclosing.indexOf(e)},_expand:function(e,t,n,s){var i=this;if(!(this._isExpanded(e)||this._isLeaf(e)||t&&this._isDisclosing(this._getKey(e)))){if(t&&!this._trigger("beforeExpand",n,this._getEventPayload(e))&&!1!==s)return;n&&this._isActionable(e,"focus")&&this._focus(e,n);var a=this._getSubtree(e),o=i._getKey(e);if(!a)return this._uiExpanded=this._uiExpanded.add([o]),void this._fetchChildren(o,function(s){if((!i._isExpanded(e)||i._isSkeletonSupported())&&(i._isInitExpanded(o)||i._isInitExpanded(o,i._uiExpanded))){var r=s.values[0];i._truncateIfOverMaxCount(r.value);var l=e.getElementsByClassName(i.constants.OJ_TREEVIEW_SKELETON_CONTAINER).length,h={fetchListResult:r.value,parentElem:e};i._isSkeletonSupported()&&l>0&&s.shouldRemoveSkeleton&&!i._isLeafOnlySelectionEnabled()?i._renderItems(h).then(function(){var t=e.offsetHeight,s=3*t,o=t*r.value.data.length;a=i._getSubtree(e);var l={startMaxHeight:s+"px",endMaxHeight:o+"px"};o>s?i._animateSkeletonRemoval("expand",e,a,l,n):o<s?i._animateSkeletonRemoval("collapse",e,a,l,n):i._animateSkeletonRemoval("fadeIn",e,a,l,n)}):i._isSkeletonSupported()&&l>0?i._renderItems(h).then(function(){i._setExpandedState(i,e,n),i.isReady()&&i._isLeafOnlySelectionEnabled()&&i._initLeafOnlySelectionMode()}):i._renderItems(h).then(function(){i._expandAfterFetch(e,t,n),i.isReady()&&i._isLeafOnlySelectionEnabled()&&i._initLeafOnlySelectionMode()})}});this._expandAfterFetch(e,t,n)}},_initLeafOnlySelectionMode:function(){let e=e=>new Map(e);this.options.data&&this.options.data.createOptimizedKeyMap&&(e=e=>this.options.data.createOptimizedKeyMap(e));let t=e=>new Set(e);this.options.data&&this.options.data.createOptimizedKeySet&&(t=e=>this.options.data.createOptimizedKeySet(e)),this.treeviewSelectionManager=new m(this._rawData,{keyAttributes:"key",childrenAttribute:"children"},e,t),this._userSelectedOptionChange(this._filterOutParentKeys(this._getSelected()),null,!0);var n=this._getRoot();this._getSkeletonContainer(this.element[0])?this._removeSkeleton(null).then(function(){n&&(n.style.display="block");var e=this._getOptionDefaults();o.fadeIn(n,{duration:e.dataFadeInDuration})}.bind(this)):n&&(n.style.display="block")},_setItemExpanded:function(e){e.classList.remove(this.constants.OJ_COLLAPSED),e.classList.add(this.constants.OJ_EXPANDED),this._setAriaExpanded(e,"true")},_animateSkeletonRemoval:function(e,t,n,s,i){var a=this._getKey(t);this._removeSkeleton(a).then(function(){this._setItemExpanded(t);var r=this,l=this._getOptionDefaults();n.style.display="block",o.fadeIn(n,{duration:l.dataFadeInDuration}).then(function(){var o=this._addBusyState("animating skeleton removal",a);t.classList.add(this.constants.OJ_TREEVIEW_ANIMATED),this._setDisclosing(this._getKey(t),!0),"expand"===e?this._startAnimation(n,"expand",s).then(this._resolveAnimationPromise(r,t,i,o)):"collapse"===e?this._startAnimation(n,"collapse",s).then(this._resolveAnimationPromise(r,t,i,o)):this._resolveAnimationPromise(r,t,i,o)()}.bind(this))}.bind(this))},_expandAfterFetch:function(e,t,n){this._setItemExpanded(e);var s=this._getKey(e),i=this._getSubtree(e);if(i&&(i.style.display="block"),t){var a=this._addBusyState("animating expand",s);e.classList.add(this.constants.OJ_TREEVIEW_ANIMATED),this._setDisclosing(s,!0),this._startAnimation(i,"expand").then(this._resolveAnimationPromise(this,e,n,a))}},_setExpandedState:function(e,t,n){e._setDisclosing(e._getKey(t),!1),t.classList.remove(e.constants.OJ_TREEVIEW_ANIMATED),e._trigger("expand",n,e._getEventPayload(t));var s=e.options.expanded.add([e._getKey(t)]);e._refreshTopAndBottomSelectionClasses(),e._userOptionChange("expanded",s,n)},_resolveAnimationPromise:function(e,t,n,s){return function(){this._setExpandedState(e,t,n),s()}.bind(this)},_collapse:function(e,t,n,s){var i=this,a=this._getKey(e);if(!(e.classList.contains(this.constants.OJ_COLLAPSED)||this._isLeaf(e)||t&&this._isDisclosing(a))){if(n&&this._isActionable(e,"focus"))this._focus(e,n);else if(e.contains(this._currentItem)){var o=e;this._isActionable(o,"focus")||(o=this._getPreviousActionableItem(e,"focus"))||(o=this._getNextActionableItem(e,"focus")),o?this._focus(o,n):(this.options.currentItem=null,this._resetFocus())}if(t){if(!this._trigger("beforeCollapse",n,this._getEventPayload(e))&&!1!==s)return;this._setDisclosing(a,!0)}e.classList.remove(this.constants.OJ_EXPANDED),e.classList.add(this.constants.OJ_COLLAPSED),this._setAriaExpanded(e,"false");var r=this._getSubtree(e);if(t){var l=this._addBusyState("animating collapse",a);e.classList.add(this.constants.OJ_TREEVIEW_ANIMATED),this._uiExpanded=this._uiExpanded.delete([a]),this._startAnimation(r,"collapse").then(function(){i._setDisclosing(a,!1),r.style.display="none",e.classList.remove(i.constants.OJ_TREEVIEW_ANIMATED),i._trigger("collapse",n,i._getEventPayload(e));var t=i.options.expanded.delete([a]);i._refreshTopAndBottomSelectionClasses(),i._userOptionChange("expanded",t,n),l()})}else r&&(r.style.display="none",this._refreshTopAndBottomSelectionClasses());this._isLeafOnlySelectionEnabled()&&!r&&this._fetchChildren(a,function(t){var n=t.values[0];i._truncateIfOverMaxCount(n.value);var s={fetchListResult:n.value,parentElem:e};i._renderItems(s).then(function(){i.isReady()&&i._isLeafOnlySelectionEnabled()&&i._initLeafOnlySelectionMode()})})}},_startAnimation:function(e,t,n){var s={};null==s[t]&&(s[t]=JSON.parse(this._getOptionDefaults()[`${t}Animation`]));var i=s[t];return n&&("expand"!==i.effect&&"collapse"!==i.effect||Object.assign(i,n)),o.startAnimation(e,t,i,this)},_getEventPayload:function(e){return{key:this._getKey(e),item:e}},_isActionable:function(e,t){var n=this.options.item[t+"able"];return!1!==n&&("function"!=typeof n||n(this.getContextByNode(e)))},_isSelected:function(e){var t=this.options.selectionMode,n=this._getSelected();if("none"===t)return!1;var s=this._getKey(e);return n.has(s)},_getSelected:function(){return this._isLeafOnlySelectionEnabled()&&this._selectedKeysets?this._selectedKeysets.selected:this.options.selected},_select:function(e,t){if("none"!==this.options.selectionMode&&this._isActionable(e,"focus")&&this._isActionable(e,"select")){var n=this._isSelected(e);if(t){var s=t.key||t.keyCode,i=t.originalEvent.sourceCapabilities&&t.originalEvent.sourceCapabilities.firesTouchEvents,a=r.isTouchSupported()&&(i||null!=this.touchStartEvent&&this.touchStartEvent.target===t.target),o=r.isMetaKeyPressed(t),l=E.isArrowUpKeyEvent(s)||E.isArrowDownKeyEvent(s),h=this._getKey(e),c=new d.KeySetImpl;if((this._isMultiSelectionEnabled()||this._isLeafOnlySelectionEnabled())&&t.shiftKey&&!l&&this._selectionAnchor){let t=this._getItemByKey(this._selectionAnchor);o&&(c=this._getSelected());for(var _=t&&t.offsetTop<e.offsetTop?this._getNextActionableItem.bind(this):this._getPreviousActionableItem.bind(this);t&&t!==e;){var u=this._getKey(t);c.has(u)||(c=c.add([u])),t=_(t,"select")}n=!0,c=c.add([h])}else(this._isMultiSelectionEnabled()||this._isLeafOnlySelectionEnabled())&&(o||a||l)?(n=!n,c=this._getSelected(),c=n?c.add([h]):c.delete([h]),this._selectionAnchor=h):(a||E.isSpaceBarKeyEvent(s))&&n?(n=!1,c=new d.KeySetImpl):(n=!0,c=new d.KeySetImpl([h]),this._selectionAnchor=h);this._userSelectedOptionChange(c,t,!o&&!l&&!a)}n?this._setSelected(e):this._setUnselected(e)}},_getSelectorByItem:function(e){return e.getElementsByTagName("oj-selector")[0]},_updateIndeterminateState:function(e){if(this._isDefaultCheckBoxesEnabled()){var t,n,s=Array.from(this.element[0].getElementsByClassName("oj-indeterminate")),i=Array.from(e.values());for(n=s.length-1;n>=0;n--){var a=(t=s[n].parentElement).rowKey,o=i.indexOf(a);-1!==o?i.splice(o,1):t.indeterminate=!1}for(n=0;n<i.length;n++){var r=this._getItemByKey(i[n]);(t=this._getSelectorByItem(r)).indeterminate=!0}}},_setSelected:function(e){this._getItemContent(e).classList.add(this.constants.OJ_SELECTED),e.setAttribute("aria-selected","true");var t=this._getKey(e);this._setupSelector(t,e,!0)},_isHiddenElement:function(e){const t=this._getParents(e,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM);for(let n=1;n<t.length;n++){const s=this._getSubtree(t[n]);if(s&&"none"===s.style.display&&e!==t[n])return!0}return!1},_refreshTopAndBottomSelectionClasses:function(){if(this._isLeafOnlySelectionEnabled()||this._isMultiSelectionEnabled()){let e;this._getFlatList().forEach(t=>{const n=this._getItemContent(t);n.classList.remove(this.constants.OJ_TREEVIEW_SELECTED_TOP_ITEM),n.classList.remove(this.constants.OJ_TREEVIEW_SELECTED_BOTTOM_ITEM);const s=this._isSelected(t);if(!e&&s&&(n.classList.add(this.constants.OJ_TREEVIEW_SELECTED_TOP_ITEM),e=t),e&&s){const s=this._getNextItem(t);s&&this._isSelected(s)||(n.classList.add(this.constants.OJ_TREEVIEW_SELECTED_BOTTOM_ITEM),e=null)}})}},_setUnselected:function(e){this._getItemContent(e).classList.remove(this.constants.OJ_SELECTED),e.setAttribute("aria-selected","false");var t=this._getKey(e);this._setupSelector(t,e,!1)},_clearSelection:function(){for(var e=this._getSelectedItemContents(),t=e.length-1;t>=0;t--)this._setUnselected(e[t].parentElement);(this._isLeafOnlySelectionEnabled()||this._isMultiSelectionEnabled())&&(this.element[0].querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_SELECTED_TOP_ITEM).forEach(e=>{e.classList.remove(this.constants.OJ_TREEVIEW_SELECTED_TOP_ITEM)}),this.element[0].querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_SELECTED_BOTTOM_ITEM).forEach(e=>{e.classList.remove(this.constants.OJ_TREEVIEW_SELECTED_BOTTOM_ITEM)}))},_setupSelector:function(e,t,n){if(this._isDefaultCheckBoxesEnabled()){var s=this._getSelectorByItem(t);if(s){const t=n?[e]:[];n!==(null!==s.querySelector(this.constants.PERIOD+this.constants.OJ_SELECTED))&&(s.selectedKeys=new d.KeySetImpl(t))}}},_getSelectedItemContents:function(){return this.element[0].querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM_CONTENT+this.constants.PERIOD+this.constants.OJ_SELECTED)},_focus:function(e,t){if(this._isActionable(e,"focus")){if(t){var s=this._getEventPayload(e);if(this._currentItem&&(s.previousKey=this._getKey(this._currentItem),s.previousItem=this._currentItem),!this._trigger("beforeCurrentItem",t,s))return;this._userOptionChange("currentItem",this._getKey(e),t)}this._focusOutHandler(n(this._getItemContent(this._currentItem))),this._focusInHandler(n(this._getItemContent(e))),this._setCurrentItem(e)}},_resetFocus:function(){if(this.options.currentItem){var e=this._getItemByKey(this.options.currentItem);if(e)return void this._setCurrentItem(e)}var t=this._getItems()[0];this._isActionable(t,"focus")||(t=this._getNextActionableItem(t,"focus")),this._setCurrentItem(t),this._userOptionChange("currentItem",this._getKey(this._currentItem),null)},_setCurrentItem:function(e){this._currentItem=e;var t=this._getRoot();t&&e&&t.setAttribute("aria-activedescendant",this._getItemId(e))},_getItemId:function(e){return e.getAttribute("id")},_getUniqueItemId:function(){return u.ElementUtils.getUniqueId()+"_"+this.element[0].getAttribute("id")},_getTreeViewItemCount:function(){return this._getItems().length},_addBusyState:function(e,t){var n=s.getContext(this.element[0]).getBusyContext(),i=this.element.attr("id"),a=n.addBusyState({description:"The component identified by '"+i+"', "+e});return this.m_fetching.has(t)?this.m_fetching.set(t,this.m_fetching.get(t)+1):this.m_fetching.set(t,1),function(){1===this.m_fetching.get(t)?this.m_fetching.delete(t):this.m_fetching.set(t,this.m_fetching.get(t)-1),a(),Promise.resolve(this._processEventQueue())}.bind(this)},_changeStatusMessage:function(e,t){const n=this.element[0].getElementsByClassName("oj-helper-hidden-accessible")[0];let s;const i=null!==e?this._getNodeTextByKey(e):this.element[0].getAttribute("id");s=t?f.getTranslatedString("oj-ojTreeView.receivedDataAria",{nodeText:i}):f.getTranslatedString("oj-ojTreeView.retrievingDataAria",{nodeText:i}),n.textContent!==s&&(n.textContent=s)},_getNodeTextByKey:function(e){const t=this._getItemByKey(e);if(t){const e=/[\n\r]+|[\s]{2,}/g;return this._getItemContent(t).textContent.replace(e," ").trim()}return null},_userOptionChange:function(e,t,n){this.option(e,t,{_context:{originalEvent:n,writeback:!0,internalSet:!0}})},_userSelectedOptionChange:function(e,t,n){let s=e;if(this._isLeafOnlySelectionEnabled()){let e=n?this._getEmptyKeySet(s):this._getSelected();this._selectedKeysets=this.treeviewSelectionManager.computeSelection(s,e),s=this._selectedKeysets.selectedLeaves}this._refreshTopAndBottomSelectionClasses(),this._userOptionChange("selected",s,t),this._userOptionChange("selection",d.KeySetUtils.toArray(s),t),this._refreshSelectionItems()},_getEmptyKeySet:function(e){return e.isAddAll()?new d.AllKeySetImpl:new d.KeySetImpl},_filterOutParentKeys:function(e){if(e.isAddAll()){let t=new d.AllKeySetImpl,n=[...e.deletedValues()].filter(e=>!this.treeviewSelectionManager.parentKeyNodeMap.has(e));return t=t.delete(n),t}return new d.KeySetImpl([...e.values()].filter(e=>!this.treeviewSelectionManager.parentKeyNodeMap.has(e)))},_getDragOptions:function(){return((this.options.dnd||{}).drag||{}).items||{}},_getDropOptions:function(){return((this.options.dnd||{}).drop||{}).items||{}},_getClosestItem:function(e){return this._closest(e,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM)},_getClosestItemContent:function(e){return this._closest(e,".oj-treeview-item-content")},_getClosestDisclosureIcon:function(e){return this._closest(e,".oj-treeview-disclosure-icon")},_handleClick:function(e){if(!E.isFromDefaultSelector(e)){var t,n=this._getClosestDisclosureIcon(e.target);if(n){t=this._getClosestItem(n);var s=this._getKey(t);if(this.m_fetching.has(s))return;return this._isExpanded(t)?this._collapse(t,!0,e):this._expand(t,!0,e),void(this.touchStartEvent=null)}var i=this._getClosestItemContent(e.target);if(i)return t=i.parentNode,this._select(t,e),this._focus(t,e),void(this.touchStartEvent=null);"none"!==this.options.selectionMode&&(this._clearSelection(),this._userSelectedOptionChange(new d.KeySetImpl,e)),this.touchStartEvent=null}},_isDnD:function(){var e=this._getDragOptions();return Object.keys(e).length>0},_handleMouseOver:function(e){if((!r.isTouchSupported()||!this.touchStartEvent)&&("none"!==this.options.selectionMode||this._isDnD())){var t=this._getClosestDisclosureIcon(e.target);t||(t=this._getClosestItemContent(e.target)),t&&(t.classList.remove(this.constants.OJ_DEFAULT),t.classList.add(this.constants.OJ_HOVER))}},_handleMouseOut:function(e){var t=this._getClosestDisclosureIcon(e.target);t&&t.classList.remove(this.constants.OJ_SELECTED),t||(t=this._getClosestItemContent(e.target)),t&&(t.classList.add(this.constants.OJ_DEFAULT),t.classList.remove(this.constants.OJ_HOVER))},_handleMouseDown:function(e){if(!E.isFromDefaultSelector(e)){var t=this._getClosestDisclosureIcon(e.target);t&&t.classList.add(this.constants.OJ_SELECTED)}},_handleMouseUp:function(e){var t=this._getClosestDisclosureIcon(e.target);t&&t.classList.remove(this.constants.OJ_SELECTED)},_handleKeyDown:function(e){var t,n=this._currentItem,s=e.key||e.keyCode;if(E.isArrowUpKeyEvent(s)||E.isArrowDownKeyEvent(s))(t=E.isArrowDownKeyEvent(s)?this._getNextActionableItem(n,"focus"):this._getPreviousActionableItem(n,"focus"))&&(e.preventDefault(),this._isSelected(n)&&e.shiftKey&&this._select(this._isSelected(t)?n:t,e),this._scrollToVisible(t),this._focus(t,e));else if(E.isArrowLeftKeyEvent(s)||E.isArrowRightKeyEvent(s)){var i="rtl"===this._GetReadingDirection(),a=!i&&E.isArrowRightKeyEvent(s)||i&&E.isArrowLeftKeyEvent(s);!a||this._isLeaf(n)||this._isExpanded(n)?a||this._isLeaf(n)||!this._isExpanded(n)?(t=a?this._getNextActionableItem(n,"focus"):this._getPreviousActionableItem(n,"focus"))&&(e.preventDefault(),this._focus(t,e)):(e.preventDefault(),this._collapse(n,!0,e)):(e.preventDefault(),this._expand(n,!0,e))}else E.isEnterKeyEvent(s)||E.isSpaceBarKeyEvent(s)?(e.preventDefault(),this._select(n,e)):E.isLetterAKeyEvent(s)&&r.isMetaKeyPressed(e)&&(this._isLeafOnlySelectionEnabled()||this._isMultiSelectionEnabled())&&(e.preventDefault(),this._userSelectedOptionChange(new d.AllKeySetImpl,e))},_scrollToVisible:function(e){const t=this.element[0],n=this._getItemSpacer(e).offsetHeight,s=t.getBoundingClientRect(),i=s.top,a=s.bottom,o=e.getBoundingClientRect(),r=o.top,l=o.top+n;r>=i&&l<=a||(r<i?t.scrollTop+=r-i-1:l>a&&(t.scrollTop+=l-a+1))},_getNextItem:function(e){if(!this._isLeaf(e)&&this._isExpanded(e)){var t=this._getChildItems(e)[0];if(t)return t}for(var n=e;n;){var s=this._getNextSibling(n,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM);if(s)return s;n=this._getParentItem(n)}return null},_getNextActionableItem:function(e,t){for(;null!=e;)if(null!=(e=this._getNextItem(e))&&this._isActionable(e,t))return e;return null},_getPreviousItem:function(e){for(var t=this._getPreviousSibling(e,this.constants.PERIOD+this.constants.OJ_TREEVIEW_ITEM);t;){if(this._isLeaf(t)||!this._isExpanded(t))return t;var n=this._getChildItems(t),s=n[n.length-1];if(!s)return t;t=s}var i=this._getParentItem(e);return i||null},_getPreviousActionableItem:function(e,t){for(;null!=e;)if(null!=(e=this._getPreviousItem(e))&&this._isActionable(e,t))return e;return null},_handleDragStart:function(e){var t=this,n="rtl"===this._GetReadingDirection(),s=this._getClosestItem(e.target);if(s){var i,a=[];if(this._isSelected(s)){var o=this.options.selection;for(i=0;i<o.length;i++){var r=this._getItemByKey(o[i]);r&&a.push(r)}}else this._select(s,e),a.push(s);this._refreshTopAndBottomSelectionClasses();var l=this._getDragOptions(),h=e.originalEvent.dataTransfer,d=document.createElement("ul");d.classList.add(this.constants.OJ_TREEVIEW_DRAG_IMAGE),d.classList.add(this.constants.OJ_TREEVIEW_LIST),E.isSafari()&&(d.style.position="absolute");var c,_=[],u=1/0,f=1/0;for(a.forEach(function(e){const s=e[t.constants.OJ_ITEM_DATA];s?_.push(s):_.push(e.parentElement.innerHTML);const i=e.getBoundingClientRect(),a=window.scrollX,o=window.scrollY,r=i.top+o;let l=i.left+a;const h=t._getItemContent(e).children;let c=0;for(var E=0;E<h.length;E++)c+=h[E].offsetWidth;l+=n?t._getTreeviewWidth()-c:c;const m=e.cloneNode(!0);m.style.top=r+"px",m.style.left=l+"px",e.classList.add(t.constants.OJ_TREEVIEW_DRAG_SOURCE),m.classList.add(t.constants.OJ_TREEVIEW_DRAG_IMAGE),m.classList.add(t.constants.OJ_TREEVIEW_DRAG_IMAGE_ITEM);var p=t._getSubtree(m);p&&m.removeChild(p);var g=t._getItemContent(m);t._setUnselected(m),g.classList.remove(t.constants.OJ_TREEVIEW_SELECTED_TOP_ITEM),g.classList.remove(t.constants.OJ_TREEVIEW_SELECTED_BOTTOM_ITEM),g.classList.remove(t.constants.OJ_FOCUS),g.classList.remove(t.constants.OJ_HOVER),g.classList.remove(t.constants.OJ_FOCUS_HIGHLIGHT),g.classList.remove(t.constants.OJ_DRAGGABLE);var v=m.getElementsByClassName(t.constants.OJ_TREEVIEW_SPACER)[0];if(v){var I=document.createElement("span");t._addTreeviewSpacerClass(I),g.insertBefore(I,v),g.removeChild(v)}if(t._isDefaultCheckBoxesEnabled()&&t._isActionable(e,"focus")&&t._isActionable(e,"select")){var y=m.getElementsByClassName(t.constants.OJ_TREEVIEW_SELECTOR)[0];y.firstChild.selectedKeys=t.options.selected,y.firstChild.rowKey=t._getKey(e)}r<u&&(u=r),l<f&&(f=l),d.appendChild(m)}),i=0;i<d.children.length;i++)(c=d.children[i]).style.top=parseFloat(c.style.top)-u+"px",c.style.left=parseFloat(c.style.left)-f+"px";var m=l.dataTypes,p="string"==typeof m?[m]:m||[];for(i=0;i<p.length;i++)h.setData(p[i],JSON.stringify(_));document.body.appendChild(d),h.setDragImage(d,e.pageX-f,e.pageY-u),setTimeout(function(){d.parentElement.removeChild(d)},0);var g=l.dragStart;g&&g(e.originalEvent,{items:_}),e.originalEvent.defaultPrevented&&a.forEach(e=>{e.classList.remove(this.constants.OJ_TREEVIEW_DRAG_SOURCE)})}},_handleDragSourceEvent:function(e,t){if(this.touchStartEvent&&this.contextMenuOpen&&"drag"===t)e.preventDefault();else{"dragEnd"===t&&(this._removeGhostElements(),this._dropLine.style.display="none");var n=this._getDragOptions()[t];n&&n(e.originalEvent)}},_getTreeviewWidth:function(){return this.element[0].offsetWidth},_getItemSpacer:function(e){return e.getElementsByClassName(this.constants.OJ_TREEVIEW_SPACER)[0]},_handleDropTargetEvent:function(e,t){var n=this._getDropOptions(),s=n.dataTypes,i="string"==typeof s?[s]:s||[],a=n[t],o=this._getClosestItem(e.target);if(o)if(this.touchStartEvent&&this.contextMenuOpen)e.preventDefault();else{!this.touchStartEvent||"dragEnter"!==t&&"dragOver"!==t&&"dragLeave"!==t||(this.isTouchDrag=!0);var r=this._getItemSpacer(o).getBoundingClientRect(),l="inside",h=e.originalEvent.clientY-r.top;h<.25*r.height?l="before":h>.75*r.height&&(l=this._isExpanded(o)?"first":"after"),a&&a(e.originalEvent,{item:o,position:l});for(var d=0;d<i.length;d++){var c=e.originalEvent.dataTransfer.types;if(c&&c.indexOf(i[d])>=0){e.preventDefault();break}}if("dragEnter"!==t&&"dragOver"!==t||!e.originalEvent.defaultPrevented)"drop"===t?(this._removeGhostElements(),this._dropLine.style.display="none",this._removeDropClass(o)):"dragLeave"===t&&(this.dragLeftTreeview=!0,"inside"!==l&&this._removeDropClass(o),setTimeout(()=>{this.dragLeftTreeview&&(this._dropLine.style.display="none",this.dragLeftTreeview=!1,this._removeAllDropZones())},50));else{this.dragLeftTreeview=!1;var _="rtl"===this._GetReadingDirection(),u=o.offsetTop;if("before"!==l&&(u+=r.height),"inside"!==l){var E,f=this._getParentItem(o);f&&this._isLeaf(o)?(E=r.width,E-=this._getItemDisclosureIcon(f).offsetHeight):f&&!this._isLeaf(o)?(E=r.width,"first"===l&&(E+=this._getItemDisclosureIcon(o).offsetHeight)):f||(E=0,"first"===l&&(E+=this._getItemDisclosureIcon(o).offsetHeight)),this._isExpanded(o)&&"before"!==l&&(E+=8),this._removeDropClass(o);var m=o.offsetWidth-parseInt(E,10)+"px",p=_?"0px":E+"px";this._dropLine.style.width=m,this._dropLine.style.left=p,this._dropLine.style.top=u+"px",this._dropLine.style.display=""}else this._dropLine.style.display="none",this._addDropClass(o)}}},_addDropClass:function(e){this._getItemContent(e).classList.add(this.constants.OJ_TREEVIEW_DROP_ZONE)},_removeDropClass:function(e){this._getItemContent(e).classList.remove(this.constants.OJ_TREEVIEW_DROP_ZONE)},_removeGhostElements:function(){for(var e=this.element[0].querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_DRAG_SOURCE),t=e.length-1;t>=0;t--)e[t].classList.remove(this.constants.OJ_TREEVIEW_DRAG_SOURCE)},_removeAllDropZones:function(){for(var e=this.element[0].querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_DROP_ZONE),t=e.length-1;t>=0;t--)e[t].classList.remove(this.constants.OJ_TREEVIEW_DROP_ZONE)},_NotifyContextMenuGesture:function(e,t,n){if("keyboard"===n){var s=this._currentItem?this._getItemContent(this._currentItem):this.element,i={launcher:this._getRoot(),initialFocus:"menu",position:{my:"start top",at:"start bottom",of:s}};this._OpenContextMenu(t,n,i)}else if(!this.isTouchDrag){this.touchStartEvent&&(this.contextMenuOpen=!0);var a=this._getClosestItem(t.target);a&&(this._setCurrentItem(a),this._userOptionChange("currentItem",this._getKey(this._currentItem),t),this._superApply(arguments))}},refresh:function(){this._super(),this._refreshId+=1,null!=this._getItemTemplate()&&this._cleanTemplateNodes(this._getRoot()),delete this.m_template,delete this.m_engine,delete this.m_dataSource,this._expandedChildrenMap=new Map,this.m_fetching=new Map,this._render()},getNodeBySubId:function(e){if(null==e)return this.element?this.element[0]:null;var t,n=e.key,s=e.subId,i=this._getItemByKey(n);return"oj-treeview-disclosure"===s&&i?t=i.getElementsByClassName(this.constants.OJ_TREEVIEW_DISCLOSURE_ICON)[0]:s===this.constants.OJ_TREEVIEW_ITEM&&i&&(t=i.getElementsByClassName(this.constants.OJ_TREEVIEW_ITEM_CONTENT)[0]),t||null},getSubIdByNode:function(e){if(!this.element[0].contains(e))return null;var t,n=this._getClosestDisclosureIcon(e),s=this._getClosestItem(e);if(n)t="oj-treeview-disclosure";else{if(!s)return null;t=this.constants.OJ_TREEVIEW_ITEM}return{subId:t,key:this._getKey(s)}},getContextByNode:function(e){if(!this.element[0].contains(e))return null;var t,n=this._getClosestItem(e);if(!n)return null;var s=n.parentNode.children,i=[];for(t=0;t<s.length;t++)s[t].classList.contains(this.constants.OJ_TREEVIEW_ITEM)&&i.push(s[t]);var o={subId:this.constants.OJ_TREEVIEW_ITEM,index:i.indexOf(n),parentKey:this._getKey(this._getParentItem(n))};o.component=a.__GetWidgetConstructor(this.element),this._FixRendererContext&&(o=this._FixRendererContext(o));var r=n[this.constants.OJ_ITEM_METADATA];if(r){o.metadata=r,o.data=n[this.constants.OJ_ITEM_DATA],o.datasource=this.options.data;var l=Object.keys(r);for(t=0;t<l.length;t++){var h=l[t];o[h]=r[h]}}else o.key=this._getKey(n),o.leaf=this._isLeaf(n),o.depth=this._getParents(n,".oj-treeview-list").length;return o},_setOption:function(e,t,n){var s,i,a=this;if(this._isLeafOnlySelectionEnabled()&&(!this._isLeafOnlySelectionEnabled()||"selected"===e&&"selection"===e)||this._superApply(arguments),"expanded"===e)for(this._uiExpanded=a._uiExpanded.clear(),this._expandedChildrenMap=new Map,i=this._getItems(),s=0;s<i.length;s++){var o=this._getKey(i[s]);a._isInitExpanded(o)?a._expand(i[s],!0):a._collapse(i[s],!0)}else if("selected"===e){if(this._isLeafOnlySelectionEnabled()){let e=t;e=this._filterOutParentKeys(e);let n=this._getEmptyKeySet(e);this._selectedKeysets=this.treeviewSelectionManager.computeSelection(e,n),t=this._selectedKeysets.selectedLeaves,arguments[1]=t,this._superApply(arguments)}var r=d.KeySetUtils.toArray(t);this._userOptionChange("selection",r,null),this._refreshSelectionItems()}else if("selection"===e){var l=d.KeySetUtils.toKeySet(t);if(this._isLeafOnlySelectionEnabled()){let e=l;e=this._filterOutParentKeys(e);let t=this._getEmptyKeySet(e);this._selectedKeysets=this.treeviewSelectionManager.computeSelection(e,t),l=this._selectedKeysets.selectedLeaves,arguments[1]=d.KeySetUtils.toArray(l),this._superApply(arguments)}this._userOptionChange("selected",l,null),this._refreshSelectionItems()}else"currentItem"===e?this._resetFocus():"data"===e?(this._removeDataProviderEventListeners(),this.options.data=t,this.options.data||this._getRoot().remove(),this._addDataProviderEventListeners(),this.refresh()):this.refresh()},_SetupResources:function(){this._super(),this._addDataProviderEventListeners(),this._isInitFetch?this._isInitFetch=!1:this.refresh()},_ReleaseResources:function(){this._super(),null!=this._getItemTemplate()&&this._cleanTemplateNodes(this._getRoot()),this._removeDataProviderEventListeners()},_VerifyConnectedForSetup:function(){return!0},_destroy:function(){null!=this._getItemTemplate()&&this._cleanTemplateNodes(this._getRoot()),this._removeDataProviderEventListeners(),this._super()},_cleanTemplateNodes:function(e){const t=this._getTemplateEngine();null!=e&&null!=t&&t.clean(e,this.element[0])},_addDataProviderEventListeners:function(){var e=this.options.data;e&&t.DataProviderFeatureChecker.isTreeDataProvider(e)&&(this.m_handleModelMutateEventListener=this.handleModelMutateEvent.bind(this),this.m_handleModelRefreshEventListener=this.handleModelRefreshEvent.bind(this),e.addEventListener("mutate",this.m_handleModelMutateEventListener),e.addEventListener("refresh",this.m_handleModelRefreshEventListener))},_removeDataProviderEventListeners:function(){var e=this.options.data;e&&t.DataProviderFeatureChecker.isTreeDataProvider(e)&&(e.removeEventListener("mutate",this.m_handleModelMutateEventListener),e.removeEventListener("refresh",this.m_handleModelRefreshEventListener))},handleModelMutateEvent:function(e){this._isLeafOnlySelectionEnabled()?l.error("Mutations are not supported in selectionMode: leafOnly  "):this.isReady()?(null!=e.detail.remove&&this.handleModelRemoveEvent(e),null!=e.detail.add&&this.handleModelAddEvent(e),null!=e.detail.update&&this.handleModelChangeEvent(e),this._processEventQueue()):this._pushToEventQueue(e)},_pushToEventQueue:function(e){null==this.m_eventQueue&&(this.m_eventQueue=[]),this.m_eventQueue.push(e)},_clearEventQueue:function(){null!=this.m_eventQueue&&(this.m_eventQueue.length=0)},_processEventQueue:function(){if(!this.isReady())return;let e;if(null!=this.m_eventQueue&&this.m_eventQueue.length>0){for(var t=0;t<this.m_eventQueue.length;t++)if(e=this.m_eventQueue[t],"refresh"===e.type&&(!e.detail||e.detail&&!e.detail.keys))return void this.handleModelRefreshEvent(e);e=this.m_eventQueue.shift(),"mutate"===e.type&&this.handleModelMutateEvent(e),"refresh"===e.type&&e.detail&&e.detail.keys&&this.handleModelRefreshEvent(e)}},isReady:function(){return 0===this.m_fetching.size},handleModelRemoveEvent:function(e){var n=this,s=e.detail.remove.keys,i=[];if(null==s||0===s.size)return;const a=this._getKey(this._currentItem),o=this._getFlatList(),r=o.indexOf(this._currentItem);if(s.forEach(function(s){let a;const o=e.detail.add,r=n._getKey(n._getParentItem(n._getItemByKey(s)));if(o&&o.parentKeys){const e=o.parentKeys.find(e=>t.KeyUtils.equals(e,r));e&&(a=e)}i=i.concat(n._removeAllChildrenOfParentKey(s,a,o&&o.keys.has(s)))}),0!==i.length){var l=this._getSelected();if(null!=l){var h=l.delete(i);l!==h&&this._userSelectedOptionChange(h,e)}this._refreshTopAndBottomSelectionClasses();var d=this.options.expanded;if(null!=d){var c=d.delete(i);this._uiExpanded.delete(i),d!==c&&this._userOptionChange("expanded",c,null)}if(!this._getItemByKey(a)){const t=this._getFlatList();let n=null;if(t.length>0){for(let e=r-1;e>=0;--e)if(t.includes(o[e])&&this._isActionable(o[e],"focus")){n=o[e];break}if(!n)for(let e=r;e<o.length;e++)if(t.includes(o[e])&&this._isActionable(o[e],"focus")){n=o[e];break}if(!n){const e=this._getItems();e.length>0&&(n=e[0])}if(n)return this._setCurrentItem(n),void this._userOptionChange("currentItem",this._getKey(this._currentItem),e)}}this._resetFocus()}},_getFlatList:function(){const e=[];return this._getItems().forEach(t=>{this._isHiddenElement(t)||e.push(t)}),e},_changeNodeToLeaf:function(e,t){if(e!==this.element[0]){e.removeChild(t),e[this.constants.OJ_ITEM_METADATA].leaf=!0,e.classList.add(this.constants.OJ_TREEVIEW_LEAF),e.classList.remove(this.constants.OJ_EXPANDED),e.removeAttribute("aria-expanded"),e.classList.remove(this.constants.OJ_COLLAPSED);var n=this._getItemSpacer(e);this._removeIndentation(n),this._addIndentation(e,n);var s=this._getKey(e),i=[];i.push(s);var a=this.options.expanded;if(null!=a){var o=a.delete(i);this._uiExpanded.delete(i),a!==o&&this._userOptionChange("expanded",o,null)}var r=this._getItemDisclosureIcon(e);this._removeDisclosureClasses(r)}},_changeNodeToParent:function(e){e[this.constants.OJ_ITEM_METADATA].leaf=!1,e.classList.remove(this.constants.OJ_TREEVIEW_LEAF),e.classList.add(this.constants.OJ_COLLAPSED),this._setAriaExpanded(e,"false");var t=this._getItemSpacer(e);this._removeIndentation(t),this._addIndentation(e,t);var n=this._getItemDisclosureIcon(e);this._addDisclosureClasses(n)},_setAriaExpanded:function(e,t){e.setAttribute("aria-expanded",t)},_getItemDisclosureIcon:function(e){return e.getElementsByTagName("ins")[0]},_removeAllChildrenOfParentKey:function(e,n,s){var i=this,a=[],o=this._getItemByKey(e);if(o){this._getChildItems(o).forEach(function(e){var t=i._getKey(e),o=i._removeAllChildrenOfParentKey(t,n,s);a=a.concat(o)});var r=o.parentNode;t.KeyUtils.equals(e,n)||(r.removeChild(o),this._cleanTemplateNodes(o),this._keyList.delete(e),s||a.push(e)),0!==r.getElementsByTagName("li").length||n||s||this._changeNodeToLeaf(r.parentNode,r)}return a},_isLeafIcon:function(e){return e.classList.contains(this.constants.OJ_TREEVIEW_LEAF)},handleModelReorder:function(e,t,n){var s=this._getItemByKey(t),i=s.parentElement,a=this._getItemByKey(e),o=a.parentElement,r=a.parentNode;o.removeChild(a),0===o.getElementsByTagName("li").length&&this._changeNodeToLeaf(r.parentNode,r),n?i.insertBefore(a,s.nextSibling):i.insertBefore(a,s)},getLastItemKey(e){return this._getKey(e[e.length-1])},handleModelAddEvent:function(e){var t=e.detail.add,n=t.parentKeys,s=t.indexes,i=0,a=this,o=e.detail.add.keys;const r=this._addBusyState("validating mutation data for add event",null);this._fetchEventDataForKeys(t).then(e=>{if(null===e)return void r();this._truncateIfOverMaxCount(e);const l=e.data,h=e.metadata;n.forEach(function(e){var t=a._getItemByKey(e);t&&a._isLeafIcon(t)&&a._changeNodeToParent(t)});const d=this._getAllTreeviewKeys(),c=E.getAddEventKeysResult(d,t,!0);if(l&&o.size>0&&l.length>0&&o.size===l.length&&(null==s||s.length===l.length)){for(i=0;i<l.length;i++){var _=n[i],u=this._getInsertIndex(h[i].key,_,c);if(null!==u){var f,m=this._getItemByKey(_);null==_?f=this._getRoot():m&&(f=this._getSubtree(m)),f&&this._renderItem(f,{data:[l[i]],metadata:[h[i]]},0,u)}}this._refreshTopAndBottomSelectionClasses()}r()})},_getInsertIndex:function(e,t,n){let s;if(s=t?this._getItemByKey(t):this.element[0],!s)return null;let i=n.indexOf(e);if(-1===i)return null;let a=this._getChildItems(s),o=a.length;for(let e=0;e<a.length;e++){let t=a[e],s=this._getKey(t);if(n.indexOf(s)>i){o=e;break}}return o},_getAllTreeviewKeys:function(){const e=[],t=this._getItems();for(let n=0;n<t.length;n++)e.push(this._getKey(t[n]));return e},handleModelChangeEvent:function(e){const t=e.detail.update,n=this._addBusyState("validating mutation data for change event",null);this._fetchEventDataForKeys(t).then(e=>{if(null===e)return void n();const t=[...e.keys];for(let n=0;n<t.length;n++){const s=this._getItemByKey(t[n]);if(null!=s){const t=this._indexToParent(s);this._renderItem(null,{data:[e.data[n]],metadata:[e.metadata[n]]},0,t,!0)}}this._resetFocus(),this._refreshTopAndBottomSelectionClasses(),n()})},_fetchEventDataForKeys:function(e){return new Promise(t=>{const n=this._addBusyState("getting data provider",null);this._getDataProvider().then(s=>{t(E.getEventDetail(s,e)),n()},function(e){l.error(this.constants.ERROR_FETCHING_DATA+e),n()})})},_indexToParent:function(e){for(var t=0,n=0;n<e.parentNode.children.length;n++)if(e.parentNode.children[n]===e){t=n;break}return t},handleModelRefreshEvent:function(e){this.isReady()?e.detail&&e.detail.keys?(e.detail.keys.forEach(e=>{const t=this._getItemByKey(e);if(t&&!this._isLeaf(t)){this._removeAllChildrenOfParentKey(e,e);const n=this._getSubtree(t);n&&t.removeChild(n),this._isExpanded(t)&&(t.classList.remove(this.constants.OJ_EXPANDED),this._expand(t,!0))}}),this._refreshTopAndBottomSelectionClasses()):(this._clearEventQueue(),this.refresh()):this._pushToEventQueue(e)},_isSkeletonSupported:function(){return"skeleton"===this._getOptionDefaults().loadIndicator},_getOptionDefaults:function(){if(null==this.defaultOptions){this.defaultOptions={};const e=Object.keys(this.constants.OJ_TREEVIEW_CSS_VARS),t=e.map(e=>this.constants.OJ_TREEVIEW_CSS_VARS[e]),n=i.getCachedCSSVarValues(t);e.forEach((e,t)=>{this.defaultOptions[e]=n[t]})}return this.defaultOptions},_renderChildSkeletons:function(e){var t=this._getItemByKey(e);this._removeExistingSkeletons(t);var n=this._getItemDisclosureIcon(t).offsetWidth,s="rtl"===this._GetReadingDirection(),i=this._buildThreeItemedSkeleton(),a=this._buildSkeletonContainer(),o=n,r=this._getDepth(t);s?a.style.marginRight=o+n/r+"px":a.style.marginLeft=o+n/r+"px",a.appendChild(i),t.appendChild(a)},_renderInitialSkeletons:function(){this._removeExistingSkeletons(this.element[0]);var e=this._buildThreeItemedSkeleton(),t=this._buildTwoItemedSkeleton(),n=this._buildSkeletonContainer();n.appendChild(e),n.appendChild(t),this.element[0].classList.add(this.constants.OJ_COMPLETE),this.element[0].appendChild(n);var s=n.offsetHeight,i=this.element[0].offsetHeight,a=s/5,o=0;if(s<i)do{o%2==0?(s+=3*a,n.appendChild(this._buildThreeItemedSkeleton())):(s+=2*a,n.appendChild(this._buildTwoItemedSkeleton())),o+=1}while(s<=i);if(s>i){var r=n.querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_SKELETON_CONTENT);for(o=r.length-1;o>=0&&(s-=a,n.removeChild(r[o]),!(s<=i));o--);}},_removeExistingSkeletons:function(e){for(var t=e.querySelectorAll(this.constants.PERIOD+this.constants.OJ_TREEVIEW_SKELETON_CONTAINER),n=0;n<t.length;n++)e.removeChild(t[n])},_getSkeletonContainer:function(e){return e.getElementsByClassName(this.constants.OJ_TREEVIEW_SKELETON_CONTAINER)[0]},_removeSkeleton:function(e){return new Promise(function(t){var n,s=this,i=s._addBusyState("removing skeleton",e);s._changeStatusMessage(e,!0),(n=null===e?this._getSkeletonContainer(s.element[0]):this._getSkeletonContainer(this._getItemByKey(e)))?o.fadeOut(n,{duration:"100ms"}).then(function(){n.parentElement&&n.parentElement.removeChild(n),i(),t()}):(i(),t())}.bind(this))},_buildThreeItemedSkeleton:function(){var e=this._buildTwoItemedSkeleton(),t=this._buildSkeletonLeafContent();return e.appendChild(t),e},_buildTwoItemedSkeleton:function(){var e=new DocumentFragment,t=this._buildSkeletonContent(!1);e.appendChild(t);var n=this._buildSkeletonContent(!0);return e.appendChild(n),e},_buildSkeletonContainer:function(){var e=document.createElement("div");return e.classList.add(this.constants.OJ_TREEVIEW_SKELETON_CONTAINER),e.classList.add(this.constants.OJ_ANIMATION_SKELETON_FADE_IN),e},_buildSkeletonContent:function(e){var t=document.createElement("div");t.classList.add(this.constants.OJ_TREEVIEW_SKELETON_CONTENT);var n=this._buildSkeletonCarrot();return e&&n.classList.add(this.constants.OJ_TREEVIEW_SKELETON_CHILD),t.appendChild(n),t.appendChild(this._buildSkeletonItem()),t},_buildSkeletonCarrot:function(){var e=document.createElement("div");return e.classList.add(this.constants.OJ_TREEVIEW_SKELETON_CARROT),e.classList.add(this.constants.OJ_ANIMATION_SKELETON),e},_buildSkeletonItem:function(){var e=document.createElement("div");return e.classList.add(this.constants.OJ_TREEVIEW_SKELETON_ITEM),e.classList.add(this.constants.OJ_ANIMATION_SKELETON),e},_buildSkeletonLeafContent:function(){var e=document.createElement("div");return e.classList.add(this.constants.OJ_TREEVIEW_SKELETON_CONTENT),e.appendChild(this._buildSkeletonLeafItem()),e},_buildSkeletonLeafItem:function(){var e=document.createElement("div");return e.classList.add(this.constants.OJ_TREEVIEW_SKELETON_LEAF),e.classList.add(this.constants.OJ_ANIMATION_SKELETON),e},_closest:function(e,t){if(!e)return null;if(!e.closest){do{if(this._matches(e,t))return e;e=e.parentElement||e.parentNode}while(null!==e&&1===e.nodeType);return null}return e.closest(t)},_getParents:function(e,t){for(var n=[];e&&e!==this.element[0];e=e.parentNode)this._matches(e,t)&&n.push(e);return n},_getNextSibling:function(e,t){var n=e.nextElementSibling;if(!t)return n;for(;n;){if(this._matches(n,t))return n;n=n.nextElementSibling}return null},_getPreviousSibling:function(e,t){var n=e.previousElementSibling;if(!t)return n;for(;n;){if(this._matches(n,t))return n;n=n.previousElementSibling}return null},_matches:function(e,t){return e.matches||(e.matches=Element.prototype.msMatchesSelector||Element.prototype.webkitMatchesSelector),e.matches(t)}});var p={properties:{currentItem:{type:"any",writeback:!0,readOnly:!0},data:{type:"object",extension:{webelement:{exceptionStatus:[{type:"unsupported",since:"13.0.0",description:"Data sets from a DataProvider cannot be sent to WebDriverJS; use ViewModels or page variables instead."}]}}},dnd:{type:"object",properties:{drag:{type:"object",properties:{items:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}}}},drop:{type:"object",properties:{items:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}}}}}},expanded:{type:"KeySet",writeback:!0},item:{type:"object",properties:{focusable:{type:"function"},renderer:{type:"function"},selectable:{type:"function"}}},scrollPolicyOptions:{type:"Object<number>",properties:{maxCount:{type:"number",value:500}}},selected:{type:"KeySet",writeback:!0},selection:{type:"Array<any>",writeback:!0,value:[]},selectionMode:{type:"string",enumValues:["leafOnly","multiple","none","single"],value:"none"},translations:{type:"object",value:{},properties:{receivedDataAria:{type:"string"},retrievingDataAria:{type:"string"},treeViewSelectorAria:{type:"string"}}}},methods:{getContextByNode:{},getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{},ojBeforeCollapse:{},ojBeforeCurrentItem:{},ojBeforeExpand:{},ojCollapse:{},ojExpand:{}},extension:{}};p.extension._WIDGET_NAME="ojTreeView",t.CustomElementBridge.register("oj-tree-view",{metadata:p})});
//# sourceMappingURL=ojtreeview.js.map