/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojdvt-toolkit","ojs/ojdvt-timecomponent","ojs/ojtimeaxis-toolkit","ojs/ojkeyboardfocus-utils","ojs/ojdvt-overview"],function(e,t,i,s,a,r){"use strict";class n extends i.TimeComponentKeyboardHandler{isMoveInitiationEvent(e){return e.keyCode===t.KeyboardEvent.M&&e.ctrlKey}isResizeStartInitiationEvent(e){return 83===e.keyCode&&e.altKey}isResizeEndInitiationEvent(e){return 69===e.keyCode&&e.altKey}isDnDScaleUpEvent(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.PAGE_UP}isDnDScaleDownEvent(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.PAGE_DOWN}isDnDForwardEvent(e){var i=t.Agent.isRightToLeft(this._eventManager._component.getCtx());return this._eventManager.getKeyboardDnDMode()&&e.keyCode===(i?t.KeyboardEvent.LEFT_ARROW:t.KeyboardEvent.RIGHT_ARROW)}isDnDBackwardEvent(e){var i=t.Agent.isRightToLeft(this._eventManager._component.getCtx());return this._eventManager.getKeyboardDnDMode()&&e.keyCode===(i?t.KeyboardEvent.RIGHT_ARROW:t.KeyboardEvent.LEFT_ARROW)}isDnDFinalizeEvent(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.ENTER}isDnDCancelEvent(e){return this._eventManager.getKeyboardDnDMode()&&e.keyCode===t.KeyboardEvent.ESCAPE}processKeyDown(e){var i=this._eventManager._component.getOptions()._keyboardUtils,s=this._eventManager.getFocus();if(this.isMoveInitiationEvent(e)&&s&&this._eventManager._component.isDnDMoveEnabled()&&!this._eventManager.isDnDDragging())return this._eventManager.handleKeyboardMoveInitiation(e,s),t.EventManager.consumeEvent(e),null;if(this.isResizeStartInitiationEvent(e)&&s&&this._eventManager._component.isDnDResizeEnabled()&&!this._eventManager.isDnDDragging())return this._eventManager.handleKeyboardResizeStartInitiation(e,s),t.EventManager.consumeEvent(e),null;if(this.isResizeEndInitiationEvent(e)&&s&&this._eventManager._component.isDnDResizeEnabled()&&!this._eventManager.isDnDDragging())return this._eventManager.handleKeyboardResizeEndInitiation(e,s),t.EventManager.consumeEvent(e),null;if(this.isDnDCancelEvent(e))return this._eventManager.handleKeyboardDnDCancel(),t.EventManager.consumeEvent(e),null;if(this.isDnDScaleUpEvent(e))return this._eventManager.handleKeyboardDnDScaleUp(e),t.EventManager.consumeEvent(e),null;if(this.isDnDScaleDownEvent(e))return this._eventManager.handleKeyboardDnDScaleDown(e),t.EventManager.consumeEvent(e),null;if(this.isDnDForwardEvent(e))return this._eventManager.handleKeyboardDnDForward(e),t.EventManager.consumeEvent(e),null;if(this.isDnDBackwardEvent(e))return this._eventManager.handleKeyboardDnDBackward(e),t.EventManager.consumeEvent(e),null;if(this.isDnDFinalizeEvent(e))return this._eventManager.handleKeyboardDnDFinalize(),t.EventManager.consumeEvent(e),null;const a=this._eventManager._component.activeInnerElems;if(!a&&s&&e.keyCode===t.KeyboardEvent.F2){var r=i.enableAllFocusable(s._displayable.getElem());return r.length>0&&(r[0].focus(),this._eventManager._component.activeInnerElems=r,s.hasActiveInnerElems=!0,this._eventManager._component.activeInnerElemsNode=s),null}if(a&&s&&(e.keyCode===t.KeyboardEvent.ESCAPE||e.keyCode===t.KeyboardEvent.F2))return this._eventManager._component.activeInnerElems=null,this._eventManager._component.activeInnerElemsNode=null,i.disableAllFocusable(s._displayable.getElem()),this._eventManager._component._context._parentDiv.focus(),s.hasActiveInnerElems=!1,this._eventManager.ShowFocusEffect(e,s),t.EventManager.consumeEvent(e),null;if(!this._eventManager._component.isDiscreteNavigationMode())return super.processKeyDown(e);if(e.keyCode&&e.keyCode==t.KeyboardEvent.SPACE||e.keyCode==t.KeyboardEvent.ENTER)return this._eventManager.handleArrowPress(e);if(t.KeyboardEvent.isPlus(e)||t.KeyboardEvent.isEquals(e)||t.KeyboardEvent.isMinus(e)||t.KeyboardEvent.isUnderscore(e))t.EventManager.consumeEvent(e);else if(e.keyCode===t.KeyboardEvent.PAGE_UP&&e.shiftKey)this._eventManager.prevPage();else{if(e.keyCode!==t.KeyboardEvent.PAGE_DOWN||!e.shiftKey)return super.processKeyDown(e);this._eventManager.nextPage()}}static getNextNavigable(e,i,s){var a=e.getSeries(),r=e.getSeriesIndex(),o=t.Agent.isRightToLeft(a.getCtx()),l=a.isVertical(),h=s.length>1;if(null==e._timeline.activeInnerElems){if(!o&&t.KeyboardEvent.RIGHT_ARROW===i.keyCode||o&&t.KeyboardEvent.LEFT_ARROW===i.keyCode){if(!l)return n.getNextItem(e,s[r],!0);if(h&&1!==r)return n.getClosestItem(e,s[1])}else if(!o&&t.KeyboardEvent.LEFT_ARROW===i.keyCode||o&&t.KeyboardEvent.RIGHT_ARROW===i.keyCode){if(!l)return n.getNextItem(e,s[r],!1);if(h&&0!==r)return n.getClosestItem(e,s[0])}else if(t.KeyboardEvent.DOWN_ARROW===i.keyCode){if(l)return n.getNextItem(e,s[r],!0);if(h&&1!==r)return n.getClosestItem(e,s[1])}else if(t.KeyboardEvent.UP_ARROW===i.keyCode){if(l)return n.getNextItem(e,s[r],!1);if(h&&0!==r)return n.getClosestItem(e,s[0])}return null}}static getNextItem(e,t,i){var s=t.indexOf(e)+(i?1:-1);return s>=0&&s<t.length?t[s]:null}static getClosestItem(e,t){if(t.length>0){for(var i=t[0],s=e.getLoc(),a=Math.abs(s-i.getLoc()),r=1;r<t.length;r++){var n=Math.abs(s-t[r].getLoc());n<a&&(a=n,i=t[r])}return i}return null}}const o={getDatatipColor:e=>{var t=e.getDurationFillColor();return t||null},getDatatip:(e,i,s)=>{var a=e._timeline;if(a.getEventManager().isKeyboardDnDScaleChanged()){var r=a.getEventManager().getKeyboardDnDNavigationScale(),n="move"===a.getEventManager().getKeyboardDnDMode()?"MoveBy":"ResizeBy",l=[];return o._addDatatipRow(l,a,n,"MoveBy",r,i),o._processDatatip(l,i)}var h=a.getOptions().tooltip,_=h?h.renderer:null;if(i&&_){var d=a.getCtx().getTooltipManager(),g=a.getEventManager().isDnDDragging()?e.getSandboxDataContext():e.getDataContext();return d.getCustomTooltip(_,g)}var c=e.getShortDesc();if(null!=c)return c;if(s&&!a.getCtx().isCustomElement()){var m=a.getOptions().translations,u=e.getDragStartTime(),v=a.getTimeAxis().formatDate(new Date(u),null,"general"),p=t.ResourceUtils.format(m.accessibleItemStart,[v]),S=e.getDragEndTime();if(S&&S!==u){var b=a.getTimeAxis().formatDate(new Date(S),null,"general");p=p+" "+t.ResourceUtils.format(m.accessibleItemEnd,[b])}var D=e.getTitle();null!=D&&""!==D&&(p=p+" "+t.ResourceUtils.format(m.accessibleItemTitle,[D]));var T=e.getDescription();return null!=T&&""!==T&&(p=p+" "+t.ResourceUtils.format(m.accessibleItemDesc,[T])),p}var f=[];return o._addItemDatatip(f,e,i),o._processDatatip(f,i)},_processDatatip:(e,i)=>0===e.length?null:i?t.HtmlTooltipManager.createElement("table",null,e,["oj-dvt-datatip-table"]):e.join(""),_addItemDatatip:(e,t,i)=>{var s=t._timeline,a=t.getTitle();a&&o._addDatatipRow(e,s,"title","Title",a,i);var r=t.getDescription();r&&o._addDatatipRow(e,s,"description","Description",r,i);var n=s.getEventManager()._isDndDragging?t.getDragStartTime():t.getStartTime(),l=s.getEventManager()._isDndDragging?t.getDragEndTime():t.getEndTime();n&&l&&l!==n?(o._addDatatipRow(e,s,"start","Start",n,i),o._addDatatipRow(e,s,"end","End",l,i)):o._addDatatipRow(e,s,"date","Date",n,i);var h=t._series.getLabel();null==h&&(h=t._series.getId()),o._addDatatipRow(e,s,"series","Series",h,i)},_addDatatipRow:(e,i,s,a,r,n)=>{if(null!=r&&""!==r){var l,h=i.getOptions().styleDefaults,_=o.getValueFormat(i,s),d=_.tooltipDisplay,g=i.getOptions().translations;if("off"!==d)if("string"==typeof _.tooltipLabel&&(l=_.tooltipLabel),null==l&&(l=null==a?"":g["label"+a]),r=o.formatValue(i,s,_,r),n){var c=[t.HtmlTooltipManager.createElement("td",h.tooltipLabelStyle,l,["oj-dvt-datatip-label"]),t.HtmlTooltipManager.createElement("td",h.tooltipValueStyle,r,["oj-dvt-datatip-value"])];e.push(t.HtmlTooltipManager.createElement("tr",null,c))}else e.push((e.length>0?"<br>":"")+t.ResourceUtils.format(g.labelAndValue,[l,r]))}},getValueFormat:(e,t)=>{var i=e.getOptions().valueFormats;if(!i)return{};if(i instanceof Array){for(var s={},a=0;a<i.length;a++){var r=i[a];s[r.type]=r}e.getOptions().valueFormats=s,i=s}return i[t]?i[t]:{}},formatValue:(e,t,i,s)=>{var a=i.converter;return"start"===t||"end"===t||"date"===t?e.getTimeAxis().formatDate(new Date(s),a,"general"):a&&a.format?a.format(s):s}},l={_DEFAULT_ZOOM_CONTROL_DIAMETER:31,_DEFAULT_ZOOM_CONTROL_PADDING:10.5,_DEFAULT_ZOOM_CONTROL_SPACING:9,_DEFAULT_DURATION_OVERFLOW_BREAKPOINT_TOUCHDEVICE:92,_DEFAULT_DURATION_OVERFLOW_BREAKPOINT:200,getItemDescriptionStyle:e=>{var i=e._series.getOptions().styleDefaults.item.descriptionStyle,s=e.getStyle();if(s){var a=new t.CSSStyle(s);i.parseInlineStyle(a)}return i},getItemTitleStyle:e=>{var i=e._series.getOptions().styleDefaults.item.titleStyle,s=e.getStyle();if(s){var a=new t.CSSStyle(s);i.parseInlineStyle(a)}return i},getReferenceObjectColor:e=>e.styleDefaults.referenceObject.color,getSeriesLabelStyle:e=>e.styleDefaults.series.labelStyle,getSeriesLabelBackgroundStyle:()=>"background-color:#f9f9f9",getSeriesLabelBackgroundOpacity:()=>.8,getSeriesLabelPadding:()=>2,getSeriesLabelSpacing:()=>20,getEmptyTextStyle:e=>e.styleDefaults.series.emptyTextStyle,getBubbleOffset:e=>"alta"===e.getCtx().getThemeBehavior()||e.isFeelerEnabled()?20:0,getBubbleSpacing:()=>15,getBubblePadding:e=>{var t=e._timeline.Options,i=t.styleDefaults.item,s=e.hasColorStripe();if(t.itemBubbleContentRenderer)return{top:0,bottom:0,start:0,end:0};if(s)return{top:Number(l.getNumberFromString(i._withStripePaddingTop)),bottom:Number(l.getNumberFromString(i._withStripePaddingBottom)),start:Number(l.getNumberFromString(i._withStripePaddingStart)),end:Number(l.getNumberFromString(i._withStripePaddingEnd))};var a=Number(l.getNumberFromString(i.padding));return{top:a,bottom:a,start:a,end:a}},getBubbleRadius:e=>l.getNumberFromString(e.styleDefaults.item.borderRadius),getItemContentSpacing:()=>2,getItemFillColor:e=>{var i=e.getStyle();if(i){var s=new t.CSSStyle(i).getStyle(t.CSSStyle.BACKGROUND_COLOR);if(s)return s}return e._series.getOptions().styleDefaults.item.backgroundColor},getItemStrokeColor:e=>{var i=e.getStyle();if(i){var s=new t.CSSStyle(i).getStyle(t.CSSStyle.BORDER_COLOR);if(s)return s}return e._series.getOptions().styleDefaults.item.borderColor},getItemStrokeWidth:()=>1,getItemHoverFillColor:e=>{var t=e._series.getOptions().styleDefaults.item.hoverBackgroundColor;return t||l.getItemFillColor(e)},getItemHoverStrokeColor:e=>{var t=e._series.getOptions().styleDefaults.item.hoverBorderColor;return t||l.getItemStrokeColor(e)},getItemHoverStrokeWidth:e=>l.getNumberFromString(e.styleDefaults.item.hoverStrokeWidth),getItemSelectedFillColor:e=>{var t=e._series.getOptions().styleDefaults.item.selectedBackgroundColor;return t||l.getItemFillColor(e)},getItemSelectedStrokeColor:e=>{var t=e._series.getOptions().styleDefaults.item.selectedBorderColor;return t||l.getItemStrokeColor(e)},getItemSelectedStrokeWidth:()=>2,getColorStripeMarginStart:e=>Number(l.getNumberFromString(e.styleDefaults.item._stripeMarginStart)),getColorStripeMarginTop:e=>Number(l.getNumberFromString(e.styleDefaults.item._stripeMarginTop)),getColorStripeMarginBottom:e=>Number(l.getNumberFromString(e.styleDefaults.item._stripeMarginBottom)),getColorStripeWidth:e=>Number(l.getNumberFromString(e.styleDefaults.item._stripeWidth)),getColorStripeBorderRadius:e=>Number(l.getNumberFromString(e.styleDefaults.item._stripeBorderRadius)),getContentBubbleBorderRadius:e=>Number(l.getNumberFromString(e.styleDefaults.item._overflowBubbleBorderRadius)),getSeriesStyle:()=>"background-color:#f9f9f9;",getColorsArray:e=>e.styleDefaults.series.colors,getDurationFeelerOffset:()=>10,getThumbnailWidth:()=>32,getThumbnailHeight:()=>32,getSeriesAxisSeparatorStyle:()=>"color:#bcc7d2",getItemInnerActiveStrokeColor:()=>"#e4f0fa",getItemInnerFillColor:()=>"rgba(249,249,249,0)",getItemInnerStrokeColor:()=>"rgba(249,249,249,0)",getItemInnerStrokeWidth:()=>2,getTimelineStyle:()=>"border:1px #d9dfe3;background-color:#f9f9f9;",getOverviewWidth:()=>60,getOverviewHeight:()=>100,getNavigationArrowWidth:()=>32,getNavigationArrowPadding:()=>8,getOverviewWindowBackgroundColor:e=>e.styleDefaults.overview.window.backgroundColor,getOverviewWindowBorderColor:e=>e.styleDefaults.overview.window.borderColor,getOverviewBackgroundColor:e=>e.styleDefaults.overview.backgroundColor,getOverviewLabelStyle:e=>e.styleDefaults.overview.labelStyle,getSeriesAxisLabelStyle:e=>e.styleDefaults.majorAxis.labelStyle,getSeriesAxisLabelBackgroundStyle:()=>"background-color:#f9f9f9",getSeriesAxisLabelBackgroundOpacity:()=>.8,getAxisSeparatorStyle:()=>"color:#bcc7d2;",getSeriesAxisLabelPadding:()=>1,getAnimationDuration:e=>t.CSSStyle.getTimeMilliseconds(e.styleDefaults.animationDuration)/1e3,convertToCSSStyle:e=>null==e||e instanceof t.CSSStyle?e:new t.CSSStyle(e),getNumberFromString:e=>{if(e){var t=e.match(/(\d+)/);return t?Number(t[0]):null}return null},getMinDurationEvent:e=>{var t=e._timeline.Options;return e.hasColorStripe()?2*l.getColorStripeMarginStart(t)+l.getColorStripeWidth(t):8},getMinHorizontalBubbleSpacing:()=>16,getContentBubbleArrow:()=>7.5,getContentBubbleSpacing:()=>15.5,getNavButtonBackgroundWidth:()=>60,getNavButtonWidth:()=>36,getNavButtonPadding:()=>8,getContentBubbleBackgroundColor:e=>e.styleDefaults.durationEventOverflow.backgroundColor,getMaximumContentsWidth:e=>{const t=l.getNumberFromString(e.styleDefaults.item._maxContentWidth);return null!=t?t:1/0},getDurationOverflowBreakpoint:()=>t.Agent.isTouchDevice()?l._DEFAULT_DURATION_OVERFLOW_BREAKPOINT_TOUCHDEVICE:l._DEFAULT_DURATION_OVERFLOW_BREAKPOINT,getContentBubblePathCmds:(e,i,s,a)=>{const r=Math.min(s,.5*i),n=Math.min(s,.5*e),o=l.getContentBubbleArrow();let h;return h=a?t.PathUtils.moveTo(0+n,0)+t.PathUtils.lineTo(0+e-n,0)+t.PathUtils.arcTo(n,r,Math.PI/2,1,0+e,0+r)+t.PathUtils.lineTo(0+e,0+i/2-o)+t.PathUtils.lineTo(0+e+o,0+i/2)+t.PathUtils.lineTo(0+e,0+i/2+o)+t.PathUtils.lineTo(0+e,0+i-r)+t.PathUtils.arcTo(n,r,Math.PI/2,1,0+e-n,0+i)+t.PathUtils.lineTo(0+n,0+i)+t.PathUtils.arcTo(n,r,Math.PI/2,1,0,0+i-r)+t.PathUtils.lineTo(0,r)+t.PathUtils.arcTo(n,r,Math.PI/2,1,0+n,0)+t.PathUtils.closePath():t.PathUtils.moveTo(0+n,0)+t.PathUtils.lineTo(0+e-n,0)+t.PathUtils.arcTo(n,r,Math.PI/2,1,0+e,0+r)+t.PathUtils.lineTo(0+e,0+i-r)+t.PathUtils.arcTo(n,r,Math.PI/2,1,0+e-n,0+i)+t.PathUtils.lineTo(0+n,0+i)+t.PathUtils.arcTo(n,r,Math.PI/2,1,0,0+i-r)+t.PathUtils.lineTo(0,0+i/2+o)+t.PathUtils.lineTo(0-o,0+i/2)+t.PathUtils.lineTo(0,0+i/2-o)+t.PathUtils.lineTo(0,0+r)+t.PathUtils.arcTo(n,r,Math.PI/2,1,0+n,0)+t.PathUtils.closePath(),h}};class h{constructor(e,t,i){this._timeline=e,this._seriesIndex=t,this._series=e._series[t],this._props=i,this._id=i.id,this._rowKey=i.rowKey,this._startTime=parseInt(i.startTime),i.endTime&&(this._endTime=parseInt(i.endTime)),this._title=i.title,this._desc=i.desc,this._thumbnail=i.thumbnail,this._shortDesc=i.shortDesc,this._background=i.background,this._style=i.style,this._data=i.data,this._durationFillColor=i.durationFillColor,this._durationSize=0,this._markerShape=i.markerShape,this._markerScaleX=i.markerScaleX,this._markerScaleY=i.markerScaleY,this._markerShortDesc=i.markerShortDesc,this._markerFillColor=i.markerFillColor,this._markerGradientFill=i.markerGradientFill,this._markerOpacity=i.markerOpacity,this._markerSD=i.markerSD,this._data=i.data,this._state={focused:!1,hovered:!1,selected:!1},this._previousState={focused:!1,hovered:!1,selected:!1}}getId(){return this._id}getSeries(){return this._series}getSeriesIndex(){return this._seriesIndex}getRowKey(){return this._rowKey}getStartTime(){return this._startTime}setStartTime(e){this._startTime=e}getEndTime(){return this._endTime}setEndTime(e){this._endTime=e}getTitle(){return this._title}getDescription(){return this._desc}getThumbnail(){return this._thumbnail}getBackground(){return this._background}getShortDesc(){var e=this._shortDesc;return"function"==typeof e?e(h.getShortDescContext(this)):e}getSandboxData(){if(!this._sandboxData){const e=this.getData(!0);this._sandboxData=t.JsonUtils.clone(e),this._sandboxData.start=e._start,this._sandboxData.end=e._end}return this._sandboxData}getStyle(){return this._style}setStyle(e){this._style=e}setBackground(e){this._background=e}getBubble(){return this._displayable}setBubble(e){this._displayable=e}getContentBubble(){return this._displayableContent}setContentBubble(e){this._displayableContent=e}getColorStripe(){return this._colorStripe}setColorStripe(e){this._colorStripe=e}createColorStripe(){let e=this._timeline.getOptions(),i=this.getSeries().getCtx(),s=t.Agent.isRightToLeft(i),a=this.getDurationWidth(),r=l.getColorStripeMarginStart(e),n=l.getColorStripeMarginTop(e),o=l.getColorStripeMarginBottom(e),h=l.getColorStripeWidth(e),_=this.getHeight()-(n+o),d=s?a-r-h:r,g=n,c=l.getColorStripeBorderRadius(e),m=new t.Rect(i,d,g,h,_);return m.setCornerRadius(c),m}getFeeler(){return this._feeler}setFeeler(e){this._feeler=e}getDurationBar(){return this._durationBar}setDurationBar(e){this._durationBar=e}getLoc(){return this._loc}setLoc(e){this._loc=e}getSpacing(){return this._spacing}setSpacing(e){this._spacing=e}getEndViewportCollision(){return this._endViewportCollision}setEndViewportCollision(e){this._endViewportCollision=e}getDurationLevel(){return this._durationLevel}setDurationLevel(e){this._durationLevel=e}getDurationSize(){return this._durationSize}setDurationSize(e){this._durationSize=e}getDurationFillColor(){return this._durationFillColor}setDurationFillColor(e){this._durationFillColor=e}getLabel(){var e=this._timeline.getOptions().translations,i=this.getStartTime(),s=this._timeline.getTimeAxis().formatDate(new Date(i),null,"general"),a=t.ResourceUtils.format(e.accessibleItemStart,[s]),r=this.getEndTime();if(null!=r&&r!==i){var n=this._timeline.getTimeAxis().formatDate(new Date(r),null,"general");a=a+" "+t.ResourceUtils.format(e.accessibleItemEnd,[n])}var o=this.getTitle();null!=o&&""!==o&&(a=a+" "+t.ResourceUtils.format(e.accessibleItemTitle,[o]));var l=this.getDescription();return null!=l&&""!==l&&(a=a+" "+t.ResourceUtils.format(e.accessibleItemDesc,[l])),a}getWidth(){return this._w}setWidth(e){this._w=e}getContentWidth(){return this._cw}setContentWidth(e){this._cw=e}getDurationWidth(){return this._dw}setDurationWidth(e){this._dw=e}getHeight(){return this._h}setHeight(e){this._h=e}getResizeHandleEnd(){return this._resizeHandleEnd}setResizeHandleEnd(e){this._resizeHandleEnd=e}getResizeHandleStart(){return this._resizeHandleStart}setResizeHandleStart(e){this._resizeHandleStart=e}getMarkerShape(){return this._markerShape}getMarkerScaleX(){return this._markerScaleX}getMarkerScaleY(){return this._markerScaleY}getMarkerShortDesc(){return this._markerShortDesc}getMarkerFillColor(){return this._markerFillColor}getMarkerGradientFill(){return this._markerGradientFill}getMarkerOpacity(){return this._markerOpacity}getMarkerSD(){return this._markerSD}getNextNavigable(e){var i=this._timeline.EventManager.getKeyboardHandler();if(e.type===t.MouseEvent.CLICK||i.isMultiSelectEvent(e))return this;if(i.isNavigationEvent(e)){for(var s=[],a=0;a<this._timeline._series.length;a++)s.push(this._timeline._series[a]._items);return n.getNextNavigable(this,e,s)}return null}getTargetElem(){return this._displayable.getElem()}getKeyboardBoundingBox(e){return this._displayable.getDimensions(e)}showKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect(),this._timeline.updateScrollForItemNavigation(this)}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}getDisplayables(){return[this._displayable]}getAriaLabel(){var e=this._timeline.getOptions(),i=e.translations,s=e._keyboardUtils,a=[];this.isSelectable()&&a.push(i[this.isSelected()?"stateSelected":"stateUnselected"]),s.getActionableElementsInNode(this._displayable.getElem()).length>0&&a.push(i.accessibleContainsControls);var r=o.getDatatip(this,!1);return t.Displayable.generateAriaLabel(r,a)}getData(e){return e?i.TimeComponent.sanitizeData(this._data,"item"):this._data}setData(e){this._data=e}getItemType(){var e=this._data.itemType;return e&&"auto"!==e?this._endTime?"event"===e||!this._series.isVertical()&&"alta"!==this._timeline.getCtx().getThemeBehavior()?e:h.DURATION_BAR:"event":this._endTime?h.DURATION_BAR:"event"}getRendererContext(){var e=this.getData()._itemData,t=this.getItemType()===h.DURATION_EVENT?Math.max(this._timeline.getDatePos(this._endTime)-this._timeline.getDatePos(this._startTime),l.getMinDurationEvent(this)):null;return{data:this.getData(!0),itemData:e||null,seriesData:this._series.getData(!0),previousState:this._previousState,state:this._state,durationWidth:t,contentWidth:this.getAvailableContentWidth(),maxAvailableWidth:this.getMaxAvailableWidth()}}getArtifactWidth(){return this.hasColorStripe()?l.getColorStripeMarginStart(this._timeline.Options)+l.getColorStripeWidth(this._timeline.Options):0}getAvailableContentWidth(){if(this.getItemType()!==h.DURATION_EVENT)return null;var e=this._timeline,t=this.getStartTime(),i=this.getEndTime(),s=e.isDiscreteNavigationMode(),a=this._timeline.getDatePos(i)-this._timeline.getDatePos(t),r=a;if(s){var n=e.getDiscreteViewportStartDate(),o=e.getDiscreteViewportEndDate();if(i<n||t>o)r=a;else{var _=e.getDatePos(Math.max(this.getDragStartTime(),e.getDiscreteViewportStartDate()));r=e.getDatePos(Math.min(this.getDragEndTime(),e.getDiscreteViewportEndDate()))-_}}r=Math.max(r,l.getMinDurationEvent(this));var d=this.getArtifactWidth();return Math.floor(r-d)}getMaxAvailableWidth(){var e,t,i,s=this._timeline,a=this.getStartTime(),r=this.getEndTime()||a,n=s.isDiscreteNavigationMode(),o=l.getNavButtonPadding(),_=l.getMaximumContentsWidth(s.Options);if(n){e=l.getNavButtonBackgroundWidth()-o;var d=s.getDiscreteViewportDateOffsetPos(s._discreteViewportCurrentIndexOffset);t=d.startDate,i=d.endDate}else e=-o,t=s._start,i=s._end;var g=this.getItemType(),c=s.getDatePos(t),m=s.getDatePos(i),u=s.getDatePos(a),v=g===h.DURATION_EVENT?u+Math.max(s.getDatePos(r)-u,l.getMinDurationEvent(this)):s.getDatePos(r),p=this.getAvailableContentWidth();if(n&&(r<t||a>i))return g===h.DURATION_EVENT?p:a<t?c-u:u-m;if(g!==h.DURATION_EVENT){var S=m-u+e;return Math.min(Math.max(0,S),_)}if(p+this.getArtifactWidth()>=l.getDurationOverflowBreakpoint())return p;var b=l.getContentBubbleSpacing(),D=Math.max(0,u-b-c+e),T=Math.max(0,m-v-b+e);return Math.floor(Math.max(p,Math.min(Math.max(D,T),_)))}getDataContext(){var e=this.getData()._itemData;return{data:this.getData(!0),seriesData:this._series.getData(!0),itemData:e||null,color:o.getDatatipColor(this),component:this._timeline.getOptions()._widgetConstructor}}getSandboxDataContext(){var e=this.getSandboxData();e.start=new Date(e.start).toISOString(),e.end=new Date(e.end).toISOString();var t=this.getData()._itemData;return{data:e,seriesData:this._series.getData(!0),itemData:t||null,color:o.getDatatipColor(this),component:this._timeline.getOptions()._widgetConstructor}}static getShortDescContext(e){var t=e._timeline.getEventManager().isDnDDragging()?e.getSandboxDataContext():e.getDataContext();return{data:t.data,seriesData:t.seriesData,itemData:t.itemData}}getDatatip(){return o.getDatatip(this,!0)}getDatatipColor(){return o.getDatatipColor(this)}setSelectable(e){this._isSelectable=e}isSelectable(){return this._isSelectable}isSelected(){return this._isSelected}setSelected(e){this._isSelected=e,this._displayable.setSelected(e),this._updateAriaLabel()}changeState(e,t,i){i?(this._previousState=this._state,this._state={focused:!1,hovered:!1,selected:!1},this._state[e]=t):this._state[e]=t}showHoverEffect(e){var t=this._timeline.EventManager.getFocus()===this;this.changeState("focused",t,!0),this._displayable.showHoverEffect(t),this.changeState("hovered",!0),(this._timeline._isVertical||this._series._isRandomItemLayout)&&(this._index||(this._index=this._series._blocks[0].getChildIndex(this.getBubble())),this._series._blocks[0].addChild(this.getBubble()))}hideHoverEffect(e){var t=this._timeline.EventManager.getFocus()===this;this.changeState("focused",t,!0),this._displayable.hideHoverEffect(t),this.changeState("hovered",!1),(this._timeline._isVertical||this._series._isRandomItemLayout)&&this._index&&!this._isSelected&&this._series._blocks[0].addChildAt(this.getBubble(),this._index)}_updateAriaLabel(){t.Agent.deferAriaCreation()||this._displayable.setAriaProperty("label",this.getAriaLabel())}isDragAvailable(){return!0}getDragTransferable(){return[this.getId()]}getDragFeedback(){return null}setDraggedObj(e){this._draggedObj=e}showDragFeedback(e,i,s,a,r,n){var o=this._timeline.getEventManager();if(s&&o){var h,_,d=o.getDnDTaskSubType(s),g=t.Agent.isRightToLeft(this._timeline.getCtx()),c=g?-1:1;switch(h={deltaX:null==o._keyboardDnDMode?o._dragInitialX-this._timeline.getTimeZoomCanvas().getTranslateX():0,deltaY:0},_=a.x+i.x+h.deltaX,d){case"event":var m=s._displayable._initialDragOffset.offsetX-_,u=this._displayable._initialPosition.initialX-m;this._displayable.setTranslateX(u);var v=this._timeline.getDatePos(this._startTime)-m*c,p=this._timeline.getDatePos(this._endTime)-m*c;this._dragStartTime=this._timeline.getPosDate(v),this._dragEndTime=this._timeline.getPosDate(p),n&&this._showDragFeedbackTooltip(e,this._dragStartTime,this._dragEndTime,this._displayable,"center");break;case"resize-handle":h={deltaX:0,deltaY:0};m=s._displayable._initialDragOffset.offsetX-_;var S="end"===s._displayable._resizeEdge,b=g&&!S||!g&&S?null:this._displayable._initialPosition.initialX-m,D=(v=this._timeline.getDatePos(this._startTime)-m*c,p=this._timeline.getDatePos(this._endTime)-m*c,this._timeline.getDatePos(this._startTime)+l.getMinDurationEvent(this)),T=this._timeline.getDatePos(this._endTime)-l.getMinDurationEvent(this);S&&p>D?(this._dragEndTime=this._timeline.getPosDate(p),this._dragStartTime=this._startTime,this._timeline.getEventManager().handleDurationEventResize(this,this._series,b)):!S&&v<T&&(this._dragStartTime=this._timeline.getPosDate(v),this._dragEndTime=this._endTime,this._timeline.getEventManager().handleDurationEventResize(this,this._series,b)),n&&this._showDragFeedbackTooltip(e,this._dragStartTime,this._dragEndTime,this._displayable,S?"end":"start")}}}_showDragFeedbackTooltip(e,i,s,a,r){var n,o=this._timeline.getCtx(),l=t.Agent.isRightToLeft(o),h=this.getSandboxData(),_=(a.getChildAt(0)||a).getDimensions(o.getStage());switch(h.start=i,h.end=s,r){case"start":n=new t.Point(_.x+l*_.w,_.y);break;case"end":n=new t.Point(_.x+!l*_.w,_.y);break;default:n=_.getCenter()}var d=o.stageToPageCoords(n.x,n.y);this._timeline.getEventManager().ProcessObjectTooltip(e,d.x,d.y,this,a.getElem())}_dropCleanup(){this._displayable&&(this._displayable._initialDragOffset=null,this._displayable._initialPosition=null,this._displayable._resizeEdge=null,this._type=null),this._sandboxData=null,this._dragStartTime=null,this._dragEndTime=null,this._timeline.getEventManager().handleDurationEventReset(this,this._series)}dragStartSetup(e){null!=e&&(this._displayable._initialDragOffset={offsetX:e.offsetX,offsetY:e.offsetY}),this._displayable._initialPosition={initialX:this._displayable.getTranslateX(),initialY:this._displayable.getTranslateY()}}getDragStartTime(){return null!=this._dragStartTime&&this._timeline.getEventManager()._isDndDragging?this._dragStartTime:this._startTime}getDragEndTime(){return null!=this._dragEndTime&&this._timeline.getEventManager()._isDndDragging?this._dragEndTime:this._endTime}updateDragFeedback(e){var i=t.Agent.isRightToLeft(this._timeline.getCtx()),s=this._timeline.getEventManager();if(s){var a,r,n,o=i?-1:1;switch(s.getDnDTaskSubType(e)){case"event":r=this._timeline.getDatePos(this._dragStartTime),a=(this._timeline.getDatePos(this._startTime)-r)*o;var l=this._displayable.getTranslateX()-a;this._displayable.setTranslateX(l);break;case"resize-handle":var h="end"===e._displayable._resizeEdge;h?(n=this._timeline.getDatePos(this._dragEndTime),a=(this._timeline.getDatePos(this._endTime)-n)*o):h||(r=this._timeline.getDatePos(this._dragStartTime),a=(this._timeline.getDatePos(this._startTime)-r)*o);var _=i&&!h||!i&&h?null:this._displayable.getTranslateX()-a;this._timeline.getEventManager().handleDurationEventResize(this,this._series,_)}}}getDragType(){return this._type}setDragType(e){this._type=e}_disableAllTabElements(){this._timeline.getOptions()._keyboardUtils.disableAllFocusable(this._displayable.getElem())}_enableAllTabElements(){this._timeline.getOptions()._keyboardUtils.enableAllFocusable(this._displayable.getElem())}hasColorStripe(){return!(!this.getBackground()||this.getItemType()!==h.DURATION_EVENT||this._series.isVertical())}}h.DURATION_EVENT="duration-event",h.DURATION_BAR="duration-bar";class _ extends t.Automation{GetSubIdForDomElement(e){var t=this._comp.EventManager.GetLogicalObject(e);if(t&&t instanceof h)for(var i=0;i<this._comp._series.length;i++){var s=this._comp._series[i]._items.indexOf(t);if(-1!==s)return"timelineItem["+i+"]["+s+"]"}return null}getDomElementForSubId(e){if(e===t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._comp);if(e&&this._comp.hasValidOptions()){var i=e.indexOf("[");if(i>0&&"timelineItem"===e.substring(0,i)){var s=e.indexOf("]");if(s>0){var a=parseInt(e.substring(i+1,s)),r=parseInt(e.substring(s+2,e.length-1)),n=this._comp._series[a];if(n){var o=n._items[r];if(o)return o.getDisplayables()[0].getElem()}}}}return null}}class d extends t.BaseComponentDefaults{constructor(e){super({alta:{}},e)}getNoCloneObject(){return{majorAxis:{converter:!0,scale:!0},minorAxis:{converter:!0,scale:!0,zoomOrder:!0},valueFormats:{date:{converter:!0},end:{converter:!0},start:{converter:!0}},_resources:{converter:!0,converterVert:!0,defaultDateConverter:!0,defaultDateTimeConverter:!0}}}}class g extends t.Container{constructor(e,t){super(e,"g",t),this.SELECTED_STATE_KEY="sel",this.ACTIVE_SELECTED_STATE_KEY="asel",this.HOVER_STATE_KEY="hl"}setSelected(e){this._isSelected!==e&&(this._isSelected=e,e?this._isShowingHoverEffect?this.applyState(this.ACTIVE_SELECTED_STATE_KEY):this.applyState(this.SELECTED_STATE_KEY):this.applyState(g.ENABLED_STATE_KEY))}showHoverEffect(e){this._isShowingHoverEffect||(this._isShowingHoverEffect=!0,this._isSelected&&e?this.applyState(this.ACTIVE_SELECTED_STATE_KEY):this._isSelected?this.applyState(this.SELECTED_STATE_KEY):this.applyState(this.HOVER_STATE_KEY))}hideHoverEffect(e){this._isSelected&&e?this.applyState(this.ACTIVE_SELECTED_STATE_KEY):this._isSelected?this.applyState(this.SELECTED_STATE_KEY):this.applyState(g.ENABLED_STATE_KEY),this._isShowingHoverEffect=!1}applyState(e){var i=this._node,s=i.getBubble();if(null==s)return;var a,r,n,o,h=s.getChildAt(0),_=h.getChildAt(0),d=i.getDurationBar();e===this.ACTIVE_SELECTED_STATE_KEY?(a=l.getItemSelectedFillColor(i),r=l.getItemSelectedStrokeColor(i),n=l.getItemSelectedStrokeWidth(),o=l.getItemInnerActiveStrokeColor()):e===this.SELECTED_STATE_KEY?(a=l.getItemSelectedFillColor(i),r=l.getItemSelectedStrokeColor(i),n=l.getItemSelectedStrokeWidth(),o=l.getItemInnerStrokeColor()):e===this.HOVER_STATE_KEY?(a=l.getItemHoverFillColor(i),r=l.getItemHoverStrokeColor(i),n=l.getItemHoverStrokeWidth(i._timeline.Options),o=l.getItemInnerActiveStrokeColor()):(a=l.getItemFillColor(i),r=l.getItemStrokeColor(i),n=l.getItemStrokeWidth(),o=l.getItemInnerStrokeColor());var g=l.getItemInnerStrokeWidth(),c=new t.Stroke(r,1,n),m=new t.Stroke(o,1,g);h.setStroke(c),_.setStroke(m);const u=i.hasColorStripe();if(e===this.HOVER_STATE_KEY){var v=u?"transparent":l.getContentBubbleBackgroundColor(i._timeline.Options);h.setSolidFill(v),_.setSolidFill(u?"transparent":a)}else h.setSolidFill(a),_.setSolidFill(l.getItemInnerFillColor());const p=i.getBackground();if(p){h.setClassName(`oj-timeline-item-bubble oj-timeline-item-bubble-bg-${p}`);const e=i.getColorStripe();u&&e&&e.setClassName(`oj-timeline-item-bubble-stripe oj-timeline-item-bubble-bg-${p}`)}else h.setClassName();var S=i.getFeeler();S&&i._timeline.isFeelerEnabled()&&S.setStroke(c),d&&d.setStroke(c)}}g.ENABLED_STATE_KEY="en";const c={renderItem:(e,t,i,s,a,r)=>{e.getBubble()?(t._hasMvAnimations=!0,c._displayBubble(e,t,s,r,!0)):(c._renderBubble(e,t,i,a),c._displayBubble(e,t,s,null,!1)),!t.isVertical()&&e._timeline.isFeelerEnabled()&&(e.getFeeler()&&t._allowUpdates?c._updateFeeler(e,t,s,r):c._renderFeeler(e,t,i.feelers,s,a))},initializeItem:(e,t,i,s)=>{e.getBubble()&&t._allowUpdates?c._updateBubble(e,t,i,s):c._createBubble(e,t,i)},_createBubble:(e,t,i)=>{var s=c._getBubbleContent(e,t);e._content=s,c._setupBubble(e,s);var a=t.calculateSpacing(e,i);e.setSpacing(a)},_setupBubble:(e,t)=>{var i,s,a,r=l.getBubblePadding(e);e._timeline.getOptions().itemBubbleContentRenderer?(i=Math.max(0,t._w+t._x+r.start+r.end),s=t._h+t._y+r.top+r.bottom):(i=t._w+r.start+r.end,s=t._h+r.top+r.bottom),e.setContentWidth(i);var n=e.getStartTime(),o=e.getEndTime(),_=e._timeline.getDatePos(n),d=e._timeline.getDatePos(o);e.getItemType()===h.DURATION_EVENT&&(i=(a=Math.max(d-_,l.getMinDurationEvent(e)))<i?a+i+l.getContentBubbleSpacing():a),c.checkEndViewportCollision(e,i),e.getEndViewportCollision()&&null===a&&(i=2*i+l.getContentBubbleSpacing()),e.setWidth(i),e.setHeight(s),e.setDurationWidth(a)},_renderBubble:(e,i,a,r)=>{var n,o,_,d,m,u,v,p=i.getCtx(),S=t.Agent.isRightToLeft(p),b=e.getId(),D=e._timeline.Options,T=l.getBubblePadding(e),f=Number(l.getBubbleRadius(D)),C=e._content,E=c._isOverflow(e),y=e.getWidth(),O=e.getContentWidth(),w=e.getDurationWidth(),A=e.getHeight(),k="_bubble_"+b;if("alta"===e._timeline.getCtx().getThemeBehavior()){if(i.isVertical()){var x=A/2,M=x-6,P=x+6;!S&&i.isInverted()||S&&!i.isInverted()?(u=[0,0,0,M,-6,x,0,P,0,A,y,A,y,0,0,0],v=[2,2,2,M,-4,x,2,P,2,A-2,y-2,A-2,y-2,2,2,2]):(u=[0,0,0,A,y,A,y,P,y+6,x,y,M,y,0,0,0],v=[2,2,2,A-2,y-2,A-2,y-2,P,y+4,x,y-2,M,y-2,2,2,2])}else M=(x=S?y-l.getBubbleOffset(e._timeline):l.getBubbleOffset(e._timeline))-6,P=x+6,i.isInverted()?(u=[0,0,M,0,x,-6,P,0,y,0,y,A,0,A,0,0],v=[2,2,M,2,x,-4,P,2,y-2,2,y-2,A-2,2,A-2,2,2]):(u=[0,0,0,A,M,A,x,A+6,P,A,y,A,y,0,0,0],v=[2,2,2,A-2,M,A-2,x,A+4,P,A-2,y-2,A-2,y-2,2,2,2]);n=new t.Polygon(p,u,k),o=new t.Polygon(p,v,k+"_i")}else{d=e.getEndViewportCollision(),m=S&&!d||!S&&d;const i=l.getContentBubbleBorderRadius(D),s=l.getContentBubblePathCmds(O,A,i,m);(_=new t.Path(p,s,k+"_ct")).setSolidFill(l.getContentBubbleBackgroundColor(e._timeline.getOptions())),w&&(y=w),n=new t.Rect(p,0,0,y,A,k),o=new t.Rect(p,2,2,Math.max(y-4,0),A-4,k+"_i"),n.setCornerRadius(f),o.setCornerRadius(f)}o.setSolidFill(l.getItemInnerFillColor()),n.addChild(o),e._bubbleRect=n,e._innerBubbleRect=o;var I=new g(p,"_bt_"+b);I._node=e,e.setBubble(I),e.setContentBubble(_);const R=e.getBackground();_&&(_.setClassName("oj-timeline-item-duration-event-overflow-bubble"),R&&_.addClassName("oj-timeline-item-duration-event-overflow-bubble-"+R)),r&&(I.setAlpha(0),r.push(I));var L=c.calcPadding(e,S,T,y,E,C);if(E&&(e.getItemType()===h.DURATION_EVENT||e._timeline.isDiscreteNavigationMode())){d=e.getEndViewportCollision();var V=(L+15.5)*((m=S&&!d||!S&&d)?-1:1);_.setTranslateX(V),_.addChild(C);var N=e._timeline.getOptions().itemBubbleContentRenderer;C.setTranslate(S&&N?e.getContentWidth():T.start,T.top),I.addChild(n),I.addChild(_)}else{var B=e._timeline._viewStartTime>e.getEndTime()||e._timeline._viewEndTime<e.getStartTime();e._timeline.isDiscreteNavigationMode()&&B&&e.getItemType()===h.DURATION_EVENT&&C.setVisible(),C.setTranslate(L,T.top),n.addChild(C),I.addChild(n)}if(s.TimeAxisUtils.supportsTouch()&&t.ToolkitUtils.setAttrNullNS(I._elem,"id",I._id),e.hasColorStripe()){var F=e.createColorStripe();e.setColorStripe(F),I.addChild(F)}I.applyState(g.ENABLED_STATE_KEY),I.setClassName("oj-timeline-item-bubble-container"),e.getLoc()>=0&&a.addChild(I);var j,z,W=e._timeline.getOptions().itemBubbleContentRenderer?"region":"img";(I.setAriaRole(W),i._callbackObj.EventManager.associate(I,e),e._timeline.isDnDResizeEnabled())&&(j=new t.Rect(p,0,0,1,A,"resize-handle-start_"+k),z=new t.Rect(p,0,0,1,A,"resize-handle-end_"+k),S?(j.setTranslateX(y),z.setTranslateX(-1)):(j.setTranslateX(-1),z.setTranslateX(y)),j.setHollow("#00000000"),z.setHollow("#00000000"),I.addChild(j),I.addChild(z),j.setClassName("oj-timeline-resize-handle-start oj-draggable"),z.setClassName("oj-timeline-resize-handle-end oj-draggable"),i._callbackObj.EventManager.associate(j,e),i._callbackObj.EventManager.associate(z,e),e.setResizeHandleStart(j),e.setResizeHandleEnd(z));e._timeline.isDnDMoveEnabled()?(o.setClassName("oj-timeline-item-inner-bubble oj-timeline-move-handle oj-draggable"),i._callbackObj.EventManager.associate(o,e)):o.setClassName("oj-timeline-item-inner-bubble")},_displayBubble:(e,i,s,a,r)=>{var n,o,_=i.getCtx(),d=t.Agent.isRightToLeft(_),m=e.getLoc(),u=e.getWidth(),v=e.getHeight(),p=e.getSpacing(),S=e.getBubble();if(r&&S.applyState(g.ENABLED_STATE_KEY),i.isVertical())o=m-v/2,d&&i.isInverted()||!d&&!i.isInverted()?n=i._size-(u+i._initialSpacing)+s:(n=i._initialSpacing,s=0);else{var b=e.getItemType()===h.DURATION_EVENT?0:l.getBubbleOffset(e._timeline);if(d)n=(e._timeline.isDiscreteNavigationMode()?e._timeline._discreteContentLength:i._length)-m-u+b,c._isOverflow(e)&&(n+=e.getContentWidth()+15.5);else n=m-b;i.isInverted()?(o=i.isTopToBottom()?p:i.Height-p-v+s+i._initialSpacing-l.getBubbleSpacing(),s=0):o=i.isTopToBottom()?p-i._initialSpacing+l.getBubbleSpacing():i.Height-p-v+s}a?(i.isVertical()?S.setTranslateX(S.getTranslateX()+i._canvasOffsetX+s):S.setTranslateY(S.getTranslateY()+i._canvasOffsetY+s),a.addProp(t.Animator.TYPE_NUMBER,S,S.getTranslateX,S.setTranslateX,n),a.addProp(t.Animator.TYPE_NUMBER,S,S.getTranslateY,S.setTranslateY,o)):S.setTranslate(n,o),e._updateAriaLabel(),e._disableAllTabElements()},_createEventMoveDragOutline:e=>{var i=e.getId(),s=e._series.getCtx(),a=e._displayable.getChildAt(0).getWidth()+2,r=e.getHeight()+2,n=e._displayable,o="_bubble_move_"+i,h=Number(l.getBubbleRadius(e._timeline.Options)),_=new t.Rect(s,0,0,a,r,o);_.setCornerRadius(h),_.setClassName("oj-timeline-move-outline"),_.setTranslateX(n.getTranslateX()-1),_.setTranslateY(n.getTranslateY()-1),_.setSolidFill("transparent");var d=new t.Stroke("#000000",1,1,!1,{dashArray:"3"});_.setStroke(d),e._moveDragOutline=_},_updateEventMoveDragOutline:e=>{var t=e._displayable,i=t.getChildAt(0).getWidth(),s=e.getHeight();e._moveDragOutline.setWidth(i+2),e._moveDragOutline.setHeight(s+2),e._moveDragOutline.setTranslateX(t.getTranslateX()-1),e._moveDragOutline.setTranslateY(t.getTranslateY()-1)},_renderEventMoveDragOutline:e=>{var t=e._series._blocks[0];null==e._moveDragOutline?c._createEventMoveDragOutline(e):c._updateEventMoveDragOutline(e),t.addChild(e._moveDragOutline)},_hideEventMoveDragOutline:e=>{var t=e._series._blocks[0];null!=e._moveDragOutline&&t.removeChild(e._moveDragOutline)},_getBubbleContent:(e,i)=>{var s,a=i.getCtx(),r=t.Agent.isRightToLeft(a),n=e.getTitle(),o=e.getDescription(),h=e.getThumbnail(),_=new t.Container(a),d=0,g=0,c=0,m=0,u=0,v=e._timeline.getOptions().itemBubbleContentRenderer;if(v&&(s=v(e.getRendererContext()))){var p=_.getContainerElem();Array.isArray(s)?s.forEach(e=>{t.ToolkitUtils.appendChildElem(p,e)}):t.ToolkitUtils.appendChildElem(p,s);var S=i._blocks[i._blocks.length-1];S.setClassName("oj-timeline-item-bubble-container"),S.addChild(_);var b=_.getDimensions();return _._w=b.w,_._h=b.h,_._x=r?b.w+b.x:b.x,_._y=b.y,S.removeChild(_),_}var D=l.getBubblePadding(e),T=e.getMaxAvailableWidth()-D.start-D.end;if(r){n&&((A=new t.OutputText(a,n,0,0)).setCSSStyle(l.getItemTitleStyle(e)),g=u=(O=A.getDimensions()).h,e._titleText=A),o&&((k=new t.OutputText(a,o,0,g)).setCSSStyle(l.getItemDescriptionStyle(e)),u=g+(w=k.getDimensions()).h,e._descText=k),h&&(C=l.getThumbnailWidth(),E=l.getThumbnailHeight(),d=0===d?0:d+l.getItemContentSpacing(),(y=new t.Image(a,h,d,0,C,E,"_tn")).setMouseEnabled(!1),_.addChild(y),c=C,m=E);d=x=T-c;if(n?(d=Math.min(O.w,d),t.TextUtils.fitText(A,x,1/0,_)):d=Math.min(0,d),o){var f=Math.min(w.w,x);0!==d&&f!==d?f>d?(A.setX(f-d),d=f):k.setX(d-f):d=f,t.TextUtils.fitText(k,x,1/0,_)}_._w=d+c}else{if(h){var C=l.getThumbnailWidth(),E=l.getThumbnailHeight(),y=new t.Image(a,h,0,0,C,E,"_tn");y.setMouseEnabled(!1),_.addChild(y),d=C+l.getItemContentSpacing(),m=E}var O,w;if(n){var A=new t.OutputText(a,n,d,0);A.setCSSStyle(l.getItemTitleStyle(e)),g=u=(O=A.getDimensions()).h,e._titleText=A}if(o){var k=new t.OutputText(a,o,d,g);k.setCSSStyle(l.getItemDescriptionStyle(e)),u=g+(w=k.getDimensions()).h,e._descText=k}var x;c=x=T-d;A?(c=Math.min(O.w,c),t.TextUtils.fitText(A,x,1/0,_)):c=0,k&&(c=Math.min(Math.max(w.w,c),x),t.TextUtils.fitText(k,x,1/0,_)),_._w=0===c?Math.max(d-l.getItemContentSpacing(),0):d+c}return _._h=Math.max(m,u),_},_setupDurationEvent:(e,t)=>{var i=e._content.getParent();i.removeChild(e._content),e._content=c._getBubbleContent(e,t),i.addChild(e._content),c._setupBubble(e,e._content)},_updateBubble:(e,i,s,a)=>{if((e._timeline._isComponentResize||e.getItemType()===h.DURATION_EVENT)&&c._setupDurationEvent(e,i),e.getItemType()===h.DURATION_EVENT)c._updateDurationEvent(e,i,null,a);else{var r=l.getBubblePadding(e),n=i.getCtx(),o=t.Agent.isRightToLeft(n),_=e._content,d=e.getWidth(),g=c.calcPadding(e,o,r,d,!1,_);_.setTranslate(g,r.top);var m=e._bubbleRect,u=e._innerBubbleRect;"alta"!==e._timeline.getCtx().getThemeBehavior()&&(m.setWidth(d),u.setWidth(Math.max(d-4,0)))}var v=i.calculateSpacing(e,s);e.setSpacing(v);var p=l.getItemTitleStyle(e),S=l.getItemDescriptionStyle(e);e._titleText&&e._titleText.getCSSStyle()!==p&&e._titleText.setCSSStyle(p),e._descText&&e._descText.getCSSStyle()!==S&&e._descText.setCSSStyle(S)},_renderFeeler:(e,i,s,a,r)=>{var n=i.getCtx(),o=t.Agent.isRightToLeft(n),_=e.getId(),d=e.getLoc(),g=e.getSpacing(),c=e._timeline.isDiscreteNavigationMode()?e._timeline._discreteContentLength:i._length;if(e.getItemType()!==h.DURATION_EVENT){var m,u="_feeler_"+_,v=e.getItemType()===h.DURATION_BAR?e.getDurationSize():0;if(i.isInverted())p=v,S=i.isTopToBottom()?g:i.Height-g-e.getHeight()+a+i._initialSpacing-l.getBubbleSpacing();else{var p=i.Height+a-v;if(i.isTopToBottom())S=g-i._initialSpacing+l.getBubbleSpacing()+e.getHeight();else var S=i.Height-g+a}m=o?c-d:d;var b=e._timeline.getTimeAxisSize(),D=new t.Line(n,m,p-b,m,S,u);r&&(D.setAlpha(0),r.push(D)),s.addChild(D);var T=l.getItemStrokeWidth(),f=l.getItemStrokeColor(e),C=new t.Stroke(f,1,T);D.setStroke(C),D._node=e,e.setFeeler(D)}else e.setFeeler(null)},_updateFeeler:(e,i,s,a)=>{var r=e._timeline.isDiscreteNavigationMode()?e._timeline._discreteContentLength:i._length;if(!i.isVertical()&&e.getItemType()!==h.DURATION_EVENT&&e._timeline.isFeelerEnabled()){var n,o=i.getCtx(),_=t.Agent.isRightToLeft(o),d=e.getFeeler(),g=e.getItemType()===h.DURATION_BAR?e.getDurationSize():0;if(i.isInverted())c=g,m=i.isTopToBottom()?e.getSpacing():i.Height-e.getSpacing()-e.getHeight()+s+i._initialSpacing-l.getBubbleSpacing(),s=0;else{var c=i.Height+s-g;if(i.isTopToBottom())m=e.getSpacing()-i._initialSpacing+l.getBubbleSpacing()+e.getHeight();else var m=i.Height-e.getSpacing()+s}n=_?r-e.getLoc():e.getLoc(),a?(d.setY1(d.getY1()+i._canvasOffsetY+s),d.setY2(d.getY2()+i._canvasOffsetY+s),a.addProp(t.Animator.TYPE_NUMBER,d,d.getX1,d.setX1,n),a.addProp(t.Animator.TYPE_NUMBER,d,d.getY1,d.setY1,c),a.addProp(t.Animator.TYPE_NUMBER,d,d.getX2,d.setX2,n),a.addProp(t.Animator.TYPE_NUMBER,d,d.getY2,d.setY2,m)):(d.setX1(n),d.setY1(c),d.setX2(n),d.setY2(m))}else e.setFeeler(null)},renderDuration:(e,t,i,s,a,r)=>{e.getDurationBar()?c._updateDuration(e,t,s,r):c._renderDuration(e,t,i,s,a)},_renderDuration:(e,i,s,a,r)=>{var n=i.getCtx(),o=t.Agent.isRightToLeft(n),h=e.getStartTime(),_=e.getEndTime(),d=e._timeline.getDatePos(h),g="_duration_"+e.getId(),c=22+10*e.getDurationLevel(),m=e._timeline.getDatePos(_),u=e._timeline.isDiscreteNavigationMode()?e._timeline._discreteContentLength:i._length;if(i.isVertical()){if(!o&&!i.isInverted()||o&&i.isInverted())var v=new t.Rect(n,i._size-c+5,d,c,m-d,g);else v=new t.Rect(n,-5,d,c,m-d,g),a=0;v.setTranslateX(a),v.setY(d),v.setWidth(c),v.setHeight(m-d)}else{var p=m-d;if(o)S=u-d-p;else var S=d;i.isInverted()?(v=new t.Rect(n,S,-5,p,c,g)).setTranslateY(0):(v=new t.Rect(n,S,i._size-c+5,p,c,g)).setTranslateY(a)}r&&(v.setAlpha(0),r.push(v)),v.setCornerRadius(5),v.setSolidFill(e.getDurationFillColor());var b=l.getItemStrokeWidth(),D=l.getItemStrokeColor(e),T=new t.Stroke(D,1,b);v.setStroke(T),v._node=e,i._callbackObj.EventManager.associate(v,e),s.addChild(v),e.setDurationBar(v)},_updateDuration:(e,i,s,a)=>{var r,n,o=i.getCtx(),l=t.Agent.isRightToLeft(o),h=e.getDurationBar(),_=e._timeline.isDiscreteNavigationMode()?e._timeline._discreteContentLength:i._length;if(null!=h){r=e._timeline.getDatePos(e.getStartTime());var d=22+10*e.getDurationLevel();if(n=e._timeline.getDatePos(e.getEndTime()),i.isVertical()){var g=0;if(!l&&!i.isInverted()||l&&i.isInverted())var c=i._size-d+5;else c=-5,s=0;var m=s,u=r,v=d,p=n-r}else{m=0;var S=n-r;c=l?_-r-S:r,i.isInverted()?(s=0,g=0,u=-5,v=S,p=d):(g=s,u=i._size-d+5,v=S,p=d)}a?(i.isVertical()?h.setTranslateX(h.getTranslateX()+i._canvasOffsetX+s):h.setTranslateY(h.getTranslateY()+i._canvasOffsetY+s),a.addProp(t.Animator.TYPE_NUMBER,h,h.getTranslateX,h.setTranslateX,m),a.addProp(t.Animator.TYPE_NUMBER,h,h.getTranslateY,h.setTranslateY,g),a.addProp(t.Animator.TYPE_NUMBER,h,h.getX,h.setX,c),a.addProp(t.Animator.TYPE_NUMBER,h,h.getY,h.setY,u),a.addProp(t.Animator.TYPE_NUMBER,h,h.getWidth,h.setWidth,v),a.addProp(t.Animator.TYPE_NUMBER,h,h.getHeight,h.setHeight,p)):(h.setTranslateX(m),h.setTranslateY(g),h.setX(c),h.setY(u),h.setWidth(v),h.setHeight(p))}},_resetDragPosition:e=>{e.setTranslate(e._initialPosition.initialX,e._initialPosition.initialY)},_updateDurationEvent:(e,i,s,a)=>{var r,n,o=(V=e._timeline.getOptions()).itemBubbleContentRenderer,h=i.getCtx(),_=t.Agent.isRightToLeft(h),d=e._timeline.getDatePos(e.getDragStartTime()),g=e._timeline.getDatePos(e.getDragEndTime()),m=e.getBubble(),u=m.getChildAt(0),v=u.getChildAt(0),p=e.getContentBubble(),S=e.getHeight(),b=Math.max(g-d,l.getMinDurationEvent(e)),D=e.getContentWidth(),T=e._timeline.isDiscreteNavigationMode();a?(a.addProp(t.Animator.TYPE_NUMBER,u,u.getWidth,u.setWidth,b),a.addProp(t.Animator.TYPE_NUMBER,v,v.getWidth,v.setWidth,b-4)):(u.setWidth(b),v.setWidth(b-4));var f=_?e.getResizeHandleStart():e.getResizeHandleEnd();f&&f.setTranslateX(b);var C=D<b?b:b+D+l.getContentBubbleSpacing();c.checkEndViewportCollision(e,C);var E=e.getEndViewportCollision(),y=_&&!E||!_&&E;const O=l.getContentBubbleBorderRadius(V),w=l.getContentBubblePathCmds(D,S,O,y);p.setCmds(w),"alta"!==e._timeline.getCtx().getThemeBehavior()&&(u.setHeight(S),v.setHeight(S-4));var A=e._timeline.getEventManager();if(c._isOverflow(e)||A._isDndDragging&&e===A.DragSource.getDragObject()){r=b+D+l.getContentBubbleSpacing(),u.getNumChildren()>1?(n=u.getChildAt(1),p.addChild(n),m.addChild(p)):n=p.getChildAt(0);var k=l.getBubblePadding(e),x=((I=c.calcPadding(e,_,k,b,!0,n))+15.5)*(y?-1:1);a?a.addProp(t.Animator.TYPE_NUMBER,p,p.getTranslateX,p.setTranslateX,x):p.setTranslateX(x),T&&(n.setVisible("visible"),e._timeline.isDnDMoveEnabled()&&m.setClassName("oj-timeline-item-bubble-container"));var M=_&&o?e.getContentWidth():k.start,P=k.top;a?(a.addProp(t.Animator.TYPE_NUMBER,n,n.getTranslateX,n.setTranslateX,M),a.addProp(t.Animator.TYPE_NUMBER,n,n.getTranslateY,n.setTranslateY,P)):n.setTranslate(M,P)}else{r=b,p.getNumChildren()>0?(n=p.getChildAt(0),u.addChild(n),m.removeChild(p)):n=u.getChildAt(1);k=l.getBubblePadding(e);var I=c.calcPadding(e,_,k,b,!1,n),R=e._timeline._viewStartTime>e.getEndTime()||e._timeline._viewEndTime<e.getStartTime();if(T&&R)n.setVisible(),e._timeline.isDnDMoveEnabled()&&m.setClassName("oj-timeline-item-bubble-container");else{n.setVisible("visible");M=I,P=k.top;a?(a.addProp(t.Animator.TYPE_NUMBER,n,n.getTranslateX,n.setTranslateX,M),a.addProp(t.Animator.TYPE_NUMBER,n,n.getTranslateY,n.setTranslateY,P)):n.setTranslate(M,P),e._timeline.isDnDMoveEnabled()&&m.setClassName("oj-timeline-item-bubble-container oj-timeline-move-handle oj-draggable")}}var L=Math.max(b,l.getMinDurationEvent(e)),V=e._timeline.Options,N=l.getColorStripeMarginStart(V),B=l.getColorStripeWidth(V),F=_?L-N-B:N,j=e.getColorStripe(),z=e.getBubble();if(j&&!e.hasColorStripe()&&(z.removeChild(j),e.setColorStripe(null)),!j&&e.hasColorStripe()){let t=e.createColorStripe();e.setColorStripe(t),z.addChild(t)}a?(s&&a.addProp(t.Animator.TYPE_NUMBER,m,m.getTranslateX,m.setTranslateX,s),j&&a.addProp(t.Animator.TYPE_NUMBER,j,j.getX,j.setX,F),a.addProp(t.Animator.TYPE_NUMBER,e,e.getWidth,e.setWidth,r),a.addProp(t.Animator.TYPE_NUMBER,e,e.getDurationWidth,e.setDurationWidth,L)):(s&&m.setTranslateX(s),j&&j.setX(F),e.setWidth(r),e.setDurationWidth(Math.max(b,L)))},_isOverflow:e=>{var t=e.getContentWidth(),i=e.getArtifactWidth();if(e.getItemType()!==h.DURATION_EVENT)return!1;var s=e.getAvailableContentWidth();return s+i<l.getDurationOverflowBreakpoint()&&s<t},calcPadding:(e,t,i,s,a,r)=>{var n=i.start;if(e.hasColorStripe()&&!a){var o=e._timeline.Options;n+=l.getColorStripeMarginStart(o)+l.getColorStripeWidth(o)}var _=n,d=e._timeline.getOptions().itemBubbleContentRenderer;t&&d&&(_=s-n-r._x);var g=e.getEndViewportCollision();a?((t&&!g||!t&&g)&&(s=e.getContentWidth()),t&&d?_=s:_+=s-n):t&&!d&&(_=Math.max(i.start,s-n-r._w));if(e._timeline.isDiscreteNavigationMode()&&!a&&e.getItemType()===h.DURATION_EVENT&&c.checkStartViewportCollision(e)){var m=e._timeline.getDiscreteViewportDatePos(e._timeline.getDiscreteViewportStartDate()),u=e._timeline.getDatePos(e.getDragStartTime()),v=Math.max(0,m-u);t?_-=v:_+=v}return _},checkStartViewportCollision:e=>e._timeline._viewStartTime>=e.getStartTime()&&e._timeline._viewStartTime<=e.getEndTime(),checkEndViewportCollision:(e,t)=>{if(e.setEndViewportCollision(!1),e.getItemType()===h.DURATION_EVENT){var i,s,a=e._timeline,r=e.getStartTime(),n=a.isDiscreteNavigationMode(),o=l.getNavButtonPadding();if(n)i=l.getNavButtonBackgroundWidth()-o,s=a.getDiscreteViewportDateOffsetPos(a._discreteViewportCurrentIndexOffset).endDate;else i=-o,s=a._end;var _=a.getDatePos(r)+t,d=a.getDatePos(s)+i-_;e.setEndViewportCollision(d<0)}}};class m extends i.TimeComponentEventManager{constructor(e){super(e),this._HIGH_LEVEL_DND_NAV_SCALES=["milliseconds","seconds","minutes","hours","days","weeks","months","quarters","years"]}addListeners(e){if(super.addListeners(e),!t.Agent.isTouchDevice()){var i=this.getCtx().getStage();"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||(i.addEvtListener("mouseenter",this.OnMouseEnter,!1,this),i.addEvtListener("mouseleave",this.OnMouseLeave,!1,this)),this._component.addEvtListener("focusout",this._handleFocusout,!1,this),this._component.addEvtListener("focusin",this._handleFocusin,!1,this)}this._component._hasListeners=!0}RemoveListeners(e){if(super.RemoveListeners(e),!t.Agent.isTouchDevice()){var i=this.getCtx().getStage();"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||(i.removeEvtListener("mouseenter",this.OnMouseEnter,!1,this),i.removeEvtListener("mouseleave",this.OnMouseLeave,!1,this)),this._component.removeEvtListener("focusout",this._handleFocusout,!1,this),this._component.removeEvtListener("focusin",this._handleFocusin,!1,this),this._clearOpenPopupListeners()}this._component._hasListeners=!1}_clearOpenPopupListeners(){null!=this._openPopup&&(this._openPopup.removeEventListener("focusin",this._handlePopupFocusinListener),this._openPopup.removeEventListener("focusout",this._handlePopupFocusoutListener),this._openPopup=null),this._handlePopupFocusinListener=null,this._handlePopupFocusoutListener=null}_handlePopupFocusout(e){this._handleFocusout(e,!0)}_handlePopupFocusin(e){this._handleFocusin(e,!0)}_clearFocusoutTimeout(){this._focusoutTimeout&&(clearTimeout(this._focusoutTimeout),this._focusoutTimeout=null)}_handleFocusout(e,t){if(this._clearFocusoutTimeout(),!t){this._clearOpenPopupListeners();var i=a.getLogicalChildPopup(this._component.getElem());if(null!=i)return this._openPopup=i,this._handlePopupFocusinListener=this._handlePopupFocusin.bind(this),this._handlePopupFocusoutListener=this._handlePopupFocusout.bind(this),i.addEventListener("focusin",this._handlePopupFocusinListener),void i.addEventListener("focusout",this._handlePopupFocusoutListener)}this._focusoutTimeout=setTimeout(function(){this._clearOpenPopupListeners();var e=this._component.getOptions()._keyboardUtils;this._component.activeInnerElemsNode&&(e.disableAllFocusable(this._component.activeInnerElemsNode._displayable.getElem()),this._component.activeInnerElemsNode.hasActiveInnerElems=!1,this._component.activeInnerElems=null,this._component.activeInnerElemsNode=null)}.bind(this),100)}_handleFocusin(e,t){this._clearFocusoutTimeout(),t||this._clearOpenPopupListeners()}ProcessKeyboardEvent(e){var i=!0,s=e.keyCode,a=this.getFocus();if(s==t.KeyboardEvent.TAB&&a){var r=this._component.activeInnerElems?this._component.activeInnerElems.length:void 0;if(r)return(e.shiftKey?this._component.activeInnerElems[0]:this._component.activeInnerElems[r-1])===document.activeElement&&(e.shiftKey?this._component.activeInnerElems[r-1].focus():this._component.activeInnerElems[0].focus(),e.preventDefault()),i;this._component.Options._keyboardUtils.disableAllFocusable(this._component.getTimeZoomCanvas().getElem(),!0)}return i=super.ProcessKeyboardEvent(e)}PreOnMouseOver(e){this._mouseOutTimer&&this._mouseOutTimer.isRunning()&&this._mouseOutTimer.stop(),super.PreOnMouseOver(e),"ie"===t.Agent.browser||"edge"===t.Agent.browser||this.isMouseOver||(this.isMouseOver=!0)}OnMouseEnter(e){this._mouseOutTimer&&this._mouseOutTimer.isRunning()&&this._mouseOutTimer.stop(),this.isMouseOver||(this.isMouseOver=!0)}OnMouseLeave(e){this._mouseOutTimer||(this._mouseOutTimer=new t.Timer(this.getCtx(),10,this._onMouseOutTimerEnd,this,1)),this._mouseOutTimer.reset(),this._mouseOutTimer.start()}PreOnMouseOut(e){super.PreOnMouseOut(e),"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser&&(this._mouseOutTimer||(this._mouseOutTimer=new t.Timer(this.getCtx(),10,this._onMouseOutTimerEnd,this,1)),this._mouseOutTimer.reset(),this._mouseOutTimer.start())}_onMouseOutTimerEnd(){this.isMouseOver=!1}OnMouseDown(e){var t=this.setDraggedObj(e);super.OnMouseDown(t)}HandleImmediateTouchStartInternal(e){1===e.targetTouches.length&&this.setDraggedObj(e)}setDraggedObj(e){var t=this.GetLogicalObjectAndDisplayable(e.target);if(t.displayable&&t.displayable.getClassName()&&-1!==t.displayable.getClassName().indexOf("oj-draggable")){var i=null;-1!==t.displayable.getClassName().indexOf("oj-timeline-move-handle")?i="event":-1!==t.displayable.getClassName().indexOf("oj-timeline-resize-handle-start")?(i="resize-handle",t.logicalObject._displayable._resizeEdge="start"):-1!==t.displayable.getClassName().indexOf("oj-timeline-resize-handle-end")&&(i="resize-handle",t.logicalObject._displayable._resizeEdge="end"),t.logicalObject.setDragType(i),this.IsDragSupported(t.logicalObject.getDragType())&&(this._component.SetPanningEnabled(!1),this._component.SetMarqueeEnabled(!1),t.logicalObject.setDraggedObj(t.logicalObject._displayable))}return e}prevPage(){-1===this._component._prevArrowContainer.getClassName().indexOf("oj-timeline-nav-arrow-disabled")&&(this._component._discreteViewportCurrentIndexOffset--,this._component.handlePageChangeDiscreteViewport())}nextPage(){-1===this._component._nextArrowContainer.getClassName().indexOf("oj-timeline-nav-arrow-disabled")&&(this._component._discreteViewportCurrentIndexOffset++,this._component.handlePageChangeDiscreteViewport())}handleArrowPress(e){var t=this.getFocus();return"prevNavArrow"===t._id?this.prevPage():"nextNavArrow"===t._id&&this.nextPage(),t}panBy(e,t){var i=this.getFocus();i&&(this._comp._dragPanSeries=i._series),super.panBy(e,t)}_handleDragCancel(e){this.handleDurationEventReset(e,e._series)}handleDurationEventResize(e,t,i){c._setupDurationEvent(e,t),c._updateDurationEvent(e,t,i)}handleDurationEventReset(e,t){c._setupDurationEvent(e,t),c._updateDurationEvent(e,t)}GetDragSourceType(e){var i=this.DragSource.getDragObject();if(i&&"duration-event"===i.getItemType()){if(e&&"dragstart"===e.getNativeEvent().type){var s=e.getNativeEvent(),a=s.clientX,r=s.clientY,n=s.offsetX,o=s.offsetY;null==a&&null==r||("ie"===t.Agent.browser||"edge"===t.Agent.browser)&&isNaN(n)&&isNaN(o)}return this.getDragType(i)}return null}GetDropTargetType(e){return"canvas"}GetDropEventPayload(e){var t=this.DragSource.getDragObject()?this.DragSource.getDragObject():this._keyboardDragObject,i=this._context.pageToStageCoords(e.pageX,e.pageY),s=t._displayable._initialDragOffset.offsetX-i.x,a={value:new Date(this._component.getPosDate(t._displayable._initialDragOffset.offsetX-s)).toISOString(),start:null,end:null};if((t=this.DragSource.getDragObject())&&"duration-event"===t.getItemType()){var r=t._dragStartTime,n=t._dragEndTime,o=this.getDnDTaskSubType(t);return"event"===o?(a.start=r,a.end=n,a.start=new Date(a.start).toISOString(),a.end=new Date(a.end).toISOString()):"resize-handle"===o&&("start"===t._displayable._resizeEdge?(a.start=new Date(r).toISOString(),a.end=new Date(t._endTime).toISOString()):(a.start=new Date(t._startTime).toISOString(),a.end=new Date(n).toISOString())),a}}IsDragSupported(e){if(this.isDndSupported()){var t=this._component.getOptions(),i=t.dnd&&t.dnd.drag?t.dnd.drag:null;return i&&i[e]&&i[e].dataTypes&&i[e].dataTypes.length>0}return!1}getDragType(e){return e?e.getDragType():null}isDndSupported(){return!0}isDnDDragging(){return this._isDndDragging}_dragStartSetup(){this._dragInitialX=this._component.getTimeZoomCanvas().getTranslateX(),this._dragInitialY=this._component.getTimeZoomCanvas().getTranslateY(),this._dragInitialViewportStart=this._component.getViewportStartTime(),this._dragInitialViewportEnd=this._component.getViewportEndTime()}_setupObjMoveAffordance(e){c._renderEventMoveDragOutline(e),e._series._blocks[0].removeChild(e._displayable),e._series._blocks[0].addChild(e._displayable)}_setupMoveAffordance(e){"event"===e.getDragType()&&(this._setupObjMoveAffordance(e),this._applyToSelection(t=>{t&&e!=t&&this._setupObjMoveAffordance(t)}))}_hideMoveAffordance(e){"event"===e.getDragType()&&(c._hideEventMoveDragOutline(e),this._applyToSelection(t=>{t&&t!=e&&c._hideEventMoveDragOutline(t)}))}_dragCancelCleanup(){if(this._dragInitialX){var e=this._component.getTimeZoomCanvas().getTranslateX()-this._dragInitialX,t=this._component.getTimeZoomCanvas().getTranslateY()-this._dragInitialY;if(0!==e||0!==t){var i=this._keyboardDragObject?this._keyboardDragObject:this.DragSource.getDragObject();this._component.isDiscreteNavigationMode()?this._component.discreteScrollIntoViewport(i):(this._component.panZoomCanvasBy(e),this._component.setViewportStartTime(this._dragInitialViewportStart),this._component.setViewportEndTime(this._dragInitialViewportEnd))}}this._dragInitialX=null,this._dragInitialY=null,this._dragInitialViewportStart=null,this._dragInitialViewportEnd=null}_dropCleanup(){null==this._dragInitialViewportStart||this._dragInitialViewportStart===this._component.getViewportStartTime()&&this._dragInitialViewportEnd===this._component.getViewportEndTime()||this._component.dispatchEvent(this._component.createViewportChangeEvent()),this._dragInitialX=null,this._dragInitialY=null,this._dragInitialViewportStart=null,this._dragInitialViewportEnd=null,this._isDndDragging=!1}getKeyboardDnDMode(){return this._keyboardDnDMode}updateDnd(){if(null!=this._keyboardDnDMode)this._setupMoveAffordance(this._keyboardDragObject),this._keyboardDragObject.dragStartSetup(),this._keyboardDragObject.updateDragFeedback(this._keyboardDragObject),this._applyToSelection(e=>{e&&e!=this._keyboardDragObject&&e.updateDragFeedback(this._keyboardDragObject)});else{var e=this.DragSource.getDragObject();this._setupMoveAffordance(e),e.dragStartSetup(),e.updateDragFeedback(e),this._applyToSelection(t=>{t&&t!=e&&t.updateDragFeedback(e)})}}OnDndDragStart(e){super.OnDndDragStart(e),this._isDndDragging&&e.preventDefault();var i=e.getNativeEvent();if(i.defaultPrevented)this._component.SetPanningEnabled(!0),this._component.SetMarqueeEnabled(!0);else{this._isDndDragging=!0,this._dragStartSetup();var s=this.DragSource.getDragObject();this._applyToSelection(e=>{e&&e!=s&&("event"===s.getDragType()&&this._setupMoveAffordance(e),e.dragStartSetup(i))}),"event"===s.getDragType()&&(this._setupMoveAffordance(s),this._applyToSelection(e=>{e&&e!=s&&this._setupMoveAffordance(e)})),s.dragStartSetup(i),this._applyToSelection(e=>{e&&e!=s&&e.dragStartSetup(i)}),this._dropOffset=new t.Point(0,0)}}OnDndDragOver(e){super.OnDndDragOver(e);var i=this;this._lastKnownDragOverEvent=e,i._isDndDragging=!0,this._isDragOverTicking||this._lastProcessedDragOverEvent&&this._lastKnownDragOverEvent.pageX===this._lastProcessedDragOverEvent.pageX&&this._lastKnownDragOverEvent.pageY===this._lastProcessedDragOverEvent.pageY||(requestAnimationFrame(()=>{var e=i.DragSource.getDragObject();if(e&&i._isDndDragging&&i._lastKnownDragOverEvent.getNativeEvent().defaultPrevented&&(i._handleDndPan(e),i._dragShowFeedback(e),t.Agent.isTouchDevice())){var s=t.AriaUtils.processAriaLabel(o.getDatatip(e,!1));if(i._component.isItemSelectionEnabled()&&e.isSelected()){var a=i._component.SelectionHandler.getSelectedCount();a>1&&(s+=". "+t.ResourceUtils.format(i._component.getOptions().translations.itemMoveSelectionInfo,[a-1]))}i._prevScreenReaderDragText&&i._prevScreenReaderDragText===s||i._component.updateLiveRegionText(s),i._prevScreenReaderDragText=s}i._lastProcessedDragOverEvent=i._lastKnownDragOverEvent,i._isDragOverTicking=!1}),this._isDragOverTicking=!0)}OnDndDragEnd(e){super.OnDndDragEnd(e);var t=this.DragSource.getDragObject();"event"===t.getDragType()&&(this._hideMoveAffordance(t),this._applyToSelection(e=>{e&&e!=t&&this._hideMoveAffordance(t)})),this._isDndDragging=!1,"none"===e.getNativeEvent().dataTransfer.dropEffect&&(this.handleKeyboardDnDCancel(),this._handleDragCancel(t),this._dropCleanup()),t._dropCleanup(),this._applyToSelection(e=>{e&&e!=t&&e._dropCleanup()}),this._component.SetPanningEnabled(!0),this._component.SetMarqueeEnabled(!0)}_dragShowFeedback(e){var t=this._component.getCtx().pageToStageCoords(this._lastKnownDragOverEvent.pageX,this._lastKnownDragOverEvent.pageY);e.showDragFeedback(this._lastKnownDragOverEvent,t,e,this._dropOffset,!1,!0),this._applyToSelection(i=>{i&&i!=e&&i.showDragFeedback(this._lastKnownDragOverEvent,t,e,this._dropOffset,!1,!1)})}OnDndDrop(e){if(super.OnDndDrop(e),e.getNativeEvent().defaultPrevented){var i=this.DragSource.getDragObject(),s=i.getDragType();if(this._component.isDnDMoveEnabled()&&"event"===s){t.Agent.isTouchDevice()&&this._component.updateLiveRegionText(this._component.getOptions().translations.itemMoveFinalized);for(var a=this.GetDropEventPayload(e),r=this._component.SelectionHandler.getSelection(),n=[],o=0;o<r.length;o++){var l=r[o];n.push(l.getDataContext())}var h=a.value,_=a.start,d=a.end,g=t.EventFactory.newTimelineMoveEvent(n,h,_,d);this._component.dispatchEvent(g)}else if(this._component.isDnDResizeEnabled()&&"resize-handle"===s){t.Agent.isTouchDevice()&&this._component.updateLiveRegionText(this._component.getOptions().translations.itemResizeFinalized);for(a=this.GetDropEventPayload(e),r=this._component.SelectionHandler.getSelection(),n=[],o=0;o<r.length;o++){l=r[o];n.push(l.getDataContext())}h=a.value,_=a.start,d=a.end,g=t.EventFactory.newTimelineResizeEvent(n,h,_,d,i._displayable._resizeEdge);this._component.dispatchEvent(g)}}}getDnDTaskSubType(e){return this.getDragType(e)}_applyToSelection(e){for(var t=this._component.SelectionHandler.getSelection(),i=0;i<t.length;i++){e(t[i])}}_handleKeyboardDnDInitiation(e,i,s,a){if(i&&"duration-event"!==i.getItemType()||this._isDndDragging)return e.preventDefault(),null;var r=t.Agent.isRightToLeft(this._component.getCtx())?-1:1;this._isDndDragging=!0,this._keyboardDragObject=i,this._dragStartSetup(),this._component.registerAndConstructGlassPane();var n=this._component.installGlassPane();this._keyboardDnDScaleRampIndex=this._HIGH_LEVEL_DND_NAV_SCALES.indexOf(this._component.getTimeAxis().getScale()),i.setDraggedObj(i._displayable),"move"===this._keyboardDnDMode?i.setDragType("event"):"resizeStart"!==this._keyboardDnDMode&&"resizeEnd"!==this._keyboardDnDMode||(i.setDragType("resize-handle"),i._displayable._resizeEdge=s),this._keyboardDnDFeedbackLocalPos={x:i._displayable.getTranslateX()+("end"===s)*r*i._displayable.getDimensions().w,y:i._displayable.getTranslateY()};var o={offsetX:this._keyboardDnDFeedbackLocalPos.x,offsetY:this._keyboardDnDFeedbackLocalPos.y};i.dragStartSetup(o),this._setupMoveAffordance(i),i.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,i,{x:0,y:0},!0,!0),this._applyToSelection(t=>{t&&t!=i&&(t.dragStartSetup(o),"move"===this._keyboardDnDMode&&this._setupMoveAffordance(t),t.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,i,{x:0,y:0},!0,!1))}),n&&(this._preventHideTooltip=!0),this._keyboardDnDTargetObj=null;var l=i.getStartTime(),h=i.getEndTime();this._keyboardDnDFeedbackTime={start:l,end:h};var _=this._component.getOptions().translations,d=_[a.initiated];if(this._component.isItemSelectionEnabled()&&this._keyboardDragObject.isSelected()){var g=this._component.SelectionHandler.getSelectedCount();g>1&&(d+=". "+t.ResourceUtils.format(_[a.selectionInfo],[g-1]))}d+=". "+_[a.instruction]+".",this._component.updateLiveRegionText(d)}handleKeyboardMoveInitiation(e,t){this._keyboardDnDMode="move";this._handleKeyboardDnDInitiation(e,t,"start",{initiated:"itemMoveInitiated",selectionInfo:"itemMoveSelectionInfo",instruction:"itemMoveInitiatedInstruction"})}handleKeyboardResizeStartInitiation(e,t){this._keyboardDnDMode="resizeStart";this._handleKeyboardDnDInitiation(e,t,"start",{initiated:"itemResizeStartInitiated",selectionInfo:"itemResizeSelectionInfo",instruction:"itemResizeInitiatedInstruction"})}handleKeyboardResizeEndInitiation(e,t){this._keyboardDnDMode="resizeEnd";this._handleKeyboardDnDInitiation(e,t,"end",{initiated:"itemResizeEndInitiated",selectionInfo:"itemResizeSelectionInfo",instruction:"itemResizeInitiatedInstruction"})}_handleKeyboardDnDChronologically(e,i){var s,a,r=t.Agent.isRightToLeft(this._component.getCtx()),n=this.getKeyboardDnDNavigationScale(),h=l.getNavButtonBackgroundWidth(),_=this._component.isDiscreteNavigationMode()?this._component.getPosDate(this._component.getDatePos(this._component._start)+h):this._component._start,d=this._component.isDiscreteNavigationMode()?this._component.getPosDate(this._component.getDatePos(this._component._end)-h):this._component._end,g=this._component.isDiscreteNavigationMode()?this._component._discreteContentLength:this._component.getContentLength(),c=this._component.getTimeAxis(),m="forward"===i?"next":"previous",u=c.getAdjacentDate(this._keyboardDnDFeedbackTime.start,n,m).getTime(),v=c.getAdjacentDate(this._keyboardDnDFeedbackTime.end,n,m).getTime();switch(this._keyboardDnDMode){case"move":("forward"===i&&u<=d||"backward"===i&&v>=_)&&(a=this._component.getDatePos(this._keyboardDnDFeedbackTime.start),this._keyboardDnDFeedbackTime.start=u,this._keyboardDnDFeedbackTime.end=v,s=this._component.getDatePos(this._keyboardDnDFeedbackTime.start));break;case"resizeStart":var p=this._keyboardDragObject.getEndTime();("forward"===i&&u<=p||"backward"===i&&u>=_)&&(a=this._component.getDatePos(this._keyboardDnDFeedbackTime.start),this._keyboardDnDFeedbackTime.start=u,s=this._component.getDatePos(this._keyboardDnDFeedbackTime.start)),"start";break;case"resizeEnd":var S=this._keyboardDragObject.getStartTime();("forward"===i&&v<=d||"backward"===i&&v>=S)&&(a=this._component.getDatePos(this._keyboardDnDFeedbackTime.end),this._keyboardDnDFeedbackTime.end=v,s=this._component.getDatePos(this._keyboardDnDFeedbackTime.end)),"end"}if(null!=s){var b=(r?g-s:s)-(r?g-a:a);this._keyboardDnDFeedbackLocalPos.x+=b,this._component.isDiscreteNavigationMode()?this._component.getPosDate(s)<this._component.getViewportStartTime()?this.prevPage():this._component.getPosDate(s)>this._component.getViewportEndTime()&&this.nextPage():this._component.panBy(b,0)}this._keyboardDragObject.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,this._keyboardDragObject,{x:0,y:0},!0,!0),this._applyToSelection(t=>{t&&t!=this._keyboardDragObject&&t.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,this._keyboardDragObject,{x:0,y:0},!0,!1)}),this._component.updateLiveRegionText(t.AriaUtils.processAriaLabel(o.getDatatip(this._keyboardDragObject,!1)))}handleKeyboardDnDForward(e){this._handleKeyboardDnDChronologically(e,"forward")}handleKeyboardDnDBackward(e){this._handleKeyboardDnDChronologically(e,"backward")}_handleKeyboardDnDScaleChange(e,i){this._isKeyboardDnDScaleChanged=!0,this._keyboardDnDScaleRampIndex=Math.max(0,Math.min(this._keyboardDnDScaleRampIndex+i,this._HIGH_LEVEL_DND_NAV_SCALES.length-1)),this._keyboardDragObject.showDragFeedback(e,this._keyboardDnDFeedbackLocalPos,this._keyboardDragObject,{x:0,y:0},!0,!0),this._component.updateLiveRegionText(t.AriaUtils.processAriaLabel(o.getDatatip(this._keyboardDragObject,!1))),this._isKeyboardDnDScaleChanged=!1}isKeyboardDnDScaleChanged(){return this._isKeyboardDnDScaleChanged}getKeyboardDnDNavigationScale(){return this._HIGH_LEVEL_DND_NAV_SCALES[this._keyboardDnDScaleRampIndex]}handleKeyboardDnDScaleUp(e){this._handleKeyboardDnDScaleChange(e,1)}handleKeyboardDnDScaleDown(e){this._handleKeyboardDnDScaleChange(e,-1)}handleKeyboardDnDFinalize(){var e,i,s,a,r;this._dropCleanup();var n=this._component.getOptions().translations,o=this._component.SelectionHandler.getSelection(),l=[this._keyboardDragObject.getDataContext()];if("move"===this._keyboardDnDMode){for(var h=0;h<o.length;h++){(_=o[h])!==this._keyboardDragObject&&l.push(_.getDataContext())}e=new Date(this._keyboardDnDFeedbackTime.start).toISOString(),i=new Date(this._keyboardDnDFeedbackTime.end).toISOString(),s=e,a=t.EventFactory.newTimelineMoveEvent(l,s,e,i),r=n.itemMoveFinalized}else if("resizeEnd"===this._keyboardDnDMode||"resizeStart"===this._keyboardDnDMode){for(h=0;h<o.length;h++){var _=o[h];l.push(_.getDataContext())}var d;e=new Date(this._keyboardDnDFeedbackTime.start).toISOString(),i=new Date(this._keyboardDnDFeedbackTime.end).toISOString(),"resizeEnd"===this._keyboardDnDMode?(s=i,d="end"):"resizeStart"===this._keyboardDnDMode&&(s=e,d="start"),a=t.EventFactory.newTimelineResizeEvent(l,s,e,i,d),r=n.itemResizeFinalized}a&&(this._component.dispatchEvent(a),this._component.updateLiveRegionText(r)),this._keyboardDnDCleanup()}handleKeyboardDnDCancel(){var e=this._component.getOptions().translations;"move"===this._keyboardDnDMode?this._component.updateLiveRegionText(e.itemMoveCancelled):"resizeEnd"!==this._keyboardDnDMode&&"resizeStart"!==this._keyboardDnDMode||this._component.updateLiveRegionText(e.itemResizeCancelled),this._dragCancelCleanup(),this._keyboardDnDCleanup()}_keyboardDnDCleanup(){null!=this._keyboardDnDMode&&(this._keyboardDragObject&&(this._hideMoveAffordance(this._keyboardDragObject),this._keyboardDragObject._dropCleanup(),this._applyToSelection(e=>{e&&e!=this._keyboardDragObject&&(this._hideMoveAffordance(e),e._dropCleanup())})),this._keyboardDnDMode=null,this._isDndDragging=!1,this._keyboardDnDTargetObj=null,this._keyboardDnDFeedbackTime=null,this._keyboardDnDScaleRampIndex=null,this._keyboardDragObject=null,this._component.unregisterAndDestroyGlassPane())}_isMouseInStartPreview(){var e=t.Agent.isRightToLeft(this._component.getCtx()),i=l.getNavButtonBackgroundWidth(),s=this._component.getCtx().pageToStageCoords(this._lastKnownDragOverEvent.pageX,this._lastKnownDragOverEvent.pageY),a=e?this._component._backgroundWidth-i:0;return s.x>a&&s.x<a+i}_isMouseInEndPreview(){var e=t.Agent.isRightToLeft(this._component.getCtx()),i=l.getNavButtonBackgroundWidth(),s=this._component.getCtx().pageToStageCoords(this._lastKnownDragOverEvent.pageX,this._lastKnownDragOverEvent.pageY),a=e?i:this._component._backgroundWidth;return s.x>a-i&&s.x<a}_handleDndPan(e){this._component.isDiscreteNavigationMode()?this._handleDndDiscretePan(e):(this._isMouseInStartPreview()||this._isMouseInEndPreview())&&(this._handleIntervalPan(e),null!=this._isDndPanWaiting&&(clearTimeout(this._isDndPanWaiting),this._isDndPanWaiting=null))}_handleDndDiscretePan(e){this._component.startPanAllowed()&&this._isMouseInStartPreview()?(null==this._isDndStartPanWaiting&&(this._isDndStartPanWaiting=setTimeout(()=>{this._handleStartPan(e)},2e3)),clearTimeout(this._isDndEndPanWaiting),this._isDndEndPanWaiting=null):this._component.endPanAllowed()&&this._isMouseInEndPreview()?(null==this._isDndEndPanWaiting&&(this._isDndEndPanWaiting=setTimeout(()=>{this._handleEndPan(e)},2e3)),clearTimeout(this._isDndStartPanWaiting),this._isDndStartPanWaiting=null):(clearTimeout(this._isDndEndPanWaiting),clearTimeout(this._isDndStartPanWaiting),this._isDndStartPanWaiting=null,this._isDndEndPanWaiting=null)}_handleStartPan(e){this._component.startPanAllowed()&&this._isMouseInStartPreview()&&this._isDndDragging?(this.prevPage(),this._dragShowFeedback(e),this._isDndStartPanWaiting=setTimeout(()=>{this._handleStartPan(e)},2e3)):(clearTimeout(this._isDndStartPanWaiting),this._isDndStartPanWaiting=null)}_handleEndPan(e){this._component.endPanAllowed()&&this._isMouseInEndPreview()&&this._isDndDragging?(this.nextPage(),this._dragShowFeedback(e),this._isDndEndPanWaiting=setTimeout(()=>{this._handleEndPan(e)},2e3)):(clearTimeout(this._isDndEndPanWaiting),this._isDndEndPanWaiting=null)}_handleIntervalPan(e){if(this._isDndDragging){var t=null;if(this._isMouseInEndPreview(e))t="next";else if(this._isMouseInStartPreview(e))t="previous";if(null!==t){var i=this._component.getTimeAxis(),s=this.getKeyboardDnDNavigationScale();s=s||this._component._scale;var a=e.getDragStartTime(),r=i.getAdjacentDate(a,s,t).getTime(),n=this._component.getDatePos(r)-this._component.getDatePos(a);return this._component.panBy(n),this._dragShowFeedback(e),void(this._isDndPanWaiting=setTimeout(()=>{this._handleIntervalPan(e)},250))}}clearTimeout(this._isDndPanWaiting),this._isDndPanWaiting=null}}class u{parse(e){var t=new Object;t.start=new Date(e.start).getTime(),t.end=new Date(e.end).getTime(),e.viewportStart&&(t.viewStart=new Date(e.viewportStart).getTime()),e.viewportEnd&&(t.viewEnd=new Date(e.viewportEnd).getTime()),e.selectionMode?t.selectionMode=e.selectionMode:t.selectionMode="none",t.inlineStyle=e.style,e.svgStyle&&(t.inlineStyle=e.svgStyle);var i=e.minorAxis;if(i){var s=i.scale;t.scale=s,t.customFormatScales=i._cfs}var a=e.majorAxis;a&&(t.seriesScale=a.scale,t.seriesConverter=a.converter,t.seriesCustomFormatScales=a._cfs),t.shortDesc=e.shortDesc,t.orientation=e.orientation;var r=e.referenceObjects;if(r&&r.length>=0){for(var n=[],o=0;o<r.length;o++)n.push(new Date(r[o].value));t.referenceObjects=n}var l=e.overview;return null!=l&&"on"===l.rendered?t.hasOverview=!0:t.hasOverview=!1,t.itemPosition=e._ip,t.customTimeScales=e._cts,t}}class v extends t.BaseComponentDefaults{constructor(){super({alta:{overviewPosition:"below",style:{borderTopStyle:"none",currentTimeIndicatorColor:"#c000d1",handleFillColor:"#ffffff",handleTextureColor:"#b3c6db",leftFilterPanelAlpha:.7,leftFilterPanelColor:"#ffffff",overviewBackgroundColor:"#e6ecf3",rightFilterPanelAlpha:.7,rightFilterPanelColor:"#ffffff",timeAxisBarColor:"#d9dfe3",timeAxisBarAlpha:0,timeIndicatorColor:"#bcc7d2",windowBackgroundAlpha:1,windowBackgroundColor:"#ffffff",windowBorderBottomColor:"#4f4f4f",windowBorderBottomStyle:"solid",windowBorderLeftColor:"#4f4f4f",windowBorderLeftStyle:"solid",windowBorderRightColor:"#4f4f4f",windowBorderRightStyle:"solid",windowBorderTopColor:"#4f4f4f",windowBorderTopStyle:"solid"},_fc:"#aadd77",_do:0,_bc:"#648baf",_bof:"0px",_bs:"solid",_bw:"1px",_dbc:"#648baf",_dbs:"solid",_dbw:"1px",_hbc:"#85bbe7",_hbs:"solid",_hbw:"2px",_hbof:"0px",_hgc:"#ebeced",_hgo:1,_hdbs:"solid",_hdbc:"#85bbe7",_hdbw:"2px",_sbs:"solid",_sbc:"#000000",_sbw:"2px",_sbof:"0px",_sbo:1,_sdbs:"solid",_sdbc:"#000000",_sdbw:"2px",_asbs:"solid",_asbc:"#000000",_asbw:"2px",_asbof:"0px",_asbo:1,_asgc:"#e4f0fa",_asgo:1,_asdbs:"solid",_asdbc:"#000000",_asdbw:"2px",_aoc:"off"}})}}class p{constructor(e,i){this._view=e,this._rowKey=i.rowKey,this._id=i.id,this._seriesId=i.seriesId,this._time=parseInt(i.time),this._endTime=null==i.endTime?null:parseInt(i.endTime),this._shape=t.SimpleMarker.CIRCLE,"square"===i.shape?this._shape=t.SimpleMarker.RECTANGLE:"plus"===i.shape?this._shape=t.SimpleMarker.PLUS:"diamond"===i.shape?this._shape=t.SimpleMarker.DIAMOND:"triangleUp"===i.shape?this._shape=t.SimpleMarker.TRIANGLE_UP:"triangleDown"===i.shape&&(this._shape=t.SimpleMarker.TRIANGLE_DOWN),this._desc=i.desc,this._color=i.color,this._gradient=i.gradient,null!=i.opacity&&(this._opacity=parseFloat(i.opacity)),null!=i.scaleX&&(this._scaleX=parseFloat(i.scaleX)),null!=i.scaleY&&(this._scaleY=parseFloat(i.scaleY)),null!=i.durationFillColor&&(this._durationFillColor=i.durationFillColor)}getId(){return this._id}getSeriesId(){return this._seriesId}getRowKey(){return this._rowKey}getTime(){return this._time}getEndTime(){return this._endTime}getScaleX(){return this._scaleX}getScaleY(){return this._scaleY}getDescription(){return this._desc}getColor(){return this._color}isGradient(){return this._gradient}getShape(){return this._shape}getOpacity(){return this._opacity}getDisplayable(){return this._displayable}setDisplayable(e){this._displayable=e}getX(){return this._x}setX(e){this._x=e}getY(){return this._y}setY(e){this._y=e}}const S=e=>e._ds,b=e=>e._dsx,D=e=>e._dsy,T=e=>e._do,f=e=>e._fc,C=e=>e._ph,E=e=>{var t=new Object;return t._bs=e._bs,t._bc=e._bc,t._bw=e._bw,t._bof=e._bof,t._bo=e._bo,t._gc=e._gc,t._go=e._go,t._dbs=e._dbs,t._dbc=e._dbc,t._dbw=e._dbw,t._hbs=e._hbs,t._hbc=e._hbc,t._hbw=e._hbw,t._hbof=e._hbof,t._hbo=e._hbo,t._hgc=e._hgc,t._hgo=e._hgo,t._hdbs=e._hdbs,t._hdbc=e._hdbc,t._hdbw=e._hdbw,t._sbs=e._sbs,t._sbc=e._sbc,t._sbw=e._sbw,t._sbof=e._sbof,t._sbo=e._sbo,t._sgc=e._sgc,t._sgo=e._sgo,t._sdbs=e._sdbs,t._sdbc=e._sdbc,t._sdbw=e._sdbw,t._asbs=e._asbs,t._asbc=e._asbc,t._asbw=e._asbw,t._asbof=e._asbof,t._asbo=e._asbo,t._asgc=e._asgc,t._asgo=e._asgo,t._asdbs=e._asdbs,t._asdbc=e._asdbc,t._asdbw=e._asdbw,t};class y extends r.OverviewParser{parse(e){var t=this.ParseRootAttributes(e);return t.timeAxisInfo=this._parseTimeAxis(e.axisTicks),t.markers=this._parseDataNode(e.markers,t.defaultMarkerStyles),t.formattedTimeRanges=e.formattedTimeRanges,t}ParseRootAttributes(e){var t=super.ParseRootAttributes(e);t.orientation=e.orn,t.selectionMode=e.selmode,t.isRtl=e.rtl.toString(),t.seriesIds=e.sid,t.animationOnClick=e._aoc,t.referenceObjects=e.referenceObjects;var i=new Object;return i.shape=S(e),i.scaleX=b(e),i.scaleY=D(e),i.opacity=T(e),i.color=f(e),i.pixelHinting=C(e),t.defaultMarkerStyles=i,t.labelStyle=e._ls,t}_parseDataNode(e,t){if(e){for(var i=[],s=0;s<e.length;s++){var a=this.ParseNodeAttributes(e[s],t),r=new p(this._view,a);i.push(r)}return i}return null}ParseNodeAttributes(e,t){var i=new Object,s="true"===e._sd;return i.id=e.tid,i.seriesId=e.sid,i.rowKey=e.rk,i.time=e.t,i.endTime=e.et,i.shape=e.s,s&&null==i.shape&&(i.shape=t.shape),i.desc=e.d,i.color=e.c,i.durationFillColor=e.dfc,s&&null==i.color&&(i.color=t.color),i.scaleX=e.sx,s&&null==i.scaleX&&(i.scaleX=t.scaleX),i.scaleY=e.sy,s&&null==i.scaleY&&(i.scaleY=t.scaleY),i.gradient=e.g,i.opacity=e.o,s&&null==i.opacity&&(i.opacity=t.opacity),i}_parseTimeAxis(e){if(e){var t=new Object;return t.width=null,t.height=null,t.ticks=e,t}return null}}class O extends r.Overview{constructor(e,i,s){super(e,i,s);var a=[t.ColorUtils.getPound(t.ColorUtils.getBrighter("#aadd77",.35)),"#aadd77",t.ColorUtils.getPound(t.ColorUtils.getDarker("#aadd77",.5))];r.OverviewUtils.supportsTouch()&&(a=["#aadd77"]),null!=s&&(this._durationColors=s.getOptions().styleDefaults.series.colors),this._defColors=a,this._markerBorderFill=t.SolidFill.invisibleFill(),this._markerSize=12,this.ENABLED_STATE="_",this.HOVER_STATE="_h",this.SELECTED_STATE="_s",this.ACTIVE_SELECTED_STATE="_as",this.BORDER_STYLE="bs",this.BORDER_COLOR="bc",this.BORDER_WIDTH="bw",this.DURATION_BORDER_COLOR="dbc",this.DURATION_BORDER_WIDTH="dbw",this.BORDER_OFFSET="bof",this.BORDER_OPACITY="bo",this.GLOW_COLOR="gc",this.GLOW_OPACITY="go"}initDefaults(){this.Defaults=new v}getParser(){return new y(this)}_applyParsedProperties(e){super._applyParsedProperties(e),this._selectionMode=e.selectionMode,this._markers=e.markers,this._seriesIds=e.seriesIds,this._defaultMarkerStyles=e.defaultMarkerStyles,this._borderStyles=E(this.Options),e.labelStyle&&(this._labelStyle=new t.CSSStyle(e.labelStyle));if("solid"===this.getStyle(this.ENABLED_STATE,this.BORDER_STYLE))var i=parseInt(this.getStyle(this.ENABLED_STATE,this.BORDER_OFFSET),10);else i=1;if("solid"===this.getStyle(this.ACTIVE_SELECTED_STATE,this.BORDER_STYLE))var s=parseInt(this.getStyle(this.ACTIVE_SELECTED_STATE,this.BORDER_OFFSET),10);else s=1;if("solid"===this.getStyle(this.SELECTED_STATE,this.BORDER_STYLE))var a=parseInt(this.getStyle(this.SELECTED_STATE,this.BORDER_OFFSET),10);else a=1;this.isItemSelectionEnabled()?this._markerSpacingOffset=Math.max(s,a,i,1)/2+1:this._markerSpacingOffset=1,this._defOpacity=this.isVertical()?0:.75,this._defAlphas=[this._defOpacity,this._defOpacity,this._defOpacity],this._radialFill=new t.LinearGradientFill(250,this._defColors,this._defAlphas),this._linearFill=new t.LinearGradientFill(180,this._defColors,this._defAlphas);var r=this.isVertical()?0:1;this._border=new t.Stroke("#aadd77",r)}getSeriesIds(){return null==this._seriesIds?null:this._seriesIds.split(" ")}isItemSelectionEnabled(){return"none"!==this._selectionMode}getDrawableById(e){for(var i=this.getNumChildren(),s=0;s<i;s++){var a=this.getChildAt(s);if(a&&a._node&&t.Obj.compareValues(this.getCtx(),e,a._node.getId()))return a}return null}getItemId(e){return e._node?e._node.getId():e.getId().substr(5)}getStyle(e,t){return this._borderStyles[e+t]}getX(e){return null!=e._node?e._node.getX():e.getMatrix().getTx()}getY(e){return null!=e._node?e._node.getY():e.getMatrix().getTy()}getScaleX(e){var t=e.getScaleX();return null==t&&(t=this.isVertical()?(this.Width-this.getTimeAxisWidth()-4)/2:1),t}getScaleY(e){var t=e.getScaleY();return null==t&&(t=1),t}renderData(e,t){if(super.renderData(e,t),null!=this._markers){if(this.isVertical())var i=this._yMin,s=this._yMax;else i=this._xMin,s=this._xMax;for(var a=this.calculateOptimalSize(i,s,e,t,this._markerSize),r=[],n=0;n<this._markers.length;n++){var o=this._markers[n];null==o._endTime?this.addMarker(o,a):r[r.length]=o}this.prepareDurations(r),this.addDurations(r,i,s),this._markerSize=a}}prepareDurations(e){this._maxDurationY=0;var t=null;null==this._durationColorMap&&(this._durationColorMap=new Object);for(var i=0;i<e.length;i++){var s=e[i],a=s.getId(),r=s.getSeriesId();r!==t&&(this._colorCount=0,t=r),s._durationLevel=this.calculateDurationY(s,e),null==s._durationFillColor&&(null==this._durationColorMap[a]?(this._durationColorMap[a]=this._colorCount,s._durationFillColor=this._durationColors[this._colorCount],this._colorCount++,this._colorCount===this._durationColors.length&&(this._colorCount=0)):s._durationFillColor=this._durationColors[this._durationColorMap[a]])}}getDurationColorMap(){return this._durationColorMap?this._durationColorMap:null}calculateOptimalSize(e,t,i,s,a){var n=new Object;n.max=1,n.arr=[];for(var o=this.isVertical()?s:i,l=0;l<this._markers.length;l++){var h=this._markers[l];if(null!=h._endTime){var _=r.OverviewUtils.getDatePosition(e,t,h.getTime(),o);this.isHorizontalRTL()&&(_=o-_),h.setX(_)}else if(this.calculateSize(h,e,t,o,a/2,n,s),n.max>s)break}return n.max>s&&a>1?this.calculateOptimalSize(e,t,i,s,a-1):a}addMarker(e,i){var s,a,n="_mrk_"+e.getId(),o=e.getColor(),l=e.isGradient(),h=e.getOpacity();null==h&&0===(h=this._defOpacity)&&null!=o&&(h=1);var _=this.getScaleX(e),d=this.getScaleY(e),g=e.getShape();if(this.isVertical()){g=t.SimpleMarker.RECTANGLE;var c=2*_,m=2*d,u=e.getY()+c/2,v=e.getX()+m/2}else c=i*_,m=i*d,u=e.getX()+c/2,v=e.getY()+m/2;var p=new t.SimpleMarker(this.getCtx(),g,u,v,c,m,null,null,null,n);if(p._node=e,null==o&&h===this._defOpacity&&null==l)s=g===t.SimpleMarker.CIRCLE?this._radialFill:this._linearFill,a=this._border;else{var S=this._defColors;if(null!=o)if(r.OverviewUtils.supportsTouch())S=[o];else S=[t.ColorUtils.getBrighter(o,.5),o,t.ColorUtils.getDarker(o,.5)];var b=[h,h,h];s=null==l?g===t.SimpleMarker.CIRCLE?new t.LinearGradientFill(250,S,b):new t.LinearGradientFill(180,S,b):new t.SolidFill(o,b[0]),a=new t.Stroke(o,h)}p.setFill(s),p.setStroke(a),this.isItemSelectionEnabled()&&p.setSelectable(!0);var D=this.getNumChildren(),T=this.getChildAt(D-1);return D>this._lastChildIndex&&("tb"===T.getId()||"arr"===T.getId())?this.addChildAt(p,D-this._lastChildIndex):this.addChild(p),e.setDisplayable(p),this.applyState(p,this.ENABLED_STATE),!this.isVertical()&&g!==t.SimpleMarker.RECTANGLE&&g!==t.SimpleMarker.DIAMOND&&g!==t.SimpleMarker.TRIANGLE_UP&&g!==t.SimpleMarker.TRIANGLE_DOWN&&g!==t.SimpleMarker.PLUS||"false"===this._defaultMarkerStyles.pixelHinting||p.setPixelHinting(!0),p}addDurations(e,i,s){for(var a=this.getCtx(),n=this._maxDurationY;n>0;n--)for(var o=0;o<e.length;o++){var l=e[o];if(n===l._durationLevel){var h=r.OverviewUtils.getDatePosition(i,s,l.getTime(),this.isVertical()?this.Height:this.Width),_="_drn_"+l.getId(),d=9+5*l._durationLevel,g=r.OverviewUtils.getDatePosition(i,s,l.getEndTime(),this.isVertical()?this.Height:this.Width);if(this.isVertical())if(this.isRTL())var c=new t.Rect(a,0,h,d,g-h,_);else c=new t.Rect(a,this.Width-d,h,d,g-h,_);else c=this.isRTL()?new t.Rect(a,this.Width-g,this.Height-d-20,g-h,d,_):new t.Rect(a,h,this.Height-d-20,g-h,d,_);c.setFill(new t.SolidFill(l._durationFillColor));var m=new t.Stroke(this.getStyle(this.ENABLED_STATE,this.DURATION_BORDER_COLOR),1,1);c.setStroke(m),c.setPixelHinting(!0),c._node=l,this.addChild(c),l._durationBar=c,l._durationY=d-2}}this.removeChild(this._timeAxisTopBar),this.addChild(this._timeAxisTopBar)}calculateSize(e,t,i,s,a,n,o){var l=a*this.getScaleX(e)+this._markerSpacingOffset,h=a*this.getScaleY(e)+this._markerSpacingOffset,_=e.getTime(),d=r.OverviewUtils.getDatePosition(t,i,_,s);if(this.isHorizontalRTL()&&(d=s-d-2*l),this.isVertical()){var g=0;"solid"===this.getStyle(this.ENABLED_STATE,this.BORDER_STYLE)&&(g=parseInt(this.getStyle(this.ENABLED_STATE,this.BORDER_WIDTH),10)),c=this.isRTL()?g+4:this.Width-2*this.getScaleX(e)-g-4}else{var c=3;this.isOverviewAbove()&&(c+=this.getTimeAxisHeight());for(var m=0,u=[],v=0;v<n.arr.length;v++){var p=n.arr[v],S=p.getX(),b=this.getScaleX(p);Math.abs(d-S)<a*b+this._markerSpacingOffset+l&&u.push(p)}for(v=0;v<u.length;v++){var D=this.calculateY(u,e.getShape(),d,c,l,h,m,a,o);if(m=D.maxy,D.cy===c){c=D.cy;break}c=D.cy}}e.setX(d),e.setY(c),n.arr.push(e),null!=m&&m>n.max&&(n.max=m)}calculateY(e,i,s,a,r,n,o,l,h){for(var _=0;_<e.length;_++){var d=e[_],g=d.getX(),c=d.getY(),m=d.getShape(),u=this.getScaleX(d),v=this.getScaleY(d);if(i===t.SimpleMarker.CIRCLE&&m===t.SimpleMarker.CIRCLE&&r===n&&u===v)var p=Math.abs(s-g),S=l*u+this._markerSpacingOffset+r,b=Math.sqrt(S*S-p*p);else b=l*v+this._markerSpacingOffset+n;if(b>Math.abs(a-c)&&(a=c+b,o=Math.max(o,a+b),l>=1&&void 0!==h&&o>h))break}return{cy:a,maxy:o}}calculateDurationY(e,t){var i=t.length,s=e.getTime(),a=e._durationLevel;null==a&&(a=1);for(var r=0;r<i;r++){var n=t[r];if(n!==e){var o=n.getEndTime();if(null!=o){var l=n.getTime(),h=n._durationLevel;null==h&&(h=1),s>=l&&s<=o&&a===h&&(a=h+1,e._durationLevel=a,a=this.calculateDurationY(e,t))}}}return a>this._maxDurationY&&(this._maxDurationY=a),a}HandleShapeMouseOver(e){var i=super.HandleShapeMouseOver(e);if(null!=i){if(null!=i._node){var s=i._node.getDescription();null!=s&&this.getCtx().getTooltipManager().showDatatip(e.pageX,e.pageY,s,"#000000")}if(this.isItemSelectionEnabled()){var a=!1;if(null!=this._selectedMarkers)for(var r=0;r<this._selectedMarkers.length;r++)if(i===this._selectedMarkers[r]){a=!0;break}if(!a){var n=this.getItemId(i),o=t.EventFactory.newTimelineOverviewEvent("highlight",n);this.dispatchEvent(o),this.highlightMarker(i)}}}}HandleShapeMouseOut(e){var i=super.HandleShapeMouseOut(e);if(null!=i&&!this.isMovable(i)){this.getCtx().getTooltipManager().hideTooltip();var s=!1;if(null!=this._selectedMarkers)for(var a=0;a<this._selectedMarkers.length;a++)if(i===this._selectedMarkers[a]){s=!0;break}if(!s){var r=this.getItemId(i),n=t.EventFactory.newTimelineOverviewEvent("unhighlight",r);this.dispatchEvent(n),this.unhighlightMarker(i)}}}HandleShapeClick(e,i,s){var a=super.HandleShapeClick(e,i,s);null!=a&&this.HandleMarkerClick(a,e.ctrlKey||e.shiftKey||t.Agent.isTouchDevice())}HandleMarkerClick(e,t){if(this.isItemSelectionEnabled()&&(this.selectItem(e,t),null!=e._node.getTime())){var i,s=this.getSlidingWindow();this.isVertical()?(i=this.getX(e)-s.getHeight()/2,this.animateSlidingWindow(null,i)):(i=this.getX(e)-s.getWidth()/2,this.animateSlidingWindow(i))}}highlightItem(e){var t=this.getDrawableById(e);null!=t&&this.highlightMarker(t)}unhighlightItem(e){var t=this.getDrawableById(e);null!=t&&this.unhighlightMarker(t)}highlightMarker(e){if(null!=this._selectedMarkers)for(var t=0;t<this._selectedMarkers.length;t++){if(e===this._selectedMarkers[t])return}this.applyState(e,this.HOVER_STATE)}unhighlightMarker(e){if(null!=this._selectedMarkers)for(var t=0;t<this._selectedMarkers.length;t++){if(e===this._selectedMarkers[t])return}this.applyState(e,this.ENABLED_STATE)}selSelectItem(e){var t=this.getDrawableById(e);null!=t&&this.addSelectedMarker(t)}selUnselectItem(e){var t=this.getDrawableById(e);null!=t&&this.removeSelectedMarker(t)}selectItem(e,i){var s=this.getItemId(e),a=t.EventFactory.newTimelineOverviewEvent("selection",s,i);this.dispatchEvent(a)}addSelectedMarker(e){null==this._selectedMarkers&&(this._selectedMarkers=[]);var t=null;this._selectedMarkers.length>0&&(t=this._selectedMarkers[this._selectedMarkers.length-1]),this._selectedMarkers.push(e),null!=t&&this.applyState(t,this.SELECTED_STATE),this.applyState(e,this.ACTIVE_SELECTED_STATE)}removeSelectedMarker(e){if(null!=this._selectedMarkers){for(var t=-1,i=0;i<this._selectedMarkers.length;i++){if(e===this._selectedMarkers[i]){t=i;break}}-1!=t&&(this.applyState(e,this.ENABLED_STATE),this._selectedMarkers.splice(t,1))}}removeAllSelectedMarkers(){if(null!=this._selectedMarkers){for(var e=0;e<this._selectedMarkers.length;e++){var t=this._selectedMarkers[e];this.applyState(t,this.ENABLED_STATE)}delete this._selectedMarkers,this._selectedMarkers=null}}applyState(e,i){if(e instanceof t.SimpleMarker){var s=!1,a=!1;if("solid"===this.getStyle(i,this.BORDER_STYLE)){s=!0;var r=this.getStyle(i,this.BORDER_COLOR);null==r&&(r="#000000");var n=this.getStyle(i,this.GLOW_COLOR);null!=n&&"none"!==n&&(a=!0)}var o=e._borderMarker,l=e._glowMarker;s||null==o?a||null==l||(this.removeChild(l),e._glowMarker=null):(this.removeChild(o),e._borderMarker=null,null!=l&&(this.removeChild(l),e._glowMarker=null));var h=e.getType();if(s){var _=parseInt(this.getStyle(i,this.BORDER_WIDTH),10),d=parseInt(this.getStyle(i,this.BORDER_OFFSET),10);if(null==o){if(h===t.SimpleMarker.CIRCLE)var g=(e.getDimensions().w+2*d)*e.getScaleX(),c=(e.getDimensions().h+2*d)*e.getScaleY(),m=this.getX(e)-d+g/2,u=this.getY(e)-d+c/2;else this.isVertical()?(g=(e.getDimensions().w+(_+1))*e.getScaleX(),c=(e.getDimensions().h+(_+1))*e.getScaleY(),m=this.getY(e)-(_+1)/2+g/2,u=this.getX(e)-(_+1)/2+c/2):(g=(e.getDimensions().w+2*d)*e.getScaleX(),c=(e.getDimensions().h+2*d)*e.getScaleY(),m=this.getX(e)-d+g/2,u=this.getY(e)-d+c/2);o=new t.SimpleMarker(this.getCtx(),h,m,u,g,c,null,null,null,e.getId()+"_border"),this.addChildAt(o,this.getChildIndex(e)),e._borderMarker=o,o.setFill(this._markerBorderFill)}var v=new t.Stroke(r,this.getStyle(i,this.BORDER_OPACITY),_);if(o.setStroke(v),!this.isVertical()&&h!==t.SimpleMarker.RECTANGLE&&h!==t.SimpleMarker.DIAMOND&&h!==t.SimpleMarker.TRIANGLE_UP&&h!==t.SimpleMarker.TRIANGLE_DOWN&&h!==t.SimpleMarker.PLUS||"false"===this._defaultMarkerStyles.pixelHinting||o.setPixelHinting(!0),a){if(null==l){var p=d-_;h===t.SimpleMarker.CIRCLE?(g=(e.getDimensions().w+2*p)*e.getScaleX(),c=(e.getDimensions().h+2*p)*e.getScaleY(),m=this.getX(e)-p+g/2,u=this.getY(e)-p+c/2):this.isVertical()?(g=(e.getDimensions().w+3)*e.getScaleX(),c=(e.getDimensions().h+3)*e.getScaleY(),m=this.getY(e)+g/2,u=this.getX(e)-1+c/2):(g=(e.getDimensions().w+2*p)*e.getScaleX(),c=(e.getDimensions().h+2*p)*e.getScaleY(),m=this.getX(e)-p+g/2,u=this.getY(e)-p+c/2),l=new t.SimpleMarker(this.getCtx(),h,m,u,g,c,null,null,null,e.getId()+"_glow"),this.addChildAt(l,this.getChildIndex(o)),e._glowMarker=l,l.setFill(this._markerBorderFill)}var S=new t.Stroke(n,this.getStyle(i,this.GLOW_OPACITY),4);l.setStroke(S),!this.isVertical()&&h!==t.SimpleMarker.RECTANGLE&&h!==t.SimpleMarker.DIAMOND&&h!==t.SimpleMarker.TRIANGLE_UP&&h!==t.SimpleMarker.TRIANGLE_DOWN&&h!==t.SimpleMarker.PLUS||"false"===this._defaultMarkerStyles.pixelHinting||l.setPixelHinting(!0)}}}else{var b=e.getId();b&&"_drn_"===b.substring(0,5)&&this.applyDurationState(e,i)}}applyDurationState(e,i){var s=this.getStyle(i,this.DURATION_BORDER_COLOR);null==s&&(s="#000000");var a=parseInt(this.getStyle(i,this.DURATION_BORDER_WIDTH),10);e.setStroke(new t.Stroke(s,1,a))}getMarkers(){return this._markers}}class w extends t.IconButton{constructor(e,t,i,s,a,r,n,o){super(t,i,s,a,r,n,o),this._id=r,this._timeline=e,this._enabledState=!0,this.setAriaRole("button")}getNextNavigable(e){var i=this._timeline.EventManager.getKeyboardHandler(),s=t.Agent.isRightToLeft(this._timeline.getCtx());if(e.type===t.MouseEvent.CLICK||i.isMultiSelectEvent(e))return this;if(!i.isNavigationEvent(e))return null;if(!s&&t.KeyboardEvent.RIGHT_ARROW===e.keyCode||s&&t.KeyboardEvent.LEFT_ARROW===e.keyCode){if("prevNavArrow"===this._id)return this._timeline._nextArrow;for(var a=0;a<this._timeline._series.length;a++){var r=this._timeline._series[a];if(r._items&&r._items.length>0)return r._items[0]}}else if(!s&&t.KeyboardEvent.LEFT_ARROW===e.keyCode||s&&t.KeyboardEvent.RIGHT_ARROW===e.keyCode)return"nextNavArrow"===this._id?this._timeline._prevArrow:this}getAriaLabel(){var e=this._callbackObj.getComponent().getOptions().translations,i=this._enabledState?[]:[e.navArrowDisabledState];return t.Displayable.generateAriaLabel(this.getAriaString(),i)}getAriaString(){var e=this._callbackObj.getComponent().getOptions().translations;return"prevNavArrow"===this._id?e.labelAccNavPreviousPage:"nextNavArrow"===this._id?e.labelAccNavNextPage:void 0}getKeyboardBoundingBox(e){return this.getDimensions(e)}setEnabled(e){this._enabledState=e,this.setAriaProperty("label",this.getAriaLabel()),super.setEnabled(e)}getTargetElem(){return this.getElem()}}const A={renderTimeline:e=>{var t;if(A._removeEmptyText(e),A._renderBackground(e),A._renderScrollableCanvas(e),e.hasValidOptions()){e.renderTimeZoomCanvas(e._canvas);var i=e.getTimeZoomCanvas();if(A._renderSeries(e,i),A._renderSeriesLabels(e),A._renderAxis(e,i),e.isDiscreteNavigationMode()?A._renderNavigationArrows(e,i):A._hideNavigationArrows(e,i),e._hasOverview?A._renderOverview(e):e.clearOverview(),e._keyboardHandler)for(var a=0;a<e._series.length;a++)if((t=e._series[a])._items&&t._items.length>0&&null==e.EventManager.getFocus()){e.EventManager.setFocusObj(t._items[0]);break}(e.isTimeDirScrollbarOn()||e.isContentDirScrollbarOn())&&A._renderScrollbars(e),A._renderZoomControls(e),e.SelectionHandler&&e.applyInitialSelections(),s.TimeAxisUtils.supportsTouch()&&e._setAriaProperty("flowto",e._series[0].getId());for(var r=0;r<e._series.length;r++)(t=e._series[r]).triggerAnimations();e.isDiscreteNavigationMode()&&e.doInitialPan()}else A._renderEmptyText(e)},_renderBackground:e=>{e._background?(e._background.setClipPath(null),e._background.setWidth(e._backgroundWidth),e._background.setHeight(e._backgroundHeight)):e._background=new t.Rect(e.getCtx(),0,0,e._backgroundWidth,e._backgroundHeight,"bg");var i=e.getBackgroundXOffset();e._background.setTranslateX(i),e._background.setCSSStyle(e._style),e._background.setPixelHinting(!0);var s=new t.ClipPath;s.addRect(i,0,e._backgroundWidth,e._backgroundHeight),e._background.setClipPath(s),e._background.getParent()!==e&&e.addChild(e._background)},_renderScrollableCanvas:e=>{e._canvas||(e._canvas=new t.Container(e.getCtx(),"g","canvas"),e.addChild(e._canvas))},_renderSeries:(e,i)=>{var s=e.getTimeAxis();if(e._series){var a=e.getCtx(),r=t.Agent.isRightToLeft(a),n=e._series.length,o=e.getTimeAxisVisibleSize(n);e.isVertical()||n>1&&e._canvasSize%2!=o%2&&(s.setContentSize(s.getContentSize()+1),o=e.getTimeAxisVisibleSize(n)),e._seriesSize=(e._canvasSize-o)/n;for(var l=0;l<n;l++){var h=e._series[l];h.setClipPath(null);var _=new t.ClipPath;if(e.isVertical()){if(r)var d=Math.abs(l-1);else d=l;if(r&&1===e._series.length){_.addRect(o,0,e._seriesSize,e.getContentLength());var g=new t.Matrix(1,0,0,1,o,0)}else _.addRect(d*(e._seriesSize+o),0,e._seriesSize,e.getContentLength()),g=new t.Matrix(1,0,0,1,d*(e._seriesSize+o),0);var c=e._seriesSize,m=e.getContentLength()}else _.addRect(0,l*(e._seriesSize+o),e.getContentLength(),e._seriesSize),g=new t.Matrix(1,0,0,1,0,l*(e._seriesSize+o)),c=e.getContentLength(),m=e._seriesSize;h.setClipPath(_),h.setMatrix(g),h.getParent()!==i&&i.addChild(h),h.render(e._seriesOptions[l],c,m)}}},_renderSeriesLabels:e=>{var i,s;if(e._series){var a=e.getCtx(),r=t.Agent.isRightToLeft(a);if(e._seriesLabels)for(var n=0;n<e._seriesLabels.length;n++)e.removeChild(e._seriesLabels[n]);e._seriesLabels=[];for(var o=e._series.length,h=l.getSeriesLabelSpacing(),_=2*t.TransientButton._DEFAULT_RADIUS+6,d=2*h,g=0;g<o;g++){var c=e._series[g],m=c.getLabel();if(null!=m){var u=l.getSeriesLabelStyle(e.Options),v=new t.CSSStyle(l.getSeriesLabelBackgroundStyle());if(c._style){var p=c._style.getStyle(t.CSSStyle.BACKGROUND_COLOR);p&&v.setStyle(t.CSSStyle.BACKGROUND_COLOR,p)}var S=new t.OutputText(a,m,0,0,"sl_s"+g);if(S.setCSSStyle(u),i=S.getDimensions(),e.isVertical())var b=e._seriesSize;else b=e._canvasLength;var D=Math.min(i.w,b-(g-1)*-_-d),T=l.getSeriesLabelPadding(),f=new t.Rect(a,0,0,D+2*T,i.h+2*T,"slb_s"+g);if(f.setCSSStyle(v),f.setAlpha(l.getSeriesLabelBackgroundOpacity()),f.setCornerRadius(3),e.isVertical())C=r?Math.abs(g-1)*(e._canvasSize-D-d)+h+e._startX+(g-1)*_:g*(e._canvasSize-D-d)+h+e._startX+(g-1)*-_,E=e._startY+h;else{if(r)var C=e._canvasLength-D-h-(g-1)*-_;else C=e._startX+h+(g-1)*-_;var E=g*(e._canvasSize-i.h-d)+h+e._startY}s=new t.Matrix(1,0,0,1,C,E),S.setMatrix(s),s=new t.Matrix(1,0,0,1,C-T,E-T),f.setMatrix(s),e.addChild(f),t.TextUtils.fitText(S,D,1/0,e),e._seriesLabels.push(f),e._seriesLabels.push(S)}if(c._isEmpty){var y=c.getEmptyText();if(null!=y){var O=new t.OutputText(a,y,0,0,"et_s"+g);if(O.setCSSStyle(l.getEmptyTextStyle(e.Options)),i=O.getDimensions(),e.isVertical())A=(e._canvasLength-i.h)/2+e._startY,w=r?Math.abs(g-1)*((o-1)*e._seriesSize+e.getTimeAxisVisibleSize(o))+(e._seriesSize-i.w)/2+e._startX:g*(e._seriesSize+e.getTimeAxisVisibleSize(o))+(e._seriesSize-i.w)/2+e._startX;else var w=(e._canvasLength-i.w)/2+e._startX,A=g*(e._seriesSize+e.getTimeAxisVisibleSize(o))+(e._seriesSize-i.h)/2+e._startY;s=new t.Matrix(1,0,0,1,w,A),O.setMatrix(s),e.addChild(O),e._seriesLabels.push(O)}}}}},_renderNavigationArrows:(e,i)=>{var s=e.getCtx(),a=t.Agent.isRightToLeft(s),r=e._discreteContentLength,n=e._series.length,o=e.getTimeAxisVisibleSize(n),h=l.getNavButtonBackgroundWidth(),_=l.getNavButtonWidth(),d=l.getNavButtonPadding(),g=1===n?e._canvasSize-o:e._canvasSize/n-o/2,c=e.getDatePos(e._viewStartTime)+e._discreteOffset-h,m=e._backgroundWidth+c-h;a&&(m=r-m-h-e.getScrollbarPadding()+2*e._discreteOffset,c=r-c-h+2*e._discreteOffset);var u=e.Options.styleDefaults.item.borderColor,v=new t.Stroke(u,1,1),p=e.Options.styleDefaults.series.backgroundColor;if(null==e._prevArrowContainer){var S=new t.Container(s),b=new t.Rect(s,0,0,h,h,"prevNavContainer"),D=new t.Rect(s,0,0,_,_,"prevNavContainer_i");D.setCornerRadius(4),D.setTranslate(d,d),b.addChild(D),S.addChild(b),S.setTranslate(c,g-_),S.setClassName("oj-timeline-nav-arrow oj-timeline-nav-arrow-previous"),D.setStroke(v),S.setSolidFill(p);var T=t.ToolkitUtils.getIconStyle(s,e._resources.prev),f=new w(e,s,"outlined",{style:T,size:28},null,"prevNavArrow",e.EventManager.prevPage,e.EventManager);f.setTranslate(4,4),D.addChild(f),i.addChild(S),e._prevArrowContainer=S,e._prevArrow=f}else e._prevArrowContainer.setVisible("visible"),e._prevArrowContainer.setTranslate(c,g-_),i.removeChild(e._prevArrowContainer),i.addChild(e._prevArrowContainer);if(null==e._nextArrowContainer){var C=new t.Container(s),E=new t.Rect(s,0,0,h,h,"nextNavContainer"),y=new t.Rect(s,0,0,_,_,"nextNavContainer_i");y.setCornerRadius(4),y.setTranslate(16,d),E.addChild(y),C.addChild(E),C.setTranslate(m,g-_),C.setClassName("oj-timeline-nav-arrow oj-timeline-nav-arrow-next"),y.setStroke(v),C.setSolidFill(p);T=t.ToolkitUtils.getIconStyle(s,e._resources.next);var O=new w(e,s,"outlined",{style:T,size:28},null,"nextNavArrow",e.EventManager.nextPage,e.EventManager);O.setTranslate(4,4),y.addChild(O),i.addChild(C),e._nextArrowContainer=C,e._nextArrow=O}else e._nextArrowContainer.setVisible("visible"),e._nextArrowContainer.setTranslate(m,g-_),i.removeChild(e._nextArrowContainer),i.addChild(e._nextArrowContainer);A._checkDisabledArrows(e)},_hideNavigationArrows:e=>{null!=e._prevArrowContainer&&e._prevArrowContainer.setVisible(),null!=e._nextArrowContainer&&e._nextArrowContainer.setVisible()},_checkDisabledArrows:e=>{e.startPanAllowed()?(e._prevArrowContainer.removeClassName("oj-timeline-nav-arrow-disabled"),e._prevArrow.setEnabled(!0)):(e._prevArrowContainer.addClassName("oj-timeline-nav-arrow-disabled"),e._prevArrow.setEnabled(!1)),e.endPanAllowed()?(e._nextArrowContainer.removeClassName("oj-timeline-nav-arrow-disabled"),e._nextArrow.setEnabled(!0)):(e._nextArrowContainer.addClassName("oj-timeline-nav-arrow-disabled"),e._nextArrow.setEnabled(!1))},_renderAxis:(e,i,s)=>{var a=e.getCtx(),r=t.Agent.isRightToLeft(a),n=e.getTimeAxis(),o=e._series.length,h=e.getTimeAxisSize(),_=e.getTimeAxisVisibleSize(o),d=1===o?e._canvasSize-_:e._canvasSize/o-_/2,g=e.getContentLength();if(r&&e.isVertical()&&1===e._series.length&&(d=0),n.getParent()!==i&&i.addChild(n),e.isVertical()){var c=new t.Matrix(1,0,0,1,d,0);n.render({_viewStartTime:e._viewStartTime,_viewEndTime:e._viewEndTime,_referenceObjects:{referenceObjects:[]},_throttle:s,_eventManager:e.getEventManager()},h,g)}else{var m=e.isDiscreteNavigationMode();l.getNavButtonBackgroundWidth();g=m?e._discreteContentLength:g;var u=e.getDiscreteViewportStartDate(),v=e.getDiscreteViewportEndDate(),p=e.getOptions(),S=m?u:e._viewStartTime,b=m?v:e._viewEndTime,D=e._seriesScale?h:0;c=new t.Matrix(1,0,0,1,e.getDiscreteOffset(),d-D),n.render({_viewStartTime:S,_viewEndTime:b,_referenceObjects:{referenceObjects:p.referenceObjects,defaultStyleClass:null,defaultStroke:new t.Stroke(l.getReferenceObjectColor(p))},_throttle:s,_eventManager:e.getEventManager()},g,h)}n.setMatrix(c),e._majorAxis&&e._majorAxis.setContentLength(n._contentLength,n._contentLength),e._fetchEndPos=n._contentLength,A._renderSeriesTimeAxis(e,e._fetchStartPos,e._fetchEndPos,e.getTimeZoomCanvas(),g)},_renderSeriesTimeAxis:(e,i,s,a,r)=>{var n=e.getCtx(),o=e.getTimeAxisSize(),h=t.Agent.isRightToLeft(n),_=(e.isDiscreteNavigationMode()?e._discreteOffset:0)*(h?-1:1);if(e._majorAxisLabels)for(var d=0;d<e._majorAxisLabels.length;d++)a.removeChild(e._majorAxisLabels[d]);if(e._majorAxisLabels=[],e._seriesScale){var g,c;e._start,e._end;if(e._customTimeScales&&e._customTimeScales[e._seriesScale]){var m=e._customTimeScales[e._seriesScale];g=m.times,c=m.labels}else if(e._seriesCustomFormatScales&&e._seriesCustomFormatScales[e._seriesScale]){var u=e._seriesCustomFormatScales[e._seriesScale];g=u.times,c=u.labels}else{g=[],c=[];var v=e.getPosDate(i),p=e._seriesTimeAxis.adjustDate(v),S=e.getDatePos(p);for(g.push(p.getTime());S<s;)c.push(e._seriesTimeAxis.formatDate(p)),p=e._seriesTimeAxis.getNextDate(p.getTime()),S=e.getDatePos(p),g.push(p.getTime())}var b=l.getSeriesAxisLabelStyle(e.Options),D=l.getSeriesAxisLabelPadding(),T=new t.CSSStyle(l.getSeriesAxisLabelBackgroundStyle());if(e._series[0]&&e._series[0]._style){var f=e._series[0]._style.getStyle(t.CSSStyle.BACKGROUND_COLOR);f&&T.setStyle(t.CSSStyle.BACKGROUND_COLOR,f)}for(var C=l.getSeriesAxisLabelBackgroundOpacity(),E=0;E<c.length;E++){var y=c[E],O=g[E];S=e.getDatePos(O)+_;var w=e.getDatePos(g[E+1])+_-S;if(h)k=e.isVertical()?A._addLabel(n,a,e._canvasSize-5,y,w,S+18,b,"o_label"+S+"_s0",!0,T,C,D,e._majorAxisLabels,h):A._addLabel(n,a,r-(S+5),y,w,e._seriesSize-2+o,b,"o_label"+S+"_s0",!0,T,C,D,e._majorAxisLabels,h);else if(e.isVertical())var k=A._addLabel(n,a,5,y,w,S+18,b,"o_label"+S+"_s0",!0,T,C,D,e._majorAxisLabels,h);else k=A._addLabel(n,a,S+5,y,w,e._seriesSize-2+o,b,"o_label"+S+"_s0",!0,T,C,D,e._majorAxisLabels,h);k.time=g[E]}}},_renderOverview:e=>{var i=e.getCtx(),s=t.Agent.isRightToLeft(i);if(null==e._overviewCanvas){var a=!0;e._overviewCanvas=new t.Container(i,"g","oCanvas")}else e._overviewCanvas.removeChildren(),e._overviewCanvas.setClipPath(null);var r,n,o,l,h=e._style.getBorderWidth(),_=h/2;e.isVertical()?(r=e._overviewSize,n=e._backgroundHeight-h,l=_,o=s?_:e._backgroundWidth-e._overviewSize-_):(r=e._backgroundWidth-h,n=e._overviewSize,l=e._backgroundHeight-e._overviewSize-_,o=_+e.getBackgroundXOffset()),e._overviewCanvas.setTranslateX(o),e._overviewCanvas.setTranslateY(l);var d=new t.ClipPath;d.addRect(o,l,r,n),e._overviewCanvas.setClipPath(d),a&&e.addChild(e._overviewCanvas),e._overview=new O(i,e.HandleEvent,e),e._overviewCanvas.addChild(e._overview);var g=e._getOverviewObject();e._overview.render(g,r,n),e.isDiscreteNavigationMode()&&(e._overview.setMouseEnabled(!1),e._overview._windowLeftGrippy.setVisible(),e._overview._windowRightGrippy.setVisible())},_renderScrollbars:e=>{var i=e.getCtx(),s=e.getScrollbarPadding(),a=e._series.length;if(null==e._scrollbarsCanvas?(e._scrollbarsCanvas=new t.Container(i,"g","sbCanvas"),e.addChild(e._scrollbarsCanvas)):(e._scrollbarsCanvas.removeChildren(),e.setTimeDirScrollbar(null),e.setContentDirScrollbar(null)),e.isTimeDirScrollbarOn()){if(e.isVertical()){if(t.Agent.isRightToLeft(e.getCtx()))var r=2*s+1;else r=e.Width-1.5*s;var n=e.getCanvasLength()}else r=e.getCanvasLength(),n=e.Height-1.5*s;var o=A._prerenderTimeDirScrollbar(e,e._scrollbarsCanvas,new t.Rectangle(0,0,r,n))}if(e.isContentDirScrollbarOn()){e.isVertical()?(r=e._seriesSize,n=e.Height-1.5*s):(r=t.Agent.isRightToLeft(e.getCtx())?2*s+1:e.Width-1.5*s,n=e._seriesSize);for(var l=[],h=0;h<a;h++)l[h]=A._prerenderContentDirScrollbar(e,e._scrollbarsCanvas,new t.Rectangle(0,0,r,n),h)}if(e.timeDirScrollbar){var _={};_.color=e.timeDirScrollbarStyles.getStyle(t.CSSStyle.COLOR),_.backgroundColor=e.timeDirScrollbarStyles.getStyle(t.CSSStyle.BACKGROUND_COLOR),_.min=e._start,_.max=e._end,e.isVertical()?(_.isReversed=!1,_.isHorizontal=!1,e.timeDirScrollbar.setTranslateY(e.getStartYOffset())):(_.isReversed=t.Agent.isRightToLeft(i),_.isHorizontal=!0,e.timeDirScrollbar.setTranslateX(e.getStartXOffset())),null!=o&&(e.timeDirScrollbar.render(_,o.w,o.h),e.timeDirScrollbar.setViewportRange(e._viewStartTime,e._viewEndTime))}if(e.contentDirScrollbar)for(h=0;h<a;h++){if((_={}).color=e.contentDirScrollbarStyles.getStyle(t.CSSStyle.COLOR),_.backgroundColor=e.contentDirScrollbarStyles.getStyle(t.CSSStyle.BACKGROUND_COLOR),_.isHorizontal=e.isVertical(),0==h){_.min=0;var d=null!=l&&null!=l[h]&&null!=l[h].h?l[h].h:0;_.max=Math.max(e._series[h]._maxOverflowValue,d),e.isVertical()?t.Agent.isRightToLeft(i)?(_.isReversed=!1,2===a?e.contentDirScrollbar[h].setTranslateX(e.getStartXOffset()+e._seriesSize+e.getTimeAxisVisibleSize(a)):e.contentDirScrollbar[h].setTranslateX(e.getStartXOffset()+e.getTimeAxisVisibleSize(a))):(_.isReversed=!0,e.contentDirScrollbar[h].setTranslateX(e.getStartXOffset())):(_.isReversed=!0,e.contentDirScrollbar[h].setTranslateY(e.getStartYOffset()))}else _.min=0,_.max=Math.max(e._series[h]._maxOverflowValue,l[h].h),e.isVertical()?t.Agent.isRightToLeft(i)?(_.isReversed=!0,e.contentDirScrollbar[h].setTranslateX(e.getStartXOffset())):(_.isReversed=!1,e.contentDirScrollbar[h].setTranslateX(e.getStartXOffset()+e._seriesSize+e.getTimeAxisVisibleSize(a))):(_.isReversed=!1,e.contentDirScrollbar[h].setTranslateY(e.getStartYOffset()+e._seriesSize+e.getTimeAxisVisibleSize(a)));e.contentDirScrollbar[h].render(_,l[h].w,l[h].h),e.contentDirScrollbar[h].setViewportRange(0,e._seriesSize)}},_prerenderTimeDirScrollbar:(e,i,s)=>{if(e.setTimeDirScrollbar(new t.SimpleScrollbar(e.getCtx(),e.HandleEvent,e)),i.addChild(e.timeDirScrollbar),e.isVertical())var a="right",r=t.CSSStyle.toNumber(e.timeDirScrollbarStyles.getWidth()),n=s.h;else a="bottom",r=s.w,n=t.CSSStyle.toNumber(e.timeDirScrollbarStyles.getHeight());return t.LayoutUtils.position(s,a,e.timeDirScrollbar,r,n,0),new t.Dimension(r,n)},_prerenderContentDirScrollbar:(e,i,s,a)=>{if(e.setContentDirScrollbar(new t.SimpleScrollbar(e.getCtx(),e.HandleEvent,e),a),i.addChild(e.contentDirScrollbar[a]),e.isVertical())var r="bottom",n=s.w,o=t.CSSStyle.toNumber(e.contentDirScrollbarStyles.getHeight());else r="right",n=t.CSSStyle.toNumber(e.contentDirScrollbarStyles.getWidth()),o=s.h;return t.LayoutUtils.position(s,r,e.contentDirScrollbar[a],n,o,0),new t.Dimension(n,o)},_renderZoomControls:e=>{var i=e.getCtx(),s=e._resources,a=t.Agent.isRightToLeft(i);if(e.isDiscreteNavigationMode())e.zoomin&&(e.zoomin.setVisible(),e.zoomout.setVisible());else{var r={zoomInProps:{imageSize:16,class:s.zoomIn},zoomOutProps:{imageSize:16,class:s.zoomOut}},n=e.getStartXOffset()+l._DEFAULT_ZOOM_CONTROL_PADDING;a&&(e._isVertical&&e._hasOverview?n-=e._overviewSize:n-=e.getBackgroundXOffset(),n=e._backgroundWidth-n-l._DEFAULT_ZOOM_CONTROL_DIAMETER),r.zoomInProps.posX=n,r.zoomOutProps.posX=n;var o=e._startY+l._DEFAULT_ZOOM_CONTROL_PADDING;r.zoomInProps.posY=o,r.zoomOutProps.posY=o+l._DEFAULT_ZOOM_CONTROL_DIAMETER+l._DEFAULT_ZOOM_CONTROL_SPACING,e.renderZoomControls(r),e.zoomin.setVisible("visible"),e.zoomout.setVisible("visible")}},_renderEmptyText:e=>{var i=e.Options.series,s=null!=i&&i.length>0?i[0].items:null;if(i&&s&&s.length>0)var a=e.Options.translations.labelInvalidData;else a=e.Options.translations.labelNoData;e.clearComponent();var r=e.renderEmptyText(e._canvas,a,new t.Rectangle(0,0,e._backgroundWidth,e._backgroundHeight),e.EventManager,l.getEmptyTextStyle(e.Options));A.setEmptyText(r,e)},setEmptyText:(e,t)=>{t._emptyText=e},_removeEmptyText:e=>{e._emptyText&&e._emptyText.getParent()&&(e._emptyText.getParent().removeChild(e._emptyText),e._emptyText=null)},_addLabel:(e,i,s,a,r,n,o,l,h,_,d,g,c,m)=>{var u=new t.OutputText(e,a,s,0,l);null!=o&&u.setCSSStyle(o);var v=u.getDimensions();if(n-=v.h,u.setY(n),m&&u.setX(s-v.w),h){var p=Math.min(v.w+2*g,r);if(m)S=s-p+2*g;else var S=s;var b=new t.Rect(e,S-g,n-g,p,v.h+2*g,"ob_"+l);b.setCSSStyle(_),b.setCornerRadius(3),b.setAlpha(d),i.addChild(b),c&&c.push(b)}return t.TextUtils.fitText(u,r,1/0,i),c&&c.push(u),u}};class k{constructor(e){this._context=e}parse(e,t){var i=this.buildData(e),s=new Object;return s.start=new Date(e.start).getTime(),s.end=new Date(e.end).getTime(),s.inlineStyle=e.style,e.svgStyle&&(s.inlineStyle=e.svgStyle),s.scale=e.scale,s.timeAxis=e.timeAxis,s.label=e.label,s.emptyText=e.emptyText,s.isIRAnimationEnabled="auto"===e.animationOnDisplay,s.isDCAnimationEnabled="auto"===e.animationOnDataChange,s.items=this._parseDataNode(e.timeline,e.index,i.data,t,s.start,s.end),s.rtl="false",s.isRandomItemLayout=e._isRandomItemLayout,s.customTimeScales=e._cts,s.customFormatScales=e._cfs,null==e.itemLayout||"auto"===e.itemLayout?s.isTopToBottom=e.inverted:s.isTopToBottom="topToBottom"===e.itemLayout,s.data=e._data,s}buildData(e){var t={},i=[],s=e.items;if(s)for(var a=0;a<s.length;a++){var r=s[a];i.push(r)}return t.data=i,t}_parseDataNode(e,t,i,s,a,r){var n=[],o=e._series[t];if(i)for(var l=0;l<i.length;l++){var _=this.ParseNodeAttributes(i[l],a,r);if(_){if(o._allowUpdates){var d=this._findExistingItem(_,s);if(d){var g=s.indexOf(d);s.splice(g,1),d.setSpacing(null),d.setDurationLevel(null),d.setLoc(null),d.setSelected(!1),d.setStartTime(_.startTime),d.setEndTime(_.endTime),d.setStyle(_.style),d.setData(_.data),d.setBackground(_.background)}else(d=new h(e,t,_)).setSelectable(!0)}else(d=new h(e,t,_)).setSelectable(!0);for(var c=d.getStartTime(),m=!0,u=0;u<n.length;u++)if(c<n[u].getStartTime()){n.splice(u,0,d),m=!1;break}m&&n.push(d)}}return n}_findExistingItem(e,i){if(i)for(var s=0;s<i.length;s++){var a=i[s];if(t.Obj.compareValues(this._context,e.id,a.getId())&&e.title===a.getTitle()&&e.desc===a.getDescription()&&e.thumbnail===a.getThumbnail())return a}return null}getDate(e){return null==e?null:e.getTime?e.getTime():isNaN(e)?new Date(e).getTime()+0:e}ParseNodeAttributes(e,t,i){var s=new Object;return s.id=e.id,s.rowKey=s.id,s.startTime=this.getDate(e.start),s.endTime=this.getDate(e.end),(s.endTime?s.endTime:s.startTime)<t||s.startTime>i?null:(s.title=e.title,s.desc=e.description,s.thumbnail=e.thumbnail,s.shortDesc=e.shortDesc,s.background=e.background,s.data=e,s.style=e.style,e.svgStyle&&(s.style=e.svgStyle),s.durationFillColor=e.durationFillColor,s.markerShape=e._markerShape,s.markerScaleX=e._markerScaleX,s.markerScaleY=e._markerScaleY,s.markerShortDesc=e._markerShortDesc,s.markerFillColor=e._markerFillColor,s.markerGradientFill=e._markerGradientFill,s.markerOpacity=e._markerOpacity,null==e._markerSD||e._markerSD?s.markerSD="true":s.markerSD="false",s.data=e,s)}}const x={renderSeries:(e,i,s)=>{if(x._renderBackground(e,i,s),x._renderScrollableCanvas(e),x._renderReferenceObjects(e,e._canvas),x._renderSeriesTicks(e),null!=e._items){if(0===e._blocks.length){var a=e.getCtx(),r=new t.Container(a,"g","itemBlock_"+e._fetchStartPos+"_"+e._fetchEndPos);r.startPos=e._fetchStartPos,r.endPos=e._fetchEndPos;var n=new t.Container(a,"g","feelers");r.addChild(n),r.feelers=n;var o=new t.Container(a,"g","durations");r.addChild(o),r.durations=o,e._canvas.addChild(r),e._blocks.push(r)}else r=e._blocks[0];e._isInitialRender?(e._isIRAnimationEnabled?e._frAnimationElems=[]:e._frAnimationElems=null,e._mvAnimator=null,e._rmAnimationElems=null):e._allowUpdates&&e._isDCAnimationEnabled?(e._frAnimationElems=[],e._mvAnimator=new t.Animator(e.getCtx(),l.getAnimationDuration(e.Options),0,t.Easing.cubicInOut),e._rmAnimationElems=[]):(e._frAnimationElems=null,e._mvAnimator=null,e._rmAnimationElems=null),e._hasMvAnimations=!1,e.prepareDurations(),e.prepareItems(e._items,e._mvAnimator);var h=Math.max(0,e._maxOverflowValue-e._size);e._overflowOffset=h,x._adjustBackground(e,h),e._oldItems&&x._removeItems(e._oldItems,e,r,e._rmAnimationElems),e._oldItems=null,e.isVertical()&&r.feelers.removeChildren(),x._renderItems(e._items,e,r,e._fetchStartPos,e._fetchEndPos,h,e._frAnimationElems,e._mvAnimator),e._callbackObj.SelectionHandler&&r.setCursor(t.SelectionEffectUtils.getSelectingCursor()),x._updateReferenceObjects(e),x._updateSeriesTicks(e),x._updateMinorSeriesTicks(e)}},updateSeriesForZoom:e=>{x._updateItemsForZoom(e._items,e),x._updateReferenceObjects(e),x._updateSeriesTicks(e),x._updateMinorSeriesTicks(e)},_renderBackground:(e,i,s)=>{if(e._background){var a=!1;e._background.setWidth(i),e._background.setHeight(s)}else a=!0,e._background=new t.Rect(e.getCtx(),0,0,i,s,"bg");e._background.setCSSStyle(e._style),e._background.setPixelHinting(!0),a&&e.addChild(e._background)},_adjustBackground:(e,i)=>{var s=e.getCtx(),a=t.Agent.isRightToLeft(s);i>0&&(e.isVertical()?e._background.setWidth(e._maxOverflowValue):e._background.setHeight(e._maxOverflowValue)),e.isVertical()?(!e.isInverted()&&!a||e.isInverted()&&a)&&(e._background.setTranslateY(0),e._background.setTranslateX(-i),e.setHScrollPos(i)):e.isInverted()||(e._background.setTranslateX(0),e._background.setTranslateY(-i),e.setVScrollPos(i))},_renderScrollableCanvas:e=>{if(e._canvas)return e._canvasOffsetX=e._canvas.getTranslateX(),e._canvasOffsetY=e._canvas.getTranslateY(),e._canvas.setTranslateX(e._offset),void e._canvas.setTranslateY(0);e._canvas=new t.Container(e.getCtx(),"g","canvas"),e._canvas.setTranslateX(e._offset),e.addChild(e._canvas)},_renderItems:(e,t,i,a,r,n,o,l)=>{for(var h,_=0;_<e.length;_++){var d=(h=e[_])._timeline.getDatePos(h.getStartTime());d>=a&&d<=r&&c.renderItem(h,t,i,n,o,l)}if(s.TimeAxisUtils.supportsTouch())for(var g=0;g<e.length-1;g++){var m=(h=e[g]).getBubble();if(m){var u=e[g+1];if(!u.getBubble())break;m._setAriaProperty("flowto","_bt_"+u.getId())}}x._renderDurations(e,t,i,n,o,l)},_updateItemsForZoom:(e,t)=>{var i,s;if(null!=e&&0!==e.length){var a=t._fetchStartPos,r=t._fetchEndPos,n=t._blocks[0];for(n.startPos=a,n.endPos=r,t.isVertical()?t._initialSpacing=20*(t._maxDurationSize>0?1:0)+l.getBubbleSpacing()+10*t._maxDurationSize:t._initialSpacing=20+l.getBubbleSpacing()+10*t._maxDurationSize,s=0;s<e.length;s++){var o=(i=e[s]).getStartTime(),_=i._timeline.getDatePos(o),d=i.getEndTime();if(d&&d!==o){var g=i._timeline.getDatePos(d)-_;i.getItemType()!==h.DURATION_EVENT&&(_+=Math.min(l.getDurationFeelerOffset(),g/2))}i.setLoc(_),t._isRandomItemLayout||i.setSpacing(null)}for(s=0;s<e.length;s++){var m=(i=e[s]).getStartTime();m>=t._start&&m<=t._end&&c._updateBubble(i,t,s)}var u=Math.max(0,t._maxOverflowValue-t._size);for(x._adjustBackground(t,u),s=0;s<e.length;s++)i=e[s],c._displayBubble(i,t,u,null,!1),c._updateFeeler(i,t,u,null),c._updateDuration(i,t,u,null)}},_renderDurations:(e,t,i,s,a,r)=>{for(var n=i.durations,o=t._maxDurationSize;o>0;o--)for(var l=0;l<e.length;l++){var _=e[l],d=_.getStartTime(),g=_.getEndTime();g&&g!==d&&o===_.getDurationLevel()&&_.getItemType()===h.DURATION_BAR&&c.renderDuration(_,t,n,s,a,r)}},_renderSeriesTicks:e=>{null==e._seriesTicks?(e._seriesTicks=new t.Container(e.getCtx()),e._seriesMinorTicks=new t.Container(e.getCtx()),e._seriesTicks._setAriaProperty("hidden","true"),e._seriesMinorTicks._setAriaProperty("hidden","true"),e._callbackObj._timeZoomCanvas.addChild(e._seriesTicks),e._canvas.addChild(e._seriesMinorTicks)):(e._seriesTicks.removeChildren(),e._seriesTicksArray=[],e._seriesMinorTicks.removeChildren(),e._seriesMinorTicksArray=[]);var i=new t.CSSStyle(l.getSeriesAxisSeparatorStyle());if(e._axisStyleDefaults){var s=e._axisStyleDefaults.separatorColor;s&&i.parseInlineStyle("color:"+s+";")}e._separatorStroke=new t.Stroke(i.getStyle(t.CSSStyle.COLOR),1,1,!1,{dashArray:"3"}),e._majorSeparatorStroke=new t.Stroke(i.getStyle(t.CSSStyle.COLOR),1,1,!1,{dashArray:"0"}),e._scale&&e._timeAxis&&x._renderSeriesTimeAxis(e,e._fetchStartPos,e._fetchEndPos,e._seriesTicks),x._renderSeriesMinorTimeAxis(e,e._fetchStartPos,e._fetchEndPos,e._seriesMinorTicks)},_updateSeriesTicks:e=>{for(var i=e.getCtx(),s=t.Agent.isRightToLeft(i),a=e._callbackObj.isDiscreteNavigationMode()?e._callbackObj._discreteContentLength:e._length,r=e._callbackObj.getTimeAxisSize(),n=0;n<e._seriesTicksArray.length;n++){var o=e._seriesTicksArray[n],l=e._callbackObj.getDiscreteOffset();if(!e.isVertical()&&s)var h=a-e._callbackObj.getDatePos(o.time)+l;else h=e._callbackObj.getDatePos(o.time)+l;if(e.isVertical()){var _=s?r:0;o.setX1(_),o.setY1(h),o.setX2(e._maxOverflowValue+_),o.setY2(h)}else o.setX1(h),o.setY1(e.Height-2),o.setX2(h),o.setY2(e.Height+r)}},_updateMinorSeriesTicks:e=>{var i=e.getCtx(),a=t.Agent.isRightToLeft(i),r=e._callbackObj.getTimeAxisSize(),n=e._callbackObj._seriesScale?r:0;if(e.isVertical())return e._seriesMinorTicks.removeChildren(),void(e._seriesMinorTicksArray=[]);if(x._minorTimeAxisScale!==e._callbackObj._timeAxis._scale)e._seriesMinorTicks.removeChildren(),e._seriesMinorTicksArray=[],x._renderSeriesMinorTimeAxis(e,e._fetchStartPos,e._fetchEndPos,e._seriesMinorTicks);else for(var o=0;o<e._seriesMinorTicksArray.length;o++){var l=e._seriesMinorTicksArray[o];if(!e.isVertical()&&a)var h=e._length-s.TimeAxisUtils.getDatePosition(e._start,e._end,l.time,e._length);else h=s.TimeAxisUtils.getDatePosition(e._start,e._end,l.time,e._length);l.setX1(h),l.setY1(0),l.setX2(h),l.setY2(e._maxOverflowValue-n)}},_renderSeriesMinorTimeAxis:(e,i,a,r)=>{var n=e.getCtx(),o=t.Agent.isRightToLeft(n),l=e._callbackObj.getTimeAxisSize(),h=e._callbackObj._seriesScale?l:0;if(!e.isVertical()){var _,d=e._start,g=e._end,c=e._callbackObj._timeAxis;x._minorTimeAxisScale=c._scale,_=[];var m=s.TimeAxisUtils.getPositionDate(d,g,i,e._length),u=c.adjustDate(m),v=s.TimeAxisUtils.getDatePosition(d,g,u,e._length);for(_.push(u.getTime());v<a;)u=e._callbackObj._timeAxis.getNextDate(u.getTime()),v=s.TimeAxisUtils.getDatePosition(d,g,u,e._length),_.push(u.getTime());for(var p=0;p<_.length-1;p++){var S=_[p];if(v=s.TimeAxisUtils.getDatePosition(d,g,S,e._length),!e.isVertical()&&o)var b=e._length-v;else b=v;var D=b,T=b,f=e._maxOverflowValue-h;if(null!=x._majorTickDates&&-1!==x._majorTickDates.indexOf(S))var C=e.addTick(r,D,T,0,f,e._majorSeparatorStroke,"o_minor_tick"+v);else C=e.addTick(r,D,T,0,f,e._separatorStroke,"o_minor_tick"+v);C.time=S,e._seriesMinorTicksArray.push(C)}}},_renderSeriesTimeAxis:(e,i,s,a)=>{var r,n=e.getCtx(),o=t.Agent.isRightToLeft(n),l=e._callbackObj.getTimeAxisSize(),h=e._callbackObj._seriesScale?l:0,_=e._callbackObj.isDiscreteNavigationMode()?e._callbackObj._discreteContentLength:e._length;if(e._customTimeScales&&e._customTimeScales[e._scale])r=e._customTimeScales[e._scale].times;else if(e._customFormatScales&&e._customFormatScales[e._scale]){r=e._customFormatScales[e._scale].times}else{r=[];var d=e._callbackObj.getPosDate(i),g=e._timeAxis.adjustDate(d),c=e._callbackObj.getDatePos(g);for(r.push(g.getTime());c<s;)g=e._timeAxis.getNextDate(g.getTime()),c=e._callbackObj.getDatePos(g),r.push(g.getTime())}x._majorTickDates=r;for(var m=0;m<r.length-1;m++){var u=r[m];if(c=e._callbackObj.getDatePos(u),!e.isVertical()&&o)var v=_-c;else v=c;if(e.isVertical())var p=o?l:0,S=p,b=v,D=e._maxOverflowValue+p,T=v;else S=v,b=e.Height-2,D=v,T=e.Height+h;var f=e.addTick(a,S,D,b,T,e._majorSeparatorStroke,"o_tick"+c);f.time=u,e._seriesTicksArray.push(f)}},_renderReferenceObjects:(e,i)=>{var s=e.getCtx(),a=t.Agent.isRightToLeft(s),r=e._callbackObj.isDiscreteNavigationMode()?e._callbackObj._discreteContentLength:e._length,n=e._callbackObj.getTimeAxisSize();e._callbackObj._seriesScale;null==e._refObjectsContainer&&(e._refObjectsContainer=new t.Container(s),e._refObjectsContainer._setAriaProperty("hidden","true"),i.addChild(e._refObjectsContainer)),e._refObjectsContainer.removeChildren();var o=e._referenceObjects;if(o)for(var h=o.length,_=0;_<h;_++){var d=o[_];if(d){var g=e._callbackObj.getDatePos(d);if(e.isVertical())var c=new t.Line(s,0,g,e._maxOverflowValue,g,"zoomOrder[i]");else a&&(g=r-g),c=new t.Line(s,g,0,g,e._maxOverflowValue,"zoomOrder[i]");var m=new t.Stroke(l.getReferenceObjectColor(e.Options));c.setStroke(m),c.setPixelHinting(!0),c.date=d,e._refObjectsContainer.addChild(c),e._renderedReferenceObjects[_]=c}}},_updateReferenceObjects:e=>{for(var i=e.getCtx(),s=t.Agent.isRightToLeft(i),a=e._callbackObj.isDiscreteNavigationMode()?e._callbackObj._discreteContentLength:e._length,r=e._callbackObj.getTimeAxisSize(),n=e._callbackObj._seriesScale?r:0,o=0;o<e._renderedReferenceObjects.length;o++){var l=e._renderedReferenceObjects[o],h=e._callbackObj.getDatePos(l.date);e.isVertical()?(l.setX1(0),l.setY1(h),l.setX2(e._maxOverflowValue),l.setY2(h)):(s&&(h=a-h),l.setX1(h),l.setY1(0),l.setX2(h),l.setY2(e._maxOverflowValue-n))}},_removeItems:(e,t,i,s)=>{if(s)x._animateItemRemoval(e,t,s);else for(var a=0;a<e.length;a++){var r=e[a],n=r.getBubble();if(i.removeChild(n),!t.isVertical()&&r._timeline.isFeelerEnabled()){var o=i.feelers,l=r.getFeeler();o.removeChild(l)}var h=r.getStartTime(),_=r.getEndTime();if(_&&_!==h){var d=i.durations,g=r.getDurationBar();d.removeChild(g)}}},_animateItemRemoval:(e,t,i)=>{for(var s=0;s<e.length;s++){var a=e[s],r=a.getBubble();if(t.isVertical()?r.setTranslateX(r.getTranslateX()+t._canvasOffsetX+t._overflowOffset):r.setTranslateY(r.getTranslateY()+t._canvasOffsetY+t._overflowOffset),i.push(r),!t.isVertical()&&a._timeline.isFeelerEnabled()){var n=a.getFeeler();n.setTranslateY(n.getTranslateY()+t._canvasOffsetY+t._overflowOffset),i.push(n)}var o=a.getStartTime(),l=a.getEndTime();if(l&&l!==o&&a.getItemType()===h.DURATION_BAR){var _=a.getDurationBar();t.isVertical()?_.setTranslateX(_.getTranslateX()+t._canvasOffsetX+t._overflowOffset):_.setTranslateY(_.getTranslateY()+t._canvasOffsetY+t._overflowOffset),i.push(_)}}}};class M extends t.BaseComponent{constructor(e,t,i){super(e),this._callback=t,this._callbackObj=i,this._blocks=[],this._renderedReferenceObjects=[],this._seriesTicksArray=[],this._seriesMinorTicksArray=[]}triggerAnimations(){var e=this.getCtx();if(this._rmAnimationElems&&0!==this._rmAnimationElems.length){this._callbackObj.EventManager.removeListeners(this._callbackObj);var i=new t.ParallelPlayable(e,new t.AnimFadeOut(e,this._rmAnimationElems,l.getAnimationDuration(this.Options)));t.Playable.appendOnEnd(i,this._onRmAnimationEnd,this),this._callbackObj.Animation=i,i.play()}else if(this._mvAnimator&&this._hasMvAnimations)this._callbackObj.EventManager.removeListeners(this._callbackObj),t.Playable.appendOnEnd(this._mvAnimator,this._onMvAnimationEnd,this),this._callbackObj.Animation=this._mvAnimator,this._mvAnimator.play();else if(this._frAnimationElems&&0!==this._frAnimationElems.length){this._callbackObj.EventManager.removeListeners(this._callbackObj);var s=new t.ParallelPlayable(e,new t.AnimFadeIn(e,this._frAnimationElems,l.getAnimationDuration(this.Options),(this._isInitialRender,0)));t.Playable.appendOnEnd(s,this._onAnimationEnd,this),this._callbackObj.Animation=s,s.play()}}_onRmAnimationEnd(){for(var e=0;e<this._rmAnimationElems.length;e++){var i=this._rmAnimationElems[e],s=i.getParent();s&&s.removeChild(i)}this._mvAnimator&&this._hasMvAnimations?(this._callbackObj.Animation=this._mvAnimator,t.Playable.appendOnEnd(this._mvAnimator,this._onMvAnimationEnd,this),this._mvAnimator.play()):this._onMvAnimationEnd()}_onMvAnimationEnd(){if(this._frAnimationElems&&0!==this._frAnimationElems.length){var e=new t.ParallelPlayable(this.getCtx(),new t.AnimFadeIn(this.getCtx(),this._frAnimationElems,l.getAnimationDuration(this.Options),(this._isInitialRender,0)));t.Playable.appendOnEnd(e,this._onAnimationEnd,this),this._callbackObj.Animation=e,e.play()}else this._onAnimationEnd()}_onAnimationEnd(){this._callbackObj.onAnimationEnd()}render(e,i,a){if(e){this.SetOptions(e),this.Width?this._isInitialRender=!1:this._isInitialRender=!0,this.Width=i,this.Height=a;var r=this.Options.orientation;if(r&&"vertical"===r?(this._isVertical?this._allowUpdates=!0:this._allowUpdates=!1,this._isVertical=!0):(this._isVertical?this._allowUpdates=!1:this._allowUpdates=!0,this._isVertical=!1),this.Options){var n=this.Parse(this.Options);this._applyParsedProperties(n)}this._fetchStartPos=0,this._isVertical?(this._fetchEndPos=a,this._maxOverflowValue=i,this._length=a,this._size=i,this._offset=0):(this._maxOverflowValue=a,this._callbackObj.isDiscreteNavigationMode()?(this._offset=this._callbackObj._discreteOffset,this._length=i-2*this._offset,this._fetchEndPos=i-2*this._offset):(this._length=i,this._fetchEndPos=i,this._offset=0),this._size=a),this._isInverted=this.Options.inverted,this._colorCount=0,this._maxDurationSize=0,x.renderSeries(this,i,a),s.TimeAxisUtils.supportsTouch()&&this._items.length>0&&this._setAriaProperty("flowto","_bt_"+this._items[0].getId());var o=this.GetComponentDescription();o&&(t.ToolkitUtils.setAttrNullNS(this.getElem(),"role","group"),t.ToolkitUtils.setAttrNullNS(this.getElem(),"aria-label",t.AriaUtils.processAriaLabel(o)))}else this._handleResize(i,a)}GetComponentDescription(){var e=this.Options.translations,i=[e.labelSeries];return this._label?i.push(this._label):i.push(this.Options.index+1),t.ResourceUtils.format(e.labelAndValue,i)}_handleResize(e,t){this._canvas.setTranslateY(0),this._callbackObj.isDiscreteNavigationMode()||this._canvas.setTranslateX(0),this.Width=e,this.Height=t,this._fetchStartPos=0,this._isVertical?(this._fetchEndPos=t,this._maxOverflowValue=e,this._length=t,this._size=e,this._offset=0):(this._maxOverflowValue=t,this._callbackObj.isDiscreteNavigationMode()?(this._offset=this._callbackObj._discreteOffset,this._length=e-2*this._offset,this._fetchEndPos=e-2*this._offset,this._canvas.setTranslateX(this._offset)):(this._length=e,this._fetchEndPos=e,this._offset=0),this._size=t),this._background.setWidth(e),this._background.setHeight(t),x.updateSeriesForZoom(this),this._callbackObj.getEventManager()._isDndDragging&&this._callbackObj.getEventManager().updateDnd()}applyStyleValues(){if(this._style=new t.CSSStyle(l.getSeriesStyle()),this._seriesStyleDefaults=this.Options.seriesStyleDefaults,this._axisStyleDefaults=this.Options.axisStyleDefaults,this._colors=l.getColorsArray(this.Options),this._referenceObjects=this.Options.referenceObjects,this._seriesStyleDefaults){var e=this._seriesStyleDefaults.backgroundColor;e&&this._style.parseInlineStyle("background-color:"+e+";")}this._style.parseInlineStyle(this._inlineStyle)}SetOptions(e){this.Options=e}Parse(e){return this._parser=new k(this.getCtx()),this._parser.parse(e,this._items)}_applyParsedProperties(e){this._items&&(this._oldItems=this._items),this._items=e.items,this._items&&this._items.length>0?this._isEmpty=!1:this._isEmpty=!0,this._isIRAnimationEnabled=e.isIRAnimationEnabled,this._isDCAnimationEnabled=e.isDCAnimationEnabled,this._label=e.label,this._timeAxis=e.timeAxis,this._emptyText=e.emptyText,null==this._emptyText&&(this._emptyText=this.Options.translations.labelNoData),this._isTopToBottom=e.isTopToBottom,this._isRandomItemLayout=e.isRandomItemLayout,this._customTimeScales=e.customTimeScales,this._customFormatScales=e.customFormatScales,this._start=e.start,this._end=e.end,this._inlineStyle=e.inlineStyle,this._scale=e.scale,this._converter=e.converter,this._data=e.data,this.applyStyleValues()}calculateSpacing(e,t){var i,s,a;if(null==this._items||0===this._items.length)return null;var r=this._maxOverflowValue,n=e.getSpacing();if(this._isRandomItemLayout){if(null==n){var o=e.getHeight(),h=this._initialSpacing,_=this._maxOverflowValue-o-h;_<0&&(_=0),n=Math.round(Math.random()*_)+h,this._maxOverflowValue<n+o&&(this._maxOverflowValue=n+o+l.getBubbleSpacing())}return n}if(null==n&&(n=this._initialSpacing),this._isVertical)for(i=0;i<t;i++)r<n+(a=(s=this._items[i]).getWidth()+10)&&(r=n+a);else{var d=e.getEndViewportCollision()?e.getContentWidth():0,g=e.getLoc()-d,c=e.getWidth()+l.getMinHorizontalBubbleSpacing(),m=l.getBubbleSpacing(),u=[];for(i=0;i<t;i++){a=(s=this._items[i]).getWidth()+l.getMinHorizontalBubbleSpacing(),d=s.getEndViewportCollision()?s.getContentWidth():0;var v=s.getLoc()-d;(g>=v&&g<=v+a||v>=g&&v<=g+c)&&u.push(s)}for(i=0;i<u.length;i++){for(var p=!1,S=0;S<u.length;S++){var b=(s=u[S]).getHeight(),D=s.getSpacing();if(n>=D&&n<=D+b){n=D+b+m,e.setSpacing(n),p=!0;break}}if(!p)break}r<n+b&&(r=n+b)}return r>this._maxOverflowValue&&(this._maxOverflowValue=r+l.getBubbleSpacing()),n}calculateDurationSize(e,t){var i,s;if(null==this._items||0===this._items.length||"duration-bar"!==e.getItemType())return null;var a=e.getStartTime(),r=e.getEndTime();if(!r||r===a)return null;var n=e.getDurationLevel();null==n&&(n=1);var o=[];for(i=0;i<t;i++){var l=(s=this._items[i]).getStartTime(),h=s.getEndTime();h&&h!==l&&a>=l&&a<=h&&o.push(s)}for(i=0;i<o.length;i++){for(var _=!1,d=0;d<o.length;d++){var g=(s=o[d]).getDurationLevel();if(n===g){n=g+1,e.setDurationLevel(n),_=!0;break}}if(!_)break}return n>this._maxDurationSize&&(this._maxDurationSize=n),n}prepareDurations(){for(var e=0;e<this._items.length;e++){var t=this._items[e],i=t.getStartTime(),s=t.getEndTime();s&&s!==i&&(t.setDurationLevel(this.calculateDurationSize(t,e)),t.setDurationSize(22+10*t.getDurationLevel()-5),null==t.getDurationFillColor()&&(t.setDurationFillColor(this._colors[this._colorCount]),this._colorCount++,this._colorCount===this._colors.length&&(this._colorCount=0)))}}prepareItems(e,t){var i,s,a;for(this.isVertical()?this._initialSpacing=20*(this._maxDurationSize>0?1:0)+l.getBubbleSpacing()+10*this._maxDurationSize:this._initialSpacing=20+l.getBubbleSpacing()+10*this._maxDurationSize,i=0;i<e.length;i++){s=e[i],a=this._callbackObj.getDatePos(s.getStartTime());var r=s.getEndTime();if(r&&r!==s.getStartTime()){var n=this._callbackObj.getDatePos(r)-a;s.getItemType()!==h.DURATION_EVENT&&(a+=Math.min(l.getDurationFeelerOffset(),n/2))}s.setLoc(a)}for(i=0;i<this._items.length;i++)s=this._items[i],(a=this._callbackObj.getDatePos(s.getStartTime()))>=this._fetchStartPos&&a<=this._fetchEndPos&&c.initializeItem(s,this,i,t)}getData(e){if(e){var t={emptyText:this._data.emptyText,id:this._data.id,itemLayout:this._data.itemLayout,label:this._data.label,svgStyle:this._data.svgStyle,items:this._data.items};return i.TimeComponent.sanitizeData(t,"series")}return this._data}getLabel(){return this._label}getEmptyText(){return this._emptyText}findItem(e){if(null!=this._items)for(var i=0;i<this._items.length;i++){var s=this._items[i];if(t.Obj.compareValues(this.getCtx(),s.getId(),e))return s}return null}isInverted(){return this._isInverted}isTopToBottom(){return this._isTopToBottom}isVertical(){return this._isVertical}addTick(e,i,s,a,r,n,o){var l=new t.Line(this.getCtx(),i,a,s,r,o);return l.setStroke(n),l.setPixelHinting(!0),e.addChild(l),l}setVScrollPos(e){null!=this._canvas&&this._canvas.setTranslateY(0-e)}setHScrollPos(e){null!=this._canvas&&this._canvas.setTranslateX(this._offset-e)}}class P extends i.TimeComponent{constructor(e,t,i){super(e,t,i),this.Defaults=new d(e),this._hasListeners=!1,this.EventManager=new m(this),this.EventManager.addListeners(this),this._keyboardHandler=new n(this.EventManager),this.EventManager.setKeyboardHandler(this._keyboardHandler)}Parse(e){return this._parser=new u,this._parser.parse(e)}_applyParsedProperties(e){var i=this.Options.orientation;this._isVertical=!(!i||"vertical"!==i),this._viewportNavigationMode=this.Options.viewportNavigationMode,this._hasOverview=e.hasOverview,this._viewStartTime=e.viewStart,this._viewEndTime=e.viewEnd,this._initialViewportTimeDuration=this._viewEndTime-this._viewStartTime,this._selectionMode=e.selectionMode,"single"===this._selectionMode?this.SelectionHandler=new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_SINGLE):"multiple"===this._selectionMode?this.SelectionHandler=new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_MULTIPLE):this.SelectionHandler=null,this.EventManager.setSelectionHandler(this.SelectionHandler);var a=this.isDnDMoveEnabled(),r=this.isDnDResizeEnabled();if(a||r){this.Options.dnd=t.JsonUtils.merge(this.Options.dnd,{drag:{event:{dataTypes:[]},"resize-handle":{dataTypes:[]}},drop:{canvas:{dataTypes:[]}}});var n=this,o=(e,t)=>{var i=n.Options.dnd.drag[t].dataTypes;Array.isArray(i)||(n.Options.dnd.drag[t].dataTypes=[i],i=n.Options.dnd.drag[t].dataTypes),i.push(e);var s=n.Options.dnd.drop.canvas.dataTypes;Array.isArray(s)||(n.Options.dnd.drop.canvas.dataTypes=[s],s=n.Options.dnd.drop.canvas.dataTypes),s.push(e)};r&&o("text/_dvtdndresizeitems","resize-handle"),a&&o("text/_dvtdndmoveitems","event")}this._shortDesc=e.shortDesc?e.shortDesc:this._shortDesc,this._referenceObjects=e.referenceObjects?e.referenceObjects:this._referenceObjects,this._seriesScale=e.seriesScale?e.seriesScale:this._seriesScale,this._seriesScale?(this._seriesConverter=e.seriesConverter,this._seriesTimeAxis=new s.TimeAxis(this.getCtx(),null,null),this._seriesTimeAxis.setIsVertical(this._isVertical),this._seriesTimeAxis.setScale(this._seriesScale),this._seriesTimeAxis.setConverter(this._seriesConverter),this._seriesCustomFormatScales=e.seriesCustomFormatScales,this._isVertical?this._seriesTimeAxis.setDefaultConverter(this._resources.converterVert):this._seriesTimeAxis.setDefaultConverter(this._resources.converter)):this._seriesTimeAxis=null,this._defaultInversions=[!1,!0],this._itemPosition=e.itemPosition,this._customTimeScales=e.customTimeScales,this._customFormatScales=e.customFormatScales,this._scale=e.scale,super._applyParsedProperties(e)}getTimeAxis(){return this._timeAxis}getTimeAxisSize(){return this._timeAxis.getSize()}getTimeAxisVisibleSize(e){return this._hasOverview||1!==e?this.getTimeAxisSize():this.getTimeAxisSize()-this._timeAxis.getBorderWidth()}select(e){this.Options.selection=t.JsonUtils.clone(e),this.SelectionHandler&&this.applyInitialSelections()}_bundleTimeAxisOptions(e,t){var i=this._resources;"majorAxis"===t?(i.axisSeparatorClass="oj-timeline-major-axis-separator",i.axisLabelClass="oj-timeline-major-axis-label"):"minorAxis"===t&&(i.axisClass="oj-timeline-minor-axis",i.axisSeparatorClass="oj-timeline-minor-axis-separator",i.axisLabelClass="oj-timeline-minor-axis-label");var s={start:e.start,end:e.end,_resources:i,shortDesc:e.shortDesc,_tzo:e._tzo,_ip:e._ip,_cts:this._customTimeScales,_cfs:this._customFormatScales,orientation:e.orientation};if(e.styleDefaults&&e.styleDefaults.minorAxis){var a=e.styleDefaults.minorAxis;s.backgroundColor=a.backgroundColor,s.borderColor=a.borderColor,s.separatorColor=a.separatorColor,s.labelStyle=a.labelStyle}if(e[t]){var r=e[t];r.scale&&(s.scale=r.scale),r.converter&&(s.converter=r.converter),s.zoomOrder=r.zoomOrder||[r.scale]}if(e.minorAxis){var n=e.minorAxis;"alta"===this.getCtx().getThemeBehavior()?(s._scaleLabelPosition={seconds:"center",minutes:"center",hours:"center",days:"center",weeks:"center",months:"center",quarters:"center",years:"center"},s._labelAlignment={horizontal:"middle",vertical:"middle"}):(s._scaleLabelPosition={seconds:"start",minutes:"start",hours:"start",days:"center",weeks:"start",months:"start",quarters:"start",years:"start"},s._labelAlignment={horizontal:"middle",vertical:"middle"}),s.zoomOrder.forEach(e=>{if(e&&e.name){const t=e.labelPosition||"auto",i="auto"===t?"start":t;s._scaleLabelPosition[e.name]=i}}),s.style=n.style,n.svgStyle&&(s.style=n.svgStyle)}return s}render(e,t,i){if(this._isComponentResize=!e,e){if(this._hasListeners||this.EventManager.addListeners(this),super.render(e,t,i),this.isDndEnabled()){var a=this.getCtx();this.renderAriaLiveRegion("_dvtTimelineAriaLiveRegion"+a.getStage().getId())}else this.removeAriaLiveRegion();this.StopAnimation(!0),this._fetchStartPos=0,this._isVertical?this._fetchEndPos=i:this._fetchEndPos=t,this.Options.styleDefaults&&(this.Options.styleDefaults.item.descriptionStyle=l.convertToCSSStyle(this.Options.styleDefaults.item.descriptionStyle),this.Options.styleDefaults.item.titleStyle=l.convertToCSSStyle(this.Options.styleDefaults.item.titleStyle),this.Options.styleDefaults.majorAxis.labelStyle=l.convertToCSSStyle(this.Options.styleDefaults.majorAxis.labelStyle),this.Options.styleDefaults.minorAxis.labelStyle=l.convertToCSSStyle(this.Options.styleDefaults.minorAxis.labelStyle),this.Options.styleDefaults.overview.labelStyle=l.convertToCSSStyle(this.Options.styleDefaults.overview.labelStyle),this.Options.styleDefaults.series.emptyTextStyle=l.convertToCSSStyle(this.Options.styleDefaults.series.emptyTextStyle),this.Options.styleDefaults.series.labelStyle=l.convertToCSSStyle(this.Options.styleDefaults.series.labelStyle),this.Options.styleDefaults.tooltipLabelStyle=l.convertToCSSStyle(this.Options.styleDefaults.tooltipLabelStyle),this.Options.styleDefaults.tooltipValueStyle=l.convertToCSSStyle(this.Options.styleDefaults.tooltipValueStyle),this._majorAxisStyleDefaults=this.Options.styleDefaults.majorAxis,this._seriesStyleDefaults=this.Options.styleDefaults.series);var r=e.majorAxis;if(r)if(r.scale){var n=this._bundleTimeAxisOptions(this.Options,"majorAxis");null==this._majorAxis&&(this._majorAxis=new s.TimeAxis(this.getCtx(),null,null)),this._majorAxis.setCanvasSize(null),this._majorAxis.getPreferredLength(n,this._canvasLength)}else this._majorAxis=null;else this._majorAxis=null;if(this._scale&&(this._timeAxisOptions=this._bundleTimeAxisOptions(this.Options,"minorAxis"),this._majorAxis&&(this._timeAxisOptions._secondaryAxis=this._majorAxis),this.applyAxisStyleValues(),this._timeAxis||(this._timeAxis=new s.TimeAxis(this.getCtx(),null,null)),this._isVertical?this._timeAxis.setBorderVisibility(!1,!0,!1,!0):this._timeAxis.setBorderVisibility(!0,!1,!0,!1),this._timeAxis.setCanvasSize(null),!this.hasMatchingViewportDates())){var o=this._timeAxis.getPreferredLength(this._timeAxisOptions,this._canvasLength);o&&this.setContentLength(o),this._timeAxis.hasValidOptions()&&this.prepareViewportLength()}if(this.isDiscreteNavigationMode()){this.hasMatchingViewportDates()||(this._discreteViewportStartIndex=0,this._discreteViewportCurrentIndexOffset=0,this._discreteViewportDatePositions=[this._viewStartTime,this._viewEndTime]);var h=l.getNavButtonBackgroundWidth();this._timeAxisRatio=(this._canvasLength-2*h)/this._canvasLength,this._discreteOffset=(this.getContentLength()-this.getContentLength()*this._timeAxisRatio)/2,this._discreteContentLength=this.getContentLength()*this._timeAxisRatio}this._populateSeries(),A.renderTimeline(this),this.UpdateAriaAttributes(),this.getCtx().setKeyboardFocusArray([this]),this.Animation||this.RenderComplete()}else this._handleResize(t,i)}hasMatchingViewportDates(){return this.isVertical()?(this._discreteViewportDatePositions=null,!1):this.isDiscreteNavigationMode()&&null!=this._discreteViewportDatePositions&&-1!=this._discreteViewportDatePositions.indexOf(this._viewStartTime)&&-1!=this._discreteViewportDatePositions.indexOf(this._viewEndTime)}hasValidSeriesItems(){for(var e=0;e<this._seriesOptions.length;e++){var t=this._seriesOptions[e];if(t.items)for(var i=0;i<t.items.length;i++){var s=t.items[i],a=new Date(s.start).getTime();if(null==a||isNaN(a)||null==s.start)return!1;if(s.hasOwnProperty("end")){var r=new Date(s.end).getTime();if(!isNaN(r)&&r<a)return!1}}}return!0}hasValidOptions(){var e=this._scale&&(-1!==s.TimeAxis.VALID_SCALES.indexOf(this._scale)||this.isTimeComponentScale(this._scale)),t=this._scale&&this._customTimeScales&&this._customTimeScales[this._scale],i=this._start&&this._end&&this._end>this._start,a=this._series&&this._series.length>0,r=!!a&&this.hasValidSeriesItems(),n=!this._seriesScale||(-1!==s.TimeAxis.VALID_SCALES.indexOf(this._seriesScale)||this.isTimeComponentScale(this._seriesScale)),o=!this._seriesScale||this._customTimeScales&&this._customTimeScales[this._seriesScale],l=!this._viewStartTime||!this._viewEndTime||this._viewEndTime>this._viewStartTime,h=!this._viewStartTime||this._viewStartTime>=this._start&&this._viewStartTime<this._end,_=!this._viewEndTime||this._viewEndTime>this._start&&this._viewEndTime<=this._end;return(e||t)&&(n||o)&&i&&a&&r&&l&&h&&_}isTimeComponentScale(e){return null!=e.getNextDate&&null!=e.getPreviousDate&&null!=e.formatter&&null!=e.name}GetComponentDescription(){return this._shortDesc?this._shortDesc:this.Options.translations.componentName}applyStyleValues(){if(this._style=new t.CSSStyle(l.getTimelineStyle()),this.Options.styleDefaults){var e=this.Options.styleDefaults.borderColor;e&&this._style.parseInlineStyle("border-color:"+e+";")}if(this._hasOverview){this._overviewSize=this._isVertical?l.getOverviewWidth():l.getOverviewHeight();var i=this.Options.overview,s=i.svgStyle?i.svgStyle:i.style;if(s){var a=new t.CSSStyle(s),r=this._isVertical?a.getWidth():a.getHeight();null!=r&&(this._overviewSize=t.CSSStyle.toNumber(r))}}super.applyStyleValues();var n=this._style.getBorderWidth(),o=2*n,h="border:"+o+"px;";this._style.parseInlineStyle(h),this.setStartXOffset(n),this.setStartYOffset(n),this.setBackgroundXOffset(0);var _=3*this.getScrollbarPadding();this.timeDirScrollbarStyles=this.getTimeDirScrollbarStyle(),this.contentDirScrollbarStyles=this.getContentDirScrollbarStyle(),this._backgroundWidth=this.Width,this._backgroundHeight=this.Height,this._isVertical?(this.isContentDirScrollbarOn()&&(this._backgroundHeight=this._backgroundHeight-t.CSSStyle.toNumber(this.contentDirScrollbarStyles.getHeight())-_),this._canvasLength=this._backgroundHeight-o,this._hasOverview?(this._canvasSize=this._backgroundWidth-this._overviewSize-o,this.isRTL()&&this.setStartXOffset(n+this._overviewSize)):(this.isTimeDirScrollbarOn()&&(this._backgroundWidth=this._backgroundWidth-t.CSSStyle.toNumber(this.timeDirScrollbarStyles.getWidth())-_),this._canvasSize=this._backgroundWidth-o,this.isRTL()&&(this.setBackgroundXOffset(this.Width-this._backgroundWidth),this.setStartXOffset(this.getStartXOffset()+this.getBackgroundXOffset())))):(this.isContentDirScrollbarOn()&&(this._backgroundWidth=this._backgroundWidth-t.CSSStyle.toNumber(this.contentDirScrollbarStyles.getWidth())-_),this._canvasLength=this._backgroundWidth-o,this.isRTL()&&(this.setBackgroundXOffset(this.Width-this._backgroundWidth),this.setStartXOffset(this.getStartXOffset()+this.getBackgroundXOffset())),this._hasOverview?this._canvasSize=this._backgroundHeight-this._overviewSize-o:(this.isTimeDirScrollbarOn()&&(this._backgroundHeight=this._backgroundHeight-t.CSSStyle.toNumber(this.timeDirScrollbarStyles.getHeight())-_),this._canvasSize=this._backgroundHeight-o))}applyAxisStyleValues(){if(this._seriesStyleDefaults&&this._seriesStyleDefaults.backgroundColor){var e=this._seriesStyleDefaults.backgroundColor,i=t.ColorUtils.getRed(e),s=t.ColorUtils.getGreen(e),a=t.ColorUtils.getBlue(e);this._seriesBackgroundOverlayStyle="background-color:rgba("+i+","+s+","+a+",0.8);"}}_populateSeries(){var e,t=this.Options.series;if(t){var i=Math.min(t.length,2);if(this._seriesOptions=[],this._series)if(i!==this._series.length){for(e=0;e<this._series.length;e++)this._timeZoomCanvas.removeChild(this._series[e]);this._series=[]}else for(e=0;e<this._series.length;e++)this._series[e]._items&&this._series[e]._items.length>0&&t[e].items&&this._series[e]._items[0]._data.itemType!==t[e].items[0].itemType&&(this._timeZoomCanvas.removeChild(this._series[e]),this._timeZoomCanvas.removeChild(this._series[e]._seriesTicks),this._series[e]._seriesTicks=null,this._series[e]=null);else this._series=[];for(e=0;e<i;e++){var s=t[e];if(s.start=this._start,s.end=this._end,s.inverted=this._defaultInversions[e],s.orientation=this.Options.orientation,s.referenceObjects=this._referenceObjects,s.timeline=this,s.index=e,s.animationOnDisplay=this.Options.animationOnDisplay,s.animationOnDataChange=this.Options.animationOnDataChange,this.Options.majorAxis&&(s.scale=void 0===this.Options.majorAxis.scale?this._seriesScale:this.Options.majorAxis.scale,s.timeAxis=this._seriesTimeAxis,s._cfs=this._seriesCustomFormatScales),s.styleDefaults=this.Options.styleDefaults,this.Options.styleDefaults&&(s.seriesStyleDefaults=this._seriesStyleDefaults,s.axisStyleDefaults=this._majorAxisStyleDefaults),s._isRandomItemLayout="random"===this._itemPosition,s._cts=this.Options._cts,s._data=t[e],s.translations=this.Options.translations,this._seriesOptions.push(s),null==this._series[e]){var a=new M(this.getCtx(),this.HandleEvent,this);this._series[e]=a}}}else this._series=[]}onAnimationEnd(){this.AnimationStopped||this.RenderComplete(),this.EventManager.addListeners(this),this.Animation=null,this.AnimationStopped=!1}_getOverviewObject(){var e=new Object;e.width=this._contentLength,e.selmode="none",e.rtl=this.isRTL(),e.sid="ts1";var t=l.getOverviewWindowBackgroundColor(this.Options);e._wbc=t,e._hfc=t;var i=l.getOverviewWindowBorderColor(this.Options);return e._wbtc=i,e._wbrc=i,e._wbbc=i,e._wblc=i,e._ls=l.getOverviewLabelStyle(this.Options).toString(),e._obc=l.getOverviewBackgroundColor(this.Options),e._ctic=l.getReferenceObjectColor(this.Options),this._referenceObjects&&this._referenceObjects.length>0&&(e.referenceObjects=this._referenceObjects),this._isVertical?(e.orn="vertical",e.yMin=this._start,e.yMax=this._end,e.y1=this._viewStartTime,e.y2=this._viewEndTime):(e.orn="horizontal",e.xMin=this._start,e.xMax=this._end,e.x1=this._viewStartTime,e.x2=this._viewEndTime,e._ds="square",e._dsx="1.3d",e._dsy="0.9d"),this._resources.overviewHandleVert&&(e._vhbc=this._resources.overviewHandleVert,e._vhs=16),this._resources.overviewHandleHor&&(e._hbc=this._resources.overviewHandleHor,e._hs=16),e.axisTicks=this._getOverviewAxisOptions(),e.markers=this._getOverviewMarkerOptions(),e}_getOverviewAxisOptions(){var e=[];if(this._seriesTimeAxis){var t,i;if(this._customTimeScales&&this._customTimeScales[this._seriesScale]){var s=this._customTimeScales[this._seriesScale];t=s.times,i=s.labels}else if(this._seriesCustomFormatScales&&this._seriesCustomFormatScales[this._seriesScale]){var a=this._seriesCustomFormatScales[this._seriesScale];t=a.times,i=a.labels}else{t=[],i=[];this._start,this._end,this._isVertical?this.Height:this.Width;for(var r=this.getPosDate(this._fetchStartPos),n=this._seriesTimeAxis.adjustDate(r),o=this.getDatePos(n);o<this._fetchEndPos;)i.push(this._seriesTimeAxis.formatDate(n)),t.push(n.getTime()),n=this._seriesTimeAxis.getNextDate(n.getTime()),o=this.getDatePos(n)}for(var l=0;l<i.length;l++){var h=new Object;h.time=t[l],h.label=i[l],e.push(h)}}return e}_getOverviewMarkerOptions(){if(this._series){for(var e=[],t=this._series.length,i=0;i<t;i++)for(var s=this._series[i]._items,a=0;a<s.length;a++){var r=s[a],n=new Object;n.rk=a,n.sid=i,n.tid=r.getId(),n.t=r.getStartTime(),n._sd=r.getMarkerSD(),this._isVertical||(r.getMarkerShape()&&(n.s=r.getMarkerShape()),r.getMarkerScaleX()&&(n.sx=r.getMarkerScaleX()),r.getMarkerScaleY()&&(n.sy=r.getMarkerScaleY())),r.getMarkerShortDesc()&&(n.d=r.getMarkerShortDesc()),r.getMarkerFillColor()&&(n.c=r.getMarkerFillColor()),r.getMarkerGradientFill()&&(n.g=r.getMarkerGradientFill()),r.getMarkerOpacity()&&(n.o=r.getMarkerOpacity());var o=r.getEndTime();if(o){n.et=o;var l=r.getDurationFillColor();l&&r.getItemType()===h.DURATION_BAR&&(n.dfc=l)}e.push(n)}return e}return null}createViewportChangeEvent(){var e=this._timeAxis.getScale();return t.EventFactory.newTimelineViewportChangeEvent(this._viewStartTime,this._viewEndTime,e)}HandleTouchStart(e){var t=e.touches,i=e.target.getClassName();1!==t.length||i||(this._dragPanSeries=this._findSeries(e.target))}HandleMouseWheel(e){if(super.HandleMouseWheel(e),this.hasValidOptions()&&!this.isDiscreteNavigationMode()&&e.zoomWheelDelta){var t=this.getCtx().pageToStageCoords(e.pageX,e.pageY);if(this.getGraphicalAreaBounds().containsPoint(t.x,t.y)){var i=this.getContentLength()*e.zoomWheelDelta,s=e.zoomTime,a=e.zoomCompLoc;this.handleZoomWheel(i,s,a,!0)}}}handleZoomWheel(e,t,i,s){var a;e>this._timeAxis.getMaxContentLength()?(e=this._timeAxis.getMaxContentLength(),this.disableZoomButton(!0)):this.enableZoomButton(!0),this._canvasLength>e?(e=this._canvasLength,this.disableZoomButton(!1)):this.enableZoomButton(!1);var r=this.getContentLength()<=e;super.handleZoomWheel(e,t,i,s);var n=this._timeAxis.getZoomLevelLengths();if(r)for(;this._timeAxis.getZoomLevelOrder()>0&&(a=n[this._timeAxis.getZoomLevelOrder()-1],this.getContentLength()>=a);)this._timeAxis.setZoomLevelOrder(this._timeAxis.getZoomLevelOrder()-1),this._timeAxis.decreaseScale();else for(;this._timeAxis.getZoomLevelOrder()<n.length-1&&(a=n[this._timeAxis.getZoomLevelOrder()],this.getContentLength()<a);)this._timeAxis.setZoomLevelOrder(this._timeAxis.getZoomLevelOrder()+1),this._timeAxis.increaseScale();if(this._hasOverview&&(this._isVertical?this._overview.setViewportRange(null,null,this._viewStartTime,this._viewEndTime):this._overview.setViewportRange(this._viewStartTime,this._viewEndTime,null,null)),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),this.applyAxisStyleValues(),A._renderAxis(this,this._timeZoomCanvas,!0),this.updateSeries(),this.isContentDirScrollbarOn())for(var o=0;o<this._series.length;o++)this.contentDirScrollbar[o].setViewportRange(0,this._seriesSize,0,Math.max(this._series[o]._maxOverflowValue,this._seriesSize));s&&this.dispatchEvent(this.createViewportChangeEvent())}updateSeries(){if(this._series){var e=this._series.length,i=this.getTimeAxisVisibleSize(e);this._seriesSize=(this._canvasSize-i)/e;for(var s=0;s<e;s++){var a=this._series[s];a.setClipPath(null);var r=new t.ClipPath;if(this._isVertical){if(this.isRTL())var n=Math.abs(s-1);else n=s;if(this.isRTL()&&1===this._series.length){r.addRect(i,0,this._seriesSize,this.getContentLength());var o=new t.Matrix(1,0,0,1,i,0)}else r.addRect(n*(this._seriesSize+i),0,this._seriesSize,this.getContentLength()),o=new t.Matrix(1,0,0,1,n*(this._seriesSize+i),0);var l=this._seriesSize,h=this.getContentLength()}else r.addRect(0,s*(this._seriesSize+i),this.getContentLength(),this._seriesSize),o=new t.Matrix(1,0,0,1,0,s*(this._seriesSize+i)),l=this.getContentLength(),h=this._seriesSize;a.setClipPath(r),a.setMatrix(o),a.render(null,l,h)}}}_handleResize(e,t){if(this.Width=e,this.Height=t,this.applyStyleValues(),this._fetchStartPos=0,this._isVertical?this._fetchEndPos=t:this._fetchEndPos=e,this.prepareViewportLength(),A._removeEmptyText(this),A._renderBackground(this),this.isDiscreteNavigationMode()){var i=l.getNavButtonBackgroundWidth();this._timeAxisRatio=(this._canvasLength-2*i)/this._canvasLength,this._discreteOffset=(this.getContentLength()-this.getContentLength()*this._timeAxisRatio)/2,this._discreteContentLength=this.getContentLength()*this._timeAxisRatio}this.hasValidOptions()?(this.renderTimeZoomCanvas(this._canvas),this.applyAxisStyleValues(),this.updateSeries(),A._renderAxis(this,this._timeZoomCanvas),A._renderSeriesLabels(this),A._renderZoomControls(this),this.isDiscreteNavigationMode()&&(A._renderNavigationArrows(this,this._timeZoomCanvas),this.doInitialPan()),this._hasOverview&&A._renderOverview(this),(this.isTimeDirScrollbarOn()||this.isContentDirScrollbarOn())&&A._renderScrollbars(this)):A._renderEmptyText(this),this.Animation||this.RenderComplete()}HandleKeyDown(e){t.KeyboardEvent.RIGHT_ARROW!==e.keyCode&&t.KeyboardEvent.LEFT_ARROW!==e.keyCode&&t.KeyboardEvent.DOWN_ARROW!==e.keyCode&&t.KeyboardEvent.UP_ARROW!==e.keyCode||this.getEventManager()._isDndDragging||this.updateScrollForItemNavigation(this.EventManager.getFocus())}HandleMouseDown(e){e.target.getClassName()||(this._dragPanSeries=this._findSeries(e.target))}endDragPan(){this._dragPanSeries=null,this.endPan()}endPan(){this._triggerViewportChange&&(this._triggerViewportChange=!1,this.dispatchEvent(this.createViewportChangeEvent()))}panBy(e,t){var i,s=this._series.length,a=this.getTimeAxisVisibleSize(s);if(this._isVertical){if(this._dragPanSeries){var r=this._dragPanSeries.getTranslateX()-e;if(this._series.length>1&&(!this.isRTL()&&this._dragPanSeries._isInverted||this.isRTL()&&!this._dragPanSeries._isInverted))var n=a+2*this._dragPanSeries.Width-this._dragPanSeries._maxOverflowValue,o=this._dragPanSeries.Width+a;else this.isRTL()&&!this._dragPanSeries._isInverted?(n=this._dragPanSeries.Width-this._dragPanSeries._maxOverflowValue+a,o=a):(n=0,o=this._dragPanSeries._maxOverflowValue-this._dragPanSeries.Width);r<n?r=n:r>o&&(r=o),this._dragPanSeries.setTranslateX(r),this.isContentDirScrollbarOn()&&(this._series[0]===this._dragPanSeries?this.isRTL()?(i=2===s?this.getTimeAxisVisibleSize()+this._seriesSize-r:this.getTimeAxisVisibleSize()-r,this.contentDirScrollbar[0].setViewportRange(i,i+this._seriesSize)):this.contentDirScrollbar[0].setViewportRange(r,r+this._seriesSize):this.isRTL()?this.contentDirScrollbar[1].setViewportRange(r,r+this._seriesSize):(i=this.getTimeAxisVisibleSize()+this._seriesSize-r,this.contentDirScrollbar[1].setViewportRange(i,i+this._seriesSize)))}this.panZoomCanvasBy(t),this._hasOverview&&this._overview.setViewportRange(null,null,this._viewStartTime,this._viewEndTime),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),A._renderAxis(this,this._timeZoomCanvas,!0)}else if(this.isDiscreteNavigationMode()||(this.panZoomCanvasBy(e),this._hasOverview&&this._overview.setViewportRange(this._viewStartTime,this._viewEndTime,null,null),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),A._renderAxis(this,this._timeZoomCanvas,!0)),this._dragPanSeries){var l=this._dragPanSeries.getTranslateY()-t;if(this._dragPanSeries._isInverted)var h=a+2*this._dragPanSeries.Height-this._dragPanSeries._maxOverflowValue,_=this._dragPanSeries.Height+a;else h=0,_=this._dragPanSeries._maxOverflowValue-this._dragPanSeries.Height;l<h?l=h:l>_&&(l=_),this._dragPanSeries.setTranslateY(l),this.isContentDirScrollbarOn()&&(this._series[0]===this._dragPanSeries?this.contentDirScrollbar[0].setViewportRange(l,l+this._seriesSize):(i=this.getTimeAxisVisibleSize()+this._seriesSize-l,this.contentDirScrollbar[1].setViewportRange(i,i+this._seriesSize)))}}isDnDMoveEnabled(){var e=this.Options.dnd;return e&&"enabled"===e.move.items}isDnDResizeEnabled(){var e=this.Options.itemDefaults;return e&&"enabled"===e.resizable}isDndEnabled(){var e=this.isDnDMoveEnabled(),t=this.isDnDResizeEnabled();return this.getEventManager().isDndSupported()&&(e||t)}HandleEvent(e,i){var s,a,r,n,o,l,h,_,d,g=e.type;if("dvtSimpleScrollbar"===g)e=this.processScrollbarEvent(e,i);else if("selection"===g)this.dispatchEvent(e);else if("overview"===g){if("rangeChanging"===(n=e.subtype)||"rangeChange"===n){var c=this._viewEndTime-this._viewStartTime;this._isVertical?(this._viewStartTime=e.newY1,this._viewEndTime=e.newY2):(this._viewStartTime=e.newX1,this._viewEndTime=e.newX2);var m=this._viewEndTime-this._viewStartTime;if(m>0){r=this._canvasLength/m,this.setContentLength(r*(this._end-this._start)),this.setRelativeStartPos(r*(this._start-this._viewStartTime));var u=this._timeAxis.getZoomLevelLengths();if(c>m){for(a=u[(s=u.length)-1];this.getContentLength()>=a&&s>0;)a=u[--s-1];s===u.length&&s--,this._timeAxis.setZoomLevelOrder(s),this._timeAxis.setScale(this._timeAxis.getZoomOrder()[s])}else{for(a=u[s=0];this.getContentLength()<a&&s<u.length-1;)a=u[++s];this._timeAxis.setZoomLevelOrder(s),this._timeAxis.setScale(this._timeAxis.getZoomOrder()[s])}this.applyAxisStyleValues(),A._renderAxis(this,this._timeZoomCanvas,!0),this.updateSeries(),this.applyTimeZoomCanvasPosition()}"rangeChange"===n&&this.dispatchEvent(this.createViewportChangeEvent())}"scrollPos"!==n&&"scrollTime"!==n||(this._isVertical?(this._viewStartTime=e.newY1,this._viewEndTime=e.newY2):(this._viewStartTime=e.newX1,this._viewEndTime=e.newX2),r=this.getContentLength()/(this._end-this._start),this.setRelativeStartPos(r*(this._start-this._viewStartTime)),this.applyTimeZoomCanvasPosition(),A._renderAxis(this,this._timeZoomCanvas,!0),this.dispatchEvent(this.createViewportChangeEvent()))}else if("timeline"===g)if("selection"===(n=e.subtype)){var v=e.itemId,p=e.isMultiSelect&&"multiple"===this._selectionMode;for(o=0;o<this._series.length;o++)for(h=this._series[o],l=0;l<h._items.length;l++)if(_=h._items[l],t.Obj.compareValues(this.getCtx(),_.getId(),v)){this.EventManager.setFocusObj(_),this.updateScrollForItemSelection(_),this.SelectionHandler._addToSelection(_,p)&&this.EventManager.fireSelectionEvent(_);break}}else if("highlight"===n){for(d=e.itemId,o=0;o<this._series.length;o++)for(h=this._series[o],l=0;l<h._items.length;l++)if(_=h._items[l],t.Obj.compareValues(this.getCtx(),_.getId(),d)){_.showHoverEffect(!0);break}}else if("unhighlight"===n)for(d=e.itemId,o=0;o<this._series.length;o++)for(h=this._series[o],l=0;l<h._items.length;l++)if(_=h._items[l],t.Obj.compareValues(this.getCtx(),_.getId(),d)){_.hideHoverEffect(!0);break}}processScrollbarEvent(e,t){super.processScrollbarEvent(e,t),t===this.timeDirScrollbar&&A._renderAxis(this,this._timeZoomCanvas,!0);var i=e.newMin;t===this.contentDirScrollbar[0]?this.isVertical()?2===this._series.length?this._series[0].setTranslateX(this.isRTL()?this.getTimeAxisVisibleSize()+this._seriesSize-i:i):this._series[0].setTranslateX(this.isRTL()?this.getTimeAxisVisibleSize()-i:i):this._series[0].setTranslateY(i):t===this.contentDirScrollbar[1]&&(this.isVertical()?this._series[1].setTranslateX(this.isRTL()?i:this.getTimeAxisVisibleSize()+this._seriesSize-i):this._series[1].setTranslateY(this.getTimeAxisVisibleSize()+this._seriesSize-i))}discreteScrollIntoViewport(e){if(this.isDiscreteNavigationMode()){this._verticalScrollIntoViewPort(e);var t=e.getStartTime(),i=Math.floor((t-this._viewStartTime)/this._initialViewportTimeDuration);0!==i&&(this._discreteViewportCurrentIndexOffset+=i,this.handlePageChangeDiscreteViewport())}}_verticalScrollIntoViewPort(e){if(!this._isVertical){this._dragPanSeries=e._series;var t=e._displayable.getTranslateY(),i=t+e.getHeight(),s=this._series.length,a=this.getTimeAxisVisibleSize(s),r=this._dragPanSeries._isInverted?this._dragPanSeries.Height+a-this._dragPanSeries.getTranslateY():this._dragPanSeries._maxOverflowValue-(this._dragPanSeries.getTranslateY()+this._dragPanSeries.Height),n=r+this._dragPanSeries.Height;t<r?this.panBy(0,t-r):i>n&&this.panBy(0,i-n),this._dragPanSeries=null}}updateScrollForItemSelection(e){if(this.isDiscreteNavigationMode())this.discreteScrollIntoViewport(e);else{var t=this._viewEndTime-this._viewStartTime;this._viewStartTime=e.getStartTime()-t/2,this._viewStartTime<this._start?this._viewStartTime=this._start:this._viewStartTime+t>this._end&&(this._viewStartTime=this._end-t),this._viewEndTime=this._viewStartTime+t;var i=this.getContentLength()/(this._end-this._start);this.setRelativeStartPos(i*(this._start-this._viewStartTime)),this.applyTimeZoomCanvasPosition(),A._renderAxis(this,this._timeZoomCanvas),this.dispatchEvent(this.createViewportChangeEvent())}}updateScrollForItemNavigation(e){if(e instanceof h&&!this.getEventManager()._isDndDragging)if(this.isDiscreteNavigationMode())this.discreteScrollIntoViewport(e);else{var t=this._isVertical?e.getHeight():e.getWidth(),i=l.getItemHoverStrokeWidth(e._timeline.Options),s=e.getLoc()-(this._isVertical?t/2+i:l.getBubbleOffset(this)+i),a=this.getRelativeStartPos();this.isRTL()&&!this._isVertical&&(s-=i);var r=s+t+2*i,n=a-this._canvasLength;-s>a?a=-s:-r<n&&(a=-r+this._canvasLength);var o=this.getContentLength()/(this._end-this._start),_=this._viewEndTime-this._viewStartTime;this._viewStartTime=this._start-a/o,this._viewStartTime<this._start&&(this._viewStartTime=this._start,a=(this._start-this._viewStartTime)*o),this._viewEndTime=this._viewStartTime+_,this._viewEndTime>this._end&&(this._viewEndTime=this._end,this._viewStartTime=this._viewEndTime-_,a=(this._start-this._viewStartTime)*o),this.setRelativeStartPos(a),this.applyTimeZoomCanvasPosition(),this._verticalScrollIntoViewPort(e),this._hasOverview&&(this._isVertical?this._overview.setViewportRange(null,null,this._viewStartTime,this._viewEndTime):this._overview.setViewportRange(this._viewStartTime,this._viewEndTime,null,null)),this.isTimeDirScrollbarOn()&&this.timeDirScrollbar.setViewportRange(this._viewStartTime,this._viewEndTime),A._renderAxis(this,this._timeZoomCanvas),this.dispatchEvent(this.createViewportChangeEvent())}}isItemSelectionEnabled(){return"none"!==this._selectionMode}isFeelerEnabled(){return this.Options.itemDefaults&&"on"===this.Options.itemDefaults.feelers}applyInitialSelections(){if(this.Options.selection)for(var e=[],t=0;t<this._series.length;t++)for(var i=this._series[t],s=0;s<i._items.length;s++)e.push(i._items[s]);this.SelectionHandler.processInitialSelections(this.Options.selection,e)}_findSeries(e){if(this.hasValidOptions()&&e&&e!==this){var t=e.getId();return e===this._series[0]||this._series.length>1&&e===this._series[1]?e:t&&"_s0"===t.substring(t.length-3,t.length)?this._series[0]:t&&"_s1"===t.substring(t.length-3,t.length)?this._series[1]:this._findSeries(e.getParent())}return null}_findDrawable(e){if(e){var t=e.getId();if(t&&"_duration_"===t.substring(0,10)&&e._node)return e;var i=e.getParent();if(i){if(t&&"zoom"===t.substring(0,4))return e;if(t&&"_bubble_"===t.substring(0,8)&&i._node)return i;var s=i.getParent();if(s){if(t&&"_bubble_"===t.substring(0,8)&&s._node)return s;if((t=s.getId())&&"_bubble_"===t.substring(0,8)&&s.getParent())return s.getParent()}}}return null}getAutomation(){return this.Automation||(this.Automation=new _(this)),this.Automation}clearComponent(){this.getEventManager().RemoveListeners(this),super.clearComponent(),this.clearOverview()}clearOverview(){this._overviewCanvas&&(this.removeChild(this._overviewCanvas),this._overviewCanvas=null)}isTimeDirScrollbarOn(){return!this._hasOverview&&!this.isDiscreteNavigationMode()}isContentDirScrollbarOn(){return!0}isDiscreteNavigationMode(){return"discrete"===this._viewportNavigationMode&&"redwood"===this.getCtx().getThemeBehavior()&&!this.isVertical()}getBackgroundXOffset(){return this._backgroundX}setBackgroundXOffset(e){this._backgroundX=e}getDiscreteOffset(){return this._discreteOffset?this._discreteOffset:0}getDiscreteViewportDateOffsetPos(e){var t,i,s=this._discreteViewportStartIndex+e;if(s<0)for(t=this._discreteViewportDatePositions[0],i=this._discreteViewportDatePositions[1];s<0;){var a=this.getClosestDate(t-this._initialViewportTimeDuration);this._discreteViewportDatePositions.unshift(a),i=t,t=a,this._discreteViewportStartIndex++,s++}else if(s>this._discreteViewportDatePositions.length-2)for(t=this._discreteViewportDatePositions[this._discreteViewportDatePositions.length-2],i=this._discreteViewportDatePositions[this._discreteViewportDatePositions.length-1];s>this._discreteViewportDatePositions.length-2;){var r=this.getClosestDate(i+this._initialViewportTimeDuration);this._discreteViewportDatePositions.push(r),t=i,i=r}else t=this._discreteViewportDatePositions[s],i=this._discreteViewportDatePositions[s+1];return{startDate:t,endDate:i}}getClosestDate(e){var t=(e,t)=>{var i=this._timeAxis.adjustDate(e,t),s=this._timeAxis.getNextDate(i,t);return Date.parse(e-i>s-e?s:i)},i=t(e),s=t(e,this.Options.majorAxis.scale);if(null!=s)return Math.abs(e-i)>Math.abs(e-s)?s:i}getDiscreteViewportPanningLength(e,i){var s=this.getCtx(),a=t.Agent.isRightToLeft(s),r=this.getDatePos(e);return(this.getDatePos(i)-r)*(a?-1:1)}getDatePos(e){var t=this.isDiscreteNavigationMode()?this._discreteContentLength:this._contentLength;return s.TimeAxisUtils.getDatePosition(this._start,this._end,e,t)}getPosDate(e){var t=this.isDiscreteNavigationMode()?this._discreteContentLength:this._contentLength;return s.TimeAxisUtils.getPositionDate(this._start,this._end,e,t)}getDiscreteViewportDatePos(e){return s.TimeAxisUtils.getDatePosition(this._start,this._end,e,this._discreteContentLength)}getDiscreteViewportPosDate(e){return s.TimeAxisUtils.getPositionDate(this._start,this._end,e,this._discreteContentLength)}getDiscreteViewportStartDate(){var e=l.getNavButtonBackgroundWidth(),t=this.getDiscreteViewportDatePos(this._viewStartTime);return Math.max(this.getDiscreteViewportPosDate(t-e),this._start)}getDiscreteViewportEndDate(){var e=l.getNavButtonBackgroundWidth(),t=this.getDiscreteViewportDatePos(this._viewEndTime);return Math.min(this.getDiscreteViewportPosDate(t+e),this._end)}updateDiscreteViewport(){this.prepareViewportLength();var e=l.getNavButtonBackgroundWidth();this._timeAxisRatio=(this._canvasLength-2*e)/this._canvasLength,this._discreteOffset=(this.getContentLength()-this.getContentLength()*this._timeAxisRatio)/2,this._discreteContentLength=this.getContentLength()*this._timeAxisRatio,this.renderTimeZoomCanvas(this._canvas),this.updateSeries(),A._renderAxis(this,this._timeZoomCanvas),A._renderNavigationArrows(this,this._timeZoomCanvas),this.doInitialPan(),this._hasOverview&&A._renderOverview(this),(this.isTimeDirScrollbarOn()||this.isContentDirScrollbarOn())&&A._renderScrollbars(this)}handlePageChangeDiscreteViewport(){var e=this.getDiscreteViewportDateOffsetPos(this._discreteViewportCurrentIndexOffset);if(e.startDate>this._start&&e.endDate<this._end){var t=this.getDiscreteViewportPanningLength(this._viewStartTime,e.startDate);this.panZoomCanvasBy(t),this._viewStartTime=e.startDate,this._viewEndTime=e.endDate,this.updateDiscreteViewport(),this.dispatchEvent(this.createViewportChangeEvent())}}doInitialPan(){var e=this.getCtx(),i=t.Agent.isRightToLeft(e),s=this._viewStartTime,a=this._viewEndTime,r=this.getDiscreteViewportStartDate(),n=this.getDiscreteViewportPanningLength(this._start,r);if(i){var o=l.getNavButtonBackgroundWidth(),h=this.getDatePos(this._viewEndTime),_=this.getPosDate(h+o);n=this._discreteContentLength+this.getDiscreteViewportPanningLength(this._start,_)}var d=n+this.getDiscreteOffset()+this._startPos;this.panZoomCanvasBy(d),this._viewStartTime=s,this._viewEndTime=a}startPanAllowed(){return this.getDiscreteViewportDateOffsetPos(this._discreteViewportCurrentIndexOffset-1).startDate>this._start}endPanAllowed(){return this.getDiscreteViewportDateOffsetPos(this._discreteViewportCurrentIndexOffset+1).endDate<this._end}}e.Timeline=P,e.TimelineOverview=O,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojtimeline-toolkit.js.map