/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["ojs/ojcore","jquery","ojs/ojcomponentcore","ojs/ojdomutils","ojs/ojconveyorbelt","ojs/ojmenu","jqueryui-amd/widgets/sortable","ojs/ojtouchproxy"],function(e,t,i,s){"use strict";
/**
 * @preserve Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */!function(){var a="oj-tabs-close-icon",n="ojtabs-id_";const r="oj-disabled",o="aria-selected",l=".oj-tabs-selected",h="oj-selected",d="aria-expanded",c="aria-hidden",u="oj-first-child-selected",b="oj-tabs-conveyorbelt-wrapper",f=".oj-tabs-facet",v="oj-tabs-tab",_="oj-tabs-tab-content",m="data-content",p="aria-labelledby",g="> :first-child",j=".oj-tabs-nav-root",T="aria-controls",C="aria-disabled",x="oj-tabs-gen-a",y="oj-conveyorbelt",I="oj-tabs-panel",w=".oj-tabs-title",A="oj-tabs-close";var E={cut:"ojtabscut","paste-before":"ojtabspastebefore","paste-after":"ojtabspasteafter",remove:"ojtabsremove"},S={cut:"labelCut","paste-before":"labelPasteBefore","paste-after":"labelPasteAfter",remove:"labelRemove"};e.__registerWidget("oj.ojTabs",t.oj.baseComponent,{widgetEventPrefix:"oj",delay:300,options:{selected:0,disabledTabs:null,truncation:"auto",selectOn:"click",orientation:"horizontal",edge:"top",removable:!1,reorderable:!1,beforeSelect:null,select:null,beforeDeselect:null,deselect:null,beforeRemove:null,remove:null,beforeReorder:null,reorder:null},_ComponentCreate:function(){var e=this.options;this._super(),this.running=!1,this._initialRender=!0,this._setupEdge(e.edge),this._isOldMarkup=0===this.element.children("ul").length,this._createTabbarFromOldMarkup(),this._processTabs(),this._menu={},this._menu.usermenu=!1,this._menu.$menuItems=[],this._menu.$container=null,this._menu.$elemPasteBefore=null,this._menu.$elemPasteAfter=null,this._initMenu(),this._refresh();var t=this._getIndexByTabOrContentId(e.selected);void 0===t&&(t=0),this._fireSelectEvents(t),this._initialRender=void 0},_fireSelectEvents:function(e,i){var s=e;this._isTabDisabled(s)&&(s=this._getNextEnabledTab(s)),this._activate(void 0===s?void 0:t(this.tabs[s]),i)},_NotifyContextMenuGesture:function(e,i,s){if(this._isInATab(i.target)&&(!this._touchProxy||!this._touchProxy.touchMoved())){var a="keyboard"===s;if("contextmenu"!==i.type&&!a&&"touch"!==s)return;var n=t(i.target).closest("li"),o={launcher:n};if(this._menu.tab=a?this.active:o.launcher,!this._menu.tab)return void i.preventDefault();if(this._menu.$elemRemove){var l=n.hasClass(r);if((l||0===this._getCloseIcons(n).length)&&1===this._menu.$container.children().length)return void i.preventDefault();l||!this._isTabRemovable(n)?this._menu.$elemRemove.addClass(r):this._menu.$elemRemove.removeClass(r)}if(this._menu.$elemPasteBefore||this._menu.$elemPasteAfter){var h=!this._menu.cutTab;this._menu.$elemPasteBefore.hasClass(r)!==h&&(h?(this._menu.$elemPasteBefore.addClass(r),this._menu.$elemPasteAfter.addClass(r)):(this._menu.$elemPasteBefore.removeClass(r),this._menu.$elemPasteAfter.removeClass(r)),this._menu.$container.ojMenu("refresh"))}this._OpenContextMenu(i,s,o)}},_tabKeydown:function(e){if(!this._handlePageNav(e)){var i=t(this.document[0].activeElement).closest("li"),s=this._getEnabledTabs(),a=s.index(i),n=s.length;switch(e.keyCode){case t.ui.keyCode.RIGHT:case t.ui.keyCode.DOWN:a=(a+1)%n;break;case t.ui.keyCode.UP:case t.ui.keyCode.LEFT:a=((0===a?n:a)-1)%n;break;case t.ui.keyCode.END:a=n-1;break;case t.ui.keyCode.HOME:a=0;break;case 46:var r=this.active;return void(r&&this._getCloseIcons(r).length>0&&(e.preventDefault(),this._removeTab(r,null,e)));default:return}e.preventDefault(),clearTimeout(this.activating);var l=t(s[a]);if(l.focus(),!e.ctrlKey){i.attr(o,"false"),l.attr(o,"true");var h=this;this.activating=this._delay(function(){h&&h.tabs&&h._activate(l,e)},this.delay)}}},_panelKeydown:function(e){t(e.target).closest(l).attr("id")===this.element.children(l).attr("id")&&(this._handlePageNav(e)||e.ctrlKey&&e.keyCode===t.ui.keyCode.UP&&(e.preventDefault(),this.active.focus()))},_handlePageNav:function(e){var i=this._getSelectedIndex();return e.ctrlKey&&e.keyCode===t.ui.keyCode.PAGE_UP?(this._activate(this._focusNextTab(i,!1)),!0):!(!e.ctrlKey||e.keyCode!==t.ui.keyCode.PAGE_DOWN)&&(this._activate(this._focusNextTab(i,!0)),!0)},_isTabDisabled:function(e){return e>=0&&e<this.tabs.length&&t(this.tabs[e]).hasClass(r)},_focusNextTab:function(e,i){var s=this._getEnabledTabs(),a=s.index(this.tabs[e]),n=s.length,r=t(s[a=i?(a+1)%n:((0===a?n:a)-1)%n]);return r.focus(),r},_getNextEnabledTab:function(e){for(var t=e+1,i=this.tabs.length-1;t<=i;){if(!this._isTabDisabled(t))return t;t+=1}for(t=e-1;t>=0;){if(!this._isTabDisabled(t))return t;t-=1}},_isHorizontal:function(){return"top"===this.options.edge||"bottom"===this.options.edge},_setOption:function(e,t,i){var s=t;if("selected"!==e){if("disabledTabs"!==e)if("removable"!==e&&"truncation"!==e)if("reorderable"!==e){if("orientation"!==e)if("edge"!==e){if("selectOn"===e)return this._tearDownEvents(!0),this._super(e,s,i),void this._setupEvents();"contextMenu"===e&&(this._clearMenu(),s&&this._initMenu(s)),this._super(e,s,i),"translations"===e&&i&&"removeCueText"===i.subkey&&this.tablist&&this._getCloseIcons(this.tablist).attr("aria-label",s?s.removeCueText:"")}else this._setupEdge(s)&&(this._edgeSpecified=!0,this._super(e,s,i),this.refresh());else if(!this._edgeSpecified){var a=this._orientationToEdge(s);a&&this._setupEdge(a)&&this.refresh()}}else s!==this.options.reorderable&&(this._super(e,s,i),this.refresh());else s!==this.options[e]&&(this._super(e,s,i),this.refresh());else if(null===s&&(s=[]),Array.isArray(s)){this._setOjDisabledOnTab(s);var n=this._getSelectedIndex();this._isTabDisabled(n)&&this._fireSelectEvents(n),this.refresh()}}else{if(void 0===(s=this._getTab(s)))return;this._activate(s)}},refresh:function(){if(this._super(),this._processTabs(),this._refresh(),!this.element.children(l).length){var e=this._getNextEnabledTab(-1);e>=0&&this._fireSelectEvents(e)}},_refresh:function(){var e=this.element.children(l);e.length?this.active=this.tablist.children(".oj-selected"):this.active=t(),this._createCloseIcons(),this._setupEvents(),this.tabs.not(this.active).attr({"aria-selected":"false",tabIndex:"-1"}),this.panels.not(this._getPanelForTab(this.active)).hide().attr({"aria-expanded":"false","aria-hidden":"true"}),this.active.length?(this.active.addClass(h).attr({"aria-selected":"true",tabIndex:"0"}),e.show().attr(d,"true").removeAttr(c)):t(this.tabs[0]).attr("tabIndex","0"),this._isHorizontal()&&(this.tabs.length>0?(this._truncateBeforeOverflow(),this._addConveyor()):this._getTabbarWrapper(),this._addFacets()),void 0===this.options.selected||0===this._getSelectedIndex()?this.element.addClass(u):this.element.removeClass(u),this._setupReorder()},_addConveyor:function(){var e=this.tablist.uniqueId().attr("id"),t=this._getTabbarWrapper().parent();this.conveyor=t.ojConveyorBelt({orientation:"horizontal",contentParent:"#"+e}).attr("data-oj-internal","");var i=this.conveyor.parent();if(i.hasClass(b)){var s="0 1 "+this._getConveyorWrapperMaxWidth()+"px";i.css("flex",s),i.css("-webkit-flex",s),i.css("-ms-flex",s)}},_processTabs:function(){var e=this,i=this.options.edge;this._destroyTabBar(),this._createTabbar(),this.tablist=this.element.children("ul").addClass("oj-tabs-nav oj-helper-clearfix").attr("role","tablist");var s,a,n=this.tablist.index();this.element.children(f).each(function(){var e=t(this);e.index()<n?(e.addClass("oj-start"),s=e):(a||(a=e),e.removeClass("oj-start"))}),"start"===i||"top"===i?s&&s.length>0?s.after(this.tablist):this.element.prepend(this.tablist):a&&a.length>0?a.before(this.tablist):this.element.append(this.tablist),this.tabs=t(),this.panels=t(),this.tablist.children("li").each(function(){var i=t(this).addClass(v).attr({role:"tab",tabIndex:"-1"}).removeAttr(c),s=i.children();s.addClass(_);var a=s.children();a.addClass("oj-tabs-anchor").attr({role:"presentation",tabIndex:"-1"}),a.children().addClass("oj-tabs-title").removeAttr(c),e.tabs=e.tabs.add(i);var n=a.uniqueId().attr("id"),r=i.attr(m),o=e.element.find(e._sanitizeIdSelector(r));i.attr({"aria-controls":r,"aria-labelledby":n}),e.panels=e.panels.add(o),o.attr(p,n).attr("role","tabpanel")}),"start"!==i&&"end"!==i||e.tablist.addClass("oj-tabs-nav-root"),this._initialRender&&this._setOjDisabledOnTab(this.options.disabledTabs)},_setupEvents:function(){var e=this,i={keydown:this._tabKeydown},a=this.options.selectOn,n=!1;a&&t.each(a.split(" "),function(t,a){"click"===a&&(n=!0),s.isValidIdentifier(a)&&(i[a]=e._eventHandler)});var r=this._getEnabledTabs();if(this._on(r,i),n||this._on(r,{click:function(e){e.preventDefault()}}),this.panels.on("keydown"+this.eventNamespace,this._panelKeydown.bind(this)),this.options.removable){var o={click:this._removeTabHandler},l=this._getCloseIcons(r);this._on(l,o),this._AddHoverable(l),this._AddActiveable(l)}this._focusable({element:r,applyHighlight:!0}),this._AddHoverable(r),this._AddActiveable({element:r,afterToggle:function(e){"mousedown"===e&&r.filter(".oj-focus-highlight").blur()}})},_tearDownEvents:function(e){var t=this._getEnabledTabs();e||this._UnregisterChildNode(this._getCloseIcons(t)),this._UnregisterChildNode(t),this.panels&&this.panels.off("keydown"+this.eventNamespace)},_eventHandler:function(e,i){var s=this.active,a=t(e.currentTarget).closest("li"),n=s&&a[0]===s[0],o=this._getPanelForTab(a),l=s&&s.length?this._getPanelForTab(s):t(),h={fromTab:s,fromContent:l,toTab:a,toContent:o};e.preventDefault();var d=i||e;a.hasClass(r)||this.running||n||l&&l.length&&!1===this._trigger("beforeDeselect",d,h)||!this._initialRender&&!1===this._trigger("beforeSelect",d,h)||(this._initialRender?this.options.selected=this._getTabIdOrIndex(a):this.option("selected",this._getTabIdOrIndex(a),{_context:{originalEvent:d,internalSet:!0}}),this.active=a,o.addClass("oj-tabs-selected"),l&&l.length&&l.removeClass("oj-tabs-selected"),this._toggle(d,h))},_toggle:function(e,s){var a=this,n=s.toTab.closest("li"),r=s.toContent,l=s.fromContent;this.running=!0;var b=s.fromTab.closest("li").removeClass(h);l.hide(),l.length>0&&i.subtreeHidden(l[0]),n.addClass(h),a._isHorizontal()&&a.tabs.length>0&&(0===n.index()?a.element.addClass(u):a.element.removeClass(u)),r.show(),r.length>0&&i.subtreeShown(r[0],{initialRender:a._initialRender}),a.running=!1,a._initialRender||(a._trigger("deselect",e,s),a._trigger("select",e,s)),l.attr({"aria-expanded":"false","aria-hidden":"true"}),b.attr(o,"false"),r.length&&l.length?b.attr("tabIndex","-1"):r.length&&this.tabs.filter(function(){return"0"===t(this).attr("tabIndex")}).attr("tabIndex","-1"),r.attr(d,"true").removeAttr(c),n.attr({"aria-selected":"true",tabIndex:"0"})},_activate:function(e,i){var s;void 0!==e&&(this.active&&e[0]===this.active[0]||(s=e.find(".oj-tabs-anchor")[0],this._eventHandler({target:s,currentTarget:s,preventDefault:t.noop},i)))},_createCloseIcons:function(){if(this.options.removable&&this._isHorizontal()){var e=this.getTranslatedString("removeCueText"),i=this;this._getEnabledTabs().each(function(s){if(i._isTabRemovable(t(this))){var r=t(this).find(g);r.addClass("oj-removable");var o=n+"rm_"+s;t(this).attr("aria-describedby",o),t("<a href='#'>").addClass("oj-tabs-icon oj-component-icon oj-clickable-icon-nocontext "+a).attr({id:o,tabIndex:"-1","aria-label":e,role:"presentation"}).appendTo(r)}})}},_getEnabledTabs:function(){return t(this.tabs.not(".oj-disabled"))},_getCloseIcons:function(e){return e.find("."+a)},_destroyTabBar:function(){this.tabs&&this._tearDownEvents(),this._hasResizeListener&&(s.removeResizeListener(this.element[0],this._resizeHandler),this._hasResizeListener=!1,this._originalWidth=void 0),this._sortable&&(s.isTouchSupported()&&this._tearDownTouchReorder(),this.tablist.sortable("instance")&&this.tablist.sortable("destroy"),this._sortable=void 0);var e=this.element.children(j),i=!e.hasClass("oj-tabs-nav");if(this.tabs&&(this._getCloseIcons(this.tabs).remove(),e.length)){var a=e,n=!0,r=this.tablist;e.children().each(function(){var e=t(this);if(e.hasClass(b))e=r;else if(!e.hasClass("oj-tabs-facet"))return;n=!1,a.after(e),a=e}),n&&i&&e.after(r)}this.conveyor&&(this.conveyor.ojConveyorBelt("destroy"),this.conveyor.remove(),this.conveyor=null,this.active=null),i&&e.remove(),this.tabs=null,this.tablist=null},_destroy:function(){this._clearMenu(),!this._isHorizontal()?this.element.removeClass("oj-tabs oj-component oj-tabs-vertical oj-tabs-start oj-tabs-end oj-helper-clearfix"):this.element.removeClass("oj-tabs oj-component oj-tabs-horizontal oj-tabs-top oj-tabs-bottom oj-first-child-selected");var e,i,s,a,n=this;this.tabs.each(function(r){(e=t(this)).removeAttr("tabIndex").removeAttr(o).removeAttr(p).removeAttr(c).removeAttr(T).removeAttr(C).removeAttr("aria-describedby").removeAttr("role").removeAttr(m).removeClass("oj-active oj-disabled oj-selected oj-tabs-gen-id oj-tabs-tab").removeUniqueId().css("display",""),i=e.children("div").removeClass(_),s=i.children("a").removeClass("oj-tabs-anchor").removeAttr("tabIndex").removeAttr("role"),(a=s.children()).removeClass("oj-tabs-title").removeAttr(c),n._isOldMarkup?a.prependTo(n.panels.get(r)):i.hasClass("oj-tabs-gen-div")&&s.hasClass(x)?(a.prependTo(e),i.remove()):s.hasClass(x)?(a.prependTo(i),s.remove()):i.hasClass("oj-tabs-gen-div")&&(s.prependTo(e),i.remove())});var r=this.tablist;this._destroyTabBar(),r.removeAttr("tabIndex").removeAttr("role").removeClass("oj-tabs-nav oj-tabs-nav-root oj-helper-clearfix").removeUniqueId(),this._isOldMarkup&&r.remove(),this.panels.each(function(){t(this).removeAttr("tabIndex").removeAttr(d).removeAttr(o).removeAttr(p).removeAttr(c).removeAttr("role").removeClass("oj-active oj-tabs-selected oj-tabs-gen-id oj-tabs-panel").removeUniqueId().css("display","")}),this.element.children(f).removeClass("oj-start")},_isTabRemovable:function(e){var t=this.options.removable;return t&&(!Array.isArray(t)||t.indexOf(e.attr("id"))>-1)},_removeTab:function(e,i,s){if(this._isTabRemovable(e)){var a=this._getPanelForTab(e),n={tab:e,content:a},r=s||i?i:{target:e,currentTarget:e,preventDefault:t.noop};if(e&&!1!==this._trigger("beforeRemove",r,n)){if(i&&i.preventDefault(),e.hasClass(h)){var o=this.tabs.index(e),l=this._getNextEnabledTab(o);if(void 0===l)this.active=void 0,this.option("selected",void 0,{_context:{originalEvent:r,internalSet:!0}});else{this._fireSelectEvents(l,r);var d=this._getTabIdOrIndex(t(this.tabs[l]));"number"==typeof d&&d>o&&(d-=1),this.option("selected",d,{_context:{originalEvent:r,internalSet:!0}})}}this._tearDownEvents(),this.tabs=this.tabs.not(e),e.remove(),a.remove(),this._updateDisabledTabs(),this.refresh(),this._trigger("remove",r,n)}}},_removeTabHandler:function(e,i){this._removeTab(t(e.currentTarget).closest("li"),e,i)},removeTab:function(e){if("string"!=typeof e)throw new Error("'"+e+"' is not a tab id");this._removeTab(this._getTab(e),null,null)},_wrapLi:function(e,t){var i;if("li"===e.prop("tagName").toLowerCase()){var s=(i=e).children("div");if(1===s.length&&s.hasClass(_)){var a=s.children("a");1!==a.length&&(i.wrapInner("<a href='#'></a>"),a.addClass(x))}else(s=i.wrapInner("<div><a href='#'></a></div>").children()).addClass("oj-tabs-gen-div oj-tabs-tab-content"),s.children().addClass(x)}else(i=e.wrap("<li><div><a href='#'></a></div></li>").parent().parent().parent()).addClass("oj-tabs-gen-li"),i.children().addClass("oj-tabs-gen-div oj-tabs-tab-content");return t&&i.attr(m,t),i},addTab:function(e){var i,s,a=-1;e.tab&&e.content?(s=e.content,i=this._wrapLi(e.tab,this._getUniqueId(s)),void 0!==e.index&&(a=e.index)):(s=e,i=this._wrapLi(t(e).find(g),this._getUniqueId(s)));var n,r=this.element.children(j),o=!1;if((n=r.hasClass("oj-tabs-nav")?r:r.length?r.find(".oj-tabs-nav"):this.element.children(".oj-tabs-nav")).length||(n=t("<ul>"),o=!0),o&&n.prependTo(this.element),a>=0&&a<n.children().length){var l=n.children(":eq("+a+")"),h=this.element.children(this._sanitizeIdSelector(l.attr(T)));l.before(i),h.before(s)}else i.appendTo(n),s.appendTo(this.element);this.refresh(),0===this.active.length&&this._fireSelectEvents(0),i[0].scrollIntoView(!1)},_setupTouchReorder:function(){this._touchProxy=e._TouchProxy.addTouchListeners(this.tablist)},_tearDownTouchReorder:function(){e._TouchProxy.removeTouchListeners(this.tablist)},_setupReorder:function(){if(this.options.reorderable){var e=this;s.isTouchSupported()&&this._setupTouchReorder(),this.tablist.sortable({axis:e._isHorizontal()?"x":"y",distance:10,start:function(){e.tablist.children(".ui-sortable-placeholder").each(function(){t(this).addClass("oj-sortable-placeholder")})},stop:function(t,i){var s=i.item;e._doReorder(t,s,s.prev())||e.tablist.sortable("cancel")}}),this._sortable=!0}else this._tearDownTouchReorder(),this._sortable=!1},_InitOptions:function(e,t){var i=t.edge;this._edgeSpecified="top"===i||"bottom"===i||"start"===i||"end"===i,this._super(e,t)},_orientationToEdge:function(e){return"horizontal"===e?"top":"vertical"===e?"start":null},_setupEdge:function(e){var t=e;(this._initialRender&&!this._edgeSpecified||!t)&&(t=this._orientationToEdge(this.options.orientation));var i=this.options.edge;switch(this.element.removeClass("oj-tabs-top oj-tabs-bottom oj-tabs-start oj-tabs-end"),t){case"top":case"bottom":!this.panels||"start"!==i&&"end"!==i||this.element.removeClass("oj-tabs-vertical oj-helper-clearfix"),this.element.addClass("oj-tabs oj-component oj-tabs-horizontal"),"bottom"===t?this.element.addClass("oj-tabs-bottom"):this.element.addClass("oj-tabs-top"),this._initialRender?this.options.orientation="horizontal":"horizontal"!==this.options.orientation&&this.option("orientation","horizontal",{_context:{internalSet:!0},changed:!0});break;case"start":case"end":!this.panels||"top"!==i&&"bottom"!==i||this.element.removeClass("oj-tabs-horizontal"),this.element.addClass("oj-tabs oj-component oj-tabs-vertical oj-helper-clearfix"),"end"===t?this.element.addClass("oj-tabs-end"):this.element.addClass("oj-tabs-start"),this._initialRender?this.options.orientation="vertical":"vertical"!==this.options.orientation&&this.option("orientation","vertical",{_context:{internalSet:!0},changed:!0});break;default:return!1}return this._initialRender?this.options.edge=t:this.options.edge!==t&&this.option("edge",t,{_context:{internalSet:!0},changed:!0}),!0},_getTabbarWrapper:function(){var e=this.tablist.parent();e.hasClass("oj-tabs-conveyor")||(e=this.tablist.wrap("<div>").parent().addClass("oj-tabs-conveyor"),(this.element.children(f).length>0?e.wrap("<div>").wrap("<div>").parent().parent().addClass(b):e).wrap("<div>").parent().addClass("oj-tabs-nav-root").uniqueId().attr("id"));return e},_addPrefixId:function(e){e.id.indexOf(n)<0&&t(e).attr("id",n+e.id)},getNodeBySubId:function(e){if(null==e)return this.element?this.element[0]:null;var i=e.subId,s=e.index;if(i!==y&&("number"!=typeof s||s<0||s>=this.panels.length))return null;switch(i){case"oj-conveyorbelt":return this.conveyor?this.conveyor[0]:null;case"oj-tabs-panel":return this._getPanelForTab(this.tabs[s])[0];case"oj-tabs-tab":return this.tabs[s];case"oj-tabs-title":return t(this.tabs[s]).find(w)[0];case"oj-tabs-close-icon":case"oj-tabs-close":return t(this.tabs[s]).find(".oj-tabs-close-icon")[0]}return null},getSubIdByNode:function(e){for(var t=[],i=0;i<this.tabs.length;i++)t.push(this._getPanelForTab(this.tabs[i])[0]);for(var s=-1,a=-1,n=e;n;){if(this.conveyor&&n===this.conveyor[0])return{subId:y};if(-1!==(s=Array.prototype.indexOf.call(this.tabs,n)))break;if(-1!==(a=t.indexOf(n)))return{subId:I,index:a};n=n.parentElement}if(-1!==s){var r=this.getNodeBySubId({subId:"oj-tabs-title",index:s}),o=this.getNodeBySubId({subId:A,index:s});for(n=e;n;){if(n===r)return{subId:"oj-tabs-title",index:s};if(n===o)return{subId:A,index:s};if(n===this.tabs[s])return{subId:v,index:s};n=n.parentElement}}return null},_getConveyorWrapperMaxWidth:function(){return this._originalWidth+10},_getTabsWidth:function(){var e=this.element.find(".oj-tabs-conveyorbelt-wrapper");return e.length?e[0].clientWidth:this.element[0].clientWidth},_isOverflow:function(){return this._originalWidth>this._getTabsWidth()},_getTabMaxWidth:function(){var e=Math.floor(this._getTabsWidth()/this.tabs.length);return this.options.removable&&(e-=28),e},_applyTabMaxWidth:function(){var e=this._getTabMaxWidth();this.tablist.find(w).each(function(){t(this).css("max-width",e+"px").addClass("oj-tabs-title-overflow")})},_removeTabMaxWidth:function(){this.tablist.find(w).each(function(){t(this).css("max-width","").removeClass("oj-tabs-title-overflow")})},_logMessage:function(){},_handleResize:function(){this._isProgressive()&&(this._isOverflow()?this._applyTabMaxWidth():this._removeTabMaxWidth())},_isProgressive:function(){return"auto"===this.options.truncation||"progressive"===this.options.truncation},_truncateBeforeOverflow:function(){this._isHorizontal()&&this.tabs.length>0&&(null==this._resizeHandler&&(this._resizeHandler=this._handleResize.bind(this)),s.addResizeListener(this.element[0],this._resizeHandler),this._hasResizeListener=!0,this._originalWidth=this._getTabbarWrapper()[0].scrollWidth,this._isProgressive()&&this._isOverflow()&&this._applyTabMaxWidth())},_NotifyShown:function(){this._super(),this.refresh()},_NotifyAttached:function(){this._super(),this.refresh()},_buildContextMenuItem:function(e){return t("<a>").text(this.getTranslatedString(S[e])).attr("href","#").wrap("<li>").parent().attr("id",E[e]).addClass("oj-menu-item")},_menu_cut:function(e){return!(!e||!e.length)&&(this._menu.cutTab=e,!0)},_menu_paste:function(e,t,i){if(!t||!t.length)return!1;if(!this._menu.cutTab)return!1;var s=this._menu.cutTab;return this._menu.cutTab=!1,this._doReorder(e,s,t,i),!0},_menu_remove:function(e,t){return!(!t||!t.length)&&(this._removeTab(t,null,e),!0)},_handleContextMenuSelect:function(e,t){var i=t?t.item.attr("id"):void 0;"ojtabscut"===i?this._menu_cut(this._menu.tab):"ojtabspastebefore"===i?this._menu_paste(e,this._menu.tab,!0):"ojtabspasteafter"===i?this._menu_paste(e,this._menu.tab,!1):"ojtabsremove"===i&&this._menu_remove(e,this._menu.tab)},_initMenu:function(e){var i=e||this.options.contextMenu;if(i){var s=t.type(i);if("function"===s){try{i=i()}catch(e){i=null}s=t.type(i)}if(i)t(i).length&&(this.options.contextMenu=i)}this._menu.usermenu=!!i,this._addContextMenu()},_addIfNotExist:function(e,t,i){if(-1===t.indexOf(i)){var s=this._buildContextMenuItem(i);e.append(s),this._menu.$menuItems.push(s)}},_addContextMenu:function(){var e=t(this.options.contextMenu);if(0!==e.length||this.options.reorderable||this.options.removable){var i=this;if(0===e.length){var s=this.options.reorderable?"labelReorder":S.remove,a=this.element.uniqueId().attr("id")+"contextmenu";(e=t("<ul>")).css("display","none").attr("id",a).attr("aria-label",this.getTranslatedString(s)),t(document.body).append(e),e.ojMenu(),this.options.contextMenu=this._sanitizeIdSelector(a)}var n=[];e.find("[data-oj-command]").each(function(){if(0===t(this).children("a").length){var e=t(this).attr("data-oj-command").slice("oj-tabs-".length);t(this).replaceWith(i._buildContextMenuItem(e)),t(this).addClass("oj-menu-item"),n.push(e)}}),this.options.reorderable&&(this._addIfNotExist(e,n,"cut"),this._addIfNotExist(e,n,"paste-before"),this._addIfNotExist(e,n,"paste-after"),this._menu.$elemPasteBefore=e.find("#ojtabspastebefore"),this._menu.$elemPasteAfter=e.find("#ojtabspasteafter")),this.options.removable&&(this._addIfNotExist(e,n,"remove"),this._menu.$elemRemove=e.find("#ojtabsremove")),this._menu.$container=e,e.ojMenu("refresh"),e.on("ojselect",t.proxy(this._handleContextMenuSelect,this))}},_clearMenu:function(){var e=this._menu;if(e&&e.$container){if(e.$container.off("ojselect"),e.usermenu||(e.$container.ojMenu("destroy"),e.$container.remove()),e.$menuItems)for(;e.$menuItems.length>0;)e.$menuItems.pop().remove();e.$container=null}e.$elemPasteBefore=null,e.$elemPasteAfter=null,e.$elemRemove=null},_doReorder:function(e,t,i,s){var a=this._getPanelForTab(t),n={tab:t,content:a};if(!1===this._trigger("beforeReorder",e,n))return!1;var r=this.tabs.index(t);if(i.length){if(this.tabs.index(i)===r)return!0;var o=this._getPanelForTab(i);s?(i.before(t),o.before(a)):(i.after(t),o.after(a))}else if(this.tabs.length>0){if(0===r)return!0;this.tabs.first().before(t),this.panels.first().before(a)}return this._updateDisabledTabs(),this.refresh(),i.blur(),t.focus(),this._trigger("reorder",e,n),!0},_sanitizeSelector:function(e){return e?e.replace(/[#!\"$%&'()*+,./:;<=>?@\[\]^`{|}~]/g,"\\$&"):""},_sanitizeIdSelector:function(e){return e?"#"+this._sanitizeSelector(e):""},_getPanelForTab:function(e){return this.element.find(this._sanitizeIdSelector(t(e).attr(T)))},_getUniqueId:function(e){var t=e.attr("id");return t||(t=e.uniqueId().attr("id"),e.addClass("oj-tabs-gen-id")),t},_getTab:function(e){var i=this._getIndexByTabOrContentId(e);if(-1!==i)return t(this.tabs[i])},_getIndexByTabOrContentId:function(e){var t=-1;if("number"==typeof e)e>=0&&e<this.tabs.length&&(t=e);else if("string"==typeof e){var i=this._sanitizeSelector(e);if(s.isValidIdentifier(i)){var a=this.element.find(this._sanitizeIdSelector(i));a.length&&-1===(t=this.tabs.index(a))&&(t=this.panels.index(a))}}return t},_getSelectedIndex:function(){var e=this.options.selected;return"number"==typeof e?e:this.tabs.index(t(this._sanitizeIdSelector(e)))},_getTabIdOrIndex:function(e){if(e)return e.attr("id")||this.tabs.index(e)},_setOjDisabledOnTab:function(e){var t=(this.tablist?this.tablist:this.element.children("ul")).children("li");t.removeClass(r).removeAttr(C);var i=[];if(e&&e.length>0)for(var s,a,n=0;n<e.length;n++)(a=this._getTab(e[n]))&&(a.addClass(r),a.attr(C,"true"),a.find(".oj-tabs-anchor").removeAttr("href"),s=a.attr("id"),i.push(s||t.index(a)));this._updateDisabledTabs(i)},_updateDisabledTabs:function(i){var s=i;if(!s){s=[];var a=this;this.tablist.children().each(function(){var e=t(this);e.hasClass(r)&&s.push(a._getTabIdOrIndex(e))})}if(!e.Object._compareArrayIdIndexObject(s,this.options.disabledTabs))if(this._initialRender)this.options.disabledTabs=s;else{this.option({disabledTabs:s},{_context:{internalSet:!0,writeback:!0},changed:!0})}},_isInATab:function(e){var i=!1;return this.tabs.each(function(){return this!==e&&!t.contains(this,e)||(i=!0,!1)}),i},_createTabbar:function(){var e=this._getContentIds(),i=this,s=this.element.children("ul");s.length>0&&s.children("li").each(function(s){i._wrapLi(t(this),e[s])})},_createTabbarFromOldMarkup:function(){var e=this.element.children("ul");if(0===e.length){var i=this,s=this._getContentIds();e=t("<ul>"),this.element.children().each(function(a){i._wrapLi(t(this).find(g),s[a]).appendTo(e)}),e.prependTo(this.element)}},_addFacets:function(){var e=this.element.children(j),i=this,s=e.children(".oj-tabs-conveyorbelt-wrapper");this.element.children(f).each(function(){var a=t(this),n=i._getUniqueId(a);0===e.find(i._sanitizeIdSelector(n)).length&&(a.hasClass("oj-start")?s.before(a):a.appendTo(e))})},_getContentIds:function(){var e=[],i=this;return this.element.children(":not(ul):not(.oj-tabs-facet)").each(function(){var s=t(this);s.addClass(I),e.push(i._getUniqueId(s))}),e}})}()});
//# sourceMappingURL=ojtabs.js.map