/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["ojs/ojcore","ojs/ojeditablevalue","jqueryui-amd/widgets/draggable","ojs/ojtouchproxy","ojs/ojcore-base","jquery","ojs/ojtranslation","ojs/ojdomutils"],function(t,e,i,s,a,n,r,l){"use strict";a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a,n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n,function(){var t={properties:{readonly:{binding:{consume:{name:"readonly"}}},userAssistanceDensity:{binding:{consume:{name:"userAssistanceDensity"}}},labelEdge:{binding:{consume:{name:"labelEdge"}}}}},e={properties:{describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string"},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string"},validatorHint:{type:"Array<string>|string"}}},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},labelEdge:{type:"string",enumValues:["inside","none","provided"]},labelHint:{type:"string",value:""},labelledBy:{type:"string"},max:{type:"number",value:100},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},min:{type:"number",value:0},orientation:{type:"string",enumValues:["horizontal","vertical"],value:"horizontal"},step:{type:"number",value:1},transientValue:{type:"number",writeback:!0,readOnly:!0},translations:{type:"object",value:{},properties:{invalidStep:{type:"string"},maxMin:{type:"string"},noValue:{type:"string"},optionNum:{type:"string"},valueRange:{type:"string"}}},type:{type:"string",enumValues:["fromMax","fromMin","single"],value:"fromMin"},userAssistanceDensity:{type:"string",enumValues:["compact","efficient","reflow"],value:"reflow"},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},value:{type:"number",writeback:!0,value:0}},methods:{getProperty:{},refresh:{},reset:{},setProperties:{},setProperty:{},showMessages:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{}},extension:{}};e.extension._WIDGET_NAME="ojSlider",e.extension._INNER_ELEM="input",a.CustomElementBridge.register("oj-slider",{metadata:a.CollectionUtils.mergeDeep(e,t)});var i={properties:{describedBy:{type:"string"},disabled:{type:"boolean",value:!1},displayOptions:{type:"object",properties:{converterHint:{type:"Array<string>|string"},helpInstruction:{type:"Array<string>|string",value:["notewindow"]},messages:{type:"Array<string>|string"},validatorHint:{type:"Array<string>|string"}}},help:{type:"object",properties:{instruction:{type:"string",value:""}}},helpHints:{type:"object",properties:{definition:{type:"string",value:""},source:{type:"string",value:""}}},labelEdge:{type:"string",enumValues:["inside","none","provided"]},labelHint:{type:"string",value:""},labelledBy:{type:"string"},max:{type:"number",value:100},messagesCustom:{type:"Array<Object>",writeback:!0,value:[]},min:{type:"number",value:0},orientation:{type:"string",enumValues:["horizontal","vertical"],value:"horizontal"},step:{type:"number",value:1},transientValue:{type:"object",writeback:!0,readOnly:!0,properties:{end:{type:"number"},start:{type:"number"}}},translations:{type:"object",value:{},properties:{higherValueThumb:{type:"string"},lowerValueThumb:{type:"string"},startEnd:{type:"string"}}},userAssistanceDensity:{type:"string",enumValues:["compact","efficient","reflow"],value:"reflow"},valid:{type:"string",writeback:!0,enumValues:["invalidHidden","invalidShown","pending","valid"],readOnly:!0},value:{type:"object",writeback:!0,properties:{end:{type:"number"},start:{type:"number"}}}},methods:{getProperty:{},refresh:{},reset:{},setProperties:{},setProperty:{},showMessages:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{}},extension:{}};i.extension._WIDGET_NAME="ojSlider",i.extension._INNER_ELEM="input",a.CustomElementBridge.register("oj-range-slider",{metadata:a.CollectionUtils.mergeDeep(i,t)})}();const u=".oj-slider-thumb",h="aria-label",o="aria-labelledby",_="oj-slider-thumb-index",d="<div></div>",m="oj-slider-bar",p="oj-slider-bar-value",c=".ui-draggable";a.__registerWidget("oj.ojSlider",n.oj.editableValue,{defaultElement:"<input>",version:"1.0.1",widgetEventPrefix:"oj",options:{labelledBy:null,max:100,min:0,orientation:"horizontal",readOnly:!1,disabled:!1,step:1,type:"fromMin",value:0,rawValue:void 0},_numPages:5,_defaultElementId:null,_sliderDisplayValue:null,_isRTL:function(){return"rtl"===l.getReadingDirection()},_ComponentCreate:function(){if(this._super(),this._inputtag=!1,this.element.is("INPUT"))if(this._inputtag=!0,this.element[0].style&&(this._styleFromInputTag=this.element[0].style.cssText),this._inputElementOriginalDisplay=this.element[0].style.display,this.element[0].style.display="none",this.OuterWrapper)this._elementWrapped=n(this.OuterWrapper);else{var t=n(this.element).wrap("<div> </div>");this._elementWrapped=t.parent()}else this._elementWrapped=this.element;this._transientValueName=this._IsCustomElement()?"transientValue":"rawValue",this._componentCreateStyling(),this._componentSetup()},_SetRawValue:function(t,e){var i={_context:{originalEvent:e,writeback:!0,internalSet:!0,readOnly:!0}};a.Object.compareValues(this.options[this._transientValueName],t)||this.option(this._transientValueName,t,i)},_componentCreateStyling:function(){this._elementWrapped[0].classList.add("oj-slider","oj-component","oj-form-control"),this._setOrientationStyles(!0)},_setOrientationStyles:function(t){var e=this._elementWrapped[0];this._isVertical()?(t||e.classList.remove("oj-slider-horizontal"),e.classList.add("oj-slider-vertical")):(t||e.classList.remove("oj-slider-vertical"),e.classList.add("oj-slider-horizontal"))},_componentSetup:function(){this._newMultiValue=[],this._thumbIndex=null,this._isCustomRangeSlider()&&(this.options.type="range","number"==typeof this.options.value&&(this.options.value={start:null,end:null})),"range"===this.options.type?this._multipleThumbs=!0:this._multipleThumbs=!1,this._calculateNewMax(),this._createSliderContainer(),this._createBarBackground(),this._buildValueOption(),this._createRange(),this._createThumbs(),this._updateUI(),this._setupEvents()},_copyLabelledbyToThumb:function(t){var e,i=this._elementWrapped.find(u);if(this._isCustomRangeSlider()){var s=document.getElementById(t),a=s?s.textContent:"",l=r.getTranslatedString("oj-ojSlider.lowerValueThumb"),_=r.getTranslatedString("oj-ojSlider.higherValueThumb");i.attr(h,a+" "+l),e=i[1],n(e).attr(h,a+" "+_)}else i.attr(o,t),i.length>1&&(e=i[1],n(e).attr(o,String(t)))},_setAriaLabelToThumb:function(t){var e;if(this._isCustomRangeSlider()){var i=r.getTranslatedString("oj-ojSlider.lowerValueThumb"),s=r.getTranslatedString("oj-ojSlider.higherValueThumb");(e=this._elementWrapped.find(u)).attr(h,t+" "+i);var a=e[1];n(a).attr(h,t+" "+s)}else(e=this.OuterWrapper.querySelector(u)).setAttribute(h,t)},_AfterCreate:function(){this._super(),this._makeDraggable(),this._setAriaInfo()},_setAriaInfo:function(){var t,i,s;if(this.OuterWrapper){if(this.options.labelledBy){var a=this.uuid+"_Label";s=e.EditableValueUtils._getOjLabelAriaLabelledBy(this.options.labelledBy,a),this._copyLabelledbyToThumb(s)}this.options.labelledBy&&!document.getElementById(this.options.labelledBy)||(t=this.OuterWrapper.getAttribute(h))&&this._setAriaLabelToThumb(t)}else if(i=this._GetLabelElementLocal()){var n=i.attr("id");n||(n=i.attr("for")),n.length>0&&this._copyLabelledbyToThumb(n)}else(t=this.element.attr(h))&&this._elementWrapped.find(u).attr(h,t)},_GetLabelElementLocal:function(){var t=this._getAriaLabelledByElementLocal();return null!==t&&0!==t.length||null!==(t=this._getAriaLabelForElementLocal())&&0!==t.length?t:null},_getAriaLabelForElementLocal:function(){var t;if(void 0!==(t=this.element.prop("id"))){var e=n("label[for='"+t+"']");if(e.length>0)return e;var i="span[for='"+t+"']";if(0!==n(i).length)return n(i)}return null},_getAriaLabelledByElementLocal:function(){var t=this.element.attr(o);if(void 0===t&&this.OuterWrapper){var e=this._elementWrapped.attr(o);if(e&&null!==document.getElementById(e))return n(document.getElementById(e))}if(void 0!==t){var i=n("label[id='"+t+"']");if(i.length>0)return i;var s=n("span[id='"+t+"']");if(s.length>0)return s}return null},widget:function(){return this._elementWrapped},_SetDisplayValue:function(t){this._sliderDisplayValue=t},_GetDisplayValue:function(){return this._sliderDisplayValue},_getElementId:function(){return this.OuterWrapper?(this._elementWrapped[0].id||this._elementWrapped.uniqueId(),this._elementWrapped[0].id):(this.element[0].id||this.element.uniqueId(),this.element[0].id)},_getThumbId:function(t){return this._getElementId()+"-thumb"+t},_getBarValueId:function(){return this._getElementId()+"-barValue"},_getBarBackgroundId:function(){return this._getElementId()+"-barBack"},_getSliderWrapperId:function(){return this._getElementId()+"-sliderWrapper"},_createThumbs:function(){var t,e,i="",s="class='oj-slider-thumb ui-state-default' tabindex='0' role='slider'aria-valuemin = '"+this._valueMin()+"' aria-valuemax = '"+this._valueMax()+"' ></span>",a=[];for(e=this._multipleThumbs?2:1,t=0;t<e;t++)i="<span id='"+this._getThumbId(t)+"' "+s,a.push(i);this._thumbs=n(a.join("")).appendTo(this._sliderContainer),this._thumb=this._thumbs.eq(0),this._refreshThumbOptions()},_refreshThumbOptions:function(){var t=this,e=0;this._thumbs.each(function(){n(this).data(_,e),e+=1,t._isVertical()&&n(this).attr("aria-orientation","vertical"),t.options.disabled?(n(this).attr("aria-disabled","true"),n(this).removeAttr("tabindex")):(n(this).removeAttr("aria-disabled"),n(this).attr("tabindex","0")),t.options.readOnly?n(this).attr("title","read only"):n(this).removeAttr("title")})},_createSliderContainer:function(){var t=this._getSliderWrapperId(),e=this._elementWrapped.find("#"+t);e.length&&e.remove(),this._sliderContainer=n(d),n(this._sliderContainer).attr("id",t),this._sliderContainer.addClass("oj-slider-container").addClass("oj-form-control-container"),this.element.after(this._sliderContainer),this._sliderContainer[0].style.cssText=this._styleFromInputTag},_createBarBackground:function(){var t=this._getBarBackgroundId(),e=this._elementWrapped.find("#"+t);e.length&&e.remove(),this._barback=n(d),n(this._barback).attr("id",t),this._barback.addClass("oj-slider-bar"),this._sliderContainer.append(this._barback),this._barback.on("mousedown"+this.eventNamespace,this._reposition.bind(this))},_reposition:function(t){this._repositionThumb(t),this._mouseStop(t),this._getActiveThumb().focus()},_buildValueOption:function(){var t=this.options;if(this._isCustomRangeSlider())null===t.value?this.options.value={start:this._valueMin(),end:this._valueMax()}:(null!==t.value.start&&void 0!==t.value.start||(this.options.value.start=this._valueMin()),null!==t.value.end&&void 0!==t.value.end||(this.options.value.end=this._valueMax()),this.option("value",this.options.value,{_context:{writeback:!0,internalSet:!0}}));else if(t.type)if(null==this.options.value)this._multipleThumbs?this.options.value=[this._valueMin(),this._valueMax()]:this.options.value=this._valueMin(),this.option("value",this.options.value,{_context:{writeback:!0,internalSet:!0}});else if(this._multipleThumbs){var e;2!==this.options.value.length&&(e=this.options.value.length>0?this.options.value[0]:this._valueMin(),this.options.value=[e,this._valueMax()],this.option("value",this.options.value,{_context:{writeback:!0,internalSet:!0}}))}},_createRange:function(){var t=this.options,e="";if(t.type){this._range=n(d),n(this._range).attr("id",this._getBarValueId()),this._sliderContainer.append(this._range),e="oj-slider-range oj-slider-bar-value",this._range.on("mousedown"+this.eventNamespace,this._reposition.bind(this)),this._range=this._sliderContainer.find("#"+this._getBarValueId());var i="";"fromMin"===t.type?i=" oj-slider-range-min":"fromMax"===t.type&&(i=" oj-slider-range-max"),this._range.addClass(e+i)}else this._range&&this._range.remove(),this._range=null},_setupTouch:function(t){this._touchProxy=a._TouchProxy.addTouchListeners(t)},_tearDownTouch:function(t){a._TouchProxy.removeTouchListeners(t)},_registerResizeListener:function(t){this._resizeObserver=new ResizeObserver(this._makeDraggable.bind(this)),this._resizeObserver.observe(t)},_setupEvents:function(){this._registerResizeListener(this._elementWrapped[0]),this._CanSetValue()&&this._AddHoverable(this._elementWrapped),this._thumbs.toArray().forEach(function(t){var e=n(t);this._UnregisterChildNode(e),this._on(e,this._thumbEvents),this._setupTouch(e),this._focusable({element:e,applyHighlight:!0})},this)},_GetMessagingLauncherElement:function(){return this._elementWrapped},_GetContentElement:function(){return this._getActiveThumb()},_destroySliderDom:function(){this._resizeObserver.disconnect(),this._thumbs.toArray().forEach(function(t){var e=n(t);this._tearDownTouch(e)},this),this._destroyDraggable(),this._range&&this._range.remove(),this._sliderContainer&&this._sliderContainer.remove(),this.OuterWrapper?(this._elementWrapped.removeUniqueId(),this._RemoveHoverable(this._elementWrapped)):(this.element.removeUniqueId(),this._RemoveHoverable(this.element))},_unwrapSlider:function(){l.unwrap(this.element,this._elementWrapped),this.element[0].style.display=this._inputElementOriginalDisplay,this._RestoreAttributes(this.element)},_destroy:function(){return this._destroySliderDom(),this._unwrapSlider(),this._super()},_repositionThumb:function(t){var e,i,s,a=this.options,r=0,l=this;return this._closestThumb=this._thumb,!(a.disabled||a.readOnly||(e={x:t.pageX,y:t.pageY},i=this._getNormValueFromMouse(e),s=this._valueMax()-this._valueMin()+1,this._multipleThumbs&&this._thumbs.each(function(t){var e=Math.abs(i-l._getMultiValues(t));(s>e||s===e&&(t===l._lastChangedValueIndex||l._getMultiValues(t)===a.min))&&(s=e,this._closestThumb=n(this),r=t)}),this._thumbIndex=r,this._closestThumb&&(this._thumbs.hasClass("ui-state-hover")||this._slide(t,r,i),this._getActiveThumb().addClass("oj-active").focus(),this._range.addClass("oj-active"),0)))},_initDragging:function(t,e){var i=this.options;return!i.disabled&&!i.readOnly&&(e.removeClass("oj-focus-highlight"),e.addClass("oj-active").focus(),this._range.addClass("oj-active"),!0)},_mouseDragInternal:function(t,e){var i=this._getNormValueFromThumb(e);this._slide(t,this._thumbIndex,i,!0);var s=100*this._getFracFromThumb(e);return this._multipleThumbs?this._setRangeMultiThumb(s,this._thumbIndex):this._setRange(s),!1},_mouseStop:function(t,e){this._thumbs.removeClass("oj-active"),this._range.removeClass("oj-active");var i=this._getNormValueFromThumb(e);return this._slide(t,this._thumbIndex,i),this._change(t,this._thumbIndex,!1),this._thumbIndex=null,!1},_isVertical:function(){return"vertical"===this.options.orientation},_getOrientationAdjustedFrac:function(t){var e=t;return e>1&&(e=1),e<0&&(e=0),this._isVertical()&&(e=1-e),e},_getNormValueFromMouse:function(t){var e,i,s=this._getFracFromMouse(t);return e=this._valueMax()-this._valueMin(),this._isRTL()&&!this._isVertical()&&(s=1-s),i=this._valueMin()+s*e,this._trimAlignValue(i)},_getFracFromMouse:function(t){var e,i,s;return this._isVertical()?(e=this._barback.height(),i=t.y-this._barback.offset().top):(e=this._barback.width(),i=t.x-this._barback.offset().left),0===e?1:(s=i/e,s=this._getOrientationAdjustedFrac(s))},_getActiveThumb:function(){return this._multipleThumbs?n(this._thumbs[this._thumbIndex?this._thumbIndex:0]):this._thumb},_getFracFromThumb:function(t){var e,i,s,a,n=t;if(t||(n=this._getActiveThumb()),this._isVertical()){var r=n.outerHeight()/2;a=n.offset().top+r,e=this._barback.height(),i=a-this._barback.offset().top}else{var l=n.outerWidth()/2;a=n.offset().left+l,e=this._barback.width(),i=a-this._barback.offset().left}return 0===e?1:(s=i/e,s=this._getOrientationAdjustedFrac(s))},_getNormValueFromThumb:function(t){var e,i,s;return e=this._getFracFromThumb(t),i=this._valueMax()-this._valueMin(),this._isRTL()&&!this._isVertical()&&(e=1-e),s=this._valueMin()+e*i,this._trimAlignValue(s)},_getOtherThumbValue:function(t){return this._getMultiValues(t?0:1)},_getNewThumbValueLimited:function(t,e,i){return this._isCustomRangeSlider()?null!==this.options.value.start&&null!==this.options.value.end&&(0===t&&e>i||1===t&&e<i)?i:e:2===this.options.value.length&&(0===t&&e>i||1===t&&e<i)?i:e},_slide:function(t,e,i,s){var a;if(this._multipleThumbs){a=this._getOtherThumbValue(e);var n=this._getNewThumbValueLimited(e,i,a);this._setMultiValue(t,e,n,s)}else this._setSingleValue(t,i,s),s||this._inputtag&&this.element.val(i)},_setSingleValue:function(t,e,i){this._newValue=this._trimAlignValue(e),this._SetRawValue(this._newValue,t),i||(this.options[this._transientValueName]=this._newValue,this._SetValue(this._newValue,t),this._updateUI())},_change:function(t,e,i){this._multipleThumbs?(this._lastChangedValues=this._getNewValues(e,this._newMultiValue[e]),this._SetRawValue(this._lastChangedValues,t),i||this._SetValue(this._lastChangedValues,t)):(this._SetRawValue(this._newValue,t),i||this._SetValue(this._newValue,t)),this._lastChangedValueIndex=e},_getNewValues:function(t,e){var i;if(this._isCustomRangeSlider())(i={}).start=this._trimAlignValue(this.options.value.start),i.end=this._trimAlignValue(this.options.value.end),t===this._thumbIndex&&(0===t&&(i.start=e),1===t&&(i.end=e));else{var s;for(i=this.options.value.slice(),s=0;s<i.length;s++)i[s]=this._trimAlignValue(i[s]);t===this._thumbIndex&&(i[t]=e)}return i},_getSingleValue:function(){return this._getValueAligned()},_getMultiValues:function(t){return this._getValuesAligned(t)},_setMultiValue:function(t,e,i,s){this._newMultiValue[e]=this._trimAlignValue(i),this._change(t,e,s),s||this._updateUI()},_setOption:function(t,e,i){var s;if("value"===t)if(this._isCustomRangeSlider())if(e instanceof Object)if(this._checkStartEnd(e.start,e.end),isNaN(e.start))s=this._parse(t,e.start),this._checkValueBounds(s,this._valueMin(),this._valueMax());else{this._multipleThumbs=!0,s=e;for(var a=Object.keys(e),n=0;n<a.length;n++)this._checkValueBounds(s[a[n]],this._valueMin(),this._valueMax())}else{s={start:this._valueMin(),end:this._valueMax()},this.options.value={start:this._valueMin(),end:this._valueMax()};for(var r=Object.keys(s),l=0;l<r.length;l++)this._checkValueBounds(s[r[l]],this._valueMin(),this._valueMax())}else if(Array.isArray(e))if(isNaN(e[0]))this._multipleThumbs=!1,s=this._parse(t,e[0]),this._checkValueBounds(s,this._valueMin(),this._valueMax());else{this._multipleThumbs=!0,s=e;for(var u=0;u<s.length;u++)this._checkValueBounds(s[u],this._valueMin(),this._valueMax())}else this._multipleThumbs=!1,s=this._IsCustomElement()?e:this._parse(t,e),this._checkValueBounds(s,this._valueMin(),this._valueMax());else"max"===t||"min"===t?(s=this._IsCustomElement()?e:this._parse(t,e),"min"===t?(this._checkMinMax(s,this._valueMax()),this._multipleThumbs?(this._getMultiValues(0)<s&&(this._isCustomRangeSlider()?this._super("value",{start:s,end:this._getMultiValues(1)},i):this._super("value",[s,this._getMultiValues(1)],i)),this._getMultiValues(1)<s&&(this._isCustomRangeSlider()?this._super("value",{start:this._getMultiValues(0),end:s},i):this._super("value",[this._getMultiValues(0),s],i))):this._getSingleValue()<s&&this._super("value",s,i)):"max"===t&&(this._checkMinMax(this._valueMin(),s),this._multipleThumbs?(this._getMultiValues(0)>s&&(this._isCustomRangeSlider()?this._super("value",{start:s,end:this._getMultiValues(1)},i):this._super("value",[s,this._getMultiValues(1)],i)),this._getMultiValues(1)>s&&(this._isCustomRangeSlider()?this._super("value",{start:this._getMultiValues(0),end:s},i):this._super("value",[this._getMultiValues(0),s],i))):this._getSingleValue()>s&&this._super("value",s,i))):s="step"===t?this._parseStep(e):e;switch(this._super(t,s,i),"readOnly"===t&&(this.options.readonly=s),"disabled"===t&&(this.options.disabled=s),t){case"disabled":this._refreshThumbOptions(),this.options.disabled?this._disableDraggable():this._makeDraggable();break;case"value":this._updateUI(),this._makeDraggable();break;case"min":case"max":this._calculateNewMax(),this._updateUI(),this._makeDraggable();break;case"orientation":this._setOrientationStyles(),this._reCreate();break;case"readonly":case"step":case"type":this._reCreate();break;case"labelledBy":this._setAriaInfo()}},_reCreate:function(){this._destroySliderDom(),this._componentSetup(),this.OuterWrapper&&this._elementWrapped.addClass("oj-complete"),this._AfterCreate()},_getValueAligned:function(){var t=this.options.value;return t=this._trimAlignValue(t)},_isCustomRangeSlider:function(){return!(!this._IsCustomElement()||"OJ-RANGE-SLIDER"!==this.element[0].parentNode.tagName)},_getValuesAligned:function(t){var e,i=null;return this._isCustomRangeSlider()?(e=0===t?void 0!==this.options.value.start&&null!==this.options.value.start?this.options.value.start:this._valueMin():void 0!==this.options.value.end&&null!==this.options.value.end?this.options.value.end:this._valueMax(),i=this._trimAlignValue(e)):i=this._trimAlignValue(this.options.value[t]),i},_trimAlignValue:function(t){if(t<=this._valueMin())return this._valueMin();if(t>=this._valueMax())return this._valueMax();var e=this.options.step>0?this.options.step:1,i=(t-this._valueMin())%e,s=t-i;return 2*Math.abs(i)>=e&&(s+=i>0?e:-e),parseFloat(s.toFixed(5))},_calculateNewMax:function(){var t=this._valueMin();if((this.options.max-t)/this.options.step%1!=0){var e=(this.options.max-t)%this.options.step;this.max=this.options.max-e+this.options.step}else this.max=this.options.max},_valueMin:function(){return this.options.min},_valueMax:function(){return this.max},_getGrid:function(){var t;t=this.options.step>0?(this._valueMax()-this._valueMin())/this.options.step:100;var e=(this._isVertical()?this._barback.height():this._barback.width())/t;return e<1&&(e=1),this._isVertical()?[1,e]:[e,1]},_getThumbsValueFrac:function(t){return(this._getMultiValues(t)-this._valueMin())/(this._valueMax()-this._valueMin())},_updateUI:function(){var t,e,i,s,a,r;this._multipleThumbs?(this._thumbs.toArray().forEach(function(e,l){var u=n(e);t=100*this._getThumbsValueFrac(l),this._isRTL()&&!this._isVertical()&&(t=100-t),this._isVertical()?u.css({top:100-t+"%"}):u.css({left:t+"%"}),0===l?(a=u,100===t?u.css({zIndex:1}):u.css({zIndex:""})):r=u,u.hasClass("oj-active")||(u.attr("aria-valuenow",this._getMultiValues(l)),u.attr("aria-valuemin",i),u.attr("aria-valuemax",s)),this._setRangeMultiThumb(t,l)},this),a.hasClass("oj-focus")&&(a.css({zIndex:1}),r.css({zIndex:""})),r.hasClass("oj-focus")&&(a.css({zIndex:""}),r.css({zIndex:1}))):(e=this._getValueAligned(),i=this._valueMin(),s=this._valueMax(),t=s!==i?(e-i)/(s-i)*100:0,this._isRTL()&&!this._isVertical()&&(t=100-t),this._isVertical()?this._thumb.css({top:100-t+"%"}):this._thumb.css({left:t+"%"}),n(this._thumb).hasClass("oj-active")||(n(this._thumb).attr("aria-valuenow",e),n(this._thumb).attr("aria-valuemin",i),n(this._thumb).attr("aria-valuemax",s)),this._setRange(t))},_setRange:function(t){var e=this.options.type;this._isVertical()?("fromMin"===e&&this._range.css({height:t+"%"}),"fromMax"===e&&this._range.css({height:100-t+"%"})):this._isRTL()?("fromMin"===e&&this._range.css({width:100-t+"%"}),"fromMax"===e&&this._range.css({width:t+"%"})):("fromMin"===e&&this._range.css({width:t+"%"}),"fromMax"===e&&this._range.css({width:100-t+"%"}))},_setRangeMultiThumb:function(t,e){var i=this._range.attr("id");if(0===e){var s=100*this._getThumbsValueFrac(1);switch(this.options.type){case"fromMin":this._isVertical()?this._range.css({height:t+"%"}):this._range.css({width:t+"%"});break;case"range":this._isVertical()?(this._range.css({top:100-s+"%"}),this._range.css({height:s-t+"%"})):this._isRTL()?(this._range.css({left:100-s+"%"}),this._range.css({width:s-(100-t)+"%"})):(this._range.css({left:t+"%"}),this._range.css({width:s-t+"%"}))}}else{var a=100*this._getThumbsValueFrac(0);switch(this.options.type){case"fromMax":this._isVertical()?this._range.css({height:100-t+"%"}):this._range.css({width:100-t+"%"});break;case"range":if(this._isVertical())document.getElementById(i)&&(this._range.css({top:100-t+"%"}),this._range.css({height:t-a+"%"}));else if(this._isRTL())document.getElementById(i)&&(this._range.css({left:t+"%"}),this._range.css({width:100-t-a+"%"}));else if(document.getElementById(i)){var n=parseInt(document.getElementById(i).style.left,10);this._range.css({width:t-n+"%"})}}}},_thumbEvents:{keydown:function(t){var e,i,s,a,r=n(t.target).data(_);switch(this._thumbIndex=r,t.keyCode){case n.ui.keyCode.HOME:case n.ui.keyCode.END:case n.ui.keyCode.PAGE_UP:case n.ui.keyCode.PAGE_DOWN:case n.ui.keyCode.UP:case n.ui.keyCode.RIGHT:case n.ui.keyCode.DOWN:case n.ui.keyCode.LEFT:t.preventDefault(),n(t.target).addClass("oj-active")}switch(s=this.options.step,e=i=this._multipleThumbs?this._getMultiValues(r):this._getSingleValue(),t.keyCode){case n.ui.keyCode.HOME:i=this._valueMin();break;case n.ui.keyCode.END:i=this._valueMax();break;case n.ui.keyCode.PAGE_UP:i=this._trimAlignValue(e+(this._valueMax()-this._valueMin())/this._numPages);break;case n.ui.keyCode.PAGE_DOWN:i=this._trimAlignValue(e-(this._valueMax()-this._valueMin())/this._numPages);break;case n.ui.keyCode.UP:if(e===this._valueMax())return;a=e+s,i=this._trimAlignValue(a);break;case n.ui.keyCode.RIGHT:if(!this._isRTL()||this._isVertical()){if(e===this._valueMax())return;a=e+s}else{if(e===this._valueMin())return;a=e-s}i=this._trimAlignValue(a);break;case n.ui.keyCode.DOWN:if(e===this._valueMin())return;a=e-s,i=this._trimAlignValue(a);break;case n.ui.keyCode.LEFT:if(!this._isRTL()||this._isVertical()){if(e===this._valueMin())return;a=e-s}else{if(e===this._valueMax())return;a=e+s}i=this._trimAlignValue(a)}this._slide(t,r,i)},keyup:function(t){switch(t.keyCode){case n.ui.keyCode.HOME:case n.ui.keyCode.END:case n.ui.keyCode.PAGE_UP:case n.ui.keyCode.PAGE_DOWN:case n.ui.keyCode.UP:case n.ui.keyCode.RIGHT:case n.ui.keyCode.DOWN:case n.ui.keyCode.LEFT:var e=n(t.target).data(_);this._thumbIndex=e,this._change(t,e,!1),n(t.target).removeClass("oj-active"),this._updateUI(!0),this._thumbIndex=null}}},_InitOptions:function(t,i){var s=this.options,a=this;if(this._superApply(arguments),!this._IsCustomElement()&&(e.EditableValueUtils.initializeOptionsFromDom([{attribute:"disabled",validateOption:!0},{attribute:"value"},{attribute:"title"},{attribute:"min"},{attribute:"max"},{attribute:"step"}],i,this,function(t){for(var e=t,i=["value","step","min","max"],n=0;n<i.length;n++){var r=i[n],l=r in e?e[r]:s[r];null!=l&&("step"===r?e[r]=a._parseStep(l):"min"===r||"max"===r?e[r]=a._parse(r,l):"value"===r&&(Array.isArray(l)?e[r]=l:e[r]=a._parse(r,l)))}}),void 0===s.value))throw new Error(this.getTranslatedString("noValue"));if(this._isCustomRangeSlider()&&this._checkStartEnd(s.value.start,s.value.end),this._checkMinMax(s.min,s.max),Array.isArray(s.value))for(var n=0;n<s.value.length;n+=1)this._checkValueBounds(s.value[n],s.min,s.max);else this._checkValueBounds(s.value,s.min,s.max)},_checkValueBounds:function(t,e,i){if(null!=e&&t<e)throw new Error(this.getTranslatedString("valueRange"));if(null!=i&&t>i)throw new Error(this.getTranslatedString("valueRange"))},_checkMinMax:function(t,e){if(null!=t&&null!=e&&t>=e)throw new Error(this.getTranslatedString("maxMin"))},_checkStartEnd:function(t,e){if(null!=t&&null!=e&&t>e)throw new Error(this.getTranslatedString("startEnd"))},getNodeBySubId:function(t){if(null==t)return this.element?this.element[0]:null;var e=t.subId;return"oj-slider-thumb-0"===e?this.widget().find(u)[0]:"oj-slider-thumb-1"===e?this.widget().find(u)[1]:e===m||e===p?this.widget().find("."+e)[0]:null},getSubIdByNode:function(t){if(null!=t){if(t.id===this._getThumbId(0)&&n(t).hasClass("oj-slider-thumb"))return{subId:"oj-slider-thumb-0"};if(t.id===this._getThumbId(1)&&n(t).hasClass("oj-slider-thumb"))return{subId:"oj-slider-thumb-1"};if(n(t).hasClass(m))return{subId:m};if(n(t).hasClass(p))return{subId:p}}return null},_GetDefaultStyleClass:function(){return"oj-slider"},_parse:function(t,e){var i;if(i=null!==e?+e:e,isNaN(i))throw new Error(this.getTranslatedString("optionNum",{option:t}));return i},_parseStep:function(t){var e;if(null===t)return 1;if((e=this._parse("step",t))<=0)throw new Error(this.getTranslatedString("invalidStep"));return(null===e||e<=0)&&(e=1),e},_getEndInterval:function(){return this._barback.offset().left+this._barback.width()},_getStartInterval:function(){return this._barback.offset().left},_callDraggable:function(t){var e,i=this._getGrid(),s=t[0].style;e=this._isVertical()?"y":"x";var a=this;t.draggable({axis:e,grid:i,disabled:!1,start:function(e){t[0]===n(a._thumbs)[0]?a._thumbIndex=0:t[0]===n(a._thumbs)[1]&&(a._thumbIndex=1),a._initDragging(e,t)},drag:function(e,i){var r=i.position;if(a._isVertical()?(s.left="",r.left=""):(s.top="",r.top=""),a._mouseDragInternal(e,t),a._isVertical()?(r.top<0&&(r.top=0),r.top>a._barback.height()&&(r.top=a._barback.height())):(r.left<0&&(r.left=0),r.left>a._barback.width()&&(r.left=a._barback.width())),a._multipleThumbs){var l,u;if(l=0===a._thumbIndex?n(a._thumbs[1]):n(a._thumbs[0]),a._isVertical()){var h=t.outerHeight()/2,o=a._barback.offsetParent().offset().top;u=l.offset().top+h-o}else{var _=t.outerWidth()/2,d=a._barback.offsetParent().offset().left;u=l.offset().left+_-d}0===a._thumbIndex?a._isVertical()?r.top<u&&(r.top=u):a._isRTL()?r.left<u&&(r.left=u):r.left>u&&(r.left=u):a._isVertical()?r.top>u&&(r.top=u):a._isRTL()?r.left>u&&(r.left=u):r.left<u&&(r.left=u)}},stop:function(e){this.style.width="",this.style.height="",a._mouseStop(e,t)}})},_makeDraggable:function(){this.options.disabled||(this._multipleThumbs?this._thumbs.toArray().forEach(function(t){var e=n(t);this._callDraggable(e)},this):this._callDraggable(this._thumb))},_disableDraggable:function(){this._multipleThumbs?this._thumbs.toArray().forEach(function(t){var e=n(t);e.is(c)&&e.draggable("disable")},this):this._thumb.is(c)&&this._thumb.draggable("disable")},_destroyDraggable:function(){this._multipleThumbs?this._thumbs.toArray().forEach(function(t){var e=n(t);e.is(c)&&e.draggable("destroy")},this):this._thumb.is(c)&&this._thumb.draggable("destroy")}})});
//# sourceMappingURL=ojslider.js.map