/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojeventtarget","ojs/ojdataprovider","ojs/ojset","ojs/ojmap","ojs/ojmetadatautils"],function(t,e,s,r,a,i){"use strict";r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a;
/**
     * @preserve Copyright 2013 jQuery Foundation and other contributors
     * Released under the MIT license.
     * http://jquery.org/license
     */
class o{constructor(t){this.options=t}async fetch(){const t=await this._createRequest(),e=this.options.fetchParameters.signal;try{const s=await fetch(t,{signal:e});return await this._parseResponse(s)}catch(t){if(this.options.errorHandler)if(null!=t.status){const e={fetchType:this.options.fetchType,fetchParameters:this.options.fetchParameters,options:this.options.options,response:t};this.options.errorHandler(e)}else{const e={fetchType:this.options.fetchType,fetchParameters:this.options.fetchParameters,options:this.options.options,error:t};Object.defineProperty(e,"err",{get:()=>e.error,enumerable:!0}),this.options.errorHandler(e)}throw t}}async _createRequest(){const{url:t,transforms:e,fetchParameters:s,fetchType:r,fetchOptions:a}=this.options,o=e[r].request;if(o){return o(i.deepFreeze({url:t,fetchParameters:s,fetchType:r,fetchOptions:a}))}return new Request(t)}async _parseResponse(t){const e={status:t.status,headers:t.headers,body:await this._getResponseBody(t)};if(!t.ok)throw e;return this._applyResponseTransforms(e)}async _getResponseBody(t){try{return await t.json()}catch{return}}async _applyResponseTransforms({status:t,headers:e,body:s}){const{transforms:r={},fetchType:a}=this.options,o=r[a].response;let n,h,c,l,f;if(o){const r=i.deepFreeze({status:t,headers:e,body:s}),a=await o(r);n=a.data,h=a.keys,c=a.metadata,l=a.hasMore,f=a.totalSize}else null!==s&&"object"==typeof s&&(n=s.data,h=s.keys,c=s.metadata,l=s.hasMore,f=s.totalSize);if(!Array.isArray(n))throw'"data" should be an array. Please use the response transform to extract the data array from the response if needed.';return{data:n,keys:h,metadata:c,hasMore:l,totalSize:f}}}const n="fetchByKeys",h="fetchByOffset",c="fetchFirst";class l{constructor(t){var e;this.options=t,this._totalSize=-1,this._sequenceNum=0,this._mapClientIdToProps=new Map,this.AsyncIterable=(e=class{constructor(t){this._asyncIterator=t,this[Symbol.asyncIterator]=function(){return this._asyncIterator}}},Symbol.asyncIterator,e),this.AsyncIterator=class{constructor(t,e,s,r,a){this._parent=t,this._nextFunc=e,this._fetchParameters=s,this._offset=r,this._iterationLimit=a,this._rowsFetched=0,this._clientId=s&&s.clientId||Symbol(),t._mapClientIdToProps.set(this._clientId,{hasMore:!0,offset:r})}async next(){const t=this._parent._mapClientIdToProps.get(this._clientId),e=t.offset,s=t.hasMore,{result:r,offset:a,hasNoMore:i}=await this._nextFunc(c,this._fetchParameters,e,s);this._parent._mapClientIdToProps.set(this._clientId,{hasMore:!i,offset:a});const o=r.value.data;return this._rowsFetched+=o.length,Number.isInteger(this._iterationLimit)&&this._rowsFetched>=this._iterationLimit&&(r.done=!0),r}},this.AsyncIteratorYieldResult=class{constructor(t){this.value=t,this.done=!1}},this.AsyncIteratorReturnResult=class{constructor(t){this.value=t,this.done=!0}}}fetchFirst(t){return new this.AsyncIterable(new this.AsyncIterator(this,this._fetchFrom.bind(this),t,0,this.options.iterationLimit))}async fetchByKeys(t){if(!t)throw Error('"keys" is a required parameter');const e=this._getCapabilitiesFromOptions();if(e.fetchByKeys){if("lookup"===e.fetchByKeys.implementation)return this._fetchByKeysLookup(t);if("batchLookup"===e.fetchByKeys.implementation)return this._fetchByKeysBatchLookup(t)}return this._fetchByKeysIteration(t)}async fetchByOffset(t){if(!t)throw Error('"offset" is a required parameter');const e=t.offset>0?t.offset:0,s=this._getCapabilitiesFromOptions();return s.fetchByOffset&&"randomAccess"===s.fetchByOffset.implementation?this._fetchByOffsetRandomAccess(t,e):this._fetchByOffsetIteration(t,e)}async containsKeys(t){const e=new r,s=await this.fetchByKeys(t);return t.keys.forEach(t=>{null!=s.results.get(t)&&e.add(t)}),{containsParameters:t,results:e}}createOptimizedKeySet(t){return t?new r(t):new r}createOptimizedKeyMap(t){return t?new a(t):new a}isEmpty(){return"unknown"}getCapability(t){const e=this._getCapabilitiesFromOptions();switch(t){case"sort":return e.sort;case"filter":return e.filter;case c:return this._getFetchCapability(c);case n:return this._getFetchCapability(n);case h:return this._getFetchCapability(h);case"fetchCapability":return l._getFetchCapabilityDefaults();default:return}}getTotalSize(){return Promise.resolve(this._totalSize)}refresh(){this.dispatchEvent(new s.DataProviderRefreshEvent)}mutate(t){const{add:e,remove:r}=t;this._adjustIteratorOffset(r,e),this.dispatchEvent(new s.DataProviderMutationEvent(t))}async _fetchFrom(t,e,r,a){const{signal:i}=e;return s.wrapWithAbortHandling(i,async(i,n)=>{if(a){const a=this._convertFetchListToFetchByOffsetParameters(e,r),n=this._getFetchSize(a),h={...a,size:n,filterCriterion:s.FilterFactory.getFilter({filterDef:a.filterCriterion,filterOptions:this.options})};s.FilterUtils.validateFilterCapabilities(this.getCapability("filter"),h.filterCriterion);const c=new o({fetchType:t,fetchParameters:h,url:this.options.url,transforms:this.options.transforms,fetchOptions:{textFilterAttributes:this.options.textFilterAttributes},errorHandler:this.options.error,options:this.options}),l=await c.fetch(),{data:f,totalSize:u,hasMore:p}=l;let y;if(l.metadata)y=l.metadata.map(t=>({...t}));else{const t=l.keys||this._generateKeysFromData(f);y=this._generateMetadataFromKeys(t)}const d=this._mergeSortCriteria(e.sortCriteria);d&&(e={...e,sortCriteria:d});const m={fetchParameters:e,data:f,metadata:y};return Number.isInteger(u)&&this._totalSize!==u&&(this._totalSize=u),"boolean"==typeof p&&(p||f.length>0)?i({result:new this.AsyncIteratorYieldResult(m),offset:r+f.length,hasNoMore:!p}):i({result:new this.AsyncIteratorReturnResult(m),offset:r+f.length,hasNoMore:!p})}return i({result:new this.AsyncIteratorReturnResult({fetchParameters:e,data:[],metadata:[]}),offset:r,hasNoMore:!0})},!0)}async _fetchByKeysIteration(t){const e=this._convertFetchByKeysToFetchListParameters(t),s=this.fetchFirst(e)[Symbol.asyncIterator](),r=[],a=[];let i=!1;for(;!i;){const e=await s.next(),{data:o,metadata:n}=e.value;n.forEach((e,s)=>{t.keys.has(e.key)&&(r.push(o[s]),a.push(e))}),i=t.keys.size===a.length||e.done}return this._createFetchByKeysResults(t,r,a)}async _fetchByKeysLookup(t){const{signal:e}=t;return s.wrapWithAbortHandling(e,async(e,s)=>{const r=[],a=[],i=[];for(let e of t.keys){const s=new o({fetchType:n,fetchParameters:{...t,keys:new Set([e])},url:this.options.url,transforms:this.options.transforms,errorHandler:this.options.error,options:this.options});r.push(s.fetch())}return(await Promise.all(r)).forEach(t=>{t.data.forEach(t=>{a.push(t)});const e=t.keys||this._generateKeysFromData(t.data);(t.metadata||this._generateMetadataFromKeys(e)).forEach(t=>{i.push(t)})}),e(this._createFetchByKeysResults(t,a,i))},!0)}async _fetchByKeysBatchLookup(t){const{signal:e}=t;return s.wrapWithAbortHandling(e,async(e,s)=>{const r=new o({fetchType:n,fetchParameters:t,url:this.options.url,transforms:this.options.transforms,errorHandler:this.options.error,options:this.options}),a=await r.fetch(),i=a.keys||this._generateKeysFromData(a.data),h=a.metadata||this._generateMetadataFromKeys(i);return e(this._createFetchByKeysResults(t,a.data,h))},!0)}async _fetchByOffsetRandomAccess(t,e){const s=await this._fetchFrom(h,this._convertFetchByOffsetToFetchListParameters(t),e,!0);s.hasNoMore&&(s.result.done=!0);const{value:r,done:a}=s.result,{data:i,metadata:o}=r,n=i.map((t,e)=>({metadata:o[e],data:t}));return{fetchParameters:t,results:n,done:a}}async _fetchByOffsetIteration(t,e){const s=this._convertFetchByOffsetToFetchListParameters(t),r=this.fetchFirst(s)[Symbol.asyncIterator](),a=[],i=[],o=this._getFetchSize(t);let n=!1,h=!0;for(;!n;){const t=await r.next(),s=t.value,{data:c,metadata:l}=s;h=t.done,c.forEach(t=>{a.push(t)}),l.forEach(t=>{i.push(t)}),n=void 0!==a[e+o-1]||h}const c=e,l=e+o,f=a.slice(c,l),u=i.slice(c,l);return{fetchParameters:t,results:f.map((t,e)=>({metadata:u[e],data:t})),done:h}}_generateKeysFromData(t){const e=null!=this.options?this.options.keyAttributes:null;return t.map(t=>{let s=this._getId(t);return null!=s&&"@index"!=e||(s=this._sequenceNum++),s})}_generateMetadataFromKeys(t){return t.map(t=>({key:t}))}_getId(t){let e,s=null;if(null!=this.options&&null!=this.options.keyAttributes&&(s=this.options.keyAttributes),null!=s){if(Array.isArray(s)){let r;for(e=[],r=0;r<s.length;r++)e[r]=this._getVal(t,s[r])}else e=this._getVal(t,s);return e}return null}_getVal(t,e){const s=e.indexOf(".");if(s>0){const r=e.substring(0,s),a=e.substring(s+1),i=t[r];if(i)return this._getVal(i,a)}return"function"==typeof t[e]?t[e]():t[e]}_convertFetchByOffsetToFetchListParameters(t){return{size:t.size,sortCriteria:t.sortCriteria,filterCriterion:t.filterCriterion,attributes:t.attributes,clientId:t.clientId,signal:t.signal}}_convertFetchListToFetchByOffsetParameters(t,e){return{offset:e,size:t.size,sortCriteria:t.sortCriteria,filterCriterion:t.filterCriterion,attributes:t.attributes,clientId:t.clientId,signal:t.signal}}_convertFetchByKeysToFetchListParameters(t){return{attributes:t.attributes,signal:t.signal}}_createFetchByKeysResults(t,e,s){const r=new Map;return e.forEach((t,e)=>{t&&r.set(s[e].key,{metadata:s[e],data:t})}),{fetchParameters:t,results:r}}_getFetchCapability(t){const e=this._getCapabilitiesFromOptions(),s=l._getFetchCapabilityDefaults();return t===c?{...s,iterationSpeed:"delayed"}:e[t]?{...s,...e[t]||{}}:null}static _getFetchCapabilityDefaults(){return{caching:"none",attributeFilter:{expansion:{},ordering:{},defaultShape:{features:new Set(["exclusion"])}}}}_getCapabilitiesFromOptions(){return this.options.capabilities||{}}_getFetchSize(t){return Number.isInteger(t.size)&&t.size>0?t.size:25}_mergeSortCriteria(t){const e=null!=this.options?this.options.implicitSort:null;if(null!=e){if(null==t)return e;const s=t.slice(0);let r,a,i;for(r=0;r<e.length;r++){for(i=!1,a=0;a<s.length;a++)s[a].attribute==e[r].attribute&&(i=!0);i||s.push(e[r])}return s}return t}_adjustIteratorOffset(t,e){const s=t?t.indexes:null,r=e?e.indexes:null;this._mapClientIdToProps.forEach((t,e)=>{let a=t.offset,i=0;s&&s.forEach(function(t){t<a&&++i}),a-=i;let o=!1;r&&r.forEach(function(t){t<a?++a:o=!0}),o?this._mapClientIdToProps.set(e,{hasMore:!0,offset:a}):this._mapClientIdToProps.set(e,{hasMore:t.hasMore,offset:a})})}}e.EventTargetMixin.applyMixin(l),t.RESTDataProvider=l,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojrestdataprovider.js.map