/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojcore-base","jquery","ojs/ojcomponentcore","ojs/ojlogger","ojs/ojdomutils","ojs/ojpreact-patch","jqueryui-amd/position","ojs/ojcontext","preact/jsx-runtime","preact","ojs/ojcustomelement-utils"],function(t,e,o,i,n,r,s,a,l,c,p,u){"use strict";e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e,o=o&&Object.prototype.hasOwnProperty.call(o,"default")?o.default:o,l=l&&Object.prototype.hasOwnProperty.call(l,"default")?l.default:l;const _=function(t){this._tapCallback=t,this.Init()};e._registerLegacyNamespaceProp("SimpleTapRecognizer",_),e.Object.createSubclass(_,e.Object,"oj.SimpleTapRecognizer"),_.prototype.Init=function(){_.superclass.Init.call(this);var t=this._eventHandler.bind(this);this._eventHandlerCallback=t;for(var e,o=document.documentElement,i=0;i<_._TOUCHEVENTS.length;i++)"touchstart"===(e=_._TOUCHEVENTS[i])||"touchmove"===e?o.addEventListener(e,t,{passive:!1,capture:!0}):o.addEventListener(e,t,!0)},_.prototype._eventHandler=function(t){var e=this._tapCallback,o=t.type;if("touchstart"===o)this._touchStartEvent=t,this._touchStartEvent._tapStart=(new Date).getTime();else if("touchmove"===o||"touchcancel"===o)this._touchStartEvent=null;else if("touchend"===o){if(this._touchStartEvent){var i=this._touchStartEvent._tapStart;if(isNaN(i))e(this._touchStartEvent);else(new Date).getTime()-i<_._PRESSHOLDTHRESSHOLD&&e(this._touchStartEvent)}this._touchStartEvent=null}},_.prototype.destroy=function(){this._tapCallback=null;var t=this._eventHandlerCallback;this._eventHandlerCallback=null;for(var e,o=document.documentElement,i=0;i<_._TOUCHEVENTS.length;i++)"touchstart"===(e=_._TOUCHEVENTS[i])||"touchmove"===e?o.removeEventListener(e,t,{passive:!1,capture:!0}):o.removeEventListener(e,t,!0)},_._TOUCHEVENTS=["touchstart","touchmove","touchcancel","touchend"],_._PRESSHOLDTHRESSHOLD=700;const f=function(){this.Init()};e._registerLegacyNamespaceProp("PopupService",f),e.Object.createSubclass(f,e.Object,"oj.PopupService");const h=function(){this.Init()},d={};f.prototype.Init=function(){f.superclass.Init.call(this)},f.getInstance=function(t){return f._popupService||(f._popupService=new h),f._popupService},f.prototype.open=function(t){e.Assert.failedInAbstractFunction()},f.prototype.close=function(t){e.Assert.failedInAbstractFunction()},f.prototype.changeOptions=function(t){e.Assert.failedInAbstractFunction()},f.prototype.triggerOnDescendents=function(t,o,i){e.Assert.failedInAbstractFunction()},f.prototype.destroy=function(){f._popupService=null},f.MODALITY={NONE:"none",MODAL:"modal",MODELESS:"modeless"},f.EVENT={POPUP_REMOVE:"ojPopupRemove",POPUP_CLOSE:"ojPopupClose",POPUP_REFRESH:"ojPopupRefresh",POPUP_AUTODISMISS:"ojPopupAutoDismiss",POPUP_BEFORE_OPEN:"ojPopupBeforeOpen",POPUP_AFTER_OPEN:"ojPopupAfterOpen",POPUP_BEFORE_CLOSE:"ojPopupBeforeClose",POPUP_AFTER_CLOSE:"ojPopupAfterClose"},f.LAYER_LEVEL={TOP_LEVEL:"topLevel",NEAREST_ANCESTOR:"nearestAncestor"},f.OPTION={POPUP:"popup",EVENTS:"events",MODALITY:"modality",LAUNCHER:"launcher",POSITION:"position",LAYER_SELECTORS:"layerSelectors",LAYER_LEVEL:"layerLevel",CONTEXT:"context",CUSTOM_ELEMENT:"customElement"},e.__registerWidget("oj.ojSurrogate",o.oj.baseComponent,{version:"1.0.0",widgetEventPrefix:"oj",options:{beforeDestroy:null},_ComponentCreate:function(){this._super(),this.element.uniqueId()},_invokeBeforeDestroy:function(){var t=this.options.beforeDestroy;this.options.beforeDestroy=null,t&&t()},_destroy:function(){this._invokeBeforeDestroy(),this.element.removeUniqueId(),this._super()},_NotifyDetached:function(){this._invokeBeforeDestroy(),this._super()},$$cleanElement:function(){this._invokeBeforeDestroy()}});e.CustomElementBridge.register("oj-surrogate",{metadata:{properties:{beforeDestroy:{type:"function"}},methods:{$$cleanElement:{}},extension:{_WIDGET_NAME:"ojSurrogate"}}}),e._registerLegacyNamespaceProp("PopupServiceImpl",h),e.Object.createSubclass(h,f,"oj.PopupServiceImpl"),h.prototype.open=function(t){e.Assert.assertObject(t);var s=o(t[f.OPTION.POPUP]);e.Assert.assertPrototype(s,o);var a=d.getStatus(s);if(a===d.STATUS.UNKNOWN||a===d.STATUS.BEFORE_OPEN||a===d.STATUS.CLOSE){var l=o(t[f.OPTION.LAUNCHER]);e.Assert.assertPrototype(l,o);var c=t[f.OPTION.POSITION];e.Assert.assertObjectOrNull(c);var p=t[f.OPTION.EVENTS];e.Assert.assertObject(p);var u=t[f.OPTION.MODALITY];(!u||f.MODALITY.MODELESS!==u&&f.MODALITY.MODAL!==u)&&(u=f.MODALITY.NONE);var _=t[f.OPTION.LAYER_SELECTORS];e.Assert.assertString(_);var E=t[f.OPTION.CUSTOM_ELEMENT],g=t[f.OPTION.LAYER_LEVEL];(!g||f.LAYER_LEVEL.TOP_LEVEL!==g&&f.LAYER_LEVEL.NEAREST_ANCESTOR!==g)&&(g=f.LAYER_LEVEL.NEAREST_ANCESTOR);var v=p[f.EVENT.POPUP_BEFORE_OPEN];v&&o.isFunction(v)||(v=h._defaultBeforeOpenCallback);var O=p[f.EVENT.POPUP_AFTER_OPEN];d.setStatus(s,d.STATUS.OPENING),r.setLogicalParent(s,l),d.addToAncestorLayer(s,l,u,_,g,E);var T,S=function(){try{s.removeAttr("aria-hidden"),this._assertEventSink()}catch(t){n.error("Error opening popup:\n%o",t)}finally{d.setStatus(s,d.STATUS.OPEN),O&&O(t);var i=d.getFirstAncestorLayer(s);if(e.Assert.assertPrototype(i,o),d.applyEvents(i,p),!d._getSurrogate(i)&&o.isFunction(p[f.EVENT.POPUP_REMOVE]))(0,p[f.EVENT.POPUP_REMOVE])()}};S=S.bind(this);try{T=v(t),i.subtreeShown(s[0])}catch(t){n.error("Error before open popup:\n%o",t)}finally{T&&T instanceof Promise?T.then(S):S()}}else this._assertEventSink()},h._defaultBeforeOpenCallback=function(t){var i=o(t[f.OPTION.POPUP]);e.Assert.assertPrototype(i,o);var n=t[f.OPTION.POSITION];i.show(),n&&i.position(n)},h.prototype.close=function(t){e.Assert.assertObject(t);var s=o(t[f.OPTION.POPUP]);e.Assert.assertPrototype(s,o);var a=d.getOpenPopupLayer(s);e.Assert.assertPrototype(a,o);var l=t[f.OPTION.EVENTS];l?l=o.extend(d.getEvents(a),l):(l=d.getEvents(a),t[f.OPTION.EVENTS]=l);var c=d.getStatus(s);if(c!==d.STATUS.OPEN&&c!==d.STATUS.BEFORE_CLOSE||!l)this._assertEventSink();else{var p=l[f.EVENT.POPUP_BEFORE_CLOSE];p&&o.isFunction(p)||(p=h._defaultBeforeCloseCallback);var u=l[f.EVENT.POPUP_AFTER_CLOSE];d.setStatus(s,d.STATUS.CLOSING),d.applyEvents(a,{}),s.attr("aria-hidden","true");var _,E=function(){try{s.hide(),null!==t[f.OPTION.POSITION]&&s.css({top:"auto",bottom:"auto",left:"auto",right:"auto"}),d.removeFromAncestorLayer(s),r.setLogicalParent(s,null),this._assertEventSink(),i.subtreeHidden(s[0])}catch(t){n.error("Error closing popup:\n%o",t)}finally{d.setStatus(s,d.STATUS.CLOSE),u&&o.isFunction(u)&&u(t)}};E=E.bind(this);try{_=p(t)}catch(t){n.error("Error before close popup:\n%o",t)}finally{_&&_ instanceof Promise?_.then(E):E()}}},h._defaultBeforeCloseCallback=function(t){var i=o(t[f.OPTION.POPUP]);e.Assert.assertPrototype(i,o),i.hide()},h.prototype.changeOptions=function(t){e.Assert.assertObject(t);var i=o(t[f.OPTION.POPUP]);if(e.Assert.assertPrototype(i,o),d.getStatus(i)===d.STATUS.OPEN){var n=d.getOpenPopupLayer(i);e.Assert.assertPrototype(n,o);var r=t[f.OPTION.EVENTS];r&&d.applyEvents(n,r);var s=t[f.OPTION.MODALITY];s&&d.applyModality(n,i,s);var a=t[f.OPTION.LAYER_SELECTORS];e.StringUtils.isEmptyOrUndefined(a)||n.attr("class",a)}},h.prototype.triggerOnDescendents=function(t,e,o){if(d.isPopupOpen(t)){var i={};i.event=e,i.argsArray=o;var n=d.getFirstAncestorLayer(t);d.postOrderVisit(n,this._triggerOnDescendentsVisitCallback,i)}},h.prototype._triggerOnDescendentsVisitCallback=function(t,e){var i=e.event,n=e.argsArray,r=d.getEvents(t);return r&&o.isFunction(r[i])&&r[i].apply(this,n),d.VISIT_RESULT.ACCEPT},h.prototype._assertEventSink=function(){var t,e,o,i=d.hasPopupsOpen(),n=this._callbackEventFilter;if(!i&&n){for(window.removeEventListener("resize",h._refreshCallback,!0),window.removeEventListener("scroll",h._refreshCallback,!0),(e=document.documentElement).removeEventListener("mousewheel",h._refreshCallback,{passive:!0,capture:!0}),e.removeEventListener("DOMMouseScroll",h._refreshCallback,!0),this._callbackEventFilter=null,t=0;t<h._REDISTRIBUTE_EVENTS.length;t++)o=h._REDISTRIBUTE_EVENTS[t],e.removeEventListener(o,n,!0);var s=this._simpleTapRecognizer;s&&(s.destroy(),this._simpleTapRecognizer=null)}else if(i&&!n){for(window.addEventListener("resize",h._refreshCallback,!0),window.addEventListener("scroll",h._refreshCallback,!0),(e=document.documentElement).addEventListener("mousewheel",h._refreshCallback,{passive:!0,capture:!0}),e.addEventListener("DOMMouseScroll",h._refreshCallback,!0),n=this._eventFilterCallback.bind(this),this._callbackEventFilter=n,t=0;t<h._REDISTRIBUTE_EVENTS.length;t++)o=h._REDISTRIBUTE_EVENTS[t],e.addEventListener(o,n,!0);r.isTouchSupported()&&(this._simpleTapRecognizer=new _(n))}},h.prototype._eventFilterCallback=function(t){var e=o(t.target);if(d.hasPopupsOpen()){if(!r.isChromeEvent(t)&&("focus"!==t.type||e.is(":focusable"))){var i=d.getDefaultLayer();if("keydown"!==t.type||!d.hasModalDialogOpen()||r.isAncestor(i[0],e[0])){var n=d.getFirstAncestorLayer(e),s=i.find("."+h._FOCUS_WITHIN_SELECTOR).first(),a=t.target.classList.contains(d._OVERLAY_SELECTOR);if(i[0]!==n[0]?n.hasClass(h._FOCUS_WITHIN_SELECTOR)||(s.length&&s.removeClass(h._FOCUS_WITHIN_SELECTOR),n.addClass(h._FOCUS_WITHIN_SELECTOR)):s.length&&!a&&s.removeClass(h._FOCUS_WITHIN_SELECTOR),"focus"!==t.type||"-1"!==e.attr("tabindex")){var l={};l.targetIsOverlay=a;for(var c=h._COPY_SAFE_EVENT_PROPERTIES,p={},u=0;u<c.length;u++){var _=c[u],f=t[_];void 0===f||o.isFunction(f)||(p[_]=f)}l.event=o.Event(t,p),d.postOrderVisit(i,h._redistributeVisitCallback,l)}}else d.eatEvent(t)}}else this._assertEventSink()},h._redistributeVisitCallback=function(t,e){var i=d.getEvents(t),n=e.event;return i&&o.isFunction(i[f.EVENT.POPUP_AUTODISMISS])?i[f.EVENT.POPUP_AUTODISMISS](n):"mousedown"===n.type&&e.targetIsOverlay&&n.preventDefault(),d.VISIT_RESULT.ACCEPT},h._refreshCallback=function(t){isNaN(h._refreshTimerId)&&(h._refreshTimerId=window.setTimeout(function(){h._refreshTimerId=Number.NaN;var t=d.getDefaultLayer();o.isFunction(window.requestAnimationFrame)?h._afRequestId=window.requestAnimationFrame(function(){h._afRequestId=null,d.postOrderVisit(t,h._refreshVisitCallback)}):d.postOrderVisit(t,h._refreshVisitCallback)},h._REFRESH_DELAY))},h._refreshVisitCallback=function(t,e){if(e.level>0)return d.VISIT_RESULT.REJECT;var i=d.getEvents(t);return i&&o.isFunction(i[f.EVENT.POPUP_REFRESH])&&i[f.EVENT.POPUP_REFRESH](),d.VISIT_RESULT.ACCEPT},h.prototype.destroy=function(){h.superclass.destroy.call(this)},h._FOCUS_WITHIN_SELECTOR="oj-focus-within",h._REDISTRIBUTE_EVENTS=["focus","mousedown","keydown"],h._COPY_SAFE_EVENT_PROPERTIES=["altKey","bubbles","cancelable","ctrlKey","currentTarget","eventPhase","metaKey","relatedTarget","shiftKey","target","timeStamp","view","which","button","buttons","clientX","clientY","offsetX","offsetY","pageX","pageY","screenX","screenY","toElement","char","charCode","key","keyCode"],h._REFRESH_DELAY=10,e._registerLegacyNamespaceProp("ZOrderUtils",d),d.STATUS={UNKNOWN:0,BEFORE_OPEN:.5,OPENING:1,OPEN:2,BEFORE_CLOSE:2.5,CLOSING:3,CLOSE:4},d._STATUS_DATA=Symbol("PopupStatus"),d.getStatus=function(t){t instanceof Element&&(t=o(t));var e=d.STATUS.UNKNOWN;return t.length&&(e=t[0][d._STATUS_DATA],isNaN(e)&&(e=d.STATUS.UNKNOWN)),e},d.setStatus=function(t,e){t instanceof Element&&(t=o(t));var i=t[0];e>=d.STATUS.UNKNOWN&&e<=d.STATUS.CLOSE&&(i[d._STATUS_DATA]=e)},d.getFirstAncestorLayer=function(t){if(!t)return d.getDefaultLayer();for(var e=t;e&&e.length>0&&e.attr(d._SURROGATE_ATTR)!==d._DEFAULT_LAYER_ID;){if(d._hasSurrogate(e[0]))return e;e=e.parent()}return d.getDefaultLayer()},d.getDefaultLayer=function(){var t=o(document.getElementById(d._DEFAULT_LAYER_ID));return t.length>0||((t=o("<div>")).attr("role","presentation"),t.attr("id",d._DEFAULT_LAYER_ID),t.prependTo(o(document.body))),t},d.addToAncestorLayer=function(t,n,r,s,a,l){var c=t[0];if(d._hasSurrogate(c.parentNode))throw new Error("JET Popup is already open - id: "+c.getAttribute("id"));var p=d.getFirstAncestorLayer(a===f.LAYER_LEVEL.TOP_LEVEL?null:n),u=o("<div>"),_=t.attr("id");e.StringUtils.isEmptyOrUndefined(_)?u.uniqueId():u.attr("id",[_,"layer"].join("_")),u.attr("role","presentation"),u.addClass(s),t.after(u);const h=d._createSurrogate(u,l);i.subtreeDetached(c),t.appendTo(u),c[d._LAYER_ID_DATA]=u.attr("id"),u.appendTo(p),i.subtreeAttached(c),d._applyVDomPatch(h[0],c),d.applyModality(u,t,r)},d._applyVDomPatch=function(t,e){t[s.OJ_POPUP]=e,s.patchPopupParent(t.parentElement)},d._getSurrogate=function(t){var e=t.attr(d._SURROGATE_ATTR);if(e)return document.getElementById(e)},d.applyEvents=function(t,e,n){n||(n=o(d._getSurrogate(t))),t.data(d._EVENTS_DATA,e),n.length>0&&e&&o.isFunction(e[f.EVENT.POPUP_REMOVE])&&i.setComponentOption(n[0],"beforeDestroy",e[f.EVENT.POPUP_REMOVE])},d.getEvents=function(t){return t.data(d._EVENTS_DATA)},d._createSurrogate=function(t,i){var n="script";i&&(n="oj-surrogate");var r=o(document.createElement(n)),s=t.attr("id");e.StringUtils.isEmptyOrUndefined(s)||r.attr("id",[s,"surrogate"].join("_")),i&&r.attr("data-oj-binding-provider","none"),r.insertBefore(t),i||r.ojSurrogate();var a=r.attr("id");return t.attr(d._SURROGATE_ATTR,a),r},d._removeSurrogate=function(t){var e=t.attr(d._SURROGATE_ATTR);t.removeAttr(d._SURROGATE_ATTR);var n=o(document.getElementById(e)),r=n.length>0;return r&&(t.insertAfter(n),i.setComponentOption(n[0],"beforeDestroy",null),n.remove()),r},d.getOpenPopupLayer=function(t){var e=t.parent(),i=t[0];if(!e||0===e.length){var n=i[d._LAYER_ID_DATA];e=o(document.getElementById(n))}return e},d.removeFromAncestorLayer=function(t){var e=d.getOpenPopupLayer(t);d.preOrderVisit(e,d._closeDescendantPopupsCallback),d._removeOverlayFromAncestorLayer(e),d._resetAriaHiddenOnBackround(e),d._restoreBodyOverflow(),e.removeData(d._EVENTS_DATA),e.removeData(d._MODALITY_DATA);var o=t[0];delete o[d._LAYER_ID_DATA],i.subtreeDetached(o),d._removeSurrogate(e)&&o&&o.parentElement?(r.unwrap(t,e),i.subtreeAttached(o)):e.remove()},d._closeDescendantPopupsCallback=function(t,e){if(e.level>0)return d.VISIT_RESULT.REJECT;var i=t.data(d._EVENTS_DATA);return i&&o.isFunction(i[f.EVENT.POPUP_CLOSE])&&i[f.EVENT.POPUP_CLOSE](),d.VISIT_RESULT.ACCEPT},d._disableBodyOverflow=function(t){const i=document.body,n=t.children()[0];if(Math.floor(o(n).width())<=window.innerWidth&&Math.floor(o(n).height())<=window.innerHeight)if(e.AgentUtils.getAgentInfo().os===e.AgentUtils.OS.IOS){if(this._iosScrollLockBackup)return;const t=window.visualViewport.offsetLeft,e=window.visualViewport.offsetTop,o=window.pageXOffset,n=window.pageYOffset;this._iosScrollLockBackup={windowScrollX:o,windowScrollY:n,bodyPosition:i.style.position,bodyOverflow:i.style.overflow,bodyTop:i.style.top,bodyLeft:i.style.left,bodyRight:i.style.right},i.style.position="fixed",i.style.overflow="hidden",i.style.top=-(n-Math.floor(e))+"px",i.style.left=-(o-Math.floor(t))+"px",i.style.right="0"}else i.classList.add("oj-component-modal-open")},d._restoreBodyOverflow=function(){if(!d.hasModalDialogOpen()){const t=document.body;if(e.AgentUtils.getAgentInfo().os===e.AgentUtils.OS.IOS){if(!this._iosScrollLockBackup)return;const e=this._iosScrollLockBackup;t.style.position=e.bodyPosition,t.style.overflow=e.bodyOverflow,t.style.top=e.bodyTop,t.style.left=e.bodyLeft,t.style.right=e.bodyRight,window.scrollTo(e.windowScrollX,e.windowScrollY),delete this._iosScrollLockBackup}else t.classList.remove("oj-component-modal-open")}},d._removeFocusWithinFromOverlayedContent=function(){var t=d.getDefaultLayer().find("."+h._FOCUS_WITHIN_SELECTOR).first();t.length&&t.removeClass(h._FOCUS_WITHIN_SELECTOR)},d.applyModality=function(t,o,i){var n=t.data(d._MODALITY_DATA);if(t.data(d._MODALITY_DATA,i),e.StringUtils.isEmptyOrUndefined(n)?f.MODALITY.MODAL===i?(d._addOverlayToAncestorLayer(t),d._disableBodyOverflow(t),d._removeFocusWithinFromOverlayedContent(),d._setAriaHiddenOnBackround(t)):d._removeOverlayFromAncestorLayer(t):n!==i&&(i===f.MODALITY.MODAL?(d._addOverlayToAncestorLayer(t),d._disableBodyOverflow(t),d._removeFocusWithinFromOverlayedContent(),d._setAriaHiddenOnBackround(t)):(d._removeOverlayFromAncestorLayer(t),d._restoreBodyOverflow(),d._resetAriaHiddenOnBackround(t))),i===f.MODALITY.MODAL){const t=o.attr("role");"dialog"!==t&&"alertdialog"!==t||o.attr("aria-modal","true")}else o.removeAttr("aria-modal")},d._setAriaHiddenOnBackround=function(t){var e=t,i=o();do{i=i.add(e.siblings(':not(script):not([aria-hidden="true"])')),e=e.parent()}while("body"!==e[0].tagName.toLowerCase());i.attr("aria-hidden",!0),t.data(d._ARIA_HIDDEN_ELEMS,i)},d._resetAriaHiddenOnBackround=function(t){var e=t.data(d._ARIA_HIDDEN_ELEMS);e&&(e.removeAttr("aria-hidden"),t.removeData(d._ARIA_HIDDEN_ELEMS))},d.hasModalDialogOpen=function(){for(var t=d.getDefaultLayer().children(),e=t.length-1;e>-1;e--){if(o(t[e]).hasClass(d._OVERLAY_SELECTOR))return!0}return!1},d._addOverlayToAncestorLayer=function(t){var i=o("<div>");i.addClass(d._OVERLAY_SELECTOR),i.addClass(t[0].className),i.attr("role","presentation");var n=t.attr("id");e.StringUtils.isEmptyOrUndefined(n)?i.uniqueId():i.attr("id",[n,"overlay"].join("_")),t.before(i);var r=i.attr("id");t.attr(d._OVERLAY_ATTR,r)},d._removeOverlayFromAncestorLayer=function(t){var i=t.attr(d._OVERLAY_ATTR);e.StringUtils.isEmptyOrUndefined(i)||(t.removeAttr(d._OVERLAY_ATTR),o(document.getElementById(i)).remove())},d.VISIT_RESULT={ACCEPT:0,REJECT:1,COMPLETE:2},d._VISIT_TRAVERSAL={PRE_ORDER:0,POST_ORDER:1},d.postOrderVisit=function(t,e,o){var i=o;o||(i={}),i.level=0,i.type=d._VISIT_TRAVERSAL.POST_ORDER,d._visitTree(t,e,i)},d.preOrderVisit=function(t,e,o){var i=o;o||(i={}),i.level=0,i.type=d._VISIT_TRAVERSAL.PRE_ORDER,d._visitTree(t,e,i)},d._visitTree=function(t,e,i){for(var n=i.level,r=t.children(),s=r.length-1;s>-1;s--){var a=o(r[s]);if(d._hasSurrogate(a[0])){var l;if(i.type===d._VISIT_TRAVERSAL.PRE_ORDER){if((l=e(a,i))===d.VISIT_RESULT.COMPLETE)return l;if(l===d.VISIT_RESULT.REJECT)break}if(i.level=n+1,l=d._visitTree(a,e,i),i.level=n,l===d.VISIT_RESULT.COMPLETE)return l;if(i.type===d._VISIT_TRAVERSAL.POST_ORDER){if((l=e(a,i))===d.VISIT_RESULT.COMPLETE)return l;if(l===d.VISIT_RESULT.REJECT)break}}}return d.VISIT_RESULT.ACCEPT},d._hasSurrogate=function(t){return!(!t||1!==t.nodeType||!t.hasAttribute(d._SURROGATE_ATTR))},d.hasPopupsOpen=function(){return d.getDefaultLayer().children().length>0},d.getOpenPopupCount=function(){var t={popupCount:0},e=d.getDefaultLayer();return d.preOrderVisit(e,d._openPopupCountCallback,t),t.popupCount},d._openPopupCountCallback=function(t,e){return e.popupCount+=1,d.VISIT_RESULT.ACCEPT},d.findOpenPopups=function(){var t={},e=[];t.popups=e;var i=d.getDefaultLayer();return d.preOrderVisit(i,d._openPopupsCallback,t),e=t.popups,o(e)},d._openPopupsCallback=function(t,e){return e.popups.push(t[0]),d.VISIT_RESULT.ACCEPT},d.isAboveTopModalLayer=function(t){if(!t||!d.hasPopupsOpen())return!0;var e=function(){var t={topLayer:null},e=d.getDefaultLayer();if(d.preOrderVisit(e,function(t,e){if(e.level>0)return d.VISIT_RESULT.REJECT;var i=e.topLayer;return i?d.compareStackingContexts(o(t),o(i))>0&&(e.topLayer=t):e.topLayer=t,d.VISIT_RESULT.ACCEPT},t),t.topLayer)return t.topLayer[0]}();if(!e)return!0;var i=function(t){var e={topModalPopup:null};if(t.hasAttribute(d._OVERLAY_ATTR)&&(e.topModalPopup=o(t)),d.postOrderVisit(o(t),function(t,e){return t[0].hasAttribute(d._OVERLAY_ATTR)?(e.topModalPopup=t,d.VISIT_RESULT.COMPLETE):d.VISIT_RESULT.ACCEPT},e),e.topModalPopup)return e.topModalPopup[0]}(e);return!i||(r.isAncestorOrSelf(i,t)||d.compareStackingContexts(o(i),o(t))<0)},d.compareStackingContexts=function(t,i){function n(t,e){var i,n=["absolute","relative","fixed"],s=t.parents(),a=[];for(i=s.length-1;i>-1;i--)a.push(o(s[i]));(s=a).push(t);var l=[],c=0;for(i=0;i<s.length;i++){var p=s[i],u=p.css("position"),_=r.getCSSLengthAsFloat(p.css("opacity")),f=r.getCSSLengthAsInt(p.css("z-index")),h=o.inArray(p[0],p.parent().children());o.inArray(u,n)>-1&&f>0?(l.push({weight:[c,f,h],order:[h]}),c+=1):_<1?(l.push({weight:[c,1,h],order:[h]}),c+=1):e&&l.push({weight:[0,0,h],order:[h]})}return l}function s(t,e){for(var o=Math.max(t.length,e.length),i=0;i<o;i++){var n=i<t.length?t[i]:0,r=i<e.length?e[i]:0;if(n!==r)return n<r?-1:1}return 0}e.Assert.assertPrototype(t,o),e.Assert.assertPrototype(i,o);var a,l,c=n(t,!1),p=n(i,!1),u=Math.max(c.length,p.length);for(a=0;a<u;a++)if(0!==(l=s(a<c.length?c[a].weight:[-1],a<p.length?p[a].weight:[-1])))return l;for(c=n(t,!0),p=n(i,!0),u=Math.max(c.length,p.length),a=0;a<u;a++)if(0!==(l=s(a<c.length?c[a].order:[-1],a<p.length?p[a].order:[-1])))return l;return 0},d.eatEvent=function(t){t.stopPropagation(),t.preventDefault()},d.isPopupOpen=function(t){var e=t.parent();return!(!e||1!==e.length||!d._hasSurrogate(e[0]))},d._EVENTS_DATA="oj-popup-events",d._MODALITY_DATA="oj-popup-modality",d._ARIA_HIDDEN_ELEMS="oj-aria-hidden-elems",d._DEFAULT_LAYER_ID="__oj_zorder_container",d._SURROGATE_ATTR="data-oj-surrogate-id",d._LAYER_ID_DATA=Symbol("PopupLayerId"),d._OVERLAY_ATTR="data-oj-overlayid",d._OVERLAY_SELECTOR="oj-component-overlay";const E={};e._registerLegacyNamespaceProp("PositionUtils",E),E.normalizeHorizontalAlignment=function(t,i){for(var n=o.extend({},t),r=0;r<E._ALIGN_RULE_PROPERTIES.length;r++){var s=E._ALIGN_RULE_PROPERTIES[r],a=n[s];if(a)if(e.StringUtils.isString(a))n[s]=a.replace("start",i?"right":"left").replace("end",i?"left":"right").replace("<",i?"+":"-").replace(">",i?"-":"+");else for(var l=0;l<E._SUB_ALIGN_RULE_PROPERTIES.length;l++){var c=E._SUB_ALIGN_RULE_PROPERTIES[l],p=a[c];e.StringUtils.isString(p)&&(a[c]=p.replace("start",i?"right":"left").replace("end",i?"left":"right").replace("<",i?"+":"-").replace(">",i?"-":"+"))}}return n},E.normalizePositionOf=function(t,e,o){return"event"===t?o:null==t||"launcher"===t?e:t},E._normalizeEventForPosition=function(t){o.each(["pageX","pageY"],function(e,o){if(t&&void 0===t[o]&&t.originalEvent){var i,n=t.originalEvent,r=n.type;if(i="touchstart"===r||"touchmove"===r?"touches":"touchend"===r?"changedTouches":null){var s=n[i][0];s&&(t[o]=s[o])}}})},E._ALIGN_RULE_PROPERTIES=["my","at"],E._SUB_ALIGN_RULE_PROPERTIES=["vertical","horizontal"],E.isAligningPositionClipped=function(t){if(t.target&&t.target.height>0&&t.target.width>0){var e=t.target.element;return!E.isWithinViewport(e)}return!1},E.isWithinViewport=function(t){function e(t,e){var o;if(["hidden","scroll","auto"].indexOf(e.overflowY)>-1){if(t.bottom-e.top<-1)return!1;if(o="auto"===e.overflowX&&e.scrollWidth>e.innerWidth||"scroll"===e.overflowX?r.getScrollBarWidth():0,e.bottom-o-t.top<1)return!1}return!(["hidden","scroll","auto"].indexOf(e.overflowX)>-1&&(o="auto"===e.overflowY&&e.scrollHeight>e.innerHeight||"scroll"===e.overflowY?r.getScrollBarWidth():0,t.right-(e.left+("rtl"===r.getReadingDirection()?o:0))<-1||t.left-(e.right-("ltr"===r.getReadingDirection()?o:0))>-1))}function i(t){var e=t[0];if(1===e.nodeType){var i=o.extend({},e.getBoundingClientRect());return i.overflowX=t.css("overflow-x"),i.overflowY=t.css("overflow-y"),i.innerHeight=t.innerHeight(),i.innerWidth=t.innerWidth(),i.scrollHeight=e.scrollHeight,i.scrollWidth=e.scrollWidth,i}return{height:0,width:0}}function n(t){return["fixed","absolute","relative","sticky"].indexOf(t.css("position"))>-1&&(!isNaN(parseInt(t.css("top"),10))||!isNaN(parseInt(t.css("bottom"),10))||!isNaN(parseInt(t.css("left"),10))||!isNaN(parseInt(t.css("right"),10)))}if(!t)return!1;if(o.isWindow(t[0])||n(t))return!0;for(var s,a=i(t),l=!0,c=t.parent();l&&c&&c.length>0&&"BODY"!==c[0].nodeName&&1===c[0].nodeType&&!n(c);){if("visible"!==(s=c).css("overflow-x")||"visible"!==s.css("overflow-y")){var p=i(c);p.height>0&&p.width>0&&(l=e(a,p))}c=c.parent()}return l},E._ANIMATION_TRANSFORM_ORIGIN_RULES={"right-top":"right top","right-middle":"right center","right-bottom":"right bottom","left-top":"left top","left-middle":"left center","left-bottom":"left bottom","center-top":"center top","center-middle":"center center","center-bottom":"center bottom"},E._ALIGN_MNEMONIC_DATA="oj-popup-align-mnemonic",E.captureTransformOriginAnimationEffectsOption=function(t,e){var o=[e.horizontal,e.vertical].join("-");t.data(E._ALIGN_MNEMONIC_DATA,o)},E.addTransformOriginAnimationEffectsOption=function(t,o){var i,n;e.StringUtils.isString(o)?(n=!0,i=o):(n=!1,i=JSON.stringify(o));var r=/#myPosition/g;if(i.match(r)){var s=t.data(E._ALIGN_MNEMONIC_DATA);e.StringUtils.isEmptyOrUndefined(s)&&(s="center-middle");var a=E._ANIMATION_TRANSFORM_ORIGIN_RULES[s];i=i.replace(r,a),o=n?i:JSON.parse(i)}return o},E._JQUI_MNEMONIC_GRP_REGX=/^(\w+)(\+|-)?(\d+)?/,E._VERTICAL_ENUM_TST_REGX=/^top$|^center$|^bottom$/,E._HORIZONTAL_ENUM_TST_REGX=/^start$|^left$|^center$|^end$|^right$/,E._COLLISION_ENUM_TST_REGX=/^none$|^flip$|^flipfit$|^fit$|^flipcenter$/,E._parsePositionNmnemonic=function(t,e){var o=[null,Number.NaN],i=E._JQUI_MNEMONIC_GRP_REGX.exec(t);if(i[1]&&e.test(i[1])&&(o[0]=i[1],i[2])){var n=parseInt(i[3],10);isNaN(n)||(n*="-"===i[2]?-1:1,o[1]=n)}return o},E._parseJSON=function(t){if(e.StringUtils.isString(t)&&/^{/.test(t)&&/}$/.test(t))try{return JSON.parse(t)}catch(t){}return null},E._coerceMyAtToJet=function(t,i,n,s){var a=E._parseJSON(i);a&&(i=a),(a=E._parseJSON(n))&&(n=a),s||(s={});var l,c=o.extend({},s),p={x:0,y:0};if(n&&"x"in n&&"y"in n&&(p.x=r.getCSSLengthAsInt(n.x),p.y=r.getCSSLengthAsInt(n.y)),e.StringUtils.isString(i)){var u=i.split(/\s/);u.length>0&&!e.StringUtils.isEmpty(u[0])&&(l=E._parsePositionNmnemonic(u[0],E._HORIZONTAL_ENUM_TST_REGX))[0]&&(c.horizontal=l[0],isNaN(l[1])||(p.x=l[1])),u.length>1&&!e.StringUtils.isEmpty(u[1])&&(l=E._parsePositionNmnemonic(u[1],E._VERTICAL_ENUM_TST_REGX))[0]&&(c.vertical=l[0],isNaN(l[1])||(p.y=l[1]))}else i&&("horizontal"in i&&(l=E._parsePositionNmnemonic(i.horizontal,E._HORIZONTAL_ENUM_TST_REGX))[0]&&(c.horizontal=l[0],isNaN(l[1])||(p.x=l[1])),"vertical"in i&&(l=E._parsePositionNmnemonic(i.vertical,E._VERTICAL_ENUM_TST_REGX))[0]&&(c.vertical=l[0],isNaN(l[1])||(p.y=l[1])));var _={};return _[t]=c,_.offset=p,_},E._coerceCollisionToJet=function(t,e){var o=e;return E._COLLISION_ENUM_TST_REGX.test(t)&&(o=t),{collision:o}},E._coerceOfToJet=function(t,i){var n=E._parseJSON(t);n&&(t=n);var s=i;if(e.StringUtils.isString(t))s=t;else if(o.isWindow(t))s="window";else if(t instanceof Element||t instanceof o){(t=o(t)).uniqueId(),s="#"+function(t){for(var e=[],o=/\w|_|-/,i=0;i<t.length;i++){var n=t.substring(i,i+1);o.test(n)?e.push(n):e.push("\\"+n)}return e.join("")}(t.attr("id"))}else t instanceof Event||t instanceof o.Event?("pageX"in t||"pageY"in t)&&((s={}).x=r.getCSSLengthAsFloat(t.pageX),s.y=r.getCSSLengthAsFloat(t.pageY)):t&&("x"in t||"y"in t)&&((s={}).x=r.getCSSLengthAsFloat(t.x),s.y=r.getCSSLengthAsFloat(t.y));return{of:s}},E.coerceToJet=function(t,e){t||(t={});var i=E._parseJSON(t);i&&(t=i),e||(e={});var n=e.my,r=e.at,s=e.collision,a=e.of,l=E._coerceMyAtToJet("my",t.my,t.offset,n),c=E._coerceMyAtToJet("at",t.at,null,r),p={offset:{x:l.offset.x+c.offset.x,y:l.offset.y+c.offset.y}};delete l.offset,delete c.offset;var u=o.extend({},l,c,p,E._coerceCollisionToJet(t.collision,s),E._coerceOfToJet(t.of,a),function(t,e){return{using:o.isFunction(t)?t:e}}(t.using,undefined));return u},E.coerceToJqUi=function(t){function i(e,o){var i=[];if(t[e][o]?i.push(t[e][o]):i.push("center"),"my"===e&&t.offset){var n="horizontal"===o?"x":"y",r=t.offset[n];isNaN(r)||0===r||(i.push(r>0?"+":""),i.push(Math.floor(r).toString()))}return i.join("")}var n={};["my","at"].forEach(function(e){if(t[e]){var o=[];o.push(i(e,"horizontal")),o.push(" "),o.push(i(e,"vertical")),n[e]=o.join("")}});var r=t.of;if(e.StringUtils.isString(r))n.of="window"===r?window:r;else if(r&&!e.StringUtils.isString(r)&&"x"in r&&"y"in r){var s=r.x,a=r.y,l=document.createEvent("MouseEvents");l.initMouseEvent("click",!0,!0,window,1,s,a,s,a,!1,!1,!1,!1,0,null),n.of=o.Event(l,{pageX:s,pageY:a})}else n.of=r;return t.collision&&(n.collision=t.collision),t.using&&(n.using=t.using),n},E.calcAvailablePopupSize=function(t,e,i){var n,s,a,l,c=o.position.getWithinInfo(i||window),p=o.position.getScrollInfo(c),u="rtl"===r.getReadingDirection(),_=u?p.width:0,f=u?0:p.width,h=e.element,d=e.target,E=c.isWindow?c.scrollLeft:0,g=c.isWindow?c.scrollTop:0,v=h.left,O=h.left+h.width,T=h.top,S=h.top+h.height,P=d.left,m=d.left+d.width,y=d.top,A=d.top+d.height,L=c.offset.left+E+_,I=c.offset.left+c.width+E-f,R=c.offset.top+g,N=c.offset.top+c.height+g-p.height;return v<P?(n=L,s=O<=P?P:O<=m?Math.min(m,I):I):v===P?P-L>I-m?(n=L,s=m):(n=P,s=I):v<m?(n=P,s=O<=m?m:I):(n=m,s=I),T<y?(a=R,l=S<=y?y:S<=A?Math.min(A,N):N):T===y?(a=y,l=N):T<A?(a=y,l=S<=A?A:N):(a=A,l=N),{width:s-n,height:l-a}},function(){var t,i=Math.max,n=Math.abs;const s=/left|center|right/,a=/top|center|bottom/,l=/[+-]\d+(\.[\d]+)?%?/,c=/^\w+/,p=/%$/;var u=o.fn.position,_=o.position.getWithinInfo;function f(t,e,o){return[parseFloat(t[0])*(p.test(t[0])?e/100:1),parseFloat(t[1])*(p.test(t[1])?o/100:1)]}function h(t,e){return parseInt(o.css(t,e),10)||0}o.position={getWithinInfo:_.bind(this),scrollbarWidth:function(){if(void 0!==t)return t;var e,i,n=document.createElement("div");n.style.display="block",n.style.position="absolute",n.style.width="50px",n.style.height="50px",n.style.overflow="hidden";var r=document.createElement("div");return r.style.height="100px",r.style.width="auto",n.appendChild(r),o("body").append(o(n)),e=r.offsetWidth,n.style.overflow="scroll",e===(i=r.offsetWidth)&&(i=n.clientWidth),o(n).remove(),t=e-i},getScrollInfo:function(t){var e=t.isWindow||t.isDocument?"":t.element.css("overflow-x"),i=t.isWindow||t.isDocument?"":t.element.css("overflow-y"),n="scroll"===e||"auto"===e&&t.width<t.element[0].scrollWidth;return{width:"scroll"===i||"auto"===i&&t.height<t.element[0].scrollHeight?o.position.scrollbarWidth():0,height:n?o.position.scrollbarWidth():0}}},o.fn.position=function(t){if(!t||!t.of)return u.apply(this,arguments);var r,p,_,d,E,g,v="string"==typeof(t=o.extend({},t)).of?o(document).find(t.of):o(t.of),O=o.position.getWithinInfo(t.within),T=o.position.getScrollInfo(O),S=(t.collision||"flip").split(" "),P={};return g=function(t){var o,i=t[0];if(9===i.nodeType)return{width:t.width(),height:t.height(),offset:{top:0,left:0}};if(null!=(o=i)&&o===o.window){var n=e.AgentUtils.getAgentInfo(),r=e.AgentUtils.OS.ANDROID===n.os||e.AgentUtils.OS.IOS===n.os;return{width:t.width(),height:r?i.innerHeight:t.height(),offset:{top:t.scrollTop(),left:t.scrollLeft()}}}return i.preventDefault?{width:0,height:0,offset:{top:i.pageY,left:i.pageX}}:{width:t.outerWidth(),height:t.outerHeight(),offset:t.offset()}}(v),v[0].preventDefault&&(t.at="left top"),p=g.width,_=g.height,d=g.offset,E=o.extend({},d),o.each(["my","at"],function(){var e,o,i=(t[this]||"").split(" ");1===i.length&&(i=s.test(i[0])?i.concat(["center"]):a.test(i[0])?["center"].concat(i):["center","center"]),i[0]=s.test(i[0])?i[0]:"center",i[1]=a.test(i[1])?i[1]:"center",e=l.exec(i[0]),o=l.exec(i[1]),P[this]=[e?e[0]:0,o?o[0]:0],t[this]=[c.exec(i[0])[0],c.exec(i[1])[0]]}),1===S.length&&(S[1]=S[0]),"right"===t.at[0]?E.left+=p:"center"===t.at[0]&&(E.left+=p/2),"bottom"===t.at[1]?E.top+=_:"center"===t.at[1]&&(E.top+=_/2),r=f(P.at,p,_),E.left+=r[0],E.top+=r[1],this.each(function(){var e,s,a=o(this),l=a.outerWidth(),c=a.outerHeight(),u=h(this,"marginLeft"),g=h(this,"marginTop"),m=l+u+h(this,"marginRight")+T.width,y=c+g+h(this,"marginBottom")+T.height,A=o.extend({},E),L=f(P.my,a.outerWidth(),a.outerHeight());"right"===t.my[0]?A.left-=l:"center"===t.my[0]&&(A.left-=l/2),"bottom"===t.my[1]?A.top-=c:"center"===t.my[1]&&(A.top-=c/2),A.left+=L[0],A.top+=L[1],e={marginLeft:u,marginTop:g},o.each(["left","top"],function(i,n){o.ui.position[S[i]]&&o.ui.position[S[i]][n](A,{targetWidth:p,targetHeight:_,elemWidth:l,elemHeight:c,collisionPosition:e,collisionWidth:m,collisionHeight:y,offset:[r[0]+L[0],r[1]+L[1]],my:t.my,at:t.at,within:O,elem:a})}),A.left=Math.round(A.left),A.top=Math.round(A.top),t.using&&(s=function(e){var o=d.left-A.left,r=o+p-l,s=d.top-A.top,u=s+_-c,f={target:{element:v,left:d.left,top:d.top,width:p,height:_},element:{element:a,left:A.left,top:A.top,width:l,height:c},horizontal:r<0?"left":o>0?"right":"center",vertical:u<0?"top":s>0?"bottom":"middle"};p<l&&Math.abs(o+r)<p&&(f.horizontal="center"),_<c&&Math.abs(s+u)<_&&(f.vertical="middle"),i(n(o),n(r))>i(n(s),n(u))?f.important="horizontal":f.important="vertical",t.using.call(this,e,f)}),a.offset(o.extend(A,{using:s}))})};var d=o.ui.position.flip.left;o.ui.position.flip={left:d.bind(this),top:function(t,e){var o,i,n=e.within,r=n.offset.top+n.scrollTop,s=n.height,a=n.isWindow?n.scrollTop:n.offset.top,l=t.top-e.collisionPosition.marginTop,c=l-a,p=l+e.collisionHeight-s-a;o="top"===e.my[1]?-e.elemHeight:"bottom"===e.my[1]?e.elemHeight:0,i="top"===e.at[1]?e.targetHeight:"bottom"===e.at[1]?-e.targetHeight:0;var u,_,f=-2*e.offset[1];c<0?((u=t.top+o+i+f+e.collisionHeight-s-r)<0||u<Math.abs(c))&&p<0&&c>p&&(t.top+=o+i+f):p>0&&((_=t.top-e.collisionPosition.marginTop+o+i+f-a)>0||Math.abs(_)<p)&&(t.top+=o+i+f)}},o.ui.position.fit={left:function(t,e){var o,i=e.within,n=i.isWindow?i.scrollLeft:i.offset.left,r=i.width,s=t.left-e.collisionPosition.marginLeft,a=n-s,l=s+e.collisionWidth-r-n;e.collisionWidth>r?a>0&&l<=0?(o=t.left+a+e.collisionWidth-r-n,t.left+=a-o):t.left=l>0&&a<=0?n:a>l?n+r-e.collisionWidth:n:a>0?t.left+=a:l>0?t.left-=l:t.left=Math.max(t.left-s,t.left),t.left<0&&(t.left=0)},top:function(t,e){var o,i=e.within,n=i.isWindow?i.scrollTop:i.offset.top,r=e.within.height,s=t.top-e.collisionPosition.marginTop,a=n-s,l=s+e.collisionHeight-r-n;e.collisionHeight>r?a>0&&l<=0?(o=t.top+a+e.collisionHeight-r-n,t.top+=a-o):t.top=l>0&&a<=0?n:a>l?n+r-e.collisionHeight:n:a>0?t.top+=a:l>0?t.top-=l:t.top=Math.max(t.top-s,t.top),t.top<0&&(t.top=0)}},o.ui.position.flipcenter={left:function(t,e){var i=t.left;o.ui.position.flip.left.call(this,t,e);var n=e.within,s=n.isWindow?n.scrollLeft:n.offset.left,a=n.width,l=t.left-e.collisionPosition.marginLeft,c=s-l,p=l+e.collisionWidth-a-s;(c>0||p>0)&&("right"===e.at[0]?i-=e.targetWidth/2:"left"===e.at[0]&&(i+=e.targetWidth/2),((i-=("rtl"===r.getReadingDirection()?-1:1)*(e.elemWidth/2))<s||i+e.elemWidth>a-s)&&(o.ui.position.fit.left.call(this,t,e),i=t.left),t.left=Math.max(0,i))},top:function(t,e){var i=t.top;o.ui.position.flip.top.call(this,t,e);var n=e.within,r=n.isWindow?n.scrollTop:n.offset.top,s=e.within.height,a=t.top-e.collisionPosition.marginTop,l=r-a,c=a+e.collisionHeight-s-r;(l>0||c>0)&&("top"===e.at[1]?i+=e.targetHeight/2:"bottom"===e.at[1]&&(i-=e.targetHeight/2),i+=e.elemHeight/2,t.top=Math.max(0,i))}}}();const g=function(){this.Init()};e._registerLegacyNamespaceProp("PopupLiveRegion",g),e.Object.createSubclass(g,e.Object,"oj.PopupLiveRegion"),g.prototype.Init=function(){g.superclass.Init.call(this),isNaN(g._refCounter)?g._refCounter=1:g._refCounter+=1},g.prototype.destroy=function(){if(!isNaN(g._refCounter)&&(g._refCounter-=1)<1){var t=o(document.getElementById(g._POPUP_LIVE_REGION_ID));t.length>0&&t.remove()}},g.prototype.announce=function(t){if(!e.StringUtils.isEmpty(t)){var i=g._getLiveRegion();i.children().remove(),setTimeout(function(){o("<div>").text(t).appendTo(i)},250)}},g._getLiveRegion=function(){var t=o(document.getElementById(g._POPUP_LIVE_REGION_ID));return 0===t.length&&((t=o("<div>")).attr({id:g._POPUP_LIVE_REGION_ID,role:"log","aria-live":"polite","aria-relevant":"additions"}),t.addClass("oj-helper-hidden-accessible"),t.appendTo(document.body)),t},g._POPUP_LIVE_REGION_ID="__oj_popup_arialiveregion";const v=function(t,i,n,r,s){e.Assert.assertPrototype(t,o),e.Assert.assertString(i),e.Assert.assertFunction(n),e.Assert.assertStringOrNull(r),this._options={insertBefore:!1,preventKeyEvents:!0},s&&(this._options=Object.assign({},this._options,s)),this._sibling=t,this._message=i,this._callback=n,this._id=r,this.Init()};e._registerLegacyNamespaceProp("PopupSkipLink",v),e.Object.createSubclass(v,e.Object,"oj.PopupSkipLink"),v.prototype.Init=function(){v.superclass.Init.call(this);var t=this._sibling,e=this._callback,i=this._message,n=this._options.insertBefore,r=this._options.preventKeyEvents;this._message=null;var s=this._id;this._id=null;var a=o(document.getElementById(s));a.length<1&&(a=o("<a>").attr({tabindex:"-1",href:"#",role:"link"})),a.attr("id",s),a.addClass("oj-helper-hidden-accessible"),a.text(i),n?a.insertBefore(t):a.insertAfter(t),a.on("click",v._activateHandler.bind(this,e)),r&&a.on("keydown keyup keypress",v._keyHandler),t[0][v._SKIPLINK_ATTR]=a},v._activateHandler=function(t,e){d.eatEvent(e),window.setImmediate(t)},v._keyHandler=function(t){t.keyCode===o.ui.keyCode.ENTER&&d.eatEvent(t)},v.prototype.destroy=function(){var t=this._sibling;if(delete this._sibling,delete this._callback,t){var e=t[0][v._SKIPLINK_ATTR];delete t[0][v._SKIPLINK_ATTR],e&&(e.off("click keydown keyup keypress"),e.remove())}},v.prototype.getLink=function(){var t,e=this._sibling;return e&&(t=e[0][v._SKIPLINK_ATTR]),t},v._SKIPLINK_ATTR=Symbol("ojSkipLink");const O=function(t,e,o,i){this._element=t,this._operation=e,this._widgetName=o,this._isCustomElement=!!i,this.Init()};e._registerLegacyNamespaceProp("PopupWhenReadyMediator",O),e.Object.createSubclass(O,e.Object,"oj.PopupWhenReadyMediator"),O.prototype.Init=function(){O.superclass.Init.call(this),this._resolvedQueue=[],this._callback=this._eventHandler.bind(this);var t=this._operation,e=["oj"];this._isCustomElement?(e.push(t.charAt(0).toUpperCase()),e.push(t.slice(1))):e.push(t);var o=e.join("");this._eventType=o,this._element.on(o,this._callback);var i=l.getContext(this._element[0]).getBusyContext(),n={description:this._getBusyStateDescription.bind(this,this._element,this._operation,this._widgetName)},r=i.addBusyState(n);this.AddPromiseExecutor(r),this._whenReadyPromise=new Promise(this.AddPromiseExecutor.bind(this))},O.prototype._getBusyStateDescription=function(t,e,o){return o+" identified by '"+t.attr("id")+"' is busy animating on the '"+e+"' operation."},O.prototype._deliverResolved=function(t){var e=this._resolvedQueue;this._resolvedQueue=null;var o=t||this._operation;this._operation=null;for(var i=0;i<e.length;i++)try{e[i](o)}catch(t){n.error("Error resolving whenReady promises:\n%o",t)}this._whenReadyPromise=Promise.resolve("none")},O.prototype.destroy=function(){if(this._resolvedQueue&&this._deliverResolved("none"),this._callback){var t=this._eventType;this._element.off(t,this._callback)}this._callback=null,this._element=null,this._operation=null,this._whenReadyPromise=null,this._widgetName=null,this._eventType=null},O.prototype.getWhenReadyPromise=function(){return this._whenReadyPromise},O.prototype._eventHandler=function(t){t.target===this._element[0]&&(this._element.off(t.type,this._callback),this._deliverResolved(),this._callback=null)},O.prototype._getPendingOperation=function(){return this._operation?this._operation:"none"},O.prototype.AddPromiseExecutor=function(t,e){this._resolvedQueue&&this._resolvedQueue.push(t)},O.prototype.isOperationPending=function(t,e,o,i){var r=!1,s=this._widgetName,a=this._getPendingOperation();if(e===a)n.info("An %s instance invoked a '%s' operation while pending animation of the same type of operation.  The second request will be ignored.",s,e),r=!0;else if("none"!==a){n.info("An %s instance invoked a '%s' operation while pending animation of a '%s' operation. The second request will be invoked after the pending operation completes.",s,e,a),new Promise(this.AddPromiseExecutor.bind(this)).then(function(){this[o].apply(this,i)}.bind(t)),r=!0}return r};class T extends p.Component{constructor(){super(...arguments),this._setRootRef=t=>{this._rootRef=t}}render(t){return c.jsx("div",{style:{display:"none"},ref:this._setRootRef,children:t.children})}componentDidMount(){this._popup=o(this._rootRef.firstChild);const t={[f.OPTION.POPUP]:this._popup,[f.OPTION.EVENTS]:{[f.EVENT.POPUP_AUTODISMISS]:this.props.autoDismiss,[f.EVENT.POPUP_REFRESH]:function(){this._popup.position(this._getPosition())}.bind(this)},[f.OPTION.LAYER_SELECTORS]:this.props.layerSelectors,[f.OPTION.CUSTOM_ELEMENT]:!0,[f.OPTION.LAUNCHER]:o(this._rootRef),[f.OPTION.POSITION]:this._getPosition()};f.getInstance().open(t)}componentWillUnmount(){f.getInstance().close({[f.OPTION.POPUP]:this._popup})}componentDidUpdate(){this._popup.position(this._getPosition())}_getPosition(){return E.normalizeHorizontalAlignment(this.props.position,"rtl"===r.getReadingDirection())}}var S;T.defaultProps={autoDismiss:null,layerSelectors:"",position:{}};const P=u.ElementUtils.getUniqueId.bind(null,null),m=Symbol();class y{}S=y,y._getPopupServiceOptions=(t,o,i,n)=>{const r={},s=e.PopupService.OPTION;r[s.POPUP]=t,r[s.LAUNCHER]=o,r[s.LAYER_SELECTORS]="dialog"===n?"oj-dialog-layer":"messages"===n?"oj-messages-layer":"oj-popup-layer",r[s.LAYER_LEVEL]=i??e.PopupService.LAYER_LEVEL.NEAREST_ANCESTOR,r[s.CUSTOM_ELEMENT]=!1;const a=e.PopupService.EVENT;return r[s.EVENTS]={[a.POPUP_BEFORE_OPEN]:()=>{},[a.POPUP_AFTER_OPEN]:()=>{},[a.POPUP_BEFORE_CLOSE]:()=>{},[a.POPUP_AFTER_CLOSE]:()=>{},[a.POPUP_AUTODISMISS]:()=>{},[a.POPUP_REFRESH]:()=>{},[a.POPUP_CLOSE]:()=>{S._closeLayerHost(t,o)},[a.POPUP_REMOVE]:()=>{}},r},y.getLayerHost=(t,e,o)=>{const i=t.anchorRef;let n,r;return t[m]?n=document.getElementById(t[m]):t[m]=`__v_layer_host_${P()}`,n||(r=null!=i?i.current:t,S._openLayerHost(t[m],r,e,o))},y._openLayerHost=(t,o,i,n)=>{if(!t)return;let r=document.getElementById(t);r||(r=document.createElement("div"),r.setAttribute("id",t),r.setAttribute("data-oj-binding-provider","preact"),document.body.appendChild(r));const s=e.PopupService.getInstance(),a=S._getPopupServiceOptions(r,o,i,n);return s.open(a),r},y._closeLayerHost=(t,o)=>{if(!t)return;const i=e.PopupService.getInstance(),n=S._getPopupServiceOptions(t,o);i.close(n),t.remove()},y.onLayerUnmount=(t,o)=>{if(!t)return;const i=document.getElementById(t[m]);if(i&&0===i.children.length){delete t[m];const o=e.PopupService.getInstance(),n=S._getPopupServiceOptions(i,null);o.close(n),i.remove()}},e._registerLegacyNamespaceProp("VLayerUtils",y),t.PopupLiveRegion=g,t.PopupService=f,t.PopupSkipLink=v,t.PopupWhenReadyMediator=O,t.PositionUtils=E,t.VLayerUtils=y,t.VPopup=T,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojpopupcore.js.map