/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojcore-base","ojs/ojmessaging","ojs/ojpagingtabledatasource"],function(t,e,n,a){"use strict";e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e,n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n;const r=function(t,e){this.m_cellSet=t,this.m_startIndex=e};e._registerLegacyNamespaceProp("PagingCellSet",r),r.prototype.getData=function(t){var e={column:t.column,row:t.row+this.m_startIndex};return this.m_cellSet.getData(e)},r.prototype.getMetadata=function(t){var e={column:t.column,row:t.row+this.m_startIndex};return this.m_cellSet.getMetadata(e)},r.prototype.getCount=function(t){return this.m_cellSet.getCount(t)},r.prototype.getCellSet=function(){return this.m_cellSet},r.prototype.getStartIndex=function(){return this.m_startIndex},r.prototype.getExtent=function(t){var e={column:t.column,row:t.row+this.m_startIndex};return this.m_cellSet.getExtent(e)};const i=function(t,a){if(!(t instanceof e.DataGridDataSource))throw new n("Not a datagridatasource","Not a datagridatasource",n.SEVERITY_LEVEL.ERROR);this.dataSource=t,this._startIndex=0,this.Init()};e._registerLegacyNamespaceProp("PagingDataGridDataSource",i),e.Object.createSubclass(i,e.DataGridDataSource,"oj.PagingDataGridDataSource"),i.prototype.Init=function(){i.superclass.Init.call(this),this._registerEventListeners()},i.prototype._registerEventListeners=function(){this.dataSource.on("change",this._handleChange.bind(this))},i.prototype.getPage=function(){return this._page},i.prototype.setPage=function(t,n){n=n||{},t=parseInt(t,10);try{i.superclass.handleEvent.call(this,e.PagingModel.EventType.BEFOREPAGE,{page:t,previousPage:this._page})}catch(t){return Promise.reject(t)}this._pageSize=null!=n.pageSize?n.pageSize:this._pageSize,n.startIndex=t*this._pageSize;var a=this._page;this._page=t,this._startIndex=n.startIndex;var r=this;return new Promise(function(t,e){r._fetchInternal(n).then(function(){t(null)},function(t){r._page=a,r._startIndex=r._page*r._pageSize,e(t)})})},i.prototype._fetchInternal=function(t){this._initialized=!0,this._startIndex=t.startIndex;var e=this;return new Promise(function(t){e.handleEvent("change",{operation:"sync",pageSize:e._pageSize}),t(void 0)})},i.prototype.fetch=function(t){return this._pageSize=t.pageSize+t.startIndex,t.startIndex=0,this._fetchInternal(t)},i.prototype.getStartItemIndex=function(){return this._startIndex},i.prototype.getEndItemIndex=function(){return this._endIndex},i.prototype.getPageCount=function(){var t=this.totalSize();return-1===t?-1:Math.ceil(t/this._pageSize)},i.prototype._handleChange=function(t){switch(t.operation){case"refresh":this._startIndex=0,this._page=0,this.handleEvent("change",{operation:"sync",pageSize:this._pageSize}),this.handleEvent(e.PagingTableDataSource.EventType.REFRESH,null);break;case"reset":this.handleEvent(e.PagingTableDataSource.EventType.RESET,null);break;case"insert":this.handleEvent(e.PagingTableDataSource.EventType.ADD,{index:t.indexes.row});break;case"delete":this.handleEvent(e.PagingTableDataSource.EventType.REMOVE,null);break;case"update":t.indexes.row=t.indexes.row-this._startIndex>=0?t.indexes.row-this._startIndex:-1,this.handleEvent("change",t);break;default:this.handleEvent("change",t),this.handleEvent(e.PagingTableDataSource.EventType.SYNC,null)}},i.prototype.getCount=function(t){var e=this.dataSource.getCount(t);return"row"===t&&e>=0?this._startIndex+this._pageSize<e?this._pageSize:e-this._startIndex:e},i.prototype.getCountPrecision=function(t){return this.dataSource.getCountPrecision(t)},i.prototype.fetchHeaders=function(t,e,n){null==this._initialized?null!=e&&e.success&&e.success.call(n.success,null,t,null):"row"===t.axis?(t.start+=this._startIndex,t.start+t.count>this._startIndex+this._pageSize&&(t.count=this._pageSize-t.start),this._pendingRowHeaderCallback={headerRange:t,callbacks:e,callbackObjects:n},this.dataSource.fetchHeaders(t,{success:this._handleRowHeaderFetchSuccess.bind(this),error:this._handleRowHeaderFetchError.bind(this)},n)):this.dataSource.fetchHeaders(t,e,n)},i.prototype._handleRowHeaderFetchSuccess=function(t,n,a){var r,i;if(this._pendingRowHeaderCallback.headerRange===n){n.start-=this._startIndex,n.count+=1,null!=t&&(r=new e.PagingHeaderSet(t,this._startIndex)),null!=a&&(i=new e.PagingHeaderSet(a,this._startIndex));var s=this._pendingRowHeaderCallback.callbacks.success,o=this._pendingRowHeaderCallback.callbackObjects.success;this._pendingRowHeaderCallback=null,s.call(o,r,n,i)}},i.prototype._handleRowHeaderFetchError=function(t){var e=this._pendingRowHeaderCallback.callbacks.error,n=this._pendingRowHeaderCallback.callbackObjects.error;this._pendingRowHeaderCallback=null,e.call(n,t)},i.prototype.fetchCells=function(t,e,n){if(null==this._initialized){var a={getData:function(){return null},getMetaData:function(){return null},getStart:function(){return 0},getCount:function(){return 0},getLevelCount:function(){return 0},getExtent:function(){return 0},getDepth:function(){return 1}};null!=e&&e.success&&e.success.call(n.success,a,t)}else{for(var r=0;r<t.length;r+=1)"row"===t[r].axis&&(t[r].start+=this._startIndex,t[r].start+t[r].count>this._startIndex+this._pageSize&&(t[r].count=this._pageSize-t[r].start));this._pendingCellCallback={cellRanges:t,callbacks:e,callbackObjects:n},this.dataSource.fetchCells(t,{success:this._handleCellsFetchSuccess.bind(this),error:this._handleCellsFetchError.bind(this)},n)}},i.prototype._handleCellsFetchSuccess=function(t,n){if(!this._pendingCellCallback.cellRanges!==n){for(var a=0;a<n.length;a+=1)"row"===n[a].axis&&(n[a].start-=this._startIndex,n[a].count+=1);var r=new e.PagingCellSet(t,this._startIndex),i=this._pendingCellCallback.callbacks.success,s=this._pendingCellCallback.callbackObjects.success;this._pendingCellCallback=null,this._endIndex=this._startIndex+t.getCount("row")-1,this.handleEvent("sync",{data:new Array(t.getCount("row")),startIndex:this._startIndex}),i.call(s,r,n)}},i.prototype._handleCellsFetchError=function(t){var e=this._pendingCellCallback.callbacks.error,n=this._pendingCellCallback.callbackObjects.error;this._pendingCellCallback=null,e.call(n,t)},i.prototype.keys=function(t){var e={column:t.column,row:t.row+this._startIndex};return this.dataSource.keys(e)},i.prototype.indexes=function(t){var e=this.dataSource.indexes(t);return-1!==e.row&&(e.row-=this._startIndex),e},i.prototype.getCapability=function(t){return this.dataSource.getCapability(t)},i.prototype.size=function(){var t;return null==this._initialized?-1:(t=this.dataSource.getCount("row"),this.dataSource.getCount("row")>this._pageSize?this._pageSize:t)},i.prototype.sort=function(t,e,n){this.dataSource.sort(t,e,n)},i.prototype.totalSize=function(){return null==this._initialized?-1:this.dataSource.getCount("row")},i.prototype.totalSizeConfidence=function(){return"actual"},i.prototype.moveOK=function(t,e,n){return this.dataSource.moveOK(t,e,n)},i.prototype.move=function(t,e,n,a,r){this.dataSource.move(t,e,n,a,r)};const s=function(t,e){this.m_headerSet=t,this.m_startIndex=e};e._registerLegacyNamespaceProp("PagingHeaderSet",s),s.prototype.getData=function(t,e){return this.m_headerSet.getData(t+this.m_startIndex,e)},s.prototype.getMetadata=function(t,e){return this.m_headerSet.getMetadata(t+this.m_startIndex,e)},s.prototype.getCount=function(){return this.m_headerSet.getCount()},s.prototype.getLevelCount=function(){return this.m_headerSet.getLevelCount()},s.prototype.getExtent=function(t,e){return this.m_headerSet.getExtent(t+this.m_startIndex,e)},s.prototype.getDepth=function(t,e){return this.m_headerSet.getDepth(t+this.m_startIndex,e)},s.prototype.getHeaderSet=function(){return this.m_headerSet},s.prototype.getStartIndex=function(){return this.m_startIndex},s.prototype.getLabel=function(t){return this.m_headerSet.getLabel(t)},t.PagingCellSet=r,t.PagingDataGridDataSource=i,t.PagingHeaderSet=s,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojpagingdatagriddatasource.js.map