/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojdvt-toolkit","ojs/ojtranslation"],function(e,t,a){"use strict";const i=e=>{var a=e.getDimensions(),i=e.localToStage(new t.Point(a.x,a.y)),o=e.localToStage(new t.Point(a.x+a.w,a.y+a.h));return new t.Rectangle(i.x,i.y,o.x-i.x,o.y-i.y)},o=(e,a,i,o,r)=>{var n=new t.OutputText(e,a,0,0);return n.setCSSStyle(i),n.setHorizAlignment(o),n.setVertAlignment(r),n},r=e=>{for(var t=e.getMatrix(),a=e.getParent();a;){var i=a.getMatrix();t=t.translate(i.getTx(),i.getTy()),a=a.getParent()}return t},n=(e,t,a,i)=>{if(e.setX(t),e.setY(a),i){var o=e.getMatrix();o=(o=o.translate(-t,-a)).rotate(i),e.setMatrix(o.translate(t,a))}},l=(e,a)=>{if(0==a.indexOf("linear-gradient")){var i=t.GradientParser.parseCSSGradient(a);i&&e.setFill(new t.LinearGradientFill(i.getAngle(),i.getColors(),i.getAlphas(),i.getRatios()))}else e.setSolidFill(a)},s=(e,t,a,i)=>{var o=e.getDisplayables(),r=i?"__displayable:"+i:"__displayable",n=null==t.__cacheId?t.id:t.__cacheId,l=e.getOptions().__displayableCache,s=null==n?t[r]:l.getFromCachedMap(n,r);null!=s?o[s]=a:(null==n?t[r]=o.length:l.putToCachedMap(n,r,o.length),o.push(a))},d=(e,t,a)=>{if(!t)return null;var i=a?"__displayable:"+a:"__displayable",o=null==t.__cacheId?t.id:t.__cacheId,r=e.getOptions().__displayableCache,n=null==o?t[i]:r.getFromCachedMap(o,i),l=e.getDisplayables();return null==n?null:l[n]},g={processDataObj:e=>{if(g.hasValidData(e)){var t=e.getOptions(),a=t.cells,i={};if(a)for(var o=0;o<a.length;o++){var r=a[o],n=r.row;i[n]||(i[n]={});var l=r.column;i[n][l]=r}for(var s=[],d={},h={},u=0;u<g.getRowCount(e);u++){var c=g.getRow(e,u);c.__cacheId="row:"+c.id,d[c.id]=u}t.__rowMap=d;for(var C=0;C<g.getColCount(e);C++){var _=g.getCol(e,C);_.__cacheId="column:"+_.id,h[_.id]=C}t.__columnMap=h;for(var p=0;p<g.getRowCount(e);p++)for(var b=g.getRow(e,p).id,v=0;v<g.getColCount(e);v++){var x=g.getCol(e,v).id;if(i[b]&&i[b][x]){var f=i[b][x];s.push(f)}else s.push({row:b,column:x})}t.cells=s;for(var y=new(e.getCtx().ojMap),m=!1,S=0;S<g.getNodeCount(e);S++){var w=g.getNode(e,S);y.set(w.id,S),!m&&(w.groupCategory||w._groupCategories||w._groupLabels)&&(m=!0)}t.__nodeMap=y,t.__grouping="none"!=t.groupBehavior&&m,g.getGrouping(e)&&"acrossCells"==g.getGroupBehavior(e)&&(t.maximizedRow=null,g.fireOptionChangeEvent(e,"maximizedRow",null),t.maximizedColumn=null,g.fireOptionChangeEvent(e,"maximizedColumn",null)),(t.maximizedRow&&isNaN(d[t.maximizedRow])||t.maximizedColumn&&isNaN(h[t.maximizedColumn]))&&(t.maximizedRow=null,g.fireOptionChangeEvent(e,"maximizedRow",null),t.maximizedColumn=null,g.fireOptionChangeEvent(e,"maximizedColumn",null))}},hasValidData:e=>{var t=e.getOptions();return!(!t||!t.rows||t.rows.length<1||!t.columns||t.columns.length<1)},getColCount:e=>e.getOptions().columns.length,getRowCount:e=>e.getOptions().rows.length,getColLabel:(e,t)=>{var a=g.getCol(e,g.getColIdx(e,t));return a&&a.label?a.label:null},getRowLabel:(e,t)=>{var a=g.getRow(e,g.getRowIndex(e,t));return a&&a.label?a.label:null},getCellByRowCol:(e,t,a)=>{var i=g.getCell(e,g.getCellIdxByRowCol(e,t,a));return i?d(e,i):null},getCellIdxByRowCol:(e,t,a)=>g.getColIdx(e,a)+g.getRowIndex(e,t)*g.getColCount(e),getCol:(e,t)=>e.getOptions().columns[t],getRow:(e,t)=>e.getOptions().rows[t],getMaximizedRow:e=>e.getOptions().maximizedRow,getMaximizedCol:e=>e.getOptions().maximizedColumn,getRowIndex:(e,t)=>e.getOptions().__rowMap[t],getColIdx:(e,t)=>e.getOptions().__columnMap[t],getCell:(e,t)=>e.getOptions().cells[t],getNodeCount:e=>e.getOptions().nodes?e.getOptions().nodes.length:0,getNode:(e,t)=>e.getOptions().nodes[t],getNodeIndex:(e,t)=>{var a=e.getOptions().__nodeMap;return a?a.get(t):-1},getCellIndex:(e,t)=>{var a=g.getRowIndex(e,t.row);return g.getColIdx(e,t.column)+a*g.getColCount(e)},getSelectedItems:e=>e.getOptions().selection,setSelectedItems:(e,t)=>{e.getOptions().selection=t},getHighlightedItems:e=>{var t,a=e.getOptions().highlightedCategories;if(a&&a.length>0){t=[];for(var i=0;i<g.getNodeCount(e);i++){var o=g.getNode(e,i);g.isNodeHighlighted(e,o)&&t.push(o)}}return t},getGrouping:e=>e.getOptions().__grouping,getGroupAttr:e=>e.getOptions().groupAttributes,getGroupBehavior:e=>e.getOptions().groupBehavior,getNodeGroupId:e=>{if(e.groupCategory)return e.groupCategory;var t=e._groupCategories;return t&&t.length>0?t.join(";"):null},getXPercentage:(e,t)=>{if(!isNaN(t.xPercentage))return t.xPercentage;var a=g.getColCount(e);return(g.getColIdx(e,t.column)+.5)/a},getYPercentage:(e,t)=>{if(!isNaN(t.yPercentage))return t.yPercentage;var a=g.getRowCount(e);return(g.getRowIndex(e,t.row)+.5)/a},getOtherThreshold:e=>e.getOptions().otherThreshold,getOtherColor:e=>e.getOptions().otherColor,getDrawer:e=>e.getOptions()._drawer,getCategoryNode:(e,t)=>{var a=g.getGroupBehavior(e),i=e.getOptions().__groups,o=t;if("withinCell"==a){var r=t.substring(0,t.indexOf(":"));o=t.substring(t.indexOf(":")+1),i=i[r]}return i?i[o]:null},getCategoryNodeLabels:(e,t)=>{if(t.__labels)return t.__labels;var a=g.getNode(e,t.nodeIndices[0]);if(a.groupCategory)return t.__labels=[a.groupCategory],t.__labels;if(t.__labels=[],a._groupCategories)for(var i=e.getOptions()._groupLabels,o=0;o<a._groupCategories.length;o++)i&&i[a._groupCategories[o]]?t.__labels[o]=i[a._groupCategories[o]]:t.__labels[o]=a._groupCategories[o];return t.__labels},isMaximizeEnabled:e=>"off"!=e.getOptions().cellMaximize,getCellContent:e=>"counts"==e.getOptions().cellContent?"counts":"auto",isCellMinimized:(e,t)=>{var a=g.getMaximizedRow(e),i=g.getMaximizedCol(e);if(!a&&!i)return!1;var o=g.getCell(e,t),r=o.row,n=o.column;return a&&i?a!=r||i!=n:a!=r&&i!=n},isCellMaximized:(e,t)=>{var a=g.getMaximizedRow(e),i=g.getMaximizedCol(e),o=g.getCell(e,t),r=o.row,n=o.column;return a==r&&i==n},isNodeHidden:(e,a)=>{var i=e.getOptions();return i.hiddenCategories&&!i.__hiddenMap&&(i.__hiddenMap=t.ArrayUtils.createBooleanMap(i.hiddenCategories)),t.ArrayUtils.hasAnyMapItem(i.__hiddenMap,a.categories)},isNodeHighlighted:(e,a)=>{var i=e.getOptions();return i.highlightedCategories&&!i.__highlightedMap&&(i.__highlightedMap=t.ArrayUtils.createBooleanMap(i.highlightedCategories)),"all"==i.highlightMatch?t.ArrayUtils.hasAllMapItems(i.__highlightedMap,a.categories):t.ArrayUtils.hasAnyMapItem(i.__highlightedMap,a.categories)},getNodeScrollableContainer:(e,t)=>{if(!t)return null;var a=g.getDrawer(e);if(a){var i=d(e,a);if(i)return i.getChildContainer()}var o=g.getCellIndex(e,t.getData());if(g.isCellMaximized(e,o)){var r=g.getCell(e,o);return d(e,r).getChildContainer()}return null},fireOptionChangeEvent:(e,a,i)=>{var o=t.EventFactory.newOptionChangeEvent(a,i);e.processEvent(o)},getMaximizedCellIndex:e=>{var t=null,a=g.getMaximizedRow(e),i=g.getMaximizedCol(e);if(a&&i){var o=g.getColCount(e);t=g.getColIdx(e,i)+o*g.getRowIndex(e,a)}return t},isDrawerSelected:(e,t)=>{var a=!1,i=g.getSelectedItems(e);if(i){for(var o={},r=0;r<i.length;r++)o[i[r]]=!0;var n=t.getData().nodeIndices;a=!0;for(var l=0;l<n.length;l++){if(!o[g.getNode(e,n[l]).id]){a=!1;break}}}return a},buildAriaDesc:(e,a,i,o,r)=>{var n=e.getOptions().translations,l="categoryNode"===a.nboxType||"drawer"===a.nboxType?t.ResourceUtils.format(n.labelAndValue,[n.labelGroup,i]):i,s=[];if(o?s.push(n.stateSelected):s.push(n.stateUnselected),"categoryNode"===a.nboxType){var d=a.getData().nodeIndices.length;s.push(n.stateCollapsed),s.push(t.ResourceUtils.format(n.labelAndValue,[n.labelSize,d]))}else if("drawer"===a.nboxType){var h=g.getCategoryNode(e,a.getData().id).nodeIndices.length;s.push(n.stateExpanded),s.push(t.ResourceUtils.format(n.labelAndValue,[n.labelSize,h]))}return t.Displayable.generateAriaLabel(l,s,r)},getFirstNavigableNode:e=>{var t=null;if(e.getNumChildren()>0){var a;t=e.getChildAt(0);do{"node"!==t.nboxType&&"overflow"!==t.nboxType||(a=t.previousNavigable),t=a||t}while(a)}return t},getLastNavigableNode:e=>{var t=null,a=e.getNumChildren();if(a>0){var i;t=e.getChildAt(a-1);do{t=(i="node"===t.nboxType?t.nextNavigable:null)||t}while(i)}return t},getNextNavigableNode:(e,a)=>{var i,o=a.keyCode==t.KeyboardEvent.RIGHT_ARROW||a.keyCode==t.KeyboardEvent.DOWN_ARROW;return"node"===e.nboxType?i=o?e.nextNavigable:e.previousNavigable:"overflow"===e.nboxType&&(i=o?null:e.previousNavigable),i||e},getCellCounts:e=>e.getOptions().__cellCounts||g._calculateCellCounts(e),_calculateCellCounts:e=>{var t=g.getRowCount(e)*g.getColCount(e),a=[],i=null,o=g.getHighlightedItems(e),r={};if(o){i=[];for(var n=0;n<o.length;n++)r[o[n].id]=!0}for(var l=0;l<t;l++)a[l]=0,i&&(i[l]=0);for(var s=g.getNodeCount(e),d=0;d<s;d++){var h=g.getNode(e,d);if(!g.isNodeHidden(e,h)){var u=g.getCellIndex(e,h);a[u]++,i&&r[h.id]&&i[u]++}}var c={};return c.total=a,i&&(c.highlighted=i),e.getOptions().__cellCounts=c,c},getRowDims:(e,a,i)=>{var o=g.getRowCount(e),r=i.h/o,n=i.y+(o-a-1)*r,l=r;return new t.Rectangle(i.x,n,i.w,l)},getColDims:(e,a,i)=>{var o=g.getColCount(e),r=i.w/o,n=t.Agent.isRightToLeft(e.getCtx()),l=i.x+(n?i.w-r:0)+(n?-1:1)*a*r,s=r;return new t.Rectangle(l,i.y,s,i.h)},compareCategoryNodeSize:(e,t)=>{var a=e.nodeIndices.length,i=t.nodeIndices.length;return a==i?0:a<i?1:-1}};class h extends t.KeyboardHandler{constructor(e,t){super(e),this._nbox=t}processKeyDown(e){if(e.keyCode==t.KeyboardEvent.TAB){var a=this._eventManager.getFocus(),i=null;if(t.EventManager.consumeEvent(e),a)i=a;else{var o=g.getDrawer(this._nbox);if(o)i=d(this._nbox,o);else if("acrossCells"==g.getGroupBehavior(this._nbox)){var r=this._nbox.getOptions().__groups;if(r){var n=[];for(var l in r){var s=d(this._nbox,r[l]);s&&n.push(s)}i=h.getNextNavigableCategoryNode(null,e,n)}}if(!i){var u=g.getColCount(this._nbox)*(g.getRowCount(this._nbox)-1);i=d(this._nbox,g.getCell(this._nbox,u))}}return i}return super.processKeyDown(e)}isSelectionEvent(e){return e.keyCode!=t.KeyboardEvent.TAB&&(this.isNavigationEvent(e)&&!e.ctrlKey)}isMultiSelectEvent(e){return e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey}isNavigationEvent(e){var a=!1;switch(e.keyCode){case t.KeyboardEvent.OPEN_BRACKET:case t.KeyboardEvent.CLOSE_BRACKET:a=!0;break;default:a=super.isNavigationEvent(e)}return a}static getNextNavigableCategoryNode(e,a,i){if(!i||i.length<=0)return null;if("categoryNode"===i[0].nboxType&&i.sort((e,t)=>g.compareCategoryNodeSize(e.getData(),t.getData())),null==e)return i[0];for(var o=e,r=a.keyCode==t.KeyboardEvent.RIGHT_ARROW||a.keyCode==t.KeyboardEvent.DOWN_ARROW,n=i.length,l=0;l<n;l++){if(i[l]===e){o=i[r?l+1<n?l+1:l:l-1>=0?l-1:l];break}}return o}static getNextNavigableCell(e,a,i,o){if(!i||0===i.length)return null;var r=parseInt(e.getData().row),n=parseInt(e.getData().column),l=g.getRowCount(o),s=g.getColCount(o);const d=(e,t)=>(t+e)%t;return a.keyCode==t.KeyboardEvent.RIGHT_ARROW?n=d(n+1,s):a.keyCode==t.KeyboardEvent.LEFT_ARROW?n=d(n-1,s):r=a.keyCode==t.KeyboardEvent.UP_ARROW?d(r+1,l):d(r-1,l),g.getCellByRowCol(o,r,n)}}const u={getAnimOnDisplay:e=>{if(!e.isAnimationAllowed())return"none";var a=e.getOptions().animationOnDisplay;return"auto"==a&&(a=t.BlackBoxAnimationHandler.ALPHA_FADE),a},getAnimOnDataChange:e=>e.isAnimationAllowed()?e.getOptions().animationOnDataChange:"none",getAnimDuration:e=>t.CSSStyle.getTimeMilliseconds(e.getOptions().styleDefaults.animationDuration)/1e3,getColLabelStyle:(e,a)=>{var i=e.getOptions().styleDefaults.columnLabelStyle,o=g.getCol(e,a);return o.labelStyle?t.JsonUtils.merge(new t.CSSStyle(o.labelStyle),i):i},getRowLabelStyle:(e,a)=>{var i=e.getOptions().styleDefaults.rowLabelStyle,o=g.getRow(e,a);return o.labelStyle?t.JsonUtils.merge(new t.CSSStyle(o.labelStyle),i):i},getCellStyle:(e,a)=>{var i=e.getOptions(),o=u._getCellStyleKeys(e,a),r=u._getCellStyleOption(e,a,o[0],o[1]),n=i.styleDefaults.cellDefaults["_"+o[0]],l=new t.CSSStyle;return u._getCellStyleProperties().forEach(e=>{var a=t.CSSStyle.cssStringToObjectProperty(e),i=r&&null!=r[a]?r[a]:n.getStyle(e);l.setStyle(e,i)}),l},getCellStyleObject:(e,a)=>{var i=u._getCellStyleKeys(e,a),o=u._getCellStyleOption(e,a,i[0],i[1]);return o&&u._getCellStyleProperties().forEach(e=>{delete o[t.CSSStyle.cssStringToObjectProperty(e)]}),o},_getCellStyleKeys:(e,t)=>{var a="style",i="svgStyle",o=g.getMaximizedRow(e),r=g.getMaximizedCol(e);return g.isCellMinimized(e,t)?(a="minimizedStyle",i="minimizedSvgStyle"):!o&&!r||g.isCellMinimized(e,t)||(a="maximizedStyle",i="maximizedSvgStyle"),[a,i]},_getCellStyleOption:(e,a,i,o)=>{var r=e.getOptions(),n=g.getCell(e,a),l=r.styleDefaults.cellDefaults,s=l[o]||l[i];!s||s instanceof Object||(s=t.CSSStyle.cssStringToObject(s));var d=n[o]||n[i];return d?(d instanceof Object||(d=t.CSSStyle.cssStringToObject(d)),d=t.JsonUtils.merge(d,s)):s&&(d=t.JsonUtils.clone(s)),d},_getCellStyleProperties:()=>[t.CSSStyle.BACKGROUND,t.CSSStyle.BACKGROUND_COLOR,t.CSSStyle.BORDER_STYLE,t.CSSStyle.BORDER_COLOR,t.CSSStyle.BORDER_WIDTH],getCellClassName:(e,t)=>{var a="className",i="svgClassName",o=g.getMaximizedRow(e),r=g.getMaximizedCol(e);g.isCellMinimized(e,t)?(a="minimizedClassName",i="minimizedSvgClassName"):!o&&!r||g.isCellMinimized(e,t)||(a="maximizedClassName",i="maximizedSvgClassName");var n=g.getCell(e,t);return n[i]||n[a]},getCellLabelStyle:(e,a)=>{var i=e.getOptions(),o=g.isCellMinimized(e,a)?"_labelMinimizedStyle":"labelStyle",r=i.styleDefaults.cellDefaults[o],n=g.getCell(e,a);return n.labelStyle?t.JsonUtils.merge(new t.CSSStyle(n.labelStyle),r):r},getCellShowCount:(e,t)=>t.showCount?t.showCount:e.getOptions().styleDefaults.cellDefaults.showCount,getCellCountLabelStyle:(e,t)=>{var a=g.isCellMinimized(e,t)?"_labelMinimizedStyle":"countLabelStyle";return e.getOptions().styleDefaults.cellDefaults[a]},getCellBorderRadius:e=>e.getOptions().styleDefaults.cellDefaults._borderRadius,getCellBodyCountLabelStyle:e=>e.getOptions().styleDefaults.cellDefaults.bodyCountLabelStyle,getCellDropTargetStyle:e=>e.getOptions().styleDefaults.cellDefaults.dropTargetStyle,getNodeLabel:(e,a)=>{if(!a.label)return null;var i=d(e,a,"label");if(i)return i;var r=t.Agent.isRightToLeft(e.getCtx())?t.OutputText.H_ALIGN_RIGHT:t.OutputText.H_ALIGN_LEFT;return i=o(e.getCtx(),a.label,u.getNodeLabelStyle(e),r,t.OutputText.V_ALIGN_CENTRAL),a.secondaryLabel&&i.setClassName("oj-typography-semi-bold"),s(e,a,i,"label"),i},getNodeSecondaryLabel:(e,a)=>{if(!a.secondaryLabel)return null;var i=d(e,a,"secondaryLabel");if(i)return i;var r=t.Agent.isRightToLeft(e.getCtx())?t.OutputText.H_ALIGN_RIGHT:t.OutputText.H_ALIGN_LEFT;return i=o(e.getCtx(),a.secondaryLabel,u.getNodeSecondaryLabelStyle(e),r,t.OutputText.V_ALIGN_CENTRAL),s(e,a,i,"secondaryLabel"),i},getNodeLabelStyle:e=>e.getOptions().styleDefaults.nodeDefaults.labelStyle,getNodeSecondaryLabelStyle:e=>e.getOptions().styleDefaults.nodeDefaults.secondaryLabelStyle,getNodeColor:(e,t)=>t.color?t.color:e.getOptions().styleDefaults.nodeDefaults.color,getNodeBorderColor:(e,t)=>{var a=t.borderColor?t.borderColor:e.getOptions().styleDefaults.nodeDefaults.borderColor;return a||null},getNodeBorderWidth:(e,t)=>{var a=t.borderWidth?t.borderWidth:e.getOptions().styleDefaults.nodeDefaults.borderWidth;return a||null},getNodeIndicatorColor:(e,t)=>t.indicatorColor?t.indicatorColor:e.getOptions().styleDefaults.nodeDefaults.indicatorColor,getIcon:(e,t)=>t.icon?u.getStyledIcon(e,t.icon):null,getIndicatorIcon:(e,t)=>t.indicatorIcon?u.getStyledIndicatorIcon(e,t.indicatorIcon):null,getStyledIcon:(e,a)=>t.JsonUtils.merge(a,e.getOptions().styleDefaults.nodeDefaults.iconDefaults),getStyledIndicatorIcon:(e,a)=>t.JsonUtils.merge(a,e.getOptions().styleDefaults.nodeDefaults.indicatorIconDefaults),getFadedNodeAlpha:e=>e.getOptions().styleDefaults.nodeDefaults.alphaFade,getScrollbarStyleMap:e=>e.getOptions().styleDefaults.__scrollbar,getCategoryNodeColor:(e,t)=>{if("none"==g.getGroupBehavior(e)||g.getGroupAttr(e)&&-1==g.getGroupAttr(e).indexOf("color"))return e.getOptions().styleDefaults.nodeDefaults.color;if(t.otherNode)return g.getOtherColor(e);var a=t.nodeIndices,i=g.getNode(e,a[0]).color;if(!i)return e.getOptions().styleDefaults.nodeDefaults.color;for(var o=1;o<a.length;o++){if(i!=g.getNode(e,a[o]).color)return e.getOptions().styleDefaults.nodeDefaults.color}return i},getCategoryNodeIndicatorColor:(e,t)=>{if("none"==g.getGroupBehavior(e)||g.getGroupAttr(e)&&-1==g.getGroupAttr(e).indexOf("indicatorColor"))return null;var a=t.nodeIndices,i=g.getNode(e,a[0]).indicatorColor;if(!i)return e.getOptions().styleDefaults.nodeDefaults.indicatorColor;for(var o=1;o<a.length;o++){if(i!=g.getNode(e,a[o]).indicatorColor)return e.getOptions().styleDefaults.nodeDefaults.indicatorColor}return i},getStyledCategoryIndicatorIcon:(e,a)=>{if("none"==g.getGroupBehavior(e))return null;if(g.getGroupAttr(e)&&-1==g.getGroupAttr(e).indexOf("indicatorIconShape")&&-1==g.getGroupAttr(e).indexOf("indicatorIconColor")&&-1==g.getGroupAttr(e).indexOf("indicatorIconPattern"))return null;var i={},o=a.nodeIndices,r=g.getNode(e,o[0]).indicatorIcon;if(!r)return null;r.width&&(i.width=r.width),r.height&&(i.height=r.height),r.borderWidth&&(i.borderWidth=r.borderWidth),r.borderStyle&&(i.borderStyle=r.borderStyle),r.borderColor&&(i.borderColor=r.borderColor),r.borderRadius&&(i.borderRadius=r.borderRadius),r.style&&(i.style=r.style),r.className&&(i.className=r.className);var n,l=!0;if(!g.getGroupAttr(e)||-1!=g.getGroupAttr(e).indexOf("indicatorIconShape")){for(var s=r.shape,d=1;d<o.length;d++)(n=g.getNode(e,o[d]).indicatorIcon)&&s!=n.shape&&(l=!1);i.shape=l?s:e.getOptions().styleDefaults.nodeDefaults.indicatorIconDefaults.shape}if(l=!0,!g.getGroupAttr(e)||-1!=g.getGroupAttr(e).indexOf("indicatorIconColor")){for(var h=r.color,u=1;u<o.length;u++)(n=g.getNode(e,o[u]).indicatorIcon)&&h!=n.color&&(l=!1);i.color=l?h:e.getOptions().styleDefaults.nodeDefaults.indicatorIconDefaults.color}if(l=!0,!g.getGroupAttr(e)||-1!=g.getGroupAttr(e).indexOf("indicatorIconPattern")){for(var c=r.pattern,C=1;C<o.length;C++){var _=g.getNode(e,o[C]).indicatorIcon;_&&c!=_.pattern&&(l=!1)}i.pattern=l?c:e.getOptions().styleDefaults.nodeDefaults.indicatorIconDefaults.pattern}return t.JsonUtils.merge(i,e.getOptions().styleDefaults.nodeDefaults.indicatorIconDefaults)},getDrawerBackground:e=>e.getOptions().styleDefaults._drawerDefaults.background,getDrawerHeaderBackground:e=>e.getOptions().styleDefaults._drawerDefaults.headerBackground,getDrawerBorderColor:e=>e.getOptions().styleDefaults._drawerDefaults.borderColor,getDrawerBorderRadius:e=>e.getOptions().styleDefaults._drawerDefaults.borderRadius,getDrawerLabelStyle:e=>e.getOptions().styleDefaults._drawerDefaults.labelStyle,getDrawerCountLabelStyle:e=>e.getOptions().styleDefaults._drawerDefaults.countLabelStyle,getDrawerCountBorderRadius:e=>e.getOptions().styleDefaults._drawerDefaults.countBorderRadius,getCategoryNodeLabelStyle:e=>e.getOptions().styleDefaults._categoryNodeDefaults.labelStyle,getNodeBorderRadius:e=>e.getOptions().styleDefaults.nodeDefaults._borderRadius,getNodeHoverColor:e=>e.getOptions().styleDefaults.nodeDefaults.hoverColor,getNodeSelectionColor:e=>e.getOptions().styleDefaults.nodeDefaults.selectionColor,getLabelHalign:(e,a)=>{var i=a.labelHalign;i||(i=e.getOptions().styleDefaults.cellDefaults.labelHalign);var o=t.Agent.isRightToLeft(e.getCtx());return"end"==i?o?t.OutputText.H_ALIGN_LEFT:t.OutputText.H_ALIGN_RIGHT:"center"==i?t.OutputText.H_ALIGN_CENTER:o?t.OutputText.H_ALIGN_RIGHT:t.OutputText.H_ALIGN_LEFT}};class c extends t.DataAnimationHandler{constructor(e,t,a,i){super(e,t),this._oldNBox=a,this._newNBox=i}getOldNBox(){return this._oldNBox}getNewNBox(){return this._newNBox}getAnimationDuration(){return u.getAnimDuration(this._oldNBox)}}c.DELETE=0,c.UPDATE=1,c.INSERT=2;const C={render:(e,a,i,o)=>{var r=e.getOptions(),n=parseInt(r.__layout.cellGap),l=parseInt(r.__layout.cellInnerPadding),d=C.getCellLayout(e),h=g.getRowIndex(e,a.row),c=g.getColIdx(e,a.column),_=C.getCellDims(e,h,c,o);i.setTranslate(_.x+n/2,_.y+n/2);var p=h*g.getColCount(e)+c,b=new t.Rect(e.getCtx(),0,0,Math.max(_.w-n,0),Math.max(_.h-n,0));b.setPixelHinting(!0);var v=u.getCellStyle(e,p);C._applyStyleToRect(b,v);var x=u.getCellBorderRadius(e);b.setRx(x),b.setRy(x);var f=u.getCellStyleObject(e,p);b.setStyle(f);var y=u.getCellClassName(e,p);b.setClassName(y),i.addChild(b);var m=e.getCellFilter();void 0===m&&(m=C._createShadow(r.styleDefaults.cellDefaults._panelShadow),e.setCellFilter(m)),m&&b.addDrawEffect(m),s(e,a,b,"background");var S=new t.KeyboardFocusEffect(e.getCtx(),i,new t.Rectangle(-1,-1,b.getWidth()+2,b.getHeight()+2));s(e,a,S,"focusEffect"),C.renderHeader(e,a,i,!1);var w=g.isCellMaximized(e,p),N=w?d.maximizedHeaderSize:d.headerSize,A=w?d.maximizedLabelHeight:d.labelHeight,D=w?new t.SimpleScrollableContainer(e.getCtx(),b.getWidth(),b.getHeight()-N):new t.Container(e.getCtx());i.addChild(D),i.setChildContainer(D);var I=null;A?(I=C._isLabelVertical(e,a)?new t.Rectangle(N,l,b.getWidth()-N-l,b.getHeight()-l-l):new t.Rectangle(l,N,b.getWidth()-l-l,b.getHeight()-N-l),D instanceof t.SimpleScrollableContainer&&D.setTranslate(0,N)):I=new t.Rectangle(l,l,b.getWidth()-l-l,b.getHeight()-l-l),I.w=Math.max(I.w,0),I.h=Math.max(I.h,0),a.__childArea=I},renderHeader:(e,a,i,r)=>{var l=d(e,a,"label");l&&(l.getParent().removeChild(l),s(e,a,null,"label"));var h=d(e,a,"countLabel");h&&(h.getParent().removeChild(h),s(e,a,null,"countLabel"));var c=d(e,a,"closeButton");c&&(c.getParent().removeChild(c),s(e,a,null,"closeButton"));var _=!1;if(a){var p,b=e.getOptions(),v=b.__layout.countLabelGap,x=b.__layout.cellCloseGap,f=parseInt(b.__layout.cellInnerPadding),y=C.getCellLayout(e),m=g.getCellCounts(e),S=d(e,a,"background"),w=g.getRowIndex(e,a.row),N=g.getColIdx(e,a.column),A=w*g.getColCount(e)+N,D=t.Agent.isRightToLeft(e.getCtx()),I=0;if(g.isCellMaximized(e,A)){var T=b._resources.close,E=T.width;if(S.getWidth()-f-f>E){var O=e.getCtx(),M=t.ToolkitUtils.getIconStyle(O,T.class),R=new t.IconButton(O,"borderless",{style:M,size:E},null,null,i.handleDoubleClick,i),L=D?Math.min((S.getWidth()-E)/2,f):Math.max((S.getWidth()-E)/2,S.getWidth()-f-E);R.setTranslate(L,f),i.addChild(R),I=E+x,s(e,a,R,"closeButton"),_=!0}}if(a.label){var P=y.labelHeight,H=!1,B=u.getLabelHalign(e,a),F=0,G=null,k=0,z=0,U=null,W=u.getCellShowCount(e,a);if(!r&&"off"!=W){var K=d(e,a).getCountLabel();K?U=K:"on"==W&&(U=""+m.total[A],m.highlighted&&(U=t.ResourceUtils.format(b.translations.highlightedCount,[m.highlighted[A],U])))}if(C._isLabelVertical(e,a)){if(U&&((G=o(e.getCtx(),U,u.getCellCountLabelStyle(e,A),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_CENTRAL)).setClassName("oj-typography-semi-bold"),t.TextUtils.fitText(G,S.getHeight()-f-f,S.getWidth()-2*f,i)?(s(e,a,G,"countLabel"),_=!0,F=G.getDimensions().w+v,z=S.getHeight()/2,k=S.getWidth()/2):H=!0),p=0,!H){var j=o(e.getCtx(),a.label,u.getCellLabelStyle(e,A),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_CENTRAL);if(t.TextUtils.fitText(j,S.getHeight()-f-f-F,S.getWidth()-2*f,i)){s(e,a,j,"label");var V=j.getDimensions().w;_=!0,n(j,S.getWidth()/2,(S.getHeight()+F)/2,D?Math.PI/2:-Math.PI/2),p=(V+v)/2}}G&&n(G,k,z-=p,D?Math.PI/2:-Math.PI/2)}else{if(U&&((G=o(e.getCtx(),U,u.getCellCountLabelStyle(e,A),B,t.OutputText.V_ALIGN_CENTRAL)).setClassName("oj-typography-semi-bold"),t.TextUtils.fitText(G,S.getWidth()-f-f-I,S.getHeight()-2*f,i)?(s(e,a,G,"countLabel"),_=!0,F=G.getDimensions().w+v,k=B==t.OutputText.H_ALIGN_CENTER?S.getWidth()/2:B==t.OutputText.H_ALIGN_RIGHT?S.getWidth()-f:f,z=g.isCellMinimized(e,A)?S.getHeight()/2:f+P/2,n(G,k,z)):H=!0),p=0,!H){var Y=o(e.getCtx(),a.label,u.getCellLabelStyle(e,A),B,t.OutputText.V_ALIGN_CENTRAL);if(t.TextUtils.fitText(Y,S.getWidth()-f-f-I-F,S.getHeight()-2*f,i)){s(e,a,Y,"label");var X,q=Y.getDimensions().w;_=!0,B==t.OutputText.H_ALIGN_CENTER?(X=(S.getWidth()-(D?-1:1)*F)/2,p=(D?-1:1)*(q+v)/2):B==t.OutputText.H_ALIGN_RIGHT?(X=S.getWidth()-f-(D?0:1)*F,p=(D?-1:0)*(q+v)):(X=f+(D?1:0)*F,p=(D?0:1)*(q+v));var J=g.isCellMinimized(e,A)?S.getHeight()/2:f+P/2;n(Y,X,J)}}G&&p&&n(G,k+p,z)}}}return C._addAccessibilityAttr(e,a,i),_},renderBodyCountLabels:(e,a)=>{var i=parseInt(e.getOptions().__layout.cellInnerPadding),r=C.getCellLayout(e),l=g.getCellCounts(e),h=Number.MAX_VALUE,c=!1,_=g.getCell(e,a[0]),p=d(e,_,"label"),b=d(e,_,"countLabel"),v=p&&p.getCSSStyle()?p.getCSSStyle().getFontSize():null,x=b&&b.getCSSStyle()?b.getCSSStyle().getFontSize():null;if(v=isNaN(v)?parseFloat(v):v,x=isNaN(x)?parseFloat(x):x,!isNaN(v)||!isNaN(x)){var f=isNaN(x)?v:Math.max(v,x);h=isNaN(v)?x:f}for(var y,m,S=[],w=[],N=0;N<a.length;N++)y=a[N],g.isCellMinimized(e,y)?w.push(y):S.push(y);for(var A=[],D=[],I=0;I<S.length;I++)y=S[I],m=l.total[y],A[I]=o(e.getCtx(),""+m,u.getCellBodyCountLabelStyle(e),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_CENTRAL);for(var T=0;T<w.length;T++)y=w[T],m=l.total[y],D[T]=o(e.getCtx(),""+m,u.getCellBodyCountLabelStyle(e),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_CENTRAL);var E=C.getBodyCountLabelsFontSize(e,S,A);(E<=h||b&&!p)&&(c=!0);var O,M=C.getBodyCountLabelsFontSize(e,w,D);if((M<=h||b&&!p)&&(c=!0),c){for(var R=0;R<a.length;R++){_=g.getCell(e,a[R]),p=d(e,_,"label"),b=d(e,_,"countLabel");var L=_.__childArea,P=!1;p&&(p.getParent().removeChild(p),s(e,_,null,"label"),P=!0),b&&(b.getParent().removeChild(b),s(e,_,null,"countLabel"),P=!0),P&&(C._isLabelVertical(e,_)?(L.x-=r.headerSize-i,L.w+=r.headerSize-i):(L.y-=r.headerSize-i,L.h+=r.headerSize-i),_.__childArea=L)}E=C.getBodyCountLabelsFontSize(e,S,A),M=C.getBodyCountLabelsFontSize(e,w,D)}for(var H=0;H<S.length;H++)y=S[H],_=g.getCell(e,y),O=d(e,_),L=_.__childArea,A[H].setFontSize(E),t.TextUtils.fitText(A[H],L.w,L.h,O)&&(c||C.renderHeader(e,_,O,!0),n(A[H],L.x+L.w/2,L.y+L.h/2));for(var B=0;B<w.length;B++)y=w[B],_=g.getCell(e,y),O=d(e,_),L=_.__childArea,D[B].setFontSize(M),t.TextUtils.fitText(D[B],L.w,L.h,O)&&(c||C.renderHeader(e,_,O,!0),n(D[B],L.x+L.w/2,L.y+L.h/2))},getBodyCountLabelsFontSize:(e,a,i)=>{for(var o=Number.MAX_VALUE,r=0;r<a.length;r++){var n=g.getCell(e,a[r]).__childArea;o=Math.min(o,parseInt(t.TextUtils.getOptimalFontSize(i[r].getCtx(),i[r].getTextString(),i[r].getCSSStyle(),n)))}return o},_isLabelVertical:(e,t)=>{var a=g.getMaximizedCol(e),i=g.getMaximizedRow(e);return!(!a||a==t.column||i&&i!=t.row)},getCellDims:(e,a,i,o)=>{var r=e.getOptions(),n=parseInt(r.__layout.cellGap),l=C.getCellLayout(e),s=t.Agent.isRightToLeft(e.getCtx()),d=n+parseInt(l.minimumCellSize),h=g.getRowCount(e),u=g.getColCount(e),c=g.getRowDims(e,a,o),_=g.getColDims(e,i,o),p=g.getMaximizedRow(e),b=g.getMaximizedCol(e),v=_.x,x=c.y,f=_.w,y=c.h,m=!0;if(p){var S=g.getRowIndex(e,p),w=Math.min(o.h/(3*(h-1)),d);a<S?(x=o.y+o.h-(a+1)*w,y=w,m=!1):a==S?(x=o.y+(h-a-1)*w,y=o.h-(h-1)*w):(x=o.y+(h-a-1)*w,y=w,m=!1)}if(b&&m){var N=g.getColIdx(e,b),A=Math.min(o.w/(3*(u-1)),d);i<N?(f=A,v=o.x+(s?o.w-A:0)+(s?-1:1)*i*A):i==N?(f=o.w-(u-1)*A,v=o.x+(s?o.w-f:0)+(s?-1:1)*i*A):(f=A,v=o.x+(s?-A:o.w)+(s?1:-1)*(u-i)*A)}return new t.Rectangle(v,x,f,y)},getCellLayout:e=>e.getOptions().__layout.__cellLayout||C._calculateCellLayout(e),_calculateCellLayout:e=>{for(var a=e.getOptions(),i=g.getCellCounts(e),r=parseInt(a.__layout.cellInnerPadding),n=a.__layout.cellLabelGap,l=parseInt(a.__layout.minimumCellSize),s=0,d=0,h=g.getRowCount(e)*g.getColCount(e),c=0;c<h;c++){var C=g.getCell(e,c);if(C&&C.label){var _=C.labelHalign,p=o(e.getCtx(),C.label,u.getCellLabelStyle(e,c),_,t.OutputText.V_ALIGN_CENTRAL).getDimensions().h;if("on"==u.getCellShowCount(e,C)){var b=o(e.getCtx(),i.total[c],u.getCellCountLabelStyle(e,c),_,t.OutputText.V_ALIGN_CENTRAL).getDimensions().h;p=Math.max(p,b)}s=Math.max(s,p)}}g.getMaximizedRow(e)&&g.getMaximizedCol(e)&&(d=Math.max(s,a._resources.close.height));var v=s+r+r,x={labelHeight:s,headerSize:s+r+n,maximizedLabelHeight:d,maximizedHeaderSize:d+r+n,minimumCellSize:l=Math.max(v,l)};return a.__layout.__cellLayout=x,x},animateUpdate:(e,a,i)=>{var o=e.getOldNBox(),n=e.getNewNBox(),l=new t.CustomAnimation(n.getCtx(),i,e.getAnimationDuration()),s=i.getChildContainer(),g=s.getMatrix();s.setMatrix(r(s));var h=i.getParent();h.addChildAt(s,h.getChildIndex(i)+1);var u=i.getTranslateX(),_=i.getTranslateY();l.getAnimator().addProp(t.Animator.TYPE_MATRIX,i,i.getMatrix,i.setMatrix,i.getMatrix()),i.setMatrix(a.getMatrix());var p=d(o,a.getData(),"background"),b=d(n,i.getData(),"background"),v=t.Agent.isRightToLeft(n.getCtx())?0:b.getWidth()-p.getWidth();if(b.getFill().equals(p.getFill())||(l.getAnimator().addProp(t.Animator.TYPE_FILL,b,b.getFill,b.setFill,b.getFill()),b.setFill(p.getFill())),l.getAnimator().addProp(t.Animator.TYPE_NUMBER,b,b.getWidth,b.setWidth,b.getWidth()),b.setWidth(p.getWidth()),l.getAnimator().addProp(t.Animator.TYPE_NUMBER,b,b.getHeight,b.setHeight,b.getHeight()),b.setHeight(p.getHeight()),i.isShowingKeyboardFocusEffect()){var x=d(n,i.getData(),"focusEffect").getEffect();x&&(l.getAnimator().addProp(t.Animator.TYPE_NUMBER,x,x.getWidth,x.setWidth,x.getWidth()),x.setWidth(p.getWidth()+2),l.getAnimator().addProp(t.Animator.TYPE_NUMBER,x,x.getHeight,x.setHeight,x.getHeight()),x.setHeight(p.getHeight()+2))}C._animateLabels(e,a,i,"countLabel"),C._animateLabels(e,a,i,"label");var f=d(o,a.getData(),"closeButton"),y=d(n,i.getData(),"closeButton");if(f)if(y)l.getAnimator().addProp(t.Animator.TYPE_MATRIX,y,y.getMatrix,y.setMatrix,y.getMatrix()),y.setMatrix(f.getMatrix());else{var m=r(f);f.setTranslate(f.getTranslateX()+v+u,f.getTranslateY()+_),e.add(new t.AnimFadeOut(n.getCtx(),f,e.getAnimationDuration()),c.UPDATE),l.getAnimator().addProp(t.Animator.TYPE_MATRIX,f,f.getMatrix,f.setMatrix,f.getMatrix()),f.setMatrix(m),n.getDeleteContainer().addChild(f)}else y&&(e.add(new t.AnimFadeIn(n.getCtx(),y,e.getAnimationDuration()),c.UPDATE),l.getAnimator().addProp(t.Animator.TYPE_MATRIX,y,y.getMatrix,y.setMatrix,y.getMatrix()),y.setTranslate(y.getTranslateX()-v,y.getTranslateY()),y.setAlpha(0));t.Playable.appendOnEnd(l,()=>{i.addChild(s),s.setMatrix(g)}),e.add(l,c.UPDATE)},_animateLabels:(e,a,i,o)=>{var n=e.getOldNBox(),l=e.getNewNBox(),s=d(n,a.getData(),o),g=d(l,i.getData(),o),h=C._isLabelVertical(n,a.getData()),u=C._isLabelVertical(l,i.getData());if(s||g)if(s&&g&&h==u){var _=new t.CustomAnimation(l.getCtx(),g,e.getAnimationDuration()),p=s.getHorizAlignment();p="left"==p?-1:"center"==p?0:1;var b=g.getHorizAlignment(),v=((b="left"==b?-1:"center"==b?0:1)-p)*g.getDimensions().w/2;if(_.getAnimator().addProp(t.Animator.TYPE_NUMBER,g,g.getX,g.setX,g.getX()),g.setX(s.getX()+v),_.getAnimator().addProp(t.Animator.TYPE_NUMBER,g,g.getY,g.setY,g.getY()),g.setY(s.getY()),_.getAnimator().addProp(t.Animator.TYPE_MATRIX,g,g.getMatrix,g.setMatrix,g.getMatrix()),g.setMatrix(s.getMatrix()),e.add(_,c.UPDATE),"countLabel"==o&&s.getTextString()!=g.getTextString()){g.setAlpha(0),i.addChild(s);var x=new t.AnimFadeOut(l.getCtx(),s,e.getAnimationDuration()),f=new t.AnimFadeIn(l.getCtx(),g,e.getAnimationDuration());e.add(x,c.UPDATE),e.add(f,c.INSERT),t.Playable.appendOnEnd(x,()=>{l.getDeleteContainer().addChild(s)})}}else s&&(s.setMatrix(r(s)),l.getDeleteContainer().addChild(s),e.add(new t.AnimFadeOut(l.getCtx(),s,e.getAnimationDuration()),c.UPDATE)),g&&(g.setAlpha(0),e.add(new t.AnimFadeIn(l.getCtx(),g,e.getAnimationDuration()),c.UPDATE))},animateDelete:(e,a)=>{var i=e.getNewNBox(),o=a.getChildContainer();if(o){var n=r(o),l=a.getParent();l.addChildAt(o,l.getChildIndex(a)+1),o.setMatrix(n)}i.getDeleteContainer().addChild(a),e.add(new t.AnimFadeOut(i.getCtx(),a,e.getAnimationDuration()),c.UPDATE)},animateInsert:(e,a)=>{var i=e.getNewNBox(),o=a.getChildContainer(),n=null;if(o){n=o.getMatrix();var l=r(a),s=a.getParent();s.addChildAt(o,s.getChildIndex(a)+1),o.setMatrix(l)}a.setAlpha(0);var d=new t.AnimFadeIn(i.getCtx(),a,e.getAnimationDuration());o&&t.Playable.appendOnEnd(d,()=>{a.addChild(o),o.setMatrix(n)}),e.add(d,c.UPDATE)},renderDropSiteFeedback:(e,a)=>{var i=d(e,a.getData(),"background"),o=new t.Rect(e.getCtx(),i.getX(),i.getY(),i.getWidth(),i.getHeight());o.setPixelHinting(!0);var r=u.getCellDropTargetStyle(e);return C._applyStyleToRect(o,r),a.addChildAt(o,a.getChildIndex(i)+1),o},_applyStyleToRect:(e,a)=>{var i=a.getStyle(t.CSSStyle.BACKGROUND),o=a.getStyle(t.CSSStyle.BACKGROUND_COLOR),r=i||o;if(r&&l(e,r),"solid"==a.getStyle(t.CSSStyle.BORDER_STYLE)){var n=a.getStyle(t.CSSStyle.BORDER_COLOR);n=n||"#000000";var s=a.getStyle(t.CSSStyle.BORDER_WIDTH);s=null==s?1:parseFloat(s),e.setSolidStroke(n,null,s)}},_addAccessibilityAttr:(e,a,i)=>{var o=t.Agent.isTouchDevice()?d(e,a,"background"):i;if(o.setAriaRole("img"),!t.Agent.deferAriaCreation()){var r=i.getAriaLabel();r&&o.setAriaProperty("label",r)}},_createShadow:e=>{if(e&&e.length>0&&"none"!==e){var a=e.match(/\S+\([^\)]+\)|\S+/g),i=e.charAt(0);return i>="0"&&i<="9"?new t.Shadow(parseInt(a[0]),parseInt(a[1]),parseInt(a[2])/2,a[4]):new t.Shadow(parseInt(a[1]),parseInt(a[2]),parseInt(a[3])/2,a[0])}return null}};class _ extends t.Container{constructor(e,t){var a=g.getRowIndex(e,t.row),i=g.getColIdx(e,t.column);super(e.getCtx(),null,"c:"+a+","+i),this._nbox=e,this._data=t,this._data.__cacheId="cell:"+this.getId(),this._scrollContainer=!1,this.nboxType="cell"}getData(){return this._data}render(e,t){e.addChild(this),s(this._nbox,this._data,this),C.render(this._nbox,this._data,this,t),this._nbox.EventManager.associate(this,this)}getChildContainer(){return this._childContainer}setChildContainer(e){this._childContainer=e}animateUpdate(e,t){C.animateUpdate(e,t,this)}animateDelete(e){C.animateDelete(e,this)}animateInsert(e){C.animateInsert(e,this)}isDoubleClickable(){return g.isMaximizeEnabled(this._nbox)}handleDoubleClick(){if(this.isDoubleClickable()){var e,a=g.getMaximizedRow(this._nbox),i=g.getMaximizedCol(this._nbox);g.fireOptionChangeEvent(this._nbox,"_drawer",null),a==this._data.row&&i==this._data.column?(g.fireOptionChangeEvent(this._nbox,"maximizedRow",null),g.fireOptionChangeEvent(this._nbox,"maximizedColumn",null)):(g.fireOptionChangeEvent(this._nbox,"maximizedRow",this._data.row),g.fireOptionChangeEvent(this._nbox,"maximizedColumn",this._data.column));var o=this._nbox.EventManager.getFocus();o?"node"===o.nboxType?e=this.getCellIndex()!=g.getCellIndex(this._nbox,o.getData()):"overflow"===o.nboxType?e=this!=o.getParentCell():"cell"===o.nboxType?e=this.getCellIndex()!=o.getCellIndex():"categoryNode"===o.nboxType&&(e=this.getCellIndex()!=o.getData().cell):this._nbox.EventManager.setFocusObj(this),e&&(this._nbox.EventManager.setFocusObj(this),this._nbox.EventManager.setFocused(!1)),this._nbox.processEvent(t.EventFactory.newRenderEvent())}}contains(e,t){var a=d(this._nbox,this._data,"background"),i=this.getTranslateX()+a.getX(),o=this.getTranslateY()+a.getY(),r=i+a.getWidth(),n=o+a.getHeight();return i<=e&&e<=r&&o<=t&&t<=n}renderDropSiteFeedback(){return C.renderDropSiteFeedback(this._nbox,this)}HandleKeyboardEvent(e){var a=g.getMaximizedRow(this._nbox),i=g.getMaximizedCol(this._nbox),o=a==this._data.row&&i==this._data.column;(!o&&e.keyCode==t.KeyboardEvent.ENTER||o&&e.keyCode==t.KeyboardEvent.ESCAPE)&&this.handleDoubleClick()}getAriaLabel(){var e=this.getCellIndex(),a=[],i=this._nbox.getOptions().translations;return g.isCellMaximized(this._nbox,e)?a.push(i.stateMaximized):g.isCellMinimized(this._nbox,e)&&a.push(i.stateMinimized),a.push([i.labelSize,this.getNodeCount()]),t.Displayable.generateAriaLabel(this.getData().shortDesc,a)}getKeyboardBoundingBox(){return i(this)}getTargetElem(){return this.getElem()}showKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!0,d(this._nbox,this.getData(),"focusEffect").show()}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,d(this._nbox,this.getData(),"focusEffect").hide()}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}getNextNavigable(e){var a=null;return this._nbox.EventManager.getKeyboardHandler().isNavigationEvent(e)&&(a=e.keyCode==t.KeyboardEvent.OPEN_BRACKET?this._getFirstNavigableChild(e):this._getNextSibling(e)),a}_getNextSibling(e){for(var t=[],a=g.getRowCount(this._nbox)*g.getColCount(this._nbox),i=0;i<a;i++)t.push(d(this._nbox,g.getCell(this._nbox,i)));return h.getNextNavigableCell(this,e,t,this._nbox)}_getFirstNavigableChild(e){var t=null,a=g.getMaximizedRow(this._nbox),i=g.getMaximizedCol(this._nbox),o=g.getDrawer(this._nbox);if(o&&a==this.getData().row&&i==this.getData().column)t=d(this._nbox,o);else{var r=this.getChildContainer();if(r.getScrollingPane&&(r=r.getScrollingPane()),r.getNumChildren()>0&&("node"===r.getChildAt(0).nboxType||"overflow"===r.getChildAt(0).nboxType))t=g.getFirstNavigableNode(r);else{for(var n=[],l=0;l<r.getNumChildren();l++){var s=r.getChildAt(l);"categoryNode"===s.nboxType&&n.push(s)}t=h.getNextNavigableCategoryNode(null,e,n)}}return t}getCellIndex(){return g.getCellIdxByRowCol(this._nbox,this.getData().row,this.getData().column)}getLabel(){var e=this.getData().label;return e||null}getCountLabel(){var e=this.getData(),t=this._nbox.getOptions().countLabel;return t?t({row:e.row,column:e.column,nodeCount:this.getNodeCount(),highlightedNodeCount:this.getHighlightedNodeCount(),totalNodeCount:g.getNodeCount(this._nbox)}):e.countLabel}getBackground(){var e=u.getCellStyle(this._nbox,this.getCellIndex()),a=e.getStyle(t.CSSStyle.BACKGROUND),i=e.getStyle(t.CSSStyle.BACKGROUND_COLOR);return a||i}hasOverflowIndicator(){var e=this._nbox.getOptions();if(e&&e.__layout&&e.__layout.__nodeLayout&&e.__layout.__nodeLayout.cellLayouts){var t=this.getCellIndex(),a=e.__layout.__nodeLayout.cellLayouts[t];if(a)return a.overflow}return!1}getNodeCount(){return g.getCellCounts(this._nbox).total[this.getCellIndex()]}getHighlightedNodeCount(){var e=g.getCellCounts(this._nbox);return e.highlighted?e.highlighted[this.getCellIndex()]:null}getNode(e){var t=this._nbox.getOptions().nodes;if(t)for(var a=0,i=0;i<t.length;i++)if(this.getData().row==t[i].row&&this.getData().column==t[i].column&&!g.isNodeHidden(this._nbox,t[i])){if(e==a)return t[i];a++}return null}getDisplayable(){return this}getKeyboardFocusDisplayable(){return"acrossCells"==g.getGroupBehavior(this._nbox)&&this._nbox.getOptions().__groups?null:d(this._nbox,g.getCell(this._nbox,g.getCellIndex(this._nbox,this.getData())))}}const p={_MIN_CORNER_RADIUS:2.5,_ASPECT_RATIO_SCALING:"xMidYMid slice",render:(e,t,a,i)=>{p._renderNodeBackground(e,t,a,i),p._renderNodeIndicator(e,t,a,i),p._renderNodeIcon(e,t,a,i),p._renderNodeLabels(e,t,a,i),p._addAccessibilityAttr(a);var o=a.getChildContainer();o&&p._clip(e,o,i)},calculateNodeLayout:(e,a)=>{for(var i,o,r=e.getOptions(),n=parseInt(r.__layout.gridGap),l=r.__layout.nodeStartLabelGap,s=r.__layout.nodeLabelOnlyStartLabelGap,d=r.__layout.nodeEndLabelGap,h=r.__layout.nodeSwatchSize,c=parseInt(r.__layout.maximumLabelWidth),C=p._calculateSimpleNodeLayout(e),_=C.nodeHeight,b=C.indicatorSectionWidth,v=C.iconSectionWidth,x=b||v?l:s,f=g.getNode(e,0),y=u.getIndicatorIcon(e,f),m=u.getIcon(e,f),S=0,w=[],N=0,A=0,D=g.getMaximizedRow(e),I=g.getMaximizedCol(e),T=g.getRowCount(e),E=g.getColCount(e),O=0;O<T;O++)for(var M=0;M<E;M++)w.push({cellRows:0,cellColumns:0,overflow:!1});for(var R=[],L=g.getNodeCount(e),P=0;P<L;P++){var H=g.getNode(e,P);if(!g.isNodeHidden(e,H)){var B=g.getCellIndex(e,H);isNaN(R[B])&&(R[B]=0),R[B]++}}if(D&&I){var F=g.getColIdx(e,I)+E*g.getRowIndex(e,D),G=g.getCell(e,F).__childArea;if(null==(S=C.labelSectionWidth)){if("ifRequired"!=r.labelTruncation)S=c+x+d;else{var k=a[F];S=Math.max(c,p._getMaxLabelWidth(e,k))+x+d}S=Math.min(S,G.w-b-v)}if(A=Math.floor((G.w+n)/(b+v+S+n)),f.label){var z=new t.Container,U=!1,W=u.getNodeLabel(e,f),K=W.getDimensions().h;if(t.TextUtils.fitText(W,S-x-d,K,z)&&(U=!0),f.secondaryLabel){var j=u.getNodeSecondaryLabel(e,f),V=j.getDimensions().h;t.TextUtils.fitText(j,S-x-d,V,z)&&(U=!0)}U||(S=0,f.color&&(y&&!u.getNodeIndicatorColor(e,f)||m&&!m.source||(S=Math.max(0,Math.min(h,G.w-b-v)))))}if(G.w-b-v<0){var Y=v;v=Math.max(0,G.w-b)}G.w-b<0&&(b=G.w),w[F]={cellRows:-1,cellColumns:A,overflow:!1}}else{var X=[];if(D)for(var q=g.getRowIndex(e,D),J=0;J<E;J++)X.push(J+q*E);else if(I)for(var Q=g.getColIdx(e,I),Z=0;Z<T;Z++)X.push(Q+Z*E);else for(var $=0;$<w.length;$++)X.push($);if(null!=C.labelSectionWidth)S=C.labelSectionWidth,G=g.getCell(e,X[0]).__childArea,N=Math.floor((G.h+n)/(_+n)),A=Math.floor((G.w+n)/(b+v+S+n));else{for(var ee=0,te=0;te<X.length;te++)"number"==typeof R[X[te]]&&(R[X[te]]>R[ee]||"number"!=typeof R[ee])&&(ee=X[te]);if("ifRequired"!=r.labelTruncation)if(G=g.getCell(e,ee).__childArea,(i=Math.floor((G.h+n)/(_+n)))*(o=Math.floor((G.w+n)/(b+v+parseInt(r.__layout.minimumLabelWidth)+x+d+n)))<R[ee])S=Math.floor(Math.min(parseInt(r.__layout.maximumLabelWidth)+x+d,(G.w+n)/o-(b+v+n))),N=i,A=o;else{var ae=o;for(S=Math.floor(Math.min(parseInt(r.__layout.maximumLabelWidth)+x+d,(G.w+n)/ae-(b+v+n)));S<parseInt(r.__layout.maximumLabelWidth)+x+d&&(ae-1)*i>=R[ee];)ae--,S=Math.floor(Math.min(parseInt(r.__layout.maximumLabelWidth)+x+d,(G.w+n)/ae-(b+v+n)));N=i,A=ae}else{G=g.getCell(e,X[0]).__childArea,i=Math.floor((G.h+n)/(_+n)),o=Math.floor((G.w+n)/(b+v+parseInt(r.__layout.minimumLabelWidth)+x+d+n)),N=i;for(var ie=0,oe=0;A<=o;){A++;var re=Math.floor((G.w+n)/A-(b+v+n));if(ie>re){A=Math.max(A-1,1);break}for(var ne=A*N,le=[],se=0;se<T;se++)for(var de=0;de<E;de++){if((f=a[g.getColIdx(e,de)+E*g.getRowIndex(e,se)])&&f.length){var ge=Math.min(f.length,ne);f.length>ne&&ge--;for(var he=oe;he<ge;he++)le.push(f[he])}}if((ie=Math.max(ie,Math.ceil(p._getMaxLabelWidth(e,le)+x+d)))>re){A=Math.max(A-1,1);break}if(ne>=R[ee])break;oe=ne}(S=ie>(re=Math.floor((G.w+n)/A-(b+v+n)))?re:Math.max(ie,Math.min(re,c+x+d)))<parseInt(r.__layout.minimumLabelWidth)&&(A=0)}}for(var ue=0;ue<X.length;ue++){var ce=X[ue],Ce=!1;R[ce]>N*A&&(Ce=!0),w[ce]={cellRows:N,cellColumns:A,overflow:Ce}}}var _e={nodeHeight:_,indicatorSectionWidth:b,iconSectionWidth:v,iconWidth:Y,labelSectionWidth:S,cellLayouts:w};return r.__layout.__nodeLayout=_e,_e},calculateNodeDrawerLayout:(e,a,i)=>{var o,r=e.getOptions(),n=parseInt(r.__layout.gridGap),l=r.__layout.nodeStartLabelGap,s=r.__layout.nodeLabelOnlyStartLabelGap,d=r.__layout.nodeEndLabelGap,h=r.__layout.nodeSwatchSize,c=parseInt(r.__layout.maximumLabelWidth),C=g.getNode(e,0),_=u.getIndicatorIcon(e,C),b=u.getIcon(e,C),v=p._calculateSimpleNodeLayout(e),x=v.nodeHeight,f=v.indicatorSectionWidth,y=v.iconSectionWidth,m=f||y?l:s,S=a.__childArea;null==(o=v.labelSectionWidth)&&(o="ifRequired"!=r.labelTruncation?c+m+d:Math.max(c,p._getMaxLabelWidth(e,i))+m+d,o=Math.min(o,S.w-f-y));var w=Math.floor((S.w+n)/(f+y+o+n));if(C.label){var N=new t.Container,A=!1,D=u.getNodeLabel(e,C),I=D.getDimensions().h;if(t.TextUtils.fitText(D,o-m-d,I,N)&&(A=!0),C.secondaryLabel){var T=u.getNodeSecondaryLabel(e,C),E=T.getDimensions().h;t.TextUtils.fitText(T,o-m-d,E,N)&&(A=!0)}A||(o=0,C.color&&(_&&!u.getNodeIndicatorColor(e,C)||b&&!b.source||(o=Math.max(0,Math.min(h,S.w-f-y)))))}if(S.w-f-y<0){var O=y;y=Math.max(0,S.w-f)}S.w-f<0&&(f=S.w);var M={nodeHeight:x,indicatorSectionWidth:f,iconSectionWidth:y,iconWidth:O,labelSectionWidth:o,drawerLayout:{rows:-1,columns:w}};return r.__layout.__nodeDrawerLayout=M,M},_calculateSimpleNodeLayout:e=>{var a=e.getOptions(),i=a.__layout.nodeIndicatorGap,o=parseInt(a.__layout.nodeSingleLabelGap),r=parseInt(a.__layout.nodeDualLabelGap),n=a.__layout.nodeInterLabelGap,l=a.__layout.nodeSwatchSize,s=g.getNode(e,0),d=0,h=0,c=0,C=null,_=u.getIndicatorIcon(e,s),p=u.getNodeIndicatorColor(e,s),b=u.getIcon(e,s);if(_){var v=_.width,x=_.height;h=v+2*i,d=Math.max(d,x+2*i)}else p&&(h=l);if(s.label){var f=u.getNodeLabel(e,s).getDimensions().h;if(d=Math.max(d,f+2*o),s.secondaryLabel){var y=u.getNodeSecondaryLabel(e,s).getDimensions().h;d=Math.max(d,f+y+2*r+n)}}else C=0,s.color&&(_&&!u.getNodeIndicatorColor(e,s)||b&&!b.source||(C=h||l));if(b){var m=t.Agent.isTouchDevice()?b.preferredSizeTouch:b.preferredSize,S=Math.max(d,s.label?m:parseInt(b.preferredSizeNoLabel)),w=(b.source?b.sourcePaddingRatio:b.shapePaddingRatio)*S,N=b.width?b.width:S-2*w,A=b.height?b.height:S-2*w;c=N+2*w,d=Math.max(d,A+2*w)}return{nodeHeight:d,indicatorSectionWidth:h,iconSectionWidth:c,labelSectionWidth:C}},_renderNodeBackground:(e,a,i,o)=>{var r=o.indicatorSectionWidth+o.iconSectionWidth+o.labelSectionWidth,n=o.nodeHeight,l=u.getNodeBorderRadius(e),d=u.getNodeHoverColor(e),g=u.getNodeSelectionColor(e),h=new t.Rect(e.getCtx(),0,0,r,n);h.setFill(null),l&&(h.setRx(l),h.setRy(l)),h.setHoverStroke(new t.Stroke(d,1,2),new t.Stroke(g,1,4)),h.setSelectedStroke(new t.Stroke(g,1,4),null),h.setSelectedHoverStroke(new t.Stroke(d,1,2),new t.Stroke(g,1,6)),i.addChild(h),i.setSelectionShape(h);var c=new t.Rect(e.getCtx(),0,0,r,n);l&&(c.setRx(l),c.setRy(l));var C=u.getNodeColor(e,a);c.setSolidFill(C),u.getNodeBorderColor(e,a)&&u.getNodeBorderWidth(e,a)&&c.setSolidStroke(u.getNodeBorderColor(e,a),null,u.getNodeBorderWidth(e,a));var _=a.svgStyle||a.style,p=a.svgClassName||a.className;c.setStyle(_).setClassName(p),i.addChild(c),s(e,a,c,"background")},_renderNodeIndicator:(e,a,i,o)=>{var r=u.getNodeColor(e,a),n=t.ColorUtils.getContrastingTextColor(r),l=t.Agent.isRightToLeft(e.getCtx())?o.labelSectionWidth+o.iconSectionWidth:0,d=u.getNodeIndicatorColor(e,a);if(d){n=t.ColorUtils.getContrastingTextColor(d);var g=new t.Rect(e.getCtx(),l,0,o.indicatorSectionWidth,o.nodeHeight);g.setSolidFill(d),p._clip(e,g,o),i.addChild(g),s(e,a,g,"indicator")}var h=u.getIndicatorIcon(e,a);if(h){var c,C=h.width,_=h.height,b=l+o.indicatorSectionWidth/2,v=o.nodeHeight/2,x=C,f=h.color?h.color:n,y=h.borderColor,m=h.borderWidth,S=h.borderRadius,w=h.pattern;h.source?(c=new t.ImageMarker(e.getCtx(),b,v,C,_,S,h.source)).setPreserveAspectRatio(p._ASPECT_RATIO_SCALING):(c=new t.SimpleMarker(e.getCtx(),h.shape,b,v,C,_,S),m>0&&(x+=m)),m&&c.setSolidStroke(y,null,m),"none"!=w?c.setFill(new t.PatternFill(w,f,r)):c.setSolidFill(f);var N=h.svgStyle||h.style,A=h.svgClassName||h.className;if(c.setStyle(N).setClassName(A),x>o.indicatorSectionWidth)if(S&&h.source)i.getChildContainer(!0).addChild(c);else p._clip(e,c,o),i.addChild(c);else i.addChild(c);s(e,a,c,"indicatorIcon")}},_renderNodeIcon:(e,a,i,r)=>{var l=e.getOptions(),d=u.getNodeColor(e,a),g=t.ColorUtils.getContrastingTextColor(d),h=t.Agent.isRightToLeft(e.getCtx()),c=u.getIcon(e,a);if(c){var C,_,b=(c.source||c.initials?c.sourcePaddingRatio:c.shapePaddingRatio)*r.nodeHeight,v=r.iconWidth?r.iconWidth:r.iconSectionWidth-2*b,x=c.width?c.width:v,f=c.height?c.height:r.nodeHeight-2*b,y=r[h?"labelSectionWidth":"indicatorSectionWidth"]+Math.max(r.iconSectionWidth/2,r.iconWidth?r.iconWidth/2:0),m=r.nodeHeight/2,S=c.color?c.color:g,w=c.borderColor,N=c.borderWidth,A=c.borderRadius,D=c.pattern,I=c.source,T=l._resources["background_"+c.background];if(I)(C=new t.ImageMarker(e.getCtx(),y,m,x,f,A,I)).setPreserveAspectRatio(p._ASPECT_RATIO_SCALING);else if(c.initials){var E=T.src,O=t.ToolkitUtils.getImageUrl(e.getCtx(),E).includes(".");C=new t.SimpleMarker(e.getCtx(),null,y,m,x,f);var M=c.background;if(C.setClassName("oj-nbox-node-initials-bg-color"+("neutral"===M?" oj-nbox-node-initials-neutral":" oj-avatar-bg-"+M+" oj-nbox-node-initials-"+M)),O){var R="ios"===t.Agent.os,L=new t.Container(e.getCtx()),P=R?c.backgroundIosSize:c.backgroundSize,H=new t.ImageMarker(e.getCtx(),y,m,parseInt(P),parseInt(P),A,T.src);H.setClipPath(p._getIconClipPath(e,y,m,x,f)),L.addChild(C),L.addChild(H),H.setClassName(R?"oj-nbox-node-initials-background-pattern oj-nbox-ios":"oj-nbox-node-initials-background-pattern"),C=L}_=o(e.getCtx(),c.initials,null,t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_CENTRAL),n(_,y,m),a.label&&!a.secondaryLabel||!a.label&&parseInt(l.styleDefaults.nodeDefaults.height)>0?_.setClassName("oj-nbox-node-initials"):_.setClassName("oj-nbox-node-initials oj-nbox-node-initials-lg")}else C=new t.SimpleMarker(e.getCtx(),c.shape,y,m,x-N,f-N,A);if(N&&C.setSolidStroke(w,null,N),"none"!=D?C.setFill(new t.PatternFill(D,S,d)):C.setSolidFill(S),!c.initials){var B=c.svgStyle||c.style,F=c.svgClassName||c.className;C.setStyle(B).setClassName(F)}if(0==r.indicatorSectionWidth||0==r.labelSectionWidth)if(A&&c.source)i.getChildContainer(!0).addChild(C);else p._clip(e,C,r),i.addChild(C);else i.addChild(C);s(e,a,C,"icon"),_&&i.addChild(_)}},_renderNodeLabels:(e,a,i,o)=>{var r=e.getOptions(),l=r.__layout.nodeInterLabelGap,d=r.__layout.nodeLabelOnlyStartLabelGap,g=r.__layout.nodeStartLabelGap,h=r.__layout.nodeEndLabelGap,c=o.indicatorSectionWidth||o.iconSectionWidth?g:d,C=u.getNodeColor(e,a),_=t.ColorUtils.getContrastingTextColor(C),p=t.Agent.isRightToLeft(e.getCtx())?o.labelSectionWidth-c:o.indicatorSectionWidth+o.iconSectionWidth+c;if(a.label){var b=u.getNodeLabel(e,a),v=b.getDimensions().h;if(t.TextUtils.fitText(b,o.labelSectionWidth-c-h,v,i)&&(n(b,p,o.nodeHeight/2),b.getCSSStyle()&&b.getCSSStyle().getStyle("color")?b.setSolidFill(b.getCSSStyle().getStyle("color")):b.setSolidFill(_),s(e,a,b,"label")),a.secondaryLabel){var x=u.getNodeSecondaryLabel(e,a),f=x.getDimensions().h;if(t.TextUtils.fitText(x,o.labelSectionWidth-c-h,f,i)){var y=(o.nodeHeight-v-f-l)/2;n(b,p,y+v/2),n(x,p,y+v+l+f/2),x.getCSSStyle()&&x.getCSSStyle().getStyle("color")?x.setSolidFill(x.getCSSStyle().getStyle("color")):x.setSolidFill(_),s(e,a,x,"secondaryLabel")}}}},_getMaxLabelWidth:(e,a)=>{for(var i=[],o=0;o<a.length;o++){var r=a[o];i.push(u.getNodeLabel(e,r)),i.push(u.getNodeSecondaryLabel(e,r))}return t.TextUtils.getMaxTextDimensions(i).w},_clip:(e,a,i)=>{var o=e.getNodeClipPath();if(!o){var r=u.getNodeBorderRadius(e);if(!(r=r<p._MIN_CORNER_RADIUS?0:r))return;var n=i.indicatorSectionWidth+i.iconSectionWidth+i.labelSectionWidth,l=i.nodeHeight;(o=new t.ClipPath).addRect(0,0,n,l,r,r),e.setNodeClipPath(o)}a.setClipPath(o)},_getIconClipPath:(e,a,i,o,r)=>{var n=e.getNodeIconClipPath();return n||((n=new t.ClipPath).addRect(a-o/2,i-r/2,o,r),e.setNodeIconClipPath(n)),n},animateUpdate:(e,a,i)=>{var o=e.getOldNBox(),n=e.getNewNBox(),l=r(a),s=r(i),h=i.getMatrix(),u=i.getParent();a.setAlpha(0),e.getNewNBox().addChild(i),i.setMatrix(l);var C=g.getNodeScrollableContainer(o,a),_=g.getNodeScrollableContainer(n,i);if(C||_){var b,v=new t.ClipPath;if(C){var x=r(C),f=new t.Rectangle(x.getTx(),x.getTy(),C.getWidth(),C.getHeight()),y=g.getCellIndex(o,a.getData()),m=g.getCell(o,y),S=d(o,m,"background"),w=r(S),N=new t.Rectangle(w.getTx(),w.getTy(),S.getWidth(),S.getHeight());b=f.getUnion(N)}if(_){var A=r(_),D=new t.Rectangle(A.getTx(),A.getTy(),_.getWidth(),_.getHeight()),I=g.getCellIndex(n,i.getData()),T=g.getCell(n,I),E=d(n,T,"background"),O=r(E),M=new t.Rectangle(O.getTx(),O.getTy(),E.getWidth(),E.getHeight()),R=D.getUnion(M);b=b?b.getUnion(R):R}b&&(v.addRect(b.x,b.y,b.w,b.h),i.setClipPath(v))}var L=new t.AnimMoveTo(i.getCtx(),i,new t.Point(s.getTx(),s.getTy()),e.getAnimationDuration());t.Playable.appendOnEnd(L,()=>{u.addChild(i),i.setMatrix(h),i.setClipPath(null)}),e.add(L,c.UPDATE);var P=new t.CustomAnimation(n.getCtx(),i,e.getAnimationDuration());p._animateFill(P,o,n,a,i,"background"),p._animateFill(P,o,n,a,i,"label"),p._animateFill(P,o,n,a,i,"secondaryLabel"),p._animateFill(P,o,n,a,i,"indicator"),p._animateFill(P,o,n,a,i,"indicatorIcon"),p._animateFill(P,o,n,a,i,"icon"),e.add(P,c.UPDATE)},_animateFill:(e,a,i,o,r,n)=>{var l=d(a,o.getData(),n),s=d(i,r.getData(),n);l&&s&&s.getFill()instanceof t.SolidFill&&!s.getFill().equals(l.getFill())&&(e.getAnimator().addProp(t.Animator.TYPE_FILL,s,s.getFill,s.setFill,s.getFill()),s.setFill(l.getFill()))},animateDelete:(e,a)=>{var i=c.DELETE,o=e.getOldNBox(),n=e.getNewNBox(),l=o.getOptions().__layout.__nodeLayout;if(l){var s=a.getData(),h=s.id,u=g.getNodeIndex(n,h);if(!isNaN(u)){var C=g.getNode(n,u);if(!g.isNodeHidden(n,C))if(i=c.UPDATE,g.getGrouping(n)){var _=n.getOptions().__groups;"withinCell"==g.getGroupBehavior(n)&&(_=_[g.getCellIndex(n,C)]);var p=_[g.getNodeGroupId(C)];if(p){var b=d(n,p);if(b){var v=r(b),x=new t.Point((l.indicatorSectionWidth+l.iconSectionWidth+l.labelSectionWidth)/2,l.nodeHeight/2);e.add(new t.AnimMoveTo(n.getCtx(),a,new t.Point(v.getTx()-x.x,v.getTy()-x.y),e.getAnimationDuration()),i)}}}else if(s.row!=C.row||s.column!=C.column){var f=r(a),y=a.getDimensions();e.getNewNBox().addChild(a),a.setMatrix(f);var m=g.getCellByRowCol(n,C.row,C.column),S=d(n,m.getData(),"overflow");if(S){var w=r(S);e.add(new t.AnimMoveTo(n.getCtx(),a,new t.Point(w.getTx(),w.getTy()),e.getAnimationDuration()),c.UPDATE)}else{var N=r(m),A=m.getDimensions(),D=new t.Point((l.indicatorSectionWidth+l.iconSectionWidth+l.labelSectionWidth)/2,l.nodeHeight/2);e.add(new t.AnimMoveTo(n.getCtx(),a,new t.Point(N.getTx()+A.w/2-D.x,N.getTy()+A.h/2-D.y),e.getAnimationDuration()),c.UPDATE)}var I=new t.CustomAnimation(n.getCtx(),C,e.getAnimationDuration());return I.getAnimator().addProp(t.Animator.TYPE_NUMBER,a,a.getScaleX,a.setScaleX,.01),I.getAnimator().addProp(t.Animator.TYPE_NUMBER,a,a.getScaleY,a.setScaleY,.01),t.Playable.appendOnEnd(I,()=>{n.getDeleteContainer().addChild(a)}),e.add(I,c.INSERT),e.add(new t.AnimMoveBy(n.getCtx(),a,new t.Point(y.w/2,y.h/2),e.getAnimationDuration()),c.INSERT),void e.add(new t.AnimFadeOut(n.getCtx(),a,e.getAnimationDuration()),c.INSERT)}}a.setMatrix(r(a));var T=g.getNodeScrollableContainer(o,a);if(T){var E=new t.ClipPath,O=r(T),M=new t.Rectangle(O.getTx(),O.getTy(),T._width,T._height);E.addRect(M.x,M.y,M.w,M.h),a.setClipPath(E)}e.add(new t.AnimFadeOut(n.getCtx(),a,e.getAnimationDuration()),i),n.getDeleteContainer().addChild(a)}},animateInsert:(e,a)=>{var i=c.INSERT,o=e.getOldNBox(),n=e.getNewNBox(),l=n.getOptions().__layout.__nodeLayout;if(l){var s=a.getData().id,h=g.getNodeIndex(o,s);if(!isNaN(h)){var u=g.getNode(o,h);if(!g.isNodeHidden(o,u)&&(i=c.UPDATE,g.getGrouping(o))){var C=o.getOptions().__groups;"withinCell"==g.getGroupBehavior(o)&&(C=C[g.getCellIndex(o,u)]);var _=C[g.getNodeGroupId(u)];if(_){var p=d(o,_);if(p){var b=a.getMatrix(),v=a.getParent(),x=r(a),f=r(p),y=new t.Point((l.indicatorSectionWidth+l.iconSectionWidth+l.labelSectionWidth)/2,l.nodeHeight/2);n.addChild(a),a.setMatrix(f.translate(-y.x,-y.y));var m=new t.AnimMoveTo(n.getCtx(),a,new t.Point(x.getTx(),x.getTy()),e.getAnimationDuration());t.Playable.appendOnEnd(m,()=>{a.setMatrix(b),v.addChild(a)}),e.add(m,i)}}}}var S=new t.CustomAnimation(n.getCtx(),a,e.getAnimationDuration());S.getAnimator().addProp(t.Animator.TYPE_NUMBER,a,a.getAlpha,a.setAlpha,a.getAlpha()),e.add(S,i),a.setAlpha(0)}},_addAccessibilityAttr:e=>{if(e.setAriaRole("img"),!t.Agent.deferAriaCreation()){var a=e.getAriaLabel();a&&e.setAriaProperty("label",a)}}};class b extends t.Container{constructor(e,a){super(e.getCtx(),null,a.id),this._nbox=e,this._data=a,this._nbox.registerObject(this);var i=this._nbox.getOptions().selectionMode;"single"!=i&&"multiple"!=i||this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this._maxAlpha=1,this.nboxType="node"}getData(){return this._data}render(e,t){p.render(this._nbox,this._data,this,t),e.addChild(this),s(this._nbox,this._data,this),this._nbox.EventManager.associate(this,this)}isSelectable(){return!0}isSelected(){return this.getSelectionShape().isSelected()}setSelected(e){this.getSelectionShape().setSelected(e),this.UpdateAccessibilityAttr()}showHoverEffect(){this.getSelectionShape().showHoverEffect()}hideHoverEffect(){this.getSelectionShape().hideHoverEffect()}setSelectionShape(e){this._selectionShape=e}getSelectionShape(){return this._selectionShape}getDatatip(){var e=this._nbox.getOptions().tooltip,a=e?e.renderer:null;if(a){var i={id:this._data.id,label:this._data.label,secondaryLabel:this._data.secondaryLabel,row:this._data.row,column:this._data.column,color:u.getNodeColor(this._nbox,this._data),indicatorColor:u.getNodeIndicatorColor(this._nbox,this._data)};return this._nbox.getCtx().getTooltipManager().getCustomTooltip(a,i)}return t.Displayable.resolveShortDesc(this.getShortDesc(),()=>b.getShortDescContext(this))}getShortDesc(){return this._data.shortDesc}getDatatipColor(){return u.getNodeColor(this._nbox,this._data)}setMaxAlpha(e){this._maxAlpha=e,this.setAlpha(this.getAlpha())}getMaxAlpha(){return this._maxAlpha}setAlpha(e){super.setAlpha(Math.min(e,this._maxAlpha))}animateUpdate(e,t){p.animateUpdate(e,t,this)}animateDelete(e){p.animateDelete(e,this)}animateInsert(e){p.animateInsert(e,this)}isDoubleClickable(){return!0}handleDoubleClick(){this._getParentContainer().handleDoubleClick()}isDragAvailable(e){return this._nbox.__isDragAvailable(e)}getDragTransferable(){return this._nbox.__getDragTransferable(this)}getDragFeedback(){return this._nbox.__getDragFeedback()}_getParentContainer(){var e,t=g.getDrawer(this._nbox);if(t)e=d(this._nbox,t);else{var a=g.getCellIndex(this._nbox,this._data),i=g.getCell(this._nbox,a);e=d(this._nbox,i)}return e}UpdateAccessibilityAttr(){if(!t.Agent.deferAriaCreation()){var e=this.getAriaLabel();e&&this.setAriaProperty("label",e)}}getAriaLabel(){return g.buildAriaDesc(this._nbox,this,this.getShortDesc(),this.isSelected(),()=>b.getShortDescContext(this))}static getShortDescContext(e){var t=e.getData();return{id:t.id,label:t.label,secondaryLabel:t.secondaryLabel,row:t.row,column:t.column}}getCategories(){return this.getData().categories?this.getData().categories:[]}getKeyboardBoundingBox(){return i(this)}getTargetElem(){return this.getElem()}showKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect();var e=g.getNodeScrollableContainer(this._nbox,this);e&&e.scrollIntoView(this)}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}getNextNavigable(e){var a=null;return e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey?this:(this._nbox.EventManager.getKeyboardHandler().isNavigationEvent(e)?a=e.keyCode==t.KeyboardEvent.CLOSE_BRACKET?this._getParentContainer():e.keyCode==t.KeyboardEvent.OPEN_BRACKET?this:g.getNextNavigableNode(this,e):e.type==t.MouseEvent.CLICK&&(a=this),a)}HandleKeyboardEvent(e){if(g.getDrawer(this._nbox)&&e.keyCode==t.KeyboardEvent.ESCAPE)this.handleDoubleClick();else{var a=g.getMaximizedRow(this._nbox),i=g.getMaximizedCol(this._nbox),o=a==this._data.row&&i==this._data.column;(!o&&e.keyCode==t.KeyboardEvent.ENTER||o&&e.keyCode==t.KeyboardEvent.ESCAPE)&&this.handleDoubleClick()}}getDisplayable(){return this}getKeyboardFocusDisplayable(){var e=g.getNode(this._nbox,g.getNodeIndex(this._nbox,this.getData().id));if(e){var t=d(this._nbox,e);if(t)return t;var a=g.getCell(this._nbox,g.getCellIndex(this._nbox,e)),i=d(this._nbox,a),o=g.getLastNavigableNode(i.getChildContainer());if("overflow"===o.nboxType)return o;var r=this._getParentDrawer();return r?r.getKeyboardFocusDisplayable():i.getKeyboardFocusDisplayable()}return null}_getParentDrawer(){for(var e=this;e&&e.getParent;)if((e=e.getParent())&&"drawer"===e.nboxType)return e;return null}getChildContainer(e){return!e||this._childContainer||(this._childContainer=new t.Container(this.getCtx()),this.addChild(this._childContainer)),this._childContainer}setChildContainer(e){this._childContainer=e}}const v={render:(e,t,a,i,o)=>{v._renderNodeBackground(e,t,a,i,o);var r=v._renderNodeIndicator(e,t,a,i,o);v._renderNodeCount(e,t,a,i,r,o),v._addAccessibilityAttr(a)},_renderNodeBackground:(e,a,i,o,r)=>{a.__scale=o,a.__gap=r;var n=Math.max(0,v.getSideLength(a)),l=u.getNodeBorderRadius(e),s=u.getNodeHoverColor(e),d=u.getNodeSelectionColor(e),g=new t.Rect(e.getCtx(),-n/2,-n/2,n,n);g.setFill(null),l&&(g.setRx(l),g.setRy(l)),g.setHoverStroke(new t.Stroke(s,1,2),new t.Stroke(d,1,4)),g.setSelectedStroke(new t.Stroke(d,1,4),null),g.setSelectedHoverStroke(new t.Stroke(s,1,2),new t.Stroke(d,1,6)),i.addChild(g),i.setSelectionShape(g);var h=new t.Rect(e.getCtx(),-n/2,-n/2,n,n);l&&(h.setRx(l),h.setRy(l));var c=u.getCategoryNodeColor(e,a);h.setSolidFill(c),i.addChild(h)},getSideLength:e=>e.__scale*Math.sqrt(e.nodeIndices.length)-e.__gap,_renderNodeIndicator:(e,a,i,o,r)=>{var n=!1,l=e.getOptions().__layout.markerGap,d=t.Agent.isRightToLeft(e.getCtx()),g=o*Math.sqrt(a.nodeIndices.length)-r,h=u.getCategoryNodeColor(e,a),c=t.ColorUtils.getContrastingTextColor(h),C=g/4,_=1,p=d?g/2-C:-g/2,b=u.getStyledCategoryIndicatorIcon(e,a);if(b){var v=C/(b.width+2*l),x=g/(b.height+2*l);_=Math.min(v,x)}var f=u.getCategoryNodeIndicatorColor(e,a);if(f){c=t.ColorUtils.getContrastingTextColor(f);var y=new t.Rect(e.getCtx(),p,-g/2,C,g);y.setSolidFill(f),i.addChild(y),n=!0}if(b){var m=b.color?b.color:c,S=new t.SimpleMarker(e.getCtx(),b.shape,(d?1:-1)*(g-C)/2,0,b.width*_,b.height*_,b.borderRadius);b.borderWidth&&S.setSolidStroke(b.borderColor,null,b.borderWidth),b.pattern&&"none"!=b.pattern?S.setFill(new t.PatternFill(b.pattern,m,h)):S.setSolidFill(m),S.setStyle(b.style).setClassName(b.className),i.addChild(S),s(e,a,S,"indicatorIcon"),n=!0}return n},_renderNodeCount:(e,a,i,r,l,h)=>{var c,C=e.getOptions().__layout.categoryNodeLabelGap,_=t.Agent.isRightToLeft(e.getCtx()),p=u.getFadedNodeAlpha(e),b=g.getHighlightedItems(e),v=d(e,a,"label");if(b){if(0==(c=a.highlightedCount))return v&&v.setTextString(""),void i.setAlpha(p)}else c=a.nodeIndices.length;var x=r*Math.sqrt(a.nodeIndices.length)-h,f=l?.75*x:x,y=(_?-1:1)*(x-f)/2,m=u.getCategoryNodeColor(e,a),S=t.ColorUtils.getContrastingTextColor(m),w=new t.Rectangle(0,0,f-2*C,x-2*C);v?v.setTextString(""+c):(v=o(e.getCtx(),""+c,u.getCategoryNodeLabelStyle(e),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_CENTRAL),s(e,a,v,"label"));var N=t.TextUtils.getOptimalFontSize(v.getCtx(),v.getTextString(),v.getCSSStyle(),w);v.setFontSize(N),t.TextUtils.fitText(v,f-2*C,x-2*C,i)&&(n(v,y,0),v.setSolidFill(S))},animateUpdate:(e,a,i)=>{var o=r(a),n=r(i),l=i.getMatrix(),s=i.getParent();a.setAlpha(0),e.getNewNBox().addChild(i),i.setMatrix(o);var d=new t.AnimMoveTo(i.getCtx(),i,new t.Point(n.getTx(),n.getTy()),e.getAnimationDuration());t.Playable.appendOnEnd(d,()=>{s.addChild(i),i.setMatrix(l)}),e.add(d,c.UPDATE)},animateDelete:(e,a)=>{var i=c.UPDATE,o=e.getOldNBox(),n=e.getNewNBox();v.isMaximizeEqual(o,n)&&v.isGroupingEqual(o,n)&&(i=c.DELETE);var l=new t.AnimScaleTo(n.getCtx(),a,new t.Point(.01,.01),e.getAnimationDuration());e.add(l,i);var s=new t.AnimFadeOut(n.getCtx(),a,e.getAnimationDuration());e.add(s,i),a.setMatrix(r(a)),n.getDeleteContainer().addChild(a)},animateInsert:(e,a)=>{var i=c.UPDATE,o=e.getOldNBox(),r=e.getNewNBox();v.isMaximizeEqual(o,r)&&v.isGroupingEqual(o,r)&&(i=c.INSERT),a.setScaleX(.01),a.setScaleY(.01);var n=new t.AnimScaleTo(r.getCtx(),a,new t.Point(1,1),e.getAnimationDuration());e.add(n,i);var l=new t.CustomAnimation(r.getCtx(),a,e.getAnimationDuration());l.getAnimator().addProp(t.Animator.TYPE_NUMBER,a,a.getAlpha,a.setAlpha,a.getAlpha()),e.add(l,i),a.setAlpha(0)},isGroupingEqual:(e,t)=>{var a=g.getGroupBehavior(e),i=g.getGroupBehavior(t),o=g.getNodeCount(e),r=g.getNodeCount(t),n=!1;if(a==i&&o==r){n=!0;for(var l=0;l<o;l++){if(g.getNodeGroupId(g.getNode(e,l))!=g.getNodeGroupId(g.getNode(t,l))){n=!1;break}}}return n},isMaximizeEqual:(e,t)=>{var a=g.getMaximizedRow(e),i=g.getMaximizedCol(e),o=g.getMaximizedRow(t),r=g.getMaximizedCol(t);return a==o&&i==r},_addAccessibilityAttr:e=>{if(e.setAriaRole("img"),!t.Agent.deferAriaCreation()){var a=e.getAriaLabel();a&&e.setAriaProperty("label",a)}}},x={render:(e,a,i,o)=>{var r=x.getDrawerBounds(e,a,o);a.__drawerBounds=r,i.setTranslate(r.x,r.y);var n=new t.KeyboardFocusEffect(e.getCtx(),i,new t.Rectangle(-1,-1,r.w+2,r.h+2));s(e,a,n,"focusEffect"),x._renderBody(e,a,i),x._renderHeader(e,a,i),x._addAccessibilityAttr(e,a,i)},_renderHeader:(e,a,i)=>{var r=e.getOptions(),l=r.__layout.drawerButtonGap,s=r.__layout.drawerStartGap,h=r.__layout.drawerLabelGap,c=r.__layout.drawerCountHorizontalGap,C=r.__layout.drawerCountVerticalGap,_=r.__layout.drawerHeaderHeight,p=r.__layout.nodeIndicatorGap,b=r.__layout.nodeSwatchSize,v=t.Agent.isRightToLeft(e.getCtx()),x=g.getCategoryNode(e,a.id),f=x.nodeIndices.length,y=a.__drawerBounds,m=r._resources.close,S=m.width;if(y.w>S){var w=m.height,N=e.getCtx(),A=t.ToolkitUtils.getIconStyle(N,m.class),D=new t.IconButton(N,"borderless",{style:A,size:S},null,null,i.closeDrawer,i),I=v?Math.min((y.w-S)/2,l):Math.max((y.w-S)/2,y.w-l-S);D.setTranslate(I,_/2-w/2),i.addChild(D)}var T=u.getCategoryNodeColor(e,x),E=t.ColorUtils.getContrastingTextColor(T),O=u.getCategoryNodeIndicatorColor(e,x),M=O?t.ColorUtils.getContrastingTextColor(O):E,R=u.getStyledCategoryIndicatorIcon(e,x),L=b,P=1;if(R){var H=R.width;L=(P=b/R.height)*H,M=R.color?R.color:M}var B,F=u.getDrawerCountBorderRadius(e),G=v?t.OutputText.H_ALIGN_RIGHT:t.OutputText.H_ALIGN_LEFT,k=o(e.getCtx(),""+f,u.getDrawerCountLabelStyle(e),G,t.OutputText.V_ALIGN_CENTRAL),z=k.getDimensions(),U=z.w,W=z.h+2*C,K=R?L+2*p:O?b:0,j=U+2*c,V=K+j;if(y.w-S-2*l-s>V){var Y=t.PathUtils.roundedRectangle(0,0,V,W,F,F,F,F);(B=new t.Path(e.getCtx(),Y)).setSolidFill(T),i.addChild(B);var X=v?j:0;if(K>0){if(O){var q=t.PathUtils.roundedRectangle(X,0,K,W,v?0:F,v?F:0,v?F:0,v?0:F),J=new t.Path(e.getCtx(),q);J.setSolidFill(O),B.addChild(J)}if(R){var Q=new t.SimpleMarker(e.getCtx(),R.shape,X+K/2,W/2,R.width*P,R.height*P,R.borderRadius);R.borderWidth&&Q.setSolidStroke(R.borderColor,null,R.borderWidth),R.pattern&&"none"!=R.pattern?Q.setFill(new t.PatternFill(R.pattern,M,O||T)):Q.setSolidFill(M),Q.setStyle(R.style).setClassName(R.className),B.addChild(Q)}}B.addChild(k),k.setSolidFill(E),n(k,v?j-c:K+c,W/2)}var Z=d(e,x).getLabel(),$=o(e.getCtx(),Z,u.getDrawerLabelStyle(e),G,t.OutputText.V_ALIGN_CENTRAL),ee=0;if(t.TextUtils.fitText($,y.w-s-h-V-2*l-S,_,i)){var te=v?y.w-s:s;n($,te,_/2),ee=$.getDimensions().w+h}if(B){var ae=v?y.w-s-V-ee:s+ee;B.setTranslate(ae,(_-W)/2)}},_renderBody:(e,a,i)=>{var o=e.getOptions(),r=parseInt(o.__layout.gridGap),n=o.__layout.drawerHeaderHeight,h=a.__drawerBounds,c=t.Agent.isRightToLeft(e.getCtx()),C=u.getDrawerBorderRadius(e),_=u.getDrawerBorderColor(e),v=t.PathUtils.roundedRectangle(0,0,h.w,h.h,C,C,C,C),f=new t.Path(e.getCtx(),v);l(f,u.getDrawerBackground(e)),f.setSolidStroke(_),f.setPixelHinting(!0),i.addChild(f),s(e,a,f,"background"),a.__childArea=new t.Rectangle(r,n+r,Math.max(h.w-2*r,0),Math.max(h.h-n-2*r,0));var y=new t.SimpleScrollableContainer(e.getCtx(),h.w,h.h-n);y.setTranslate(0,n),i.addChild(y),i.setChildContainer(y);var m=u.getFadedNodeAlpha(e),S=g.getHighlightedItems(e),w={};if(S)for(var N=0;N<S.length;N++)w[S[N].id]=!0;for(var A=x.calculateNodeOrders(e,a),D=p.calculateNodeDrawerLayout(e,a,A),I=D.indicatorSectionWidth+D.iconSectionWidth+D.labelSectionWidth+r,T=D.nodeHeight+r,E=d(e,a).getChildContainer(),O=0;O<A.length;O++){var M=A[O];if(0!=D.drawerLayout.columns&&0!=D.drawerLayout.rows){var R=new b(e,M),L=a.__childArea.x+(a.__childArea.w-D.drawerLayout.columns*I+r)/2,P=r,H=O%D.drawerLayout.columns;c&&(H=D.drawerLayout.columns-H-1);var B=Math.floor(O/D.drawerLayout.columns);R.setTranslate(L+I*H,P+T*B),R.render(E.getScrollingPane(),D),S&&!w[M.id]&&R.setAlpha(m);var F=O>0?A[O-1]:null;if(F){var G=d(e,F);R.previousNavigable=G,G.nextNavigable=R}}}E.prepareContentPane()},calculateNodeOrders:(e,t)=>{var a=["normal"],i=g.getHighlightedItems(e),o={};if(i)for(var r=0;r<i.length;r++)o[i[r].id]=!0;var n=g.getSelectedItems(e),l={};if(n)for(var s=0;s<n.length;s++)l[n[s]]=!0;i?a=n?["highlighted-selected","highlighted-unselected","unhighlighted-selected","unhighlighted-unselected"]:["highlighted-unselected","unhighlighted-unselected"]:n&&(a=["unhighlighted-selected","unhighlighted-unselected"]);for(var d=[],h=g.getCategoryNode(e,t.id),u=h.nodeIndices.length,c=0;c<a.length;c++)for(var C=0;C<u;C++){var _=g.getNode(e,h.nodeIndices[C]);("normal"==a[c]||"highlighted-selected"==a[c]&&o[_.id]&&l[_.id]||"highlighted-unselected"==a[c]&&o[_.id]&&!l[_.id]||"unhighlighted-selected"==a[c]&&!o[_.id]&&l[_.id]||"unhighlighted-unselected"==a[c]&&!o[_.id]&&!l[_.id])&&d.push(_)}return d},getDrawerBounds:(e,a,i)=>{var o=e.getOptions(),r=parseInt(o.__layout.gridGap),n=C.getCellLayout(e),l=new t.Rectangle(i.x+r,i.y+r,Math.max(i.w-2*r,0),Math.max(i.h-2*r,0));if("withinCell"==g.getGroupBehavior(e)){var s=parseInt(a.id.substring(0,a.id.indexOf(":")));if(g.isCellMaximized(e,s)){var d=g.getCell(e,s),h=g.getRowIndex(e,d.row),u=g.getColIdx(e,d.column),c=C.getCellDims(e,h,u,i);l=new t.Rectangle(c.x+r,c.y+r+n.maximizedHeaderSize,Math.max(c.w-2*r,0),Math.max(c.h-n.maximizedHeaderSize-2*r,0))}}return l},animateUpdate:()=>{},animateDelete:(e,a)=>{var i=c.UPDATE,o=e.getNewNBox(),n=a.getData().__drawerBounds,l=a.getData().id,s=g.getCategoryNode(o,l);if(s){var h=v.getSideLength(s),u=h/n.w,C=h/n.h,_=d(o,s);if(_){var p=r(_),b=new t.Matrix(u,0,0,C,p.getTx()-h/2,p.getTy()-h/2),x=new t.CustomAnimation(o.getCtx(),a,e.getAnimationDuration());x.getAnimator().addProp(t.Animator.TYPE_MATRIX,a,a.getMatrix,a.setMatrix,b),e.add(x,i)}}o.getDeleteContainer().addChild(a);var f=new t.AnimFadeOut(o.getCtx(),a,e.getAnimationDuration());e.add(f,i)},animateInsert:(e,a)=>{var i=c.UPDATE,o=e.getNewNBox(),n=a.getData().__drawerBounds,l=a.getData().id,s=g.getCategoryNode(o,l);if(s){var h=v.getSideLength(s),u=h/n.w,C=h/n.h,_=d(o,s);if(_){var p=r(_),b=new t.Matrix(u,0,0,C,p.getTx()-h/2,p.getTy()-h/2),x=new t.CustomAnimation(o.getCtx(),a,e.getAnimationDuration());x.getAnimator().addProp(t.Animator.TYPE_MATRIX,a,a.getMatrix,a.setMatrix,a.getMatrix());var f=a.getParent();o.addChild(a),t.Playable.appendOnEnd(x,()=>{f.addChild(a)}),a.setMatrix(b),e.add(x,i)}}a.setAlpha(0);var y=new t.AnimFadeIn(o.getCtx(),a,e.getAnimationDuration());e.add(y,i)},_addAccessibilityAttr:(e,a,i)=>{var o=t.Agent.isTouchDevice()?d(e,a,"background"):i;if(o.setAriaRole("img"),!t.Agent.deferAriaCreation()){var r=i.getAriaLabel();r&&o.setAriaProperty("label",r)}}};class f extends t.Container{constructor(e,t){super(e.getCtx(),null,t.id+"_d"),this._nbox=e,this._data=t,this._data.__cacheId="drawer:"+this.getId(),this._nbox.registerObject(this),this.nboxType="drawer"}getData(){return this._data}render(e,t){e.addChild(this),s(this._nbox,this._data,this),x.render(this._nbox,this._data,this,t),this._nbox.EventManager.associate(this,this)}getChildContainer(){return this._childContainer}setChildContainer(e){this._childContainer=e}isDoubleClickable(){return!0}handleDoubleClick(){this.closeDrawer()}closeDrawer(){g.fireOptionChangeEvent(this._nbox,"_drawer",null),this._nbox.processEvent(t.EventFactory.newRenderEvent())}animateUpdate(){x.animateUpdate()}animateDelete(e){x.animateDelete(e,this)}animateInsert(e){x.animateInsert(e,this)}HandleKeyboardEvent(e){e.keyCode==t.KeyboardEvent.ESCAPE&&this.closeDrawer()}UpdateAccessibilityAttr(){if(!t.Agent.deferAriaCreation()){var e=this.getAriaLabel();if(e)(t.Agent.isTouchDevice()?d(this._nbox,this.getData(),"background"):this).setAriaProperty("label",e)}}getAriaLabel(){var e=d(this._nbox,g.getCategoryNode(this._nbox,this.getData().id)),t=g.isDrawerSelected(this._nbox,e);return g.buildAriaDesc(this._nbox,this,e.getShortDesc(),t)}getKeyboardBoundingBox(){return i(this)}getTargetElem(){return this.getElem()}showKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!0,d(this._nbox,this.getData(),"focusEffect").show()}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,d(this._nbox,this.getData(),"focusEffect").hide()}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}getNextNavigable(e){var a=null;if(this._nbox.EventManager.getKeyboardHandler().isNavigationEvent(e))if(e.keyCode==t.KeyboardEvent.OPEN_BRACKET){var i=this.getChildContainer();i.getScrollingPane&&(i=i.getScrollingPane()),a=g.getFirstNavigableNode(i)}else if(e.keyCode==t.KeyboardEvent.CLOSE_BRACKET){var o=g.getMaximizedCellIndex(this._nbox);a=d(this._nbox,g.getCell(this._nbox,o))}return a}getDisplayable(){return this}getKeyboardFocusDisplayable(){if(this._nbox.getOptions()._drawer)return this;var e=g.getCategoryNode(this._nbox,this.getData().id);return e?d(this._nbox,e):null}}class y extends t.Container{constructor(e,t){super(e.getCtx()),this._nbox=e,this._cell=t,this._button,this.nboxType="overflow"}render(e,a,i){var o=this._nbox.getCtx(),r=this._nbox.getOptions()._resources.overflow,n=r.width,l=r.height,d=t.ToolkitUtils.getIconStyle(o,r.class),h=1;(a<n||i<l)&&(h=Math.min(a/n,i/l)),n*=h,l*=h;Math.max(n,l);var u=new t.Rect(o,0,0,a,i);this._button=new t.IconButton(o,"borderless",{style:d,size:Math.max(n,l),pos:{x:a/2,y:i/2}},u,null,this.HandleClick,this),g.isMaximizeEnabled(this._nbox)||this._button.setEnabled(!1),this.addChild(this._button);var c=new t.KeyboardFocusEffect(this._nbox.getCtx(),this,new t.Rectangle(-1,-1,a+2,i+2));s(this._nbox,this,c,"focusEffect"),e.addChild(this),this._addAccessibilityAttr(),this._nbox.EventManager.associate(this,this)}getParentCell(){return this._cell}getButton(){return this._button}HandleClick(e){t.EventManager.consumeEvent(e),this._cell.handleDoubleClick(!0)}HandleKeyboardEvent(e){e.keyCode==t.KeyboardEvent.ENTER&&this._cell.handleDoubleClick()}_addAccessibilityAttr(){if(this.setAriaRole("button"),!t.Agent.deferAriaCreation()){var e=this.getAriaLabel();e&&this.setAriaProperty("label",e)}}getDatatip(){return this._nbox.getOptions().translations.labelAdditionalData}getAriaLabel(){return this.getDatatip()}getKeyboardBoundingBox(e){return i(this,e)}getTargetElem(){return this.getElem()}showKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!0,d(this._nbox,this,"focusEffect").show()}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,d(this._nbox,this,"focusEffect").hide()}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}getNextNavigable(e){var a=null;return this._nbox.EventManager.getKeyboardHandler().isNavigationEvent(e)&&(a=e.keyCode==t.KeyboardEvent.CLOSE_BRACKET?this.getParentCell():g.getNextNavigableNode(this,e)),a}getDisplayable(){return this}getKeyboardFocusDisplayable(){var e=this.previousNavigable.getData(),t=g.getNode(this._nbox,g.getNodeIndex(this._nbox,e.id));return d(this._nbox,t).nextNavigable}}class m extends t.Automation{GetSubIdForDomElement(e){for(var a=this._getParentObject(e,_),i=this._getParentObject(e,f);e&&"nbox"!==e.nboxType;){var o,r,n=this.getComponent();if("node"===e.nboxType){var l=g.getNodeIndex(n,e.getData().id);return o="node"+this._createBrackets([l]),this._createSubId(o,r)}if(a){var s=a.getData().row,h=a.getData().column,u=a.getChildContainer();if(u.getScrollingPane&&(u=u.getScrollingPane()),o="cell"+this._createBrackets([s,h]),"cell"===e.nboxType)return this._createSubId(o,r);if(e instanceof t.IconButton){if(this._getParentObject(e,y))return r="overflow",this._createSubId(o,r);if(e==d(n,a.getData(),"closeButton"))return r="closeButton",this._createSubId(o,r)}if("categoryNode"===e.nboxType){var c=e.getData().id;return r="groupNode",g.getNode(n,e.getData().nodeIndices[0]).groupCategory?r+=this._createBrackets([c]):r+=this._createBraces(c.split(";")),this._createSubId(o,r)}}if(i){if(o="dialog","drawer"===e.nboxType)return this._createSubId(o,r);if(e instanceof t.IconButton)return r="closeButton",this._createSubId(o,r)}if("categoryNode"===e.nboxType){var C=e.getData().id;return o="groupNode",g.getNode(n,e.getData().nodeIndices[0]).groupCategory?o+=this._createBrackets([C]):o+=this._createBraces(C.split(";")),this._createSubId(o,r)}e=e.getParent()}return null}_createSubId(e,t){var a=e;return t&&(a+="#"+t),a}getDomElementForSubId(e){var a=this.getComponent();if(e==t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(a);var i,o=this._parseSubId(e),r=o.component,n=o.action,l=null,s=null,h=null;if(0===r.lastIndexOf("node",0)&&(l=this._parseBrackets(r,!0),i=g.getNode(a,l[0]),h=d(a,i)),0===r.lastIndexOf("cell",0)){l=this._parseBrackets(r);var u=this._getCellIndexFromValues(l);if(!(i=g.getCell(a,u)))return null;var c=d(a,i);if(n){if((s=c.getChildContainer()).getScrollingPane&&(s=s.getScrollingPane()),"overflow"==n)for(var C=s.getNumChildren();C>0;C--)if("overflow"===s.getChildAt(C-1).nboxType){h=s.getChildAt(C-1).getButton();break}if("closeButton"==n&&(h=d(a,c.getData(),"closeButton")),0===n.lastIndexOf("node",0)){var _=(l=this._parseBrackets(n,!0))[0];if(_<0)return null;for(var p=g.getFirstNavigableNode(s),b=0;"node"===p.nboxType;){if(b==_){h=p;break}p=p.nextNavigable,b++}}if(0===n.lastIndexOf("groupNode",0)){var v,x,f;n.indexOf("{")>-1?l=this._parseBraces(n):v=n.substring(n.indexOf("[")+1,n.indexOf("]"));for(var y=0;y<s.getNumChildren();y++)if("categoryNode"===(x=s.getChildAt(y)).nboxType&&(f=x.getData().id,l&&this._compareCategories(l,f.split(";"))||v&&v==f)){h=x;break}}}else h=c}else if(0===r.lastIndexOf("groupNode",0)){var m,S,w;s=a.getChildContainer(),r.indexOf("{")>-1?l=this._parseBraces(r):m=r.substring(r.indexOf("[")+1,r.indexOf("]"));for(var N=0;N<s.getNumChildren();N++)if("categoryNode"===(S=s.getChildAt(N)).nboxType&&(w=S.getData().id,l&&this._compareCategories(l,w.split(";"))||m&&m==w)){h=S;break}}else if("dialog"===r&&(s=a.getChildContainer()))for(var A=0;A<s.getNumChildren();A++)if("drawer"===s.getChildAt(A).nboxType){var D=s.getChildAt(A);if(n){if("closeButton"==n)for(var I=0;I<D.getNumChildren();I++)D.getChildAt(I)instanceof t.IconButton&&(h=D.getChildAt(I));if(0===n.lastIndexOf("node",0)){var T=D.getChildContainer().getScrollingPane(),E=(l=this._parseBrackets(n,!0))[0];if(E<0)return null;for(var O=g.getFirstNavigableNode(T),M=0;"node"===O.nboxType;){if(M==E){h=O;break}O=O.nextNavigable,M++}}}else h=D;break}return h?h.getElem():null}_parseSubId(e){var t=null,a=null,i=e.indexOf("#");return-1!==i?(t=e.substring(0,i),a=e.substring(i+1)):t=e,{component:t,action:a}}getComponent(){return this._comp}_parseBrackets(e,t){var a=e.substring(e.indexOf("[")+1,e.indexOf("]")).split(",");if(t)for(var i=0;i<a.length;i++)a[i]=parseInt(a[i]);return a.length>0?a:null}_createBrackets(e){return e.length>0?"["+e.join(",")+"]":""}_parseBraces(e){return e.substring(e.indexOf("{")+1,e.lastIndexOf("}")).split(",")}_createBraces(e){for(var t="{",a=0;a<e.length;a++)t+=e[a].trim()+",";return t.substring(0,t.length-1)+"}"}_compareCategories(e,t){if(e.length!=t.length)return!1;e.sort(),t.sort();for(var a=0;a<e.length;a++)if(e[a].trim()!=t[a].trim())return!1;return!0}_getCellIndexFromValues(e){var t=this.getComponent();if(g.hasValidData(t)){var a=g.getColCount(t),i=g.getRowIndex(t,e[0]),o=g.getColIdx(t,e[1]);if(null!=o&&null!=i)return o+a*i}return null}_getParentObject(e,t){for(var a=e;a;){if(a instanceof t)return a;a=a.getParent()}return null}getData(e,t){if(this._comp&&g.hasValidData(this._comp))if("rowsTitle"==e){if(this._comp.getOptions().rowsTitle)return this._comp.getOptions().rowsTitle}else if("rowCount"==e){var a=this._comp.getOptions().rows;if(a)return a.length}else if("row"==e){if(g.getRowIndex(this._comp,t)>=0){var i={};return i.label=g.getRowLabel(this._comp,t),i}}else if("columnsTitle"==e){if(this._comp.getOptions().columnsTitle)return this._comp.getOptions().columnsTitle}else if("columnCount"==e){var o=this._comp.getOptions().columns;if(o)return o.length}else if("column"==e){if(g.getColIdx(this._comp,t)>=0){var r={};return r.label=g.getColLabel(this._comp,t),r}}else if("groupBehavior"==e)return g.getGroupBehavior(this._comp);return null}getGroupNode(e){if(e&&g.getGrouping(this._comp)&&"acrossCells"==g.getGroupBehavior(this._comp)){if("string"==typeof e)return this._getGroupNodeData(e);var t="";for(var a in e)e[a]?t+=a+":"+e[a]+";":t+=a+";";return this._getGroupNodeData(t.substring(0,t.length-1))}return null}_getGroupNodeData(e){var t=g.getCategoryNode(this._comp,e);if(t){var a=d(this._comp,t);if(a)return{selected:a.isSelected(),color:u.getCategoryNodeColor(this._comp,t),indicatorColor:u.getCategoryNodeIndicatorColor(this._comp,t),tooltip:a.getShortDesc(),size:t.nodeIndices?t.nodeIndices.length:-1,indicatorIcon:this._getMarkerData(d(this._comp,t,"indicatorIcon"))}}return null}getCell(e,t){if(this._comp&&g.hasValidData(this._comp)){var a=g.getCellByRowCol(this._comp,e,t);if(a)return{label:a.getLabel(),background:a.getBackground(),getNodeCount:()=>a.getNodeCount(),rowValue:e,columnValue:t,cellIndex:a.getCellIndex()}}return null}getCellNode(e,t){if(this._comp&&g.hasValidData(this._comp)&&!g.getGrouping(this._comp)){var a=g.getCellByRowCol(this._comp,e.rowValue,e.columnValue).getNode(t);return this._getNode(a)}return null}getNode(e){var t=g.getNode(this._comp,e);return this._getNode(t)}_getNode(e){if(e){var t=d(this._comp,e);if(t){var a={selected:t.isSelected(),tooltip:t.getShortDesc(),color:u.getNodeColor(this._comp,e),indicatorColor:u.getNodeIndicatorColor(this._comp,e)};e.label&&(a.label=e.label),e.secondaryLabel&&(a.secondaryLabel=e.secondaryLabel);var i=d(this._comp,e,"icon");a.icon=this._getMarkerData(i);var o=d(this._comp,e,"indicatorIcon");return a.indicatorIcon=this._getMarkerData(o),a}}return null}getCellGroupNode(e,t){if(t&&g.getGrouping(this._comp)&&"withinCell"==g.getGroupBehavior(this._comp)){if("string"==typeof t)return this._getGroupNodeData(e.cellIndex+":"+t);var a=e.cellIndex+":";for(var i in t)t[i]?a+=i+":"+t[i]+";":a+=i+";";return this._getGroupNodeData(a.substring(0,a.length-1))}return null}_getMarkerData(e){if(e){var a={};return a.shape=e instanceof t.SimpleMarker?e.getType():"none",e.getFill()&&(a.color=e.getFill().getColor()),a}return null}getDialog(){var e=g.getDrawer(this._comp);if(e){var t=g.getCategoryNode(this._comp,e.id);if(t){var a=d(this._comp,t),i={};i.label=a.getLabel(),i.getNodeCount=()=>t.nodeIndices?t.nodeIndices.length:-1;for(var o={},r=t.id.split(";"),n=0;n<r.length;n++){var l=r[n].split(":");l&&2==l.length&&(o[l[0]]=l[1])}return i.groupInfo=o,i}}return null}getDialogNode(e){var t=g.getDrawer(this._comp);if(t){var a=g.getCategoryNode(this._comp,t.id);if(a&&a.nodeIndices&&null!=a.nodeIndices[e]){var i=g.getNode(this._comp,a.nodeIndices[e]);return this._getNode(i)}}return null}getNodeIdFromIndex(e){return g.getNode(this._comp,e).id}getNodeIndexFromId(e){return g.getNodeIndex(this._comp,e)}}class S extends t.BaseComponentDefaults{constructor(e){super({alta:{skin:t.CSSStyle.SKIN_ALTA,selectionMode:"multiple",animationOnDataChange:"none",animationOnDisplay:"none",cellMaximize:"on",cellContent:"auto",groupBehavior:"withinCell",otherColor:"#636363",otherThreshold:0,hoverBehavior:"none",highlightMatch:"all",highlightedCategories:[],touchResponse:"auto",_statusMessageStyle:new t.CSSStyle,styleDefaults:{animationDuration:500,hoverBehaviorDelay:200,columnLabelStyle:new t.CSSStyle,rowLabelStyle:new t.CSSStyle,columnsTitleStyle:new t.CSSStyle,rowsTitleStyle:new t.CSSStyle,cellDefaults:{_style:new t.CSSStyle,_borderRadius:0,_maximizedStyle:new t.CSSStyle,_minimizedStyle:new t.CSSStyle,labelStyle:new t.CSSStyle,_labelMinimizedStyle:new t.CSSStyle,_labelMaximizedStyle:new t.CSSStyle,countLabelStyle:new t.CSSStyle,bodyCountLabelStyle:new t.CSSStyle,dropTargetStyle:new t.CSSStyle("background-color:rgba(217, 244, 250, .75);border-color:#ccf6ff"),showCount:"auto",showMaximize:"on",_panelShadow:"none"},__scrollbar:{scrollbarBackground:"linear-gradient(bottom, #dce2e7 0%, #f8f8f8 8%)",scrollbarBorderColor:"#dce2e7",scrollbarHandleColor:"#abb0b4",scrollbarHandleHoverColor:"#333333",scrollbarHandleActiveColor:"#333333"},_drawerDefaults:{background:"#e9e9e9",borderColor:"#bcc7d2",borderRadius:1,headerBackground:"linear-gradient(to bottom, #f5f5f5 0%, #f0f0f0 100%)",labelStyle:new t.CSSStyle,countLabelStyle:new t.CSSStyle,countBorderRadius:1},nodeDefaults:{color:"#FFFFFF",labelStyle:new t.CSSStyle,secondaryLabelStyle:new t.CSSStyle,alphaFade:.2,_borderRadius:1,hoverColor:"#FFFFFF",selectionColor:"#000000",iconDefaults:{preferredSize:19,preferredSizeTouch:34,shapePaddingRatio:.15,sourcePaddingRatio:0,opacity:1,pattern:"none",borderColor:"#000000",borderWidth:0,borderRadius:0,shape:t.SimpleMarker.CIRCLE,background:"neutral",backgroundSize:196},indicatorIconDefaults:{width:10,height:10,opacity:1,pattern:"none",borderColor:"#000000",borderWidth:0,borderRadius:0,shape:t.SimpleMarker.CIRCLE}},_categoryNodeDefaults:{labelStyle:new t.CSSStyle}},__layout:{componentGap:8,titleGap:4,titleComponentGap:4,nodeLabelOnlyStartLabelGap:5,nodeStartLabelGap:3,nodeEndLabelGap:5,nodeSingleLabelGap:2,nodeDualLabelGap:2,nodeInterLabelGap:0,nodeIndicatorGap:3,nodeSwatchSize:10,categoryNodeLabelGap:5,minimumCellSize:34,cellGap:3,gridGap:6,cellInnerPadding:6,cellLabelGap:6,cellCloseGap:6,countLabelGap:10,markerGap:3,minimumLabelWidth:55,maximumLabelWidth:148,drawerButtonGap:6,drawerCountHorizontalGap:5,drawerCountVerticalGap:3,drawerStartGap:6,drawerLabelGap:6,drawerHeaderHeight:31}}},e)}getNoCloneObject(){return{data:!0}}}class w extends t.CategoryRolloverHandler{GetRolloverCallback(e){return function(){this.SetHighlightMode(!0),this._callbackObj.processEvent(e),this._callback&&this._callback.call(this._callbackObj,e,this._source)}.bind(this)}GetRolloutCallback(e){return function(){this.SetHighlightModeTimeout(),this._callbackObj.processEvent(e),this._callback&&this._callback.call(this._callbackObj,e,this._source)}.bind(this)}}class N extends t.EventManager{constructor(e){super(e.getCtx(),e.processEvent,e,e),this._nbox=e}OnClickInternal(e){var t=this.GetLogicalObject(e.target);t&&"categoryNode"===t.nboxType&&!t.isSelectable()&&t.openDrawer()}OnDblClickInternal(e){this._handleDblClick(e.target)}HandleTouchDblClickInternal(e){this._handleDblClick(e.target)}HandleTouchClickInternal(e){var t=this.GetLogicalObject(e.target);t&&"categoryNode"===t.nboxType&&!t.isSelectable()&&t.openDrawer()}_handleDblClick(e){var t=this.GetLogicalObject(e);t&&t.isDoubleClickable&&t.isDoubleClickable()&&t.handleDoubleClick&&t.handleDoubleClick()}ProcessKeyboardEvent(e){var a=!1,i=e.keyCode,o=this.getFocus();return i==t.KeyboardEvent.ENTER||i==t.KeyboardEvent.ESCAPE?o&&o.HandleKeyboardEvent&&o.HandleKeyboardEvent(e):e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey&&"categoryNode"!==o.nboxType&&"node"!==o.nboxType||(a=super.ProcessKeyboardEvent(e)),a}ProcessRolloverEvent(e,a,i){var o=this._nbox.getOptions();if("dim"==o.hoverBehavior){var r=a.getCategories?a.getCategories():[];o.highlightedCategories=i?r.slice():null;var n=t.EventFactory.newCategoryHighlightEvent(o.highlightedCategories,i),l=t.CSSStyle.getTimeMilliseconds(o.styleDefaults.hoverBehaviorDelay);this.RolloverHandler.processEvent(n,this._nbox.getNodeDisplayables(),l,"any"==o.highlightMatch)}}CreateCategoryRolloverHandler(e,t){return new w(e,t)}GetTouchResponse(){var e=this._nbox.getOptions(),a=g.getDrawer(this._nbox),i=g.getCell(this._nbox,g.getMaximizedCellIndex(this._nbox));return a&&d(this._nbox,a).getChildContainer().hasScrollingContent()||i&&d(this._nbox,i).getChildContainer().hasScrollingContent()?t.EventManager.TOUCH_RESPONSE_TOUCH_HOLD:e.touchResponse===t.EventManager.TOUCH_RESPONSE_TOUCH_START?t.EventManager.TOUCH_RESPONSE_TOUCH_START:t.EventManager.TOUCH_RESPONSE_AUTO}}class A extends t.Container{constructor(e,a){super(e.getCtx(),null,isNaN(a.cell)?a.id:a.cell+":"+a.id),this.nboxType="categoryNode",this._nbox=e,this._data=a,this._data.__cacheId="categoryNode:"+this.getId(),this._nbox.registerObject(this),this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this._maxAlpha=1}getData(){return this._data}render(e,t,a){v.render(this._nbox,this._data,this,t,a),e.addChild(this),s(this._nbox,this._data,this),this._nbox.EventManager.associate(this,this)}isSelectable(){return"multiple"==this._nbox.getOptions().selectionMode}isSelected(){return this.getSelectionShape().isSelected()}setSelected(e){this.getSelectionShape().setSelected(e),this.UpdateAccessibilityAttr()}showHoverEffect(){this.getSelectionShape().showHoverEffect()}hideHoverEffect(){this.getSelectionShape().hideHoverEffect()}setSelectionShape(e){this._selectionShape=e}getSelectionShape(){return this._selectionShape}getLabel(){var e=a.getTranslatedString("oj-converter.plural-separator");return g.getCategoryNodeLabels(this._nbox,this._data).join(e)}getDatatip(){var e=this._nbox.getOptions().tooltip,a=e?e.renderer:null;if(a){var i={id:this._data.id,color:u.getCategoryNodeColor(this._nbox,this._data),indicatorColor:u.getCategoryNodeIndicatorColor(this._nbox,this._data),size:this._data.nodeIndices.length};return"withinCell"==g.getGroupBehavior(this._nbox)&&(i.row=g.getCell(this._nbox,this._data.cell).row,i.column=g.getCell(this._nbox,this._data.cell).column),this._nbox.getCtx().getTooltipManager().getCustomTooltip(a,i)}var o=this._nbox.getOptions().translations;return this.getShortDesc()+"\n"+t.ResourceUtils.format(o.labelAndValue,[o.labelSize,this._data.nodeIndices.length])}getShortDesc(){return g.getCategoryNodeLabels(this._nbox,this._data).join("\n")}getDatatipColor(){return u.getCategoryNodeColor(this._nbox,this._data)}setMaxAlpha(e){this._maxAlpha=e,this.setAlpha(this.getAlpha())}getMaxAlpha(){return this._maxAlpha}setAlpha(e){super.setAlpha(Math.min(e,this._maxAlpha))}isDoubleClickable(){return this.isSelectable()}handleDoubleClick(){this.isSelectable()&&this.openDrawer()}openDrawer(){g.fireOptionChangeEvent(this._nbox,"_drawer",{id:this.getId()}),this._nbox.processEvent(t.EventFactory.newRenderEvent())}animateUpdate(e,t){v.animateUpdate(e,t,this)}animateDelete(e){v.animateDelete(e,this)}animateInsert(e){v.animateInsert(e,this)}isDragAvailable(e){return this._nbox.__isDragAvailable(e)}getDragTransferable(){return this._nbox.__getDragTransferable(this)}getDragFeedback(){return this._nbox.__getDragFeedback()}HandleKeyboardEvent(e){if(e.keyCode==t.KeyboardEvent.ENTER)this.openDrawer();else if(e.keyCode==t.KeyboardEvent.ESCAPE&&"withinCell"==g.getGroupBehavior(this._nbox)){var a=g.getCell(this._nbox,this._data.cell);d(this._nbox,a).HandleKeyboardEvent(e)}}UpdateAccessibilityAttr(){if(!t.Agent.deferAriaCreation()){var e=this.getAriaLabel();e&&this.setAriaProperty("label",e)}}getAriaLabel(){return g.buildAriaDesc(this._nbox,this,this.getShortDesc(),this.isSelected())}getCategories(){var e=this.getData().categories;if(!e){var t=(e,t)=>e.filter(e=>t.indexOf(e)>-1),a=this.getData().nodeIndices;e=null;for(var i=0;i<a.length;i++){var o=g.getNode(this._nbox,a[i]).categories;if(!o){e=[];break}e=null==e?o:t(e,o)}this.getData().categories=e}return e}getKeyboardBoundingBox(){return i(this)}getTargetElem(){return this.getElem()}showKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!0,this.showHoverEffect()}hideKeyboardFocusEffect(){this._isShowingKeyboardFocusEffect=!1,this.hideHoverEffect()}isShowingKeyboardFocusEffect(){return this._isShowingKeyboardFocusEffect}getNextNavigable(e){var a=null;if(e.keyCode==t.KeyboardEvent.SPACE&&e.ctrlKey)return this;if(e.keyCode==t.KeyboardEvent.CLOSE_BRACKET&&"withinCell"==g.getGroupBehavior(this._nbox)){var i=g.getCell(this._nbox,this.getData().cell);a=d(this._nbox,i)}else if(e.keyCode==t.KeyboardEvent.CLOSE_BRACKET||e.keyCode==t.KeyboardEvent.OPEN_BRACKET)a=this;else if(this._nbox.EventManager.getKeyboardHandler().isNavigationEvent(e))if("acrossCells"==g.getGroupBehavior(this._nbox)){var o=this._nbox.getOptions().__groups,r=[];for(var n in o){var l=d(this._nbox,o[n]);l&&r.push(l)}a=h.getNextNavigableCategoryNode(this,e,r)}else{for(var s=this.getParent(),u=[],c=0;c<s.getNumChildren();c++)"categoryNode"===s.getChildAt(c).nboxType&&u.push(s.getChildAt(c));a=h.getNextNavigableCategoryNode(this,e,u)}else e.type==t.MouseEvent.CLICK&&(a=this);return a}getDisplayable(){return this}getKeyboardFocusDisplayable(){var e=g.getDrawer(this._nbox);if(e)return d(this._nbox,e);if(g.getGrouping(this._nbox)){var t=g.getCategoryNode(this._nbox,this.getId());if(t)return d(this._nbox,t)}return null}}const D={create:(e,t)=>({x:e,y:t}),add:(e,t)=>D.create(e.x+t.x,e.y+t.y),subtract:(e,t)=>D.create(e.x-t.x,e.y-t.y),scale:(e,t)=>D.create(e.x*t,e.y*t),getMagnitude:e=>Math.sqrt(e.x*e.x+e.y*e.y)},I={render:(e,t,a)=>{I._renderBackground(e,t,a),g.hasValidData(e)?(I._adjustAvailSpace(a),I._renderTitles(e,t,a),I._adjustAvailSpace(a),I._renderCells(e,t,a),I._renderNodes(e,t,a),I._renderInitialSelection(e)):I._renderEmptyText(e,t,a)},_renderBackground:(e,a,i)=>{var o=new t.Rect(e.getCtx(),i.x,i.y,i.w,i.h);o.setInvisibleFill(),a.addChild(o);var r=new t.ClipPath;r.addRect(i.x,i.y,i.w,i.h),a.setClipPath(r)},_renderTitles:(e,a,i)=>{var r=e.getOptions(),l=g.getColCount(e),d=g.getRowCount(e),h=r.__layout.componentGap,c=r.__layout.titleGap,_=r.__layout.titleComponentGap,p=t.Agent.isRightToLeft(e.getCtx());i.x+=h,i.y+=h,i.w-=2*h,i.h-=2*h;var b=g.getMaximizedCol(e),v=b?g.getColIdx(e,b):-1,x=g.getMaximizedRow(e),f=x?g.getRowIndex(e,x):-1,y=null,m=null,S=[],w=[],N=0,A=0,D=0,I=0,T=0,E=0,O=0,M=0;r.columnsTitle&&(y=o(e.getCtx(),r.columnsTitle,r.styleDefaults.columnsTitleStyle,t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE),a.addChild(y),N=y.getDimensions().h),r.rowsTitle&&(m=o(e.getCtx(),r.rowsTitle,r.styleDefaults.rowsTitleStyle,t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE),a.addChild(m),A=m.getDimensions().h);for(var R=0;R<l;R++){var L=g.getCol(e,R);if(L.label){var P=o(e.getCtx(),L.label,u.getColLabelStyle(e,R),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE);T=Math.max(T,P.getDimensions().h),b&&b!=L.id||(S[R]=P,a.addChild(S[R]))}}for(var H=0;H<d;H++){var B=g.getRow(e,H);if(B.label){var F=o(e.getCtx(),B.label,u.getRowLabelStyle(e,H),t.OutputText.H_ALIGN_CENTER,t.OutputText.V_ALIGN_MIDDLE);E=Math.max(E,F.getDimensions().h),x&&x!=B.id||(w[H]=F,a.addChild(w[H]))}}(A||E)&&(O=_,A&&E&&(D=c)),(N||T)&&(M=_,N&&T&&(I=c));var G=A+D+E+O,k=N+I+T+M;i.x+=p?0:G,i.w-=G,i.h-=k,y&&t.TextUtils.fitText(y,i.w,N,a)&&(n(y,i.x+i.w/2,i.y+i.h+k-N/2),s(e,e.getOptions(),y,"columnsTitle")),m&&t.TextUtils.fitText(m,i.h,A,a)&&(n(m,i.x+(p?i.w:0)+(p?1:-1)*(G-A/2),i.y+i.h/2,p?Math.PI/2:-Math.PI/2),s(e,e.getOptions(),m,"rowsTitle"));for(var z=0;z<l;z++)if(S[z]){var U=C.getCellDims(e,-1==f?0:f,z,i);t.TextUtils.fitText(S[z],U.w,T,a)&&(n(S[z],U.x+U.w/2,i.y+i.h+M+T/2),s(e,g.getCol(e,z),S[z],"label"))}for(var W=0;W<d;W++)if(w[W]){var K=C.getCellDims(e,W,-1==v?0:v,i);t.TextUtils.fitText(w[W],K.h,E,a)&&(n(w[W],i.x+(p?i.w:0)+(p?1:-1)*(O+E/2),K.y+K.h/2,p?Math.PI/2:-Math.PI/2),s(e,g.getRow(e,W),w[W],"label"))}},_renderCells:(e,t,a)=>{for(var i=g.getRowCount(e),o=g.getColCount(e),r=0;r<i;r++)for(var n=0;n<o;n++){var l=g.getCell(e,r*o+n);new _(e,l).render(t,a)}},calculateNodeOrders:e=>{var t=["normal"],a=g.getHighlightedItems(e),i={};if(a)for(var o=0;o<a.length;o++)i[a[o].id]=!0;var r=g.getSelectedItems(e),n={};if(r)for(var l=0;l<r.length;l++)n[r[l]]=!0;a?t=r?["highlighted-selected","highlighted-unselected","unhighlighted-selected","unhighlighted-unselected"]:["highlighted-unselected","unhighlighted-unselected"]:r&&(t=["unhighlighted-selected","unhighlighted-unselected"]);for(var s={},d=g.getNodeCount(e),h=0;h<t.length;h++)for(var u=0;u<d;u++){var c=g.getNode(e,u);if(!g.isNodeHidden(e,c)&&("normal"==t[h]||"highlighted-selected"==t[h]&&i[c.id]&&n[c.id]||"highlighted-unselected"==t[h]&&i[c.id]&&!n[c.id]||"unhighlighted-selected"==t[h]&&!i[c.id]&&n[c.id]||"unhighlighted-unselected"==t[h]&&!i[c.id]&&!n[c.id])){var C=g.getCellIndex(e,c);g.isCellMinimized(e,C)||(s[C]||(s[C]=[]),s[C].push(c))}}return s},_renderNodes:(e,t,a)=>{if(g.getNodeCount(e)>0){if("counts"==g.getCellContent(e)){for(var i=g.getRowCount(e),o=g.getColCount(e),r=[],n=0;n<i;n++)for(var l=0;l<o;l++)r.push(n*o+l);return void C.renderBodyCountLabels(e,r)}g.getGrouping(e)?(I._renderCategoryNodes(e,t,a),I._renderDrawer(e,t,a)):I._renderIndividualNodes(e),e.setNodeClipPath(null),e.setNodeIconClipPath(null)}},_renderIndividualNodes:e=>{var a=e.getOptions(),i=parseInt(a.__layout.gridGap),o=t.Agent.isRightToLeft(e.getCtx()),r=u.getFadedNodeAlpha(e),n=g.getHighlightedItems(e),l={};if(n)for(var h=0;h<n.length;h++)l[n[h].id]=!0;for(var c=I.calculateNodeOrders(e),_=p.calculateNodeLayout(e,c),v=_.indicatorSectionWidth+_.iconSectionWidth+_.labelSectionWidth+i,x=_.nodeHeight+i,f=g.getRowCount(e),m=g.getColCount(e),S=0;S<f;S++)for(var w=0;w<m;w++){var N=S*m+w,A=c[N];if(A&&A.length){var D=g.getCell(e,N),T=_.cellLayouts[N],E=T.cellRows,O=T.cellColumns;if(!(0==E||0==O||1==E&&1==O&&T.overflow))for(var M=E*O-(T.overflow?1:0),R=0;R<A.length;R++){var L=A[R];if(M<0||R<M){var P=d(e,D).getChildContainer(),H=P instanceof t.SimpleScrollableContainer,B=new b(e,L),F=D.__childArea.x+(D.__childArea.w-T.cellColumns*v+i)/2,G=H?i:D.__childArea.y,k=R%O;o&&(k=O-k-1);var z=Math.floor(R/O);B.setTranslate(F+v*k,G+x*z),B.render(H?P.getScrollingPane():P,_),n&&!l[L.id]&&B.setAlpha(r);var U=R>0?A[R-1]:null;if(U){var W=d(e,U);B.previousNavigable=W,W.nextNavigable=B}}}}}for(var K=g.getRowCount(e),j=g.getColCount(e),V=[],Y=0;Y<K;Y++)for(var X=0;X<j;X++){var q=Y*j+X;if(!g.isCellMinimized(e,q)){var J=g.getCell(e,q),Q=d(e,J),Z=_.cellLayouts[q];if(Z.overflow){var $=Z.cellRows,ee=Z.cellColumns;if(0==$||0==ee||1==$&&1==ee&&Z.overflow)V.push(q);else{var te=new y(e,Q),ae=g.getLastNavigableNode(Q.getChildContainer());ae&&"node"===ae.nboxType&&(te.previousNavigable=ae,ae.nextNavigable=te),s(e,te,te),s(e,J,te,"overflow");var ie=J.__childArea.x+(J.__childArea.w-Z.cellColumns*v+i)/2,oe=J.__childArea.y,re=Z.cellColumns-1;o&&(re=0);var ne=Z.cellRows-1;te.setTranslate(ie+v*re,oe+x*ne),te.render(Q.getChildContainer(),v-i,x-i)}}}if(g.isCellMaximized(e,q))d(e,g.getCell(e,q)).getChildContainer().prepareContentPane()}V.length>0&&C.renderBodyCountLabels(e,V)},_renderCategoryNodes:(e,a,i)=>{var o,r,n={},l=g.getNodeCount(e),s=g.getGroupBehavior(e),h=t.Agent.isRightToLeft(e.getCtx()),u=g.getHighlightedItems(e),c={};if(u)for(var C=0;C<u.length;C++)c[u[C].id]=!0;for(var _=0;_<l;_++){var p=g.getNode(e,_);if(!g.isNodeHidden(e,p)){var b=n;"withinCell"==s&&((b=n[o=g.getCellIndex(e,p)+""])||(b={},n[o]=b));var v=b[o=g.getNodeGroupId(p)];v||((v={}).id=o,"withinCell"==s&&(v.cell=g.getCellIndex(e,p)),v.nodeIndices=[],v.highlightedCount=0,b[o]=v),v.nodeIndices.push(_),c[g.getNode(e,_).id]&&v.highlightedCount++}}if("withinCell"==s)for(var x in r={},n)r[x]=I._processOtherThreshold(e,n[x]);else r=I._processOtherThreshold(e,n);var f=r;if(e.getOptions().__groups=f,"acrossCells"==s){var y=[];for(var m in f)y.push(m);y.sort((e,t)=>g.compareCategoryNodeSize(f[e],f[t]));for(var S=Math.sqrt(i.w*i.h*.15/l),w=0;w<y.length;w++){for(var N=y[w],D=0,T=0,E=f[N].nodeIndices.length,O=0;O<E;O++){var M=g.getNode(e,f[N].nodeIndices[O]);D+=g.getXPercentage(e,M),T+=g.getYPercentage(e,M)}D/=E,T/=E;var R=new A(e,f[N]);R.setTranslate(i.x+(h?1-D:D)*i.w,i.y+(1-T)*i.h),R.render(a,S,0),R.setMaxAlpha(.8)}}else if("withinCell"==s){for(var L=g.getRowCount(e)*g.getColCount(e),P=[],H=0;H<L;H++)if(f[H]&&!g.isCellMinimized(e,H)){var B=g.getCell(e,H);P[H]=I._forceLayoutGroups(f[H],B.__childArea.w,B.__childArea.h)}for(var F=40,G=0;G<L;G++)f[G]&&!g.isCellMinimized(e,G)&&(F=Math.min(F,P[G].scale));for(var k=0;k<L;k++)if(f[k]&&!g.isCellMinimized(e,k)){var z=P[k].positions,U=P[k].center,W=g.getCell(e,k),K=d(e,W).getChildContainer(),j=K instanceof t.SimpleScrollableContainer;for(var V in z){var Y=new A(e,f[k][V]);Y.setTranslate(W.__childArea.x+W.__childArea.w/2+F*(z[V].x-U.x),(j?0:W.__childArea.y)+W.__childArea.h/2+F*(z[V].y-U.y)),Y.render(j?K.getScrollingPane():K,F,3)}}}},_adjustAvailSpace:e=>{e.x=Math.round(e.x),e.y=Math.round(e.y),e.w=Math.round(e.w),e.h=Math.round(e.h)},_renderInitialSelection:e=>{if(e.isSelectionSupported()){var t={},a=[],i=g.getSelectedItems(e);if(i){for(var o=0;o<i.length;o++)t[i[o]]=!0;var r=e.getObjects();if(g.getGrouping(e))for(var n=0;n<r.length;n++)if("categoryNode"===r[n].nboxType){for(var l=r[n].getData().nodeIndices,s=!0,d=0;d<l.length;d++){var h=g.getNode(e,l[d]);if(!t[h.id]){s=!1;break}}if(s){var u=g.getDrawer(e);if(!u||u.id!==r[o].getId()){for(d=0;d<l.length;d++)t[(h=g.getNode(e,l[d])).id]=!1;a.push(r[n].getId())}}}for(var c in t)t[c]&&a.push(c)}e.getSelectionHandler().processInitialSelections(a,r)}},_forceLayoutGroups:(e,a,i)=>{var o=[];for(var r in e)o.push(r);o.sort((t,a)=>g.compareCategoryNodeSize(e[t],e[a]));for(var n={},l=2*Math.PI/o.length,s=0;s<o.length;s++){var d=s*Math.cos(l*s),h=s*Math.sin(l*s);n[o[s]]=D.create(d,h)}for(var u=1,c=-.25*i/Math.max(a,i),C=-.25*a/Math.max(a,i);u>.005;){for(var _={},p=0;p<o.length;p++){var b=o[p],v=n[b],x=e[b].nodeIndices.length;_[b]=D.create(u*c*v.x,u*C*v.y);for(var f=0;f<o.length;f++)if(p!=f){for(var y,m=o[f],S=n[m],w=e[m].nodeIndices.length,N=D.subtract(v,S),A=D.getMagnitude(N),I=Math.atan2(N.y,N.x);I<0;)I+=Math.PI/2;for(;I>=Math.PI/2;)I-=Math.PI/2;if(A<(y=I<Math.PI/4?.5*(Math.sqrt(x)+Math.sqrt(w))/Math.cos(I):.5*(Math.sqrt(x)+Math.sqrt(w))/Math.sin(I))){var T=w/(x+w)*((y-A)/A);_[b]=D.add(_[b],D.scale(N,(1-u)*T))}}}for(var E=0;E<o.length;E++){var O=o[E];n[O]=D.add(n[O],_[O])}u*=.98}for(var M=Number.MAX_VALUE,R=-Number.MAX_VALUE,L=Number.MAX_VALUE,P=-Number.MAX_VALUE,H=0;H<o.length;H++){var B=o[H],F=Math.sqrt(e[B].nodeIndices.length),G=n[B];M=Math.min(M,G.x-F/2),R=Math.max(R,G.x+F/2),L=Math.min(L,G.y-F/2),P=Math.max(P,G.y+F/2)}var k=a/(R-M),z=i/(P-L),U=(M+R)/2,W=(L+P)/2;return{scale:Math.min(k,z),center:new t.Point(U,W),positions:n}},_processOtherThreshold:(e,t)=>{var a=g.getNodeCount(e),i=g.getOtherThreshold(e)*a;if(i<=1)return t;var o={},r={};if("withinCell"==g.getGroupBehavior(e))for(var n in t){var l=t[n];r.cell=l.cell;break}for(var s in r.id="other",r.nodeIndices=[],r.otherNode=!0,t){var d=t[s];if(d.nodeIndices.length<i)for(var h=0;h<d.nodeIndices.length;h++)r.nodeIndices.push(d.nodeIndices[h]);else o[s]=d}return r.nodeIndices.length>0&&(o.other=r),o},_renderDrawer:(e,t,a)=>{var i=g.getDrawer(e);i&&(g.getCategoryNode(e,i.id)?new f(e,i).render(t,a):(e.getOptions()._drawer=null,g.fireOptionChangeEvent(e,"_drawer",null)))},animateUpdate:(e,t,a)=>{I._animateCells(e,t,a),I._animateNodes(e,t,a);var i=g.getDrawer(t);i=i?i.id:null;var o=g.getDrawer(a);i!=(o=o?o.id:null)&&I._animateDrawer(e,t,a)},_animateCells:(e,t,a)=>{for(var i=g.getRowCount(t),o=g.getRowCount(a),r=g.getColCount(t),n=g.getColCount(a),l=i*r,s=o*n,h=[],u=[],c=0;c<l;c++)h.push(d(t,g.getCell(t,c)));for(var C=0;C<s;C++)u.push(d(a,g.getCell(a,C)));if(i==o&&r==n){for(var _=!0,p=0;p<o;p++){if(g.getRow(t,p).id!=g.getRow(a,p).id){_=!1;break}}if(_)for(var b=0;b<n;b++){if(g.getCol(t,b).id!=g.getCol(a,b).id){_=!1;break}}if(_)return void e.constructAnimation(h,u)}e.constructAnimation(h,[]),e.constructAnimation([],u)},_animateNodes:(e,t,a)=>{for(var i=g.getNodeCount(t),o=g.getNodeCount(a),r=[],n=[],l=0;l<i;l++)r.push(d(t,g.getNode(t,l)));for(var s=0;s<o;s++)n.push(d(a,g.getNode(a,s)));e.constructAnimation(r,n);var h=g.getDrawer(t);if(!g.getDrawer(a)){var u=I._getSortedGroups(t),c=I._getSortedGroups(a);h&&(g.getMaximizedCellIndex(t)!=g.getMaximizedCellIndex(a)?(u=u.filter(e=>e.getData().cell!=g.getMaximizedCellIndex(t)),c=c.filter(e=>e.getData().cell!=g.getMaximizedCellIndex(t))):(u=null,c=null)),e.constructAnimation(u,c)}},_getSortedGroups:e=>{var t=g.getGroupBehavior(e),a=e.getOptions().__groups,i=[];if(a)if("withinCell"==t)for(var o=g.getRowCount(e)*g.getColCount(e),r=0;r<o;r++)for(var n=a[r+""],l=I._getSortedGroupsFromContainer(e,n),s=0;s<l.length;s++)i.push(l[s]);else i=I._getSortedGroupsFromContainer(e,a);return i},_getSortedGroupsFromContainer:(e,t)=>{var a=[];for(var i in t){var o=d(e,t[i]);o&&a.push(o)}return a.sort((e,t)=>{var a=e.getId(),i=t.getId();return a==i?0:a<i?-1:1}),a},_animateDrawer:(e,t,a)=>{var i=g.getDrawer(t);i=i?[d(t,i)]:null;var o=g.getDrawer(a);o=o?[d(a,o)]:[],e.constructAnimation(i,o)},getNodeOrderFunction:e=>{var a=[],i=g.getDrawer(e);if(i)for(var o=d(e,i).getChildContainer().getScrollingPane(),r=0;r<o.getNumChildren();r++)a.push(o.getChildAt(r));else for(var n=g.getRowCount(e)*g.getColCount(e),l=0;l<n;l++){var s=[],h=g.getCell(e,l),u=d(e,h).getChildContainer();u instanceof t.SimpleScrollableContainer&&(u=u.getScrollingPane());for(var c=0;c<u.getNumChildren();c++)s.push(u.getChildAt(c));a.push(s)}return()=>{if(a.length)if(a[0]&&isNaN(a[0].length)){var i=g.getDrawer(e);if(i)for(var o=d(e,i).getChildContainer().getScrollingPane(),r=0;r<a.length;r++)o.addChild(a[r])}else for(var n=0;n<a.length;n++){var l=a[n],s=g.getCell(e,n);if(l.length&&s){var h=d(e,s).getChildContainer();h instanceof t.SimpleScrollableContainer&&(h=h.getScrollingPane());for(var u=0;u<l.length;u++)h.addChild(l[u])}}}},_renderEmptyText:(e,a,i)=>{var o=e.getOptions(),r=o.translations.labelInvalidData;e.renderEmptyText(a,r,new t.Rectangle(i.x,i.y,i.w,i.h),e.getEventManager(),o._statusMessageStyle)}};class T extends t.BaseComponent{constructor(e,t,a){super(e,t,a),this.Defaults=new S(e),this.EventManager=new N(this),this.EventManager.addListeners(this),this.EventManager.setKeyboardHandler(this.CreateKeyboardHandler(this.EventManager)),this.setId("nbox1000"+Math.floor(1e9*Math.random())),this._peers=[],this._animationAllowed=!0}SetOptions(e){super.SetOptions(e),e||(e=this.getSanitizedOptions()),e?(this.Options=this.Defaults.calcOptions(e),g.processDataObj(this),t.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none")):this.Options||(this.Options=this.GetDefaults()),this._displayables=[],this.Options.__displayableCache=new t.BaseComponentCache;var a=this.Options.selectionMode;this._selectionHandler="single"==a?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_SINGLE):"multiple"==a?new t.SelectionHandler(this.getCtx(),t.SelectionHandler.TYPE_MULTIPLE):null,this.EventManager.setSelectionHandler(this._selectionHandler)}render(e,a,i){var o=u.getAnimOnDataChange(this),r=null;this.Options&&"none"!==o&&((r={options:this.Options,getOptions:function(){return this.options},displayables:this._displayables,getDisplayables:function(){return this.displayables},id:this.getId(),getId:function(){return this.id}}).getOptions=r.getOptions,r.getDisplayables=r.getDisplayables,r.getId=r.getId),this.__cleanUp(),this.StopAnimation(),this.SetOptions(e),!g.getGrouping(this)&&this.getOptions()._drawer&&(this.getOptions()._drawer=null),isNaN(a)||isNaN(i)||(this.Width=a,this.Height=i);var n=new t.Container(this.getCtx());if(this.addChild(n),I.render(this,n,new t.Rectangle(0,0,this.Width,this.Height)),e&&g.getDrawer(this)&&g.getGrouping(this)){var l=d(this,g.getDrawer(this));this.EventManager.setFocus(l),this.EventManager.setFocused(!1)}this._updateKeyboardFocusEffect();var s=u.getAnimOnDisplay(this),h=u.getAnimDuration(this),C=new t.Rectangle(0,0,this.Width,this.Height),_=!1;if(this._container){if("none"!=o&&e)if(this.Animation=t.BlackBoxAnimationHandler.getCombinedAnimation(this.getCtx(),o,this._container,n,C,h),this.Animation)_=!0;else{this._deleteContainer=new t.Container(this.getCtx(),"g","DeleteContainer"),this.addChild(this._deleteContainer);var p=new c(this.getCtx(),this._deleteContainer,r,this),b=I.getNodeOrderFunction(this);p.constructAnimation([r],[this]),this.Animation=p.getAnimation(),t.Playable.appendOnEnd(this.Animation,b,this)}}else"none"!==s&&(this.Animation=t.BlackBoxAnimationHandler.getInAnimation(this.getCtx(),s,n,C,h));this.Animation?(this.setMouseEnabled(!1),t.Playable.appendOnEnd(this.Animation,this._getOnAnimationEndFunction(e),this),this.Animation.play()):this._getOnAnimationEndFunction(e)(),_?this._oldContainer=this._container:this._container&&(this.removeChild(this._container),this._container.destroy()),this._container=n,this.UpdateAriaAttributes()}__cleanUp(){this.EventManager.hideTooltip(),this._peers.length=0}_getOnAnimationEndFunction(e){return()=>{this._oldContainer&&(this.removeChild(this._oldContainer),this._oldContainer.destroy(),this._oldContainer=null),this._deleteContainer&&(this.removeChild(this._deleteContainer),this._deleteContainer.destroy()),this._deleteContainer=null,this.setMouseEnabled(!0),this.AnimationStopped||(this.Animation&&("ie"===t.Agent.browser||"edge"===t.Agent.browser)&&t.Agent.version>=12&&(this.Animation=null,this.setAnimationAllowed(!1),this.render(e),this.setAnimationAllowed(!0)),this.RenderComplete()),this.Animation=null,this.AnimationStopped=!1}}CreateKeyboardHandler(e){return new h(e,this)}getChildContainer(){return this._container}getDeleteContainer(){return this._deleteContainer}getDisplayables(){return this._displayables}_updateKeyboardFocusEffect(){var e,t=this.EventManager.getFocus(),a=!1;t&&(a=t.isShowingKeyboardFocusEffect(),t.getKeyboardFocusDisplayable&&(e=t.getKeyboardFocusDisplayable()),e&&a&&e.showKeyboardFocusEffect(),this.EventManager.setFocus(e))}processEvent(e){var t=e.type;"categoryHighlight"==t?e=this._processRolloverEvent(e):"selection"==t&&(e=this._processSelectionEvent(e)),e&&this.dispatchEvent(e)}_processRolloverEvent(e){return this._processHighlighting(e.categories),e}_processSelectionEvent(e){var a=e.selection,i=null;if(a){for(var o={},r=0;r<a.length;r++)o[a[r]]=!0;var n=this.getObjects(),l=null;if(g.getGrouping(this))for(var s=0;s<n.length;s++)if("categoryNode"===n[s].nboxType){if(o[n[s].getId()]){o[n[s].getId()]=!1;for(var d=n[s].getData().nodeIndices,h=0;h<d.length;h++){o[g.getNode(this,d[h]).id]=!0}}}else"drawer"===n[r].nboxType&&(l=n[r]);var u=[];for(var c in i=[],o)o[c]&&(u.push(c),i.push(c));e=t.EventFactory.newSelectionEvent(u)}return g.setSelectedItems(this,i),l&&l.UpdateAccessibilityAttr(),e}registerObject(e){this._peers.push(e)}getObjects(){return this._peers}getWidth(){return this.Width}getHeight(){return this.Height}getSelectionHandler(){return this._selectionHandler}isSelectionSupported(){return!!this._selectionHandler}animateUpdate(e,t){I.animateUpdate(e,t,this)}getSanitizedOptions(){return t.JsonUtils.clone(this.getOptions(),e=>0!=e.indexOf("__"),this.Defaults.getNoCloneObject())}getSubcomponentStyles(){return{}}__isDragAvailable(e){return this._selectionHandler?e[0]:null}__getDragTransferable(e){e.isSelected()||(this._selectionHandler.processClick(e,!1),this.EventManager.fireSelectionEvent());for(var t=[],a={},i=this._selectionHandler.getSelection(),o=0;o<i.length;o++){var r=i[o];if("node"===r.nboxType){var n=r.getData().id;t.push(n),a[n]=!0}else if("categoryNode"===r.nboxType){for(var l=r.getData().nodeIndices,s=0;s<l.length;s++){var d=g.getNode(this,l[s]).id;t.push(d),a[d]=!0}a[r.getData().id]=!0}}for(var h=this._selectionHandler.getSelectedIds(),u=0;u<h.length;u++){var c=h[u];if(!a[c])if(isNaN(g.getNodeIndex(this,c))){if(g.getGrouping(this)&&g.getCategoryNode(this,c)){for(var C=g.getCategoryNode(this,c).nodeIndices,_=0;_<C.length;_++){var p=g.getNode(this,C[_]).id;a[p]||(t.push(p),a[p]=!0)}a[c]=!0}}else t.push(c),a[c]=!0}return t}__getDragFeedback(){return this._selectionHandler.getSelection().slice(0)}__getCellUnderPoint(e,t){for(var a=g.getRowCount(this)*g.getColCount(this),i=0;i<a;i++){var o=d(this,g.getCell(this,i));if(o.contains(e,t))return o}return null}__showDropSiteFeedback(e){return this._dropSiteFeedback&&(this._dropSiteFeedback.getParent().removeChild(this._dropSiteFeedback),this._dropSiteFeedback=null),e&&(this._dropSiteFeedback=e.renderDropSiteFeedback()),this._dropSiteFeedback}getAutomation(){return this.Automation||(this.Automation=new m(this)),this.Automation}GetComponentDescription(){var e=this.getOptions().translations;return g.hasValidData(this)?t.ResourceUtils.format(e.componentName,[g.getColCount(this)*g.getRowCount(this)]):e.labelInvalidData}highlight(e){this.Options.highlightedCategories=t.JsonUtils.clone(e),this._processHighlighting(e)}_processHighlighting(e){var a=this.getNodeDisplayables(),i=this,o=a=>{if("node"===a.nboxType){if(a.getCategories())return"all"==i.getOptions().highlightMatch?t.ArrayUtils.hasAllItems(e,a.getCategories()):t.ArrayUtils.hasAnyItem(e,a.getCategories())}else if("categoryNode"===a.nboxType)for(var o=a.getData(),r=o.nodeIndices.length,n=0;n<r;n++){var l=g.getNode(i,o.nodeIndices[n]);if(l.categories&&("all"==i.getOptions().highlightMatch?t.ArrayUtils.hasAllItems(e,l.categories):t.ArrayUtils.hasAnyItem(e,l.categories)))return!0}return!1},r=g.getRowCount(i)*g.getColCount(i);i.getOptions().__highlightedMap=null;for(var n=0;n<r;n++){var l=g.getCell(i,n),s=d(i,l);C.renderHeader(i,l,s,!1)}var h=g.getHighlightedItems(i),c={};if(h)for(var _=0;_<h.length;_++)c[h[_].id]=!0;for(var p=0;p<a.length;p++)if(e&&e.length>0&&!o(a[p])?a[p].setAlpha(u.getFadedNodeAlpha(this)):a[p].setAlpha(1),"categoryNode"===a[p].nboxType){for(var b=0,x=a[p].getData(),f=0;f<x.nodeIndices.length;f++)c[x.nodeIndices[f]]&&(b+=1);x.highlightedCount=b;var y=null!=u.getStyledCategoryIndicatorIcon(i,x)||null!=u.getCategoryNodeIndicatorColor(i,x);v._renderNodeCount(i,a[p].getData(),a[p],x.__scale,y,x.__gap)}}getNodeDisplayables(){for(var e=[],t=g.getNodeCount(this),a=0;a<t;a++)e.push(g.getNode(this,a));var i=g.getGroupBehavior(this),o=this.getOptions().__groups;if(o)if("withinCell"==i)for(var r=g.getRowCount(this)*g.getColCount(this),n=0;n<r;n++){var l=o[n+""];for(var s in l)e.push(l[s])}else for(var h in o)e.push(o[h]);for(var u=[],c=0;c<e.length;c++){var C=d(this,e[c]);C&&u.push(C)}return u}isAnimationAllowed(){return this._animationAllowed}setAnimationAllowed(e){this._animationAllowed=e}setCellFilter(e){this._filter=e}getCellFilter(){return this._filter}setNodeClipPath(e){this._nodeClipPath=e}getNodeClipPath(){return this._nodeClipPath}setNodeIconClipPath(e){this._nodeIconClipPath=e}getNodeIconClipPath(){return this._nodeIconClipPath}static getDefaults(e){return(new S).getDefaults(e)}}e.NBox=T,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojnbox-toolkit.js.map