/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["ojs/ojcore-base","ojs/ojcomponentcore","ojs/ojthemeutils","jquery","ojs/ojdomutils","ojs/ojnavigationlistdnd","ojs/ojlistview","ojs/ojdatacollection-common","ojs/ojmenu","ojs/ojbutton"],function(t,e,i,n,s,o,a,l,r,h){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n,function(){var e={properties:{as:{type:"string",value:""},currentItem:{type:"any",writeback:!0},data:{type:"object",extension:{webelement:{exceptionStatus:[{type:"unsupported",since:"13.0.0",description:"Data sets from a DataProvider cannot be sent to WebDriverJS; use ViewModels or page variables instead."}]}}},display:{type:"string",enumValues:["all","icons"],value:"all"},drillMode:{type:"string",enumValues:["collapsible","none","sliding"],value:"none"},edge:{type:"string",enumValues:["bottom","start","top"],value:"start"},expanded:{type:"KeySet",writeback:!0},hierarchyMenuThreshold:{type:"number",value:0},item:{type:"object",properties:{renderer:{type:"function"},selectable:{type:"function|boolean",value:!0}}},overflow:{type:"string",enumValues:["hidden","popup"],value:"hidden"},rootLabel:{type:"string",value:"Navigation List"},selection:{type:"any",writeback:!0},translations:{type:"object",value:{},properties:{accessibleExpandCollapseInstructionText:{type:"string"},defaultRootLabel:{type:"string"},hierMenuBtnLabel:{type:"string"},msgFetchingData:{type:"string"},msgNoData:{type:"string"},overflowItemLabel:{type:"string"},previousIcon:{type:"string"},selectedLabel:{type:"string"}}}},methods:{getContextByNode:{},getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{},ojBeforeCollapse:{},ojBeforeCurrentItem:{},ojBeforeExpand:{},ojBeforeSelect:{},ojCollapse:{},ojExpand:{},ojSelectionAction:{}},extension:{}};e.extension._WIDGET_NAME="ojNavigationList",e.extension._ALIASED_PROPS={hierarchyMenuThreshold:"hierarchyMenuDisplayThresholdLevel"},t.CustomElementBridge.register("oj-navigation-list",{metadata:e});var i={properties:{as:{type:"string",value:""},currentItem:{type:"any",writeback:!0},data:{type:"object",extension:{webelement:{exceptionStatus:[{type:"deprecated",since:"14.0.0",description:"Data sets from a DataProvider cannot be sent to WebDriverJS; use ViewModels or page variables instead."}]}}},display:{type:"string",enumValues:["all","icons","stacked"],value:"all"},edge:{type:"string",enumValues:["bottom","end","start","top"],value:"start"},item:{type:"object",properties:{renderer:{type:"function"},selectable:{type:"function|boolean",value:!0}}},layout:{type:"string",enumValues:["condense","stretch"],value:"stretch"},overflow:{type:"string",enumValues:["hidden","popup"],value:"hidden"},reorderable:{type:"string",enumValues:["disabled","enabled"],value:"disabled"},selection:{type:"any",writeback:!0},translations:{type:"object",value:{},properties:{accessibleReorderAfterItem:{type:"string"},accessibleReorderBeforeItem:{type:"string"},accessibleReorderTouchInstructionText:{type:"string"},labelCut:{type:"string"},labelPasteAfter:{type:"string"},labelPasteBefore:{type:"string"},labelRemove:{type:"string"},msgFetchingData:{type:"string"},msgNoData:{type:"string"},overflowItemLabel:{type:"string"},removeCueText:{type:"string"},selectedLabel:{type:"string"}}},truncation:{type:"string",enumValues:["none","progressive"],value:"none"}},methods:{getContextByNode:{},getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{},ojBeforeCurrentItem:{},ojBeforeDeselect:{},ojBeforeRemove:{},ojBeforeSelect:{},ojDeselect:{},ojRemove:{},ojReorder:{}},extension:{}};i.extension._WIDGET_NAME="ojNavigationList",t.CustomElementBridge.register("oj-tab-bar",{metadata:i})}();const d="aria-hidden",_="aria-label",u="oj-default",c="oj-disabled";const m=function(e,i){var s=function(){};return t.Object.createSubclass(s,e,""),n.extend(s.prototype,i),s}(t._ojListView,{OPTION_DRILL_MODE:"drillMode",OPTION_DRILL_MODE_NONE:"none",OPTION_DRILL_MODE_COLLAPSIBLE:"collapsible",OPTION_DRILL_MODE_SLIDING:"sliding",OPTION_DISPLAY:"display",OPTION_DISPLAY_ICONS:"icons",OPTION_DISPLAY_ALL:"all",OPTION_DISPLAY_STACKED:"stacked",OPTION_LAYOUT_STRETCH:"stretch",OPTION_LAYOUT_CONDENSE:"condense",OPTION_EDGE:"edge",OPTION_EDGE_TOP:"top",OPTION_EDGE_END:"end",OPTION_EDGE_START:"start",OPTION_EDGE_BOTTOM:"bottom",OPTION_SELECTION:"selection",OPTION_CURRENT_ITEM:"currentItem",OPTION_ITEM:"item",TAG_NAME_TAB_BAR:"oj-tab-bar",NAVLIST_ITEM_SUBID_KEY:{navlist:"oj-navigationlist-item",tabbar:"oj-tabbar-item"},NAVLIST_EXPANDED_STYLE_CLASS:{navlist:"oj-navigationlist-expanded",tabbar:"oj-tabbar-expanded"},NAVLIST_COLLAPSIBLE_STYLE_CLASS:{navlist:"oj-navigationlist-collapsible",tabbar:"oj-tabbar-collapsible"},NAVLIST_VERTICAL_STYLE_CLASS:{navlist:"oj-navigationlist-vertical",tabbar:"oj-tabbar-vertical"},ITEM_CONTENT_STYLE_CLASS:{navlist:"oj-navigationlist-item-content",tabbar:"oj-tabbar-item-content"},NAVLIST_DIVIDERS_STYLE_CLASS:{navlist:"oj-navigationlist-item-dividers",tabbar:"oj-tabbar-item-dividers"},LAST_ITEM_STYLE_CLASS:{navlist:"oj-navigationlist-item-last-child",tabbar:"oj-tabbar-item-last-child"},EXPANDED_STYLE_CLASS:"oj-expanded",COLLAPSED_STYLE_CLASS:"oj-collapsed",CONDENSE_STYLE_CLASS:"oj-condense",SLIDING_NAVLIST_CURRENT_STYLE_CLASS:"oj-navigationlist-current",DIVIDER_STYLE_CLASS:{navlist:"oj-navigationlist-divider",tabbar:"oj-tabbar-divider"},NAVLIST_OVERFLOW_MENU_ITEM:{navlist:"oj-navigationlist-overflow-menu-item",tabbar:"oj-tabbar-overflow-menu-item"},NAVLIST_OVERFLOW_MENU:{navlist:"oj-navigationlist-overflow-menu",tabbar:"oj-tabbar-overflow-menu"},NAVLIST_OVERFLOW_ITEM_ICON:{navlist:"oj-navigationlist-overflow-item-icon",tabbar:"oj-tabbar-overflow-item-icon"},_CATEGORY_DIVIDER_STYLE_CLASS:{navlist:"oj-navigationlist-category-divider",tabbar:"oj-tabbar-category-divider"},_ITEM_LABEL_STYLE_CLASS:{navlist:"oj-navigationlist-item-label",tabbar:"oj-tabbar-item-label"},_ICON_ONLY_STYLE_CLASS:{navlist:"oj-navigationlist-icon-only",tabbar:"oj-tabbar-icon-only"},_STACK_ICON_STYLE_CLASS:{navlist:"oj-navigationlist-stack-icon-label",tabbar:"oj-tabbar-stack-icon-label"},_ITEM_ICON_STYLE_CLASS:{navlist:"oj-navigationlist-item-icon",tabbar:"oj-tabbar-item-icon"},_ITEM_BADGE_STYLE_CLASS:{navlist:"oj-navigationlist-item-end",tabbar:"oj-tabbar-item-end"},_HORIZONTAL_NAVLIST_STYLE_CLASS:{navlist:"oj-navigationlist-horizontal",tabbar:"oj-tabbar-horizontal"},_NAVLIST_END_EDGE_STYLE_CLASS:{navlist:"oj-navigationlist-vertical-end",tabbar:"oj-tabbar-vertical-end"},_NAVLIST_BOTTOM_EDGE_STYLE_CLASS:{navlist:"oj-navigationlist-horizontal-bottom",tabbar:"oj-tabbar-horizontal-bottom"},_NAVLIST_HAS_ICONS:{navlist:"oj-navigationlist-has-icons",tabbar:"oj-tabbar-has-icons"},_NAVLIST_ITEM_HAS_NO_ICON:{navlist:"oj-navigationlist-item-no-icon",tabbar:"oj-tabbar-item-no-icon"},_NAVLIST_ITEM_TITLE:{navlist:"oj-navigationlist-item-title",tabbar:"oj-tabbar-item-title"},_NAVLIST_STYLE_CLASS:{navlist:"oj-navigationlist",tabbar:"oj-tabbar"},_NAVLIST_TOUCH_STYLE_CLASS:{navlist:"oj-navigationlist-touch",tabbar:"oj-tabbar-touch"},_NAVLIST_LISTVIEW_CONTAINER_STYLE_CLASS:{navlist:"oj-navigationlist-listview-container",tabbar:"oj-tabbar-listview-container"},_IS_TITLE_ATTR_ADDED_DUE_TO_TRUNCATION:"IsTitleAttrDueToTruncation",_APPLICATION_LEVEL_NAV_STYLE_CLASS:"oj-navigationlist-app-level",_PAGE_LEVEL_NAV_STYLE_CLASS:"oj-navigationlist-page-level",_NAVLIST_ITEM_ICON_HAS_TITLE:"navigationListItemIconHastitle",_NAVLIST_NO_FOLLOW_LINK_CLASS:{navlist:"oj-navigationlist-nofollow-link",tabbar:"oj-tabbar-nofollow-link"},_CONTAINER_STYLE_CLASS:{navlist:"oj-navigationlist-listview",tabbar:"oj-tabbar-listview"},_ELEMENT_STYLE_CLASS:{navlist:"oj-navigationlist-element",tabbar:"oj-tabbar-element"},_ELEMENT_EMPTY_TEXT_STYLE_CLASS:{navlist:"oj-navigationlist-empty-text",tabbar:"oj-tabbar-empty-text"},_ELEMENT_NO_DATA_MSG_STYLE_CLASS:{navlist:"oj-navigationlist-no-data-message",tabbar:"oj-tabbar-no-data-message"},_FOCUSED_ELEMENT_STYLE_CLASS:{navlist:"oj-navigationlist-focused-element",tabbar:"oj-tabbar-focused-element"},_ITEM_ELEMENT_STYLE_CLASS:{navlist:"oj-navigationlist-item-element",tabbar:"oj-tabbar-item-element"},_ITEM_STYLE_CLASS:{navlist:"oj-navigationlist-item",tabbar:"oj-tabbar-item"},_OPTION_DEFAULT_STYLE_CLASS:{navlist:"oj-navigationlist-option-defaults",tabbar:"oj-tabbar-option-defaults"},_LOADING_STATUS_ICON_STYLE_CLASS:{navlist:"oj-navigationlist-loading-icon",tabbar:"oj-tabbar-loading-icon"},_STATUS_MSG_STYLE_CLASS:{navlist:"oj-navigationlist-status-message",tabbar:"oj-tabbar-status-message"},_STATUS_STYLE_CLASS:{navlist:"oj-navigationlist-status",tabbar:"oj-tabbar-status"},getItemLabel:function(t){var e=this.getItemContentElement(t);if(e.is("a")){var i=this.getItemLabelStyleClass(),s=e[0].querySelector("."+i);return n.trim(s.textContent).replace("CORE PACK","")}return n.trim(e.find("."+this.getItemTitleStyleClass()).text())},getItemContentElement:function(t){var e=t.children("."+this.getItemContentStyleClass());return 0===e.length&&0===(e=t.children("."+this.getGroupItemStyleClass()).children("."+this.getItemContentStyleClass())).length&&(e=t.children("."+this.getGroupItemStyleClass()).children(":not(."+this.getExpandIconStyleClass()+"):not(."+this.getCollapseIconStyleClass()+")")),e},isRtl:function(){return"rtl"===this.ojContext._GetReadingDirection()},_initNavigationMode:function(t){t[0].tagName.toLowerCase()===this.TAG_NAME_TAB_BAR?this._navigationMode="tabbar":this._navigationMode="navlist"},_getNavigationMode:function(){return this._navigationMode},renderComplete:function(){this.m_listHandler.BeforeRenderComplete(),m.superclass.renderComplete.apply(this,arguments)},itemInsertComplete:function(t,e){this.m_listHandler.ItemInsertComplete(t,e),m.superclass.itemInsertComplete.apply(this,arguments)},itemRemoveComplete:function(t,e){return this.m_listHandler.ItemRemoveComplete(t),m.superclass.itemRemoveComplete.apply(this,arguments)},_restoreContent:function(t){var e=t.children();t.removeAttr("style").removeClass(this.getHasIconsStyleClass()).removeAttr(d);for(var i=0;i<e.length;i++){var s=e[i];if((s=n(s)).hasClass(this.getDividerStyleClass()))s.remove();else{var o=this.getItemContentElement(s);o.removeClass(this.getItemContentStyleClass()).removeClass(this.getHasNoIconStyleClass()).removeAttr("aria-haspopup");var a=o.children("."+this.getItemIconStyleClass());a&&a.length>0&&(a.removeAttr("role"),a.removeAttr(_),this._removeToolTipOnIcon(a)),s.removeClass(u).removeAttr("role").removeAttr("aria-disabled").removeAttr("aria-expanded").removeAttr(d).removeAttr("aria-pressed");var l=this.getFocusItem(s);l.removeAttr("role").removeAttr(d).removeAttr("aria-pressed"),o.children("."+this.getItemLabelStyleClass()).contents().unwrap(),s.find("."+this.getNavListRemoveIcon()).remove(),l.data(this._IS_TITLE_ATTR_ADDED_DUE_TO_TRUNCATION)&&l.removeAttr("title");var r=s.children("ul");r.length>0?(this.m_listHandler.RestoreItem(s,o,r),this._restoreContent(r)):this.m_listHandler.RestoreItem(s,o)}}},GetDnDContext:function(){if(void 0!==o.NavigationListDndContext&&this.ojContext.element[0].tagName.toLowerCase()===this.TAG_NAME_TAB_BAR)return new o.NavigationListDndContext(this)},IsNodeEditableOrClickable:function(t){return!(t.hasClass(this.getItemContentStyleClass())||t.hasClass(this.getExpandIconStyleClass())||t.hasClass(this.getCollapseIconStyleClass()))&&m.superclass.IsNodeEditableOrClickable.apply(this,arguments)},IsElementEditableOrClickable:function(t){return t.prop("nodeName").match(/^INPUT|SELECT|OPTION|BUTTON|^A\b|TEXTAREA/)&&!t.hasClass(this.getItemContentStyleClass())||t.hasClass("oj-component")},_focusable:function(t){return n(t.data).is("li")?!n(t.data).hasClass(c):!n(t.parentElement).hasClass(c)},_prepareListViewOptions:function(t){var e=n.extend({},t);return e.drillMode="none"!==t.drillMode?"collapsible":"none",e.selection=null!==t.selection?[t.selection]:[],e.selectionMode="single",e.item=n.extend({focusable:this._focusable},t.item),e.element=this._list,e},updateListViewOption:function(t,e){switch(t){case this.OPTION_DRILL_MODE:this.options[this.OPTION_DRILL_MODE]="none"!==e?"collapsible":"none";break;case this.OPTION_SELECTION:this.options[this.OPTION_SELECTION]=null!==e?[e]:[];break;case this.OPTION_ITEM:this.options[this.OPTION_ITEM]=n.extend({focusable:this._focusable},e);break;default:this.options[t]=e}},getRootLabel:function(){return this.ojContext.options.rootLabel?this.ojContext.options.rootLabel:this.ojContext.getTranslatedString("defaultRootLabel")},SetAriaProperties:function(){"tabbar"===this._getNavigationMode()&&this.ojContext.element.attr("aria-multiselectable",!1)},_isHorizontalTablist:function(){const t=this.ojContext.element.get(0);return"tablist"===t.getAttribute("role")&&"vertical"!==t.getAttribute("aria-orientation")},_focusSelectedTab:function(t){if(!this.m_preActive&&null==this.m_active){const e=this.ojContext.element.get(0).querySelector("."+this.getItemElementStyleClass()+".oj-selected");e&&this._setActive(n(e),t,!0)}},HandleFocus:function(t){return this._isHorizontalTablist()&&this._focusSelectedTab(t),this.m_listHandler.HandleFocus(t)},HandleBlur:function(t){return this.m_listHandler.HandleBlur(t)},SetRootElementTabIndex:function(){this.ojContext.element.attr("tabIndex",0)},RemoveRootElementTabIndex:function(){this.ojContext.element.removeAttr("tabIndex")},UnsetAriaProperties:function(){this.ojContext.element.removeAttr("aria-activedescendant").removeAttr("aria-multiselectable")},isLoadMoreOnScroll:function(){return!1},ShouldUseGridRole:function(){return!1},init:function(t){var e=this,i=t.ojContext.element;this._initNavigationMode(i),i.addClass(this.getNavListStyleClass()),s.isTouchSupported()&&i.addClass(this.getNavListTouchStyleClass()),this._list=i.children("ul:first"),0===this._list.length&&(this._list=n(document.createElement("ul")),i.append(this._list));var o=n(document.createElement("div"));o.addClass(this.getNavListContainerStyleClass()),o.attr("role","presentation"),this._list.wrap(o);var a=this._prepareListViewOptions(t);m.superclass.init.call(this,a),this.getListContainer().attr("role","presentation"),this.element.removeClass("oj-component-initnode"),this.ojContext._on(this.ojContext.element,{click:function(t){e.m_listHandler.HandleClick(t)},keydown:function(t){e.m_listHandler.HandleKeydown(t)},mouseup:function(t){e._clearActiveState(t)},mouseover:function(t){if(n(t.target).closest("a."+e.getItemContentStyleClass()).length>0){var i=n(t.target).closest("a."+e.getItemContentStyleClass());if(i.find("."+e.getOverflowItemIconStyleClass()).length>0)return;var s=i.find("."+e.getItemLabelStyleClass());s[0].offsetWidth<s[0].scrollWidth&&!i.attr("title")&&(i.attr("title",s.text().trim()),i.data(e._IS_TITLE_ATTR_ADDED_DUE_TO_TRUNCATION,"true"))}},mouseout:function(t){if(n(t.target).closest("a."+e.getItemContentStyleClass()).length>0){var i=n(t.target).closest("a."+e.getItemContentStyleClass());i.data(e._IS_TITLE_ATTR_ADDED_DUE_TO_TRUNCATION)&&(i.removeData(e._IS_TITLE_ATTR_ADDED_DUE_TO_TRUNCATION),i.removeAttr("title")),e._clearActiveState(t)}}})},_initListHandler:function(){var e=this.ojContext.options.drillMode,i=this.ojContext.options.edge;e===this.OPTION_DRILL_MODE_SLIDING?this.m_listHandler=new t.SlidingNavListHandler(this,this.ojContext.element,this.ojContext):e===this.OPTION_DRILL_MODE_COLLAPSIBLE?this.m_listHandler=new t.CollapsibleNavListHandler(this,this.ojContext.element,this.ojContext):e!==this.OPTION_DRILL_MODE_NONE||i!==this.OPTION_EDGE_TOP&&i!==this.OPTION_EDGE_BOTTOM?this.m_listHandler=new t.DefaultNavListHandler(this,this.ojContext.element,this.ojContext):this.m_listHandler=new t.HorizontalNavListHandler(this,this.ojContext.element,this.ojContext),this.m_listHandler.Init(this.options);var n=this.ojContext.options.navigationLevel;this._setNavigationLevel(n)},_setNavigationLevel:function(t){"none"===this.ojContext.options.drillMode&&("application"===t||"oj-navigation-list"===this.ojContext.element[0].tagName.toLowerCase()?(this.ojContext.element.addClass(this._APPLICATION_LEVEL_NAV_STYLE_CLASS),this.ojContext.element.removeClass(this._PAGE_LEVEL_NAV_STYLE_CLASS)):"page"===t&&(this.ojContext.element.addClass(this._PAGE_LEVEL_NAV_STYLE_CLASS),this.ojContext.element.removeClass(this._APPLICATION_LEVEL_NAV_STYLE_CLASS)))},_clearActiveState:function(t){var e=this.FindItem(n(t.target));null!=e&&this.HighlightUnhighlightElem(e,"oj-active",!1)},afterCreate:function(){this._initListHandler(),m.superclass.afterCreate.apply(this,arguments)},getAnimationEffect:function(t){return this.m_listHandler.GetAnimationEffect(t)},notifyAttached:function(){m.superclass.notifyAttached.apply(this,arguments),this.m_listHandler.NotifyAttached()},ShouldRegisterResizeListener:function(){return!0},HandleResize:function(t,e){m.superclass.HandleResize.apply(this,arguments),t>0&&e>0&&null!=this.m_listHandler&&this.m_listHandler.HandleResize(t,e)},BeforeInsertItem:function(){this.m_listHandler.BeforeInsertItem()},HandleMouseDownOrTouchStart:function(t){m.superclass.HandleMouseDownOrTouchStart.apply(this,arguments);var e=this.FindItem(n(t.target));e&&!e.hasClass(c)&&this.HighlightUnhighlightElem(e,"oj-active",!0)},HandleTouchEndOrCancel:function(t){this._clearActiveState(t),m.superclass.HandleTouchEndOrCancel.apply(this,arguments)},getItemContentStyleClass:function(){return this.ITEM_CONTENT_STYLE_CLASS[this._getNavigationMode()]},getNavListExpandedStyleClass:function(){return this.NAVLIST_EXPANDED_STYLE_CLASS[this._getNavigationMode()]},getNavListCollapsibleStyleClass:function(){return this.NAVLIST_COLLAPSIBLE_STYLE_CLASS[this._getNavigationMode()]},getNavListVerticalStyleClass:function(){return this.NAVLIST_VERTICAL_STYLE_CLASS[this._getNavigationMode()]},getNavListItemsDividerStyleClass:function(){return this.NAVLIST_DIVIDERS_STYLE_CLASS[this._getNavigationMode()]},getLastItemStyleClass:function(){return this.LAST_ITEM_STYLE_CLASS[this._getNavigationMode()]},getItemBadgeStyleClass:function(){return this._ITEM_BADGE_STYLE_CLASS[this._getNavigationMode()]},getDividerStyleClass:function(){return this.DIVIDER_STYLE_CLASS[this._getNavigationMode()]},getOverflowItemStyleClass:function(){return this.NAVLIST_OVERFLOW_MENU_ITEM[this._getNavigationMode()]},getOverflowMenuStyleClass:function(){return this.NAVLIST_OVERFLOW_MENU[this._getNavigationMode()]},getOverflowItemIconStyleClass:function(){return this.NAVLIST_OVERFLOW_ITEM_ICON[this._getNavigationMode()]},getCategoryDividerStyleClass:function(){return this._CATEGORY_DIVIDER_STYLE_CLASS[this._getNavigationMode()]},getItemLabelStyleClass:function(){return this._ITEM_LABEL_STYLE_CLASS[this._getNavigationMode()]},getIconOnlyStyleClass:function(){return this._ICON_ONLY_STYLE_CLASS[this._getNavigationMode()]},getStackedIconStyleClass:function(){return this._STACK_ICON_STYLE_CLASS[this._getNavigationMode()]},getItemIconStyleClass:function(){return this._ITEM_ICON_STYLE_CLASS[this._getNavigationMode()]},getHorizontalNavListStyleClass:function(){return this._HORIZONTAL_NAVLIST_STYLE_CLASS[this._getNavigationMode()]},getNavListEndEdgeStyleClass:function(){return this._NAVLIST_END_EDGE_STYLE_CLASS[this._getNavigationMode()]},getNavListBottomEdgeStyleClass:function(){return this._NAVLIST_BOTTOM_EDGE_STYLE_CLASS[this._getNavigationMode()]},getHasIconsStyleClass:function(){return this._NAVLIST_HAS_ICONS[this._getNavigationMode()]},getHasNoIconStyleClass:function(){return this._NAVLIST_ITEM_HAS_NO_ICON[this._getNavigationMode()]},getItemTitleStyleClass:function(){return this._NAVLIST_ITEM_TITLE[this._getNavigationMode()]},getNavListStyleClass:function(){return this._NAVLIST_STYLE_CLASS[this._getNavigationMode()]},getNavListTouchStyleClass:function(){return this._NAVLIST_TOUCH_STYLE_CLASS[this._getNavigationMode()]},getNavListContainerStyleClass:function(){return this._NAVLIST_LISTVIEW_CONTAINER_STYLE_CLASS[this._getNavigationMode()]},getNoFollowLinkStyleClass:function(){return this._NAVLIST_NO_FOLLOW_LINK_CLASS[this._getNavigationMode()]},getCondenseStyleClass:function(){return this.CONDENSE_STYLE_CLASS},getItemSubIdKey:function(){return this.isTabBar()?this.NAVLIST_ITEM_SUBID_KEY.tabbar:this.NAVLIST_ITEM_SUBID_KEY.navlist},GetContainerStyleClass:function(){return this._CONTAINER_STYLE_CLASS[this._getNavigationMode()]},GetStyleClass:function(){return this._ELEMENT_STYLE_CLASS[this._getNavigationMode()]},getEmptyTextMarkerClass:function(){return this._ELEMENT_EMPTY_TEXT_STYLE_CLASS[this._getNavigationMode()]},getEmptyTextStyleClass:function(){return this._ELEMENT_NO_DATA_MSG_STYLE_CLASS[this._getNavigationMode()]},getNavListRemoveIcon:function(){return"oj-tabbar-remove-icon"},getNavListRemoveCommand:function(){return"oj-tabbar-remove"},getRemovableStyleClass:function(){return"oj-removable"},getItemStyleClass:function(){return this._ITEM_STYLE_CLASS[this._getNavigationMode()]},getItemLayoutStyleClass:function(){return this.getItemStyleClass()},getFocusedElementStyleClass:function(){return this._FOCUSED_ELEMENT_STYLE_CLASS[this._getNavigationMode()]},getItemElementStyleClass:function(){return this._ITEM_ELEMENT_STYLE_CLASS[this._getNavigationMode()]},getCollapseIconStyleClass:function(){return"oj-navigationlist-collapse-icon"},getExpandIconStyleClass:function(){return"oj-navigationlist-expand-icon"},getDepthStyleClass:function(t){return"oj-navigationlist-depth-"+t},getGroupItemStyleClass:function(){return"oj-navigationlist-group-item"},getGroupStyleClass:function(){return"oj-navigationlist-group"},getGroupExpandStyleClass:function(){return"oj-navigationlist-collapsible-transition"},getGroupCollapseStyleClass:function(){return this.getGroupExpandStyleClass()},getStyleValues:function(){const e={};return Object.entries(m._CSS_Vars[this._getNavigationMode()]).forEach(([n,s])=>{"animation"===n?e.animation=t._ojListView.getComplexCSSVariable(s):e[n]=i.getCachedCSSVarValues([s])[0]}),e},getLoadingStatusIconStyleClass:function(){return this._LOADING_STATUS_ICON_STYLE_CLASS[this._getNavigationMode()]},showLoadingIcon:function(){"redwood"===i.parseJSONFromFontFamily("oj-theme-json").behavior||m.superclass.showLoadingIcon.apply(this,arguments)},getStatusMessageStyleClass:function(){return this._STATUS_MSG_STYLE_CLASS[this._getNavigationMode()]},getStatusStyleClass:function(){return this._STATUS_STYLE_CLASS[this._getNavigationMode()]},AnimateExpand:function(t,e,i){return this.m_listHandler.Expand(t,e,i)},AnimateCollapse:function(t,e,i,n){return this.m_listHandler.Collapse(t,e,i,n)},HandleArrowKeys:function(t,e,i){return!i.altKey&&this.m_listHandler.HandleArrowKeys(t,e,i)},IsArrowKey:function(t){return this.m_listHandler.IsArrowKey(t)},GetState:function(t){return this.m_listHandler.GetState(t)},SetState:function(t,e){this.m_listHandler.SetState(t,e)},_handleRemovableLink:function(t){var e=n(t.target),i=this.FindItem(e);if(null!=i&&0!==i.length){this.HandleClickActive(i,t);var s=this.getItemContentElement(i);s.length>0&&s[0].focus(),t.preventDefault(),t.stopPropagation(),this._handleRemove(t,i)}},HandleMouseClick:function(t){var e=n(t.target),i=e[0].parentNode,s=this.FindItem(e);if(null!=s&&0!==s.length)if(this.SkipFocus(s))t.preventDefault();else if(i.classList.contains("oj-animate-pointerUp")&&(e=n(i)),!this.IsNodeEditableOrClickable(e)){var o=this.getItemContentElement(s).attr("href");if(!o||"#"===o||0!==t.button||!t.shiftKey&&!t.ctrlKey){var a=this.GetOption("selection")[0];m.superclass.HandleMouseClick.apply(this,arguments),this.isTabBar()||this._skipSelectionAction||this.FireSelectionAction(t,s,a),t.preventDefault()}}},HandleKeyDown:function(t){if(this.m_active){var e,i=t.keyCode,s=this.m_active.elem,o=this.m_active.key;if(i===n.ui.keyCode.HOME||i===n.ui.keyCode.END)e=i===n.ui.keyCode.HOME?this.element.find("."+this.getItemContentStyleClass()+":visible").first().closest("."+this.getItemElementStyleClass()):this.element.find("."+this.getItemContentStyleClass()+":visible").last().closest("."+this.getItemElementStyleClass()),this.SetCurrentItem(e,t),t.preventDefault();else if(i===n.ui.keyCode.DELETE&&this.isTabBar())this._handleRemove(t,s);else{var a=this.GetOption("selection")[0],l=this.HandleSelectionOrActiveKeyDown(t),r=this.m_listHandler.HandleExpandAndCollapseKeys(t,i,s,o);l=l||r||null!=this.m_dndContext&&this.m_dndContext.HandleKeyDown(t),this.isTabBar()||t.keyCode!==n.ui.keyCode.ENTER&&t.keyCode!==n.ui.keyCode.SPACE||(this.FireSelectionAction(t,s,a),this._skipSelectionAction=t.keyCode===n.ui.keyCode.ENTER,window.requestAnimationFrame(()=>{this._skipSelectionAction=!1})),l&&t.preventDefault()}}},AvoidFocusHighLight:function(t){this._avoidFocusHighLight=t},RecentPointerCallback:function(){var t=this;return function(){return!!t._avoidFocusHighLight}},ShouldApplyHighlight:function(){return!0},ToggleSelection:function(t,e,i){var n=this.m_active.elem;this.IsSelectable(n[0])&&(this._isSelected(n)||this._fireBeforeSelectEvent(t,n)&&(m.superclass.ToggleSelection.apply(this,arguments),this._initiateNavigation(n)))},HighlightUnhighlightElem:function(t,e,i){var s=n(t);"oj-selected"===e&&this.m_listHandler.UpdateAriaPropertiesOnSelectedItem(this.getFocusItem(s),i);var o=s.children("."+this.getGroupItemStyleClass());o.length>0&&(s=n(o[0])),"oj-focus"===e?i?this._focusInHandler(s):this._focusOutHandler(s):i?s.addClass(e):s.removeClass(e),s.hasClass("oj-selected")||s.hasClass("oj-focus")||s.hasClass("oj-hover")||s.hasClass("oj-active")||s.hasClass(c)?(s.hasClass(this.getRemovableStyleClass())&&this.isTabBar()&&s.find("."+this.getNavListRemoveIcon()).css("visibility","visible"),s.removeClass(u)):(this.isTabBar()&&s.find("."+this.getNavListRemoveIcon()).css("visibility","hidden"),s.addClass(u))},IsSelectable:function(t){return!n(t).hasClass(c)&&this.m_listHandler.IsSelectable(n(t))},Trigger:function(t,e,i){return"ready"===t||this.ojContext._trigger(t,e,i)},SetOption:function(t,e,i){if(this.m_listHandler.IsOptionUpdateAllowed(t,e,i)){var n=null;if("selection"===t){var s=i._context,o=s&&s.extraData&&s.extraData.items;o&&(this.ojContext._IsCustomElement()?0===o.length?s.extraData.item=null:s.extraData.item=o[0]:s.extraData.item=o,s.extraData.items=void 0),e&&e.length>0&&(n=e[0]),this._fireDeselectEvent(s.originalEvent,o,e)}else n=e;this.ojContext.option(t,n,i),this.options[t]=e,this.m_listHandler.OptionUpdated(t,n,i)}},ShouldRefresh:function(t){return null!=t.data||null!=t.drillMode||null!=t.item||null!=t.display||null!=t.layout||null!=t.edge},setOptions:function(t,e){var i,n={skipOptions:[]};this.m_listHandler.SetOptions(t),void 0!==t.navigationLevel&&this._setNavigationLevel(t.navigationLevel);const s=Object.hasOwn(t,"selection");return s&&(i=t.selection),n.needRefresh=m.superclass.setOptions.call(this,t,e),s&&!Object.hasOwn(t,"selection")&&n.skipOptions.push("selection"),s&&(t.selection=i),n},compareValues:function(e,i){return e===i||t.Object.compareValues(e,i)},HandleSelectionOption:function(t){if(Object.hasOwn(t,"selection")){var e=t.selection;if(null!=e){var i=this.GetOption("selection");if(i&&0!==i.length&&this.compareValues(i[0],e))delete t.selection;else{var s=this.FindElementByKey(e);if(!s||this.IsSelectable(s))this._fireBeforeSelectEvent(null,n(s),e)?(this._fireDeselectEvent(null,s,e),t.selection=[e],this.m_listHandler.HandleSelectionChange(s),s&&this._initiateNavigation(n(s))):delete t.selection;else delete t.selection}}else t.selection=[];m.superclass.HandleSelectionOption.call(this,t)}},GetOption:function(t){var e=this.ojContext.option(t);return"selection"===t?null!=e?[e]:[]:("item"!==t||e.focusable||(e.focusable=this._focusable),null===e?this.options[t]:e)},getWidgetConstructor:function(){return e.__GetWidgetConstructor(this.ojContext.element)},SelectAndFocus:function(t,e){t.hasClass(c)||this.IsSelectable(t[0])&&(!this._isSelected(t)&&this._fireBeforeSelectEvent(e,t)?(m.superclass.SelectAndFocus.apply(this,arguments),this._initiateNavigation(t)):this.HandleClickActive(t,e))},isTabBar:function(){return this.ojContext.element[0].tagName.toLowerCase()===this.TAG_NAME_TAB_BAR},_fireBeforeDeselectEvent:function(t,e,i){i||(i=this.GetKey(e[0]));var n=this.GetOption("selection"),s=this.FindElementByKey(n);return this.Trigger("beforeDeselect",t,{toItem:e,toKey:i,fromItem:s,fromKey:n})},_fireBeforeSelectEvent:function(t,e,i){var n=!0;return i||(i=this.GetKey(e[0])),this.isTabBar()&&(n=this._fireBeforeDeselectEvent(t,e,i)),n&&this.Trigger("beforeSelect",t,{item:e,key:i})},_fireRemoveEvent:function(t,e){var i=this.GetKey(e[0]);return this.Trigger("beforeRemove",t,{item:e,key:i})&&this.Trigger("remove",t,{item:e,key:i})},_fireDeselectEvent:function(t,e,i){var n=this.GetOption("selection"),s=this.FindElementByKey(n);this.Trigger("deselect",t,{toItem:e,toKey:i,fromItem:s,fromKey:n})},FireSelectionAction:function(t,e,i){var n=this.GetKey(e[0]||e);this.Trigger("selectionAction",t,{value:n,previousValue:i})},_initiateNavigation:function(t){if(this.ojContext.element.hasClass(this.getNoFollowLinkStyleClass()))return!1;var e=this.getItemContentElement(t),i=e.attr("href"),n=e.attr("target");return!(!i||"#"===i)&&(n&&"_self"!==n?window.open(i,n):window.location.href=i,!0)},_isSelected:function(t){var e=this.GetOption("selection"),i=this.GetKey(t[0]);return!(!e||1!==e.length||!this.compareValues(e[0],i))},_setToolTipOnIcon:function(t,e){t.attr("title")||t.attr("title",e)},_removeToolTipOnIcon:function(t){t.data(this._NAVLIST_ITEM_ICON_HAS_TITLE)?t.removeData(this._NAVLIST_ITEM_ICON_HAS_TITLE):t.removeAttr("title")},GetRootElement:function(){return this.ojContext.element},getSingleFocusableElement:function(t){var e=this,i="a, input, select, textarea, button",s=t.children(i).filter(function(){return!(n(this).hasClass(e.getNavListRemoveIcon())||n(this).hasClass(e.getExpandIconStyleClass()))});return 1===s.length&&0===s.first().find(i).filter(function(){return!n(this).hasClass(e.getNavListRemoveIcon())}).length?s.first():t},PrepareContextMenu:function(t){var e=this.ojContext._GetContextMenu();if(null!=this.m_dndContext&&e&&this.m_dndContext.prepareContextMenu(e),t.hasClass(this.getRemovableStyleClass())&&e){this.m_contextMenu!==e&&(this.m_contextMenu=e,e.addEventListener("ojAction",this._handleContextMenuSelect.bind(this))),this.m_contextMenuItem=t;var i=n(e).find("[data-oj-command="+this.getNavListRemoveCommand()+"]"),s=this.ojContext.getTranslatedString("labelRemove");this.ojContext._IsCustomElement()?i.empty().append(document.createTextNode(s)):i.empty().append(n('<a href="#"></a>').text(s)),e.refresh()}},_handleContextMenuSelect:function(t){n(t.target).attr("data-oj-command")===this.getNavListRemoveCommand()&&this._handleRemove(t,this.m_contextMenuItem)},_handleRemove:function(t,e){e.hasClass(this.getRemovableStyleClass())&&this._fireRemoveEvent(t,e)},_wrapInner:function(t,e){for(var i=t.childNodes;i.length>0;)e.appendChild(i[0]);t.appendChild(e)},itemRenderComplete:function(t,e){var i=n(t);if(i.hasClass(this.getCategoryDividerStyleClass()))return i.removeClass(this.getItemElementStyleClass()),i.removeClass(this.getFocusedElementStyleClass()),i.removeClass(this.getItemStyleClass()),i.removeAttr("aria-selected"),i.children().remove(),void i.attr("role","separator");var s,o=this.getGroupItemStyleClass(),a=this.getCollapseIconStyleClass(),l=this.getExpandIconStyleClass(),r=this.getItemIconStyleClass(),h=this.getItemBadgeStyleClass(),d=i.children("."+o);if(d.length>0){d.addClass(this.getItemStyleClass()),s=d.children(":not(."+l+"):not(."+a+")");var g=d.children("."+l);0===g.length&&(g=d.children("."+a)),g.removeAttr("aria-labelledby"),i.hasClass(c)&&d.addClass(c)}else s=i.children().first();if(s.length>0){s.addClass(this.getItemContentStyleClass());var p=this.getItemLabelStyleClass(),v=s[0].querySelector("."+p),C=s.find("."+r),f=s.find("."+h);if(null==v&&((v=document.createElement("span")).classList.add(p),this._wrapInner(s[0],v),f.length>0&&f.insertAfter(v),C.length>0&&C.insertBefore(v)),C.length>0){if(C.attr("title")&&C.data(this._NAVLIST_ITEM_ICON_HAS_TITLE,C.attr("title")),"icons"===this.ojContext.options.display){this.ojContext.element.addClass(this.getIconOnlyStyleClass());var S=this.getItemLabel(i);(null!==S||S.length>0)&&(C.attr(_,S),C.attr("role","img"),this._setToolTipOnIcon(C,S))}"stacked"===this.ojContext.options.display&&(this.ojContext.element.hasClass(this.getStackedIconStyleClass())||(this.ojContext.element.addClass(this.getStackedIconStyleClass()),this.isStackedIconClassAdded=!0),C.attr("role","img")),this.element.closest("ul").addClass(this.getHasIconsStyleClass())}else s.addClass(this.getHasNoIconStyleClass());if(i.hasClass(this.getRemovableStyleClass())&&this.isTabBar()){var I=document.createElement("div");I.classList.add("oj-tabbar-icon-label-container"),C.length>0&&I.appendChild(C[0]),I.appendChild(v),f.length>0&&I.appendChild(f[0]),s[0].appendChild(I),null==this.m_handleRemovableLink&&(this.m_handleRemovableLink=this._handleRemovableLink.bind(this));var y=n("<a>");y.addClass(this.getNavListRemoveIcon()).addClass("oj-clickable-icon-nocontext oj-component-icon").attr(_,this.ojContext.getTranslatedString("removeCueText")).attr("role","img"),y[0].addEventListener("click",this.m_handleRemovableLink),i.hasClass(c)?y.css("visibility","visible"):y.css("visibility","hidden"),s.append(y),s.attr("aria-describedby",y.uniqueId().attr("id"))}}i.hasClass(c)?this.getFocusItem(i).attr("aria-disabled","true"):d.length>0?d.addClass(u):i.addClass(u),this.m_listHandler.ModifyListItem(i,s),m.superclass.itemRenderComplete.apply(this,arguments)},DestroyContentHandler:function(t){null===this.GetOption("data")&&this._restoreContent(this.element),m.superclass.DestroyContentHandler.apply(this,arguments)},getNodeBySubId:function(t){if(null==t)return this.ojContext.element?this.ojContext.element[0]:null;var e=this.m_listHandler.GetNodeBySubId(t);if(!e&&t.subId===this.getItemSubIdKey()){var i=t.key;e=this.FindElementByKey(i)}return e},getSubIdByNode:function(t){var e=null;if(null!=t&&!(e=this.m_listHandler.GetSubIdByNode(t))){var i=this.FindItem(t);if(null!=i&&i.length>0){var n=this.GetKey(i[0]);null!=n&&(e={subId:this.getItemSubIdKey(),key:n})}}return e},getContextByNode:function(t){var e=m.superclass.getContextByNode.call(this,t);return e&&"oj-listview-item"===e.subId?(e.subId=this.getItemSubIdKey(),e):null},refresh:function(){this._resetNavlist(),this._initListHandler(),m.superclass.refresh.apply(this,arguments)},_resetNavlist:function(){this.ojContext.element.removeClass(this.getIconOnlyStyleClass()),this.isStackedIconClassAdded&&this.ojContext.element.removeClass(this.getStackedIconStyleClass()),this.ojContext.element.removeClass(this.getCondenseStyleClass()),this.ojContext.element.removeClass(this._APPLICATION_LEVEL_NAV_STYLE_CLASS),this.ojContext.element.removeClass(this._PAGE_LEVEL_NAV_STYLE_CLASS),this._restoreContent(this.element),this.m_listHandler.Destroy()},destroy:function(){this._resetNavlist(),m.superclass.destroy.apply(this,arguments),this._list.unwrap(),this._list.is(":empty")&&this._list.remove(),this.ojContext.element.removeClass(this.getNavListStyleClass()+" "+this.getNavListTouchStyleClass()),this.ojContext._off(this.element,"click"),this.ojContext._off(this.element,"focus"),this.ojContext._off(this.element,"blur"),this.ojContext._off(this.element,"mouseover"),this.ojContext._off(this.element,"mousein"),this.ojContext._off(this.element,"mouseout"),this.ojContext._off(this.element,"keydown"),this.m_handleRemovableLink=null}});m._CSS_Vars={navlist:{animation:{addHorizontalItem:"--oj-private-navigation-list-global-horizontal-add-animation-default",removeHorizontalItem:"--oj-private-navigation-list-global-horizontal-remove-animation-default",add:"--oj-private-navigation-list-global-add-animation-default",remove:"--oj-private-navigation-list-global-remove-animation-default",update:"--oj-private-navigation-list-global-update-animation-default",expand:"--oj-private-navigation-list-global-expand-animation-default",collapse:"--oj-private-navigation-list-global-collapse-animation-default",sliderExpand:"--oj-private-navigation-list-global-slider-expand-animation-default",sliderCollapse:"--oj-private-navigation-list-global-slider-collapse-animation-default",pointerUp:"--oj-private-navigation-list-global-pointer-up-animation-default"},hierarchyMenuDisplayThresholdLevel:"--oj-private-navigation-list-global-hierarchy-menu-threshold-default",showIndicatorDelay:"--oj-private-core-global-loading-indicator-delay-duration"},tabbar:{animation:{addHorizontalItem:"--oj-private-tab-bar-global-horizontal-add-animation-default",removeHorizontalItem:"--oj-private-tab-bar-global-horizontal-remove-animation-default",add:"--oj-private-tab-bar-global-add-animation-default",remove:"--oj-private-tab-bar-global-remove-animation-default",update:"--oj-private-tab-bar-global-update-animation-default",pointerUp:"--oj-private-tab-bar-global-pointerUp-animation-default"},showIndicatorDelay:"--oj-private-core-global-loading-indicator-delay-duration"}},t.__registerWidget("oj.ojNavigationList",n.oj.baseComponent,{widgetEventPrefix:"oj",options:{as:"",currentItem:null,drillMode:"none",reorderable:"disabled",truncation:"none",edge:"start",hierarchyMenuDisplayThresholdLevel:0,rootLabel:null,selection:null,expanded:new t._ojListViewExpandedKeySet,data:null,display:"all",navigationLevel:"page",overflow:"hidden",item:{renderer:null,selectable:!0},animateStart:null,animateEnd:null,beforeSelect:null,beforeCollapse:null,beforeCurrentItem:null,beforeDeselect:null,collapse:null,deselect:null,beforeExpand:null,expand:null,reorder:null,selectionAction:null},_ComponentCreate:function(){this._super(),this._setup()},_AfterCreate:function(){this._super();var t=this;this.navlist._FixRendererContext=function(e){return t._FixRendererContext(e)},this.navlist._WrapCustomElementRenderer=function(e){return t._WrapCustomElementRenderer(e)},this.navlist._GetCustomElement=function(){return t._GetCustomElement()},this.navlist.afterCreate()},_NotifyContextMenuGesture:function(t,e,i){this.navlist.notifyContextMenuGesture(t,e,i)},_setup:function(){this.navlist=new m;for(var t=Object.keys(this.options),e=0;e<t.length;e++){var i=t[e];this._validateOptionValues(i,this.options[i])}this._validateOptionsForIconsOnlyAndHorizontalList(this.options[this.navlist.OPTION_DRILL_MODE],this.options[this.navlist.OPTION_DISPLAY],this.options[this.navlist.OPTION_EDGE]);var s={ojContext:this};s=n.extend(this.options,s),this.navlist.init(s)},getNodeBySubId:function(t){return this.navlist.getNodeBySubId(t)},getSubIdByNode:function(t){return this.navlist.getSubIdByNode(t)},getContextByNode:function(t){return this.navlist.getContextByNode(t)},expand:function(t,e,i){this.navlist.expandKey(t,e,!0,!0,i)},collapse:function(t,e,i){this.navlist.collapseKey(t,e,!0,i)},getExpanded:function(){return this.navlist.getExpanded()},_validateOptionsForIconsOnlyAndHorizontalList:function(t,e,i){if(t!==this.navlist.OPTION_DRILL_MODE_NONE){if(e===this.navlist.OPTION_DISPLAY_ICONS)throw new Error("Icon only navigation list should have drillMode set to 'none'.");if(e===this.navlist.OPTION_DISPLAY_STACKED)throw new Error("Stack only navigation list should have drillMode set to 'none'.");if(i===this.navlist.OPTION_EDGE_TOP)throw new Error("Horizontal navigation list should have drillMode set to 'none'.")}},_validateOptionValues:function(t,e){var i=!0;if(t===this.navlist.OPTION_DRILL_MODE?i=e===this.navlist.OPTION_DRILL_MODE_NONE||e===this.navlist.OPTION_DRILL_MODE_COLLAPSIBLE||e===this.navlist.OPTION_DRILL_MODE_SLIDING:t===this.navlist.OPTION_DISPLAY?i=e===this.navlist.OPTION_DISPLAY_ALL||e===this.navlist.OPTION_DISPLAY_ICONS||e===this.navlist.OPTION_DISPLAY_STACKED:t===this.navlist.OPTION_EDGE&&(i=this.element[0].tagName.toLowerCase()===this.navlist.TAG_NAME_TAB_BAR?e===this.navlist.OPTION_EDGE_TOP||e===this.navlist.OPTION_EDGE_START||e===this.navlist.OPTION_EDGE_END||e===this.navlist.OPTION_EDGE_BOTTOM:e===this.navlist.OPTION_EDGE_TOP||e===this.navlist.OPTION_EDGE_BOTTOM||e===this.navlist.OPTION_EDGE_START),!i)throw new Error("Invalid value: "+e+" for key: "+t)},_setOption:function(t,e){var i,s;switch(this._validateOptionValues(t,e),t){case this.navlist.OPTION_DRILL_MODE:this._validateOptionsForIconsOnlyAndHorizontalList(e,this.options[this.navlist.OPTION_DISPLAY],this.options[this.navlist.OPTION_EDGE]);break;case this.navlist.OPTION_DISPLAY:this._validateOptionsForIconsOnlyAndHorizontalList(this.options[this.navlist.OPTION_DRILL_MODE],e,this.options[this.navlist.OPTION_EDGE]);break;case this.navlist.OPTION_EDGE:this._validateOptionsForIconsOnlyAndHorizontalList(this.options[this.navlist.OPTION_DRILL_MODE],this.options[this.navlist.OPTION_DISPLAY],e);break;case this.navlist.OPTION_SELECTION:case this.navlist.OPTION_CURRENT_ITEM:this.navlist.isAvailable()&&(s=this.navlist.getItems([e])[0],i={_context:{extraData:{item:this._IsCustomElement()?s:n(s)}}})}return this.navlist.updateListViewOption(t,e),i?this._super(t,e,i):this._super(t,e)},_setOptions:function(t,e){if(!this.navlist.isAvailable())return this._super(t,e),this;for(var i=this.navlist.setOptions(t,e),n={},s=Object.keys(t),o=0;o<s.length;o++){var a=s[o];i.skipOptions.indexOf(a)<0&&(n[a]=t[a])}return this._super(n,e),i.needRefresh&&this.navlist.refresh(),this},_NotifyAttached:function(){this.navlist.notifyAttached()},_NotifyDetached:function(){this.navlist.notifyDetached()},_NotifyShown:function(){this.navlist.notifyShown()},_VerifyConnectedForSetup:function(){return!0},refresh:function(){this._super(),this.navlist.refresh()},whenReady:function(){return this.navlist.whenReady()},_SetupResources:function(){this._super(),this.navlist.setupResources()},_ReleaseResources:function(){this._super(),this.navlist.releaseResources()},_destroy:function(){this.navlist.destroy(),this._super()},_CompareOptionValues:function(e,i,n){switch(e){case"currentItem":case"selection":return t.Object.compareValues(i,n);default:return this._super(e,i,n)}}}),e.setDefaultOptions({ojNavigationList:{hierarchyMenuDisplayThresholdLevel:e.createDynamicPropertyGetter(function(){const t=m._CSS_Vars.navlist.hierarchyMenuDisplayThresholdLevel;return+i.getCachedCSSVarValues([t])[0]})}});const g=function(t,e,i){this.m_widget=t,this.m_root=e,this.m_component=i,this.m_widget.GetOption(this.m_widget.OPTION_EDGE)===this.m_widget.OPTION_EDGE_END&&this.m_root.addClass(this.m_widget.getNavListEndEdgeStyleClass())};t._registerLegacyNamespaceProp("DefaultNavListHandler",g),g.prototype.Destroy=function(){this.m_root.removeClass(this.m_widget.getNavListExpandedStyleClass()).removeClass(this.m_widget.getNavListVerticalStyleClass()).removeClass(this.m_widget.getNavListEndEdgeStyleClass())},g.prototype.Expand=function(t,e,i){return Promise.resolve(null)},g.prototype.Collapse=function(t,e,i,n){return Promise.resolve(null)},g.prototype.HandleExpandAndCollapseKeys=function(t,e,i,n){return!1},g.prototype.ModifyListItem=function(t,e){this.m_widget.m_contentHandler.IsHierarchical()&&!this.m_widget.isTabBar()||this.m_widget.getSingleFocusableElement(t).attr("role","tab")},g.prototype.UpdateAriaPropertiesOnSelectedItem=function(t,e){t.attr("aria-selected",e?"true":"false")},g.prototype.BeforeRenderComplete=function(){var t=this.m_widget.element.attr("role");if(t&&"presentation"!==t){this.m_widget.element.attr("role","presentation");var e=this.m_widget.m_contentHandler.IsHierarchical();!this.m_widget.isTabBar()&&e?this.m_root.attr("role",t):(this.m_root.hasClass(this.m_widget.getNavListVerticalStyleClass())&&this.m_root.attr("aria-orientation","vertical"),this.m_root.attr("role","tablist"))}},g.prototype.ItemInsertComplete=function(t,e){},g.prototype.ItemRemoveComplete=function(t){},g.prototype.HandleArrowKeys=function(t,e,i){return m.superclass.HandleArrowKeys.apply(this.m_widget,arguments)},g.prototype.IsArrowKey=function(t){return m.superclass.IsArrowKey.apply(this.m_widget,arguments)},g.prototype.GetState=function(t){return m.superclass.GetState.apply(this.m_widget,arguments)},g.prototype.SetState=function(t,e){m.superclass.SetState.apply(this.m_widget,arguments)},g.prototype.Init=function(t){this.m_root.addClass(this.m_widget.getNavListExpandedStyleClass()).addClass(this.m_widget.getNavListVerticalStyleClass())},g.prototype.IsSelectable=function(t){return m.superclass.IsSelectable.apply(this.m_widget,arguments)},g.prototype.RestoreItem=function(t,e,i){},g.prototype.SetOptions=function(t){},g.prototype.HandleBlur=function(t){return m.superclass.HandleBlur.apply(this.m_widget,arguments)},g.prototype.HandleFocus=function(t){return m.superclass.HandleFocus.apply(this.m_widget,arguments)},g.prototype.GetNodeBySubId=function(t){return null},g.prototype.GetSubIdByNode=function(t){return null},g.prototype.HandleResize=function(t,e){},g.prototype.NotifyAttached=function(){},g.prototype.GetAnimationEffect=function(t){return m.superclass.getAnimationEffect.apply(this.m_widget,arguments)},g.prototype.IsOptionUpdateAllowed=function(t,e,i){return!0},g.prototype.OptionUpdated=function(t,e,i){},g.prototype.BeforeInsertItem=function(){},g.prototype.HandleClick=function(t){},g.prototype.HandleKeydown=function(t){},g.prototype.HandleSelectionChange=function(t){};const p=function(t,e,i){p.superclass.constructor.call(this,t,e,i)};t.Object.createSubclass(p,g,"oj.CollapsibleNavListHandler"),t._registerLegacyNamespaceProp("CollapsibleNavListHandler",p),p.prototype.Destroy=function(){this.m_root.removeClass(this.m_widget.getNavListCollapsibleStyleClass()).removeClass(this.m_widget.getNavListVerticalStyleClass())},p.prototype.Init=function(t){this.m_root.addClass(this.m_widget.getNavListCollapsibleStyleClass()).addClass(this.m_widget.getNavListVerticalStyleClass())},p.prototype.Expand=function(t,e,i){return m.superclass.AnimateExpand.apply(this.m_widget,arguments)},p.prototype.Collapse=function(t,e,i,n){return m.superclass.AnimateCollapse.apply(this.m_widget,arguments)},p.prototype.HandleExpandAndCollapseKeys=function(t,e,i,s){var o=i.children("."+this.m_widget.getGroupStyleClass()).length>0;return e===this.m_widget.LEFT_KEY||e===this.m_widget.RIGHT_KEY?(e===this.m_widget.LEFT_KEY&&!this.m_widget.isRtl()||e===this.m_widget.RIGHT_KEY&&this.m_widget.isRtl()?this.m_widget.GetState(i)===this.m_widget.STATE_EXPANDED&&this.m_widget.CollapseItem(i,t,!0,s,!0,!0):this.m_widget.GetState(i)===this.m_widget.STATE_COLLAPSED&&this.m_widget.ExpandItem(i,t,!0,s,!0,!0,!0),!0):!(!o||e!==n.ui.keyCode.ENTER&&e!==n.ui.keyCode.SPACE)&&(!(i.length<=0)&&(this.m_widget.GetState(i)===this.m_widget.STATE_COLLAPSED?this.m_widget.ExpandItem(i,null,!0,s,!0,!0,!0):this.m_widget.GetState(i)===this.m_widget.STATE_EXPANDED&&this.m_widget.CollapseItem(i,null,!0,s,!0,!0),!0))};const v="aria-selected",C="oj-default",f=function(t,e,i){this.m_duringInit=!0,f.superclass.constructor.call(this,t,e,i),this.m_widget.GetOption(this.m_widget.OPTION_EDGE)===this.m_widget.OPTION_EDGE_BOTTOM&&this.m_root.addClass(this.m_widget.getNavListBottomEdgeStyleClass())};t.Object.createSubclass(f,g,"oj.HorizontalNavListHandler"),t._registerLegacyNamespaceProp("HorizontalNavListHandler",f),f.prototype.Destroy=function(){this.m_root.removeClass(this.m_widget.getNavListExpandedStyleClass()).removeClass(this.m_widget.getHorizontalNavListStyleClass()).removeClass(this.m_widget.getNavListBottomEdgeStyleClass()),this.m_root.find("."+this.m_widget.getDividerStyleClass()).remove(),this._destroyOverflowMenu(),null!=this.m_overflowMenuItem&&(this.m_overflowMenuItem.remove(),this.m_overflowMenuItem=null),this.m_overflowMenuItems=[],this.m_duringInit=!0},f.prototype.UpdateAriaPropertiesOnSelectedItem=function(t,e){t.attr(v,e?"true":"false")},f.prototype._isTabBar=function(){return this.m_widget.isTabBar()},f.prototype._getScrollableParent=function(t,e){for(var i,n=window.getComputedStyle(t).position,s="absolute"===n,o=e?/(auto|scroll|hidden)/:/(auto|scroll)/,a=!1,l=t.parentElement;l&&!a;){const{overflow:t,overflowY:e,overflowX:n,position:r}=window.getComputedStyle(l);s&&"static"===r||!o.test(t+e+n)||(i=l,a=!0),l=l.parentElement}return"fixed"!==n&&i?i:t.ownerDocument.documentElement||document.documentElement},f.prototype._isElementInsideHorizontalScrollerBounds=function(t,e){var i,n;if(e===document.documentElement)i=0,n=document.documentElement.clientWidth;else{var s=e.getBoundingClientRect();i=s.left,n=s.right}var o=t.getBoundingClientRect();return o.left<=n&&o.right<=n&&o.left>=i&&o.right>=i},f.prototype.HandleArrowKeys=function(t,e,i){"ArrowLeft"===t||"Left"===t||t===n.ui.keyCode.LEFT?t=this.m_widget.isRtl()?n.ui.keyCode.DOWN:n.ui.keyCode.UP:"ArrowRight"!==t&&"Right"!==t&&t!==n.ui.keyCode.RIGHT||(t=this.m_widget.isRtl()?n.ui.keyCode.UP:n.ui.keyCode.DOWN);var s=m.superclass.HandleArrowKeys.call(this.m_widget,t,e,i),o=this.m_widget.m_active.elem;return this._scrollableParent||(this._scrollableParent=this._getScrollableParent(this.m_root[0],!0)),this._isElementInsideHorizontalScrollerBounds(o[0],this._scrollableParent)||o[0].scrollIntoView({block:"nearest",inline:"nearest"}),s},f.prototype.IsArrowKey=function(t){return"ArrowUp"===t||"Up"===t||t===this.m_widget.UP_KEY||"ArrowDown"===t||"Down"===t||t===this.m_widget.DOWN_KEY||"ArrowLeft"===t||"Left"===t||t===this.m_widget.LEFT_KEY||"ArrowRight"===t||"Right"===t||t===this.m_widget.RIGHT_KEY},f.prototype.ModifyListItem=function(t,e){this.m_widget.getSingleFocusableElement(t).attr("role","tab")},f.prototype.BeforeRenderComplete=function(){var t=this;this.m_root.attr("role","tablist"),this.m_widget.element.attr("role","presentation"),"condense"===this.m_widget.GetOption("layout")&&(this.m_root.hasClass(this.m_widget.getCondenseStyleClass())||this.m_root.addClass(this.m_widget.getCondenseStyleClass()));var e=this.m_widget.element.find("."+this.m_widget.getItemElementStyleClass()+":visible");e.each(function(i){var s=n(this);i>0&&t._addSeparator(this,i),i===e.length-1?s.addClass(t.m_widget.getLastItemStyleClass()):s.removeClass(t.m_widget.getLastItemStyleClass())}),this.m_duringInit&&(this.m_duringInit=!1,this._handleOverflow())},f.prototype._addSeparator=function(t,e){var i=n(t),s=i.prev();e>0&&s.length&&!s.is("li."+this.m_widget.getDividerStyleClass())&&i.before('<li role="presentation" class="'+this.m_widget.getDividerStyleClass()+'"></li>')},f.prototype.ItemInsertComplete=function(t,e){this._addSeparator(t,e.index),this._handleOverflow()},f.prototype.ItemRemoveComplete=function(t){var e=n(t),i=e.prev();if(i.length&&i.is("li."+this.m_widget.getDividerStyleClass()))i.remove();else{var s=e.next();s.is("li."+this.m_widget.getDividerStyleClass())&&s.remove()}this._handleOverflow()},f.prototype.IsSelectable=function(t){var e=v;return!(this.m_overflowMenuItem&&this.m_overflowMenuItem[0]===n(t)[0])&&this.m_widget.getFocusItem(n(t))[0].hasAttribute(e)},f.prototype.Init=function(t){this.m_root.addClass(this.m_widget.getNavListExpandedStyleClass()).addClass(this.m_widget.getHorizontalNavListStyleClass()),this.m_overflowMenuItems=[]},f.prototype.HandleClick=function(t){n(t.target).closest("."+this.m_widget.getOverflowItemStyleClass()+" a."+this.m_widget.getItemContentStyleClass()).length>0&&this._launchOverflowMenu(t)},f.prototype.HandleKeydown=function(t){n(t.target).closest("."+this.m_widget.getOverflowItemStyleClass()+" a."+this.m_widget.getItemContentStyleClass()).length>0&&t.keyCode===n.ui.keyCode.SPACE&&this._launchOverflowMenu(t)},f.prototype.NotifyAttached=function(){this._handleOverflow()},f.prototype.HandleResize=function(t,e){this.m_ignoreNextResize?this.m_ignoreNextResize=!1:this._handleOverflow()},f.prototype.SetOptions=function(t){var e,i,n=this.m_widget.GetOption("overflow"),s=this.m_widget.GetOption("truncation");t.overflow&&n!==t.overflow&&(e=t.overflow),t.truncation&&s!==t.truncation&&(i=t.truncation),(e||i)&&this._handleOverflow(e,i)},f.prototype.HandleSelectionChange=function(t){this.m_overflowMenuItem&&(null!=t&&"none"===t.style.display?this._highlightUnhighlightMoreItem(!0):this._highlightUnhighlightMoreItem(!1))},f.prototype.GetAnimationEffect=function(t){return"add"===t||"remove"===t?m.superclass.getAnimationEffect.call(this.m_widget,t+"HorizontalItem"):m.superclass.getAnimationEffect.apply(this.m_widget,arguments)},f.prototype.GetNodeBySubId=function(t){var e=null;if(t.subId===this.m_widget.getItemSubIdKey()&&this.m_overflowMenuItems.length>0)for(var i=this._getOverflowMenu(),s=t.key,o=i.find(".oj-menu-item"),a=0;a<o.length;a++)if(this.m_widget.compareValues(n(o[a]).data("key"),s)){e=o[a],this._launchOverflowMenu(null);break}return e},f.prototype.GetSubIdByNode=function(t){var e=null,i=n(t).closest(".oj-menu-item");if(null!==this._getOverflowMenu()&&i.closest("."+this.m_widget.getOverflowMenuStyleClass())[0]!==this._getOverflowMenu()[0])return null;if(null!=i&&i.length>0){var s=i.data("key");null!=s&&(e={subId:this.m_widget.getItemSubIdKey(),key:s})}return e},f.prototype.OptionUpdated=function(t,e,i){"selection"===t&&this._toggleOverflowBtnSelection(e)},f.prototype.IsOptionUpdateAllowed=function(t,e,i){return"currentItem"!==t||!this.m_overflowMenuItem||this.m_overflowMenuItem.attr("id")!==e};var S=function(t,e,i,n,s){this._overflow=e,this._truncation=i,this._items=t,this._display=n,this._navlistHandler=s};f.prototype._handleOverflow=function(t,e){var i=-1,n=this._getItems();if(0!==n.length){var s=this.m_widget.GetOption("display");t||(t=this.m_widget.GetOption("overflow")),e||(e=this.m_widget.GetOption("truncation"));var o=new S(n,t,e,s,this);if(!o.shouldHandleOverflow())return o.unApplyTruncation(),void this._releaseContainerWidth();this.showAllItems(n,t),o.unApplyTruncation(),o.checkForOverflow()&&o.applyTruncation()&&(i=o.getOverflowThreshold()),this._applyThreshold(i),this._releaseContainerWidth()}},f.prototype.BeforeInsertItem=function(){this._fixContainerWidth()},f.prototype._fixContainerWidth=function(){var t=this.m_widget.getListContainer(),e=t[0].getBoundingClientRect().width;0!==e&&(this.m_freezedContainerWidth=e,t.css("maxWidth",e))},f.prototype._releaseContainerWidth=function(){this.m_widget.getListContainer().css("maxWidth","none"),this.m_freezedContainerWidth&&(this.m_ignoreNextResize=!0,this.m_freezedContainerWidth=null)},f.prototype.showAllItems=function(t,e){var i=this;"popup"===e&&this._showOrHideItem(this._getOverflowMenuButton(),!0),t.each(function(t,e){i._showOrHideItem(n(e),!0)})},f.prototype._getItems=function(){return this.m_root.find("."+this.m_widget.getItemElementStyleClass()+":not(."+this.m_widget.getOverflowItemStyleClass()+")")},f.prototype._hasSeparators=function(){return this.m_root.hasClass(this.m_widget.getNavListItemsDividerStyleClass())},f.prototype._showOrHideItem=function(t,e){var i;this._hasSeparators()&&(i=t.prev("."+this.m_widget.getDividerStyleClass())),e?(t.show(),i&&i.show()):(t.hide(),i&&i.hide())},f.prototype._applyThreshold=function(t){var e,i,s=this,o=this._getItems(),a=[];if(0!==o.length){this.m_root.find("."+this.m_widget.getLastItemStyleClass()).removeClass(this.m_widget.getLastItemStyleClass()),-1===t||t>=o.length?this.m_overflowMenuItem&&this._showOrHideItem(this.m_overflowMenuItem,!1):(this._addSeparator(this._getOverflowMenuButton(),o.length),this._showOrHideItem(this._getOverflowMenuButton(),!0),i=!0),o.each(function(i,o){var l=n(o);if(-1!==t&&t<=i){l.hasClass("oj-focus")&&s.m_widget.ActiveAndFocus(s._getOverflowMenuButton(),null),l.hasClass("oj-selected")&&s._highlightUnhighlightMoreItem(!0),s._showOrHideItem(l,!1);var r={};a.push(r),r.key=s.m_widget.GetKey(o),r.label=s._getItemLabel(l),l.hasClass("oj-disabled")&&(r.disabled=!0)}else e=l,s._showOrHideItem(l,!0),l.hasClass("oj-selected")&&s.m_overflowMenuItem&&s._highlightUnhighlightMoreItem(!1),s.m_overflowMenuItem&&s.m_overflowMenuItem.hasClass("oj-focus")&&s.m_widget.compareValues(s.m_widget.GetKey(o),s.m_widget.GetOption("currentItem"))&&s.m_widget.ActiveAndFocus(e,null)}),i?this._getOverflowMenuButton().addClass(this.m_widget.getLastItemStyleClass()):e.addClass(this.m_widget.getLastItemStyleClass()),this.m_overflowMenuItems=a,this.m_widget.ClearCache();var l=this.m_overflowMenu&&this.m_overflowMenu.is(":visible");this._destroyOverflowMenu(),l&&this._launchOverflowMenu(null)}},f.prototype._highlightUnhighlightMoreItem=function(t){var e=this._getOverflowMenuButton();t?e.addClass("oj-selected").removeClass(C):e.removeClass("oj-selected").addClass(C)},f.prototype._destroyOverflowMenu=function(){this.m_overflowMenu&&(this.m_overflowMenu.ojMenu("destroy"),this.m_overflowMenu.remove(),this.m_overflowMenu=null)},f.prototype._getOverflowMenuButton=function(){if(!this.m_overflowMenuItem){var t=n(document.createElement("li")),e=n(document.createElement("a")),i=n(document.createElement("span")),s=this._getItems();t.uniqueId().attr("role","presentation").addClass(this.m_widget.getItemElementStyleClass()).addClass(this.m_widget.getItemStyleClass()).addClass(this.m_widget.getOverflowItemStyleClass()).addClass(C).append(e),e.addClass(this.m_widget.getFocusedElementStyleClass()).addClass(this.m_widget.getItemContentStyleClass()),e.attr("role","tab").attr("aria-haspopup","true").attr(v,"false").attr("tabindex","-1").attr("href","#").append(i),l.disableElement(e[0]),i.addClass(this.m_widget.getItemIconStyleClass()).addClass("oj-fwk-icon").addClass(this.m_widget.getOverflowItemIconStyleClass());var o=this.m_widget.ojContext.getTranslatedString("overflowItemLabel");i.attr("aria-label",o),t[0].key=t.attr("id"),this.m_root.find("."+this.m_widget.GetStyleClass()).append(t),this._addSeparator(t,s.length),this.m_overflowMenuItem=t}return this.m_overflowMenuItem},f.prototype._getOverflowMenu=function(){var t=this,e=this.m_overflowMenuItems;if(0===e.length)return null;if(!this.m_overflowMenu){var i=n(document.createElement("ul"));i.addClass(this.m_widget.getOverflowMenuStyleClass()).hide(),this.m_root.append(i);for(var s=0;s<e.length;s++){var o=n(document.createElement("li")),a=n(document.createElement("a"));a.attr("href","#").text(e[s].label),o.data("key",e[s].key),e[s].disabled&&o.addClass("oj-disabled"),o.append(a),i.append(o)}i.ojMenu({openOptions:{display:"auto"},open:t.__handleOverflowMenuOpen.bind(t),close:t.__handleOverflowMenuClose.bind(t),select:t.__handleOverflowMenuSelection.bind(t)}),this.m_overflowMenu=i}return this.m_overflowMenu},f.prototype._launchOverflowMenu=function(t){this._getOverflowMenu().is(":visible")||this._getOverflowMenu().ojMenu("open",t,{launcher:this._getOverflowMenuButton(),initialFocus:"firstItem",position:{my:"end bottom",at:"end top",collision:"flipfit"}})},f.prototype._toggleOverflowBtnSelection=function(t){var e;if(this.m_overflowMenuItem&&this.m_overflowMenuItems.length>0){if(t)for(var i=0;i<this.m_overflowMenuItems.length;i++)if(this.m_widget.compareValues(this.m_overflowMenuItems[i].key,t)){e=!0;break}if(e){const e=this.m_widget.element[0].querySelectorAll("."+this.m_widget.getItemElementStyleClass()+".oj-selected");for(let i=0;i<e.length-1;i++)this.m_widget.compareValues(e[i].key,t)||e[i].classList.remove("oj-selected")}else this._highlightUnhighlightMoreItem(!1)}},f.prototype.__handleOverflowMenuOpen=function(t){this._getOverflowMenuButton().find("."+this.m_widget.getItemContentStyleClass()).attr("tabindex","0")},f.prototype.__handleOverflowMenuClose=function(t){var e=this.m_widget.ojContext.option("selection");this._toggleOverflowBtnSelection(e),this._getOverflowMenuButton().find("."+this.m_widget.getItemContentStyleClass()).focus()},f.prototype.__handleOverflowMenuSelection=function(t,e){var i=e.item.data("key"),s={selection:i},o=this.m_widget.FindElementByKey(i);if(!this.m_widget.isTabBar()){var a=this.m_widget.GetOption("selection")[0];this.m_widget.FireSelectionAction(t,o,a)}this.m_widget.HandleSelectionOption(s);var l=s.selection;l&&this.m_widget.SetOption("selection",l,{_context:{originalEvent:t,internalSet:!0,extraData:{items:n(o)}},changed:!0})},f.prototype._getItemLabel=function(t){var e=t.find("."+this.m_widget.getItemTitleStyleClass()+":first");return e.length>0?e.text():t.find("."+this.m_widget.getItemLabelStyleClass()+":first").text()},S.prototype._TEXT_WIDTH_KEY="textWidth",S.prototype._ITEM_WIDTH_KEY="itemWidth",S.prototype._getOverflowMenuButton=function(){return this._navlistHandler._getOverflowMenuButton()},S.prototype._getWidget=function(){return this._navlistHandler.m_widget},S.prototype.shouldHandleOverflow=function(){return"popup"===this._overflow||"progressive"===this._truncation},S.prototype.unApplyTruncation=function(){var t=this;this._items.each(function(e,i){n(i).find("."+t._getWidget().getItemLabelStyleClass()).css("max-width","")})},S.prototype.checkForOverflow=function(){return!!this.shouldHandleOverflow()&&(this._overflowData||(this._overflowData=this._collectOverflowData()),this._isOverflowed(this._overflowData.containerEdgePos,this._overflowData.itemEdgePos,0))},S.prototype.applyTruncation=function(){"progressive"===this._truncation&&this._applyLabelMaxWidth(this._overflowData);var t=this._items.last()[0].getBoundingClientRect()["ltr"===s.getReadingDirection()?"right":"left"];return this._isOverflowed(this._overflowData.containerEdgePos,t,0)},S.prototype.getOverflowThreshold=function(){var t=-1;return"popup"===this._overflow&&(t=this._calculateThreshold(this._overflowData)),t},S.prototype._collectOverflowData=function(){var t,e,i=s.getReadingDirection(),n="ltr"===i?"right":"left",o=this._getWidget().ojContext.element,a=this._items.last();"progressive"===this._truncation&&(this._calculateItemWidths(),t=this._calculateItemNonTextWidth());var l=o[0].getBoundingClientRect()[n],r=o[0].getBoundingClientRect().width;if("popup"===this._overflow){var h=this._getOverflowMenuButton()[0],d=h.getBoundingClientRect();const t=window.getComputedStyle(h);let n=0;this._navlistHandler._isTabBar()||"icons"!==this._display||(n="ltr"===i?t.marginLeft:t.marginRight),this._navlistHandler._isTabBar()&&"rtl"===i&&(n=t.marginRight),e=d.width+parseInt(n,10)}return{containerEdgePos:l,containerWidth:r,overflowItemWidth:e,itemEdgePos:a[0].getBoundingClientRect()[n],itemNonTextWidth:t}},S.prototype._calculateItemWidths=function(){var t=this;this._items.each(function(e,i){var s=n(i),o=s.find("."+t._getWidget().getItemLabelStyleClass())[0].getBoundingClientRect().width;s.data(t._TEXT_WIDTH_KEY,o),s.data(t._ITEM_WIDTH_KEY,i.getBoundingClientRect().width)})},S.prototype._calculateItemNonTextWidth=function(){var t=this._items,e=this;this._getWidget().GetRootElement().find("."+this._getWidget().getHasIconsStyleClass()).lenght>0&&(t=t.filter(function(t,i){return n(i).find("."+e._getWidget().getItemIconStyleClass()).length>0}));var i=t.filter(function(t,i){return n(i).find("."+e._getWidget().getRemovableStyleClass()).length>0}),s=i&&i.length>0?i.last():t.last(),o=s.data(e._TEXT_WIDTH_KEY);return s.data(e._ITEM_WIDTH_KEY)-o},S.prototype._isOverflowed=function(t,e,i){var n=i||0;return"ltr"===s.getReadingDirection()?e-t+n>.1:t-e+n>.1},S.prototype._calculateThreshold=function(t){for(var e=this._items,i=s.getReadingDirection(),n="ltr"===i?"right":"left",o=e.length-1,a=e[o].getBoundingClientRect()[n];this._isOverflowed(t.containerEdgePos,a,t.overflowItemWidth)&&o>0;)if(o-=1,this._navlistHandler._isTabBar()||"icons"!==this._display){const t=window.getComputedStyle(e[o]);let s=0;s=this._navlistHandler._isTabBar()||"ltr"===i?t.marginRight:t.marginLeft,a=e[o].getBoundingClientRect()[n]+parseInt(s,10)}else a=e[o].getBoundingClientRect()[n];return o+1},S.prototype._applyLabelMaxWidth=function(t){var e=this._items,i=this,s=this._getMinLabelWidth(this._items),o=t.containerWidth/e.length-t.itemNonTextWidth;o<s&&(o=s);var a=0,l=0;e.each(function(t,e){var s=n(e).data(i._TEXT_WIDTH_KEY);s<o?a+=o-s:l+=s}),e.each(function(t,e){var s=n(e).data(i._TEXT_WIDTH_KEY),r=s;s>o&&(r=o+a*s/l),n(e).find("."+i._getWidget().getItemLabelStyleClass()).css({"max-width":r+"px"})})},S.prototype._getMinLabelWidth=function(t){var e=window.getComputedStyle(t.first().find("."+this._getWidget().getItemLabelStyleClass())[0],null).getPropertyValue("min-width");return e.indexOf("px")>0?parseInt(e.substring(0,e.length-2),10):0};const I="oj-focus-ancestor",y="aria-hidden",E="aria-describedby",L="aria-expanded",b="oj-navigationlist-hierarchical-button",T="oj-navigationlist-hierarchical-menu",w="oj-navigationlist-previous-link",O=function(t,e,i){O.superclass.constructor.call(this,t,e,i),this.m_expanded=[]};t.Object.createSubclass(O,p,"oj.SlidingNavListHandler"),t._registerLegacyNamespaceProp("SlidingNavListHandler",O),O.prototype.Destroy=function(){this.m_root.removeClass("oj-navigationlist-slider").removeClass(this.m_widget.getNavListVerticalStyleClass()),this._toolbar.remove()},O.prototype._slideAnimation=function(t,e,i,n,s){var o=this,a=this.m_widget.getListContainer(),l=a.hasClass(I);l&&e&&a.removeClass(I);var r=e?"sliderExpand":"sliderCollapse";this.m_widget.StartAnimation(a.get(0),r,this.m_widget.getAnimationEffect(r)).then(function(){o._slideAnimationComplete(t,e,i,n,l),s(null)})},O.prototype._slideAnimationComplete=function(t,e,i,n,s){null!==this.m_widget.m_contentHandler&&(i&&(s&&this.m_widget.getListContainer().addClass(I),n&&0===n.button&&this.m_widget.AvoidFocusHighLight(!0),i.length>0&&this.m_widget.SetCurrentItem(i,n),this.m_widget.AvoidFocusHighLight(!1)),e?this.m_widget.AnimateExpandComplete(t.children("."+this.m_widget.getGroupStyleClass())):this.m_widget.AnimateCollapseComplete(t.children("."+this.m_widget.getGroupStyleClass())))},O.prototype.Expand=function(t,e,i){var s,o=new Promise(function(t){s=t}),a=n(t).parents(".oj-navigationlist-item-element:first"),l=a.children("."+this.m_widget.getGroupStyleClass()),r=null,h=a.closest("."+this.m_widget.SLIDING_NAVLIST_CURRENT_STYLE_CLASS);return h.length>0&&(h.removeClass(this.m_widget.SLIDING_NAVLIST_CURRENT_STYLE_CLASS),a.addClass(this.m_widget.SLIDING_NAVLIST_CURRENT_STYLE_CLASS),r=l.find("."+this.m_widget.getItemElementStyleClass()+":eq(0)"),this._updateHMenuOnExpand(a)),e?this._slideAnimation(a,!0,r,i,s):(this._slideAnimationComplete(a,!0,r,i,!1),s(null)),a.siblings().attr(y,"true"),a.children("."+this.m_widget.getGroupItemStyleClass()).children("."+this.m_widget.getItemContentStyleClass()).attr(y,"true"),l.removeAttr(y),t.css("display",""),a.addClass("oj-skipfocus"),o},O.prototype._updateHMenuOnExpand=function(t){var e=t.parentsUntil(this.m_widget.element,"."+this.m_widget.getItemElementStyleClass());e=e.get().reverse(),e=n(e.concat(t)),this.m_expanded=[],this._emptyHviewMenu(),e.each(function(t,e){var i;i=0===t?this.m_widget.getRootLabel():this.m_widget.getItemLabel(this.m_expanded[t-1]);var s=n(e);this._addItemToHviewMenu(this.m_widget.GetKey(s[0]),this.m_widget.getItemLabel(s),i),this.m_expanded.push(s)}.bind(this))},O.prototype.Collapse=function(t,e,i,n){var s,o=new Promise(function(t){s=t}),a=t.children("."+this.m_widget.getGroupStyleClass()),l=t.parent();return t.children("."+this.m_widget.getGroupItemStyleClass()).children("."+this.m_widget.getItemContentStyleClass()).removeAttr(y),a.attr(y,"true"),t.siblings().removeAttr(y),t.removeClass("oj-skipfocus"),t.removeClass(this.m_widget.SLIDING_NAVLIST_CURRENT_STYLE_CLASS),0===t.closest("."+this.m_widget.SLIDING_NAVLIST_CURRENT_STYLE_CLASS).length&&(l.closest("."+this.m_widget.getItemElementStyleClass()).addClass(this.m_widget.SLIDING_NAVLIST_CURRENT_STYLE_CLASS),this.m_widget.element.is(l)&&this.m_widget.element.addClass(this.m_widget.SLIDING_NAVLIST_CURRENT_STYLE_CLASS)),i?this._slideAnimation(t,!1,a.parent(),n,s):(this._slideAnimationComplete(t,!1,a.parent(),n,!1),s(null)),this._updateHMenuOnCollapse(e),o},O.prototype._updateHMenuOnCollapse=function(t){var e=-1;this.m_expanded.forEach(function(i,n){var s=this.m_widget.GetKey(i[0]);t===s&&(e=n)}.bind(this)),e>-1&&this.m_expanded.splice(e),this._removeItemFromHviewMenu(t)},O.prototype.UpdateAriaPropertiesOnSelectedItem=function(t,e){e?t.attr(E,this._selectedLabelId):t.removeAttr(E)},O.prototype.GetState=function(t){var e=this.m_widget.getFocusItem(t).attr(L);return"true"===e?this.m_widget.STATE_EXPANDED:"false"===e?this.m_widget.STATE_COLLAPSED:this.m_widget.STATE_NONE},O.prototype.SetState=function(t,e){e===this.m_widget.STATE_EXPANDED?(this.m_widget.getFocusItem(t).attr(L,"true"),t.removeClass(this.m_widget.COLLAPSED_STYLE_CLASS).addClass(this.m_widget.EXPANDED_STYLE_CLASS)):e===this.m_widget.STATE_COLLAPSED&&(this.m_widget.getFocusItem(t).attr(L,"false"),t.removeClass(this.m_widget.EXPANDED_STYLE_CLASS).addClass(this.m_widget.COLLAPSED_STYLE_CLASS))},O.prototype.ModifyListItem=function(t,e){var i=this.m_widget.getFocusItem(t);t.attr("role","presentation"),i.attr("role","menuitem"),e.attr("id")||e.uniqueId(),i.removeAttr("aria-selected");var n=t.children("."+this.m_widget.getGroupStyleClass());n.length>0&&(i.attr("aria-haspopup","true"),n.attr("role","menu"),n.css("display",""),t.removeAttr(L),i.attr(L,"false"))},O.prototype.BeforeRenderComplete=function(){this.m_root.attr("role","group"),this.m_widget.element.attr("role","menu"),this.m_widget.element.attr("aria-labelledby",this._headerLabel.attr("id"))},O.prototype.Init=function(t){this.m_root.addClass("oj-navigationlist-slider").addClass(this.m_widget.getNavListVerticalStyleClass()),t.element.addClass("oj-navigationlist-current"),this._buildSlidingNavListHeader(t),this._initializeHierarchicalView()},O.prototype.HandleClick=function(t){n(t.target).closest(".oj-navigationlist-previous-link, .oj-navigationlist-previous-button").length>0&&this.CollapseCurrentList(t)},O.prototype.IsSelectable=function(t){return"menuitem"===this.m_widget.getFocusItem(n(t))[0].getAttribute("role")&&!this.m_widget.getFocusItem(n(t))[0].hasAttribute("aria-selected")},O.prototype.HandleKeydown=function(t){n(t.target).closest(".oj-navigationlist-previous-link, .oj-navigationlist-previous-button").length>0&&t.keyCode===n.ui.keyCode.ENTER&&this.CollapseCurrentList(t),n(t.target).closest("."+this.m_widget.GetStyleClass()).length>0&&(t.keyCode!==n.ui.keyCode.ESCAPE||t.isDefaultPrevented()||this.CollapseCurrentList(t))},O.prototype._buildSlidingNavListHeader=function(t){this._toolbar=n(document.createElement("div")),this._toolbar.addClass("oj-navigationlist-toolbar"),this._previousLink=n(document.createElement("a")),this._prevButton=n(document.createElement("a")),this._prevButton.addClass("oj-navigationlist-previous-button"),this._prevButton.css("visibility","hidden").attr("tabindex","-1"),this._previousLink.addClass(w).attr("tabindex","-1"),this._headerLabel=n(document.createElement("label")),this._headerLabel.uniqueId(),this._headerLabel.addClass("oj-navigationlist-current-header").text(this.m_widget.getRootLabel()),this._vSeparator=n(document.createElement("span")),this._vSeparator.attr("role","separator").attr("aria-orientation","vertical").addClass("oj-navigationlist-toolbar-separator"),this._hviewBtn=n(document.createElement("button")),this._hviewBtn.addClass(b).attr("tabindex","-1"),this._hviewMenu=n(document.createElement("ul")),this._hviewMenu.addClass(T).hide();var e=n(document.createElement("label"));e.uniqueId().addClass("oj-helper-hidden-accessible").attr(y,"true"),this._selectedLabelId=e.attr("id"),e.text(this.m_component.getTranslatedString("selectedLabel")),this._previousLink.append(this._headerLabel),this._toolbar.append(this._prevButton),this._toolbar.append(this._previousLink).append(this._vSeparator).append(this._hviewBtn).append(this._hviewMenu).append(e),this.m_root.prepend(this._toolbar),this._showOrHideHierarchyMenu(t.hierarchyMenuDisplayThresholdLevel)},O.prototype.CollapseCurrentList=function(t){var e=this.m_expanded[this.m_expanded.length-1];e&&this.m_widget.CollapseItem(e,t,!0,null,!0,!0)},O.prototype._initializeHierarchicalView=function(){var t=this,e=this._hviewMenu.uniqueId().attr("id");this._hviewMenu.ojMenu({openOptions:{position:{my:"end top",at:"end bottom"}},select:function(e,i){var s=i.item.nextAll(),o=t.m_expanded,a=i.item.data("key");for(t.m_widget.signalTaskStart();o.length>0;){var l=o[o.length-1],r=t.m_widget.GetKey(l[0]);if(t.m_widget.CollapseItem(n(l),e,!0,r,!0,!0),t.m_widget.compareValues(a,r))break}s.remove(),i.item.remove(),t._hviewMenu.ojMenu("refresh"),t.m_widget.signalTaskEnd()}}),this._hviewBtn.ojButton({label:this.m_component.getTranslatedString("hierMenuBtnLabel"),display:"icons",icons:{start:"oj-fwk-icon oj-hier-icon"},menu:"#"+e,disabled:!0,chroming:"half"}),this._prevButton.ojButton({label:this.m_component.getTranslatedString("previousIcon"),display:"icons",icons:{start:"oj-navigationlist-previous-icon oj-component-icon oj-clickable-icon-nocontext"},chroming:"half"})},O.prototype._emptyHviewMenu=function(){this._hviewMenu&&this._hviewMenu.find("li").remove()},O.prototype._addItemToHviewMenu=function(t,e,i){var s;if(this._hviewBtn){var o=this._hviewMenu.find("li").length,a=n(document.createElement("li")),l=n(document.createElement("a"));if(l.attr("href","#"),a.append(l),o>0){for(s=0;s<o;s++)s>0&&l.append(n(document.createElement("span")).addClass("oj-navigationlist-hvitem-space"));l.append(n(document.createElement("span")).addClass("oj-menu-item-icon oj-icon oj-navigationlist-level-indicator"))}var r=n(document.createElement("span")).addClass("oj-navigationlist-hierarchical-menu-label");r.text(i),l.append(r),a.data("key",t),this._hviewMenu.append(a),this._hviewMenu.ojMenu("refresh"),this._showOrHideHierarchyMenu(this.m_widget.GetOption("hierarchyMenuDisplayThresholdLevel")),this._hviewBtn.ojButton("option","disabled",!1),this._prevButton.css("visibility","visible"),this.m_widget.getListContainer().hasClass(I)&&this._prevButton.attr("tabindex","0"),this._headerLabel.text(e)}},O.prototype.SetOptions=function(t){void 0!==t.hierarchyMenuDisplayThresholdLevel&&(this.m_widget.GetOption("hierarchyMenuDisplayThresholdLevel")!==t.hierarchyMenuDisplayThresholdLevel&&this._showOrHideHierarchyMenu(t.hierarchyMenuDisplayThresholdLevel))},O.prototype._showOrHideHierarchyMenu=function(t){var e=this._hviewMenu.find("li").length;-1===t||e<t?(this._vSeparator.css("visibility","hidden"),this._hviewBtn[0]===document.activeElement&&this.m_root.focusin(),this._hviewBtn.css("visibility","hidden")):e>=t&&(this._vSeparator.css("visibility","visible"),this._hviewBtn.css("visibility","visible"))},O.prototype._removeItemFromHviewMenu=function(t){var e,i;this._hviewBtn&&(this._hviewMenu.find("li").each(function(s,o){var a=n(o);a.data("key")===t?(a.remove(),i=a.children("a").text(),e=!0):e&&a.remove()}),this._hviewMenu.ojMenu("refresh"),this._showOrHideHierarchyMenu(this.m_widget.GetOption("hierarchyMenuDisplayThresholdLevel")),0===this._hviewMenu.children("li").length?(this._hviewBtn.ojButton("option","disabled",!0),this._prevButton.css("visibility","hidden"),this._prevButton.attr("tabindex","-1"),this._headerLabel.text(this.m_widget.getRootLabel())):this._headerLabel.text(i))},O.prototype.RestoreItem=function(t,e,i){e.removeAttr("role").removeAttr(L).removeAttr(E).removeAttr(y)},O.prototype._makeToolbarItemsFocusable=function(t){t?(this._hviewMenu.find("li").length&&this._prevButton.attr("tabindex","0"),this._hviewBtn.attr("tabindex","0")):(this._prevButton.attr("tabindex","-1"),this._hviewBtn.attr("tabindex","-1"))},O.prototype.HandleFocus=function(t){n.contains(this._toolbar.get(0),t.target)||this._hviewMenu.get(0)===t.relatedTarget||(this._makeToolbarItemsFocusable(!0),m.superclass.HandleFocus.apply(this.m_widget,arguments))},O.prototype.HandleBlur=function(t){n.contains(this._toolbar.get(0),t.relatedTarget)||this._hviewMenu.get(0)===t.relatedTarget?this.m_widget.UnhighlightActive():(null!=t.relatedTarget&&n.contains(this.m_root.get(0),t.relatedTarget)||this._makeToolbarItemsFocusable(!1),m.superclass.HandleBlur.apply(this.m_widget,arguments))},O.prototype.GetNodeBySubId=function(t){return t.subId===w?this._prevButton?this._prevButton[0]:null:t.subId===b?this._hviewBtn?this._hviewBtn[0]:null:t.subId===T&&this._hviewMenu?this._hviewMenu[0]:null},O.prototype.GetSubIdByNode=function(t){return n(t).closest(this._prevButton).length>0?{subId:w}:n(t).closest(this._hviewBtn).length>0?{subId:b}:n(t).closest(this._hviewMenu).length>0?{subId:T}:null}});
//# sourceMappingURL=ojnavigationlist.js.map