/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["ojs/ojcore-base","jquery","ojs/ojcontext","ojs/ojconfig","ojs/ojthemeutils","ojs/ojcomponentcore","ojs/ojanimation","ojs/ojlogger","ojs/ojdomutils","ojs/ojfocusutils","ojdnd"],function(e,t,i,n,r,s,a,o,l,h,u){"use strict";e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e,t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,i=i&&Object.prototype.hasOwnProperty.call(i,"default")?i.default:i,h=h&&Object.prototype.hasOwnProperty.call(h,"default")?h.default:h;var d={properties:{reorderHandle:{type:"string"},translations:{type:"object",value:{},properties:{labelCut:{type:"string"},labelPasteAfter:{type:"string"},labelPasteBefore:{type:"string"}}}},methods:{getProperty:{},insertTile:{},refresh:{},removeTile:{},resizeTile:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojAnimateEnd:{},ojAnimateStart:{},ojBeforeInsert:{},ojBeforeRemove:{},ojBeforeReorder:{},ojBeforeResize:{},ojInsert:{},ojRemove:{},ojReorder:{},ojResize:{}},extension:{}};function _(e,t,i,n,r,s){var a=_;null==a._agentTypeAndVersion&&(a._agentTypeAndVersion=a._getAgentTypeAndVersion(navigator.userAgent)),this._elem=e,this._rtl=t,this._automationEnabled=i,this._tilesSelector=n.tiles,this._transitionShowFromStyleClass=r.transitionShowFromStyleClass,this._addStyleClassNameFunc=s.addStyleClassName,this._removeStyleClassNameFunc=s.removeStyleClassName,this._getSizeStyleClassNameFunc=s.getSizeStyleClassName,this._getTileSpanFunc=s.getTileSpan,this._showTileOnEndFunc=s.showTileOnEndFunc,this._hideTileOnEndFunc=s.hideTileOnEndFunc,this._startAnimationFunc=s.startAnimationFunc,this._layoutOnEndFunc=s.layoutOnEndFunc,this._layoutCycleOnStartFunc=s.layoutCycleOnStartFunc,this._layoutCycleOnEndFunc=s.layoutCycleOnEndFunc,this._sortTilesOriginalOrderFunc=s.sortTilesOriginalOrderFunc,this._subtreeAttachedFunc=s.subtreeAttached,this._subtreeDetachedFunc=s.subtreeDetached,this._addBusyStateFunc=s.addBusyState;var o=document.createElement("div"),l=o.style;l.display="inline-block",l.overflow="hidden",l.visibility="hidden";var h=document.createElement("div");(l=h.style).display="inline-block",o.appendChild(h),e.insertBefore(o,e.firstChild),this._sizeDivWrapper=o,this._sizeDiv=h;var u=this;this._hideTilesFunc=function(){u._hideTiles()},this._resolveBusyStateFunc=function(){u._resolveBusyState()}}d.extension._WIDGET_NAME="ojMasonryLayout",d.extension._TRACK_CHILDREN="immediate",e.CustomElementBridge.register("oj-masonry-layout",{metadata:d}),_.prototype.setup=function(e,t){var i=!1;return e?(i=!!this._layout(),this._reorderTilesForLayout()):(this._busyStateResolveFunc=this._addBusyStateFunc("performing layout (setup)"),this._layoutCycleOnStartFunc(),this._transitionStart(t),i=this._transitionLayout()),i},_.prototype.destroy=function(){this._resolveBusyState();for(var e=this._elem,t=this._getTileChildren(),i=0;i<t.length;i++){var n=t[i].style;this._rtl?n.right="":n.left="",n.top=""}e.removeChild(this._sizeDivWrapper),this._sizeDivWrapper=null,this._sizeDiv=null,this._hideTilesFunc=null,this._resolveBusyStateFunc=null,this._arMovedInfolets=null,this._arInfoletsToResize=null,this._arInfoletsToShow=null,this._arInfoletsToHide=null,this._arFireHideOnEnd=null,this._elem=null,this._addStyleClassNameFunc=null,this._removeStyleClassNameFunc=null,this._getSizeStyleClassNameFunc=null,this._getTileSpanFunc=null,this._showTileOnEndFunc=null,this._hideTileOnEndFunc=null,this._startAnimationFunc=null,this._layoutOnEndFunc=null,this._layoutCycleOnStartFunc=null,this._layoutCycleOnEndFunc=null,this._sortTilesOriginalOrderFunc=null,this._subtreeAttachedFunc=null,this._subtreeDetachedFunc=null,this._addBusyStateFunc=null},_.prototype.resizeTile=function(e,t){var i=this._elem.querySelector(e);this._arInfoletsToResize||(this._arInfoletsToResize=[]);var n=this._arInfoletsToResize;n.push(i),n.push(t),this._resizingInfolet=!0,this._queueRelayout()},_.prototype.insertTileDomElem=function(e,t){var i=this._getTileChildren();this._sortTilesOriginalOrderFunc(i);var n=null;t>=0&&t<i.length&&(n=i[t]),this._elem.insertBefore(e,n),this._queueRelayout()},_.prototype.showTile=function(e){var t=this._elem.querySelector(e);if(t){this._arInfoletsToShow||(this._arInfoletsToShow=[]),this._arInfoletsToShow.push(t),this._showingInfolets=!0;var i=_;this._layoutPhase!==i._PHASE_HIDE&&this._layoutPhase!==i._PHASE_LAYOUT?this._queueRelayout():this._showingInfolets=!1}},_.prototype.hideTile=function(e){var t=this._elem.querySelector(e);t&&(this._arInfoletsToHide||(this._arInfoletsToHide=[]),this._arInfoletsToHide.push(t),this._hidingInfolets=!0,this._queueRelayout())},_.prototype.resizeNotify=function(){this._resizingInfolet||this._hidingInfolets||this._showingInfolets||(this._busyStateResolveFunc=this._addBusyStateFunc("performing layout (resizeNotify)"),this._layoutCycleOnStartFunc(),this._transitionStart(!1),this._transitionLayout())},_.prototype.getCellSize=function(){return this._cellSize},_.prototype.isAnimationEnabled=function(){if(this._temporarilyDisableAnimation)return!1;if(!this._cachedAnimationEnabled){if(this._automationEnabled)this._animationEnabled=!1;else{var e=_,t=e._agentTypeAndVersion[0],i=e._agentTypeAndVersion[1];this._animationEnabled=e._isMinimumAgentMet(t,i,["gecko",16,"trident",6,"webkit",533.1])}this._cachedAnimationEnabled=!0}return this._animationEnabled},_.prototype.isInLayoutCycle=function(){return null!=this._layoutPhase||null!=this._arMovedInfolets&&this._arMovedInfolets.length>0},_.prototype.finishLayoutCycle=function(){this._temporarilyDisableAnimation=!0,this._removeStyleClassFromTiles(this._transitionShowFromStyleClass);for(var e=_,t=this._getTileChildren(),i=0;i<t.length;i++){var n=t[i];n._afrCellSize&&delete n._afrCellSize}this._hideTilesAnimationStarted?(this._hideTilesAnimationStarted=!1,this._handleHideTransitionEnd(null)):this._showTilesTimeout?(clearTimeout(this._showTilesTimeout),this._showTilesTimeout=null,this._showTiles()):this._layoutPhase===e._PHASE_LAYOUT||null!=this._arMovedInfolets&&this._arMovedInfolets.length>0?this._handleTransitionEnd(null):this._layoutPhase===e._PHASE_SHOW&&this._handleShowTransitionEnd(null),this._temporarilyDisableAnimation=!1},_._getElemSize=function(e){var t=_,i=t._getComputedStyle(e),n=t._getCSSLengthAsInt(i.marginLeft)+t._getCSSLengthAsInt(i.marginRight),r=t._getCSSLengthAsInt(i.marginTop)+t._getCSSLengthAsInt(i.marginBottom);return{w:e.offsetWidth+n,h:e.offsetHeight+r}},_._getElemInsets=function(e){var t=_,i=t._getComputedStyle(e);return{paddingLeft:t._getCSSLengthAsInt(i.paddingLeft),paddingRight:t._getCSSLengthAsInt(i.paddingRight),paddingTop:t._getCSSLengthAsInt(i.paddingTop),paddingBottom:t._getCSSLengthAsInt(i.paddingBottom),borderLeftWidth:t._getCSSLengthAsInt(i.borderLeftWidth),borderRightWidth:t._getCSSLengthAsInt(i.borderRightWidth),borderTopWidth:t._getCSSLengthAsInt(i.borderTopWidth),borderBottomWidth:t._getCSSLengthAsInt(i.borderBottomWidth)}},_._getComputedStyle=function(e){var t=e.ownerDocument.defaultView;return t?t.getComputedStyle(e,null):e.currentStyle},_._getCSSLengthAsInt=function(e){if(e.length>0&&"auto"!==e){var t=parseInt(e,10);return isNaN(t)&&(t=0),t}return 0},_._arrayIndexOf=function(e,t){if(e)for(var i=0;i<e.length;i++)if(e[i]===t)return i;return-1},_._isMinimumAgentMet=function(e,t,i){var n=i.length;if(n%2==0)for(var r=0;r<=n-2;r+=2){if(e===i[r])return t>=i[1+r]}return!1},_._getAgentTypeAndVersion=function(e){var t=_._parseFloatVersion,i=null,n=-1,r=e.toLowerCase();if(-1!==r.indexOf("msie")||-1!==r.indexOf("trident")){i="trident";var s=t(r,/trident\/(\d+[.]\d+)/);-1!==s?n=s:(-1===(s=t(r,/msie (\d+\.\d+);/))&&(s=t(r,/msie (\d+\.\d+)b;/)),n=s-4),null!=document.documentMode&&(n=Math.min(n,document.documentMode-4))}else-1!==r.indexOf("applewebkit")?(i="webkit",n=t(r,/applewebkit\/(\d+([.]\d+)*)/)):-1!==r.indexOf("gecko/")&&(i="gecko",n=t(r,/rv:(\d+[.]\d+)/));return[i,n]},_._parseFloatVersion=function(e,t){var i=e.match(t);if(i){var n=i[1];if(n)return parseFloat(n)}return-1},_._compareTilePositions=function(e,t){return e.startRow>t.startRow?1:e.startRow<t.startRow?-1:e.startCol>t.startCol?1:-1},_.prototype._queueRelayout=function(){this._hideTilesTimeout||(this._layoutPhase?this._queuedRelayout||(this._queuedRelayout=!0):(this._busyStateResolveFunc=this._addBusyStateFunc("performing layout"),this._hideTilesTimeout=setTimeout(this._hideTilesFunc,0)))},_.prototype._getTileChildren=function(){for(var e=this._elem.querySelectorAll(this._tilesSelector),t=[],i=0;i<e.length;i++){var n=e[i],r=n.style;n.offsetWidth>0&&n.offsetHeight>0&&"hidden"!==r.visibility&&t.push(n)}return t},_.prototype._transitionLayout=function(){var e=this._arMovedInfolets,t=this._layout();if(this._arInfoletsToResize){var i=this._arInfoletsToResize;t||(t=[]);for(var n=_,r=0;r<i.length;r+=2){var s=i[r];n._arrayIndexOf(t,s)<0&&t.push(s)}}var a=!1;!t||t.length<1?(!e||e.length<1)&&(this._arMovedInfolets=null,this._handleTransitionEnd(null),a=!0):this._arMovedInfolets=t;var o=null!=t&&t.length>0;return this.isAnimationEnabled()||a||this._handleTransitionEnd(null),o},_.prototype._layout=function(){var e=this._elem,t=this._getTileChildren();this._sortTilesOriginalOrderFunc(t),this._cellSize=null;var i=null;this._cols=0,this._rows=1,this._occupancyMap=null;var n,r,s,a,o,l=[],h=[],u=[],d=this._rtl,c=_,f=c._getElemInsets(e),g=0,m=[];for(this._arTilePositions=m,n=0;n<t.length;n++){(r=t[n])._afrCellSize&&(this._cellSize=r._afrCellSize,delete r._afrCellSize);var p=this._getTileSpanFunc(r);if(this._cellSize||(this._cellSize=this._calcCellSize(r,p)),i=this._cellSize,!this._occupancyMap){var v=e.offsetWidth-f.paddingLeft-f.paddingRight-f.borderLeftWidth-f.borderRightWidth;this._cols=Math.max(Math.floor(v/i.w),1),this._initOccupancyMap(this._cols,this._rows),g=this._cols}p.colSpan>g&&(g=p.colSpan),p.colSpan>this._cols&&(p.colSpan=this._cols);for(var y=!1,T=0;T<this._rows;T++){for(var S=0;S<this._cols;S++)if(this._fits(S,T,p)){o={top:(s=r.style).top},d?o.right=s.right:o.left=s.left,h.push(o),a=this._calcPosition(r,S,T,p,i,f),u.push(a),y=!0,m.push({startCol:S,startRow:T,tile:r});break}if(y)break;T===this._rows-1&&this._addRow()}}if(i){var O=this._sizeDiv.style;if(O){var C=g*i.w,E=this._rows*i.h,b=O.width?_._getCSSLengthAsInt(O.width.toString()):0,F=O.height?_._getCSSLengthAsInt(O.height.toString()):0;(b>C||F>E)&&(this._afrSizeDivDims={},this._afrSizeDivDims.width=C+"px",this._afrSizeDivDims.height=E+"px"),O.width=(b>C?b:C)+"px",O.height=(F>E?F:E)+"px"}}for(n=0;n<t.length;n++)s=(r=t[n]).style,a=u[n],""!==(o=h[n]).top&&(d&&parseInt(a.right,10)!==parseInt(o.right,10)||!d&&parseInt(a.left,10)!==parseInt(o.left,10)||parseInt(a.top,10)!==parseInt(o.top,10))&&(l.push(r),this._layoutTransition&&c._arrayIndexOf(this._arInfoletsToResize,r)<0&&this._animateLayout(r,this._reorderTransitionStarted?"reorder":"move")),s.top=a.top,this._rtl?s.right=a.right:s.left=a.left;return l.length<1&&(l=null),l},_.prototype._updateSizeDivOnEnd=function(){if(this._afrSizeDivDims){var e=this._sizeDiv.style;e.width=this._afrSizeDivDims.width,e.height=this._afrSizeDivDims.height,delete this._afrSizeDivDims}},_.prototype._reorderTilesForLayout=function(){var e=this._arTilePositions;this._arTilePositions=null;var t=_;e.sort(t._compareTilePositions);for(var i=this._getTileChildren(),n=0;n<i.length;n++){var r=i[n],s=e[n].tile;if(r!==s){this._subtreeDetachedFunc(s),r.parentNode.insertBefore(s,r),this._subtreeAttachedFunc(s);var a=t._arrayIndexOf(i,s);a>n&&(i.splice(a,1),i.splice(n,0,s))}}},_.prototype._initOccupancyMap=function(e,t){this._occupancyMap=[];for(var i=this._occupancyMap,n=0;n<t;n++){var r=[];i.push(r);for(var s=0;s<e;s++)r[s]=!1}},_.prototype._addRow=function(){this._rows+=1;var e=[];this._occupancyMap.push(e);for(var t=0;t<this._cols;t++)e[t]=!1},_.prototype._fits=function(e,t,i){for(var n=i.colSpan,r=i.rowSpan,s=t;s<t+r;s++){s>=this._rows&&this._addRow();for(var a=e;a<e+n;a++){if(a>=this._cols)return!1;if(this._occupancyMap[s][a])return!1}}return!0},_.prototype._calcPosition=function(e,t,i,n,r,s){for(var a=n.colSpan,o=n.rowSpan,l=this._occupancyMap,h=i;h<i+o;h++)for(var u=t;u<t+a;u++)l[h][u]=!0;var d={},_=s.paddingTop+i*r.h;if(d.top=_+"px",this._rtl){var c=s.paddingRight+t*r.w;d.right=c+"px"}else{var f=s.paddingLeft+t*r.w;d.left=f+"px"}return d},_.prototype._removeStyleClassFromTiles=function(e){for(var t=this._getTileChildren(),i=0;i<t.length;i++)this._removeStyleClassNameFunc(t[i],e)},_.prototype._animateLayout=function(e,t){if(this.isAnimationEnabled()){var i=this;i._startAnimationFunc(e,t).then(function(){i._layoutTransition&&i._handleTransitionEnd(e)})}},_.prototype._transitionStart=function(e){this._layoutTransition||(this._reorderTransitionStarted=e,this._layoutTransition=!0)},_.prototype._handleTransitionEnd=function(e){var t=!0;if(this._arMovedInfolets){var i=this._arMovedInfolets;if(e){for(var n=0;n<i.length;n++)if(e===i[n]){this._arMovedInfolets=[],i=this._arMovedInfolets;break}}else this.isAnimationEnabled()||(this._arMovedInfolets=[],i=this._arMovedInfolets);i.length>0&&(t=!1)}if(t){this._arInfoletsToResize&&(this._arInfoletsToResize=null),this._reorderTransitionStarted&&(this._reorderTransitionStarted=!1);var r=_;if(this._layoutTransition=!1,this._resizingInfolet=!1,this._hidingInfolets=!1,this._showingInfolets=!1,this._reorderTilesForLayout(),this._layoutOnEndFunc(),this._updateSizeDivOnEnd(),this._layoutPhase===r._PHASE_LAYOUT)if(this.isAnimationEnabled()){var s=this;this._showTilesTimeout=setTimeout(function(){s._showTiles()},0)}else this._showTiles();else this._layoutPhase||this._layoutCycleOnEndFunc(this._resolveBusyStateFunc)}},_.prototype._calcCellSize=function(e,t){var i=_._getElemSize(e);return{w:i.w/t.colSpan,h:i.h/t.rowSpan}},_.prototype._hideTiles=function(){this._hideTilesTimeout&&(clearTimeout(this._hideTilesTimeout),this._hideTilesTimeout=null),this._layoutCycleOnStartFunc();var e=_;if(this._layoutPhase=e._PHASE_HIDE,this._arInfoletsToHide&&this.isAnimationEnabled()){var t=this._arInfoletsToHide,i=this;this._hideTilesAnimationStarted=!0;for(var n=0;n<t.length;n++){var r=t[n],s=function(e){i._handleHideTransitionEnd(e)}.bind(null,r);this._startAnimationFunc(r,"remove").then(s)}}else this._handleHideTransitionEnd(null)},_.prototype._handleHideTransitionEnd=function(e){this._hideTilesAnimationStarted&&(this._hideTilesAnimationStarted=!1);var t,i,n,r,s=_,a=this._arInfoletsToHide;if(e){if(t=e,a){for(n=0;n<a.length;n++)if((i=a[n])===t){a.splice(n,1),this._arFireHideOnEnd||(this._arFireHideOnEnd=[]),(r=this._arFireHideOnEnd).push(t);break}a.length<1&&(this._arInfoletsToHide=null)}}else if(!this.isAnimationEnabled()&&a){for(n=0;n<a.length;n++)i=a[n],this._arFireHideOnEnd||(this._arFireHideOnEnd=[]),(r=this._arFireHideOnEnd).push(i);this._arInfoletsToHide=null}if(!this._arInfoletsToHide){if(this._arFireHideOnEnd){for(r=this._arFireHideOnEnd,n=0;n<r.length;n++){var o=(t=r[n]).style;this._rtl?o.right="":o.left="",o.top="",this._hideTileOnEndFunc(t)}this._arFireHideOnEnd=null}if(this._layoutPhase=s._PHASE_LAYOUT,this._transitionStart(!1),this._arInfoletsToResize){var l=this._arInfoletsToResize;for(n=0;n<l.length;n+=2){t=l[n];var h=l[n+1],u=this._getSizeStyleClassNameFunc(t);this.isAnimationEnabled()&&(t._afrCellSize=this._cellSize,this._animateLayout(t,"resize")),this._removeStyleClassNameFunc(t,u),this._addStyleClassNameFunc(t,h)}}this._transitionLayout()}},_.prototype._showTiles=function(){this._showTilesTimeout&&(clearTimeout(this._showTilesTimeout),this._showTilesTimeout=null);var e,t,i=_;this._layoutPhase=i._PHASE_SHOW;var n=this._arInfoletsToShow;if(n&&this.isAnimationEnabled()){var r=this;for(e=0;e<n.length;e++){t=n[e],this._removeStyleClassNameFunc(t,this._transitionShowFromStyleClass);var s=function(e){r._handleShowTransitionEnd(e)}.bind(null,t);this._startAnimationFunc(t,"insert").then(s)}}else{if(n)for(e=0;e<n.length;e++)t=n[e],this._removeStyleClassNameFunc(t,this._transitionShowFromStyleClass);this._handleShowTransitionEnd(null)}},_.prototype._handleShowTransitionEnd=function(e){var t,i,n=this._arInfoletsToShow;if(e){var r=e;if(n){for(t=0;t<n.length;t++)if((i=n[t])===r){n.splice(t,1),this._showTileOnEndFunc(r);break}n.length<1&&(this._arInfoletsToShow=null)}}else if(!this.isAnimationEnabled()&&n){for(t=0;t<n.length;t++)i=n[t],this._showTileOnEndFunc(i);this._arInfoletsToShow=null}this._arInfoletsToShow||(this._layoutPhase=null,this._layoutCycleOnEndFunc(this._resolveBusyStateFunc),this._queuedRelayout&&(this._queuedRelayout=!1,this._queueRelayout()))},_.prototype._resolveBusyState=function(){this._busyStateResolveFunc&&(this._busyStateResolveFunc(),this._busyStateResolveFunc=null)},_._PHASE_HIDE=1,_._PHASE_LAYOUT=2,_._PHASE_SHOW=3,function(){var u="px",d="hidden",c="none",f="draggable",g="oj-disabled",m="oj-draggable",p="oj-masonrylayout-tile",v=/oj-masonrylayout-tile-[0-9]+x[0-9]+/,y="."+p,T="oj-helper-hidden",S="data-oj-command",O="oj-masonrylayout-tile-transition-show-from",C="JET MasonryLayout: 'disabled' property not supported",E="no tile found for selector: ",b="ojmasonrylayoutcut",F="ojmasonrylayoutpastebefore",D="ojmasonrylayoutpasteafter",M={cut:b,"paste-before":F,"paste-after":D},I={cut:"labelCut","paste-before":"labelPasteBefore","paste-after":"labelPasteAfter"};function w(e){return t(e).offset()}function A(e,i){t(e).addClass(i)}function j(e,i){t(e).removeClass(i)}function R(e){var i=null,n=t(e).attr("class").match(v);return n&&(i=n[0]),i}function H(e){var i=t(e).attr("class").match(v)[0].substring(p.length+1),n=i.indexOf("x"),r=i.substring(0,n),s=i.substring(n+1);return{colSpan:_._getCSSLengthAsInt(r),rowSpan:_._getCSSLengthAsInt(s)}}function L(e){return e&&e.sort(z),e}function z(e,t){return t._jetDataMasonryOriginalOrder<e._jetDataMasonryOriginalOrder?1:e._jetDataMasonryOriginalOrder<t._jetDataMasonryOriginalOrder?-1:0}function P(e,t){for(var i=e;i;){var n=i.style;if(n&&(n.visibility===d||n.display===c))break;var r=i.parentNode;if(r===t)return i;i=r}return null}function x(e){for(var t=e;t;){var i=t.nextSibling,n=!0;if(i){var r=i.style;!r||r.visibility!==d&&r.display!==c||(n=!1)}if(i&&1===i.nodeType&&n)return i;t=i}return null}e.__registerWidget("oj.ojMasonryLayout",t.oj.baseComponent,{defaultElement:"<div>",widgetEventPrefix:"oj",options:{reorderHandle:null,animateStart:null,animateEnd:null,beforeInsert:null,insert:null,beforeRemove:null,remove:null,beforeResize:null,resize:null,beforeReorder:null,reorder:null},_ComponentCreate:function(){this._super(),this.element.addClass("oj-masonrylayout oj-component"),this.options.disabled&&o.warn(C),this.reorderHandleEventNamespace=this.eventNamespace+"ReorderHandle",this._menu={},this._menu.usermenu=!1,this._menu.$container=!1,this._menu.$elemCut=!1,this._menu.$elemPasteBefore=!1,this._menu.$elemPasteAfter=!1,this._initMenu(),this._applyMenu(),this._setup(!0)},refresh:function(){this._super();var e="rtl"===this._GetReadingDirection()!==this._bRTL;e&&this._destroyMLCommon(),this._setup(e)},_NotifyShown:function(){this._super(),this._setupAsNeeded()},_NotifyAttached:function(){this._super(),this._setupAsNeeded()},_NotifyContextMenuGesture:function(e,i,n){this._prepareContextMenuBeforeOpen(i);var r=this._menu.$container.children().not(".oj-helper-hidden");r&&r.length>0&&this._OpenContextMenu(i,n,{launcher:t(i.target).closest(":tabbable")})},_setupAsNeeded:function(){this._needsSetup?this._setup(this._needsSetup[0]):this._mlCommon.setup(!0)},_setup:function(e){var t=this;if(!this._canCalculateSizes()){var i=!1;return this._needsSetup&&(i=this._needsSetup[0]),void(this._needsSetup=[e||i])}this._needsSetup=null,this._bRTL="rtl"===this._GetReadingDirection(),this._bTouchSupported=l.isTouchSupported();var r=this.element,a=this.options;if(e){if(this._showTileOnEndFunc=function(e){t._showTileOnEnd(e)},this._hideTileOnEndFunc=function(e){t._hideTileOnEnd(e)},this._startAnimationFunc=function(e,i){return t._startAnimation(e,i)},this._layoutOnEndFunc=function(){t._layoutOnEnd()},this._layoutCycleOnStartFunc=function(){t._layoutCycleOnStart()},this._layoutCycleOnEndFunc=function(e){t._layoutCycleOnEnd(e)},!this._mlCommon){var o={tiles:y},h={transitionShowFromStyleClass:O},u={addStyleClassName:A,removeStyleClassName:j,getSizeStyleClassName:R,getTileSpan:H,showTileOnEndFunc:this._showTileOnEndFunc,hideTileOnEndFunc:this._hideTileOnEndFunc,startAnimationFunc:this._startAnimationFunc,layoutOnEndFunc:this._layoutOnEndFunc,layoutCycleOnStartFunc:this._layoutCycleOnStartFunc,layoutCycleOnEndFunc:this._layoutCycleOnEndFunc,sortTilesOriginalOrderFunc:L,subtreeAttached:s.subtreeAttached,subtreeDetached:s.subtreeDetached,addBusyState:function(e){return t._addBusyState(e)}};this._applyTileStyleClass(),this._saveTilesOriginalOrder(),this._mlCommon=new _(r[0],this._bRTL,"enabled"===n.getAutomationMode(),o,h,u)}this._handleDragStartFunc=function(e){t._handleDragStart(e)},this._handleDragEnterFunc=function(e){t._handleDragEnter(e)},this._handleDragOverFunc=function(e){t._handleDragOver(e)},this._handleDragLeaveFunc=function(e){t._handleDragLeave(e)},this._handleDragEndFunc=function(e){t._handleDragEnd(e)},this._handleDropFunc=function(e){t._handleDrop(e)},a.reorderHandle&&this._setupReorderHandles()}else{this._applyTileStyleClass();var d=r.children();this._tearDownReorderHandlesForElem(d),this._setupReorderHandlesForElem(d),this._checkTilesOriginalOrder()}this._mlCommon.setup(e),e&&(this._handleResizeFunc=function(e,i){t._handleResize()},l.addResizeListener(r[0],this._handleResizeFunc,25))},_destroy:function(){this._clearMenu();var e=this.element;l.removeResizeListener(e[0],this._handleResizeFunc),this._handleResizeFunc=null,this._restoreTilesOriginalOrder();for(var t=this._getTileElements(),i=t.length,n=0;n<i;n++){delete t[n]._jetDataMasonryOriginalOrder}this._destroyMLCommon(),e.removeClass("oj-masonrylayout oj-component"),this.options.reorderHandle&&this._tearDownReorderHandles(),e.children("."+p).removeClass(p),this._handleDragStartFunc=null,this._handleDragEnterFunc=null,this._handleDragOverFunc=null,this._handleDragLeaveFunc=null,this._handleDragEndFunc=null,this._handleDropFunc=null,this._showTileOnEndFunc=null,this._hideTileOnEndFunc=null,this._startAnimationFunc=null,this._layoutOnEndFunc=null,this._layoutCycleOnStartFunc=null,this._layoutCycleOnEndFunc=null,this._arTilesToInsert=null,this._super()},_setOption:function(t,i,n){var r=!1,s=!1;switch(t){case"reorderHandle":this._tearDownReorderHandles(),r=!0;break;case"disabled":o.warn(C);break;case"contextMenu":l.isTouchSupported()||(this._clearMenu(),i&&this._initMenu(i));break;case"translations":e.Object.compareValues(i,this.options[t])||(s=!0)}this._super(t,i,n),s&&this._refreshMenu(),r&&i&&this._setupReorderHandles()},resizeTile:function(e,i){var n=this._mlCommon;n.isInLayoutCycle()&&n.finishLayoutCycle();var r=t(e),s=r[0];if(!s)throw new Error("JET MasonryLayout: Unable to resize tile because "+E+e);var a=R(s);if(i===a)throw new Error("JET MasonryLayout: Unable to resize child "+e+" to style class "+i+" because "+i+" is already applied.");var o={tile:r,previousSizeStyleClass:a,sizeStyleClass:i};!1!==this._trigger("beforeResize",null,o)&&(this._arResizingTiles||(this._arResizingTiles=[]),this._arResizingTiles.push(s,a,i),n.resizeTile(e,i))},insertTile:function(e,i){var n=this._mlCommon;n.isInLayoutCycle()&&n.finishLayoutCycle(),isNaN(i)&&(i=-1);var r=t(e),a=r[0];if(!a)throw new Error("JET MasonryLayout: Unable to insert tile because "+E+e);r.addClass(p);var o={tile:r,index:i};if(!1!==this._trigger("beforeInsert",null,o)){a._jetDataTileInsertIndex=i,n.isAnimationEnabled()&&r.addClass(O);var l=a.style;l.top="-1px",this._bRTL?l.right="-1px":l.left="-1px",this._insertTileOriginalOrder(a,i),n.insertTileDomElem(a,i),s.subtreeAttached(a),this._arTilesToInsert||(this._arTilesToInsert=[]),this._arTilesToInsert.push(e)}},removeTile:function(e){var i=this._mlCommon;i.isInLayoutCycle()&&i.finishLayoutCycle();var n=t(e),r=n[0];if(!r)throw new Error("JET MasonryLayout: Unable to remove tile because "+E+e);if(h.containsFocus(r)){var s=this._getTileElements(!0),a=s.indexOf(r);a>0&&(this._deletingTileWithFocusPrev=s[a-1])}var o={tile:n};!1!==this._trigger("beforeRemove",null,o)&&i.hideTile(e)},_handleResize:function(){this._bDragging||this._inLayoutCycle||this._mlCommon.resizeNotify()},_showTileOnEnd:function(e){var i=t(e),n=e._jetDataTileInsertIndex;delete e._jetDataTileInsertIndex,this.options.reorderHandle&&this._setupReorderHandlesForElem(i);var r={tile:i,index:n};this._eventsToFire.push("insert",r)},_hideTileOnEnd:function(e){var i=t(e);this.options.reorderHandle&&this._tearDownReorderHandlesForElem(i),i.removeClass(p),s.subtreeDetached(e),e.parentNode.removeChild(e),this._removeTileOriginalOrder(e);var n={tile:i};this._eventsToFire.push("remove",n)},_startAnimation:function(e,t){var i=(r.parseJSONFromFontFamily("oj-masonrylayout-option-defaults")||{}).animation,n=i?i[t]:null;return a.startAnimation(e,t,n,this)},_layoutOnEnd:function(){var e;if(this._arTilesToInsert){var i=this._mlCommon,n=this._arTilesToInsert;for(e=0;e<n.length;e++){var r=n[e];i.showTile(r)}this._arTilesToInsert=null}if(this._arResizingTiles){var s=this._arResizingTiles;for(e=0;e<s.length;e+=3){var a=s[e],o=s[e+1],l=s[e+2],h={tile:t(a),previousSizeStyleClass:o,sizeStyleClass:l};this._eventsToFire.push("resize",h)}this._arResizingTiles=null}this._bDragging&&(this._bDragMoveTransition?this._handleDragMoveTransitionEnd():this._bDragEndTransition&&this._handleDragEndTransitionEnd())},_layoutCycleOnStart:function(){this._inLayoutCycle=!0,this._layoutStartActiveDomElem=null,this._eventsToFire||(this._eventsToFire=[]);var e=document.activeElement;e&&l.isAncestor(this.element[0],e)&&(this._layoutStartActiveDomElem=e)},_layoutCycleOnEnd:function(e){this._inLayoutCycle=!1;var t=this.element[0];if(this._layoutStartActiveDomElem){var i=this._layoutStartActiveDomElem;if(this._layoutStartActiveDomElem=null,this._deletingTileWithFocusPrev){var n=this._deletingTileWithFocusPrev;if(this._deletingTileWithFocusPrev=null,n&&l.isAncestor(t,n)){var r=this._getTileElements(t,!0),s=r.indexOf(n);s>=0&&s<r.length-1?h.focusFirstTabStop(r[s+1]):h.focusFirstTabStop(n)}}else l.isAncestor(t,i)?h.focusElement(i):h.focusFirstTabStop(t)}if(e&&e(),this._eventsToFire){var a=this._eventsToFire;this._eventsToFire=[];for(var o=0;o<a.length;o+=2){var u=a[o],d=a[o+1];this._trigger(u,null,d)}}},_destroyMLCommon:function(){var e=this._mlCommon;e&&e.destroy(),this._mlCommon=null},_canCalculateSizes:function(){var e=document.createElement("div"),t=e.style;t.width="10px",t.height="10px";var i=this.element[0];i.appendChild(e);var n=!1;try{n=e.offsetWidth>0&&e.offsetHeight>0}catch(e){}return i.removeChild(e),n},_getTileElements:function(e){for(var t=this.element.children(y),i=t.length,n=[],r=0;r<i;r++){var s=t[r];if(!e||s!==this._dropSite){var a=s.style;a.visibility!==d&&a.display!==c&&n.push(s)}}return n},_saveTilesOriginalOrder:function(){var e=this._getTileElements();if(e)for(var t=0;t<e.length;t++){var i=e[t];i._jetDataMasonryOriginalOrder||(i._jetDataMasonryOriginalOrder=t+1)}},_checkTilesOriginalOrder:function(){var e=this._getTileElements();if(e)for(var t=0;t<e.length;t++){var i=e[t];i._jetDataMasonryOriginalOrder||this._insertTileOriginalOrder(i,t)}},_restoreTilesOriginalOrder:function(){var e=this._getTileElements(),t=this._getTileElements();L(t);for(var i=0;i<e.length;i++){var n=e[i],r=t[i];if(n!==r){s.subtreeDetached(r),n.parentNode.insertBefore(r,n),s.subtreeAttached(r);var a=e.indexOf(r);a>i&&(e.splice(a,1),e.splice(i,0,r))}}},_insertTileOriginalOrder:function(e,t){var i=this._getTileElements();if(t<0&&(t=i.length),i)for(var n=0;n<i.length;n++){var r=i[n];r._jetDataMasonryOriginalOrder&&r._jetDataMasonryOriginalOrder>=t+1&&(r._jetDataMasonryOriginalOrder+=1)}e._jetDataMasonryOriginalOrder=t+1},_removeTileOriginalOrder:function(e){if(e._jetDataMasonryOriginalOrder){var t=this._getTileElements();if(t)for(var i=0;i<t.length;i++){var n=t[i];n._jetDataMasonryOriginalOrder&&n._jetDataMasonryOriginalOrder>e._jetDataMasonryOriginalOrder&&(n._jetDataMasonryOriginalOrder-=1)}delete e._jetDataMasonryOriginalOrder}},_applyTileStyleClass:function(){var e=this.element.children();(e=(e=e.not("."+p)).filter(function(e,t){return t.className.match(v)})).addClass(p)},_initMenu:function(e){var i=this._GetContextMenu();if(e||i||this._IsCustomElement()||(i=this.element.attr("contextmenu"))&&(this.options.contextMenu="#"+i),e||i){if(i=e||i,"function"===t.type(i)){try{i=i()}catch(e){i=null}t.type(i)}if(i){var n=t(i);if(n.length>0){n.css("display",c);var r=this._menu;if(!r)return;r.$container=n,r.usermenu=!0}this._menu.usermenu&&e&&this._applyMenu()}}},_applyMenu:function(){if(this._menu&&this._menu.usermenu&&this.options.reorderHandle){var e=this._menu.$container,i=this;"OJ-MENU"===e[0].tagName?e[0].addEventListener("ojAction",this._handleContextMenuSelect.bind(this)):e.on("ojselect",this._handleContextMenuSelect.bind(this));var n=e.find("[data-oj-command]"),r=!1;n.each(function(){var n=t(this).attr(S);n.indexOf("oj-masonrylayout-")>=0&&(n=n.slice("oj-masonrylayout-".length));var s="OJ-MENU"===e[0].tagName?this.tagName:"li",a=i._buildContextMenuItem(n,s);t(this).attr("id",a.attr("id")),"OJ-OPTION"===this.tagName?(this.innerHTML=a.get(0).innerHTML,t(this).attr(S,a.attr(S))):(a.get(0).className=t(this).get(0).className,t(this).replaceWith(a)),r=!0}),r&&("OJ-MENU"===e[0].tagName?e[0].refresh():e.ojMenu("refresh")),this._menu.$elemCut=e.find("#"+b),this._menu.$elemPasteBefore=e.find("#"+F),this._menu.$elemPasteAfter=e.find("#"+D)}},_clearMenu:function(){var e=this._menu;e&&e.usermenu&&(e.usermenu=!1,"OJ-MENU"===e.$container[0].tagName?e.$container[0].removeEventListener("ojAction",this._handleContextMenuSelect):e.$container.off("ojselect"),e.$container=null)},_refreshMenu:function(){this._clearMenu(),this._initMenu(),this._applyMenu()},_prepareContextMenuBeforeOpen:function(e){var i=this.element,n=e.originalEvent.target,r=this.options.reorderHandle,s=!1;if(r){var a=t(n).closest(r);a&&a.length>0&&(s=!0)}var o,l=P(n,i[0]);if(this._menu.tile=l,this._menu.usermenu){var h=this._menu.cutTile,u=!1,d=this._menu.$elemCut;if(d){var _=d.hasClass(T);s||_?s&&_&&(d.removeClass(T),u=!0):(d.addClass(T),u=!0);var c=d.hasClass(g);o=!1,h&&l===h&&(o=!0),o&&!c?(d.addClass(g),u=!0):!o&&c&&(d.removeClass(g),u=!0)}var f=this._menu.$elemPasteBefore;if(f){var m=f.hasClass(T);s||m?s&&m&&(f.removeClass(T),u=!0):(f.addClass(T),u=!0);var p=f.hasClass(g);o=!1,h&&l!==h&&l!==x(h)||(o=!0),o&&!p?(f.addClass(g),u=!0):!o&&p&&(f.removeClass(g),u=!0)}var v=this._menu.$elemPasteAfter;if(v){var y=v.hasClass(T);s||y?s&&y&&(v.removeClass(T),u=!0):(v.addClass(T),u=!0);var S=v.hasClass(g);o=!1,h&&h!==l&&h!==x(l)||(o=!0),o&&!S?(v.addClass(g),u=!0):!o&&S&&(v.removeClass(g),u=!0)}if(u){var O=this._menu.$container;"OJ-MENU"===O[0].tagName?O[0].refresh():O.ojMenu("refresh")}}},_buildContextMenuItem:function(e,i){var n=M[e],r=t(document.createElement(i));return r.attr("id",n),r.attr(S,e),r.append(this._buildContextMenuLabel(e,"OJ-OPTION"===i)),r},_buildContextMenuLabel:function(e,i){var n=I[e],r=document.createTextNode(this.getTranslatedString(n));return i?r:t('<a href="#"></a>').append(r)},_menuCut:function(e){e&&(this._menu.cutTile=e)},_menuPaste:function(e,t){if(e&&this._menu.cutTile){var i=this._menu.cutTile;this._menu.cutTile=!1,this._doPaste(i,e,t)}},_doPaste:function(e,i,n){var r=e._jetDataMasonryOriginalOrder-1,s=t(e),a={tile:s,fromIndex:r};if(!1!==this._trigger("beforeReorder",null,a)){this._removeTileOriginalOrder(e);var o=i._jetDataMasonryOriginalOrder-1;n||(o+=1);var l=this.element[0];if(n)this._insertTileOriginalOrder(e,o),l.insertBefore(e,i);else{var h=x(i);this._insertTileOriginalOrder(e,o),l.insertBefore(e,h)}this._mlCommon.setup(!0);var u={tile:s,fromIndex:r,toIndex:o};this._trigger("reorder",null,u)}},_handleContextMenuSelect:function(e,i){var n=(i?i.item:t(e.target)).attr("id");n===b?this._menuCut(this._menu.tile):n===F?this._menuPaste(this._menu.tile,!0):n===D&&this._menuPaste(this._menu.tile,!1)},_getTileIndex:function(e){var t=this._getTileElements(!0);L(t);for(var i=t.length,n=0;n<i;n++)if(t[n]===e)return n;return-1},_setupReorderHandles:function(){var e=this.element,t=e.children();this._setupReorderHandlesForElem(t),e.on("dragstart"+this.reorderHandleEventNamespace,this._handleDragStartFunc).on("dragenter"+this.reorderHandleEventNamespace,this._handleDragEnterFunc).on("dragover"+this.reorderHandleEventNamespace,this._handleDragOverFunc).on("dragleave"+this.reorderHandleEventNamespace,this._handleDragLeaveFunc).on("dragend"+this.reorderHandleEventNamespace,this._handleDragEndFunc).on("drop"+this.reorderHandleEventNamespace,this._handleDropFunc)},_setupReorderHandlesForElem:function(e){var t=this.options;e.filter(t.reorderHandle).attr(f,"true").addClass(m),e.find(t.reorderHandle).attr(f,"true").addClass(m)},_tearDownReorderHandles:function(){var e=this.element,t=e.children();this._tearDownReorderHandlesForElem(t),e.off(this.reorderHandleEventNamespace)},_tearDownReorderHandlesForElem:function(e){var t=this.options;e.filter(t.reorderHandle).removeAttr(f).removeClass(m),e.find(t.reorderHandle).removeAttr(f).removeClass(m)},_handleDragStart:function(e){var i,n=this.options;i=e.originalEvent.target;var r=t(i).closest(n.reorderHandle);if(r&&!(r.length<1)&&!this._bDragging){var s=P(i=e.target,this.element[0]);if(s){var a=this._getTileIndex(s);s._jetDataMasonryDragSourceIndex=a;var o={tile:t(s),fromIndex:a};if(!1!==this._trigger("beforeReorder",null,o)){var l=e.originalEvent;this._dragStart(s,l.pageX,l.pageY,l.dataTransfer)}}}},_handleDragEnter:function(e){if(this._bDragging){var i=e.originalEvent,n=i.relatedTarget,r=this.element[0],s=!1;if(n)s=r!==n&&!l.isAncestor(r,n);else if(this._dragLeftMasonryLayout){var a=document.elementFromPoint(i.clientX,i.clientY);s=a&&(a===r||l.isAncestor(r,a))}if(s)if(this._dragLeftMasonryLayout=!1,this._draggedTile){if(this._dropSite){t(this._dropSite).css("display",""),this._mlCommon.setup(!1,!0)}}else i.dataTransfer.dropEffect="none"}},_handleDragOver:function(e){if(!this._bDragging)return!1;var t=e.originalEvent;return t.dataTransfer.dropEffect="move",this._dragMove(t.pageX,t.clientX,t.clientY),e.preventDefault(),!1},_handleDragLeave:function(e){if(this._bDragging){var i=e.originalEvent,n=i.relatedTarget,r=this.element[0],s=!1;if(n)s=r!==n&&!l.isAncestor(r,n);else{var a=document.elementFromPoint(i.clientX,i.clientY);s=a&&a!==r&&!l.isAncestor(r,a)}if(s)if(this._dragLeftMasonryLayout=!0,this._dropSite)t(this._dropSite).css("display",c),this._mlCommon.setup(!1,!0)}},_clearDragStartHideTileTimeout:function(){if(this._dragStartHideTileTimeout){clearTimeout(this._dragStartHideTileTimeout),this._dragStartHideTileTimeout=null,this._busyStateResolveFunc(),this._busyStateResolveFunc=null;var e=this._draggedTile;e&&t(e).removeClass("oj-drag")}},_handleDragEnd:function(e){if(this._clearDragStartHideTileTimeout(),this._bDragging&&!this._bDropping){var i=this._draggedTile;if(i&&this._dropSite){var n=this._dropSite,r=this.element[0];if(l.isAncestor(r,i))t(n).css("display",""),this._removeTileOriginalOrder(n),n.parentNode.removeChild(n),t(i).css("display",""),this._insertTileOriginalOrder(i,i._jetDataMasonryOriginalOrder-1),this._mlCommon.setup(!1,!0);delete i._jetDataMasonryDragSourceIndex}this._draggedTile=null,this._dropSite=null,this._prevTileUnderPoint=null,this._prevCellUnderPoint=null,this._bDragMoveTransition=!1,this._bMouseMoved=!1,this._dragOffset=null,this._bDragEndTransition=!1,this._bDragging=!1}},_handleDrop:function(e){if(!this._bDragging)return!1;var t=this._mlCommon;t.isInLayoutCycle()&&t.finishLayoutCycle(),this._clearDragStartHideTileTimeout();var i=e.originalEvent;return this._drop(this._draggedTile,i.pageX,i.pageY),e.stopPropagation(),!1},_dragStart:function(e,i,n,r){this._bDragging=!0,this._bDropping=!1,this._bMouseMoved=!1,this._bDragStartTileHidden=!1,this._draggedTile=e;var a=this.element[0],o=R(e);this._dropSite=document.createElement("div");var l=this._dropSite;l._jetDataMasonryOriginalOrder=e._jetDataMasonryOriginalOrder,l.className=o+" oj-drop "+p;var h=l.style,u=e.style;h.top=u.top,this._bRTL?h.right=u.right:h.left=u.left;var d=w(e);a.insertBefore(l,e);var _={left:i-d.left,top:n-d.top};this._dragOffset=_,t(e).addClass("oj-drag"),r.effectAllowed="move",r.setData("text/html",e.outerHTML),r.setDragImage(e,_.left,_.top);var f=this;this._busyStateResolveFunc=this._addBusyState("Wait for dragStartHideTile timeout"),this._dragStartHideTileTimeout=setTimeout(function(){f._bDragStartTileHidden=!0,u.display=c,t(e).removeClass("oj-drag"),f._dragStartHideTileTimeout=null,f._busyStateResolveFunc(),f._busyStateResolveFunc=null,s.subtreeHidden(e)},0)},_dragMove:function(e,i,n){if(this._bMouseMoved=!0,this._bDragStartTileHidden&&!this._bDragMoveTransition){var r=this.element[0],s=P(document.elementFromPoint(i,n),r),a=!1;if(s){var o=t(s),l=this.options.reorderHandle;if(o.is(l))a=!0;else{var h=o.find(l);a=h&&h.length>0}}var u=!1;if(null==s||s===this._dropSite||s===this._draggedTile)this._prevTileUnderPoint=null,this._prevCellUnderPoint=null;else if(this._prevTileUnderPoint&&this._prevCellUnderPoint&&this._prevTileUnderPoint!==s){var d=this._getCellPosition(i,n);d&&d.row===this._prevCellUnderPoint.row&&d.col===this._prevCellUnderPoint.col&&(u=!0)}if(s&&!u&&s!==this._dropSite&&s!==this._draggedTile&&a){var _=e-w(r).left,c=x(this._dropSite),f=_>=s.offsetLeft+.5*s.offsetWidth;if(this._removeTileOriginalOrder(this._dropSite),f&&!this._bRTL||!f&&this._bRTL){var g=x(s);g?(this._insertTileOriginalOrder(this._dropSite,g._jetDataMasonryOriginalOrder-1),r.insertBefore(this._dropSite,g)):(this._insertTileOriginalOrder(this._dropSite,s._jetDataMasonryOriginalOrder),r.appendChild(this._dropSite))}else this._insertTileOriginalOrder(this._dropSite,s._jetDataMasonryOriginalOrder-1),r.insertBefore(this._dropSite,s);if(c!==x(this._dropSite)){var m=this._mlCommon,p=s,v=this._getCellPosition(i,n);this._bDragMoveTransition=m.setup(!1,!0),this._bDragMoveTransition&&(this._prevTileUnderPoint=p,this._prevCellUnderPoint=v)}}}},_handleDragMoveTransitionEnd:function(){this._bDragMoveTransition=!1},_drop:function(e,i,n){this._bDropping=!0;var r=this.element[0],a=this._dropSite;this._dropSite=null,this._prevTileUnderPoint=null,this._prevCellUnderPoint=null,s.subtreeDetached(e),r.insertBefore(e,a),r.removeChild(a),s.subtreeAttached(e),e._jetDataMasonryOriginalOrder=a._jetDataMasonryOriginalOrder;var o=e.style;o.display="",s.subtreeShown(e);var l=w(r),h=this._dragOffset;o.top=n-h.top-l.top+u;var d=i-h.left-l.left;if(this._bRTL?(o.right=r.offsetWidth-(d+t(e).outerWidth(!0))+u,o.left=""):o.left=d+u,this._dragOffset=null,this._bMouseMoved){var _=this._mlCommon;this._bDragEndTransition=_.setup(!1,!0)}else this._handleDragEndTransitionEnd()},_handleDragEndTransitionEnd:function(){this._bDragEndTransition=!1,this._bDragging=!1,this._bDropping=!1,this._bMouseMoved=!1,this._bDragStartTileHidden=!1;var e=this._draggedTile;this._draggedTile=null;var i=e._jetDataMasonryDragSourceIndex;delete e._jetDataMasonryDragSourceIndex;var n=this._getTileIndex(e),r={tile:t(e),fromIndex:i,toIndex:n};this._trigger("reorder",null,r)},_getCellPosition:function(e,t){var i=this._mlCommon.getCellSize(),n=null;return i&&(n={col:parseInt(e/i.w,10),row:parseInt(t/i.h,10)}),n},_addBusyState:function(e){var t=this.element,n=i.getContext(t[0]).getBusyContext(),r="MasonryLayout";r+=" (id='"+t.attr("id")+"')";var s={description:r+=": "+e};return n.addBusyState(s)},getNodeBySubId:function(e){return this._super(e)},getSubIdByNode:function(e){return this._super(e)}})}()});
//# sourceMappingURL=ojmasonrylayout.js.map