/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojcore-base","ojs/ojtranslation","jquery","hammerjs","ojs/ojcontext","ojs/ojjquery-hammer","ojs/ojcomponentcore","ojs/ojdomutils"],function(e,t,n,r,i,s,a,o,l){"use strict";var u;t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r,s=s&&Object.prototype.hasOwnProperty.call(s,"default")?s.default:s,(u={properties:{data:{type:"object",extension:{webelement:{exceptionStatus:[{type:"deprecated",since:"14.0.0",description:"Data sets from a DataProvider cannot be sent to WebDriverJS; use ViewModels or page variables instead."}]}}},translations:{type:"object",value:{},properties:{ariaDisabledLabel:{type:"string"},ariaInBetweenText:{type:"string"},ariaKeyboardInstructionText:{type:"string"},ariaOthersLabel:{type:"string"},ariaTouchInstructionText:{type:"string"},indexerCharacters:{type:"string"},indexerOthers:{type:"string"}}}},methods:{getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}}).extension._WIDGET_NAME="ojIndexer",u.extension._INNER_ELEM="ul",u.extension._GLOBAL_TRANSFER_ATTRS=["aria-label","aria-labelledby"],t.CustomElementBridge.register("oj-indexer",{metadata:u});const d=function(){};t._registerLegacyNamespaceProp("IndexerModel",d),d.SECTION_OTHERS={id:"__others__",label:n.getTranslatedString("oj-ojIndexer.indexerOthers")},function(){const e="data-includes",n="data-range",a="data-others";t.__registerWidget("oj.ojIndexer",r.oj.baseComponent,{defaultElement:"<ul>",version:"1.2",widgetEventPrefix:"oj",options:{data:null},_ComponentCreate:function(){this._super(),this._setup()},_AfterCreate:function(){this._super(),this._createIndexerContent(),this._setAriaProperties(),this._createInstructionText()},_destroy:function(){this._super();var e=this._getIndexerContainer();this._unregisterResizeListener(e),this._unregisterTouchHandler(e),this._unsetAriaProperties(),this.element.removeClass("oj-component-initnode"),l.unwrap(this.element,e)},_setOption:function(e,t){this._superApply(arguments),"data"===e&&this.refresh()},_SetupResources:function(){this._super();var e=this._getIndexerContainer()[0];this._registerResizeListener(e),this._registerTouchHandler(e)},_ReleaseResources:function(){this._super();var e=this._getIndexerContainer()[0];this._unregisterResizeListener(e),this._unregisterTouchHandler(e),this._resolveBusyState()},_resolveBusyState:function(){this.busyStateResolve&&(this.busyStateResolve(null),this.busyStateResolve=null)},widget:function(){return this._getIndexerContainer()},refresh:function(){this._super(),this.element.empty(),this._createIndexerContent(),this._setAriaProperties(),this.m_current=null},getNodeBySubId:function(t){if(null==t)return this.element?this.element[0]:null;if("oj-indexer-section"===t.subId)for(var i=t.section,s=this.element.children("li"),a=0;a<s.length;a++){var o=s.get(a);if(r(o).data(n)===i)return o;var l=r(o).data(e);if(null!=l)for(var u=0;u<l.length;u++)if(l[u]===i)return o}return null},getSubIdByNode:function(e){if(null!=e){var t=r(e).data(n);if(null!=t)return{subId:"oj-indexer-section",section:t}}return null},_setAriaProperties:function(){var e=this.element.children("li").first(),t=e.data(n);e.hasClass("oj-disabled")&&(t=t+". "+this.getTranslatedString("ariaDisabledLabel")),this.element.attr("role","slider").attr("aria-orientation","vertical").attr("aria-describedby",this.element.prop("id")+":desc").attr("aria-valuemin",0).attr("aria-valuemax",Math.max(0,this.element.children().length-1)).attr("aria-valuenow",0).attr("aria-valuetext",t)},_unsetAriaProperties:function(){this.element.removeAttr("role").removeAttr("aria-orientation").removeAttr("aria-describedby").removeAttr("aria-valuemin").removeAttr("aria-valuemax").removeAttr("aria-valuenow").removeAttr("aria-valuetext")},_createInstructionText:function(){var e;e=l.isTouchSupported()?"ariaTouchInstructionText":"ariaKeyboardInstructionText";var t=r(document.createElement("div"));t.prop("id",this.element.prop("id")+":desc"),t.addClass("oj-helper-hidden-accessible").text(this.getTranslatedString(e)),this._getIndexerContainer().append(t)},_getIndexerContainer:function(){return null==this.m_container&&(this.m_container=this._createIndexerContainer()),this.m_container},_createIndexerContainer:function(){var e;return this.OuterWrapper?e=r(this.OuterWrapper):(e=r(document.createElement("div")),this.element.parent()[0].replaceChild(e[0],this.element[0])),e.addClass("oj-indexer oj-component"),e.prepend(this.element),e},_createIndexerContent:function(){var e=this._getIndexerModel();if(null!=e){var t=e.getIndexableSections();if(null!=t){var n,r=this.element;e.getMissingSections&&(n=e.getMissingSections());var i=this.getTranslatedString("indexerOthers"),s=this.widget().outerHeight(),a=this._createItem(t[0],n);r.append(a),this._getIndexerContainer().removeClass("oj-indexer-abbr"),null==this.m_itemHeight&&(this.m_itemHeight=a.outerHeight());var o=Math.max(1,this.m_itemHeight),l=Math.floor(s/o),u=Math.floor((t.length+1)/l)+1;u>1&&this._getIndexerContainer().addClass("oj-indexer-abbr");for(var d=1+u;d<t.length;d=d+u+1){if(u>1){var h=this._createSeparator(t,d-u,d-1);r.append(h)}else d-=1;var c=t[d],_=this._createItem(c,n);r.append(_)}var p=this._createItem(t[t.length-1],n);r.append(p);var f=this._createItem(i);f.attr("data-others","true"),r.append(f),null==this.m_height&&(this.m_height=s)}}},_createItem:function(e,t){var i=e.label?e.label:e,s=r(document.createElement("li"));return s.data(n,e).text(i),null!=t&&t.indexOf(e)>-1&&s.addClass("oj-disabled"),s},_createSeparator:function(t,i,s){var a=[],o=r(document.createElement("li"));o.addClass("oj-indexer-ellipsis").data(n,t[i+Math.round((s-i)/2)]);for(var l=i;l<=s;l++)a.push(t[l]);return o.data(e,a),o},_setup:function(){var e=this;this.element.uniqueId().addClass("oj-component-initnode").attr("tabIndex",0),this._on(this.element,{click:function(t){e._handleClick(t)},keydown:function(t){e._handleKeyDown(t)},focus:function(t){e._handleFocus(t)},blur:function(t){e._handleBlur(t)}}),this._focusable({applyHighlight:!0,setupHandlers:function(t,n){e._focusInHandler=t,e._focusOutHandler=n}})},_handleClick:function(e){var t;0===e.button&&(t=r(e.target),this._setCurrent(t))},_handleFocus:function(e){this._getIndexerContainer().addClass("oj-focus-ancestor"),null==this.m_current?this._setFocus(this.element.children("li").first()):this._setFocus(this.m_current)},_handleBlur:function(e){this._getIndexerContainer().removeClass("oj-focus-ancestor")},_handleKeyDown:function(e){var t,n=!1;switch(e.keyCode){case 38:t=this.m_current.prev();break;case 40:t=this.m_current.next();break;case 13:this._setCurrent(this.m_current),n=!0}null!=t&&t.length>0&&(n=!0,this._setFocus(t)),n&&e.preventDefault()},_setFocus:function(e){null!=this.m_current&&this._focusOutHandler(this.m_current),this._focusInHandler(e),this._updateAriaProperties(e),this.m_current=e},_getIndexerModel:function(){var e=this.option("data");if(null!=e&&(void 0===e.setSection||void 0===e.getIndexableSections))throw new Error("Invalid IndexerModel");return e},_setCurrent:function(e){var t=e.data(n);e.attr(a)&&(t=d.SECTION_OTHERS),this._setCurrentSection(t)},_setCurrentSection:function(e){var t=this,n=s.getContext(this.element[0]).getBusyContext();this.busyStateResolve=n.addBusyState({description:"setCurrentSection"}),this._getIndexerModel().setSection(e).then(function(e){if(null!=e){var n=t._findItem(e);null!=n&&t._setFocus(n)}t._resolveBusyState()},function(){t._resolveBusyState()})},_updateAriaProperties:function(t){var r=t.data(e),i="";if(null!=r){if(r.length>0){var s=r[0].label?r[0].label:r[0],a=r[r.length-1].label?r[r.length-1].label:r[r.length-1];i=this.getTranslatedString("ariaInBetweenText",{first:s,second:a})}}else{var o=t.data(n);i=o===d.SECTION_OTHERS?this.getTranslatedString("ariaOthersLabel"):o}t.hasClass("oj-disabled")&&(i=i+". "+this.getTranslatedString("ariaDisabledLabel")),this.element.attr("aria-valuetext",i),this.element.attr("aria-valuenow",t.index())},_findItem:function(t){for(var i=this.element.children(),s=0;s<i.length;s++){var o=i.get(s),l=r(o).data(n),u=r(o).data(e),d=r(o).attr(a);if(null!=l&&l===t||null!=u&&u.indexOf(t)>-1||void 0!==d)return r(o)}return null},_unregisterResizeListener:function(e){e&&this._resizeHandler&&l.removeResizeListener(e,this._resizeHandler)},_registerResizeListener:function(e){e&&(null==this._resizeHandler&&(this._resizeHandler=this._handleResize.bind(this)),l.addResizeListener(e,this._resizeHandler))},_unregisterTouchHandler:function(e){this.hammer&&(this.hammer.off("panstart panmove panend"),r(e).ojHammer("destroy")),this.hammer=null},_registerTouchHandler:function(t){var s,a,o,l,u,d=this,h={recognizers:[[i.Pan,{direction:i.DIRECTION_VERTICAL}]]};this.hammer=r(t).ojHammer(h).on("panstart",function(e){var t=e.gesture.target;s=d.element[0].getBoundingClientRect().left+5,a=t.getBoundingClientRect().top,d._setCurrent(r(t)),o=t,l=r(t).data(n),u=a}).on("panmove",function(t){var i=u;u=a+t.gesture.deltaY;var h=document.elementFromPoint(s,u);if(null!=h){var c,_,p=u-i;if(o===h){if(null!=(c=r(h).data(e))){var f=c.indexOf(l);_=null,p>0&&f<c.length-1?_=c[f+1]:p<0&&f>0&&(_=c[f-1]),null!=_&&(l=_,d._setCurrentSection(_))}}else r(h).data(n)&&(_=null,null!=(c=r(h).data(e))&&(p>0&&h===o.nextElementSibling?_=c[0]:p<0&&h===o.previousElementSibling&&(_=c[c.length-1])),null==_&&(_=r(h).data(n)),o=h,l=_,d._setCurrentSection(l))}}).on("panend",function(){o=null,l=null,u=null})},_handleResize:function(e,t){t>0&&t!==this.m_height&&(this.refresh(),this.m_height=t)}})}();const h=function(e){this.listview=e,this.Init()};t._registerLegacyNamespaceProp("ListViewIndexerModel",h),t.Object.createSubclass(h,t.EventSource,"oj.ListViewIndexerModel"),h.prototype.getIndexableSections=function(){return this.listview.ojContext.getTranslatedString("indexerCharacters").split("|")},h.prototype.getMissingSections=function(){return null==this.missingSections&&(this.missingSections=this._getMissingSections()),this.missingSections},h.prototype._getMissingSections=function(){var e,t=[],n=this.listview._getGroupItemsCache(),i=this.getIndexableSections();for(e=0;e<i.length;e++){var s=i[e],a=!1;n.each(function(){var e=r(this).text();return!(e.length>0&&e.charAt(0)===s)||(a=!0,!1)}),a||t.push(s)}return t},h.prototype.setSection=function(e){return e===d.SECTION_OTHERS?this._setOtherSection():this._setSection(e)},h.prototype._setOtherSection=function(){var e=this.getIndexableSections(),t=this;return new Promise(function(n){var i=null;t.listview._getGroupItemsCache().each(function(){for(var t=r(this).text(),n=0;n<e.length;n++){var s=e[n];if(0===t.indexOf(s))return!0}return i=this,!1}),i?(t.listview._scrollToGroupHeader(i),n(d.SECTION_OTHERS)):n(null)})},h.prototype._setSection=function(e){var t=this.getIndexableSections(),n=t.indexOf(e),r=this;return new Promise(function(e){if(-1===n)e(null);else{for(var i=null;n<t.length;n++){var s=t[n],a=r._findGroupHeader(s);if(null!=a){r.listview._scrollToGroupHeader(a),i=s;break}}e(i)}})},h.prototype._findGroupHeader=function(e){var t;return this.listview._getGroupItemsCache().each(function(){return 0!==r(this).text().indexOf(e)||(t=this,!1)}),t},e.ListViewIndexerModel=h,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojindexer.js.map