/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojdvt-toolkit","ojs/ojdvt-axis"],function(e,t,a){"use strict";const i={hasData:e=>{var t=e.getOptions();return t&&null!=t.value&&i.hasValidData(e)},hasValidData:e=>{var t=e.getOptions();return Number(t.min)<Number(t.max)},getValThresholdIdx:(e,t)=>{var a=e.getOptions(),i=null!=t?t:a.value,s=a.thresholds;if(!s)return-1;for(var n=0;n<s.length;n++)if(i<=s[n].max)return n;return s.length-1},getThreshold:(e,t)=>{var a=e.getOptions().thresholds;return a&&t>=0&&t<a.length?a[t]:null},getReferenceObject:(e,t)=>{var a=e.getOptions().referenceLines;return a&&t>=0&&t<a.length?a[t]:null}},s={renderEmptyText:(e,a,s)=>{var n=e.getOptions(),r=n.translations,o=n.emptyText;o||(o=r.labelNoData),i.hasValidData(e)||(o=r.labelInvalidData);var l=n._statusMessageStyle;if(l.getStyle("font-size")||l.setStyle("font-size","13px"),"statusMeter"===e.type){var h=l.getStyle("color");h=h||"#333333",l.setStyle("color",h)}e.renderEmptyText(a,o,new t.Rectangle(s.x,s.y,s.w,s.h),e.getEventManager(),l)},getFormattedMetricLabel:(e,t)=>{var a=t.getOptions();if(a.metricLabel.text)return a.metricLabel.text;var i=a.metricLabel.converter,n=a.metricLabel.scaling,r=a.metricLabel.autoPrecision?a.metricLabel.autoPrecision:"on",o="percent"===a.metricLabel.textType;return s._formatMetricLabelValue(e,t,i,n,r,o)},_formatMetricLabelValue:(e,t,i,n,r,o)=>{var l,h=t.getOptions(),d=h.min,g=h.max,u=g-d,c=u<1e3?100:1e3,p=null;isNaN(u)||(p=u/c),o&&(e=s.getFillPercentage(h,h.min,h.max,e,!0));var _=new a.LinearScaleAxisValueFormatter(d,g,p,n,r,h.translations);if(i&&i.format)l=_.format(e,i);else if(o){var v=t.getCtx().getNumberConverter({style:"percent",maximumFractionDigits:0,minimumFractionDigits:0});l=v&&v.format?v.format(e):String(Math.round(100*e))+"%"}else l=_.format(e);return l},getFillPercentage:(e,t,a,i,s)=>{var n=(i-t)/(e.max-e.min);return n=s?n:Math.min(Math.max(0,n),1)},getTooltipString:e=>{var a=e.getOptions(),n=i.getValThresholdIdx(e),r=i.getThreshold(e,n),o=s.getFormattedMetricLabel(a.value,e);return r&&null!=r.shortDesc?r.shortDesc:null!=a.shortDesc?a.shortDesc:a.label.text?t.ResourceUtils.format(a.translations.labelAndValue,[a.label.text,o]):o},renderMetricLabel:(e,a,i,n,r,o,l)=>{var h=e.getOptions(),d=!1;if("on"===h.metricLabel.rendered||l&&"off"!==h.metricLabel.rendered){var g=s.getFormattedMetricLabel(h.value,e),u=s.getFormattedMetricLabel(h.min,e),c=s.getFormattedMetricLabel(h.max,e),p=new t.OutputText(e.getCtx(),g,i.x+i.w/2,i.y+i.h/2);p.setCSSStyle(h.metricLabel.style);var _=h.metricLabel.style.getStyle("font-size");_||(_=s.calcLabelFontSize([g,u,c],p,i),p.setTextString(g),p.setFontSize(_)),"top"===o?(p.setY(i.y),p.alignTop()):"middle"===o?t.TextUtils.centerTextVertically(p,i.y+i.h/2):"bottom"===o&&(p.setY(i.y+i.h),p.alignBottom()),"center"===r?p.alignCenter():"left"==r?(p.setX(i.x),p.alignLeft()):"right"===r&&(p.setX(i.x+i.w),p.alignRight()),null!=n&&p.setSolidFill(n),d=t.TextUtils.fitText(p,i.w,i.h,a)}return d},renderLabel:(e,a,i,s,n)=>{var r=e.getOptions(),o=!1;if(r.label.text){var l=r.label.text,h=r.label.style,d=new t.MultilineText(e.getCtx(),l),g=h.clone();d.setCSSStyle(h);var u=h.getStyle("font-size")||t.TextUtils.getOptimalFontSize(d.getCtx(),d.getTextString(),d.getCSSStyle(),i);g.setFontSize("font-size",u,e.getCtx()),null!=s&&g.setStyle("color",s),d.setCSSStyle(g),o=t.TextUtils.fitText(d,i.w,i.h,e);var c=d.getDimensions().h;"top"===n?d.setY(i.y):"bottom"===n?d.setY(i.y+i.h-c):d.setY(i.y+i.h/2-c/2),d.setX(i.x+i.w/2),d.alignCenter(),a.addChild(d)}return o},calcLabelFontSize:(e,a,i)=>{for(var s=0,n=null,r=0,o=0;o<e.length;o++)a.setTextString(e[o]),(r=a.getDimensions().w)>s&&(n=e[o],s=r);return a.setTextString(n),t.TextUtils.getOptimalFontSize(a.getCtx(),a.getTextString(),a.getCSSStyle(),i)},adjustForStep:(e,t)=>{var a=Number(e.step);if(a&&a>0){var i=t/a;if(i<.5)return e.min;var s=Math.ceil(i)*a;return Math.max(Math.min(e.max,s),e.min)}return t}};class n extends t.Automation{getDomElementForSubId(e){if(e===t.Automation.TOOLTIP_SUBID)return this.GetTooltipElement(this._comp);if(0===e.indexOf("item")){var a=e.indexOf("["),i=e.indexOf("]");if(a>0&&i>0){var s=e.substring(a+1,i),n=this._comp.__getRatingGaugeItem(s);if(n)return n.getElem()}}return null}GetSubIdForDomElement(e){for(var t=this._comp,a=t.getOptions(),i=0;i<a.max;i++){if(t.__getRatingGaugeItem(i)===e)return"item["+i+"]"}return null}getValue(){return this._comp.getOptions().value}getMetricLabel(){return s.getFormattedMetricLabel(this.getValue(),this._comp)}}class r extends t.EventManager{constructor(e){super(e.getCtx(),e.dispatchEvent,e,e),this._gauge=e,this.IsMouseEditing=!1}OnMouseDown(e){if(this._gauge.IsInteractive()){this.IsMouseEditing=!0,this.hideTooltip();var t=this.GetRelativePosition(e.pageX,e.pageY);this._gauge.__processValueChangeStart(t.x,t.y),e.preventDefault()}else super.OnMouseDown(e)}OnMouseUp(e){this.IsMouseEditing?this.StopMouseEditing(e):super.OnMouseUp(e)}OnMouseMove(e){if(this.IsMouseEditing){var t=this.GetRelativePosition(e.pageX,e.pageY);this._gauge.__processValueChangeMove(t.x,t.y)}!this.IsShowingTooltipWhileEditing()&&this.IsMouseEditing||super.OnMouseMove(e)}IsShowingTooltipWhileEditing(){return!1}PreEventBubble(e){var a;t.TouchEvent.TOUCHSTART===e.type&&this._gauge.IsInteractive()?(this.IsMouseEditing=!0,a=this.GetRelativePosition(e.touches[0].pageX,e.touches[0].pageY),this._gauge.__processValueChangeStart(a.x,a.y),e.preventDefault()):t.TouchEvent.TOUCHMOVE===e.type&&this.IsMouseEditing?(a=this.GetRelativePosition(e.touches[0].pageX,e.touches[0].pageY),this._gauge.__processValueChangeMove(a.x,a.y),e.preventDefault()):t.TouchEvent.TOUCHEND===e.type&&this.IsMouseEditing&&(this.IsMouseEditing=!1,a=this.GetRelativePosition(e.changedTouches[0].pageX,e.changedTouches[0].pageY),this._gauge.__processValueChangeEnd(a.x,a.y),e.preventDefault()),this.IsMouseEditing&&!this.IsShowingTooltipWhileEditing()||super.PreEventBubble(e)}ProcessKeyboardEvent(e){if(!this.KeyboardHandler)return!1;this.KeyboardHandler.processKeyDown(e);var a=e.keyCode;if(a===t.KeyboardEvent.UP_ARROW||a===t.KeyboardEvent.LEFT_ARROW||a===t.KeyboardEvent.DOWN_ARROW||a===t.KeyboardEvent.RIGHT_ARROW||a===t.KeyboardEvent.TAB){var i=this._gauge.getCtx().getStageAbsolutePosition();this.ProcessObjectTooltip(e,i.x,i.y,this._gauge.__getLogicalObject(),this._gauge)}return!1}OnBlur(e){super.OnBlur(e),this.hideTooltip()}GetRelativePosition(e,t){var a=this.getCtx().pageToStageCoords(e,t);return this._gauge.stageToLocal(a)}UpdateActiveElement(e,t){}__isMouseEditing(){return this.IsMouseEditing}StopMouseEditing(e){this.IsMouseEditing=!1;var t=this.GetRelativePosition(e.pageX,e.pageY);this._gauge.__processValueChangeEnd(t.x,t.y)}}class o extends t.KeyboardHandler{constructor(e,t){super(e),this._gauge=t}processKeyDown(e){var a=e.keyCode,i=t.Agent.isRightToLeft(this._gauge.getCtx()),s=this._gauge.getOptions().value;this._gauge.getOptions().readOnly||(a!==t.KeyboardEvent.ENTER&&a!==t.KeyboardEvent.TAB||this._oldValue===s?a===t.KeyboardEvent.UP_ARROW||a===(i?t.KeyboardEvent.LEFT_ARROW:t.KeyboardEvent.RIGHT_ARROW)?(this._gauge.__increaseValue(),t.EventManager.consumeEvent(e)):a!==t.KeyboardEvent.DOWN_ARROW&&a!==(i?t.KeyboardEvent.RIGHT_ARROW:t.KeyboardEvent.LEFT_ARROW)||(this._gauge.__decreaseValue(),t.EventManager.consumeEvent(e)):(this._gauge.dispatchEvent(t.EventFactory.newValueChangeEvent(this._oldValue,s,!0)),this._oldValue=null),null===this._oldValue&&(this._oldValue=s))}}const l={getColor:e=>{var t=e.getOptions(),a=i.getValThresholdIdx(e),s=i.getThreshold(e,a);return s&&("statusMeter"!==e.type||"statusMeter"===e.type&&"onIndicator"===t.thresholdDisplay)?l.getThresholdColor(e,s,a):t.color},getBorderColor:e=>{var t=e.getOptions(),a=i.getValThresholdIdx(e),s=i.getThreshold(e,a);return s&&s.borderColor&&("statusMeter"!==e.type||"statusMeter"===e.type&&"onIndicator"===t.thresholdDisplay)?s.borderColor:t.borderColor},getPlotAreaColor:e=>{var t=e.getOptions(),a=i.getValThresholdIdx(e),s=i.getThreshold(e,a);return s&&("statusMeter"!==e.type||"statusMeter"===e.type&&"onIndicator"!==t.thresholdDisplay)?l.getThresholdColor(e,s,a):t.plotArea.color},getPlotAreaBorderColor:e=>{var t=e.getOptions(),a=t.plotArea.borderColor;return"statusMeter"===e.type&&"circular"==t.orientation?null:a},getThresholdColor:(e,t,a)=>{if(t.color)return t.color;var i=e.getOptions(),s=a%i._thresholdColors.length;return i._thresholdColors[s]}};class h extends t.BaseComponent{constructor(e,a,i,s){super(e,a,i),e.getStage().setCursor(""),this._bStaticRendering=s,this._bStaticRendering||(this.EventManager=this.CreateEventManager(),this.EventManager.addListeners(this),this.EventManager.setKeyboardHandler(this.CreateKeyboardHandler(this.EventManager)),this.setId("gauge1000"+Math.floor(1e9*Math.random())),this._editingOverlay=new t.Rect(e,0,0),this._editingOverlay.setInvisibleFill(),this.addChild(this._editingOverlay)),this._bEditing=!1,this._bResizeRender=!1,this._oldValue=null}SetOptions(e){super.SetOptions(e),this.Options=e,t.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none"),"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||"auto"!==this.Options.visualEffects||(this.Options.visualEffects="none"),e.className&&(this.Options.svgClassName=e.className),e.style&&(this.Options.svgStyle=e.style)}render(e,a,i){if(e?this.SetOptions(e):this.Options||this.SetOptions(null),this.Options.thresholds){var s=this.Options.thresholds;this.Options.thresholds=s.sort(h._thresholdComparator)}"number"==typeof a&&"number"==typeof i&&(0!==this.Width&&this.Width!==a||0!==this.Height&&this.Height!==i?this._bResizeRender=!0:this._bResizeRender=!1,this.Width=a,this.Height=i),this.__oldShapes=this.__shapes,this.__shapes=[];var n=new t.Container(this.getCtx());this.addChildAt(n,0),!1!==this.Render(n,this.Width,this.Height)&&this.PostRender(e,n)}PostRender(e,a){this._setAnimation(a,null!=e,this.__oldShapes,this.Width,this.Height),this._editingOverlay&&(this._editingOverlay.setWidth(this.Width),this._editingOverlay.setHeight(this.Height),this.getEventManager().associate(this._editingOverlay,this.__getLogicalObject(),!0)),this.UpdateAriaAttributes(),this._bStaticRendering||this.Options.readOnly||this.setAriaAttributes(),this.Options._selectingCursor&&this.setCursor(t.SelectionEffectUtils.getSelectingCursor()),this.Animation||this.RenderComplete()}setAriaAttributes(){var e=this.getCtx().getContainer();e.setAttribute("role","slider"),e.setAttribute("aria-valuemin",this.Options.min),e.setAttribute("aria-valuemax",this.Options.max),e.setAttribute("aria-valuenow",this.Options.value);var t=s.getFormattedMetricLabel(this.Options.value,this);Number(t)===this.Options.value&&(t=this.Options.value.toString()),e.setAttribute("aria-valuetext",t),this.Options.disabled&&e.setAttribute("aria-disabled",!0)}__getLogicalObject(){var e=this.Options.tooltip,a=e?e.renderer:null,i=l.getColor(this);if(a){var n={component:this.Options._widgetConstructor,label:s.getFormattedMetricLabel(this.Options.value,this),color:i};return new t.CustomDatatipPeer(this.getCtx().getTooltipManager(),a,i,n)}var r=s.getTooltipString(this);return new t.SimpleObjPeer(null,r,i)}Render(e,t,a){}_setAnimation(e,a,i,s,n){this.StopAnimation();var r=!1,o=this._bEditing||this._bResizeRender?"none":this.getOptions().animationOnDataChange,l=this._bEditing||this._bResizeRender?"none":this.getOptions().animationOnDisplay,h=t.CSSStyle.getTimeMilliseconds(this.getOptions().animationDuration)/1e3;if(l||o){var d=new t.Rectangle(0,0,s,n),g=this.getCtx();this._container||"none"===l||null==this.__shapes[0]?this._container&&"none"!==o&&a&&null!=this.__shapes[0]&&(this.Animation=t.BlackBoxAnimationHandler.getCombinedAnimation(g,o,this._container,e,d,h),this.Animation?r=!0:this.Animation=this.CreateAnimOnDataChange(i,this.__shapes,l,h)):(this.Animation=t.BlackBoxAnimationHandler.getInAnimation(g,l,e,d,h),this.Animation||(this.Animation=this.CreateAnimOnDisplay(this.__shapes,l,h))),!r&&this._container&&(this.removeChild(this._container),this._container.destroy()),this.Animation&&(this.Animation.play(),this.Animation.setOnEnd(this._onAnimEnd,this)),r&&(this._oldContainer=this._container),this._container=e}}CreateAnimOnDisplay(e,t,a){return null}CreateAnimOnDataChange(e,a,i,s){for(var n=[],r=0;r<e.length;r++){var o=e[r],l=a[r],h=o.getAnimParams(),d=l.getAnimParams();l.setAnimParams(h);var g=new t.CustomAnimation(this.getCtx(),l,s);g.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,l,l.getAnimParams,l.setAnimParams,d),n.push(g)}return new t.ParallelPlayable(this.getCtx(),n)}GetValueAt(e,t){return null}renderUpdate(){this.render()}_onAnimEnd(){this._oldContainer&&(this.removeChild(this._oldContainer),this._oldContainer.destroy(),this._oldContainer=null),this.AnimationStopped||this.RenderComplete(),this.Animation=null,this.AnimationStopped=!1}__processValueChangeStart(e,t){this._bEditing=!0,this._oldValue=this.Options.value,this.__processValueChangeMove(e,t)}__processValueChangeMove(e,a){if(null!=this._oldValue){var i=s.adjustForStep(this.Options,this.GetValueAt(e,a));i!==this.Options.value&&(this.Options.value=i,this.renderUpdate(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(this._oldValue,this.Options.value,!1)))}}__processValueChangeEnd(e,a){if(this.__processValueChangeMove(e,a),t.Agent.isTouchDevice()){var i=s.getFormattedMetricLabel(this.Options.value,this),n=s.getTooltipString(this);i!==n&&(n=i+t.AriaUtils.ARIA_LABEL_DESC_DELIMITER+n,this._container.setAriaProperty("label",n))}this.dispatchEvent(t.EventFactory.newValueChangeEvent(this._oldValue,this.Options.value,!0)),this._bEditing=!1,this._oldValue=null}__increaseValue(){if(!this.Options.readOnly){var e=this.Options.value;if(null!=this.Options.step){var a=this.Options.value+this.Options.step;this.Options.value=s.adjustForStep(this.Options,a)}else{var i=(this.Options.max-this.Options.min)/100;this.Options.value=Math.min(Math.max(this.Options.value+i,this.Options.min),this.Options.max)}this.renderUpdate(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(e,this.Options.value,!1))}}__decreaseValue(){if(!this.Options.readOnly){var e=this.Options.value;if(null!=this.Options.step){var a=this.Options.value-this.Options.step;this.Options.value=s.adjustForStep(this.Options,a)}else{var i=(this.Options.max-this.Options.min)/100;this.Options.value=Math.min(Math.max(this.Options.value-i,this.Options.min),this.Options.max)}this.renderUpdate(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(e,this.Options.value,!1))}}CreateEventManager(){return new r(this)}static _thresholdComparator(e,t){return null!=e.max&&null!=t.max?e.max-t.max:e.max?-1/0:1/0}getAutomation(){return new n(this)}CreateKeyboardHandler(e){return new o(e,this)}UpdateAriaAttributes(){if(!this._bStaticRendering){var e=s.getTooltipString(this);if(this.IsParentRoot()){var a=this.Options.translations;this.getCtx().setAriaLabel(t.ResourceUtils.format(a.labelAndValue,[a.labelDataVisualization,t.Displayable.generateAriaLabel(t.AriaUtils.processAriaLabel(this.GetComponentDescription()),e?[e]:null)])),this.IsInteractive()?this.getCtx().setAriaRole("slider"):this.getCtx().setAriaRole("img")}else this.IsInteractive()||(this.setAriaRole("img"),this.setAriaProperty("label",t.Displayable.generateAriaLabel(t.AriaUtils.processAriaLabel(this.GetComponentDescription()),e?[e]:null)))}}IsInteractive(){return!this.Options.readOnly}}class d extends t.BaseComponentDefaults{constructor(e){const a={skin:t.CSSStyle.SKIN_ALTA,min:0,max:100,center:{},color:"#393737",borderColor:null,visualEffects:"auto",emptyText:null,animationOnDataChange:"none",animationOnDisplay:"none",animationDuration:500,readOnly:"true",metricLabel:{rendered:"auto",scaling:"auto",style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),textType:"number"},_statusMessageStyle:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),label:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),position:"auto"},_thresholdColors:["#ed6647","#fad55c","#68c182"],__layout:{outerGap:1,labelGap:5}};super({alta:t.JsonUtils.merge(e.alta,a)})}}class g extends d{constructor(e){super({alta:{type:"circle"}},e)}}const u={_SHAPE_TRIANGLE_CMDS:[-50,36.6,0,-50,50,36.6],_SHAPE_STAR_CMDS:"M 13.686617627555295 -14.844072859624454 L 0 -49.99999973529656 L -13.686617627555295 -14.844072859624454 L -49.21031057098533 -11.804119976838445 L -22.1446397569434 12.966333294730747 L -30.4142789122285 49.99999973529656 L 0 30.151376755728354 L 30.4142789122285 49.99999973529656 L 22.1446397569434 12.966333294730747 L 49.21031057098533 -11.804119976838445 Z ",_SHAPE_ARROW_CMDS:[25,48,25,8,47.5,8,0,-39,-47.5,8,-25,8,-25,48],_SHAPE_HUMAN_CMDS:"M -0.06059525142297417 -50.86842065108466 C -11.4496388584463 -50.86842065108466 -20.708163169810554 -39.024253028220556 -20.708163169810554 -24.413724255650386 C -20.708163169810554 -9.803195483080515 -11.4496388584463 2.040972139783591 -0.06059525142297417 2.040972139783591 C 11.328499974520241 2.040972139783591 20.586972666964613 -9.803195483080515 20.586972666964613 -24.413724255650386 C 20.586972666964613 -39.024253028220556 11.328499974520241 -50.86842065108466 -0.06059525142297417 -50.86842065108466 z M -23.93434565705865 -2.959610715450779 C -30.908061721494278 3.3998402034127153 -42.00096758564793 18.817121073473572 -38.77478509839983 33.65756051481475 C -20.651382358034887 47.30044101688934 14.372054723529814 49.13162219665128 39.298831093003386 32.85101489300273 C 40.26410489318826 16.477493533721187 32.34060070450674 4.7883891459240715 23.167918656763206 -2.959610715450779 C 11.553661702670112 21.074158341552575 -11.029615708066558 16.237465556670102 -23.93434565705865 -2.959610715450779 z ",render:(e,a,n,r)=>{if(i.hasData(e)){var o=e.getOptions(),h=o.__layout.outerGap,d=o&&(o.size>=0||o.size<1)?Math.sqrt(o.size):1,g=new t.Rectangle(h+(n-2*h)*(1-d)/2,h+(r-2*h)*(1-d)/2,(n-2*h)*d,(r-2*h)*d);u._renderShape(e,a,g);var c=!1,p=t.ColorUtils.getContrastingTextColor(l.getColor(e));if(o.label.text){var _="middle",v=u._getMetricLabelBounds(e,a,g);"on"===o.metricLabel.rendered&&(v.y=v.y+.6*v.h,v.h=.4*v.h,_="top"),c=t.Agent.isHighContrast()||null==o.label.style.getStyle("color")?s.renderLabel(e,a,v,p,_):s.renderLabel(e,a,v,null,_)}if("on"===o.metricLabel.rendered){var m=u._getMetricLabelBounds(e,a,g),x="middle";c&&(m.h=.55*m.h,x="bottom"),t.Agent.isHighContrast()||null==o.metricLabel.style.getStyle("color")?s.renderMetricLabel(e,a,m,p,"center",x):s.renderMetricLabel(e,a,m,null,"center",x)}}else s.renderEmptyText(e,a,new t.Rectangle(0,0,n,r))},_renderShape:(e,a,i)=>{var s,n,r=e.getCtx(),o=e.getOptions(),h=o.type,d=l.getColor(e),g=l.getBorderColor(e),c=i.x+i.w/2,p=i.y+i.h/2,_=Math.min(i.w,i.h)/2;u._cache||(u._cache=new t.Cache(50));var v=Math.min(i.w/100,i.h/100);if("square"===h)s=new t.Rect(r,c-_,p-_,2*_,2*_);else if("rectangle"==h)s=new t.Rect(r,i.x,i.y,i.w,i.h);else if("diamond"===h)s=new t.Polygon(r,[c-_,p,c,p-_,c+_,p,c,p+_]);else if("circle"===h)s=new t.Circle(r,c,p,_);else{if("star"===h)n=u._SHAPE_STAR_CMDS;else if("triangle"===h)n=u._SHAPE_TRIANGLE_CMDS;else if("arrow"===h)n=u._SHAPE_ARROW_CMDS;else if("human"===h)n=u._SHAPE_HUMAN_CMDS;else if(!(n=u._cache.get(h))){s=new t.Path(r,h);var m=t.DisplayableUtils.getDimForced(r,s),x=100/Math.max(m.w,m.h);n=t.PathUtils.transformPath(s.getCommandsArray(),-x*(m.x+m.w/2),-x*(m.y+m.h/2),x,x),u._cache.put(h,n)}"triangle"===h||"arrow"===h?(n=t.PolygonUtils.scale(n,v,v),n=t.PolygonUtils.translate(n,i.x+i.w/2,i.y+i.h/2),s=new t.Polygon(r,n)):(n=t.PathUtils.transformPath(t.PathUtils.createPathArray(n),i.x+i.w/2,i.y+i.h/2,v,v),s=new t.Path(r,n))}var C=e.getCtx().getThemeBehavior();if("none"===o.visualEffects||"redwood"===C)s.setSolidFill(d);else{var y=[t.ColorUtils.adjustHSL(d,0,-.09,.04),t.ColorUtils.adjustHSL(d,0,-.04,-.05)],b=o&&o.rotation%90==0?o.rotation:0,S="arrow"===h||"star"===h||"triangle"===h?b-90:270;s.setFill(new t.LinearGradientFill(S,y,[1,1],[0,1]))}g&&s.setSolidStroke(g),s.setClassName(o.svgClassName),s.setStyle(o.svgStyle),(b=o.rotation)&&("arrow"===h||"triangle"===h||s instanceof t.Path&&"human"!==h&&"star"!==h)&&(s=u._rotate(e,a,s,i)),a.addChild(s)},_rotate:(e,a,i,s)=>{var n=e.getOptions(),r=new t.Container(e.getCtx());a.addChild(r),r.addChild(i);var o=n&&n.rotation%90==0?n.rotation:0,l=new t.Matrix;i.setMatrix(l.rotate(Math.PI*o/180));var h=r.getDimensions(),d=s.x+s.w/2-(h.x+h.w/2),g=s.y+s.h/2-(h.y+h.h/2),u=new t.Matrix;return r.setMatrix(u.translate(d,g)),r},_getMetricLabelBounds:(e,a,i)=>{var s=e.getOptions(),n=s.type,r=s.rotation%90==0?s.rotation:0,o=Math.min(i.w,i.h),l=i.x+i.w/2-o/2,h=i.y+i.h/2-o/2,d=o,g=o;return"triangle"===n?0===r?(l+=.2*o,h+=.25*o,d-=.4*o,g-=.3*o):90===r?(l+=.05*o,h+=.2*o,d-=.3*o,g-=.4*o):180===r?(l+=.2*o,h+=.05*o,d-=.4*o,g-=.3*o):270===r&&(l+=.25*o,h+=.2*o,d-=.3*o,g-=.4*o):"arrow"===n?0===r?(l+=.2*o,h+=.2*o,d-=.4*o,g-=.4*o):90===r?(l+=.05*o,h+=.2*o,d-=.28*o,g-=.4*o):180===r?(l+=.2*o,h+=.2*o,d-=.4*o,g-=.4*o):270===r&&(l+=.23*o,h+=.2*o,d-=.28*o,g-=.4*o):"star"===n?(l+=.25*o,h+=.25*o,d-=.5*o,g-=.4*o):"diamond"===n?(l+=.15*o,h+=.15*o,d-=.3*o,g-=.3*o):"rectangle"===n?(l+=.1*o,h+=.1*o,d-=.2*o,g-=.2*o):(l+=.15*o,h+=.15*o,d-=.3*o,g-=.3*o),new t.Rectangle(l,h,d,g)}};class c extends h{constructor(e,t,a,i){super(e,t,a,i),this.type="led",this.Defaults=new g(e)}SetOptions(e){(e=t.JsonUtils.clone(e)).title&&(e.label=e.title),super.SetOptions(this.Defaults.calcOptions(e)),"auto"===this.Options.animationOnDisplay&&(this.Options.animationOnDisplay="zoom"),"auto"===this.Options.animationOnDataChange&&(this.Options.animationOnDataChange="alphaFade"),this.Options.readOnly=!0}Render(e,t,a){u.render(this,e,t,a)}}class p extends d{constructor(e){super({alta:{min:0,max:5,orientation:"horizontal",unselectedState:{shape:"star",color:"#C4CED7"},selectedState:{shape:"star",color:"#F8C15A"},hoverState:{shape:"star",color:"#007CC8"},changedState:{shape:"star",color:"#ED2C02"},preserveAspectRatio:"meet",step:1}},e)}}class _ extends r{constructor(e){super(e),this._gauge=e}OnMouseOver(e){if(this._gauge.IsInteractive()){var t=this.GetRelativePosition(e.pageX,e.pageY);this._gauge.__processValueChangeStart(t.x,t.y),this.IsMouseEditing=!0}super.OnMouseOver(e)}OnMouseOut(e){if(this._gauge.IsInteractive()){var t=this.GetRelativePosition(e.pageX,e.pageY);this._gauge.__processHoverEnd(t.x,t.y),this.IsMouseEditing=!1}super.OnMouseOut(e)}OnMouseMove(e){var t=this.GetRelativePosition(e.pageX,e.pageY),a=!0===this._gauge.getOptions().disabled;this._gauge.IsInteractive()&&!this.IsMouseEditing&&this._gauge.getOptions().value!==this._gauge.GetValueAt(t.x,t.y)&&(this.IsMouseEditing=!0),a||super.OnMouseMove(e)}OnMouseDown(e){t.EventManager.prototype.OnMouseDown.call(this,e)}OnContextMenu(e){var a=t.Agent.engine;"webkit"!==a&&"blink"!==a||"mac"!==t.Agent.os||this.IsMouseEditing&&this.StopMouseEditing(e),super.OnContextMenu(e)}ProcessKeyboardEvent(e){return this.IsMouseEditing=!1,super.ProcessKeyboardEvent(e)}IsShowingTooltipWhileEditing(){return!0}}class v extends t.SimpleObjPeer{constructor(e){super(),this._gauge=e}getDatatip(e,t,a){var s,n=this._gauge.getOptions();s=this._gauge.getEventManager().__isMouseEditing()?i.getValThresholdIdx(this._gauge,this._gauge.GetValueAt(t,a)):i.getValThresholdIdx(this._gauge);var r=i.getThreshold(this._gauge,s);return r&&r.shortDesc?r.shortDesc:n.shortDesc}}const m={render:(e,a,n,r)=>{if(i.hasData(e)){var o=e.getOptions(),l=i.getValThresholdIdx(e),h=i.getThreshold(e,l),d=o.selectedState.color,g=o.changedState.color,u=o.selectedState.borderColor,c=o.changedState.borderColor;h&&h.color&&(d=h.color,g=h.color),h&&h.borderColor&&(u=h.borderColor,c=h.borderColor);var p={value:0,state:"unselected",type:o.unselectedState.shape,color:o.unselectedState.color,borderColor:o.unselectedState.borderColor,visualEffects:o.visualEffects,source:o.unselectedState.source,svgClassName:o.unselectedState.svgClassName,svgStyle:o.unselectedState.svgStyle},_={value:0,state:"selected",type:o.selectedState.shape,color:d,borderColor:u,visualEffects:o.visualEffects,source:o.selectedState.source,svgClassName:o.selectedState.svgClassName,svgStyle:o.selectedState.svgStyle},v={value:0,state:"changed",type:o.changedState.shape,color:g,borderColor:c,visualEffects:o.visualEffects,source:o.changedState.source,svgClassName:o.changedState.svgClassName,svgStyle:o.changedState.svgStyle},x={value:0,state:"hover",type:o.hoverState.shape,color:o.hoverState.color,borderColor:o.hoverState.borderColor,visualEffects:o.visualEffects,source:o.hoverState.source,svgClassName:o.hoverState.svgClassName,svgStyle:o.hoverState.svgStyle};"dot"==o.unselectedState.shape&&(p.type="circle",p.visualEffects="none",p.size=.05),m._createShapes(e,a,p),m._createShapes(e,a,o.changed?v:_),o.readOnly||o.disabled||m._createShapes(e,a,x),e.__updateClipRects(o.value,"render",a)}else s.renderEmptyText(e,a,new t.Rectangle(0,0,n,r))},_createShapes:(e,a,i)=>{var s=e.getCtx(),n=new t.Container(s);a.addChild(n);for(var r=e.getOptions(),o=e.__bounds,l=e.__shapeWidth,h=e.__shapeHeight,d="ie"===t.Agent.browser||"edge"===t.Agent.browser?null:m._createShape(s,0,0,l,h,i,r),g=0;g<r.max;g++){var u,c;if("vertical"==r.orientation?(u=o.x+o.w/2-l/2,c=o.y+o.h-(g+1)*h):t.Agent.isRightToLeft(s)?(u=o.x+o.w-(g+1)*l,c=o.y+o.h/2-h/2):(u=o.x+g*l,c=o.y+o.h/2-h/2),"ie"===t.Agent.browser||"edge"===t.Agent.browser){var p=m._createShape(s,u,c,l,h,i,r);p&&n.addChild(p)}else if(d){var _=new t.Use(s,u,c,d);n.addChild(_)}}},_createShape:(e,a,i,s,n,r,o)=>{var l;if(r.source)l=new t.ImageMarker(e,a+s/2,i+n/2,s,n,null,r.source),"none"===o.preserveAspectRatio&&l.setPreserveAspectRatio("none");else if("none"!=r.type){if(l=new c(e,null,null,!0),0!=a&&0!=i&&l.setTranslate(a,i),o.disabled||t.Agent.isHighContrast()){var h=`oj-rating-gauge-${"unselected"===r.state?"unselected":"selected"}${o.disabled?"-disabled":""}`;o.disabled?(r.svgClassName=h,r.svgStyle=null):r.svgClassName=`${r.svgClassName||""} ${h}`.trim(),t.Agent.isHighContrast()&&l.addClassName("oj-hicontrast")}l.render(r,s,n)}return l}};class x extends d{constructor(e){super({alta:{angleExtent:360,borderRadius:"auto",color:"#393737",indicatorSize:1,innerRadius:.7,metricLabel:{style:new t.CSSStyle(t.BaseComponentDefaults.FONT_FAMILY_ALTA),position:"auto"},orientation:"horizontal",plotArea:{color:"#E4E8EA",rendered:"auto",borderRadius:"auto"},startAngle:90,thresholdDisplay:"onIndicator"}},e)}}class C extends(a.DataAxisInfoMixin(a.BaseAxisInfo)){}const y={calcPointOnArc:(e,t,a)=>({x:Math.cos(a)*t+e.w/2+e.x,y:Math.sin(a)*t+e.h/2+e.y}),createCircularPathCmd:(e,a,i,s,n)=>{var r,o,l,h,d;return i<t.Math.TWO_PI?(o=y.calcPointOnArc(e,n,a),l=y.calcPointOnArc(e,n,a+i),h=y.calcPointOnArc(e,s,a+i),d=y.calcPointOnArc(e,s,a),r=t.PathUtils.moveTo(o.x,o.y)+t.PathUtils.arcTo(n,n,i,1,l.x,l.y)+t.PathUtils.lineTo(h.x,h.y)+t.PathUtils.arcTo(s,s,i,0,d.x,d.y)+t.PathUtils.closePath()):(o=y.calcPointOnArc(e,n,a),l=y.calcPointOnArc(e,n,a+i/2),h=y.calcPointOnArc(e,s,a),d=y.calcPointOnArc(e,s,a+i/2),r=t.PathUtils.moveTo(o.x,o.y)+t.PathUtils.arcTo(n,n,i/2,1,l.x,l.y)+t.PathUtils.arcTo(n,n,i/2,1,o.x,o.y),s>0&&(r+=t.PathUtils.moveTo(d.x,d.y)+t.PathUtils.arcTo(s,s,i/2,0,h.x,h.y)+t.PathUtils.arcTo(s,s,i/2,0,d.x,d.y)),r+=t.PathUtils.closePath()),r}};class b extends t.Path{constructor(e,t,a,i,s,n){super(e),this.setPath(t,a,i,s,n)}setPath(e,a,i,s,n){e&&e instanceof t.Rectangle?this._bounds=e:e=this._bounds,this._startAngle=a,this._angleExtent=i,this._innerRadius=s,this._outerRadius=n,this.setCmds(y.createCircularPathCmd(e,a,i,s,n))}getAnimParams(){return[this._bounds,this._startAngle,this._angleExtent,this._innerRadius,this._outerRadius]}setAnimParams(e){e&&5==e.length&&this.setPath(e[0],e[1],e[2],e[3],e[4])}}class S extends t.Path{constructor(e,t,a,i,s,n){super(t),this._gauge=e,this.setCoords(a,i,s,n)}setCoords(e,a,i,s){this._x1=e,this._x2=a,this._y1=i,this._y2=s;var n=Math.min(e,a),r=Math.min(i,s),o=Math.abs(e-a),l=Math.abs(s-i),h=this._gauge.getOptions(),d="vertical"==h.orientation?o:l,g=t.PathUtils.rectangleWithBorderRadius(n,r,o,l,h.borderRadius,d,"15%");this.setCmds(g)}getAnimParams(){return[this._x1,this._x2,this._y1,this._y2]}setAnimParams(e){e&&4===e.length&&this.setCoords(e[0],e[1],e[2],e[3])}}const w={render:(e,a,n,r)=>{if(i.hasData(e)){var o=e.getOptions(),l=o.__layout.outerGap,h=new t.Rectangle(l,l,n-2*l,r-2*l);"horizontal"==o.orientation||"vertical"==o.orientation?(w._hasMetricLabelOutsidePlotArea(o)&&w._renderMetricLabelOutsidePlotArea(e,a,h),w._renderShape(e,a,h)):"circular"==o.orientation&&w._renderCircularGauge(e,a,h)}else s.renderEmptyText(e,a,new t.Rectangle(0,0,n,r))},_renderCircularGauge:(e,a,i)=>{var n,r=e.getOptions(),o=i.clone(),h=t.Agent.isRightToLeft(e.getCtx()),d=0,g=null,u=r.value,c=r.innerRadius,p=r.thresholds,_=null,v=t.Math.TWO_PI-t.Math.degreesToRads(r.startAngle),m=t.Math.degreesToRads(r.angleExtent),x=(v+m)%(2*Math.PI);e.cx=i.w/2,e.cy=i.h/2,m!=2*Math.PI&&(g=w._adjustCenterAndBounds(e,c,v,m,x,i,h),_=e.maxInnerDiameter);var C=.5*(n=Math.min(i.w,i.h))*c,y=.5*n,b=r.indicatorSize;if(b&&b>1){var S=(1-1/b)/2*(y-C);C+=S,y-=S}var A="middle";g||(_=Math.min(i.w,i.h)*c,g=new t.Rectangle(i.x+i.w/2-_*(3/7),i.y+i.h/2-_*(2.5/7),_*(6/7),_*(5/7)));if(r.label.text){var O="middle",M=new t.Rectangle(g.x,g.y,g.w,g.h);"off"!=r.metricLabel.rendered&&(M.y=M.y+.6*M.h,M.h=.4*M.h,O="top"),s.renderLabel(e,a,M,null,O)&&"off"!=r.metricLabel.rendered&&(g.h=.55*g.h,A="bottom")}s.renderMetricLabel(e,a,g,null,"center",A,!0);var f=v,P=d*m,E=l.getPlotAreaBorderColor(e);if(p&&"off"!=r.plotArea.rendered&&"all"==r.thresholdDisplay)for(var R=0;R<p.length;R++){var T=l.getThresholdColor(e,p[R],R),L=p[R].max<r.max&&R!=p.length-1?p[R].max:r.max,I=0==R?r.min:p[R-1].max;f=v+m*s.getFillPercentage(r,r.min,L,I),P=(d=s.getFillPercentage(r,I,L,L))*m;var D=p[R].borderColor;w._drawCircularArc(e,a,i,f,P,C,y,T,!0,D||E)}else if("off"!=r.plotArea.rendered&&"all"!=r.thresholdDisplay){var F=l.getPlotAreaColor(e);w._drawCircularArc(e,a,i,v,m,C,y,F,!0,E)}if(C=n*c*.5,y=.5*n,b&&b<1){var U=(1-b)/2*(y-C);C+=U,y-=U}P=(d=s.getFillPercentage(r,r.min,r.max,u))*m,w._drawCircularArc(e,a,i,v,P,C,y,l.getColor(e),!1);var V=r.referenceLines;if(V)for(var N=0;N<V.length;N++){var H=V[N].color?V[N].color:"black",z=V[N].lineWidth?V[N].lineWidth:2,W=V[N].lineStyle;u=V[N].value;var G=v+s.getFillPercentage(r,r.min,r.max,u)*m;w._drawCircularReferenceLine(e,a,i,G,H,z,W)}r.center.renderer&&w._renderCenterContent(e,r,i,o,_)},_renderShape:(e,a,i)=>{var s=e.getOptions(),n=t.Agent.isRightToLeft(e.getCtx()),r="vertical"==s.orientation,o={isRTL:n,layout:{gapRatio:0},timeAxisType:"disabled",position:r?"left":"bottom",min:s.min,max:s.max,dataMin:s.min,dataMax:s.max,tickLabel:{rendered:"off"},translations:s.translations},h=new C(e.getCtx(),o,i);e.__axisInfo=h;var d=0;s.max<=0?d=s.max:s.min>=0&&(d=s.min);var g=h.getCoordAt(d);"off"==s.plotArea.rendered||"auto"==s.plotArea.rendered&&"onIndicator"==s.thresholdDisplay||(g=h.getUnboundedCoordAt(s.min));var u=h.getUnboundedCoordAt(s.value);u=r?Math.max(i.y,Math.min(i.y+i.h,u)):Math.max(i.x,Math.min(i.x+i.w,u));var c,p,_,v,m,x,y,b,A=s.indicatorSize,O=0,M=A<1?1:A,f=A>1?1:A,P=Math.min(.5,(Math.abs(u-g)-.5)/2);r?(b=u>g?-1:1,c=i.x+(1-f)/2*i.w,p=i.x+i.w*(1+f)/2,v=g-b*P,_=u+b*P+.5,m=i.x+(1-1/M)/2*i.w,x=i.x+i.w*(1+1/M)/2,y=i.y,O=i.y+i.h):(b=(n?u>g:u<g)?-1:1,c=n?g-b*P+.5:g+b*P-.5,p=n?u+b*P:u-b*P,_=i.y+(1-f)/2*i.h,v=i.y+i.h*(1+f)/2,m=i.x,x=i.x+i.w,y=i.y+(1-1/M)/2*i.h,O=i.y+i.h*(1+1/M)/2);var E=!0;s.value==s.min&&(r?_=v:c=p,E=!1);var R,T,L=l.getBorderColor(e),I=l.getPlotAreaBorderColor(e),D=s.thresholds,F=r?0:270;if(D&&"off"!=s.plotArea.rendered&&"all"==s.thresholdDisplay)for(T=D.length-1;T>=0;T--){var U=T;R=w._createShape(e,e.getCtx(),m,x,y,O);var V=new t.ClipPath("pacp"+e.getId());if(T==D.length-1)!r&&n?V.addRect(h.getUnboundedCoordAt(s.max)+1,0,i.w+2,i.h+2,0,0):V.addRect(0,0,i.w+2,i.h+2,0,0);else if(r){var N=s.max-D[D.length-2-U].max;V.addRect(0,h.getUnboundedCoordAt(s.max),i.w+2,1*Math.max(0,N)/Math.abs(s.min-s.max)*i.h,0,0)}else if(n){var H=null==D[D.length-2-U].max?100:D[D.length-2-U].max;V.addRect(h.getUnboundedCoordAt(s.max),0,1*Math.max(0,s.max-H)/Math.abs(s.min-s.max)*i.w,i.h+2,0,0)}else{var z=D[U].max-s.min;V.addRect(0,0,1*Math.max(0,z)/Math.abs(s.min-s.max)*i.w,i.h+2,0,0)}R.setClipPath(V),(n||r)&&(U=D.length-1-T),R.setSolidFill(l.getThresholdColor(e,D[U],U));var W=D[U].borderColor;R.setSolidStroke(W||I),w._renderPlotAreaVisualEffects(e,a,R,l.getThresholdColor(e,D[U],U),F)}else if("off"!==s.plotArea.rendered&&("auto"!=s.plotArea.rendered||"onIndicator"!=s.thresholdDisplay)&&"all"!=s.thresholdDisplay){R=r?w._createShape(e,e.getCtx(),m,x,h.getUnboundedCoordAt(s.max),h.getUnboundedCoordAt(s.min)):w._createShape(e,e.getCtx(),h.getUnboundedCoordAt(s.min),h.getUnboundedCoordAt(s.max),y,O);var G=l.getPlotAreaColor(e);R.setSolidFill(G),R.setSolidStroke(I),w._renderPlotAreaVisualEffects(e,a,R,G,F)}var B=new S(e,e.getCtx(),c,p,_,v);e.__shapes.push(B);var j,k,K,Y,X=l.getColor(e);if("redwood"===e.getCtx().getThemeBehavior()||"none"===s.visualEffects)B.setSolidFill(X),B.setSolidStroke(X);else{var q=[t.ColorUtils.adjustHSL(X,0,-.09,.04),t.ColorUtils.adjustHSL(X,0,-.04,-.05)],J=new t.LinearGradientFill(F,q,[1,1],[0,1]);B.setFill(J)}L&&B.setSolidStroke(L),B.setClassName(s.svgClassName),B.setStyle(s.svgStyle),E&&a.addChild(B),w._createShape(e,e.getCtx(),c,p,_,v);var $=s.referenceLines;if($)for(T=0;T<$.length;T++){var Q=$[T].color?$[T].color:"white",Z=$[T].value;A=s.indicatorSize,r?(Y=((1-A)/2+A)*i.w,j=i.x+(1-A)/4*i.w,k=h.getUnboundedCoordAt(Z),K=new t.Line(e.getCtx(),j,k,j+Y,k)):(Y=((1-A)/2+A)*i.h,j=h.getUnboundedCoordAt(Z),k=i.y+(1-A)/4*i.h,K=new t.Line(e.getCtx(),j,k,j,k+Y));var ee=$[T].lineWidth?$[T].lineWidth:2,te=$[T].lineStyle,ae=new t.Stroke(Q,1,ee,!1,t.Stroke.getDefaultDashProps(te,ee));if(K.setStroke(ae),a.addChild(K),"ie"!==t.Agent.browser&&"edge"!==t.Agent.browser&&"none"!=s.visualEffects){var ie=new t.Shadow(.5,.5,1,"rgba(0, 0, 0, 0.8)");K.addDrawEffect(ie)}}var se=s.metricLabel.position;if("on"!=s.metricLabel.rendered||w._hasMetricLabelOutsidePlotArea(s)||s.label.text)s.label.text&&w._renderLabel(e,a,i,se);else{var ne={x1:c,x2:p,y1:_,y2:v},re={x1:m,x2:x,y1:y,y2:O};w._renderMetricLabelInsidePlotArea(e,a,i,X,se,ne,re)}},_createShape:(e,a,i,s,n,r)=>{var o=Math.min(i,s),l=Math.min(n,r),h=Math.abs(i-s),d=Math.abs(r-n),g=e.getOptions(),u="vertical"==g.orientation?h:d,c="auto"!=g.plotArea.borderRadius?g.plotArea.borderRadius:g.borderRadius,p=t.PathUtils.rectangleWithBorderRadius(o,l,h,d,c,u,"15%");return new t.Path(a,p)},_renderPlotAreaVisualEffects:(e,a,i,s,n)=>{var r=e.getOptions();if(i.setMouseEnabled(!1),a.addChild(i),"redwood"!==e.getCtx().getThemeBehavior()&&"none"!==r.visualEffects){var o=[t.ColorUtils.adjustHSL(s,0,-.04,-.05),t.ColorUtils.adjustHSL(s,0,-.09,.04)],l=new t.LinearGradientFill(n,o,[1,1],[0,1]);i.setFill(l)}i.setClassName(r.plotArea.svgClassName),i.setStyle(r.plotArea.svgStyle)},_renderMetricLabelOutsidePlotArea:(e,a,i)=>{var n=e.getOptions(),r=t.Agent.isRightToLeft(e.getCtx()),o="vertical"==n.orientation,l=new t.OutputText(e.getCtx(),""),h=s.getFormattedMetricLabel(n.value,e),d=n.__layout.labelGap,g=n.metricLabel.style,u=g.getStyle("color");u=u||"#333333";var c,p,_,v,m,x=null;if(l.setCSSStyle(g),l.setSolidFill(u),o&&"on"==n.metricLabel.rendered){v=n.max>0?n.max:n.min,m=s.getFormattedMetricLabel(v,e),(_=new t.OutputText(e.getCtx(),m)).setCSSStyle(g);var C=new t.Rectangle(i.x,i.y+.8*i.h,i.w,.2*i.h);c=g.getStyle("font-size")||t.TextUtils.getOptimalFontSize(_.getCtx(),_.getTextString(),_.getCSSStyle(),C),_.setFontSize(c),x=_.getDimensions(),i.h-=x.h,l.setFontSize(c),l.setTextString(h),l.setX(i.x+i.w/2),l.setY(i.y+i.h),i.h-=d,l.alignCenter(),t.TextUtils.fitText(l,i.w,i.h,a)}else if(!o&&"on"==n.metricLabel.rendered){var y;if(c=g.getStyle("font-size"),p=s.getFormattedMetricLabel(n.min,e),_=s.getFormattedMetricLabel(n.max,e),void 0===c&&i.h<18&&(c=s.calcLabelFontSize([h,p,_],l,i)),c=c?parseInt(c):13,l.setFontSize(c),n.max>0||"off"!=n.plotArea.rendered||"auto"!=n.plotArea.rendered||"onIndicator"!=n.thresholdDisplay){v=n.max>0?n.max:n.min,m=s.getFormattedMetricLabel(v,e),(_=new t.OutputText(e.getCtx(),m)).setCSSStyle(g),_.setFontSize(c),(x=_.getDimensions()).w=Math.min(x.w,i.w),y=r?i.x+x.w:i.x+i.w;var b=x.w;r?(i.x+=x.w+d,i.w-=x.w+d):i.w-=x.w+d}if(n.min<0&&"on"!=n.plotArea.rendered&&("auto"!=n.plotArea.rendered||"onIndicator"!=n.thresholdDisplay)){var S=s.getFormattedMetricLabel(n.min,e);(p=new t.OutputText(e.getCtx(),S)).setCSSStyle(g),p.setFontSize(c);var w=p.getDimensions();(n.value<0||n.max<=0)&&(y=r?i.x+i.w:i.x+w.w,b=w.w),r||(i.x+=w.w+d),i.w-=w.w+d}l.setTextString(h),l.setX(y),t.TextUtils.centerTextVertically(l,i.y+i.h/2),l.alignRight();var A="firefox"===t.Agent.browser?i.h+2:i.h;t.TextUtils.fitText(l,b,A,a)}},_renderMetricLabelInsidePlotArea:(e,a,i,n,r,o,l,h)=>{var d=e.getOptions(),g=t.Agent.isRightToLeft(e.getCtx()),u="vertical"==d.orientation,c="on"==d.plotArea.rendered,p="center",_="middle",v=new t.Rectangle(Math.min(o.x1,o.x2),Math.min(o.y1,o.y2),Math.abs(o.x2-o.x1),Math.abs(o.y2-o.y1)),m=d.metricLabel.style.getStyle("color");"center"==r?(m=m||t.ColorUtils.getContrastingTextColor(n),u?(v.h-=v.w,v.y+=v.w/2):(v.w-=v.h,v.x+=v.h/2)):"insideIndicatorEdge"==r?(m=m||t.ColorUtils.getContrastingTextColor(n),u?(v.h-=v.w,v.y+=v.w/2,_=!c&&o.y1>o.y2?"bottom":"top"):(v.w-=v.h,v.x+=v.h/2,p=g?!c&&o.x1<o.x2?"right":"left":!c&&o.x1>o.x2?"left":"right")):"outsideIndicatorEdge"==r&&(u?(v.h=Math.abs(l.y1-o.y1)-v.w,v.y=l.y1+v.w/2,_="bottom",!c&&o.y1>o.y2&&(v.h=Math.abs(l.y2-o.y1)-v.w,v.y=o.y1+v.w/2,_="top")):g?!c&&o.x1<o.x2?(v.w=Math.abs(l.x2-o.x2)-v.h,v.x=o.x2+v.h/2,p="left"):(v.w=Math.abs(l.x1-o.x2)-v.h,v.x=l.x1+v.h/2,p="right"):!c&&o.x1>o.x2?(v.w=Math.abs(l.x1-o.x2)-v.h,v.x=l.x1+v.h/2,p="right"):(v.w=Math.abs(l.x2-o.x2)-v.h,v.x=o.x2+v.h/2,p="left")),s.renderMetricLabel(e,a,v,m,p,_)||h||("outsideIndicatorEdge"==r?w._renderMetricLabelInsidePlotArea(e,a,i,n,"insideIndicatorEdge",o,l,!0):"insideIndicatorEdge"!=r&&"center"!=r||w._renderMetricLabelInsidePlotArea(e,a,i,n,"outsideIndicatorEdge",o,l,!0))},_renderLabel:(e,a,i,n)=>{var r=t.Agent.isRightToLeft(e.getCtx()),o=e.getOptions(),l="vertical"==o.orientation,h=new t.Rectangle(i.x,i.y,l?i.w:i.w-i.h,l?i.h-i.w:i.h),d=o.label.text;if(!w._hasMetricLabelOutsidePlotArea(o)&&"on"==o.metricLabel.rendered){var g=s.getFormattedMetricLabel(o.value,e);d=t.ResourceUtils.format(o.translations.labelAndValue,[d,g])}var u=o.label.style,c=u.clone(),p=u.getStyle("font-size");if(!p){var _=new t.OutputText(e.getCtx(),d,0,0);_.setCSSStyle(u),_.setTextString(d),p=l?t.TextUtils.getOptimalFontSize(_.getCtx(),_.getTextString(),_.getCSSStyle(),new t.Rectangle(h.x,h.y,h.w,Number.MAX_VALUE)):t.TextUtils.getOptimalFontSize(_.getCtx(),_.getTextString(),_.getCSSStyle(),new t.Rectangle(h.x,h.y,Number.MAX_VALUE,h.h))}var v=new t.MultilineText(e.getCtx(),d);c.setFontSize("font-size",p,e.getCtx()),v.setCSSStyle(c),t.TextUtils.fitText(v,h.w,h.h,e),"center"==o.label.position||"auto"==o.label.position&&l?(t.TextUtils.centerTextVertically(v,i.y+i.h/2),v.setX(i.x+i.w/2),v.alignCenter()):(t.TextUtils.centerTextVertically(v,i.y+i.h/2),!l&&r?(v.setX(i.x+i.w-h.h/2),v.alignRight()):l||r?l&&(v.setY(i.y+i.h-v.getDimensions().h-h.w/2),v.setX(i.x+i.w/2),v.alignCenter()):(v.setX(i.x+h.h/2),v.alignLeft())),a.addChild(v)},_drawCircularArc:(e,a,i,s,n,r,o,h,d,g)=>{var u,c=e.getCtx();t.Agent.isRightToLeft(e.getCtx())&&(s=(s=Math.PI-s-n)>0?s:s+2*Math.PI),d?u=new t.Path(c,y.createCircularPathCmd(i,s,n,r,o)):(u=new b(c,i,s,n,r,o),e.__shapes.push(u)),u.setSolidFill(h);var p=l.getBorderColor(e);p&&!d?u.setSolidStroke(p):d&&g&&u.setSolidStroke(g);var _=e.getOptions();u.setClassName(d?_.plotArea.svgClassName:_.svgClassName),u.setStyle(d?_.plotArea.svgStyle:_.svgStyle),a.addChild(u)},_drawCircularReferenceLine:(e,a,i,s,n,r,o)=>{var l=e.getCtx(),h=Math.min(i.w,i.h),d=.275*h,g=.5*h;t.Agent.isRightToLeft(e.getCtx())&&(s=(s=Math.PI-s)>0?s:s+2*Math.PI);var u=y.calcPointOnArc(i,d,s),c=y.calcPointOnArc(i,g,s),p=new t.Line(l,u.x,u.y,c.x,c.y),_=new t.Stroke(n,1,r,!1,t.Stroke.getDefaultDashProps(o,r));p.setStroke(_),a.addChild(p)},getAngleQuadrant:(e,a)=>{var i=1;return a?e>=t.Math.HALF_PI&&e<Math.PI?i=2:e>=Math.PI&&e<1.5*Math.PI?i=3:e>=1.5*Math.PI&&e<t.Math.TWO_PI&&(i=4):e>t.Math.HALF_PI&&e<=Math.PI?i=2:e>Math.PI&&e<=1.5*Math.PI?i=3:(e>1.5*Math.PI&&e<t.Math.TWO_PI||0==e)&&(i=4),i},_hasMetricLabelOutsidePlotArea:e=>{var t=e.metricLabel.position;return"auto"==t||"outsidePlotArea"==t||("withLabel"==t||"withTitle"==t)&&!e.label.text},_adjustCenterAndBounds:(e,a,i,s,n,r,o)=>{var l,h,d=null,g=w.getAngleQuadrant(i,!0),u=w.getAngleQuadrant(n,!1),c=r.w,p=r.h,_=c/2,v=p/2;if(g==u&&s<=t.Math.HALF_PI)l=2*Math.min(r.w,r.h),r.w=r.w+l/2,r.h=r.h+l/2,h=l*a,!o&&1==g||o&&2==g?(r.x-=l/2,r.y-=l/2,_=c/2-l/4+1,v=p/2-l/4+1,d=new t.Rectangle(r.x+r.w/2-1,r.y+r.h/2-1,h*(3/7)-2,h*(2.5/7)-2)):!o&&2==g||o&&1==g?(r.y-=l/2,_=c/2+l/4-1,v=p/2-l/4+1,d=new t.Rectangle(r.x+r.w/2-h*(3/7)+1,r.y+r.h/2-1,h*(3/7)-2,h*(2.5/7)-2)):!o&&3==g||o&&4==g?(_=c/2+l/4-1,v=p/2+l/4-1,d=new t.Rectangle(r.x+r.w/2-h*(3/7)+1,r.y+r.h/2-h*(2.5/7)+1,h*(3/7)-2,h*(2.5/7)-2)):(!o&&4==g||o&&3==g)&&(r.x-=l/2,_=c/2-l/4+1,v=p/2+l/4-1,d=new t.Rectangle(r.x+r.w/2-1,r.y+r.h/2-h*(2.5/7)+1,h*(3/7)-2,h*(2.5/7)-2));else if(g%4+1==u&&s<=Math.PI)1==g||3==g?(h=(l=Math.min(r.w,2*r.h))*a,r.w>r.h&&(d=new t.Rectangle(r.x+r.w/2-h*(3/7),r.y+r.h-(r.h-l/2)/2-h*(2.75/7),h*(6/7),h*(2.5/7)),1==g?(d.y=r.y+(r.h-l/2)/2+h*(.5/7),r.y-=l/2-(r.h-l/2)/2,v=p/2-l/4+1):(r.y+=(r.h-l/2)/2,v=p/2+l/4-1),r.h=l)):(h=(l=Math.min(2*r.w,r.h))*a,r.w<r.h&&(d=new t.Rectangle(r.x+r.w-(r.w-l/2)/2-h*(3.25/7),r.y+r.h/2-h*(2.5/7),h*(3/7),h*(5/7)),!o&&4==g||o&&2==g?(d.x=r.x+(r.w-l/2)/2+h*(.25/7),r.x-=l/2-(r.w-l/2)/2,_=c/2-l/4+1):(r.x+=(r.w-l/2)/2,_=c/2+l/4-1),r.w=l));else if(u%4+1==g&&s>Math.PI){var m;1==g&&r.h>r.w?(m=(h=(l=Math.min(r.w/(Math.cos(i)+1)*2,r.w/(Math.sin(n-1.5*Math.PI)+1)*2,r.h))*a)*(3/7)*(2*r.w/l-1),o?(d=new t.Rectangle(r.x+r.w-l/2-m,r.y+r.h/2-h*(2.5/7),h*(3/7)+m,h*(5/7)),r.x-=l-r.w,_=-l/2+c):(d=new t.Rectangle(r.x+l/2-h*(3/7),r.y+r.h/2-h*(2.5/7),h*(3/7)*(2*r.w/l-1+1),h*(5/7)),_=l/2),r.w=l):2==g&&r.h<r.w?(h=(l=Math.min(r.h/(Math.cos(i-t.Math.HALF_PI)+1)*2,r.h/(Math.sin(n)+1)*2,r.w))*a,d=new t.Rectangle(r.x+r.w/2-h*(3/7),r.y+l/2-h*(2.5/7),h*(6/7),h*(2.5/7)*(2*r.h/l-1+1)),r.h=l,v=l/2):3==g&&r.h>r.w?(m=(h=(l=Math.min(r.w/(Math.cos(i-Math.PI)+1)*2,r.w/(Math.sin(n-t.Math.HALF_PI)+1)*2,r.h))*a)*(3/7)*(2*r.w/l-1),o?(d=new t.Rectangle(r.x+l/2-h*(3/7),r.y+r.h/2-h*(2.5/7),h*(3/7)*(2*r.w/l-1+1),h*(5/7)),_=l/2):(d=new t.Rectangle(r.x+r.w-l/2-m,r.y+r.h/2-h*(2.5/7),h*(3/7)+m,h*(5/7)),r.x-=l-r.w,_=-l/2+c),r.w=l):4==g&&r.h<r.w&&(m=(h=(l=Math.min(r.h/(Math.cos(i-1.5*Math.PI)+1)*2,r.h/(Math.sin(t.Math.TWO_PI-n)+1)*2,r.w))*a)*(2.5/7)*(2*r.h/l-1),d=new t.Rectangle(r.x+r.w/2-h*(3/7),r.y+r.h-l/2-m,h*(6/7),h*(2.5/7)+m),r.y-=l-r.h,r.h=l,v=-l/2+p)}return e.cx=_,e.cy=v,e.maxInnerDiameter=h,d},_renderCenterContent:(e,a,i,n,r)=>{var o=new t.Rectangle(i.x+.5*(i.w-r),i.y+.5*(i.h-r),r,r);o=o.getIntersection(n);var l=new t.Rectangle(i.x+.5*(i.w-r/Math.sqrt(2)),i.y+.5*(i.h-r/Math.sqrt(2)),r/Math.sqrt(2),r/Math.sqrt(2));l=l.getIntersection(n);var h=a.center.renderer;if(h){var d={outerBounds:{x:o.x,y:o.y,width:o.w,height:o.h},innerBounds:{x:l.x,y:l.y,width:l.w,height:l.h},metricLabel:s.getFormattedMetricLabel(a.value,e),component:a._widgetConstructor},g=e.getCtx();d=g.fixRendererContext(d);var u=g.getContainer(),c=e.centerDiv;c&&u.removeChild(c);var p=h(d);if(!p)return;var _=g.createOverlayDiv();Array.isArray(p)?p.forEach(e=>{_.appendChild(e)}):_.appendChild(p),e.centerDiv=_,u.appendChild(_);var v=g.getOverlayAttachedCallback();v&&v(_)}}};e.LedGauge=c,e.RatingGauge=class extends h{constructor(e,t,a){super(e,t,a),this.type="rating",this.Defaults=new p(e)}SetOptions(e){(e=t.JsonUtils.clone(e)).changedState&&(e.changedState.className&&(e.changedState.svgClassName=e.changedState.className),e.changedState.style&&(e.changedState.svgStyle=e.changedState.style)),e.hoverState&&(e.hoverState.className&&(e.hoverState.svgClassName=e.hoverState.className),e.hoverState.style&&(e.hoverState.svgStyle=e.hoverState.style)),e.selectedState&&(e.selectedState.className&&(e.selectedState.svgClassName=e.selectedState.className),e.selectedState.style&&(e.selectedState.svgStyle=e.selectedState.style)),e.unselectedState&&(e.unselectedState.className&&(e.unselectedState.svgClassName=e.unselectedState.className),e.unselectedState.style&&(e.unselectedState.svgStyle=e.unselectedState.style)),this.getCtx().isCustomElement()&&(e.readOnly=e.readonly);var a=this.getCtx().getSvgDocument();"fit"!==e.size?(this.getCtx().removeSizingSvg(),a.style.height=e._height+"px",a.style.width=e._width+"px"):(this.getCtx().addSizingSvg(),a.style.height="",a.style.width=""),super.SetOptions(this.Defaults.calcOptions(e))}Render(e,a,i){var s=this.Options.__layout.outerGap,n=this.Options.max,r=this.Options.size,o="vertical"==this.Options.orientation,l=this.Options.selectedState.source,h="none"!=this.Options.preserveAspectRatio;if(l&&h&&"fit"===r){return t.ImageLoader.loadImage(this.Options.selectedState.source,r=>{if("ie"!==t.Agent.browser&&"edge"!==t.Agent.browser||11!=t.Agent.version||!r||0!=r.width||0!=r.height||(r.width=1,r.height=1),r&&r.width&&r.height){var l=r.width/r.height;this.__shapeWidth=o?Math.min(a-2*s,(i-2*s)*l/n):Math.min((i-2*s)*l,(a-2*s)/n),this.__shapeHeight=this.__shapeWidth/l,this.__bounds=o?new t.Rectangle(s,(i-this.__shapeHeight*n)/2,a-2*s,this.__shapeHeight*n):new t.Rectangle((a-this.__shapeWidth*n)/2,s,this.__shapeWidth*n,i-2*s),m.render(this,e,a,i)}this.PostRender(this.Options,e)}),!1}return s="fit"===r?s:0,h?(this.__shapeWidth=o?Math.min(a-2*s,(i-2*s)/n):Math.min(i-2*s,(a-2*s)/n),this.__shapeHeight=this.__shapeWidth):(this.__shapeWidth=o?a-2*s:(a-2*s)/n,this.__shapeHeight=o?(i-2*s)/n:i-2*s),this.__bounds=o?new t.Rectangle(s,(i-this.__shapeHeight*n)/2,a-2*s,this.__shapeHeight*n):new t.Rectangle((a-this.__shapeWidth*n)/2,s,this.__shapeWidth*n,i-2*s),m.render(this,e,a,i),!0}__getLogicalObject(){var e=this.Options.tooltip,a=e?e.renderer:null,i=l.getColor(this);if(a){var n={component:this.Options._widgetConstructor,label:s.getFormattedMetricLabel(this.Options.value,this),color:i};return new t.CustomDatatipPeer(this.getCtx().getTooltipManager(),a,i,n)}return new v(this)}GetValueAt(e,a){var n,r="vertical"==this.Options.orientation?this.__shapeHeight:this.__shapeWidth;return i.hasData(this)?("vertical"==this.Options.orientation?(a=Math.max(Math.min(a,this.__bounds.y+this.__bounds.h),this.__bounds.y),n=Math.max((this.__bounds.y+this.__bounds.h-a)/r,this.Options.min)):(e=Math.max(Math.min(e,this.__bounds.x+this.__bounds.w),this.__bounds.x),n=0,n=t.Agent.isRightToLeft(this.getCtx())?Math.max((this.__bounds.x+this.__bounds.w-e)/r,this.Options.min):Math.max((e-this.__bounds.x)/r,this.Options.min)),s.adjustForStep(this.Options,n)):null}__processHoverEnd(e,a){this.__updateClipRects(this.Options.value,"render"),this.dispatchEvent(t.EventFactory.newValueChangeEvent(this.Options.value,this.Options.value,!1))}__processValueChangeStart(e,t){this.__processValueChangeMove(e,t)}__processValueChangeMove(e,a){var i=this.GetValueAt(e,a);this.__updateClipRects(i,"hover"),this.dispatchEvent(t.EventFactory.newValueChangeEvent(this.Options.value,i,!1))}__processValueChangeEnd(e,a){var i=this.Options.value;this.Options.value=this.GetValueAt(e,a),this.Options.changed=!0,this.render(),this.dispatchEvent(t.EventFactory.newValueChangeEvent(i,this.Options.value,!1)),this.dispatchEvent(t.EventFactory.newValueChangeEvent(i,this.Options.value,!0))}__updateClipRects(e,a,s){if(i.hasData(this)){s||(s=this._container);var n,r,o,l,h,d,g=t.Agent.isRightToLeft(this.getCtx()),u="vertical"==this.Options.orientation,c=u?this.__shapeHeight:this.__shapeWidth,p=0,_=(e=Math.max(Math.min(e,this.Options.max),0))*c,v=e*c;"render"===a&&(p=e*c,_=0),u?(n=s.getChildAt(0),(r=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,this.__bounds.w,this.__bounds.h-v),n.setClipPath(r),o=s.getChildAt(1),(l=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y+this.__bounds.h-p,this.__bounds.w,p),o.setClipPath(l),(h=s.getChildAt(2))&&((d=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y+this.__bounds.h-_,this.__bounds.w,_),h.setClipPath(d))):g?(n=s.getChildAt(0),(r=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,this.__bounds.w-v,this.__bounds.h),n.setClipPath(r),o=s.getChildAt(1),(l=new t.ClipPath).addRect(this.__bounds.x+this.__bounds.w-v,this.__bounds.y,p,this.__bounds.h),o.setClipPath(l),(h=s.getChildAt(2))&&((d=new t.ClipPath).addRect(this.__bounds.x+this.__bounds.w-v,this.__bounds.y,_,this.__bounds.h),h.setClipPath(d))):(n=s.getChildAt(0),(r=new t.ClipPath).addRect(this.__bounds.x+v,this.__bounds.y,this.__bounds.w-v,this.__bounds.h),n.setClipPath(r),o=s.getChildAt(1),(l=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,p,this.__bounds.h),o.setClipPath(l),(h=s.getChildAt(2))&&((d=new t.ClipPath).addRect(this.__bounds.x,this.__bounds.y,_,this.__bounds.h),h.setClipPath(d)))}}__getRatingGaugeItem(e){return this._container.getChildAt(0).getChildAt(e)}CreateEventManager(){return new _(this)}IsInteractive(){return!this.Options.disabled&&super.IsInteractive(this)}},e.StatusMeterGauge=class extends h{constructor(e,t,a){super(e,t,a),this.type="statusMeter",this.Defaults=new x(e),this.__axisInfo=null}SetOptions(e){(e=t.JsonUtils.clone(e)).title&&(e.label=e.title),e.plotArea&&(e.plotArea.className&&(e.plotArea.svgClassName=e.plotArea.className),e.plotArea.style&&(e.plotArea.svgStyle=e.plotArea.style)),this.getCtx().isCustomElement()&&(e.readOnly=e.readonly),super.SetOptions(this.Defaults.calcOptions(e))}Render(e,t,a){w.render(this,e,t,a)}CreateAnimOnDisplay(e,a,i){for(var s=[],n=0;n<e.length;n++){var r=e[n],o=r.getAnimParams();"horizontal"==this.Options.orientation?r.setAnimParams([o[0],o[0],o[2],o[3]]):"vertical"==this.Options.orientation?r.setAnimParams([o[0],o[1],o[3],o[3]]):"circular"==this.Options.orientation&&r.setAnimParams([o[0],o[1],0,o[3],o[4]]);var l=new t.CustomAnimation(this.getCtx(),r,i);l.getAnimator().addProp(t.Animator.TYPE_NUMBER_ARRAY,r,r.getAnimParams,r.setAnimParams,o),l.getAnimator().setEasing(function(e){return t.Easing.backOut(e,.7)}),s.push(l)}return new t.ParallelPlayable(this.getCtx(),s)}GetValueAt(e,a){var i=this.Options,s=t.Agent.isRightToLeft(this.getCtx());if("horizontal"==i.orientation)return this.__axisInfo.getBoundedValAt(e);if("vertical"==i.orientation)return this.__axisInfo.getBoundedValAt(a);if("circular"==i.orientation){var n=i.angleExtent,r=Math.atan2(a-this.cy,e-this.cx),o=s?180-(t.Math.radsToDegrees(r)-i.startAngle):t.Math.radsToDegrees(r)-(360-i.startAngle),l=(o=(o+720)%360)/n,h=i.min,d=i.max,g=l*(d-h)+h;return o>n&&(g=(o-n)/(360-n)>.5?0:d),g}return null}},Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojgauge-toolkit.js.map