/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojcore-base","jquery","ojs/ojcontext","ojs/ojcomponentcore","ojs/ojlogger","ojs/ojdomutils","ojs/ojfocusutils","touchr"],function(e,t,i,s,n,o,a,r,h){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,i=i&&Object.prototype.hasOwnProperty.call(i,"default")?i.default:i,s=s&&Object.prototype.hasOwnProperty.call(s,"default")?s.default:s,r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r;var l={properties:{arrowPlacement:{type:"string",enumValues:["adjacent","overlay"],value:"adjacent"},arrowVisibility:{type:"string",enumValues:["auto","hidden","hover","visible"],value:"auto"},currentItem:{type:"object",writeback:!0,value:{index:0},properties:{id:{type:"string"},index:{type:"number"}}},looping:{type:"string",enumValues:["off","page"],value:"off"},maxItemsPerPage:{type:"number",value:0},orientation:{type:"string",enumValues:["horizontal","vertical"],value:"horizontal"},translations:{type:"object",value:{},properties:{labelAccArrowNextPage:{type:"string"},labelAccArrowPreviousPage:{type:"string"},labelAccFilmStrip:{type:"string"},tipArrowNextPage:{type:"string"},tipArrowPreviousPage:{type:"string"}}}},methods:{getItemsPerPage:{},getPagingModel:{},getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},extension:{}};l.extension._WIDGET_NAME="ojFilmStrip",l.extension._TRACK_CHILDREN="immediate",t.CustomElementBridge.register("oj-film-strip",{metadata:l});const c=function(){this.Init()};t._registerLegacyNamespaceProp("FilmStripPagingModel",c),t.Object.createSubclass(c,t.EventSource,"oj.FilmStripPagingModel"),c.prototype.Init=function(){c.superclass.Init.call(this),this._page=-1,this._totalSize=0,this._pageSize=-1},c.prototype.setTotalSize=function(e){this._totalSize=e},c.prototype.getPageSize=function(){return this._pageSize},c.prototype.getPage=function(){return this._page},c.prototype.setPage=function(e,t){e=parseInt(e,10);try{var i=this.getPageCount(),s=this._page,n=this._pageSize,o=n;if(t&&t.pageSize&&(o=t.pageSize),0===this._totalSize&&-1===o)return Promise.resolve();var a=Math.ceil(this._totalSize/o);if(e<0||e>a-1)throw new Error("JET FilmStrip: Invalid 'page' set: "+e);var r=!1;if(e!==s||o!==n){if(!1===this.handleEvent("beforePage",{page:e,previousPage:s}))return Promise.reject();r=!0}this._page=e,this._pageSize=o;var h=this.getPageCount(),l=this;return new Promise(function(n){if(i!==h&&l.handleEvent("pageCount",{pageCount:h,previousPageCount:i}),r){var o={page:e,previousPage:s};t&&t.loopDirection&&(o.loopDirection=t.loopDirection),l.handleEvent("page",o)}n(null)})}catch(e){return Promise.reject(e)}},c.prototype.getStartItemIndex=function(){return-1===this._page&&-1===this._pageSize?-1:this._page*this._pageSize},c.prototype.getEndItemIndex=function(){return Math.min(this.getStartItemIndex()+this._pageSize,this._totalSize)-1},c.prototype.getPageCount=function(){return Math.ceil(this._totalSize/this._pageSize)},c.prototype.totalSize=function(){return this._totalSize},c.prototype.totalSizeConfidence=function(){return"actual"},function(){const e="adjacent",h="aria-hidden",l="auto",u="display",d="",g="JET FilmStrip: Value of 'currentItem' property is invalid. No such item exists: ",p="JET FilmStrip: Unsupported value set as 'orientation' property: ",_="JET FilmStrip: Unsupported value set as 'arrowPlacement' property: ",f="JET FilmStrip: Unsupported value set as 'arrowVisibility' property: ",m="JET FilmStrip: Unsupported value set as 'looping' property: ",v="flex-basis",P="hidden",b=":hidden",S="horizontal",w="hover",C="currentItem",y="-ms-transform",I="none",T="oj-bottom",F="oj-end",E="oj-filmstrip-arrow",z="oj-filmstrip-arrow-container",j="oj-filmstrip-arrow-transition",N="oj-filmstrip-container",M="oj-filmstrip-hover",x="oj-filmstrip-item",A="oj-filmstrip-item-container",H="oj-filmstrip-page",D="oj-filmstrip-transition",L="oj-filmstrip-transition-next-newpage-from",R="oj-filmstrip-transition-next-oldpage-from",$="oj-filmstrip-transition-prev-newpage-from",k="oj-filmstrip-transition-prev-oldpage-from",B="oj-filmstrip-transition-next-newpage-to",O="oj-filmstrip-transition-next-oldpage-to",V="oj-filmstrip-transition-prev-newpage-to",W="oj-filmstrip-transition-prev-oldpage-to",U="oj-filmstrip-transition-display-as-firstpage",q="oj-filmstrip-transition-display-as-lastpage",K="aria-labelledby",J="oj-filmstrip-start-arrow",X="oj-filmstrip-end-arrow",Y="oj-filmstrip-top-arrow",G="oj-filmstrip-bottom-arrow",Q="oj-filmstrip-vertical",Z="oj-start",ee="oj-top",te="page",ie="next",se="prev",ne="overlay",oe=".",ae="px",re="transform",he="vertical",le="visible",ce=":visible",ue="-webkit-flex-basis",de="-webkit-transform",ge="JET FilmStrip: 'disabled' property not supported";function pe(e,t){e.css(de,t).css(y,t).css(re,t)}function _e(e){e.css(de,d).css(y,d).css(re,d)}function fe(e){const t=i("<div></div>");return t.text(e),t[0].innerHTML}t.__registerWidget("oj.ojFilmStrip",i.oj.baseComponent,{defaultElement:"<div>",widgetEventPrefix:"oj",options:{maxItemsPerPage:0,orientation:"horizontal",currentItem:{index:0},arrowPlacement:"adjacent",arrowVisibility:"auto",looping:"off"},_ComponentCreate:function(){this._super();const t=this.element;t.addClass("oj-filmstrip oj-component").attr("tabindex",0).attr("role","application"),t.uniqueId(),this._focusable({element:t,applyHighlight:!0});const i=this.options;if(i.disabled&&o.warn(ge),i.orientation!==S&&i.orientation!==he)throw new Error(p+i.orientation);if(i.arrowPlacement!==e&&i.arrowPlacement!==ne)throw new Error(_+i.arrowPlacement);if(i.arrowVisibility!==le&&i.arrowVisibility!==P&&i.arrowVisibility!==w&&i.arrowVisibility!==l)throw new Error(f+i.arrowVisibility);if("off"!==i.looping&&i.looping!==te)throw new Error(m+i.looping);if(this.touchEventNamespace=this.eventNamespace+"Touch",this.mouseEventNamespace=this.eventNamespace+"Mouse",this.keyEventNamespace=this.eventNamespace+"Key",this.navArrowHoverableEventNamespace=this.eventNamespace+"NavArrowHoverable",i.currentItem=this._convertCurrentItemToObj(i.currentItem),t.children().length&&i.currentItem&&(function(e,t){return e&&a.isValidIdentifier(e)&&!t.find(`#${e}`).length}(i.currentItem.id,t)||function(e,t){return null!=e&&(e<0||e>=t.children().length)}(i.currentItem.index,t)))throw new Error(g+JSON.stringify(i.currentItem));this._setup(!0),this._populateCurrentItemObj(i.currentItem),this.option(C,i.currentItem,{_context:{internalSet:!0,writeback:!0}})},refresh:function(){this._super(),this._setup(!1)},getItemsPerPage:function(){return this._itemsPerPage},getPagingModel:function(){return this._pagingModel},_notifyCommon:function(){this._needsSetup?this._setup(this._needsSetup[0]):this._handleResize()},_NotifyShown:function(){this._super(),this._notifyCommon()},_NotifyAttached:function(){this._super(),this._notifyCommon()},_setup:function(e){const t=this;if(e&&!this._pagingModel&&(this._pagingModel=new c),e&&!this._filterNestedFilmStripsFunc&&(this._filterNestedFilmStripsFunc=function(e,s){return i(s).closest(".oj-filmstrip")[0]===t.element[0]}),!this._canCalculateSizes()){let t=!1;return this._needsSetup&&(t=this._needsSetup[0]),void(this._needsSetup=[e||t])}var s=!1;this._needsSetup&&(s=this._needsSetup[0]),this._needsSetup=null,this._bRTL="rtl"===this._GetReadingDirection(),this._bTouchSupported=a.isTouchSupported();const r=this.element;e||s?(this._itemsPerPage=0,this._handlePageFunc=function(e){t._handlePage(e)},this._componentSize=0,this._itemSize=-1,this._handleTransitionEndFunc=function(){t._handleTransitionEnd()},this._handleResizeFunc=function(){t._handleResize()},this._bTouchSupported&&(this._handleTouchStartFunc=function(e){t._handleTouchStart(e)},this._handleTouchMoveFunc=function(e){t._handleTouchMove(e)},this._handleTouchEndFunc=function(){t._handleTouchEnd()},this._addTouchListeners()),this._handleMouseDownFunc=function(e){t._handleMouseDown(e)},this._handleMouseMoveFunc=function(e){t._handleMouseMove(e)},this._handleMouseUpFunc=function(){t._handleMouseUp()},this._addMouseListeners(),this._handleKeyDownFunc=function(e){t._handleKeyDown(e)},this._addKeyListeners()):this._destroyInternal();const h=r.children();for(let e=0;e<h.length;e++)n.subtreeDetached(h[e]);const l=this._pagingModel;(e||s)&&l.on("page",this._handlePageFunc),l.setTotalSize(h.length),this._wrapChildren(),this._adjustSizes();for(let e=0;e<h.length;e++)n.subtreeAttached(h[e]);0===h.length&&o.warn("JET FilmStrip: There are no nested children!"),a.addResizeListener(r[0],this._handleResizeFunc,25)},_destroy:function(){this._bTouchSupported&&(this._removeTouchListeners(),this._handleTouchStartFunc=null,this._handleTouchMoveFunc=null,this._handleTouchEndFunc=null),this._removeMouseListeners(),this._handleMouseDownFunc=null,this._handleMouseMoveFunc=null,this._handleMouseUpFunc=null,this._removeKeyListeners(),this._handleKeyDownFunc=null,this._destroyInternal(),this._pagingModel.off("page",this._handlePageFunc),this._handlePageFunc=null,this._pagingModel=null,this._handleResizeFunc=null,this._handleTransitionEndFunc=null,this._filterNestedFilmStripsFunc=null;const e=this.element;e.removeClass("oj-filmstrip oj-component "+M).removeAttr("tabindex role").removeAttr(K),e.removeUniqueId(),this._IsCustomElement()&&(e[0].removeEventListener("touchstart",this._delegatedHandleTouchStartFunc,{passive:!0}),e[0].removeEventListener("touchmove",this._delegatedHandleTouchMoveFunc,{passive:!1}),delete this._delegatedHandleTouchStartFunc,delete this._delegatedHandleTouchMoveFunc),this._super()},_destroyInternal:function(){this._deferredHandleResize=!1,this._resolveBusyState();const e=this.element;a.removeResizeListener(e[0],this._handleResizeFunc),this._itemSize=-1,this._queuedHandleResize&&(clearTimeout(this._queuedHandleResize),this._queuedHandleResize=null);const t=this._getItems();let i;for(i=0;i<t.length;i++)n.subtreeDetached(t[i]);this._clearCalculatedSizes();for(this._getItemContainers().unwrap(),this._unwrapChildren(),i=0;i<t.length;i++)n.subtreeAttached(t[i])},_setOption:function(t,i,s){const n=this.options;let a=!1,r=-1;const h=this._pagingModel,c=h.getPage();switch(t){case"disabled":o.warn(ge);break;case"orientation":if(i!==S&&i!==he)throw new Error(p+i);a=n.orientation!==i;break;case"maxItemsPerPage":a=n.maxItemsPerPage!==i;break;case"arrowPlacement":if(i!==e&&i!==ne)throw new Error(_+i);a=n.arrowPlacement!==i;break;case"arrowVisibility":if(i!==le&&i!==P&&i!==w&&i!==l)throw new Error(f+i);a=n.arrowVisibility!==i;break;case"looping":if("off"!==i&&i!==te)throw new Error(m+i);a=n.looping!==i;break;case C:i=this._convertCurrentItemToObj(i),this._populateCurrentItemObj(i);var u=n.currentItem;if(u&&i&&(u.id!==i.id||u.index!==i.index)&&(r=this._findPage(i),r<0||r>=h.getPageCount()))throw new Error(g+JSON.stringify(i))}this._super(t,i,s),t===C&&r>-1&&r!==c&&h.setPage(r),a&&this._setup(!1)},_handleResize:function(){if(this._busyStateResolveFunc)this._deferredHandleResize=!0;else if(this._bHandlingResize){if(!this._queuedHandleResize){const e=this;this._queuedHandleResize=setTimeout(function(){e._queuedHandleResize=null,e._handleResize()},0)}}else this._bHandlingResize=!0,this._adjustSizes(!0),this._bHandlingResize=!1},_isHorizontal:function(){return this.options.orientation!==he},_isLoopingPage:function(){return this.options.looping===te},_getCssPositionAttr:function(){return this._isHorizontal()?this._bRTL?"right":"left":"top"},_getCssSizeAttr:function(){return this._isHorizontal()?"width":"height"},_canCalculateSizes:function(){const e=document.createElement("div"),t=e.style;t.position="absolute",t.width="10px",t.height="10px";const i=this.element[0];i.appendChild(e);let s=!1;try{s=e.offsetWidth>0&&e.offsetHeight>0}catch(e){}return i.removeChild(e),s},_wrapChildren:function(){const t=this.element,i=this._isHorizontal(),s=t.children();s.addClass(x).wrap(`<div class="${N} ${A}"></div>`);const n=this._getCssPositionAttr(),o=t.children().wrapAll(`<div class="${N} oj-filmstrip-pages-container"></div>`).parent().css(n,"0px");this._pagesWrapper=o;const a=this.options;a.arrowVisibility!==P&&a.arrowPlacement===e&&(this._contentWrapper=o.wrap(`<div class="${N} oj-filmstrip-content-container"></div>`).parent()),t.addClass(N),i||t.addClass(Q);const r=this._createPageInfoElem(),h=t.attr("id"),l=r.attr("id");t.append(r),t.attr(K,`${h} ${l}`),this._pageInfoElem=r,a.arrowVisibility!==P&&s.length>0&&(this._prevButton=this._createPrevNavArrow(),this._nextButton=this._createNextNavArrow(),this._navArrowsShownOnHover()&&this._setupNavArrowsHoverable())},_unwrapChildren:function(){const e=this.element,t=this._getItems();this._tearDownNavArrowsHoverable(),this._prevButton&&(this._UnregisterChildNode(this._prevButton),this._prevButton=null),this._nextButton&&(this._UnregisterChildNode(this._nextButton),this._nextButton=null);const i=e.children(oe+z);i&&i.remove(),this._pageInfoElem&&(this._UnregisterChildNode(this._pageInfoElem),this._pageInfoElem.remove(),this._pageInfoElem=null),t.removeClass(x).unwrap().unwrap(),this._pagesWrapper=null,this._contentWrapper&&(t.unwrap(),this._contentWrapper=null),e.removeClass(`${N} ${Q}`)},_createPageInfoElem:function(){const e=i(document.createElement("div"));return e.uniqueId(),e.addClass("oj-helper-hidden-accessible oj-filmstrip-liveregion"),e.attr({"aria-live":"polite","aria-atomic":"true"}),e},_updatePageInfoElem:function(){const e=this._pagingModel,t=e.getPage(),i=e.getPageCount(),s=fe(this.getTranslatedString("labelAccFilmStrip",{pageIndex:t+1,pageCount:i})),n=this._pageInfoElem;n&&n.text(s)},_setupNavArrowsHoverable:function(){this.element.on("mouseenter"+this.navArrowHoverableEventNamespace,function(e){i(e.currentTarget).hasClass("oj-disabled")||i(e.currentTarget).addClass(M)}).on("mouseleave"+this.navArrowHoverableEventNamespace,function(e){i(e.currentTarget).removeClass(M)})},_tearDownNavArrowsHoverable:function(){this.element.off(this.navArrowHoverableEventNamespace)},_navArrowsShownOnHover:function(){const e=this.options,t=e.arrowVisibility;return t===w||t===l&&e.arrowPlacement===ne},_hasPrevPage:function(){return this._pagingModel.getPage()>0},_hasNextPage:function(){const e=this._pagingModel;return e.getPage()<e.getPageCount()-1},_prevPage:function(){const e=this._pagingModel;if(this._hasPrevPage())e.setPage(e.getPage()-1);else{const t=e.getPageCount();this._isLoopingPage()&&t>1&&e.setPage(t-1,{loopDirection:se})}},_nextPage:function(){const e=this._pagingModel;if(this._hasNextPage())e.setPage(e.getPage()+1);else{const t=e.getPageCount();this._isLoopingPage()&&t>1&&e.setPage(0,{loopDirection:ie})}},_displayNavigationArrow:function(t,i){this.options.arrowPlacement===e?i.css("visibility",t?"":P):i.parent().css("display",t?"":I)},_updateNavigationArrowsDisplay:function(){if(this.options.arrowVisibility!==P){const e=this._pagingModel,t=e.getPage(),i=e.getPageCount(),s=this._isLoopingPage()&&i>1;this._displayNavigationArrow(s||0!==t,this._prevButton),this._displayNavigationArrow(s||t!==i-1,this._nextButton)}},_createPrevNavArrow:function(){const e=this.element,t=this._isHorizontal()?Z:ee,i=this._createNavigationArrowContainer(t);this.options.arrowPlacement===ne?e.append(i):e.prepend(i);const s=fe(this.getTranslatedString("labelAccArrowPreviousPage")),n=fe(this.getTranslatedString("tipArrowPreviousPage")),o=this._createNavigationArrow(i,t,s,n),a=this;return o.on("click",function(){a._prevPage()}),o},_createNextNavArrow:function(){const e=this.element,t=this._isHorizontal()?F:T,i=this._createNavigationArrowContainer(t);e.append(i);const s=fe(this.getTranslatedString("labelAccArrowNextPage")),n=fe(this.getTranslatedString("tipArrowNextPage")),o=this._createNavigationArrow(i,t,s,n),a=this;return o.on("click",function(){a._nextPage()}),o},_createNavigationArrowContainer:function(e){const t=i(document.createElement("div"));t.addClass(z+" "+e);return this.options.arrowPlacement===ne&&(t.addClass("oj-filmstrip-arrow-container-overlay"),this._navArrowsShownOnHover()&&t.addClass(j)),t},_createNavigationArrow:function(t,i,s,n){const o=`<div class='${E} oj-default oj-enabled ${i}' role='button' tabindex='-1'><span class='oj-filmstrip-arrow-icon ${i} oj-component-icon'></span></div>`;t.append(o);const a=t.children(oe+E).eq(0);a.uniqueId();const r=a.attr("id");s&&a.attr("aria-label",s),n&&a.attr("title",n);const h=this._pageInfoElem.attr("id");a.attr(K,`${h} ${r}`),this._AddHoverable(a),this._AddActiveable(a);return this.options.arrowPlacement===e&&this._navArrowsShownOnHover()&&a.addClass(j),a},_getItemContainers:function(){return this._pagesWrapper.find(oe+A).filter(this._filterNestedFilmStripsFunc)},_getItems:function(){return this._pagesWrapper.find(oe+x).filter(this._filterNestedFilmStripsFunc)},_getPages:function(){return this._pagesWrapper.children(oe+H)},_clearCalculatedSizes:function(){const e=this._pagesWrapper;this._getPages().css(v,d).css(ue,d);this._getItemContainers().css(v,d).css(ue,d),e.css(this._getCssSizeAttr(),d)},_adjustSizes:function(t){this._clearCalculatedSizes();const s=this.options,o=this._isHorizontal();let a=s.maxItemsPerPage;const r=a<1,l=this.element,c=this._getItemContainers();if(this._itemSize<0){if(this._getItems().length){const e=this._getItemIndex(s.currentItem);let t;t=e>-1&&c[e]?i(c[e]):i(c[0]);const a=t.children(oe+x);a.css(u,d),n.subtreeShown(a[0]),this._itemSize=o?t.width():t.height()}}let g=o?l.width():l.height();if(s.arrowVisibility!==P&&s.arrowPlacement===e){const e=l.children(oe+z).eq(0);g-=2*(o?e.width():e.height())}if(this._componentSize=g,!r){const e=Math.max(Math.floor(g/this._itemSize),1);e<a&&(a=e)}const p=r?Math.max(Math.floor(g/this._itemSize),1):a,_=g/p;c.css(v,_+ae).css(ue,_+ae);const f=Math.ceil(c.length/p);let m=this._getPages(),b=!1;const S=this._pagingModel;if(S.getPageCount()!==f||this._itemsPerPage!==p||!m||m.length<1){let e;if(b=!0,t)for(e=0;e<c.length;e++)n.subtreeDetached(c[e]);for(m&&m.length>0&&c.unwrap(),e=0;e<c.length;e+=p){c.slice(e,e+p).wrapAll(`<div class="${N} ${H}" ${h}="true"></div>`).parent().css("display",I)}if(t)for(e=0;e<c.length;e++)n.subtreeAttached(c[e])}m=this._getPages(),m.css(v,g+ae).css(ue,g+ae);const w=this._pagesWrapper,C=this._contentWrapper;if(w.css(this._getCssSizeAttr(),g),C&&C.css(this._getCssSizeAttr(),g),c.length){let e=0;if(s.currentItem&&(e=this._findTargetPage(s.currentItem,p)),e>-1&&(S.getPageCount()!==f||this._itemsPerPage!==p||S.getPage()!==e))S.setPage(e,{pageSize:p});else if(b){const e=S.getPage();this._handlePage({previousPage:e,page:e})}}},_handlePage:function(e){const t=e.page,s=e.loopDirection,n=e.previousPage,o=this._pagesWrapper,a=this._getPages(),r=this._pagingModel,h=r.getPageSize(),l=r.getPageCount(),c=n<0||n===t||this._itemsPerPage!==h,u=this._isLoopingPage();this._itemsPerPage=h;let d=null;c||(d=i(a[n]));const g=this._getCssPositionAttr(),p=i(a[t]),_=p.is(b);_&&this._unhidePage(p);let f,m=this._bDragInit;if(n>-1&&!c){f=t>n,u&&s&&(f=s===ie);const e=u&&!f&&l>1&&0===n,i=u&&f&&l>1&&n===l-1;m=!0,o.css(this._getCssSizeAttr(),2*this._componentSize),f||_&&o.css(g,-this._componentSize+ae),f?(d&&d.addClass(R),p.addClass(L),i&&p.addClass(q)):(d&&d.addClass(k),p.addClass($),e&&p.addClass(U))}if(this._busyStateResolveFunc=this._addBusyState("scrolling"),m){const e=this,i=this._bDragInit;if(i&&n<0){a.filter(ce).addClass(D)}setTimeout(function(){e._finishHandlePage(t,n,f,c,i)},25)}else this._finishHandlePage(t,n,f,c)},_finishHandlePage:function(e,t,s,n,o){const a=this._pagesWrapper;if(n||(this._bPageChangeTransition=!0,a.on(`transitionend${this.eventNamespace} webkitTransitionEnd${this.eventNamespace}`,this._handleTransitionEndFunc)),n)this._handleTransitionEnd();else{const n=this._getPages();if(o&&_e(n),t>-1){const o=i(n[t]),a=i(n[e]);o.addClass(D),a.addClass(D),s?(o.removeClass(R),a.removeClass(L),o.addClass(O),a.addClass(B)):(o.removeClass(k),a.removeClass($),o.addClass(W),a.addClass(V))}else if(o){pe(n.filter(ce),"translate3d(0, 0, 0)")}}},_handleTransitionEnd:function(){this._bPageChangeTransition=!1;const e=this._pagesWrapper,t=this._getCssPositionAttr();e.off(this.eventNamespace).css(this._getCssSizeAttr(),this._componentSize).css(t,"0px");let s=null;(r.containsFocus(e[0])||this._nextButton&&r.containsFocus(this._nextButton[0])||this._prevButton&&r.containsFocus(this._prevButton[0]))&&(s=document.activeElement);const n=this._pagingModel.getPage(),o=this._getPages();for(let e=0;e<o.length;e++)e!==n&&this._hidePage(i(o[e]));if(o.removeClass(D+" "+O+" "+B+" "+W+" "+V+" "+U+" "+q),_e(o),this._updateNavigationArrowsDisplay(),s&&i(s).is(b)){const e=this.element,t=r.getFirstTabStop(o[n]);t?r.focusElement(t):r.focusElement(e[0])}const a=this.options;if(this._findPage(a.currentItem)!==n){const e=this._getFirstItemOnPage(n);e&&this.option(C,e,{_context:{writeback:!0}})}this._deferredHandleResize&&(this._deferredHandleResize=!1,this._handleResize()),this._updatePageInfoElem(),this._resolveBusyState()},_getItemIndex:function(e){let t=-1;if(e){const i=this._getItems();if(e.id&&a.isValidIdentifier(e.id))for(let s=0;s<i.length;s++){const n=i[s].id;if(n&&n.length>0&&n===e.id){t=s;break}}else null!=e.index&&e.index>=0&&e.index<i.length&&(t=e.index)}return t},_convertCurrentItemToObj:function(e){let t=null;return"object"==typeof e?t={index:e.index,id:e.id}:"number"==typeof e?t={index:e}:"string"==typeof e&&(t={id:e}),t},_populateCurrentItemObj:function(e){if(e&&this._pagingModel.getPage()>=0){const t=this._getItemIndex(e);if(e.index=t,null==e.id&&t>-1){const i=this._getItems();e.id=i[t].id}}},_findPage:function(e,t){const i=this._getItemIndex(e);let s=-1;return i>-1&&(void 0===t&&(t=this._itemsPerPage),s=Math.floor(i/t)),s},_findTargetPage:function(e,t){let i=this._findPage(e,t);if(i<0){const s=this._getItems();s.length>0&&e&&null!=e.index&&e.index>=s.length&&(void 0===t&&(t=this._itemsPerPage),i=Math.floor((s.length-1)/t))}return i},_getFirstItemOnPage:function(e,t,i){const s=this._pagingModel;if(void 0===t&&(t=s.getPageCount()),e>=0&&e<t){const t=this._getItems();void 0===i&&(i=this._itemsPerPage);const s=e*i;if(s<t.length){return{id:t[s].id,index:s}}}return null},_hidePage:function(e){n.subtreeHidden(e[0]),e.css(u,I).attr(h,"true");e.find(oe+x).filter(this._filterNestedFilmStripsFunc).css(u,I)},_unhidePage:function(e){e.css(u,d).removeAttr(h);e.find(oe+x).filter(this._filterNestedFilmStripsFunc).css(u,d),n.subtreeShown(e[0])},_addKeyListeners:function(){this.element.on(`keydown${this.keyEventNamespace}`,this._handleKeyDownFunc)},_removeKeyListeners:function(){this.element.off(this.keyEventNamespace)},_addMouseListeners:function(){this.element.on(`mousedown${this.mouseEventNamespace}`,this._handleMouseDownFunc).on(`mousemove${this.mouseEventNamespace}`,this._handleMouseMoveFunc).on(`mouseup${this.mouseEventNamespace}`,this._handleMouseUpFunc)},_removeMouseListeners:function(){this.element.off(this.mouseEventNamespace)},_addTouchListeners:function(){const e=this.element;if(this._IsCustomElement()){const t=function(e){return function(t){e(i.Event(t))}};this._delegatedHandleTouchStartFunc=t(this._handleTouchStartFunc),this._delegatedHandleTouchMoveFunc=t(this._handleTouchMoveFunc),e[0].addEventListener("touchstart",this._delegatedHandleTouchStartFunc,{passive:!0}),e[0].addEventListener("touchmove",this._delegatedHandleTouchMoveFunc,{passive:!1}),e.on(`touchend${this.touchEventNamespace}`,this._handleTouchEndFunc).on(`touchcancel${this.touchEventNamespace}`,this._handleTouchEndFunc)}else e.on(`touchstart${this.touchEventNamespace}`,this._handleTouchStartFunc).on(`touchmove${this.touchEventNamespace}`,this._handleTouchMoveFunc).on(`touchend${this.touchEventNamespace}`,this._handleTouchEndFunc).on(`touchcancel${this.touchEventNamespace}`,this._handleTouchEndFunc)},_removeTouchListeners:function(){this.element.off(this.touchEventNamespace)},_handleKeyDown:function(e){if(e.target!==this.element[0])return;const t=this._pagingModel,s=t.getPage(),n=t.getPageCount();let o;switch(e.keyCode){case i.ui.keyCode.RIGHT:o=this._bRTL?s-1:s+1;break;case i.ui.keyCode.LEFT:o=this._bRTL?s+1:s-1;break;case i.ui.keyCode.DOWN:o=s+1;break;case i.ui.keyCode.UP:o=s-1;break;case i.ui.keyCode.HOME:o=0;break;case i.ui.keyCode.END:o=n-1;break;default:return}if(o>-1&&o<n)t.setPage(o);else if(this._isLoopingPage()&&n>1){const e={};o===n&&(o=0,e.loopDirection=ie),-1===o&&(o=n-1,e.loopDirection=se),t.setPage(o,e)}e.preventDefault()},_handleMouseDown:function(e){const t=e.originalEvent;this._dragScrollStart(t)},_handleMouseMove:function(e){const t=e.originalEvent;this._dragScrollMove(e,t)},_handleMouseUp:function(){this._dragScrollEnd()},_handleTouchStart:function(e){const t=e.originalEvent.touches;if(1===t.length){const e=t[0];this._dragScrollStart(e)}},_handleTouchMove:function(e){const t=e.originalEvent.touches[0];this._dragScrollMove(e,t),(this._bTouch||this._scrolledForThisTouch)&&e.preventDefault()},_handleTouchEnd:function(){this._dragScrollEnd()},_dragScrollStart:function(e){if(this._pagingModel.getPageCount()>1&&!this._bPageChangeTransition){this._bTouch=!0,this._bDragInit=!1,this._bFirstToLast=!1,this._bLastToFirst=!1;const t=this._isHorizontal();this._touchStartCoord=t?e.pageX:e.pageY,this._touchStartCoord2=t?e.pageY:e.pageX}},_initDragScroll:function(e,t,s){const n=this._isHorizontal();this._touchStartCoord=n?e.pageX:e.pageY,this._touchStartCoord2=n?e.pageY:e.pageX;const o=this._getCssPositionAttr(),a=this._pagesWrapper,r=this._pagingModel,h=r.getPage(),l=r.getPageCount(),c=this._getPages();let u=1;t||s?(t&&(this._unhidePage(i(c[l-1])),a.css(o,-this._componentSize+ae),u+=1,i(c[l-1]).addClass(U)),s&&(this._unhidePage(i(c[0])),u+=1,i(c[0]).addClass(q))):(h>0&&(this._unhidePage(i(c[h-1])),a.css(o,-this._componentSize+ae),u+=1),h<l-1&&(this._unhidePage(i(c[h+1])),u+=1)),u>1&&a.css(this._getCssSizeAttr(),u*this._componentSize),this._touchStartScroll=parseInt(a.css(o),10)},_dragScrollMove:function(e,t){if(!this._bTouch)return;const s=this._isHorizontal(),n=(s?t.pageX:t.pageY)-this._touchStartCoord,o=(s?t.pageY:t.pageX)-this._touchStartCoord2,a=s&&this._bRTL?n>0:n<0,r=this._pagingModel,h=r.getPage(),l=r.getPageCount(),c=this._isLoopingPage(),u=c&&!a&&l>1&&0===h,d=c&&a&&l>1&&h===l-1;if(!this._bDragInit)return Math.abs(o)>Math.abs(n)&&(this._bTouch=!1,this._scrolledForThisTouch=!1),Math.abs(n)>3&&(this._initDragScroll(t,u,d),this._bDragInit=!0),this._bFirstToLast=u,void(this._bLastToFirst=d);u===this._bFirstToLast&&d===this._bLastToFirst||(this._dragScrollResetPages(),this._initDragScroll(t,u,d),this._bFirstToLast=u,this._bLastToFirst=d);if(a&&h<r.getPageCount()-1||!a&&h>0||c){const e=this.element[0],t=Math.min(.33*(s?e.offsetWidth:e.offsetHeight),100),o=this._getCssPositionAttr(),c=this._pagesWrapper,g=this._getPages();if(Math.abs(n)>=t){let e,t;const s={};if(u||d?(u?(e=l-1,t=l>2?1:-1):(e=0,t=l>2?l-2:-1),s.loopDirection=a?ie:se):(e=a?h+1:h-1,t=a?h-1:h+1),t>-1&&t<r.getPageCount()&&this._hidePage(i(g[t])),a&&t>-1&&!d){const e=parseInt(c.css(o),10);c.css(o,e+this._componentSize+ae)}c.css(this._getCssSizeAttr(),2*this._componentSize),this._bTouch=!1,r.setPage(e,s)}else{const e=s?`translate3d(${n}px, 0, 0)`:`translate3d(0, ${n}px, 0)`;pe(g.filter(ce),e)}this._scrolledForThisTouch=!0}this._scrolledForThisTouch&&(e.preventDefault(),e.stopPropagation())},_dragScrollEnd:function(){if(this._bTouch&&this._bDragInit){const e=this._pagingModel.getPage();this._handlePage({previousPage:e,page:e})}this._bTouch=!1,this._bDragInit=!1,this._bFirstToLast=!1,this._bLastToFirst=!1,this._scrolledForThisTouch=!1},_dragScrollResetPages:function(){const e=this._pagesWrapper,t=this._getCssPositionAttr(),s=this._pagingModel,n=s.getPage(),o=s.getPageCount(),a=this._getPages();for(let e=0;e<a.length;e++)e!==n&&this._hidePage(i(a[e]));e.css(t,"0px"),i(a[0]).removeClass(q),i(a[o-1]).removeClass(U)},_addBusyState:function(e){const t=this.element,i=s.getContext(t[0]).getBusyContext(),n={description:`FilmStrip (id='${t.attr("id")}'): ${e}`};return i.addBusyState(n)},_resolveBusyState:function(){this._busyStateResolveFunc&&(this._busyStateResolveFunc(),this._busyStateResolveFunc=null)},getNodeBySubId:function(e){if(null==e)return this.element?this.element[0]:null;const t=e.subId;return t===J?this.widget().find(oe+E+oe+Z).filter(this._filterNestedFilmStripsFunc)[0]:t===X?this.widget().find(oe+E+oe+F).filter(this._filterNestedFilmStripsFunc)[0]:t===Y?this.widget().find(oe+E+oe+ee).filter(this._filterNestedFilmStripsFunc)[0]:t===G?this.widget().find(oe+E+oe+T).filter(this._filterNestedFilmStripsFunc)[0]:null},getSubIdByNode:function(e){const t=this.getNodeBySubId({subId:J}),i=this.getNodeBySubId({subId:X}),s=this.getNodeBySubId({subId:Y}),n=this.getNodeBySubId({subId:G});let o=e;const a=this.element[0];for(;o&&o!==a;){if(o===t)return{subId:J};if(o===i)return{subId:X};if(o===s)return{subId:Y};if(o===n)return{subId:G};o=o.parentElement}return null},_CompareOptionValues:function(e,i,s){return"currentItem"===e?t.Object.compareValues(i,s):this._super(e,i,s)}})}(),e.FilmStripPagingModel=c,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojfilmstrip.js.map