/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojdvt-toolkit","ojs/ojtimeaxis-toolkit"],function(t,e,i){"use strict";const s={_DEFAULT_TIME_DIR_SCROLLBAR_STYLE:"height: 3px; width: 3px; color: #9E9E9E; background-color: #F0F0F0",_DEFAULT_CONTENT_DIR_SCROLLBAR_STYLE:"height: 3px; width: 3px; color: #9E9E9E; background-color: #F0F0F0",_SCROLLBAR_PADDING:4,getTimeDirScrollbarStyle:()=>new e.CSSStyle(s._DEFAULT_TIME_DIR_SCROLLBAR_STYLE),getContentDirScrollbarStyle:()=>new e.CSSStyle(s._DEFAULT_CONTENT_DIR_SCROLLBAR_STYLE),getScrollbarPadding:()=>s._SCROLLBAR_PADDING};class n extends e.BaseComponent{constructor(t,e,i){super(t,e,i),this._virtualize=!1,this.ZOOM_BY_VALUE=1.5,this.WHEEL_UNITS_PER_LINE=40}Init(t,e,i){super.Init(t,e,i),this._virtualize=!1,this.ZOOM_BY_VALUE=1.5,this.WHEEL_UNITS_PER_LINE=40}render(t,e,i){if(t){this._resources=t._resources,null==this._resources&&(this._resources=[]),this.SetOptions(t);var s=this.Options.dragMode;this.SetPanningEnabled("pan"===s||null==s,!0),this.SetMarqueeEnabled("select"===s&&"multiple"===this.Options.selectionMode,!0)}if(this.Width=e,this.Height=i,this.Options){var n=this.Parse(this.Options);this._applyParsedProperties(n)}}SetOptions(t){super.SetOptions(t),this.Options=this.Defaults.calcOptions(t);var i=new Date(t.start).getTime(),s=new Date(t.end).getTime(),n=new Date(t.viewportStart).getTime(),a=new Date(t.viewportEnd).getTime();n>=i&&n<s||(this._viewStartTime=null,this.Options.viewportStart=""),a>i&&a<=s||(this._viewEndTime=null,this.Options.viewportEnd=""),e.Agent.isEnvironmentTest()&&(this.Options.animationOnDisplay="none",this.Options.animationOnDataChange="none")}clearComponent(){this._canvas&&this._canvas.removeChildren()}_applyParsedProperties(t){this._start=t.start,this._end=t.end,this._inlineStyle=t.inlineStyle,this._timeDirScrollbar=t.timeDirScrollbar,this._contentDirScrollbar=t.contentDirScrollbar,this.applyStyleValues()}static sanitizeData(t,e){const i=t=>{if(t._itemData.taskId){const e={...t._itemData};return e.id=e.taskId,e.taskId=void 0,e}return t._itemData},s=t=>{const e={...t};return e._itemData=void 0,e};if("series"===e||"row"===e){const n="series"===e?"items":"tasks",a=t[n];if(a.length>0){const e=Object.assign({},t._noTemplate?t._itemData:t);return a[0]._noTemplate?e[n]=t[n].map(i):a[0]._itemData&&(e[n]=t[n].map(s)),e}}else{if(t._noTemplate)return i(t);if(t._itemData)return s(t)}return t}applyStyleValues(){this._style&&this._style.parseInlineStyle(this._inlineStyle)}isDndEnabled(){return!1}isAnimationEnabled(){return!1}getAdjustedStartTime(){return this._start}getAdjustedEndTime(){return this._end}getContentLength(){return this._contentLength}setContentLength(t){this._canvasLength<t?this._contentLength=t:this._contentLength=this._canvasLength,this._virtualize||(this._fetchStartPos=0,this._fetchEndPos=this._contentLength)}getCanvasSize(){return this._canvasSize}getCanvasLength(){return this._canvasLength}isRTL(){return e.Agent.isRightToLeft(this.getCtx())}isVertical(){return this._isVertical}getTimeAxis(){return null}prepareViewportLength(){var t,e;if(this.setRelativeStartPos(0),this._viewStartTime&&this._viewEndTime)(t=this._viewEndTime-this._viewStartTime)>0&&(e=this._canvasLength/t,this.setContentLength(e*(this._end-this._start)),this.setRelativeStartPos(e*(this._start-this._viewStartTime)));else{var i=this.getTimeAxis(),s=i.getZoomLevelLengths()[i._zoomLevelOrder],n=this._start,a=this._end;null==this._viewStartTime?null!=this._viewEndTime?(this._viewStartTime=this._viewEndTime-this._canvasLength/s*(a-n),this._viewStartTime<this._start&&(this._viewStartTime=this._start),t=this._viewEndTime-this._viewStartTime,e=this._canvasLength/t,this.setContentLength(e*(this._end-this._start)),this.setRelativeStartPos(e*(this._start-this._viewStartTime))):(this._viewStartTime=this._start,this.setRelativeStartPos(0),this._viewEndTime=this._canvasLength/s*(a-n)+this._viewStartTime,this._viewEndTime>this._end&&(this._viewEndTime=this._end)):(this._viewEndTime=this._canvasLength/s*(a-n)+this._viewStartTime,this._viewEndTime>this._end&&(this._viewEndTime=this._end),t=this._viewEndTime-this._viewStartTime,e=this._canvasLength/t,this.setContentLength(e*(this._end-this._start)),this.setRelativeStartPos(e*(this._start-this._viewStartTime)))}}renderTimeZoomCanvas(t){this._timeZoomCanvas?this._timeZoomCanvas.setClipPath(null):this._timeZoomCanvas=new e.Container(this.getCtx(),"g","iCanvas");var i=new e.ClipPath;this.isVertical()?(i.addRect(this._startX,this._startY,this._canvasSize,this._canvasLength),this._timeZoomCanvas.setTranslateX(this._startX),this._timeZoomCanvas.setTranslateY(this._startY+this.getAbsoluteStartPos())):(i.addRect(this._startX,this._startY,this._canvasLength,this._canvasSize),this._timeZoomCanvas.setTranslateX(this._startX+this.getAbsoluteStartPos()),this._timeZoomCanvas.setTranslateY(this._startY)),t.setClipPath(i),this._timeZoomCanvas.getParent()!=t&&t.addChild(this._timeZoomCanvas)}getTimeZoomCanvas(){return this._timeZoomCanvas}renderZoomControls(t){if(!this.isZoomingEnabled())return this._canvas.removeChild(this.zoomin),this._canvas.removeChild(this.zoomout),this.zoomin=null,void(this.zoomout=null);var s,n=this.getCtx(),a=this.getTimeAxis(),o=this.Options.translations,r=t.zoomInProps,h=r.imageSize,l=r.class,_=r.posX,g=r.posY;null==this.zoomin&&(s=e.ToolkitUtils.getIconStyle(n,l),this.zoomin=new e.TransientButton(n,s,h,this.EventManager,this.EventManager.HandleZoomInClick),this.EventManager.associate(this.zoomin,this.zoomin));var m=t.zoomOutProps;h=m.imageSize,l=m.class;var c=m.posX,v=m.posY;null==this.zoomout&&(s=e.ToolkitUtils.getIconStyle(n,l),this.zoomout=new e.TransientButton(n,s,h,this.EventManager,this.EventManager.HandleZoomOutClick),this.EventManager.associate(this.zoomout,this.zoomout)),this.zoomin.setTooltip(o.tooltipZoomIn),this.zoomout.setTooltip(o.tooltipZoomOut),this.zoomin.hide(),this.zoomout.hide(),i.TimeAxisUtils.supportsTouch()&&(e.ToolkitUtils.setAttrNullNS(this.zoomin.getElem(),"role","button"),e.ToolkitUtils.setAttrNullNS(this.zoomin.getElem(),"aria-label",o.tooltipZoomIn),e.ToolkitUtils.setAttrNullNS(this.zoomout.getElem(),"role","button"),e.ToolkitUtils.setAttrNullNS(this.zoomout.getElem(),"aria-label",o.tooltipZoomOut)),this.zoomin.setTranslateX(_),this.zoomout.setTranslateX(c),this.zoomin.setTranslateY(g),this.zoomout.setTranslateY(v),this.zoomin.getParent()!=this._canvas&&this._canvas.addChild(this.zoomin),this.zoomout.getParent()!=this._canvas&&this._canvas.addChild(this.zoomout);var u=this.getContentLength();u>=a.getMaxContentLength()&&this.disableZoomButton(!0),this._canvasLength>=u&&this.disableZoomButton(!1)}HandleMouseWheel(t){e.EventManager.consumeEvent(t);var i=t.wheelDelta,s=t.getNativeEvent();if(this.hasValidOptions()&&(null!=s.wheelDeltaX?t.wheelDeltaX=s.wheelDeltaX/this.WHEEL_UNITS_PER_LINE:null!=s.deltaX&&(s.deltaMode==s.DOM_DELTA_LINE?t.wheelDeltaX=-s.deltaX:s.deltaMode==s.DOM_DELTA_PIXEL&&(t.wheelDeltaX=-s.deltaX/n.SCROLL_LINE_HEIGHT)),i)){var a=this.getCtx().getStageAbsolutePosition();if(this._isVertical)var o=t.pageY-a.y-this.getStartYOffset();else o=t.pageX-a.x-this.getStartXOffset();var r=(this._end-this._start)/this.getContentLength();if(this.isRTL()&&!this._isVertical)var h=this._viewEndTime-r*o;else h=r*o+this._viewStartTime;t.zoomTime=h,t.zoomCompLoc=o,t.zoomWheelDelta=.02*i+1}}handleZoomWheel(t,e,i,s){var n=(this._viewEndTime-this._viewStartTime)/(this._end-this._start)*this.getContentLength();this.setContentLength(t);var a=n/this.getContentLength()*(this._end-this._start);if(e){var o=(this._end-this._start)/this.getContentLength();this.isRTL()&&!this._isVertical?(this._viewEndTime=e+i*o,this._viewEndTime>this._end&&(this._viewEndTime=this._end),this._viewStartTime=this._viewEndTime-a,this._viewStartTime<this._start&&(this._viewStartTime=this._start,this._viewEndTime=this._viewStartTime+a,this._viewEndTime>this._end&&(this._viewEndTime=this._end))):(this._viewStartTime=e-i*o,this._viewStartTime<this._start&&(this._viewStartTime=this._start),this._viewEndTime=this._viewStartTime+a,this._viewEndTime>this._end&&(this._viewEndTime=this._end,this._viewStartTime=this._viewEndTime-a,this._viewStartTime<this._start&&(this._viewStartTime=this._start))),this.setRelativeStartPos(1/o*(this._start-this._viewStartTime))}else this._viewStartTime=this._start,this._viewEndTime=this._viewStartTime+a,this._viewEndTime>this._end&&(this._viewEndTime=this._end),this.setRelativeStartPos(0);this.applyTimeZoomCanvasPosition()}zoomBy(t){var e=(1/t-1)/2+1;if(this._isVertical)var i=this.Height/2;else i=this.Width/2;var s=(this._end-this._start)/this.getContentLength()*i+this._viewStartTime;this.handleZoomWheel(this.getContentLength()*e,s,i,!0)}beginPinchZoom(t,e,i,s){this._isVertical?this._initialPinchZoomLoc=Math.sqrt((e-s)*(e-s))+(e<s?e:s):this._initialPinchZoomLoc=Math.sqrt((t-i)*(t-i))+(t<i?t:i);var n=(this._end-this._start)/this.getContentLength();this.isRTL()&&!this._isVertical?this._initialPinchZoomTime=this._viewEndTime-n*this._initialPinchZoomLoc:this._initialPinchZoomTime=n*this._initialPinchZoomLoc+this._viewStartTime,this._initialPinchZoomDist=Math.sqrt((t-i)*(t-i)+(e-s)*(e-s)),this._initialPinchZoomLength=this.getContentLength()}contPinchZoom(t,e,i,s){var n=Math.sqrt((t-i)*(t-i)+(e-s)*(e-s));n!=this._initialPinchZoomDist&&(this._triggerViewportChange=!0);var a=n/this._initialPinchZoomDist*this._initialPinchZoomLength;this.handleZoomWheel(a,this._initialPinchZoomTime,this._initialPinchZoomLoc,!1)}endPinchZoom(){this._initialPinchZoomDist=null,this._initialPinchZoomLoc=null,this._initialPinchZoomLength=null,this._initialPinchZoomTime=null,this._triggerViewportChange&&(this._triggerViewportChange=!1,this.dispatchEvent(this.createViewportChangeEvent()))}SetPanningEnabled(t,e){var i=this.getOptions().dragMode;this._panningEnabled=!(!e&&"pan"!==i&&null!=i)&&t}IsPanningEnabled(){return this._panningEnabled}SetMarqueeEnabled(t,e){e||this.isMarqueeSelectEnabled()?this._marqueeEnabled=t:this._marqueeEnabled=!1}IsMarqueeEnabled(){return this._marqueeEnabled}isMarqueeSelectEnabled(){return"select"===this.getOptions().dragMode&&"multiple"===this.getOptions().selectionMode}isZoomingEnabled(){return"off"!==this.getOptions().zooming}IsTimeCursorEnabled(){return"on"===this.getOptions().timeCursor}panZoomCanvasBy(t){if(this._isVertical){var e=this._timeZoomCanvas.getTranslateY()-t,i=-(this.getContentLength()-this._canvasLength-this._startY),s=this._startY;e<i?e=i:e>s&&(e=s),this._timeZoomCanvas.setTranslateY(e);var n=e-this._startY;this.setAbsoluteStartPos(n);var a=this.getContentLength()/(this._end-this._start),o=this._viewEndTime-this._viewStartTime;this._viewStartTime=this._start-n/a,this._viewEndTime=this._viewStartTime+o,this._viewEndTime>this._end&&(this._viewEndTime=this._end)}else{var r=this._timeZoomCanvas.getTranslateX()-t,h=-(this.getContentLength()-this._canvasLength-this._startX),l=this._startX;r<h?r=h:r>l&&(r=l),this._timeZoomCanvas.setTranslateX(r),this.setAbsoluteStartPos(r-this._startX),n=this.getRelativeStartPos(),a=this.getContentLength()/(this._end-this._start),o=this._viewEndTime-this._viewStartTime,this._viewStartTime=this._start-n/a,this._viewEndTime=this._viewStartTime+o,this._viewEndTime>this._end&&(this._viewEndTime=this._end)}}handleZoom(t){t?this.zoomBy(1/this.ZOOM_BY_VALUE):this.zoomBy(this.ZOOM_BY_VALUE)}enableZoomButton(t){t?this.zoomin.setEnabled(!0):this.zoomout.setEnabled(!0)}disableZoomButton(t){t?(this.zoomin.setEnabled(!1),this.zoomin.setCursor(null)):(this.zoomout.setEnabled(!1),this.zoomout.setCursor(null))}applyTimeZoomCanvasPosition(){this._isVertical?this._timeZoomCanvas.setTranslateY(this._startY+this.getAbsoluteStartPos()):this._timeZoomCanvas.setTranslateX(this._startX+this.getAbsoluteStartPos())}getAbsoluteStartPos(){return this._startPos}setAbsoluteStartPos(t){this._startPos=t}getRelativeStartPos(){return this.isRTL()&&!this._isVertical?this._canvasLength-this.getContentLength()-this._startPos:this._startPos}setRelativeStartPos(t){this.isRTL()&&!this._isVertical?this._startPos=this._canvasLength-this.getContentLength()-t:this._startPos=t}getStartXOffset(){return this._startX}setStartXOffset(t){this._startX=t}getStartYOffset(){return this._startY}setStartYOffset(t){this._startY=t}getGraphicalAreaBounds(){return this.isVertical()?new e.Rectangle(this._startX,this._startY,this._canvasSize,this._canvasLength):new e.Rectangle(this._startX,this._startY,this._canvasLength,this._canvasSize)}isTimeDirScrollbarOn(){return!0}isContentDirScrollbarOn(){return!0}getTimeDirScrollbar(){return this.timeDirScrollbar}setTimeDirScrollbar(t){this.timeDirScrollbar=t}setContentDirScrollbar(t,e){null!=e?(null==this.contentDirScrollbar&&(this.contentDirScrollbar=[]),this.contentDirScrollbar[e]=t):this.contentDirScrollbar=t}getScrollbarPadding(){return s._SCROLLBAR_PADDING}getTimeDirScrollbarStyle(){return s.getTimeDirScrollbarStyle()}getContentDirScrollbarStyle(){return s.getContentDirScrollbarStyle()}HandleEvent(t,e){"dvtSimpleScrollbar"==t.type&&(t=this.processScrollbarEvent(t,e)),t&&this.dispatchEvent(t)}processScrollbarEvent(t,e){if(e==this.timeDirScrollbar){var i=t.newMin,s=t.newMax;this._viewStartTime=i,this._viewEndTime=s;var n=this.getContentLength()/(this._end-this._start);this.setRelativeStartPos(n*(this._start-this._viewStartTime)),this.applyTimeZoomCanvasPosition();var a=this.createViewportChangeEvent();this.dispatchEvent(a)}}processEvent(t){t&&this.dispatchEvent(t)}createViewportChangeEvent(){return null}getViewportStartTime(){return this._viewStartTime}setViewportStartTime(t){this._viewStartTime=t}getViewportEndTime(){return this._viewEndTime}setViewportEndTime(t){this._viewEndTime=t}HandleKeyDown(t){}HandleMouseDown(t){}HandleFocus(t){null!=this.zoomin&&this.zoomin._onFocus(t),null!=this.zoomout&&this.zoomout._onFocus(t)}HandleBlur(t){null!=this.zoomin&&this.zoomin._onBlur(t),null!=this.zoomout&&this.zoomout._onBlur(t)}beginDragPan(t,e){this._currentX=t,this._currentY=e}endDragPan(){this.endPan()}setPanCursorDown(){this.setCursor(e.ToolkitUtils.getGrabbingCursor())}setPanCursorUp(){this.setCursor(e.ToolkitUtils.getGrabCursor())}registerAndConstructGlassPane(){if(this._glassPaneUsageStack||(this._glassPaneUsageStack=[]),!this._glassPane){var t=this.getGraphicalAreaBounds();this._glassPane=new e.Rect(this.getCtx(),t.x,t.y,t.w,t.h),this._glassPane.setInvisibleFill()}this._glassPaneUsageStack.push(1)}installGlassPane(){return!this._glassPaneDrawn&&(this.addChild(this._glassPane),this._glassPaneDrawn=!0,!0)}unregisterAndDestroyGlassPane(){this._glassPaneUsageStack.pop(),this._glassPaneDrawn&&0===this._glassPaneUsageStack.length&&(this.removeChild(this._glassPane),this._glassPaneDrawn=!1)}renderAriaLiveRegion(t){if(!this._ariaLiveRegion){var e=this.getCtx();this._ariaLiveRegion=document.createElement("div"),this._ariaLiveRegion.id=t,this._ariaLiveRegion.setAttribute("aria-live","assertive"),this._ariaLiveRegion.style.clip="rect(1px, 1px, 1px, 1px)",this._ariaLiveRegion.style.height="1px",this._ariaLiveRegion.style.overflow="hidden",this._ariaLiveRegion.style.position="absolute",this._ariaLiveRegion.style.whiteSpace="nowrap",this._ariaLiveRegion.style.width="1px",e.getContainer().appendChild(this._ariaLiveRegion)}}getAriaLiveRegion(){return this._ariaLiveRegion}updateLiveRegionText(t){this._ariaLiveRegion&&(this._ariaLiveRegion.textContent=t)}removeAriaLiveRegion(){this._ariaLiveRegion&&(this.getCtx().getContainer().removeChild(this._ariaLiveRegion),this._ariaLiveRegion=null)}HandleTouchEnd(t){"none"!=this._selectionMode&&this.handleShapeClick(t,"multiple"==this._selectionMode)}handleShapeClick(t){}HandleMouseClick(t){this.handleShapeClick(t,t.ctrlKey&&"multiple"==this._selectionMode)}endPan(){this._triggerViewportChange&&(this._triggerViewportChange=!1,this.dispatchEvent(this.createViewportChangeEvent()))}contDragPan(t,e){if(this._currentX&&this._currentY){var i=this._currentX-t,s=this._currentY-e;return(0!=i||0!=s)&&(this._triggerViewportChange=!0,this._currentX=t,this._currentY=e,this.panBy(i,s),!0)}return!1}panBy(t,e){this.panZoomCanvasBy(t)}}n.SCROLL_LINE_HEIGHT=15;class a extends e.EventManager{constructor(t){super(t.getCtx(),t.processEvent,t,t),this._comp=t,this._isDragPanning=!1,this._isPinchZoom=!1}Init(t,e,i,s){void 0!==e?(super.Init(t,e,i,s),this._comp=s):(super.Init(t.getCtx(),t.processEvent,t,t),this._comp=t),this._isDragPanning=!1,this._isPinchZoom=!1}addListeners(t){super.addListeners(t),e.SvgDocumentUtils.addDragListeners(this._comp,this._onDragStart,this._onDragMove,this._onDragEnd,this),e.Agent.isTouchDevice()||("firefox"===e.Agent.browser?t.addEvtListener("wheel",this.OnMouseWheel,!1,this):t.addEvtListener(e.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this))}RemoveListeners(t){super.RemoveListeners(t),e.Agent.isTouchDevice()||("firefox"===e.Agent.browser?t.removeEvtListener("wheel",this.OnMouseWheel,!1,this):t.removeEvtListener(e.MouseEvent.MOUSEWHEEL,this.OnMouseWheel,!1,this))}OnFocus(t){super.OnFocus(t),this._comp.HandleFocus(t)}OnBlur(t){super.OnBlur(t),this._comp.HandleBlur(t)}OnKeyDown(t){super.OnKeyDown(t),this._comp.HandleKeyDown(t)}OnClick(t){super.OnClick(t),this._comp.HandleMouseClick(t)}PreOnMouseDown(t){super.PreOnMouseDown(t),this._comp.HandleMouseDown(t)}OnMouseWheel(t){this._comp.HandleMouseWheel(t)}OnTouchStartBubble(t){super.OnTouchStartBubble(t),this._comp.HandleTouchStart(t),this._comp.getCtx().getStage().getSVGRoot().parentNode.focus()}OnTouchEndBubble(t){super.OnTouchEndBubble(t),this._comp.HandleTouchEnd(t)}UpdateActiveElement(t,e){super.UpdateActiveElement(t,t.getAriaLabel&&(t.getDisplayable||t.getDisplayables)?null:e)}_onDragStart(t){return!!this._comp.hasValidOptions()&&(e.EventManager.isTouchEvent(t)?this._onTouchDragStart(t):this._onMouseDragStart(t))}_onDragMove(t){return e.EventManager.isTouchEvent(t)?this._onTouchDragMove(t):this._onMouseDragMove(t)}_onDragEnd(t){return e.EventManager.isTouchEvent(t)?this._onTouchDragEnd(t):this._onMouseDragEnd(t)}_getRelativePosition(t,i){return this._stageAbsolutePosition||(this._stageAbsolutePosition=this._context.getStageAbsolutePosition()),new e.Point(t-this._stageAbsolutePosition.x,i-this._stageAbsolutePosition.y)}_onMouseDragStart(t){if(t.button!=e.MouseEvent.RIGHT_CLICK_BUTTON){var i=this._getRelativePosition(t.pageX,t.pageY),s=this._getDragHandler(i);if(this._comp.IsPanningEnabled()){if(this._comp.getGraphicalAreaBounds().containsPoint(i.x,i.y)&&!this._isDragPanning)return this.hideTooltip(),this._comp.registerAndConstructGlassPane(),this._comp.setPanCursorDown(),this._comp.beginDragPan(i.x,i.y),this._isDragPanning=!0,!0}else if(s&&this._comp.IsMarqueeEnabled()){var n=s.processDragStart(i,t.ctrlKey);return n&&(n._relPos=i,this.ProcessMarqueeEvent(n)),this._comp.setCursor(s.getCursor(i)),!0}}return!1}_onMouseDragMove(t){var e=this._getRelativePosition(t.pageX,t.pageY),i=this._getDragHandler();if(this._comp.IsPanningEnabled()&&this._comp.contDragPan(e.x,e.y)&&this._isDragPanning)this._comp.installGlassPane();else if(i&&this._comp.IsMarqueeEnabled()){var s=i.processDragMove(e,t.ctrlKey);s&&(s._relPos=e,this.ProcessMarqueeEvent(s))}}_onMouseDragEnd(t){var e=this._getRelativePosition(t.pageX,t.pageY),i=this._getDragHandler();if(this._comp.IsPanningEnabled()&&this._isDragPanning)this._isDragPanning=!1,this._comp.endDragPan(),this._comp.unregisterAndDestroyGlassPane(),this._comp.getGraphicalAreaBounds().containsPoint(e.x,e.y)?this._comp.setPanCursorUp():this._comp.setCursor("inherit");else if(i&&this._comp.IsMarqueeEnabled()){var s=i.processDragEnd(e,t.ctrlKey);s&&(s._relPos=e,this.ProcessMarqueeEvent(s)),this._comp.setCursor(i.getCursor(e))}this._stageAbsolutePosition=null}OnMouseMove(t){super.OnMouseMove(t);var e=this._getRelativePosition(t.pageX,t.pageY),i=this._getDragHandler();if(this._comp.getGraphicalAreaBounds().containsPoint(e.x,e.y)){if(this._comp.IsPanningEnabled())return void(this._isDragPanning?this._comp.setPanCursorDown():this._comp.setPanCursorUp());if(i)return void(this._comp.IsMarqueeEnabled()&&this._comp.setCursor(i.getCursor(e)))}this._comp.setCursor("inherit")}_onTouchDragStart(t){var e=t.touches,i=this._comp.getGraphicalAreaBounds(),s=t=>{t.preventDefault(),this._comp.isDndEnabled()||t.stopPropagation()};if(1==e.length){var n=this._getRelativePosition(e[0].pageX,e[0].pageY),a=this._getDragHandler();if(i.containsPoint(n.x,n.y)){if(this._comp.IsPanningEnabled())return this._comp.beginDragPan(n.x,n.y),this._comp.getOptions().itemBubbleContentRenderer||s(t),!0;if(a&&this._comp.IsMarqueeEnabled()){var o=a.processDragStart(n,!0);return o&&(o._relPos=n,this.ProcessMarqueeEvent(o)),this.getCtx().getTooltipManager().hideTooltip(),s(t),!0}}}else if(2==e.length){this._comp.IsPanningEnabled()&&this._comp.endDragPan(),this._isPinchZoom=!0;var r=this._getRelativePosition(e[0].pageX,e[0].pageY),h=this._getRelativePosition(e[1].pageX,e[1].pageY);if(i.containsPoint(r.x,r.y)&&i.containsPoint(h.x,h.y))return this._comp.beginPinchZoom(r.x,r.y,h.x,h.y),s(t),!0}return!1}_onTouchDragMove(t){var e=t.touches;if(1==e.length){var i=this._getRelativePosition(e[0].pageX,e[0].pageY),s=this._getDragHandler();if(this._comp.IsPanningEnabled())this._comp.contDragPan(i.x,i.y),t.preventDefault();else if(s&&this._comp.IsMarqueeEnabled()){var n=s.processDragMove(i,!0);n&&(n._relPos=i,this.ProcessMarqueeEvent(n)),this.getCtx().getTooltipManager().hideTooltip(),t.preventDefault()}}else if(2==e.length){var a=this._getRelativePosition(e[0].pageX,e[0].pageY),o=this._getRelativePosition(e[1].pageX,e[1].pageY);this._comp.contPinchZoom(a.x,a.y,o.x,o.y),t.preventDefault()}}_onTouchDragEnd(t){if(this._isPinchZoom)this._isPinchZoom=!1,this._comp.endPinchZoom(),t.preventDefault();else if(this._comp.IsPanningEnabled())this._comp.endDragPan(),this._comp.getOptions().itemBubbleContentRenderer||t.preventDefault();else if(this._comp.IsMarqueeEnabled()){var e=this._getDragHandler();if(e)var i=e.processDragEnd(null,!0);i&&this.ProcessMarqueeEvent(i),t.preventDefault()}this._stageAbsolutePosition=null}_getDragHandler(t){return t&&!this._comp.getGraphicalAreaBounds().containsPoint(t.x,t.y)?null:this._comp.isMarqueeSelectEnabled()?this._marqueeSelectHandler:null}setMarqueeSelectHandler(t){this._marqueeSelectHandler=t}ProcessMarqueeEvent(t){}cancelMarquee(t){this._comp.isMarqueeSelectEnabled()&&this._marqueeSelectHandler&&this._marqueeSelectHandler.cancelMarquee()}zoomBy(t){this._comp.zoomBy(t)}panBy(t,i){var s=t*this._comp._canvasLength*(e.Agent.isRightToLeft(this._context)?-1:1),n=i*this._comp._canvasSize;0!=s&&(this._comp._triggerViewportChange=!0),this._comp.panBy(s,n),this._comp.endPan()}HandleZoomInClick(t){this._comp.handleZoom(!0)}HandleZoomOutClick(t){this._comp.handleZoom(!1)}GetTouchResponse(){return e.EventManager.TOUCH_RESPONSE_TOUCH_HOLD}}class o extends e.KeyboardHandler{isSelectionEvent(t){return this.isNavigationEvent(t)&&!t.ctrlKey}isMultiSelectEvent(t){return t.keyCode==e.KeyboardEvent.SPACE&&t.ctrlKey}processKeyDown(t){if(e.KeyboardEvent.isPlus(t)||e.KeyboardEvent.isEquals(t))this._eventManager.HandleZoomInClick();else if(e.KeyboardEvent.isMinus(t)||e.KeyboardEvent.isUnderscore(t))this._eventManager.HandleZoomOutClick();else{var i=t.keyCode;i==e.KeyboardEvent.PAGE_UP?(t.shiftKey?this._eventManager.panBy(-.25,0):this._eventManager.panBy(0,-.25),e.EventManager.consumeEvent(t)):i==e.KeyboardEvent.PAGE_DOWN&&(t.shiftKey?this._eventManager.panBy(.25,0):this._eventManager.panBy(0,.25),e.EventManager.consumeEvent(t))}return super.processKeyDown(t)}}t.TimeComponent=n,t.TimeComponentEventManager=a,t.TimeComponentKeyboardHandler=o,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojdvt-timecomponent.js.map