/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojdvt-toolkit"],function(t,i){"use strict";class e extends i.BaseComponentDefaults{constructor(){super({alta:{overviewPosition:"below",style:{currentTimeIndicatorColor:"#c000d1",handleFillColor:"#ffffff",handleTextureColor:"#b3c6db",leftFilterPanelAlpha:.7,leftFilterPanelColor:"#ffffff",overviewBackgroundColor:"#e6ecf3",rightFilterPanelAlpha:.7,rightFilterPanelColor:"#ffffff",timeAxisBarColor:"#e5e5e5",timeAxisBarAlpha:1,timeIndicatorColor:"#bcc7d2",windowBackgroundAlpha:1,windowBackgroundColor:"#ffffff",windowBorderBottomColor:"#4f4f4f",windowBorderBottomStyle:"solid",windowBorderLeftColor:"#4f4f4f",windowBorderLeftStyle:"solid",windowBorderRightColor:"#4f4f4f",windowBorderRightStyle:"solid",windowBorderTopColor:"#4f4f4f",windowBorderTopStyle:"solid"}}})}}class n extends i.EventManager{constructor(t){super(t.getCtx(),t.processEvent,t),this._overview=t}addListeners(t){i.SvgDocumentUtils.addDragListeners(this._overview,this._onDragStart,this._onDragMove,this._onDragEnd,this)}_onDragStart(t){return i.EventManager.isTouchEvent(t)?this._onTouchDragStart(t):this._onMouseDragStart(t)}_onDragMove(t){return i.EventManager.isTouchEvent(t)?this._onTouchDragMove(t):this._onMouseDragMove(t)}_onDragEnd(t){return i.EventManager.isTouchEvent(t)?this._onTouchDragEnd(t):this._onMouseDragEnd(t)}_getRelativePosition(t,e){return this._stageAbsolutePosition||(this._stageAbsolutePosition=this._context.getStageAbsolutePosition()),new i.Point(t-this._stageAbsolutePosition.x,e-this._stageAbsolutePosition.y)}_onMouseDragStart(t){if(t.button!==i.MouseEvent.RIGHT_CLICK_BUTTON){var e=this._getRelativePosition(t.pageX,t.pageY);return this._overview.beginDragPan(t,e.x,e.y)}return!1}_onMouseDragMove(t){var i=this._getRelativePosition(t.pageX,t.pageY);return this._overview.contDragPan(t,i.x,i.y),!0}_onMouseDragEnd(t){this._overview.endDragPan(),this._stageAbsolutePosition=null}_onTouchDragStart(t){var i=t.touches;if(t.stopPropagation(),1===i.length){var e=this._getRelativePosition(i[0].pageX,i[0].pageY);return t.preventDefault(),this._overview.beginDragPan(t,e.x,e.y)}return!1}_onTouchDragMove(t){var i=t.touches;if(1===i.length){var e=this._getRelativePosition(i[0].pageX,i[0].pageY);this._overview.contDragPan(t,e.x,e.y),t.preventDefault()}t.stopPropagation()}_onTouchDragEnd(t){this._overview.endDragPan(),i.EventManager.consumeEvent(t),this._stageAbsolutePosition=null}}class s{constructor(t){this._view=t}parse(t){return this.ParseRootAttributes(t)}ParseRootAttributes(t){var e={};return e.animationOnClick=t.animationOnClick,null!=t.xMin&&(e.xMin=t.xMin),null!=t.xMax&&(e.xMax=t.xMax),null!=t.x1&&(e.x1=t.x1),null!=t.x2&&(e.x2=t.x2),null!=t.yMin&&(e.yMin=t.yMin),null!=t.yMax&&(e.yMax=t.yMax),null!=t.y1&&(e.y1=t.y1),null!=t.y2&&(e.y2=t.y2),null!=t.referenceObjects&&(e.referenceObjects=t.referenceObjects),e.orientation="horizontal",null!=t.orientation&&(e.orientation=t.orientation),e.featuresOff=t.featuresOff,e.minimumWindowSize=t.minimumWindowSize,e.leftMargin=t.leftMargin,e.rightMargin=t.rightMargin,e.overviewPosition="below",e.selectionMode="none",e.isRtl=i.Agent.isRightToLeft(this._view.getCtx()).toString(),null!=t.rtl&&(e.isRtl=t.rtl.toString()),e}calculateWidth(t,i,e,n,s){var o=s*(i-t),r=n-e;return 0===o||0===r?0:o/r}}const o=5,r=1,a=t=>null!=t._hfc?t._hfc:t.style.handleFillColor,l=t=>null!=t._htc?t._htc:t.style.handleTextureColor,h=(t,i)=>i?null!=t._vhbc?t._vhbc:t.style.vertHandleBackgroundClass:null!=t._hbc?t._hbc:t.style.handleBackgroundClass,d=(t,i)=>i?null!=t._vhs?t._vhs:t.style.vertHandleSize:null!=t._hs?t._hs:t.style.handleSize,g=t=>null!=t._btc?t._btc:t.style.borderTopColor,u=t=>null!=t._bts?t._bts:t.style.borderTopStyle,_=t=>null!=t._wbc?t._wbc:t.style.windowBackgroundColor,w=t=>t.style.windowBackgroundAlpha,c=t=>null!=t._wbts?t._wbts:t.style.windowBorderTopStyle,v=t=>null!=t._wbrs?t._wbrs:t.style.windowBorderRightStyle,m=t=>null!=t._wbbs?t._wbbs:t.style.windowBorderBottomStyle,P=t=>null!=t._wbls?t._wbls:t.style.windowBorderLeftStyle,S=t=>null!=t._wbtc?t._wbtc:t.style.windowBorderTopColor,f=t=>null!=t._wbrc?t._wbrc:t.style.windowBorderRightColor,p=t=>null!=t._wbbc?t._wbbc:t.style.windowBorderBottomColor,x=t=>null!=t._wblc?t._wblc:t.style.windowBorderLeftColor,C=t=>null!=t._obc?t._obc:t.style.overviewBackgroundColor,M=t=>null!=t._ctic?t._ctic:t.style.currentTimeIndicatorColor,b=t=>null!=t._tabc?t._tabc:t.style.timeAxisBarColor,H=t=>null!=t._tabo?t._tabo:t.style.timeAxisBarAlpha,W=t=>null!=t._tic?t._tic:t.style.timeIndicatorColor,T=t=>t.style.leftFilterPanelColor,y=t=>t.style.leftFilterPanelAlpha,X=t=>t.style.rightFilterPanelColor,D=t=>t.style.rightFilterPanelAlpha,L={supportsTouch:()=>i.Agent.isTouchDevice(),getDatePosition:(t,i,e,n)=>{var s=(e-t)*n,o=i-t;return 0==s||0==o?0:s/o},getPositionDate:(t,i,e,n)=>{var s=e*(i-t);return 0===s||0===n?t:s/n+t}},O={renderOverview:t=>{t.isBackgroundRendered()&&O._renderBackground(t);var i=null!=t._callback||null!=t._callbackObj;i&&O._renderSlidingWindow(t),O._renderTimeAxis(t),O._parseFilledTimeRanges(t),O._updateReferenceLines(t),t.renderData(t.Width,t.Height),i&&(O._createBorderAroundSlidingWindow(t),O._updateSlidingWindow(t))},_renderBackground:t=>{var e=new i.Rect(t.getCtx(),0,0,t.Width,t.Height,"bg");e.setSolidFill(t._overviewBackgroundColor),e.setPixelHinting(!0),t.addChild(e)},_renderSlidingWindow:t=>{var e=t.Width,n=t.Height,s=new i.Rect(t.getCtx(),0,0,e,n,"window");if(s.setSolidFill(t._windowBackgroundColor,t._windowBackgroundAlpha),s.setPixelHinting(!0),!t.isFeatureOff("zoom")){var o,r=t.getHandleSize(),a=t.getHandleStart(),l=t.getGrippySize();if(t.isVerticalScrollingEnabled()){var h=t.getSlidingWindowWidth(),d=i.PathUtils.moveTo(0,0)+i.PathUtils.quadTo(3,6,8,8)+i.PathUtils.lineTo(28,8)+i.PathUtils.quadTo(33,6,36,0);i.PathUtils.closePath();var g=i.PathUtils.moveTo(0,0)+i.PathUtils.quadTo(3,-6,8,-8)+i.PathUtils.lineTo(28,-8)+i.PathUtils.quadTo(33,-6,36,0);i.PathUtils.closePath();var u=new i.Rect(t.getCtx(),0,0,h,r,"thb"),_=new i.Rect(t.getCtx(),0,0,h,r,"bhb");if(o="row-resize",t._vertHandleBackgroundClass)var w=O._createGrippyImage(t,h,l,!0),c=O._createGrippyImage(t,h,l,!0);else w=O._createGrippy(t,!0),c=O._createGrippy(t,!0);u.setSolidFill(t._windowBackgroundColor,0),_.setSolidFill(t._windowBackgroundColor,0),u.setPixelHinting(!0),_.setPixelHinting(!0);var v=new i.Path(t.getCtx(),d,"th"),m=new i.Path(t.getCtx(),g,"bh");v.setSolidFill(t._handleFillColor),v.setSolidStroke(t._handleFillColor),m.setSolidFill(t._handleFillColor),m.setSolidStroke(t._handleFillColor),t._windowBackgroundColor===t._handleFillColor&&(v.setPixelHinting(!0),m.setPixelHinting(!0)),u.setCursor(o),_.setCursor(o),v.setCursor(o),m.setCursor(o),w.setCursor(o),c.setCursor(o),s.addChild(u),t._windowTopHandleBackground=u,s.addChild(v),t._windowTopHandle=v,s.addChild(w),t._windowTopGrippy=w,s.addChild(_),t._windowBottomHandleBackground=_,s.addChild(m),t._windowBottomHandle=m,s.addChild(c),t._windowBottomGrippy=c}if(t.isHorizontalScrollingEnabled()){var P=t.getSlidingWindowHeight(),S=i.PathUtils.moveTo(0,0)+i.PathUtils.quadTo(6,3,8,8)+i.PathUtils.lineTo(8,28)+i.PathUtils.quadTo(6,33,0,36);i.PathUtils.closePath();var f=i.PathUtils.moveTo(0,0)+i.PathUtils.quadTo(-6,3,-8,8)+i.PathUtils.lineTo(-8,28)+i.PathUtils.quadTo(-6,33,0,36);i.PathUtils.closePath();var p=new i.Rect(t.getCtx(),0-a,0,r,P,"lhb"),x=new i.Rect(t.getCtx(),a,0,r,P,"rhb");if(o="col-resize",t._horHandleBackgroundClass)var C=O._createGrippyImage(t,l,P,!1),M=O._createGrippyImage(t,l,P,!1);else C=O._createGrippy(t,!1),M=O._createGrippy(t,!1);p.setSolidFill(t._windowBackgroundColor,0),x.setSolidFill(t._windowBackgroundColor,0),p.setPixelHinting(!0),x.setPixelHinting(!0);var b=new i.Path(t.getCtx(),S,"lh"),H=new i.Path(t.getCtx(),f,"rh");b.setSolidFill(t._handleFillColor),b.setSolidStroke(t._handleFillColor),H.setSolidFill(t._handleFillColor),H.setSolidStroke(t._handleFillColor),t._windowBackgroundColor===t._handleFillColor&&(b.setPixelHinting(!0),H.setPixelHinting(!0)),p.setCursor(o),x.setCursor(o),b.setCursor(o),H.setCursor(o),C.setCursor(o),M.setCursor(o),s.addChild(p),t._windowLeftHandleBackground=p,s.addChild(b),t._windowLeftHandle=b,s.addChild(C),t._windowLeftGrippy=C,s.addChild(x),t._windowRightHandleBackground=x,s.addChild(H),t._windowRightHandle=H,s.addChild(M),t._windowRightGrippy=M}}s.setCursor("move"),t.addChild(s),O._renderTimeAxisTopBar(t),O._renderLeftAndRightFilters(t,a)},_createGrippyImage:(t,e,n,s)=>{var o,r=t.getCtx();if(s){var a=n/2,l=i.ToolkitUtils.getIconStyle(r,t._vertHandleBackgroundClass);(o=i.OutputText.createIcon(r,{style:l,size:t._vertHandleSize,pos:{x:0,y:a}})).setId("vgrpy")}else{var h=e/2,d=i.ToolkitUtils.getIconStyle(r,t._horHandleBackgroundClass);(o=i.OutputText.createIcon(r,{style:d,size:t._horHandleSize,pos:{x:h,y:0}})).setId("hgrpy")}o.setMouseEnabled(!1);var g=new i.Container(r);return g.addChild(o),g},_createGrippy:(t,e)=>{var n=t._handleTextureColor;if(e){for(var s=new i.Container(t.getCtx(),"g","vgrpy"),o=8,r=3,a=0;a<9;a++){var l=new i.Line(t.getCtx(),o+2*a,r,o+2*a+1,r,"dot1"+a);l.setSolidStroke(n),s.addChild(l),r+=2,(l=new i.Line(t.getCtx(),o+1+2*a,r,o+1+2*a+1,r,"dot2"+a)).setSolidStroke(n),s.addChild(l),r+=2,(l=new i.Line(t.getCtx(),o+2*a,r,o+2*a+1,r,"dot3"+a)).setSolidStroke(n),s.addChild(l),r=3}(l=new i.Line(t.getCtx(),o+18,r,o+18+1,r,"dot4")).setSolidStroke(n),s.addChild(l),r+=4,(l=new i.Line(t.getCtx(),o+18,r,o+18+1,r,"dot5")).setSolidStroke(n),s.addChild(l)}else{for(s=new i.Container(t.getCtx(),"g","hgrpy"),o=3,r=8,a=0;a<9;a++)(l=new i.Line(t.getCtx(),o,r+2*a,o,r+2*a+1,"dot1"+a)).setSolidStroke(n),s.addChild(l),o+=2,(l=new i.Line(t.getCtx(),o,r+1+2*a,o,r+1+2*a+1,"dot2"+a)).setSolidStroke(n),s.addChild(l),o+=2,(l=new i.Line(t.getCtx(),o,r+2*a,o,r+2*a+1,"dot3"+a)).setSolidStroke(n),s.addChild(l),o=3;(l=new i.Line(t.getCtx(),o,r+18,o,r+18+1,"dot4")).setSolidStroke(n),s.addChild(l),o+=4,(l=new i.Line(t.getCtx(),o,r+18,o,r+18+1,"dot5")).setSolidStroke(n),s.addChild(l)}return s.setPixelHinting(!0),s},_createBorderAroundSlidingWindow:t=>{var e=t.Width,n=t.Height,s=t.getSlidingWindow(),o=r/2;if(t.isVertical())var a=s.getY(),l=a+o,h=a+s.getHeight(),d=h-o,g=0,u=o,_=e,w=_-o,c=new i.Line(t.getCtx(),g,l,e,l,"lh"),v=new i.Line(t.getCtx(),g,d,e,d,"rh"),m=new i.Line(t.getCtx(),u,0,u,a,"ltb"),P=new i.Line(t.getCtx(),u,h,u,n,"rtb"),S=new i.Line(t.getCtx(),w,a,w,h,"bb"),f=new i.Line(t.getCtx(),u,a,u,h,"tb");else l=(a=0)+o,d=(h=n)-o,u=(g=s.getX())+o,w=(_=g+s.getWidth())-o,c=new i.Line(t.getCtx(),u,a,u,h,"lh"),v=new i.Line(t.getCtx(),w,a,w,h,"rh"),m=new i.Line(t.getCtx(),0,l,g+1,l,"ltb"),P=new i.Line(t.getCtx(),_-1,l,e,l,"rtb"),S=new i.Line(t.getCtx(),g,d,_,d,"bb"),f=new i.Line(t.getCtx(),g,l,_,l,"tb");c.setPixelHinting(!0),v.setPixelHinting(!0),m.setPixelHinting(!0),P.setPixelHinting(!0),S.setPixelHinting(!0),f.setPixelHinting(!0),"none"!==t._windowBorderLeftStyle&&c.setSolidStroke(t._windowBorderLeftColor),t.addChild(c),t._leftHandle=c,"none"!==t._windowBorderRightStyle&&v.setSolidStroke(t._windowBorderRightColor),t.addChild(v),t._rightHandle=v,"none"!==t._borderTopStyle&&t._borderTopColor&&(m.setSolidStroke(t._borderTopColor),P.setSolidStroke(t._borderTopColor)),t.addChild(m),t.addChild(P),"none"!==t._windowBorderBottomStyle&&S.setSolidStroke(t._windowBorderBottomColor),t.addChild(S),"none"!==t._windowBorderTopStyle&&f.setSolidStroke(t._windowBorderTopColor),t.addChild(f)},_updateBorderAroundSlidingWindow:t=>{var i=t.getSlidingWindow(),e=r/2,n=t.getLeftHandle(),s=t.getRightHandle(),o=t.getLeftTopBar(),a=t.getRightTopBar(),l=t.getBottomBar(),h=t.getTopBar();if(t.isVertical()){if(t.isHorizontalScrollingEnabled()){var d=i.getWidth(),g=t.getSlidingWindowPosX(i),u=g+e,_=g+d-e;t.setLinePosX(n,u,_),t.setLinePosX(s,u,_),t.setLinePosX(h,u,u),t.setLinePosX(l,_,_)}if(t.isVerticalScrollingEnabled()){var w=i.getHeight(),c=t.getSlidingWindowPosY(i),v=c+e,m=c+w-e;t.setLinePosY(n,v,v),t.setLinePosY(s,m,m),t.setLinePosY(h,v,m),t.setLinePosY(l,v,m)}}else t.isHorizontalScrollingEnabled()&&(d=i.getWidth(),u=(g=t.getSlidingWindowPosX(i))+e,_=g+d-e,t.setLinePosX(n,u,u),t.setLinePosX(s,_,_),t.setLinePosX(h,u,_),t.setLinePosX(l,u,_)),t.isVerticalScrollingEnabled()&&(w=i.getHeight(),v=(c=t.getSlidingWindowPosY(i))+e,m=c+w-e,t.setLinePosY(n,v,m),t.setLinePosY(s,v,m),t.setLinePosY(h,v,v),t.setLinePosY(l,m,m));t.setLinePos(o,-1,t.getSlidingWindowPos(i)),t.setLinePos(a,t.getLinePos1(s),-1)},_updateSlidingWindow:t=>{var i=t.getSlidingWindow(),e=t.Width,n=t.Height;if(t.isHorizontalScrollingEnabled()){var s=Math.max(t.getMinimumPositionX(),L.getDatePosition(t._xMin,t._xMax,t._x1,e)),o=Math.max(t.getMinimumPositionX(),L.getDatePosition(t._xMin,t._xMax,t._x2,e)),r=Math.min(t.getMaximumPositionX(),o);t.isRTL()?t.setSlidingWindowPosX(i,e-r):t.setSlidingWindowPosX(i,s),O._setSlidingWindowWidth(t,i,r-s)}else O._setSlidingWindowWidth(t,i,e);if(t.isVerticalScrollingEnabled()){var a=Math.max(t.getMinimumPositionY(),L.getDatePosition(t._yMin,t._yMax,t._y1,n)),l=Math.max(t.getMinimumPositionY(),L.getDatePosition(t._yMin,t._yMax,t._y2,n)),h=Math.min(t.getMaximumPositionY(),l);t.setSlidingWindowPosY(i,a),O._setSlidingWindowHeight(t,i,h-a)}else O._setSlidingWindowHeight(t,i,n);O._updateBorderAroundSlidingWindow(t)},_setSlidingWindowWidth:(t,i,e)=>{if(e=Math.min(t.getMaximumWindowWidth(),Math.max(t.getMinimumWindowWidth(),e)),i.setWidth(e),t.isLeftAndRightFilterRendered()){var n=t.getSlidingWindowPosX(i)+e,s=t.getRightBackground();if(s.setX(n),s.setWidth(Math.max(0,t.Width-n)),L.supportsTouch()&&!t.isFeatureOff("zoom"))t.getRightBackgroundHandle().setX(n)}if(!t.isFeatureOff("zoom")){if(t.isHorizontalScrollingEnabled()){var o=t._windowRightHandleBackground,r=t._windowRightHandle,a=t._windowRightGrippy;r.setTranslateX(e),o.setTranslateX(e-t.getHandleSize()),a.setTranslateX(e-t.getGrippySize())}if(t.isVerticalScrollingEnabled()){var l=(i.getWidth()-36)/2;if(t._vertHandleBackgroundClass)var h=e/2;else h=l;var d=t._windowTopHandleBackground,g=t._windowTopHandle,u=t._windowTopGrippy;g.setTranslateX(l),d.setWidth(e),u.setTranslateX(h);var _=t._windowBottomHandleBackground,w=t._windowBottomHandle,c=t._windowBottomGrippy;w.setTranslateX(l),_.setWidth(e),c.setTranslateX(h)}}},_setSlidingWindowHeight:(t,i,e)=>{if(e=Math.min(t.getMaximumWindowHeight(),Math.max(t.getMinimumWindowHeight(),e)),i.setHeight(e),!t.isFeatureOff("zoom")){if(t.isHorizontalScrollingEnabled()){var n=(e-36)/2;if(t._horHandleBackgroundClass)var s=e/2;else s=n;var o=t._windowLeftHandleBackground,r=t._windowLeftHandle,a=t._windowLeftGrippy;r.setTranslateY(n),o.setHeight(e),a.setTranslateY(s);var l=t._windowRightHandleBackground,h=t._windowRightHandle,d=t._windowRightGrippy;h.setTranslateY(n),l.setHeight(e),d.setTranslateY(s)}if(t.isVerticalScrollingEnabled()){var g=t._windowBottomHandleBackground,u=t._windowBottomHandle,_=t._windowBottomGrippy;u.setTranslateY(e),g.setTranslateY(e-t.getHandleSize()),_.setTranslateY(e-t.getGrippySize())}}},_renderTimeAxisTopBar:t=>{var e=t.Width,n=t.Height;if(t.isVertical())if(t.isRTL())var s=new i.Line(t.getCtx(),t.getTimeAxisWidth(),0,t.getTimeAxisWidth(),n,"tab");else s=new i.Line(t.getCtx(),e-t.getTimeAxisWidth(),0,e-t.getTimeAxisWidth(),n,"tab");else s=t.isOverviewAbove()?new i.Line(t.getCtx(),0,t.getTimeAxisHeight(),e,t.getTimeAxisHeight(),"tab"):new i.Line(t.getCtx(),0,n-t.getTimeAxisHeight(),e,n-t.getTimeAxisHeight(),"tab");s.setSolidStroke(t._timeAxisBarColor,t._timeAxisBarOpacity),s.setPixelHinting(!0),t._timeAxisTopBar=s,t.addChild(s)},_renderLeftAndRightFilters:(t,e)=>{var n=t.Width,s=t.Height;if(t.isLeftAndRightFilterRendered()){if(t.isVertical())var o=new i.Rect(t.getCtx(),0,0,n,0,"lbg"),r=new i.Rect(t.getCtx(),0,0,n,0,"rbg");else o=new i.Rect(t.getCtx(),0,0,0,s,"lbg"),r=new i.Rect(t.getCtx(),0,0,0,s,"rbg");if(o.setSolidFill(t._leftFilterPanelColor,t._leftFilterPanelAlpha),t.addChild(o),r.setSolidFill(t._rightFilterPanelColor,t._rightFilterPanelAlpha),t.addChild(r),L.supportsTouch()&&null!=e){if(t.isVertical())var a=new i.Rect(t.getCtx(),0,0,n,e,"lbgrh"),l=new i.Rect(t.getCtx(),0,0,n,e,"rbgrh");else a=new i.Rect(t.getCtx(),0,0,e,s,"lbgrh"),l=new i.Rect(t.getCtx(),0,0,e,s,"rbgrh");a.setSolidFill(t._leftFilterPanelColor,0),t.addChild(a),l.setSolidFill(t._rightFilterPanelColor,0),t.addChild(l)}}},_renderTimeAxis:t=>{if(null!=t._ticks)for(var i=t.Width,e=t.Height,n=t.isVertical(),s=t.getOverviewSize(),r=0;r<t._ticks.length;r++){var a=t._ticks[r],l=parseInt(a.time,10);if(n)var h=t.getDateYPosition(l);else h=t.getDateXPosition(l);var d=a.label,g=0;if(r+1<t._ticks.length){var u=parseInt(t._ticks[r+1].time,10);if(n)var _=t.getDateYPosition(u);else _=t.getDateXPosition(u);g=_-h}else g=s-h;t.isHorizontalRTL()&&(h=s-h),n&&(g=i),g-=2*o,O._addTick(t,h,i,e,"tick"+r),O._addLabel(t,h,d,e,g,"label"+r,t._labelStyle)}},_addTick:(t,e,n,s,o)=>{if(t.isVertical())var r=new i.Line(t.getCtx(),0,e,n,e,o);else r=new i.Line(t.getCtx(),e,0,e,s,o);var a=new i.Stroke(t._timeIndicatorColor,1,1,!1,{dashArray:"3"});r.setStroke(a),r.setPixelHinting(!0),t.addChild(r)},_addLabel:(t,e,n,s,r,a,l)=>{if(t.isVertical()){var h=new i.OutputText(t.getCtx(),n,4,e,a);if(h.setCSSStyle(l),t.isRTL()){var d=h.getDimensions();h.setX(Math.max(4,t.Width-d.w-4))}}else{if(t.isOverviewAbove())var g=2;else g=s-t.getTimeAxisHeight()+2;var u=o;(h=new i.OutputText(t.getCtx(),n,e+u,g,a)).setCSSStyle(l),t.isHorizontalRTL()&&(d=h.getDimensions(),h.setX(e-Math.min(d.w,r)-u))}i.TextUtils.fitText(h,r,1/0,t),h._rawText=h.getUntruncatedTextString()},_parseFilledTimeRanges:t=>{if(null!=t._formattedTimeRanges)for(var i=0;i<t._formattedTimeRanges.length;i++){var e=t._formattedTimeRanges[i];O._addFilledTimeRange(t,e,t.Width,t.Height)}},_addFilledTimeRange:(t,e,n,s)=>{var o=parseInt(e.rs,10),r=parseInt(e.re,10);if(null!=o&&null!=r){var a=e.c,l=t.getOverviewSize();if(t.isVertical())h=t.getDateYPosition(o),d=t.getDateYPosition(r);else var h=t.getDateXPosition(o),d=t.getDateXPosition(r);var g,u=d-h;if(t.isHorizontalRTL()&&(h=l-h-u),t.isVertical())g=new i.Rect(t.getCtx(),0,h,n-t.getTimeAxisWidth(),u,"ftr");else{var _=t.isOverviewAbove()?t.getTimeAxisHeight():0;g=new i.Rect(t.getCtx(),h,_,u,s-t.getTimeAxisHeight(),"ftr")}null!=a&&g.setSolidFill(a,.4),g.setCursor("move"),g.setPixelHinting(!0),t.addChild(g)}},_updateReferenceLines:t=>{var e=t.Width,n=t.Height,s=function(i){return!(null==i||isNaN(i)||i<t._xMin||i>t._xMax)},o=function(i){i.setSolidStroke(t._currentTimeIndicatorColor),i.setPixelHinting(!0),t.addChild(i)};if(null!=t.Options.referenceObjects&&0!=t.Options.referenceObjects.length)if(t.isVertical()){for(var r=0;r<t.Options.referenceObjects.length;r++)if(s(t.Options.referenceObjects[r])){var a=t.getDateYPosition(t.Options.referenceObjects[r]),l=new i.Line(t.getCtx(),0,a,e,a,"referenceObjects"+r);o(l)}}else for(r=0;r<t.Options.referenceObjects.length;r++)s(t.Options.referenceObjects[r])&&(a=t.getDateXPosition(t.Options.referenceObjects[r]),t.isRTL()&&(a=e-a),o(l=new i.Line(t.getCtx(),a,0,a,n,"referenceObjects"+r)))}};class E extends i.Container{constructor(t,e,s){super(t),this.MIN_WINDOW_SIZE=10,this.DEFAULT_VERTICAL_TIMEAXIS_SIZE=40,this.DEFAULT_HORIZONTAL_TIMEAXIS_SIZE=20,this.HANDLE_PADDING_SIZE=20,this.initDefaults(),this._callback=e,this._callbackObj=s,this._lastChildIndex=6,(null!=this._callback||null!=this._callbackObj)&&(this.EventManager=new n(this,t,e,s),this.EventManager.addListeners(this),this.addEvtListener(i.TouchEvent.TOUCHSTART,this.HandleTouchStart,!1,this),this.addEvtListener(i.TouchEvent.TOUCHMOVE,this.HandleTouchMove,!1,this),this.addEvtListener(i.TouchEvent.TOUCHEND,this.HandleTouchEnd,!1,this),this.addEvtListener(i.MouseEvent.CLICK,this.HandleShapeClick,!1,this),this.addEvtListener(i.MouseEvent.MOUSEOVER,this.HandleShapeMouseOver,!1,this),this.addEvtListener(i.MouseEvent.MOUSEOUT,this.HandleShapeMouseOut,!1,this),this.addEvtListener(i.MouseEvent.CLICK,this.HandleShapeClick,!1,this))}initDefaults(){this.Defaults=new e}setViewportRange(t,i,e,n){if(null!=t&&null!=i){var s=this.getDateXPosition(t),o=this.getDateXPosition(i);if(o>s){s<this.getMinimumPositionX()&&(s=this.getMinimumPositionX()),o>this.getMaximumPositionX()&&(o=this.getMaximumPositionX());var r=Math.max(o-s,this.getMinimumWindowWidth()),a=this.getSlidingWindow();this.isRTL()?this.setSlidingWindowPosX(a,this.Width-(s+r)):this.setSlidingWindowPosX(a,s),O._setSlidingWindowWidth(this,a,r)}}if(null!=e&&null!=n){var l=this.getDateYPosition(e),h=this.getDateYPosition(n);if(h>l){l<this.getMinimumPositionY()&&(l=this.getMinimumPositionY()),h>this.getMaximumPositionY()&&(h=this.getMaximumPositionY());var d=Math.max(h-l,this.getMinimumWindowHeight());a=this.getSlidingWindow(),this.setSlidingWindowPosY(a,l),O._setSlidingWindowHeight(this,a,d)}}O._updateBorderAroundSlidingWindow(this)}isFeatureOff(t){return null!=this._featuresOff&&-1!==this._featuresOff.indexOf(t)}isAnimationOnClick(){return"off"!==this._animationOnClick}render(t,i,e){if(null!=i&&null!=e&&(this.Width=i,this.Height=e),null==t){var n=this.getSlidingWindow();if(this._xMin&&this._xMax){var s=this.getSlidingWindowPosX(n);null!=n&&0!==s&&(this._x1=L.getPositionDate(this._xMin,this._xMax,s,this.Width))}this._yMin&&this._yMax&&(s=this.getSlidingWindowPosY(n),null!=n&&0!==s&&(this._y1=L.getPositionDate(this._yMin,this._yMax,s,this.Height))),this.removeChildren()}else{this.SetOptions(t);var o=this.Parse(this.Options);this._applyParsedProperties(o)}O.renderOverview(this)}SetOptions(t){this.Options=this.Defaults.calcOptions(t)}getParser(){return new s(this)}Parse(t){return this.getParser(t).parse(t)}_applyParsedProperties(t){this._xMin=t.xMin,this._xMax=t.xMax,this._x1=t.x1,this._x2=t.x2,this._yMin=t.yMin,this._yMax=t.yMax,this._y1=t.y1,this._y2=t.y2,this._animationOnClick=t.animationOnClick,this._leftMargin=Math.max(0,t.leftMargin),this._rightMargin=Math.max(0,t.rightMargin),isNaN(this._leftMargin)&&(this._leftMargin=0),isNaN(this._rightMargin)&&(this._rightMargin=0),this._orientation=t.orientation,this._isRtl=t.isRtl,null!=t.featuresOff&&(this._featuresOff=t.featuresOff.split(" ")),null!=t.minimumWindowSize&&t.minimumWindowSize>0&&(this._minimumWindowSize=t.minimumWindowSize),this._timeAxisInfo=t.timeAxisInfo,null!=t.timeAxisInfo&&(this._ticks=this._timeAxisInfo.ticks),this._formattedTimeRanges=t.formattedTimeRanges,this._borderTopStyle=u(this.Options),this._borderTopColor=g(this.Options),this._windowBackgroundColor=_(this.Options),this._windowBackgroundAlpha=w(this.Options),this._windowBorderTopStyle=c(this.Options),this._windowBorderRightStyle=v(this.Options),this._windowBorderBottomStyle=m(this.Options),this._windowBorderLeftStyle=P(this.Options),this._windowBorderTopColor=S(this.Options),this._windowBorderRightColor=f(this.Options),this._windowBorderBottomColor=p(this.Options),this._windowBorderLeftColor=x(this.Options),this._handleTextureColor=l(this.Options),this._handleFillColor=a(this.Options),this._horHandleBackgroundClass=h(this.Options,!1),this._horHandleSize=d(this.Options,!1),this._vertHandleBackgroundClass=h(this.Options,!0),this._vertHandleSize=d(this.Options,!0),this._overviewBackgroundColor=C(this.Options),this._currentTimeIndicatorColor=M(this.Options),this._timeIndicatorColor=W(this.Options),this._timeAxisBarColor=b(this.Options),this._timeAxisBarOpacity=H(this.Options),this._leftFilterPanelColor=T(this.Options),this._leftFilterPanelAlpha=y(this.Options),this._rightFilterPanelColor=X(this.Options),this._rightFilterPanelAlpha=D(this.Options),this._labelStyle=new i.CSSStyle("font-weight:bold")}getDateXPosition(t){return Math.max(this.getMinimumPositionX(),L.getDatePosition(this._xMin,this._xMax,t,this.getOverviewWidth())+this._leftMargin)}getDateYPosition(t){return Math.max(this.getMinimumPositionY(),L.getDatePosition(this._yMin,this._yMax,t,this.getOverviewHeight()))}getXPositionDate(t){return L.getPositionDate(this._xMin,this._xMax,Math.max(this.getMinimumPositionX()-this._leftMargin,t-this._leftMargin),this.getOverviewWidth())}getYPositionDate(t){return L.getPositionDate(this._yMin,this._yMax,Math.max(this.getMinimumPositionY(),t),this.getOverviewHeight())}isRTL(){return"true"===this._isRtl}isHorizontalRTL(){return this.isRTL()&&!this.isVertical()}isVertical(){return"vertical"===this._orientation}isOverviewAbove(){return"above"===this.Options.overviewPosition}setMargins(t,i){!isNaN(t)&&null!=t&&t>0&&(this._leftMargin=t),!isNaN(i)&&null!=i&&i>0&&(this._rightMargin=i)}getOverviewSize(){return this.isVertical()?this.Height-this._leftMargin-this._rightMargin:this.Width-this._leftMargin-this._rightMargin}getOverviewWidth(){return this.Width-this._leftMargin-this._rightMargin}getOverviewHeight(){return this.Height}getMinimumPositionX(){return this._leftMargin}getMinimumPositionY(){return 0}getMaximumPositionX(){return this.Width-this._rightMargin}getMaximumPositionY(){return this.Height}getMinimumWindowWidth(){return null!=this._minWinSize?this._minWinSize:null!=this._minimumWindowSize?(this._minWinSize=L.getDatePosition(this._xMin,this._xMax,this._xMin+this._minimumWindowSize,this.getOverviewWidth()),this._minWinSize):this.MIN_WINDOW_SIZE}getMinimumWindowHeight(){return null!=this._minWinSize?this._minWinSize:null!=this._minimumWindowSize?(this._minWinSize=L.getDatePosition(this._yMin,this._yMax,this._yMin+this._minimumWindowSize,this.getOverviewHeight()),this._minWinSize):this.MIN_WINDOW_SIZE}getMaximumWindowWidth(){return this.Width}getMaximumWindowHeight(){return this.Height}getGrippySize(){return 10}getHandleStart(){return L.supportsTouch()?this.getHandleSize()/2:0}getHandleSize(){return L.supportsTouch()?30:10}isHandle(t){var i=t.getId();return"lh"===i||"rh"===i||"lhb"===i||"rhb"===i||"th"===i||"bh"===i||"thb"===i||"bhb"===i||"hgrpy"===i||"vgrpy"===i||"lbgrh"===i||"rbgrh"===i||null!=t.getParent()&&("hgrpy"===t.getParent().getId()||"vgrpy"===t.getParent().getId())}isLeftOrRightHandle(t){var i=t.getId();return"lh"===i||"rh"===i||"lhb"===i||"rhb"===i||"hgrpy"===i||"lbgrh"===i||"rbgrh"===i||null!=t.getParent()&&"hgrpy"===t.getParent().getId()}isTopOrBottomHandle(t){var i=t.getId();return"th"===i||"bh"===i||"thb"===i||"bhb"===i||"vgrpy"===i||null!=t.getParent()&&"vgrpy"===t.getParent().getId()}getTimeAxisWidth(){if(null==this._timeAxisInfo)return 0;if(null==this._timeAxisWidth){var t=parseInt(this._timeAxisInfo.width,10);!isNaN(t)&&t<this.Width?this._timeAxisWidth=t:this._timeAxisWidth=this.DEFAULT_VERTICAL_TIMEAXIS_SIZE}return this._timeAxisWidth}getTimeAxisHeight(){if(null==this._timeAxisInfo)return 0;if(null==this._timeAxisHeight){var t=parseInt(this._timeAxisInfo.height,10);!isNaN(t)&&t<this.Height?this._timeAxisHeight=t:this._timeAxisHeight=this.DEFAULT_HORIZONTAL_TIMEAXIS_SIZE}return this._timeAxisHeight}getPageX(t){return null!=t.targetTouches?t.targetTouches.length>0?t.targetTouches[0].pageX:null:t.pageX}getPageY(t){return null!=t.targetTouches?t.targetTouches.length>0?t.targetTouches[0].pageY:null:t.pageY}isBackgroundRendered(){return!0}isLeftAndRightFilterRendered(){return!1}getSlidingWindow(){return this.getChildAt(1)}getSlidingWindowWidth(){if(this.isHorizontalScrollingEnabled()){var t=Math.max(this.getMinimumPositionX(),L.getDatePosition(this._xMin,this._xMax,this._x1,this.Width));return Math.min(this.getMaximumPositionX(),Math.max(this.getMinimumPositionX(),L.getDatePosition(this._xMin,this._xMax,this._x2,this.Width)))-t}return this.Width}getSlidingWindowHeight(){if(this.isVerticalScrollingEnabled()){var t=Math.max(this.getMinimumPositionY(),L.getDatePosition(this._yMin,this._yMax,this._y1,this.Height));return Math.min(this.getMaximumPositionY(),Math.max(this.getMinimumPositionY(),L.getDatePosition(this._yMin,this._yMax,this._y2,this.Height)))-t}return this.Height}getLeftBackground(){return this.isLeftAndRightFilterRendered()?this.getChildAt(3):null}getRightBackground(){return this.isLeftAndRightFilterRendered()?this.getChildAt(4):null}getLeftBackgroundHandle(){return this.isLeftAndRightFilterRendered()&&!this.isFeatureOff("zoom")?this.getChildAt(5):null}getRightBackgroundHandle(){return this.isLeftAndRightFilterRendered()&&!this.isFeatureOff("zoom")?this.getChildAt(6):null}getLeftHandle(){return this._leftHandle}getRightHandle(){return this._rightHandle}getLeftTopBar(){var t=this._lastChildIndex-2;return this.getChildAt(this.getNumChildren()-t)}getRightTopBar(){var t=this._lastChildIndex-3;return this.getChildAt(this.getNumChildren()-t)}getBottomBar(){var t=this._lastChildIndex-4;return this.getChildAt(this.getNumChildren()-t)}getTopBar(){var t=this._lastChildIndex-5;return this.getChildAt(this.getNumChildren()-t)}setLinePos(t,i,e){this.isVertical()?(-1!==i&&t.setY1(i),-1!==e&&t.setY2(e)):(-1!==i&&t.setX1(i),-1!==e&&t.setX2(e))}setLinePosX(t,i,e){-1!==i&&t.setX1(i),-1!==e&&t.setX2(e)}setLinePosY(t,i,e){-1!==i&&t.setY1(i),-1!==e&&t.setY2(e)}getLinePos1(t){return this.isVertical()?t.getY1():t.getX1()}_findDrawable(t){var i=t.target;if(null!=i){var e=i.getId();if(null==e)return null;if("_border"===e.substr(e.length-7))return this.getChildAfter(i);if("tick"!==e.substr(0,4)&&"ltb"!==e&&"rtb"!==e&&"bb"!==e&&"tab"!==e)return i}return null}isMovable(t){return!("window"!==t.getId()&&"ftr"!==t.getId()&&"sta"!==t.getId()&&!this.isHandle(t))}setRectPos(t,i){this.isVertical()?t.setY(i):t.setX(i)}getRectPos(t){return this.isVertical()?t.getY():t.getX()}getRectSize(t){return this.isVertical()?t.getHeight():t.getWidth()}setRectSize(t,i){this.isVertical()?t.setHeight(i):t.setWidth(i)}getSlidingWindowPos(t){return this.isVertical()?t.getTranslateY():t.getTranslateX()}getSlidingWindowPosX(t){return t.getTranslateX()}getSlidingWindowPosY(t){return t.getTranslateY()}setSlidingWindowPosX(t,i){if(i=Math.max(this.getMinimumPositionX(),i),t.setTranslateX(i),this.isLeftAndRightFilterRendered()){this.getLeftBackground().setWidth(i);var e=i+this.getSlidingWindowSize(t),n=this.getRightBackground();if(n.setX(e),n.setWidth(Math.max(0,this.Width-e)),L.supportsTouch()&&!this.isFeatureOff("zoom")){var s=this.getHandleStart();this.getLeftBackgroundHandle().setX(i-s),this.getRightBackgroundHandle().setX(e)}}}setSlidingWindowPosY(t,i){i=Math.max(this.getMinimumPositionY(),i),t.setTranslateY(i)}getSlidingWindowSize(t){return this.getRectSize(t)}renderData(t,i){}animateSlidingWindow(t,e){var n=0,s=this.getSlidingWindow();if(null!=t&&t!==this.getSlidingWindowPosX(s)||null!=e&&e!==this.getSlidingWindowPosY(s)){var o=this.getLeftHandle(),r=this.getRightHandle(),a=this.getLeftTopBar(),l=this.getRightTopBar(),h=this.getBottomBar(),d=this.getTopBar(),g=!1,u=this.isAnimationOnClick()?new i.Animator(this.getCtx(),.5,0,i.Easing.linear):null;if(this.isVerticalScrollingEnabled()&&null!=e){var _=s.getTranslateY,w=s.setTranslateY,c=o.getY1,v=o.setY1,m=o.getY2,P=o.setY2,S=r.getY1,f=r.setY1,p=r.getY2,x=r.setY2,C=h.getY1,M=h.setY1,b=h.getY2,H=h.setY2,W=d.getY1,T=d.setY1,y=d.getY2,X=d.setY2,D=this.getMinimumPositionY(),O=this.getMaximumPositionY(),E=s.getHeight();e=Math.max(D,Math.min(O-E,e)),this.animateProperty(u,s,_,w,e),this.isVertical()?(this.animateProperty(u,o,c,v,e),this.animateProperty(u,o,m,P,e),this.animateProperty(u,r,S,f,e+E),this.animateProperty(u,r,p,x,e+E),this.animateProperty(u,h,C,M,e),this.animateProperty(u,d,W,T,e),this.animateProperty(u,h,b,H,e+E),this.animateProperty(u,d,y,X,e+E),this.animateProperty(u,a,a.getY2,a.setY2,e+1),this.animateProperty(u,l,l.getY1,l.setY1,e+E-1)):(this.animateProperty(u,o,c,v,e),this.animateProperty(u,o,m,P,e+E),this.animateProperty(u,r,S,f,e),this.animateProperty(u,r,p,x,e+E),this.animateProperty(u,h,C,M,e+E),this.animateProperty(u,d,W,T,e),this.animateProperty(u,h,b,H,e+E),this.animateProperty(u,d,y,X,e)),g=!0}if(this.isHorizontalScrollingEnabled()&&null!=t){var B=s.getTranslateX,Y=s.setTranslateX,R=o.getX1,A=o.setX1,k=o.getX2,I=o.setX2,F=r.getX1,z=r.setX1,U=r.getX2,N=r.setX2,V=h.getX1,G=h.setX1,j=h.getX2,Z=h.setX2,K=d.getX1,q=d.setX1,J=d.getX2,Q=d.setX2,$=this.getMinimumPositionX(),tt=this.getMaximumPositionX();n=s.getWidth(),t=Math.max($,Math.min(tt-n,t)),this.animateProperty(u,s,B,Y,t),this.animateProperty(u,o,R,A,t),this.animateProperty(u,o,k,I,t),this.animateProperty(u,r,F,z,t+n),this.animateProperty(u,r,U,N,t+n),this.isVertical()||(this.animateProperty(u,a,a.getX2,a.setX2,t+1),this.animateProperty(u,l,l.getX1,l.setX1,t+n-1)),this.animateProperty(u,h,V,G,t),this.animateProperty(u,d,K,q,t),this.animateProperty(u,h,j,Z,t+n),this.animateProperty(u,d,J,Q,t+n),g=!0}if(this.isLeftAndRightFilterRendered()){var it=this.getLeftBackground(),et=it.getWidth,nt=it.setWidth;this.animateProperty(u,it,et,nt,t);var st=Number(t)+n,ot=this.getRightBackground(),rt=ot.getWidth,at=ot.setWidth,lt=ot.getX,ht=ot.setX;if(this.animateProperty(u,ot,rt,at,this.Width-st),this.animateProperty(u,ot,lt,ht,st),L.supportsTouch()&&!this.isFeatureOff("zoom")){var dt=this.getHandleStart(),gt=this.getLeftBackgroundHandle(),ut=gt.getX,_t=gt.setX,wt=this.getRightBackgroundHandle(),ct=wt.getX,vt=wt.setX;this.animateProperty(u,gt,ut,_t,t-dt),this.animateProperty(u,wt,ct,vt,st)}g=!0}null!=u&&g&&u.play()}}animateProperty(t,e,n,s,o){null!=t?t.addProp(i.Animator.TYPE_NUMBER,e,n,s,o):s.call(e,o)}HandleShapeMouseOver(t){var e=this._findDrawable(t);if(e&&"bg"!==e.getId()&&"referenceObjects"!==e.getId())if("label"===e.getId().substr(0,5)&&(e instanceof i.OutputText||e instanceof i.BackgroundOutputText))e.isTruncated()&&this.getCtx().getTooltipManager().showDatatip(t.pageX,t.pageY,e._rawText,"#000000");else if("window"!==e.getId()&&"ftr"!==e.getId()&&"arr"!==e.getId()&&!this.isHandle(e))return e}HandleShapeMouseOut(t){null==this._moveDrawable&&this.setCursor("default");var i=this._findDrawable(t);return null==i?null:i}HandleShapeClick(t,e,n){t.stopPropagation();var s=this._findDrawable(t);if(!s||"window"===s.getId()||this.isHandle(s))return null;if("bg"===s.getId()||"label"===s.getId().substr(0,5)||"referenceObjects"===s.getId()||"lbg"===s.getId()||"rbg"===s.getId()){null==e&&(e=t.pageX),null==n&&(n=t.pageY);var o=this.getCtx().pageToStageCoords(e,n);o=this.stageToLocal(o);var r,a,l,h,d=this.getSlidingWindow();if(this.isVerticalScrollingEnabled())var g=o.y,u=this.Height,_=g-d.getHeight()/2;if(this.isHorizontalScrollingEnabled())var w=o.x,c=this.Width,v=w-d.getWidth()/2;if(this.animateSlidingWindow(v,_),null!=v){var m=d.getWidth();v=Math.max(this.getMinimumPositionX(),Math.min(v,c-m)),this.isRTL()?(r=this.getXPositionDate(c-(v+m)),a=this.getXPositionDate(c-v)):(r=this.getXPositionDate(v),a=this.getXPositionDate(v+m))}if(null!=_){var P=d.getHeight();_=Math.max(this.getMinimumPositionY(),Math.min(_,u-P)),l=this.getYPositionDate(_),h=this.getYPositionDate(_+P)}var S=i.EventFactory.newOverviewEvent("scrollTime",r,a,l,h);return this.dispatchEvent(S),null}return s}beginDragPan(t,e,n){var s=this._findDrawable(t);if(null!=s&&this.isMovable(s)){if("ftr"!==s.getId()&&"sta"!==s.getId()||(s=this.getSlidingWindow()),this._initX=e,this._initY=n,this.isHandle(s)){var o=this.getSlidingWindow();"hgrpy"!==s.getParent().getId()&&"vgrpy"!==s.getParent().getId()||(s=s.getParent());var r=s.getId();"hgrpy"!==r&&"vgrpy"!==r||(r=(s=o.getChildBefore(s)).getId()),"lh"!==r&&"rh"!==r&&"th"!==r&&"bh"!==r||(r=(s=o.getChildBefore(s)).getId()),"lbgrh"===r&&(s=o.getChildAt(0)),"rbgrh"===r&&(s=o.getChildAt(o.getNumChildren()-3)),this.isLeftOrRightHandle(s)?(this._isHorizontalResize=!0,this.isRTL()?(this._oldEndPosX=this.Width-o.getX(),this._oldStartPosX=this._oldEndPosX-o.getWidth()):(this._oldStartPosX=o.getX(),this._oldEndPosX=this._oldStartPosX+o.getWidth()),L.supportsTouch()||(s.setX(0-this.HANDLE_PADDING_SIZE),s.setWidth(2*(s.getWidth()+this.HANDLE_PADDING_SIZE)))):(this._isHorizontalResize=!1,this._oldStartPosY=o.getY(),this._oldEndPosY=this._oldStartPosY+o.getHeight(),L.supportsTouch()||(s.setY(0-this.HANDLE_PADDING_SIZE),s.setHeight(2*(s.getHeight()+this.HANDLE_PADDING_SIZE)))),this.overrideCursors(s.getCursor())}this._moveDrawable=s;var a=i.EventFactory.newOverviewEvent("dropCallback");return this.dispatchEvent(a),!0}return!1}overrideCursors(t){var i=this.getSlidingWindow();if(null!=i&&i.setCursor(t),this.isLeftAndRightFilterRendered()){var e=this.getLeftBackground(),n=this.getRightBackground();null!=e&&null!=n&&(e.setCursor(t),n.setCursor(t))}}resetCursors(){var t=this.getSlidingWindow();if(null!=t&&t.setCursor("move"),this.isLeftAndRightFilterRendered()){var i=this.getLeftBackground(),e=this.getRightBackground();null!=i&&null!=e&&(i.setCursor("default"),e.setCursor("default"))}}endDragPan(){null!=this._moveDrawable&&this._isDragPanning&&("window"===this._moveDrawable.getId()?this.handleWindowDrag("scrollEnd"):this.isHandle(this._moveDrawable)&&(this.finishHandleDrag(0,0),L.supportsTouch()||(this.isTopOrBottomHandle(this._moveDrawable)?(this._moveDrawable.setY(0),this._moveDrawable.setHeight(this.getHandleSize())):this.isLeftOrRightHandle(this._moveDrawable)&&(this._moveDrawable.setX(0),this._moveDrawable.setWidth(this.getHandleSize()))),this.resetCursors()),this._isDragPanning=!1,this._moveDrawable=null,this._initX=-1)}contDragPan(t,i,e){if(null!=this._moveDrawable&&-1!==this._initX){this._isDragPanning=!0;var n=i-this._initX,s=e-this._initY;this._initX=i,this._initY=e,"window"===this._moveDrawable.getId()?this.handleWindowDrag("scrollPos",n,s):"lh"===this._moveDrawable.getId()||"lhb"===this._moveDrawable.getId()?this.handleLeftOrRightHandleDragPositioning(t,n,!0):"rh"===this._moveDrawable.getId()||"rhb"===this._moveDrawable.getId()?this.handleLeftOrRightHandleDragPositioning(t,n,!1):"th"===this._moveDrawable.getId()||"thb"===this._moveDrawable.getId()?this.handleTopOrBottomHandleDragPositioning(t,s,!0):"bh"!==this._moveDrawable.getId()&&"bhb"!==this._moveDrawable.getId()||this.handleTopOrBottomHandleDragPositioning(t,s,!1)}}HandleTouchStart(t){var i=t.touches;this._touchStartX=i[0].pageX,this._touchStartY=i[0].pageY,2===i.length&&(t.preventDefault(),this._touchStartX2=i[1].pageX,this._touchStartY2=i[1].pageY,Math.abs(this._touchStartY-this._touchStartY2)<20?this._counter=0:(this._touchStartX=null,this._touchStartY=null,this._touchStartX2=null,this._touchStartY2=null))}HandleTouchMove(t){t.preventDefault();var i=t.touches;if(null!=this._touchStartX2&&null!=this._touchStartY2){if(this._counter<50)return void this._counter++;var e=i[1].pageX-this._touchStartX2;this.handleRightHandleDragPositioning(null,e,0),this._touchStartX2=i[1].pageX,this._counter=0}else{var n=Math.abs(this._touchStartX-i[0].pageX),s=Math.abs(this._touchStartY-i[0].pageY);(n>3||s>3)&&(this._touchStartX=null,this._touchStartY=null)}}HandleTouchEnd(t){null!=this._touchStartX2&&null!=this._touchStartY2?this.finishHandleDrag(0,0):null!=this._touchStartX&&null!=this._touchStartY&&this.HandleShapeClick(t,this._touchStartX,this._touchStartY),this._touchStartX=null,this._touchStartY=null,this._touchStartX2=null,this._touchStartY2=null}stopDragAction(){this.endDragPan()}handleWindowDrag(t,i,e){var n,s,o,r,a=this.getSlidingWindow(),l=!1,h=this.getSlidingWindowPosX(a),d=this.getSlidingWindowPosY(a),g=a.getWidth(),u=a.getHeight();if("scrollPos"===t){if(this.isHorizontalScrollingEnabled()&&0!==i){var _=this.getMinimumPositionX(),w=this.getMaximumPositionX();h+i<=_?this.setSlidingWindowPosX(a,_):h+g+i>=w?this.setSlidingWindowPosX(a,w-g):this.setSlidingWindowPosX(a,h+i);var c=this.getSlidingWindowPosX(a);c!==h&&(h=c,l=!0)}if(this.isVerticalScrollingEnabled()&&0!==e){var v=this.getMinimumPositionY(),m=this.getMaximumPositionY();d+e<=v?this.setSlidingWindowPosY(a,v):d+u+e>=m?this.setSlidingWindowPosY(a,m-u):this.setSlidingWindowPosY(a,d+e);var P=this.getSlidingWindowPosY(a);P!==d&&(d=P,l=!0)}l&&O._updateBorderAroundSlidingWindow(this)}(l||"scrollEnd"===t)&&(this.isHorizontalScrollingEnabled()&&(this.isRTL()?(n=this.getXPositionDate(this.Width-(h+g)),s=this.getXPositionDate(this.Width-h)):(n=this.getXPositionDate(h),s=this.getXPositionDate(h+g))),this.isVerticalScrollingEnabled()&&(o=this.getYPositionDate(d),r=this.getYPositionDate(d+u)),this.fireScrollEvent(t,n,s,o,r))}fireScrollEvent(t,e,n,s,o){var r,a,l,h;this.isHorizontalScrollingEnabled()&&(r=e,a=n),this.isVerticalScrollingEnabled()&&(l=s,h=o);var d=i.EventFactory.newOverviewEvent(t,r,a,l,h);this.dispatchEvent(d)}handleLeftOrRightHandleDragPositioning(t,e,n){if(0!==e){var s=this.getSlidingWindow(),o=this.getSlidingWindowPosX(s),r=s.getWidth();if(n){if(r-e<=this.getMinimumWindowWidth())return;if(o+e<=this.getMinimumPositionX())return;var a=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).x;if(a=this.stageToLocal(a),e>0&&a<=o||e<0&&a>=o)return;this.setSlidingWindowPosX(s,o+e),O._setSlidingWindowWidth(this,s,r-e)}else{if(r+e<=this.getMinimumWindowWidth())return;if(o+r+e>=this.getMaximumPositionX())return;if(a=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).x,a=this.stageToLocal(a),e>0&&a<=o+r||e<0&&a>=o+r)return;O._setSlidingWindowWidth(this,s,r+e)}if(O._updateBorderAroundSlidingWindow(this),this.isRangeChangingSupported()){var l,h;this.isRTL()?(l=this.getXPositionDate(this.Width-(this.getSlidingWindowPosX(s)+s.getWidth())),h=this.getXPositionDate(this.Width-this.getSlidingWindowPosX(s))):(l=this.getXPositionDate(this.getSlidingWindowPosX(s)),h=this.getXPositionDate(this.getSlidingWindowPosX(s)+s.getWidth()));var d=i.EventFactory.newOverviewEvent("rangeChanging",l,h);this.dispatchEvent(d)}}}handleTopOrBottomHandleDragPositioning(t,e,n){if(0!==e){var s=this.getSlidingWindow(),o=this.getSlidingWindowPosY(s),r=s.getHeight();if(n){if(r-e<=this.getMinimumWindowHeight())return;if(o+e<=this.getMinimumPositionY())return;var a=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).y;if(a=this.stageToLocal(a),e>0&&a<=o||e<0&&a>=o)return;this.setSlidingWindowPosY(s,o+e),O._setSlidingWindowHeight(this,s,r-e)}else{if(r+e<=this.getMinimumWindowHeight())return;if(o+r+e>=this.getMaximumPositionY())return;if(a=this.getCtx().pageToStageCoords(this.getPageX(t),this.getPageY(t)).y,a=this.stageToLocal(a),e>0&&a<=o+r||e<0&&a>=o+r)return;O._setSlidingWindowHeight(this,s,r+e)}if(O._updateBorderAroundSlidingWindow(this),this.isRangeChangingSupported()){var l=this.getYPositionDate(this.getSlidingWindowPosY(s)),h=this.getYPositionDate(this.getSlidingWindowPosY(s)+s.getHeight()),d=i.EventFactory.newOverviewEvent("rangeChanging",void 0,void 0,l,h);this.dispatchEvent(d)}}}isHorizontalScrollingEnabled(){return null!=this._xMin&&null!=this._xMax}isVerticalScrollingEnabled(){return null!=this._yMin&&null!=this._yMax}isRangeChangingSupported(){return!0}finishHandleDrag(t,e){var n,s=this.getSlidingWindow();if(this._isHorizontalResize){var o=this.getXPositionDate(this._oldStartPosX),r=this.getXPositionDate(this._oldEndPosX);if(this.isRTL())var a=this.getXPositionDate(this.Width-(this.getSlidingWindowPosX(s)+s.getWidth())),l=this.getXPositionDate(this.Width-this.getSlidingWindowPosX(s));else a=this.getXPositionDate(this.getSlidingWindowPosX(s)),l=this.getXPositionDate(this.getSlidingWindowPosX(s)+s.getWidth());n=i.EventFactory.newOverviewEvent("rangeChange",a,l,void 0,void 0,o,r)}else{var h=this.getYPositionDate(this._oldStartPosY),d=this.getYPositionDate(this._oldEndPosY),g=this.getYPositionDate(this.getSlidingWindowPosY(s)),u=this.getYPositionDate(this.getSlidingWindowPosY(s)+s.getHeight());n=i.EventFactory.newOverviewEvent("rangeChange",void 0,void 0,g,u,void 0,void 0,h,d)}this.dispatchEvent(n)}dispatchEvent(t){this._callback.call(this._callbackObj,t,this)}destroy(){this.EventManager&&(this.EventManager.removeListeners(this),this.EventManager.destroy(),this.EventManager=null),this.removeEvtListener(i.TouchEvent.TOUCHSTART,this.HandleTouchStart,!1,this),this.removeEvtListener(i.TouchEvent.TOUCHMOVE,this.HandleTouchMove,!1,this),this.removeEvtListener(i.TouchEvent.TOUCHEND,this.HandleTouchEnd,!1,this),this.removeEvtListener(i.MouseEvent.CLICK,this.HandleShapeClick,!1,this),this.removeEvtListener(i.MouseEvent.MOUSEOVER,this.HandleShapeMouseOver,!1,this),this.removeEvtListener(i.MouseEvent.MOUSEOUT,this.HandleShapeMouseOut,!1,this),this.removeEvtListener(i.MouseEvent.CLICK,this.HandleShapeClick,!1,this),this.removeEvtListener(i.KeyboardEvent.KEYDOWN,this.HandleKeyDown,!1,this),this.removeEvtListener(i.KeyboardEvent.KEYUP,this.HandleKeyUp,!1,this),super.destroy()}}t.Overview=E,t.OverviewParser=s,t.OverviewUtils=L,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojdvt-overview.js.map