/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["ojs/ojcore-base","ojs/ojdvt-toolkit","ojs/ojcontext","ojs/ojconfig","ojs/ojmap","ojs/ojlocaledata","ojs/ojcomponentcore","jquery","ojs/ojkeysetimpl","ojs/ojdomutils","ojs/ojattributegrouphandler","ojs/ojlogger","ojs/ojcustomelement","ojs/ojcustomelement-utils","ojs/ojmetadatautils","ojs/ojthemeutils","ojdnd"],function(e,t,n,i,o,s,r,a,l,h,d,c,_,p,u,m,f){"use strict";e=e&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e,n=n&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n,o=o&&Object.prototype.hasOwnProperty.call(o,"default")?o.default:o,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a,l=l&&Object.prototype.hasOwnProperty.call(l,"default")?l.default:l;const v=function(e,t){this._path=t,this._root=e,this._delimiter="/"};v.prototype._resolveLeafObjectAndProperty=function(e,t,n,i){for(var o={};e&&t.indexOf(n)>-1;){var s=t.substring(0,t.indexOf(n));i&&void 0===e[s]&&(e[s]={}),e=e[s],t=t.substring(t.indexOf(n)+1,t.length)}return e&&(o.object=e,o.parameter=t),o},v.prototype._resolvePath=function(e){if(void 0===this._leaf){var t=this._resolveLeafObjectAndProperty(this._root,this._path,this._delimiter,e);this._leaf=t.object,this._param=t.parameter}},v.prototype.getValue=function(){return this._resolvePath(!1),void 0===this._leaf?void 0:this._leaf[this._param]},v.prototype.setValue=function(e,t){this._resolvePath(!0),!t&&this._leaf[this._param]||(this._leaf[this._param]=e)};const y=function(e){this._styleCache={},this._context=e,this._letterSpacing=null,this._wordSpacing=null,this._fontVariantNumeric=null};y._FONT_WEIGHT="font-weight",y.styleTypes={TEXT:function(e){var t={};return e&&(e.hasClass("oj-gauge-metric-label")?(t["font-size"]=!0,t.color=!0):e.hasClass("oj-treemap-node-header")?t[y._FONT_WEIGHT]=!0:e.hasClass("oj-legend-title")&&(t[y._FONT_FAMILY]=!0)),y._buildTextCssPropertiesObject(e,t)},BACKGROUND:function(e,t,n,i){return y._buildCssBackgroundPropertiesObject(e)},ANIM_DUR:function(e){var t=e.css("animation-duration");if(t)return"ms"===t.slice(-2)?t=parseInt(t.slice(0,-2),10):"s"===t.slice(-1)&&(t=1e3*parseFloat(t.slice(0,-1))),t}},y._INHERITED_FONT_COLOR="rgb(254, 0, 254)",y._INHERITED_FONT_FAMILY="Times",y._INHERITED_FONT_SIZE="1px",y._INHERITED_FONT_WEIGHT="1",y._INHERITED_FONT_STYLE="normal",y._FONT_SIZE_BUFFER=4,y.defaultStyleProcessor=function(e,t){return e.css(t)},y._buildCssBackgroundPropertiesObject=function(e){var t={};return e.css("border-top-color")&&(t.borderColor=e.css("border-top-color")),e.css("border-width")&&e.css("border-style")&&"none"!==e.css("border-style")&&(t.borderWidth=e.css("border-width")),e.css("background-color")&&(t.backgroundColor=e.css("background-color")),t},y._buildTextCssPropertiesObject=function(e,t){var n={},i=e.css("font-family");return i&&i!==y._INHERITED_FONT_FAMILY&&(n.fontFamily=i.replace(/"/g,"'")),!(i=e.css("font-size"))||i.indexOf("px")>-1&&parseFloat(i)<y._FONT_SIZE_BUFFER||t["font-size"]||(n.fontSize=i),(i=e.css(y._FONT_WEIGHT))&&i!==y._INHERITED_FONT_WEIGHT&&!t[y._FONT_WEIGHT]&&(n.fontWeight=i),(i=e.css("color"))&&i!==y._INHERITED_FONT_COLOR&&!t.color&&(n.color=i),(i=e.css("font-style"))&&i!==y._INHERITED_FONT_STYLE&&(n.fontStyle=i),n},y.prototype.processStyles=function(e,t,n,i){var o,s=null,r=null,l=e.data("no-style-cache"),h="";for(o=0;o<n.length;o++)h=h+n[o]+" ";var d,c={},_={},p=Object.keys(i);for(o=0;o<p.length;o++){var u=i[d=p[o]];u instanceof Array||(u=[u]);var m=this._hasUncachedProperty(d,u)||l;r||s||!m||((s=a(document.createElement("div"))).css("display","none"),e.append(s),s.attr("class",h),(r=a(document.createElement("div"))).css("font-size",y._INHERITED_FONT_SIZE),r.css("color",y._INHERITED_FONT_COLOR),r.css(y._FONT_WEIGHT,y._INHERITED_FONT_WEIGHT),r.css("font-style",y._INHERITED_FONT_STYLE),s.append(r)),c[d]=u,m&&(_[d]=this._createStyleDivs(r,d,u))}if(!this._letterSpacing||!this._wordSpacing||!this._fontVariantNumeric){var f=window.getComputedStyle(e[0]);this._context.letterSpacing=f.letterSpacing,this._context.wordSpacing=f.wordSpacing,this._context.fontVariantNumeric=f.fontVariantNumeric,this._letterSpacing=f.letterSpacing,this._wordSpacing=f.wordSpacing,this._fontVariantNumeric=f.fontVariantNumeric}for(o=0;o<p.length;o++)d=p[o],this._processStyle(_[d],t,d,c[d],l);s&&s.remove()},y.prototype._createStyleDivs=function(e,t,n){this._styleCache[t]||(this._styleCache[t]={});for(var i=null,o=0;o<n.length;o++){var s=n[o].property;if(s)void 0===this._styleCache[t][s]&&(i||("oj-dvt-color-ramp"===t?i=d.ColorAttributeGroupHandler.__createAttrDiv():(i=a(document.createElement("div"))).addClass(t),e.append(i)))}return i},y.prototype._processStyle=function(e,t,n,i,o){for(var s=0;s<i.length;s++){var r=i[s],a=r.property;if(a){var l=this._styleCache[n][a];if(void 0===l&&e&&(l="oj-dvt-color-ramp"===n?d.ColorAttributeGroupHandler.__processAttrDiv(e):y._resolveStyle(e,a),o||(this._styleCache[n][a]=l)),null!=l){var h=r.path,c=new v(t,h),_=c.getValue(),p="object"==typeof _&&!Array.isArray(_);if(p&&_)for(var u=Object.keys(l),m=0;m<u.length;m++){var f=u[m];void 0===_[f]&&(_[f]=l[f])}else c.setValue(l,p)}}}},y._resolveStyle=function(e,t){var n=y.styleTypes[t],i=n?n(e):y.defaultStyleProcessor(e,t);return null==i||"string"==typeof i&&""===i.replace(/^\s+/g,"")?null:i},y.prototype._hasUncachedProperty=function(e,t){var n=this._styleCache[e];if(!n)return!0;for(var i=0;i<t.length;i++){var o=t[i].property;if(o)if(void 0===n[o])return!0}return!1},y.populateOptions=function(e,t){for(var n,i=Object.keys(t),o=0;o<i.length;o++){var s=t[i[o]];s instanceof Array||(s=[s]);for(var r=0;r<s.length;r++){var a=(n=s[r]).path,l="TEXT"===n.property||"BACKGROUND"===n.property;if(l||a.indexOf("/")>-1)l||(a=a.substring(0,a.lastIndexOf("/"))),new v(e,a).setValue({})}}},y.prototype.clearCache=function(e){this._styleCache[e]=void 0};const g=function(e,t){this._component=e,this._configMap=t,this._init()};e.Object.createSubclass(g,e.Object,"DataProviderHandler"),g.prototype._init=function(){this._dataProviderEventListeners={},this._keyDataMap={},this._fetchedData={},this._eventListeners=[]},g.prototype._fetchCollection=function(e,t,n,i,o,s){var r=this,a={data:[],keys:[]};if(s<=-1)return Promise.resolve(a);this._clientId=this._clientId||Symbol();var l={clientId:this._clientId,size:-1},h=e.fetchFirst(l)[Symbol.asyncIterator](),d=this.isTreeDataProvider(e),c=function(e){for(var s=[],l=0;l<e.value.data.length;l++){var _=t({data:e.value.data[l],key:e.value.metadata[l].key},o);s.push(_)}return Promise.all(s).then(function(e){for(var t=0;t<e.length;t++){var s=e[t].data,l=e[t].key;a.data.push(s),a.keys.push(l),r._keyDataMap[n].set(d?l.value:l,{data:s,key:l,parentKey:i,depth:o})}}).then(function(){return e.done?Promise.resolve(a):h.next().then(c)})};return h.next().then(c)},g.prototype._getDPPostProcessor=function(e,t,n,i){var o=this,s=this.isTreeDataProvider(e);i=null==i?Number.MAX_VALUE:i;var r=function(s,a){var l={value:s.data},h={value:s.key};if(a<i&&n&&n.has(h.value)){var d=e.getChildDataProvider(h.value);if(d)return o._fetchCollection(d,r,t,h.value,a+1).then(function(e){return l.children=e.data,h.children=e.keys,{data:l,key:h}})}return Promise.resolve({data:l,key:h})};return s?r:function(e){return Promise.resolve(e)}},g.prototype.fetchAllData=function(e,t,n){if(n&&this._fetchedData[t])return Promise.resolve(this._fetchedData[t]);var i=this._configMap[t];return this.clear(t,!0),this._fetchCollection(e,this._getDPPostProcessor(e,t,i.expandedKeySet,i.maxFetchDepth),t,null,0,i.maxFetchDepth).then(function(i){return n&&(this._fetchedData[t]=i,this._addDPEventListeners(e,t)),i}.bind(this))},g.prototype._getDataProviderEventHandler=function(e){var t=this,n=function(e,t,n){if(!t)return[];var i=new l(t),o=new Map,s=function(e){for(var t=0;t<e.length;t++){var r=n?e[t].value:e[t],a=i.get(r);a!==i.NOT_A_KEY&&o.set(a,t),n&&e[t].children&&s(e[t].children)}};s(e.keys);var r=[];return t.forEach(function(e){r.push(o.get(e))}),r},i=function(n){var i=t._component._GetThrottlePromise();Promise.all([n,i]).then(function(n){t._fireEvent("clearState",{dataProperty:e}),t._fetchedData[e]=n[0],t._fireEvent("dataUpdated",{data:n[0]})})};return function(o){t._fireEvent("notReady",{event:o});var s=this,r=t.isTreeDataProvider(s),a=t._keyDataMap[e];if("refresh"===o.type)i(t.fetchAllData(s,e));else if("mutate"===o.type){var h=o.detail.update,d=o.detail.remove,c=o.detail.add,_=t._fetchedData[e];if(d){var p=d.keys;if(c){var u=new l(c.keys);p=new Set([...p].filter(e=>!u.has(e)))}t._fireEvent("removeKeys",{keys:p})}var m,f=function(n,i,o,l){var h=0,d=[],c=1===o&&!l;return i.keys.forEach(function(n){var o,_=l?null:i.data[h];if(r)if(c){var p=a.get(n);p&&(p.data.value=_,o=Promise.resolve({data:p.data,key:a.get(n).key}))}else{var u={value:_},m={value:n},f=s.getChildDataProvider(n);if(f&&!l)o=t.fetchAllData(f,e).then(function(e){return u.children=e.data,m.children=e.keys,{data:u,key:m}});else o=Promise.resolve({data:u,key:m});if(!l){var v=i.parentKeys?i.parentKeys[h]:null;a.set(m.value,{data:u,key:m,parentKey:v})}}else o=Promise.resolve({data:_,key:n}),a.set(n,{data:_,key:n});d.push(o),h+=1}),Promise.all(d).then(function(e){for(var s=0;s<e.length;s++){var h,d,p,u=r?e[s].key.value:e[s].key,m=a.get(u).parentKey;if(m){var f=a.get(m);f.data.children||c||(f.data.children=[],f.key.children=[]),h=f.data.children,d=f.key.children}else h=_.data,d=_.keys;if(l)p=n[s]-s,h.splice(p,o),d.splice(p,o),t._component._getCurrentItem&&i.keys.has(t._component._getCurrentItem())&&t._component._handleRemoveCurrentItem();else{if(c)p=n[s];else p=0===n.length||null==n[s]?h.length:n[s];h.splice(p,o,e[s].data),d.splice(p,o,e[s].key)}}return _})},v=function(e){return s.fetchByKeys({keys:e}).then(function(t){var n=[];return t.results.size>0&&e.forEach(function(e){n.push(t.results.get(e).data)}),n})},y=Promise.resolve();h&&(m=h.indexes||n(_,h.keys,r),y=Array.isArray(h.data)?f(m,h,1):v(h.keys).then(function(e){var t=Object.create(h,{data:{value:e}});return f(m,t,1)})),y.then(function(){return d?(m=d.indexes||n(_,d.keys,r),f(m,d,1,!0)):Promise.resolve()}).then(function(){return c?(m=c.indexes||n(_,c.addBeforeKeys?c.addBeforeKeys:c.afterKeys,r),Array.isArray(c.data)?f(m,c,0):v(c.keys).then(function(e){var t=Object.create(c,{data:{value:e}});return f(m,t,0)})):Promise.resolve()}).then(function(){i(Promise.resolve(_))})}}},g.prototype._addDPEventListeners=function(e,t){if(!this._dataProviderEventListeners[t]){var n=this._getDataProviderEventHandler(t);e.addEventListener("mutate",n),e.addEventListener("refresh",n),this._dataProviderEventListeners[t]={dataProvider:e,listener:n}}},g.prototype.release=function(e){var t=function(e){var t=this._dataProviderEventListeners[e];if(t){var n=t.dataProvider,i=t.listener;n.removeEventListener("mutate",i),n.removeEventListener("refresh",i),this._dataProviderEventListeners[e]=null}}.bind(this);if(e)t(e),this.clear(e);else{for(var n=Object.keys(this._dataProviderEventListeners),i=0;i<n.length;i++)t(n[i]);this.clear()}},g.prototype.fetchChildrenData=function(e,t,n,i){var o=function(t,n,i){this._keyDataMap[e].get(t).data.children=n,this._keyDataMap[e].get(t).key.children=i}.bind(this),s=t.getChildDataProvider(n);if(s){var r=this._configMap[e].maxFetchDepth,a=this._keyDataMap[e].get(n).depth,l=this._getDPPostProcessor(t,e,i,r);return this._fetchCollection(s,l,e,n,a,r).then(function(e){return o(n,e.data,e.keys),e})}return Promise.resolve({data:[],keys:[]})},g.prototype.clear=function(e,t){e&&t?(this._keyDataMap[e]=this._keyDataMap[e]||new o,this._fireEvent("reset",{dataProperty:e})):e?this._fetchedData[e]=null:(this._fetchedData={},this._keyDataMap={})},g.prototype.isDataProvider=function(t){return e.DataProviderFeatureChecker.isDataProvider(t)},g.prototype.isTreeDataProvider=function(t){return e.DataProviderFeatureChecker.isTreeDataProvider(t)},g.prototype.addEventListener=function(e){this._eventListeners.push(e)},g.prototype._fireEvent=function(e,t){for(var n=0;n<this._eventListeners.length;n++)this._eventListeners[n]({type:e,detail:t})};const C=function(e,t,n){this._component=e,this._configMap=t,this._useObjectAssign=n,this._init()};e.Object.createSubclass(C,e.Object,"TemplateHandler"),C.prototype._init=function(){this._templateEnginePromise=null,this._templates=this.getTemplates(),this._templateResults={},this._templateNodeData={},this._componentResults={},this._eventListeners=[],this._queueNextEvent=!0,this._eventUpdates=[],this._templatePropertyMap={},this._propertyValidatorMap={}},C.prototype.getTemplateEngine=function(){return this._templateEnginePromise||(this._templateEnginePromise=new Promise(e=>{const t={customElement:this._component._GetCustomElement(),needsTrackableProperties:this._component._NeedsTrackableProperties};i.__getTemplateEngine(t).then(function(t){e(t)},function(e){throw new Error("Error loading template engine: "+e)})})),this._templateEnginePromise},C.prototype.getDataSet=function(e){var t=this.getTemplate(e);return t&&t.dataset},C.prototype.getTemplate=function(e){return this._templates[e]&&this._templates[e][0]},C.prototype.getDataSetBoolean=function(e,t){var n=this.getDataSet(e),i=p.AttributeUtils.attributeToPropertyName(t),o=n&&n[i];return null!=o&&p.AttributeUtils.coerceBooleanValue(this.getTemplate(e),t,o,"Boolean")},C.prototype.getTemplates=function(){return p.CustomElementUtils.getSlotMap(this._component.element[0])},C.prototype._getPropertyValidator=function(t,n){if(!t)return null;var i=this._propertyValidatorMap[n];if(i)return i;var o=e.CustomElementBridge.getMetadata(n),s=t.content?t.content.children[0]:t.childNodes[1],r={};return i=function(n,i){var a=n.join("."),l=r[a];if(!l){l=o;for(var h=0;h<n.length;h++)l=l.properties[n[h]];r[a]=l}try{u.checkEnumValues(s,a,i,l)}catch(e){throw new p.JetElementError(t,e.message)}null!=i&&e.BaseCustomElementBridge.checkType(s,a,i,l)},this._propertyValidatorMap[n]=i,i},C.prototype._processAliasedPropertyNames=function(e,t,n){var i=this._configMap[e].getAliasedPropertyNames;if(i)for(var o=i(t),s=Object.keys(o),r=0;r<s.length;r++){var a=s[r];n[o[a]]=n[a],n[a]=void 0}return n},C.prototype._getTemplateElementProperties=function(e){var t=this._templatePropertyMap[e];return t||(t=this._component.getElementPropertyNames(e),this._templatePropertyMap[e]=t),t},C.prototype.processNodeTemplate=function(t,n,i,s,r,a,l){var h=i.getAttribute("slot"),d=this._component.options.as,c=this._component.element[0],_=this._getTemplateElementProperties(s),p=this._getPropertyValidator(i,s),u=l?t:h,m=function(n){return function(i){var o=this._processAliasedPropertyNames(t,s,i),r=this._templateNodeData[u];e.CollectionUtils.copyInto(r.get(n).data,o),this._eventUpdates.push({key:a,data:o}),this._queueNextEvent&&(this._fireEvent("notReady"),this._component._GetThrottlePromise().then(function(){this._fireEvent("dataUpdated",{dataProperty:t,templateName:h,data:this._eventUpdates.slice(0)}),this._queueNextEvent=!0,this._eventUpdates=[]}.bind(this))),this._queueNextEvent=!1}.bind(this)}.bind(this),f=n.resolveProperties(c,i,s,_,r,d,p);f.subscribe(m(a));var v={data:this._processAliasedPropertyNames(t,s,f.peek()),node:f,context:r};return this._templateNodeData[u]||(this._templateNodeData[u]=new o),this._templateNodeData[u].set(a,v),v.data},C.prototype.processTemplates=function(e,t,n,i,o,s,r){if(s&&this._templateResults[e])return this._templateResults[e];var a,l,h=this._configMap[e],d=this;if(h){a=[],l=[];var _="string"==typeof h.templateName?function(){return h.templateName}:h.templateName,p="string"==typeof h.templateElementName?function(){return h.templateElementName}:h.templateElementName,u=h.resultPath,m=this._component.element[0],f=h.processChildrenData,v=h.processOptionData||function(e){return e},y=d._templateNodeData[e];if(_&&p&&u){var g,C=function(t,i,o,s,r){var a;try{s?a=d.processNodeTemplate(e,n,s,r,o,i,!0):(d._useObjectAssign?(a=Object.assign({},t),Object.defineProperties(a,{_noTemplate:{value:!0,enumerable:!1},_dvtNoClone:{value:!0,enumerable:!1}})):((a=Object.create(t))._noTemplate=!0,a._dvtNoClone=!0),y.set(i,{data:a,context:o})),a.id=i,a._itemData=t}catch(e){c.error(e)}return a},b=function(e,t,n){for(var o=e.data,s=e.keys,r=[],a=0;a<o.length;a++){var l=i?o[a].value:o[a],h=i?s[a].value:s[a],c={data:l,key:h,index:a,componentElement:m};i&&(c.parentData=t,c.parentKey=n);var v=_(o[a]),y=p(o[a]),g=d.getTemplate(v),E=C(l,h,c,g,y);if(i&&o[a].children){var D=t.slice(0);D.push(l);var P={data:o[a].children,keys:s[a].children},T=b(P,D,h);f?f(E,o[a],T):E[u]=T}r.push(E)}return r};a.push(u),o&&y.has(o)&&(g=y.get(o).context.parentData.concat(y.get(o).context.data));var E=b(t,g||[],o);l.push(v(E))}r&&(y.get(o).data[u]=l[0])}var D={paths:a,values:l};return s&&(this._templateResults[e]=D),D},C.prototype.release=function(e){var t;if(e){var n=this._configMap[e].derivedTemplates;t=n?[e].concat(n):[e]}else t=Object.keys(this._templateNodeData);for(var i=0;i<t.length;i++){var s=this._templateNodeData[t[i]];s&&(s.forEach(function(e){e.node&&e.node.dispose()}),this._templateNodeData[t[i]]=new o)}this.clear(e)},C.prototype.clear=function(e,t){if(e)for(var n,i=this._configMap[e].derivedTemplates,s=i?[e].concat(i):[e],r=0;r<s.length;r++)n=s[r],t?this._templateNodeData[n]=this._templateNodeData[n]||new o:(this._templateResults[n]=null,this._componentResults[n]=null);else this._templateResults={},this._componentResults={},this._templateNodeData={}},C.prototype.getComponentResults=function(e){return this._componentResults[e]},C.prototype.setComponentResults=function(e,t){this._componentResults[e]=t},C.prototype.addEventListener=function(e){this._eventListeners.push(e)},C.prototype._fireEvent=function(e,t){for(var n=0;n<this._eventListeners.length;n++)this._eventListeners[n]({type:e,detail:t})};const b=function(e,t,n,i,o,s){this._componentElement=e,this._getDvtComponent=t,this._getSkeletonMaskStyleClass=n,this._configureCompElemTabIndex=i,this._getOptionsCopy=o,this._isLoadingIndicatorEnabled=!1,this._translations=s,this._isBusy=!1,this._descRegionId=`_dvtLoadingDesc_${Math.floor(1e9*Math.random())}`;const r=e=>{this._isBusy&&e.stopImmediatePropagation()};e.addEventListener("keydown",r),e.addEventListener("keyup",r)};e.Object.createSubclass(b,e.Object,"LoadingIndicatorHandler"),b._SHOW_DELAY_CSS_VAR="--oj-private-core-global-loading-indicator-delay-duration",b._CONTAINER_CLASSNAME="oj-dvt-loading-container",b._SKELETON_CONTAINER_CLASSNAME="oj-dvt-skeleton-container",b._SKELETON_CLASSNAME="oj-dvt-skeleton oj-animation-skeleton",b._HIDDEN_ACCESSIBLE_CLASSNAME="oj-helper-hidden-accessible",b.prototype._getShowDelay=function(){const e=m.getCachedCSSVarValues([b._SHOW_DELAY_CSS_VAR])[0],t=h.getCSSTimeUnitAsMillis(e);return isNaN(t)?0:t},b.prototype._hideVis=function(){const e=this._getDvtComponent();e&&(e.getCtx().getSvgDocument().style.visibility="hidden")},b.prototype._showVis=function(){const e=this._getDvtComponent();e&&e.getCtx().getSvgDocument().style.removeProperty("visibility")},b.prototype._renderLoadingIndicator=function(){this._hideVis(),this._container&&this._container.remove(),this._container=document.createElement("div"),this._container.className=b._CONTAINER_CLASSNAME;const e=document.createElement("div");e.className=`${b._SKELETON_CONTAINER_CLASSNAME} ${this._getSkeletonMaskStyleClass()}`;const t=document.createElement("div");t.className=b._SKELETON_CLASSNAME,e.appendChild(t),this._container.appendChild(e),this._componentElement.appendChild(this._container)},b.prototype._removeLoadingIndicator=function(){this._container&&(this._container.remove(),this._showVis(),this._container=null)},b.prototype._renderLiveRegion=function(){this._liveRegion||(this._liveRegion=document.createElement("div"),this._liveRegion.className=b._HIDDEN_ACCESSIBLE_CLASSNAME,this._liveRegion.setAttribute("aria-live","polite"),this._componentElement.appendChild(this._liveRegion))},b.prototype._updateLiveRegion=function(e){this._liveRegion&&(this._liveRegion.textContent=e)},b.prototype._renderDescriptionRegion=function(){this._descRegion||(this._descRegion=document.createElement("div"),this._descRegion.className=b._HIDDEN_ACCESSIBLE_CLASSNAME,this._descRegion.id=this._descRegionId,this._descRegion.textContent=this._translations.stateLoading,this._componentElement.appendChild(this._descRegion))},b.prototype._removeDescriptionRegion=function(){this._descRegion&&(this._descRegion.remove(),this._descRegion=null)},b.prototype._addToDescribedBy=function(e){const t=this._componentElement.getAttribute("aria-describedby");this._componentElement.setAttribute("aria-describedby",t?[...new Set(t.split(/\s+/).concat(e))].join(" "):e)},b.prototype._removeFromDescribedBy=function(e){const t=this._componentElement.getAttribute("aria-describedby");if(t){const n=t.replace(e,"").split(/\s+/).join(" ");n?this._componentElement.setAttribute("aria-describedby",n):this._componentElement.removeAttribute("aria-describedby")}},b.prototype._setBusy=function(e){if(e||this._isBusy)if(this._isBusy=e,this._componentElement.setAttribute("aria-busy",e),e){this._renderDescriptionRegion();const e=this._getDvtComponent(),t=e?.Options;e&&!t&&(e.SetOptions(this._getOptionsCopy()),e.UpdateAriaAttributes(),e.Options=t),this._configureCompElemTabIndex(),this._addToDescribedBy(this._descRegionId),this._updateLiveRegion(this._translations.stateLoading)}else{this._removeFromDescribedBy(this._descRegionId),this._removeDescriptionRegion();const e=this._componentElement.getAttribute("aria-label");this._updateLiveRegion(e?`${e}, ${this._translations.stateLoaded}`:this._translations.stateLoaded)}},b.prototype.setEnabled=function(e){this._isLoadingIndicatorEnabled=e,e?this._renderLiveRegion():this.hide()},b.prototype.show=function(){this._isLoadingIndicatorEnabled&&!this._showTimeout&&(this._showTimeout=setTimeout(()=>{this._setBusy(!0),this._renderLoadingIndicator(),this._showTimeout=null},this._getShowDelay()))},b.prototype.hide=function(){this._showTimeout&&(clearTimeout(this._showTimeout),this._showTimeout=null),this._removeLoadingIndicator(),this._setBusy(!1)},e.__registerWidget("oj.dvtBaseComponent",a.oj.baseComponent,{options:{trackResize:"on"},_ComponentCreate:function(){this._super(),this._renderCount=0,this._numDeferredObjs=0,this._optionsCopy=null,this._dataValuePromise={},this._templateMap={},this._TemplateHandler=new C(this,this._GetSimpleDataProviderConfigs(),this._UseObjectAssignForShapedData()),this._DataProviderHandler=new g(this,this._GetSimpleDataProviderConfigs()),this._DataProviderHandler.addEventListener(this._GetDPEventHandler()),this._TemplateHandler.addEventListener(this._GetDPEventHandler()),this._LoadingIndicatorHandler=new b(this.element[0],()=>this._component,()=>this._GetLoadingSkeletonMaskStyleClass(),()=>this._configureTabIndex(),()=>t.JsonUtils.clone(this.options,null,this._GetComponentNoClonePaths()),this.options.translations),this._LoadingIndicatorHandler.setEnabled(this._IsLoadingSkeletonSupported());for(var n=this._GetComponentStyleClasses(),i=0;i<n.length;i++)this.element.addClass(n[i]);this._referenceDiv=a(document.createElement("div")),this._referenceDiv.css("visibility","hidden"),this.element.append(this._referenceDiv),t.Agent.setAgentInfo({...e.AgentUtils.getAgentInfo(),isTouchSupported:h.isTouchSupported()});var d=this.element[0].parentElement;d&&d._dvtcontext?this._context=d._dvtcontext:this._context=new t.Context(this.element[0],null,this._referenceDiv[0]);var c=Object.keys(this._GetSimpleDataProviderConfigs()),_={oj:e,KeySetImpl:l,ojMap:o,LocaleData:s,dataProviderProps:c};if(this._context.setJetProperties(_),this._context.setReadingDirection(this._GetReadingDirection()),this._context.setTooltipAttachedCallback(r.subtreeAttached),this._context.setOverlayAttachedCallback(r.subtreeAttached),this._context.setFixContextCallback(this._FixRendererContext.bind(this)),this._context.setCustomElement(this._IsCustomElement()),a(document.body).hasClass("oj-hicontrast")&&t.Agent.setHighContrast(!0),this._component=this._CreateDvtComponent(this._context,this._HandleEvent,this),this._component.setContextMenu(!!this._GetContextMenu()),t.Agent.isEnvironmentTest()){var p=this.element[0].getAttribute("data-oj-dvt-test-id");p&&p.length>0&&this._component.setId(p)}this._context.getStage().addChild(this._component),this._context.setDvtComponent(this._component),this._LoadResources(),this.options._widgetConstructor=r.__GetWidgetConstructor(this.element)},_AfterCreate:function(){this._super(),"off"!==this.options.trackResize&&this._addResizeListener(),this._ProcessOptions(),this._Render()},_SetLocaleHelpers:function(e,t){var n={createNumberConverter:function(t){return new e.IntlNumberConverter(t)},isoToDateConverter:function(e){if("string"==typeof e){var n=t.IntlConverterUtils.isoToDate(e),i=n.toJSON()?t.IntlConverterUtils.dateToLocalIso(n):e;return t.IntlConverterUtils.isoToLocalDate(i)}return e},dateToIsoWithTimeZoneConverter:function(e){if(e instanceof Date){var n=-1*e.getTimezoneOffset(),i=n>=0?"+":"-",o=Math.floor(Math.abs(n)/60),s=Math.abs(n)%60,r=i+(2!==o.toString().length?"0"+o:o)+":"+(2!==s.toString().length?s+"0":s);return t.IntlConverterUtils.dateToLocalIso(e)+r}return e}};this._context.setLocaleHelpers(n)},refresh:function(){this._super(),this._styleProcessor=null,this._context.setReadingDirection(this._GetReadingDirection()),this._Render()},getNodeBySubId:function(e){var t=this._component&&this._component.getAutomation?this._component.getAutomation():null;if(t){var n=this._ConvertLocatorToSubId(e);return t.getDomElementForSubId(n)}return null},getSubIdByNode:function(e){var t=this._component&&this._component.getAutomation?this._component.getAutomation():null;if(t){var n=t.getSubIdForDomElement(e);return n?this._ConvertSubIdToLocator(n):null}return null},_ConvertLocatorToSubId:function(e){return null},_ConvertSubIdToLocator:function(e){return null},_ProcessStyles:function(e){this._styleProcessor=this._styleProcessor?this._styleProcessor:new y(this._component.getCtx()),this._styleProcessor.processStyles(this.element,e,this._GetComponentStyleClasses(),this._GetChildStyleClasses())},_GetComponentStyleClasses:function(){return["oj-dvtbase"]},_GetChildStyleClasses:function(){var e={"oj-dvt-no-data-message":{path:"_statusMessageStyle",property:"TEXT"}};return e},_GetEventTypes:function(){return[]},_VerifyConnectedForSetup:function(){return!0},_ReleaseResources:function(){this._super(),this._renderNeeded=!0,this._context.hideTooltips(),this._context.releaseTooltipResources(),this._removeResizeListener(),this._CleanAllTemplates(),this._MakeReady(),this._DataProviderHandler.release(),this._TemplateHandler.release(),this._LoadingIndicatorHandler.hide(),this._dataValuePromise={}},_destroy:function(){var e=this.element[0].parentElement;e&&e._dvtcontext&&(e._dvtcontext=null),this._component.destroy&&this._component.destroy(),this._component=null,this.element.children().remove(),this.element.removeAttr("role").removeAttr("tabIndex").removeAttr("aria-activedescendant");for(var t=this._GetComponentStyleClasses(),n=0;n<t.length;n++)this.element.removeClass(t[n]);this._super(),this._context.destroy(),this._context=null},_setOptions:function(e,t){this._superApply(arguments),this._OptionChangeHandler(e);var n=this.options.trackResize;if("off"===n&&this._resizeListener?this._removeResizeListener():"off"===n||this._resizeListener||this._addResizeListener(),this._ProcessOptions(),!this._bUserDrivenChange){var i=this._numDeferredObjs>0;if(!i){var o=this._GetEventTypes(),s=this._GetOptimizedOptions();a.each(e,function(e){if(o.indexOf(e)<0&&s.indexOf(e)<0)return i=!0,!1})}i?this._Render():this._UpdateNoRenderOptions(e)}},_GetOptimizedOptions:function(){return["highlightedCategories","selection","dataCursorPosition","scrollPosition"]},_UpdateNoRenderOptions:function(e){void 0!==e.highlightedCategories&&this._component.highlight(e.highlightedCategories),void 0!==e.selection&&this._component.select(e.selection),void 0!==e.dataCursorPosition&&this._component.positionDataCursor&&this._component.positionDataCursor(e.dataCursorPosition),void 0!==e.scrollPosition&&this._component.scroll(e.scrollPosition)},_CreateDvtComponent:function(e,t,n){return null},_HandleEvent:function(e){var t=e.type;"selection"===t?this._UserOptionChange("selection",e.selection):"categoryHide"===t||"categoryShow"===t?this._UserOptionChange("hiddenCategories",e.hiddenCategories):"categoryHighlight"===t?this._UserOptionChange("highlightedCategories",e.categories):"optionChange"===t?this._UserOptionChange(e.key,e.value,e.optionMetadata):"touchHoldRelease"===t&&this._GetContextMenu()?this._OpenContextMenu(a.Event(e.nativeEvent),"touch"):"dvtRender"===t?this._Render():"ready"===t&&0===this._numDeferredObjs&&this._MakeReady()},_BeforeResizeRender:function(){},_addResizeListener:function(){if(!this._resizeListener)if(this._resizeListener=this._handleResize.bind(this),this._IsFlowingLayoutSupported())h.addResizeListener(this.element[0],this._resizeListener,250);else{const e=this.element[0],t=e.hasAttribute("data-oj-resize-notify");this._resizeObserver=new ResizeObserver(n=>{const i=n[0].borderBoxSize,o=i?(i[0]||i).inlineSize:e.offsetWidth,s=i?(i[0]||i).blockSize:e.offsetHeight;this._resizeListener(o,s),t&&e.dispatchEvent(new Event("oj-resize"))}),this._resizeObserver.observe(e,{box:"border-box"})}},_removeResizeListener:function(){this._resizeObserver?(this._resizeObserver.disconnect(),this._resizeObserver=null):this._resizeListener&&h.removeResizeListener(this.element[0],this._resizeListener),this._resizeListener=null},_handleResize:function(e,t){var n=this.element.width(),i=this.element.height();(null==this._width||null==this._height||Math.abs(n-this._width)+Math.abs(i-this._height)>=5)&&this._Render(!0)},_LoadResources:function(){},_Render:function(e){this._context.hideTooltips(),this._NotReady(),!this._context.isReadyToRender()||this._renderNeeded&&e?(this._renderNeeded=!0,this._MakeReady()):(this._width=this._IsFlowingLayoutSupported()?null:this.element.width(),this._height=this._IsFlowingLayoutSupported()?null:this.element.height(),this._context.setDefaultFontFamily(this._referenceDiv.css("font-family")),this._context.setDefaultFontSize(this._referenceDiv.css("font-size")),this.options._width=this._width,this.options._height=this._height,this.options._locale=t.Agent.isEnvironmentTest()&&this.options._locale?this.options._locale:i.getLocale(),this._IsDraggable()&&this.element.attr("draggable",!0),y.populateOptions(this.options,this._GetChildStyleClasses()),e?0===this._numDeferredObjs&&(this._renderCount+=1,this._RenderComponent(this._optionsCopy,e)):(this._renderCount+=1,this._resolveDeferredDataItems()&&this._RenderComponent(this._optionsCopy)),this._renderNeeded=!1)},_IsDraggable:function(){return!!this.options.dnd},_NotifyShown:function(){this._super(),this._notifyShownAttached()},_NotifyAttached:function(){this._super(),this._notifyShownAttached()},_NotifyDetached:function(){this._super(),this._notifyHiddenDetached()},_NotifyHidden:function(){this._super(),this._notifyHiddenDetached()},_notifyShownAttached:function(){this._renderNeeded&&this._Render()},_notifyHiddenDetached:function(){this._context.hideTooltips(),this._MakeReady()},_UserOptionChange:function(e,t,n){this._bUserDrivenChange=!0,this.option(e,t,{_context:{writeback:!0,optionMetadata:n,internalSet:!0,skipEvent:"_"===e.charAt(0)}}),this._bUserDrivenChange=!1},_NotifyContextMenuGesture:function(e,t,n){if("touch"!==n)if("keyboard"===n){var i=this.element[0].getBoundingClientRect(),o=this._component.getKeyboardFocus()?this._component.getKeyboardFocus().getBoundingClientRect():null,s=o?"left+"+(o.left+.5*o.width-i.left)+" top+"+(o.top+.5*o.height-i.top):"center";this._OpenContextMenu(t,n,{position:{at:s}})}else this._super(e,t,n)},_GetDvtComponent:function(e){var t=r.__GetWidgetConstructor(e)("instance");return t?t._component:null},_GetStringFromIndexPath:function(e){for(var t="",n=0;n<e.length;n++)t+="["+e[n]+"]";return t},_GetIndexPath:function(e){for(var t=[],n=0;e.indexOf("[",n)>0;){var i=e.indexOf("[",n)+1,o=e.indexOf("]",n);t.push(Number(e.substring(i,o))),n=o+1}return t},_GetFirstIndex:function(e){return Number(this._GetFirstBracketedString(e))},_GetFirstBracketedString:function(e){var t=e.indexOf("[")+1,n=e.indexOf("]");return e.substring(t,n)},_GetComponentDeferredDataPaths:function(){return{}},_GetComponentNoClonePaths:function(){if(!this._noClonePaths){this._noClonePaths={};var e=this,t=this._GetComponentDeferredDataPaths().root;t&&t.forEach(function(t){e._noClonePaths[t]=!0})}return this._noClonePaths},_resolveDocumentFonts:function(){var e=document.fonts;if(e&&"loading"===e.status){this._numDeferredObjs+=1;var t=this._renderCount;e.ready.then(function(){this._renderDeferredData(t,null,[])}.bind(this))}},_resolveDeferredDataItems:function(){this._optionsCopy=t.JsonUtils.clone(this.options,null,this._GetComponentNoClonePaths()),this._ProcessStyles(this._optionsCopy),this._numDeferredObjs=0,this._FixCustomRenderers(this._optionsCopy),this._resolveDocumentFonts(),this._LoadingIndicatorHandler.show();for(var e=this,n=this._GetComponentDeferredDataPaths(),i=Object.keys(n),o=0;o<i.length;o++){var s=i[o];n[s].forEach(function(t){if("root"===s)e._resolveDeferredDataItem.bind(e)(e.options,e._optionsCopy,t);else{var n=e.options[s];if(n&&n instanceof Array)for(var i=0;i<n.length;i++)e._resolveDeferredDataItem.bind(e)(n[i],e._optionsCopy[s][i],t)}})}return 0===this._numDeferredObjs},_resolveDeferredDataItem:function(e,t,n){var i=new v(e,n),o=i.getValue(),s=this;if(o instanceof Function?o=Promise.resolve(o(this._GetDataContext(e))):this._IsCustomElement()&&Array.isArray(o)&&(o=Promise.resolve(o),i.setValue(o,!0)),o&&this._DataProviderHandler.isDataProvider(o)){var r=this._DataProviderHandler.isTreeDataProvider(o);o=s._dataValuePromise[n]||new Promise(function(e){var t=s._TemplateHandler.getTemplateEngine(),i=s._DataProviderHandler.fetchAllData(o,n,!0);Promise.all([t,i]).then(function(t){if(o===s._dataValuePromise[n]){var i=t[0],a=t[1],l=s._ProcessTemplates(n,a,i,r,null,!0);s._dataValuePromise[n]=null,e(l)}},function(){s._dataValuePromise[n]=null})}),s._dataValuePromise[n]=o}if(o instanceof Promise){var a=this._renderCount;o.then(function(e){var i=[n],o=[e];e.paths&&(i=e.paths,o=e.values),s._renderDeferredData(a,t,i,o)},function(){s._renderDeferredData(a,t,[n],[[]])}),this._numDeferredObjs+=1}},_renderDeferredData:function(e,t,n,i){if(this._context&&e===this._renderCount){this._numDeferredObjs-=1;for(var o=0;o<n.length;o++)new v(t,n[o]).setValue(i[o],!0);0===this._numDeferredObjs&&(this._RenderComponent(this._optionsCopy),this._optionsCopy=null)}},_ClearDataProviderState:function(e){this._DataProviderHandler.clear(e),this._TemplateHandler.release(e),this._dataValuePromise[e]=null,this._LoadingIndicatorHandler.setEnabled(this._IsLoadingSkeletonSupported())},_OptionChangeHandler:function(e){for(var t=Object.keys(this._GetSimpleDataProviderConfigs()),n=0;n<t.length;n++){var i=t[n];Object.prototype.hasOwnProperty.call(e,i)&&this._ClearDataProviderState(i)}},_IsLoadingSkeletonSupported:function(){return!1},_GetLoadingSkeletonMaskStyleClass:function(){return""},getElementPropertyNames:function(t){var n=e.CustomElementBridge.getMetadata(t).properties,i=Object.keys(n).filter(function(e){return!n[e]._eventListener}),o=new Set;return i.forEach(function(e){o.add(e)}),o},_ProcessTemplates:function(e,t,n,i,o,s,r){return this._TemplateHandler.processTemplates(e,t,n,i,o,s,r)},_GetSimpleDataProviderConfigs:function(){return{}},_UseObjectAssignForShapedData:function(){return!1},_GetDPEventHandler:function(){return function(e){"notReady"===e.type?this._NotReady():"dataUpdated"===e.type?this._Render():"clearState"===e.type?this._ClearDataProviderState(e.detail.dataProperty):"reset"===e.type?this._TemplateHandler.clear(e.detail.dataProperty,!0):"removeKeys"===e.type&&this._RemoveKeys(e.detail.keys)}.bind(this)},_RemoveKeys:function(e){var t,n,i=this.options.selection,o=new l(e);if(i&&i.length>0){for(var s=(n=i.slice(0)).length-1;s>=0;s--)o.has(n[s])&&(t=!0,n.splice(s,1));t&&this._UserOptionChange("selection",n)}},_getFetchDataHandler:function(e){var t=this._GetSimpleDataProviderConfigs()[e].resultPath;return function(n,i,o,s){var r=this._DataProviderHandler.fetchChildrenData(e,n,s,i),a=this._TemplateHandler.getTemplateEngine();return Promise.all([r,a]).then(function(n){var i=this._ProcessTemplates(e,{data:n[0].data,keys:n[0].keys},n[1],!0,s,!1,!0).values[0];return o&&(o[t]=i),i}.bind(this))}.bind(this)},_configureTabIndex:function(){this.element.attr("role")?this.element[0].hasAttribute("tabindex")||this.element.attr("tabindex",0):this.element.attr("tabindex",null)},_RenderComponent:function(e,t){if(this._context.isReadyToRender()){this._CleanAllTemplates(t);var n=this._IsFlowingLayoutSupported()&&this._resizeListener;n&&this._removeResizeListener(),t&&this._BeforeResizeRender(),this._component.render(t?null:e,this._width,this._height),n&&this._addResizeListener(),this._LoadingIndicatorHandler.hide(),this._LoadingIndicatorHandler.setEnabled(!1),this._configureTabIndex()}else this._renderNeeded=!0,this._MakeReady()},_GetDataContext:function(e){return{}},_IsFlowingLayoutSupported:function(){return!1},whenReady:function(){if(this._ready)return Promise.resolve(!0);if(!this._promise){var e=this;this._promise=new Promise(function(t){e._promiseResolve=t})}return this._promise},_NotReady:function(){if(this._ready=!1,0===this._numDeferredObjs&&!this._readyResolveFunc){var e=n.getContext(this.element[0]).getBusyContext(),t={description:"The component identified by '"+this.element.attr("id")+"' is being loaded."};this._readyResolveFunc=e.addBusyState(t)}},_MakeReady:function(){this._promiseResolve&&(this._promiseResolve(!0),this._promiseResolve=null),this._ready=!0,this._promise=null,this._readyResolveFunc&&(this._readyResolveFunc(),this._readyResolveFunc=null)},_ProcessOptions:function(){t.Agent.isEnvironmentTest()&&(this.options=Object.assign(this.options,this.element[0].__dvtToolkit));var e=this.options.tooltip;e&&e._renderer&&(this.options.tooltip={renderer:this._GetTemplateRenderer(e._renderer,"tooltip")})},_WrapCustomElementRenderer:function(e){var t=this;return e?function(n){n._dvtcontext=t._context;var i=e(n);if(n._templateName&&n._templateCleanup&&(t._AddTemplate(n),"tooltipTemplate"===n._templateName)){const e=t._cleanTooltipTemplate();Object.defineProperty(n,"_tooltipTemplateCleanup",{value:()=>e(n._templateCleanup),enumerable:!1})}if(i&&!0!==i.preventDefault&&i.insert){var o=i.insert;return o.classList&&o.classList.contains("oj-dvtbase")?t._GetDvtComponent(o):o}return null}:null},_FixCustomRenderers:function(e){if(this._IsCustomElement())for(var t=this._GetComponentRendererOptions(),n=0;n<t.length;n++){var i=t[n].path,o=t[n].slot,s=this._TemplateHandler.getTemplates();if(o&&s[o]&&s[o][0])this._ProcessInlineTemplateRenderer(e,i,s[o][0],o);else{var r=new v(e,i),a=r.getValue();a&&r.setValue(this._WrapCustomElementRenderer(a),!0)}}},_GetComponentRendererOptions:function(){return[{path:"tooltip/renderer",slot:"tooltipTemplate"}]},_GetTemplateRenderer:function(e,t){var n=this;return function(i){var o=document.createElement("div");o.style.display="none",e({parentElement:o,context:i});var s=o.children[0];return s?(n._AddTemplate({_templateName:t,_templateCleanup:function(){a(o).remove()}}),o.removeChild(s),a(o).remove(),s):null}},_GetTemplateDataRenderer:function(e,t){var n=this;return function(i){var o=document.createElement("div");o.style.display="none",o._dvtcontext=n._context,n.element.append(o),e({parentElement:o,data:i.data});var s=o.children[0];return s?(n._AddTemplate({_templateName:t,_templateCleanup:function(){a(o).remove()}}),"http://www.w3.org/2000/svg"===s.namespaceURI?(o.removeChild(s),a(o).remove(),s):n._GetDvtComponent(s)):null}},_WrapInlineTemplateRenderer:function(e,t,n){return e},_ProcessInlineTemplateRenderer:function(e,t,n,i){var o=this._renderCount;this._numDeferredObjs+=1,this._TemplateHandler.getTemplateEngine().then(function(s){var r=function(e){return this._TemplateRenderer(e,s,n,i)}.bind(this);r=this._WrapInlineTemplateRenderer(r,i,t),this._renderDeferredData(o,e,[t],[this._WrapCustomElementRenderer(r)])}.bind(this))},_TemplateRenderer:function(e,t,n,i){var o=t.execute(this.element[0],n,e);return o&&o.length>0?(Object.defineProperty(e,"_templateCleanup",{value:()=>{o.forEach(e=>{t.clean(e,this.element[0])})},enumerable:!1}),Object.defineProperty(e,"_templateName",{value:i,enumerable:!1}),{insert:o}):{preventDefault:!0}},_CleanAllTemplates:function(e){for(var t=Object.keys(this._templateMap),n=0;n<t.length;n++){var i=t[n];this._CleanTemplate(i)}},_CleanTemplate:function(e){if(this._templateMap[e]){for(var t=this._templateMap[e].length,n=0;n<t;n++)this._templateMap[e][n]();this._templateMap[e]=[]}},_cleanTooltipTemplate:function(){return e=>{const t=this._templateMap.tooltipTemplate,n=t.findIndex(t=>t===e);-1!==n&&(t[n](),t.splice(n,1))}},_AddTemplate:function(e){var t=e._templateName;this._templateMap[t]||(this._templateMap[t]=[]),this._templateMap[t].push(e._templateCleanup)},_CompareOptionValues:function(t,n,i){switch(t){case"hiddenCategories":case"highlightedCategories":case"selection":return e.Object.compareValues(n,i);default:return this._super(t,n,i)}}},!0),e._registerLegacyNamespaceProp("AttributeGroupHandler",d.AttributeGroupHandler),e._registerLegacyNamespaceProp("ColorAttributeGroupHandler",d.ColorAttributeGroupHandler),e._registerLegacyNamespaceProp("ShapeAttributeGroupHandler",d.ShapeAttributeGroupHandler);const E={_SHAPE_REGEXP:/\d/,_SHAPE_ENUMS:{circle:!0,ellipse:!0,square:!0,rectangle:!0,diamond:!0,triangleUp:!0,triangleDown:!0,plus:!0,human:!0,star:!0},shapeParseFunction:function(e,t){var n=t||E._SHAPE_ENUMS;return function(t,i,o,s){if(e[i]){if(E._SHAPE_REGEXP.test(t))return t;if(n[t])return t;throw new Error("Found: '"+t+"'. Expected one of the following: "+Object.keys(n).toString())}return s(t)}}};return E});
//# sourceMappingURL=ojdvt-base.js.map