/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojdomutils"],function(t,e){"use strict";const r=oj;class i{static get DrawerLayoutStyleSurrogate(){return`${this.stringOjDrawer}${this.charDash}layout${this.charDash}${this.stringSurrogate}`}static get DrawerPopupStyleSurrogate(){return`${this.stringOjDrawer}${this.charDash}popup${this.charDash}${this.stringSurrogate}`}static styleDisplayMode(t){return`${this.stringOjDrawer}${this.charDash}${t}`}static get styleOpened(){return`${this.stringOjDrawer}${this.charDash}${this.stringOpened}`}static get styleFixedInViewport(){return`${this.stringOjDrawer}${this.charDash}fixed-in-viewport`}static get styleDrawerHidden(){return`${this.stringOjDrawer}${this.charDash}hidden`}static get clippingAreaSelector(){return`${this.stringOjDrawer}${this.charDash}${this.stringClippingArea}`}static get styleStartDrawer(){return`${this.stringOjDrawer}${this.charDash}${this.stringStart}`}static get styleEndDrawer(){return`${this.stringOjDrawer}${this.charDash}${this.stringEnd}`}static get styleBottomDrawer(){return`${this.stringOjDrawer}${this.charDash}${this.stringBottom}`}static get middleSectionSelector(){return`${this.stringOjDrawer}${this.charDash}${this.stringMiddleSection}`}static get mainContentSelector(){return`${this.stringOjDrawer}${this.charDash}${this.stringMainContent}`}static get styleReflow(){return`${this.stringOjDrawer}${this.charDash}${this.stringReflow}`}static get styleOverlay(){return`${this.stringOjDrawer}${this.charDash}${this.stringOverlay}`}}i.displayTypeChangeThreshold=1024,i.fullWidthDrawerChangeThreshold=600,i.fullHeightDrawerChangeThreshold=600,i.charDash="-",i.charSpace=" ",i.stringOjDrawer="oj-drawer",i.stringStart="start",i.stringEnd="end",i.stringTop="top",i.stringBottom="bottom",i.stringMiddleSection="layout-middle-section",i.stringMainContent="layout-main-content",i.stringClippingArea="clipping-area",i.stringStyleClassDisableOverflow="oj-drawer-disable-body-overflow",i.stringSurrogate="surrogate",i.stringOpened="opened",i.stringClosed="closed",i.stringClosedWithEsc="ClosedWithEsc",i.stringShouldChangeDisplayMode="ShouldChangeDisplayMode",i.stringStateToChangeTo="StateToChangeTo",i.stringPrevState="PrevState",i.stringReflow="reflow",i.stringOverlay="overlay",i.stringFullOverlay="full-overlay",i.stringDisplay="Display",i.stringResize="resize",i.stringLeft="left",i.stringRight="right",i.stringOpen="open",i.stringClose="close",i.stringSlideIn="slideIn",i.stringSlideOut="slideOut",i.stringWidth="width",i.stringHeight="height",i.animationDuration=300,i.keys={ESC:"Escape",TAB:"Tab"};class s{static capitalizeFirstChar(t){return t.charAt(0).toUpperCase()+t.slice(1)}static disableBodyOverflow(){document.body.classList.add(i.stringStyleClassDisableOverflow)}static enableBodyOverflow(){document.body.classList.remove(i.stringStyleClassDisableOverflow)}static getElement(t){return document.querySelector(t)}static getElementHeight(t){return Math.round(t.offsetHeight)}static getElementWidth(t){return Math.round(t.getBoundingClientRect().width)}static getAutofocusFocusables(t){return Array.from(t.querySelectorAll('[autofocus]:not([tabindex="-1"]):not([disabled]):not([hidden])')).filter(t=>!this.isHidden(t))}static getFocusables(t){const e=["button","[href]","input","select","textarea","[tabindex]","video"],r=e.length;let i="";for(let t=0;t<r;t++){const s=`${e[t]}:not([tabindex="-1"]):not([disabled]):not([hidden])`;i+=t<r-1?`${s}, `:`${s}`}return Array.from(t.querySelectorAll(i)).filter(t=>!this.isHidden(t))}static isHidden(t){if(null===t.offsetParent)return!0;if(r.AgentUtils.getAgentInfo().browser===r.AgentUtils.BROWSER.FIREFOX&&t.offsetParent===document.body)return!0;return"hidden"===window.getComputedStyle(t).visibility}static isFocusable(t){return!(!t||!t.parentElement)&&s.getFocusables(t.parentElement).some(e=>e===t)}static isObjectEmpty(t){return"object"!=typeof t||0===Object.keys(t).length&&t.constructor===Object}static isRTL(){return"rtl"===e.getReadingDirection()}static getAnimationOptions(t,e){let r;switch(e){case i.stringStart:r=t===i.stringSlideIn?this.isRTL()?i.stringLeft:i.stringRight:t===i.stringSlideOut?this.isRTL()?i.stringRight:i.stringLeft:i.stringWidth;break;case i.stringEnd:r=t===i.stringSlideIn?this.isRTL()?i.stringRight:i.stringLeft:t===i.stringSlideOut?this.isRTL()?i.stringLeft:i.stringRight:i.stringWidth;break;case i.stringBottom:r=t===i.stringSlideIn?i.stringTop:t===i.stringSlideOut?i.stringBottom:i.stringHeight}return{direction:r,duration:`${i.animationDuration}ms`}}static getCommonStyleClasses(t){return{[i.styleStartDrawer]:t===i.stringStart,[i.styleEndDrawer]:t===i.stringEnd,[i.styleBottomDrawer]:t===i.stringBottom}}static getStyleClassesMapAsString(t){let e="";for(let r in t)t[r]&&(e+=e?i.charSpace+r:r);return e}static getViewportWidth(){return r.AgentUtils.getAgentInfo().os===r.AgentUtils.OS.IOS?document.documentElement.clientWidth:window.innerWidth}static getViewportHeight(){return r.AgentUtils.getAgentInfo().os===r.AgentUtils.OS.IOS?document.documentElement.clientHeight:window.innerHeight}static moveFocusToElementOrNearestAncestor(t){if(s.isFocusable(t))t.focus();else{let e=t.parentElement;for(;e&&"HTML"!==e.nodeName&&!s.isFocusable(e);)e=e.parentElement;e&&e.focus()}}static wrapDrawerWithClippingArea(t,e){const r=$(t).wrap(function(){const t=document.createElement("div");return t.setAttribute("id",i.clippingAreaSelector),t.style.overflow="hidden",t.style.position="absolute",$(t)}).parent()[0];r.style.setProperty("height",s.getElementHeight(t)+"px"),r.style.setProperty("width",s.getElementWidth(t)+"px"),$(r).position(e),t.style.setProperty("position","static")}static unwrapDrawerClippingArea(t){t&&(t.style.removeProperty("position"),$(t).unwrap())}}t.DrawerConstants=i,t.DrawerUtils=s,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojdrawerutils.js.map