/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["require","touchr","ojs/ojdatasource-common","ojs/ojdatacollection-utils","ojs/ojinputnumber","ojs/ojmenu","ojs/ojmenuselectmany","ojs/ojdialog","ojs/ojbutton","ojdnd","ojs/ojcore-base","@oracle/oraclejet-preact/hooks/UNSAFE_useFormVariantContext","ojs/ojcomponentcore","ojs/ojcontext","ojs/ojdatacollection-common","ojs/ojdomutils","ojs/ojconfig","ojs/ojcustomelement-utils","ojs/ojkeyboardfocus-utils","jquery","ojs/ojlogger","ojs/ojthemeutils","ojs/ojtranslationbundleutils"],function(e,t,i,s,n,o,r,l,a,h,d,m,c,u,_,p,g,f,C,y,E,v,w){"use strict";var b;d=d&&Object.prototype.hasOwnProperty.call(d,"default")?d.default:d,u=u&&Object.prototype.hasOwnProperty.call(u,"default")?u.default:u,y=y&&Object.prototype.hasOwnProperty.call(y,"default")?y.default:y,(b={properties:{bandingInterval:{type:"object",properties:{column:{type:"number",value:0},row:{type:"number",value:0}}},cell:{type:"object",properties:{alignment:{type:"object",properties:{horizontal:{type:"function|string",value:"auto"},vertical:{type:"function|string",value:"auto"}}},className:{type:"function|string"},editable:{type:"function|string",enumValues:["disable","enable"],value:"enable"},renderer:{type:"function"},style:{type:"function|string"}}},currentCell:{type:"object",writeback:!0},data:{type:"DataGridProvider",extension:{webelement:{exceptionStatus:[{type:"unsupported",since:"13.0.0",description:"Data sets from a DataProvider cannot be sent to WebDriverJS; use ViewModels or page variables instead."}]}}},dataTransferOptions:{type:"object",properties:{copy:{type:"string",enumValues:["disable","enable"],value:"disable"},cut:{type:"string",enumValues:["disable","enable"],value:"disable"},fill:{type:"string",enumValues:["disable","enable"],value:"disable"},headerLabelCut:{type:"string",enumValues:["disable","enable"],value:"disable"},paste:{type:"string",enumValues:["disable","enable"],value:"disable"}}},dnd:{type:"object",properties:{drag:{type:"object",properties:{columnEndLabels:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}},columnLabels:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}},columns:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}},rowEndLabels:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}},rowLabels:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}},rows:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},drag:{type:"function"},dragEnd:{type:"function"},dragStart:{type:"function"}}}}},drop:{type:"object",properties:{columnEndLabels:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},columnLabels:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},columns:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},rowEndLabels:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},rowLabels:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}},rows:{type:"object",properties:{dataTypes:{type:"string|Array<string>"},dragEnter:{type:"function"},dragLeave:{type:"function"},dragOver:{type:"function"},drop:{type:"function"}}}}},reorder:{type:"object",properties:{row:{type:"string",enumValues:["disable","enable"],value:"disable"}}}}},editMode:{type:"string",writeback:!0,enumValues:["cellEdit","cellNavigation","none"],value:"none"},frozenColumnCount:{type:"number",writeback:!0,value:0},frozenRowCount:{type:"number",writeback:!0,value:0},gridlines:{type:"object",properties:{horizontal:{type:"string",enumValues:["hidden","visible"],value:"visible"},vertical:{type:"string",enumValues:["hidden","visible"],value:"visible"}}},header:{type:"object",properties:{column:{type:"object",properties:{alignment:{type:"object",properties:{horizontal:{type:"function|string",value:"auto"},vertical:{type:"function|string",value:"auto"}}},className:{type:"function|string"},filterable:{type:"function|string",enumValues:["auto","disable"],value:"disable"},freezable:{type:"string",enumValues:["disable","enable"],value:"disable"},hidable:{type:"string",value:"disable"},label:{type:"object",properties:{alignment:{type:"object",properties:{horizontal:{type:"function|string",value:"auto"},vertical:{type:"function|string",value:"auto"}}},className:{type:"function|string"},renderer:{type:"function"},sortable:{type:"function|string",enumValues:["auto","disable"],value:"disable"},style:{type:"function|string"}}},renderer:{type:"function"},resizable:{type:"object",properties:{height:{type:"string",enumValues:["disable","enable"],value:"disable"},width:{type:"string|function",enumValues:["disable","enable"],value:"disable"}}},sortable:{type:"function|string",enumValues:["auto","disable","enable"],value:"auto"},style:{type:"function|string"}}},columnEnd:{type:"object",properties:{alignment:{type:"object",properties:{horizontal:{type:"function|string",value:"auto"},vertical:{type:"function|string",value:"auto"}}},className:{type:"function|string"},label:{type:"object",properties:{alignment:{type:"object",properties:{horizontal:{type:"function|string",value:"auto"},vertical:{type:"function|string",value:"auto"}}},className:{type:"function|string"},renderer:{type:"function"},sortable:{type:"function|string",enumValues:["auto","disable"],value:"disable"},style:{type:"function|string"}}},renderer:{type:"function"},resizable:{type:"object",properties:{height:{type:"string",enumValues:["disable","enable"],value:"disable"},width:{type:"string|function",enumValues:["disable","enable"],value:"disable"}}},style:{type:"function|string"}}},row:{type:"object",properties:{alignment:{type:"object",properties:{horizontal:{type:"function|string",value:"auto"},vertical:{type:"function|string",value:"auto"}}},className:{type:"function|string"},freezable:{type:"string",enumValues:["disable","enable"],value:"disable"},hidable:{type:"string",value:"disable"},label:{type:"object",properties:{alignment:{type:"object",properties:{horizontal:{type:"function|string",value:"auto"},vertical:{type:"function|string",value:"auto"}}},className:{type:"function|string"},renderer:{type:"function"},sortable:{type:"function|string",enumValues:["auto","disable"],value:"disable"},style:{type:"function|string"}}},renderer:{type:"function"},resizable:{type:"object",properties:{height:{type:"string|function",enumValues:["disable","enable"],value:"disable"},width:{type:"string",enumValues:["disable","enable"],value:"disable"}}},sortable:{type:"function|string",enumValues:["auto","disable","enable"],value:"auto"},style:{type:"function|string"}}},rowEnd:{type:"object",properties:{alignment:{type:"object",properties:{horizontal:{type:"function|string",value:"auto"},vertical:{type:"function|string",value:"auto"}}},className:{type:"function|string"},label:{type:"object",properties:{alignment:{type:"object",properties:{horizontal:{type:"function|string",value:"auto"},vertical:{type:"function|string",value:"auto"}}},className:{type:"function|string"},renderer:{type:"function"},sortable:{type:"function|string",enumValues:["auto","disable"],value:"disable"},style:{type:"function|string"}}},renderer:{type:"function"},resizable:{type:"object",properties:{height:{type:"string|function",enumValues:["disable","enable"],value:"disable"},width:{type:"string",enumValues:["disable","enable"],value:"disable"}}},style:{type:"function|string"}}}}},hiddenColumns:{type:"object",writeback:!0},hiddenRows:{type:"object",writeback:!0},scrollPolicy:{type:"string",enumValues:["auto","loadMoreOnScroll","scroll"],value:"auto"},scrollPolicyOptions:{type:"object",properties:{maxColumnCount:{type:"number",value:500},maxRowCount:{type:"number",value:500}}},scrollPosition:{type:"object",writeback:!0,value:{x:0,y:0},properties:{columnIndex:{type:"number"},columnKey:{type:"any"},offsetX:{type:"number"},offsetY:{type:"number"},rowIndex:{type:"number"},rowKey:{type:"any"},x:{type:"number"},y:{type:"number"}}},scrollToKey:{type:"string",enumValues:["always","auto","capability","never"],value:"auto"},selection:{type:"Array<Object>",writeback:!0,value:[]},selectionMode:{type:"object",properties:{cell:{type:"string",enumValues:["multiple","none","single"],value:"none"},row:{type:"string",enumValues:["multiple","none","single"],value:"none"}}},translations:{type:"object",value:{},properties:{accessibleActionableMode:{type:"string"},accessibleCollapsed:{type:"string"},accessibleColumnContext:{type:"string"},accessibleColumnEndHeaderContext:{type:"string"},accessibleColumnEndHeaderLabelContext:{type:"string"},accessibleColumnHeaderContext:{type:"string"},accessibleColumnHeaderLabelContext:{type:"string"},accessibleColumnHierarchicalFull:{type:"string"},accessibleColumnHierarchicalPartial:{type:"string"},accessibleColumnHierarchicalUnknown:{type:"string"},accessibleColumnSelected:{type:"string"},accessibleColumnSpanContext:{type:"string"},accessibleContainsControls:{type:"string"},accessibleExpanded:{type:"string"},accessibleFirstColumn:{type:"string"},accessibleFirstRow:{type:"string"},accessibleLastColumn:{type:"string"},accessibleLastRow:{type:"string"},accessibleLevelContext:{type:"string"},accessibleLevelHierarchicalContext:{type:"string"},accessibleMultiCellSelected:{type:"string"},accessibleNavigationMode:{type:"string"},accessibleRangeSelectModeOff:{type:"string"},accessibleRangeSelectModeOn:{type:"string"},accessibleRowCollapsed:{type:"string"},accessibleRowContext:{type:"string"},accessibleRowEndHeaderContext:{type:"string"},accessibleRowEndHeaderLabelContext:{type:"string"},accessibleRowExpanded:{type:"string"},accessibleRowHeaderContext:{type:"string"},accessibleRowHeaderLabelContext:{type:"string"},accessibleRowHierarchicalFull:{type:"string"},accessibleRowHierarchicalPartial:{type:"string"},accessibleRowHierarchicalUnknown:{type:"string"},accessibleRowSelected:{type:"string"},accessibleRowSpanContext:{type:"string"},accessibleSelectionAffordanceBottom:{type:"string"},accessibleSelectionAffordanceTop:{type:"string"},accessibleSortAscending:{type:"string"},accessibleSortDescending:{type:"string"},accessibleSortable:{type:"string"},accessibleStateSelected:{type:"string"},accessibleSummaryEstimate:{type:"string"},accessibleSummaryExact:{type:"string"},accessibleSummaryExpanded:{type:"string"},collapsedText:{type:"string"},columnWidth:{type:"string"},expandedText:{type:"string"},labelCopyCells:{type:"string"},labelCut:{type:"string"},labelCutCells:{type:"string"},labelDisableNonContiguous:{type:"string"},labelEnableNonContiguous:{type:"string"},labelFillCells:{type:"string"},labelFilter:{type:"string"},labelFilterCol:{type:"string"},labelFreezeCol:{type:"string"},labelFreezeRow:{type:"string"},labelHideColumn:{type:"string"},labelHideRow:{type:"string"},labelPaste:{type:"string"},labelPasteCells:{type:"string"},labelResize:{type:"string"},labelResizeColumn:{type:"string"},labelResizeDialogApply:{type:"string"},labelResizeDialogCancel:{type:"string"},labelResizeDialogSubmit:{type:"string"},labelResizeFitToContent:{type:"string"},labelResizeHeight:{type:"string"},labelResizeRow:{type:"string"},labelResizeWidth:{type:"string"},labelSelectMultiple:{type:"string"},labelSortAsc:{type:"string"},labelSortCol:{type:"string"},labelSortColAsc:{type:"string"},labelSortColDsc:{type:"string"},labelSortDsc:{type:"string"},labelSortRow:{type:"string"},labelSortRowAsc:{type:"string"},labelSortRowDsc:{type:"string"},labelUnfreezeCol:{type:"string"},labelUnfreezeRow:{type:"string"},labelUnhideColumn:{type:"string"},labelUnhideRow:{type:"string"},msgFetchingData:{type:"string"},msgNoData:{type:"string"},msgReadOnly:{type:"string"},resizeColumnDialog:{type:"string"},resizeRowDialog:{type:"string"},rowHeight:{type:"string"},tooltipRequired:{type:"string"}}}},methods:{getContextByNode:{},getProperty:{},refresh:{},setProperties:{},setProperty:{},getNodeBySubId:{},getSubIdByNode:{}},events:{ojBeforeCurrentCell:{},ojBeforeEdit:{},ojBeforeEditEnd:{},ojCellResize:{},ojCollapseRequest:{},ojCopyRequest:{},ojCutRequest:{},ojExpandRequest:{},ojFillRequest:{},ojFilterRequest:{},ojHeaderLabelCutRequest:{},ojPasteRequest:{},ojResize:{},ojScroll:{},ojSort:{},ojSortLabelRequest:{},ojSortRequest:{}},extension:{}}).extension._WIDGET_NAME="ojDataGrid",b.extension._BINDING={provide:new Map([[m.FormVariantContext,"embedded"]])},d.CustomElementBridge.register("oj-data-grid",{metadata:d.CollectionUtils.mergeDeep(b,{properties:{userAssistanceDensity:{binding:{provide:[{name:"containerUserAssistanceDensity",default:"compact"},{name:"userAssistanceDensity",default:"compact"}]}}}})});const H=function(e,t,i,s){this.rtlMode=e,this.translationFunction=t,this.defaultOptions=i,this.widgetName=s,this.styles={},this.styles.datagrid="oj-datagrid",this.styles.cell="oj-datagrid-cell",this.styles.banded="oj-datagrid-banded",this.styles.row="oj-datagrid-row",this.styles.databody="oj-datagrid-databody",this.styles.topcorner="oj-datagrid-top-corner",this.styles.bottomcorner="oj-datagrid-bottom-corner",this.styles.rowheaderspacer="oj-datagrid-row-header-spacer",this.styles.colheaderspacer="oj-datagrid-column-header-spacer",this.styles.status="oj-datagrid-status",this.styles.loadingicon="oj-icon oj-datagrid-loading-icon",this.styles.emptytext="oj-datagrid-empty-text",this.styles.header="oj-datagrid-header",this.styles.endheader="oj-datagrid-end-header",this.styles.groupingcontainer="oj-datagrid-header-grouping",this.styles.headercell="oj-datagrid-header-cell",this.styles.rowheader="oj-datagrid-row-header",this.styles.colheader="oj-datagrid-column-header",this.styles.colheadercell="oj-datagrid-column-header-cell",this.styles.rowheadercell="oj-datagrid-row-header-cell",this.styles.endheadercell="oj-datagrid-end-header-cell",this.styles.rowendheader="oj-datagrid-row-end-header",this.styles.colendheader="oj-datagrid-column-end-header",this.styles.colendheadercell="oj-datagrid-column-end-header-cell",this.styles.rowendheadercell="oj-datagrid-row-end-header-cell",this.styles.headerlabel="oj-datagrid-header-label",this.styles.rowheaderlabel="oj-datagrid-row-header-label",this.styles.columnheaderlabel="oj-datagrid-column-header-label",this.styles.rowendheaderlabel="oj-datagrid-row-end-header-label",this.styles.columnendheaderlabel="oj-datagrid-column-end-header-label",this.styles["scroller-mobile"]="oj-datagrid-scroller-touch",this.styles.scroller="oj-datagrid-scroller",this.styles.scrollers="oj-datagrid-scrollers",this.styles.scrollbarForce="oj-scrollbar-force",this.styles.focus="oj-focus",this.styles.hover="oj-hover",this.styles.active="oj-active",this.styles.selected="oj-selected",this.styles.topSelected="oj-datagrid-selected-top",this.styles.bottomSelected="oj-datagrid-selected-bottom",this.styles.startSelected="oj-datagrid-selected-start",this.styles.endSelected="oj-datagrid-selected-end",this.styles.topEdit="oj-datagrid-cell-edit-top",this.styles.bottomEdit="oj-datagrid-cell-edit-bottom",this.styles.startEdit="oj-datagrid-cell-edit-start",this.styles.endEdit="oj-datagrid-cell-edit-end",this.styles.topEditInvalid="oj-datagrid-cell-edit-top-invalid",this.styles.bottomEditInvalid="oj-datagrid-cell-edit-bottom-invalid",this.styles.startEditInvalid="oj-datagrid-cell-edit-start-invalid",this.styles.endEditInvalid="oj-datagrid-cell-edit-end-invalid",this.styles.topFloodfill="oj-datagrid-floodfill-top",this.styles.bottomFloodfill="oj-datagrid-floodfill-bottom",this.styles.startFloodfill="oj-datagrid-floodfill-start",this.styles.endFloodfill="oj-datagrid-floodfill-end",this.styles.topResized="oj-datagrid-resized-top",this.styles.bottomResized="oj-datagrid-resized-bottom",this.styles.endResized="oj-datagrid-resized-end",this.styles.startResized="oj-datagrid-resized-start",this.styles.disabled="oj-disabled",this.styles.enabled="oj-enabled",this.styles.default="oj-default",this.styles.sortIcon="oj-datagrid-sort-icon",this.styles.sortascending="oj-datagrid-sort-ascending-icon",this.styles.sortdescending="oj-datagrid-sort-descending-icon",this.styles.sortdefault="oj-datagrid-sort-default-icon",this.styles.icon="oj-component-icon",this.styles.clickableicon="oj-clickable-icon-nocontext",this.styles.info="oj-helper-hidden-accessible",this.styles.rowexpander="oj-rowexpander",this.styles.cut="oj-datagrid-cut",this.styles.selectaffordance="oj-datagrid-touch-selection-affordance",this.styles.selectaffordancetopcornerbounded="oj-datagrid-touch-selection-affordance-top-corner-bounded",this.styles.selectaffordancebottomcornerbounded="oj-datagrid-touch-selection-affordance-bottom-corner-bounded",this.styles.selectaffordancetoprow="oj-datagrid-touch-selection-affordance-top-row",this.styles.selectaffordancebottomrow="oj-datagrid-touch-selection-affordance-bottom-row",this.styles.selectaffordancetopcolumn="oj-datagrid-touch-selection-affordance-top-column",this.styles.selectaffordancebottomcolumn="oj-datagrid-touch-selection-affordance-bottom-column",this.styles.floodfillaffordance="oj-datagrid-floodfill-affordance",this.styles.toucharea="oj-datagrid-touch-area",this.styles.readOnly="oj-read-only",this.styles.editable="oj-datagrid-editable",this.styles.cellEdit="oj-datagrid-cell-edit",this.styles.draggable="oj-draggable",this.styles.drag="oj-drag",this.styles.drop="oj-drop",this.styles.activedrop="oj-active-drop",this.styles.validdrop="oj-valid-drop",this.styles.invaliddrop="oj-invalid-drop",this.styles.formcontrol="oj-form-control-inherit",this.styles.borderHorizontalNone="oj-datagrid-border-horizontal-none",this.styles.borderVerticalNone="oj-datagrid-border-vertical-none",this.styles.borderHorizontalSmall="oj-datagrid-small-content-border-horizontal",this.styles.borderVerticalSmall="oj-datagrid-small-content-border-vertical",this.styles.offsetOutline="oj-datagrid-focus-offset",this.styles.depth="oj-datagrid-depth-",this.styles.popupHeader="oj-datagrid-popup-header",this.styles.popupContent="oj-datagrid-popup-content",this.styles.popupFooter="oj-datagrid-popup-footer",this.styles.dialogTitle="oj-dialog-title",this.styles.resizeDialog="oj-datagrid-resize-dialog",this.styles.headerAllSelected="oj-selected",this.styles.headerPartialSelected="oj-partial-selected",this.styles.disclosureContainer="oj-datagrid-disclosure-icon-container",this.styles.disclosureIcon="oj-datagrid-disclosure-icon",this.styles.expanded="oj-datagrid-expanded-icon",this.styles.collapsed="oj-datagrid-collapsed-icon",this.styles.spacer="oj-datagrid-tree-spacer",this.styles.hierarchicalTree="oj-datagrid-hierarchical-tree",this.styles.hierarchicalGroup="oj-datagrid-hierarchical-group",this.styles.iconContainer="oj-datagrid-icon-container",this.styles.requiredIcon="oj-datagrid-required-icon",this.styles.noDataContainer="oj-datagrid-no-data-container",this.styles.draggableItem="oj-datagrid-draggable",this.styles.dragSourceOpaque="drag-source-opaque",this.styles.rowDropTargetLine="oj-datagrid-row-drop-target-line",this.styles.colDropTargetLine="oj-datagrid-col-drop-target-line",this.styles.dragging="oj-datagrid-drag-active",this.styles.dropTarget="oj-datagrid-drop-target",this.styles.disabledElement="oj-datagrid-disabled-element",this.styles.databodyFrozenCol="oj-datagrid-databody-frozen-column",this.styles.databodyFrozenRow="oj-datagrid-databody-frozen-row",this.styles.databodyFrozenCorner="oj-datagrid-databody-frozen-corner",this.styles.colHeaderFrozen="oj-datagrid-column-header-frozen",this.styles.rowHeaderFrozen="oj-datagrid-row-header-frozen",this.styles.colEndHeaderFrozen="oj-datagrid-column-end-header-frozen",this.styles.rowEndHeaderFrozen="oj-datagrid-row-end-header-frozen",this.styles.rowFrozenIndicator="oj-datagrid-row-frozen-indicator",this.styles.colFrozenIndicator="oj-datagrid-col-frozen-indicator",this.styles.frozenHeader="oj-datagrid-header-frozen",this.styles.frozenCell="oj-datagrid-cell-frozen",this.styles.skeletonContainer="oj-datagrid-skeleton-container",this.styles.skeletonCell="oj-datagrid-skeleton-cell",this.styles.skeleton="oj-datagrid-skeleton",this.styles.skeletonAnimation="oj-animation-skeleton",this.styles.colHiddenIndicator="oj-datagrid-col-hidden-indicator",this.styles.rowHiddenIndicator="oj-datagrid-row-hidden-indicator",this.styles.colHeaderHiddenIndicator="oj-datagrid-col-header-hidden-indicator",this.styles.rowHeaderHiddenIndicator="oj-datagrid-row-header-hidden-indicator",this.styles.filterIcon="oj-datagrid-filter-icon",this.styles.filterable="oj-datagrid-filterable-icon",this.styles.filtered="oj-datagrid-filtered-icon",this.styles.headerCellContent="oj-datagrid-header-cell-content",this.styles.headerLabelCellContent="oj-datagrid-header-label-cell-content",this.styles.iconHidden="oj-datagrid-icon-hidden",this.styles.validationError="oj-datagrid-cell-validation-error",this.commands={},this.commands.sortCol="oj-datagrid-sortCol",this.commands.sortColAsc="oj-datagrid-sortColAsc",this.commands.sortColDsc="oj-datagrid-sortColDsc",this.commands.sortRow="oj-datagrid-sortRow",this.commands.sortRowAsc="oj-datagrid-sortRowAsc",this.commands.sortRowDsc="oj-datagrid-sortRowDsc",this.commands.resize="oj-datagrid-resize",this.commands.resizeWidth="oj-datagrid-resizeWidth",this.commands.resizeHeight="oj-datagrid-resizeHeight",this.commands.resizeFitToContent="oj-datagrid-resizeFitToContent",this.commands.cut="oj-datagrid-cut",this.commands.paste="oj-datagrid-paste",this.commands.cutCells="oj-datagrid-cutCells",this.commands.copyCells="oj-datagrid-copyCells",this.commands.pasteCells="oj-datagrid-pasteCells",this.commands.autoFill="oj-datagrid-fillCells",this.commands.discontiguousSelection="oj-datagrid-discontiguousSelection",this.commands.freezeCol="oj-datagrid-freezeCol",this.commands.freezeRow="oj-datagrid-freezeRow",this.commands.unfreezeCol="oj-datagrid-unfreezeCol",this.commands.unfreezeRow="oj-datagrid-unfreezeRow",this.commands.hideCol="oj-datagrid-hideCol",this.commands.unhideCol="oj-datagrid-unhideCol",this.commands.hideRow="oj-datagrid-hideRow",this.commands.unhideRow="oj-datagrid-unhideRow",this.commands.filterCol="oj-datagrid-filterCol",this.attributes={},this.attributes.busyContext=u._OJ_CONTEXT_ATTRIBUTE,this.attributes.context="data-oj-cellContext",this.attributes.resizable="data-oj-resizable",this.attributes.sortable="data-oj-sortable",this.attributes.sortDir="data-oj-sortdir",this.attributes.expander="data-oj-expander",this.attributes.expanderIndex="data-oj-expander-index",this.attributes.container=c._OJ_CONTAINER_ATTR,this.attributes.extent="data-oj-extent",this.attributes.start="data-oj-start",this.attributes.depth="data-oj-depth",this.attributes.level="data-oj-level",this.attributes.metadata="data-oj-metaData",this.attributes.hiddenIndicatorIndex="data-oj-hiddenIndicatorIndex",this.attributes.filterable="data-oj-filterable",this.attributes.readOnly="data-oj-readOnly"};d._registerLegacyNamespaceProp("DataGridResources",H),H.prototype.setRTLMode=function(e){this.rtlMode=e},H.prototype.isRTLMode=function(){return"rtl"===this.rtlMode},H.prototype.getTranslatedText=function(e,t){return this.translationFunction(e,t)},H.prototype.getDefaultOption=function(e){return this.defaultOptions[e]},H.prototype.getMappedStyle=function(e){return null!=e?this.styles[e]:null},H.prototype.getMappedCommand=function(e){return null!=e?this.commands[e]:null},H.prototype.getMappedAttribute=function(e){return null!=e?this.attributes[e]:null};const x=function(e){this.dataprovider=e,this.pendingHeaderCallback={},e.options&&e.options.implicitSort&&(this.currentSortCriteria=e.options.implicitSort),this.sortUpdated=!1;var t=this.dataprovider.getCapability("fetchByOffset");this.fetchByOffset=null!=t&&"randomAccess"===t.implementation,this._registerEventListeners(),x.superclass.constructor.call(this)};function S(e,t,i,s){this.indexes=e,this.data=i,this.metadata=t,this.columns=s}function R(e,t,i){this.response=e,this.results=e.results,this.cellRanges=t,this.columns=i,this._setBounds(e,t,i)}function I(e,t,i,s){this.start=e,this.end=t,this.headers=i,this.sortCriteria=s}d.Object.createSubclass(x,d.DataGridDataSource,"DataProviderDataGridDataSource"),x.prototype._registerEventListeners=function(){this._mutationListener=this._handleDataProviderMutationEvent.bind(this),this._refreshListener=this._handleDataProviderRefreshEvent.bind(this),this.dataprovider.addEventListener("mutate",this._mutationListener),this.dataprovider.addEventListener("refresh",this._refreshListener)},x.prototype._handleDataProviderMutationEvent=function(e){var t,i=e.detail.add;if(null!=i){var s={indexes:[],keys:[]},n=[],o=[],r=[];for(t=0;t<i.data.length;t++)s.source=this,s.operation="insert",s.keys.push({row:i.metadata[t].key,column:null}),s.indexes.push({row:i.indexes[t],column:-1}),r.push(i.indexes[t]),n.push(i.data[t]),o.push(i.metadata[t]),t!==i.data.length-1&&i.indexes[t+1]===i.indexes[t]+1||(s.result=new S(r,o,n,this.columns),this.handleEvent("change",s),(s={}).indexes=[],s.keys=[],n=[],o=[],r=[])}var l=e.detail.remove;if(null!=l){var a={source:this,operation:"delete",keys:[],indexes:[]};for(t=0;t<l.data.length;t++)a.keys.push({row:l.metadata[t].key,column:null}),a.indexes.push({row:l.indexes[t],column:-1});this.handleEvent("change",a)}var h=e.detail.update;if(null!=h)for(t=0;t<h.data.length;t++){var d={source:this,operation:"update",keys:{row:h.metadata[t].key,column:null},indexes:{row:h.indexes[t],column:-1}};d.result=new S([h.indexes[t]],[h.metadata[t]],[h.data[t]],this.columns),this.handleEvent("change",d)}},S.prototype.getData=function(e){var t=this,i={};return Object.defineProperty(i,"data",{enumerable:!0,get:function(){return t.data[e.row-t.getStart("row")][t.columns[e.column]]},set:function(i){t.data[e.row-t.getStart("row")][t.columns[e.column]]=i}}),i},S.prototype.getMetadata=function(e){var t=this,i=t.metadata[e.row-t.getStart("row")];return i.keys={row:i.key,column:t.columns[e.column]},i},S.prototype.getStart=function(e){return"row"===e?this.indexes[0]:0},S.prototype.getCount=function(e){return"row"===e?this.data.length:"column"===e?this.columns.length:0},S.prototype.getExtent=function(){return{row:{extent:1,more:{before:!1,after:!1}},column:{extent:1,more:{before:!1,after:!1}}}},x.prototype._handleDataProviderRefreshEvent=function(){this._asyncIterator=null,this.handleEvent("change",{operation:"refresh"})},x.prototype.fetchHeaders=function(e,t,i){if(null!=t){var s=e.axis,n={headerRange:e,callbacks:t,callbackObjects:i};this.pendingHeaderCallback[s]=n}},x.prototype._processPendingHeaderCallbacks=function(e){var t=this.pendingHeaderCallback[e];if(null!=t){var i=t.headerRange,s=t.callbacks,n=t.callbackObjects;this._handleHeaderFetchSuccess(i,s,n),this.pendingHeaderCallback[e]=null}},x.prototype._handleHeaderFetchSuccess=function(e,t,i){var s,n=e.axis,o=e.start,r=e.count;"column"===n&&null!=this.columns?s=new I(o,Math.min(this.columns.length,o+r),this.columns,this.currentSortCriteria):s=null;null!=t&&t.success&&t.success.call(i.success,s,e,null)},R.prototype._setBounds=function(e,t,i){for(var s=0;s<t.length;s+=1){var n=t[s];"row"===n.axis?(this.rowStart=e.fetchParameters.offset?e.fetchParameters.offset:n.start,this.rowEnd=this.rowStart+e.results.length-1):"column"===n.axis&&(this.colStart=n.start,this.colEnd=Math.min(this.colStart+n.count-1,this.colStart+i.length-1))}},R.prototype.getData=function(e){var t=this,i={};return Object.defineProperty(i,"data",{enumerable:!0,get:function(){return t.results[e.row-t.rowStart].data[t.columns[e.column]]},set:function(i){t.results[e.row-t.rowStart].data[t.columns[e.column]]=i}}),i},R.prototype.getMetadata=function(e){var t=this.results[e.row-this.rowStart].metadata;return t.keys={row:this.results[e.row-this.rowStart].metadata.key,column:this.columns[e.column]},t},R.prototype.getCount=function(e){return"row"===e?this.rowEnd-this.rowStart+1:"column"===e?this.colEnd-this.colStart+1:0},R.prototype.getExtent=function(){return{row:{extent:1,more:{before:!1,after:!1}},column:{extent:1,more:{before:!1,after:!1}}}},x.prototype.setUpColumns=function(e){if(null==this.columns||0===this.columns.length){var t=[];if(e.results.length)for(var i=Object.keys(e.results[0].data),s=0;s<i.length;s++)t.push(i[s]);this.columns=t}},x.prototype.getRangeInfo=function(e){for(var t={},i=0;i<e.length;i+=1){var s=e[i];"row"===s.axis?(t.rowStart=s.start,t.rowEnd=t.rowStart+s.count-1):"column"===s.axis&&(t.colStart=s.start,t.colEnd=t.colStart+s.count-1)}return t},x.prototype._createResults=function(e){e.results=[];for(var t=0;t<e.value.data.length;t++){var i={data:e.value.data[t],metadata:e.value.metadata[t]};e.results.push(i)}},x.prototype.handleFetchResult=function(e,t,i,s){var n=s[0];n.results||(this._createResults(n),n.fetchParameters=n.value.fetchParameters),this.setUpColumns(n),this._processPendingHeaderCallbacks("column"),this._processPendingHeaderCallbacks("row");var o=new R(n,e,this.columns);if(null!=t&&null!=t.success){var r=i?i.success:null;t.success.call(r,o,e)}},x.prototype.fetchCells=function(e,t,i){var s=this;this.getCount("row");var n=s.getRangeInfo(e),o=n.rowEnd-n.rowStart+1;if(s.fetchByOffset){var r=n.rowStart;s._fetchPromise=s.dataprovider.fetchByOffset({size:o,offset:r,sortCriteria:s.currentSortCriteria})}else(null==s._asyncIterator||this.sortUpdated)&&(s._clientId=s._clientId||Symbol(),s._asyncIterator=s.dataprovider.fetchFirst({clientId:s._clientId,size:o,sortCriteria:s.currentSortCriteria})[Symbol.asyncIterator]()),s._fetchPromise=s._asyncIterator.next();this.sortUpdated=!1,Promise.all([s._fetchPromise,s._getCountPromise]).then(s.handleFetchResult.bind(s,e,t,i))},x.prototype.getCapability=function(e){if("sort"===e){var t=this.dataprovider.getCapability(e).attributes;return"multiple"===t||"single"===t?"column":t}return"none"},x.prototype.getCount=function(e){var t=this;if("row"===e){if(void 0!==t.totalRowCount)return t.totalRowCount;t._getCountPromise=this.dataprovider.getTotalSize(),t._getCountPromise.then(function(e){t.totalRowCount=e})}else if("column"===e&&null!=this.columns)return this.columns.length;return-1},x.prototype.getCountPrecision=function(){return"estimate"},x.prototype.indexes=function(){return{row:-1,column:-1}},x.prototype.keys=function(){return{row:null,column:null}},x.prototype.move=function(){return!1},x.prototype.moveOK=function(){return"invalid"},x.prototype.sort=function(e,t,i){this.sortUpdated=!0,this.currentSortCriteria=[{attribute:e.key,direction:e.direction}],null==i&&(i={}),null!=t&&null!=t.success&&t.success.call(i.success)},I.prototype.getData=function(e){return this.headers[e]},I.prototype.getMetadata=function(e){var t=this.getData(e),i={key:t};if(null!=this.sortCriteria)for(var s=0;s<this.sortCriteria.length;s++)this.sortCriteria[s].attribute===t&&(i.sortDirection=this.sortCriteria[s].direction);return i},I.prototype.getLevelCount=function(){return 1},I.prototype.getExtent=function(){return{extent:1,more:{before:!1,after:!1}}},I.prototype.getLabel=function(){return null},I.prototype.getDepth=function(){return 1},I.prototype.getCount=function(){return Math.max(0,this.end-this.start)};const M=function(e){this.grid=e};M.prototype.getAction=function(e,t){var i=e.keyCode,s=this.grid.m_utils.ctrlEquivalent(e),n=e.shiftKey,o=e.altKey,r=this.grid.keyCodes,l=t.cellOrHeader,a=t.readOnly,h=t.currentMode,d=t.activeMove,m=t.activeDrag,c=t.rowMove,u=t.columnSort;let _=t.rowSort;var p=t.selection,g=t.selectionMode,f=t.multipleSelection,C=t.expandCollapse,y=t.copyCells,E=t.cutCells,v=t.pasteCells,w=t.fill;switch(i){case r.TAB_KEY:if("actionable"===h)return n?"TAB_PREV_IN_CELL":"TAB_NEXT_IN_CELL";if("edit"===h)return n?"TAB_PREV_IN_CELL_OR_FOCUS_LEFT":"TAB_NEXT_IN_CELL_OR_FOCUS_RIGHT";if(!a)return n?"FOCUS_LEFT":"FOCUS_RIGHT";break;case r.ENTER_KEY:if("actionable"===h)return"NO_OP";if("column"===l&&u||"row"===l&&_)return"SORT";if(!o&&a&&"navigation"===h||"cell"!==l)return"ACTIONABLE";if(!a&&!o)return n?"FOCUS_UP":"FOCUS_DOWN";if(o&&a&&"navigation"===h)return"EDITABLE";if(!a&&("navigation"===h||"edit"===h))return"EDIT";break;case r.ESC_KEY:if("actionable"===h)return"EXIT_ACTIONABLE";if(d)return"CANCEL_REORDER";if(m)return"CANCEL_DRAG";if(a){if(this.grid.m_discontiguousSelection)return"SELECT_DISCONTIGUOUS"}else{if("navigation"===h)return"EXIT_EDITABLE";if("edit"===h)return"CANCEL_EDIT"}break;case r.SPACE_KEY:if(-1!==l.indexOf("row")&&p&&("cell"===g&&f||"row"===g)&&"navigation"===h)return"SELECT_ROW";if(-1!==l.indexOf("column")&&p&&"cell"===g&&f&&"navigation"===h)return"SELECT_COLUMN";if("cell"===l)if(a&&"navigation"===h){if(s&&p&&"cell"===g&&f)return"SELECT_COLUMN";if(n&&p&&("cell"===g&&f||"row"===g))return"SELECT_ROW"}else if("navigation"===h)return"DATA_ENTRY";break;case r.PAGEUP_KEY:if("navigation"===h)return"FOCUS_ROW_FIRST";break;case r.PAGEDOWN_KEY:if("navigation"===h)return"FOCUS_ROW_LAST";break;case r.END_KEY:if("navigation"===h)return s&&"cell"===l?"FOCUS_LAST_CELL_IN_GRID":"FOCUS_COLUMN_LAST";break;case r.HOME_KEY:if("navigation"===h)return s&&"cell"===l?"FOCUS_FIRST_CELL_IN_GRID":"FOCUS_COLUMN_FIRST";break;case r.LEFT_KEY:if(s&&C&&this.grid._isHeaderExpanded(e.target))return"COLLAPSE";if("actionable"===h)return"NO_OP";if("navigation"===h)return n&&p&&"cell"===g&&f?"SELECT_EXTEND_LEFT":s?"FOCUS_LEFT_NON_EMPTY_CELL":"FOCUS_LEFT";break;case r.UP_KEY:if("actionable"===h)return"NO_OP";if("navigation"===h)return n&&p&&f?"SELECT_EXTEND_UP":s?"FOCUS_UP_NON_EMPTY_CELL":"FOCUS_UP";break;case r.RIGHT_KEY:if(s&&C&&this.grid._isHeaderCollapsed(e.target))return"EXPAND";if("actionable"===h)return"NO_OP";if("navigation"===h)return n&&p&&"cell"===g&&f?"SELECT_EXTEND_RIGHT":s?"FOCUS_RIGHT_NON_EMPTY_CELL":"FOCUS_RIGHT";break;case r.DOWN_KEY:if("actionable"===h)return"NO_OP";if("navigation"===h)return n&&p&&f?"SELECT_EXTEND_DOWN":s?"FOCUS_DOWN_NON_EMPTY_CELL":"FOCUS_DOWN";break;case r.F2_KEY:if("actionable"===h)return"EXIT_ACTIONABLE";if("cell"!==l)return"ACTIONABLE";if(a&&"navigation"===h)return"EDITABLE";if(!a&&"navigation"===h)return"EDIT";if(!a&&"edit"===h)return"CANCEL_EDIT";break;case r.F8_KEY:if(n&&p&&f)return"SELECT_DISCONTIGUOUS";break;case r.F10_KEY:if(n)return"NO_OP";break;case r.V_KEY:if("navigation"===h&&s){if(c)return"PASTE";if(v)return"PASTE_CELLS"}if(!a&&"navigation"===h&&"cell"===l)return"DATA_ENTRY";break;case r.X_KEY:if("navigation"===h&&s){if(c)return"CUT";if(E)return"CUT_CELLS"}if(!a&&"navigation"===h&&"cell"===l)return"DATA_ENTRY";break;case r.C_KEY:if("navigation"===h&&s&&y)return"COPY_CELLS";if(!a&&"navigation"===h&&"cell"===l)return"DATA_ENTRY";break;case r.D_KEY:if("navigation"===h&&s&&w)return"FILL";if(!a&&"navigation"===h&&"cell"===l&&!s)return"DATA_ENTRY";break;case r.R_KEY:if("navigation"===h&&s&&o&&t.filterCol)return"FILTER_COLUMN";if("navigation"===h&&s&&w)return"FILL";if(!a&&"navigation"===h&&"cell"===l&&!s)return"DATA_ENTRY";break;case r.SHIFT_KEY:case r.CTRL_KEY:case r.ALT_KEY:break;case r.A_KEY:if(s&&p&&f&&"navigation"===h)return"SELECT_ALL";case r.NUM5_KEY:if(s&&o&&"navigation"===h)return"READ_CELL";default:if((i<r.F1_KEY||i>r.F15_KEY)&&!a&&"navigation"===h&&"cell"===l&&!s)return"DATA_ENTRY"}return"NO_OP"},M.prototype.getNoDataAction=function(e,t){var i=e.keyCode,s=e.shiftKey,n=this.grid.keyCodes,o=t.currentMode;switch(i){case n.TAB_KEY:if("actionable"===o)return s?"TAB_PREV_IN_CELL":"TAB_NEXT_IN_CELL";break;case n.ESC_KEY:if("actionable"===o)return"EXIT_ACTIONABLE";break;case n.F2_KEY:return"actionable"===o?"EXIT_ACTIONABLE":"ACTIONABLE";case n.UP_KEY:if("navigation"===o)return"FOCUS_COLUMN_HEADER";break;case n.DOWN_KEY:if("navigation"===o)return"FOCUS_COLUMN_END_HEADER";break;case n.LEFT_KEY:if("navigation"===o)return"FOCUS_ROW_HEADER";break;case n.RIGHT_KEY:if("navigation"===o)return"FOCUS_ROW_END_HEADER"}return"NO_OP"};const F=function(e,t){this.options=e,this.rendererWrapperFunction=t};F.prototype.extract=function(e,t,i,s,n){if(null!=e){var o=this.options[e];if(null!=t&&null!=o){var r=o[t];if(null!=i&&null!=r){var l=r[i];if(null!=s&&null!=l){var a=l[s];return null!=n&&null!=a?a[n]:a}return l}return r}return o}return null},F.prototype.evaluate=function(e,t){return"function"==typeof e?e.call(this,t):e},F.prototype.getRawProperty=function(e,t,i){var s,n,o,r;return"row"===t||"column"===t||"rowEnd"===t||"columnEnd"===t?(s="header",n=t,i?(o="label",r=e):o=e):"cell"===t&&(s="cell",n=e),this.extract(s,n,o,r)},F.prototype.getProperty=function(e,t,i,s){return void 0===i?this.extract(e,t,s):this.evaluate(this.getRawProperty(e,t,s),i)},F.prototype.getRowBandingInterval=function(){var e=this.getProperty("bandingInterval","row");return null!=e?e:0},F.prototype.getColumnBandingInterval=function(){var e=this.getProperty("bandingInterval","column");return null!=e?e:0},F.prototype.getEmptyText=function(){return this.getProperty("emptyText")},F.prototype.getHorizontalGridlines=function(){var e=this.extract("gridlines","horizontal");return null!=e?e:"visible"},F.prototype.getVerticalGridlines=function(){var e=this.extract("gridlines","vertical");return null!=e?e:"visible"},F.prototype.getScrollToKey=function(){var e=this.getProperty("scrollToKey");return null!=e?e:"auto"},F.prototype.getScrollPosition=function(){var e=this.getProperty("scrollPosition");return null!=e?e:null},F.prototype.getSelectionCardinality=function(){var e=this.getProperty("selectionMode");if(null==e)return"none";var t=e[this.getSelectionMode()];return null!=t?t:"none"},F.prototype.getSelectionMode=function(){var e=this.getProperty("selectionMode");if(null==e)return"cell";var t=e.row;return null!=t&&"none"!==t?"row":"cell"},F.prototype.getSelection=function(){return this.getProperty("selection")},F.prototype.getCurrentCell=function(){return this.getProperty("currentCell")},F.prototype.getEditMode=function(){return this.getProperty("editMode")},F.prototype.isSortable=function(e,t,i){return this.getProperty("sortable",e,t,i)},F.prototype.isResizable=function(e,t,i){var s=this.extract("header",e,"resizable",t);return null!=i?this.evaluate(s,i):s},F.prototype.isMoveable=function(e){return this.extract("dnd","reorder",e)},F.prototype._isDragEnabled=function(e){let t=!1,i="row"===e||"rowEnd"===e?"rows":"columns",s=this.getProperty("dnd").drag;return s&&s[i]&&(t=!0),t},F.prototype._isDragEnabledOnLabel=function(e){let t=!1,i="row"===e||"rowEnd"===e?"rowLabels":"columnLabels",s=this.getProperty("dnd").drag;return s&&s[i]&&(t=!0),t},F.prototype.isFloodFillEnabled=function(){let e=!1;return"enable"===this.extract("dataTransferOptions","fill")&&(e=!0),e},F.prototype.isCopyEnabled=function(){let e=!1;return"enable"===this.extract("dataTransferOptions","copy")&&(e=!0),e},F.prototype.isCutEnabled=function(){let e=!1;return"enable"===this.extract("dataTransferOptions","cut")&&(e=!0),e},F.prototype._isLabelCutEnabled=function(){let e=!1;return"enable"===this.extract("dataTransferOptions","headerLabelCut")&&(e=!0),e},F.prototype.isPasteEnabled=function(){let e=!1;return"enable"===this.extract("dataTransferOptions","paste")&&(e=!0),e},F.prototype.isFreezeEnabled=function(e){let t=!1;return"scroll"!==this.getProperty("scrollPolicy")&&("enable"===this.extract("header",e,"freezable")&&(t=!0),t)},F.prototype._getFreezeIndex=function(e){let t=null;return"scroll"===this.getProperty("scrollPolicy")||(t="row"===e?this.getProperty("frozenRowCount"):this.getProperty("frozenColumnCount"),null!==t&&(t=parseInt(t,10)-1)),t},F.prototype.isHideEnabled=function(e){let t=!1;return"enable"===this.extract("header",e,"hidable")&&(t=!0),t},F.prototype._getHiddenIndices=function(e){let t;return"column"===e?t=this.getProperty("hiddenColumns"):"row"===e&&(t=this.getProperty("hiddenRows")),t},F.prototype.getInlineStyle=function(e,t,i){return this.getProperty("style",e,t,i)},F.prototype.getStyleClass=function(e,t,i){return this.getProperty("className",e,t,i)},F.prototype.isEditable=function(e,t,i){return this.getProperty("editable",e,t,i)},F.prototype.getRenderer=function(e,t){return this.rendererWrapperFunction?this.rendererWrapperFunction(this.getRawProperty("renderer",e,t)):this.getRawProperty("renderer",e,t)},F.prototype.getScrollPolicy=function(){var e=this.getProperty("scrollPolicy");return null==e&&(e="auto"),e},F.prototype.getScrollPolicyOptions=function(){return this.getProperty("scrollPolicyOptions")},F.prototype.isFilterEnabled=function(e,t){return this.getProperty("filterable",e,t)},F.prototype.getAlignment=function(e,t,i,s){let n;return n="cell"===t?this.extract("cell","alignment",e):s?this.extract("header",t,"label","alignment",e):this.extract("header",t,"alignment",e),null==n&&(n="auto"),null!=i?this.evaluate(n,i):n},F.prototype.getHorizontalAlignment=function(e,t,i){return this.getAlignment("horizontal",e,t,i)},F.prototype.getVeticalAlignment=function(e,t,i){return this.getAlignment("vertical",e,t,i)};const z=function(){this.sizes={column:new Map,row:new Map}};z.prototype.setSize=function(e,t,i){this.sizes[e].set(t,i)},z.prototype.getSize=function(e,t){var i=this.sizes[e].get(t);return null!=i||this.sizes[e].forEach(function(e,s){null==i&&d.Object.compareValues(s,t)&&(i=e)}),i},z.prototype.clear=function(){this.sizes.column.clear(),this.sizes.row.clear()};const D=function(e){this.scrollbarSize=-1,this.dataGrid=e};D.prototype._getMaxDivHeightForScrolling=function(){return null==this.m_maxDivHeightForScrolling&&this._setMaxValuesForScrolling(),this.m_maxDivHeightForScrolling},D.prototype._getMaxDivWidthForScrolling=function(){return null==this.m_maxDivWidthForScrolling&&this._setMaxValuesForScrolling(),this.m_maxDivWidthForScrolling},D.prototype._setMaxValuesForScrolling=function(){this._calculateBrowserDefinedValues()},D.prototype._calculateBrowserDefinedValues=function(){var e=document.createElement("div");e.style.width="1000000000px",e.style.height="1000000000px",e.style.display="none";var t=document.createElement("div");t.style.width="100px",t.style.height="100px",t.style.overflow="scroll",t.style.position="absolute",t.style.top="-9999px",document.body.appendChild(t);let i=!1;_.isIE()||_.isEdge()?(this.m_maxDivHeightForScrolling=1e6,this.m_maxDivWidthForScrolling=1e6):(i=!0,document.body.appendChild(e),this.m_maxDivHeightForScrolling=parseInt(parseFloat(window.getComputedStyle(e).height)/2,10),this.m_maxDivWidthForScrolling=parseInt(parseFloat(window.getComputedStyle(e).width)/2,10)),this.scrollbarSize=t.offsetWidth-t.clientWidth,i&&document.body.removeChild(e),document.body.removeChild(t)},D.prototype.getScrollbarSize=function(){return-1===this.scrollbarSize&&this._calculateBrowserDefinedValues(),this.scrollbarSize},D.prototype.isTouchDevice=function(){return null==this.isTouch&&(this.isTouch=_.isMobileTouchDevice()),this.isTouch},D.prototype.isTouchDeviceNotIOS=function(){if(null==this.isTouchNotIOS){let e=this.isTouchDevice();this.isTouchNotIOS=!!e&&!_.isIos()}return this.isTouchNotIOS},D.prototype.addCSSClassName=function(e,t){null!=t&&""!==t&&null!=e&&null!=e.classList&&e.classList.add(t)},D.prototype.removeCSSClassName=function(e,t){null!=t&&""!==t&&null!=e&&null!=e.classList&&e.classList.remove(t)},D.prototype.containsCSSClassName=function(e,t){var i=!1;return null!=t&&null!=e&&null!=e.classList&&(i=e.classList.contains(t)),i},D.prototype.ctrlEquivalent=function(e){return _.isMac()?e.metaKey:e.ctrlKey},D.prototype.getElementScrollLeft=function(e){return Math.abs(e.scrollLeft)},D.prototype.setElementScrollLeft=function(e,t){p.setScrollLeft(e,t)},D.prototype.getMousewheelEvent=function(){return"wheel"},D.prototype.getMousewheelScrollDelta=function(e){var t=-1,i=e.deltaMode;return i===e.DOM_DELTA_PIXEL?t=-1:i!==e.DOM_DELTA_LINE&&i!==e.DOM_DELTA_PAGE||(t=-40),{deltaX:e.deltaX*t,deltaY:e.deltaY*t}},D.prototype.empty=function(e){for(;e.firstChild;)this.dataGrid._remove(e.firstChild)},D.prototype._isNodeEditableOrClickable=function(e,t){for(;null!=e&&e!==t;){var i=e.nodeName;if(3===e.nodeType)e=e.parentNode;else{var s=parseInt(e.getAttribute("tabIndex"),10),n=parseInt(e.getAttribute(this.dataGrid.getResources().getMappedAttribute("tabindex")),10);if(null!=s&&s>=0)return!(this.containsCSSClassName(e,this.dataGrid.getResources().getMappedStyle("cell"))||this.containsCSSClassName(e,this.dataGrid.getResources().getMappedStyle("headerlabel"))||this.containsCSSClassName(e,this.dataGrid.getResources().getMappedStyle("headercell"))||this.containsCSSClassName(e,this.dataGrid.getResources().getMappedStyle("endheadercell")));if(i.match(/^INPUT|SELECT|OPTION|BUTTON|^A\b|TEXTAREA/)&&(-1!==s||-1!==n))return!0;e=e.parentNode}}return!1},D.prototype.shouldOffsetOutline=function(){return!(!_.isMac()||!_.isWebkit())};const A=function(e){this.m_root=e,this.MAX_COLUMN_THRESHOLD=20,this.MAX_ROW_THRESHOLD=30,this.m_utils=new D(this),this.m_discontiguousSelection=!1,this.m_sizingManager=new z,this.m_keyboardHandler=new M(this),this.m_rowHeaderWidth=null,this.m_rowEndHeaderWidth=null,this.m_colHeaderHeight=null,this.m_colEndHeaderHeight=null,this.m_styleClassDimensionMap={width:{},height:{}},this.m_isEstimateRowCount=void 0,this.m_isEstimateColumnCount=void 0,this.m_stopRowFetch=!1,this.m_stopRowHeaderFetch=!1,this.m_stopRowEndHeaderFetch=!1,this.m_stopColumnFetch=!1,this.m_stopColumnHeaderFetch=!1,this.m_stopColumnEndHeaderFetch=!1,this.m_fetchingForUpdate=!1,this.m_initialized=!1,this.m_shouldFocus=null,this.m_renderCount=0,this.callbacks={},this._setupActions(),this.m_readinessStack=[],this.m_modelEvents=[],this.m_databodyMap=new Map};A.prototype.keyCodes={TAB_KEY:9,ENTER_KEY:13,SHIFT_KEY:16,CTRL_KEY:17,ALT_KEY:18,ESC_KEY:27,SPACE_KEY:32,PAGEUP_KEY:33,PAGEDOWN_KEY:34,END_KEY:35,HOME_KEY:36,LEFT_KEY:37,UP_KEY:38,RIGHT_KEY:39,DOWN_KEY:40,NUM5_KEY:53,V_KEY:86,X_KEY:88,C_KEY:67,D_KEY:68,R_KEY:82,F1_KEY:112,F2_KEY:113,F8_KEY:119,F10_KEY:121,F15_KEY:126,A_KEY:65},A.UPDATE_ANIMATION_FADE_INOUT=1,A.UPDATE_ANIMATION_SLIDE_INOUT=2,A.UPDATE_ANIMATION_DURATION=250,A.EXPAND_ANIMATION_DURATION=500,A.COLLAPSE_ANIMATION_DURATION=400,A.MAX_OVERSCROLL_PIXEL=50,A.BOUNCE_ANIMATION_DURATION=500,A.DECELERATION_FACTOR=6e-4,A.TAP_AND_SCROLL_RESET=300,A.MIN_SWIPE_DURATION=200,A.MAX_SWIPE_DURATION=400,A.MIN_SWIPE_DISTANCE=10,A.MIN_SWIPE_TRANSITION_DURATION=100,A.MAX_SWIPE_TRANSITION_DURATION=500,A.CONTEXT_MENU_TAP_HOLD_DURATION=750,A.HEADER_TAP_SHORT_HOLD_DURATION=300,A.FETCH_PIXEL_THRESHOLD=5,A.VISIBILITY_STATE_HIDDEN="hidden",A.VISIBILITY_STATE_REFRESH="refresh",A.VISIBILITY_STATE_RENDER="render",A.VISIBILITY_STATE_VISIBLE="visible",A.SPACER_DEFAULT_WIDTH=2,A.SKELETON_DEFAULT_COUNT=3,A.prototype.SetOptions=function(e,t){this.m_options=new F(e,t)},A.prototype.SetSortOriginalEvent=function(e){this.m_sortColumnInfo&&(this.m_sortColumnInfo.originalEvent=e)},A.prototype.UpdateOptions=function(e,t){var i,s,n=Object.keys(e);for(s=0;s<n.length;s++)(i=n[s])in this.m_options.options&&this.m_options.options[i]!==e[i]&&(this.m_options.options[i]=e[i]);for(s=0;s<n.length;s++)if(i=n[s],!this._updateDataGrid(i,t)){this.empty(),this.refresh(this.m_root);break}},A.prototype._updateDataGrid=function(e,t){var i;switch(e){case"bandingInterval":this._removeBanding(),this.updateColumnBanding(),this.updateRowBanding();break;case"currentCell":i=this.m_options.getCurrentCell(),this._updateActive(i,!0,!1);break;case"editMode":this.m_editMode=this.m_options.getEditMode();break;case"gridlines":this._updateGridlines();break;case"header":i=this.m_options.options.header,this._updateHeaderOptions(i,t);break;case"scrollPosition":i=this.m_options.getScrollPosition(),this._updateScrollPosition(i);break;case"selection":i=this.m_options.getSelection(),this._updateSelection(i);break;case"selectionMode":this._clearSelection(null);break;case"frozenColumnCount":i=this.m_options._getFreezeIndex("column"),this._updateFrozenSection(i,"column");break;case"frozenRowCount":i=this.m_options._getFreezeIndex("row"),this._updateFrozenSection(i,"row");break;case"hiddenColumns":i=this.m_options._getHiddenIndices("column"),this._updateHiddenSection(Array.from(i),"column");break;case"hiddenRows":i=this.m_options._getHiddenIndices("row"),this._updateHiddenSection(Array.from(i),"row");break;default:return!1}return!0},A.prototype._updateSelection=function(e){null!=e&&this._isSelectionEnabled()&&this.SetSelection(e)},A.prototype._updateHeaderOptions=function(e,t){if(null!=t&&null!=t.subkey){var i,s=t.subkey.split("."),n=s[0],o=s[1];if("column"===n&&null!=this.m_colHeader&&null!=this.m_colHeader.firstChild?i=this.m_colHeader.firstChild.childNodes:"row"===n&&null!=this.m_rowHeader&&null!=this.m_rowHeader.firstChild?i=this.m_rowHeader.firstChild.childNodes:"columnEnd"===n&&null!=this.m_colEndHeader&&null!=this.m_colEndHeader.firstChild?i=this.m_colEndHeader.firstChild.childNodes:"rowEnd"===n&&null!=this.m_rowEndHeader&&null!=this.m_rowEndHeader.firstChild&&(i=this.m_rowEndHeader.firstChild.childNodes),null!=i)for(var r=0;r<i.length;r++){var l=i[r],a=l[this.getResources().getMappedAttribute("context")];if(a.index=this.getHeaderCellIndex(l),"resizable"===o)this._isHeaderResizeEnabled(n,a)?this._setAttribute(l,o,"true"):this._setAttribute(l,o,"false");else if("sortable"===o){const e=this.m_options.getHorizontalAlignment(n,a);var h=null!=this._getSortContainer(l);if(this._isSortEnabled(n,a)){if(!h){var d=this._buildSortIcon(a,l);this._shouldAppendIcon(e,n,a)?l.appendChild(d):l.insertBefore(d,l.childNodes[0])}this._setAttribute(l,o,"true")}else h&&this._remove(this._getSortContainer(l)),this._setAttribute(l,o,"false")}}}},A.prototype._updateGridlines=function(){var e=this.m_options.getHorizontalGridlines(),t=this.m_options.getVerticalGridlines(),i=this.getResources().isRTLMode()?"right":"left";if(this.m_databody&&this.m_databody.firstChild){let s=this.m_databody.firstChild.querySelectorAll("."+this.getMappedStyle("cell")),n=this._getLastAxis("row"),o=this._getLastAxis("column");for(let r=0;r<s.length;r++){let l=s[r],a=this.getCellIndexes(l);"hidden"===t||a.column===o&&(this.getRowHeaderWidth()+this.getElementDir(l,i)+this.getElementWidth(l)>=this.getWidth()||this.m_endRowEndHeader>-1)?this.m_utils.addCSSClassName(l,this.getMappedStyle("borderVerticalNone")):this.m_utils.removeCSSClassName(l,this.getMappedStyle("borderVerticalNone")),"hidden"===e||a.row===n&&(this.getRowBottom(l,null)>=this.getHeight()||this.m_endColEndHeader>-1)?this.m_utils.addCSSClassName(l,this.getMappedStyle("borderHorizontalNone")):this.m_utils.removeCSSClassName(l,this.getMappedStyle("borderHorizontalNone"))}}},A.prototype._updateEdgeCellBorders=function(e){if(null!=this.m_active&&"cell"===this.m_active.type){var t=this._getActiveElement();if(null!=t){if(this._isCellEditable()&&""===e||""!==e){let i="Edit",s=this.getResources().getMappedAttribute("metadata");"invalidShown"===t[s]?.metadata?.validity&&"navigation"!==this.m_currentMode&&(i="EditInvalid"),this._applyBorderClassesAroundRange(t,{startIndex:this.m_active.indexes},""===e,i)}this._isLastRow(this.m_active.indexes.row)&&("none"===e?this.m_utils.addCSSClassName(t,this.getMappedStyle("borderHorizontalNone")):this.m_utils.removeCSSClassName(t,this.getMappedStyle("borderHorizontalNone"))),this._isLastColumn(this.m_active.indexes.column)&&("none"===e?this.m_utils.addCSSClassName(t,this.getMappedStyle("borderVerticalNone")):this.m_utils.removeCSSClassName(t,this.getMappedStyle("borderVerticalNone")))}}},A.prototype.SetResources=function(e){this.m_resources=e},A.prototype.getResources=function(){return this.m_resources},A.prototype.getStartRowHeader=function(){return this.m_startRowHeader},A.prototype.getStartColumnHeader=function(){return this.m_startColHeader},A.prototype.getStartRowEndHeader=function(){return this.m_startRowEndHeader},A.prototype.getStartColumnEndHeader=function(){return this.m_startColEndHeader},A.prototype.getMappedStyle=function(e){return this.getResources().getMappedStyle(e)},A.prototype.SetDataSource=function(e){this.m_modelEvents=[],this.m_dataSource=e},A.prototype.getDataSource=function(){return this.m_dataSource},A.prototype.setVisibility=function(e){this.m_visibility=e},A.prototype.getVisibility=function(){return null==this.m_visibility&&(null!=this.m_root.offsetParent?this.setVisibility(A.VISIBILITY_STATE_VISIBLE):this.setVisibility(A.VISIBILITY_STATE_HIDDEN)),this.m_visibility},A.prototype.SetOptionCallback=function(e){this.m_setOptionCallback=e},A.prototype.SetContextCallback=function(e){this.m_contextCallback=e},A.prototype.SetCustomElementCallback=function(e){this.m_isCustomElementCallback=e},A.prototype.SetRemoveCallback=function(e){this.m_removeCallback=e},A.prototype.SetUniqueIdCallback=function(e){this._uniqueIdCallback=e},A.prototype.SetCompareValuesCallback=function(e){this._compareValuesCallback=e},A.prototype.SetSubtreeAttachedCallback=function(e){this.m_subtreeAttachedCallback=e},A.prototype.SetUpdateScrollPostionOnRefreshCallback=function(e){this.m_updateScrollPostionOnRefreshCallback=e},A.prototype._remove=function(e){null!=e&&(this._uniqueIdCallback(e,!0),this.m_removeCallback.call(null,e))},A.prototype._removeFromArray=function(e){for(var t=0;t<e.length;t++)this._remove(e[t])},A.prototype.SetNotReadyCallback=function(e){this.m_notReady=e},A.prototype.SetMakeReadyCallback=function(e){this.m_makeReady=e},A.prototype._signalTaskStart=function(){this.m_readinessStack&&(0===this.m_readinessStack.length&&this.m_notReady(),this.m_readinessStack.push(1))},A.prototype._signalTaskEnd=function(){this.m_readinessStack&&this.m_readinessStack.length>0&&(this.m_readinessStack.pop(),0===this.m_readinessStack.length&&this.m_makeReady())},A.prototype._indexes=function(e,t){var i=this,s=this.getDataSource().indexes(e);"function"==typeof s.then?(i._signalTaskStart(),s.then(function(s){t.call(i,s,e),i._signalTaskEnd()},function(){t.call(i,{row:-1,column:-1},e),i._signalTaskEnd()})):t.call(i,s,e)},A.prototype._keys=function(e,t){var i=this,s=this._getLocalKeys(e);if(void 0===s){var n=this.getDataSource().keys(e);"function"==typeof n.then?(i._signalTaskStart(),n.then(function(s){t.call(i,s,e),i._signalTaskEnd()},function(){t.call(i,{row:null,column:null},e),i._signalTaskEnd()})):t.call(i,n,e)}else t.call(i,s,e)},A.prototype._getLocalKeys=function(e){var t=this._getCellByIndex(e);if(t)return this.getCellKeys(t);var i,s,n=e.row,o=e.column;if(void 0!==n){if(-1===n)i=null;else{var r=this._getCellOrHeaderByIndex(n,"row");r&&(i=this._getKey(r,"row"))}if(void 0===i)return}if(void 0!==o){if(-1===o)s=null;else{var l=this._getCellOrHeaderByIndex(o,"column");l&&(s=this._getKey(l,"column"))}if(void 0===s)return}return this.createIndex(i,s)},A.prototype.SetCreateContextCallback=function(e){this.m_createContextCallback=e},A.prototype.SetFocusableCallback=function(e,t){this.m_focusInHandler=e,this.m_focusOutHandler=t},A.prototype.SetFixContextCallback=function(e){this.m_fixContextCallback=e},A.prototype.SetCustomElement=function(e){this.m_customElement=e},A.prototype._isHighWatermarkScrolling=function(){return"scroll"!==this.m_options.getScrollPolicy()},A.prototype.destroy=function(){delete this.m_fetching,this._removeDataSourceEventListeners(),this._removeDomEventListeners(),delete this.m_styleClassDimensionMap,this.m_styleClassDimensionMap={width:{},height:{}}},A.prototype._addDataSourceEventListeners=function(){this._removeDataSourceEventListeners(),null!=this.m_dataSource&&(this.m_handleModelEventListener=this.handleModelEvent.bind(this),this.m_handleExpandEventListener=this.handleExpandEvent.bind(this),this.m_handleCollapseEventListener=this.handleCollapseEvent.bind(this),this.m_dataSource.on("change",this.m_handleModelEventListener,this),this.m_dataSource.on("expand",this.m_handleExpandEventListener,this),this.m_dataSource.on("collapse",this.m_handleCollapseEventListener,this))},A.prototype._removeDataSourceEventListeners=function(){null!=this.m_dataSource&&(this.m_dataSource.off("change",this.m_handleModelEventListener),this.m_dataSource.off("expand",this.m_handleExpandEventListener),this.m_dataSource.off("collapse",this.m_handleCollapseEventListener))},A.prototype._addDomEventListeners=function(){this.m_handleDatabodyKeyDown||(this.m_handleDatabodyKeyDown=this.handleDatabodyKeyDown.bind(this)),this.m_handleDatabodyKeyUp||(this.m_handleDatabodyKeyUp=this.handleDatabodyKeyUp.bind(this)),this.m_handleRootFocus||(this.m_handleRootFocus=this.handleRootFocus.bind(this)),this.m_handleRootBlur||(this.m_handleRootBlur=this.handleRootBlur.bind(this)),this.m_root.addEventListener("keydown",this.m_handleDatabodyKeyDown,!1),this.m_root.addEventListener("keyup",this.m_handleDatabodyKeyUp,!1),this.m_root.addEventListener("focus",this.m_handleRootFocus,!0),this.m_root.addEventListener("blur",this.m_handleRootBlur,!0)},A.prototype._removeDomEventListeners=function(){document.removeEventListener("mousemove",this.m_docMouseMoveListener,!1),document.removeEventListener("mouseup",this.m_docMouseUpListener,!1),null!=this.m_root&&(this.m_handleDatabodyKeyDown&&this.m_root.removeEventListener("keydown",this.m_handleDatabodyKeyDown,!1),this.m_handleDatabodyKeyUp&&this.m_root.removeEventListener("keyup",this.m_handleDatabodyKeyUp,!1),this.m_handleRootFocus&&this.m_root.removeEventListener("focus",this.m_handleRootFocus,!0),this.m_handleRootBlur&&this.m_root.removeEventListener("blur",this.m_handleRootBlur,!0))},A.prototype.getRootElement=function(){return this.m_root},A.prototype.getWidth=function(){return null==this.m_width&&(this.m_width=this.getRootElement().clientWidth),this.m_width},A.prototype.getHeight=function(){return null==this.m_height&&(this.m_height=this.getRootElement().clientHeight),this.m_height},A.prototype.getViewportWidth=function(){var e=this.getWidth();return Math.round(1.5*e)},A.prototype.getViewportHeight=function(){var e=this.getHeight();return Math.round(1.5*e)},A.prototype._getViewportTop=function(){return this.m_currentScrollTop},A.prototype._getViewportBottom=function(){var e=this._getViewportTop(),t=this.getElementHeight(this.m_databody),i=this.m_utils.getScrollbarSize();return this.m_hasHorizontalScroller?e+t-i:e+t},A.prototype._getViewportLeft=function(){return this.m_currentScrollLeft},A.prototype._getViewportRight=function(){var e=this._getViewportLeft(),t=this.getElementWidth(this.m_databody),i=this.m_utils.getScrollbarSize();return this.m_hasVerticalScroller?e+t-i:e+t},A.prototype.getFetchSize=function(e){return"row"===e?(null==this.m_rowFetchSize&&(this.m_rowFetchSize=Math.max(1,Math.round(this.getViewportHeight()/this.getDefaultRowHeight()))),this.m_rowFetchSize):"column"===e?(null==this.m_columnFetchSize&&(this.m_columnFetchSize=Math.max(1,Math.round(this.getViewportWidth()/this.getDefaultColumnWidth()))),this.m_columnFetchSize):0},A.prototype.getEmptyText=function(){var e=this.m_options.getEmptyText();null==e&&(e=this.getResources().getTranslatedText("msgNoData"));return e},A.prototype._buildEmptyText=function(){let e;if(null==this.getDataSource()){let t=this.getWidth(),i=this.getHeight();e=this.buildDatabody(!0)[0],this.setElementWidth(e,t),this.setElementHeight(e,i),this.m_root.insertBefore(e,this.m_status)}const t=this._getTemplateEngine(),i=this._getItemTemplateBySlotName("noData");if(e=this.m_databody,i&&null!=t){let s=document.createElement("div");return s.setAttribute(this.getResources().getMappedAttribute("container"),this.getResources().widgetName),s.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),s.id=this.createSubId("noData"),this.m_utils.addCSSClassName(s,this.getMappedStyle("noDataContainer")),t.execute(this.getRootElement(),i,{},null,e).forEach(function(e){s.appendChild(e)}),this._removeFocusFromChildElements({},s),s}var s=this.getEmptyText(),n=document.createElement("div");return n.id=this.createSubId("empty"),n.className=this.getMappedStyle("emptytext"),n.textContent=s,this.m_empty=n,n},A.prototype.getRowThreshold=function(){return 0},A.prototype.getColumnThreshold=function(){return 0},A.prototype.setDefaultDimensions=function(){var e=document.createElement("div");e.style.visibilty="hidden";var t=this.getResources();e.className=t.getMappedStyle("rowheadercell")+" "+t.getMappedStyle("colheadercell")+" "+t.getMappedStyle("headercell"),this.m_root.appendChild(e),this.m_defaultColumnWidth=e.offsetWidth,this.m_defaultRowHeight=e.offsetHeight,this.getViewportWidth(),this.getViewportHeight(),this.m_root.removeChild(e)},A.prototype.getDefaultRowHeight=function(){return null==this.m_defaultRowHeight&&this.setDefaultDimensions(),this.m_defaultRowHeight},A.prototype.getDefaultColumnWidth=function(){return null==this.m_defaultColumnWidth&&this.setDefaultDimensions(),this.m_defaultColumnWidth},A.prototype._getHeaderDimension=function(e,t,i,s){var n=this.m_sizingManager.getSize(i,t);if(null!=n)return n;if(""!==e.style[s])return n=this.getElementDir(e,s),this.m_sizingManager.setSize(i,t,n),n;var o=e.className;return null==(n=this.m_styleClassDimensionMap[s][o])&&(n=this.getElementDir(e,s)),this.m_sizingManager.setSize(i,t,n),this.m_styleClassDimensionMap[s][o]=n,n},A.prototype.createSubId=function(e){return[this.getRootElement().id,e].join(":")},A.prototype.isHeaderFetchComplete=function(){return!1===this.m_fetching.row&&!1===this.m_fetching.column},A.prototype.isFetchComplete=function(){return null!=this.m_fetching&&this.isHeaderFetchComplete()&&!1===this.m_fetching.cells},A.prototype._isLastRow=function(e){return this._isCountUnknown("row")?e===this.m_endRow&&this.m_stopRowFetch:e+1===this.getDataSource().getCount("row")},A.prototype._isLastColumn=function(e){return this._isCountUnknown("column")?e===this.m_endCol&&this.m_stopColumnFetch:e+1===this.getDataSource().getCount("column")},A.prototype._getLastAxis=function(e){return this._isCountUnknown(e)?("row"===e?this.m_stopRowFetch:this.m_stopColumnFetch)?"row"===e?this.m_endRow:this.m_endCol:"row"===e?this.m_endRow+1:this.m_endCol+1:this.getDataSource().getCount(e)-1},A.prototype.empty=function(){this.m_empty&&this._remove(this.m_empty),this.m_corner&&this._remove(this.m_corner),this.m_bottomCorner&&this._remove(this.m_bottomCorner),this.m_columnHeaderScrollbarSpacer&&this._remove(this.m_columnHeaderScrollbarSpacer),this.m_rowHeaderScrollbarSpacer&&this._remove(this.m_rowHeaderScrollbarSpacer),this.m_root.removeChild(this.m_placeHolder),this.m_root.removeChild(this.m_status),this.m_root.removeChild(this.m_accSummary),this.m_root.removeChild(this.m_accInfo),this.m_root.removeChild(this.m_stateInfo),this.m_root.removeChild(this.m_contextInfo),this._remove(this.m_colHeader),this._remove(this.m_rowHeader),this._remove(this.m_colEndHeader),this._remove(this.m_rowEndHeader),this._remove(this.m_databody),this._remove(this.m_databodyFrozenCol),this._remove(this.m_databodyFrozenRow),this._remove(this.m_databodyFrozenCorner),this._remove(this.m_colHeaderFrozen),this._remove(this.m_colEndHeaderFrozen),this._remove(this.m_rowHeaderFrozen),this._remove(this.m_rowEndHeaderFrozen),this._clearDatabodyMap()},A.prototype.refresh=function(e){this.resetInternal(),this.render(e)},A.prototype.resetInternal=function(){this.m_initialized=!1,this.m_readinessStack=[],this._signalTaskStart(),this._signalTaskEnd(),this._clearDatabodyMap(),this.m_cursor=null,this.m_corner=null,this.m_bottomCorner=null,this.m_columnHeaderScrollbarSpacer=null,this.m_rowHeaderScrollbarSpacer=null,this.m_colHeader=null,this.m_colEndHeader=null,this.m_rowHeader=null,this.m_rowEndHeader=null,this.m_databody=null,this.m_empty=null,this.m_accInfo=null,this.m_accSummary=null,this.m_contextInfo=null,this.m_placeHolder=null,this.m_stateInfo=null,this.m_status=null,this.m_headerLabels={row:[],column:[],rowEnd:[],columnEnd:[]},this.m_rowHeaderFrozen=null,this.m_rowEndHeaderFrozen=null,this.m_colHeaderFrozen=null,this.m_colEndHeaderFrozen=null,this.m_databodyFrozenCorner=null,this.m_databodyFrozenRow=null,this.m_databodyFrozenCol=null,this.m_isEstimateRowCount=void 0,this.m_isEstimateColumnCount=void 0,this.m_stopRowFetch=!1,this.m_stopRowHeaderFetch=!1,this.m_stopRowEndHeaderFetch=!1,this.m_stopColumnFetch=!1,this.m_stopColumnHeaderFetch=!1,this.m_stopColumnEndHeaderFetch=!1,this.m_rowFetchSize=null,this.m_columnFetchSize=null,this.m_fetching=null,this.m_processingModelEvent=!1,this.m_processingEventQueue=!1,this.m_animating=!1,this.m_fetchingForUpdate=!1,this.m_sizingManager.clear(),this.m_styleClassDimensionMap={width:{},height:{}},this.m_height=null,this.m_width=null,this.m_scrollHeight=null,this.m_scrollWidth=null,this.m_avgRowHeight=void 0,this.m_avgColWidth=void 0,this.m_defaultColumnWidth=null,this.m_defaultRowHeight=null,this.m_colHeaderHeight=null,this.m_colEndHeaderHeight=null,this.m_rowHeaderWidth=null,this.m_rowEndHeaderWidth=null,this.m_rowHeaderLevelWidths=[],this.m_rowEndHeaderLevelWidths=[],this.m_columnHeaderLevelHeights=[],this.m_columnEndHeaderLevelHeights=[],this.m_collisionResize=!1,this.m_active=null,this.m_prevActive=null,this.m_trueIndex={},this.m_headerDragState=!1,this.m_databodyDragState=!1,this.m_databodyMove=!1,this.m_moveRow=null,this.m_moveRowHeader=null,this.m_dropTarget=null,this.m_dropTargetHeader=null,this.m_floodFillDragState=!1,this.m_dataTransferAction=null,this.m_discontiguousSelection=!1,this.m_selectionFrontier=null,this.m_docMouseMoveListener=null,this.m_docMouseUpListener=null,this.m_modelEvents=[],this.m_hasHorizontalScroller=null,this.m_hasVerticalScroller=null,this.m_currentScrollLeft=null,this.m_currentScrollTop=null,this.m_prevScrollLeft=null,this.m_prevScrollTop=null,this.m_handleScrollOverflow=null,this._clearScrollPositionTimeout(),this._requiresInitPostScrollFillViewport=!1,this.m_resizing=!1,this.m_resizingElement=null,this.m_resizingElementSibling=null,this.m_resizingElementMin=null,this.m_startRow=null,this.m_startCol=null,this.m_endRow=null,this.m_endCol=null,this.m_startRowPixel=null,this.m_startColPixel=null,this.m_endRowPixel=null,this.m_endColPixel=null,this.m_startRowHeader=null,this.m_startColHeader=null,this.m_endRowHeader=null,this.m_endColHeader=null,this.m_startRowHeaderPixel=null,this.m_startColHeaderPixel=null,this.m_endRowHeaderPixel=null,this.m_endColHeaderPixel=null,this.m_rowHeaderLevelCount=null,this.m_columnHeaderLevelCount=null,this.m_startRowEndHeader=null,this.m_startColEndHeader=null,this.m_endRowEndHeader=null,this.m_endColEndHeader=null,this.m_startRowEndHeaderPixel=null,this.m_startColEndHeaderPixel=null,this.m_endRowEndHeaderPixel=null,this.m_endColEndHeaderPixel=null,this.m_rowEndHeaderLevelCount=null,this.m_columnEndHeaderLevelCount=null,this.m_sortColumnInfo=null,this.m_sortRowInfo=null,this.m_expandCollapseInfo=null,this.m_resizeRequired=null,this.m_externalFocus=null,this.m_currentMode=null,this.m_editMode=null,this.m_hasCells=null,this.m_hasRowHeader=null,this.m_hasRowEndHeader=null,this.m_hasColHeader=null,this.m_hasColEndHeader=null,this.m_isLongScroll=null,this.m_longScrollRow=null,this.m_longScrollColumn=null,this.m_longScrollRowPixel=null,this.m_longScrollColumnPixel=null,this.m_addBorderBottom=null,this.m_addBorderRight=null,this.m_sortContainerWidth=null,this.m_sortContainerHeight=null,this._resetSkeletonProperties(),this._destroyEditableClone(),this._clearFocusoutTimeout(),this._clearFocusoutBusyState()},A.prototype._shouldInitialize=function(){return this.isFetchComplete()&&!this.m_initialized&&null!=this.m_databody.parentNode},A.prototype._handleInitialization=function(e){!0===e?(this.resizeGrid(),this._databodyEmptyState()||0!==this.m_startRow||0!==this.m_startCol?this._requiresInitPostScrollFillViewport=!0:this.fillViewport(),this.isFetchComplete()&&(this._updateActive(this.m_options.getCurrentCell(),!!this.m_focusOnRefresh,!0),this.m_initialized=!0,this.fireEvent("ready",{}),this._runModelEventQueue())):(this.m_initialized=!0,this.fireEvent("ready",{}),this._runModelEventQueue())},A.prototype._runModelEventQueue=function(){var e;if(null!=this.m_modelEvents){if(this.m_processingEventQueue=!0,0===this.m_modelEvents.length)return void(this.m_processingEventQueue=!1);"expand"===(e=this.m_modelEvents.shift()).operation?this.handleExpandEvent(e,!0):"collapse"===e.operation?this.handleCollapseEvent(e,!0):this.handleModelEvent(e,!0)}else this.m_processingEventQueue=!1},A.prototype.render=function(e){this.m_renderCount+=1,this.m_timingStart=new Date,this.m_fetching={},this.m_startRow=0,this.m_startCol=0,this.m_endRow=-1,this.m_endCol=-1,this.m_startRowPixel=0,this.m_startColPixel=0,this.m_endRowPixel=0,this.m_endColPixel=0,this.m_startRowHeader=0,this.m_startColHeader=0,this.m_endRowHeader=-1,this.m_endColHeader=-1,this.m_startRowHeaderPixel=0,this.m_startColHeaderPixel=0,this.m_endRowHeaderPixel=0,this.m_endColHeaderPixel=0,this.m_startRowEndHeader=0,this.m_startColEndHeader=0,this.m_endRowEndHeader=-1,this.m_endColEndHeader=-1,this.m_startRowEndHeaderPixel=0,this.m_startColEndHeaderPixel=0,this.m_endRowEndHeaderPixel=0,this.m_endColEndHeaderPixel=0,this.m_currentScrollLeft=0,this.m_currentScrollTop=0,this.m_prevScrollLeft=0,this.m_prevScrollTop=0,this.m_handleScrollOverflow=!1,this.m_rowHeaderLevelWidths=[],this.m_rowEndHeaderLevelWidths=[],this.m_columnHeaderLevelHeights=[],this.m_columnEndHeaderLevelHeights=[],this.m_frozenColIndex=null,this.m_frozenRowIndex=null,this._resetSkeletonProperties();var t=this._loadTemplateEngine();t?(this._signalTaskStart("loading template engine"),t.then(()=>{this._signalTaskEnd(),this.m_renderCount-=1,0===this.m_renderCount&&this.buildGrid(e)})):(this.m_renderCount-=1,this.buildGrid(e))},A.prototype._loadTemplateEngine=function(){var e=this._getSlotMap();if(this._isDataGridProvider()&&Object.keys(e).length>1||null==this.getDataSource()&&Object.keys(e).length>0){var t={customElement:this.m_customElement};return new Promise(e=>{g.__getTemplateEngine(t).then(t=>{this.m_engine=t,e(t)},function(e){throw new Error("Error loading template engine: "+e)})})}return null},A.prototype._getTemplateEngine=function(){return this.m_engine},A.prototype._cleanTemplateNodes=function(e){var t=this._getTemplateEngine();null!=t&&t.clean(e,this.m_root)},A.prototype._isDataGridProvider=function(){return this.m_options.options.data&&this.m_options.options.data.fetchByOffset&&!this.m_options.options.data.fetchFirst},A.prototype._getSlotMap=function(){return f.CustomElementUtils.getSlotMap(this.m_root)},A.prototype._getItemTemplateBySlotName=function(e){var t=this._getSlotMap()[e];return t&&t.length>0&&"template"===t[0].tagName.toLowerCase()?t[0]:null},A.prototype.buildGrid=function(e){this.m_root=e,this.m_root.setAttribute("role","application"),this._isCellEditable()?this.m_utils.addCSSClassName(this.m_root,this.getMappedStyle("editable")):this.m_utils.addCSSClassName(this.m_root,this.getMappedStyle("readOnly")),this.setDefaultDimensions(),e.tabIndex=0;var t=this.buildStatus();e.appendChild(t),this.m_status=t;var i=this.buildAccSummary();e.appendChild(i),this.m_accSummary=i;var s=this.buildAccInfo();e.appendChild(s),this.m_accInfo=s;var n=this.buildStateInfo();e.appendChild(n),this.m_stateInfo=n;var o=this.buildContextInfo();e.appendChild(o),this.m_contextInfo=o;var r=this.buildPlaceHolder();if(e.appendChild(r),this.m_placeHolder=r,this.m_headerLabels={row:[],column:[],rowEnd:[],columnEnd:[]},null!=this.getDataSource()){this.m_empty=null;var l=this.getResources().isRTLMode(),a=this.buildHeaders("column",this.getMappedStyle("colheader"),this.getMappedStyle("colendheader")),h=a.root,d=a.endRoot;let i=a.frozenHeader,s=a.frozenEndHeader;e.insertBefore(h,t),e.insertBefore(d,t),i&&e.insertBefore(i,t),s&&e.insertBefore(s,t);var m=(a=this.buildHeaders("row",this.getMappedStyle("rowheader"),this.getMappedStyle("rowendheader"))).root,c=a.endRoot;const n=a.frozenHeader,o=a.frozenEndHeader;e.insertBefore(m,t),e.insertBefore(c,t),n&&e.insertBefore(n,t),o&&e.insertBefore(o,t);const r=this.buildDatabody();for(let i=0;i<r.length;i++)e.insertBefore(r[i],t);const _=r[0];if(l&&(h.style.direction="rtl",_.style.direction="rtl"),this.m_isResizing=!1,this.m_resizingElement=null,this.m_resizingElementMin=null,this.m_databodyDragState=!1,this.m_docMouseMoveListener=this.handleMouseMove.bind(this),this.m_docMouseUpListener=this.handleMouseUp.bind(this),this.m_utils.isTouchDevice())_.addEventListener("touchstart",this.handleTouchStart.bind(this),{passive:!0}),_.addEventListener("touchmove",this.handleTouchMove.bind(this),{passive:!1}),_.addEventListener("touchend",this.handleTouchEnd.bind(this),!1),_.addEventListener("touchcancel",this.handleTouchCancel.bind(this),!1),h.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),h.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),h.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),h.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1),m.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),m.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),m.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),m.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1),d.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),d.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),d.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),d.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1),c.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),c.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),c.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),c.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1);else{var u=this.m_utils.getMousewheelEvent();_.addEventListener(u,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),_.addEventListener("mousedown",this.handleDatabodyMouseDown.bind(this),!1),_.addEventListener("mousemove",this.handleDatabodyMouseMove.bind(this),!1),_.addEventListener("mouseup",this.handleDatabodyMouseUp.bind(this),!1),_.addEventListener("mouseout",this.handleDatabodyMouseOut.bind(this),!1),_.addEventListener("mouseover",this.handleDatabodyMouseOver.bind(this),!1),_.addEventListener("dblclick",this.handleDatabodyDoubleClick.bind(this),!1),m.addEventListener(u,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),h.addEventListener(u,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),m.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),h.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),m.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),h.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),m.addEventListener("mousemove",this.handleRowHeaderMouseMove.bind(this),!1),h.addEventListener("mousemove",this.handleColumnHeaderMouseMove.bind(this),!1),m.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),h.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),m.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),h.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),m.addEventListener("click",this.handleHeaderClick.bind(this),!1),m.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1),h.addEventListener("click",this.handleHeaderClick.bind(this),!1),h.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1),c.addEventListener(u,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),d.addEventListener(u,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),c.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),d.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),c.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),d.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),c.addEventListener("mousemove",this.handleRowHeaderMouseMove.bind(this),!1),d.addEventListener("mousemove",this.handleColumnHeaderMouseMove.bind(this),!1),c.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),d.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),c.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),d.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),c.addEventListener("click",this.handleHeaderClick.bind(this),!1),c.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1),d.addEventListener("click",this.handleHeaderClick.bind(this),!1),d.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1)}this._addDnDEventListener(m,c,h,d,_),this._addListenersOnFrozenSections(n,o,i,s),this._shouldInitialize()&&this._handleInitialization(!0)}else{var _=this._buildEmptyText();this.m_databody.firstChild.appendChild(_),this._handleInitialization(!1)}},A.prototype._addDnDEventListener=function(e,t,i,s,n){e&&(e.addEventListener("drag",this.handleRowDrag.bind(this),!1),e.addEventListener("dragstart",this.handleDragStart.bind(this),!1),e.addEventListener("dragend",this.handleRowDragEnd.bind(this),!1),e.addEventListener("dragover",this.handleRowDragOver.bind(this),!1),e.addEventListener("dragenter",this.handleRowDragEnter.bind(this),!1),e.addEventListener("dragleave",this.handleRowDragLeave.bind(this),!1),e.addEventListener("drop",this.handleRowDrop.bind(this),!1)),i&&(i.addEventListener("dragstart",this.handleDragStart.bind(this),!1),i.addEventListener("dragend",this.handleColumnDragEnd.bind(this),!1),i.addEventListener("dragover",this.handleColumnDragOver.bind(this),!1),i.addEventListener("dragenter",this.handleColumnDragEnter.bind(this),!1),i.addEventListener("dragleave",this.handleColumnDragLeave.bind(this),!1),i.addEventListener("drop",this.handleColumnDrop.bind(this),!1)),t&&(t.addEventListener("drag",this.handleRowDrag.bind(this),!1),t.addEventListener("dragstart",this.handleDragStart.bind(this),!1),t.addEventListener("dragend",this.handleRowDragEnd.bind(this),!1),t.addEventListener("dragover",this.handleRowDragOver.bind(this),!1),t.addEventListener("dragenter",this.handleRowDragEnter.bind(this),!1),t.addEventListener("dragleave",this.handleRowDragLeave.bind(this),!1),t.addEventListener("drop",this.handleRowDrop.bind(this),!1)),s&&(s.addEventListener("dragstart",this.handleDragStart.bind(this),!1),s.addEventListener("dragend",this.handleColumnDragEnd.bind(this),!1),s.addEventListener("dragover",this.handleColumnDragOver.bind(this),!1),s.addEventListener("dragenter",this.handleColumnDragEnter.bind(this),!1),s.addEventListener("dragleave",this.handleColumnDragLeave.bind(this),!1),s.addEventListener("drop",this.handleColumnDrop.bind(this),!1)),n&&(n.addEventListener("dragover",this.handleDatabodyDragOver.bind(this),!1),n.addEventListener("dragenter",this.handleDatabodyDragEnter.bind(this),!1),n.addEventListener("drop",this.handleDatabodyDrop.bind(this),!1))},A.prototype._addListenersOnFrozenSections=function(e,t,i,s){const n=this.m_utils.getMousewheelEvent();let o=[this.m_databodyFrozenCorner,this.m_databodyFrozenCol,this.m_databodyFrozenRow];o=o.filter(e=>e);for(let e=0;e<o.length;e++){let t=o[e];this.m_utils.isTouchDevice()?(t.addEventListener("touchstart",this.handleTouchStart.bind(this),{passive:!0}),t.addEventListener("touchmove",this.handleTouchMove.bind(this),{passive:!1}),t.addEventListener("touchend",this.handleTouchEnd.bind(this),!1),t.addEventListener("touchcancel",this.handleTouchCancel.bind(this),!1)):(t.addEventListener(n,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),t.addEventListener("mousedown",this.handleDatabodyMouseDown.bind(this),!1),t.addEventListener("mousemove",this.handleDatabodyMouseMove.bind(this),!1),t.addEventListener("mouseup",this.handleDatabodyMouseUp.bind(this),!1),t.addEventListener("mouseout",this.handleDatabodyMouseOut.bind(this),!1),t.addEventListener("mouseover",this.handleDatabodyMouseOver.bind(this),!1),t.addEventListener("dblclick",this.handleDatabodyDoubleClick.bind(this),!1),t.addEventListener("dragover",this.handleDatabodyDragOver.bind(this),!1),t.addEventListener("dragenter",this.handleDatabodyDragEnter.bind(this),!1),t.addEventListener("drop",this.handleDatabodyDrop.bind(this),!1))}e&&(this.m_utils.isTouchDevice()?(e.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),e.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),e.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),e.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1)):(e.addEventListener(n,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),e.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),e.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),e.addEventListener("mousemove",this.handleRowHeaderMouseMove.bind(this),!1),e.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),e.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),e.addEventListener("click",this.handleHeaderClick.bind(this),!1),e.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1))),i&&(this.m_utils.isTouchDevice()?(i.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),i.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),i.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),i.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1)):(i.addEventListener(n,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),i.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),i.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),i.addEventListener("mousemove",this.handleColumnHeaderMouseMove.bind(this),!1),i.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),i.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),i.addEventListener("click",this.handleHeaderClick.bind(this),!1),i.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1))),t&&(this.m_utils.isTouchDevice()?(t.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),t.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),t.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),t.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1)):(t.addEventListener(n,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),t.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),t.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),t.addEventListener("mousemove",this.handleRowHeaderMouseMove.bind(this),!1),t.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),t.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),t.addEventListener("click",this.handleHeaderClick.bind(this),!1),t.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1))),s&&(this.m_utils.isTouchDevice()?(s.addEventListener("touchstart",this.handleHeaderTouchStart.bind(this),{passive:!0}),s.addEventListener("touchmove",this.handleHeaderTouchMove.bind(this),{passive:!1}),s.addEventListener("touchend",this.handleHeaderTouchEnd.bind(this),!1),s.addEventListener("touchcancel",this.handleHeaderTouchCancel.bind(this),!1)):(s.addEventListener(n,this.handleDatabodyMouseWheel.bind(this),{passive:!1}),s.addEventListener("mousedown",this.handleHeaderMouseDown.bind(this),!1),s.addEventListener("mouseover",this.handleHeaderMouseOver.bind(this),!1),s.addEventListener("mousemove",this.handleColumnHeaderMouseMove.bind(this),!1),s.addEventListener("mouseup",this.handleHeaderMouseUp.bind(this),!1),s.addEventListener("mouseout",this.handleHeaderMouseOut.bind(this),!1),s.addEventListener("click",this.handleHeaderClick.bind(this),!1),s.addEventListener("dblclick",this.handleHeaderDoubleClick.bind(this),!1))),this._addDnDEventListener(e,t,i,s)},A.prototype.HandleResize=function(e,t){e=this.getRootElement().clientWidth,t=this.getRootElement().clientHeight,e===this.m_width&&t===this.m_height||(this.m_width=e,this.m_height=t,this.m_rowFetchSize=null,this.m_columnFetchSize=null,this.m_initialized&&(this.resizeGrid(),this.isFetchComplete()&&(this.m_resizeRequired=!0,this.fillViewport())))},A.prototype.resizeGrid=function(){var e=this.getWidth(),t=this.getHeight(),i=this.m_colHeader,s=this.m_colEndHeader,n=this.m_rowHeader,o=this.m_rowEndHeader,r=this.m_databody,l=r.firstChild;const a=this.m_databodyFrozenCol,h=this.m_databodyFrozenRow;let d=0,m=0;var c=this.getColumnHeaderHeight(),u=this.getColumnEndHeaderHeight(),_=this.getRowHeaderWidth(),p=this.getRowEndHeaderWidth();a&&(d=this.getElementWidth(a)),h&&(m=this.getElementHeight(h)),this._hasFrozenColumns()&&this._hasFrozenRows()&&(d||(d=this.getElementWidth(this.m_databodyFrozenCorner)),m||(m=this.getElementHeight(this.m_databodyFrozenCorner))),this.m_headerLabels.row&&this.m_headerLabels.row.length&&0===c&&(c=this._getCellDimension(this.m_headerLabels.row[0],0,null,"column","height"),this.m_colHeaderHeight=c),this.m_headerLabels.column&&this.m_headerLabels.column.length&&0===_&&(_=this._getCellDimension(this.m_headerLabels.column[0],0,null,"row","width"),this.m_rowHeaderWidth=_);var g,f,C,y=t-c-u-m,E=e-_-p-d,v=this.m_utils.getScrollbarSize();this._databodyEmpty()&&(null==this.m_empty?(g=this._buildEmptyText(),f=this.getElementHeight(g),C=this.getElementWidth(g),l=r.firstChild,f>this.getElementHeight(l)&&this.setElementHeight(l,Math.max(f,y)),C>this.getElementWidth(l)&&this.setElementWidth(l,Math.max(C,E)),this.m_databody.firstChild.appendChild(g)):g=this.m_empty);var w,b,H,x,S,R=this.getElementWidth(r.firstChild),I=this.getElementHeight(r.firstChild),M=this.isDatabodyHorizontalScrollbarRequired(E);if(M)w=this.isDatabodyVerticalScrollbarRequired(y-v),r.style.overflow="auto";else if(w=this.isDatabodyVerticalScrollbarRequired(y))M=this.isDatabodyHorizontalScrollbarRequired(E-v),r.style.overflow="auto";else{this.m_handleScrollOverflow=!1;var F=this;setTimeout(function(){F.m_handleScrollOverflow||F.m_hasVerticalScroller||F.m_hasHorizontalScroller||(r.style.overflow="hidden",F.m_handleScrollOverflow=!0)},10)}this.m_hasHorizontalScroller=M,this.m_hasVerticalScroller=w,-1!==this.m_endColEndHeader?(b=Math.min(I+(M?v:0),y),H=M?b-v:b):(b=y,H=Math.min(I,M?b-v:b)),-1!==this.m_endRowEndHeader?(x=Math.min(R+(w?v:0),E),S=w?x-v:x):(x=E,S=Math.min(R,w?x-v:x));var z=_+S+d+(w?v:0),D=c+H+m+(M?v:0),A=this.getResources().isRTLMode()?"right":"left";this.setElementDir(n,0,A),this.setElementDir(n,c,"top"),this.setElementHeight(n,H),this.setElementDir(o,z,A),this.setElementDir(o,c,"top"),this.setElementHeight(o,H),this.setElementDir(i,_,A),this.setElementWidth(i,S),this.setElementDir(s,_,A),this.setElementDir(s,D,"top"),this.setElementWidth(s,S),[_,c]=this._setFrozenContainerDimension(x,b,_,p,c,u),this.setElementDir(r,c,"top"),this.setElementDir(r,_,A),this.setElementWidth(r,x),this.setElementHeight(r,b),this.m_scrollWidth=R-S,this.m_scrollHeight=I-H,this.buildCorners(),this._adjustHeaderBorders(),this._updateGridlines(),this.m_resizeRequired=!1},A.prototype._sizeDatabodyScroller=function(){var e=this.m_databody,t=e.firstChild,i=0,s=0;this._databodyEmptyState()?(i=Math.max(Math.max(this.m_endRowHeaderPixel,this.m_endRowEndHeaderPixel),1),s=Math.max(Math.max(this.m_endColHeaderPixel,this.m_endColEndHeaderPixel),1)):(i=this.m_endRowPixel,s=this.m_endColPixel),this._setScrollerDimension(t,i,s),this.m_initialized&&(this.m_scrollWidth=this.getElementWidth(t)-Math.min(this.getElementWidth(t),this.getElementWidth(e)-(this.m_hasVerticalScroller?this.m_utils.getScrollbarSize():0)),this.m_scrollHeight=this.getElementHeight(t)-Math.min(this.getElementHeight(t),this.getElementHeight(e)-(this.m_hasHorizontalScroller?this.m_utils.getScrollbarSize():0)))},A.prototype._setScrollerDimension=function(e,t,i){let s=this._isHighWatermarkScrolling(),n=this.m_utils._getMaxDivHeightForScrolling(),o=this.m_utils._getMaxDivWidthForScrolling(),r=this.getDataSource().getCount("row"),l=this.getDataSource().getCount("column"),a=0,h=0;a=-1===r||s?t:r*this.m_avgRowHeight,h=-1===l||s?i:l*this.m_avgColWidth,this.setElementHeight(e,Math.min(n,a)),this.setElementWidth(e,Math.min(o,h))},A.prototype._adjustLastHeadersAlongAxis=function(e,t,i,s,n,o,r){for(var l=0;l<t;){let t=this._getHeaderByIndex(e,r,l);o?this.m_utils.removeCSSClassName(t,n):this.m_utils.addCSSClassName(t,n),l+=this.getHeaderCellDepth(t)}},A.prototype._adjustHeaderBordersAlongAxis=function(e,t,i,s,n,o,r,l,a){null!=e&&i>=0&&(s?this.m_utils.addCSSClassName(n,o):this.m_utils.removeCSSClassName(n,o),t(i)&&this._adjustLastHeadersAlongAxis(i,r,e,l,o,s,a))},A.prototype._adjustHeaderBorders=function(){var e,t,i,s,n,o=this.m_utils.getScrollbarSize(),r=this.getWidth(),l=this.getHeight(),a=this.getColumnHeaderHeight(),h=this.getElementWidth(this.m_colHeader),d=this.getColumnEndHeaderHeight(),m=this.getRowHeaderWidth(),c=this.getElementHeight(this.m_rowHeader),u=m+h+this.getRowEndHeaderWidth()+(this.m_hasVerticalScroller?o:0)<r,_=a+c+d+(this.m_hasHorizontalScroller?o:0)<l;if(u&&this.m_endRowEndHeader>=0?(e=!0,this.m_addBorderRight=!0):!0===this.m_addBorderRight&&(e=!1),null!=e)for(t=this.getMappedStyle("borderVerticalSmall"),null!=this.m_columnHeaderScrollbarSpacer&&(e?this.m_utils.addCSSClassName(this.m_columnHeaderScrollbarSpacer,t):this.m_utils.removeCSSClassName(this.m_columnHeaderScrollbarSpacer,t)),null!=this.m_bottomCorner&&(e?this.m_utils.addCSSClassName(this.m_bottomCorner,t):this.m_utils.removeCSSClassName(this.m_bottomCorner,t)),s=Array.from(this.m_rowEndHeader.firstChild.childNodes),this.m_rowEndHeaderFrozen?.firstChild?.childNodes?.length&&s.push(...this.m_rowEndHeaderFrozen.firstChild.childNodes),i=0;i<s.length;i++)e?this.m_utils.addCSSClassName(s[i],t):this.m_utils.removeCSSClassName(s[i],t);else{t=this.getMappedStyle("borderVerticalNone"),n=this._isLastColumn.bind(this);let e=this.m_startColHeader,i=this.m_startColEndHeader;this._hasFrozenColumns()&&(e=this.m_frozenColIndex+1,i=e),this._adjustHeaderBordersAlongAxis(this.m_colHeader,n,this.m_endColHeader,u,this.m_columnHeaderScrollbarSpacer,t,this.m_columnHeaderLevelCount,e,"column"),this._adjustHeaderBordersAlongAxis(this.m_colEndHeader,n,this.m_endColEndHeader,u,this.m_bottomCorner,t,this.m_columnEndHeaderLevelCount,i,"columnEnd")}if(e=null,_&&this.m_endColEndHeader>=0?(this.m_addBorderBottom=!0,e=!0):!0===this.m_addBorderBottom&&(e=!1),null!=e){t=this.getMappedStyle("borderHorizontalSmall"),null!=this.m_rowHeaderScrollbarSpacer&&(e?this.m_utils.addCSSClassName(this.m_rowHeaderScrollbarSpacer,t):this.m_utils.removeCSSClassName(this.m_rowHeaderScrollbarSpacer,t)),null!=this.m_bottomCorner&&(e?this.m_utils.addCSSClassName(this.m_bottomCorner,t):this.m_utils.removeCSSClassName(this.m_bottomCorner,t)),s=Array.from(this.m_colEndHeader.firstChild.childNodes),this.m_colEndHeaderFrozen?.firstChild?.childNodes?.length&&s.push(...this.m_colEndHeaderFrozen.firstChild.childNodes);const n=this.getMappedStyle("groupingcontainer");for(i=0;i<s.length;i++){let o=s[i];o.classList.contains(n)&&(o=o.firstChild),e?this.m_utils.addCSSClassName(o,t):this.m_utils.removeCSSClassName(o,t)}}else{t=this.getMappedStyle("borderHorizontalNone"),n=this._isLastRow.bind(this);let e=this.m_startRowHeader,i=this.m_startRowEndHeader;null!==this.m_frozenRowIndex&&(e=this.m_frozenRowIndex+1,i=e),this._adjustHeaderBordersAlongAxis(this.m_rowHeader,n,this.m_endRowHeader,_,this.m_rowHeaderScrollbarSpacer,t,this.m_rowHeaderLevelCount,e,"row"),this._adjustHeaderBordersAlongAxis(this.m_rowEndHeader,n,this.m_endRowEndHeader,_,this.m_bottomCorner,t,this.m_rowEndHeaderLevelCount,i,"rowEnd")}},A.prototype._isHeaderLabelCollision=function(){return this.m_headerLabels.column[this.m_columnHeaderLevelCount-1]&&this.m_headerLabels.row[this.m_rowHeaderLevelCount-1]},A.prototype.buildCorners=function(){var e,t,i,s,n=this.m_utils.getScrollbarSize(),o=this.getWidth(),r=this.getHeight(),l=this.getColumnHeaderHeight(),a=this.getElementWidth(this.m_colHeader),h=this.getColumnEndHeaderHeight(),d=this.getRowHeaderWidth(),m=this.getRowEndHeaderWidth(),c=this.getElementHeight(this.m_rowHeader),u=this.getResources().isRTLMode()?"right":"left";let _,p,g,f,C,y,E=!0,v=l,w=d,b=0,H=0;const x=this.m_databodyFrozenCol,S=this.m_databodyFrozenRow;if(x&&(b=this.getElementWidth(x)),S&&(H=this.getElementHeight(S)),-1!==this.m_endRowHeader&&-1!==this.m_endColHeader?(p=this.m_headerLabels.column.length?this.m_columnHeaderLevelHeights[this.m_columnHeaderLevelCount-1]:this.m_colHeaderHeight,_=this.m_headerLabels.row.length?this.m_rowHeaderLevelWidths[this.m_rowHeaderLevelCount-1]:this.m_rowHeaderWidth,C=c+l+H,y=h+(this.m_hasHorizontalScroller?n:0),g=d+a+b,f=m+(this.m_hasVerticalScroller?n:0)):-1!==this.m_endRowHeader&&-1===this.m_endColHeader?(p=l,C=c+l+H,y=h+(this.m_hasHorizontalScroller?n:0),g=d,f=m+a+b+(this.m_hasVerticalScroller?n:0)):-1===this.m_endRowHeader&&-1!==this.m_endColHeader?(_=d,C=l,y=h+c+H+(this.m_hasHorizontalScroller?n:0),g=d+a+b,f=m+(this.m_hasVerticalScroller?n:0)):E=!1,E){if(null!=this.m_corner?e=this.m_corner:((e=document.createElement("div")).id=this.createSubId("corner"),e.className=this.getMappedStyle("topcorner")),this.setElementWidth(e,d),this.setElementHeight(e,l),null==this.m_corner){if(this._attachEventListenersOnCorner(e),this.m_root.appendChild(e),this.m_corner=e,p)for(s=0;s<this.m_headerLabels.row.length;s++)null!=(i=this.m_headerLabels.row[s])&&(this.setElementHeight(i,p),e.appendChild(i));if(_)for(s=0;s<this.m_headerLabels.column.length;s++)null!=(i=this.m_headerLabels.column[s])&&(this.setElementWidth(i,_),e.appendChild(i));if(this.m_subtreeAttachedCallback(e),this._isHeaderLabelCollision()){let e=this.m_headerLabels.row[this.m_rowHeaderLevelCount-1],t=this.getElementHeight(e);return this.m_colHeaderHeight+=t,this.m_columnHeaderLevelHeights[this.m_columnHeaderLevelCount-1]+=t,this.resizeColumnHeightsAndShift(t,this.m_columnHeaderLevelCount-1,!1),this.setElementHeight(this.m_colHeader,this.m_colHeaderHeight),this.m_colHeaderFrozen&&this.setElementHeight(this.m_colHeaderFrozen,this.m_colHeaderHeight),void this.manageResizeScrollbars()}}else{this.m_utils.isTouchDevice()?(e.addEventListener("touchstart",this.handleHeaderLabelMouseDown.bind(this),!1),e.addEventListener("touchmove",this.handleHeaderLabelMouseMove.bind(this),!1)):(e.addEventListener("mousedown",this.handleHeaderLabelMouseDown.bind(this),!1),e.addEventListener("mousemove",this.handleHeaderLabelMouseMove.bind(this),!1))}this._buildCornerOnHeaderAxisDisabled("row",u,0,C,w,y),this._buildCornerOnHeaderAxisDisabled("column",u,g,0,f,v)}else this.m_headerLabels.row=[],this.m_headerLabels.column=[];null!=this.m_corner&&null==e&&(this.m_root.removeChild(this.m_corner),this.m_corner=null),(this.m_hasHorizontalScroller&&this.m_hasVerticalScroller||this.m_hasVerticalScroller&&-1!==this.m_endColEndHeader||this.m_hasHorizontalScroller&&-1!==this.m_endRowEndHeader||-1!==this.m_endRowEndHeader&&-1!==this.m_endColEndHeader)&&(null!=this.m_bottomCorner?t=this.m_bottomCorner:((t=document.createElement("div")).id=this.createSubId("bcorner"),t.className=this.getMappedStyle("bottomcorner")),this.setElementDir(t,c+l+H,"top"),this.setElementDir(t,d+a+b,u),-1!==this.m_endRowEndHeader?this.setElementWidth(t,m+(this.m_hasVerticalScroller?n:0)):this.setElementWidth(t,o-a-d-b),-1!==this.m_endColEndHeader?this.setElementHeight(t,h+(this.m_hasHorizontalScroller?n:0)):this.setElementHeight(t,r-c-l-H),null==this.m_bottomCorner&&(this.m_root.appendChild(t),this.m_bottomCorner=t)),null!=this.m_bottomCorner&&null==t&&(this.m_root.removeChild(this.m_bottomCorner),this.m_bottomCorner=null)},A.prototype._attachEventListenersOnCorner=function(e){this.m_utils.isTouchDevice()?e.addEventListener("touchstart",this.handleCornerMouseDown.bind(this),!1):(e.addEventListener("mousedown",this.handleCornerMouseDown.bind(this),!1),e.addEventListener("mouseover",this.handleCornerMouseOver.bind(this),!1),e.addEventListener("mouseout",this.handleCornerMouseOut.bind(this),!1)),this.m_options._isLabelCutEnabled()?this._attachDndListenersOnLabelSection(e):e.addEventListener("click",this.handleCornerClick.bind(this),!1)},A.prototype._attachDndListenersOnLabelSection=function(e){e.addEventListener("dragstart",this.handleCornerDragStart.bind(this),!1),e.addEventListener("dragend",this.handleCornerDragEnd.bind(this),!1),e.addEventListener("dragover",this.handleCornerDragOver.bind(this),!1),e.addEventListener("drop",this.handleCornerDrop.bind(this),!1),e.addEventListener("dragenter",this.handleCornerDragEnter.bind(this),!1)},A.prototype._buildCornerOnHeaderAxisDisabled=function(e,t,i,s,n,o){let r,l="column"===e?this.m_columnHeaderScrollbarSpacer:this.m_rowHeaderScrollbarSpacer,a=!1;if("column"===e?(this.m_hasVerticalScroller||-1!==this.m_endRowEndHeader)&&(a=!0,null!=this.m_columnHeaderScrollbarSpacer?r=this.m_columnHeaderScrollbarSpacer:(r=document.createElement("div"),r.id=this.createSubId("chSbSpacer"),r.className=this.getMappedStyle("colheaderspacer"))):"row"===e&&(this.m_hasHorizontalScroller||-1!==this.m_endColEndHeader)&&(a=!0,null!=this.m_rowHeaderScrollbarSpacer?r=this.m_rowHeaderScrollbarSpacer:(r=document.createElement("div"),r.id=this.createSubId("rhSbSpacer"),r.className=this.getMappedStyle("rowheaderspacer"))),a){let a,h;if(this.setElementDir(r,i,t),this.setElementDir(r,s,"top"),this.setElementWidth(r,n),this.setElementHeight(r,o),null==l){if(this.m_utils.isTouchDevice()?r.addEventListener("touchstart",this.handleCornerMouseDown.bind(this),{passive:!0}):(r.addEventListener("mousedown",this.handleCornerMouseDown.bind(this),!1),r.addEventListener("mouseover",this.handleCornerMouseOver.bind(this),!1),r.addEventListener("mouseout",this.handleCornerMouseOut.bind(this),!1),this._attachDndListenersOnLabelSection(r),"disable"!==this.isResizeEnabled()&&(r.addEventListener("mousedown",this.handleHeaderLabelMouseDown.bind(this),!1),r.addEventListener("mousemove",this.handleHeaderLabelMouseMove.bind(this),!1))),this.m_root.appendChild(r),"column"===e?(this.m_columnHeaderScrollbarSpacer=r,a=this.m_headerLabels.rowEnd):(this.m_rowHeaderScrollbarSpacer=r,a=this.m_headerLabels.columnEnd),a.length)for(let e=0;e<a.length;e++)h=a[e],null!=h&&r.appendChild(h);this.m_subtreeAttachedCallback(r)}}else"column"===e?(null!=this.m_columnHeaderScrollbarSpacer&&this.m_root.removeChild(this.m_columnHeaderScrollbarSpacer),this.m_columnHeaderScrollbarSpacer=null,this.m_headerLabels.rowEnd=[]):(null!=this.m_rowHeaderScrollbarSpacer&&this.m_root.removeChild(this.m_rowHeaderScrollbarSpacer),this.m_rowHeaderScrollbarSpacer=null,this.m_headerLabels.columnEnd=[])},A.prototype._updateScrollPosition=function(e){this._scrollToScrollPositionObject(e)},A.prototype._setScrollPosition=function(){this.m_setOptionCallback("scrollPosition",this._createScrollPositionObject(this.m_currentScrollLeft,this.m_currentScrollTop),{_context:{writeback:!0,internalSet:!0}})},A.prototype._clearScrollPositionKeys=function(){var e=this.m_options.getScrollPosition();e.rowKey=void 0,e.columnKey=void 0,this.m_setOptionCallback("scrollPosition",e,{_context:{internalSet:!0}})},A.prototype._createScrollPositionObject=function(e,t){var i={x:e,y:t},s=this.getResources().isRTLMode()?"right":"left",n=this._getCellAtPixel(e,t);if(null!=n)i.rowIndex=this._getIndex(n,"row"),i.columnIndex=this._getIndex(n,"column"),i.rowKey=this._getKey(n,"row"),i.columnKey=this._getKey(n,"column"),i.offsetX=e-this.getElementDir(n,s),i.offsetY=t-this.getElementDir(n,"top");else{var o=this._getHeaderAtPixel(t,"row");null!=o&&(i.rowIndex=this._getIndex(o),i.rowKey=this._getKey(o),i.offsetY=t-this.getElementDir(o,"top"));var r=this._getHeaderAtPixel(e,"column");null!=r&&(i.columnIndex=this._getIndex(r),i.columnKey=this._getKey(r),i.offsetX=e-this.getElementDir(r,s))}return i},A.prototype._getCellAtPixel=function(e,t){for(var i=this.m_databody.firstChild.querySelectorAll("."+this.getMappedStyle("cell")),s=this.getResources().isRTLMode()?"right":"left",n=0;n<i.length;n++){var o=i[n],r=this.getElementDir(o,s),l=r+this.getElementWidth(o);if(r<=e&&e<l){var a=this.getElementDir(o,"top"),h=a+this.getElementHeight(o);if(a<=t&&t<h)return o}}return null},A.prototype._getAxisInnerMostHeaders=function(e){var t,i,s=this.getMappedStyle("headercell");switch(e){case"row":t=this.m_rowHeader,i=this.m_rowHeaderLevelCount;break;case"column":t=this.m_colHeader,i=this.m_columnHeaderLevelCount;break;case"rowEnd":t=this.m_rowEndHeader,i=this.m_rowEndHeaderLevelCount;break;case"columnEnd":t=this.m_colEndHeader,i=this.m_columnEndHeaderLevelCount}var n=[];if(t)for(var o=t.getElementsByClassName(s),r=0;r<o.length;r++){var l=o[r],a=l[this.getResources().getMappedAttribute("context")];a.level+a.depth===i&&n.push(l)}return n},A.prototype._getHeaderAtPixel=function(e,t){var i,s,n,o,r=this;function l(t){for(var i=0;i<t.length;i++){var s=t[i],l=r.getElementDir(s,n),a=l+r.getElementDir(s,o);if(l<=e&&e<a)return s}}i=this._getAxisInnerMostHeaders(t),s=this._getAxisInnerMostHeaders(t+"End"),"row"===t?(n="top",o="height"):"column"===t&&(n=this.getResources().isRTLMode()?"right":"left",o="width");var a=l(i);return null==a&&(a=l(s)),a},A.prototype._checkScrollPosition=function(){null!=this.m_desiredScrollPositionObject?this._scrollToScrollPositionObject(this.m_desiredScrollPositionObject):this._setScrollPosition()},A.prototype._areKeysLocallyAvailable=function(e,t){var i=!0;return e&&null==this._getCellOrHeaderByKey(e,"row")&&(i=!1),t&&null==this._getCellOrHeaderByKey(t,"column")&&(i=!1),i},A.prototype._scrollToScrollPositionObject=function(e){var t=e.x,i=e.y,s=e.rowIndex,n=e.columnIndex,o=e.rowKey,r=e.columnKey,l=e.offsetX?e.offsetX:0,a=e.offsetY?e.offsetY:0,h=this.getResources().isRTLMode()?"right":"left",d=this.m_options.getScrollToKey();if("never"!==d||!o&&!r){if("always"!==d)if(this.getDataSource()instanceof x&&!this._areKeysLocallyAvailable(o,r)){var m=this.m_options.getProperty("data").getCapability("fetchFirst");if(null==m||"immediate"!==m.iterationSpeed)return}var c=this;this._getIndexFromKeyPromise(o,r).then(function(d){var m=Math.floor(c._getPositionEstimate("column",h,r,d.columnIndexFromKey,n,t,l,c.m_currentScrollLeft,c._getMaxRightPixel(),c.m_avgColWidth)),u=Math.floor(c._getPositionEstimate("row","top",o,d.rowIndexFromKey,s,i,a,c.m_currentScrollTop,c._getMaxBottomPixel(),c.m_avgRowHeight));m!==c.m_currentScrollLeft&&(c.m_currentScrollLeft!==c.m_scrollWidth||m<c.m_currentScrollLeft)||u!==c.m_currentScrollTop&&(c.m_currentScrollTop!==c.m_scrollHeight||u<c.m_currentScrollTop)?(null==c.m_desiredScrollPositionObject&&c._signalTaskStart("begin scrolling to new desired location"),c.m_desiredScrollPositionObject=e,c._setScrollPositionTimeout(),c._initiateScroll(m,u),c._requiresInitPostScrollFillViewport=!1):(null!=c.m_desiredScrollPositionObject&&c._signalTaskEnd("reached desired location"),c.m_desiredScrollPositionObject=null,c._setScrollPosition(),c._requiresInitPostScrollFillViewport&&(c._requiresInitPostScrollFillViewport=!1,c.fillViewport()))})}},A.prototype._setScrollPositionTimeout=function(){this.m_utils.isTouchDeviceNotIOS()||(this.pendingScrollTimeout=setTimeout(function(){null!=this.m_desiredScrollPositionObject&&this._signalTaskEnd("reached desired location"),this.m_desiredScrollPositionObject=null,this._setScrollPosition()}.bind(this),300))},A.prototype._clearScrollPositionTimeout=function(){null!=this.pendingScrollTimeout&&(clearTimeout(this.pendingScrollTimeout),this.pendingScrollTimeout=null)},A.prototype._getPositionEstimate=function(e,t,i,s,n,o,r,l,a,h){var d,m,c=this._isHighWatermarkScrolling();return null!=i&&-1!==s&&(null!=(m=this._getCellOrHeaderByKey(i,e))?d=this.getElementDir(m,t)+r:c?d=a:null!=s&&(d=h*s+r),null!=d)?d:d=null!=n?null!=(m=this._getCellOrHeaderByIndex(n,e))?this.getElementDir(m,t)+r:c?a:h*n:null!=o?o:l},A.prototype.isDatabodyHorizontalScrollbarRequired=function(e){var t=this.m_databody.firstChild;return this.getElementWidth(t)>e},A.prototype.isDatabodyVerticalScrollbarRequired=function(e){var t=this.m_databody.firstChild;return this.getElementHeight(t)>e},A.prototype.buildStatus=function(){var e=document.createElement("div");return e.id=this.createSubId("status"),e.className=this.getMappedStyle("status"),e.setAttribute("role","status"),e},A.prototype.buildAccInfo=function(){var e=document.createElement("div");return e.id=this.createSubId("info"),e.className=this.getMappedStyle("info"),e.setAttribute("role","status"),e},A.prototype.buildAccSummary=function(){var e=document.createElement("div");return e.id=this.createSubId("summary"),e.className=this.getMappedStyle("info"),e},A.prototype.buildStateInfo=function(){var e=document.createElement("div");return e.id=this.createSubId("state"),e.className=this.getMappedStyle("info"),e},A.prototype.buildContextInfo=function(){var e=document.createElement("div");return e.id=this.createSubId("context"),e.className=this.getMappedStyle("info"),e},A.prototype.buildPlaceHolder=function(){var e=document.createElement("div");return e.id=this.createSubId("placeHolder"),e.className=this.getMappedStyle("info"),e},A.prototype.populateAccInfo=function(){var e=this.getResources().getTranslatedText("accessibleSummaryExact",{rownum:this.m_endRow+1,colnum:this.m_endCol+1});this.getDataSource().getExpandedKeys&&(e=e+". "+this.getResources().getTranslatedText("accessibleSummaryExpanded",{num:this.getDataSource().getExpandedKeys().length}));e+=". ",this.m_accSummary.textContent=e},A.prototype.SetAccessibleContext=function(e){if(null!=e&&(null!=e.context&&(this.m_accessibleContext=e.context),null!=e.state&&(this.m_stateInfo.textContent=e.state),null!=e.ancestors&&this._isDatabodyCellActive())){var t="",i=e.ancestors,s=this.m_active.indexes.column;if(null!=s&&s>=0)for(var n=0;n<i.length;n++){n>0&&(t=t.concat(", "));var o=i[n],r=this._getAxisCellsByKey(o.key,"row");if(null!=r){var l=r[0].textContent;l=null!=l?l.replace(/\n|<br\s*\/?>/gi,"").trim():"",t=t.concat(o.label).concat(" ").concat(l)}}this.m_accessibleContext=t.concat(", ").concat(this.m_accessibleContext)}},A.prototype._updateStateInfo=function(e){for(var t=". ",i=0;i<e.length;i++){var s=this.getResources().getTranslatedText(e[i].key,e[i].args);null!=s&&(t=2===t.length?t+s:t+", "+s)}t=2===t.length?t:t+". ",this.m_stateInfo.textContent=t},A.prototype._updateContextInfo=function(e,t){var i,s;e.indexes&&(i=e.indexes.row,s=e.indexes.column);var n=e.level,o=e.rowHeader,r=e.rowEndHeader,l=e.columnHeader,a=e.columnEndHeader,h=e.rowHeaderLabel,d=e.rowEndHeaderLabel,m=e.columnHeaderLabel,c=e.columnEndHeaderLabel,u="";null!=this.m_accessibleContext||isNaN(i)||"row"===t||(u=this._updateAccessibleInfoString(u,"accessibleRowContext",{index:i+1})),isNaN(s)||"column"===t||(u=this._updateAccessibleInfoString(u,"accessibleColumnContext",{index:s+1})),isNaN(o)||(u=this._updateAccessibleInfoString(u,"accessibleRowHeaderContext",{index:o+1})),isNaN(l)||(u=this._updateAccessibleInfoString(u,"accessibleColumnHeaderContext",{index:l+1})),isNaN(r)||(u=this._updateAccessibleInfoString(u,"accessibleRowEndHeaderContext",{index:r+1})),isNaN(a)||(u=this._updateAccessibleInfoString(u,"accessibleColumnEndHeaderContext",{index:a+1})),isNaN(h)||(u=this._updateAccessibleInfoString(u,"accessibleRowHeaderLabelContext",{level:h+1})),isNaN(m)||(u=this._updateAccessibleInfoString(u,"accessibleColumnHeaderLabelContext",{level:m+1})),isNaN(d)||(u=this._updateAccessibleInfoString(u,"accessibleRowEndHeaderLabelContext",{level:d+1})),isNaN(c)||(u=this._updateAccessibleInfoString(u,"accessibleColumnEndHeaderLabelContext",{level:c+1})),isNaN(n)||(u=this._updateAccessibleInfoString(u,"accessibleLevelContext",{level:n+1})),u=0===u.length?u:u+". ",null!=this.m_accessibleContext&&(u+=this.m_accessibleContext,this.m_accessibleContext=null),this.m_contextInfo.textContent=u},A.prototype._updateAccessibleInfoString=function(e,t,i){var s=this.getResources().getTranslatedText(t,i);return null!=s?0===e.length?s:e+", "+s:e},A.prototype._isCountUnknown=function(e){var t=this.getDataSource();if("row"===e||"rowEnd"===e){var i=t.getCountPrecision("row"),s=t.getCount("row");return this.m_isEstimateRowCount="estimate"===i||s<0,this.m_isEstimateRowCount}if("column"===e||"columnEnd"===e){var n=t.getCountPrecision("column"),o=t.getCount("column");return this.m_isEstimateColumnCount="estimate"===n||o<0,this.m_isEstimateColumnCount}return!1},A.prototype._isCountUnknownOrHighwatermark=function(e){return this._isCountUnknown(e)||this._isHighWatermarkScrolling()},A.prototype._hideHeader=function(e){e.style.display="none"},A.prototype._showHeader=function(e){e.style.display=""},A.prototype.buildHeaders=function(e,t,i){var s=this.getMappedStyle("scroller")+(this.m_utils.isTouchDeviceNotIOS()?" "+this.getMappedStyle("scroller-mobile"):"");let n=this._createHeaderElement(e,t,s,!1),o=this._createHeaderElement(e,i,s,!0);const r=this.m_options._getFreezeIndex(e);let l,a;if("column"===e?(this.m_colHeader=n,this.m_colEndHeader=o):"row"===e&&(this.m_rowHeader=n,this.m_rowEndHeader=o),"column"===e&&null!==r&&(this.m_frozenColIndex=r,l=this._createHeaderElement("frozenColumn",this.getMappedStyle("colHeaderFrozen"),s,!1),this.m_colHeaderFrozen=l,this.m_colEndHeader&&(a=this._createHeaderElement("frozenColumn",this.getMappedStyle("colEndHeaderFrozen"),s,!0),this.m_colEndHeaderFrozen=a)),"row"===e&&null!==r&&(this.m_frozenRowIndex=r,l=this._createHeaderElement("frozenRow",this.getMappedStyle("rowHeaderFrozen"),s,!1),this.m_rowHeaderFrozen=l,this.m_rowEndHeader&&(a=this._createHeaderElement("frozenRow",this.getMappedStyle("rowEndHeaderFrozen"),s,!0),this.m_rowEndHeaderFrozen=a)),this._isHighWatermarkScrolling()){this.fetchHeaders(e,0,n,o,null,null)}else{var h=this,d=this.m_options.getScrollPosition();this._getIndexesFromScrollPosition(d).then(function(t){var i=t[e];"column"===e?(h.m_startColHeader=i,h.m_startColEndHeader=i):"row"===e&&(h.m_startRowHeader=i,h.m_startRowEndHeader=i);let s=null;h.m_fetching[e]=!1,null!==r&&(s=h.getFetchSize(e)+i,i=0),h.fetchHeaders(e,i,n,o,s,null)}),this.m_fetching[e]=!0}return{root:n,endRoot:o,frozenHeader:l,frozenEndHeader:a}},A.prototype._createHeaderElement=function(e,t,i,s){let n=document.createElement("div");n.id=s?this.createSubId(e+"EndHeader"):this.createSubId(e+"Header");let o=s?this.getMappedStyle("endheader"):this.getMappedStyle("header");n.className=t+" "+o;let r=document.createElement("div");return r.className=i,n.appendChild(r),n},A.prototype.fetchHeaders=function(e,t,i,s,n,o){if(!this.m_fetching[e]){null==n&&(n=this.getFetchCount(e,t));var r,l={axis:e,start:t,count:n,header:i,endHeader:s};this.m_fetching[e]=l,r=null!=o&&null!=o.success?o.success:this.handleHeadersFetchSuccess,this.m_initialized&&this.isSkeletonSupport()||this.showStatusText(!this.isSkeletonSupport()),this._signalTaskStart(),this.getDataSource().fetchHeaders(l,{success:r,error:this.handleHeadersFetchError},{success:this,error:this})}},A.prototype.isHeaderFetchResponseValid=function(e){var t=e.axis;return null!=this.m_fetching&&e===this.m_fetching[t]},A.prototype.isHeaderFetchResponseInViewport=function(e){if(!this.m_initialized)return!0;var t=e.axis,i=e.start;return("row"===t?this._getLongScrollStart(this.m_currentScrollTop,this.m_prevScrollTop,t):this._getLongScrollStart(this.m_currentScrollLeft,this.m_prevScrollLeft,t)).start===i},A.prototype.handleHeadersFetchSuccess=function(e,t,i,s){var n=this.m_options.getScrollPolicyOptions(),o=n?n.maxRowCount:null,r=n?n.maxColumnCount:null;if(!this.isHeaderFetchResponseValid(t))return void this._signalTaskEnd();var l=t.axis;if(this.isLongScroll()&&!this.isHeaderFetchResponseInViewport(t))return this.m_fetching[l]=!1,this.m_headerInvalid=!0,void this._signalTaskEnd();this.m_fetching[l]=!1;var a=t.header,h=t.endHeader,d=t.start;let m="column"===l?this.m_hiddenColumns.length:this.m_hiddenRows.length;var c=this.getDataSource().getCount(l)-m;if("column"===l){null===this.m_frozenColIndex&&(this.m_frozenColIndex=this.m_options._getFreezeIndex(l));let{headerStart:s,endHeaderStart:n,headerFetchCount:o,endHeaderFetchCount:m}=this._buildFrozenHeaders(l,e,i,t,c);if(null!=e&&o>0){d=s;let i=o;this.buildColumnHeaders(a,e,d,c,!1,!1,i,!1),(e.getCount()<t.count||r&&r>0&&r===d+e.getCount())&&(this.m_stopColumnHeaderFetch=!0)}else this.m_stopColumnHeaderFetch=!0;if(this.m_endColHeader<0?(this._hideHeader(a),this.m_stopColumnHeaderFetch=!0,this.m_startColHeader=0):(this.m_hasColHeader=!0,this._buildHeaderLabels(l,e)),null!=i&&m>0){d=n;let e=m;this.buildColumnEndHeaders(h,i,d,c,!1,!1,e,!1),(i.getCount()<t.count||r&&r>0&&r===d+i.getCount())&&(this.m_stopColumnEndHeaderFetch=!0)}else this.m_stopColumnEndHeaderFetch=!0;this.m_endColEndHeader<0?(this._hideHeader(h),this.m_stopColumnEndHeaderFetch=!0,this.m_startColEndHeader=0):(this.m_hasColEndHeader=!0,this._buildHeaderLabels("columnEnd",i))}else if("row"===l){null===this.m_frozenRowIndex&&(this.m_frozenRowIndex=this.m_options._getFreezeIndex("row"));let{headerStart:n,endHeaderStart:r,headerFetchCount:m,endHeaderFetchCount:u}=this._buildFrozenHeaders(l,e,i,t,c);if(null!=e&&m>0){d=n;const i=m;this.buildRowHeaders(a,e,d,c,s,!1,i,!1),(e.getCount()<t.count||o&&o>0&&o===d+e.getCount())&&(this.m_stopRowHeaderFetch=!0)}else this.m_stopRowHeaderFetch=!0;if(this.m_endRowHeader<0?(this._hideHeader(a),this.m_stopRowHeaderFetch=!0,this.m_startRowHeader=0):(this.m_hasRowHeader=!0,this._buildHeaderLabels(l,e)),null!=i&&u>0){d=r;const e=u;this.buildRowEndHeaders(h,i,d,c,s,!1,e,!1),(i.getCount()<t.count||o&&o>0&&o===d+i.getCount())&&(this.m_stopRowEndHeaderFetch=!0)}else this.m_stopRowEndHeaderFetch=!0;this.m_endRowEndHeader<0?(this._hideHeader(h),this.m_stopRowEndHeaderFetch=!0,this.m_startRowEndHeader=0):(this.m_hasRowEndHeader=!0,this._buildHeaderLabels("rowEnd",i))}this.isFetchComplete()&&(this.hideStatusText(),this._shouldInitialize()&&!s&&this._handleInitialization(!0)),this.m_initialized&&(this.isSkeletonSupport()&&this.loadSkeletonsOnHeaderLoad(l,d,e,i),this._sizeDatabodyScroller()),this._signalTaskEnd()},A.prototype._calculateFrozenIndex=function(e,t){let i=e;if(t&&t.length){let e=0;for(let i=0;i<t.length;i++){let s=t[i];0===this._getAttribute(s,"level",10)&&(e+=this._getAttribute(s,"extent",10))}i=e}return i},A.prototype.handleHeadersFetchError=function(e,t){var i=t.axis;this.m_fetching[i]=!1,this._signalTaskEnd()},A.prototype.createHeaderContext=function(e,t,i,s,n,o,r,l,a){var h={axis:e,index:t,data:i};h.component=this,h.datasource=this.m_options.getProperty("data"),h.level=o,h.depth=l,h.extent=r,!a||"row"!==e&&"column"!==e||(h.contentElement=a),null!=n&&(h.parentElement=n);for(var d=Object.keys(s),m=0;m<d.length;m++){var c=d[m];h[c]=s[c]}return null!=this.m_createContextCallback&&this.m_createContextCallback.call(this,h),this.m_fixContextCallback.call(this,h)},A.prototype._createLabelContext=function(e,t,i,s,n,o){var r={axis:e,level:t,data:i};if(r.component=this,r.datasource=this.m_options.getProperty("data"),!o||"row"!==e&&"column"!==e||(r.contentElement=o),null!=s&&(r.parentElement=s),null!=this.m_createContextCallback&&this.m_createContextCallback.call(this,r),this._isDataGridProvider()&&null!=n)for(var l=Object.keys(n),a=0;a<l.length;a++){var h=l[a];r[h]=n[h]}return this.m_fixContextCallback.call(this,r)},A.prototype._buildHeaderLabels=function(e,t){if(0===this.m_headerLabels[e].length&&t&&t.getLabel){var i,s=t.getLevelCount();"rowEnd"===e?i=this.getResources().isRTLMode()?"left":"right":"row"===e?i=this.getResources().isRTLMode()?"right":"left":"column"===e?i="top":"columnEnd"===e&&(i="bottom");var n=0;if(s>0)for(var o=0;o<s;o++){var r,l=document.createElement("div"),a=t.getLabel(o);this._isDataGridProvider()&&(r=t.getLabelMetadata(o));var h=this._getLabelDimension(e,o);let s;if("row"!==e&&"column"!==e||(s=document.createElement("div"),s.classList.add(this.getMappedStyle("headerLabelCellContent"))),null!=a){var d=this._createLabelContext(e,o,a,l,r,s);l.setAttribute(this.getResources().getMappedAttribute("container"),this.getResources().widgetName),l.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),this._createUniqueId(l),l[this.getResources().getMappedAttribute("context")]=d;const t=this.m_options.getHorizontalAlignment(e,d,!0),g=this.m_options.getVeticalAlignment(e,d,!0);if("auto"!==t){const e=this._getHorizontalAlignmentStyle(t);l.style.justifyContent=e.justifyContent,l.style.textAlign=e.textAlign}"auto"!==g&&(l.style.alignItems=this._getVerticalAlignmentStyle(g));var m=this.m_options.getInlineStyle(e,d,!0);null!=m&&_.applyMergedInlineStyles(l,m,""),l.className=this.getMappedStyle("headerlabel")+" "+this.getMappedStyle(e.toLowerCase()+"headerlabel");var c=this.m_options.getStyleClass(e,d,!0);null!=c&&(l.className+=" "+c),"row"===e||"rowEnd"===e?("rowEnd"===e&&(l.style.height="100%"),this.setElementWidth(l,h),this.setElementDir(l,n,i),this.setElementDir(l,0,"bottom")):("columnEnd"===e&&(l.style.width="100%"),this.setElementHeight(l,h),this.setElementDir(l,n,i),this.setElementDir(l,0,this.getResources().isRTLMode()?"left":"right")),"enable"!==this.m_options.isResizable(e,"width")&&"enable"!==this.m_options.isResizable(e,"height")||this._setAttribute(l,"resizable","true");var u=this.getRendererOrTemplate(e,!0);if(this._renderContent(u,d,l,a,this.buildLabelTemplateContext(d,r||{})),this.m_headerLabels[e][o]=l,this._isDataGridProvider()&&this._isSortEnabled(e,d,!0)){const i=this._shouldAppendIcon(t,e,d);if(null!=r.metadata.sortDirection&&"unsorted"!==r.metadata.sortDirection){const t={level:d.level,axis:e,direction:r.metadata.sortDirection};"column"===e&&null==this.m_sortRowInfo?(this.m_sortRowInfo=t,this.m_sortRowInfo.type="label"):"row"===e&&null==this.m_sortColumnInfo&&(this.m_sortColumnInfo=t,this.m_sortColumnInfo.type="label")}var p=this._buildLabelSortIcon(d,l,e);i?l.appendChild(p):l.prepend(p),this._setAttribute(l,"sortable","true")}}n+=h}}},A.prototype.buildLabelTemplateContext=function(e,t){return{item:{data:e.data,metadata:t.metadata},datasource:e.datasource}},A.prototype.buildHeaderTemplateContext=function(e,t){return{item:{data:e.data,depth:e.depth,extent:e.extent,index:e.index,level:e.level,metadata:t.metadata,axis:e.axis},datasource:e.datasource}},A.prototype.buildCellTemplateContext=function(e,t){return{item:{columnExtent:e.extents.column,columnIndex:e.indexes.column,data:e.data,metadata:t.metadata,rowExtent:e.extents.row,rowIndex:e.indexes.row},datasource:e.datasource,mode:e.mode}},A.prototype.getRendererOrTemplate=function(e,t){var i,s,n=this.m_options.getRenderer(e,t);return n||(i="cell"===e?"cellTemplate":t?e+"HeaderLabelTemplate":e+"HeaderTemplate",(s=this._getItemTemplateBySlotName(i))||(("row"===e||"column"===e)&&(i=t?e+"HeaderLabelContentTemplate":e+"HeaderContentTemplate",s=this._getItemTemplateBySlotName(i))?s:null))},A.prototype.buildColumnHeaders=function(e,t,i,s,n,o,r,l){if(null==this.m_columnHeaderLevelCount&&(this.m_columnHeaderLevelCount=t.getLevelCount()),0===this.m_columnHeaderLevelCount)return;let a=r;void 0===a&&(a=t.getCount());var h=i>this.m_endColHeader;var d=h?this.m_endColHeaderPixel:this.m_startColHeaderPixel,m=this.m_endColHeader,c=this.m_columnHeaderLevelCount,u=this.getMappedStyle("colheader")+" "+this.getMappedStyle("header"),_=this.getMappedStyle("headercell")+" "+this.getMappedStyle("colheadercell");l&&(_+=` ${this.getMappedStyle("frozenHeader")}`);var p=this.buildAxisHeaders(e,t,"column",i,a,h,false,null,d,m,c,u,_,false),g=p.totalHeaderDimension,f=p.totalLevelDimension;if(0===g||0!==this.m_avgColWidth&&null!=this.m_avgColWidth||(this.m_avgColWidth=g/p.visibleHeaderCount),this.m_colHeaderHeight||(this.m_colHeaderHeight=f,this.setElementHeight(e,this.m_colHeaderHeight)),h?(this.m_endColHeader=i+a-1,this.m_endColHeaderPixel+=g):(this.m_startColHeader-=a,this.m_startColHeaderPixel-=g),-1===s&&(s=this.m_endColHeader),!this._isCountUnknown("column")&&this._isHighWatermarkScrolling()&&this.m_endColHeader+1>=s?this.m_stopColumnHeaderFetch=!0:this.m_stopColumnHeaderFetch=p.stopFetch,0===this.m_startColHeader&&0!==this.m_startColHeaderPixel&&(this._shiftHeadersAlongAxisInContainer(e.firstChild,0,-1*this.m_startColHeaderPixel,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colheadercell")),this.m_endColHeaderPixel-=this.m_startColHeaderPixel,this.m_startColHeaderPixel=0),!this.m_initialized&&this.m_startColHeader>0){var C=Math.round(this.m_avgColWidth*this.m_startColHeader);this._shiftHeadersAlongAxisInContainer(e.firstChild,this.m_startColHeader,C-this.m_startColHeaderPixel,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colheadercell")),this.m_endColHeaderPixel=C+g,this.m_startColHeaderPixel=C}},A.prototype.buildColumnEndHeaders=function(e,t,i,s,n,o,r,l){if(null==this.m_columnEndHeaderLevelCount&&(this.m_columnEndHeaderLevelCount=t.getLevelCount()),0===this.m_columnEndHeaderLevelCount)return;let a=r;void 0===a&&(a=t.getCount());var h=i>this.m_endColEndHeader;var d=h?this.m_endColEndHeaderPixel:this.m_startColEndHeaderPixel,m=this.m_endColEndHeader,c=this.m_columnEndHeaderLevelCount,u=this.getMappedStyle("colendheader")+" "+this.getMappedStyle("endheader"),_=this.getMappedStyle("endheadercell")+" "+this.getMappedStyle("colendheadercell");l&&(_+=` ${this.getMappedStyle("frozenHeader")}`);var p=this.buildAxisHeaders(e,t,"columnEnd",i,a,h,false,null,d,m,c,u,_,false),g=p.totalHeaderDimension,f=p.totalLevelDimension;if(0===g||0!==this.m_avgColWidth&&null!=this.m_avgColWidth||(this.m_avgColWidth=g/p.visibleHeaderCount),this.m_colEndHeaderHeight||(this.m_colEndHeaderHeight=f,this.setElementHeight(e,this.m_colEndHeaderHeight)),h?(this.m_endColEndHeader=i+(a-1),this.m_endColEndHeaderPixel+=g):(this.m_startColEndHeader-=a,this.m_startColEndHeaderPixel-=g),-1===s&&(s=this.m_endColEndHeader),!this._isCountUnknown("column")&&this._isHighWatermarkScrolling()&&this.m_endColEndHeader+1>=s?this.m_stopColumnEndHeaderFetch=!0:this.m_stopColumnEndHeaderFetch=p.stopFetch,0===this.m_startColEndHeader&&0!==this.m_startColEndHeaderPixel&&(this._shiftHeadersAlongAxisInContainer(e.firstChild,0,-1*this.m_startColEndHeaderPixel,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colendheadercell")),this.m_endColEndHeaderPixel-=this.m_startColEndHeaderPixel,this.m_startColEndHeaderPixel=0),!this.m_initialized&&this.m_startColEndHeader>0){var C=Math.round(this.m_avgColWidth*this.m_startColEndHeader);this._shiftHeadersAlongAxisInContainer(e.firstChild,this.m_startColEndHeader,C-this.m_startColEndHeaderPixel,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colendheadercell")),this.m_endColEndHeaderPixel=C+g,this.m_startColEndHeaderPixel=C}},A.prototype.buildRowHeaders=function(e,t,i,s,n,o,r,l){if(null==this.m_rowHeaderLevelCount&&(this.m_rowHeaderLevelCount=t.getLevelCount()),0===this.m_rowHeaderLevelCount)return;let a=r;void 0===a&&(a=t.getCount());var h,d=i>this.m_endRowHeader,m=d?this.m_endRowHeaderPixel:this.m_startRowHeaderPixel;n?(h=e.firstChild.childNodes[i-this.m_startRowHeader],m=this.getElementDir(h,"top")):h=null;var c=this.m_endRowHeader,u=this.m_rowHeaderLevelCount,_=this.getMappedStyle("rowheader")+" "+this.getMappedStyle("header"),p=this.getMappedStyle("headercell")+" "+this.getMappedStyle("rowheadercell");l&&(p+=` ${this.getMappedStyle("frozenHeader")}`);var g=this.buildAxisHeaders(e,t,"row",i,a,d,n,h,m,c,u,_,p,o),f=g.totalHeaderDimension,C=g.totalLevelDimension;if(o)return g;if(0===f||0!==this.m_avgRowHeight&&null!=this.m_avgRowHeight||(this.m_avgRowHeight=f/g.visibleHeaderCount),this.m_rowHeaderWidth||(this.m_rowHeaderWidth=C,this.setElementWidth(e,this.m_rowHeaderWidth)),d){if(-1!==this.m_endRowHeader&&0!==a){var y=e.firstChild.childNodes[this.m_endRowHeader-this.m_startRowHeader];null!=y&&this.m_utils.removeCSSClassName(y,this.getMappedStyle("borderHorizontalNone"))}this.m_endRowHeader=i+(a-1),this.m_endRowHeaderPixel+=f}else n?(i<this.m_startRowHeader&&(this.m_startRowHeader=i,this.m_startRowHeaderPixel=Math.max(0,this.m_startRowHeaderPixel-f)),this.m_endRowHeader+=a,this.m_endRowHeaderPixel=Math.max(0,this.m_endRowHeaderPixel+f),this.pushRowHeadersDown(h,f)):(this.m_startRowHeader=Math.max(0,this.m_startRowHeader-a),this.m_startRowHeaderPixel-=f);if(-1===s&&(s=this.m_endRowHeader),!this._isCountUnknown("row")&&this._isHighWatermarkScrolling()&&this.m_endRowHeader+1>=s?this.m_stopRowHeaderFetch=!0:this.m_stopRowHeaderFetch=g.stopFetch,0===this.m_startRowHeader&&0!==this.m_startRowHeaderPixel&&(this._shiftHeadersAlongAxisInContainer(e.firstChild,0,-1*this.m_startRowHeaderPixel,"top",this.getMappedStyle("rowheadercell")),this.m_endRowHeaderPixel-=this.m_startRowHeaderPixel,this.m_startRowHeaderPixel=0),!this.m_initialized&&this.m_startRowHeader>0){var E=Math.round(this.m_avgRowHeight*this.m_startRowHeader);this._shiftHeadersAlongAxisInContainer(e.firstChild,this.m_startRowHeader,E-this.m_startRowHeaderPixel,"top",this.getMappedStyle("rowheadercell")),this.m_endRowHeaderPixel=E+f,this.m_startRowHeaderPixel=E}},A.prototype.buildRowEndHeaders=function(e,t,i,s,n,o,r,l){if(null==this.m_rowEndHeaderLevelCount&&(this.m_rowEndHeaderLevelCount=t.getLevelCount()),0===this.m_rowEndHeaderLevelCount)return;let a=r;void 0===a&&(a=t.getCount());var h,d=i>this.m_endRowEndHeader,m=d?this.m_endRowEndHeaderPixel:this.m_startRowEndHeaderPixel;n?(h=e.firstChild.childNodes[i-this.m_startRowEndHeader],m=this.getElementDir(h,"top")):h=null;var c=this.m_endRowEndHeader,u=this.m_rowEndHeaderLevelCount,_=this.getMappedStyle("rowendheader")+" "+this.getMappedStyle("endheader"),p=this.getMappedStyle("endheadercell")+" "+this.getMappedStyle("rowendheadercell");l&&(p+=` ${this.getMappedStyle("frozenHeader")}`);var g=this.buildAxisHeaders(e,t,"rowEnd",i,a,d,n,h,m,c,u,_,p,o);if(o)return g;var f=g.totalHeaderDimension,C=g.totalLevelDimension;if(0===f||0!==this.m_avgRowHeight&&null!=this.m_avgRowHeight||(this.m_avgRowHeight=f/a),this.m_rowEndHeaderWidth||(this.m_rowEndHeaderWidth=C,this.setElementWidth(e,this.m_rowEndHeaderWidth)),d){if(-1!==this.m_endRowEndHeader&&0!==a){var y=e.firstChild.childNodes[this.m_endRowEndHeader-this.m_startRowEndHeader];null!=y&&this.m_utils.removeCSSClassName(y,this.getMappedStyle("borderHorizontalNone"))}this.m_endRowEndHeader=i+(a-1),this.m_endRowEndHeaderPixel+=f}else n?(i<this.m_startRowEndHeader&&(this.m_startRowEndHeader=i,this.m_startRowEndHeaderPixel=Math.max(0,this.m_startRowEndHeaderPixel-f)),this.m_endRowEndHeader+=a,this.m_endRowEndHeaderPixel=Math.max(0,this.m_endRowEndHeaderPixel+f),this.pushRowHeadersDown(h,f)):(this.m_startRowEndHeader=Math.max(0,this.m_startRowEndHeader-a),this.m_startRowEndHeaderPixel-=f);if(-1===s&&(s=this.m_endRowEndHeader),!this._isCountUnknown("row")&&this._isHighWatermarkScrolling()&&this.m_endRowEndHeader+1>=s?this.m_stopRowEndHeaderFetch=!0:this.m_stopRowEndHeaderFetch=g.stopFetch,0===this.m_startRowEndHeader&&0!==this.m_startRowEndHeaderPixel&&(this._shiftHeadersAlongAxisInContainer(e.firstChild,0,-1*this.m_startRowEndHeaderPixel,"top",this.getMappedStyle("rowendheadercell")),this.m_endRowEndHeaderPixel-=this.m_startRowEndHeaderPixel,this.m_startRowEndHeaderPixel=0),!this.m_initialized&&this.m_startRowEndHeader>0){var E=Math.round(this.m_avgRowHeight*this.m_startRowEndHeader);this._shiftHeadersAlongAxisInContainer(e.firstChild,this.m_startRowEndHeader,E-this.m_startRowEndHeaderPixel,"top",this.getMappedStyle("rowendheadercell")),this.m_endRowEndHeaderPixel=E+f,this.m_startRowEndHeaderPixel=E}},A.prototype.buildAxisHeaders=function(e,t,i,s,n,o,r,l,a,h,d,m,c,u){var _,p,g=-1!==i.indexOf("column"),f=g?"height":"width",C=!1,y=0,E=0,v=0,w=0;let b=0;if(!u){if(0===n&&this._isCountUnknown(i))return{totalHeaderDimension:y,totalLevelDimension:E,stopFetch:C=!0};_=e.firstChild,-1===h&&""===e.className&&(e.className=m,e.style[f]="",_.style[f]="")}for(var H=this.getRendererOrTemplate(i),x=document.createDocumentFragment(),S=0;n-S>0;){o||r?(p=s+S,v=g?a+y:0,w=g?0:a+y):(p=s+(n-1-S),v=g?a-y:0,w=g?0:a-y),this.isHidden(i,p)&&(b+=1);var R=this.buildLevelHeaders(x,p,0,v,w,o,r,H,t,i,c,d);S+=R.count,y+=R.totalHeaderDimension,R.totalLevelDimension>E&&(E=R.totalLevelDimension)}return u?x:(o?_.appendChild(x):r?_.insertBefore(x,l):_.insertBefore(x,_.firstChild),e.hasChildNodes()||r||e.appendChild(_),this.m_subtreeAttachedCallback(_),{totalHeaderDimension:y,totalLevelDimension:E,stopFetch:C,visibleHeaderCount:n-b})},A.prototype._renderContent=function(e,t,i,s,n){let o=!1,r=t.contentElement;if(null!=e&&"function"==typeof e){const s=e.call(this,t);let n=i,l=s;null!=s?.insert?l=s.insert:null!=r&&(null!=s?.insertContent?(n=r,l=s.insertContent,o=!0):r.hasChildNodes()&&(o=!0),o&&i.appendChild(r)),_.applyRendererContent(n,l,!1,this.m_isCustomElementCallback()?null:this.m_subtreeAttachedCallback),this._removeFocusFromChildElements(t,i)}else if(null!=e&&"object"==typeof e&&this.m_engine){var l=this.m_engine.execute(this.m_root,e,n,null);o="columnHeaderContentTemplate"===e.slot||"rowHeaderContentTemplate"===e.slot||"columnHeaderLabelContentTemplate"===e.slot||"rowHeaderLabelContentTemplate"===e.slot;for(var a=0;a<l.length;a++)o?r.appendChild(l[a]):i.appendChild(l[a]);o&&i.appendChild(r),this._removeFocusFromChildElements(t,i)}else null!=s&&"object"==typeof s&&Object.prototype.hasOwnProperty.call(s,"data")&&(s=s.data),null==s&&(s=""),r?(r.appendChild(document.createTextNode(s.toString())),i.appendChild(r)):i.appendChild(document.createTextNode(s.toString()))},A.prototype._removeFocusFromChildElements=function(e,t){if("edit"!==e.mode){var i=this;this._signalTaskStart(),this.m_contextCallback(t).getBusyContext().whenReady().then(function(){_.disableAllFocusableElements(t),i._signalTaskEnd()})}},A.prototype.buildLevelHeaders=function(e,t,i,s,n,o,r,l,a,h,d,m){var c,u,p,g,f,C,y,E,v,w,b,H,x,S,R,I=0,M=0,F=0,z=0;let D;"row"===h?(c="row",u=this.m_rowHeader,p="width",g=this.m_rowHeaderLevelWidths,f="height",C="top",y=n,E=this.getResources().isRTLMode()?"right":"left",v=s,w=this.m_startRowHeader,b=this.m_endRowHeader,this._hasFrozenRows()&&t<=this.m_frozenRowIndex&&this.m_rowHeaderFrozen&&(u=this.m_rowHeaderFrozen)):"rowEnd"===h?(c="row",u=this.m_rowEndHeader,p="width",g=this.m_rowEndHeaderLevelWidths,f="height",C="top",y=n,E=this.getResources().isRTLMode()?"left":"right",v=s,w=this.m_startRowEndHeader,b=this.m_endRowEndHeader,this._hasFrozenRows()&&t<=this.m_frozenRowIndex&&this.m_rowEndHeaderFrozen&&(u=this.m_rowEndHeaderFrozen)):"column"===h?(c="column",u=this.m_colHeader,p="height",g=this.m_columnHeaderLevelHeights,f="width",C=this.getResources().isRTLMode()?"right":"left",y=s,E="top",v=n,w=this.m_startColHeader,b=this.m_endColHeader,this._hasFrozenColumns()&&t<=this.m_frozenColIndex&&this.m_colHeaderFrozen&&(u=this.m_colHeaderFrozen)):(c="column",u=this.m_colEndHeader,p="height",g=this.m_columnEndHeaderLevelHeights,f="width",C=this.getResources().isRTLMode()?"right":"left",y=s,E="bottom",v=n,w=this.m_startColEndHeader,b=this.m_endColEndHeader,this._hasFrozenColumns()&&t<=this.m_frozenColIndex&&this.m_colEndHeaderFrozen&&(u=this.m_colEndHeaderFrozen)),D=this.isHidden(h,t);var A=a.getExtent(t,i),L=A.extent,T=A.more.before,N=A.more.after,O=a.getDepth(t,i);let k;if(T&&t===b+1){for(H=this._getHeaderContainer(t-1,i,u,m),this._setAttribute(H,"extent",this._getAttribute(H,"extent",!0)+L),k=(x=H.firstChild)[this.getResources().getMappedAttribute("context")],k.extent+=L,I=this.getElementDir(x,p),S=0;S<L;)y+=(R="column"===h||"columnEnd"===h?this.buildLevelHeaders(H,t+S,i+O,y,v+I,o,r,l,a,h,d,m):this.buildLevelHeaders(H,t+S,i+O,v+I,y,o,r,l,a,h,d,m)).totalHeaderDimension,F+=R.totalHeaderDimension,z+=R.count,S+=R.count;this.setElementDir(x,this.getElementDir(x,f)+F,f),"none"===x.style.display&&0!==F&&(x.style.display="",this.deleteAndApplyHiddenIndicators())}else if(N&&t===w-1){for(H=this._getHeaderContainer(t+1,i,u,m),this._setAttribute(H,"extent",this._getAttribute(H,"extent",!0)+L),this._setAttribute(H,"start",this._getAttribute(H,"start",!0)-L),k=(x=H.firstChild)[this.getResources().getMappedAttribute("context")],k.extent+=L,k.index-=L,I=this.getElementDir(x,p),S=0;S<L;)y-=(R="column"===h||"columnEnd"===h?this.buildLevelHeaders(H,t-S,i+O,y,v+I,o,r,l,a,h,d,m):this.buildLevelHeaders(H,t-S,i+O,v+I,y,o,r,l,a,h,d,m)).totalHeaderDimension,F+=R.totalHeaderDimension,z+=R.count,S+=R.count;this.setElementDir(x,this.getElementDir(x,f)+F,f),"none"===x.style.display&&0!==F&&(x.style.display="",this.deleteAndApplyHiddenIndicators()),this.setElementDir(x,y,C)}else{var P=a.getData(t,i),B=a.getMetadata(t,i);let s;x=document.createElement("div"),"row"!==h&&"column"!==h||(s=document.createElement("div"),s.classList.add(this.getMappedStyle("headerCellContent"))),k=this.createHeaderContext(h,o||r?t:t-L+1,P,B,x,i,L,O,s),x.setAttribute(this.getResources().getMappedAttribute("container"),this.getResources().widgetName),x.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),this._createUniqueId(x),x[this.getResources().getMappedAttribute("context")]=k,x[this.getResources().getMappedAttribute("metadata")]=B,x.extentInfo=A;var W=this.m_options.getInlineStyle(h,k),j=this.m_options.getStyleClass(h,k);null!=W&&_.applyMergedInlineStyles(x,W,""),x.className=d,x.className+=" "+this.getMappedStyle("depth")+O,null!=j&&(x.className+=" "+j),this.setElementDir(x,v,E),this.setElementDir(x,y,C);var K=this._getHeaderDimensions(x,f,p,g,i,c,k.key,O);I=K[p],this.setElementDir(x,I,p);var V=K[f];if(this._setAttribute(x,"depth",O),i!==m-1&&((H=document.createElement("div")).className=this.getMappedStyle("groupingcontainer"),H.appendChild(x),this._setAttribute(H,"start",o||r?t:t-L+1),this._setAttribute(H,"extent",L),this._setAttribute(H,"level",i)),i+O===m)D&&(V=0,x.style.display="none"),this.setElementDir(x,V,f),F+=V,z+=1,M=I,o||r||(y-=V,this.setElementDir(x,y,C));else{for(S=0;S<L;S++){var U=o||r?t+S:t-S;V=(R="column"===h||"columnEnd"===h?this.buildLevelHeaders(H,U,i+O,y,v+I,o,r,l,a,h,d,m):this.buildLevelHeaders(H,U,i+O,v+I,y,o,r,l,a,h,d,m)).totalHeaderDimension,y=o||r?y+V:y-V,F+=V,z+=R.count,S+=R.count-1}M=I,R&&!isNaN(R.totalLevelDimension)&&(M+=R.totalLevelDimension),o||r||this.setElementDir(x,y,C),this.setElementDir(x,F,f),this.isHeaderHidden(x)&&(x.style.display="none")}"columnEnd"===h&&this.m_addBorderBottom&&this.m_utils.addCSSClassName(x,this.getMappedStyle("borderHorizontalSmall")),"rowEnd"===h&&this.m_addBorderRight&&this.m_utils.addCSSClassName(x,this.getMappedStyle("borderVerticalSmall")),this._isHeaderResizeEnabled(h,k)&&this._setAttribute(x,"resizable","true"),this.m_isCustomElementCallback()||(null!=H?this.m_root.appendChild(H):this.m_root.appendChild(x));const n=this.m_options.getHorizontalAlignment(h,k),u=this.m_options.getVeticalAlignment(h,k);if(this._renderContent(l,k,x,P,this.buildHeaderTemplateContext(k,B)),"auto"!==n){const e=this._getHorizontalAlignmentStyle(n);x.style.justifyContent=e.justifyContent,x.style.textAlign=e.textAlign}"auto"!==u&&(x.style.alignItems=this._getVerticalAlignmentStyle(u));const w=this._shouldAppendIcon(n,h,k);if(this._isRequired(k)){var Y=document.createElement("span");this.m_utils.addCSSClassName(Y,this.getMappedStyle("iconContainer")),this.m_utils.addCSSClassName(Y,this.getMappedStyle("requiredIcon")),Y.setAttribute("title",this.getResources().getTranslatedText("tooltipRequired")),x.appendChild(Y)}if(("column"===h||this._isDataGridProvider())&&this._isSortEnabled(h,k)){this._isDataGridProvider()?null!=B.sortDirection&&("column"===h&&null==this.m_sortColumnInfo||"row"===h&&null==this.m_sortRowInfo)&&("row"===h?(this.m_sortRowInfo={},this.m_sortRowInfo.key=B.key,this.m_sortRowInfo.direction=B.sortDirection,this.m_sortRowInfo.axis=h,this.m_sortRowInfo.type="header"):(this.m_sortColumnInfo={},this.m_sortColumnInfo.key=B.key,this.m_sortColumnInfo.direction=B.sortDirection,this.m_sortColumnInfo.axis=h,this.m_sortColumnInfo.type="header")):null==this.m_sortColumnInfo&&(this.m_sortColumnInfo={},this.m_sortColumnInfo.key=B.key,this.m_sortColumnInfo.direction=B.sortDirection,this.m_sortColumnInfo.axis=h);var G=this._buildSortIcon(k,x,h);w?x.appendChild(G):x.insertBefore(G,x.childNodes[0]),this._setAttribute(x,"sortable","true")}if("column"===h&&this._isFilterEnabled(h,k)){const e=this._buildFilterIcon(k,x,h);w?x.appendChild(e):x.insertBefore(e,x.childNodes[0]),this._setAttribute(x,"filterable","true")}if(this._isParentNode(k)){const e=this._buildDisclosureIcon(k);this._isHierarchicalGroup(k)?this.m_utils.addCSSClassName(x,this.getMappedStyle("hierarchicalGroup")):this.m_utils.addCSSClassName(x,this.getMappedStyle("hierarchicalTree")),x.prepend(e);const t=this._buildSpacer(k);x.prepend(t)}else if(this._isLeafNode(k)){this.m_utils.addCSSClassName(x,this.getMappedStyle("hierarchical"));const e=this._buildSpacer(k);x.prepend(e)}o||r?null!=H?e.appendChild(H):e.appendChild(x):null!=H?e.firstChild?this.m_utils.containsCSSClassName(e.firstChild,this.getMappedStyle("groupingcontainer"))?e.insertBefore(H,e.firstChild):(this.m_utils.containsCSSClassName(e.firstChild,this.getMappedStyle("headercell"))||this.m_utils.containsCSSClassName(e.firstChild,this.getMappedStyle("endheadercell")))&&e.insertBefore(H,e.firstChild.nextSibling):e.appendChild(H):this.m_utils.containsCSSClassName(e,this.getMappedStyle("groupingcontainer"))?e.insertBefore(x,e.firstChild.nextSibling):e.insertBefore(x,e.firstChild)}return"column"===h||"columnEnd"===h?this._isLastColumn(t+(L-1))&&this.m_utils.addCSSClassName(x,this.getMappedStyle("borderVerticalNone")):this._isLastRow(t+(L-1))&&!r&&this.m_utils.addCSSClassName(x,this.getMappedStyle("borderHorizontalNone")),{totalLevelDimension:M,totalHeaderDimension:F,count:z}},A.prototype._getHeaderDimensions=function(e,t,i,s,n,o,r,l){for(var a={},h=0,d=0;d<l;d++){var m=s[n+d];if(null==m){h=null;break}h+=m}null==h?a=this._computeElementWidthAndHeight(e):a[i]=h,1===l&&(s[n]=a[i]);var c=this.m_sizingManager.getSize(o,r);if(null!=c)return a[t]=c,a;if(""!==e.style[t])return null==a[t]&&(a[t]=this.getElementDir(e,t)),this.m_sizingManager.setSize(o,r,a[t]),a;var u=e.className;return null==a[t]&&(a[t]=this.m_styleClassDimensionMap[t][u],null==a[t]&&(a[t]=this.getElementDir(e,t))),this.m_sizingManager.setSize(o,r,a[t]),this.m_styleClassDimensionMap[t][u]=a[t],a},A.prototype._getHeaderLevelDimension=function(e,t,i,s,n){for(var o=0,r=0;r<n;r++){var l=i[e+r];if(null==l){o=null;break}o+=l}return null!=o||(o=this.getElementDir(t,s),1===n&&(i[e]=o)),o},A.prototype._getHeaderContainer=function(e,t,i,s){const n=this._getHeaderByIndexFromRoot(e,t,i,s,0);return n?n.parentNode:null},A.prototype._getChildElementCountByClassName=function(e,t){if(null==e)return 0;let i=0;return t&&(i+=Array.from(e.children).filter(e=>this.m_utils.containsCSSClassName(e,t)).length),i},A.prototype._getHeaderPreviousSibling=function(e){if(!e||!e.previousSibling)return null;const t=this.getMappedStyle("headercell"),i=this.getMappedStyle("endheadercell"),s=this.getMappedStyle("groupingcontainer"),n=e.previousSibling;return n.classList.contains(t)||n.classList.contains(i)||n.classList.contains(s)?n:this._getHeaderPreviousSibling(n)},A.prototype._getHeaderLastChild=function(e){let t=e.lastChild;const i=this.getMappedStyle("headercell"),s=this.getMappedStyle("endheadercell"),n=this.getMappedStyle("groupingcontainer");if(!t)return null;for(;t&&!(t.classList.contains(i)||t.classList.contains(s)||t.classList.contains(n));)t=t.previousSibling;return t},A.prototype._getHeaderByIndex=function(e,t,i){let s=this._getHeaderDetails(e,t),n=s.root,o=s.totalLevels,r=s.startIndex;return this._getHeaderByIndexFromRoot(e,i,n,o,r)},A.prototype._getHeaderDetails=function(e,t){let i,s,n,o,r,l;return"column"===t?(i=this.m_colHeader,s=this.m_columnHeaderLevelCount,n=this.m_startColHeader,o=this.m_colHeaderFrozen,r=this._hasFrozenColumns(),l=this.m_frozenColIndex):"columnEnd"===t?(i=this.m_colEndHeader,s=this.m_columnEndHeaderLevelCount,n=this.m_startColEndHeader,o=this.m_colEndHeaderFrozen,r=this._hasFrozenColumns(),l=this.m_frozenColIndex):"row"===t?(i=this.m_rowHeader,s=this.m_rowHeaderLevelCount,n=this.m_startRowHeader,o=this.m_rowHeaderFrozen,r=this._hasFrozenRows(),l=this.m_frozenRowIndex):"rowEnd"===t&&(i=this.m_rowEndHeader,s=this.m_rowEndHeaderLevelCount,n=this.m_startRowEndHeader,o=this.m_rowEndHeaderFrozen,r=this._hasFrozenRows(),l=this.m_frozenRowIndex),r&&(e<=l?i=o:n+=l+1),{root:i,totalLevels:s,startIndex:n}},A.prototype._getHeadersByIndex=function(e,t){let i=[],s=this._getHeaderDetails(e,t),n=s.root,o=s.totalLevels,r=s.startIndex,l=1;for(let t=o-1;t>=0;t-=l){let s=this._getHeaderByIndexFromRoot(e,t,n,o,r);s&&(l=this.getHeaderCellDepth(s),i.push(s))}return i},A.prototype._getHeaderByIndexFromRoot=function(e,t,i,s,n){let o;if(t<0)return null;const r=i.querySelectorAll(`.${this.getMappedStyle("headercell")},.${this.getMappedStyle("endheadercell")}`);if(1===s)return o=e-n,r[o];for(let i=0;i<r.length;i++){const s=r[i][this.getResources().getMappedAttribute("context")],n=s.index,o=s.extent,l=s.depth,a=s.level;if(e>=n&&e<n+o&&t>=a&&t<a+l)return r[i]}return null},A.prototype._getAttribute=function(e,t,i){var s=e.getAttribute(this.getResources().getMappedAttribute(t));return i?parseInt(s,10):s},A.prototype._setAttribute=function(e,t,i){e.setAttribute(this.getResources().getMappedAttribute(t),i)},A.prototype.buildDatabody=function(e){let t=this._createDatabodyElement("databody");this.m_databody=t;const i=this.m_frozenRowIndex,s=this.m_frozenColIndex;let n,o,r;if(this._hasFrozenColumns()&&this._hasFrozenRows()&&(r=this._createDatabodyElement("databodyFrozenCorner"),this.m_databodyFrozenCorner=r),this._hasFrozenColumns()&&(n=this._createDatabodyElement("databodyFrozenCol"),this.m_databodyFrozenCol=n),this._hasFrozenRows()&&(o=this._createDatabodyElement("databodyFrozenRow"),this.m_databodyFrozenRow=o),!e)if(t.addEventListener("scroll",this.handleScroll.bind(this),!1),this._isHighWatermarkScrolling()){this.fetchCells(t,0,0)}else{var l=this,a=this.m_options.getScrollPosition();this._getIndexesFromScrollPosition(a).then(function(e){var n=e.row,o=e.column;let r=null,a=null;l.m_startRow=n,l.m_startCol=o,l.m_fetching.cells=!1,null===s&&null===i||(null!==s&&(r=l.getFetchSize("column")+o,o=0),null!==i&&(a=l.getFetchSize("row")+n,n=0)),l.fetchCells(t,n,o,a,r)}),this.m_fetching.cells=!0}let h=[];return h.push(t),n&&h.push(n),o&&h.push(o),r&&h.push(r),h},A.prototype._createDatabodyElement=function(e){var t=document.createElement("div");t.id=this.createSubId(e),t.className=this.getMappedStyle(e)+" "+this.getMappedStyle("scrollbarForce"),t.tabIndex="-1";var i=document.createElement("div");return i.className=this.getMappedStyle("scroller")+(this.m_utils.isTouchDeviceNotIOS()?" "+this.getMappedStyle("scroller-mobile"):""),t.appendChild(i),t},A.prototype._getIndexFromKeyPromise=function(e,t){var i=this;return new Promise(function(s){null!=e||null!=t?i._indexes({row:e,column:t},function(e){s({rowIndexFromKey:e.row,columnIndexFromKey:e.column})}):s({rowIndexFromKey:null,columnIndexFromKey:null})})},A.prototype._getIndexesFromScrollPosition=function(e){var t=this,i=e.rowKey,s=e.columnKey;return this._getIndexFromKeyPromise(i,s).then(function(i){var s={};return null!=i.rowIndexFromKey&&i.rowIndexFromKey>0?s.row=i.rowIndexFromKey:null!=e.rowIndex?s.row=e.rowIndex:null!=e.y?s.row=Math.round(e.y/t.getDefaultRowHeight()):s.row=0,null!=i.columnIndexFromKey&&i.columnIndexFromKey>0?s.column=i.columnIndexFromKey:null!=e.columnIndex?s.column=e.columnIndex:null!=e.x?s.column=Math.round(e.x/t.getDefaultColumnWidth()):s.column=0,s})},A.prototype.getFetchCount=function(e,t){var i=this.getFetchSize(e);if(this._isHighWatermarkScrolling()){var s="row"===e?"maxRowCount":"maxColumnCount",n=this.m_options.getScrollPolicyOptions();n&&null!=n[s]&&n[s]>0&&(i=Math.max(Math.min(i,n[s]-t),0))}return i},A.prototype.fetchCells=function(e,t,i,s,n,o){var r;if(!this.m_fetching.cells){null==s&&(s=this.getFetchCount("row",t)),null==n&&(n=this.getFetchCount("column",i));var l={axis:"row",start:t,count:s},a={axis:"column",start:i,count:n,databody:e};this.m_fetching.cells={rowRange:l,columnRange:a},r=null!=o&&null!=o.success?o.success:this.handleCellsFetchSuccess,this.isSkeletonSupport()||this.showStatusText(!this.isSkeletonSupport()),this._signalTaskStart(),this.getDataSource().fetchCells([l,a],{success:r,error:this.handleCellsFetchError},{success:this,error:this})}},A.prototype.isCellFetchResponseValid=function(e){if(null==this.m_fetching)return!1;var t=e[0],i=e[1],s=this.m_fetching.cells;return t===s.rowRange&&i===s.columnRange},A.prototype.isLongScroll=function(){return this.m_isLongScroll},A.prototype.isCellFetchResponseInViewport=function(e,t){if(isNaN(this.m_avgRowHeight)||isNaN(this.m_avgColWidth)||null!=this.m_empty||!this.m_initialized)return!0;var i=t[0].start,s=t[1].start,n=this._getLongScrollStart(this.m_currentScrollTop,this.m_prevScrollTop,"row"),o=this._getLongScrollStart(this.m_currentScrollLeft,this.m_prevScrollLeft,"column");return n.start===i&&o.start===s},A.prototype.handleCellsFetchSuccess=function(e,t,i){var s=this.m_options.getScrollPolicyOptions(),n=s?s.maxRowCount:null,o=s?s.maxColumnCount:null,r=this.getDataSource().getCount("row"),l=this.getDataSource().getCount("column");if(void 0===i){if(i=!1,!this.isCellFetchResponseValid(t))return void this._signalTaskEnd();if(this.isLongScroll()&&(!this.isCellFetchResponseInViewport(e,t)||this.m_headerInvalid))return this.m_fetching.cells=!1,this.m_headerInvalid=!1,this.handleLongScroll(this.m_currentScrollLeft,this.m_currentScrollTop),void this._signalTaskEnd();this.m_isLongScroll=!1,this.m_longScrollRow=null,this.m_longScrollColumn=null,this.m_longScrollRowPixel=null,this.m_longScrollColumnPixel=null}var a=t[0],h=a.start,d=e.getCount("row"),m=d>0&&(h>this.m_endRow||h+d<=this.m_startRow);let c=this.m_frozenRowIndex;this.m_initialized&&this._hasFrozenRows()&&h<c&&this.m_rowHeaderFrozen&&(h=c+1),(0===d&&this._isCountUnknown("row")&&a.count>0||m&&this._isHighWatermarkScrolling()&&!this._isCountUnknown("row")&&this.m_endRow+d+1>=r||d<a.count||this._isHighWatermarkScrolling()&&n&&n>0&&h+d===n)&&(this.m_stopRowFetch=!0);var u=t[1],_=u.start,p=e.getCount("column");let g=this.m_frozenColIndex;this.m_initialized&&this._hasFrozenColumns()&&_<g&&this.m_colHeaderFrozen&&(_=g+1);var f=p>0&&(_>this.m_endCol||_+p===this.m_startCol);(0===p&&this._isCountUnknown("column")&&u.count>0||f&&this._isHighWatermarkScrolling()&&!this._isCountUnknown("column")&&this.m_endCol+p+1>=l||p<u.count||this._isHighWatermarkScrolling()&&o&&o>0&&_+p===o)&&(this.m_stopColumnFetch=!0);var C=this.m_databody;null==C&&(C=u.databody);var y,E,v,w,b,H,x,S,R,I,M=C.firstChild;if(m||i){if(y=!(i||!(h>=this.m_startRow)))E=this.m_endRowPixel;else if(i){var F=this._getCellByIndex({row:h+d,column:this.m_startCol});E=this.getElementDir(F,"top")}else E=this.m_startRowPixel;v=_>=this.m_startCol?this.m_startColPixel:this.m_endColPixel;let t=_,s=h,n=d,o=p;!1===this.m_initialized?(this._hasFrozenRows()&&this._hasFrozenColumns()&&null!==this.m_colHeaderFrozen&&null!==this.m_rowHeaderFrozen&&(b=this._populateFrozenContainer(this.m_databodyFrozenCorner.firstChild,e,h,E,_,v,c+1,g+1),_=g+1,h=c+1,d=n-(c+1),0===(p=o-(g+1))&&(this.m_endRowPixel+=b.totalRowHeight)),this._hasFrozenRows()&&null!==this.m_rowHeaderFrozen&&(b=this._populateFrozenContainer(this.m_databodyFrozenRow.firstChild,e,s,E,_,v,c+1,p),d=n-(c+1),h=c+1),this._hasFrozenColumns()&&null!==this.m_colHeaderFrozen&&(b=this._populateFrozenContainer(this.m_databodyFrozenCol.firstChild,e,h,E,t,v,d,g+1),_=g+1,0===(p=o-(g+1))&&(this.m_endRowPixel+=b.totalRowHeight))):this._hasFrozenColumns()&&null!==this.m_colHeaderFrozen&&this.m_databodyFrozenCol.firstChild.childElementCount&&(b=this._populateFrozenContainer(this.m_databodyFrozenCol.firstChild,e,h,E,this.m_startCol,v,d,g+1),_=g+1,0===(p=o-(g+1))&&(this.m_endRowPixel+=b.totalRowHeight)),w=document.createDocumentFragment(),H=(b=this._addCellsToFragment(w,e,h,E,_,v,d,p)).totalColumnWidth,x=b.totalRowHeight,S=b.avgWidth,R=x/d,this._populateDatabody(M,w),y?(-1!==this.m_endRow&&0!==d&&this._highlightCellsAlongAxis(this.m_endRow,"row","index","remove",["borderHorizontalNone"]),this.m_endRow=h+(d-1),this.m_endRowPixel+=x):i?(h<this.m_startRow&&(this.m_startRow=h,this.m_startRowPixel=Math.max(0,this.m_startRowPixel-x)),this.m_endRow+=d,this.m_endRowPixel+=x,this.pushRowsDown(h+d,x)):(this.m_startRow-=d,this.m_startRowPixel-=x)}else if(f){if(v=(y=_>=this.m_startCol)?this.m_endColPixel:this.m_startColPixel,E=h>=this.m_startRow?this.m_startRowPixel:this.m_endRowPixel,!this.m_databody.firstChild.childElementCount&&y&&this._hasFrozenRows()&&this.m_initialized){const e=this.getResources().isRTLMode()?"right":"left",t=this.m_databodyFrozenRow.firstChild.lastChild;v=this.getElementDir(t,e)+this.getElementWidth(t)}this._hasFrozenRows()&&null!==this.m_rowHeaderFrozen&&(this._populateFrozenContainer(this.m_databodyFrozenRow.firstChild,e,this.m_startRow,E,_,v,c+1,p),d-=c+1,h=c+1),w=document.createDocumentFragment(),b=this._addCellsToFragment(w,e,h,E,_,v,d,p),this._populateDatabody(M,w),H=b.totalColumnWidth}if(null==S||0!==this.m_avgColWidth&&null!=this.m_avgColWidth||(this.m_avgColWidth=S),null==R||0!==this.m_avgRowHeight&&null!=this.m_avgRowHeight||(this.m_avgRowHeight=R),f&&(_<this.m_startCol?(this.m_startCol-=p,this.m_startColPixel-=H):(this.m_endCol=_+(p-1),this.m_endColPixel+=H)),this._sizeDatabodyScroller(),this.m_endCol>=0&&this.m_endRow>=0?this.m_hasCells=!0:(this.m_startCol=0,this.m_startRow=0),0===this.m_startCol&&0!==this.m_startColPixel&&(this._shiftCellsAlongAxis("column",-this.m_startColPixel,0,!0),this.m_endColPixel-=this.m_startColPixel,this.m_startColPixel=0),0===this.m_startRow&&0!==this.m_startRowPixel&&(this._shiftCellsAlongAxis("row",-this.m_startRowPixel,0,!0),this.m_endRowPixel-=this.m_startRowPixel,this.m_startRowPixel=0),!this.m_initialized&&this.m_startCol>0&&(I=Math.round(this.m_avgColWidth*this.m_startCol),this._shiftCellsAlongAxis("column",I-this.m_startColPixel,this.m_startCol,!0),this.m_endColPixel=I+H,this.m_startColPixel=I),!this.m_initialized&&this.m_startRow>0&&(I=Math.round(this.m_avgRowHeight*this.m_startRow),this._shiftCellsAlongAxis("row",I-this.m_startRowPixel,this.m_startRow,!0),this.m_endRowPixel=I+x,this.m_startRowPixel=I),this.m_fetching.cells=!1,this.isFetchComplete()){if(this.hideStatusText(),this.m_initialized)this._checkScroll&&this._checkScrollPosition();else{if(this.m_utils.isTouchDeviceNotIOS()&&Object.prototype.hasOwnProperty.call(window,"WebKitCSSMatrix")){const e="translate3d(0, 0, 0)";M.style.transform=e,null!=this.m_rowHeader&&(this.m_rowHeader.firstChild.style.transform=e),null!=this.m_colHeader&&(this.m_colHeader.firstChild.style.transform=e),null!=this.m_rowEndHeader&&(this.m_rowEndHeader.firstChild.style.transform=e),null!=this.m_colEndHeader&&(this.m_colEndHeader.firstChild.style.transform=e)}this._updateScrollPosition(this.m_options.getScrollPosition())}if(null!=this.m_scrollIndexAfterFetch?this.scrollToIndex(this.m_scrollIndexAfterFetch):null!=this.m_scrollHeaderAfterFetch?this.scrollToHeader(this.m_scrollHeaderAfterFetch):this.isActionableMode()||null==this._getActiveElement()||this.m_utils.containsCSSClassName(this._getActiveElement(),this.getMappedStyle("focus"))||(!0!==this.m_shouldFocus&&(this.m_shouldFocus=!1),this._highlightActive(),this._manageMoveCursor()),this._isSelectionEnabled()&&this.applySelection(h,h+d,_,_+p),this.populateAccInfo(),this._shouldInitialize())this._handleInitialization(!0);else if(this.m_initialized){var z;(!0===this.m_resizeRequired||this.m_endRowPixel-x<this.getElementHeight(C))&&this.resizeGrid(),m?y?z="top":i||(z="bottom"):f&&(z=_===this.m_startCol?"right":"left"),this._cleanupViewport(z),this.fillViewport(),this.isFetchComplete()&&this.fireEvent("ready",{})}}this._isSelectionEnabled()&&this.isMultipleSelection()&&this._resetHeaderHighLight();let D,A=this.getActiveDatabodyIndicators();m&&f||(m?D="row":f&&(D="column")),this.deleteAndApplyHiddenIndicators(A,D),this._signalTaskEnd()},A.prototype._setZIndexBefore=function(e,t,i,s){if("row"===e)for(var n=this.m_startRow,o=this.m_currentScrollTop,r=t;r>=n;r--){var l,a=this._getAxisCellsByIndex(r,e);if(this.getElementDir(a[0],"top")<o)break;for(var h=0;h<a.length;h++)a[h].style.zIndex=10;i&&(l=this._getHeaderByIndex(r,"row",0))&&(l.style.zIndex=10),s&&(l=this._getHeaderByIndex(r,"rowEnd",0))&&(l.style.zIndex=10)}},A.prototype._onEndEvent=function(e,t,i,s){var n;function o(){n&&(clearTimeout(n),n=void 0),t.removeEventListener(e,o),i()}t.addEventListener(e,o),n=setTimeout(o,s+100)},A.prototype._insertRowsWithAnimation=function(e,t,i,s,n,o,r,l){var a,h,d,m,c,u,_,p,g,f,C=this,y=0,E=0,v=0;C._signalTaskStart();var w=s>this.m_endRow,b=this.m_databody.firstChild,H=null!=t,x=null!=i;for(s>0&&(v=s-1,f=this._getAxisCellsByIndex(s-1,"row"),y=(E=this.getElementDir(f[0],"top"))+this.getElementHeight(f[0])),this._setZIndexBefore("row",v,H,x),H&&(d=(h=this.m_rowHeader.firstChild).childNodes[s-this.m_startRow-1]),x&&(c=(m=this.m_rowEndHeader.firstChild).childNodes[s-this.m_startRow-1]),a=0;a<e.childNodes.length;a++){var S=e.childNodes[a];p=E-(_=y+this.getElementDir(S,"top"))-this.getElementHeight(S),this.setElementDir(S,_,"top"),this.addTransformMoveStyle(S,0,0,"linear",0,p,0)}if(H)for(a=0;a<t.childNodes.length;a++)u=t.childNodes[a],p=E-(_=y+this.getElementDir(u,"top"))-this.getElementHeight(u),this.setElementDir(u,_,"top"),this.addTransformMoveStyle(u,0,0,"linear",0,p,0);if(x)for(a=0;a<i.childNodes.length;a++)g=i.childNodes[a],p=E-(_=y+this.getElementDir(g,"top"))-this.getElementHeight(g),this.setElementDir(g,_,"top"),this.addTransformMoveStyle(g,0,0,"linear",0,p,0);for(a=s;a<=this.m_endRow;a++){var R=this._getAxisCellsByIndex(a-this.m_startRow,"row");_=o+this.getElementDir(R[0],"top"),p=-o;for(var I=0;I<R.length;I++)this.setElementDir(R[I],_,"top"),this.addTransformMoveStyle(R[I],0,0,"linear",0,p,0);H&&(u=h.childNodes[a],this.setElementDir(u,_,"top"),this.addTransformMoveStyle(u,0,0,"linear",0,p,0)),x&&(g=m.childNodes[a],this.setElementDir(g,_,"top"),this.addTransformMoveStyle(g,0,0,"linear",0,p,0))}this._modifyAxisCellContextIndex("row",s,this.m_endRow-s+1,n),this.m_endRow+=n,this.m_endRowPixel+=o,H&&(this.m_endRowHeader+=t.childNodes.length,this.m_endRowHeaderPixel+=o),x&&(this.m_endRowEndHeader+=i.childNodes.length,this.m_endRowEndHeaderPixel+=o),b.appendChild(e),w?(H&&h.appendChild(t),x&&m.appendChild(i)):(H&&h.insertBefore(t,d.nextSibling),x&&m.insertBefore(i,c.nextSibling)),this.setElementHeight(b,this.getElementHeight(b)+o),this.resizeGrid(),this.updateRowBanding(),this._refreshDatabodyMap(),this._isSelectionEnabled()&&this.applySelection(s,s+n,r,r+l);var M=this._getCellByIndex(this.createIndex(s+(n-1),this.m_endCol));this.m_animating=!0;var F=C.m_processingEventQueue?1:A.EXPAND_ANIMATION_DURATION;this._onEndEvent("transitionend",M,function(){C._handleAnimationEnd()},F),setTimeout(function(){for(var e=A.EXPAND_ANIMATION_DURATION,t="ease-out",i=s;i<=C.m_endRow;i++){for(var n=C._getAxisCellsByIndex(i,"row"),o=0;o<n.length;o++)C.addTransformMoveStyle(n[o],e+"ms",0,t,0,0,0);H&&C.addTransformMoveStyle(h.childNodes[i],e+"ms",0,t,0,0,0),x&&C.addTransformMoveStyle(m.childNodes[i],e+"ms",0,t,0,0,0)}},0)},A.prototype._addCellsToFragment=function(e,t,i,s,n,o,r,l){var a=this.getResources().isRTLMode()?"right":"left";let h=0;var d=this.getRendererOrTemplate("cell"),m=this.m_options.getColumnBandingInterval(),c=this.m_options.getRowBandingInterval(),u=this.m_options.getHorizontalGridlines(),p=this.m_options.getVerticalGridlines();null==r&&(r=t.getCount("row")),null==l&&(l=t.getCount("column"));for(var g=i>=this.m_startRow,f=n>=this.m_startCol,C=0,y=s,E=[],v=[],w=0;w<r;w+=1){for(var b,H,x,S,R=o,I=g?i+w:i+(r-1-w),M=Math.floor(I/c)%2==1,F=0;F<l;F+=H.column){var z=0;b=0;var D,A=f?n+F:n+(l-1-F);H={row:(D=t.getExtent?t.getExtent(this.createIndex(I,A)):{row:{extent:1,more:{before:!1,after:!1}},column:{extent:1,more:{before:!1,after:!1}}}).row.extent,column:D.column.extent},f||(A=A-H.column+1);var L=g?I:I-H.row+1,T=this.createIndex(L,A);if(E[w]&&E[w][F])z=E[w][F].width,R=f?R+z:R-z;else{var N=this._patchExistingCells(D,A,L,E);if(N)z=N.width;else{var O=t.getData(this.createIndex(L,A)),k=t.getMetadata(this.createIndex(L,A));x=document.createElement("div"),S=this.createCellContext(T,O,k,x,H),x.setAttribute(this.getResources().getMappedAttribute("container"),this.getResources().widgetName),x.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),this._createUniqueId(x),x[this.getResources().getMappedAttribute("context")]=S,x[this.getResources().getMappedAttribute("metadata")]=k;const i=this.m_options.getHorizontalAlignment("cell",S),s=this.m_options.getVeticalAlignment("cell",S);if("auto"!==i){const e=this._getHorizontalAlignmentStyle(i);x.style.justifyContent=e.justifyContent,x.style.textAlign=e.textAlign}if("auto"!==s&&(x.style.alignItems=this._getVerticalAlignmentStyle(s)),void 0!==k.metadata?.validity){if("invalidShown"===k.metadata.validity){let e=document.createElement("div");this.m_utils.addCSSClassName(e,this.getMappedStyle("validationError")),x.appendChild(e),x.setAttribute("aria-invalid",!0)}}var P=this.m_options.getInlineStyle("cell",S);null!=P&&_.applyMergedInlineStyles(x,P,""),""!==x.style.height&&(x.style.height=""),""!==x.style.width&&(x.style.width=""),this.m_utils.addCSSClassName(x,this.getMappedStyle("cell")),this.m_utils.addCSSClassName(x,this.getMappedStyle("formcontrol")),(this._hasFrozenColumns()&&A<=this.m_frozenColIndex||this._hasFrozenRows()&&L<=this.m_frozenRowIndex)&&this.m_utils.addCSSClassName(x,this.getMappedStyle("frozenCell")),_.isIos()&&(x.setAttribute("aria-labelledby",this.getLabelledBy(this._createActiveObject(x),null,x,!0)),x.setAttribute("role","text")),(M||Math.floor(A/m)%2==1)&&this.m_utils.addCSSClassName(x,this.getMappedStyle("banded"));var B,W=this.m_options.getStyleClass("cell",S);if(null!=W&&(x.className+=" "+W),this._isGridEditable()){"disable"===this.m_options.isEditable("cell",S)&&(this._setAttribute(x,"readOnly",!0),this.m_utils.addCSSClassName(x,this.getMappedStyle("readOnly")))}for(B=0;B<H.row;B++){var j=0===B?S.keys.row:this._getKey(this._getHeaderByIndex(L+B,"row",0),"row");v[w+B]=this._getCellDimension(x,L+B,j,"row","height"),this.isHidden("row",L)&&(v[w+B]=0,x.style.display="none"),b+=v[w+B]}for(this.setElementHeight(x,b),B=0;B<H.column;B++){var K=0===B?S.keys.column:this._getKey(this._getHeaderByIndex(A+B,"column",0),"column");z+=this._getCellDimension(x,A,K,"column","width")}this.isHidden("column",A)&&(z=0,x.style.display="none",h+=1),this.setElementWidth(x,z),!x.classList.contains(this.getMappedStyle("frozenCell"))&&("hidden"===p||this._isLastColumn(A+(H.column-1))&&(this.getRowHeaderWidth()+R+z>=this.getWidth()||-1!==this.m_endRowEndHeader))&&this.m_utils.addCSSClassName(x,this.getMappedStyle("borderVerticalNone")),("hidden"===u||this._isLastRow(L+(H.row-1))&&(this.getRowBottom(x,y+b)>=this.getHeight()||-1!==this.m_endColEndHeader)&&!x.classList.contains(this.getMappedStyle("frozenCell")))&&this.m_utils.addCSSClassName(x,this.getMappedStyle("borderHorizontalNone")),g?this.setElementDir(x,y,"top"):this.setElementDir(x,y-b,"top"),f?this.setElementDir(x,R,a):this.setElementDir(x,R-z,a),this.m_isCustomElementCallback()&&this.m_root.appendChild(x),this._renderContent(d,S,x,O,this.buildCellTemplateContext(S,k)),e.appendChild(x)}this._updateTempArray(E,{width:z},w,F,H.row,H.column),R=f?R+z:R-z,0===w&&(C+=z)}}b=v[w],y=g?y+b:y-b,b}return{avgWidth:C/(l-h),totalRowHeight:v.reduce(function(e,t){return e+t},0),totalColumnWidth:C}},A.prototype._updateCellDimension=function(e,t,i,s,n,o,r,l){var a,h,d=0,m="width"===r?"height":"width",c=this._getCellByIndex(this.createIndex(s,i)),u=this.getElementDir(c,r),_=c[this.getResources().getMappedAttribute("context")];_.extents[o]+=e,"row"===o?a=s:"column"===o&&(a=i);for(var p=1;p<=e;p++){var g=this._getKey(this._getHeaderByIndex(l?a-p:a+p,o,0),o);d+=this._getCellDimension(c,l?a-p:a+p,g,o,r);for(var f=0;f<t;f++){var C,y;"row"===o?(C=l?s-p:s+p,y=i+f):(C=s+f,y=l?i-p:i+p),this._addIndexToDatabodyMap(this.createIndex(C,y),c.id)}}l&&(h="width"===r?this.getResources().isRTLMode()?"right":"left":"top",this.setElementDir(c,this.getElementDir(c,h)-d,h),_.indexes[o]-=e);this.setElementDir(c,u+d,r);var E={};return E[r]=d,E[m]=this.getElementDir(c,m),E.cell=c,E},A.prototype._patchExistingCells=function(e,t,i,s){var n=e.column.extent,o=e.row.extent,r=e.row.more.before,l=e.row.more.after,a=e.column.more.before,h=e.column.more.after;return t-1===this.m_endCol&&a?this._updateCellDimension(n,o,this.m_endCol,i,s,"column","width",!1):i-1===this.m_endRow&&r?this._updateCellDimension(o,n,t,this.m_endRow,s,"row","height",!1):t+n===this.m_startCol&&h?this._updateCellDimension(n,o,this.m_startCol,i,s,"column","width",!0):!(i+o!==this.m_startRow||!l)&&this._updateCellDimension(o,n,t,this.m_startRow,s,"row","height",!0)},A.prototype._updateTempArray=function(e,t,i,s,n,o){for(var r=0;r<n;r++){null==e[i+r]&&(e[i+r]=[]);for(var l=0;l<o;l++)e[i+r][s+l]=t}},A.prototype._getCellDimension=function(e,t,i,s,n){var o,r,l;if("row"===s?(o=this.getMappedStyle("rowheadercell")+" "+this.getMappedStyle("headercell"),r=this.m_endRowHeader):"column"===s&&(o=this.getMappedStyle("colheadercell")+" "+this.getMappedStyle("headercell"),r=this.m_endColHeader),-1===r){var a=this.createHeaderContext(s,t,null,{key:i},null,0,0,1),h=this.m_options.getInlineStyle(s,a),d=this.m_options.getStyleClass(s,a);l=document.createElement("div"),null!=h&&_.applyMergedInlineStyles(l,h,""),l.className=o+" "+d}else l=e;return this._getHeaderDimension(l,i,s,n)},A.prototype._getLabelDimension=function(e,t){let i,s,n;"column"===e?(i=this.m_columnHeaderLevelHeights,s="height",n=this.m_startColHeader):"columnEnd"===e?(i=this.m_columnEndHeaderLevelHeights,s="height",n=this.m_startColEndHeader):"row"===e?(i=this.m_rowHeaderLevelWidths,s="width",n=this.m_startRowHeader):(i=this.m_rowEndHeaderLevelWidths,s="width",n=this.m_startRowEndHeader);let o=i[t];if(null!=o)return o;const r=this._getHeaderByIndex(n,e,t),l=r[this.getResources().getMappedAttribute("context")],a=l.level,h=l.depth,d=this.getElementDir(r,s);let m=0,c=0;for(let e=a;e<a+h;e++){let t=i[e];null!=t?m+=t:c+=1}return 0===c?d:(o=Math.max(0,Math.round((d-m)/c)),i[t]=o,o)},A.prototype._modifyAndPushCells=function(e,t,i,s,n,o,r,l){let a=this.getResources().isRTLMode()?"right":"left",h="row"===i?"top":a,d=this.getResources().getMappedAttribute("context"),m=r?1:-1,c=function(i,s,n){i.forEach(i=>{let o=s(i),a=0;if(r)o>=e[0]&&(a=e.length);else for(;a<e.length&&!(e[a]>=o);a++);if(0===e.length&&l>0&&(a+=l),a>0){let s=t.length?t.slice(0,a).reduce((e,t)=>e+t):0;s*=m,a*=m,l&&e.length&&(a+=l*m),n(i,s,a,o)}})};if(c(s.firstChild.querySelectorAll("."+this.getMappedStyle("cell")),e=>e[d].indexes[i],(e,t,s)=>{if(0!==t){let i=this.getElementDir(e,h)+t;this.setElementDir(e,i,h)}e[d].indexes[i]+=s}),n){c(n.querySelectorAll("."+this.getMappedStyle("headercell")),e=>e[d].index,(e,t,i)=>{if(0!==t){let i=this.getElementDir(e,h)+t;this.setElementDir(e,i,h)}e[d].index+=i}),c(n.querySelectorAll("."+this.getMappedStyle("groupingcontainer")),e=>this._getAttribute(e,"start",!0),(e,t,i,s)=>{this._setAttribute(e,"start",s+i)})}if(o){c(o.querySelectorAll("."+this.getMappedStyle("endheadercell")),e=>e[d].index,(e,t,i)=>{if(0!==t){let i=this.getElementDir(e,h)+t;this.setElementDir(e,i,h)}e[d].index+=i}),c(o.querySelectorAll("."+this.getMappedStyle("groupingcontainer")),e=>this._getAttribute(e,"start",!0),(e,t,i,s)=>{this._setAttribute(e,"start",s+i)})}},A.prototype.pushRowsDown=function(e,t){for(;e<=this.m_endRow;){var i=this._getAxisCellsByIndex(e,"row");if(i.length>0)for(var s=0;s<i.length;s++){var n=i[s],o=this.getElementDir(n,"top")+t;n.style.top=o+"px"}e+=1}},A.prototype.pushRowsUp=function(e,t){this.pushRowsDown(e,-t)},A.prototype.pushRowHeadersDown=function(e,t){for(;e;){var i=this.getElementDir(e,"top")+t;e.style.top=i+"px",e=e.nextSibling}},A.prototype.pushRowHeadersUp=function(e,t){this.pushRowHeadersDown(e,-t)},A.prototype.createCellContext=function(e,t,i,s,n){var o={parentElement:s,indexes:e,cell:t};this._isDataGridProvider()?o.data=t:o.data=null!=t&&"object"==typeof t&&Object.prototype.hasOwnProperty.call(t,"data")?t.data:t,o.component=this,o.datasource=this.m_options.getProperty("data"),o.mode="navigation",o.extents=n;for(var r=Object.keys(i),l=0;l<r.length;l++){var a=r[l];o[a]=i[a]}return null!=this.m_createContextCallback&&this.m_createContextCallback.call(this,o),this.m_fixContextCallback.call(this,o)},A.prototype._createUniqueId=function(e){return this._uniqueIdCallback(e,!1)},A.prototype.getRowHeaderWidth=function(){return null===this.m_rowHeaderWidth?0:this.m_rowHeaderWidth},A.prototype.getColumnHeaderHeight=function(){return null===this.m_colHeaderHeight?0:this.m_colHeaderHeight},A.prototype.getRowEndHeaderWidth=function(){return-1===this.m_endRowEndHeader?0:this.m_rowEndHeaderWidth},A.prototype.getColumnEndHeaderHeight=function(){return-1===this.m_endColEndHeader?0:this.m_colEndHeaderHeight},A.prototype.getRowBottom=function(e,t){var i=this.getColumnHeaderHeight();if(null!=t)return i+t;var s=this.getElementDir(e,"top"),n=this.calculateRowHeight(e);return isNaN(s)||isNaN(n)?i:i+s+n},A.prototype.handleCellsFetchError=function(e,t){if(this.m_fetching.cells=!1,this.hideStatusText(),null!=this.m_databody.firstChild&&this.m_initialized){var i=t[0],s=t[1];s.start+(s.count-1)>this.m_endCol&&(this.m_stopColumnFetch=!0,this.m_stopColumnHeaderFetch=!0,this.m_stopColumnEndHeaderFetch=!0),i.start+(i.count-1)>this.m_endRow&&(this.m_stopRowFetch=!0,this.m_stopRowHeaderFetch=!0,this.m_stopRowEndHeaderFetch=!0)}else this._shouldInitialize()&&this._handleInitialization(!1);this._signalTaskEnd()},A.prototype._isFocusableElementBeforeCell=function(e){if(null==e||e===this.getRootElement()||this.m_utils.containsCSSClassName(e,this.getMappedStyle("cell")))return!1;var t=e.tagName;return!!("INPUT"===t||"TEXTAREA"===t||"SELECT"===t||"BUTTON"===t||"A"===t||this.m_utils.containsCSSClassName(e,this.getMappedStyle("active"))||null!=e.getAttribute("tabIndex")&&parseInt(e.getAttribute("tabIndex"),10)>=0&&this.findCell(e)!==e)||this._isFocusableElementBeforeCell(e.parentNode)},A.prototype._setFocusToFirstFocusableElement=function(e,t,i){_.enableAllFocusableElements(e);var s=_.getFocusableElementsInNode(e);if(s.length>0){var n=s[0];if(n.focus(),t&&t.preventDefault(),n.setSelectionRange&&n.value)try{n.setSelectionRange(n.value.length,n.value.length)}catch(e){}return!0===i&&"function"==typeof s[0].select&&n.select(),!0}return!1},A.prototype.handleScroll=function(e){if(this._clearScrollPositionTimeout(),this.m_handleScrollOverflow||(this.m_hasVerticalScroller||this.m_hasHorizontalScroller||(this.m_databody.style.overflow="hidden"),this.m_handleScrollOverflow=!0),this.m_animating)e.preventDefault();else if(!this.m_utils.isTouchDeviceNotIOS())if(!0!==this.m_silentScroll){var t=e.target,i=this.m_utils.getElementScrollLeft(t),s=t.scrollTop;this.scrollTo(i,s)}else this.m_silentScroll=!1},A.prototype._getMaxScrollWidth=function(){return this._isCountUnknownOrHighwatermark("column")&&!this.m_stopColumnFetch?Number.MAX_VALUE:this.m_scrollWidth},A.prototype._getMaxScrollHeight=function(){return this._isCountUnknownOrHighwatermark("row")&&!this.m_stopRowFetch?Number.MAX_VALUE:this.m_scrollHeight},A.prototype.scroll=function(e){if(null!=e.position){var t={};t.x=Math.max(0,Math.min(this.m_scrollWidth,e.position.scrollX)),t.y=Math.max(0,Math.min(this.m_scrollHeight,e.position.scrollY)),this._scrollToScrollPositionObject(t)}},A.prototype.scrollDelta=function(e,t){this._adjustScrollerSize();var i=Math.max(0,Math.min(this._getMaxScrollWidth(),this.m_currentScrollLeft-e)),s=Math.max(0,Math.min(this._getMaxScrollHeight(),this.m_currentScrollTop-t));this._initiateScroll(i,s)},A.prototype.adjustTouchScroll=function(e,t){return this.m_utils.isTouchDevice()&&0!==e&&0!==t&&(Math.abs(e)>Math.abs(t)?(t=0,this.m_extraScrollOverY=null):(e=0,this.m_extraScrollOverX=null)),[e,t]},A.prototype._initiateScroll=function(e,t){this.m_utils.isTouchDeviceNotIOS()?this.scrollTo(e,t):(this.m_utils.setElementScrollLeft(this.m_databody,e),this.m_databody.scrollTop=t,this.m_databody.firstChild.childElementCount||!this._hasFrozenColumns()&&!this._hasFrozenRows()||this.scrollTo(e,t))},A.prototype._initiateScrollOnAttached=function(){this._initiateScroll(this.m_currentScrollLeft,this.m_currentScrollTop)},A.prototype._disableTouchScrollAnimation=function(){this.m_databody.firstChild.style.transitionDuration="0ms",this.m_rowHeader.firstChild.style.transitionDuration="0ms",this.m_colHeader.firstChild.style.transitionDuration="0ms",this.m_rowEndHeader.firstChild.style.transitionDuration="0ms",this.m_colEndHeader.firstChild.style.transitionDuration="0ms"},A.prototype._shouldLongScroll=function(e,t){return!this._isHighWatermarkScrolling()&&(e+this.getViewportWidth()<this._getMaxLeftPixel()||t+this.getViewportHeight()<this._getMaxTopPixel()||e>this._getMaxRightPixel()||t>this._getMaxBottomPixel())},A.prototype.scrollTo=function(e,t){if(this.m_prevScrollLeft=this.m_currentScrollLeft,this.m_currentScrollLeft=e,this.m_prevScrollTop=this.m_currentScrollTop,this.m_currentScrollTop=t,this._checkScroll=!1,this.m_utils.isTouchDeviceNotIOS()||(this._shouldLongScroll(e,t)?this.handleLongScroll(e,t):this.fillViewport(),this._checkScroll=!0),this._syncScroller(),this._adjustScrollerSize(),null!=this.m_cellToFocus){var i=this.m_cellToFocus;this.m_cellToFocus=null,this._setActive(i,this._createActiveObject(i),null,!1,!1,!0)}if(null!=this.m_scrollIndexAfterFetch&&this._isInViewport(this.m_scrollIndexAfterFetch)===A.INSIDE&&(this._isDatabodyCellActive()&&this.m_scrollIndexAfterFetch.row===this.m_active.indexes.row&&this.m_scrollIndexAfterFetch.column===this.m_active.indexes.column&&this._highlightActive(),this.m_scrollIndexAfterFetch=null),null!=this.m_scrollHeaderAfterFetch){let e="row";const t=this.m_scrollHeaderAfterFetch.index;"column"!==this.m_scrollHeaderAfterFetch.axis&&"columnEnd"!==this.m_scrollHeaderAfterFetch.axis||(e="column"),this._isAxisIndexInViewport(t,e)===A.INSIDE&&(this._isDatabodyCellActive()||this.m_scrollHeaderAfterFetch.axis!==this.m_active.axis||this.m_scrollHeaderAfterFetch.index!==this.m_active.index||this.m_scrollHeaderAfterFetch.level!==this.m_active.level||this._highlightActive(),this.m_scrollHeaderAfterFetch=null)}this.m_utils.isTouchDeviceNotIOS()||this.m_prevScrollTop===t&&this.m_prevScrollLeft===e||this.fireEvent("scroll",{event:null,ui:{scrollX:e,scrollY:t}}),!this.m_utils.isTouchDeviceNotIOS()&&this.isFetchComplete()&&this._checkScrollPosition()},A.prototype._scrollTransitionEnd=function(){this._isSelectionEnabled()&&this._scrollTouchSelectionAffordance(),this.fireEvent("scroll",{event:null,ui:{scrollX:this.m_currentScrollLeft,scrollY:this.m_currentScrollTop}}),this._shouldLongScroll(this.m_currentScrollLeft,this.m_currentScrollTop)?this.handleLongScroll(this.m_currentScrollLeft,this.m_currentScrollTop):this.fillViewport(),this._checkScroll=!0,this.isFetchComplete()&&this._checkScrollPosition()},A.prototype._bounceBack=function(){var e=this.m_currentScrollLeft,t=this.m_currentScrollTop,i=this.m_databody.firstChild,s=this.m_colHeader.firstChild,n=this.m_rowHeader.firstChild,o=this.m_colEndHeader.firstChild,r=this.m_rowEndHeader.firstChild;i.style.transitionDuration=A.BOUNCE_ANIMATION_DURATION+"ms",n.style.transitionDuration=A.BOUNCE_ANIMATION_DURATION+"ms",r.style.transitionDuration=A.BOUNCE_ANIMATION_DURATION+"ms",s.style.transitionDuration=A.BOUNCE_ANIMATION_DURATION+"ms",o.style.transitionDuration=A.BOUNCE_ANIMATION_DURATION+"ms",null==this.m_scrollTransitionEnd&&(this.m_scrollTransitionEnd=this._scrollTransitionEnd.bind(this)),this._onEndEvent("transitionend",i,this.m_scrollTransitionEnd,A.BOUNCE_ANIMATION_DURATION),this.getResources().isRTLMode()?(i.style.transform="translate3d("+e+"px, "+-t+"px, 0)",s.style.transform="translate3d("+e+"px, 0, 0)",o.style.transform="translate3d("+e+"px, 0, 0)"):(i.style.transform="translate3d("+-e+"px, "+-t+"px, 0)",s.style.transform="translate3d("+-e+"px, 0, 0)",o.style.transform="translate3d("+-e+"px, 0, 0)"),n.style.transform="translate3d(0, "+-t+"px, 0)",r.style.transform="translate3d(0, "+-t+"px, 0)",this.m_extraScrollOverX=null,this.m_extraScrollOverY=null},A.prototype._syncScroller=function(){var e=this.m_currentScrollLeft,t=this.m_currentScrollTop,i=this.m_databody.firstChild,s=this.m_colHeader.firstChild,n=this.m_rowHeader.firstChild,o=this.m_colEndHeader.firstChild,r=this.m_rowEndHeader.firstChild;let l,a;if(this.m_databodyFrozenCol&&(l=this.m_databodyFrozenCol.firstChild),this.m_databodyFrozenRow&&(a=this.m_databodyFrozenRow.firstChild),this.m_utils.isTouchDeviceNotIOS()&&Object.prototype.hasOwnProperty.call(window,"WebKitCSSMatrix"))this._checkScroll=!1,null!=this.m_extraScrollOverX||null!=this.m_extraScrollOverY?(null!=this.m_extraScrollOverX?e+=this.m_extraScrollOverX:t+=this.m_extraScrollOverY,null==this.m_bounceBack&&(this.m_bounceBack=this._bounceBack.bind(this)),this._onEndEvent("transitionend",i,this.m_bounceBack,500)):"0ms"===i.style.transitionDuration?this._scrollTransitionEnd():(null==this.m_scrollTransitionEnd&&(this.m_scrollTransitionEnd=this._scrollTransitionEnd.bind(this)),this._onEndEvent("transitionend",i,this.m_scrollTransitionEnd,i.style.transitionDuration)),this.getResources().isRTLMode()?(i.style.transform="translate3d("+e+"px, "+-t+"px, 0)",s.style.transform="translate3d("+e+"px, 0, 0)",o.style.transform="translate3d("+e+"px, 0, 0)"):(i.style.transform="translate3d("+-e+"px, "+-t+"px, 0)",s.style.transform="translate3d("+-e+"px, 0, 0)",o.style.transform="translate3d("+-e+"px, 0, 0)"),n.style.transform="translate3d(0, "+-t+"px, 0)",r.style.transform="translate3d(0, "+-t+"px, 0)";else{var h=this.getResources().isRTLMode()?"right":"left";this.setElementDir(s,-e,h),this.setElementDir(o,-e,h),this.setElementDir(n,-t,"top"),this.setElementDir(r,-t,"top"),a&&this.setElementDir(a,-e,h),l&&this.setElementDir(l,-t,"top")}},A.prototype._adjustScrollerSize=function(){var e=this.m_databody.firstChild,t=this.getElementHeight(e),i=this.getElementWidth(e),s=this._getEmptyElement(),n=0,o=0;s&&(n=this.getElementHeight(s),o=this.getElementWidth(s)),(this._getMaxBottomPixel()>t||this.getDataSource().getCount("row")===this._getMaxBottom()+1&&!this._isCountUnknown("row")&&this._getMaxBottom()>-1)&&this.setElementHeight(e,Math.max(this._getMaxBottomPixel(),n)),(this._getMaxRightPixel()>i||this.getDataSource().getCount("column")===this._getMaxRight()+1&&!this._isCountUnknown("column")&&this._getMaxRight()>-1)&&this.setElementWidth(e,Math.max(this._getMaxRightPixel(),o))},A.prototype._getLongScrollStart=function(e,t,i){var s,n,o,r,l,a,h,d;if(t!==e){"row"===i?(s=this.getElementHeight(this.m_databody.firstChild),n=this.m_utils._getMaxDivHeightForScrolling(),o=this._getMaxScrollHeight(),r=this.m_avgRowHeight,l=this.m_hasHorizontalScroller?this.m_utils.getScrollbarSize():0,d=Math.max(Math.max(this.getDataSource().getCount(i),this.m_endRow),0)):"column"===i&&(s=this.getElementWidth(this.m_databody.firstChild),n=this.m_utils._getMaxDivWidthForScrolling(),o=this._getMaxScrollWidth(),r=this.m_avgColWidth,l=this.m_hasVerticalScroller?this.m_utils.getScrollbarSize():0,d=Math.max(Math.max(this.getDataSource().getCount(i),this.m_endCol),0));var m=Math.max(Math.min(e/s,1),0),c=this.getFetchSize(i);a=Math.floor(d*m),h=n<=s?Math.min(e,o):a*r,(1===m||e+c*r>s-l)&&(a=Math.max(d-c,0),h=Math.max(s-c*r,0))}else"row"===i?(a=null!=this.m_longScrollRow?this.m_longScrollRow:this.m_startRow,h=null!=this.m_longScrollRowPixel?this.m_longScrollRowPixel:this.m_startRowPixel):"column"===i&&(a=null!=this.m_longScrollColumn?this.m_longScrollColumn:this.m_startCol,h=null!=this.m_longScrollColumnPixel?this.m_longScrollColumnPixel:this.m_startColPixel);return{start:a,startPixel:h}},A.prototype.handleLongScroll=function(e,t){this.m_isLongScroll=!0;const i=this._getLongScrollStart(t,this.m_prevScrollTop,"row");this.m_longScrollRow=i.start,this.m_longScrollRowPixel=i.startPixel;const s=this._getLongScrollStart(e,this.m_prevScrollLeft,"column");if(this.m_longScrollColumn=s.start,this.m_longScrollColumnPixel=s.startPixel,this.isSkeletonSupport()&&this.loadSkeletons(t,e,this.m_longScrollRow,this.m_longScrollColumn,this.m_longScrollRowPixel,this.m_longScrollColumnPixel),this.isFetchComplete()&&this._isScrollBackToEditable(!0)){const e=this.m_longScrollRow,t=this.m_longScrollRowPixel,i=this.m_longScrollColumn,s=this.m_longScrollColumnPixel;let n=!0,o=()=>{n&&(n=!1,this.m_resizeRequired=!0,this.m_hasCells&&(this.m_startRow=e,this.m_endRow=-1,this.m_startRowPixel=t,this.m_endRowPixel=t,this.m_startCol=i,this.m_endCol=-1,this.m_startColPixel=s,this.m_endColPixel=s),this.m_hasRowHeader&&(this.m_startRowHeader=e,this.m_endRowHeader=-1,this.m_startRowHeaderPixel=t,this.m_endRowHeaderPixel=t),this.m_hasRowEndHeader&&(this.m_startRowEndHeader=e,this.m_endRowEndHeader=-1,this.m_startRowEndHeaderPixel=t,this.m_endRowEndHeaderPixel=t),this.m_hasColHeader&&(this.m_startColHeader=i,this.m_endColHeader=-1,this.m_startColHeaderPixel=s,this.m_endColHeaderPixel=s),this.m_hasColEndHeader&&(this.m_startColEndHeader=i,this.m_endColEndHeader=-1,this.m_startColEndHeaderPixel=s,this.m_endColEndHeaderPixel=s),this.m_stopRowFetch=!1,this.m_stopRowHeaderFetch=!1,this.m_stopRowEndHeaderFetch=!1,this.m_stopColumnFetch=!1,this.m_stopColumnHeaderFetch=!1,this.m_stopColumnEndHeaderFetch=!1)};this.fetchHeaders("row",e,this.m_rowHeader,this.m_rowEndHeader,void 0,{success:function(e,t,i){o(),this.handleHeadersFetchSuccessForLongScroll(e,t,i)}}),this.fetchHeaders("column",i,this.m_colHeader,this.m_colEndHeader,void 0,{success:function(e,t,i){o(),this.handleHeadersFetchSuccessForLongScroll(e,t,i)}}),this.fetchCells(this.m_databody,e,i,null,null,{success:function(n,r){o(),this.handleCellsFetchSuccessForLongScroll(n,r,e,i,t,s)}})}},A.prototype.handleHeadersFetchSuccessForLongScroll=function(e,t,i){let s=this.m_rowHeader.firstChild,n=this.m_rowEndHeader.firstChild;"column"===t.axis&&(s=this.m_colHeader.firstChild,n=this.m_colEndHeader.firstChild),null!=s&&this._removeAllNonSkeletonContainerNodes(s),null!=n&&this._removeAllNonSkeletonContainerNodes(n),this.handleHeadersFetchSuccess(e,t,i,!1)},A.prototype.handleCellsFetchSuccessForLongScroll=function(e,t,i,s,n,o){const r=this.m_databody.firstChild;if(null!=r&&!this._getEmptyElement()){this._getAllNonSkeletonContainerNodes(r).forEach(e=>{this._remove(e)})}this.handleCellsFetchSuccess(e,t)},A.prototype._cleanupViewport=function(e){if(!this._isHighWatermarkScrolling()&&this._isScrollBackToEditable()){null==e&&(this.m_prevScrollLeft>this.m_currentScrollLeft?e="right":this.m_prevScrollLeft<this.m_currentScrollLeft?e="left":this.m_prevScrollTop>this.m_currentScrollTop?e="bottom":this.m_prevScrollTop<this.m_currentScrollTop&&(e="top"));var t=this._getViewportLeft(),i=this._getViewportRight(),s=this._getViewportTop(),n=this._getViewportBottom();"top"===e&&s>this._getMaxTopPixel()?(this.removeRowsFromTop(this.m_databody),this.removeRowHeadersFromTop()):"bottom"===e&&n<this._getMaxBottomPixel()?(this.removeRowsFromBottom(this.m_databody),this.removeRowHeadersFromBottom()):"left"===e&&t>this._getMaxLeftPixel()?(this.removeColumnsFromLeft(this.m_databody),this.removeColumnHeadersFromLeft()):"right"===e&&i<this._getMaxRightPixel()&&(this.removeColumnsFromRight(this.m_databody),this.removeColumnHeadersFromRight())}},A.prototype.fillViewport=function(){var e,t;const i=this._getLongScrollStart(this.m_currentScrollTop,this.m_prevScrollTop,"row"),s=this._getLongScrollStart(this.m_currentScrollLeft,this.m_prevScrollLeft,"column");if(this.isSkeletonSupport()&&this.loadSkeletons(this.m_currentScrollTop,this.m_currentScrollLeft,i.start,s.start,i.startPixel,s.startPixel),this.isFetchComplete()){var n=this._getViewportLeft(),o=this._getViewportRight()+A.FETCH_PIXEL_THRESHOLD,r=this._getViewportTop(),l=this._getViewportBottom()+A.FETCH_PIXEL_THRESHOLD;if(this._getMaxBottomPixel()<=l&&(!this.m_stopRowHeaderFetch||!this.m_stopRowEndHeaderFetch||!this.m_stopRowFetch))return e=Math.max(0,this._getMaxBottom()+1),t=Math.max(0,this.getFetchCount("row",e)),this.fetchHeaders("row",e,this.m_rowHeader,this.m_rowEndHeader,t),void this.fetchCells(this.m_databody,e,this.m_startCol,t,this.m_endCol-this.m_startCol+1);if((this._getMaxTopPixel()>r||0===this.m_currentScrollTop)&&this._getMaxTop()>0)return e=Math.max(0,this._getMaxTop()-this.getFetchSize("row")),t=Math.max(0,this._getMaxTop()-e),this.fetchHeaders("row",e,this.m_rowHeader,this.m_rowEndHeader,t),void this.fetchCells(this.m_databody,e,this.m_startCol,t,this.m_endCol-this.m_startCol+1);if(this._getMaxRightPixel()<=o&&(!this.m_stopColumnHeaderFetch||!this.m_stopColumnEndHeaderFetch||!this.m_stopColumnFetch))return e=Math.max(0,this._getMaxRight()+1),t=Math.max(0,this.getFetchCount("column",e)),this.fetchHeaders("column",e,this.m_colHeader,this.m_colEndHeader,t),void this.fetchCells(this.m_databody,this.m_startRow,e,this.m_endRow-this.m_startRow+1,t);(this._getMaxLeftPixel()>n||0===this.m_currentScrollLeft)&&this._getMaxLeft()>0&&(e=Math.max(0,this._getMaxLeft()-this.getFetchSize("column")),t=Math.max(0,this._getMaxLeft()-e),this.fetchHeaders("column",e,this.m_colHeader,this.m_colEndHeader,t),this.fetchCells(this.m_databody,this.m_startRow,e,this.m_endRow-this.m_startRow+1,t))}},A.prototype._getMaxRight=function(){return Math.max(this.m_endCol,this.m_endColHeader,this.m_endColEndHeader)},A.prototype._getMaxLeft=function(){return Math.max(this.m_startCol,this.m_startColHeader,this.m_startColEndHeader)},A.prototype._getMaxRightPixel=function(){return Math.max(this.m_endColPixel,this.m_endColHeaderPixel,this.m_endColEndHeaderPixel)},A.prototype._getMaxLeftPixel=function(){return Math.max(this.m_startColPixel,this.m_startColHeaderPixel,this.m_startColEndHeaderPixel)},A.prototype._getMaxBottom=function(){return Math.max(this.m_endRow,this.m_endRowHeader,this.m_endRowEndHeader)},A.prototype._getMaxTop=function(){return Math.max(this.m_startRow,this.m_startRowHeader,this.m_startRowEndHeader)},A.prototype._getMaxBottomPixel=function(){return Math.max(this.m_endRowPixel,this.m_endRowHeaderPixel,this.m_endRowEndHeaderPixel)},A.prototype._getMaxTopPixel=function(){return Math.max(this.m_startRowPixel,this.m_startRowHeaderPixel,this.m_startRowEndHeaderPixel)},A.prototype._isScrollBackToEditable=function(e){var t=this._getCurrentMode(),i=this._getActiveElement();return"edit"!==t||!e&&!this._isCellGoingToBeRemoved(i)||this._handleExitEdit(null,i)},A.prototype._isCellGoingToBeRemoved=function(e){if(!this._isHighWatermarkScrolling()){if(this.m_endRow-this.m_startRow>this.MAX_ROW_THRESHOLD){var t=this.getElementDir(e.parentNode,"top");if(t+this.getElementHeight(e)<this.m_currentScrollTop||t<this.m_currentScrollTop+this.getViewportHeight())return!0}if(this.m_endCol-this.m_startCol>this.MAX_COLUMN_THRESHOLD){var i=this.getElementDir(e,"left");if(i+this.getElementWidth(e)<this.m_currentScrollLeft||i<this.m_currentScrollLeft+this.getViewportHeight())return!0}}},A.prototype._removeCellsAlongAxis=function(e,t,i){var s,n,o,r,l,a,h,d,m,c,u,_,p=0,g=0;for("row"===e?(n=this.m_startRow,o=this.m_endRow,r=this.m_rowHeaderLevelCount,l="height",a=this.m_startRowPixel,h=this.m_endRowPixel,d=this.m_currentScrollTop,m="column",c=this.m_startCol,u=this.m_endCol,_="top",s=i?o:n):(n=this.m_startCol,o=this.m_endCol,r=this.m_columnHeaderLevelCount,l="width",a=this.m_startColPixel,h=this.m_endColPixel,d=this.m_currentScrollLeft,m="row",c=this.m_startRow,u=this.m_endRow,_=this.getResources().isRTLMode()?"right":"left",s=i?o:n);s<=o&&s>=n;){var f=this._getKey(this._getHeaderByIndex(s,e,r-1),e);null==f&&(f=this._getKey(this._getCellByIndex("column"===e?this.createIndex(this.m_startRow,s):this.createIndex(s,this.m_startCol)),e));var C=this.isHidden(e,s)?0:this._getCellDimension(null,s,f,e,l);if(!(i?h-C-p>t:a+C+p<d-t))break;for(var y,E=c;E<=u;E+=y){var v=this._getCellByIndex("column"===e?this.createIndex(E,s):this.createIndex(s,E)),w=v[this.getResources().getMappedAttribute("context")],b=w.extents[e];y=w.extents[m],1===b?(this._remove(v),this.isHidden(e,s)&&this._remove(this.getHiddenIndicatorByIndex(s,this.m_databody.firstChild,!1))):(w.extents[e]-=1,this.setElementDir(v,this.getElementDir(v,l)-C,l),i||(w.indexes[e]+=1,this.setElementDir(v,this.getElementDir(v,_)+C,_)));for(var H=0;H<y;H++){var x="column"===e?this.createIndex(E+H,s):this.createIndex(s,E+H);this._removeIndexFromDatabodyMap(x)}}p+=C,g+=1,s=i?s-1:s+1}return{dimensionChange:p,extentChange:g}},A.prototype.removeHeadersFromStartOfContainer=function(e,t,i,s,n,o,r,l){const a=this.getResources().getMappedAttribute("context");var h=0,d=0;let m=Array.from(e.children).filter(e=>this.m_utils.containsCSSClassName(e,n)||this.m_utils.containsCSSClassName(e,this.getMappedStyle("groupingcontainer")));var c=null==t?m[0]:t.nextSibling;if(null==c)return{extentChange:0,dimensionChange:0};for(var u=this.m_utils.containsCSSClassName(c,n),_=u?c:c.firstChild,p=this.getElementDir(_,o);i+p<l-s;){if(this._remove(c),u){let t=c[a].axis,i=c[a].index;this.isHidden(t,i)&&this._remove(this.getHiddenIndicatorByIndex(i,e,!0))}if(m.shift(),d+=p,h+=u?1:this._getAttribute(c,"extent",!0),i+=p,null==(c=null==t?m[0]:t.nextSibling))return{extentChange:h,dimensionChange:d};_=(u=this.m_utils.containsCSSClassName(c,n))?c:c.firstChild,p=this.getElementDir(_,o)}if(!u){var g=this.removeHeadersFromStartOfContainer(c,c.firstChild,i,s,n,o,r,l);this._setAttribute(c,"start",this._getAttribute(c,"start",!0)+g.extentChange),this._setAttribute(c,"extent",this._getAttribute(c,"extent",!0)-g.extentChange),this.setElementDir(_,this.getElementDir(_,r)+g.dimensionChange,r),this.setElementDir(_,this.getElementDir(_,o)-g.dimensionChange,o),_[a].index+=g.extentChange,_[a].extent-=g.extentChange,h+=g.extentChange,d+=g.dimensionChange}return{extentChange:h,dimensionChange:d}},A.prototype.removeHeadersFromEndOfContainer=function(e,t,i,s,n){const o=this.getResources().getMappedAttribute("context");var r=0,l=0;let a=Array.from(e.children).filter(e=>this.m_utils.containsCSSClassName(e,s)||this.m_utils.containsCSSClassName(e,this.getMappedStyle("groupingcontainer"))),h=a[a.length-1];for(var d=this.m_utils.containsCSSClassName(h,s),m=d?h:h.firstChild,c=this.getElementDir(m,n);t-c>i;){if(this._remove(h),d){let t=h[o].axis,i=h[o].index;this.isHidden(t,i)&&this._remove(this.getHiddenIndicatorByIndex(i,e,!0))}a.pop(),l+=c,r+=d?1:this._getAttribute(h,"extent",!0),t-=c,h=a[a.length-1],m=(d=this.m_utils.containsCSSClassName(h,s))?h:h.firstChild,c=this.getElementDir(m,n)}if(!d){var u=this.removeHeadersFromEndOfContainer(h,t,i,s,n);this._setAttribute(h,"extent",this._getAttribute(h,"extent",!0)-u.extentChange),this.setElementDir(m,this.getElementDir(m,n)-u.dimensionChange,n),m[o].extent-=u.extentChange,r+=u.extentChange,l+=u.dimensionChange}return{extentChange:r,dimensionChange:l}},A.prototype.removeColumnHeadersFromLeft=function(){var e,t;if(this.m_endColHeader-this.m_startColHeader>this.MAX_COLUMN_THRESHOLD){var i=this.m_colHeader.firstChild;e=this.getColumnThreshold(),this.m_startColHeaderPixel<=this.m_currentScrollLeft-e&&(t=this.removeHeadersFromStartOfContainer(i,null,this.m_startColHeaderPixel,e,this.getMappedStyle("colheadercell"),"width",this.getResources().isRTLMode()?"right":"left",this.m_currentScrollLeft),this.m_startColHeaderPixel+=t.dimensionChange,this.m_startColHeader+=t.extentChange)}if(this.m_endColEndHeader-this.m_startColEndHeader>this.MAX_COLUMN_THRESHOLD){var s=this.m_colEndHeader.firstChild;e=this.getColumnThreshold(),this.m_startColEndHeaderPixel<this.m_currentScrollLeft-e&&(t=this.removeHeadersFromStartOfContainer(s,null,this.m_startColEndHeaderPixel,e,this.getMappedStyle("colendheadercell"),"width",this.getResources().isRTLMode()?"right":"left",this.m_currentScrollLeft),this.m_startColEndHeaderPixel+=t.dimensionChange,this.m_startColEndHeader+=t.extentChange)}},A.prototype.removeColumnsFromLeft=function(e){if(this.m_endCol-this.m_startCol>this.MAX_COLUMN_THRESHOLD){var t=e.firstChild.querySelectorAll("."+this.getMappedStyle("cell")),i=this.getColumnThreshold();if(t.length<1)return;var s=this._removeCellsAlongAxis("column",i,!1);this.m_startColPixel+=s.dimensionChange,this.m_startCol+=s.extentChange}},A.prototype.removeColumnHeadersFromRight=function(){var e,t,i=this.m_currentScrollLeft+this.getViewportWidth()+this.getColumnThreshold();this.m_endColHeader-this.m_startColHeader>this.MAX_COLUMN_THRESHOLD&&(e=this.m_colHeader.firstChild,this.m_endColHeaderPixel>i&&(this.m_stopColumnHeaderFetch&&(this.m_stopColumnHeaderFetch=!1),t=this.removeHeadersFromEndOfContainer(e,this.m_endColHeaderPixel,i,this.getMappedStyle("colheadercell"),"width"),this.m_endColHeaderPixel-=t.dimensionChange,this.m_endColHeader-=t.extentChange)),this.m_endColEndHeader-this.m_startColEndHeader>this.MAX_COLUMN_THRESHOLD&&(e=this.m_colEndHeader.firstChild,this.m_endColEndHeaderPixel>i&&(this.m_stopColumnEndHeaderFetch&&(this.m_stopColumnEndHeaderFetch=!1),t=this.removeHeadersFromEndOfContainer(e,this.m_endColEndHeaderPixel,i,this.getMappedStyle("colendheadercell"),"width"),this.m_endColEndHeaderPixel-=t.dimensionChange,this.m_endColEndHeader-=t.extentChange))},A.prototype.removeColumnsFromRight=function(e){if(this.m_endCol-this.m_startCol>this.MAX_COLUMN_THRESHOLD){var t=e.firstChild.querySelectorAll("."+this.getMappedStyle("cell")),i=this.m_currentScrollLeft+this.getViewportWidth()+this.getColumnThreshold();if(this.m_endColPixel<=i||t.length<1)return;this.m_stopColumnFetch&&(this.m_stopColumnFetch=!1);var s=this._removeCellsAlongAxis("column",i,!0);this.m_endColPixel-=s.dimensionChange,this.m_endCol-=s.extentChange}},A.prototype.removeRowHeadersFromTop=function(){var e,t;if(this.m_endRowHeader-this.m_startRowHeader>this.MAX_ROW_THRESHOLD){var i=this.m_rowHeader.firstChild;t=this.getRowThreshold(),this.m_startRowHeaderPixel>=this.m_currentScrollTop-t||(e=this.removeHeadersFromStartOfContainer(i,null,this.m_startRowHeaderPixel,t,this.getMappedStyle("rowheadercell"),"height","top",this.m_currentScrollTop),this.m_startRowHeaderPixel+=e.dimensionChange,this.m_startRowHeader+=e.extentChange)}if(this.m_endRowEndHeader-this.m_startRowEndHeader>this.MAX_ROW_THRESHOLD){var s=this.m_rowEndHeader.firstChild;t=this.getRowThreshold(),this.m_startRowEndHeaderPixel>=this.m_currentScrollTop-t||(e=this.removeHeadersFromStartOfContainer(s,null,this.m_startRowEndHeaderPixel,t,this.getMappedStyle("rowendheadercell"),"height","top",this.m_currentScrollTop),this.m_startRowEndHeaderPixel+=e.dimensionChange,this.m_startRowEndHeader+=e.extentChange)}},A.prototype.removeRowsFromTop=function(e){if(this.m_endRow-this.m_startRow>this.MAX_ROW_THRESHOLD){var t=this.getRowThreshold();if(this.m_startRowPixel>=this.m_currentScrollTop-t)return;var i=this._removeCellsAlongAxis("row",t,!1);this.m_startRowPixel+=i.dimensionChange,this.m_startRow+=i.extentChange}},A.prototype.removeRowHeadersFromBottom=function(){var e,t=this.m_currentScrollTop+this.getViewportHeight()+this.getRowThreshold();if(this.m_endRowHeader-this.m_startRowHeader>this.MAX_ROW_THRESHOLD){var i=this.m_rowHeader.firstChild;this.m_endRowHeaderPixel<=t||(this.m_stopRowHeaderFetch&&(this.m_stopRowHeaderFetch=!1),e=this.removeHeadersFromEndOfContainer(i,this.m_endRowHeaderPixel,t,this.getMappedStyle("rowheadercell"),"height"),this.m_endRowHeaderPixel-=e.dimensionChange,this.m_endRowHeader-=e.extentChange)}if(this.m_endRowEndHeader-this.m_startRowEndHeader>this.MAX_ROW_THRESHOLD){var s=this.m_rowEndHeader.firstChild;this.m_endRowEndHeaderPixel<=t||(this.m_stopRowEndHeaderFetch&&(this.m_stopRowEndHeaderFetch=!1),e=this.removeHeadersFromEndOfContainer(s,this.m_endRowEndHeaderPixel,t,this.getMappedStyle("rowendheadercell"),"height"),this.m_endRowEndHeaderPixel-=e.dimensionChange,this.m_endRowEndHeader-=e.extentChange)}},A.prototype.removeRowsFromBottom=function(e){if(this.m_endRow-this.m_startRow>this.MAX_ROW_THRESHOLD){var t=this.m_currentScrollTop+this.getViewportHeight()+this.getRowThreshold();if(this.m_endRowPixel<=t)return;this.m_stopRowFetch&&(this.m_stopRowFetch=!1);var i=this._removeCellsAlongAxis("row",t,!0);this.m_endRowPixel-=i.dimensionChange,this.m_endRow-=i.extentChange}},A.prototype.handleContextMenuGesture=function(e,t,i){let s,n,o;const r="disable",l=e.originalEvent.target;let a=!1,h=!1,d=!1,m=this.findCell(l);if(m&&(d=!0),null===m&&(m=this.findHeader(l),m&&(a=!0)),null===m&&(m=this.findLabel(l),m&&(h=!0)),"touch"===t&&null!=m){s=a?this.getHeaderCellIndex(m):this.getCellIndexes(m);let t=a?this._isHeaderInsideSelection(s,this.getHeaderCellAxis(m)):this._isContainSelection(s);(!this.isMultipleSelection()||!t||this._isDatabodyCellActive()&&s.row!==this.m_active.indexes.row&&s.column!==this.m_active.indexes.column)&&(this._isSelectionEnabled()?this.handleDatabodyClickSelection(e.originalEvent):this.handleDatabodyClickActive(e.originalEvent))}if(!this.m_utils._isNodeEditableOrClickable(l,this.m_root)){if(m&&d)s=this.getCellIndexes(m),this.isMultipleSelection()&&this._isContainSelection(s)?(o=this._getActiveElement(),this._isDatabodyCellActive()?(null==o&&(o=m),n=this._getCellCapability(o)):n=this._getHeaderOrLabelCapability(o,m)):(o=m,n=this._getCellCapability(o)),this.m_selectionFrontier&&"row"===this.m_selectionFrontier.axis?n.resizeWidth=r:this.m_selectionFrontier&&"column"===this.m_selectionFrontier.axis&&(n.resizeHeight=r);else if(m&&(a||h)){n=this._getHeaderOrLabelCapability(m);const e=this.getHeaderCellAxis(m);"column"!==e&&"columnEnd"!==e||!this.m_selectionFrontier||"column"!==this.m_selectionFrontier.axis?"row"!==e&&"rowEnd"!==e||!this.m_selectionFrontier||"row"!==this.m_selectionFrontier.axis||(n.resizeWidth=r):n.resizeHeight=r,o=m}else n={resize:r,resizeWidth:r,resizeHeight:r,sortRow:r,sortCol:r,cut:r,paste:r,sortColAsc:r,sortColDsc:r,sortRowAsc:r,sortRowDsc:r,filterCol:r},o=m;i.call(null,{capabilities:n,launcher:o},e,t)}},A.prototype._getCellCapability=function(e){const t="disable",i="enable",s={resize:t,resizeWidth:t,resizeHeight:t,sortRow:t,sortCol:t,cut:t,cutCells:t,copyCells:t,paste:t,pasteCells:t,autoFill:t,sortColAsc:t,sortColDsc:t,sortRowAsc:t,sortRowDsc:t,freezeRow:t,freezeCol:t,unfreezeRow:t,unfreezeCol:t,hideCol:t,unhideCol:t,hideRow:t,unhideRow:t,filterCol:t,resizeFitToContent:i};this.m_options.isCopyEnabled()&&(s.copyCells=i),this.m_options.isCutEnabled()&&(s.cutCells=i),this.m_options.isPasteEnabled()&&(s.pasteCells=i);const n=this.m_selection,o=this.m_options.options.selectionMode,r=o.cell,l=o.row;if("single"===r||"none"===r&&"none"===l)s.resizeFitToContent=t;else{const e=new Set;this._populateSelectedHeaderSet(e),0===e.size&&(s.resizeFitToContent=t)}let a=!1;if(!this.m_discontiguousSelection&&n&&1===n.length){const e=n[0].startIndex.row,t=n[0].startIndex.column,i=n[0].endIndex.row,s=n[0].endIndex.column;e===i&&t===s||(a=!0)}this.m_options.isFloodFillEnabled()&&a&&(s.autoFill=i);const h=this.getResources().getMappedAttribute("context");if(this.m_options.isFreezeEnabled("column")&&(s.freezeCol=i,e[h].indexes.column===this.m_frozenColIndex&&(s.freezeCol=t),s.unfreezeCol=t,this._hasFrozenColumns()&&(s.unfreezeCol=i)),this.m_options.isHideEnabled("row")){const t=this._getCellHidabilityContextMenuCapability(e,"row");t.canHide&&(s.hideRow=i),t.canUnhide&&(s.unhideRow=i)}if(this.m_options.isHideEnabled("column")){const t=this._getCellHidabilityContextMenuCapability(e,"column");t.canHide&&(s.hideCol=i),t.canUnhide&&(s.unhideCol=i)}this.m_options.isFreezeEnabled("row")&&(s.freezeRow=i,e[h].indexes.row===this.m_frozenRowIndex&&(s.freezeRow=t),s.unfreezeRow=t,this._hasFrozenRows()&&(s.unfreezeRow=i));const d=this.getHeaderFromCell(e,"row"),m=this.getHeaderFromCell(e,"column"),c=this.getResources().getMappedAttribute("resizable"),u=this.getResources().getMappedAttribute("sortable");if(null!=m&&("true"===m.getAttribute(c)&&(s.resize=i,s.resizeWidth=i),"true"===m.getAttribute(u))){s.sortCol=i,s.sortColAsc=i,s.sortColDsc=i;const e=m.getAttribute(this.getResources().getMappedAttribute("sortDir"));"ascending"===e?s.sortColAsc=t:"descending"===e&&(s.sortColDsc=t)}return null!=d&&(this._isMoveEnabled("row")&&(s.cut=i,s.paste=i),"true"===d.getAttribute(u)&&(s.sortRow=i,s.sortRowAsc=i,s.sortRowDsc=i),null!=d&&("true"===d.getAttribute(c)&&(s.resize=i,s.resizeHeight=i),"true"===d.getAttribute(u)&&(s.sortRow=i))),s},A.prototype._getHeaderOrLabelCapability=function(e){const t="disable",i="enable",s=this.findLabel(e),n={resize:t,resizeWidth:t,resizeHeight:t,sortRow:t,sortCol:t,cut:t,paste:t,sortColAsc:t,sortColDsc:t,sortRowAsc:t,sortRowDsc:t,freezeRow:t,freezeCol:t,unfreezeRow:t,unfreezeCol:t,hideCol:t,unhideCol:t,hideRow:t,unhideRow:t,filterCol:t,resizeFitToContent:i},o=this.getHeaderCellAxis(e)||this.getHeaderLabelAxis(e),r=this.getResources().getMappedAttribute("resizable"),l=this.getResources().getMappedAttribute("sortable"),a=this.getResources().getMappedAttribute("filterable"),h=this.getResources().getMappedAttribute("context");if(null!==e){if("column"===o||"columnEnd"===o){if("true"===e.getAttribute(r)&&(n.resizeWidth=i,n.resize=i),n.resizeHeight=this.m_options.isResizable(o,"height"),"true"===e.getAttribute(l)&&!s){n.sortCol=i,n.sortColAsc=i,n.sortColDsc=i;var d=e.getAttribute(this.getResources().getMappedAttribute("sortDir"));"ascending"===d?n.sortColAsc=t:"descending"===d&&(n.sortColDsc=t)}if("true"===e.getAttribute(l)&&s){n.sortRow=i,n.sortRowAsc=i,n.sortRowDsc=i;let s=e.getAttribute(this.getResources().getMappedAttribute("sortDir"));"ascending"===s?n.sortRowAsc=t:"descending"===s&&(n.sortRowDsc=t)}this.m_options.isFreezeEnabled("column")&&!s&&(n.freezeCol=i,e[h].index===this.m_frozenColIndex&&(n.freezeCol=t),n.unfreezeCol=t,this._hasFrozenColumns()&&(n.unfreezeCol=i)),s&&this.m_options._isLabelCutEnabled()&&(n.cutCells=i),"true"===e.getAttribute(a)&&(n.filterCol=i)}else{if(this._isMoveEnabled("row")&&(n.cut=i,n.paste=i),"true"===e.getAttribute(r)&&(n.resize=i,n.resizeHeight=i),n.resizeWidth=this.m_options.isResizable(o,"width"),"true"===e.getAttribute(l)&&!s){n.sortRow=i,n.sortRowAsc=i,n.sortRowDsc=i;let s=e.getAttribute(this.getResources().getMappedAttribute("sortDir"));"ascending"===s?n.sortRowAsc=t:"descending"===s&&(n.sortRowDsc=t)}if("true"===e.getAttribute(l)&&s){n.sortCol=i,n.sortColAsc=i,n.sortColDsc=i;let s=e.getAttribute(this.getResources().getMappedAttribute("sortDir"));"ascending"===s?n.sortColAsc=t:"descending"===s&&(n.sortColDsc=t)}this.m_options.isFreezeEnabled("row")&&!s&&(n.freezeRow=i,e[h].index===this.m_frozenRowIndex&&(n.freezeRow=t),n.unfreezeRow=t,this._hasFrozenRows()&&(n.unfreezeRow=i)),s&&this.m_options._isLabelCutEnabled()&&(n.cutCells=i)}if(this.m_options.isHideEnabled(o)){const t=this._getHeaderHidabilityContextMenuCapability(e,o);t.canHide&&("column"===o||"columnEnd"===o?n.hideCol=i:"row"!==o&&"rowEnd"!==o||(n.hideRow=i)),t.canUnhide&&("column"===o||"columnEnd"===o?n.unhideCol=i:"row"!==o&&"rowEnd"!==o||(n.unhideRow=i))}}return n.resize=n.resizeHeight===i||n.resizeWidth===i?i:t,n},A.prototype.handleContextMenuReturn=function(e,t,i){var s,n;if(null!=this.m_active&&(s=this._getActiveElement()),t===this.m_resources.getMappedCommand("resizeHeight")||t===this.m_resources.getMappedCommand("resizeWidth"))this.isResizeEnabled()&&this.handleContextMenuResize(e,t,i,s);else if(t===this.m_resources.getMappedCommand("resizeFitToContent")){let t=this.findCell(e.target);t||(t=this.findHeader(e.target)),t||(t=this.findLabel(e.target)),t&&(this.m_resizingElement=t),this.isResizeEnabled()&&this._getHeadersForResizeFitToContent(e)}else t===this.m_resources.getMappedCommand("sortColAsc")||t===this.m_resources.getMappedCommand("sortColDsc")?(n=t===this.m_resources.getMappedCommand("sortColAsc")?"ascending":"descending",this.m_utils.containsCSSClassName(s,this.getMappedStyle("cell"))&&(s=this.getHeaderFromCell(s,"column")),this._isDOMElementSortable(s)&&(this.m_utils.containsCSSClassName(s,this.getMappedStyle("headerlabel"))?this._handleHeaderLabelSort(s,this.findLabel(s),n):this._handleCellSort(e,n,s))):t===this.m_resources.getMappedCommand("sortRowAsc")||t===this.m_resources.getMappedCommand("sortRowDsc")?(n=t===this.m_resources.getMappedCommand("sortRowAsc")?"ascending":"descending",this.m_utils.containsCSSClassName(s,this.getMappedStyle("cell"))&&(s=this.getHeaderFromCell(s,"row")),this._isDOMElementSortable(s)&&(this.m_utils.containsCSSClassName(s,this.getMappedStyle("headerlabel"))?this._handleHeaderLabelSort(s,this.findLabel(s),n):this._handleCellSort(e,n,s))):t===this.m_resources.getMappedCommand("cut")?this._handleCut(e,s):t===this.m_resources.getMappedCommand("paste")?this._handlePaste(e,s):t===this.m_resources.getMappedCommand("cutCells")?this._handleCutCells(e,s):t===this.m_resources.getMappedCommand("copyCells")?this._handleCopyCells(e,s):t===this.m_resources.getMappedCommand("pasteCells")?this._handlePasteCells(e,s):t===this.m_resources.getMappedCommand("autoFill")?this._handleAutofill(e,s):t===this.m_resources.getMappedCommand("discontiguousSelection")?this.setDiscontiguousSelectionMode(i):t===this.m_resources.getMappedCommand("freezeRow")?this._handleFreezeRow(e,s):t===this.m_resources.getMappedCommand("freezeCol")?this._handleFreezeCol(e,s):t===this.m_resources.getMappedCommand("unfreezeCol")?this._handleUnFreeze("column",e):t===this.m_resources.getMappedCommand("unfreezeRow")?this._handleUnFreeze("row",e):t===this.m_resources.getMappedCommand("hideCol")?this._handleHideAxis(e,"column"):t===this.m_resources.getMappedCommand("unhideCol")?this._handleUnhideAxis(e,"column"):t===this.m_resources.getMappedCommand("hideRow")?this._handleHideAxis(e,"row"):t===this.m_resources.getMappedCommand("unhideRow")?this._handleUnhideAxis(e,"row"):t===this.m_resources.getMappedCommand("filterCol")&&this._handleHeaderFilter(e,"column")},A.prototype._isSortEnabled=function(e,t,i=!1){var s=this.getDataSource().getCapability("sort");let n=this.m_options.isSortable(e,t,i);return!("enable"!==n&&"auto"!==n||"full"!==s&&s!==e)&&(!this._isDataGridProvider()||null!=t.metadata.sortDirection)},A.prototype._isParentNode=function(e){return!!this._isDataGridProvider()&&(e.metadata.expanded&&null!==e.metadata.expanded)},A.prototype._isRequired=function(e){return!!this._isDataGridProvider()&&!0===e.metadata.showRequired},A.prototype._isFilterEnabled=function(e,t){return!("disable"===this.m_options.isFilterEnabled(e,t)||!this._isDataGridProvider())&&null!=t.metadata.filter},A.prototype._isHierarchicalGroup=function(e){return null==e.metadata.treeDepth},A.prototype._isLeafNode=function(e){if(!e.metadata)return!1;const t=e.metadata.treeDepth;return!!this._isDataGridProvider()&&(null!=t&&0!==t)},A.prototype._isDOMElementSortable=function(e){if(null==e)return!1;let t=this.findHeader(e)||this.findLabel(e);return null!=t&&"true"===t.getAttribute(this.getResources().getMappedAttribute("sortable"))},A.prototype._isSelectionEnabled=function(){return"none"!==this.m_options.getSelectionCardinality()},A.prototype.isMultipleSelection=function(){return"multiple"===this.m_options.getSelectionCardinality()},A.prototype.isResizeEnabled=function(){return this.m_options.isResizable("row","width")||this.m_options.isResizable("row","height")||this.m_options.isResizable("column","width")||this.m_options.isResizable("column","height")||this.m_options.isResizable("rowEnd","width")||this.m_options.isResizable("rowEnd","height")||this.m_options.isResizable("columnEnd","width")||this.m_options.isResizable("columnEnd","height")},A.prototype._isHeaderResizeEnabled=function(e,t){return"column"===e||"columnEnd"===e?"enable"===this.m_options.isResizable(e,"width",t):("row"===e||"rowEnd"===e)&&"enable"===this.m_options.isResizable(e,"height",t)},A.prototype.handleMouseMove=function(e){this.isResizeEnabled()&&!1===this.m_databodyDragState&&this.handleResize(e)},A.prototype.handleRowHeaderMouseMove=function(e){0===e.buttons&&this.handleMouseUp(e),this.m_databodyMove&&!this._isDataGridProvider()?this._handleMove(e):this.m_headerDragState&&(this.m_selectionFrontier&&this.m_selectionFrontier.axis&&-1!==this.m_selectionFrontier.axis.indexOf("row")||this.m_deselectInfo&&this.m_deselectInfo.axis&&-1!==this.m_deselectInfo.axis.indexOf("row"))?this.extendSelectionHeader(e.target,e,!0,this.m_deselectInProgress):this.m_isResizing||this.handleMouseMove(e)},A.prototype.handleColumnHeaderMouseMove=function(e){0===e.buttons&&this.handleMouseUp(e),this.m_headerDragState&&(this.m_selectionFrontier&&this.m_selectionFrontier.axis&&-1!==this.m_selectionFrontier.axis.indexOf("column")||this.m_deselectInfo&&this.m_deselectInfo.axis&&-1!==this.m_deselectInfo.axis.indexOf("column"))?this.extendSelectionHeader(e.target,e,!0,this.m_deselectInProgress):this.m_isResizing||this.handleMouseMove(e)},A.prototype.handleHeaderLabelMouseMove=function(e){this.m_isResizing||this.handleMouseMove(e)},A.prototype.handleHeaderMouseDown=function(e){var t;this.deleteDatabodyHiddenVisualIndicators();const i=this.findHeader(e.target);if(null==i)return;this.m_shouldFocus=!1;var s=e.target;const n=this._getActiveElement();if(!this._isEditOrEnter()||!1!==this._leaveEditing(e,n,!1)){var o=this.m_options.getSelectionMode();if(0===e.button){if(this._isSortIcon(s)&&this._isDOMElementSortable(s))return this.handleHeaderClickActive(e,null,!0),void this._handleSortIconMouseDown(s,i);if(this._isFilterIcon(s)&&this._isDOMElementFilterable(s))return void this.handleHeaderClickActive(e,null,!0);if(this._isDisclosureIcon(s))return void this.handleHeaderClickActive(e,null,!0);this.isResizeEnabled()&&(t=this.handleResizeMouseDown(e),this._highlightResizeMouseDown());var r=this.m_utils.ctrlEquivalent(e);this._isDataGridProvider()||this.m_isResizing||r||!this._isMoveOnElementEnabled(this.findHeader(s))||(this.m_databodyMove=!0,this.m_currentX=e.pageX,this.m_currentY=e.pageY,t=!0);let n=this.getHeaderCellAxis(i);if(this.m_utils.containsCSSClassName(i,this.getMappedStyle("draggableItem"))&&this.m_utils.addCSSClassName(i,this.getMappedStyle("dragging")),this._isDataGridProvider()&&this.m_options._isDragEnabled(n)&&this.shouldHoverHeader(i)&&this.m_selection&&this.m_selection.length&&this._setHeaderDraggable(i))return}if(!this.m_isResizing&&"default"===this.manageHeaderCursor(e,!1)){this.m_root.contains(document.activeElement)&&document.activeElement!==this.m_root||(this.m_externalFocus=!0);var l=i[this.getResources().getMappedAttribute("context")];!this._isSelectionEnabled()||!this.isMultipleSelection()||"row"===o&&-1===l.axis.indexOf("row")||this.m_databodyMove?"row"===o&&-1!==l.axis.indexOf("row")&&this._isSelectionEnabled()?this.handleHeaderClickSelection(e):this.handleHeaderClickActive(e):(0===e.button&&(this.m_headerDragState=!0),this.handleHeaderClickSelection(e))}this.m_options.isFloodFillEnabled()&&this.m_bottomFloodFillIconContainer&&this.m_bottomFloodFillIconContainer.parentNode&&(this.m_bottomFloodFillIconContainer.parentNode.removeChild(this.m_bottomFloodFillIconContainer),this.m_bottomFloodFillIconContainer.removeEventListener("mouseover",this.handleDatabodyMouseMove)),!0===t&&e.preventDefault()}},A.prototype.handleHeaderLabelMouseDown=function(e){var t;const i=this.find(e.target,"headerlabel"),s=this.getResources().getMappedAttribute("context");0===e.button&&this._isSortIcon(e.target)&&this._isDOMElementSortable(e.target)&&(this._handleSortIconMouseDown(e.target,i),this._handleHeaderLabelSort(e,i)),i&&this.m_options._isDragEnabledOnLabel(i[s].axis)&&i.setAttribute("draggable",!0),i&&this.isResizeEnabled()&&(t=this.handleResizeMouseDown(e),this._highlightResizeMouseDown()),!0===t&&e.preventDefault()},A.prototype.handleMouseUp=function(e){this.m_headerDragState=!1,this.m_databodyDragState=!1,this.m_deselectInProgress=!1,this.m_databodyMove?this._handleMoveMouseUp(e,!1):this.isResizeEnabled()&&this.handleResizeMouseUp(e),this.m_databodyMove=!1},A.prototype.shouldHoverHeader=function(e){const t=null==e?null:this.getHeaderCellAxis(e),i=null===e?null:this.getHeaderCellLevel(e),s="row"===t||"rowEnd"===t,n=this.m_options.getSelectionMode();return this._isSelectionEnabled()&&(this.isMultipleSelection()&&"cell"===n||"row"===n&&s&&(this.isMultipleSelection()||null!==i&&i===this.m_rowHeaderLevelCount-1))},A.prototype.handleHeaderMouseOver=function(e){var t=e.target,i=this.findHeader(t);if(this._isDOMElementSortable(e.target)){const e=this._getSortContainer(i);e&&e.classList.remove(this.getMappedStyle("iconHidden"))}if(this._isDOMElementFilterable(e.target)){const e=this._getFilterContainer(i);e&&e.classList.remove(this.getMappedStyle("iconHidden"))}!this.m_isResizing&&"default"===this.manageHeaderCursor(e,!1)&&this.shouldHoverHeader(i)&&this.m_utils.addCSSClassName(i,this.getMappedStyle("hover"));let s=this.getHeaderCellAxis(i);this._isDataGridProvider()&&this.shouldHoverHeader(i)&&this.m_options._isDragEnabled(s)&&this.m_selection&&this.m_selection.length&&this._setHeaderDraggable(i)},A.prototype.handleHeaderMouseOut=function(e){var t=e.target;this.m_utils.removeCSSClassName(this.findHeader(t),this.getMappedStyle("hover")),!this.m_isResizing&&this.m_resizingElement&&(this.m_resizingElement.style.cursor="",null!=this.m_resizingElementSibling&&(this.m_resizingElementSibling.style.cursor="")),this._isDOMElementSortable(e.target)&&this._handleSortMouseOut(e),this._isDOMElementFilterable(e.target)&&this._handleFilterMouseOut(e)},A.prototype.handleHeaderMouseUp=function(e){this.handleDragAnchorChange(e),this.m_headerDragState=!1,this.m_databodyDragState=!1,this.m_deselectInProgress=!1,this.m_floodFillDragState&&(this.unhighlightFloodFillRange(),this.m_selectionRange=null,this.m_floodFillRange=null,this.m_floodFillDirection=null,this.m_databody.style.cursor="default",this.m_cursor="default"),this.m_databodyMove&&this._handleMoveMouseUp(e,!0);let t=this.findHeader(e.target),i=this.getHeaderCellAxis(t);this._isDataGridProvider()&&this.m_options._isDragEnabled(i)&&this.shouldHoverHeader(t)&&this.m_selection&&this.m_selection.length&&this._setHeaderDraggable(t),this.m_utils.containsCSSClassName(t,this.getMappedStyle("dragging"))&&this.m_utils.removeCSSClassName(t,this.getMappedStyle("dragging"))},A.prototype.handleCornerMouseDown=function(e){this.deleteDatabodyHiddenVisualIndicators();let t,i=e.target,s=this.m_utils.containsCSSClassName(i,this.getMappedStyle("rowendheaderlabel"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("columnendheaderlabel")),n=this.findLabel(i);null!=n&&(t=s,this.m_options._isDragEnabledOnLabel()&&(t=!0),this._setActive(n,this._createActiveObject(n),e,t),this._isSortIcon(e.target)||this.handleHeaderLabelMouseDown(e))},A.prototype.handleCornerMouseOver=function(e){var t=e.target;let i=this.findLabel(t);const s=this.getResources().getMappedAttribute("context");if(i&&this.m_options._isDragEnabledOnLabel(i[s].axis)?(this.m_utils.addCSSClassName(i,this.getMappedStyle("draggableItem")),i.setAttribute("draggable",!0)):this._isSelectionEnabled()&&this.isMultipleSelection()&&(i?this.m_utils.addCSSClassName(i,this.getMappedStyle("hover")):this.m_utils.addCSSClassName(this.find(t,"topcorner"),this.getMappedStyle("hover"))),this._isDOMElementSortable(t)){const e=this._getSortContainer(i);e&&e.classList.remove(this.getMappedStyle("iconHidden"))}this.m_isResizing||null===i||this.handleMouseMove(e)},A.prototype.handleCornerMouseMove=function(e){var t=e.target;let i=this.findLabel(t);this.m_isResizing||null===i||this.handleMouseMove(e)},A.prototype.handleCornerMouseOut=function(e){var t=e.target;let i=this.findLabel(t);i?(this._isDOMElementSortable(t)&&this._handleSortMouseOut(e),this.m_utils.removeCSSClassName(i,this.getMappedStyle("hover")),this.m_utils.removeCSSClassName(i,this.getMappedStyle("draggableItem")),i.setAttribute("draggable",!1)):this.m_utils.removeCSSClassName(this.find(t,"topcorner"),this.getMappedStyle("hover"))},A.prototype.handleCornerClick=function(e){this._handleSelectAll(e)},A.prototype.handleHeaderClick=function(e){var t=e.target;this._isSortIcon(t)&&this._isDOMElementSortable(t)?(this._removeTouchSelectionAffordance(),this._handleHeaderSort(e),e.preventDefault()):this._isFilterIcon(t)&&this._isDOMElementFilterable(t)?(this._removeTouchSelectionAffordance(),this._handleHeaderFilter(e),e.preventDefault()):this._isDisclosureIcon(e.target)&&(this._removeTouchSelectionAffordance(),this._handleExpandCollapseRequest(e),e.preventDefault())},A.prototype.handleHeaderDoubleClick=function(e){if(document.contains(e.target)){let t,i=!1,s=this.m_utils.containsCSSClassName(e.target,this.getMappedStyle("colHeaderHiddenIndicator")),n=this.m_utils.containsCSSClassName(e.target,this.getMappedStyle("rowHeaderHiddenIndicator"));if(s?t="column":n&&(t="row"),s||n){let i=this._getAttribute(e.target,"hiddenIndicatorIndex",!0);return void this._handleUnhideAxis(e,t,i)}this.m_cursor=this.manageHeaderCursor(e,i),("col-resize"===this.m_cursor||"row-resize"===this.m_cursor)&&(this.m_resizingElement||(this.m_resizingElement=this.findHeader(e.target)),this.isResizeEnabled()&&this._getHeadersForResizeFitToContent(e))}},A.prototype._getHeadersForResizeFitToContent=function(e){let t=this.getHeaderCellAxis(this.m_resizingElement);const i=this.m_resizingElement[this.getResources().getMappedAttribute("context")],s=this._getSelectionAxis(t),n=new Set;let o=!1,r=!1,l=!1,a=this.findCell(this.m_resizingElement);if(a&&(l=!0),null===a&&(a=this.findHeader(this.m_resizingElement),a&&(o=!0)),null===a&&(a=this.findLabel(this.m_resizingElement),a&&(r=!0)),o)this._isSelectionEnabled()&&this.isMultipleSelection()&&0!==this.m_selection.length&&this._isHeaderSelected(i,s)?this.m_selection.forEach(e=>{this._getHeadersWithinSelection(e,e.startIndex[s],t).forEach(e=>n.add(e))}):n.add(this.m_resizingElement);else{if(r){const s=i.level;t=i.axis;const n=this._getHeadersByLevel(t,s);return void(n.length>0&&this.handleResizeFitToContent(e,n[0],r,n))}l&&this._populateSelectedHeaderSet(n)}n.forEach(t=>{this.handleResizeFitToContent(e,t,r)})},A.prototype._populateSelectedHeaderSet=function(e){const t=this.m_options.options.selectionMode.cell;this.m_selection.forEach(t=>{this._getHeadersWithinSelection(t,t.startIndex.row,"row").forEach(t=>e.add(t))}),"multiple"===t&&this.m_selection.forEach(t=>{this._getHeadersWithinSelection(t,t.startIndex.column,"column").forEach(t=>e.add(t))})},A.prototype._getHeadersByLevel=function(e,t){return[..."column"===e?this.m_root.querySelectorAll(`.${this.getMappedStyle("colheadercell")},.${this.getMappedStyle("colendheadercell")}`):this.m_root.querySelectorAll(`.${this.getMappedStyle("rowheadercell")},.${this.getMappedStyle("rowendheadercell")}`)].filter(e=>e[this.getResources().getMappedAttribute("context")].level===t)},A.prototype._getHeadersWithinSelection=function(e,t,i){let s,n,o,r,l=[];if("column"===i?(s=this.m_columnHeaderLevelCount-1,n="column"):"columnEnd"===i?(s=this.m_columnEndHeaderLevelCount-1,n="column"):"row"===i?(s=this.m_rowHeaderLevelCount-1,n="row"):(s=this.m_rowEndHeaderLevelCount-1,n="row"),0===e.startIndex.column&&-1===e.endIndex.column&&0===e.startIndex.row&&-1===e.endIndex.row){o=0,r="row"===n?this.m_endRowHeader-this.m_startRowHeader:this.m_endColHeader-this.m_startColHeader}else 0===e.startIndex.column&&-1===e.endIndex.column||void 0===e.startIndex.column?e.startIndex.row<=t&&t<=e.endIndex.row&&("row"===i||"rowEnd"===i)&&(o=e.startIndex.row,r=e.endIndex.row):(0===e.startIndex.row&&-1===e.endIndex.row||void 0===e.startIndex.row)&&e.startIndex.column<=t&&t<=e.endIndex.column&&("column"===i||"columnEnd"===i)&&(o=e.startIndex.column,r=e.endIndex.column);for(let e=o;e<=r;e++){let t=this._getHeaderByIndex(e,i,s);t&&l.push(t)}return l},A.prototype._setHeaderDraggable=function(e){let t=!1;if(this.m_selection&&this.m_selection.length){if(this._isSelectionAcrossAxis())return!1;this.m_utils.containsCSSClassName(e,this.getMappedStyle("selected"))&&(t=!0)}return t&&(this.m_utils.addCSSClassName(e,this.getMappedStyle("draggableItem")),e.setAttribute("draggable",!0)),t},A.prototype._isSelectionAcrossAxis=function(){let e,t=!1;for(let i=0;i<this.m_selection.length;i++){let s=this.m_selection[i];if(e&&(-1===s.endIndex.row&&"column"!==e||-1===s.endIndex.column&&"row"!==e)){t=!0;break}-1===s.endIndex.row?e="column":-1===s.endIndex.column&&(e="row")}return t},A.prototype.handleDatabodyMouseDown=function(e){this.deleteDatabodyHiddenVisualIndicators();var t=e.target,i=this.findCell(t);if(null==i&&!this._getEmptyElement())return void(this.m_scrollbarFocus=!0);this.m_shouldFocus=!1;const s=this._getActiveElement();if(this._isEditOrEnter()){if(i===s)return;if(!1===this._leaveEditing(e,s,!1))return}var n=this.m_utils.ctrlEquivalent(e);0!==e.button||n||this._isMoveOnElementEnabled(i)&&(this.m_databodyMove=!0,this.m_currentX=e.pageX,this.m_currentY=e.pageY),this.m_root.contains(document.activeElement)&&document.activeElement!==this.m_root||(this.m_externalFocus=!0),this._isGridEditable()&&(this.m_shouldFocus=!this._isFocusableElementBeforeCell(t)),this._isSelectionEnabled()?(this.isMultipleSelection()&&0===e.button&&(this.m_databodyDragState=!0),this.handleDatabodyClickSelection(e)):this.handleDatabodyClickActive(e)},A.prototype.handleDatabodyMouseOut=function(e){if(!this.m_databodyMove){var t=e.target,i=this.findCell(t);this._setCellHover(i,"remove")}},A.prototype.handleDatabodyMouseOver=function(e){if(!this.m_databodyMove){var t=e.target,i=this.findCell(t);this._setCellHover(i,"add")}},A.prototype._setCellHover=function(e,t){if(null!=e&&this._isSelectionEnabled()){var i=this.m_options.getSelectionMode();if("cell"===i)"add"===t?this.m_utils.addCSSClassName(e,this.getMappedStyle("hover")):this.m_utils.removeCSSClassName(e,this.getMappedStyle("hover"));else if("row"===i)for(var s=this._getIndex(e,"row"),n=this._getSelectionStartAndEnd(this.createIndex(s,this.m_startCol),this.createIndex(s,this.m_endCol),0),o=n.min.row;o<=n.max.row;o++)this._highlightCellsAlongAxis(o,"row","index",t,["hover"])}},A.prototype.handleDatabodyDoubleClick=function(e){if(this._isGridEditable()){var t=e.target,i=this.findCell(t);if("edit"===this._getCurrentMode()){var s=this._getActiveElement();if(i===s)return;if(!this._handleExitEdit(e,s))return}this._handleEditable(e,i),this._handleEdit(e,i)}},A.prototype.handleDatabodyMouseMove=function(e){0===e.buttons&&this.handleMouseUp(e),this.m_databodyMove?this._handleMove(e):this.m_databodyDragState?this.m_floodFillDragState?this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this.m_selectionRange||(this.m_selectionRange=this.GetSelection()),this.handleDatabodyFloodFillDrag(e)):this.handleDatabodySelectionDrag(e):this.m_headerDragState&&(this.m_selectionFrontier&&this.m_selectionFrontier.axis&&(-1!==this.m_selectionFrontier.axis.indexOf("row")||-1!==this.m_selectionFrontier.axis.indexOf("column"))||this.m_deselectInfo&&this.m_deselectInfo.axis&&(-1!==this.m_deselectInfo.axis.indexOf("row")||-1!==this.m_deselectInfo.axis.indexOf("column")))&&this.extendSelectionHeader(e.target,e,!0,this.m_deselectInProgress)},A.prototype.handleDatabodyMouseUp=function(e){this.m_databodyDragState=!1,this.m_headerDragState=!1,this.m_deselectInProgress=!1,this.m_databodyMove&&this._handleMoveMouseUp(e,!0),this.m_options.isFloodFillEnabled()&&this.m_floodFillDragState&&(this._handleFloodFillMouseUp(e),this.m_floodFillDragState=!1)},A.prototype.handleDatabodyKeyUp=function(e){this.m_deselectInProgress&&(this.m_deselectInProgress=e.shiftKey)},A.prototype.handleDatabodyKeyDown=function(e){var t,i=this.m_utils.ctrlEquivalent(e);if(e.defaultPrevented&&i&&(this.keyCodes.LEFT_KEY||this.keyCodes.RIGHT_KEY)||this.m_animating)return;let s=this._getActiveElement();null!=(t=null!=this.m_active&&"header"===this.m_active.type?this._getActionFromKeyDown(e,this.m_active.axis,!1):null!=this.m_active&&"label"===this.m_active.type?this._getActionFromKeyDown(e,this.m_active.axis,!0):null!=this.m_active&&"empty"===this.m_active.type?this._getActionFromNoDataKeydown(e):this._getActionFromKeyDown(e,"cell",!1))&&t.call(this,e,s)&&e.preventDefault()},A.prototype.findPos=function(e){if(e){const t=e.getBoundingClientRect();return[t.x,t.y]}return[0,0]},A.prototype._findHeaderOffset=function(e,t,i){if(i||(i=[0,0]),e!==t){for(;!e.offsetParent;)e=e.parentElement;return e.offsetLeft&&(i[0]+=parseInt(e.offsetLeft,10)),e.offsetTop&&(i[1]+=parseInt(e.offsetTop,10)),this._findHeaderOffset(e.offsetParent,t,i)}return i},A.prototype.handleDatabodyMouseWheel=function(e){var t,i=this.find(e.target,"header");if(null==i&&(i=this.find(e.target,"endheader")),i&&(t=i===this.m_rowHeader||i===this.m_rowEndHeader?"row":"column"),("row"!==t||this.m_stopRowHeaderFetch&&this.m_stopRowEndHeaderFetch&&this.m_stopRowFetch)&&("column"!==t||this.m_stopColumnHeaderFetch&&this.m_stopColumnEndHeaderFetch&&this.m_stopColumnFetch)||e.preventDefault(),!this.m_animating){var s=this.m_utils.getMousewheelScrollDelta(e),n=s.deltaX,o=s.deltaY;if(null===i&&e.target.classList.contains(this.getMappedStyle("frozenCell"))){let t=this._getCellContainer(e.target);t.classList.contains(this.getMappedStyle("databodyFrozenRow"))?o=0:t.classList.contains(this.getMappedStyle("databodyFrozenCol"))?n=0:t.classList.contains(this.getMappedStyle("databodyFrozenCorner"))&&(n=0,o=0)}"row"===t?n=0:"column"===t&&(o=0);var r=Math.max(0,Math.min(this._getMaxScrollHeight(),this.m_currentScrollTop-o));this._getMaxScrollHeight()!==r&&0!==r&&(this.find(e.target,"header")||this.find(e.target,"databodyFrozenCol"))&&e.preventDefault(),this.scrollDelta(n,o)}},A.prototype.handleTouchStart=function(e){var t=e.touches.length,i=e.touches[0].target;if(1===t){if(this.m_startX=e.touches[0].pageX,this.m_startY=e.touches[0].pageY,this.m_currentX=this.m_startX,this.m_currentY=this.m_startY,this.m_prevX=this.m_startX,this.m_prevY=this.m_startY,this.m_startTime=(new Date).getTime(),this.m_touchActive=!0,this.isMultipleSelection()){i.classList.contains(this.getMappedStyle("selectaffordance"))&&(i=i.parentNode);var s=null;if(i===this.m_topSelectIconContainer?s="top":i===this.m_bottomSelectIconContainer&&(s="bottom"),s){this.m_touchMultipleSelect=!0;var n=this.GetSelection();this.m_touchSelectAnchor="top"===s?n[n.length-1].endIndex:n[n.length-1].startIndex}}!this.m_touchMultipleSelect&&this._isMoveOnElementEnabled(this.findCell(i))&&(this.m_databodyMove=!0)}else this.handleTouchCancel(e)},A.prototype.handleTouchMove=function(e){var t=e.target;if(this.m_touchActive){e.cancelable&&e.preventDefault(),this.m_currentX=e.touches[0].pageX,this.m_currentY=e.touches[0].pageY;var i=this.m_currentX-this.m_prevX,s=this.m_currentY-this.m_prevY,n=this.adjustTouchScroll(i,s);if(i=n[0],s=n[1],this.getResources().isRTLMode()&&(i*=-1),this.m_touchMultipleSelect)this.handleDatabodySelectionDrag(e),this.m_utils.isTouchDeviceNotIOS()||e.preventDefault();else if(this.m_databodyMove)this._removeTouchSelectionAffordance(),this._handleMove(e),this.m_utils.isTouchDeviceNotIOS()||e.preventDefault();else if(this._isEditOrEnter()&&this.m_utils.isTouchDeviceNotIOS()){var o=this._getActiveElement();this.findCell(t)!==o&&this._handleNonSwipeScroll(i,s)}else this._handleNonSwipeScroll(i,s);this.m_prevX=this.m_currentX,this.m_prevY=this.m_currentY}else this.handleTouchCancel(e)},A.prototype.handleTouchEnd=function(e){var t,i=e.target;if(this._isEditOrEnter()){if(t=this._getActiveElement(),this.findCell(i)===t)return void this.handleTouchCancel(e);this._leaveEditing(e,t,!1)}if(this.m_shouldFocus=!1,null!=this.m_lastTapTime&&this.m_startTime-this.m_lastTapTime<250&&this.m_lastTapTarget===i?(this.m_lastTapTime=null,this.m_lastTapTarget=null,null!=(t=this.findCell(i))&&(this._handleEditable(e,t),this._handleEdit(e,t),e.cancelable&&e.preventDefault())):(this.m_lastTapTarget=e.target,this.m_lastTapTime=(new Date).getTime()),this.m_touchActive&&!e.defaultPrevented)if(this.m_touchMultipleSelect)e.cancelable&&e.preventDefault(),this.m_touchMultipleSelect=!1;else{var s=this.m_lastTapTime-this.m_startTime;if(this.m_currentX===this.m_startX&&this.m_currentY===this.m_startY)return this.m_databodyMove=!1,this._isSelectionEnabled()&&s<A.CONTEXT_MENU_TAP_HOLD_DURATION?void this.handleDatabodyClickSelection(e):void this.handleDatabodyClickActive(e);if(this.m_databodyMove)return e.cancelable&&e.preventDefault(),this.m_databodyMove=!1,void this._handleMoveMouseUp(e,!0);this.m_utils.isTouchDeviceNotIOS()&&this._handleSwipe(e)}this.handleTouchCancel(e)},A.prototype._calculateMomentum=function(e,t,i,s,n,o){var r,l=e-t,a=Math.abs(l)/i,h=a*a/(2*A.DECELERATION_FACTOR)*(l<0?-1:1),d=a/A.DECELERATION_FACTOR;return o&&(h*=-1),s-h>n?(r=Math.max(-1*A.MAX_OVERSCROLL_PIXEL,h),h=s-n,d=(l=n-s)/a):s-h<0&&(r=Math.min(A.MAX_OVERSCROLL_PIXEL,h),h=s,d=(l=s)/a),{destination:Math.round(h),duration:Math.min(Math.max(A.MIN_SWIPE_TRANSITION_DURATION,d),A.MAX_SWIPE_TRANSITION_DURATION),overScroll:r}},A.prototype.handleTouchCancel=function(e){this.m_databodyMove&&(this._handleMoveMouseUp(e,!1),this.m_databodyMove=!1),this.m_touchSelectAnchor=null,this.m_touchMultipleSelect=!1,this.m_touchActive=!1,this.m_startX=0,this.m_startY=0,this.m_prevX=0,this.m_prevY=0,this.m_currentX=0,this.m_currentY=0,this.m_startTime=0},A.prototype.handleHeaderTouchStart=function(e){this.m_touchStart=(new Date).getTime();var t=e.touches.length,i=e.target;if(1===t){this.m_startX=e.touches[0].pageX,this.m_startY=e.touches[0].pageY,this.m_currentX=this.m_startX,this.m_currentY=this.m_startY,this.m_prevX=this.m_startX,this.m_prevY=this.m_startY,this.m_touchActive=!0;var s=this.findHeader(i);this.isResizeEnabled()&&(this.handleResize(e),this.handleResizeMouseDown(e),this._highlightResizeMouseDown()),!this.m_isResizing&&this._isMoveOnElementEnabled(s)&&(this.m_databodyMove=!0);let t=this.getHeaderCellAxis(s);this._isDataGridProvider()&&this.m_options._isDragEnabled(t)&&(this.m_utils.addCSSClassName(s,this.getMappedStyle("draggableItem")),s.setAttribute("draggable",!0))}else this.handleHeaderTouchCancel(e)},A.prototype.handleHeaderTouchMove=function(e){if(this.m_touchActive){e.cancelable&&e.preventDefault(),this.m_currentX=e.touches[0].pageX,this.m_currentY=e.touches[0].pageY;var t=this.m_currentX-this.m_prevX,i=this.m_currentY-this.m_prevY;if(this.m_isResizing&&this.isResizeEnabled())this.handleResize(e);else if(this.m_databodyMove)this._removeTouchSelectionAffordance(),this._handleMove(e);else if(this.m_databodyReorder)this._removeTouchSelectionAffordance();else{var s=e.target,n=this.findHeader(s),o=this.getHeaderCellAxis(n);"column"===o||"columnEnd"===o?this._handleNonSwipeScroll(t,0):this._handleNonSwipeScroll(0,i)}this.m_prevX=this.m_currentX,this.m_prevY=this.m_currentY}else this.handleTouchCancel(e)},A.prototype.handleHeaderTouchEnd=function(e){var t;if(this.m_touchActive&&!e.defaultPrevented){var i=e.target;if(this.m_isResizing&&this.isResizeEnabled())this.handleResizeMouseUp(e),this.m_currentX!==this.m_startX&&this.m_currentY!==this.m_startY&&e.cancelable&&e.preventDefault();else if(this.m_currentX===this.m_startX&&this.m_currentY===this.m_startY){var s=this.m_options.getSelectionMode(),n=(t=this.findHeader(i))[this.getResources().getMappedAttribute("context")],o=this.m_root.getAttribute("id"),r=document.querySelector("#"+o+"contextmenu");null===r&&(r=this._getSlotMap()?.contextMenu?.[0]),r&&"none"===r.style.display&&(this._isSortIcon(i)&&this._isDOMElementSortable(i)?(e.cancelable&&e.preventDefault(),this._removeTouchSelectionAffordance(),this._handleSortIconMouseDown(i,t),this._handleHeaderSort(e)):this._isFilterIcon(i)&&this._isDOMElementFilterable(i)?(e.cancelable&&e.preventDefault(),this._removeTouchSelectionAffordance(),this._handleHeaderFilter(e)):this._isDisclosureIcon(i)?(this._removeTouchSelectionAffordance(),this._handleExpandCollapseRequest(e),e.preventDefault()):!this._isSelectionEnabled()||!this.isMultipleSelection()||"row"===s&&-1===n.axis.indexOf("row")||this.m_databodyMove?"row"===s&&-1!==n.axis.indexOf("row")&&this._isSelectionEnabled()?this.handleHeaderClickSelection(e):this.handleHeaderClickActive(e):(0===e.button&&(this.m_headerDragState=!0),this.handleHeaderClickSelection(e)))}else if(this.m_databodyMove)e.cancelable&&e.preventDefault(),this.m_databodyMove=!1,this._handleMoveMouseUp(e,!0);else if(this.m_databodyReorder){e.cancelable&&e.preventDefault(),this.m_databodyReorder=!1,t=this.findHeader(i),"row"===this.getHeaderCellAxis(t)?this.handleRowDragEnd(e):this.handleColumnDragEnd(e)}else t=this.findHeader(i),this._handleSwipe(e,this.getHeaderCellAxis(t))}this.handleHeaderTouchCancel(e)},A.prototype.handleHeaderTouchCancel=function(e){this.m_databodyMove&&(this._handleMoveMouseUp(e,!1),this.m_databodyMove=!1),this.m_touchActive=!1,this.m_startX=0,this.m_startY=0,this.m_prevX=0,this.m_prevY=0,this.m_currentX=0,this.m_currentY=0},A.prototype._handleNonSwipeScroll=function(e,t){var i=(new Date).getTime();this._disableTouchScrollAnimation();var s=this.adjustTouchScroll(e,t);e=s[0],t=s[1],this.scrollDelta(e,t),i-this.m_startTime>A.TAP_AND_SCROLL_RESET&&(this.m_startX=this.m_currentX,this.m_startY=this.m_currentY,this.m_startTime=(new Date).getTime())},A.prototype._handleSwipe=function(e,t){var i=(new Date).getTime()-this.m_startTime,s=this.getResources().isRTLMode(),n=this.m_currentX-this.m_startX,o=this.m_currentY-this.m_startY;if(s&&(n*=-1),Math.abs(n)<A.MIN_SWIPE_DISTANCE&&Math.abs(o)<A.MIN_SWIPE_DISTANCE&&i<A.MIN_SWIPE_DURATION)e.cancelable&&e.preventDefault(),this._isSelectionEnabled()&&this._scrollTouchSelectionAffordance();else if(i<A.MAX_SWIPE_DURATION){var r,l;if(e.cancelable&&e.preventDefault(),"row"!==t&&"rowEnd"!==t?(r=this._calculateMomentum(this.m_currentX,this.m_startX,i,this.m_currentScrollLeft,this.m_scrollWidth,s),isNaN(r.overScroll)||(r.overScroll>0||this.m_stopColumnFetch)&&(this.m_extraScrollOverX=-1*r.overScroll)):(r={duration:0,destination:0},n=0),"column"!==t&&"columnEnd"!==t?(l=this._calculateMomentum(this.m_currentY,this.m_startY,i,this.m_currentScrollTop,this.m_scrollHeight),isNaN(l.overScroll)||(l.overScroll>0||this.m_stopRowFetch)&&(this.m_extraScrollOverY=-1*l.overScroll)):(l={duration:0,destination:0},o=0),this.m_utils.isTouchDeviceNotIOS()){var a=Math.max(r.duration,l.duration);this.m_databody.firstChild.style.transitionDuration=a+"ms",this.m_rowHeader.firstChild.style.transitionDuration=a+"ms",this.m_colHeader.firstChild.style.transitionDuration=a+"ms",this.m_rowEndHeader.firstChild.style.transitionDuration=a+"ms",this.m_colEndHeader.firstChild.style.transitionDuration=a+"ms"}n+=r.destination,o+=l.destination;var h=this.adjustTouchScroll(n,o);n=h[0],o=h[1],this.scrollDelta(n,o)}},A.prototype.fireEvent=function(e,t){if(null!=e&&null!=t){var i=this.callbacks[e];return null==i||i(t)}},A.prototype.addListener=function(e,t){this.callbacks[e]=t},A.prototype.setElementHeight=function(e,t){e.style.height=t+"px"},A.prototype.getElementHeight=function(e){return this.getElementDir(e,"height")},A.prototype.setElementWidth=function(e,t){e.style.width=t+"px"},A.prototype.getElementWidth=function(e){return this.getElementDir(e,"width")},A.prototype.setElementDir=function(e,t,i){e.style[i]=t+"px"},A.prototype.getElementDir=function(e,t){var i;return e.style[t].indexOf("px")>-1&&-1===e.style[t].indexOf("e")?parseFloat(e.style[t]):(document.body.contains(e)?i=Math.round(e["offset"+t.charAt(0).toUpperCase()+t.slice(1)]):(e.style.visibility="hidden",this.m_root.appendChild(e),i=Math.round(e["offset"+t.charAt(0).toUpperCase()+t.slice(1)]),this.m_root.removeChild(e),e.style.visibility=""),i)},A.prototype._computeElementWidthAndHeight=function(e){var t={};return e.style.width.indexOf("px")>-1&&-1===e.style.width.indexOf("e")&&(t.width=parseFloat(e.style.width)),e.style.height.indexOf("px")>-1&&-1===e.style.height.indexOf("e")&&(t.height=parseFloat(e.style.height)),null!=t.width&&null!=t.height||(document.body.contains(e)?(t.width=Math.round(e.offsetWidth),t.height=Math.round(e.offsetHeight)):(e.style.visibility="hidden",this.m_root.appendChild(e),t.width=Math.round(e.offsetWidth),t.height=Math.round(e.offsetHeight),this.m_root.removeChild(e),e.style.visibility="")),t},A.BEFORE=1,A.AFTER=2,A.INSIDE=3,A.prototype._isInViewport=function(e){var t=e.row,i=e.column;return-1===t&&-1===i?-1:-1===t?this._isColumnIndexInViewport(i):-1===i?this._isRowIndexInViewport(t):i>=this.m_startCol&&i<=this.m_endCol&&t>=this.m_startRow&&t<=this.m_endRow?A.INSIDE:-1},A.prototype._isAxisIndexInViewport=function(e,t){return-1===e?-1:"column"===t?this._isColumnIndexInViewport(e):"row"===t?this._isRowIndexInViewport(e):-1},A.prototype._isColumnIndexInViewport=function(e){return e<this.m_startCol?A.BEFORE:e>this.m_endCol?A.AFTER:A.INSIDE},A.prototype._isRowIndexInViewport=function(e){return e<this.m_startRow?A.BEFORE:e>this.m_endRow?A.AFTER:A.INSIDE},A.prototype._isCellBoundaryInViewport=function(e,t,i,s){var n=this._getViewportTop(),o=this._getViewportBottom(),r=this._getViewportLeft(),l=this._getViewportRight();return(s<=o&&s>n||i>=n&&i<o)&&(t<=l&&t>r||e>=r&&e<l)},A.prototype.queueModelEvent=function(e){return!this.m_initialized||this.m_processingEventQueue||this.m_animating||this.m_processingModelEvent||this._isEditOrEnter()&&this._isActiveWithinUpdateRange(e)?(null==this.m_modelEvents&&(this.m_modelEvents=[]),this.m_modelEvents.push(e),!0):(this.m_modelEvents.length&&this.m_modelEvents.push(e),!1)},A.prototype._isActiveWithinUpdateRange=function(e){const t=e.detail.ranges;if(null!=this.m_active){const e=this.m_active.type;if("label"===e||"empty"===e)return!1;for(let i=0;i<t.length;i++){let s=t[i];if("cell"===e){if(this.m_active.indexes.column>=s.columnOffset&&this.m_active.indexes.row>=s.rowOffset&&(-1===s.columnCount||this.m_active.indexes.column<s.columnOffset+s.columnCount)&&(-1===s.rowCount||this.m_active.indexes.row<s.rowOffset+s.rowCount))return!0}else if("header"===e){if(0===s.columnOffset&&-1===s.columnCount&&this.m_active.index>=s.rowOffset&&this.m_active.index<s.rowOffset+s.rowCount)return!0;if(0===s.rowOffset&&-1===s.rowCount&&this.m_active.index>=s.columnOffset&&this.m_active.index<s.columnOffset+s.columnCount)return!0}}}return!1},A.prototype.handleModelEvent=function(e,t){if(void 0!==t||!this.queueModelEvent(e)){var i=e.operation,s=e.keys,n=e.indexes,o=e.result,r=e.header,l=e.endheader,a=!1;if(this.m_processingModelEvent=!0,e.detail)"delete"===i&&(this._handleDeleteRangeEvent(e.detail),this.m_processingModelEvent=!1),"insert"===i&&this._handleInsertRangeEvent(e.detail),"update"===i&&this._handleUpdateRangeEvent(e.detail),"refresh"===i&&(this._handleModelRefreshEvent(e.detail),this.m_processingModelEvent=!1);else if("insert"===i)this._adjustActive(i,n),this.m_shouldFocus=!0,this._adjustSelectionOnModelChange(i,s,n),null!=o?(this._handleModelInsertRangeEvent(o,r,l),a=!0):this._handleModelInsertEvent(n,s);else if("update"===i)this._handleModelUpdateEvent(n,s,o),a=!0;else if("delete"===i){let t;if(this._isEditOrEnter()&&(t=this._getCellByIndex(this.m_active.indexes)),t){let i=this.getCellIndexes(t),s=!1;n.forEach(e=>{e.row!==i.row&&e.column!==i.column||(s=!0)}),s&&(this._handleExitEditable(e,t),this._handleExitEdit(e,t))}this._adjustSelectionOnModelChange(i,s,n),Array.isArray(s)||(s=new Array(s)),this._handleModelDeleteEventWithAnimation(e,s),s.length>0&&(a=!0)}else"refresh"===i||"reset"===i?this._handleModelRefreshEvent():"sync"===i&&this._handleModelSyncEvent(e);e.detail||(this.m_processingModelEvent=!1),a||!t||this.m_processingModelEvent||this._runModelEventQueue()}},A.prototype._adjustActive=function(e,t){var i,s;if(null!=this.m_active){if("cell"===this.m_active.type)s=!1,i=this.m_active.indexes.row;else{if("header"!==this.m_active.type||"row"!==this.m_active.axis)return;s=!0,i=this.m_active.index}if(Array.isArray(t)||(t=new Array(t)),!0===this.m_moveActive){if("insert"===e)return void(s?this.m_active.index=t[0].row:this.m_active.indexes.row=t[0].row);if("delete"===e&&t[0].row===i)return}for(var n="insert"===e?1:-1,o=0;o<t.length;o++){var r=this._isDataGridProvider()?t[o]:t[o].row;r<i&&this.m_active?s?this.m_active.index+=n:this.m_active.indexes.row+=n:r===i&&"delete"===e&&this._setActive(null,null)}}},A.prototype._adjustSelectionOnModelChange=function(e,t,i){Array.isArray(t)||(t=new Array(t)),Array.isArray(i)||(i=new Array(i));var s=this.GetSelection();if(null!=t&&null!=i&&t.length===i.length&&0!==s.length)for(var n="insert"===e?1:-1,o=0;o<t.length;o++)for(var r,l=t[o].row,a=i[o].row,h=s.length-1;h>=0;h--){var d=s[h],m=d.startKey.row,c=d.endKey.row,u=d.startIndex.row,_=d.endIndex.row;if(m===l){if(c===l&&"delete"===e){s.splice(h,1);continue}r=this._getKey(this._getAxisCellsByIndex(d.startIndex.row+1,"row")[0],"row"),d.startKey.row=r,d.endIndex.row+=n}else c===l?(r=this._getKey(this._getAxisCellsByIndex(d.startIndex.row-1,"row")[0],"row"),d.endKey.row=r,d.endIndex.row+=n):a<=u?(d.startIndex.row+=n,d.endIndex.row+=n):a<_&&(d.endIndex.row+=n)}else if(this.m_moveActive&&"insert"===e){var p;if(this._isSelectionEnabled()&&this._isDatabodyCellActive())p="cell"===this.m_options.getSelectionMode()?this.createRange(this.m_active.indexes,this.m_active.indexes,t[0],t[0]):this.createRange(i[0],i[0],t[0],t[0]),this.m_selectionFrontier=this.m_active.indexes,s.push(p);this.m_moveActive=!1}},A.prototype._simpleAdjustSelectionOnChange=function(e,t,i){let s=this.GetSelection(),n="insert"===e?1:-1;for(let o=0;o<t.length;o++){let r=t[o];for(let t=s.length-1;t>=0;t--){let o=s[t],l=o.startIndex[i],a=o.endIndex[i];if(l===r){if(a===r&&"delete"===e){s.splice(t,1);continue}if("delete"===e){let e=this._getKey(this._getAxisCellsByIndex(o.startIndex[i]+1,i)[0],i);o.startKey[i]=e}else o.startIndex[i]+=n;o.endIndex[i]+=n}else if(a===r){if("delete"===e){let e=this._getKey(this._getAxisCellsByIndex(o.endIndex[i]-1,i)[0],i);void 0===o.endKey&&(o.endKey={row:null,column:null}),o.endKey[i]=e}o.endIndex[i]+=n}else r<l?(o.startIndex[i]+=n,o.endIndex[i]+=n):r<a&&(o.endIndex[i]+=n)}}},A.prototype._handleInsertRangeEvent=function(e){let t=e.axis,i=e.ranges;if(0===i.length)return void this.fillViewport();i.sort(function(e,t){return e.offset-t.offset});let s=i.shift(),n=s.offset,o=s.count,r=this._isAxisIndexInViewport(n,t);if(r===A.INSIDE){let i=n,r=o,l=this.m_startCol,a=this.m_endCol-this.m_startCol+1;"column"===t&&(i=this.m_startRow,r=this.m_endRow-this.m_startRow+1,l=n,a=o);let h,d=document.createDocumentFragment(),m=document.createDocumentFragment(),c=new Promise(function(e){h=e}),u={axis:t,range:s,headerFragment:d,endHeaderFragment:m,totalDimension:0,promiseResolve:h};this.fetchHeaders(t,n,d,m,o,{success:this._handleInsertRangeHeaderFetchSuccess.bind(this,u),error:this.handleCellsFetchError}),this.fetchCells(this.m_databody,i,l,r,a,{success:this._handleInsertRangeCellFetchSuccess.bind(this,u),error:this.handleCellsFetchError}),c.then(this._handleInsertRangeEvent.bind(this,e))}else if(r===A.BEFORE){let i=this.m_avgRowHeight,s=i*o,r=this.m_rowHeader,l=this.m_rowEndHeader;"row"===t?(this.m_endRow>=0&&(this.m_startRow+=o,this.m_endRow+=o,this.m_startRowPixel+=s,this.m_endRowPixel+=s),this.m_endRowHeader>=0&&(this.m_startRowHeader+=o,this.m_endRowHeader+=o,this.m_startRowHeaderPixel+=s,this.m_endRowHeaderPixel+=s),this.m_endRowEndHeader>=0&&(this.m_startRowEndHeader+=o,this.m_endRowEndHeader+=o,this.m_startRowEndHeaderPixel+=s,this.m_endRowEndHeaderPixel+=s)):(i=this.m_avgColWidth,s=i*o,r=this.m_colHeader,l=this.m_colEndHeader,this.m_endCol>=0&&(this.m_startCol+=o,this.m_endCol+=o,this.m_startColPixel+=s,this.m_endColPixel+=s),this.m_endColHeader>=0&&(this.m_startColHeader+=o,this.m_endColHeader+=o,this.m_startColHeaderPixel+=s,this.m_endColHeaderPixel+=s),this.m_endColEndHeader>=0&&(this.m_startColEndHeader+=o,this.m_endColEndHeader+=o,this.m_startColEndHeaderPixel+=s,this.m_endColEndHeaderPixel+=s));let a=new Array(o).fill(n).map((e,t)=>e+t),h=new Array(o).fill(i);this._modifyAndPushCells(a,h,t,this.m_databody,r,l,!0),this._refreshDatabodyMap(),this._handleInsertRangeEvent(e)}else r===A.AFTER&&("row"===t?(this.m_stopRowFetch=!1,this.m_stopRowHeaderFetch=!1,this.m_stopRowEndHeaderFetch=!1):(this.m_stopColumnFetch=!1,this.m_stopColumnHeaderFetch=!1,this.m_stopColumnEndHeaderFetch=!1),this._handleInsertRangeEvent(e))},A.prototype._handleUpdateRangeEvent=function(e){let t=e.ranges;if(0===t.length)return this._resetEditableClone(),this.applySelection(),this._resetHeaderHighLight(),void this.fillViewport();t.sort(function(e,t){return e.offset-t.offset});let i=t.shift(),s=i.rowOffset,n=i.columnOffset,o=-1===i.rowCount?this._getMaxBottom()+1:i.rowCount,r=-1===i.columnCount?this._getMaxRight()+1:i.columnCount,l=s+o-1,a=n+r-1,h=this._isAxisIndexInViewport(s,"row"),d=this._isAxisIndexInViewport(l,"row"),m=this._isAxisIndexInViewport(n,"column"),c=this._isAxisIndexInViewport(a,"column");if(h!==A.AFTER&&d!==A.BEFORE&&m!==A.AFTER&&c!==A.BEFORE){let t;h===A.BEFORE&&(s=this._getMaxTop()),d===A.AFTER&&(l=this._getMaxBottom()),m===A.BEFORE&&(n=this._getMaxLeft()),c===A.AFTER&&(a=this._getMaxRight()),o=l-s+1,r=a-n+1;let u,_,p=!1;-1!==i.rowCount&&-1!==i.columnCount||(p=!0,t=-1===i.rowCount?"column":"row"),"row"===t?(u=s,_=o):"column"===t&&(u=n,_=r);const g=document.createDocumentFragment(),f=document.createDocumentFragment();let C;const y=new Promise(function(e){C=e}),E={axis:t,range:i,headerFragment:g,endHeaderFragment:f,totalDimension:0,promiseResolve:C};this.m_fetchingForUpdate=!0,p?(E.editHeader=!0,this.fetchHeaders(t,u,g,void 0,_,{success:this._handleInsertRangeHeaderFetchSuccess.bind(this,E),error:this.handleHeadersFetchError}),this.fetchCells(this.m_databody,s,n,o,r,{success:this._handleUpdateEditableHeader.bind(this,E),error:this.handleCellsFetchError})):this.fetchCells(this.m_databody,s,n,o,r,{success:this._handleUpdateRangeFetchSuccess.bind(this,E),error:this.handleCellsFetchError}),y.then(this._handleUpdateRangeEvent.bind(this,e))}else this._handleUpdateRangeEvent(e)},A.prototype._handleUpdateEditableHeader=function(e,t,i){this.m_fetchingForUpdate=!1;let s,n,o=e,r=o.range,l=o.axis,a=o.editHeader;"column"===l?(s=r.columnOffset,n=r.columnCount):"row"===l&&(s=r.rowOffset,n=r.rowCount);let h={axis:l,ranges:[{offset:s,count:n}],editHeader:a},d=this.m_root.contains(document.activeElement);this._handleDeleteRangeEvent(h),delete o.range,o.range={offset:s,count:n},this._handleInsertRangeCellFetchSuccess(o,t,i),this._isActiveWithinUpdateRange({detail:{ranges:[r]}})&&(d||(this.m_shouldFocus=!1),this._highlightActive()),this._runModelEventQueue(),this.m_modelEvents?.length||(this.m_processingModelEvent=!1),this._signalTaskEnd()},A.prototype._handleInsertRangeHeaderFetchSuccess=function(e,t,i,s){const n=i.axis;this._signalTaskEnd(),this.m_fetching[n]=!1;const o=this.getResources().isRTLMode()?"right":"left",r=i.start,l=e.range.count,a=e.headerFragment,h=e.endHeaderFragment,d="row"===n?"top":o;let m,c,u;this.updateHiddenAxisForInsertion(r,l,n);let _,p,g,f,C,y,E,v=0,w=0;if(null!=t){for(g=this.getMappedStyle("headercell"),"row"===n?(C=this.m_rowHeaderLevelCount,g+=" "+this.getMappedStyle("rowheadercell")):(C=this.m_columnHeaderLevelCount,g+=" "+this.getMappedStyle("colheadercell")),m=this._getHeaderByIndex(r,n,C-1),c=this.getElementDir(m,d),"column"===n&&this._hasFrozenColumns()&&r===this.m_frozenColIndex+1?this.m_colHeaderFrozen?c=this.getElementWidth(this.m_colHeaderFrozen):this.m_colEndHeaderFrozen&&(c=this.getElementWidth(this.m_colEndHeaderFrozen)):"row"===n&&this._hasFrozenRows()&&r===this.m_frozenRowIndex+1&&(this.m_rowHeaderFrozen?c=this.getElementHeight(this.m_rowHeaderFrozen):this.m_rowEndHeaderFrozen&&(c=this.getElementHeight(this.m_rowEndHeaderFrozen))),u=t.getCount(),f=this.getRendererOrTemplate(n);u-v>0;)"row"===n?(y=0,E=c+w):(y=c+w,E=0),_=r+v,("column"===n&&this._hasFrozenColumns()&&_<=this.m_frozenColIndex+1||"row"===n&&this._hasFrozenRows()&&_<=this.m_frozenRowIndex+1)&&(g=`${g} ${this.getMappedStyle("frozenHeader")}`),p=this.buildLevelHeaders(a,_,0,y,E,!1,!0,f,t,n,g,C),v+=p.count,w+=p.totalHeaderDimension;w>e.totalDimension&&(e.totalDimension=w)}if(w=0,v=0,null!=s){g=this.getMappedStyle("endheadercell"),"row"===n?(C=this.m_rowEndHeaderLevelCount,g+=" "+this.getMappedStyle("rowendheadercell")):(C=this.m_columnEndHeaderLevelCount,g+=" "+this.getMappedStyle("colendheadercell"));const t=`${n}End`;for(m=this._getHeaderByIndex(r,t,C-1),c=this.getElementDir(m,d),u=s.getCount(),f=this.getRendererOrTemplate(t);u-v>0;)"row"===n?(y=0,E=c+w):(y=c+w,E=0),_=r+v,p=this.buildLevelHeaders(h,_,0,y,E,!0,!1,f,s,t,g,C),v+=p.count,w+=p.totalHeaderDimension;w>e.totalDimension&&(e.totalDimension=w)}},A.prototype._handleInsertRangeCellFetchSuccess=function(e,t,i){const s=e.range,n=e.axis,o=e.editHeader,r=e.headerFragment,l=e.endHeaderFragment;let a=e.totalDimension;const h=this.getResources().isRTLMode()?"right":"left",d=document.createDocumentFragment(),m=document.createDocumentFragment(),c=document.createDocumentFragment(),u=document.createDocumentFragment();let _=this.m_rowHeader,p=this.m_rowEndHeader,g=this.m_databodyFrozenRow,f=this.m_rowHeaderFrozen,C=this.m_rowEndHeaderFrozen;if("column"===n&&(_=this.m_colHeader,p=this.m_colEndHeader,g=this.m_databodyFrozenCol,f=this.m_colHeaderFrozen,C=this.m_colEndHeaderFrozen),this.m_modelEvents?.length||(this.m_processingModelEvent=!1),this._signalTaskEnd(),this.m_fetching.cells=!1,o||this.unhighlightSelection(),t){let e=i[0].start;let s=i[1].start,o=t.getCount("row"),r=t.getCount("column");const l=this._getCellByIndex(this.createIndex(e,s));let _,p;if(l?(_="row"===n?this.getElementDir(l,"top"):this.m_startRowPixel,p="row"===n?this.m_startColPixel:this.getElementDir(l,h),"column"===n&&this._hasFrozenColumns()&&s===this.m_frozenColIndex+1&&(p=this.getElementWidth(this.m_databodyFrozenCol)),"row"===n&&this._hasFrozenRows()&&e===this.m_frozenRowIndex+1&&(_=this.getElementHeight(this.m_databodyFrozenRow))):(_="row"===n?this._getMaxBottomPixel():this.m_startRowPixel,p="row"===n?this.m_startColPixel:this._getMaxRightPixel()),"column"===n)if(this._hasFrozenColumns()&&s<=this.m_frozenColIndex+1){this.m_databodyFrozenCorner&&(this._addCellsToFragment(u,t,e,_,s,p,this.m_frozenRowIndex+1,null),e=this.m_frozenRowIndex+1,o-=this.m_frozenRowIndex+1);const i=this._addCellsToFragment(m,t,e,_,s,p,o,r);a=Math.max(a,i.totalColumnWidth)}else{this._hasFrozenRows()&&(this._addCellsToFragment(c,t,e,_,s,p,this.m_frozenRowIndex+1,null),e=this.m_frozenRowIndex+1,o-=this.m_frozenRowIndex+1);const i=this._addCellsToFragment(d,t,e,_,s,p,o,null);a=Math.max(a,"row"===n?i.totalRowHeight:i.totalColumnWidth)}else if("row"===n)if(this._hasFrozenRows()&&e<=this.m_frozenRowIndex+1){this.m_databodyFrozenCorner&&(this._addCellsToFragment(u,t,e,_,s,p,null,this.m_frozenColIndex+1),s=this.m_frozenColIndex+1,r-=this.m_frozenColIndex+1);const i=this._addCellsToFragment(c,t,e,_,s,p,o,r);a=Math.max(a,i.totalRowHeight)}else{this._hasFrozenColumns()&&(this._addCellsToFragment(m,t,e,_,s,p,null,this.m_frozenColIndex+1),s=this.m_frozenColIndex+1,r-=this.m_frozenColIndex+1);const i=this._addCellsToFragment(d,t,e,_,s,p,null,r);a=Math.max(a,i.totalRowHeight)}}let y=this.getMappedStyle("frozenCell");if(u.childNodes&&u.childNodes.length)for(let e=0;e<=u.childNodes.length;e++){let t=u.childNodes[e];this.m_utils.addCSSClassName(t,y)}if(m.childNodes&&m.childNodes.length)for(let e=0;e<=m.childNodes.length;e++){let t=m.childNodes[e];this.m_utils.addCSSClassName(t,y)}if(c.childNodes&&c.childNodes.length)for(let e=0;e<=c.childNodes.length;e++){let t=c.childNodes[e];this.m_utils.addCSSClassName(t,y)}const E=s.offset,v=s.count;let w=new Array(v).fill(E).map((e,t)=>e+t),b=0,H=0;(this._hasFrozenColumns()||this._hasFrozenRows())&&("column"===n&&this._hasFrozenColumns()&&E<=this.m_frozenColIndex+1||"row"===n&&this._hasFrozenRows()&&E<=this.m_frozenRowIndex+1)?H=new Array(v).fill(a/v):b=new Array(v).fill(a/v);let x=d.childNodes.length,S=r.childNodes.length,R=l.childNodes.length,I=this.m_databody.firstChild,M=[];for(let e=w.length-1;e>=0;e--){let t=w[e];("column"===n&&this._hasFrozenColumns()&&t<=this.m_frozenColIndex+1||"row"===n&&this._hasFrozenRows()&&t<=this.m_frozenRowIndex+1)&&(M.push(t),w.splice(e,1))}this._modifyAndPushCells(w,b,n,this.m_databody,_,p,!0,M.length),"column"===n&&this.m_databodyFrozenRow?this._modifyAndPushCells(w,b,n,this.m_databodyFrozenRow,null,null,!0,M.length):"row"===n&&this.m_databodyFrozenCol&&this._modifyAndPushCells(w,b,n,this.m_databodyFrozenCol,null,null,!0,M.length),M.length&&(this._modifyAndPushCells(M,H,n,g,f,C,!0),this.m_databodyFrozenCorner&&this._modifyAndPushCells(M,H,n,this.m_databodyFrozenCorner,null,null,!0),"column"===n?this.m_frozenColIndex+=M.length:this.m_frozenRowIndex+=M.length),o||this._simpleAdjustSelectionOnChange("insert",w,n);let F=!1;if(d.childNodes.length&&(I.appendChild(d),F=!0),m.childNodes.length&&(I=this.m_databodyFrozenCol.firstChild,I.appendChild(m),F=!0),c.childNodes.length&&(I=this.m_databodyFrozenRow.firstChild,I.appendChild(c),F=!0),u.childNodes.length&&(this.m_databodyFrozenCorner.firstChild.appendChild(u),F=!0),F&&this._refreshDatabodyMap(),this._insertHeaders(n,E,r,l),this.hideStatusText(),"row"===n){if(x&&(this.m_endRow+=v,this.m_endRowPixel+=a,this.m_stopRowFetch=!1),S&&(this.m_endRowHeader+=v,(!this._hasFrozenRows()||this._hasFrozenRows()&&E>this.m_frozenRowIndex+1)&&(this.m_endRowHeaderPixel+=a),this.m_stopRowHeaderFetch=!1),R&&(this.m_endRowEndHeader+=v,this.m_endRowEndHeaderPixel+=a,this.m_stopRowEndHeaderFetch=!1),this._hasFrozenRows()&&E<=this.m_frozenRowIndex+1){let e=this.getElementHeight(this.m_databodyFrozenRow)+a;this.setElementHeight(this.m_databodyFrozenRow,e),this.m_databodyFrozenCorner&&this.setElementHeight(this.m_databodyFrozenCorner,e)}else{let e=this.getElementHeight(I)+a;this.setElementHeight(I,e)}this.updateRowBanding()}else if("column"===n){if(x&&(this.m_endCol+=v,this.m_endColPixel+=a,this.m_stopColumnFetch=!1),S&&(this.m_endColHeader+=v,(!this._hasFrozenColumns()||this._hasFrozenColumns()&&E>this.m_frozenColIndex+1)&&(this.m_endColHeaderPixel+=a),this.m_stopColumnHeaderFetch=!1),R&&(this.m_endColEndHeader+=v,this.m_endColEndHeaderPixel+=a,this.m_stopColumnEndHeaderFetch=!1),this._hasFrozenColumns()&&E<=this.m_frozenColIndex+1){let e=this.getElementWidth(this.m_databodyFrozenCol)+a;this.setElementWidth(this.m_databodyFrozenCol,e),this.m_databodyFrozenCorner&&this.setElementWidth(this.m_databodyFrozenCorner,e)}else{let e=this.getElementWidth(I)+a;this.setElementWidth(I,e)}this.updateColumnBanding()}this.deleteAndApplyHiddenIndicators(),o||(this.applySelection(),this._resetHeaderHighLight(),this.resizeGrid()),e.promiseResolve()},A.prototype._insertHeaders=function(e,t,i,s){let n=this.m_rowHeader,o=this.m_rowEndHeader;this._hasFrozenRows()&&t<=this.m_frozenRowIndex&&(n=this.m_rowHeaderFrozen,o=this.m_rowEndHeaderFrozen);let r,l=this.m_rowHeaderLevelCount,a=this.m_rowEndHeaderLevelCount,h=this.m_startRowHeader,d=this.m_startRowEndHeader,m="height",c="top";"column"===e&&(n=this.m_colHeader,o=this.m_colEndHeader,this._hasFrozenColumns()&&t<=this.m_frozenColIndex&&(n=this.m_colHeaderFrozen,o=this.m_colEndHeaderFrozen),l=this.m_columnHeaderLevelCount,a=this.m_columnEndHeaderLevelCount,h=this.m_startColHeader,d=this.m_startColEndHeader,m="width",c=this.getResources().isRTLMode()?"right":"left");let u=(e,t,i,s,n,o,r)=>{for(;e.childNodes.length;){let l,a=e.firstChild;if(this.m_utils.containsCSSClassName(a,this.getMappedStyle("groupingcontainer"))){if(l=a.firstChild,null==l||this.m_utils.containsCSSClassName(l,this.getMappedStyle("groupingcontainer"))){e.removeChild(a);continue}}else l=a;let h=l.extentInfo,d=h.more.before,m=h.more.after,c=l[this.getResources().getMappedAttribute("context")],_=c.index,p=c.extent,g=c.level;if(d){let e=this._getHeaderContainer(_-1,g,t,i),s=e.firstChild,r=s[this.getResources().getMappedAttribute("context")];c.extent+=r.extent,c.index=r.index;let a=this._getAttribute(e,"extent",!0);this._setAttribute(e,"extent",a+p);let h=this.getElementDir(s,n),d=this.getElementDir(l,n);this.setElementDir(l,h+d,n);let m=this.getElementDir(s,o);this.setElementDir(l,m,o),e.replaceChild(l,s)}else if(m){let e=this._getHeaderContainer(_+p,g,t,i),s=e.firstChild,r=s[this.getResources().getMappedAttribute("context")];c.extent+=r.extent,c.index=r.index-p;let a=this._getAttribute(e,"extent",!0);this._setAttribute(e,"extent",a+p);let h=this._getAttribute(e,"start",!0);this._setAttribute(e,"start",h-p);let d=this.getElementDir(s,n),m=this.getElementDir(l,n);this.setElementDir(l,d+m,n);let u=this.getElementDir(s,o);this.setElementDir(l,u-m,o),e.replaceChild(l,s)}else{let e=this._getHeaderContainer(_,g,t,i);if(e){let t=this._getHeaderByIndex(_-1,r,g);if(null===t||t.parentNode!==e){let t=g===i-1?e.childNodes[1]:e.childNodes[0];e.insertBefore(l,t)}else t.nextSibling&&t.nextSibling.parentNode===e?e.insertBefore(l,t.nextSibling):e.appendChild(l)}else{let e=this._getHeaderContainer(_-1,g,t,i);if(null===e){let e=t.firstChild;e.firstChild?e.insertBefore(a,e.firstChild):e.appendChild(a)}else e.nextSibling?e.parentNode.insertBefore(a,e.nextSibling):e.parentNode.appendChild(a)}}if(d||m){let e=a.querySelector("."+this.getMappedStyle("groupingcontainer"));e&&u(e,t,i,s,n,o,r)}}};if(i.childNodes.length&&(1===l?(r=this._getHeaderByIndex(t,e,l-1),n.firstChild.insertBefore(i,r)):u(i,n,l,h,m,c,e)),s.childNodes.length){let i=e+"End";1===a?(r=this._getHeaderByIndex(t,i,l-1),o.firstChild.insertBefore(s,r)):u(s,o,a,d,m,c,i)}},A.prototype._handleModelInsertEvent=function(e,t){var i=this._isInViewport(e);if(i===A.INSIDE||i===A.AFTER&&e.row===this.m_endRow+1)null!=t.row&&(this._databodyEmpty()?(this.empty(),this.refresh(this.m_root)):(this._modifyAxisCellContextIndex("row",e.row,this.m_endRow-e.row+1,1),this._refreshDatabodyMap(),this.fetchHeaders("row",e.row,this.m_rowHeader,this.m_rowEndHeader,1,{success:this._handleHeaderInsertsFetchSuccess}),this.fetchCells(this.m_databody,e.row,this.m_startCol,1,this.m_endCol-this.m_startCol+1,{success:this._handleCellInsertsFetchSuccess})));else{if(i===A.BEFORE){this._modifyAxisCellContextIndex("row",0,this.m_endRow+1,1),this._refreshDatabodyMap(),this.m_startRow+=1,this.m_startRowHeader+=1,this.m_endRow+=1,this.m_endRowHeader+=1,this.m_startRowPixel+=this.m_avgRowHeight,this.m_startRowHeaderPixel+=this.m_avgRowHeight,this.m_endRowPixel+=this.m_avgRowHeight,this.m_endRowHeaderPixel+=this.m_avgRowHeight;var s=this.m_databody.firstChild.firstChild;null!=s&&this.pushRowsDown(s,this.m_avgRowHeight);var n=this.m_rowHeader.firstChild.firstChild;null!=n&&this.pushRowsDown(n,this.m_avgRowHeight);var o=this.m_rowEndHeader.firstChild.firstChild;null!=o&&this.pushRowsDown(o,this.m_avgRowHeight)}this.scrollToIndex(e)}},A.prototype._handleCellInsertsFetchSuccess=function(e,t){this.m_resizeRequired=!0,this.handleCellsFetchSuccess(e,t,this.m_endRow>=t[0].start);var i=t[0].start;this._scrollRowIntoViewport(i),this._isHighWatermarkScrolling()||this._cleanupViewport("top"),this.updateRowBanding(),this.m_stopRowFetch=!1,-1!==this.m_endRowHeader&&(this.m_stopRowHeaderFetch=!1),-1!==this.m_endRowEndHeader&&(this.m_stopRowEndHeaderFetch=!1),this.fillViewport()},A.prototype._handleHeaderInsertsFetchSuccess=function(e,t,i){this.m_resizeRequired=!0,this.handleHeadersFetchSuccess(e,t,i,this.m_endRowHeader>=t.start)},A.prototype._scrollRowIntoViewport=function(e){var t=this._getAxisCellsByIndex(e,"row");if(null!=t){var i=this._getViewportTop(),s=this._getViewportBottom(),n=this.getElementDir(t[0],"top"),o=i-n;(o>0||(o=s-n)<0)&&this.scrollDelta(0,o)}},A.prototype._handleModelInsertRangeEvent=function(e,t,i){var s,n,o,r,l,a,h,d,m=this._getEmptyElement(),c=e.getStart("row"),u=e.getStart("column"),_=e.getCount("column");if(!(c>this.m_endRow+1))if(m)this.empty(),this.refresh(this.m_root);else{if(null!=t){s=document.createDocumentFragment();var p=t.getCount();for(r=0,n=0,a=this.getMappedStyle("headercell")+" "+this.getMappedStyle("rowheadercell"),h=this.getRendererOrTemplate("row");p-n>0;)o=c+n,n+=(l=this.buildLevelHeaders(s,o,0,0,r,!0,c!==this.m_endRowHeader+1,h,t,"row",a,this.m_rowHeaderLevelCount)).count,r+=l.totalHeaderDimension}if(null!=i){d=document.createDocumentFragment();var g=i.getCount();for(r=0,n=0,a=this.getMappedStyle("endheadercell")+" "+this.getMappedStyle("rowendheadercell"),h=this.getRendererOrTemplate("rowEnd");g-n>0;)o=c+n,n+=(l=this.buildLevelHeaders(d,o,0,0,r,!0,c!==this.m_endRowEndHeader+1,h,i,"rowEnd",a,this.m_rowEndHeaderLevelCount)).count,r+=l.totalHeaderDimension}var f=document.createDocumentFragment();if(l=this._addCellsToFragment(f,e,c,0,u,0),!(0!==f.childNodes.length||null!=s&&0!==s.childNodes.length||null!=d&&0!==d.childNodes.length))return;this._insertRowsWithAnimation(f,s,d,c,e.getCount("row"),l.totalRowHeight,u,_)}},A.prototype._handleModelUpdateEvent=function(e,t,i){if(this._isInViewport(e)===A.INSIDE)if(null!=i){var s=this.getRendererOrTemplate("cell"),n=this.m_options.getColumnBandingInterval();this._updateCellsInRow(i,i.getStart("row"),s,this.m_startCol,n)}else-1!==this.m_endRowHeader&&this.fetchHeaders("row",e.row,this.m_rowHeader,this.m_rowEndHeader,1,{success:this._handleHeaderUpdatesFetchSuccess,error:this.handleHeadersFetchError}),this.fetchCells(this.m_databody,e.row,this.m_startCol,1,this.m_endCol-this.m_startCol+1,{success:this._handleCellUpdatesFetchSuccess,error:this.handleCellsFetchError})},A.prototype._handleHeaderUpdatesFetchSuccess=function(e,t,i){var s=t.axis;this.m_fetching[s]=!1;var n=t.start;this._replaceHeaders(this.buildRowHeaders.bind(this),e,this.m_rowHeader,n,this.m_startRowHeader),this._replaceHeaders(this.buildRowEndHeaders.bind(this),i,this.m_rowEndHeader,n,this.m_startRowEndHeader);var o=this.m_rowHeader.firstChild.childNodes[n-this.m_startRowHeader];null==this.m_active||"header"!==this.m_active.type||"row"!==this.m_active.axis&&"rowEnd"!==this.m_active.axis||this._getKey(o,"row")!==this.m_active.key||this._highlightActive(),this._signalTaskEnd()},A.prototype._replaceHeaders=function(e,t,i,s,n){if(null!=t){var o=e(i,t,s,1,!0,!0),r=i.firstChild,l=r.childNodes[s-n];r.replaceChild(o,l)}},A.prototype._handleCellUpdatesFetchSuccess=function(e,t){this.m_fetching.cells=!1;var i=t[0].start,s=this.getRendererOrTemplate("cell"),n=this.m_options.getColumnBandingInterval();this._updateCellsInRow(e,i,s,this.m_startCol,n),this._signalTaskEnd()},A.prototype._getUpdateAnimationDuration=function(){return A.UPDATE_ANIMATION_DURATION},A.prototype._updateCellsInRow=function(e,t,i,s,n){var o,r=this._getUpdateAnimationDuration(),l=this._getAxisCellsByIndex(t,"row"),a=this.getElementDir(l[0],"top");if(0===r)this._removeFromArray(l),o=document.createDocumentFragment(),this._addCellsToFragment(o,e,t,a,s,this.m_startColPixel),this._populateDatabody(this.m_databody.firstChild,o),this._isSelectionEnabled()&&this.applySelection(),this._highlightActive(),this.hideStatusText();else{var h=this;h._signalTaskStart(),this._removeFromArray(l),o=document.createDocumentFragment(),this._addCellsToFragment(o,e,t,a,s,this.m_startColPixel),l=o.childNodes;for(var d=this.getElementWidth(this.m_databody),m=0;m<l.length;m++)this.addTransformMoveStyle(l[m],0,0,"linear",d,0,0);this._populateDatabody(this.m_databody.firstChild,o),l=this._getAxisCellsByIndex(t,"row"),this.hideStatusText();this._onEndEvent("transitionend",l[l.length-1],function(){for(var e=0;e<l.length;e++)h.removeTransformMoveStyle(l[e]);h._isSelectionEnabled()&&h.applySelection(),h._highlightActive(),h._signalTaskEnd(),h._runModelEventQueue()},r),setTimeout(function(){for(var e=0;e<l.length;e++)h.addTransformMoveStyle(l[e],r+"ms",0,"linear",0,0,0)},0)}},A.prototype._handleUpdateRangeFetchSuccess=function(e,t,i){this.m_fetching.cells=!1,this.m_fetchingForUpdate=!1;const s=i[0].start,n=s+t.getCount("row")-1,o=i[1].start,r=o+t.getCount("column")-1,l=this.m_root.contains(document.activeElement);this._splitRange(t,s,n,o,r),this.hideStatusText(),null!=this.m_active&&"cell"===this.m_active.type&&this._isActiveWithinUpdateRange({detail:{ranges:[e.range]}})&&(l||(this.m_shouldFocus=!1),this._highlightActive()),this._runModelEventQueue(),this.m_modelEvents?.length||(this.m_processingModelEvent=!1),this._signalTaskEnd(),e.promiseResolve()},A.prototype._splitRange=function(e,t,i,s,n){let o=i<this.m_frozenRowIndex?i:this.m_frozenRowIndex,r=n<this.m_frozenColIndex?n:this.m_frozenColIndex;null!==this.m_frozenRowIndex&&null!==this.m_frozenColIndex&&t<=this.m_frozenRowIndex&&s<=this.m_frozenColIndex?(this._fetchAndMutateCellsByRange(e,this.m_databodyFrozenCorner,t,o,s,r),i>this.m_frozenRowIndex&&this._fetchAndMutateCellsByRange(e,this.m_databodyFrozenCol,this.m_frozenRowIndex+1,i,s,r),n>this.m_frozenColIndex&&this._fetchAndMutateCellsByRange(e,this.m_databodyFrozenRow,t,o,this.m_frozenColIndex+1,n),i>this.m_frozenRowIndex&&(t=this.m_frozenRowIndex+1),n>this.m_frozenColIndex&&(s=this.m_frozenColIndex+1)):this.m_databodyFrozenCol&&null!==this.m_frozenColIndex&&s<=this.m_frozenColIndex?(this._fetchAndMutateCellsByRange(e,this.m_databodyFrozenCol,t,i,s,r),s=this.m_frozenColIndex+1):this.m_databodyFrozenRow&&null!==this.m_frozenRowIndex&&t<=this.m_frozenRowIndex&&(this._fetchAndMutateCellsByRange(e,this.m_databodyFrozenRow,t,o,s,n),t=this.m_frozenRowIndex+1);let l=null!==this.m_frozenColIndex&&-1!==this.m_frozenColIndex,a=null!==this.m_frozenRowIndex&&-1!==this.m_frozenRowIndex;(!l&&!a||(l||a)&&(!a||i>this.m_frozenRowIndex)&&(!l||n>this.m_frozenColIndex))&&this._fetchAndMutateCellsByRange(e,this.m_databody,t,i,s,n)},A.prototype._fetchAndMutateCellsByRange=function(e,t,i,s,n,o){let r=this._getCellsInRange(i,n,s,o);const l=this.getElementDir(r[0],"top"),a=this.getResources().isRTLMode()?"right":"left",h=this.getElementDir(r[0],a),d=s-i+1,m=o-n+1;this._removeFromArray(r);let c=document.createDocumentFragment();this._addCellsToFragment(c,e,i,l,n,h,d,m),this._populateDatabody(t.firstChild,c)},A.prototype._removeAndModifyCells=function(e,t){e.forEach(e=>{let i=e[this.getResources().getMappedAttribute("context")];1===i.extents[t]?this._remove(e):i.extent[t]-=1})},A.prototype._removeAndModifyHeaders=function(e,t,i,s,n){e.forEach(e=>{let o=e[this.getResources().getMappedAttribute("context")],r=o.extent,l=e.parentNode;if(1===r)this._remove(e),0!==l.childNodes.length||l.classList.contains(this.getMappedStyle("scroller"))||this._remove(l);else{let r=this.getElementDir(e,i);this.setElementDir(e,r-t,i),o.extent-=1;let a=o.index;if(a===n){o.index+=1;let i=this.getElementDir(e,s);this.setElementDir(e,i+t,s)}if(l.classList.contains(this.getMappedStyle("groupingcontainer"))){let e=this._getAttribute(l,"extent",!0),t=this._getAttribute(l,"start",!0);this._setAttribute(l,"extent",e-1),a===n&&this._setAttribute(l,"start",t+1)}}})},A.prototype._handleDeleteRangeEvent=function(e){let t=e.ranges,i=new Set,s=e.axis,n=e.editHeader,o=this.getResources().isRTLMode()?"right":"left",r=this.m_selection;for(let e=0;e<r.length;e++)this._applyBorderClassesAroundRange(this.getElementsInRange(r[e]),r[e],!1,"Selected");t.forEach(function(e){let t=e.offset,s=e.count;for(var n=0;n<s;n++)i.add(t+n)});let l=Array.from(i);l.sort(function(e,t){return t-e});let a=0,h=0,d=0,m=0,c=0,u=0,_=this.m_databodyFrozenRow,p=this.m_rowHeader,g=this.m_rowHeaderFrozen,f=this.m_rowEndHeader,C=this.m_rowEndHeaderFrozen,y=this.m_avgRowHeight,E=-1!==this.m_endRow,v=-1!==this.m_endRowHeader,w=-1!==this.m_endRowEndHeader,b="height",H="top";"column"===s&&(_=this.m_databodyFrozenCol,p=this.m_colHeader,g=this.m_colHeaderFrozen,f=this.m_colEndHeader,C=this.m_colEndHeaderFrozen,y=this.m_avgColWidth,E=-1!==this.m_endCol,v=-1!==this.m_endColHeader,w=-1!==this.m_endColEndHeader,b="width",H=o);let x,S=[],R=[];if(this._isEditOrEnter()&&(x=this._getCellByIndex(this.m_active.indexes)),x){let t=this.getCellIndexes(x),i=!1;l.forEach(e=>{("row"===s&&e===t.row||"column"===s&&e===t.column)&&(i=!0)}),i&&(this._handleExitEditable(e,x),this._handleExitEdit(e,x))}for(let e=0;e<l.length;e++){let t=l[e],i=0,n=this._isAxisIndexInViewport(t,s);if(n===A.BEFORE||n===A.INSIDE){if(n===A.BEFORE)d+=1,i=y,a+=i;else if(n===A.INSIDE){m+=1,i=this.getElementDir(this._getCellOrHeaderByIndex(t,s),b);let e=this._getAxisCellsByIndex(t,s);null!=e&&(this.m_selectionRange&&this.m_selectionRange.length&&this.unhighlightFloodFillRange(this.m_selectionRange[0]),this._removeAndModifyCells(e,s));let n,o=this._getHeadersByIndex(t,s);o.length&&this._removeAndModifyHeaders(o,i,b,H,t),"column"===s?n=this._getHeadersByIndex(t,"columnEnd"):"row"===s&&(n=this._getHeadersByIndex(t,"rowEnd")),n.length&&this._removeAndModifyHeaders(n,i,b,H,t),"column"===s&&this._hasFrozenColumns()&&t<=this.m_frozenColIndex||"row"===s&&this._hasFrozenRows()&&t<=this.m_frozenRowIndex?c+=i:u+=i}"column"===s&&this._hasFrozenColumns()&&t<=this.m_frozenColIndex||"row"===s&&this._hasFrozenRows()&&t<=this.m_frozenRowIndex?R.unshift(i):(h+=i,S.unshift(i))}else n===A.AFTER&&"scroll"===this.m_options.getScrollPolicy()&&(u+=i)}this.updateHiddenAxisForDeletion(l,s),l.reverse();let I=[];for(let e=l.length-1;e>=0;e--){let t=l[e];("column"===s&&this._hasFrozenColumns()&&t<=this.m_frozenColIndex||"row"===s&&this._hasFrozenRows()&&t<=this.m_frozenRowIndex)&&(I.push(t),l.splice(e,1))}if(I.reverse(),this._modifyAndPushCells(l,S,s,this.m_databody,p,f,!1,I.length),"column"===s&&this.m_databodyFrozenRow?this._modifyAndPushCells(l,S,s,this.m_databodyFrozenRow,null,null,!1,I.length):"row"===s&&this.m_databodyFrozenCol&&this._modifyAndPushCells(l,S,s,this.m_databodyFrozenCol,null,null,!1,I.length),I.length&&(this._modifyAndPushCells(I,R,s,_,g,C,!1),this.m_databodyFrozenCorner&&this._modifyAndPushCells(I,R,s,this.m_databodyFrozenCorner,null,null,!1),"column"===s?this.m_frozenColIndex-=I.length:this.m_frozenRowIndex-=I.length),this._refreshDatabodyMap(),!n){let t;this._adjustActive("delete",l),this._simpleAdjustSelectionOnChange("delete",l.reverse(),s);let i={};if(this.m_active&&"cell"===this.m_active.type&&(Object.assign(i,this.m_active.indexes),t=this._getCellByIndex(i),"row"===s))for(;!t&&i.row-1>0;)i.row-=1,t=this._getCellByIndex(i);t&&(this._setActiveByIndex(i,e),this._highlightActive())}var M=this.m_databody.firstChild;if("row"===s){E&&(this.m_startRow-=d,this.m_endRow=this.m_endRow-d-m,this.m_startRowPixel-=a,this.m_endRowPixel=this.m_endRowPixel-a-h,this.m_stopRowFetch=!1),v&&(this.m_startRowHeader-=d,this.m_endRowHeader=this.m_endRowHeader-d-m,this.m_startRowHeaderPixel-=a,this.m_endRowHeaderPixel=this.m_endRowHeaderPixel-a-h,this.m_stopRowHeaderFetch=!1),w&&(this.m_startRowEndHeader-=d,this.m_endRowEndHeader=this.m_endRowEndHeader-d-m,this.m_startRowEndHeaderPixel-=a,this.m_endRowEndHeaderPixel=this.m_endRowEndHeaderPixel-a-h,this.m_stopRowEndHeaderFetch=!1);var F=this.getElementHeight(M)-u;if(this.setElementHeight(M,F),this.m_databodyFrozenCol&&this.setElementHeight(this.m_databodyFrozenCol,F),this.m_databodyFrozenRow){var z=this.getElementHeight(this.m_databodyFrozenRow)-c;this.setElementHeight(this.m_databodyFrozenRow,z),this.m_databodyFrozenCorner&&this.setElementHeight(this.m_databodyFrozenCorner,z)}this.updateRowBanding()}else if("column"===s){E&&(this.m_startCol-=d,this.m_endCol=this.m_endCol-d-m,this.m_startColPixel-=a,this.m_endColPixel=this.m_endColPixel-a-h,this.m_stopColumnFetch=!1),v&&(this.m_startColHeader-=d,this.m_endColHeader=this.m_endColHeader-d-m,this.m_startColHeaderPixel-=a,this.m_endColHeaderPixel=this.m_endColHeaderPixel-a-h,this.m_stopColumnHeaderFetch=!1),w&&(this.m_startColEndHeader-=d,this.m_endColEndHeader=this.m_endColEndHeader-d-m,this.m_startColEndHeaderPixel-=a,this.m_endColEndHeaderPixel=this.m_endColEndHeaderPixel-a-h,this.m_stopColumnEndHeaderFetch=!1);var D=this.getElementWidth(M)-u;if(this.setElementWidth(M,D),this.m_databodyFrozenRow&&this.setElementWidth(this.m_databodyFrozenRow,D),this.m_databodyFrozenCol){var L=this.getElementWidth(this.m_databodyFrozenCol)-c;this.setElementWidth(this.m_databodyFrozenCol,L),this.m_databodyFrozenCorner&&this.setElementWidth(this.m_databodyFrozenCorner,L)}this.updateColumnBanding()}if(!n){this.applySelection(),this.m_utils.isTouchDevice()&&(this.GetSelection().length?this._moveTouchSelectionAffordance():this._removeTouchSelectionAffordance(!0)),this.resizeGrid(),this.deleteAndApplyHiddenIndicators(),this.m_resizeRequired=!0;let e=this;Promise.resolve().then(()=>{null!=e.m_modelEvents&&0===e.m_modelEvents.length&&e.fillViewport()})}},A.prototype._handleModelDeleteEventWithAnimation=function(e,t){this._collapseRowsWithAnimation(e,t)},A.prototype._collapseRowsWithAnimation=function(e,t){var i,s,n,o,r,l,a,h;let d=e.indexes;if(0!==t.length){var m=this;m._signalTaskStart();var c=this.m_processingEventQueue?1:A.COLLAPSE_ANIMATION_DURATION,u=[],_=0,p=-1!==this.m_endRowHeader,g=-1!==this.m_endRowEndHeader,f=this.m_databody.firstChild,C=this._getIndex(this._getAxisCellsByKey(t[0].row,"row")[0],"row")-1;for(s=C;s>=this.m_startRow&&(i=this._getAxisCellsByIndex(s,"row"),!(this.getElementDir(i[0],"top")+this.getElementHeight(i[0])<this.m_currentScrollTop));s--)for(n=0;n<i.length;n++)i[n].style.zIndex=10;if(p)for(r=[],o=this._findHeaderByKey(t[0].row,this.m_rowHeader,this.getMappedStyle("rowheadercell")).previousSibling;o&&!(this.getElementDir(o,"top")+this.getElementHeight(o)<this.m_currentScrollTop);)o.style.zIndex=10,o=o.previousSibling;if(g)for(l=[],o=this._findHeaderByKey(t[0].row,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell")).previousSibling;o&&!(this.getElementDir(o,"top")+this.getElementHeight(o)<this.m_currentScrollTop);)o.style.zIndex=10,o=o.previousSibling;for(s=0;s<t.length;s++){var y=t[s].row;if((i=this._getAxisCellsByKey(y,"row")).length)for(u.push(i),_+=this.getElementHeight(i[0]),n=0;n<i.length;n++)this.setElementDir(i[n],this.getElementDir(i[n],"top")-_,"top"),this.addTransformMoveStyle(i[n],0,0,"linear",0,_,0);p&&null!=(a=this._findHeaderByKey(y,this.m_rowHeader,this.getMappedStyle("rowheadercell")))&&(r.push(a),this.setElementDir(a,this.getElementDir(a,"top")-_,"top"),this.addTransformMoveStyle(a,0,0,"linear",0,_,0)),g&&null!=(h=this._findHeaderByKey(y,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell")))&&(l.push(h),this.setElementDir(h,this.getElementDir(h,"top")-_,"top"),this.addTransformMoveStyle(h,0,0,"linear",0,_,0))}for(s=C+t.length+1;s<=this.m_endRow;s++){for(i=this._getAxisCellsByIndex(s,"row"),n=0;n<i.length;n++)this.setElementDir(i[n],this.getElementDir(i[n],"top")-_,"top"),this.addTransformMoveStyle(i[n],0,0,"linear",0,_,0);p&&(a=a.nextSibling,this.setElementDir(a,this.getElementDir(a,"top")-_,"top"),this.addTransformMoveStyle(a,0,0,"linear",0,_,0)),g&&(h=h.nextSibling,this.setElementDir(h,this.getElementDir(h,"top")-_,"top"),this.addTransformMoveStyle(h,0,0,"linear",0,_,0))}var E=this._getCellByIndex(this.createIndex(this.m_endRow,this.m_endCol));m._onEndEvent("transitionend",E,function(){u.length&&m._modifyAxisCellContextIndex("row",C+t.length+1,m.m_endRow-(C+t.length),-1*t.length),p&&r.length&&m._modifyAxisHeaderContextIndex("row",C+t.length+1,m.m_endRow-(C+t.length),-1*t.length),g&&l.length&&m._modifyAxisHeaderContextIndex("rowEnd",C+t.length+1,m.m_endRow-(C+t.length),-1*t.length);for(var e=0;e<u.length;e++){for(var i=0;i<u[e].length;i++)m._remove(u[e][i]);p&&m._remove(r[e]),g&&m._remove(l[e])}m._adjustActive("delete",d),m._refreshDatabodyMap(),m._isEditOrEnter()&&(m._highlightActiveObject(m.m_active,m.m_prevActive),m._updateEdgeCellBorders("")),m.m_endRow-=u.length,m.m_endRowPixel-=_,m.m_stopRowFetch=!1,p&&(m.m_endRowHeader-=r.length,m.m_endRowHeaderPixel-=_,m.m_stopRowHeaderFetch=!1),g&&(m.m_endRowEndHeader-=r.length,m.m_endRowEndHeaderPixel-=_,m.m_stopRowEndHeaderFetch=!1),m.setElementHeight(f,m.m_endRowPixel-m.m_startRowPixel),m.resizeGrid(),m.updateRowBanding(),null==m.m_modelEvents||0!==m.m_modelEvents.length||m.m_moveActive||m.fillViewport(),m._handleAnimationEnd()},c),this.m_animating=!0,setTimeout(function(){for(s=C+1;s<=m.m_endRow;s++){for(i=m._getAxisCellsByIndex(s,"row"),n=0;n<i.length;n++)m.addTransformMoveStyle(i[n],c+"ms",0,"ease-out",0,0,0);p&&(a=m._getHeaderByIndex(s,"row",0),m.addTransformMoveStyle(a,c+"ms",0,"ease-out",0,0,0)),g&&(h=m._getHeaderByIndex(s,"rowEnd",0),m.addTransformMoveStyle(h,c+"ms",0,"ease-out",0,0,0))}},0)}},A.prototype._handleAnimationEnd=function(){var e,t=this.m_databody.firstChild,i=this.m_rowHeader.firstChild,s=this.m_rowEndHeader.firstChild;for(e=0;e<t.childNodes.length;e++)this.removeTransformMoveStyle(t.childNodes[e]),t.childNodes[e].style.zIndex="";if(-1!==this.m_endRowHeader)for(e=0;e<i.childNodes.length;e++)this.removeTransformMoveStyle(i.childNodes[e]),i.childNodes[e].style.zIndex="";if(-1!==this.m_endRowEndHeader)for(e=0;e<s.childNodes.length;e++)this.removeTransformMoveStyle(s.childNodes[e]),s.childNodes[e].style.zIndex="";this.m_animating=!1,this._runModelEventQueue(),this._signalTaskEnd()},A.prototype._getCellOrHeaderByKey=function(e,t){var i=null,s=this._getAxisCellsByKey(e,t,!0);return null!=s&&s.length>0&&(i=s[0]),null==i&&("row"===t?null==(i=this._findHeaderByKey(e,this.m_rowHeader,this.getMappedStyle("rowheadercell")))&&(i=this._findHeaderByKey(e,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell"))):"column"===t&&null==(i=this._findHeaderByKey(e,this.m_colHeader,this.getMappedStyle("colheadercell")))&&(i=this._findHeaderByKey(e,this.m_colEndHeader,this.getMappedStyle("colendheadercell")))),i},A.prototype._findHeaderByKey=function(e,t,i){if(null==t)return null;var s=[],n=[];if(s.push(t),this._hasFrozenRows()&&(t===this.m_rowHeader||t===this.m_rowEndHeader)){let e=t===this.m_rowHeader?this.m_rowHeaderFrozen:this.m_rowEndHeaderFrozen;s.push(e)}if(this._hasFrozenColumns()&&(t===this.m_colHeader||t===this.m_colEndHeader)){let e=t===this.m_colHeader?this.m_colHeaderFrozen:this.m_colEndHeaderFrozen;s.push(e)}for(let e=0;e<s.length;e++)n.push(...s[e].getElementsByClassName(i));for(var o=0;o<n.length;o++){var r=n[o],l=this._getKey(r);if(this._shallowThenDeepCompare(l,e))return r}return null},A.prototype._handleModelRefreshEvent=function(e){let t,i;if(null!=e){const s={ranges:[]};let n=!0;if(null!=e.disregardAfterColumnOffset&&this._getCellOrHeaderByIndex(e.disregardAfterColumnOffset,"column")){s.axis="column";const t=e.disregardAfterColumnOffset+1;s.ranges.push({offset:t,count:this.m_endCol-e.disregardAfterColumnOffset}),n=!1}if(null!=e.disregardAfterRowOffset&&this._getCellOrHeaderByIndex(e.disregardAfterRowOffset,"row")){s.axis="row";const t=e.disregardAfterRowOffset+1;s.ranges.push({offset:t,count:this.m_endRow-e.disregardAfterRowOffset}),n=!1}if(e.preserved&&("columns"===e.preserved&&(t=this.m_currentScrollLeft),"rows"===e.preserved&&(i=this.m_currentScrollTop)),!n)return void this._handleDeleteRangeEvent(s)}var s=this.getVisibility();this.m_focusOnRefresh=this.m_root.contains(document.activeElement),this.m_updateScrollPostionOnRefreshCallback(t,i),s===A.VISIBILITY_STATE_VISIBLE?(this.empty(),null!=this.m_root.offsetParent?this.refresh(this.m_root):this.setVisibility(A.VISIBILITY_STATE_REFRESH)):s===A.VISIBILITY_STATE_HIDDEN&&(this.empty(),this.setVisibility(A.VISIBILITY_STATE_REFRESH))},A.prototype._handleModelSyncEvent=function(e){var t=e.pageSize;this.m_fetching={},this.m_startRow=0,this.m_endRow=-1,this.m_startRowHeader=0,this.m_endRowHeader=-1,this.m_startRowEndHeader=0,this.m_endRowEndHeader=-1,this.m_startRowPixel=0,this.m_endRowPixel=0,this.m_startRowHeaderPixel=0,this.m_endRowHeaderPixel=0,this.m_startRowEndHeaderPixel=0,this.m_endRowEndHeaderPixel=0,this.m_startCol=0,this.m_endCol=-1,this.m_startColHeader=0,this.m_endColHeader=-1,this.m_startColEndHeader=0,this.m_endColEndHeader=-1,this.m_startColPixel=0,this.m_endColPixel=0,this.m_startColHeaderPixel=0,this.m_endColHeaderPixel=0,this.m_startColEndHeaderPixel=0,this.m_endColEndHeaderPixel=0,this.m_rowHeaderLevelCount=void 0,this.m_columnHeaderLevelCount=void 0,this.m_rowEndHeaderLevelCount=void 0,this.m_columnEndHeaderLevelCount=void 0,this.m_avgRowHeight=void 0,this.m_avgColWidth=void 0,this.m_isEstimateRowCount=void 0,this.m_isEstimateColumnCount=void 0,this.m_stopRowFetch=!1,this.m_stopRowHeaderFetch=!1,this.m_stopRowEndHeaderFetch=!1,this.m_stopColumnFetch=!1,this.m_stopColumnHeaderFetch=!1,this.m_stopColumnEndHeaderFetch=!1,this._clearScrollPositionKeys(),this.m_selection=null,this.m_selectionRange=null,this.m_active=null,this.m_prevActive=null,this.m_trueIndex={},null!=this.m_empty&&(this.m_databody.firstChild.removeChild(this.m_empty),this.m_empty=null),this._showHeader(this.m_rowHeader),this._showHeader(this.m_colHeader),this._showHeader(this.m_rowEndHeader),this._showHeader(this.m_colEndHeader),this._emptyHeaders(),this._emptyHeaderLabels();var i=this.m_databody.firstChild;null!=i&&this._emptyDatabody(i),this.m_initialized=!1,this.fetchHeaders("row",0,this.m_rowHeader,this.m_rowEndHeader,t,{success:function(e,t,i){this.handleHeadersFetchSuccess(e,t,i,!1)}}),this.fetchHeaders("column",0,this.m_colHeader,this.m_colEndHeader,void 0,{success:function(e,t,i){this.handleHeadersFetchSuccess(e,t,i,!1)}}),this.fetchCells(this.m_databody,0,0,t,null,{success:function(e,t){this.handleCellsFetchSuccess(e,t)}})},A.prototype._emptyHeaders=function(){var e=this.m_rowHeader.firstChild,t=this.m_rowEndHeader.firstChild;null!=e&&this.m_utils.empty(e),null!=t&&this.m_utils.empty(t);var i=this.m_colHeader.firstChild,s=this.m_colEndHeader.firstChild;null!=i&&this.m_utils.empty(i),null!=s&&this.m_utils.empty(s)},A.prototype._emptyHeaderLabels=function(){var e=this.m_headerLabels.row,t=this.m_headerLabels.rowEnd,i=this.m_headerLabels.column,s=this.m_headerLabels.columnEnd;e&&e.length&&e.forEach(e=>{this.m_utils.empty(e)}),t&&t.length&&t.forEach(e=>{this.m_utils.empty(e)}),i&&i.length&&i.forEach(e=>{this.m_utils.empty(e)}),s&&s.length&&s.forEach(e=>{this.m_utils.empty(e)})},A.prototype._setActiveByIndex=function(e,t,i,s,n){let o=this._getCellByIndex(e);return this._setActive(o,{type:"cell",indexes:e},t,i,s,n)},A.prototype._updateActive=function(e,t,i){var s;if(null==e)this._setActive(null,null,null,!0,!1,i);else if(null!=e.keys)s=this._getCellByKeys(e.keys);else if(null!=e.indexes)s=this._getCellByIndex(e.indexes);else if(null!=e.axis){var n=null==e.level?0:e.level;"column"===e.axis?null!=e.key?s=this._findHeaderByKey(e.key,this.m_colHeader,this.getMappedStyle("colheadercell")):null!=e.index?s=this._getHeaderByIndex(e.index,e.axis,n):"label"===e.type&&(s=this._getLabel(e.axis,e.level)):"row"===e.axis?null!=e.key?s=this._findHeaderByKey(e.key,this.m_rowHeader,this.getMappedStyle("rowheadercell")):null!=e.index?s=this._getHeaderByIndex(e.index,e.axis,n):"label"===e.type&&(s=this._getLabel(e.axis,e.level)):"columnEnd"===e.axis?null!=e.key?s=this._findHeaderByKey(e.key,this.m_colEndHeader,this.getMappedStyle("colendheadercell")):null!=e.index?s=this._getHeaderByIndex(e.index,e.axis,n):"label"===e.type&&(s=this._getLabel(e.axis,e.level)):"rowEnd"===e.axis&&(null!=e.key?s=this._findHeaderByKey(e.key,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell")):null!=e.index?s=this._getHeaderByIndex(e.index,e.axis,n):"label"===e.type&&(s=this._getLabel(e.axis,e.level)))}null!=s&&(t||(this.m_shouldFocus=!1),this._setActive(s,e,null,!0,!1,i))},A.prototype._setActive=function(e,t,i,s,n,o,r){var l;if(null==t||o||this._scrollToActive(t),null!=e)if(l=this._createActiveObject(e),this._compareActive(l,this.m_active)){if(n||this._fireBeforeCurrentCellEvent(l,this.m_active,i)){this.m_prevActive=this.m_active,this.m_active=l;const t=this._getElementFromActiveObject(this.m_prevActive);return t&&_.disableAllFocusableElements(t),!i||"mousedown"!==i.type&&"touchend"!==i.type||(this.m_trueIndex=null),s&&this._isSelectionEnabled()&&this._clearSelection(i),this.deleteDatabodyHiddenVisualIndicators(),this._unhighlightActiveObject(this.m_prevActive),this._highlightActiveObject(this.m_active,this.m_prevActive,null,o),this._manageMoveCursor(),this._isGridEditable()&&"cell"===l.type&&(this._setEditableClone(e),this._updateEdgeCellBorders("")),n||this._fireCurrentCellEvent(l,i),this.m_options.isFloodFillEnabled()&&this._isSelectionEnabled()&&!this.m_discontiguousSelection&&"cell"===this.m_active.type&&i&&(this._addFloodfillAffordance(i),this._moveFloodFillAffordance()),!0}}else this._highlightActive(null,r);else if(!this.m_scrollIndexAfterFetch&&!this.m_scrollHeaderAfterFetch)return(n||this._fireBeforeCurrentCellEvent(l,this.m_active,i))&&(this.m_prevActive=this.m_active,this.m_active=null,this._unhighlightActiveObject(this.m_prevActive),n||this._fireCurrentCellEvent(l,i)),!0;return!1},A.prototype._createActiveObject=function(e){var t=e[this.getResources().getMappedAttribute("context")];return this.m_utils.containsCSSClassName(e,this.getMappedStyle("headercell"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("endheadercell"))?{type:"header",axis:t.axis,index:this.getHeaderCellIndex(e),key:t.key,level:t.level}:this.m_utils.containsCSSClassName(e,this.getMappedStyle("headerlabel"))?{type:"label",axis:t.axis,level:t.level}:this.m_utils.containsCSSClassName(e,this.getMappedStyle("noDataContainer"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("emptytext"))?{type:"empty"}:{type:"cell",indexes:{row:t.indexes.row,column:t.indexes.column},keys:{row:t.keys.row,column:t.keys.column},extents:{row:t.extents.row,column:t.extents.column}}},A.prototype._getActiveElement=function(){return this._getElementFromActiveObject(this.m_active)},A.prototype._getElementFromActiveObject=function(e){if(null!=e){if("header"!==e.type)return"label"===e.type?this._getLabel(e.axis,e.level):"empty"===e.type?this._getEmptyElement():this._getCellByIndex(e.indexes);if("row"===e.axis){let t=this.m_rowHeader;return this._hasFrozenRows()&&e.index<=this.m_frozenRowIndex&&(t=this.m_rowHeaderFrozen),this._findHeaderByKey(e.key,t,this.getMappedStyle("rowheadercell"))}if("column"===e.axis){let t=this.m_colHeader;return this._hasFrozenColumns()&&e.index<=this.m_frozenColIndex&&(t=this.m_colHeaderFrozen),this._findHeaderByKey(e.key,t,this.getMappedStyle("colheadercell"))}if("rowEnd"===e.axis){let t=this.m_rowEndHeader;return this._hasFrozenRows()&&e.index<=this.m_frozenRowIndex&&(t=this.m_rowEndHeaderFrozen),this._findHeaderByKey(e.key,t,this.getMappedStyle("rowendheadercell"))}if("columnEnd"===e.axis){let t=this.m_colEndHeader;return this._hasFrozenColumns()&&e.index<=this.m_frozenColIndex&&(t=this.m_colEndHeaderFrozen),this._findHeaderByKey(e.key,t,this.getMappedStyle("colendheadercell"))}}return null},A.prototype._compareActive=function(e,t){if(null==e&&null==t)return!1;if(null==e&&null!=t||null!=e&&null==t)return!0;if(e.type!==t.type)return!0;if("empty"===e.type)return!0;if("header"===e.type){if(e.index!==t.index||e.key!==t.key||e.axis!==t.axis||e.level!==t.level)return!0}else if("label"===e.type){if(e.axis!==t.axis||e.level!==t.level)return!0}else if(e.indexes.row!==t.indexes.row||e.indexes.column!==t.indexes.column||e.keys.row!==t.keys.row||e.keys.column!==t.keys.column)return!0;return!1},A.prototype._fireBeforeCurrentCellEvent=function(e,t,i){var s={event:i,ui:{currentCell:e,previousCurrentCell:t}};return this.fireEvent("beforeCurrentCell",s)},A.prototype._fireCurrentCellEvent=function(e,t){var i={event:t,ui:e};return this.fireEvent("currentCell",i)},A.prototype._isDatabodyCellActive=function(){return null!=this.m_active&&"cell"===this.m_active.type},A.prototype._updateActiveContext=function(e,t){var i,s,n,o={};if("header"===e.type){i=e.axis;var r=e.index;s=e.level,"row"===e.axis?(this.m_rowHeaderLevelCount>1&&(null!=t&&s===t.level&&i===t.axis||(o.level=s)),null!=t&&r===t.index&&i===t.axis||(o.rowHeader=r)):"column"===i?(this.m_columnHeaderLevelCount>1&&(null!=t&&s===t.level&&i===t.axis||(o.level=s)),null!=t&&r===t.index&&i===t.axis||(o.columnHeader=r)):"rowEnd"===e.axis?(this.m_rowEndHeaderLevelCount>1&&(null!=t&&s===t.level&&i===t.axis||(o.level=s)),null!=t&&r===t.index&&i===t.axis||(o.rowEndHeader=r)):"columnEnd"===i&&(this.m_columnEndHeaderLevelCount>1&&(null!=t&&s===t.level&&i===t.axis||(o.level=s)),null!=t&&r===t.index&&i===t.axis||(o.columnEndHeader=r)),this._updateContextInfo(o,n)}else"cell"===e.type?(null==t||"cell"!==t.type||null==e||this.m_externalFocus||(e.indexes.row===t.indexes.row?n="row":e.indexes.column===t.indexes.column&&(n="column")),this._updateContextInfo(e,n)):"label"===e.type&&(i=e.axis,s=e.level,(null==t||"label"!==t.type||"label"===t.type&&t.axis!==i||this.m_externalFocus)&&("column"===i?o.columnHeaderLabel=s:"row"===i?o.rowHeaderLabel=s:"rowEnd"===i?o.rowEndHeaderLabel=s:"columnEnd"===i&&(o.columnEndHeaderLabel=s)),this._updateContextInfo(o,n))},A.prototype.handleDatabodyClickActive=function(e){var t=e.target,i=this.findCell(t);null!=i&&this._setActive(i,this._createActiveObject(i),e);const s=this._getEmptyElement();s&&this._setActive(s,this._createActiveObject(s),e)},A.prototype.handleHeaderClickActive=function(e,t,i){var s=e.target,n=this.findHeader(s);null!=n&&(t||this._clearSelection(e),this._setActive(n,this._createActiveObject(n),e,null,null,i))},A.prototype._scrollToActive=function(e){"header"===e.type?this.scrollToHeader(e):"cell"===e.type&&this.scrollToIndex(e.indexes)},A.prototype._getCellByKeys=function(e){if(null==e||null==e.row||null==e.column||null==this.m_databody||null==this.m_databody.firstChild)return null;for(var t=this.m_databody.firstChild.getElementsByClassName(this.getMappedStyle("cell")),i=0;i<t.length;i++){var s=t[i],n=this._getKey(s,"row");if(this._shallowThenDeepCompare(n,e.row)){var o=this._getKey(s,"column");if(this._shallowThenDeepCompare(o,e.column))return s}}return null},A.prototype._shallowThenDeepCompare=function(e,t){return e===t||this._compareValuesCallback(e,t)},A.prototype.getCellKeys=function(e){var t=e[this.getResources().getMappedAttribute("context")];return this.createIndex(t.keys.row,t.keys.column)},A.prototype.getCellIndexes=function(e){var t=e[this.getResources().getMappedAttribute("context")];return this.createIndex(t.indexes.row,t.indexes.column)},A.prototype.getCellExtents=function(e){var t=e[this.getResources().getMappedAttribute("context")];return this.createIndex(t.extents.row,t.extents.column)},A.prototype.getCellEndIndexes=function(e){var t=this.getCellIndexes(e),i=this.getCellExtents(e);return this.createIndex(t.row+(i.row-1),t.column+(i.column-1))},A.prototype._getIndex=function(e,t){if(null!=e){if(null==t||!this.m_utils.containsCSSClassName(e,this.getMappedStyle("cell")))return this.getHeaderCellIndex(e);var i=e[this.getResources().getMappedAttribute("context")];if("row"===t)return i.indexes.row;if("column"===t)return i.indexes.column}return null},A.prototype._getExtent=function(e,t){if(null!=e){if(null==t||!this.m_utils.containsCSSClassName(e,this.getMappedStyle("cell")))return parseInt(this._getAttribute(e,"extent",!0),10);var i=e[this.getResources().getMappedAttribute("context")];if("row"===t)return i.extents.row;if("column"===t)return i.extents.column}return null},A.prototype.getHeaderCellIndex=function(e){var t,i,s;let n,o=e,r=this.getMappedStyle("headercell");switch(this.getHeaderCellAxis(e)){case"column":t=this.m_columnHeaderLevelCount,i=this.m_startColHeader,this._hasFrozenColumns()&&(n=this.m_colHeaderFrozen);break;case"row":t=this.m_rowHeaderLevelCount,i=this.m_startRowHeader,this._hasFrozenRows()&&(n=this.m_rowHeaderFrozen);break;case"columnEnd":t=this.m_columnEndHeaderLevelCount,i=this.m_startColEndHeader,this._hasFrozenColumns()&&(n=this.m_colEndHeaderFrozen),r=this.getMappedStyle("endheadercell");break;case"rowEnd":t=this.m_rowEndHeaderLevelCount,i=this.m_startRowEndHeader,this._hasFrozenRows()&&(n=this.m_rowEndHeaderFrozen),r=this.getMappedStyle("endheadercell");break;default:return-1}if(t>1){if(s=this._getAttribute(e.parentNode,"start",!0),e===e.parentNode.firstChild)return s;s-=1}else s=i;for(o=this._getHeaderPreviousSibling(o);o;)s+=1,o=this._getHeaderPreviousSibling(o);return 1===t&&void 0!==n&&null===n.querySelector(`#${e.id}`)&&(s+=this._getChildElementCountByClassName(n.firstChild,r)),s},A.prototype.getHeaderCellAxis=function(e){return this.m_utils.containsCSSClassName(e,this.getMappedStyle("colheadercell"))?"column":this.m_utils.containsCSSClassName(e,this.getMappedStyle("rowheadercell"))?"row":this.m_utils.containsCSSClassName(e,this.getMappedStyle("rowendheadercell"))?"rowEnd":this.m_utils.containsCSSClassName(e,this.getMappedStyle("colendheadercell"))?"columnEnd":null},A.prototype.getHeaderCellLevel=function(e){if(this.m_utils.containsCSSClassName(e,this.getMappedStyle("colheadercell"))){if(1===this.m_columnHeaderLevelCount)return 0}else if(this.m_utils.containsCSSClassName(e,this.getMappedStyle("rowheadercell"))){if(1===this.m_rowHeaderLevelCount)return 0}else if(this.m_utils.containsCSSClassName(e,this.getMappedStyle("colendheadercell"))){if(1===this.m_columnEndHeaderLevelCount)return 0}else if(this.m_utils.containsCSSClassName(e,this.getMappedStyle("rowendheadercell"))&&1===this.m_rowEndHeaderLevelCount)return 0;var t=this._getAttribute(e.parentNode,"level",!0);return e===e.parentNode.firstChild?t:t+this.getHeaderCellDepth(e.parentNode.firstChild)},A.prototype.getHeaderCellDepth=function(e){return this._getAttribute(e,"depth",!0)},A.prototype.getHeaderLabelLevel=function(e){let t=e[this.getResources().getMappedAttribute("context")];return t?t.level:null},A.prototype.getHeaderLabelAxis=function(e){let t=e[this.getResources().getMappedAttribute("context")];return t?t.axis:null},A.prototype._getResizeHeaderMode=function(e){var t="row";return(this.m_utils.containsCSSClassName(e,this.getMappedStyle("colheadercell"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("colendheadercell"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("columnheaderlabel"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("columnendheaderlabel")))&&(t="column"),t},A.prototype.findCellOrHeader=function(e){var t=this.findCell(e);return null==t&&(t=this.findHeader(e)),t},A.prototype.findCell=function(e){return this.find(e,"cell")},A.prototype.findLabel=function(e){return this.find(e,"headerlabel")},A.prototype.find=function(e,t,i){return null==e||e===this.getRootElement()?null:(null==i&&(i=this.getMappedStyle(t)),null==i?null:this.m_utils.containsCSSClassName(e,i)?e:this.find(e.parentNode,t,i))},A.prototype._highlightActive=function(e,t){this._highlightActiveObject(this.m_active,this.m_prevActive,e,null,t)},A.prototype._unhighlightActive=function(e){this._unhighlightActiveObject(this.m_active,e)},A.prototype._highlightActiveObject=function(e,t,i,s,n){if(null==i&&this.m_utils.shouldOffsetOutline()&&(i=["offsetOutline"]),null!=e){var o=this._getElementFromActiveObject(e);null!=o&&(n||this.m_focusInHandler(o),null!=i&&this._highlightElement(o,i),this._isCellEditable()&&"cell"===e.type&&this._applyBorderClassesAroundRange(o,{startIndex:e.indexes},!0,"Edit"),this._setAriaProperties(e,t,o,s))}},A.prototype._unhighlightActiveObject=function(e,t){if(null==t&&this.m_utils.shouldOffsetOutline()&&(t=["offsetOutline"]),null!=e){var i=this._getElementFromActiveObject(e);null!=i&&(this.m_focusOutHandler(i),null!=t&&this._unhighlightElement(i,t),this._isGridEditable()&&"cell"===e.type&&this._applyBorderClassesAroundRange(i,{startIndex:e.indexes},!1,"Edit"),this._unsetAriaProperties(i))}},A.prototype._highlightCellsAlongAxis=function(e,t,i,s,n){for(var o="key"===i?this._getAxisCellsByKey(e,t):this._getAxisCellsByIndex(e,t),r=0;r<o.length;r++)"add"===s?this._highlightElement(o[r],n):this._unhighlightElement(o[r],n)},A.prototype._highlightElement=function(e,t){for(var i=0;i<t.length;i++){var s=this.getMappedStyle(t[i]);this.m_utils.addCSSClassName(e,s)}},A.prototype._unhighlightElement=function(e,t){for(var i=0;i<t.length;i++){var s=this.getMappedStyle(t[i]);this.m_utils.removeCSSClassName(e,s)}},A.prototype._unhighlightElementsByClassName=function(e,t){if(e.length&&t.length)for(var i=0;i<e.length;i++)this._unhighlightElement(e[i],t)},A.prototype._setAriaProperties=function(e,t,i,s){var n=this.getLabelledBy(e,t,i);this._updateActiveContext(e,t),i.setAttribute("tabIndex",0),i.setAttribute("aria-labelledby",n),i.setAttribute("role","application"),null!=this.m_cellToFocus&&this.m_cellToFocus===i||!1===this.m_shouldFocus||i.focus({preventScroll:s}),this.m_shouldFocus=null},A.prototype._unsetAriaProperties=function(e){null!=e&&(e.setAttribute("tabIndex",-1),e.removeAttribute("aria-labelledby"),e.removeAttribute("role"),_.isIos()&&e.setAttribute("role","text"))},A.prototype.getLabelledBy=function(e,t,i,s){var n,o,r,l,a="",h=[];const d=i[this.getResources().getMappedAttribute("metadata")];if("header"===e.type){null==t||"header"!==t.type||this.m_externalFocus||(n=this._getHeaderByIndex(t.index,t.axis,t.level)),a=[this.createSubId("context"),this._getHeaderAndParentIds(i,n)].join(" ");var m=i.getAttribute(this.getResources().getMappedAttribute("sortDir"));if("ascending"===m?o="accessibleSortAscending":"descending"===m?o="accessibleSortDescending":this._getAttribute(i,"sortable")&&(o="accessibleSortable"),null!=o&&h.push({key:o,args:{id:""}}),d&&d.metadata){"expanded"===d.metadata.expanded?h.push({key:"accessibleExpanded",args:{}}):"collapsed"===d.metadata.expanded&&h.push({key:"accessibleCollapsed",args:{}});const t=d.metadata.treeDepth;if(null!=t){let i,s,n,o,r;"row"===e.axis?(i=this.m_stopRowHeaderFetch&&this.m_stopRowEndHeaderFetch&&this.m_stopRowFetch,s=this.m_endRowHeader,n=this.m_startRowHeader):"column"===e.axis&&(s=this.m_endColHeader,n=this.m_startColHeader,i=this.m_stopColumnHeaderFetch&&this.m_stopColumnEndHeaderFetch&&this.m_stopColumnFetch),h.push({key:"accessibleLevelHierarchicalContext",args:{level:t+1}});let l="";const a=[...this.m_root.querySelectorAll(".oj-datagrid-"+e.axis+"-header-cell")];if(t>0){let h,d;a.forEach(i=>{const s=i[this.getResources().getMappedAttribute("context")],n=s.metadata;n.treeDepth<t&&s.index>e.index&&(!d||s.index<d)&&(d=s.index),n.treeDepth===t-1&&s.index<e.index&&(!h||s.index>h)&&(h=s.index)}),null!=h&&null!=d?l="Full":null!=h&&null==d?(d=s+1,l=i?"Full":"Partial"):null==h&&null!=d?(h=n-1,l="Unknown"):(h=n-1,d=s+1,l="Unknown"),o=0,r=0,a.forEach(i=>{const s=i[this.getResources().getMappedAttribute("context")];s.metadata.treeDepth===t&&(s.index<=e.index&&s.index>h&&(r+=1),s.index>h&&s.index<d&&(o+=1))})}else{o=0,r=1;l=0===this.m_startRowHeader?i?"Full":"Partial":"Unknown",a.forEach(i=>{const s=i[this.getResources().getMappedAttribute("context")];s.metadata.treeDepth===t&&(o+=1,s.index<e.index&&(r+=1))})}const d=this._getHierarchicalTranslationKey(l,e.axis);h.push({key:d,args:{posInSet:r,setSize:o}})}}0!==h.length&&(a=a+" "+this.createSubId("state")),i.setAttribute("tabIndex",0)}else if("label"===e.type)a=[this.createSubId("context"),this._getActiveElement().id].join(" ");else if("empty"===e.type)a=this._getActiveElement().id;else{null!=t&&("header"===t.type?(r="row"===t.axis?t.index:null,l="column"===t.axis?t.index:null):"cell"===t.type&&(r=t.indexes.row,l=t.indexes.column));var c=this._getHeaderLabelledBy("row",this.m_rowHeaderLevelCount,this.m_endRowHeader,e.indexes.row,r,i),u=this._getHeaderLabelledBy("rowEnd",this.m_rowEndHeaderLevelCount,this.m_endRowEndHeader,e.indexes.row,r,i),p=this._getHeaderLabelledBy("column",this.m_columnHeaderLevelCount,this.m_endColHeader,e.indexes.column,l,i),g=this._getHeaderLabelledBy("columnEnd",this.m_columnEndHeaderLevelCount,this.m_endColEndHeader,e.indexes.column,l,i),f=e.extents.row,C=e.extents.column;f>1&&h.push({key:"accessibleRowSpanContext",args:{extent:f}}),C>1&&h.push({key:"accessibleColumnSpanContext",args:{extent:C}}),a=(a=s?[c,u,p,g,i.id].join(" "):[this.createSubId("context"),c,u,p,g,i.id,this.createSubId("state")].join(" ")).replace(/ +(?= )/g,"")}!0===this.m_externalFocus&&(null!=this.m_root.id&&(a=[this.m_root.id,a].join(" ")),a=[this.createSubId("summary"),a].join(" "),this.m_externalFocus=!1);let y=_.getActionableElementsInNode(i);return y&&y.length>0&&h.push({key:"accessibleContainsControls"}),this._updateStateInfo(h),a},A.prototype._getHierarchicalTranslationKey=function(e,t){return"accessible"+(t.charAt(0).toUpperCase()+t.slice(1))+"Hierarchical"+e},A.prototype.getHeaderFromCell=function(e,t,i){var s,n,o;return"row"===t?null!=this.m_rowHeader&&(s=this._getIndex(e,"row"),n=this._getExtent(e,"row"),o=this.m_rowHeaderLevelCount-1):"column"===t?null!=this.m_colHeader&&(s=this._getIndex(e,"column"),n=this._getExtent(e,"column"),o=this.m_columnHeaderLevelCount-1):"rowEnd"===t?null!=this.m_rowEndHeader&&(s=this._getIndex(e,"row"),n=this._getExtent(e,"row"),o=this.m_rowEndHeaderLevelCount-1):"columnEnd"===t&&null!=this.m_colEndHeader&&(s=this._getIndex(e,"column"),n=this._getExtent(e,"column"),o=this.m_columnEndHeaderLevelCount-1),null!=s&&null!=o&&s>-1?(i&&(s+=n-1),this._getHeaderByIndex(s,t,o)):null},A.prototype._trimRangeForSelectionMode=function(e){return"row"===this.m_options.getSelectionMode()?this.createRange(this.createIndex(e.startIndex.row),this.createIndex(e.endIndex.row)):e},A.prototype.createRange=function(e,t,i,s){var n,o,r,l,a,h,d,m;return t&&(e.row<t.row||-1===t.row?(n=e.row,o=t.row,i&&(a=i.row,h=s.row)):(n=t.row,o=e.row,i&&(a=s.row,h=i.row)),isNaN(e.column)||isNaN(t.column)?(e={row:n},t={row:o},i&&(i={row:a,column:d},s={row:h,column:m})):(e.column<t.column||-1===t.column?(r=e.column,l=t.column,i&&(d=i.column,m=s.column)):(r=t.column,l=e.column,i&&(d=s.column,m=i.column)),e={row:n,column:r},t={row:o,column:l},i&&(i={row:a,column:d},s={row:h,column:m}))),i?{startIndex:e,endIndex:t,startKey:i,endKey:s}:{startIndex:e,endIndex:t}},A.prototype._createRangeWithKeys=function(e,t,i){this._keys(e,this._createRangeStartKeyCallback.bind(this,t,i))},A.prototype._createRangeStartKeyCallback=function(e,t,i,s){null!=e&&null!=s&&e.row===s.row&&e.column===s.column?this._createRangeEndKeyCallback(i,s,t,i,s):e?this._keys(e,this._createRangeEndKeyCallback.bind(this,i,s,t)):t.call(this,{startIndex:s,endIndex:s,startKey:i,endKey:i})},A.prototype._createRangeEndKeyCallback=function(e,t,i,s,n){i.call(this,this.createRange(t,n,e,s))},A.prototype.getEndIndex=function(e){return null==e.endIndex?e.startIndex:e.endIndex},A.prototype.getElementsInRange=function(e,t,i,s,n){var o,r,l,a,h;null==t&&(t=this.m_startRow),null==i&&(i=this.m_endRow+1);var d=e.startIndex,m=this.getEndIndex(e),c=d.row,u=m.row;if(-1===u&&(u=Number.MAX_VALUE),i<c||u<t)return null;if(!isNaN(d.column)&&!isNaN(m.column)&&(o=d.column,-1===(r=m.column)&&(r=Number.MAX_VALUE),this.m_endCol+1<o||r<this.m_startCol))return null;var _=[];if(null==this.m_databody.firstChild)return null;if(c=Math.max(this.m_startRow,c),u=Math.min(this.m_endRow,u),isNaN(o)||isNaN(r))for(o=Math.max(0,this.m_startCol),r=Math.max(o,this.m_endCol),l=c;l<=u;l+=1)for(a=o;a<=r;a+=1)null!=(h=this._getCellByIndex(this.createIndex(l,a)))&&-1===_.indexOf(h)&&_.push(h);else for(o=Math.max(this.m_startCol,o),r=Math.min(this.m_endCol,r),l=c;l<=u;l+=1)for(a=o;a<=r;a+=1)null!=(h=this._getCellByIndex(this.createIndex(l,a)))&&-1===_.indexOf(h)&&_.push(h);return _},A.prototype._getRangeInView=function(e){let t=e.startIndex,i=this.getEndIndex(e),s=t.row,n=i.row,o=t.column,r=i.column;return-1===n&&(n=Number.MAX_VALUE),-1===r&&(r=Number.MAX_VALUE),s=Math.max(this.m_startRow,s),n=Math.min(this.m_endRow,n),(isNaN(t.column)||isNaN(i.column))&&(o=Math.max(0,this.m_startCol),r=Math.max(o,this.m_endCol)),o=Math.max(this.m_startCol,o),r=Math.min(this.m_endCol,r),this.createRange(this.createIndex(s,o),this.createIndex(n,r))},A.prototype._applyBorderClassesAroundRange=function(e,t,i,s){if(null==this.m_databody.firstChild||null==e||0===e.length)return;let n=this._getRangeInView(t),o=n.startIndex.row,r=n.startIndex.column,l=n.endIndex.row,a=n.endIndex.column,h=this.isFirstOrFirstNonHiddenIndex(o,"row"),d=this.isFirstOrFirstNonHiddenIndex(r,"column"),m=h?o:this.getVisibleCellIndexInDirection("row",o-1,{up:!0}),c=l,u=d?r:this.getVisibleCellIndexInDirection("column",r-1,{left:!0}),_=a;for(let e=o;e<=l;e++){let t=this._getCellByIndex(this.createIndex(e,u)),n=this._getCellByIndex(this.createIndex(e,_)),o=(d?"start":"end")+s,r="end"+s;i?(this._highlightElement(t,[o]),this._highlightElement(n,[r])):(this._unhighlightElement(t,[o]),this._unhighlightElement(n,[r]))}for(let e=r;e<=a;e++){let t=this._getCellByIndex(this.createIndex(m,e)),n=this._getCellByIndex(this.createIndex(c,e)),o=(h?"top":"bottom")+s,r="bottom"+s;i?(this._highlightElement(t,[o]),this._highlightElement(n,[r])):(this._unhighlightElement(t,[o]),this._unhighlightElement(n,[r]))}},A.prototype.readCurrentContent=function(){var e,t;if(null==this.m_active)return!1;if("header"===this.m_active.type)e={},"row"===this.m_active.axis?(this.m_rowHeaderLevelCount>1&&(e.level=this.m_active.level),e.rowHeader=this.m_active.index):(this.m_columnHeaderLevelCount>1&&(e.level=this.m_active.level),e.columnHeader=this.m_active.index),t=this._getActiveElement();else if("cell"===this.m_active.type){if(e=this.m_active.indexes,this._isSelectionEnabled()&&this.isMultipleSelection()&&null!=this.m_selectionFrontier&&(e=this.m_selectionFrontier),null==e)return!1;var i=this.createRange(e),s=this.getElementsInRange(i);if(null==s||0===s.length)return!1;t=s[0]}else t=this._getActiveElement();this._updateActiveContext(this.m_active,this.m_prevActive),this.m_placeHolder.tabIndex=-1;var n=t.getAttribute("aria-labelledby");return this.m_placeHolder.setAttribute("aria-labelledby",n+" "+t.id),this.m_placeHolder===document.activeElement?t.focus():this.m_placeHolder.focus(),!0},A.prototype._enterActionableMode=function(e,t,i){return this.isActionableMode()||(this._enteringActionableMode=!0,(!i||i&&this._setFocusToFirstFocusableElement(e,t))&&(this.m_focusOutHandler(e),this.setActionableMode(!0))),this._enteringActionableMode=!1,!1},A.prototype._exitActionableMode=function(){if(this.isActionableMode()){var e=this._getActiveElement();this.setActionableMode(!1),_.disableAllFocusableElements(e),this.m_focusInHandler(e)}},A.prototype._reRenderCell=function(e,t,i,s){var n=this.getRendererOrTemplate("cell"),o=e[this.getResources().getMappedAttribute("context")],r=e[this.getResources().getMappedAttribute("metadata")];if(o.mode=t,this.m_utils.empty(e),this.m_utils.containsCSSClassName(e,i)?this.m_utils.removeCSSClassName(e,i):this.m_utils.addCSSClassName(e,i),s){for(;s.hasChildNodes();)e.appendChild(s.firstChild);this._destroyEditableClone()}else this._renderContent(n,o,e,o.data,this.buildCellTemplateContext(o,r))},A.prototype._resetEditableClone=function(){if(this._isGridEditable()&&this.m_active&&"cell"===this.m_active.type){let e=this._getActiveElement();e&&this._setEditableClone(e)}},A.prototype._setEditableClone=function(e){if(this._destroyEditableClone(),null!=e){var t=e.cloneNode(!1);t.removeAttribute("id"),this._createUniqueId(t),t[this.getResources().getMappedAttribute("context")]=e[this.getResources().getMappedAttribute("context")],t[this.getResources().getMappedAttribute("metadata")]=e[this.getResources().getMappedAttribute("metadata")],t[this.getResources().getMappedAttribute("context")].parentElement=t,this.m_root.appendChild(t),this._reRenderCell(t,"edit",this.getMappedStyle("cellEdit"),null),t.style.display="none",t[this.getResources().getMappedAttribute("context")].parentElement=e,this.m_editableClone=t}},A.prototype._destroyEditableClone=function(){this.m_editableClone&&(null!=this.m_editableClone.parentNode?this._remove(this.m_editableClone):this._cleanTemplateNodes(this.m_editableClone),delete this.m_editableClone)},A.prototype.isArrowKey=function(e){return e===this.keyCodes.UP_KEY||e===this.keyCodes.DOWN_KEY||e===this.keyCodes.LEFT_KEY||e===this.keyCodes.RIGHT_KEY},A.prototype.createIndex=function(e,t){var i={};return void 0!==e&&(i.row=e),void 0!==t&&(i.column=t),i},A.prototype.checkCorners=function(e,t,i){return"column"===this.m_selectionFrontier.axis&&this.m_columnHeaderLevelCount!==this.m_selectionFrontier.level||"row"===this.m_selectionFrontier.axis&&this.m_rowHeaderLevelCount!==this.m_selectionFrontier.level||"rowEnd"===this.m_selectionFrontier.axis&&this.m_rowEndHeaderLevelCount!==this.m_selectionFrontier.level||"columnEnd"===this.m_selectionFrontier.axis&&this.m_columnEndHeaderLevelCount!==this.m_selectionFrontier.level||(-1!==e.indexOf("row")?t===i.startIndex.row&&this.m_selectionFrontier.end===i.endIndex.row||t===i.endIndex.row&&this.m_selectionFrontier.end===i.startIndex.row:-1!==e.indexOf("column")&&(t===i.startIndex.column&&this.m_selectionFrontier.end===i.endIndex.column||t===i.endIndex.column&&this.m_selectionFrontier.end===i.startIndex.column))},A.prototype.handleLabelFocusChange=function(e,t,i,s){var n,o,r,l;if(!this.isFetchComplete())return!0;this.getResources().isRTLMode()&&(e===this.keyCodes.LEFT_KEY?e=this.keyCodes.RIGHT_KEY:e===this.keyCodes.RIGHT_KEY&&(e=this.keyCodes.LEFT_KEY));var a=this.m_active.axis,h=this.m_active.level;switch("column"===a?(r=this.m_startColHeader,l=this.m_columnHeaderLevelCount):"row"===a&&(r=this.m_startRowHeader,l=this.m_rowHeaderLevelCount),"columnEnd"===a&&(e===this.keyCodes.DOWN_KEY?e=this.keyCodes.UP_KEY:e===this.keyCodes.UP_KEY&&(e=this.keyCodes.DOWN_KEY),r=this.m_startColEndHeader,l=this.m_columnEndHeaderLevelCount),"rowEnd"===a&&(e===this.keyCodes.LEFT_KEY?e=this.keyCodes.RIGHT_KEY:e===this.keyCodes.RIGHT_KEY&&(e=this.keyCodes.LEFT_KEY),r=this.m_startRowEndHeader,l=this.m_rowEndHeaderLevelCount),e){case this.keyCodes.DOWN_KEY:"row"!==a&&"rowEnd"!==a||(n=this._getHeaderByIndex(r,a,h),this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(n,{type:"header",index:r,level:h,axis:a},t)),"column"!==a&&"columnEnd"!==a||((n=this.m_headerLabels[a][h+1])?this._setActive(n,{type:"label",level:h+1,axis:a},t):"column"===a&&h===l-1&&this.m_headerLabels.row.length?(n=this.m_headerLabels.row[this.m_headerLabels.row.length-1],this._setActive(n,{type:"label",level:this.m_headerLabels.row.length-1,axis:"row"},t)):h===l-1&&(o="column"===a?this.m_startRowHeader:this.m_endRowHeader,n=this._getHeaderByIndex(o,"row",this.m_rowHeaderLevelCount-1),this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),n&&this._setActive(n,{type:"header",index:o,level:h,axis:"row"},t)));break;case this.keyCodes.UP_KEY:"row"===a&&h===l-1&&this.m_headerLabels.column.length&&(n=this.m_headerLabels.column[this.m_headerLabels.column.length-1],this._setActive(n,{type:"label",level:this.m_headerLabels.column.length-1,axis:"column"},t)),"column"!==a&&"columnEnd"!==a||(n=this.m_headerLabels[a][h-1])&&this._setActive(n,{type:"label",level:h-1,axis:a},t);break;case this.keyCodes.RIGHT_KEY:if("row"===a||"rowEnd"===a)if(n=this.m_headerLabels[a][h+1])this._setActive(n,{type:"label",level:h+1,axis:a},t);else if(h===l-1){for(o="row"===a?this.m_startColHeader:this.m_endColHeader;this.isHidden("column",o);)o="row"===a?o+1:o-1;(n=this._getHeaderByIndex(o,"column",this.m_columnHeaderLevelCount))&&(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(n,{type:"header",index:o,level:h,axis:"column"},t))}if("column"===a||"columnEnd"===a){for(o=r,n=this._getHeaderByIndex(o,a,h);null!=n&&this.isHeaderHidden(n);)o=h!==l-1?this._getAttribute(n.parentNode,"start",!0)+this._getAttribute(n.parentNode,"extent",!0):o+1,n=this._getHeaderByIndex(o,a,h);this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(n,{type:"header",index:r,level:h,axis:a},t)}break;case this.keyCodes.LEFT_KEY:"row"!==a&&"rowEnd"!==a||(n=this.m_headerLabels[a][h-1])&&this._setActive(n,{type:"label",level:h-1,axis:a},t)}return!0},A.prototype.handleHeaderFocusChange=function(e,t,i,s,n){var o,r,l,a,h,d,m;let c,u=this._getEmptyElement();this.getResources().isRTLMode()&&(e===this.keyCodes.LEFT_KEY?e=this.keyCodes.RIGHT_KEY:e===this.keyCodes.RIGHT_KEY&&(e=this.keyCodes.LEFT_KEY));var _=this.m_active.axis,p=this.m_active.index,g=this.m_active.level,f=this._getActiveElement(),C=null!=f?this._getAttribute(f,"depth",!0):1;if(_||p||!this.m_active||(_=this.m_selectionFrontier.axis,p=this.m_active.indexes[_]),t.shiftKey&&!i&&this.m_selectionFrontier&&this.isMultipleSelection()&&(i=this.checkHeaderToDatabody(_,e)),!(i&&this.isArrowKey(e)&&this.isHeaderSelectionType(this.m_selectionFrontier)&&this.checkCorners(_,p,this.m_selection[this.m_selection.length-1]))||(_=this.m_selectionFrontier.axis,p=this.m_selectionFrontier.index,g=this.m_selectionFrontier.level,-1===p&&(p=this.m_active.indexes[_]),"cell"!==this.m_active.type||(e!==this.keyCodes.LEFT_KEY&&e!==this.keyCodes.RIGHT_KEY||-1===_.indexOf("row"))&&(e!==this.keyCodes.UP_KEY&&e!==this.keyCodes.DOWN_KEY||-1===_.indexOf("column")))){if("column"===_?(h=this.m_endColHeader,d=this.m_columnHeaderLevelCount,m=this.m_stopColumnHeaderFetch,c=this.m_startColHeader):"row"===_&&(h=this.m_endRowHeader,d=this.m_rowHeaderLevelCount,m=this.m_stopRowHeaderFetch,c=this.m_startRowHeader),"columnEnd"===_&&(e===this.keyCodes.DOWN_KEY?e=this.keyCodes.UP_KEY:e===this.keyCodes.UP_KEY&&(e=this.keyCodes.DOWN_KEY),h=this.m_endColEndHeader,d=this.m_columnEndHeaderLevelCount,m=this.m_stopColumnEndHeaderFetch,c=this.m_startColEndHeader),"rowEnd"===_&&(e===this.keyCodes.LEFT_KEY?e=this.keyCodes.RIGHT_KEY:e===this.keyCodes.RIGHT_KEY&&(e=this.keyCodes.LEFT_KEY),h=this.m_endRowEndHeader,d=this.m_rowEndHeaderLevelCount,m=this.m_stopRowEndHeaderFetch,c=this.m_startRowEndHeader),!this.isFetchComplete())return this.m_skeletonSet.size>0&&!i&&(l=1===d||g===d-1?p+1:null!=f?this._getAttribute(f.parentNode,"start",!0)+this._getAttribute(f.parentNode,"extent",!0):p+1,(e===this.keyCodes.RIGHT_KEY&&l===this.m_endCol+1||e===this.keyCodes.DOWN_KEY&&l===this.m_endRow+1)&&this._scrollSkeletonHeadersIntoViewport(l-1,_,g,!0)),!0;i&&this.isArrowKey(e)&&this.isHeaderSelectionType(this.m_selectionFrontier)&&(C=null!=(f=this._getHeaderByIndex(p,_,g))?this._getAttribute(f,"depth",!0):1);var y=this._isSelectionEnabled()?this.selectAndFocus.bind(this):this._setActiveByIndex.bind(this);switch(e){case this.keyCodes.LEFT_KEY:if("column"===_||"columnEnd"===_)if(p>0&&!this.isFirstOrFirstNonHiddenIndex(p,_)){if(s&&this.m_headerLabels[_][g]){this._setActive(this.m_headerLabels[_][g],{type:"label",level:g,axis:_},t);break}if("column"===_&&s&&this.m_headerLabels.row[this.m_rowHeaderLevelCount-1]){this._setActive(this.m_headerLabels.row[this.m_rowHeaderLevelCount-1],{type:"label",level:this.m_rowHeaderLevelCount-1,axis:"row"},t);break}l=null!=(r=this._getHeaderByIndex(p-1,_,g))&&g!==d-1?this._getAttribute(r.parentNode,"start",!0)-this._getAttribute(r.parentNode,"extent",!0):p-1;let e=1;for(;null!=r&&this.isHeaderHidden(r);)l=p-1-e,r=this._getHeaderByIndex(l,_,g),e+=1;if(l=null!=r&&g!==d-1?this._getAttribute(r.parentNode,"start",!0):this.findNextNonHiddenIndex(l,_),a=null!=r?this.getHeaderCellLevel(r):g,l<0)break;i?this.extendSelectionHeader(r,t,!0):l<c?this._scrollSkeletonHeadersIntoViewport(p,_,g,!1):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&"row"!==this.m_options.getSelectionMode()&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(r,{type:"header",index:l,level:a,axis:_},t),this._highlightActive())}else this.m_headerLabels[_][g]?this._setActive(this.m_headerLabels[_][g],{type:"label",level:g,axis:_},t):"column"===_&&this.m_headerLabels.row[this.m_rowHeaderLevelCount-1]&&this._setActive(this.m_headerLabels.row[this.m_rowHeaderLevelCount-1],{type:"label",level:this.m_rowHeaderLevelCount-1,axis:"row"},t);else("row"===_||"rowEnd"===_)&&g>0&&(r=this._getHeaderByIndex(p,_,g-1),l=this._getAttribute(r.parentNode,"start",!0),a=this.getHeaderCellLevel(r),i?this.extendSelectionHeader(r,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(r,{type:"header",index:l,level:a,axis:_},t),this._highlightActive()));break;case this.keyCodes.RIGHT_KEY:if("rowEnd"===_&&s&&-1!==this.m_endRowHeader)r=this._getHeaderByIndex(p,_,this.m_rowHeaderLevelCount),i?this.extendSelectionHeader(r,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(r,{type:"header",index:p,level:this.m_rowHeaderLevelCount,axis:_},t),this._highlightActive());else if("row"===_&&s&&-1!==this.m_endRowEndHeader)r=this._getHeaderByIndex(p,_,this.m_rowEndHeaderLevelCount),i?this.extendSelectionHeader(r,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(r,{type:"header",index:p,level:this.m_rowEndHeaderLevelCount,axis:_},t),this._highlightActive());else if("row"===_||"rowEnd"===_)if(g+C>=d&&!i)if(this.m_trueIndex={row:p},n){if("row"===_){let e=this._getEmptyCellNeighborIndex({row:p,column:-1},{right:!0},this._getMaxRight(),this.m_endRowEndHeader);if(e)if(e.cell)y(e.cell,t);else if(e.header){let e=this._getHeaderByIndex(this.m_trueIndex.row,"rowEnd",this.m_rowEndHeaderLevelCount-1);this._setActive(e,{type:"header",index:p,level:this.m_rowEndHeaderLevelCount-1,axis:"rowEnd"},t,!0)}}else if("rowEnd"===_){let e=this._getEmptyCellNeighborIndex({row:p,column:this.m_endCol+1},{left:!0},this._getMaxLeft(),this.m_startRowHeader);if(e.cell)y(e.cell,t);else if(e.header){let e=this._getHeaderByIndex(this.m_trueIndex.row,"row",this.m_rowHeaderLevelCount-1);this._setActive(e,{type:"header",index:p,level:this.m_rowHeaderLevelCount-1,axis:"row"},t,!0)}}}else if(u)this._setActive(u,{type:"empty"},t,!0);else{let e,i;if("row"===_){for(let e=0;e<=this.getDataSource().getCount("column")-1;e++)if(!this.isHidden("column",e)){i=e;break}o=this.createIndex(p,i)}else this._isHighWatermarkScrolling()?(e=this.getVisibleCellIndexInDirection("column",this.m_endCol,{left:!0}),o=this.createIndex(p,e)):(e=this.getVisibleCellIndexInDirection("column",this.getDataSource().getCount("column")-1,{left:!0}),o=this.createIndex(p,e));if(this._isSelectionEnabled())this.selectAndFocus(o,t);else{let e=this._getCellByIndex(o).classList.contains(this.getMappedStyle("frozenCell"));this._setActiveByIndex(o,t,null,null,e),this._highlightActive()}}else{let e=this.getVisibleCellIndexInDirection(_,p,{right:!0});r=this._getHeaderByIndex(e,_,g+C),l=this._getAttribute(r.parentNode,"start",!0),a=this.getHeaderCellLevel(r),i?this.extendSelectionHeader(r,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(r,{type:"header",index:l,level:a,axis:_},t),this._highlightActive())}else if("column"===_&&s&&this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount-1])this._setActive(this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount-1],{type:"label",level:this.m_rowEndHeaderLevelCount-1,axis:"rowEnd"},t);else{for(l=null!=f&&g!==d-1?this._getAttribute(f.parentNode,"start",!0)+this._getAttribute(f.parentNode,"extent",!0):p+1,r=this._getHeaderByIndex(l,_,g);null!=r&&this.isHeaderHidden(r);)l=g!==d-1?this._getAttribute(r.parentNode,"start",!0)+this._getAttribute(r.parentNode,"extent",!0):l+1,r=this._getHeaderByIndex(l,_,g);a=null!=r?this.getHeaderCellLevel(r):g,l>h&&m||!(this._isCountUnknown("column")||l<this.getDataSource().getCount("column"))?"column"===_&&this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount-1]&&this._setActive(this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount-1],{type:"label",level:this.m_rowEndHeaderLevelCount-1,axis:"rowEnd"},t):i?this.extendSelectionHeader(r,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&"row"!==this.m_options.getSelectionMode()&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(r,{type:"header",index:l,level:a,axis:_},t),this._highlightActive())}break;case this.keyCodes.UP_KEY:if("row"===_||"rowEnd"===_){if(s&&this.m_headerLabels[_][g]){this._setActive(this.m_headerLabels[_][g],{type:"label",level:g,axis:_},t);break}if("row"===_&&s&&this.m_headerLabels.column[this.m_columnHeaderLevelCount-1]){this._setActive(this.m_headerLabels.column[this.m_columnHeaderLevelCount-1],{type:"label",level:this.m_columnHeaderLevelCount-1,axis:"column"},t);break}if(p>0&&!this.isFirstOrFirstNonHiddenIndex(p,_)){l=null!=(r=this._getHeaderByIndex(p-1,_,g))&&g!==d-1?this._getAttribute(r.parentNode,"start",!0)-this._getAttribute(r.parentNode,"extent",!0):p-1;let e=1;for(;null!=r&&this.isHeaderHidden(r);)l=p-1-e,r=this._getHeaderByIndex(l,_,g),e+=1;if(l=null!=r&&g!==d-1?this._getAttribute(r.parentNode,"start",!0):this.findNextNonHiddenIndex(l,_),a=null!=r?this.getHeaderCellLevel(r):g,l<0)break;i?this.extendSelectionHeader(r,t,!0):l<c?this._scrollSkeletonHeadersIntoViewport(p,_,g,!1):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this.m_selectionFrontier={},this._clearSelection(t)),this._setActive(r,{type:"header",index:l,level:a,axis:_},t),this._highlightActive())}else this.m_headerLabels[_][g]?this._setActive(this.m_headerLabels[_][g],{type:"label",level:g,axis:_},t):"row"===_&&this.m_headerLabels.column[this.m_columnHeaderLevelCount-1]&&this._setActive(this.m_headerLabels.column[this.m_columnHeaderLevelCount-1],{type:"label",level:this.m_columnHeaderLevelCount-1,axis:"column"},t)}else("column"===_||"columnEnd"===_)&&g>0&&(r=this._getHeaderByIndex(p,_,g-1),l=this._getAttribute(r.parentNode,"start",!0),a=this.getHeaderCellLevel(r),i?this.extendSelectionHeader(r,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this.m_selectionFrontier={},this._clearSelection(t)),this._setActive(r,{type:"header",index:l,level:a,axis:_},t),this._highlightActive()));break;case this.keyCodes.DOWN_KEY:if("columnEnd"===_&&s&&-1!==this.m_endColHeader)r=this._getHeaderByIndex(p,_,this.m_columnHeaderLevelCount),i?this.extendSelectionHeader(r,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this.m_selectionFrontier={},this._clearSelection(t)),this._setActive(r,{type:"header",index:p,level:this.m_columnHeaderLevelCount,axis:_},t),this._highlightActive());else if("column"===_&&s&&-1!==this.m_endColEndHeader)r=this._getHeaderByIndex(p,_,this.m_columnEndHeaderLevelCount),i?this.extendSelectionHeader(r,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(r,{type:"header",index:p,level:this.m_columnEndHeaderLevelCount,axis:_},t),this._highlightActive());else if("column"===_||"columnEnd"===_)if(g+C>=d&&!i)if(this.m_trueIndex={column:p},n){if("column"===_){let e=this._getEmptyCellNeighborIndex({row:0,column:this.m_trueIndex.column},{down:!0},this._getMaxBottom(),this.m_endColEndHeader);if(e)if(e.cell)y(e.cell,t);else if(e.header){let e=this._getHeaderByIndex(this.m_trueIndex.column,"columnEnd",this.m_columnEndHeaderLevelCount-1);this._setActive(e,{type:"header",index:p,level:this.m_columnEndHeaderLevelCount-1,axis:"columnEnd"},t,!0)}}else if("columnEnd"===_){let e=this._getEmptyCellNeighborIndex({row:this.m_endRow+1,column:this.m_trueIndex.column},{up:!0},this._getMaxTop(),this.m_startColHeader);if(e)if(e.cell)y(e.cell,t);else if(e.header){let e=this._getHeaderByIndex(this.m_trueIndex.column,"column",this.m_columnHeaderLevelCount-1);this._setActive(e,{type:"header",index:p,level:this.m_columnHeaderLevelCount-1,axis:"column"},t,!0)}}}else if(u)this._setActive(u,{type:"empty"},t,!0);else{if("column"===_){let e=this.getVisibleCellIndexInDirection("row",0,{down:!0});o=this.createIndex(e,p)}else if(this._isHighWatermarkScrolling())o=this.createIndex(this.m_endRow,p);else{let e=this.getVisibleCellIndexInDirection("row",this.getDataSource().getCount("row")-1,{up:!0});o=this.createIndex(e,p)}this._isSelectionEnabled()?this.selectAndFocus(o,t):(this._setActiveByIndex(o,t),this._highlightActive())}else p=this.getVisibleCellIndexInDirection("column",p,{down:!0}),r=this._getHeaderByIndex(p,_,g+C),l=this._getAttribute(r.parentNode,"start",!0),a=this.getHeaderCellLevel(r),i?this.extendSelectionHeader(r,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(r,{type:"header",index:l,level:a,axis:_},t),this._highlightActive());else if("row"===_&&s&&this.m_headerLabels.columnEnd[this.m_columnEndHeaderLevelCount-1])this._setActive(this.m_headerLabels.columnEnd[this.m_columnEndHeaderLevelCount-1],{type:"label",level:this.m_columnEndHeaderLevelCount-1,axis:"columnEnd"},t);else{for(l=null!=f&&g!==d-1?this._getAttribute(f.parentNode,"start",!0)+this._getAttribute(f.parentNode,"extent",!0):p+1,r=this._getHeaderByIndex(l,_,g);null!=r&&this.isHeaderHidden(r);)l=g!==d-1?this._getAttribute(r.parentNode,"start",!0)+this._getAttribute(r.parentNode,"extent",!0):l+1,r=this._getHeaderByIndex(l,_,g);a=null!=r?this.getHeaderCellLevel(r):g,l>h&&m||!(this._isCountUnknown("row")||l<this.getDataSource().getCount("row"))?"row"===_&&this.m_headerLabels.columnEnd[this.m_columnEndHeaderLevelCount-1]&&this._setActive(this.m_headerLabels.columnEnd[this.m_rowEndHeaderLevelCount-1],{type:"label",level:this.m_columnEndHeaderLevelCount-1,axis:"columnEnd"},t):i?this.extendSelectionHeader(r,t,!0):(this._isSelectionEnabled()&&!this.m_discontiguousSelection&&(this._clearSelection(t),this.m_selectionFrontier={}),this._setActive(r,{type:"header",index:l,level:a,axis:_},t),this._highlightActive())}break;case this.keyCodes.PAGEUP_KEY:"row"!==_&&"rowEnd"!==_||(f=this._getHeaderByIndex(0,_,g),this._setActive(f,{type:"header",index:0,level:g,axis:_},t));break;case this.keyCodes.PAGEDOWN_KEY:"row"!==_&&"rowEnd"!==_||(p=this._isCountUnknown("row")||this._isHighWatermarkScrolling()?Math.max(0,h):Math.max(0,this.getDataSource().getCount("row")-1),f=this._getHeaderByIndex(p,_,g),this._setActive(f,{type:"header",index:p,level:g,axis:_},t));break;case this.keyCodes.HOME_KEY:if("column"===_||"columnEnd"===_){let e;for(let t=0;t<=p;t++)if(!this.isHidden(_,t)){e=t;break}f=this._getHeaderByIndex(e,_,g),this._setActive(f,{type:"header",index:e,level:g,axis:_},t)}break;case this.keyCodes.END_KEY:if("column"===_||"columnEnd"===_){let e;e=this._isCountUnknown("column")||this._isHighWatermarkScrolling()?Math.max(0,h):Math.max(0,this.getDataSource().getCount("column")-1);for(let t=e;t>=p;t--)if(!this.isHidden(_,t)){e=t;break}f=this._getHeaderByIndex(e,_,g),this._setActive(f,{type:"header",index:e,level:g,axis:_},t)}}return!0}},A.prototype.checkHeaderToDatabody=function(e,t){return!("row"===e&&this.m_rowHeaderLevelCount===this.m_selectionFrontier.level&&t===this.keyCodes.RIGHT_KEY||"rowEnd"===e&&this.m_rowEndHeaderLevelCount===this.m_selectionFrontier.level&&t===this.keyCodes.LEFT_KEY||"column"===e&&this.m_columnHeaderLevelCount===this.m_selectionFrontier.level&&t===this.keyCodes.DOWN_KEY||"columnEnd"===e&&this.m_columnEndHeaderLevelCount===this.m_selectionFrontier.level&&t===this.keyCodes.UP_KEY)},A.prototype._getHeaderLabelledBy=function(e,t,i,s,n,o){var r;if(-1!==i&&(s!==n||this.m_externalFocus)){var l=this.getHeaderFromCell(o,e);return null!=n&&(r=this._getHeaderByIndex(n,e,t-1)),this._getHeaderAndParentIds(l,r)}return""},A.prototype._getHeaderAndParentIds=function(e,t){var i="",s=[];if(null==e)return"";var n=this._getHeaderAndParents(e);null!=t&&(s=this._getHeaderAndParents(t));for(var o=0;o<n.length;o++)s[o]===n[o]&&o!==n.length-1||(i+=(""===i?"":" ")+n[o].id);return i},A.prototype._getHeaderAndParents=function(e){var t,i=[e],s=this.getHeaderCellAxis(e),n=this.getHeaderCellLevel(e),o=this._getLabel(s,n);if("row"===s?t=this.m_rowHeaderLevelCount:"column"===s?t=this.m_columnHeaderLevelCount:"rowEnd"===s?t=this.m_rowEndHeaderLevelCount:"columnEnd"===s&&(t=this.m_columnEndHeaderLevelCount),o&&i.unshift(o),1===t)return i;for(n===t-1&&(e=e.parentNode.firstChild,i.unshift(e),n-=1,(o=this._getLabel(s,n))&&i.unshift(o));n>0;)e=e.parentNode.parentNode.firstChild,i.unshift(e),n-=1,(o=this._getLabel(s,n))&&i.unshift(o);return i},A.prototype.isHeaderSelectionType=function(e){return!(!e||!e.axis)},A.prototype._isChildEmpty=function(e){if(e){let t=e.textContent.trim();return!(e.children.length>0||t.length>0)}return!1},A.prototype._isNeighborCellEmpty=function(e,t){let i=this._getIndex(e,"row"),s=this._getIndex(e,"column");if("row"===t){let t=this.getVisibleCellIndexInDirection("column",s-1,{left:!0}),n=this.getVisibleCellIndexInDirection("column",s+1,{right:!0}),o=this._getCellByIndex({row:i,column:t}),r=this._getCellByIndex({row:i,column:n});if((this._isChildEmpty(o)||this._isChildEmpty(r))&&!this._isChildEmpty(e)&&!this.isHidden("column",s))return!0}else if("column"===t){let t=this._getCellByIndex({row:i-1,column:s}),n=this._getCellByIndex({row:i+1,column:s});if((this._isChildEmpty(t)||this._isChildEmpty(n))&&!this._isChildEmpty(e))return!0}return!1},A.prototype._getEmptyCellNeighborIndex=function(e,t,i,s){let n,o,r,l,a,h,d,m=e.row,c=e.column,u=Object.create({}),_=t.left||t.right,p=t.up||t.down,g=t.right||t.down,f=t.left||t.up;_?(n="row",o=c,r=m):p&&(n="column",o=m,l=c),g?(a=1,d=i):f&&(a=-1,d=i-1);let C,y=o;for(;f?y>=i:y<=i;){if(g?C=y<i:f&&(C=y>i),_?l=y===i?d:y+a:p&&(r=y===i?d:y+a),h=this._getCellByIndex({row:r,column:l}),C&&this._isNeighborCellEmpty(h,n))return u.cell=this.createIndex(r,l),u;if(y===i){let e;return g?e=(t.right?this._isLastColumn(y):this._isLastRow(y))&&-1!==s:f&&(e=0===y),e?(u.header=!0,u):(u.cell=this.createIndex(r,l),u)}y+=a}return null},A.prototype.handleNoDataFocusChange=function(e,t,i,s){let n;if(null==this.m_active)return null;switch(this.getResources().isRTLMode()&&(e===this.keyCodes.LEFT_KEY?e=this.keyCodes.RIGHT_KEY:e===this.keyCodes.RIGHT_KEY&&(e=this.keyCodes.LEFT_KEY)),e){case this.keyCodes.UP_KEY:!t&&s&&-1!==this.m_endColHeader&&(n=this._getHeaderByIndex(this.m_startColHeader,"column",this.m_columnHeaderLevelCount-1),this._setActive(n,{type:"header",index:this.m_startColHeader,level:this.m_columnHeaderLevelCount-1,axis:"column"},i,!0));break;case this.keyCodes.DOWN_KEY:-1!==this.m_endColEndHeader&&s&&(n=this._getHeaderByIndex(this.m_startColEndHeader,"columnEnd",this.m_columnEndHeaderLevelCount-1),this._setActive(n,{type:"header",index:this.m_startColEndHeader,level:this.m_columnEndHeaderLevelCount-1,axis:"columnEnd"},i,!0));break;case this.keyCodes.LEFT_KEY:!t&&s&&-1!==this.m_endRowHeader&&(n=this._getHeaderByIndex(this.m_startRowHeader,"row",this.m_rowHeaderLevelCount-1),this._setActive(n,{type:"header",index:this.m_startRowHeader,level:this.m_rowHeaderLevelCount-1,axis:"row"},i,!0));break;case this.keyCodes.RIGHT_KEY:-1!==this.m_endRowEndHeader&&s&&(n=this._getHeaderByIndex(this.m_startRowEndHeader,"rowEnd",this.m_rowEndHeaderLevelCount-1),this._setActive(n,{type:"header",index:this.m_startRowEndHeader,level:this.m_rowEndHeaderLevelCount-1,axis:"rowEnd"},i,!0))}return!0},A.prototype.handleFocusChange=function(e,t,i,s,n,o=!1,r=!1){var l,a,h,d=1,m=1;if(this.getResources().isRTLMode()&&(e===this.keyCodes.LEFT_KEY?e=this.keyCodes.RIGHT_KEY:e===this.keyCodes.RIGHT_KEY&&(e=this.keyCodes.LEFT_KEY)),!this.isFetchComplete()&&!1===this.m_fetchingForUpdate){if(this.m_skeletonSet.size>0&&!t){const t=(l=this.m_active.indexes).column,i=l.row;e===this.keyCodes.RIGHT_KEY&&t+1===this.m_endCol+1?this._scrollSkeletonCellsIntoViewport(i,t,"column",!0):e===this.keyCodes.DOWN_KEY&&i+1===this.m_endRow+1&&this._scrollSkeletonCellsIntoViewport(i,t,"row",!0)}return!0}if(t){if(l=this.m_selectionFrontier,this.isHeaderSelectionType(this.m_selectionFrontier))return void this.handleHeaderFocusChange(e,i,t,n)}else l=this.m_active.indexes;if(null!=l){var c,u,_,p,g;switch(null==this.m_trueIndex&&(this.m_trueIndex={}),c=this._isSelectionEnabled()?this.selectAndFocus.bind(this):this._setActiveByIndex.bind(this),u=l.row,_=l.column,(p=this._getCellByIndex(l))&&(d=(g=p[this.getResources().getMappedAttribute("context")]).extents.row,m=g.extents.column),e){case this.keyCodes.LEFT_KEY:if(this.m_trueIndex.row||t||(this.m_trueIndex={row:u}),o){let e=g.indexes.row,t=g.indexes.column,s=this._getEmptyCellNeighborIndex({row:e,column:t},{left:!0},this._getMaxLeft(),this.m_startRowHeader);s&&(s.cell?c(s.cell,i):s.header&&(h=this._getHeaderByIndex(this.m_trueIndex.row,"row",this.m_rowHeaderLevelCount-1),this._setActive(h,{type:"header",index:this.m_trueIndex.row,level:this.m_rowHeaderLevelCount-1,axis:"row"},i,!0)))}else if(_>0&&(!n||-1===this.m_endRowHeader))if("row"===this.m_options.getSelectionMode())a=this.createIndex(this.m_trueIndex.row,_-1),this._setActiveByIndex(a,i);else{if(t)a=this.createIndex(u,_-1),this.extendSelection(a,i,e);else if(_-1<this.m_startCol)this._scrollSkeletonCellsIntoViewport(u,_,"column",!1);else{let e=_-1,t=!1;for(;this.isHidden("column",e);){if(0===e){e=this.getVisibleCellIndexInDirection("column",e,{right:!0}),t=!0;break}e-=1}t&&s?(h=this._getHeaderByIndex(this.m_trueIndex.row,"row",this.m_rowHeaderLevelCount-1),this._setActive(h,{type:"header",index:this.m_trueIndex.row,level:this.m_rowHeaderLevelCount-1,axis:"row"},i,!0)):c(a=this.createIndex(this.m_trueIndex.row,e),i)}_-1==0&&this._setAccInfoText("accessibleFirstColumn")}else!t&&s&&(h=this._getHeaderByIndex(this.m_trueIndex.row,"row",this.m_rowHeaderLevelCount-1),this.m_discontiguousSelection?this.discontiguousHeaderSetActiveFromDatabody(i,"row",h,this.m_rowHeaderLevelCount):this._setActive(h,{type:"header",index:this.m_trueIndex.row,level:this.m_rowHeaderLevelCount-1,axis:"row"},i,!0));break;case this.keyCodes.RIGHT_KEY:if(this.m_trueIndex.row||t||(this.m_trueIndex={row:u}),o){let e=g.indexes.row,t=g.indexes.column,s=this._getEmptyCellNeighborIndex({row:e,column:t},{right:!0},this._getMaxRight(),this.m_endRowEndHeader);s&&(s.cell?c(s.cell,i):s.header&&(h=this._getHeaderByIndex(this.m_trueIndex.row,"rowEnd",this.m_rowEndHeaderLevelCount-1),this._setActive(h,{type:"header",index:this.m_trueIndex.row,level:this.m_rowEndHeaderLevelCount-1,axis:"rowEnd"},i,!0)))}else if(this._isLastColumn(_+(m-1))||n&&-1!==this.m_endRowEndHeader)-1!==this.m_endRowEndHeader&&s?(h=this._getHeaderByIndex(this.m_trueIndex.row,"rowEnd",this.m_rowEndHeaderLevelCount-1),this.m_discontiguousSelection?this.discontiguousHeaderSetActiveFromDatabody(i,"rowEnd",h,this.m_rowEndHeaderLevelCount):this._setActive(h,{type:"header",index:this.m_trueIndex.row,level:this.m_rowEndHeaderLevelCount-1,axis:"rowEnd"},i,!0)):t||c(l,i);else if("row"===this.m_options.getSelectionMode())a=this.createIndex(this.m_trueIndex.row,_+m),this._setActiveByIndex(a,i);else{if(t)a=this.createIndex(u,_+1),this.extendSelection(a,i,e);else{let e=_+m,t=!1;for(;this.isHidden("column",e);){if(this._isLastColumn(e)){e=this.getVisibleCellIndexInDirection("column",e,{left:!0}),t=!0;break}e+=1}t&&-1!==this.m_endRowEndHeader?(h=this._getHeaderByIndex(this.m_trueIndex.row,"rowEnd",this.m_rowEndHeaderLevelCount-1),this._setActive(h,{type:"header",index:this.m_trueIndex.row,level:this.m_rowEndHeaderLevelCount-1,axis:"rowEnd"},i,!0)):c(a=this.createIndex(this.m_trueIndex.row,e),i)}this._isLastColumn(_+m)&&this._setAccInfoText("accessibleLastColumn")}break;case this.keyCodes.UP_KEY:if(this.m_trueIndex.column||t||(this.m_trueIndex={column:_}),o){let e=g.indexes.row,t=g.indexes.column,s=this._getEmptyCellNeighborIndex({row:e,column:t},{up:!0},this._getMaxTop(),this.m_startColHeader);s&&(s.cell?c(s.cell,i):s.header&&(h=this._getHeaderByIndex(this.m_trueIndex.column,"column",this.m_columnHeaderLevelCount-1),this._setActive(h,{type:"header",index:this.m_trueIndex.column,level:this.m_columnHeaderLevelCount-1,axis:"column"},i,!0)))}else if(u>0&&(!n||-1===this.m_endColHeader)){if(t)a=this.createIndex(u-1,_),this.extendSelection(a,i,e);else if(u-1<this.m_startRow)this._scrollSkeletonCellsIntoViewport(u,_,"row",!1);else{let e=this.getVisibleCellIndexInDirection("row",u-1,{up:!0});-1===e&&s?(h=this._getHeaderByIndex(this.m_trueIndex.column,"column",this.m_columnHeaderLevelCount-1),this._setActive(h,{type:"header",index:this.m_trueIndex.column,level:this.m_columnHeaderLevelCount-1,axis:"column"},i,!0)):c(a=this.createIndex(e,this.m_trueIndex.column),i)}u-1==0&&this._setAccInfoText("accessibleFirstRow")}else!t&&s&&(h=this._getHeaderByIndex(this.m_trueIndex.column,"column",this.m_columnHeaderLevelCount-1),this.m_discontiguousSelection?this.discontiguousHeaderSetActiveFromDatabody(i,"column",h,this.m_columnHeaderLevelCount):this._setActive(h,{type:"header",index:this.m_trueIndex.column,level:this.m_columnHeaderLevelCount-1,axis:"column"},i,!0));break;case this.keyCodes.DOWN_KEY:if(this.m_trueIndex.column||t||(this.m_trueIndex={column:_}),o){let e=g.indexes.row,t=g.indexes.column,s=this._getEmptyCellNeighborIndex({row:e,column:t},{down:!0},this._getMaxBottom(),this.m_endColEndHeader);s&&(s.cell?c(s.cell,i):s.header&&(h=this._getHeaderByIndex(this.m_trueIndex.column,"columnEnd",this.m_columnEndHeaderLevelCount-1),this._setActive(h,{type:"header",index:this.m_trueIndex.column,level:this.m_columnEndHeaderLevelCount-1,axis:"columnEnd"},i,!0)))}else if(this._isLastRow(u+(d-1))||n&&-1!==this.m_endColEndHeader)-1!==this.m_endColEndHeader&&s?(h=this._getHeaderByIndex(this.m_trueIndex.column,"columnEnd",this.m_columnEndHeaderLevelCount-1),this.m_discontiguousSelection?this.discontiguousHeaderSetActiveFromDatabody(i,"columnEnd",h,this.m_columnEndHeaderLevelCount):this._setActive(h,{type:"header",index:this.m_trueIndex.column,level:this.m_columnEndHeaderLevelCount-1,axis:"columnEnd"},i,!0)):t||c(l,i);else{if(t)a=this.createIndex(u+1,_),this.extendSelection(a,i,e);else{let e=this.getVisibleCellIndexInDirection("row",u+d,{down:!0});e>this._getLastAxis("row")&&s?(h=this._getHeaderByIndex(this.m_trueIndex.column,"columnEnd",this.m_columnEndHeaderLevelCount-1),this._setActive(h,{type:"header",index:this.m_trueIndex.column,level:this.m_columnEndHeaderLevelCount-1,axis:"columnEnd"},i,!0)):c(a=this.createIndex(e,this.m_trueIndex.column),i)}this._isLastRow(u+d)&&this._setAccInfoText("accessibleLastRow")}break;case this.keyCodes.HOME_KEY:{let e=0,t=0;for(let e=0;e<=_;e++)if(!this.isHidden("column",e)){t=e;break}if(r)c(this.createIndex(e,t),i);else this.m_trueIndex.row||(this.m_trueIndex={row:u}),c(a=this.createIndex(this.m_trueIndex.row,t),i);break}case this.keyCodes.END_KEY:{let e;this.m_trueIndex.row||(this.m_trueIndex={row:u,column:_}),e=this._isCountUnknown("column")||this._isHighWatermarkScrolling()?Math.max(0,this.m_endCol):Math.max(0,this.getDataSource().getCount("column")-1);for(let t=e;t>=_;t--)if(!this.isHidden("column",t)){e=t;break}if(r){let t;t=this._isCountUnknown("column")||this._isHighWatermarkScrolling()?this.createIndex(Math.max(0,this.m_endRow),e):this.createIndex(Math.max(0,this.getDataSource().getCount("row")-1),e),c(t,i)}else c(a=this._isCountUnknown("column")||this._isHighWatermarkScrolling()?this.createIndex(this.m_trueIndex.row,Math.max(0,e)):this.createIndex(this.m_trueIndex.row,e),i);break}case this.keyCodes.PAGEUP_KEY:this.m_trueIndex.column||(this.m_trueIndex={column:_}),c(a=this.createIndex(0,_),i);break;case this.keyCodes.PAGEDOWN_KEY:this.m_trueIndex.column||(this.m_trueIndex={column:_}),c(a=this._isCountUnknown("column")||this._isHighWatermarkScrolling()?this.createIndex(Math.max(0,this.m_endRow),this.m_trueIndex.column):this.createIndex(Math.max(0,this.getDataSource().getCount("row")-1),this.m_trueIndex.column),i)}return!0}},A.prototype.scrollToIndex=function(e,t,i){var s,n,o=e.row,r=e.column;t&&(this.m_shouldFocus=!1),i&&(e.scrollToOrigin=!0);var l=this.getResources().isRTLMode()?"right":"left",a=0,h=0,d=this._getViewportTop(),m=this._getViewportBottom(),c=this._getViewportLeft(),u=this._getViewportRight();if(o<this.m_startRow||o>this.m_endRow){var _;_=o<this.m_startRow?this.m_avgRowHeight*o:this.m_avgRowHeight*(o+1)-m+d,h=this.m_currentScrollTop-_,this.m_scrollIndexAfterFetch=e,s=!0}else{n=this._getCellByIndex(e);let t=this.getMappedStyle("frozenCell");var p;null===n?(n=this._getFirstCellWithMatchingStartIndex(o,"row"),p=this.m_sizingManager.getSize("row",this._getKey(n,"row"))):p=this.getElementHeight(n);var g=this.getElementDir(n,"top");if(i||e.scrollToOrigin?h=d-g:g+p>m?h=m-(g+p):g<d&&(h=d-g),n&&n.classList.contains(t)){let e=this._getCellContainer(n);(e.classList.contains(this.getMappedStyle("databodyFrozenRow"))||e.classList.contains(this.getMappedStyle("databodyFrozenCorner")))&&(h=0)}}if(!isNaN(r)&&!0!==s)if(r<this.m_startCol||r>this.m_endCol){var f;let t,i;r<this.m_startCol?(t=this.hiddenColumnsInDirection(r,{left:!0}),i=t.length,f=this.m_avgColWidth*(r-i)):(t=this.hiddenColumnsInDirection(r,{right:!0}),i=t.length,f=this.m_avgColWidth*(r-i+1)-u+c),a=this.m_currentScrollLeft-f,this.m_scrollIndexAfterFetch=e}else{var C;null===(n=this._getCellByIndex(e))?(n=this._getFirstCellWithMatchingStartIndex(r,"column"),C=this.m_sizingManager.getSize("column",this._getKey(n,"column"))):C=this.getElementWidth(n);var y=this.getElementDir(n,l);i||e.scrollToOrigin||y<c?a=c-y:y+C>u&&(a=u-(y+C));let t=this.getMappedStyle("frozenCell");if(n&&n.classList.contains(t)){let e=this._getCellContainer(n);(e.classList.contains(this.getMappedStyle("databodyFrozenCol"))||e.classList.contains(this.getMappedStyle("databodyFrozenCorner")))&&(a=0)}}0!==a||0!==h?(null!=(n=this._getCellByIndex(e))&&!0!==t&&!1!==this.m_shouldFocus&&(this.m_cellToFocus=n),this.scrollDelta(a,h)):null!=this.m_scrollIndexAfterFetch&&(t||!1===this.m_shouldFocus||this._setActiveByIndex(this.m_scrollIndexAfterFetch,null,!1,!1,!0))&&(this.m_scrollIndexAfterFetch=null)},A.prototype.scrollToHeader=function(e){var t,i,s,n,o,r,l,a,h,d=e.axis,m=e.index,c=e.level,u=0;"row"===d?(t=this.m_startRowHeader,i=this.m_endRowHeader,s=this.m_avgRowHeight,n=this.m_currentScrollTop,a=this._getViewportTop(),h=this._getViewportBottom()):"column"===d?(t=this.m_startColHeader,i=this.m_endColHeader,s=this.m_avgColWidth,n=this.m_currentScrollLeft,a=this._getViewportLeft(),h=this._getViewportRight()):"rowEnd"===d?(t=this.m_startRowEndHeader,i=this.m_endRowEndHeader,s=this.m_avgRowHeight,n=this.m_currentScrollTop,a=this._getViewportTop(),h=this._getViewportBottom()):"columnEnd"===d&&(t=this.m_startColEndHeader,i=this.m_endColEndHeader,s=this.m_avgColWidth,n=this.m_currentScrollLeft,a=this._getViewportLeft(),h=this._getViewportRight());var _=h-a;if(m<t||m>i?(u=n-(m<t?s*m:s*(m+1)-_),this.m_scrollHeaderAfterFetch=e):("row"===d||"rowEnd"===d?(l=this._getHeaderByIndex(m,d,c),o=this.getElementDir(l,"top"),r=this.getElementHeight(l)):"column"!==d&&"columnEnd"!==d||(l=this._getHeaderByIndex(m,d,c),o=this.getElementDir(l,this.getResources().isRTLMode()?"right":"left"),r=this.getElementWidth(l)),_>r?o+r>h?u=h-(o+r):o<a&&(u=a-o):u=a-o),l){let e=this.getMappedStyle("frozenHeader");l.classList.contains(e)&&(u=0)}0!==u?(null!=l&&!1!==this.m_shouldFocus&&(this.m_cellToFocus=l),"row"===d||"rowEnd"===d?this.scrollDelta(0,u):this.scrollDelta(u,0)):null!=this.m_scrollHeaderAfterFetch&&(this._updateActive(e,!0,!0),this.m_scrollHeaderAfterFetch=null)},A.prototype.findHeader=function(e,t,i){if(null==t&&(t=this.getMappedStyle("headercell")),null==i&&(i=this.getMappedStyle("endheadercell")),null!=t){if(this.m_utils.containsCSSClassName(e,t)||this.m_utils.containsCSSClassName(e,i))return e;if(e.parentNode)return this.findHeader(e.parentNode,t,i);if(e===this.m_root)return null}return null},A.prototype.updateRowBanding=function(){var e=this.m_options.getRowBandingInterval();if(e>0)for(var t=this.m_databody.firstChild.querySelectorAll("."+this.getMappedStyle("cell")),i=this.getMappedStyle("banded"),s=0;s<t.length;s++){var n=t[s],o=this._getIndex(n,"row");Math.floor(o/e)%2==1?this.m_utils.containsCSSClassName(n,i)||this.m_utils.addCSSClassName(n,i):this.m_utils.containsCSSClassName(n,i)&&this.m_utils.removeCSSClassName(n,i)}},A.prototype.updateColumnBanding=function(){var e=this.m_options.getColumnBandingInterval();if(e>0)for(var t=this.m_databody.firstChild.querySelectorAll("."+this.getMappedStyle("cell")),i=this.getMappedStyle("banded"),s=0;s<t.length;s+=1){var n=t[s],o=this._getIndex(n,"column");Math.floor(o/e)%2==1?this.m_utils.containsCSSClassName(n,i)||this.m_utils.addCSSClassName(n,i):this.m_utils.containsCSSClassName(n,i)&&this.m_utils.removeCSSClassName(n,i)}},A.prototype._removeBanding=function(){for(var e=this.m_databody.firstChild.querySelectorAll("."+this.getMappedStyle("cell")),t=this.getMappedStyle("banded"),i=0;i<e.length;i++)this.m_utils.containsCSSClassName(e[i],t)&&this.m_utils.removeCSSClassName(e[i],t)},A.prototype._setAccInfoText=function(e,t){var i=this.getResources().getTranslatedText(e,t);null!=i&&(this.m_accInfo.textContent=i)},A.prototype.handleExpandEvent=function(e,t){void 0===t&&this.queueModelEvent(e)?e.operation="expand":(this._setAccInfoText("accessibleRowExpanded"),this.populateAccInfo(),t&&this._runModelEventQueue())},A.prototype.handleCollapseEvent=function(e,t){void 0===t&&this.queueModelEvent(e)?e.operation="collapse":(this._setAccInfoText("accessibleRowCollapsed"),this.populateAccInfo(),t&&this._runModelEventQueue())},A.prototype._getKey=function(e,t){return null!=e&&e[this.getResources().getMappedAttribute("context")]?null!=t&&this.m_utils.containsCSSClassName(e,this.getMappedStyle("cell"))?e[this.getResources().getMappedAttribute("context")].keys[t]:e[this.getResources().getMappedAttribute("context")].key:null},A.prototype._getActiveKey=function(e,t){if(t&&null!=this.m_prevActive){if("header"===this.m_prevActive.type&&(this.m_prevActive.axis===e||this.m_prevActive.axis===e+"End"))return this.m_prevActive.key;if("cell"===this.m_prevActive.type)return this.m_prevActive.keys[e]}else if(null!=this.m_active){if("header"===this.m_active.type&&(this.m_active.axis===e||this.m_active.axis===e+"End"))return this.m_active.key;if("cell"===this.m_active.type)return this.m_active.keys[e]}return null},A.prototype._handleCut=function(e,t){null==t&&(t=e.target);var i=this.findCellOrHeader(t);if(this._isMoveOnElementEnabled(i)){if(null!=this.m_cutCells)for(var s=0;s<this.m_cutCells.length;s++)this.m_utils.removeCSSClassName(this.m_cutCells[s],this.getMappedStyle("cut"));var n=this._getKey(i,"row");return this.m_cutCells=this._getAxisCellsByKey(n,"row"),this.m_cutRowHeader=this._findHeaderByKey(n,this.m_rowHeader,this.getMappedStyle("rowheadercell")),this.m_cutRowEndHeader=this._findHeaderByKey(n,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell")),this._highlightCellsAlongAxis(n,"row","key","add",["cut"]),null!==this.m_cutRowHeader&&this.m_utils.addCSSClassName(this.m_cutRowHeader,this.getMappedStyle("cut")),null!==this.m_cutRowEndHeader&&this.m_utils.addCSSClassName(this.m_cutRowEndHeader,this.getMappedStyle("cut")),!0}return!1},A.prototype._handleCutCells=function(e,t){null==t&&(t=e.target);const i=this.findCell(e.target),s=this.findLabel(e.target),n=this.findHeader(e.target);if(this._isDataGridProvider()){this.m_dataTransferAction="cut";let t={event:e,ui:{action:this.m_dataTransferAction}};if((i||n)&&this.m_options.isCutEnabled()&&this._isSelectionEnabled()&&this.m_selection?.length&&!s){this.m_selectionRange&&this.m_selectionRange.length&&this.unhighlightFloodFillRange(this.m_selectionRange[0]);let e=this.m_selection[this.m_selection.length-1];if(this.m_selectionRange=[e],t.ui.sourceRange=this.m_selectionRange[0],!this.fireEvent("cutRequest",t))return!0;this.highlightFloodFillRange(e),this.m_options.isFloodFillEnabled()&&this._removeFloodFillAffordance()}else if(s&&this.m_options._isLabelCutEnabled()){const e=this.getResources().getMappedAttribute("context");if(s){const i=s[e].level,n=s[e].axis;t.ui.level=i,t.ui.axis=n;let o=[];o.push(s),o=this._getDropHeaderTargets(n,i,o),o=this._getHeadersInView(o,n),this._headersDragged=o;let r="row"===n||"rowEnd"===n?["endFloodfill"]:["bottomFloodfill"];this._highlightHeaderRange(o,n,i,r),this.fireEvent("headerLabelCutRequest",t)}}}return!0},A.prototype._handleCopyCells=function(e,t){if(null==t&&(t=e.target),this._isDataGridProvider()&&this._isSelectionEnabled()&&this.m_options.isCopyEnabled()&&this.m_selection?.length){this.m_selectionRange&&this.m_selectionRange.length&&this.unhighlightFloodFillRange(this.m_selectionRange[0]);let t=this.m_selection[this.m_selection.length-1];this.m_selectionRange=[t],this.m_dataTransferAction="copy";let i={event:e,ui:{action:this.m_dataTransferAction,sourceRange:this.m_selectionRange[0]}};return!this.fireEvent("copyRequest",i)||(this.highlightFloodFillRange(t),this.m_options.isFloodFillEnabled()&&this._removeFloodFillAffordance(),!0)}return!1},A.prototype._handlePaste=function(e,t){if(null==t&&(t=e.target),null!=this.m_cutCells){for(var i=0;i<this.m_cutCells.length;i++)this.m_utils.removeCSSClassName(this.m_cutCells[i],this.getMappedStyle("cut"));null!==this.m_cutRowHeader&&(this.m_utils.removeCSSClassName(this.m_cutRowHeader,this.getMappedStyle("cut")),this.m_cutRowHeader=null),null!==this.m_cutRowEndHeader&&(this.m_utils.removeCSSClassName(this.m_cutRowEndHeader,this.getMappedStyle("cut")),this.m_cutRowEndHeader=null);var s=this._getKey(this.findCellOrHeader(t),"row"),n=this._getKey(this.m_cutCells[0],"row");n!==s&&(this._isSelectionEnabled()&&this._clearSelection(e),this._isDatabodyCellActive()&&this._unhighlightActive(),this.m_moveActive=!0,this.getDataSource().move(n,s)),this.m_cutCells=null}return!0},A.prototype._handlePasteCells=function(e,t){if(null==t&&(t=e.target),this._isDataGridProvider()&&this.m_options.isPasteEnabled())if(this.m_selectionRange&&this._isSelectionEnabled()&&!this.m_discontiguousSelection&&1===this.m_selection.length){let t={event:e,ui:{action:this.m_dataTransferAction,sourceRange:this.m_selectionRange[0],targetRange:this.m_selection[0]}};if(!this.fireEvent("pasteRequest",t))return!0;this.unhighlightFloodFillRange(this.m_selectionRange[0]),this.m_selectionRange=null,this.m_dataTransferAction=null}else if(!this.m_selectionRange){let t={event:e,ui:{action:"unknown",sourceRange:{},targetRange:this.m_selection[0]}};if(!this.fireEvent("pasteRequest",t))return!0;this.m_selectionRange=null,this.m_dataTransferAction=null}return!0},A.prototype._handleAutofill=function(e,t){if(null==t&&(t=e.target),this._isDataGridProvider()&&this._isSelectionEnabled()&&!this.m_discontiguousSelection&&this.m_options.isFloodFillEnabled()&&1===this.m_selection.length){let t="down";"keydown"===e.type&&(t=e.keyCode===this.keyCodes.D_KEY?"down":"end");let s=this.m_selection[0].startIndex,n=this.m_selection[0].endIndex,o=this.createRange(s,n),r=this.createRange(s,n),l=!1;if("down"===t?(o.endIndex.row=o.startIndex.row,r.startIndex.row=o.startIndex.row+1,r.startIndex.row>=o.startIndex.row&&r.startIndex.row<=r.endIndex.row&&(l=!0)):(o.endIndex.column=o.startIndex.column,r.startIndex.column=o.startIndex.column+1,r.startIndex.column>=o.startIndex.column&&r.startIndex.column<=r.endIndex.column&&(l=!0)),l){var i={event:e,ui:{action:t,sourceRange:o,targetRange:r}};if(!this.fireEvent("fillRequest",i))return!0}return this.unhighlightFloodFillRange(this.m_selection[0]),this._removeFloodFillAffordance(),this.m_selectionRange=null,this.m_dataTransferAction=null,this.m_floodFillDirection=null,!0}return!1},A.prototype._handleCancelReorder=function(e,t){if(null!=this.m_cutCells){for(var i=0;i<this.m_cutCells.length;i++)this.m_utils.removeCSSClassName(this.m_cutCells[i],this.getMappedStyle("cut"));return this.m_cutCells=null,null!==this.m_cutRowHeader&&(this.m_utils.removeCSSClassName(this.m_cutRowHeader,this.getMappedStyle("cut")),this.m_cutRowHeader=null),null!==this.m_cutRowEndHeader&&(this.m_utils.removeCSSClassName(this.m_cutRowEndHeader,this.getMappedStyle("cut")),this.m_cutRowEndHeader=null),!0}null!==this.m_dataTransferAction&&(this.m_selectionRange&&this.m_selectionRange.length?(this.unhighlightFloodFillRange(this.m_selectionRange[0]),this.m_selectionRange=null):(this.unhighlightDraggedHeaders(),this._headersDragged=[]),this.m_dataTransferAction=null)},A.prototype.unhighlightDraggedHeaders=function(){this._unhighlightElementsByClassName(this._headersDragged,["bottomFloodfill","startFloodfill","topFloodfill","endFloodfill"]);const e=this.getResources().getMappedAttribute("context");let t=this._headersDragged[0][e];if(0!==t.level){let e=this.m_headerLabels[t.axis][t.level-1],i=[];i.push(e),i=this._getDropHeaderTargets(t.axis,t.level-1,i),"column"===t.axis||"columnEnd"===t.axis?this._unhighlightElementsByClassName(i,["bottomFloodfill"]):this._unhighlightElementsByClassName(i,["endFloodfill"])}},A.prototype._handleMove=function(e){if(null==this.m_moveCells){var t=e.target,i=this.findCellOrHeader(t),s=this._getKey(i,"row");this.m_originalMoveIndex=this._getIndex(i,"row"),this.m_moveIndex=this.m_originalMoveIndex,this.m_moveCells=this._getAxisCellsByIndex(this.m_moveIndex,"row"),this.m_moveRowHeader=this._findHeaderByKey(s,this.m_rowHeader,this.getMappedStyle("rowheadercell")),this.m_moveRowEndHeader=this._findHeaderByKey(s,this.m_rowEndHeader,this.getMappedStyle("rowendheadercell")),this._highlightCellsAlongAxis(this.m_moveIndex,"row","index","add",["drag"]),this.m_originalTop=this.getElementDir(this.m_moveCells[0],"top"),this.m_dropTarget=document.createElement("div"),this.m_utils.addCSSClassName(this.m_dropTarget,this.getMappedStyle("drop")),this.setElementHeight(this.m_dropTarget,this.calculateRowHeight(this.m_moveCells[0])),this.setElementDir(this.m_dropTarget,this.m_originalTop,"top"),this.m_databody.firstChild.appendChild(this.m_dropTarget),this._addHeaderDropTarget(this.m_moveRowHeader,this.m_rowHeader,!1),this._addHeaderDropTarget(this.m_moveRowEndHeader,this.m_rowEndHeader,!0)}this.m_utils.isTouchDevice()||(this.m_prevY=this.m_currentY,this.m_currentY=e.pageY);for(var n=this.m_currentY-this.m_prevY,o=this.calculateRowHeight(this.m_moveCells[0]),r=0;r<this.m_moveCells.length;r++)this.setElementDir(this.m_moveCells[r],this.getElementDir(this.m_moveCells[r],"top")+n,"top");null!==this.m_moveRowHeader&&this.setElementDir(this.m_moveRowHeader,this.getElementDir(this.m_moveRowHeader,"top")+n,"top"),null!==this.m_moveRowEndHeader&&this.setElementDir(this.m_moveRowEndHeader,this.getElementDir(this.m_moveRowEndHeader,"top")+n,"top");var l=this.m_moveIndex+1,a=this.m_moveIndex-1,h=this._getCellByIndex(this.createIndex(l,this.m_startCol)),d=this._getCellByIndex(this.createIndex(a,this.m_startCol));null!=h&&this.getElementDir(h,"top")<this.getElementDir(this.m_moveCells[0],"top")+o/2?this._moveDropRows("nextSibling",l):null!=d&&this.getElementDir(d,"top")>this.getElementDir(this.m_moveCells[0],"top")-o/2&&this._moveDropRows("previousSibling",a)},A.prototype._addHeaderDropTarget=function(e,t,i){var s;null!==e&&(null==e.style.height&&this.setElementHeight(e,this.calculateRowHeight(e)),this.m_utils.addCSSClassName(e,this.getMappedStyle("drag")),s=document.createElement("div"),this.m_utils.addCSSClassName(s,this.getMappedStyle("drop")),this.setElementHeight(s,this.calculateRowHeight(e)),this.setElementDir(s,this.m_originalTop,"top"),t.firstChild.appendChild(s),i?this.m_dropTargetEndHeader=s:this.m_dropTargetHeader=s)},A.prototype._moveDropRows=function(e,t){var i,s,n,o,r;"nextSibling"===e?(r=this._getAxisCellsByIndex(t,"row"),i=this.m_originalTop+this.calculateRowHeight(r[0]),s=this.m_originalTop):(r=this._getAxisCellsByIndex(t,"row"),s=(i=this.getElementDir(r[0],"top"))+this.calculateRowHeight(r[0])),this.setElementDir(this.m_dropTarget,i,"top");for(var l=0;l<r.length;l++)this.setElementDir(r[l],s,"top");null!==this.m_moveRowHeader&&(n=this.m_moveRowHeader.parentNode,this.setElementDir(this.m_dropTargetHeader,i,"top"),this.setElementDir(this.m_moveRowHeader[e],s,"top")),null!==this.m_moveRowEndHeader&&(o=this.m_moveRowEndHeader.parentNode,this.setElementDir(this.m_dropTargetEndHeader,i,"top"),this.setElementDir(this.m_moveRowEndHeader[e],s,"top")),this.m_originalTop=i,this._highlightCellsAlongAxis(this.m_moveIndex+1,"row","index","remove",["activedrop"]),"nextSibling"===e?(this._modifyAxisCellContextIndex("row",this.m_moveIndex,1,1),this._modifyAxisCellContextIndex("row",this.m_moveIndex+1,1,-1),this.m_moveIndex+=1,null!==this.m_moveRowHeader&&n&&n.insertBefore(this.m_moveRowHeader,this.m_moveRowHeader[e][e]),null!==this.m_moveRowEndHeader&&o&&o.insertBefore(this.m_moveRowEndHeader,this.m_moveRowEndHeader[e][e])):(this._modifyAxisCellContextIndex("row",this.m_moveIndex,1,-1),this._modifyAxisCellContextIndex("row",this.m_moveIndex-1,1,1),this.m_moveIndex-=1,null!==this.m_moveRowHeader&&n&&n.insertBefore(this.m_moveRowHeader,this.m_moveRowHeader[e]),null!==this.m_moveRowEndHeader&&o&&o.insertBefore(this.m_moveRowEndHeader,this.m_moveRowEndHeader[e])),this._refreshDatabodyMap(),this._highlightCellsAlongAxis(this.m_moveIndex+1,"row","index","add",["activedrop"])},A.prototype._isMoveEnabled=function(e){var t=this.getDataSource().getCapability("move");return"enable"===this.m_options.isMoveable("row")&&("full"===t||t===e)},A.prototype._handleMoveMouseUp=function(e,t){if(null!=this.m_moveCells){this._remove(this.m_dropTarget),null!==this.m_moveRowHeader&&this._remove(this.m_dropTargetHeader),null!==this.m_moveRowEndHeader&&this._remove(this.m_dropTargetEndHeader),null!=this.m_active&&"column"!==this.m_active.axis&&(this.m_moveActive=!0),this._isSelectionEnabled()&&this._clearSelection(e);var i=this.m_moveCells[0],s=this._getKey(i,"row");if(!0===t){var n=this.m_moveIndex+1,o=this._getKey(this._getCellByIndex(this.createIndex(n,this.m_startCol)),"row");this.getDataSource().move(s,o)}else this.getDataSource().move(s,s);this.m_moveCells=null,this.m_originalMoveIndex=null,this.m_moveIndex=null}this.m_databodyMove=!1},A.prototype._handleFloodFillMouseUp=function(e){if(this.m_floodFillRange&&this.m_floodFillRange.length){var t={event:e,ui:{action:this.m_floodFillDirection,sourceRange:this.m_selectionRange[0],targetRange:this.m_floodFillRange[0]}};if(!this.fireEvent("fillRequest",t))return!0;this.unhighlightFloodFillRange()}this.m_selectionRange=null,this.m_floodFillRange=null,this.m_floodFillDirection=null;const i=[this.m_databody,this.m_databodyFrozenCol,this.m_databodyFrozenRow,this.m_databodyFrozenCorner];for(let e=0;e<i.length;e++)i[e]&&(i[e].style.cursor="default");return this.m_cursor="default",!0},A.prototype._isMoveOnElementEnabled=function(e){return!(null==e||!this._isMoveEnabled("row")||this._getActiveKey("row")!==this._getKey(e,"row"))},A.prototype._manageMoveCursor=function(){if(!this._isDataGridProvider()){var e=this._getActiveKey("row"),t=this._getActiveKey("row",!0),i=this.getMappedStyle("draggable"),s=this.getMappedStyle("rowheadercell"),n=this.getMappedStyle("rowendheadercell");if(null!=t){this._highlightCellsAlongAxis(t,"row","key","remove",["draggable"]);var o=this._findHeaderByKey(t,this.m_rowHeader,s);this.m_utils.containsCSSClassName(o,i)&&this.m_utils.removeCSSClassName(o,i),o=this._findHeaderByKey(t,this.m_rowEndHeader,n),this.m_utils.containsCSSClassName(o,i)&&this.m_utils.removeCSSClassName(o,i)}if(null!=e){var r=this._getAxisCellsByKey(e,"row");if(this._isMoveOnElementEnabled(r[0])){this._highlightCellsAlongAxis(e,"row","key","add",["draggable"]);var l=this._findHeaderByKey(e,this.m_rowHeader,s);this.m_utils.addCSSClassName(l,i);var a=this._findHeaderByKey(e,this.m_rowEndHeader,n);this.m_utils.addCSSClassName(a,i)}}}},A.prototype.handleRootFocus=function(e,t){this.m_utils.addCSSClassName(this.m_root,this.getMappedStyle("focus")),this._clearFocusoutTimeout(),this._clearFocusoutBusyState();const i=e.target;if(!t){if(this._clearOpenPopupListeners(),!this.m_root.contains(document.activeElement)||document.activeElement===this.m_root&&0===this.m_root.tabIndex||document.activeElement===this.m_databody&&this.m_scrollbarFocus&&0===this.m_root.tabIndex){this._exitActionableMode(),this.m_externalFocus=!0,this._isCellEditable()?this._setAccInfoText("accessibleEditableMode"):this._isGridEditable()&&this._setAccInfoText("accessibleNavigationMode");var s=!1;!0===this.m_scrollbarFocus&&(this.m_shouldFocus=!1,this.m_scrollbarFocus=!1,s=!0);let t=this._getEmptyElement();if(null==this.m_active&&t)this._setActive(t,{type:"empty"},e,null,null,s,!0);else if(null!=this.m_active||this._databodyEmpty())null!=this.m_active&&this._highlightActive();else{var n;let t=this.getVisibleCellIndexInDirection("column",0,{right:!0}),i=this.getVisibleCellIndexInDirection("row",0,{down:!0});n=this.createIndex(i,t),s||this.scrollToIndex(n),this._setActiveByIndex(n,e,null,null,s)}}else if(this.m_utils.containsCSSClassName(i,this.getMappedStyle("cell"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("headercell"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("headerlabel"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("endheadercell"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("noDataContainer"))||this._isEditOrEnter())this._exitActionableMode();else if(!this._enteringActionableMode){let t=this._getOwnedContentFromTarget(i);if(t){this.m_shouldFocus=!1;const i=this._createActiveObject(t);this._setActive(t,i,e,null,null,null,!0),_.enableAllFocusableElements(t),this._enterActionableMode(t,null,!1)}}this.m_root.tabIndex=-1}},A.prototype._getOwnedContentFromTarget=function(e){let t=this.findCellOrHeader(e);return null===t&&(t=this.findLabel(e)),null===t&&(t=this.find(e,"noDataContainer")),t},A.prototype._handlePopupFocusout=function(e){this.handleRootBlur(e,!0)},A.prototype._handlePopupFocusin=function(e){this.handleRootFocus(e,!0)},A.prototype.handleRootBlur=function(e,t){if(this._clearFocusoutTimeout(),!t){this._clearOpenPopupListeners();var i=C.getLogicalChildPopup(this.m_root);if(null!=i)return this._openPopup=i,t=!1,this._handlePopupFocusinListener=this._handlePopupFocusin.bind(this),this._handlePopupFocusoutListener=this._handlePopupFocusout.bind(this),i.addEventListener("focusin",this._handlePopupFocusinListener),void i.addEventListener("focusout",this._handlePopupFocusoutListener)}this._setFocusoutBusyState(),this.m_focusoutTimeout=setTimeout(function(){if(!this.m_root.contains(document.activeElement)||!0===t){this.m_root.tabIndex=0;var i=this._getActiveElement();null!=i&&(this._unsetAriaProperties(i),this._isEditOrEnter()&&!this.m_animating&&this._leaveEditing(e,i,!1,!1),this._exitActionableMode())}this._clearFocusoutBusyState()}.bind(this),100),null==this.m_moveRow&&this.m_utils.removeCSSClassName(this.m_root,this.getMappedStyle("focus"))},A.prototype._clearOpenPopupListeners=function(){null!=this._openPopup&&(this._openPopup.removeEventListener("focusin",this._handlePopupFocusinListener),this._openPopup.removeEventListener("focusout",this._handlePopupFocusoutListener),this._openPopup=null),this._handlePopupFocusinListener=null,this._handlePopupFocusoutListener=null},A.prototype._handlePopupFocusout=function(e){this.handleRootBlur(e,!0)},A.prototype._handlePopupFocusin=function(e){this.handleRootFocus(e,!0)},A.prototype._clearFocusoutTimeout=function(){this.m_focusoutTimeout&&(clearTimeout(this.m_focusoutTimeout),this.m_focusoutTimeout=null)},A.prototype._setFocusoutBusyState=function(){if(!this.m_focusoutResolveFunc){var e=u.getContext(this.m_root).getBusyContext(),t={description:"Datagrid component 'is handling focusout."};this.m_focusoutResolveFunc=e.addBusyState(t)}},A.prototype._clearFocusoutBusyState=function(){this.m_focusoutResolveFunc&&(this.m_focusoutResolveFunc(),this.m_focusoutResolveFunc=null)},A.prototype.calculateRowHeight=function(e){return""!==e.style.height?this.getElementHeight(e):null!=e.nextSibling?this.getElementDir(e.nextSibling,"top")-this.getElementDir(e,"top"):this.m_endRowPixel-this.getElementDir(e,"top")},A.prototype._databodyEmpty=function(){return!(null!=this.m_databody.firstChild&&null!=this.m_databody.firstChild.firstChild||this._hasFrozenColumns()||this._hasFrozenRows())},A.prototype._databodyEmptyState=function(){return!(null!=this.m_databody.firstChild&&null!=this.m_databody.firstChild.firstChild&&!this._getEmptyElement())},A.prototype._getEmptyElement=function(){let e=this.m_databody.querySelector("."+this.getMappedStyle("noDataContainer")),t=this.m_databody.querySelector("."+this.getMappedStyle("emptytext"));return e||t},A.prototype.addTransformMoveStyle=function(e,t,i,s,n,o,r){e.style.transitionDelay=i,e.style.transitionTimingFunction=s,e.style.transitionDuration=t,e.style.transform="translate3d("+n+"px,"+o+"px,"+r+"px)"},A.prototype.removeTransformMoveStyle=function(e){e.style.transitionDelay="",e.style.transitionTimingFunction="",e.style.transitionDuration="",e.style.transform=""},A.prototype._refreshDatabodyMap=function(){this._clearDatabodyMap(),this._addNodesToDatabodyMap(this.m_databody.firstChild.childNodes),this.m_databodyFrozenCol&&this._addNodesToDatabodyMap(this.m_databodyFrozenCol.firstChild.childNodes),this.m_databodyFrozenCorner&&this._addNodesToDatabodyMap(this.m_databodyFrozenCorner.firstChild.childNodes),this.m_databodyFrozenRow&&this._addNodesToDatabodyMap(this.m_databodyFrozenRow.firstChild.childNodes)},A.prototype._populateDatabody=function(e,t){this._addNodesToDatabodyMap(t.childNodes),e.appendChild(t),this.m_subtreeAttachedCallback(e)},A.prototype._emptyDatabody=function(e){this._clearDatabodyMap(),this.m_utils.empty(e)},A.prototype._addNodesToDatabodyMap=function(e){for(var t=0;t<e.length;t++){var i=e[t];if(this.m_utils.containsCSSClassName(i,this.getMappedStyle("cell"))){var s=this.getCellIndexes(i),n=this.getCellExtents(i),o=i.id;this._addToDatabodyMap(s,o,n)}}},A.prototype._addToDatabodyMap=function(e,t,i){for(var s=i.row,n=i.column,o=0;o<s;o++)for(var r=0;r<n;r++)this._addIndexToDatabodyMap(this.createIndex(e.row+o,e.column+r),t)},A.prototype._addIndexToDatabodyMap=function(e,t){var i="r"+e.row+"c"+e.column;this.m_databodyMap.set(i,t)},A.prototype._removeIndexFromDatabodyMap=function(e){var t="r"+e.row+"c"+e.column;return this.m_databodyMap.delete(t)},A.prototype._getFromDatabodyMap=function(e){var t="r"+e.row+"c"+e.column;return this.m_databodyMap.get(t)},A.prototype._clearDatabodyMap=function(){return this.m_databodyMap.clear()},A.prototype._modifyAxisCellContextIndex=function(e,t,i,s){for(var n=t;n<t+i;n++)for(var o=this._getAxisCellsByIndex(n,e),r=0;r<o.length;r++){o[r][this.getResources().getMappedAttribute("context")].indexes[e]+=s}},A.prototype._modifyAxisHeaderContextIndex=function(e,t,i,s){for(var n=t;n<t+i;n++){var o;o="row"===e?this._getHeadersByIndex(n,"row"):this._getHeadersByIndex(n,"rowEnd");for(var r=0;r<o.length;r++){o[r][this.getResources().getMappedAttribute("context")].index+=s}}},A.prototype._getCellOrHeaderByIndex=function(e,t){var i=null,s=this._getAxisCellsByIndex(e,t,!0);return null!=s&&s.length>0&&(i=s[0]),null==i&&("row"===t&&null==(i=this._getHeaderByIndex(e,t))&&(i=this._getHeaderByIndex(e,"rowEnd")),"column"===t&&null==(i=this._getHeaderByIndex(e,t))&&(i=this._getHeaderByIndex(e,"columnEnd"))),i},A.prototype._getLabel=function(e,t){return this.m_headerLabels[e][t]},A.prototype._getCellByIndex=function(e){var t=this._getFromDatabodyMap(e);let i=null;if(null!=t){let e=[this.m_databody,this.m_databodyFrozenCorner,this.m_databodyFrozenCol,this.m_databodyFrozenRow];e=e.filter(e=>e);for(let s=0;s<e.length&&(i=e[s].querySelector(`#${t}`),!i);s++);}return i},A.prototype._getCellContainer=function(e){let t=this.m_databody,i=[this.m_databodyFrozenCorner,this.m_databodyFrozenCol,this.m_databodyFrozenRow];i=i.filter(e=>e);for(let s=0;s<i.length;s++){if(i[s].querySelector(`#${e.id}`)){t=i[s];break}}return t},A.prototype._getFrozenCellByIndex=function(e,t,i){var s=this._getFromDatabodyMap(e);if(null!=s){let e;return i?e=this.m_databodyFrozenCorner.querySelector("#"+s):"row"===t?e=this.m_databodyFrozenCol.querySelector("#"+s):"column"===t&&(e=this.m_databodyFrozenRow.querySelector("#"+s)),e}return null},A.prototype._getCellsInRange=function(e,t,i,s){let n=[];for(let o=e;o<=i;o++)for(let e=t;e<=s;e++){let t=this._getCellByIndex(this.createIndex(o,e));t&&n.push(t)}return n},A.prototype._getFirstCellWithMatchingStartIndex=function(e,t){let i,s,n="row"===t?this.m_startCol:this.m_startRow,o="row"===t?this.m_endCol:this.m_endRow;for(let r=n;r<=o;r++)if(i=this.createIndex("row"===t?e:r,"row"===t?r:e),s=this._getCellByIndex(i),this._getIndex(s,t)===e)return s;return null},A.prototype._getAxisCellsByIndex=function(e,t,i){for(var s,n="row"===t?this.m_startCol:this.m_startRow,o="row"===t?this.m_endCol:this.m_endRow,r=[],l=n;l<=o;l+=s){var a=this._getCellByIndex(this.createIndex("row"===t?e:l,"row"===t?l:e));if(null!=a){if(s=this.getCellExtents(a)["row"===t?"column":"row"],r.push(a),i)break}else s=1}return r},A.prototype._getAxisCellsByKey=function(e,t,i){if(null==e||null==this.m_databody||null==this.m_databody.firstChild)return null;var s=[];let n=[this.m_databody,this.m_databodyFrozenCorner,this.m_databodyFrozenCol,this.m_databodyFrozenRow];n=n.filter(e=>e);let o=[];for(let e=0;e<n.length;e++)o.push(...n[e].firstChild.querySelectorAll("."+this.getMappedStyle("cell")));for(var r=0;r<o.length;r++){var l=o[r];if(this.m_utils.containsCSSClassName(l,this.getMappedStyle("cell")))if(this._getKey(l,t)===e&&(s.push(l),i))break}return s},A.prototype._isDOMElementFilterable=function(e){if(null==e)return!1;var t=this.findHeader(e);return null!=t&&"true"===t.getAttribute(this.getResources().getMappedAttribute("filterable"))},A.prototype._getHorizontalAlignmentStyle=function(e){const t={justifyContent:e,textAlign:e};return"start"===e?(t.justifyContent="flex-start",t.textAlign="start"):"end"===e&&(t.justifyContent="flex-end",t.textAlign="end"),t},A.prototype._getVerticalAlignmentStyle=function(e){return"top"===e?"flex-start":"bottom"===e?"flex-end":"center"},A.prototype._shouldAppendIcon=function(e,t,i){return!!("start"===e||"center"===e||this.getResources().isRTLMode()&&"right"===e||!this.getResources().isRTLMode()&&"left"===e||"auto"===e&&("row"===t||this._isParentNode(i)))},A.prototype._setupActions=function(){this.actions={ACTIONABLE:this._handleActionable,EXIT_ACTIONABLE:this._handleExitActionable,TAB_NEXT_IN_CELL:_.handleActionableTab,TAB_PREV_IN_CELL:_.handleActionablePrevTab,TAB_NEXT_IN_CELL_OR_FOCUS_RIGHT:this._handleEditableTab,TAB_PREV_IN_CELL_OR_FOCUS_LEFT:this._handleEditablePrevTab,EDITABLE:this._handleEditable,EXIT_EDITABLE:this._handleExitEditable,DATA_ENTRY:this._handleDataEntry,EDIT:this._handleEdit,EXIT_EDIT:this._handleExitEdit,CANCEL_EDIT:this._handleCancelEdit,NO_OP:this._handleNoOp,FOCUS_LEFT:this._handleFocusLeft,FOCUS_LEFT_NON_EMPTY_CELL:this._handleFocusLeftNonEmptyCell,FOCUS_RIGHT:this._handleFocusRight,FOCUS_RIGHT_NON_EMPTY_CELL:this._handleFocusRightNonEmptyCell,FOCUS_UP:this._handleFocusUp,FOCUS_UP_NON_EMPTY_CELL:this._handleFocusUpNonEmptyCell,FOCUS_DOWN:this._handleFocusDown,FOCUS_DOWN_NON_EMPTY_CELL:this._handleFocusDownNonEmptyCell,FOCUS_ROW_FIRST:this._handleFocusRowFirst,FOCUS_ROW_LAST:this._handleFocusRowLast,FOCUS_COLUMN_FIRST:this._handleFocusColumnFirst,FOCUS_COLUMN_LAST:this._handleFocusColumnLast,FOCUS_COLUMN_HEADER:this._handleFocusColumnHeader,FOCUS_COLUMN_END_HEADER:this._handleFocusColumnEndHeader,FOCUS_ROW_HEADER:this._handleFocusRowHeader,FOCUS_ROW_END_HEADER:this._handleFocusRowEndHeader,FOCUS_FIRST_CELL_IN_GRID:this._handleFocusFirstCellInGrid,FOCUS_LAST_CELL_IN_GRID:this._handleFocusLastCellInGrid,READ_CELL:this.readCurrentContent,SORT:this._handleSortKey,EXPAND:this._handleExpandKey,COLLAPSE:this._handleCollapseKey,SELECT_DISCONTIGUOUS:this._handleSelectDiscontiguous,SELECT_EXTEND_LEFT:this._handleExtendSelectionLeft,SELECT_EXTEND_RIGHT:this._handleExtendSelectionRight,SELECT_EXTEND_UP:this._handleExtendSelectionUp,SELECT_EXTEND_DOWN:this._handleExtendSelectionDown,SELECT_ROW:this._handleSelectRow,SELECT_COLUMN:this._handleSelectColumn,SELECT_ALL:this._handleSelectAll,CUT:this._handleCut,CUT_CELLS:this._handleCutCells,COPY_CELLS:this._handleCopyCells,CANCEL_REORDER:this._handleCancelReorder,PASTE:this._handlePaste,PASTE_CELLS:this._handlePasteCells,FILL:this._handleAutofill,CANCEL_DRAG:this.handleCancelDrag,FILTER_COLUMN:this._handleFilterKey}},A.prototype._getActionFromKeyDown=function(e,t,i){var s={cellOrHeader:t,isLabel:i,readOnly:!this._isCellEditable(),currentMode:this._getCurrentMode(),activeMove:null!=this.m_cutCells||null!=this.m_dataTransferAction,rowMove:this._isMoveEnabled("row"),columnSort:"column"===t&&this._isDOMElementSortable(this._getActiveElement()),rowSort:"row"===t&&this._isDOMElementSortable(this._getActiveElement()),selection:this._isSelectionEnabled(),selectionMode:this.m_options.getSelectionMode(),multipleSelection:this.isMultipleSelection(),expandCollapse:this._isTargetExpandCollapseEnabled(e.target)};return this._isDataGridProvider()&&(s.cutCells=!0,s.copyCells=!0,s.pasteCells=!0,s.activeDrag=!(!this._cellsDragged||!this._cellsDragged.length),s.filterCol=this._isDOMElementFilterable(this._getActiveElement())),this.m_options.isFloodFillEnabled()&&(s.fill=!0),this.actions[this.m_keyboardHandler.getAction(e,s)]},A.prototype._getActionFromNoDataKeydown=function(e){var t={readOnly:!this._isCellEditable(),currentMode:this._getCurrentMode()};return this.actions[this.m_keyboardHandler.getNoDataAction(e,t)]},A.prototype.isActionableMode=function(){return"actionable"===this.m_currentMode},A.prototype.setActionableMode=function(e){this.m_currentMode=e?"actionable":"navigation",this._setAccInfoText(this.isActionableMode()?"accessibleActionableMode":"accessibleNavigationMode")},A.prototype._handleActionable=function(e,t){return this._enterActionableMode(t,e,!0),!1},A.prototype._handleExitActionable=function(e,t){return this._exitActionableMode(),this._highlightActive(),!1},A.prototype._getEditMode=function(){return null==this.m_editMode&&(this.m_editMode=this.m_options.getEditMode()),this.m_editMode},A.prototype._getCurrentMode=function(){return null==this.m_currentMode&&(this.m_currentMode="navigation"),this.m_currentMode},A.prototype._isEditOrEnter=function(){return"edit"===this._getCurrentMode()},A.prototype._isGridEditable=function(){var e=this._getEditMode();return"cellNavigation"===e||"cellEdit"===e},A.prototype._isCellEditable=function(){return"cellEdit"===this._getEditMode()},A.prototype._handleEditable=function(e,t){return this._isGridEditable()?(this.m_editMode=null,this.m_setOptionCallback("editMode","cellEdit",{_context:{writeback:!0,internalSet:!0}}),this.m_utils.removeCSSClassName(this.m_root,this.getMappedStyle("readOnly")),this.m_utils.addCSSClassName(this.m_root,this.getMappedStyle("editable")),this._updateEdgeCellBorders(""),this._setAccInfoText("accessibleEditableMode"),this._setEditableClone(t)):this._handleActionable(e,t),!1},A.prototype._handleExitEditable=function(e,t){this.m_editMode=null,this.m_setOptionCallback("editMode","cellNavigation",{_context:{writeback:!0,internalSet:!0}}),this.m_utils.addCSSClassName(this.m_root,this.getMappedStyle("readOnly")),this.m_utils.removeCSSClassName(this.m_root,this.getMappedStyle("editable")),this._updateEdgeCellBorders("none"),this._setAccInfoText("accessibleNavigationMode"),this._destroyEditableClone()},A.prototype._handleDataEntry=function(e,t){var i={event:e,ui:{cell:t,cellContext:t[this.getResources().getMappedAttribute("context")]}};return!this._getAttribute(t,"readOnly")&&this.fireEvent("beforeEdit",i)?(this._removeFloodFillAffordance(),this._reRenderCell(t,"edit",this.getMappedStyle("cellEdit"),this.m_editableClone),this._setFocusToFirstFocusableElement(t,void 0,!0)?this.m_currentMode="edit":this.m_utils.removeCSSClassName(t,this.getMappedStyle("cellEdit"))):this.showReadOnlyPopup(t),!1},A.prototype._handleEdit=function(e,t,i){var s={event:e,ui:{cell:t,cellContext:t[this.getResources().getMappedAttribute("context")]}},n=!this._getAttribute(t,"readOnly")&&this.fireEvent("beforeEdit",s);if(n){this._removeFloodFillAffordance(),this._reRenderCell(t,"edit",this.getMappedStyle("cellEdit"),this.m_editableClone),this.m_currentMode="edit",this._updateEdgeCellBorders("");var o=this;u.getContext(t).getBusyContext().whenReady().then(function(){o._setFocusToFirstFocusableElement(t,void 0,i)||(o.m_utils.removeCSSClassName(t,o.getMappedStyle("cellEdit")),o.m_currentMode="navigation")})}else n=!1,this._enterActionableMode(t,null,!0),this.isActionableMode()||this.showReadOnlyPopup(t);return n},A.prototype.showReadOnlyPopup=function(e){const t=this.m_root.getAttribute("id");let i=document.getElementById(t+"popup");if(null===i){i=document.createElement("oj-popup"),i.id=t+"popup",i.setAttribute("data-oj-binding-provider","none");var s=document.createElement("span");let e=this.getResources().getTranslatedText("msgReadOnly");s.textContent=e,i.appendChild(s);const n={my:{horizontal:"center",vertical:"bottom"},at:{horizontal:"center",vertical:"top"},collision:"none"};i.setAttribute("position",JSON.stringify(n)),i.setAttribute("tail","none"),this.m_root.appendChild(i)}if(i){u.getContext(i).getBusyContext().whenReady().then(()=>{i.open(e)})}else i.open(e)},A.prototype._handleExitEdit=function(e,t){return this._leaveEditing(e,t,!1)},A.prototype._handleCancelEdit=function(e,t){return!!this._leaveEditing(e,t,!0)&&(this._setEditableClone(t),!0)},A.prototype._leaveEditing=function(e,t,i,s){const n=t[this.getResources().getMappedAttribute("context")];var o={event:e,ui:{cell:t,cellContext:n,cancelEdit:i}};"invalidShown"===n.metadata?.validity&&this._applyBorderClassesAroundRange(t,{startIndex:this.m_active.indexes},!1,"EditInvalid"),i||(_.disableAllFocusableElements(t),!1===s&&(this.m_shouldFocus=s),this._highlightActive());var r=this.fireEvent("beforeEditEnd",o);return r?(this.m_currentMode="navigation",_.disableAllFocusableElements(t),!1===s&&(this.m_shouldFocus=s),this._highlightActive(),this._reRenderCell(t,"navigation",this.getMappedStyle("cellEdit"),this.m_editableClone)):(r=!1,this._scrollToActive(this.m_active),this._setFocusToFirstFocusableElement(t)),this._runModelEventQueue(),r},A.prototype._handleFocusKey=function(e,t,i,s,n,o,r){var l,a=!0,h=!0;if(null!=this.m_active){if("cell"===this.m_active.type){if(this._isEditOrEnter()?(l=!0,a=this._leaveEditing(e,t,!1),h=!1):this.isActionableMode()&&this._exitActionableMode(),a){this.m_options.isFloodFillEnabled()&&this._removeFloodFillAffordance();var d=this.m_active,m=this.handleFocusChange(i,s,e,h,n,o,r);return this._isGridEditable()&&d!==this.m_active&&l&&this.m_utils.isTouchDevice()?this._handleEdit(e,this._getActiveElement(),!0):m}return!0}if("header"===this.m_active.type)return this.handleHeaderFocusChange(i,e,s,n,o);if("label"===this.m_active.type)return this.handleLabelFocusChange(i,e,s,n);if("empty"===this.m_active.type)return this.handleNoDataFocusChange(i,s,e,h)}return!1},A.prototype._handleFocusLeft=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.LEFT_KEY,!1,!1)},A.prototype._handleFocusLeftNonEmptyCell=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.LEFT_KEY,!1,!1,!0)},A.prototype._handleFocusRight=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.RIGHT_KEY,!1,!1)},A.prototype._handleFocusRightNonEmptyCell=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.RIGHT_KEY,!1,!1,!0)},A.prototype._handleFocusUp=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.UP_KEY,!1,!1)},A.prototype._handleFocusUpNonEmptyCell=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.UP_KEY,!1,!1,!0)},A.prototype._handleFocusDown=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.DOWN_KEY,!1,!1)},A.prototype._handleFocusDownNonEmptyCell=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.DOWN_KEY,!1,!1,!0)},A.prototype._handleFocusRowFirst=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.PAGEUP_KEY,!1,!1)},A.prototype._handleFocusRowLast=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.PAGEDOWN_KEY,!1,!1)},A.prototype._handleFocusColumnFirst=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.HOME_KEY,!1,!1)},A.prototype._handleFocusColumnLast=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.END_KEY,!1,!1)},A.prototype._handleFocusRowHeader=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.LEFT_KEY,!1,!0)},A.prototype._handleFocusRowEndHeader=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.RIGHT_KEY,!1,!0)},A.prototype._handleFocusColumnHeader=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.UP_KEY,!1,!0)},A.prototype._handleFocusColumnEndHeader=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.DOWN_KEY,!1,!0)},A.prototype._handleFocusFirstCellInGrid=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.HOME_KEY,!1,!1,!1,!0)},A.prototype._handleFocusLastCellInGrid=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.END_KEY,!1,!1,!1,!0)},A.prototype._handleSelectRow=function(e,t){var i,s,n,o,r=1;if(!this._isSelectionEnabled()||!this.isMultipleSelection()&&"row"!==this.m_options.getSelectionMode())return!1;if(this.m_utils.containsCSSClassName(t,this.getMappedStyle("cell")))i=o=this.m_active.indexes.row,s=o,n=this.m_rowHeaderLevelCount-1;else{if(null==this.m_active||"header"!==this.m_active.type||-1===this.m_active.axis.indexOf("row"))return!1;if(o=this.m_active.index,n=this.m_active.level,this.m_rowHeaderLevelCount-1===n)i=o,s=o;else{var l=this._getActiveElement();s=(i=this._getAttribute(l.parentNode,"start",!0))+(r=this._getAttribute(l.parentNode,"extent",!0))-1}}if(this.m_selectionFrontier&&this.m_selectionFrontier.axis&&-1!==this.m_selectionFrontier.axis.indexOf("column"))return this._handleSelectAll(e),!0;if(this.setHeaderSelectionFrontier("row",s,o,n,t,!0),this._shouldDeselectHeader(o,r,"row")){var a=this.createIndex(o,0),h=this.createIndex(o+r-1,-1),d=this._getSelectionStartAndEnd(a,h,0),m=this.createRange(this.createIndex(d.min.row,0),this.createIndex(d.max.row,-1)),c=this._trimRangeForSelectionMode(m);return this.m_deselectInfo={selection:this.GetSelection()},this._deselectRange(c,e),!0}return this._selectEntireRow(i,s,e),this._setAccInfoText("accessibleRowSelected",{row:o+1}),!0},A.prototype._handleSelectColumn=function(e,t){var i,s,n,o,r=1;if(!this._isSelectionEnabled()||!this.isMultipleSelection()||"cell"!==this.m_options.getSelectionMode())return!1;if(this.m_utils.containsCSSClassName(t,this.getMappedStyle("cell")))i=o=this.m_active.indexes.column,s=o,n=this.m_columnHeaderLevelCount-1;else{if(null==this.m_active||"header"!==this.m_active.type||-1===this.m_active.axis.indexOf("column"))return!1;if(o=this.m_active.index,n=this.m_active.level,this.m_columnHeaderLevelCount-1===n)i=o,s=o;else{var l=this._getActiveElement();s=(i=this._getAttribute(l.parentNode,"start",!0))+(r=this._getAttribute(l.parentNode,"extent",!0))-1}}if(this.m_selectionFrontier&&this.m_selectionFrontier.axis&&-1!==this.m_selectionFrontier.axis.indexOf("row"))return this._handleSelectAll(e),!0;if(this.setHeaderSelectionFrontier("column",s,o,n,t,!0),this._shouldDeselectHeader(o,r,"column")){var a=this.createIndex(0,o),h=this.createIndex(-1,o+r-1),d=this._getSelectionStartAndEnd(a,h,0),m=this.createRange(this.createIndex(0,d.min.column),this.createIndex(-1,d.max.column)),c=this._trimRangeForSelectionMode(m);return this.m_deselectInfo={selection:this.GetSelection()},this._deselectRange(c,e),!0}return this._selectEntireColumn(i,s,e),this._setAccInfoText("accessibleColumnSelected",{column:o+1}),!0},A.prototype._handleSelectDiscontiguous=function(e,t){return this.setDiscontiguousSelectionMode(!this.m_discontiguousSelection),!0},A.prototype._handleExtendSelectionLeft=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.LEFT_KEY,!0,!1)},A.prototype._handleExtendSelectionRight=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.RIGHT_KEY,!0,!1)},A.prototype._handleExtendSelectionUp=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.UP_KEY,!0,!1)},A.prototype._handleExtendSelectionDown=function(e,t){return this._handleFocusKey(e,t,this.keyCodes.DOWN_KEY,!0,!1)},A.prototype._handleSortKey=function(e,t){return"true"===t.getAttribute(this.getResources().getMappedAttribute("sortable"))?(this._handleKeyboardSort(t,e),!0):this._handleActionable(e,t)},A.prototype._handleExpandKey=function(e,t){return!!this._isHeaderCollapsed(t)&&(this._handleExpandCollapseRequest(e),!0)},A.prototype._handleCollapseKey=function(e,t){return!!this._isHeaderExpanded(t)&&(this._handleExpandCollapseRequest(e),!0)},A.prototype._handleNoOp=function(e,t){return!1},A.prototype._handleFilterKey=function(e){return this._handleHeaderFilter(e,"column"),!0},A.prototype._handleEditableTab=function(e,t){var i=_.getFocusableElementsInNode(t);return!(i&&i.indexOf(document.activeElement)<i.length-1)&&this._handleFocusRight(e,t)},A.prototype._handleEditablePrevTab=function(e,t){var i=_.getFocusableElementsInNode(t);return!(i&&i.indexOf(document.activeElement)>0)&&this._handleFocusLeft(e,t)},A.RESIZE_OFFSET=5,A.RESIZE_TOUCH_OFFSET=8,A.prototype.handleResize=function(e){if(!1===this.m_isResizing){var t=this.find(e.target,"header"),i=this.find(e.target,"headerlabel");if(null==t&&(t=this.find(e.target,"endheader")),null!=t&&(t===this.m_rowHeader||t===this.m_colHeader||t===this.m_rowEndHeader||t===this.m_colEndHeader||t===this.m_colHeaderFrozen||t===this.m_colEndHeaderFrozen||t===this.m_rowHeaderFrozen||t===this.m_rowEndHeaderFrozen)||null!=i){let s=!1;i&&(s=!0),this.m_cursor=this.manageHeaderCursor(e,s),null!=this.m_resizingElement&&("default"===this.m_cursor?(this.m_resizingElement.style.cursor="",this._isSelectionEnabled()&&(t&&this.shouldHoverHeader(t)||i)&&this.m_utils.addCSSClassName(e.target,this.getMappedStyle("hover")),null!=this.m_resizingElementSibling&&(this.m_resizingElementSibling.style.cursor="")):(this.m_resizingElement.style.cursor=this.m_cursor,this.m_utils.removeCSSClassName(e.target,this.getMappedStyle("hover")),null!=this.m_resizingElementSibling&&(this.m_resizingElementSibling.style.cursor=this.m_cursor)))}}else this.handleResizeMouseMove(e)},A.prototype.handleResizeMouseDown=function(e){return("col-resize"===this.m_cursor||"row-resize"===this.m_cursor)&&(this.m_isResizing=!0,this.m_utils.isTouchDevice()?(this.m_lastMouseX=e.touches[0].pageX,this.m_lastMouseY=e.touches[0].pageY):(document.addEventListener("mousemove",this.m_docMouseMoveListener,!1),document.addEventListener("mouseup",this.m_docMouseUpListener,!1),this.m_lastMouseX=e.pageX,this.m_lastMouseY=e.pageY),this.m_overResizeLeft=0,this.m_overResizeMinLeft=0,this.m_overResizeTop=0,this.m_overResizeMinTop=0,this.m_overResizeRight=0,this.m_overResizeBottom=0,this.m_orginalResizeDimensions={width:this.getElementWidth(this.m_resizingElement),height:this.getElementHeight(this.m_resizingElement)},!0)},A.prototype._resizeSelectedHeaders=function(e,t,i,s,n,o){let r=this.m_resizingElement,l=this.getHeaderCellAxis(this.m_resizingElement),a=this._getResizeHeaderMode(this.m_resizingElement),h=this.getHeaderCellLevel(this.m_resizingElement),d=!1;("column"===l&&h===this.m_columnHeaderLevelCount-1||"row"===l&&h===this.m_rowHeaderLevelCount-1||"columnEnd"===l&&h===this.m_columnEndHeaderLevelCount-1||"rowEnd"===l&&h===this.m_rowEndHeaderLevelCount-1)&&(d=!0);const m=new Set,c=this.m_resizingElement[this.getResources().getMappedAttribute("context")],u=this._getSelectionAxis(l);this.m_selection&&this.m_selection.length&&d&&!this.m_discontiguousSelection&&this._isHeaderSelected(c,u)&&this.m_selection.forEach(e=>{this._getHeadersWithinSelection(e,e.startIndex[u],l).forEach(e=>m.add(e))}),0!==m.size?m.forEach(l=>{let h=l[this.getResources().getMappedAttribute("context")],d=h.index,m=h.key,c="column"===a?s:n,u="column"===a?"width":"height";if(r!==l){this.m_resizingElement=l;let e=this.getElementDir(l,u);this.isHidden(a,d)&&(this.m_sizingManager.setSize(a,m,c),c=0),"column"===a?this.resizeColWidth(e,c):this.resizeRowHeight(e,c)}this._fireResizeEvent(e,t,i,s,n,o)}):("column"===a?this.resizeColWidth(this.getElementDir(this.m_resizingElement,"width"),s):this.resizeRowHeight(this.getElementDir(this.m_resizingElement,"height"),n),this._fireResizeEvent(e,t,i,s,n,o)),this._fireCellResizeEvent(e,t,i,s,n,m)},A.prototype._getSelectionAxis=function(e){let t=e;return"rowEnd"===t?t="row":"columnEnd"===t&&(t="column"),t},A.prototype._fireCellResizeEvent=function(e,t,i,s,n,o){const r={event:e,ui:{}};let l;const a=this._getResizeHeaderMode(this.m_resizingElement),h=this.getHeaderCellIndex(this.m_resizingElement),d=this.getHeaderCellLevel(this.m_resizingElement),m=this.getHeaderCellAxis(this.m_resizingElement),c=this.find(this.m_resizingElement,"headerlabel"),u=this.m_resizingElement[this.getResources().getMappedAttribute("context")];let _=!1;if(("column"===m&&d===this.m_columnHeaderLevelCount-1||"row"===m&&d===this.m_rowHeaderLevelCount-1||"columnEnd"===m&&d===this.m_columnEndHeaderLevelCount-1||"rowEnd"===m&&d===this.m_rowEndHeaderLevelCount-1)&&(_=!0),s!==t){if("column"!==a&&"columnEnd"!==a||c)if(c){l=this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("rowendheaderlabel"))?"rowEndHeaderWidth":"rowHeaderWidth",r.ui.levels=[a.includes("row")?u.level:this.m_rowHeaderLevelCount-1],r.ui.size=s}else{let e=this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("rowendheadercell"));l=e?"rowEndHeaderWidth":"rowHeaderWidth",r.ui.levels=[u.level+u.depth-1],r.ui.size=e?this.m_rowEndHeaderLevelWidths[u.level+u.depth-1]:this.m_rowHeaderLevelWidths[u.level+u.depth-1]}else l="columnWidth",r.ui.size=this.getElementWidth(this._getHeaderByIndex(h+u.extent-1,"column",this.m_columnHeaderLevelCount-1));r.ui.dimension=l}else{if(n===i)return;if("row"!==a&&"rowEnd"!==a||c)if(c){l=this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("columnendheaderlabel"))?"columnEndHeaderHeight":"columnHeaderHeight",r.ui.levels=[a.includes("column")?u.level:this.m_columnHeaderLevelCount-1],r.ui.size=n}else{let e=this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("colendheadercell"));l=e?"columnEndHeaderHeight":"columnHeaderHeight",r.ui.levels=[u.level+u.depth-1],r.ui.size=e?this.m_columnEndHeaderLevelHeights[u.level+u.depth-1]:this.m_columnHeaderLevelHeights[u.level+u.depth-1]}else l="rowHeight",r.ui.size=this.getElementHeight(this._getHeaderByIndex(h+u.extent-1,"row",this.m_rowHeaderLevelCount-1));r.ui.dimension=l}const p=this._getSelectionAxis(m);if(this.m_selection&&this.m_selection.length&&_&&!this.m_discontiguousSelection&&("rowHeight"===l||"columnWidth"===l)){const e=[];this._isHeaderSelected(u,p)?o.forEach(t=>{const i=t[this.getResources().getMappedAttribute("context")];e.push(this.getHeaderCellIndex(t)+i.extent-1)}):e.push(h+u.extent-1),r.ui.indices=e}else"rowHeight"!==l&&"columnWidth"!==l||(r.ui.indices=[],r.ui.indices.push(h+u.extent-1));this.fireEvent("cellResize",r)},A.prototype._fireResizeEvent=function(e,t,i,s,n,o){let r={event:e,ui:{header:this._getKey(this.m_resizingElement),oldDimensions:{width:t,height:i},newDimensions:{width:s,height:n},size:o}};this.fireEvent("resize",r)},A.prototype.handleResizeMouseUp=function(e){if(!0===this.m_isResizing){var t=this.getElementWidth(this.m_resizingElement),i=this.getElementHeight(this.m_resizingElement);let s=this.m_orginalResizeDimensions.width,n=this.m_orginalResizeDimensions.height,o=this.m_resizingElement,r="col-resize"===this.m_cursor?o.style.width:o.style.height;t===this.m_orginalResizeDimensions.width&&i===this.m_orginalResizeDimensions.height||"col-resize"!==this.m_cursor&&"row-resize"!==this.m_cursor||this._resizeSelectedHeaders(e,s,n,t,i,r),o.style.cursor="",this._unhighlightResizeBorderColor(),this.m_isResizing=!1,this.m_cursor="default",null!=this.m_resizingElementSibling&&(this.m_resizingElementSibling.style.cursor=""),this.m_resizingElement=null,this.m_resizingElementMin=null,this.m_resizingElementSibling=null,this.m_orginalResizeDimensions=null,document.removeEventListener("mousemove",this.m_docMouseMoveListener,!1),document.removeEventListener("mouseup",this.m_docMouseUpListener,!1)}},A.prototype._isDOMElementResizable=function(e){return null!=e&&"true"===e.getAttribute(this.getResources().getMappedAttribute("resizable"))},A.prototype.manageHeaderCursor=function(e,t){var i,s,n,o,r,l,a,h,d;if((d=t?this.find(e.target,"headerlabel"):this.find(e.target,"headercell"))||t||(d=this.find(e.target,"endheadercell")),!d)return"default";var m=t?this.getHeaderLabelAxis(d):this.getHeaderCellAxis(d),c=t?this.getHeaderLabelLevel(d):this.getHeaderCellIndex(d),u=t?c:this.getHeaderCellLevel(d);if("column"===m)if(r="enable"===this.m_options.isResizable(m,"height"),o=this._isDOMElementResizable(d),t)a=null,l=null,h=this.m_headerLabels.column[c-1];else{let e=this.getVisibleCellIndexInDirection("column",c-1,{left:!0});(a=this._getHeaderByIndex(e,"column",u))||(this.m_headerLabels.column.length?(a=this._getLabel("column",u),u===this.m_columnHeaderLevelCount-1&&this._isHeaderLabelCollision()&&(a=this.m_headerLabels.row[this.m_rowHeaderLevelCount-1])):a=this._getLabel("row",u)),l=this._isDOMElementResizable(a),h=this._getHeaderByIndex(c,"column",u-1)}else if("row"===m)o="enable"===this.m_options.isResizable(m,"width"),r=t?"enable"===this.m_options.isResizable(m,"height"):this._isDOMElementResizable(d),t?(h=this.m_headerLabels.row[c-1],this._isHeaderLabelCollision()&&d===this.m_headerLabels.row[this.m_rowHeaderLevelCount-1]&&(a=this.m_headerLabels.column[this.m_columnHeaderLevelCount-1])):(a=this._getHeaderByIndex(c-1,"row",u),l=this._isDOMElementResizable(a),h=this._getHeaderByIndex(c,"row",u-1));else if("columnEnd"===m)if(r="enable"===this.m_options.isResizable(m).height,o=this._isDOMElementResizable(d),t)a=null,l=null,h=this.m_headerLabels.columnEnd[c-1];else{let e=this.getVisibleCellIndexInDirection("column",c-1,{left:!0});(a=this._getHeaderByIndex(e,"columnEnd",u))||(a=this._getLabel("columnEnd",u)),l=this._isDOMElementResizable(a),h=this._getHeaderByIndex(c,"columnEnd",u-1)}else"rowEnd"===m&&(o="enable"===this.m_options.isResizable(m).width,r=this._isDOMElementResizable(d),t?(a=this.m_headerLabels.rowEnd[c-1],l=this._isDOMElementResizable(a)):(a=this._getHeaderByIndex(c-1,"rowEnd",u),l=this._isDOMElementResizable(a),h=this._getHeaderByIndex(c,"rowEnd",u-1)));if(this.m_utils.isTouchDevice())i=e.touches[0].pageX,s=e.touches[0].pageY,n=A.RESIZE_TOUCH_OFFSET;else{i=e.offsetX,s=e.offsetY,n=A.RESIZE_OFFSET;var _=this._findHeaderOffset(e.target,d);i+=_[0],s+=_[1]}var p=this.getHeaderEdgePixels(d),g=this.getResources().isRTLMode(),f="columnEnd"===m||"rowEnd"===m,C=i<p[0]+n,y=s<p[1]+n,E=i>p[2]-n,v=s>p[3]-n;if("column"===m||"columnEnd"===m){if(o&&(g?C:E))return this.m_resizingElement=d,"col-resize";if(l&&(g?E:C)){if(this.m_resizingElement=a,this.m_resizingElementSibling=d,null!==this.m_resizingElement)return"col-resize"}else if(r){if(!f&&v||f&&y)return this.m_resizingElement=d,"row-resize";if((!f&&y||f&&v)&&0!==u)return this.m_resizingElement=h,this.m_resizingElementSibling=d,"row-resize"}}else if("row"===m||"rowEnd"===m){if(r&&v)return this.m_resizingElement=d,"row-resize";if(l&&y&&!t){if(this.m_resizingElement=a,this.m_resizingElementSibling=d,null!==this.m_resizingElement)return"row-resize"}else if(h&&y&&t&&a&&(this.m_resizingElement=h,this.m_resizingElementSibling=d,null!==this.m_resizingElement))return"row-resize";if(o){if(!f&&(g?C:E)||f&&(g?E:C))return this.m_resizingElement=d,"col-resize";if((!f&&(g?E:C)||f&&(g?C:E))&&0!==u&&(this.m_resizingElement=h,this.m_resizingElementSibling=d,null!==this.m_resizingElement))return"col-resize"}}return"default"},A.prototype.handleResizeMouseMove=function(e){var t,i,s,n,o;this.m_currentMouseX=e.pageX,this.m_currentMouseY=e.pageY,this.m_utils.isTouchDevice()?(this.m_currentMouseX=e.touches[0].pageX,this.m_currentMouseY=e.touches[0].pageY):(this.m_currentMouseX=e.pageX,this.m_currentMouseY=e.pageY),t=this._getResizeHeaderMode(this.m_resizingElement);var r=this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("endheadercell"))||this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("columnendheaderlabel"));let l=this.find(this.m_resizingElement,"headerlabel");"col-resize"===this.m_cursor?"column"===t?(r=!l&&r,i=this.getElementWidth(this.m_resizingElement),s=this.getNewElementWidth("column",i,r,null,l),l?this.resizeRowWidth(s,s-i,r,l):this.resizeColWidth(i,s)):"row"===t&&(this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("rowendheaderlabel"))&&(r=!0),i=this.getElementWidth(this.m_resizingElement),s=this.getNewElementWidth("row",i,r,null,l),this.resizeRowWidth(s,s-i,r,l)):"row-resize"===this.m_cursor&&("row"===t?(n=this.getElementHeight(this.m_resizingElement),o=this.getNewElementHeight("row",n,r,null,l),l?this.resizeColHeight(o,o-n,r):this.resizeRowHeight(n,o)):"column"===t&&(n=this.getElementHeight(this.m_resizingElement),o=this.getNewElementHeight("column",n,r,null,l),this.resizeColHeight(o,o-n,r))),this.buildCorners(),this.m_utils.isTouchDevice()&&this._moveTouchSelectionAffordance(),this.m_lastMouseX=this.m_currentMouseX,this.m_lastMouseY=this.m_currentMouseY},A.prototype.resizeColWidth=function(e,t){var i,s=t-e;const n=this.getResources().isRTLMode()?"right":"left";if(0!==s){let e=!1;if(this.m_resizingElement.classList.contains(this.getMappedStyle("frozenHeader"))&&(e=!0),null==this.m_databody.firstChild||e){if(e&&this.m_databodyFrozenCol){let e=this.getElementWidth(this.m_databodyFrozenCol),t=this.getElementDir(this.m_databodyFrozenCol,n);if(-1!==this.m_endRowEndHeader){let i=this.getElementDir(this.m_rowEndHeader,n);s=t+e+s>i?i-(t+e):s}i=e+s,this.setElementWidth(this.m_databodyFrozenCol,i),this.setElementWidth(this.m_databodyFrozenCol,i),this.m_databodyFrozenCorner&&(this.setElementWidth(this.m_databodyFrozenCorner,i),this.setElementWidth(this.m_databodyFrozenCorner,i))}}else{i=this.getElementWidth(this.m_databody.firstChild)+s,this.setElementWidth(this.m_databody.firstChild,i),this.m_databodyFrozenRow&&this.setElementWidth(this.m_databodyFrozenRow.firstChild,i)}this.resizeColumnWidthAndShift(s),this.deleteAndApplyHiddenIndicators(),e||(this.m_endColPixel+=s,this.m_endColHeaderPixel+=s,this.m_endColEndHeaderPixel+=s,null!=i&&(this.m_avgColWidth=i/this.getDataSource().getCount("column"))),this.manageResizeScrollbars()}},A.prototype.resizeRowHeight=function(e,t){var i,s=t-e;if(0!==s){let e=!1;if(this.m_resizingElement.classList.contains(this.getMappedStyle("frozenHeader"))&&(e=!0),null==this.m_databody.firstChild||e){if(e&&this.m_databodyFrozenRow){let e=this.getElementHeight(this.m_databodyFrozenRow),t=this.getElementDir(this.m_databodyFrozenRow,"top");if(-1!==this.m_endColEndHeader){let i=this.getElementDir(this.m_colEndHeader,"top");s=t+e+s>i?i-(t+e):s}i=e+s,this.setElementHeight(this.m_databodyFrozenRow,i),this.setElementHeight(this.m_databodyFrozenRow,i),this.m_databodyFrozenCorner&&(this.setElementHeight(this.m_databodyFrozenCorner,i),this.setElementHeight(this.m_databodyFrozenCorner,i))}}else{i=this.getElementHeight(this.m_databody.firstChild)+s,this.setElementHeight(this.m_databody.firstChild,i)}this.resizeRowHeightAndShift(s),this.deleteAndApplyHiddenIndicators(),e||(this.m_endRowPixel+=s,this.m_endRowHeaderPixel+=s,this.m_endRowEndHeaderPixel+=s,null!=i&&(this.m_avgRowHeight=i/this.getDataSource().getCount("row"))),this.manageResizeScrollbars()}},A.prototype.resizeColHeight=function(e,t,i){if(0!==t){var s,n,o,r=!0,l=this.find(this.m_resizingElement,"headerlabel");if(l?"column"===(o=this.getHeaderLabelAxis(this.m_resizingElement))||"columnEnd"===o?n=this.getHeaderLabelLevel(this.m_resizingElement):"row"!==o&&"rowEnd"!==o||(n=this.m_columnHeaderLevelCount-1,r=!1):(n=this.getHeaderCellLevel(this.m_resizingElement)+(this.getHeaderCellDepth(this.m_resizingElement)-1),o=this.getHeaderCellAxis(this.m_resizingElement)),i?this.m_columnEndHeaderLevelHeights[n]+=t:(s=this.m_columnHeaderLevelHeights[n],this.m_columnHeaderLevelHeights[n]+=t),!i&&n===this.m_columnHeaderLevelCount-1&&this.m_headerLabels.row.length&&this._isHeaderLabelCollision()&&(r=!1),this.resizeColumnHeightsAndShift(t,n,i,r),i)this.m_colEndHeaderHeight+=t,this.setElementHeight(this.m_colEndHeader,this.m_colEndHeaderHeight),this.m_colEndHeaderFrozen&&this.setElementHeight(this.m_colEndHeaderFrozen,this.m_colEndHeaderHeight);else{if(this.m_colHeaderHeight+=t,this.setElementHeight(this.m_colHeader,this.m_colHeaderHeight),this.m_colHeaderFrozen&&this.setElementHeight(this.m_colHeaderFrozen,this.m_colHeaderHeight),0===this.m_headerLabels.column.length&&-1!==n)this._resizeHeaderLabelDirs(n,t,["row"],"height");else if(null!=this.m_columnHeaderLevelCount&&n===this.m_columnHeaderLevelCount-1)if(this.m_headerLabels.row.length){var a,h;if(l){if("column"===o)h=e,this.m_collisionResize=!0;else if("row"===o)a=t,this.m_collisionResize=!0;else if("rowEnd"===o)if(this._isHeaderLabelCollision()){let e=0;for(let t=0;t<this.m_columnHeaderLevelCount-1;t++)e+=this.getElementHeight(this.m_headerLabels.column[t]);let t=this.m_colHeaderHeight-e,i=this._calculateCollisionDimension(t,s,l,o);a=i.rowHeightChange,h=i.colHeight}else a=t,h=this.m_colHeaderHeight}else if(this._isHeaderLabelCollision()){let t=this._calculateCollisionDimension(e,s,!0,o);a=t.rowHeightChange,h=t.colHeight}else a=t,h=e;var d=this._getLabel("column",this.m_columnHeaderLevelCount-1);d&&this.setElementHeight(d,h),this._resizeHeaderLabelDirs(this.m_rowHeaderLevelCount-1,a,["row"],"height")}else{let t=["bottomResized"],i=this._getLabel("column",this.m_columnHeaderLevelCount-1);this._highlightElement(i.parentNode,t);let s=0;if("rowEnd"===o)for(let e=0;e<this.m_columnHeaderLevelCount-1;e++)s+=this.getElementHeight(this.m_headerLabels.column[e]);let n=e-s;this.setElementHeight(i,n)}else if(n<0){let t=this._getLabel("row",this.m_rowHeaderLevelCount-1),i=["bottomResized"];if(t&&n<0){this._highlightElement(t.parentNode,i);for(let i=0;i<this.m_rowHeaderLevelCount;i++)t=this._getLabel("row",i),this.setElementHeight(t,e)}}let i=this._getLabel("rowEnd",this.m_rowEndHeaderLevelCount-1),r=["bottomResized"];if(i){let t=-1===this.m_endColHeader?e:this.m_colHeaderHeight;this._highlightElement(i.parentNode,r);for(let e=0;e<this.m_rowEndHeaderLevelCount;e++)i=this._getLabel("rowEnd",e),this.setElementHeight(i,t)}}this.deleteAndApplyHiddenIndicators(),this.manageResizeScrollbars()}},A.prototype._calculateCollisionDimension=function(e,t,i,s){let n,o,r={},l=this._getMinValue("height",s,i);if(this.m_collisionResize){let r=this.getElementDir(this.m_headerLabels.row[this.m_rowHeaderLevelCount-1],"height"),a=this.getElementDir(this.m_headerLabels.column[this.m_columnHeaderLevelCount-1],"height"),h=r+a,d=a/h,m=r/h;r===l&&a===l?(n=Math.floor(e/2)-Math.floor(t/2),o=Math.ceil(e/2),this.m_collisionResize=!1):d>m?(o=Math.floor(e*d),n=e-o-r,r+n<this._getMinValue("height",s,i)&&(n=0)):(n=Math.floor(e*m)-r,r+n<this._getMinValue("height",s,i)&&(n=0),o=e-(r+n),o=Math.max(o,this._getMinValue("height",s,i)))}else n=Math.floor(e/2)-Math.floor(t/2),o=Math.ceil(e/2);return r.colHeight=o,r.rowHeightChange=n,r},A.prototype.resizeRowWidth=function(e,t,i,s){if(0!==t){var n;if(s){let e=this.getHeaderLabelAxis(this.m_resizingElement);"column"===e||"columnEnd"===e?n=this.m_rowHeaderLevelCount-1:"row"!==e&&"rowEnd"!==e||(n=this.getHeaderLabelLevel(this.m_resizingElement))}else n=this.getHeaderCellLevel(this.m_resizingElement)+(this.getHeaderCellDepth(this.m_resizingElement)-1);if(i?this.m_rowEndHeaderLevelWidths[n]+=t:this.m_rowHeaderLevelWidths[n]+=t,this.resizeRowWidthsAndShift(t,n,i),i)this.m_rowEndHeaderWidth+=t,this.setElementWidth(this.m_rowEndHeader,this.m_rowEndHeaderWidth),this.m_rowEndHeaderFrozen&&this.setElementWidth(this.m_rowEndHeaderFrozen,this.m_rowEndHeaderWidth);else{if(this.m_rowHeaderWidth+=t,n<0){let t=this.getResources().isRTLMode()?["startResized"]:["endResized"],i=this._getLabel("column",this.m_columnHeaderLevelCount-1);this._highlightElement(i.parentNode,t);for(let t=0;t<this.m_columnHeaderLevelCount;t++)i=this._getLabel("column",t),this.setElementWidth(i,e)}else this.setElementWidth(this.m_rowHeader,this.m_rowHeaderWidth),this.m_rowHeaderFrozen&&this.setElementWidth(this.m_rowHeaderFrozen,this.m_rowHeaderWidth),(n===this.m_rowHeaderLevelCount-1||0===this.m_headerLabels.row.length&&this.m_headerLabels.column.length)&&this._resizeHeaderLabelDirs(n,t,["column"],"width");let i=this._getLabel("columnEnd",this.m_columnEndHeaderLevelCount-1),s=this.getResources().isRTLMode()?["startResized"]:["endResized"];if(i){this._highlightElement(i.parentNode,s);let e=this.getElementWidth(i)+t;for(let t=0;t<this.m_columnEndHeaderLevelCount;t++)i=this._getLabel("columnEnd",t),this.setElementWidth(i,e)}}this.deleteAndApplyHiddenIndicators(),this.manageResizeScrollbars()}},A.prototype._resizeHeaderLabelDirs=function(e,t,i,s){for(var n=0;n<i.length;n++){for(var o=i[n],r=0;r<this.m_headerLabels[o].length;r++){var l=this.m_headerLabels[o][r];if(null!=l){var a=this.getElementDir(l,s)+t;this.setElementDir(l,a,s)}}this._highlightResizeLabelDirs(o,e)}},A.prototype._highlightResizeLabelDirs=function(e,t){let i=this.getResources().isRTLMode()?["startResized"]:["endResized"],s="column"===e?i:["bottomResized"];this.m_corner&&("column"===e&&t===this.m_columnHeaderLevelCount-1||"row"===e&&t===this.m_rowHeaderLevelCount-1)&&this._highlightElement(this.m_corner,s);let n=this._getLabel("rowEnd",this.m_columnHeaderLevelCount-1);n&&this._highlightElement(n.parentNode,s)},A.prototype._unhighlightResizeBorderColor=function(){let e=this.m_root.querySelectorAll(".oj-datagrid-resized-start,\n    .oj-datagrid-resized-end, .oj-datagrid-resized-top, .oj-datagrid-resized-bottom");this._unhighlightElementsByClassName(e,["startResized","endResized","topResized","bottomResized"])},A.prototype.getNewElementWidth=function(e,t,i,s,n){const o=this._getResizeMinWidth(e,this.m_resizingElement,n,!1);null==s&&(s=this.getResources().isRTLMode()?this.m_lastMouseX-this.m_currentMouseX:this.m_currentMouseX-this.m_lastMouseX),i&&"row"===e&&(s*=-1);var r=t+s+this.m_overResizeLeft+this.m_overResizeMinLeft+this.m_overResizeRight;if(r<o?(this.m_overResizeMinLeft+=s-o+t,r=o):(this.m_overResizeMinLeft=0,this.m_overResizeLeft=0),"row"===e){const e=this._getResizeMaxWidth(t);r>e?(this.m_overResizeRight+=s-e+t,r=e):this.m_overResizeRight=0}return r},A.prototype._getResizeMinWidth=function(e,t,i,s){return this._getMinValue("width",e,i,s,t)},A.prototype._getResizeMaxWidth=function(e){const t=this.getRowHeaderWidth()+this.getRowEndHeaderWidth()-e;return Math.round(this.getWidth()-this.m_utils.getScrollbarSize()-1)-t},A.prototype.getNewElementHeight=function(e,t,i,s,n){const o=this._getResizeMinHeight(e,this.m_resizingElement,n,!1,i);null==s&&(s=this.m_currentMouseY-this.m_lastMouseY),i&&"column"===e&&(s*=-1);var r=t+s+this.m_overResizeTop+this.m_overResizeMinTop+this.m_overResizeBottom;if(r<o?(this.m_overResizeMinTop+=s-o+t,r=o):(this.m_overResizeMinTop=0,this.m_overResizeTop=0),"column"===e){const e=this._getResizeMaxHeight(t);r>e?(this.m_overResizeBottom+=s-e+t,r=e):this.m_overResizeBottom=0}return r},A.prototype._getResizeMaxHeight=function(e){var t=this.getColumnHeaderHeight()+this.getColumnEndHeaderHeight()-e;return Math.round(this.getHeight()-this.m_utils.getScrollbarSize()-1)-t},A.prototype._getResizeMinHeight=function(e,t,i,s,n){let o=0;const r=this._getMinValue("height",e,!0,s,t);if(i){if(o=r,"rowEnd"===this.getHeaderLabelAxis(t)&&this.m_headerLabels.column&&this.m_headerLabels.column.length){this._isHeaderLabelCollision()&&(o=2*r);for(let e=0;e<this.m_columnHeaderLevelCount-1;e++)o+=this.getElementHeight(this.m_headerLabels.column[e])}}else o=this._getMinValue("height",e,i,s,t);return"column"===e&&!n&&this.getHeaderCellLevel(t)+this.getHeaderCellDepth(t)===this.m_columnHeaderLevelCount&&this._isHeaderLabelCollision()&&(o=2*r),o},A.prototype._getMinValue=function(e,t,i,s,n=this.m_resizingElement){var o,r,l=this._getCellPaddingBorder(e,n),a=l;if(i||s)return Math.max(this.m_utils.isTouchDevice()?2*A.RESIZE_TOUCH_OFFSET:2*A.RESIZE_OFFSET,a);var h=this.getHeaderCellLevel(n),d=this.getHeaderCellDepth(n),m=this.getResources().getMappedAttribute("sortable");"true"===n.getAttribute(m)&&this._setSortContainerSize(this._getSortContainer(n),l),"column"===t&&"true"===n.getAttribute(m)&&(a="width"===e?this.m_sortContainerWidth:this.m_sortContainerHeight);var c=Math.max(this.m_utils.isTouchDevice()?2*A.RESIZE_TOUCH_OFFSET:2*A.RESIZE_OFFSET,a);if("column"===t&&(1===this.m_columnHeaderLevelCount||"width"===e&&this.m_columnHeaderLevelCount===h+1||"height"===e&&1===d)||"row"===t&&-1===this.m_endRowHeader||"column"===t&&-1===this.m_endColHeader||"row"===t&&(1===this.m_rowHeaderLevelCount||"height"===e&&this.m_rowHeaderLevelCount===h+1||"width"===e&&1===d))return c;var u=this.getHeaderCellIndex(n),_=this._getAttribute(n.parentNode,"extent",!0),p=this.getElementDir(n,e);if("column"===t)if("width"===e){let i=u+(_-1);for(;this.isHidden("column",i);)i-=1;o=this._getHeaderByIndex(i,t,this.m_columnHeaderLevelCount-1),r=this.getElementDir(o,e)}else r=this._getHeaderLevelDimension(h+(d-1),n,this.m_columnHeaderLevelHeights,"height",1);else"row"===t&&("height"===e?(o=this._getHeaderByIndex(u+(_-1),t,this.m_rowHeaderLevelCount-1),r=this.getElementDir(o,e)):r=this._getHeaderLevelDimension(h+(d-1),n,this.m_rowHeaderLevelWidths,"width",1));return p-(r-c)},A.prototype._getLabelMinValue=function(e){var t=this.m_resizingElement,i=this._getCellPaddingBorder(e,t);return Math.max(this.m_utils.isTouchDevice()?2*A.RESIZE_TOUCH_OFFSET:2*A.RESIZE_OFFSET,i)},A.prototype._setSortContainerSize=function(e,t){this.m_sortContainerWidth=this.getElementWidth(e)+t,this.m_sortContainerHeight=this.getElementHeight(e)},A.prototype._getCellPaddingBorder=function(e,t){if(null==this.m_resizingElementMin){for(var i=["top","right","bottom","left"],s="width"===e?1:0,n=0,o=window.getComputedStyle(t);s<4;s+=2)n+=parseFloat(o.getPropertyValue("padding-"+i[s])),n+=parseFloat(o.getPropertyValue("border-"+i[s]+"-width"));this.m_resizingElementMin=Math.round(n)}return this.m_resizingElementMin},A.prototype.manageResizeScrollbars=function(){var e=this.getWidth(),t=this.getHeight(),i=this.m_colHeader,s=this.m_colEndHeader,n=this.m_rowHeader,o=this.m_rowEndHeader,r=this.m_databody,l=r.firstChild;const a=this.m_databodyFrozenCol,h=this.m_databodyFrozenRow;let d=0,m=0;var c=this.getColumnHeaderHeight(),u=this.getColumnEndHeaderHeight(),_=this.getRowHeaderWidth(),p=this.getRowEndHeaderWidth();if(a&&(d=this.getElementWidth(a)),h&&(m=this.getElementHeight(h)),-1===this.m_endRowHeader&&-1!==this.m_endColHeader){let e=this._getLabel("column",this.m_columnHeaderLevelCount-1);e&&(_=this.getElementWidth(e))}else if(-1!==this.m_endRowHeader&&-1===this.m_endColHeader){let e=this._getLabel("row",this.m_rowHeaderLevelCount-1);e&&(c=this.getElementHeight(e))}var g,f=t-c-u-m,C=e-_-p-d,y=this.m_utils.getScrollbarSize(),E=this.getResources().isRTLMode()?"right":"left";if(this._databodyEmpty())if(null==this.m_empty){g=this._buildEmptyText();var v=this.getElementHeight(g),w=this.getElementWidth(g);v>this.getElementHeight(l)&&this.setElementHeight(l,v),w>this.getElementWidth(l)&&this.setElementWidth(l,w),this.m_databody.firstChild.appendChild(g)}else g=this.m_empty,this.setElementDir(g,this.m_endColHeader>=0?c:0,"top");var b,H,x,S,R,I=this.getElementWidth(r.firstChild),M=this.getElementHeight(r.firstChild),F=this.isDatabodyHorizontalScrollbarRequired(C);F?(b=this.isDatabodyVerticalScrollbarRequired(f-y),r.style.overflow="auto"):(b=this.isDatabodyVerticalScrollbarRequired(f))?(F=this.isDatabodyHorizontalScrollbarRequired(C-y),r.style.overflow="auto"):r.style.overflow="hidden",this.m_hasHorizontalScroller=F,this.m_hasVerticalScroller=b,-1!==this.m_endColEndHeader?(H=Math.min(M+(F?y:0),f),x=F?H-y:H):(H=f,x=Math.min(M,F?H-y:H)),-1!==this.m_endRowEndHeader?(S=Math.min(I+(b?y:0),C),R=b?S-y:S):(S=C,R=Math.min(I,b?S-y:S));var z=_+R+d+(b?y:0),D=c+x+m+(F?y:0);if(this.setElementDir(n,0,E),this.setElementDir(n,c,"top"),this.setElementHeight(n,x),this.setElementDir(o,z,E),this.setElementDir(o,c,"top"),this.setElementHeight(o,x),this.setElementDir(i,_,E),this.setElementWidth(i,R),this.setElementDir(s,_,E),this.setElementDir(s,D,"top"),this.setElementWidth(s,R),[_,c]=this._setFrozenContainerDimension(S,H,_,p,c,u),this.setElementDir(r,c,"top"),this.setElementDir(r,_,E),this.setElementWidth(r,S),this.setElementHeight(r,H),-1===this.m_endRowHeader&&-1!==this.m_endColHeader&&this.m_rowHeaderScrollbarSpacer?(this.setElementDir(this.m_rowHeaderScrollbarSpacer,c,"top"),this.setElementHeight(this.m_rowHeaderScrollbarSpacer,H+u),this.setElementWidth(this.m_rowHeaderScrollbarSpacer,_)):-1!==this.m_endRowHeader&&-1===this.m_endColHeader&&this.m_columnHeaderScrollbarSpacer&&(this.setElementDir(this.m_columnHeaderScrollbarSpacer,_,"left"),this.setElementWidth(this.m_columnHeaderScrollbarSpacer,S+p),this.setElementHeight(this.m_columnHeaderScrollbarSpacer,c)),this.m_scrollWidth=I-R,this.m_scrollHeight=M-x,this.buildCorners(),this._adjustHeaderBorders(),this._updateGridlines(),this.m_utils.isTouchDevice()){var A=0,L=0;if(this.m_currentScrollLeft>this.m_scrollWidth&&(A=this.m_scrollWidth-this.m_currentScrollLeft),this.m_currentScrollTop>this.m_scrollHeight&&(L=this.m_scrollHeight-this.m_currentScrollTop),0!==A||0!==L){this.m_utils.isTouchDeviceNotIOS()&&this._disableTouchScrollAnimation();var T=this.adjustTouchScroll(A,L);A=T[0],L=T[1],this.scrollDelta(A,L)}}},A.prototype.resizeColumnWidthAndShift=function(e){var t=this.getResources().isRTLMode()?"right":"left",i=this.m_colHeader.style.display,s=this.m_colEndHeader.style.display;let n=this.m_resizingElement.classList.contains(this.getMappedStyle("frozenHeader")),o=!1;n?(this.m_databodyFrozenCol.style.display="none",this.m_colHeaderFrozen.style.display="none",this.m_colEndHeaderFrozen.style.display="none",this.m_databodyFrozenCorner&&(this.m_databodyFrozenCorner.style.display="none",o=!0)):(this.m_databody.style.display="none",this.m_colHeader.style.display="none",this.m_colEndHeader.style.display="none",this.m_databodyFrozenRow&&(this.m_databodyFrozenRow.style.display="none"));var r=this.getHeaderCellIndex(this.m_resizingElement);if(this.m_columnHeaderLevelCount>1&&this.m_resizingElement===this.m_resizingElement.parentNode.firstChild&&null!=this.m_resizingElement.nextSibling)for(r+=this._getAttribute(this.m_resizingElement.parentNode,"extent",!0)-1;this.isHidden("column",r);)r-=1;var l,a=this.createIndex(-1,r),h=this.getElementsInRange(this.createRange(a,a));if(h)for(let e=0;e<h.length;e++)l=this.getResources().isRTLMode()?["startResized"]:["endResized"],this._highlightElement(h[e],l);let d=this.m_colHeader.firstChild,m=this.m_colEndHeader.firstChild;n&&(d=this.m_colHeaderFrozen.firstChild,m=this.m_colEndHeaderFrozen.firstChild),this._shiftHeadersAlongAxisInContainer(d,r,e,t,this.getMappedStyle("colheadercell"),"column"),this._shiftHeadersAlongAxisInContainer(m,r,e,t,this.getMappedStyle("colendheadercell"),"column"),n?this._shiftCellsAlongAxis("column",e,r,null,this.m_frozenColIndex,o):(this._shiftCellsAlongAxis("column",e,r),this.m_databodyFrozenRow&&this._shiftFrozenCellsAlongAxis("column",e,r,!1)),n?(this.m_databodyFrozenCol.style.display="",this.m_colHeaderFrozen.style.display=i,this.m_colEndHeaderFrozen.style.display=s,this.m_databodyFrozenCorner&&(this.m_databodyFrozenCorner.style.display="")):(this.m_databody.style.display="",this.m_colHeader.style.display=i,this.m_colEndHeader.style.display=s,this.m_databodyFrozenRow&&(this.m_databodyFrozenRow.style.display=""))},A.prototype._shiftCellsAlongAxis=function(e,t,i,s,n,o,r){var l,a,h,d,m=[];let c=n;if(null==s&&(s=!1),"row"===e?(l="height",a="top",void 0===c&&(c=this.m_endRow),h=null===this.m_frozenColIndex||-1===this.m_frozenColndex||o?this.m_startCol:this.m_frozenColIndex+1,d=this.m_endCol):(l="width",a=this.getResources().isRTLMode()?"right":"left",void 0===c&&(c=this.m_endCol),h=this._hasFrozenRows()&&!o?this.m_frozenRowIndex+1:this.m_startRow,d=this.m_endRow),null!=this.m_databody.firstChild)for(var u=h;u<=d;u++){var _="row"===e?this.createIndex(i,u):this.createIndex(u,i),p=this._getCellByIndex(_),g=p[this.getResources().getMappedAttribute("context")],f=g.indexes[e],C=g.extents[e],y=i-f,E=C-y;m[u]&&m[u][i]||!0===s||(this.setElementDir(p,this.getElementDir(p,l)+t,l),"row"===e?this._updateTempArray(m,!0,u,i,g.extents.column,C-y):this._updateTempArray(m,!0,u,i,g.extents.row,C-y),r&&(this.isHidden(e,i)?p.style.display="none":p.style.display=""));var v=i;!0!==s&&(v=i+E);for(var w=v;w<=c;w++)if(!m[u]||!m[u][w]){_="row"===e?this.createIndex(w,u):this.createIndex(u,w),C=(g=(p=this._getCellByIndex(_))[this.getResources().getMappedAttribute("context")]).extents[e];var b=this.getElementDir(p,a)+t;this.setElementDir(p,b,a),"row"===e?this._updateTempArray(m,!0,u,w,g.extents.column,C):this._updateTempArray(m,!0,u,w,g.extents.row,C)}}},A.prototype._shiftFrozenCellsAlongAxis=function(e,t,i,s,n){const o=[];let r,l,a,h,d;"row"===e?(r="top",l=this.m_endRow,a=this.m_startCol,h=this.m_frozenColIndex,d="height"):(r=this.getResources().isRTLMode()?"right":"left",l=this.m_endCol,a=this.m_startRow,h=this.m_frozenRowIndex,d="width");for(let m=a;m<=h;m++){let a="row"===e?this.createIndex(i,m):this.createIndex(m,i),h=this._getFrozenCellByIndex(a,e),c=h[this.getResources().getMappedAttribute("context")],u=c.extents[e],_=i-c.indexes[e],p=u-_;if(!(o[m]&&o[m][i]||!0===s)){this.setElementDir(h,this.getElementDir(h,d)+t,d),n&&(this.isHidden(e,i)?h.style.display="none":h.style.display="");const s="row"===e?"column":"row";this._updateTempArray(o,!0,m,i,c.extents[s],u-_)}let g=i;!0!==s&&(g=i+p);for(let i=g;i<=l;i++)if(!o[m]||!o[m][i]){a="row"===e?this.createIndex(i,m):this.createIndex(m,i),h=this._getFrozenCellByIndex(a,e),c=h[this.getResources().getMappedAttribute("context")],u=c.extents[e];let s=this.getElementDir(h,r)+t;this.setElementDir(h,s,r),"row"===e?this._updateTempArray(o,!0,m,i,c.extents.column,u):this._updateTempArray(o,!0,m,i,c.extents.row,u)}}},A.prototype.resizeRowHeightAndShift=function(e){var t=this.m_rowHeader.style.display,i=this.m_rowEndHeader.style.display;let s=this.m_resizingElement.classList.contains(this.getMappedStyle("frozenHeader")),n=!1;s?(this.m_databodyFrozenRow.style.display="none",this.m_rowHeaderFrozen.style.display="none",this.m_rowEndHeaderFrozen.style.display="none",this.m_databodyFrozenCorner&&(this.m_databodyFrozenCorner.style.display="none",n=!0)):(this.m_databody.style.display="none",this.m_rowHeader.style.display="none",this.m_rowEndHeader.style.display="none");var o=this.getHeaderCellIndex(this.m_resizingElement);this.m_rowHeaderLevelCount>1&&this.m_resizingElement===this.m_resizingElement.parentNode.firstChild&&null!=this.m_resizingElement.nextSibling&&(o+=this._getAttribute(this.m_resizingElement.parentNode,"extent",!0)-1);var r,l=this.createIndex(o,-1),a=this.getElementsInRange(this.createRange(l,l));if(a)for(let e=0;e<a.length;e++)r=["bottomResized"],this._highlightElement(a[e],r);let h=this.m_rowHeader.firstChild,d=this.m_rowEndHeader.firstChild;s&&(h=this.m_rowHeaderFrozen.firstChild,d=this.m_rowEndHeaderFrozen.firstChild),this._shiftHeadersAlongAxisInContainer(h,o,e,"top",this.getMappedStyle("rowheadercell"),"row"),this._shiftHeadersAlongAxisInContainer(d,o,e,"top",this.getMappedStyle("rowendheadercell"),"row"),s?this._shiftCellsAlongAxis("row",e,o,null,this.m_frozenRowIndex,n):(this._shiftCellsAlongAxis("row",e,o),this.m_databodyFrozenCol&&this._shiftFrozenCellsAlongAxis("row",e,o,!1)),s?(this.m_databodyFrozenRow.style.display="",this.m_rowHeaderFrozen.style.display=t,this.m_rowEndHeaderFrozen.style.display=i,this.m_databodyFrozenCorner&&(this.m_databodyFrozenCorner.style.display="",n=!0)):(this.m_databody.style.display="",this.m_rowHeader.style.display=t,this.m_rowEndHeader.style.display=i)},A.prototype._shiftHeadersAlongAxisInContainer=function(e,t,i,s,n,o,r){var l,a,h,d,m=0,c=this._getHeaderLastChild(e);if(null!=c){var u,_=this.m_utils.containsCSSClassName(c,n);for(_?(a=c.parentNode,l=c,h=this.getHeaderCellIndex(l)):(a=c,l=c.firstChild,h=this._getAttribute(a,"start",!0));t<h;)if(_)d=this.getElementDir(l,s)+i,this.setElementDir(l,d,s),c=this._getHeaderPreviousSibling(c),_=this.m_utils.containsCSSClassName(c,n),a=c.parentNode,l=c,h=this.getHeaderCellIndex(l);else{for(var p=a.getElementsByClassName(n),g=0;g<p.length;g++)d=this.getElementDir(p[g],s)+i,this.setElementDir(p[g],d,s);c=this._getHeaderPreviousSibling(c),_=this.m_utils.containsCSSClassName(c,n),a=c,l=c.firstChild,h=this._getAttribute(a,"start",!0)}if(this.m_resizingElement&&(u=this.getHeaderCellLevel(this.m_resizingElement)),"column"===o?(m=this.getElementWidth(l)+i,this.setElementWidth(l,m)):"row"===o?(m=this.getElementHeight(l)+i,this.setElementHeight(l,m)):null==o&&(d=this.getElementDir(l,s)+i,this.setElementDir(l,d,s)),r&&(this.isHeaderHidden(l)?l.style.display="none":l.style.display=""),("row"===o||"column"===o)&&!r){let e=this.getResources().isRTLMode()?["startResized"]:["endResized"],t="row"===o?["bottomResized"]:e;void 0!==u&&this.getHeaderCellLevel(l)>=u&&this._highlightElement(l,t),l!==this.m_resizingElement||l!==a.lastChild&&l!==a.firstChild||this._highlightResizeBorder(t,o)}_||null==l.nextSibling?null==o||r||"column"===o&&this.isHidden("column",t)||this.m_sizingManager.setSize(o,this._getKey(l),m):this._shiftHeadersAlongAxisInContainer(c,t,i,s,n,o,r)}},A.prototype._highlightResizeBorder=function(e,t){let i=this.getHeaderCellIndex(this.m_resizingElement),s="column"===t?this.m_columnHeaderLevelCount:this.m_rowHeaderLevelCount,n=this.m_resizingElement[this.getResources().getMappedAttribute("context")],o=n.index+n.extent-1;for(let n=0;n<s-1;n++){let s=this._getHeaderByIndex(i,t,n),r=s[this.getResources().getMappedAttribute("context")];r.index+r.extent-1===o&&this._highlightElement(s,e)}},A.prototype.resizeColumnHeightsAndShift=function(e,t,i,s){var n,o,r,l;i?(n=this.m_colEndHeader,o=this.getMappedStyle("colendheadercell"),r="columnEnd",l="bottom"):(n=this.m_colHeader,o=this.getMappedStyle("colheadercell"),r="column",l="top"),n.style.display="none",this.m_databody.style.display="none",this._hasFrozenColumns()&&(i?this.m_colEndHeaderFrozen.style.display="none":this.m_colHeaderFrozen.style.display="none",this.m_databodyFrozenCol.style.display="none"),s&&this._shiftLabelsDir(this.m_headerLabels[r],e,t,l,r),this._shiftHeadersDirInContainer(n.firstChild,e,t,l,o,r),this.m_colHeaderFrozen&&this._shiftHeadersDirInContainer(this.m_colHeaderFrozen.firstChild,e,t,l,o,r),n.style.display="",this.m_databody.style.display="",this._hasFrozenColumns()&&(i?this.m_colEndHeaderFrozen.style.display="":this.m_colHeaderFrozen.style.display="",this.m_databodyFrozenCol.style.display="")},A.prototype.resizeRowWidthsAndShift=function(e,t,i){var s,n,o,r;i?(s=this.m_rowEndHeader,n=this.getMappedStyle("rowendheadercell"),o="rowEnd",r=this.getResources().isRTLMode()?"left":"right"):(s=this.m_rowHeader,n=this.getMappedStyle("rowheadercell"),o="row",r=this.getResources().isRTLMode()?"right":"left"),s.style.display="none",this.m_databody.style.display="none",this._hasFrozenRows()&&(i?this.m_rowEndHeaderFrozen.style.display="none":this.m_rowHeaderFrozen.style.display="none",this.m_databodyFrozenRow.style.display="none"),this._shiftLabelsDir(this.m_headerLabels[o],e,t,r,o),this._shiftHeadersDirInContainer(s.firstChild,e,t,r,n,o),this.m_rowHeaderFrozen&&this._shiftHeadersDirInContainer(this.m_rowHeaderFrozen.firstChild,e,t,r,n,o),s.style.display="",this.m_databody.style.display="",this._hasFrozenRows()&&(i?this.m_rowEndHeaderFrozen.style.display="":this.m_rowHeaderFrozen.style.display="",this.m_databodyFrozenRow.style.display="")},A.prototype._shiftLabelsDir=function(e,t,i,s,n){for(var o=0;o<e.length;o++){var r,l=e[o];if(o===i)if("column"===n||"columnEnd"===n)if(r=this.getElementHeight(l)+t,this.setElementHeight(l,r),"column"===n&&this._isHeaderLabelCollision()&&i===this.m_columnHeaderLevelCount-1){let e=["bottomResized"];this._highlightElement(this.m_corner,e)}else if("columnEnd"===n){let e=["topResized"],t=this._getLabel("columnEnd",this.m_columnEndHeaderLevelCount-1);t&&this._highlightElement(t,e)}else{let e="column"===n?["bottomResized"]:["topResized"];this._highlightElement(l,e)}else{r=this.getElementWidth(l)+t,this.setElementWidth(l,r);let e=this.getResources().isRTLMode()?["startResized"]:["endResized"],i=this.getResources().isRTLMode()?["endResized"]:["startResized"],s="row"===n?e:i;this._highlightElement(l,s);let o=this._getLabel("columnEnd",this.m_columnEndHeaderLevelCount-1);o&&this._highlightElement(o.parentNode,s)}o>i&&(r=this.getElementDir(l,s)+t,this.setElementDir(l,r,s))}},A.prototype._shiftHeadersDirInContainer=function(e,t,i,s,n,o){for(var r=e.childNodes,l=0;l<r.length;l++){var a,h,d=r[l];if(this.m_utils.containsCSSClassName(d,n)){a=this.getHeaderCellLevel(d);var m=this.getHeaderCellDepth(d);if(a<=i&&i<a+m){if("column"===o||"columnEnd"===o){if(h=this.getElementHeight(d)+t,this.setElementHeight(d,h),this.m_resizingElement){var c=this.getMappedStyle("colendheadercell");if(this.m_utils.containsCSSClassName(d,c)){let e=["topResized"];this._highlightElement(d,e)}else{let e=["bottomResized"];this._highlightElement(d,e)}}}else if(h=this.getElementWidth(d)+t,this.setElementWidth(d,h),this.m_resizingElement){var u=this.getMappedStyle("rowendheadercell");if(this.m_utils.containsCSSClassName(d,u)){let e=this.getResources().isRTLMode()?["endResized"]:["startResized"];this._highlightElement(d,e)}else{let e=this.getResources().isRTLMode()?["startResized"]:["endResized"];this._highlightElement(d,e)}}}else a>i&&(h=this.getElementDir(d,s)+t,this.setElementDir(d,h,s))}else if((a=this._getAttribute(d,"level",!0))<=i)this._shiftHeadersDirInContainer(d,t,i,s,n,o);else for(var _=d.getElementsByClassName(n),p=0;p<_.length;p++)h=this.getElementDir(_[p],s)+t,this.setElementDir(_[p],h,s)}},A.prototype.handleContextMenuResize=function(e,t,i,s){this.m_overResizeLeft=0,this.m_overResizeMinLeft=0,this.m_overResizeTop=0,this.m_overResizeMinTop=0,this.m_overResizeRight=0,this.m_overResizeBottom=0;var n=parseFloat(i,10),o=n-this.getElementWidth(s),r=n-this.getElementHeight(s);this.m_utils.containsCSSClassName(s,this.getMappedStyle("cell"))&&(s=t===this.m_resources.getMappedCommand("resizeHeight")?this.getHeaderFromCell(s,"row",!0):this.getHeaderFromCell(s,"column",!0)),this.m_isResizing=!0,this.m_resizingElement=s;let l=this.find(this.m_resizingElement,"headerlabel");var a=this.getElementWidth(s),h=this.getElementHeight(s),d=this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("endheadercell"))||this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("columnendheaderlabel"))||this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("rowendheaderlabel"));if(t===this.m_resources.getMappedCommand("resizeWidth")){if(a!==n)if("column"===this._getResizeHeaderMode(this.m_resizingElement)){if(this._isDOMElementResizable(this.m_resizingElement))if(l)this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("columnendheaderlabel"))&&(d=!1),this.resizeRowWidth(n,n-a,d,l),this._fireResizeEvent(e,a,h,n,h,n),this._fireCellResizeEvent(e,a,h,n,h);else{let t=this.getNewElementWidth("column",a,d,o,l);this.resizeColWidth(a,t),this._resizeSelectedHeaders(e,a,h,n,h,n)}}else this.resizeRowWidth(n,n-a,d,l),this._fireResizeEvent(e,a,h,n,h,n),this._fireCellResizeEvent(e,a,h,n,h)}else if(t===this.m_resources.getMappedCommand("resizeHeight")&&h!==n)if("column"===this._getResizeHeaderMode(this.m_resizingElement))this.resizeColHeight(n,n-h,d),this._fireResizeEvent(e,a,h,a,n,n),this._fireCellResizeEvent(e,a,h,a,n);else if(this._isDOMElementResizable(this.m_resizingElement)){let t=this.getNewElementHeight("row",h,d,r,l);l?(this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("rowendheaderlabel"))&&(d=!1),this.resizeColHeight(t,t-h,d),this._fireResizeEvent(e,a,h,a,n,n),this._fireCellResizeEvent(e,a,h,a,n)):(this.resizeRowHeight(h,t),this._resizeSelectedHeaders(e,a,h,a,t,n))}var m=this.getElementWidth(s),c=this.getElementHeight(s);m===a&&c===h||(this.buildCorners(),this.m_utils.isTouchDevice()&&this._moveTouchSelectionAffordance()),this._unhighlightResizeBorderColor(),this.m_resizingElement=null,this.m_resizingElementMin=null,this.m_isResizing=!1},A.prototype._highlightResizeMouseDown=function(){let e,t,i=this.getHeaderCellIndex(this.m_resizingElement),s=this._getResizeHeaderMode(this.m_resizingElement),n=this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("endheadercell"))||this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("columnendheaderlabel")),o=this.getResources().isRTLMode()?"right":"left",r=this.find(this.m_resizingElement,"headerlabel");if("col-resize"===this.m_cursor)if("column"===s)if(n=!r&&n,r)t=this.getHeaderLabelAxis(this.m_resizingElement),"column"===t||"columnEnd"===t?e=this.m_rowHeaderLevelCount-1:"row"!==t&&"rowEnd"!==t||(e=this.getHeaderLabelLevel(this.m_resizingElement)),this.resizeRowWidthsAndShift(0,e,n),n||(e===this.m_rowHeaderLevelCount-1||0===this.m_headerLabels.row.length&&this.m_headerLabels.column.length)&&this._highlightResizeLabelDirs("column",e);else{this.m_columnHeaderLevelCount>1&&this.m_resizingElement===this.m_resizingElement.parentNode.firstChild&&null!=this.m_resizingElement.nextSibling&&(i+=this._getAttribute(this.m_resizingElement.parentNode,"extent",!0)-1);let e,t=this.createIndex(-1,i),s=this.getElementsInRange(this.createRange(t,t));if(s)for(let t=0;t<s.length;t++)e=this.getResources().isRTLMode()?["startResized"]:["endResized"],this._highlightElement(s[t],e);let n=this.m_colHeader.firstChild,r=this.m_colEndHeader.firstChild;this.m_resizingElement.classList.contains(this.getMappedStyle("frozenHeader"))&&(n=this.m_colHeaderFrozen.firstChild,r=this.m_colEndHeaderFrozen.firstChild),this._shiftHeadersAlongAxisInContainer(n,i,0,o,this.getMappedStyle("colheadercell"),"column"),this._shiftHeadersAlongAxisInContainer(r,i,0,o,this.getMappedStyle("colendheadercell"),"column")}else"row"===s&&(this.m_utils.containsCSSClassName(this.m_resizingElement,this.getMappedStyle("rowendheaderlabel"))&&(n=!0),r?(t=this.getHeaderLabelAxis(this.m_resizingElement),"column"===t||"columnEnd"===t?e=this.m_rowHeaderLevelCount-1:"row"!==t&&"rowEnd"!==t||(e=this.getHeaderLabelLevel(this.m_resizingElement))):e=this.getHeaderCellLevel(this.m_resizingElement)+(this.getHeaderCellDepth(this.m_resizingElement)-1),this.resizeRowWidthsAndShift(0,e,n),n||(e===this.m_rowHeaderLevelCount-1||0===this.m_headerLabels.row.length&&this.m_headerLabels.column.length)&&this._highlightResizeLabelDirs("column",e));else if("row-resize"===this.m_cursor)if("row"===s)if(r){let i=!0;t=this.getHeaderLabelAxis(this.m_resizingElement),"column"===t||"columnEnd"===t?e=this.getHeaderLabelLevel(this.m_resizingElement):"row"!==t&&"rowEnd"!==t||(e=this.m_columnHeaderLevelCount-1,i=!1),!n&&e===this.m_columnHeaderLevelCount-1&&this.m_headerLabels.row.length&&this._isHeaderLabelCollision()&&(i=!1),this.resizeColumnHeightsAndShift(0,e,n,i),n||(0===this.m_headerLabels.column.length||e===this.m_columnHeaderLevelCount-1&&this.m_headerLabels.row.length)&&this._highlightResizeLabelDirs("row",e)}else{this.m_rowHeaderLevelCount>1&&this.m_resizingElement===this.m_resizingElement.parentNode.firstChild&&null!=this.m_resizingElement.nextSibling&&(i+=this._getAttribute(this.m_resizingElement.parentNode,"extent",!0)-1);let e,t=this.createIndex(i,-1),s=this.getElementsInRange(this.createRange(t,t));if(s)for(let t=0;t<s.length;t++)e=["bottomResized"],this._highlightElement(s[t],e);let n=this.m_rowHeader.firstChild,o=this.m_rowEndHeader.firstChild;this.m_resizingElement.classList.contains(this.getMappedStyle("frozenHeader"))&&(n=this.m_rowHeaderFrozen.firstChild,o=this.m_rowEndHeaderFrozen.firstChild),this._shiftHeadersAlongAxisInContainer(n,i,0,"top",this.getMappedStyle("rowheadercell"),"row"),this._shiftHeadersAlongAxisInContainer(o,i,0,"top",this.getMappedStyle("rowendheadercell"),"row")}else{let i=!0;r?(t=this.getHeaderLabelAxis(this.m_resizingElement),"column"===t||"columnEnd"===t?e=this.getHeaderLabelLevel(this.m_resizingElement):"row"!==t&&"rowEnd"!==t||(e=this.m_columnHeaderLevelCount-1,i=!1)):(e=this.getHeaderCellLevel(this.m_resizingElement)+(this.getHeaderCellDepth(this.m_resizingElement)-1),t=this.getHeaderCellAxis(this.m_resizingElement)),!n&&e===this.m_columnHeaderLevelCount-1&&this.m_headerLabels.row.length&&this._isHeaderLabelCollision()&&(i=!1),this.resizeColumnHeightsAndShift(0,e,n,i),n||(0===this.m_headerLabels.column.length||e===this.m_columnHeaderLevelCount-1&&this.m_headerLabels.row.length)&&this._highlightResizeLabelDirs("row",e)}},A.prototype.handleResizeFitToContent=function(e,t,i,s){this.m_resizingElement=t;const n=this.getHeaderCellAxis(t),o=this.getHeaderCellIndex(t),r=this.m_utils.containsCSSClassName(t,this.getMappedStyle("endheadercell")),l="column"===n||"columnEnd"===n,a="row"===n||"rowEnd"===n;if(this.isHidden(l?"column":"row",o))return;let h;if(i)h=s;else{const e=this.createIndex(l?-1:o,l?o:-1);h=this.getElementsInRange(this.createRange(e,e))||[],h.push(t)}const d=this.getElementWidth(this.m_resizingElement),m=this.getElementHeight(this.m_resizingElement);let c,u=d,_=m;l&&!i||a&&i?(u=this._calculateResizeFitToContentValue(h,"column"),c=u,l?this.resizeColWidth(d,u):a&&this.resizeRowWidth(u,u-d,r,!1)):(_=this._calculateResizeFitToContentValue(h,"row"),c=_,l?this.resizeColHeight(_,_-m,r):a&&this.resizeRowHeight(m,_));(d!==u||m!==_)&&(this._fireResizeEvent(e,d,m,u,_,c),this._fireCellResizeEvent(e,d,m,u,_,[t])),this._unhighlightResizeBorderColor()},A.prototype._calculateResizeFitToContentValue=function(e,t){let i,s="height";"column"===t&&(s="width");let n=this._getMinValue(s,t,!1),o=document.createElement("div");if("width"===s){o.style.display="inline-flex",o.style.flexFlow="column nowrap",o.style.justifyContent="flex-start",o.style.alignItems="stretch";for(let t=0;t<e.length;t++){let i=e[t].cloneNode(!0);i.classList.remove(...i.classList),i.style[s]="",i.style.whiteSpace="nowrap !important",i.style.overflow="hidden",o.appendChild(i)}}else if("height"===s){o.style.display="flex";for(let t=0;t<e.length;t++){let i=e[t].cloneNode(!0);i.style[s]="",i.style.whiteSpace="break-spaces",o.appendChild(i)}}o.style.visibility="hidden",o.style.top="0px",this.m_root.appendChild(o);let r="column"===t?this.m_databody.offsetWidth:this.m_databody.offsetHeight,l="column"===t?this._getCellPaddingBorder(s,this.m_resizingElement):0;return i=("column"===t?Math.ceil(o.firstElementChild.getBoundingClientRect().width):Math.ceil(o.firstElementChild.getBoundingClientRect().height))+l,i=i<n?n:i,i=i>r?r:i,this.m_root.removeChild(o),i},A.prototype.getHeaderEdgePixels=function(e){var t=0,i=0;if(this.m_utils.isTouchDevice()){var s=this.findPos(e);t=s[0],i=s[1]}return[t,i,t+this.getElementWidth(e),i+this.getElementHeight(e)]},A.prototype.unhighlightSelection=function(){for(var e=this.GetSelection(),t=0;t<e.length;t+=1)this.unhighlightRange(e[t]);this.getResources()&&this._clearHeaderHighLight()},A.prototype.unhighlightRange=function(e){var t=this.getElementsInRange(e);this.unhighlightElems(t),this._applyBorderClassesAroundRange(t,e,!1,"Selected")},A.prototype.highlightRange=function(e,t){const i=this.getHeadersByRange(e,"row"),s=this.getHeadersByRange(e,"column");this._highlightHeaders(e,i,s);var n,o=this.getElementsInRange(e);(this.highlightElems(o,e),this._applyBorderClassesAroundRange(o,e,!0,"Selected"),t)&&(n=1===this.GetSelection().length?o.length:this._getCurrentSelectionCellCount(),this._setAccInfoText("accessibleMultiCellSelected",{num:n}))},A.prototype.getHeadersByRange=function(e,t){const i=new Set;let s,n,o,r;if("row"===t&&this.m_rowHeaderLevelCount>0){for(e.endIndex&&e.endIndex.row&&(r=e.endIndex.row),r||null==e.startIndex.row?-1!==r&&null!=e.startIndex.row||(r=this.m_endRowHeader):r=e.startIndex.row,n=e.startIndex.row?Math.max(this.m_startRowHeader,e.startIndex.row):this.m_startRowHeader;n<=r;n++)for(s=this._getHeadersByIndex(n,t),o=0;o<s.length;o++)i.add(s[o])}else if("column"===t&&this.m_columnHeaderLevelCount>0){for(e.endIndex&&e.endIndex.column&&(r=e.endIndex.column),r||null==e.startIndex.column?-1!==r&&null!=e.startIndex.column||(r=this.m_endColHeader):r=e.startIndex.column,n=e.startIndex.column?Math.max(this.m_startColHeader,e.startIndex.column):this.m_startColHeader;n<=r;n++)for(s=this._getHeadersByIndex(n,t),o=0;o<s.length;o++)i.add(s[o])}if("row"===t&&this.m_rowEndHeaderLevelCount>0){for(e.endIndex&&e.endIndex.row&&(r=e.endIndex.row),r||null==e.startIndex.row?-1!==r&&null!=e.startIndex.row||(r=this.m_endRowHeader):r=e.startIndex.row,n=e.startIndex.row?Math.max(this.m_startRowEndHeader,e.startIndex.row):this.m_startRowEndHeader;n<=r;n++)for(s=this._getHeadersByIndex(n,"rowEnd"),o=0;o<s.length;o++)i.add(s[o])}else if("column"===t&&this.m_columnEndHeaderLevelCount>0){for(e.endIndex&&e.endIndex.column&&(r=e.endIndex.column),r||null==e.startIndex.column?-1!==r&&null!=e.startIndex.column||(r=this.m_endColHeader):r=e.startIndex.column,n=e.startIndex.column?Math.max(this.m_startColEndHeader,e.startIndex.column):this.m_startColEndHeader;n<=r;n++)for(s=this._getHeadersByIndex(n,"columnEnd"),o=0;o<s.length;o++)i.add(s[o])}return i},A.prototype._highlightHeaders=function(e,t,i){t.forEach(t=>{const i=t[this.getResources().getMappedAttribute("context")];null==e?.endIndex?.column||-1===e.endIndex.row&&-1===e.endIndex.column||-1===e.endIndex.column&&0===e.startIndex.column&&this._isHeaderSelected(i,"row")?(t.classList.remove(this.getMappedStyle("headerPartialSelected")),t.classList.add(this.getMappedStyle("headerAllSelected"))):(t.classList.remove(this.getMappedStyle("headerAllSelected")),t.classList.add(this.getMappedStyle("headerPartialSelected")))}),i.forEach(t=>{const i=t[this.getResources().getMappedAttribute("context")];null==e?.endIndex?.row||-1===e.endIndex.row&&-1===e.endIndex.column||-1===e.endIndex.row&&0===e.startIndex.row&&this._isHeaderSelected(i,"column")?(t.classList.remove(this.getMappedStyle("headerPartialSelected")),t.classList.add(this.getMappedStyle("headerAllSelected"))):(t.classList.remove(this.getMappedStyle("headerAllSelected")),t.classList.add(this.getMappedStyle("headerPartialSelected")))})},A.prototype._isHeaderSelected=function(e,t){let i=!1;return this.GetSelection().forEach(s=>{e.index>=s.startIndex[t]&&e.index+(e.extent-1)<=s.endIndex[t]&&(i=!0)}),i},A.prototype._clearHeaderHighLight=function(){const e=this.getMappedStyle("headerAllSelected"),t=this.getMappedStyle("headerPartialSelected"),i=this.getMappedStyle("headercell"),s=this.getMappedStyle("endheadercell"),n=this.m_root.querySelectorAll("."+e+"."+i+",."+e+"."+s+",."+t+"."+i+",."+t+"."+s);for(let i=0;i<n.length;i++)n[i].classList.remove(e,t,this.getMappedStyle("draggableItem"))},A.prototype._getCurrentSelectionCellCount=function(){for(var e=0,t=this.GetSelection(),i=0;i<t.length;i++){var s=this.getElementsInRange(t[i]);null!=s&&(e+=s.length)}return e},A.prototype.unhighlightElems=function(e){if(null!=e&&0!==e.length)for(let t=0;t<e.length;t+=1){let i=e[t],s=["selected","topSelected","bottomSelected","startSelected","endSelected"];this._unhighlightElement(i,s)}},A.prototype.highlightElems=function(e){if(null!=e&&0!==e.length)for(let t=0;t<e.length;t+=1)this._highlightElement(e[t],["selected"])},A.prototype.applySelection=function(e,t,i,s){for(var n=this.GetSelection(),o=0;o<n.length;o+=1){var r=this.getElementsInRange(n[o],e,t,i,s);if(this.highlightElems(r),this._applyBorderClassesAroundRange(r,n[o],!0,"Selected"),this.m_dragIndex&&r&&r.length)for(let e=0;e<r.length;e++)this._highlightElement(r[e],["dragSourceOpaque"])}},A.prototype.handleDatabodySelectionDrag=function(e){var t,i;if(this.m_utils.isTouchDevice()?t=this.findCell(document.elementFromPoint(e.touches[0].clientX,e.touches[0].clientY)):(i=e.target,t=this.findCell(i)),null!=t){var s=this.getCellIndexes(t);this.m_deselectInProgress?this.extendDeselection(s,e):this.isHeaderSelectionType(this.m_selectionFrontier)?this.extendSelectionHeader(t,e):this.extendSelection(s,e)}},A.prototype.handleHeaderClickSelection=function(e){var t,i,s,n,o=e.target,r=this.findHeader(o),l=e.shiftKey,a=this.isMultipleSelection(),h=this.m_utils.ctrlEquivalent(e);if(l&&a||!r||this._setActive(r,this._createActiveObject(r),e),null==this.m_active||"header"!==this.m_active.type&&!e.shiftKey)return!1;var d=r[this.getResources().getMappedAttribute("context")];if(t=d.axis,i=d.index,n=d.extent,h&&this._shouldDeselectHeader(i,n,t)){var m,c,u,_;-1!==t.indexOf("row")?(m=this.createIndex(i,0),c=this.createIndex(i+n-1,-1),_=this._getSelectionStartAndEnd(m,c,0),u=this.createRange(this.createIndex(_.min.row,0),this.createIndex(_.max.row,-1))):(m=this.createIndex(0,i),c=this.createIndex(-1,i+n-1),_=this._getSelectionStartAndEnd(m,c,0),u=this.createRange(this.createIndex(0,_.min.column),this.createIndex(-1,_.max.column)));var p=this._trimRangeForSelectionMode(u);return this.m_deselectInfo={anchor:p.startIndex,selection:this.GetSelection(),axis:-1!==t.indexOf("row")?"row":"column",sourceParent:r},void(this.m_deselectInProgress=this._deselectRange(p,e))}"header"===this.m_active.type&&(t=this.m_active.axis,i=this.m_active.index,s=this.m_active.level),this.m_utils.isTouchDevice()?(this._removeTouchSelectionAffordance(),this._selectHeader(t,i,s,e)):l&&a?(null==t&&(t=d.axis),(-1!==t.indexOf("row")&&-1!==d.axis.indexOf("row")||-1!==t.indexOf("column")&&-1!==d.axis.indexOf("column"))&&this.extendSelectionHeader(r,e)):this._isHeaderInsideSelection(i,t)&&1!==e.buttons||this._selectHeader(t,i,s,e)},A.prototype.discontiguousHeaderSetActiveFromDatabody=function(e,t,i,s){var n=t.replace("End",""),o=this.m_selection[this.m_selection.length-1];this.unhighlightSelection(),o.startIndex.row===this.m_active.indexes.row&&o.endIndex.row===this.m_active.indexes.row&&o.startIndex.column===this.m_active.indexes.column&&o.endIndex.column===this.m_active.indexes.column&&this.m_selection.pop(),this._setActive(i,{type:"header",index:this.m_trueIndex[n],level:s-1,axis:t},e,!1),this.rehighlightSelection()},A.prototype.handleDragAnchorChange=function(e){if(this.m_headerDragState){var t,i,s=e.target,n=this.findHeader(s),o=n[this.getResources().getMappedAttribute("context")],r=this._getActiveElement(),l=r[this.getResources().getMappedAttribute("context")],a=this._getAttribute(r.parentNode,"start",!0),h=a+(this._getAttribute(r.parentNode,"extent",!0)-1);if(!o.extent)return;1===o.extent?(t=o.index,i=o.index):i=(t=this._getAttribute(n.parentNode,"start",!0))+(this._getAttribute(n.parentNode,"extent",!0)-1),1!==l.extent?(t<=a&&i>=h||t>=a&&i<=h)&&this._setActive(n,this._createActiveObject(n),e):t!==i&&t<=a&&a<=i&&this._setActive(n,this._createActiveObject(n),e)}},A.prototype.handleDatabodyClickSelection=function(e){var t,i=e.target,s=this.findCell(i);if(null!=s&&(t=this.getCellIndexes(s)),null!=t){if(this.isMultipleSelection()&&2===e.button&&this._isContainSelection(t))return;var n=this.m_utils.ctrlEquivalent(e),o=e.shiftKey;if(this.m_utils.containsCSSClassName(s,this.getMappedStyle("selected"))&&n){this.m_deselectInfo={anchor:t,selection:this.GetSelection()};var r=this.getCellEndIndexes(s),l=this._trimRangeForSelectionMode(this.createRange(t,r));return void(this.m_deselectInProgress=this._deselectRange(l,e))}this.isMultipleSelection()?(this._removeTouchSelectionAffordance(),this.m_utils.isTouchDevice()?(null!=this.m_active&&this._unhighlightActive(),this.selectAndFocus(t,e,!1)):n?n&&o?this.extendSelection(t,e):this.selectAndFocus(t,e,!0):o?this.extendSelection(t,e):this.selectAndFocus(t,e,!1)):this.selectAndFocus(t,e,!1)}},A.prototype._doRangesOverlap=function(e,t){var i=e.startIndex,s=i.column,n=i.row,o=e.endIndex,r=o.column,l=o.row,a=t.startIndex,h=a.column,d=a.row,m=t.endIndex,c=m.column,u=m.row;return(s<=c||-1===c||void 0===c)&&(r>=h||-1===r||void 0===r)&&(n<=u||-1===u)&&(l>=d||-1===l)},A.prototype._isRangeValid=function(e){return(e.startIndex.row<=e.endIndex.row||e.startIndex.row>=0&&-1===e.endIndex.row)&&(e.startIndex.column<=e.endIndex.column||e.startIndex.column>=0&&-1===e.endIndex.column||void 0===e.startIndex.column&&void 0===e.endIndex.column)},A.prototype._deselectRange=function(e,t){var i=this.m_deselectInfo.selection,s=e.startIndex,n=s.column,o=s.row,r=e.endIndex,l=r.column,a=r.row,h=!1,d=[],m=0,c=[],u=this;return i.forEach(function(t){var i=t.startIndex,s=i.column,r=i.row,_=t.endIndex,p=_.column,g=_.row;if(this._doRangesOverlap(t,e)){var f,C,y=function(e,t,i){return new Promise(function(s){u._createRangeWithKeys(e,t,function(e){d[i]=e,s()})})};h=!0,r<o&&(f=this.createIndex(r,s),C=this.createIndex(o-1,p),this._isRangeValid({startIndex:f,endIndex:C})&&(c.push(y(f,C,m)),m+=1)),-1!==a&&(f=this.createIndex(a+1,s),C=this.createIndex(g,p),this._isRangeValid({startIndex:f,endIndex:C})&&(c.push(y(f,C,m)),m+=1)),s<n&&void 0!==s&&(f=this.createIndex(Math.max(o,r),s),C=this.createIndex(Math.min(-1===a?g:a,-1===g?a:g),n-1),this._isRangeValid({startIndex:f,endIndex:C})&&(c.push(y(f,C,m)),m+=1)),-1!==l&&void 0!==s&&(f=this.createIndex(Math.max(o,r),l+1),C=this.createIndex(Math.min(-1===a?g:a,-1===g?a:g),p),this._isRangeValid({startIndex:f,endIndex:C})&&(c.push(y(f,C,m)),m+=1))}else d[m]=t,m+=1},this),!!h&&(Promise.all(c).then(function(){var e=u.m_selection;u.SetSelection(d),u._compareSelectionAndFire(t,e)}),!0)},A.prototype._shouldDeselectHeader=function(e,t,i){var s,n,o=this.GetSelection();"row"===i||"rowEnd"===i?(s="row",n="column"):(s="column",n="row");var r=!1,l=this.m_options.getSelectionMode();return o.forEach(function(i){var o=i.startIndex[n],a=i.endIndex[n];if(0===o&&-1===a||"row"===l&&"row"===s){var h=i.startIndex[s],d=i.endIndex[s];h<=e&&(d>=e+t-1||-1===d)&&(r=!0)}}),r},A.prototype._handleSelectAll=function(e){return!(!this._isSelectionEnabled()||!this.isMultipleSelection())&&("row"===this.m_options.getSelectionMode()?this._selectRange(this.createIndex(0),this.createIndex(-1),e):this._selectRange(this.createIndex(0,0),this.createIndex(-1,-1),e),this.m_utils.isTouchDevice()&&this.m_topSelectIconContainer&&this.m_bottomSelectIconContainer&&(this.m_topSelectIconContainer.parentNode.removeChild(this.m_topSelectIconContainer),this.m_bottomSelectIconContainer.parentNode.removeChild(this.m_bottomSelectIconContainer)),!0)},A.prototype._isContainSelection=function(e,t){null==t&&(t=this.GetSelection());for(var i=0;i<t.length;i+=1){var s=t[i],n=s.startIndex,o=this.getEndIndex(s),r=n.row,l=o.row;if(e.row>=r&&(-1===l||e.row<=l)){var a=n.column,h=o.column;if(isNaN(a)||isNaN(h))return!0;if(e.column>=a&&(-1===h||e.column<=h))return!0}}return!1},A.prototype._isHeaderInsideSelection=function(e,t){const i=this.GetSelection();for(let s=0;s<i.length;s+=1){let n=i[s],o=n.startIndex,r=this.getEndIndex(n),l=o.row,a=r.row,h=o.column,d=r.column;if("column"===t||"columnEnd"===t){if(e>=h&&(-1===d||e<=d)&&0===l&&-1===a)return!0}else if(("row"===t||"rowEnd"===t)&&e>=l&&(-1===a||e<=a)&&(0===h&&-1===d||void 0===h&&void 0===d))return!0}return!1},A.prototype._compareSelections=function(e,t){if(e.length!==t.length)return!1;for(var i=0;i<e.length;i+=1){for(var s=!1,n=0;n<t.length;n+=1)this._compareIndividualSelectionObjects(e[i],t[n])&&(s=!0);if(!1===s)return!1}return!0},A.prototype._compareIndividualSelectionObjects=function(e,t){return e.startIndex.row===t.startIndex.row&&e.startIndex.column===t.startIndex.column&&e.endIndex.row===t.endIndex.row&&e.endIndex.column===t.endIndex.column},A.prototype._clearSelection=function(e){this.unhighlightSelection(),this._removeTouchSelectionAffordance();var t=this.GetSelection();this.m_selection=[],this._compareSelectionAndFire(e,t)},A.prototype.setDiscontiguousSelectionMode=function(e){this.m_discontiguousSelection=e,this._setAccInfoText(e?"accessibleRangeSelectModeOn":"accessibleRangeSelectModeOff")},A.prototype._selectEntireRow=function(e,t,i){var s=this.createIndex(e,0),n=this.createIndex(t,-1),o=this._getSelectionStartAndEnd(s,n,0);"row"===this.m_options.getSelectionMode()?this._selectRange(this.createIndex(o.min.row),this.createIndex(o.max.row),i):this._selectRange(this.createIndex(o.min.row,0),this.createIndex(o.max.row,-1),i)},A.prototype._selectEntireColumn=function(e,t,i){var s=this.createIndex(0,e),n=this.createIndex(-1,t),o=this._getSelectionStartAndEnd(s,n,0);this._selectRange(this.createIndex(0,o.min.column),this.createIndex(-1,o.max.column),i)},A.prototype._selectRange=function(e,t,i){this.unhighlightSelection(),this._createRangeWithKeys(e,t,this._selectRangeCallback.bind(this,i))},A.prototype._selectRangeCallback=function(e,t){var i,s=this.GetSelection();(i=this.m_discontiguousSelection||!e||this.m_utils.ctrlEquivalent(e)&&this.isMultipleSelection()&&0===e.button?this.m_utils.ctrlEquivalent(e)&&this.isMultipleSelection()&&!0===e.shiftKey?s.slice(0,s.length-1):s.slice(0):[]).push(t),this.m_selection=i,this.rehighlightSelection(),this._isDatabodyCellActive()&&e.target[this.getResources().getMappedAttribute("context")]&&!e.target[this.getResources().getMappedAttribute("context")].axis&&!this.m_selectionFrontier.axis&&(this.m_selectionFrontier=this.m_active.indexes,this._highlightActive()),this._compareSelectionAndFire(e,s)},A.prototype.rehighlightSelection=function(){for(var e=0;e<this.m_selection.length;e++)this.highlightRange(this.m_selection[e])},A.prototype.GetSelection=function(){return null==this.m_selection&&(this.m_selection=[]),this.m_selection},A.prototype.SetSelection=function(e){void 0!==e&&(null===e&&(e=[]),this.unhighlightSelection(),this.m_selection=e,this._resetHeaderHighLight(),null!=this.m_databody&&this.applySelection(this.m_startRow,this.m_endRow,this.m_startCol,this.m_endCol),this.m_bottomFloodFillIconContainer&&(1===this.m_selection.length?this._moveFloodFillAffordance():this._removeFloodFillAffordance()),this.m_utils.isTouchDevice()&&void 0!==this.m_resources&&this._moveTouchSelectionAffordance())},A.prototype.fireSelectionEvent=function(e,t){var i={event:e,ui:{selection:this.GetSelection(),previousSelection:t}};this.fireEvent("select",i)},A.prototype.extendSelection=function(e,t,i){if("header"!==this.m_active.type){var s;if(this.m_utils.isTouchDevice())s=this.m_touchSelectAnchor;else s={row:this.m_active.indexes.row,column:this.m_active.indexes.column};if(null!=s){this._resetSelectionFrontierFocus();var n=this._updateSelectionFrontier(s,e,i),o=n.min,r=n.max;if("row"===this.m_options.getSelectionMode()&&(o=this.createIndex(o.row),r=this.createIndex(r.row)),this.m_discontiguousSelection&&(this.m_deselectInProgress||this._isContainSelection(s,this.GetSelection().slice(0,-1)))){this.m_deselectInProgress||(this.m_deselectInfo={anchor:s,selection:this.GetSelection()});var l=this._trimRangeForSelectionMode(this.createRange(o,r));this.m_deselectInProgress=this._deselectRange(l,t)}else this._createRangeWithKeys(o,r,this._extendSelectionCallback.bind(this,t,s))}}},A.prototype.extendDeselection=function(e,t){var i=this.m_deselectInfo.anchor,s=this._updateSelectionFrontier(i,e),n=s.min,o=s.max,r=this._trimRangeForSelectionMode(this.createRange(n,o));this._deselectRange(r,t)},A.prototype.extendSelectionHeader=function(e,t,i,s){if(null!==e){var n=this.findCellOrHeader(e);if(null!==n){var o,r,l,a,h,d=n[this.getResources().getMappedAttribute("context")];if(null==i&&(i=this.m_discontiguousSelection),d){if(d.cell)a=l=-1!==this.m_selectionFrontier.axis.indexOf("column")?d.indexes.column:d.indexes.row,h=l;else{if(this.m_selectionFrontier&&d.index===this.m_selectionFrontier.index&&d.level===this.m_selectionFrontier.level)return;1===d.extent?(l=d.index,a=d.index,h=d.index):a=(l=this._getAttribute(e.parentNode,"start",!0))+(this._getAttribute(e.parentNode,"extent",!0)-1)}var m=s?this.m_deselectInfo.sourceParent:this._getActiveElement();if(m){var c,u,_,p=m[this.getResources().getMappedAttribute("context")];if(s?(r=this.m_deselectInfo.axis,o=this.m_deselectInfo.anchor[r],u=(c=this._getAttribute(m.parentNode,"start",!0))+(this._getAttribute(m.parentNode,"extent",!0)-1)):this.m_utils.isTouchDevice()?(-1===(o=-1!==this.m_selectionFrontier.axis.indexOf("column")?this.m_touchSelectAnchor.column:this.m_touchSelectAnchor.row)&&(o=0),c=o,u=o,r=this.m_selectionFrontier.axis):(u=(c=this._getAttribute(m.parentNode,"start",!0))+(this._getAttribute(m.parentNode,"extent",!0)-1),"header"===this.m_active.type&&(r=this.m_active.axis,o=this.m_active.index)),"cell"===this.m_active.type?(_=1,o=-1!==(r=d.axis).indexOf("row")?this.m_active.indexes.row:this.m_active.indexes.column):_=p.extent,i&&!s){var g=this.m_selection[this.m_selection.length-1];this.unhighlightSelection(),g&&this.checkCorners(r,o,g)&&this.m_selection.pop()}if(1!==_?l<=c&&a>=u||l>=c&&a<=u?(this.m_headerDragState||this._setActive(n,this._createActiveObject(n),t),o=l,h=a):l>c&&a>u?(o=c,h=a):l<c&&a<u&&(o=l,h=u):1===_&&l!==a&&(l<=o&&o<=a?(this.m_headerDragState||"cell"===this.m_active.type||this._setActive(n,this._createActiveObject(n),t),o=l,h=a):l<=o&&a<=o?(h=o,o=l):l>=o&&a>=o&&(h=a)),d.cell?this.setHeaderSelectionFrontier(r,h,h,this.m_selectionFrontier.level,n,!0):this.setHeaderSelectionFrontier(r,h,d.index,d.level,n,!0),!s&&r)-1!==r.indexOf("column")?this._selectEntireColumn(o,h,t):-1!==r.indexOf("row")&&this._selectEntireRow(o,h,t);else{var f,C=Math.min(o,h),y=Math.max(o,h);f=null!=r&&-1!==r.indexOf("row")?this.createRange(this.createIndex(C,0),this.createIndex(y,-1)):this.createRange(this.createIndex(0,C),this.createIndex(-1,y));var E=this._trimRangeForSelectionMode(f);this._deselectRange(E,t)}}}}}},A.prototype._updateSelectionFrontier=function(e,t,i){var s,n,o;if("row"===this.m_options.getSelectionMode()?(s=this.createIndex(e.row,this.m_startCol),n=this.createIndex(t.row,this.m_endCol)):(s=e,n=t),null!=i){if(this.m_deselectInProgress)o=this.createRange(this.m_deselectInfo.anchor,this.m_selectionFrontier);else{var r=this.GetSelection();o=r[this._getLastAnchoredSelectionIndex(r,s)]}var l=o.startIndex,a=o.endIndex;l.row===this.m_selectionFrontier.row&&s.row!==l.row?s.row=a.row:a.row===this.m_selectionFrontier.row&&s.row!==a.row&&(s.row=l.row),l.column===this.m_selectionFrontier.column&&s.column!==l.column?s.column=a.column:a.column===this.m_selectionFrontier.column&&s.column!==a.column&&(s.column=l.column)}var h=this._getSelectionStartAndEnd(s,n,0),d=n;if(null!=i){var m=h.min,c=h.max;for("row"===this.m_options.getSelectionMode()&&(m=this.createIndex(m.row),c=this.createIndex(c.row));this._compareIndividualSelectionObjects(o,this.createRange(m,c));){if(i===this.keyCodes.LEFT_KEY){if(0===n.column)break;n.column-=1}else if(i===this.keyCodes.RIGHT_KEY){if(n.column===this.m_endCol)break;n.column+=1}else if(i===this.keyCodes.UP_KEY){if(0===n.row)break;n.row-=1}else{if(i!==this.keyCodes.DOWN_KEY)break;if(n.row===this.m_endRow)break;n.row+=1}m=(h=this._getSelectionStartAndEnd(s,n,0)).min,c=h.max,"row"===this.m_options.getSelectionMode()&&(m=this.createIndex(m.row),c=this.createIndex(c.row))}i===this.keyCodes.LEFT_KEY?(d.column=m.column<s.column?m.column:c.column,d.row=m.row<s.row?m.row:c.row):i===this.keyCodes.RIGHT_KEY?(d.column=c.column>s.column?c.column:m.column,d.row=m.row<s.row?m.row:c.row):i===this.keyCodes.UP_KEY?(d.row=m.row<s.row?m.row:c.row,d.column=m.column<s.column?m.column:c.column):i===this.keyCodes.DOWN_KEY&&(d.row=c.row>s.row?c.row:m.row,d.column=m.column<s.column?m.column:c.column)}else d=this.getCellIndexes(this._getCellByIndex(d));return"row"===this.m_options.getSelectionMode()&&(d=this.createIndex(d.row,this.m_active.indexes.column)),this.m_selectionFrontier=d,h},A.prototype._getMinOrMax=function(e,t,i){return isNaN(e)?isNaN(t)?null:t:isNaN(t)?e:i(e,t)},A.prototype._getSelectionStartAndEnd=function(e,t,i){var s=this.getElementsInRange(this.createRange(e,t));if(null==s||s.length===i)return{min:e,max:t};for(var n={row:this._getMinOrMax(e.row,t.row,Math.min),column:this._getMinOrMax(e.column,t.column,Math.min)},o={row:this._getMinOrMax(e.row,t.row,Math.max),column:this._getMinOrMax(e.column,t.column,Math.max)},r=0;r<s.length;r++){var l=this.getCellIndexes(s[r]),a=this.getCellEndIndexes(s[r]);(l.row<n.row||null==n.row)&&(n.row=l.row),(l.column<n.column||null==n.column)&&(n.column=l.column),(a.row>o.row||null==o.row)&&(o.row=a.row),(a.column>o.column||null==o.column)&&(o.column=a.column)}return this._getSelectionStartAndEnd(n,o,s.length)},A.prototype._getLastAnchoredSelectionIndex=function(e,t){var i;for(i=e.length-1;i>-1;i--)if(this._isContainSelection(t,[e[i]]))return i;return i-1},A.prototype._extendSelectionCallback=function(e,t,i){var s=this.GetSelection(),n=this._getLastAnchoredSelectionIndex(s,t),o=s[n];if(null!=o){var r=o.startIndex.row===i.startIndex.row;null!=o.startIndex.column&&null!=i.startIndex.column&&(r=r&&o.startIndex.column===i.startIndex.column);var l=o.endIndex.row===i.endIndex.row;if(null!=o.endIndex.column&&null!=i.endIndex.column&&(l=l&&o.endIndex.column===i.endIndex.column),!r||!l){var a;if(this.m_discontiguousSelection||e&&this.m_utils.ctrlEquivalent(e)&&0===e.button?(a=s.slice(0),this.unhighlightRange(o),a.splice(n,1)):(a=[],this.unhighlightSelection()),a.push(i),this.m_selection=a,this.m_discontiguousSelection||e&&this.m_utils.ctrlEquivalent(e)&&0===e.button)for(var h=0;h<this.m_selection.length;h++)this.highlightRange(this.m_selection[h]);else this.highlightRange(i,!0);this._makeSelectionFrontierFocus(),this._compareSelectionAndFire(e,s)}}},A.prototype._resetSelectionFrontierFocus=function(){if(!(null==this.m_selectionFrontier||this._isDatabodyCellActive()&&this.m_selectionFrontier.row===this.m_active.indexes.row&&this.m_selectionFrontier.column===this.m_active.indexes.column)){var e=this.createRange(this.m_selectionFrontier),t=this.getElementsInRange(e);null!=t&&t.length>0&&this._unsetAriaProperties(t[0])}},A.prototype._makeSelectionFrontierFocus=function(){if(!(null==this.m_selectionFrontier||this._isDatabodyCellActive()&&this.m_selectionFrontier.row===this.m_active.indexes.row&&this.m_selectionFrontier.column===this.m_active.indexes.column)){if(this._isDatabodyCellActive()){var e=this.createRange(this.m_active.indexes),t=this.getElementsInRange(e);null!=t&&t.length>0&&this._unsetAriaProperties(t[0])}var i=this.createRange(this.m_selectionFrontier),s=this.getElementsInRange(i);if(null!=s&&0!==s.length){this._updateContextInfo(this.m_selectionFrontier);var n=this.m_utils.containsCSSClassName(s[0],this.getMappedStyle("row"))?s[0].firstChild:s[0];this._setAriaProperties(this._createActiveObject(n),null,n)}}},A.prototype._selectHeader=function(e,t,i,s){var n,o;if(-1!==e.indexOf("row")&&this.m_rowHeaderLevelCount-1===i||-1!==e.indexOf("column")&&this.m_columnHeaderLevelCount-1===i)n=t,o=t;else{var r=this._getActiveElement();o=(n=this._getAttribute(r.parentNode,"start",!0))+(this._getAttribute(r.parentNode,"extent",!0)-1)}-1!==e.indexOf("row")?((n===o&&!this.isMultipleSelection()||this.isMultipleSelection())&&(this.setHeaderSelectionFrontier(e,o,t,i,s.target,!0),this._selectEntireRow(n,o,s)),this._setAccInfoText("accessibleRowSelected",{row:t+1})):-1!==e.indexOf("column")&&(this.setHeaderSelectionFrontier(e,o,t,i,s.target,!0),this._selectEntireColumn(n,o,s),this._setAccInfoText("accessibleColumnSelected",{column:t+1})),this.isMultipleSelection()&&(this.m_headerDragState=!0)},A.prototype.setHeaderSelectionFrontier=function(e,t,i,s,n,o){o&&(this.m_selectionFrontier={}),this.m_selectionFrontier.axis=e,this.m_selectionFrontier.end=t,this.m_selectionFrontier.index=i,this.m_selectionFrontier.level=s,this.m_selectionFrontier.target=n},A.prototype._resetHeaderHighLight=function(){this.GetSelection().forEach(e=>{var t=this.getHeadersByRange(e,"row"),i=this.getHeadersByRange(e,"column");this._highlightHeaders(e,t,i)})},A.prototype.selectAndFocus=function(e,t,i){null==i&&(i=!1),this._resetSelectionFrontierFocus(),this._setActiveByIndex(e,t),"row"===this.m_options.getSelectionMode()&&(e=this.createIndex(e.row));var s=this._getSelectionStartAndEnd(e,e,0),n=s.min,o=s.max;"row"===this.m_options.getSelectionMode()&&(n=this.createIndex(n.row),o=this.createIndex(o.row)),this._createRangeWithKeys(n,o,this._selectAndFocusRangeCallback.bind(this,n,t,i))},A.prototype._selectAndFocusRangeCallback=function(e,t,i,s){var n=this.GetSelection(),o=n.slice(0);i||(this.m_discontiguousSelection||!t||this.isMultipleSelection()&&this.m_utils.ctrlEquivalent(t)&&0===t.button?!this._isDatabodyCellActive()||null==this.m_prevActive||"cell"!==this.m_prevActive.type||!(this.m_selectionFrontier.row===this.m_prevActive.indexes.row&&this.m_selectionFrontier.column===this.m_prevActive.indexes.column||this.m_selectionFrontier.row===this.m_prevActive.indexes.row&&this.isMultipleSelection()&&"row"===this.m_options.getSelectionMode())||this.m_utils.isTouchDevice()||!t.keyCode&&this.isMultipleSelection()||o.pop():o=[]),this.m_selectionFrontier=e,o.push(s),this.unhighlightSelection(),this._clearHeaderHighLight(),this.m_selection=o,this.rehighlightSelection(),this.m_options.isFloodFillEnabled()&&!this.m_discontiguousSelection&&"cell"===this.m_active.type&&this._moveFloodFillAffordance(),this._compareSelectionAndFire(t,n)},A.prototype._compareSelectionAndFire=function(e,t){var i=this.GetSelection();this.isMultipleSelection()&&i.length>0&&(this.m_utils.isTouchDevice()?(this._addTouchSelectionAffordance(e),this._moveTouchSelectionAffordance()):this.m_options.isFloodFillEnabled()&&this._isSelectionEnabled()&&!this.m_discontiguousSelection&&"cell"===this.m_active.type&&(this._addFloodfillAffordance(e),this._moveFloodFillAffordance())),this._compareSelections(i,t)||(this._resetHeaderHighLight(),this.fireSelectionEvent(e,t))},A.prototype._addTouchSelectionAffordance=function(e){if(null==this.m_topSelectIconContainer&&null==this.m_bottomSelectIconContainer){var t=e.target,i=this.findCell(t);if(i||(i=this.findHeader(t)),!i)return;this.m_topSelectIconContainer=document.createElement("div"),this.m_topSelectIconContainer.className=this.getMappedStyle("toucharea");var s=document.createElement("div");s.className=this.getMappedStyle("selectaffordance"),s.setAttribute("role","button"),s.setAttribute("aria-label",this.getResources().getTranslatedText("accessibleSelectionAffordanceTop")),this.m_topSelectIconContainer.appendChild(s),this.m_bottomSelectIconContainer=document.createElement("div"),this.m_bottomSelectIconContainer.className=this.getMappedStyle("toucharea");var n=document.createElement("div");if(n.className=this.getMappedStyle("selectaffordance"),n.setAttribute("role","button"),n.setAttribute("aria-label",this.getResources().getTranslatedText("accessibleSelectionAffordanceBottom")),this.m_bottomSelectIconContainer.appendChild(n),i?.classList.contains(this.getMappedStyle("frozenCell"))){let e=this._getCellContainer(i);e.firstChild.appendChild(this.m_topSelectIconContainer),e.firstChild.appendChild(this.m_bottomSelectIconContainer)}else if(i?.classList.contains(this.getMappedStyle("frozenHeader"))){let e;i.classList.contains(this.getMappedStyle("rowheadercell"))?e=this.m_databodyFrozenRow:i.classList.contains(this.getMappedStyle("colheadercell"))&&(e=this.m_databodyFrozenCol),e.firstChild.childNodes?.length||(e=this.m_databodyFrozenCorner),e.firstChild.appendChild(this.m_topSelectIconContainer),e.firstChild.appendChild(this.m_bottomSelectIconContainer)}else this.m_databody.firstChild.appendChild(this.m_topSelectIconContainer),this.m_databody.firstChild.appendChild(this.m_bottomSelectIconContainer);this.m_touchSelectionAffordanceHeight=this.m_topSelectIconContainer.firstElementChild.offsetHeight,this.m_touchSelectionAffordanceWidth=this.m_topSelectIconContainer.firstElementChild.offsetWidth}},A.prototype._addRoundedAffordanceClasses=function(e,t,i,s){if(e&&t)i||"row"!==s?i||"column"!==s?(e.classList.add(this.getMappedStyle("selectaffordancetopcornerbounded")),t.classList.add(this.getMappedStyle("selectaffordancebottomcornerbounded"))):(e.classList.add(this.getMappedStyle("selectaffordancetopcolumn")),t.classList.add(this.getMappedStyle("selectaffordancebottomcolumn"))):(e.classList.add(this.getMappedStyle("selectaffordancetoprow")),t.classList.add(this.getMappedStyle("selectaffordancebottomrow")));else if(t){let e;e=i||"row"!==s?i||"column"!==s?"selectaffordancebottomcornerbounded":"selectaffordancebottomcolumn":"selectaffordancebottomrow",t.classList.add(this.getMappedStyle(e))}},A.prototype._clearRoundedAffordanceClasses=function(e,t){e&&(e.classList.remove(this.getMappedStyle("selectaffordancetopcornerbounded")),e.classList.remove(this.getMappedStyle("selectaffordancetopcolumn")),e.classList.remove(this.getMappedStyle("selectaffordancetoprow"))),t.classList.remove(this.getMappedStyle("selectaffordancebottomcornerbounded")),t.classList.remove(this.getMappedStyle("selectaffordancebottomcolumn")),t.classList.remove(this.getMappedStyle("selectaffordancebottomrow"))},A.prototype._removeTouchSelectionAffordance=function(e){(this._isDatabodyCellActive()||e)&&this.m_topSelectIconContainer&&this.m_topSelectIconContainer.parentNode&&(this.m_topSelectIconContainer.parentNode.removeChild(this.m_topSelectIconContainer),this.m_bottomSelectIconContainer.parentNode.removeChild(this.m_bottomSelectIconContainer))},A.prototype._moveTouchSelectionAffordance=function(){var e,t,i=this.getResources().isRTLMode()?"right":"left",s=this.GetSelection();let n=this.m_databody,o=this.m_databody;if(s.length>0){var r=this.m_options.getSelectionMode(),l=this._getTouchSelectionAffordanceSize();if(null!=this.m_topSelectIconContainer&&null!=this.m_bottomSelectIconContainer){var a=this.m_topSelectIconContainer.firstElementChild,h=this.m_bottomSelectIconContainer.firstElementChild;if(this._clearRoundedAffordanceClasses(a,h),"row"===r||-1!==s[s.length-1].endIndex.row&&-1===s[s.length-1].endIndex.column){if(this._addRoundedAffordanceClasses(a,h,!1,"row"),s[s.length-1]?.startKey?.row){let t=s[s.length-1].startKey.row;e=this._getAxisCellsByKey(t,"row")}else s[s.length-1]?.startIndex?.row&&(e=this._getAxisCellsByIndex(s[s.length-1].startIndex.row,"row"));if(s[s.length-1]?.endKey?.row){let e=s[s.length-1].endKey.row;t=this._getAxisCellsByKey(e,"row")}else s[s.length-1]?.endIndex?.row&&(t=this._getAxisCellsByIndex(s[s.length-1].endIndex.row,"row"));let r;if(t&&t.length&&(r=t[0]),!r){let e=this.createIndex(-1,0),t=this.getElementsInRange(this.createRange(e,e));r=t[t.length-1]}n=e[0].parentNode.parentNode,o=t[0].parentNode.parentNode,this.setElementDir(this.m_topSelectIconContainer,this.getElementDir(e[0],"top")-this.m_touchSelectionAffordanceHeight-1,"top"),this.setElementDir(this.m_bottomSelectIconContainer,this.getElementDir(r,"top")+this.getElementHeight(r)-l+this.m_touchSelectionAffordanceHeight,"top");const d=this.getElementWidth(n)/2+this.m_currentScrollLeft-l/2;this.setElementDir(this.m_topSelectIconContainer,d,i),this.setElementDir(this.m_bottomSelectIconContainer,d,i)}else if(-1!==s[s.length-1].endIndex.column&&-1===s[s.length-1].endIndex.row){if(this._addRoundedAffordanceClasses(a,h,!1,"column"),s[s.length-1]?.startKey?.column){let t=s[s.length-1].startKey.column;e=this._getAxisCellsByKey(t,"column")}else s[s.length-1]?.startIndex?.column&&(e=this._getAxisCellsByIndex(s[s.length-1].startIndex.column,"column"));if(s[s.length-1]?.endKey?.column){let e=s[s.length-1].endKey.column;t=this._getAxisCellsByKey(e,"column")}else s[s.length-1]?.endIndex?.column&&(t=this._getAxisCellsByIndex(s[s.length-1].endIndex.column,"column"));n=e[0].parentNode.parentNode,o=t[0].parentNode.parentNode;var d=this.getElementHeight(n)/2+this.m_currentScrollTop-l/2;this.setElementDir(this.m_topSelectIconContainer,d,"top"),this.setElementDir(this.m_bottomSelectIconContainer,d,"top"),this.setElementDir(this.m_topSelectIconContainer,this.getElementDir(e[0],"left")-this.m_touchSelectionAffordanceWidth-2,"left"),this.setElementDir(this.m_bottomSelectIconContainer,this.getElementDir(t[0],"left")+this.getElementWidth(t[0])-(l-this.m_touchSelectionAffordanceWidth-1),"left")}else{this._addRoundedAffordanceClasses(a,h,!0);var m=this._getCellByIndex(s[s.length-1].startIndex),c=this._getCellByIndex(s[s.length-1].endIndex);if(!c){let e=this.createIndex(-1,-1),t=this.getElementsInRange(this.createRange(e,e));c=t[t.length-1]}n=this._getCellContainer(m),o=this._getCellContainer(c),this.setElementDir(this.m_topSelectIconContainer,this.getElementDir(m,"top")-this.m_touchSelectionAffordanceHeight-1,"top"),this.setElementDir(this.m_bottomSelectIconContainer,this.getElementDir(c,"top")+this.getElementHeight(c)-l+this.m_touchSelectionAffordanceWidth,"top"),this.setElementDir(this.m_topSelectIconContainer,this.getElementDir(m,i)-this.m_touchSelectionAffordanceWidth-2,i),this.setElementDir(this.m_bottomSelectIconContainer,this.getElementDir(c,i)+this.getElementWidth(c)-(l-this.m_touchSelectionAffordanceWidth),i)}null!=this.m_topSelectIconContainer.parentNode&&this.m_topSelectIconContainer.parentNode===n||n.firstChild.appendChild(this.m_topSelectIconContainer),null!=this.m_bottomSelectIconContainer.parentNode&&this.m_bottomSelectIconContainer.parentNode===n||o.firstChild.appendChild(this.m_bottomSelectIconContainer)}}},A.prototype._scrollTouchSelectionAffordance=function(){var e,t,i=this.m_options.getSelectionMode();if("row"===i)null!=this.m_topSelectIconContainer&&(t=this.getResources().isRTLMode()?"right":"left",e=this.getElementWidth(this.m_databody)/2+this.m_currentScrollLeft,this.setElementDir(this.m_topSelectIconContainer,e,t),this.setElementDir(this.m_bottomSelectIconContainer,e,t));else if("cell"===i&&this.isHeaderSelectionType(this.m_selectionFrontier)&&null!=this.m_topSelectIconContainer)if(-1!==this.m_selectionFrontier.axis.indexOf("row"))t=this.getResources().isRTLMode()?"right":"left",e=this.getElementWidth(this.m_databody)/2+this.m_currentScrollLeft,this.setElementDir(this.m_topSelectIconContainer,e,t),this.setElementDir(this.m_bottomSelectIconContainer,e,t);else{var s=this.getElementHeight(this.m_databody)/2+this.m_currentScrollTop;this.setElementDir(this.m_topSelectIconContainer,s,"top"),this.setElementDir(this.m_bottomSelectIconContainer,s,"top")}},A.prototype._getTouchSelectionAffordanceSize=function(){if(null==this.m_touchSelectionAffordanceSize){var e=document.createElement("div");e.className=this.getMappedStyle("toucharea"),e.style.visibilty="hidden",e.style.top="0px",e.style.visibilty="0px",this.m_root.appendChild(e);var t=e.offsetWidth;this.m_root.removeChild(e),this.m_touchSelectionAffordanceSize=t}return this.m_touchSelectionAffordanceSize},A.SORT_ANIMATION_DURATION=800,A.prototype._handleSortContainerMouseOver=function(e){var t=e.target;let i=this.findHeader(t)||this.findLabel(t);var s=this._getSortIcon(i),n=this._getSortContainer(i);this.m_utils.containsCSSClassName(e.currentTarget,this.getMappedStyle("sortIcon"))&&(this.m_utils.addCSSClassName(e.currentTarget,this.getMappedStyle("hover")),this.m_utils.addCSSClassName(s,this.getMappedStyle("hover")),this.m_utils.removeCSSClassName(n,this.getMappedStyle("iconHidden")))},A.prototype._handleSortMouseOut=function(e){if(!this._databodyEmpty()){var t=e.target,i=e.relatedTarget;let o=this.findHeader(t),r=!1;var s;!o&&this.findLabel(t)&&(r=!0,o=this.findLabel(t)),null!=o&&null!=i&&o===this.findHeader(i)&&o===this.findLabel(i)||this._displaySortIcon(o,r),(s=this._getSortIcon(o))&&this.m_utils.removeCSSClassName(s,this.getMappedStyle("hover"));var n=this._getSortContainer(o);if(n){this.m_utils.removeCSSClassName(n,this.getMappedStyle("hover")),this.m_utils.removeCSSClassName(n,this.getMappedStyle("selected"));const e=o[this.getResources().getMappedAttribute("context")];this.m_utils.containsCSSClassName(s,this.getMappedStyle("selected"))||"unsorted"!==e.metadata?.sortDirection||n.classList.add(this.getMappedStyle("iconHidden"))}}},A.prototype._handleSortIconMouseDown=function(e,t){const i=this.m_utils.containsCSSClassName(e,this.getMappedStyle("sortIcon"))?e.lastChild:e;if(!this._databodyEmpty()){this.m_utils.addCSSClassName(i,this.getMappedStyle("selected"));this._getSortContainer(t).classList.remove(this.getMappedStyle("iconHidden"))}},A.prototype._toggleSortIconDirection=function(e,t){if(null!=e){var i=this._getSortIcon(e);"descending"===t&&(this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortascending"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortdefault")))?(this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortascending")),this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortdefault")),this.m_utils.addCSSClassName(i,this.getMappedStyle("sortdescending")),i.setAttribute("title",this.getResources().getTranslatedText("labelSortAsc"))):"ascending"===t&&(this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortdescending"))||this.m_utils.containsCSSClassName(i,this.getMappedStyle("sortdefault")))?(this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortdescending")),this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortdefault")),this.m_utils.addCSSClassName(i,this.getMappedStyle("sortascending")),i.setAttribute("title",this.getResources().getTranslatedText("labelSortDsc"))):"default"===t&&(this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortdescending")),this.m_utils.removeCSSClassName(i,this.getMappedStyle("sortascending")),this.m_utils.addCSSClassName(i,this.getMappedStyle("sortdefault")),i.setAttribute("title",this.getResources().getTranslatedText("labelSortAsc")))}},A.prototype._displaySortIcon=function(e,t){var i=!1;if(null!=e){var s=this._getSortIcon(e);if(this._isDataGridProvider()){if(this._isDataGridProvider()){let s=t?this.getHeaderLabelAxis(e):this.getHeaderCellAxis(e);"column"===s?i=t?this.m_sortRowInfo?.level===this.getHeaderLabelLevel(e):this.m_sortColumnInfo?.key===this._getKey(e):"row"===s&&(i=t?this.m_sortColumnInfo?.level===this.getHeaderLabelLevel(e):this.m_sortRowInfo?.key===this._getKey(e))}}else i=this.m_sortColumnInfo?.key===this._getKey(e);i&&this.m_utils.addCSSClassName(s,this.getMappedStyle("default"))}},A.prototype._populateSortIcon=function(e,t,i,s){let n=i.split(" ");for(let t=0;t<n.length;t++)this.m_utils.addCSSClassName(e,n[t]);return"ascending"===s?(this.m_utils.addCSSClassName(e,this.getMappedStyle("sortascending")),t.setAttribute(this.getResources().getMappedAttribute("sortDir"),s),e.setAttribute("title",this.getResources().getTranslatedText("labelSortDsc"))):"descending"===s?(this.m_utils.addCSSClassName(e,this.getMappedStyle("sortdescending")),t.setAttribute(this.getResources().getMappedAttribute("sortDir"),s),e.setAttribute("title",this.getResources().getTranslatedText("labelSortAsc"))):(this.m_utils.addCSSClassName(e,this.getMappedStyle("sortdefault")),e.setAttribute("title",this.getResources().getTranslatedText("labelSortAsc"))),e},A.prototype._buildHiddenSortIcon=function(e,t,i){e.className=this.getMappedStyle("sortdefault")+" "+i,e.setAttribute("title",this.getResources().getTranslatedText("labelSortAsc")),t.classList.add(this.getMappedStyle("iconHidden"))},A.prototype._buildSortIcon=function(e,t,i){var s=document.createElement("div");this.m_utils.addCSSClassName(s,this.getMappedStyle("iconContainer")),this.m_utils.addCSSClassName(s,this.getMappedStyle("sortIcon"));var n=document.createElement("div"),o=this.getMappedStyle("icon")+" "+this.getMappedStyle("clickableicon");let r=null,l=null;return this._isDataGridProvider()?"column"===i&&"header"===this.m_sortColumnInfo?.type?(r=this.m_sortColumnInfo.key,l=this.m_sortColumnInfo.direction):"row"===i&&"header"===this.m_sortRowInfo?.type&&(r=this.m_sortRowInfo.key,l=this.m_sortRowInfo.direction):(r=this.m_sortColumnInfo?.axis===i?this.m_sortColumnInfo?.key:null,l=this.m_sortColumnInfo?.axis===i?this.m_sortColumnInfo?.direction:null),e.key===r?this._populateSortIcon(n,t,o,l):this._buildHiddenSortIcon(n,s,o),s.appendChild(n),s.addEventListener("mouseover",this._handleSortContainerMouseOver.bind(this)),s},A.prototype._buildLabelSortIcon=function(e,t,i){const s=document.createElement("div");this.m_utils.addCSSClassName(s,this.getMappedStyle("iconContainer")),this.m_utils.addCSSClassName(s,this.getMappedStyle("sortIcon"));const n=document.createElement("div"),o=this.getMappedStyle("icon")+" "+this.getMappedStyle("clickableicon");let r=null,l=null;return this._isDataGridProvider()&&("row"===i||"rowEnd"===i?(r=this.m_sortColumnInfo?.axis===i?this.m_sortColumnInfo.level:null,l=this.m_sortColumnInfo?.axis===i?this.m_sortColumnInfo.direction:null):(r=this.m_sortRowInfo?.axis===i?this.m_sortRowInfo.level:null,l=this.m_sortRowInfo?.axis===i?this.m_sortRowInfo.direction:null),e.level===r?this._populateSortIcon(n,t,o,l):this._buildHiddenSortIcon(n,s,o)),s.appendChild(n),s.addEventListener("mouseover",this._handleSortContainerMouseOver.bind(this)),s},A.prototype._handleKeyboardSort=function(e,t){if(!this._databodyEmpty()){var i=e.getAttribute(this.getResources().getMappedAttribute("sortDir"));i=null==i||"descending"===i?"ascending":"descending","header"===(this.find(e,"headerlabel")?"label":"header")?this._doHeaderSort(t,e,i):this._doHeaderLabelSort(t,e,i)}},A.prototype._handleHeaderSort=function(e,t){if(!this._databodyEmpty()){var i=e.target,s=this.findHeader(i);if(null!=s){const e=this.getHeaderCellAxis(s);null==t&&(this._isDataGridProvider()?(t="ascending","column"===e&&"header"===this.m_sortColumnInfo?.type&&this.m_sortColumnInfo?.key===this._getKey(s)?t="ascending"===this.m_sortColumnInfo?.direction?"descending":"ascending":"row"===e&&"header"===this.m_sortRowInfo?.type&&this.m_sortRowInfo?.key===this._getKey(s)&&(t="ascending"===this.m_sortRowInfo?.direction?"descending":"ascending")):(t="ascending",this.m_sortColumnInfo?.key===this._getKey(s)&&"ascending"===this.m_sortColumnInfo.direction&&(t="descending")))}this._doHeaderSort(e,s,t)}},A.prototype._handleHeaderLabelSort=function(e,t,i){if(!this._databodyEmpty()){const s=this.getResources().getMappedAttribute("context");if(null!=t){let n=t[s].axis;if(void 0===i){let e=this.m_sortRowInfo;"row"!==n&&"rowEnd"!==n||(e=this.m_sortColumnInfo),i=e?.axis===n&&"label"===e.type&&"ascending"===e.direction?"descending":"ascending"}this._doHeaderLabelSort(e,t,i)}}},A.prototype._handleCellSort=function(e,t,i){null==i||this._databodyEmpty()||(this._removeTouchSelectionAffordance(),this._doHeaderSort(e,i,t))},A.prototype._doHeaderSort=function(e,t,i){if(!0!==this.m_isSorting){this.m_delayedSort=null;var s=this._getKey(t),n=this._getAxis(t);if(this._removeSortSelection(n),t.setAttribute(this.getResources().getMappedAttribute("sortDir"),i),"column"!==n&&this._isDataGridProvider()?(this.m_sortRowInfo={event:e,key:s,axis:n,direction:i,header:t,type:"header"},"header"===this.m_sortColumnInfo?.type&&(this.m_sortColumnInfo={})):(this.m_sortColumnInfo={event:e,key:s,axis:n,direction:i,header:t,type:"header"},"header"===this.m_sortRowInfo?.type&&(this.m_sortRowInfo={})),this._toggleSortIconDirection(t,i),this._addSortSelection(n),this._setAccInfoText("ascending"===i?"accessibleSortAscending":"accessibleSortDescending",{id:s}),null!=i&&null!=s&&null!=n)if(this._isDataGridProvider())this._fireSortRequestEvent(n);else{this.m_isSorting=!0,this.showStatusText(!this.isSkeletonSupport());var o={axis:n,key:s,direction:i};this.getDataSource().sort(o,{success:this._handleSortSuccess.bind(this),error:this._handleSortError.bind(this)})}}else this.m_delayedSort={event:e,header:t,direction:i}},A.prototype._doHeaderLabelSort=function(e,t,i){const s=this.getHeaderLabelAxis(t),n=this.getHeaderLabelLevel(t);t.setAttribute(this.getResources().getMappedAttribute("sortDir"),i),"row"===s||"rowEnd"===s?this.m_sortColumnInfo={event:e,level:n,axis:s,direction:i,label:t,type:"label"}:this.m_sortRowInfo={event:e,level:n,axis:s,direction:i,label:t,type:"label"},this._toggleSortIconDirection(t,i),this._setAccInfoText("ascending"===i?"accessibleSortAscending":"accessibleSortDescending",{id:n}),null!=i&&null!=n&&null!=s&&this._isDataGridProvider()&&this._fireSortLabelRequestEvent(t,s)},A.prototype._handleSortError=function(){this.hideStatusText()},A.prototype._removeSortSelection=function(e){let t="column"===e?this.m_sortColumnInfo:this.m_sortRowInfo;if(null!=t&&"header"===t.type){var i;if(!(i="column"===e?this._findHeaderByKey(t.key,this.m_colHeader,this.getMappedStyle("colheadercell")):this._findHeaderByKey(t.key,this.m_rowHeader,this.getMappedStyle("rowheadercell"))))return;i.removeAttribute(this.getResources().getMappedAttribute("sortDir"));var s=this._getSortIcon(i);this._toggleSortIconDirection(i,"default"),"descending"===t.direction&&(this.m_utils.removeCSSClassName(s,this.getMappedStyle("sortdescending")),this.m_utils.addCSSClassName(s,this.getMappedStyle("sortascending"))),this.m_utils.removeCSSClassName(s,this.getMappedStyle("default")),this.m_utils.removeCSSClassName(s,this.getMappedStyle("selected"));this._getSortContainer(i).classList.add(this.getMappedStyle("iconHidden"))}},A.prototype._addSortSelection=function(e){let t="column"===e?this.m_sortColumnInfo:this.m_sortRowInfo;if(null!=t&&"header"===t.type){var i;i="column"===e?this._findHeaderByKey(t.key,this.m_colHeader,this.getMappedStyle("colheadercell")):this._findHeaderByKey(t.key,this.m_rowHeader,this.getMappedStyle("rowheadercell"));var s=this._getSortIcon(i);this.m_utils.addCSSClassName(s,this.getMappedStyle("default")),this.m_utils.addCSSClassName(s,this.getMappedStyle("selected"));this._getSortContainer(i).classList.remove(this.getMappedStyle("iconHidden"))}},A.prototype._getAxis=function(e){var t=this.getMappedStyle("colheadercell"),i=this.getMappedStyle("rowheadercell");return this.m_utils.containsCSSClassName(e,t)?"column":this.m_utils.containsCSSClassName(e,i)?"row":null},A.prototype._handleSortSuccess=function(){this.hideStatusText(),this._isDatabodyCellActive()?this._indexes({row:this.m_active.keys.row,column:this.m_active.keys.column},this._handlePreSortScrolling):this._fetchForSort(this.m_startRow,this.m_endRow-this.m_startRow+1,!1)},A.prototype._handlePreSortScrolling=function(e){var t=(-1===e.row?0:e.row)*this.m_avgRowHeight,i=t+this.m_avgRowHeight,s=this._isHighWatermarkScrolling();if(this.m_currentScrollTop<=t&&i<=this.m_currentScrollTop+this.getElementHeight(this.m_databody)||s)this._fetchForSort(this.m_startRow,this.m_endRow-this.m_startRow+1,!1);else{this.m_currentScrollTop=Math.min(t,this._getMaxScrollHeight());var n=Math.floor(this.m_currentScrollTop/this.m_avgRowHeight),o=n*this.m_avgRowHeight;this.m_startRow=n,this.m_endRow=-1,this.m_startRowHeader=n,this.m_endRowHeader=-1,this.m_startRowPixel=o,this.m_endRowPixel=o,this.m_startRowHeaderPixel=o,this.m_endRowHeaderPixel=o,this._fetchForSort(n,null,!0)}},A.prototype._fetchForSort=function(e,t,i){var s=document.createDocumentFragment(),n=document.createDocumentFragment();this.fetchHeaders("row",e,s,n,t,{success:this.handleHeadersFetchSuccessForSort.bind(this),error:this.handleCellsFetchError}),this.fetchCells(this.m_databody,e,this.m_startCol,t,this.m_endCol-this.m_startCol+1,{success:this.handleCellsFetchSuccessForSort.bind(this,s,n,i),error:this.handleCellsFetchError})},A.prototype.handleHeadersFetchSuccessForSort=function(e,t,i,s){var n,o,r,l,a,h,d,m=t.axis,c=t.start,u=t.header,_=t.endHeader;if(this.m_fetching[m]=!1,null!=e){for(n=e.getCount(),l=0,o=0,h=this.getMappedStyle("headercell")+" "+this.getMappedStyle("rowheadercell"),d=this.getRendererOrTemplate("row");n-o>0;)r=c+o,o+=(a=this.buildLevelHeaders(u,r,0,0,this.m_startRowPixel+l,!0,s,d,e,"row",h,this.m_rowHeaderLevelCount)).count,l+=a.totalHeaderDimension;this.m_endRowHeader=this.m_startRowHeader+(n-1),this.m_endRowHeaderPixel=this.m_startRowHeaderPixel+l}if(null!=i){for(n=i.getCount(),l=0,o=0,h=this.getMappedStyle("endheadercell")+" "+this.getMappedStyle("rowendheadercell"),d=this.getRendererOrTemplate("rowEnd");n-o>0;)r=c+o,o+=(a=this.buildLevelHeaders(_,r,0,0,this.m_startRowPixel+l,!0,s,d,i,"rowEnd",h,this.m_rowEndHeaderLevelCount)).count,l+=a.totalHeaderDimension;this.m_endRowEndHeader=this.m_startRowEndHeader+(n-1),this.m_endRowEndHeaderPixel=this.m_startRowEndHeaderPixel+l}this._signalTaskEnd()},A.prototype.handleCellsFetchSuccessForSort=function(e,t,i,s,n){var o;this.m_fetching.cells=!1;var r=A.SORT_ANIMATION_DURATION;this.isFetchComplete()&&this.hideStatusText();var l=n[0].start,a=s.getCount("row"),h=n[1].start,d=document.createDocumentFragment(),m=this._addCellsToFragment(d,s,l,this.m_startRowPixel,h,this.m_startColPixel);this.m_endRow=this.m_startRow+(a-1),this.m_endRowPixel=this.m_startRowPixel+m.totalRowHeight;var c=this.m_databody.firstChild,_=this.m_rowHeader.firstChild,p=this.m_rowEndHeader.firstChild;if(!0===i&&(o=this._isHighWatermarkScrolling(),this.m_utils.isTouchDeviceNotIOS()?(this._disableTouchScrollAnimation(),this.scrollTo(this.m_currentScrollLeft,this.m_currentScrollTop)):(this.m_silentScroll=!0,this.m_databody.scrollTop=this.m_currentScrollTop,this._syncScroller())),!r||1===a||this.m_rowHeaderLevelCount>1&&null!=this.m_rowHeaderLevelCount||!1===o)this._signalTaskStart(),this._handleSortEnd(d,e,t);else if(this.m_isCustomElementCallback()){this._signalTaskStart("processing sort render");let i=document.createElement("div"),s=document.createElement("div"),n=document.createElement("div");i.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),s.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),n.setAttribute(this.getResources().getMappedAttribute("busyContext"),""),i.className=this.getMappedStyle("info"),s.className=this.getMappedStyle("info"),n.className=this.getMappedStyle("info"),i.appendChild(d),s.appendChild(e),n.appendChild(t),this.m_root.appendChild(i),this.m_root.appendChild(s),this.m_root.appendChild(n);var g=u.getContext(i).getBusyContext().whenReady(),f=u.getContext(s).getBusyContext().whenReady(),C=u.getContext(n).getBusyContext().whenReady();Promise.all([g,f,C]).then(function(){for(;i.childNodes.length>0;)d.appendChild(i.childNodes[0]);for(;s.childNodes.length>0;)e.appendChild(s.childNodes[0]);for(;n.childNodes.length>0;)t.appendChild(n.childNodes[0]);this.m_root.removeChild(i),this.m_root.removeChild(s),this.m_root.removeChild(n),this._signalTaskEnd(),this.processSortAnimationToPosition(r,0,"ease-in",_,e,c,d,p,t)}.bind(this))}else this.processSortAnimationToPosition(r,0,"ease-in",_,e,c,d,p,t);this._signalTaskEnd()},A.prototype._handleSortEnd=function(e,t,i,s,n,o){var r;if(t.childNodes.length>1){if(r=this.m_rowHeader.firstChild,n)for(let e=0;e<n.length;e++){let i=n[e];t.insertBefore(i.element,t.childNodes[i.index])}this.m_utils.empty(r),r.appendChild(t),this.m_subtreeAttachedCallback(r)}if(i.childNodes.length>1){if(r=this.m_rowEndHeader.firstChild,o)for(let e=0;e<o.length;e++){let t=o[e];i.insertBefore(t.element,i.childNodes[t.index])}this.m_utils.empty(r),r.appendChild(i),this.m_subtreeAttachedCallback(r)}var l=this.m_databody.firstChild,a=this.m_rowHeader.firstChild,h=this.m_rowEndHeader.firstChild;if(s)for(let t=0;t<s.length;t++)e.appendChild(s[t]);this._emptyDatabody(l),this._populateDatabody(l,e),this._fireSortEvent(),this._restoreActive(),this.m_isSorting=!1,this._doDelayedSort(),this.m_animating=!1;for(let e=0;e<l.childNodes.length;e++)this.removeTransformMoveStyle(l.childNodes[e]);if(-1!==this.m_endRowHeader)for(let e=0;e<a.childNodes.length;e++)this.removeTransformMoveStyle(a.childNodes[e]);if(-1!==this.m_endRowEndHeader)for(let e=0;e<h.childNodes.length;e++)this.removeTransformMoveStyle(h.childNodes[e]);this._signalTaskEnd(),this._runModelEventQueue()},A.prototype.processSortAnimationToPosition=function(e,t,i,s,n,o,r,l,a){var h,d,m,c,u,_,p,g,f,C,y=this;this._signalTaskStart();var E=n.childNodes.length>1,v=a.childNodes.length>1,w=this.getResources().isRTLMode()?"right":"left",b=this._getViewportBottom(),H=this._getViewportLeft(),x=this._getViewportRight(),S={},R={},I=[];for(c=0;c<o.childNodes.length;c++)u=o.childNodes[c],h=this._getKey(u,"row"),C=(f=this.getElementDir(u,w))+this.getElementWidth(u),_=(d=this.getElementDir(u,"top"))+this.getElementHeight(u),this._isCellBoundaryInViewport(f,C,d,_)&&(S[h]?S[h].cell.push(u):(m=b,S[h]={cell:[u],oldTop:d,newTop:m}),m-d!=0&&(g=u));for(c=0;c<s.childNodes.length;c++)E&&(u=s.childNodes[c],h=this._getKey(u,"row"),_=(d=this.getElementDir(u,"top"))+this.getElementHeight(u),this._isCellBoundaryInViewport(H,x,d,_)&&(m=b,S[h]||(S[h]={oldTop:d,newTop:m}),S[h].rowHeader=u));for(c=0;c<l.childNodes.length;c++)E&&(u=l.childNodes[c],h=this._getKey(u,"row"),_=(d=this.getElementDir(u,"top"))+this.getElementHeight(u),this._isCellBoundaryInViewport(H,x,d,_)&&(m=b,S[h]||(S[h]={oldTop:d,newTop:m}),S[h].rowEndHeader=u));for(c=0;c<r.childNodes.length;c++)u=r.childNodes[c],h=this._getKey(u,"row"),m=this.getElementDir(u,"top"),S[h]?S[h].newTop=m:(d=b,p=m+this.getElementHeight(u),C=(f=this.getElementDir(u,w))+this.getElementWidth(u),this._isCellBoundaryInViewport(f,C,m,p)&&(u.style.transform="translate3d(0px,"+d+"px,0px)",I.push(u),R[h]?R[h].cell.push(u):R[h]={cell:[u],oldTop:d,newTop:m,add:!0},m-d!=0&&(g=u)));for(let e=0;e<I.length;e++)o.appendChild(I[e]);var M=[];for(c=0;c<n.childNodes.length;c++)if(E){var F=n.childNodes[c];h=this._getKey(F,"row"),S[h]||(p=(m=this.getElementDir(F,"top"))+this.getElementHeight(F),d=b,this._isCellBoundaryInViewport(H,x,m,p)&&(F.style.transform="translate3d(0px,"+d+"px,0px)",M.push({element:F,index:c}),R[h]||(R[h]={oldTop:d,newTop:m,add:!0}),R[h].rowHeader=F))}for(let e=0;e<M.length;e++)s.appendChild(M[e].element);var z=[];for(c=0;c<a.childNodes.length;c++)if(v){var D=a.childNodes[c];h=this._getKey(D,"row"),S[h]||(p=(m=this.getElementDir(D,"top"))+this.getElementHeight(D),d=b,this._isCellBoundaryInViewport(H,-1,m,p)&&(D.style.transform="translate3d(0px,"+d+"px,0px)",z.push({element:D,index:c}),R[h].rowEndHeader=D,R[h]||(R[h]={oldTop:d,newTop:m,add:!0})))}for(let e=0;e<z.length;e++)l.appendChild(z[e].element);if(null!=g){var A=this._handleSortEnd.bind(this,r,n,a,I,M,z);y._onEndEvent("transitionend",g,A,e),this.m_animating=!0,setTimeout(function(){var s,n,o,r,l=0,a=Object.keys(S);for(r=0;r<a.length;r++){if(h=a[r],o=S[a[r]],n=t+"ms",s=o.newTop-o.oldTop,o.cell)for(l=0;l<o.cell.length;l++)y.addTransformMoveStyle(o.cell[l],e/2+"ms",n,i,0,s,0);E&&o.rowHeader&&y.addTransformMoveStyle(o.rowHeader,e/2+"ms",n,i,0,s,0),v&&o.rowEndHeader&&y.addTransformMoveStyle(o.rowEndHeader,e/2+"ms",n,i,0,s,0)}for(a=Object.keys(R),r=0;r<a.length;r++){if(h=a[r],o=R[a[r]],n=t*l+"ms",s=0,o.cell)for(var d=0;d<o.cell.length;d++)y.addTransformMoveStyle(o.cell[d],e/2+"ms",n,i,0,s,0);E&&o.rowHeader&&y.addTransformMoveStyle(o.rowHeader,e/2+"ms",n,i,0,s,0),v&&o.rowEndHeader&&y.addTransformMoveStyle(o.rowEndHeader,e/2+"ms",n,i,0,s,0)}},0)}else this._handleSortEnd(r,n,a)},A.prototype._restoreActive=function(){if(null!=this.m_active){var e=this.m_active.axis,t=this.m_sortColumnInfo.originalEvent;if("cell"===this.m_active.type){var i=this._getCellByKeys(this.m_active.keys);if(null!=i){var s=this.getCellIndexes(i);this._isSelectionEnabled()?this.selectAndFocus(s,t):this._setActiveByIndex(s,t)}else this._setActive(null,null,t,!0),this._isSelectionEnabled()&&this._clearSelection(t)}else if("row"===e||"rowEnd"===e){var n="row"===e?this.m_rowHeader:this.m_rowEndHeader,o="row"===e?this.getMappedStyle("rowheadercell"):this.getMappedStyle("rowendheadercell"),r=this._findHeaderByKey(this.m_active.key,n,o);if(null!=r){var l=r[this.getResources().getMappedAttribute("context")];this._setActive(r,{type:"header",axis:e,index:l.index,key:l.key,level:l.level},t)}else this._setActive(null,null,t)}}},A.prototype._getSortIcon=function(e){return this._getSortContainer(e).firstChild},A.prototype._getSortContainer=function(e){return e.querySelector("."+this.getMappedStyle("sortIcon"))},A.prototype._fireSortEvent=function(){var e={event:this.m_sortColumnInfo.event,ui:{header:this.m_sortColumnInfo.key,direction:this.m_sortColumnInfo.direction}};this.fireEvent("sort",e)},A.prototype._fireSortRequestEvent=function(e){let t="column"===e?this.m_sortColumnInfo:this.m_sortRowInfo,i=t.header[this.getResources().getMappedAttribute("context")],s=t.header[this.getResources().getMappedAttribute("metadata")],n=this.buildHeaderTemplateContext(i,s).item;var o={event:t.event,ui:{direction:t.direction,item:n,axis:t.axis}};this.fireEvent("sortRequest",o)},A.prototype._fireSortLabelRequestEvent=function(e,t){let i=e[this.getResources().getMappedAttribute("context")],s={metadata:i.metadata},n=this.buildLabelTemplateContext(i,s).item,o=this.m_sortRowInfo;if("row"!==t&&"rowEnd"!==t||(o=this.m_sortColumnInfo),o){var r={event:o.event,ui:{direction:o.direction,item:n,axis:t,level:o.level}};this.fireEvent("sortLabelRequest",r)}},A.prototype._doDelayedSort=function(){null!=this.m_delayedSort?this._doHeaderSort(this.m_delayedSort.event,this.m_delayedSort.header,this.m_delayedSort.direction):this.fillViewport()},A.prototype._isSortIcon=function(e){return this.m_utils.containsCSSClassName(e,this.getMappedStyle("sortascending"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("sortdescending"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("sortdefault"))||this.m_utils.containsCSSClassName(e,this.getMappedStyle("sortIcon"))},A.prototype._fireExpandRequestEvent=function(e){const t=this.findHeader(e.target),i=t[this.getResources().getMappedAttribute("context")],s=t[this.getResources().getMappedAttribute("metadata")];s.metadata.expanded="expanded";const n={item:this.buildHeaderTemplateContext(i,s).item,axis:i.axis},o=this._getDisclosureIcon(t);this.m_utils.removeCSSClassName(o,this.getMappedStyle("collapsed")),this.m_utils.addCSSClassName(o,this.getMappedStyle("expanded")),this.fireEvent("expandRequest",n)},A.prototype._fireCollapseRequestEvent=function(e){const t=this.findHeader(e.target),i=t[this.getResources().getMappedAttribute("context")],s=t[this.getResources().getMappedAttribute("metadata")];s.metadata.expanded="collapsed";const n={item:this.buildHeaderTemplateContext(i,s).item,axis:i.axis},o=this._getDisclosureIcon(t);this.m_utils.removeCSSClassName(o,this.getMappedStyle("expanded")),this.m_utils.addCSSClassName(o,this.getMappedStyle("collapsed")),this.fireEvent("collapseRequest",n)},A.prototype._handleExpandCollapseRequest=function(e){this._isHeaderExpanded(e.target)?this._fireCollapseRequestEvent(e):this._isHeaderCollapsed(e.target)&&this._fireExpandRequestEvent(e)},A.prototype._isTargetExpandCollapseEnabled=function(e){return this._isHeaderCollapsed(e)||this._isHeaderExpanded(e)},A.prototype._isHeaderCollapsed=function(e){const t=this._getDisclosureIcon(e);return!!t&&this.m_utils.containsCSSClassName(t,this.getMappedStyle("collapsed"))},A.prototype._isHeaderExpanded=function(e){const t=this._getDisclosureIcon(e);return!!t&&this.m_utils.containsCSSClassName(t,this.getMappedStyle("expanded"))},A.prototype._buildDisclosureIcon=function(e){const t=document.createElement("div");t.classList.add(this.getMappedStyle("iconContainer")),t.classList.add(this.getMappedStyle("disclosureIcon"));const i=document.createElement("div");let s;return i.classList.add(this.getMappedStyle("icon")),i.classList.add(this.getMappedStyle("clickableicon")),"expanded"===e.metadata.expanded?(i.classList.add(this.getMappedStyle("expanded")),s=this.getResources().getTranslatedText("collapsedText")):"collapsed"===e.metadata.expanded&&(i.classList.add(this.getMappedStyle("collapsed")),s=this.getResources().getTranslatedText("expandedText")),t.setAttribute("title",s),t.appendChild(i),t.addEventListener("mouseover",this._handleExpandCollapseContainerMouseOver.bind(this)),t.addEventListener("mouseout",this._handleDisclosureMouseOut.bind(this)),t},A.prototype._handleExpandCollapseContainerMouseOver=function(e){const t=e.target,i=this.findHeader(t),s=this._getDisclosureIcon(i);this.m_utils.containsCSSClassName(e.currentTarget,this.getMappedStyle("disclosureIcon"))&&(this.m_utils.addCSSClassName(e.currentTarget,this.getMappedStyle("hover")),this.m_utils.addCSSClassName(s,this.getMappedStyle("hover")),this.m_utils.removeCSSClassName(s,this.getMappedStyle("disabled")))},A.prototype._buildSpacer=function(e){const t=document.createElement("span");return this._addDataGridSpacerClass(t),this._addIndentation(e,t),t},A.prototype._getTreeDepth=function(e){return e.metadata.treeDepth?e.metadata.treeDepth:null},A.prototype._addDataGridSpacerClass=function(e){this.m_utils.addCSSClassName(e,this.getMappedStyle("spacer"))},A.prototype._isLeaf=function(e){return!e.metadata.expanded||null===e.metadata.expanded},A.prototype._addIndentation=function(e,t){let i=this._getTreeDepth(e);null!==i&&this._appendSpacerClass(i,t,e)},A.prototype._appendSpacerClass=function(e,t,i){t.style.width=e*A.SPACER_DEFAULT_WIDTH+(this._isLeaf(i)?A.SPACER_DEFAULT_WIDTH:0)+"rem"},A.prototype._handleDisclosureMouseOut=function(e){const t=e.target,i=this.findHeader(t),s=this._getDisclosureIcon(i);this.m_utils.containsCSSClassName(e.currentTarget,this.getMappedStyle("disclosureIcon"))&&(this.m_utils.removeCSSClassName(e.currentTarget,this.getMappedStyle("hover")),this.m_utils.removeCSSClassName(s,this.getMappedStyle("hover")))},A.prototype._isDisclosureIcon=function(e){return this.m_utils.containsCSSClassName(e,this.getMappedStyle("icon"))&&this.m_utils.containsCSSClassName(e.parentElement,this.getMappedStyle("disclosureIcon"))},A.prototype._getDisclosureIcon=function(e){return this._isDisclosureIcon(e)?e:e.getElementsByClassName(this.getMappedStyle("icon"))[0]};const L=function(e){this.datagridprovider=e,this.pendingHeaderCallback={},this._registerEventListeners(),this.totalRowCount=-1,this.totalColumnCount=-1,this.rowKeyMap=new O,this.columnKeyMap=new O,L.superclass.constructor.call(this)};function T(e,t,i){this.results=e,this.rowKeyMap=t,this.columnKeyMap=i,this.databodyResults=e.results.databody,this.rowStart=this.results.rowOffset,this.rowCount=this.results.rowCount,this.rowEnd=this.rowStart+this.rowCount-1,this.columnStart=this.results.columnOffset,this.columnCount=this.results.columnCount,this.columnEnd=this.columnStart+this.columnCount-1,this.lastItem=null}function N(e,t,i){this.results=e,this.axis=t,this.axisResults=e.results[this.axis+"Header"],this.axisLabels=e.results[this.axis+"HeaderLabel"],"row"===this.axis||"rowEnd"===this.axis?(this.start=this.results.rowOffset,this.count=this.results.rowCount):(this.start=this.results.columnOffset,this.count=this.results.columnCount),this.end=this.start+this.count-1,this.lastItem=null,this.keyMap=i,this.levelCount=null}function O(){this.keyMap=new Map,this.nextKey=0,this.set=(e,t,i,s)=>{const n=""+this.nextKey;null==s&&(s=1);for(let o=0;o<s;o++){let s=null==t?t:t+o,r=this.pairIndexLevel(e,s,i);this.keyMap.set(r,n)}return this.nextKey+=1,n},this.get=(e,t,i,s)=>{const n=this.pairIndexLevel(e,t,i);let o=this.keyMap.get(n);return null==o&&(o=this.set(e,t,i,s)),o},this.pairIndexLevel=(e,t,i)=>null==t||null!=i&&t===i-1?""+e:e+","+t,this.handleOffsetChange=e=>{let t=new Map;const i=[...this.keyMap.keys()];for(let s=0;s<i.length;s++){let n=i[s].split(",");parseInt(n[0],10)<e&&t.set(i[s],this.keyMap.get(i[s]))}this.keyMap=t},this.handleChange=(e,t)=>{let i=new Set;e.forEach(function(e){let t=e.offset,s=e.count;for(var n=0;n<s;n++)i.add(t+n)});let s=Array.from(i);s.sort(function(e,t){return e-t});let n=new Map;this.keyMap.forEach((e,i)=>{let o=i.split(","),r=parseInt(o[0],10),l=o[1];if(t&&s.some(e=>e===r))return;let a=0;if(r>=s[0]){let e=r;a=s.findIndex(i=>(!t&&e>=i&&(e+=1),i>e)),-1===a&&(a=s.length)}let h=t?r-a:r+a,d=this.pairIndexLevel(h,l);n.set(d,e)}),this.keyMap=n}}let k;async function P(){if(k)return k;const{default:t}=await new Promise(function(t,i){e(["@oracle/oraclejet-preact/translationBundle"],function(e){t(function(e){if(e&&e.__esModule)return e;var t={};return e&&Object.keys(e).forEach(function(i){var s=Object.getOwnPropertyDescriptor(e,i);Object.defineProperty(t,i,s.get?s:{enumerable:!0,get:function(){return e[i]}})}),t.default=e,t}(e))},i)});return k=w.getTranslationBundlePromiseFromLoader(t),k}d.Object.createSubclass(L,d.DataGridDataSource,"DataGridProviderDataGridDataSource"),L.prototype.fetchHeaders=function(e,t,i){if(null!=t){var s=e.axis,n={headerRange:e,callbacks:t,callbackObjects:i};this.pendingHeaderCallback[s]=n}},L.prototype.fetchCells=function(e,t,i){let s,n,o,r;for(let t=0;t<e.length;t+=1){let i=e[t];"row"===i.axis?(s=i.start,n=i.count):"column"===i.axis&&(o=i.start,r=i.count)}let l,a=this.pendingHeaderCallback.row,h=this.pendingHeaderCallback.column;this.pendingHeaderCallback={},l=a&&h?["all"]:a?["databody","rowHeader","rowEndHeader","rowHeaderLabel","rowEndHeaderLabel"]:h?["databody","columnHeader","columnEndHeader","columnHeaderLabel","columnEndHeaderLabel"]:["databody"];let d={rowOffset:s,columnOffset:o,rowCount:n,columnCount:r,fetchRegions:new Set(l)},m=(s,n)=>{let o,r,l;null!=n?(s.results=Object.assign({},s.results,n.results),null!=n.next&&(o=n.next)):null!=s.next&&(o=s.next),this.totalRowCount=s.totalRowCount,this.totalColumnCount=s.totalColumnCount;let d=s.results;if(h&&(!o||null!=d.columnHeader&&null!=d.columnEndHeader&&null!=d.columnHeaderLabel&&null!=d.columnEndHeaderLabel)&&(r=h.callbacks,null!=r&&null!=r.success)){let e,t;l=h.callbackObjects,null!=d.columnHeader&&(e=new N(s,"column",this.columnKeyMap)),null!=d.columnEndHeader&&(t=new N(s,"columnEnd",this.columnKeyMap)),r.success.call(l.success,e,h.headerRange,t),h=null}if(a&&(!o||null!=d.rowHeader&&null!=d.rowEndHeader&&null!=d.rowHeaderLabel&&null!=d.rowEndHeaderLabel)&&(r=a.callbacks,null!=r&&null!=r.success)){let e,t;l=a.callbackObjects,null!=d.rowHeader&&(e=new N(s,"row",this.rowKeyMap)),null!=d.rowEndHeader&&(t=new N(s,"rowEnd",this.rowKeyMap)),r.success.call(l.success,e,a.headerRange,t),a=null}if(null!=t&&null!=t.success&&!o){let n=new T(s,this.rowKeyMap,this.columnKeyMap);t.success.call(i.success,n,e)}o&&o.then(m.bind(this,s))};Promise.all([this.datagridprovider.fetchByOffset(d),P()]).then(e=>{m(e[0])},s=>{h?.callbacks?.error&&(h.callbacks.error.call(h.callbackObjects?.error,s,h.headerRange),h=null),a?.callbacks?.error&&(a.callbacks.error.call(a.callbackObjects?.error,s,a.headerRange),a=null),t?.error&&t.error.call(i?.error,s,e)})},L.prototype.getCapability=function(e){return"sort"===e?"full":"sort"===e||"move"===e?"none":null},L.prototype.getCount=function(e){return"row"===e?this.totalRowCount:"column"===e?this.totalColumnCount:-1},L.prototype.getCountPrecision=function(){return"exact"},L.prototype.indexes=function(){return{row:-1,column:-1}},L.prototype.keys=function(){return{row:null,column:null}},L.prototype.move=function(){},L.prototype.moveOK=function(){return"invalid"},L.prototype.sort=function(){},L.prototype._registerEventListeners=function(){this._addListener=this._handleDataGridProviderAddEvent.bind(this),this._removeListener=this._handleDataGridProviderRemoveEvent.bind(this),this._updateListener=this._handleDataGridProviderUpdateEvent.bind(this),this._refreshListener=this._handleDataGridProviderRefreshEvent.bind(this),this.datagridprovider.addEventListener("add",this._addListener),this.datagridprovider.addEventListener("remove",this._removeListener),this.datagridprovider.addEventListener("update",this._updateListener),this.datagridprovider.addEventListener("refresh",this._refreshListener)},L.prototype.Destroy=function(){this.datagridprovider.removeEventListener("add",this._addListener),this.datagridprovider.removeEventListener("remove",this._removeListener),this.datagridprovider.removeEventListener("update",this._updateListener),this.datagridprovider.removeEventListener("refresh",this._refreshListener)},L.prototype.updateTotalCount=function(e,t,i){"row"===t&&-1===this.totalRowCount||"column"===t&&-1===this.totalColumnCount||e.forEach(e=>{let s=i*e.count;"row"===t?this.totalRowCount+=s:"column"===t&&(this.totalColumnCount+=s)})},L.prototype._handleDataGridProviderAddEvent=function(e){var t={source:this,operation:"insert",detail:e.detail};("row"===e.detail.axis?this.rowKeyMap:this.columnKeyMap).handleChange(e.detail.ranges,!1),this.updateTotalCount(e.detail.ranges,e.detail.axis,1),this.handleEvent("change",t)},L.prototype._handleDataGridProviderRemoveEvent=function(e){var t={source:this,operation:"delete",detail:e.detail};("row"===e.detail.axis?this.rowKeyMap:this.columnKeyMap).handleChange(e.detail.ranges,!0),this.updateTotalCount(e.detail.ranges,e.detail.axis,-1),this.handleEvent("change",t)},L.prototype._handleDataGridProviderUpdateEvent=function(e){var t={source:this,operation:"update",detail:e.detail};this.handleEvent("change",t)},L.prototype._handleDataGridProviderRefreshEvent=function(e){let t=!0;if(e&&null!=e.detail){const i=e.detail;if(null!=i.disregardAfterColumnOffset){const e=i.disregardAfterColumnOffset+1;this.columnKeyMap.handleOffsetChange(e),t=!1}if(null!=i.disregardAfterRowOffset){const e=i.disregardAfterRowOffset+1;this.rowKeyMap.handleOffsetChange(e),t=!1}}t&&(this.columnKeyMap=new O,this.rowKeyMap=new O);const i={source:this,operation:"refresh",detail:e.detail};this.handleEvent("change",i)},T.prototype.getData=function(e){return this._findItemByIndex(e.row,e.column).data},T.prototype.getMetadata=function(e){let t=this._findItemByIndex(e.row,e.column);return{metadata:t.metadata,keys:{row:this.rowKeyMap.get(t.rowIndex),column:this.columnKeyMap.get(t.columnIndex)}}},T.prototype.getCount=function(e){if(null!=this.databodyResults){if("row"===e)return this.rowCount;if("column"===e)return this.columnCount}return 0},T.prototype.getExtent=function(e){let t=!1,i=!1,s=!1,n=!1,o=this._findItemByIndex(e.row,e.column),r=o.rowIndex,l=o.rowExtent,a=r+l-1,h=o.columnIndex,d=o.columnExtent,m=h+d-1;return r<this.rowStart&&(l-=this.rowStart-r,t=!0),a>this.rowEnd&&(l-=a-this.rowEnd,i=!0),h<this.columnStart&&(d-=this.columnStart-h,s=!0),m>this.columnEnd&&(d-=m-this.columnEnd,n=!0),{row:{extent:l,more:{before:t,after:i}},column:{extent:d,more:{before:s,after:n}}}},T.prototype._findItemByIndex=function(e,t){let i=i=>{let s=i.rowIndex,n=i.rowExtent,o=i.columnIndex,r=i.columnExtent;return e>=s&&e<s+n&&t>=o&&t<o+r};return null!=this.lastItem&&i(this.lastItem)||(this.lastItem=this.databodyResults.find(i)),this.lastItem},N.prototype.getData=function(e,t){return this._findItemByIndexLevel(e,t).data},N.prototype.getMetadata=function(e,t){let i=this._findItemByIndexLevel(e,t),s=i.metadata.sortDirection;return null!=s&&(s="unsorted"===i.metadata.sortDirection?null:s),{metadata:i.metadata,key:this.keyMap.get(i.index,i.level,this.getLevelCount(),i.depth),sortDirection:s}},N.prototype.getLevelCount=function(){if(null==this.levelCount){let e=0;null!=this.axisResults&&this.axisResults.forEach(t=>{let i=t.level+t.depth-1;i>e&&(e=i)}),this.levelCount=e+1}return this.levelCount},N.prototype.getExtent=function(e,t){let i=this._findItemByIndexLevel(e,t),s=i.extent,n=i.index,o=i.index+s-1,r=!1,l=!1;return n<this.start&&(s-=this.start-n,r=!0),o>this.end&&(s-=o-this.end,l=!0),{extent:s,more:{before:r,after:l}}},N.prototype.getLabel=function(e){return null!=this.axisLabels?this.axisLabels[e].data:null},N.prototype.getLabelMetadata=function(e){return null!=this.axisLabels?{metadata:this.axisLabels[e].metadata}:null},N.prototype.getDepth=function(e,t){return this._findItemByIndexLevel(e,t).depth},N.prototype.getCount=function(){return null!=this.axisResults?this.count:0},N.prototype._findItemByIndexLevel=function(e,t){let i=i=>{let s=i.index,n=i.extent,o=i.level,r=i.depth;return e>=s&&e<s+n&&t>=o&&t<o+r};return null!=this.lastItem&&i(this.lastItem)||(this.lastItem=this.axisResults.find(i)),this.lastItem},d.__registerWidget("oj.ojDataGrid",y.oj.baseComponent,{widgetEventPrefix:"oj",options:{bandingInterval:{row:0,column:0},data:null,gridlines:{horizontal:"visible",vertical:"visible"},scrollToKey:"auto",scrollPosition:{x:0,y:0},selectionMode:{cell:"none",row:"none"},dnd:{reorder:{row:"disable"},drag:null,drop:null},dataTransferOptions:{cut:"disable",copy:"disable",paste:"disable",fill:"disable",headerLabelCut:"disable"},frozenColumnCount:null,frozenRowCount:null,scrollPolicy:"auto",scrollPolicyOptions:{maxRowCount:500,maxColumnCount:500},selection:[],hiddenColumns:new Set([]),hiddenRows:new Set([]),currentCell:null,editMode:"none",header:{row:{alignment:{horizontal:"auto",vertical:"auto"},className:null,label:{alignment:{horizontal:"auto",vertical:"auto"},renderer:null,className:null,style:null,sortable:"disable"},renderer:null,resizable:{width:"disable",height:"disable"},sortable:"auto",style:null,hidable:"disable",freezable:"disable"},column:{alignment:{horizontal:"auto",vertical:"auto"},className:null,filterable:"disable",label:{alignment:{horizontal:"auto",vertical:"auto"},renderer:null,className:null,style:null,sortable:"disable"},renderer:null,resizable:{width:"disable",height:"disable"},sortable:"auto",style:null,hidable:"disable",freezable:"disable"},columnEnd:{alignment:{horizontal:"auto",vertical:"auto"},className:null,label:{alignment:{horizontal:"auto",vertical:"auto"},renderer:null,className:null,style:null,sortable:"disable"},renderer:null,resizable:{width:"disable",height:"disable"},style:null},rowEnd:{alignment:{horizontal:"auto",vertical:"auto"},className:null,label:{alignment:{horizontal:"auto",vertical:"auto"},renderer:null,className:null,style:null,sortable:"disable"},renderer:null,resizable:{width:"disable",height:"disable"},style:null}},cell:{alignment:{horizontal:"auto",vertical:"auto"},className:null,editable:"enable",renderer:null,style:null},resize:null,cellResize:null,sort:null,sortRequest:null,sortLabelRequest:null,collapseRequest:null,expandRequest:null,filterRequest:null,ready:null,scroll:null,beforeCurrentCell:null,beforeEdit:null,beforeEditEnd:null,cutRequest:null,copyRequest:null,pasteRequest:null,fillRequest:null,headerLabelCutRequest:null},_ComponentCreate:function(){this._super(),this._isCreate=!0,this.root=this.element[0],this.rootId=this.root.getAttribute("id"),this.grid=new A(this.root),this.grid.setVisibility(A.VISIBILITY_STATE_RENDER),y(this.root).addClass("oj-datagrid oj-component"),y(this.root).attr(c._OJ_CONTAINER_ATTR,this.widgetName),_.disableDefaultBrowserStyling(this.root),this.redrawSet={data:"all",header:["className","renderer","style","template"]}},_AfterCreate:function(){var e=this;this._unregisterResizeListener(this.root),this._removeAllChildren(),this._super(),this.resources=new H(this._GetReadingDirection(),this._getTranslation.bind(e),{showIndicatorDelay:v.getCachedCSSVarValues(["--oj-private-core-global-loading-indicator-delay-duration"])[0],loadIndicator:v.getCachedCSSVarValues(["--oj-private-data-grid-global-load-indicator-default"])[0]},this.widgetName),this._setDataSource(),this._setSelection(),this._hideColumns(),this._hideRows(),null!=this.datasource&&(this.grid.SetDataSource(this.datasource),this._addContextMenu(),this.grid._addDataSourceEventListeners()),this._checkSelectionMode(this.options),this.grid.SetOptions(this.options,this._WrapCustomElementRenderer.bind(e)),this.grid.SetResources(this.resources),this.grid.SetCreateContextCallback(this._modifyContext.bind(e)),this.grid.SetFixContextCallback(this._FixRendererContext.bind(e)),this.grid.SetRemoveCallback(this._remove.bind(e)),this.grid.SetUniqueIdCallback(this._uniqueId.bind(e)),this.grid.SetCompareValuesCallback(this._compareValues.bind(e)),this.grid.SetNotReadyCallback(this._NotReady.bind(e)),this.grid.SetMakeReadyCallback(this._MakeReady.bind(e)),this.grid.SetOptionCallback(this.option.bind(e)),this.grid.SetSubtreeAttachedCallback(c.subtreeAttached),this.grid.SetContextCallback(u.getContext),this.grid.SetCustomElementCallback(this._IsCustomElement.bind(e)),this.grid.SetUpdateScrollPostionOnRefreshCallback(this._updateScrollPositionOnRefresh.bind(e)),this.grid.SetCustomElement(this._GetCustomElement()),this._focusable({applyHighlight:!0,setupHandlers:function(t,i){e.grid.SetFocusableCallback.call(e.grid,function(e){return t(y(e))},function(e){return i(y(e))})}}),this._registerEventListeners(),this._possiblyRenderOrRefresh()},_SetupResources:function(){this._super(),this.setupResources(!this._isCreate)},setupResources:function(e){null!=this.datasource&&(e||this.grid._addDataSourceEventListeners(),this.grid._addDomEventListeners(),this._registerResizeListener(this.root)),e&&this.refresh(),this._isCreate=!1},_ReleaseResources:function(){this._super(),this.releaseResources()},releaseResources:function(){this.grid._removeDataSourceEventListeners(),this.grid._removeDomEventListeners(),this._unregisterResizeListener(this.root),this.contextMenuEvent=null,this._removeAllChildren()},_registerEventListeners:function(){var e=this;this.grid.addListener("resize",function(t){e._trigger("resize",t.event,t.ui)}),this.grid.addListener("select",function(t){e.option("selection",t.ui.selection,{_context:{originalEvent:t.event,internalSet:!0},changed:!0})}),this.grid.addListener("currentCell",function(t){e.option("currentCell",t.ui,{_context:{originalEvent:t.event,internalSet:!0},changed:!0})}),this.grid.addListener("beforeCurrentCell",function(t){return e._trigger("beforeCurrentCell",t.event,t.ui)}),this.grid.addListener("sort",function(t){var i=e._trigger2("sort",t.event,t.ui);e.grid.SetSortOriginalEvent(i.event)}),this.grid.addListener("sortRequest",function(t){return e._trigger("sortRequest",t.event,t.ui)}),this.grid.addListener("sortLabelRequest",function(t){return e._trigger("sortLabelRequest",t.event,t.ui)}),this.grid.addListener("expandRequest",function(t){return e._trigger("expandRequest",t.event,t)}),this.grid.addListener("collapseRequest",function(t){return e._trigger("collapseRequest",t.event,t)}),this.grid.addListener("keydown",function(t){return e._trigger("keydown",t.event,t.ui)}),this.grid.addListener("ready",function(){e._trigger("ready",null,{})}),this.grid.addListener("scroll",function(t){e._trigger("scroll",t.event,t.ui)}),this.grid.addListener("beforeEdit",function(t){return e._trigger("beforeEdit",t.event,t.ui)}),this.grid.addListener("beforeEditEnd",function(t){return e._trigger("beforeEditEnd",t.event,t.ui)}),this.grid.addListener("cutRequest",function(t){return e._trigger("cutRequest",t.event,t.ui)}),this.grid.addListener("copyRequest",function(t){return e._trigger("copyRequest",t.event,t.ui)}),this.grid.addListener("pasteRequest",function(t){return e._trigger("pasteRequest",t.event,t.ui)}),this.grid.addListener("fillRequest",function(t){return e._trigger("fillRequest",t.event,t.ui)}),this.grid.addListener("cellResize",function(t){return e._trigger("cellResize",t.event,t.ui)}),this.grid.addListener("rowFreeze",function(t){e.option("frozenRowCount",t.ui.frozenCount,{_context:{originalEvent:t.event,internalSet:!0},changed:!0})}),this.grid.addListener("columnFreeze",function(t){e.option("frozenColumnCount",t.ui.frozenCount,{_context:{originalEvent:t.event,internalSet:!0},changed:!0})}),this.grid.addListener("headerLabelCutRequest",function(t){return e._trigger("headerLabelCutRequest",t.event,t.ui)}),this.grid.addListener("columnHide",function(t){e.option("hiddenColumns",t.ui.hiddenColumns,{_context:{originalEvent:t.event,internalSet:!0},changed:!0})}),this.grid.addListener("rowHide",function(t){e.option("hiddenRows",t.ui.hiddenRows,{_context:{originalEvent:t.event,internalSet:!0},changed:!0})}),this.grid.addListener("filterRequest",function(t){return e._trigger("filterRequest",t.event,t.ui)})},refresh:function(){this._super(),(!this._IsCustomElement()||null!=this._defaultContextMenu)&&this._ReleaseContextMenu(),this.releaseResources(),this._defaultContextMenu&&(this.options.contextMenu=null,this._defaultContextMenu=null),this._setDataSource(),null!=this.datasource&&(d.FlattenedTreeDataGridDataSource&&this.datasource instanceof d.FlattenedTreeDataGridDataSource&&(this.datasource.Destroy(),this.datasource.Init()),this.grid.SetDataSource(this.datasource),this._addContextMenu()),this.grid.SetOptions(this.options,this._WrapCustomElementRenderer.bind(this)),this.resources.setRTLMode(this._GetReadingDirection()),this.grid.SetResources(this.resources),(!this._IsCustomElement()||null!=this._defaultContextMenu)&&this._SetupContextMenu(),this.setupResources(!1),this.grid.getVisibility()!==A.VISIBILITY_STATE_RENDER&&this.grid.setVisibility(A.VISIBILITY_STATE_REFRESH),this._possiblyRenderOrRefresh()},_updateScrollPositionOnRefresh:function(e,t){var i=this.options.selection,s={};if(null!=i&&0!==i.length){var n=i[i.length-1];n&&(n.startKey?(s.rowKey=n.startKey.row,s.columnKey=n.startKey.column):n.startIndex&&(s.rowIndex=0,s.columnIndex=0))}else s={x:0,y:0};null!=e&&(s.x=e),null!=t&&(s.y=t),this.option("scrollPosition",s,{_context:{internalSet:!0},changed:!1})},_destroy:function(){y(this.root).removeAttr(c._OJ_CONTAINER_ATTR),null!=this.datasource&&this.datasource.Destroy&&this.datasource.Destroy(),this.grid.destroy(),this._unregisterResizeListener(this.root),y(this.root).empty(),this._MakeReady()},_setOptions:function(e,t){if(this.datasource){let i="refresh";this.grid.getVisibility()!==A.VISIBILITY_STATE_RENDER&&(i=this._handleOptionUpdate(e,t)),this._super(e,t),"refresh"===i?this.refresh():"pass"===i&&this.grid.UpdateOptions(e,t)}else this._super(e,t),null!=e.data&&this.refresh()},_checkSelectionMode:function(e){var t=e.selectionMode;if(t&&t.row&&t.cell&&"none"!==t.row&&"none"!==t.cell)throw new Error("JET DataGrid does not support selectionMode on cell and row simultaneously.")},_NotifyShown:function(){this._super(),this._possiblyRenderOrRefresh()},_NotifyHidden:function(){this._super(),this.grid.getVisibility()===A.VISIBILITY_STATE_VISIBLE&&this.grid.setVisibility(A.VISIBILITY_STATE_HIDDEN)},_NotifyAttached:function(){this._super(),this._possiblyRenderOrRefresh()&&this.grid._initiateScrollOnAttached()},_NotifyDetached:function(){this._super(),this.grid.getVisibility()===A.VISIBILITY_STATE_VISIBLE&&this.grid.setVisibility(A.VISIBILITY_STATE_HIDDEN)},_VerifyConnectedForSetup:function(){return!0},_handleOptionUpdate:function(e,t){for(var i="ignore",s=Object.keys(e),n=0;n<s.length;n++){switch(s[n]){case"bandingInterval":case"currentCell":case"editMode":case"gridlines":case"scrollPosition":case"selection":case"frozenColumnCount":case"frozenRowCount":case"hiddenColumns":case"hiddenRows":i="pass";break;case"beforeCurrentCell":case"beforeEdit":case"beforeEditEnd":case"cutRequest":case"copyRequest":case"pasteRequest":case"fillRequest":case"create":case"disabled":case"dnd":case"optionChange":case"ready":case"resize":case"rootAttributes":case"scroll":case"sort":break;case"selectionMode":this._checkSelectionMode(e),i="pass";break;case"cell":case"header":var o=t.subkey;if(null!=o){var r=o.split(".");if("resizable"===r[1]||"sortable"===r[1]){i="pass";break}}return"refresh";case"data":return this._updateScrollPositionOnRefresh(),"refresh";default:return"refresh"}}return i},_isResizeEnabled:function(e,t){return!(!this.options.header[e]||!this.options.header[e].resizable)&&"disable"!==this.options.header[e].resizable[t]},_isSortEnabled:function(e){return!!this.options.header[e]&&"disable"!==this.options.header[e].sortable},_isSortLabelEnabled:function(e){return!!this.options.header[e]?.label&&"disable"!==this.options.header[e].label.sortable},_isFreezeEnabled:function(e){return!!this.options.header[e]&&"disable"!==this.options.header[e].freezable},_isHideEnabled:function(e){return!!this.options.header[e]&&"disable"!==this.options.header[e].hidable},_isFilterEnabled:function(e){return!!this.options.header[e]&&"disable"!==this.options.header[e].filterable},_removeAllChildren:function(){for(var e=this.root.children,t=e.length-1;t>=0;t--)"TEMPLATE"!==e[t].tagName&&"OJ-SURROGATE"!==e[t].tagName&&("OJ-MENU"!==e[t].tagName||"OJ-MENU"===e[t].tagName&&"contextMenu"!==e[t].slot)&&this._remove(e[t])},_GetDefaultContextMenu:function(){return this._defaultContextMenu},_addContextMenu:function(){var e=this,t=e._IsCustomElement(),i=this._GetContextMenu()?this._GetContextMenu():this._menuContainer;if(i){null==this._menuItemsSetByGrid&&(this._menuItemsSetByGrid=[]),this._menuContainer=i;var s=(i=y(i)).find("[data-oj-command]"),n=[];s.each(function(){var i=e._shouldUpdateListItem(this,t);if(i.shouldUpdate){var s=y(this).attr("data-oj-command").split("-");if(t){var o=e._getContextMenuText(s[s.length-1],t);i.itemToUpdate?(i.itemToUpdate.textContent=o,n.push(i.itemToUpdate)):(i.toFirstChild,this.textContent=o,n.push(this))}else{var r=y(e._buildContextMenuItem(s[s.length-1],t));y(this).replaceWith(r),n.push(r.children("a").get(0))}}}),this._menuItemsSetByGrid=n,i.data("oj-ojMenu")&&(t?i[0].refresh():i.ojMenu("refresh"))}else null!=this.datasource&&(i=this._createDefaultContextMenu())&&(this._defaultContextMenu=i[0]);i&&this._addMenuSelectListener(i)},_shouldUpdateListItem:function(e,t){var i,s=!1;if(t){if(null!=e.firstElementChild&&"opt"===e.firstElementChild.getAttribute("ojmenu")?(i=f.CustomElementUtils.getSlotMap(e.firstElementChild),s=!0):i=f.CustomElementUtils.getSlotMap(e),!i[""]||0===i[""].length)return{shouldUpdate:!0,toFirstChild:s};if(i[""]){var n=this._menuItemsSetByGrid.indexOf(e);if(-1!==n)return{shouldUpdate:!0,itemToUpdate:this._menuItemsSetByGrid[n]}}return{shouldUpdate:!1}}var o=y(e).children("a");return{shouldUpdate:0===o.length||-1!==this._menuItemsSetByGrid.indexOf(o.get(0))}},_addMenuSelectListener:function(e){var t=this._handleContextMenuSelect.bind(this);this._IsCustomElement()?e[0].addEventListener("ojAction",t):e.on("ojselect",t)},_createDefaultContextMenu:function(){let e,t,i,s,n,o,r,l,a,h,d,m,c=null,u=null,_=null;const g=this._IsCustomElement();r=g?this._createCustomElementContextMenu():this._createWidgetContextMenu(),(this._isResizeEnabled("column","height")||this._isResizeEnabled("row","height"))&&(c=this._buildContextMenuItem("resizeHeight",g)),(this._isResizeEnabled("column","width")||this._isResizeEnabled("row","width"))&&(u=this._buildContextMenuItem("resizeWidth",g)),(this._isResizeEnabled("column","width")||this._isResizeEnabled("column","height")||this._isResizeEnabled("row","width")||this._isResizeEnabled("row","height"))&&(_=this._buildContextMenuItem("resizeFitToContent",g));const f=this.datasource.getCapability("sort");if((this._isSortEnabled("column")||this._isSortLabelEnabled("column")||this._isSortLabelEnabled("columnEnd"))&&("column"!==f&&"full"!==f||(e=this._buildContextMenuItem("sortCol",g))),(this._isSortEnabled("row")||this._isSortLabelEnabled("row")||this._isSortLabelEnabled("rowEnd"))&&("row"!==f&&"full"!==f||(t=this._buildContextMenuItem("sortRow",g))),this._isHideEnabled("column")&&(l=this._buildContextMenuItem("hideCol",g),a=this._buildContextMenuItem("unhideCol",g)),this._isHideEnabled("row")&&(h=this._buildContextMenuItem("hideRow",g),d=this._buildContextMenuItem("unhideRow",g)),this._isFilterEnabled("column")&&(m=this._buildContextMenuItem("filterCol",g)),"enable"===this.options.dnd.reorder.row)if("none"===this.datasource.getCapability("move"));else g?(s=new DocumentFragment,s.appendChild(this._buildContextMenuOjOption("cut")),s.appendChild(this._buildContextMenuOjOption("paste")),s.appendChild(this._buildContextMenuDivider())):(s=new DocumentFragment,s.appendChild(this._buildContextMenuListItem("cut")),s.appendChild(this._buildContextMenuListItem("paste")));let C=[];if(C=Object.keys(this.options.dataTransferOptions).filter(e=>"enable"===this.options.dataTransferOptions[e]),C.length){let e=this.options.dataTransferOptions;n=new DocumentFragment,g?("enable"!==e.cut&&"enable"!==e.headerLabelCut||n.appendChild(this._buildContextMenuOjOption("cutCells")),"enable"===e.copy&&n.appendChild(this._buildContextMenuOjOption("copyCells")),"enable"===e.paste&&n.appendChild(this._buildContextMenuOjOption("pasteCells")),"enable"===e.fill&&n.appendChild(this._buildContextMenuOjOption("autoFill")),n.appendChild(this._buildContextMenuDivider())):("enable"!==e.cut&&"enable"!==e.headerLabelCut||n.appendChild(this._buildContextMenuListItem("cutCells")),"enable"===e.copy&&n.appendChild(this._buildContextMenuListItem("copyCells")),"enable"===e.paste&&n.appendChild(this._buildContextMenuListItem("pasteCells")),"enable"===e.fill&&n.appendChild(this._buildContextMenuListItem("autoFill")))}return this._isMultipleSelection()&&p.isTouchSupported()&&(this._discontiguousSelection=!1,g?(i=document.createElement("oj-menu-select-many"),i.setAttribute("data-oj-binding-provider","none"),i.appendChild(this._buildContextMenuOjOption("discontiguousSelection"))):i=this._buildContextMenuListItem("discontiguousSelection")),this._isFreezeEnabled("row")&&(o=new DocumentFragment,g?(o.appendChild(this._buildContextMenuOjOption("freezeRow")),o.appendChild(this._buildContextMenuOjOption("unfreezeRow"))):(o.appendChild(this._buildContextMenuListItem("freezeRow")),o.appendChild(this._buildContextMenuListItem("unfreezeRow")))),this._isFreezeEnabled("column")&&(void 0===o&&(o=new DocumentFragment),g?(o.appendChild(this._buildContextMenuOjOption("freezeCol")),o.appendChild(this._buildContextMenuOjOption("unfreezeCol"))):(o.appendChild(this._buildContextMenuListItem("freezeCol")),o.appendChild(this._buildContextMenuListItem("unfreezeCol")))),c||u||_||e||t||s||i||o||l||a||h||d||n||m?(n&&r.appendChild(n),l&&r.appendChild(l),a&&r.appendChild(a),h&&r.appendChild(h),d&&r.appendChild(d),o&&r.appendChild(o),(l||a||h||d||o)&&r.appendChild(this._buildContextMenuDivider()),c&&r.appendChild(c),u&&r.appendChild(u),_&&r.appendChild(_),(e||t||m)&&((c||u||_)&&r.appendChild(this._buildContextMenuDivider()),e&&r.appendChild(e),t&&r.appendChild(t),m&&r.appendChild(m)),s&&((c||u||_||o||l||a||h||d||e||t||m)&&r.appendChild(this._buildContextMenuDivider()),r.appendChild(s)),i&&((c||u||_||o||e||t||l||a||h||d||m||s)&&r.appendChild(this._buildContextMenuDivider()),r.appendChild(i)),g||y(r).ojMenu(),this.option("contextMenu",r,{_context:{internalSet:!0}}),y(r)):null},_createCustomElementContextMenu:function(e){const t=document.createElement("oj-menu");t.setAttribute("data-oj-binding-provider","none"),t.style.display="none";let i=e?"contextsubmenu":"contextmenu";return t.setAttribute("id",this.rootId+i),e||this.root.appendChild(t),t},_createWidgetContextMenu:function(e){const t=document.createElement("ul");let i=e?"contextsubmenu":"contextmenu";return t.setAttribute("id",this.rootId+i),t.style.display="none",e||this.root.appendChild(t),t},_buildContextMenuItem:function(e,t){if(t){if("resize"===e){const e=new DocumentFragment;return e.appendChild(this._buildContextMenuOjOption("resizeRow")),e.appendChild(this._buildContextMenuOjOption("resizeColumn")),e}if("sortCol"===e){const e=new DocumentFragment;return e.appendChild(this._buildContextMenuOjOption("sortColAsc")),e.appendChild(this._buildContextMenuOjOption("sortColDsc")),e}if("sortRow"===e){const e=new DocumentFragment;return e.appendChild(this._buildContextMenuOjOption("sortRowAsc")),e.appendChild(this._buildContextMenuOjOption("sortRowDsc")),e}if(-1!==Object.keys(this.resources.commands).indexOf(e))return this._buildContextMenuOjOption(e)}else{if("resize"===e){const e=this._buildContextMenuListItem("resize"),t=document.createElement("ul");return t.appendChild(this._buildContextMenuListItem("resizeWidth")),t.appendChild(this._buildContextMenuListItem("resizeHeight")),e.appendChild(t),e}if("sortCol"===e){const e=this._buildContextMenuListItem("sortCol"),t=document.createElement("ul");return t.appendChild(this._buildContextMenuListItem("sortColAsc")),t.appendChild(this._buildContextMenuListItem("sortColDsc")),e.appendChild(t),e}if("sortRow"===e){const e=this._buildContextMenuListItem("sortRow"),t=document.createElement("ul");return t.appendChild(this._buildContextMenuListItem("sortRowAsc")),t.appendChild(this._buildContextMenuListItem("sortRowDsc")),e.appendChild(t),e}if(-1!==Object.keys(this.resources.commands).indexOf(e))return this._buildContextMenuListItem(e)}},_buildContextMenuOjOption:function(e){const t=document.createElement("oj-option");let i;if(t.setAttribute("data-oj-command",this._getMappedCommand(e)),-1!==["cutCells","copyCells","pasteCells"].indexOf(e)){i=document.createElement("span");let t=e.indexOf("Cells"),s=e.slice(0,t);i=document.createElement("span"),i.setAttribute("slot","startIcon"),i.setAttribute("class",`oj-ux-ico-${s}`)}return t.textContent=this._getContextMenuText(e),i&&t.appendChild(i),t},_buildContextMenuDivider:function(){const e=document.createElement("oj-option");return e.textContent="---",e},_buildContextMenuListItem:function(e){const t=document.createElement("li");return t.setAttribute("data-oj-command",this._getMappedCommand(e)),t.appendChild(this._buildContextMenuLabel(e)),t},_getContextMenuText:function(e){var t=this._IsCustomElement();t&&"discontiguousSelection"===e&&(e="SelectMultiple"),"resizeWidth"===e?e="resizeColumn":"resizeHeight"===e&&(e="resizeRow"),"hideCol"===e&&(e="hideColumns"),"unhideCol"===e&&(e="unhideColumns"),"hideRow"===e&&(e="hideRows"),"unhideRow"===e&&(e="unhideRows");let i="label"+e.charAt(0).toUpperCase()+e.slice(1);return t||"discontiguousSelection"!==e||(i="labelEnableNonContiguous"),this._getTranslation(i)},_buildContextMenuLabel:function(e){const t=this._getContextMenuText(e),i=document.createElement("a");return i.setAttribute("href","#"),i.textContent=t,i},_getDataGridContextMenu:function(){return this._GetContextMenu()||this._GetDefaultContextMenu()},_getTranslation:function(e,t){return this.getTranslatedString(e,t)},_handleResizeDialog:function(e){var t,i;this._IsCustomElement()?(t=document.getElementById(this.rootId+"inputNumber").value,i=document.getElementById(this.rootId+"modal").getAttribute("dimension"),document.getElementById(this.rootId+"modal").close()):(t=y("#"+this.rootId+"inputNumber").ojInputNumber("option","value"),y("#"+this.rootId+"modal").ojDialog("close")),this.grid.handleContextMenuReturn(this.contextMenuEvent,this._getMappedCommand(i),t),this.contextMenuEvent.target.focus()},_buildResizeDialog:function(e,t,i){let s,n,o,r,l,a,h,d,m;if(this._IsCustomElement()){s=document.getElementById(this.rootId+"inputNumber"),o=document.getElementById(this.rootId+"modal");const c=null===o||null===s;if(c){o=document.createElement("oj-dialog"),o.id=this.rootId+"modal",o.setAttribute("data-oj-binding-provider","none"),o.setAttribute("initial-focus","firstFocusable"),o.className=this._getMappedStyle("resizeDialog"),r=document.createElement("div"),r.setAttribute("slot","header"),l=document.createElement("div"),l.setAttribute("slot","body"),a=document.createElement("div"),a.setAttribute("slot","footer"),m=document.createElement("h5"),m.textContent=e,r.appendChild(m),r.className=this._getMappedStyle("dialogTitle"),o.appendChild(r),o.appendChild(l),o.appendChild(a),s=document.createElement("oj-input-number"),s.id=this.rootId+"inputNumber",h=document.createElement("oj-button"),h.id=this.rootId+"modalcancel",h.style.margin="5px",d=document.createElement("oj-button"),d.id=this.rootId+"modalsubmit",d.style.margin="5px",d.setAttribute("chroming","callToAction"),l.appendChild(s),a.appendChild(h),a.appendChild(d),this.root.appendChild(o),h.textContent=this._getTranslation("labelResizeDialogCancel"),d.textContent=this._getTranslation("labelResizeDialogApply"),n=()=>{d.disabled=!1,s.value=0,o.close()},h.addEventListener("click",n),d.addEventListener("click",this._handleResizeDialog.bind(this)),s.addEventListener("validChanged",e=>{"valid"===e.detail.value?d.disabled=!1:d.disabled=!0});const t={my:{horizontal:"center",vertical:"center"},at:{horizontal:"center",vertical:"center"},collision:"none"};o.setAttribute("position",JSON.stringify(t))}let _=!1,p=!1,g=this.grid.findHeader(this.contextMenuEvent.target);null===g&&(g=this.grid.findCell(this.contextMenuEvent.target),g&&(p=!0)),null===g&&(g=this.grid.findLabel(this.contextMenuEvent.target),g&&(_=!0));const f=this.grid._getResizeHeaderMode(g);let C=0;if("width"===i)C=this.grid._getResizeMinWidth(f,g,_,p);else{const e=this.grid.m_utils.containsCSSClassName(g,this.grid.getMappedStyle("endheadercell"))||this.grid.m_utils.containsCSSClassName(g,this.grid.getMappedStyle("columnendheaderlabel"));C=this.grid._getResizeMinHeight(f,g,_,p,e)}if(s.setAttribute("min",C),s.setAttribute("max",2e3),s.setAttribute("step",1),s.setAttribute("value",t),s.setAttribute("display-options",'{"converterHint": "none", "validatorHint": "none"}'),s.setAttribute("label-edge","inside"),s.setAttribute("user-assistance-density","efficient"),"width"===i?(s.setAttribute("label-hint",this._getTranslation("columnWidth")),o.setAttribute("dimension","resizeWidth")):(s.setAttribute("label-hint",this._getTranslation("rowHeight")),o.setAttribute("dimension","resizeHeight")),o.setAttribute("dialog-title",e),c){u.getContext(o).getBusyContext().whenReady().then(()=>{o.open(this.root)})}else o.open(this.root)}else o=y("#"+this.rootId+"modal"),s=y("#"+this.rootId+"inputNumber"),0===o.length||0===s.length?(o=document.createElement("div"),o.id=this.rootId+"modal",r=document.createElement("div"),l=document.createElement("div"),a=document.createElement("div"),r.className=this._getMappedStyle("dialogTitle"),o.appendChild(r),o.appendChild(l),o.appendChild(a),m=document.createElement("h5"),m.textContent=e,r.appendChild(m),s=document.createElement("input"),s.id=this.rootId+"inputNumber",s.setAttribute("label-edge","inside"),h=document.createElement("oj-button"),h.id=this.rootId+"modalcancel",h.style.margin="5px",d=document.createElement("oj-button"),d.id=this.rootId+"modalsubmit",d.style.margin="5px",l.appendChild(s),a.appendChild(h),a.appendChild(d),this.root.appendChild(o),y(h).ojButton({component:"ojButton",label:this._getTranslation("labelResizeDialogCancel")}),y(d).ojButton({component:"ojButton",label:this._getTranslation("labelResizeDialogApply")}),n=function(){y(d).ojButton({disabled:!1}),y(s).ojInputNumber({value:0}),y(o).ojDialog("close")},h.addEventListener("click",n),d.addEventListener("click",this._handleResizeDialog.bind(this)),y(s).ojInputNumber({component:"ojInputNumber",max:1e3,min:20,step:1,value:t}),"width"===i?(s.setAttribute("label-hint",this._getTranslation("columnWidth")),o.setAttribute("dialog-title","resizeWidth")):(s.setAttribute("label-hint",this._getTranslation("rowHeight")),o.setAttribute("dialog-title","resizeHeight")),y(s).on("change",function(){y(d).ojButton({disabled:!y(s).ojInputNumber("validate")})}),y(o).ojDialog({initialFocus:"firstFocusable",position:{my:"center center",at:"center center",collision:"none",of:y(this.root)}}),y(o).ojDialog("open")):(s.ojInputNumber("option","value",t),s.setAttribute("label-edge","inside"),o.find("."+this._getMappedStyle("dialogTitle"))[0].firstChild.textContent=e,o.ojDialog("open"))},_handleContextMenuSelect:function(e,t){var i;if(i=t?t.item:y(e.target),this.menuItemFunction=i.attr("data-oj-command"),this.menuItemFunction===this._getMappedCommand("sortColAsc")||this.menuItemFunction===this._getMappedCommand("sortColDsc")||this.menuItemFunction===this._getMappedCommand("sortRowAsc")||this.menuItemFunction===this._getMappedCommand("sortRowDsc")||this.menuItemFunction===this._getMappedCommand("cut")||this.menuItemFunction===this._getMappedCommand("paste")||this.menuItemFunction===this._getMappedCommand("cutCells")||this.menuItemFunction===this._getMappedCommand("pasteCells")||this.menuItemFunction===this._getMappedCommand("copyCells")||this.menuItemFunction===this._getMappedCommand("autoFill")||this.menuItemFunction===this._getMappedCommand("freezeRow")||this.menuItemFunction===this._getMappedCommand("freezeCol")||this.menuItemFunction===this._getMappedCommand("unfreezeRow")||this.menuItemFunction===this._getMappedCommand("unfreezeCol")||this.menuItemFunction===this._getMappedCommand("hideCol")||this.menuItemFunction===this._getMappedCommand("unhideCol")||this.menuItemFunction===this._getMappedCommand("hideRow")||this.menuItemFunction===this._getMappedCommand("unhideRow")||this.menuItemFunction===this._getMappedCommand("filterCol"))this.grid.handleContextMenuReturn(this.contextMenuEvent,this.menuItemFunction,null);else if(this.menuItemFunction===this._getMappedCommand("resizeWidth")||this.menuItemFunction===this._getMappedCommand("resizeHeight")){var s=y(this.contextMenuEvent.target).closest("."+this._getMappedStyle("cell"));if(0===s.length&&(s=y(this.contextMenuEvent.target).closest("."+this._getMappedStyle("headercell"))),0===s.length&&(s=y(this.contextMenuEvent.target).closest("."+this._getMappedStyle("endheadercell"))),0===s.length&&(s=y(this.contextMenuEvent.target).closest("."+this._getMappedStyle("headerlabel"))),s.length>0){var n=this.menuItemFunction===this._getMappedCommand("resizeWidth")?s.outerWidth():s.outerHeight(),o=this.menuItemFunction===this._getMappedCommand("resizeWidth")?"width":"height",r="width"===o?this._getTranslation("resizeColumnDialog"):this._getTranslation("resizeRowDialog");this._buildResizeDialog(r,n,o)}}else if(this.menuItemFunction===this._getMappedCommand("resizeFitToContent"))this.grid.handleContextMenuReturn(this.contextMenuEvent,this.menuItemFunction,null);else if(this.menuItemFunction===this._getMappedCommand("discontiguousSelection")){let e;this._discontiguousSelection=!this._discontiguousSelection,this.grid.handleContextMenuReturn(this.contextMenuEvent,this.menuItemFunction,this._discontiguousSelection);e=this._IsCustomElement()?"labelSelectMultiple":this._discontiguousSelection?"labelDisableNonContiguous":"labelEnableNonContiguous",i.children().first().text(this._getTranslation(e))}},_NotifyContextMenuGesture:function(e,t,i){this.grid.handleContextMenuGesture(t,i,this._contextMenuGestureCallback.bind(this))},_contextMenuGestureCallback:function(e,t,i){if(null!=e){this.contextMenuEvent=t.originalEvent;var s=e.launcher,n=e.capabilities;this._manageContextMenu(n);var o="keyboard"===i?{position:{of:s},launcher:y(s)}:{launcher:y(s)};p.isTouchSupported()&&(this.grid.m_databodyReorder||this.grid.m_pivotInProgress)||this._OpenContextMenu(t,i,o)}},_addContextMenuCapability:function(e){var t=y(this._getDataGridContextMenu());this._IsCustomElement()?t.find("[data-oj-command="+e+"]").attr("disabled")||t.find("[data-oj-command="+e+"]").attr("disabled",!0):t.find("[data-oj-command="+e+"]").hasClass("oj-disabled")||t.find("[data-oj-command="+e+"]").addClass("oj-disabled")},_removeContextMenuCapability:function(e){y(this._getDataGridContextMenu()).find("[data-oj-command="+e+"]").removeClass("oj-disabled").attr("disabled",!1)},_manageContextMenu:function(e){for(var t=Object.keys(e),i=0;i<t.length;i++){var s=t[i],n=this.resources.getMappedCommand(s);"disable"===e[s]?this._addContextMenuCapability(n):this._removeContextMenuCapability(n)}},_findCellIndex:function(e){return e[this._getMappedAttribute("context")].indexes},_setDataSource:function(){null!=this.options.data?this.options.data.fetchByOffset&&!this.options.data.fetchFirst?(null!=this.datasource&&this.datasource.Destroy&&this.datasource.Destroy(),this.datasource=new L(this.options.data)):d.DataProviderFeatureChecker.isDataProvider(this.options.data)?(this.datasource=new x(this.options.data),"randomAccess"!==this.options.data.getCapability("fetchByOffset").implementation&&"scroll"===this.options.scrollPolicy&&(E.error("oj.DataProvider does not support fetchByOffset and scrollPolicy is set to scroll. scrollPolicy will fall back to auto."),this.options.scrollPolicy="auto")):this.datasource=this.options.data:this.datasource=null},_setSelection:function(){var e=this.options.selection;null!=e&&this.grid.SetSelection(e)},_hideColumns:function(){var e=this.options.hiddenColumns;null!=e&&(e=[...e],this.grid.setHiddenColumns(e))},_hideRows:function(){var e=this.options.hiddenRows;null!=e&&(e=[...e],this.grid.setHiddenRows(e))},_modifyContext:function(e){e.component=c.__GetWidgetConstructor(this.element,"ojDataGrid")},_setAccessibleContext:function(e){this.grid.SetAccessibleContext(e)},_unregisterResizeListener:function(e){e&&this._resizeHandler&&(p.removeResizeListener(e,this._resizeHandler),this._resizeHandler=null)},_registerResizeListener:function(e){e&&(null==this._resizeHandler&&(this._resizeHandler=this._handleResize.bind(this)),p.addResizeListener(e,this._resizeHandler))},_handleResize:function(e,t){e>0&&t>0&&(this._possiblyRenderOrRefresh(),this.grid.HandleResize(e,t))},getNodeBySubId:function(e){var t;if(null==e)return this.element?this.element[0]:null;var i=e.subId;if("oj-datagrid-cell"===i){var s=e.rowIndex,n=e.columnIndex;t=y(this.grid._getCellByIndex({row:s,column:n}))}else if("oj-datagrid-sort-icon"===i||"oj-datagrid-sort-ascending"===i||"oj-datagrid-sort-default"===i||"oj-datagrid-sort-descending"===i||"oj-datagrid-header"===i){var o,r=e.axis,l=e.index,a=null==e.level?0:e.level;if(null==(o=this.grid._getHeaderByIndex(l,r,a)))return null;if(o=y(o),"oj-datagrid-sort-icon"===i)return o.children("."+this._getMappedStyle("sortIcon")).children().get(0);t="oj-datagrid-sort-ascending"===i?o.find("."+this._getMappedStyle("sortascending")):"oj-datagrid-sort-default"===i?o.find("."+this._getMappedStyle("sortdefault")):"oj-datagrid-sort-descending"===i?o.find("."+this._getMappedStyle("sortdescending")):o}else"oj-datagrid-header-label"===i&&(t=y(this.grid._getLabel(e.axis,e.level)));return null!=t&&t.length>0?t[0]:null},getSubIdByNode:function(e){var t,i=y(e).closest("."+this._getMappedStyle("cell"));if(i.length>0){var s=this._findCellIndex(i[0]);return{subId:"oj-datagrid-cell",rowIndex:s.row,columnIndex:s.column}}var n=y(e).closest("."+this._getMappedStyle("headercell"));if(0===n.length&&(n=y(e).closest("."+this._getMappedStyle("endheadercell"))),n.length>0)return t=n[0][this._getMappedAttribute("context")],{subId:y(e).hasClass(this._getMappedStyle("sortascending"))?"oj-datagrid-sort-ascending":y(e).hasClass(this._getMappedStyle("sortdefault"))?"oj-datagrid-sort-default":y(e).hasClass(this._getMappedStyle("sortdescending"))?"oj-datagrid-sort-descending":"oj-datagrid-header",axis:t.axis,index:this._getHeaderIndex(n),level:t.level};var o=y(e).closest("."+this._getMappedStyle("headerlabel"));return o.length>0?{subId:"oj-datagrid-header-label",axis:(t=o[0][this._getMappedAttribute("context")]).axis,level:t.level}:null},getContextByNode:function(e){var t,i,s=y(e).closest("."+this._getMappedStyle("cell"));if(s.length>0)return t=s[0][this._getMappedAttribute("context")],(i=d.CollectionUtils.copyInto({},t,void 0,!0)).subId="oj-datagrid-cell",i;var n=y(e).closest("."+this._getMappedStyle("headercell"));if(0===n.length&&(n=y(e).closest("."+this._getMappedStyle("endheadercell"))),n.length>0)return t=n[0][this._getMappedAttribute("context")],(i=d.CollectionUtils.copyInto({},t,void 0,!0)).subId="oj-datagrid-header",i.index=this._getHeaderIndex(n),i;var o=y(e).closest("."+this._getMappedStyle("headerlabel"));return o.length>0?(t=o[0][this._getMappedAttribute("context")],(i=d.CollectionUtils.copyInto({},t,void 0,!0)).subId="oj-datagrid-header-label",i):null},_getMappedStyle:function(e){return this.resources.getMappedStyle(e)},_getMappedAttribute:function(e){return this.resources.getMappedAttribute(e)},_getMappedCommand:function(e){return this.resources.getMappedCommand(e)},_isDataGridSizingAvailable:function(){return null!=this.root.offsetParent},_possiblyRenderOrRefresh:function(){var e=this.grid.getVisibility(),t=!1;return this._isDataGridSizingAvailable()?(e===A.VISIBILITY_STATE_RENDER?(this.grid.render(this.root),t=!0):e===A.VISIBILITY_STATE_REFRESH&&(this.grid.refresh(this.root),t=!0),this.grid.setVisibility(A.VISIBILITY_STATE_VISIBLE)):e===A.VISIBILITY_STATE_VISIBLE&&this.grid.setVisibility(A.VISIBILITY_STATE_HIDDEN),t},_getHeaderIndex:function(e){var t;let i;if(e.parent().hasClass(this._getMappedStyle("groupingcontainer"))){if(t=parseInt(e.parent().attr(this._getMappedAttribute("start")),10),e.get(0)===e.parent().children(":first").get(0))return t;t-=1}else e.hasClass(this._getMappedStyle("rowheadercell"))?(t=this.grid.getStartRowHeader(),i="row"):e.hasClass(this._getMappedStyle("colheadercell"))?(t=this.grid.getStartColumnHeader(),i="column"):e.hasClass(this._getMappedStyle("colendheadercell"))?(t=this.grid.getStartColumnEndHeader(),i="column"):(t=this.grid.getStartRowEndHeader(),i="row");return i&&this.grid.m_options.isFreezeEnabled(i)&&this.grid.m_options._getFreezeIndex(i)>=0&&!e.parent().parent().hasClass(this._getMappedStyle("frozenHeader"))&&(t+=this.grid.m_options._getFreezeIndex(i)+1),t+=e.index()},_isMultipleSelection:function(){return null!=this.options.selectionMode&&("multiple"===this.options.selectionMode.row||"multiple"===this.options.selectionMode.cell)},_remove:function(e){null!=e&&(this.grid._cleanTemplateNodes(e),y(e).remove())},_uniqueId:function(e,t){t?y(e).removeUniqueId():y(e).uniqueId()},_compareValues:function(e,t){return d.Object.compareValues(e,t)},scrollTo:function(e){this.grid.scroll(e)},whenReady:function(){if(this._ready)return Promise.resolve(!0);if(!this._readyPromise){var e=this;this._readyPromise=new Promise(function(t){e._readyPromiseResolve=t})}return this._readyPromise},_NotReady:function(){if(this._ready=!1,!this._readyResolveFunc){var e=u.getContext(this.element[0]).getBusyContext(),t={description:"The component identified by '"+this.element.attr("id")+"' is being loaded."};this._readyResolveFunc=e.addBusyState(t)}},_MakeReady:function(){this._readyPromiseResolve&&(this._readyPromiseResolve(!0),this._readyPromiseResolve=null),this._ready=!0,this._readyPromise=null,this._readyResolveFunc&&(this._readyResolveFunc(),this._readyResolveFunc=null)},_CompareOptionValues:function(e,t,i){switch(e){case"currentCell":case"selection":return d.Object.compareValues(t,i);default:return this._super(e,t,i)}},_WrapCustomElementRenderer:function(e){return this._IsCustomElement()&&"function"==typeof e?function(t){return e(t)}:e}}),A.prototype.unhighlightFloodFillRange=function(e){null==e&&(e=this.GetFloodFillRange()[0]),null!=e&&this._applyBorderClassesAroundRange(this.getElementsInRange(e),e,!1,"Floodfill")},A.prototype.highlightFloodFillRange=function(e){this._applyBorderClassesAroundRange(this.getElementsInRange(e),e,!0,"Floodfill")},A.prototype.handleDatabodyFloodFillDrag=function(e){var t=e.target,i=this.findCell(t);if(null!=i){var s=this.getCellIndexes(i);this.extendFloodFillSelection(s,e)}else this.unhighlightFloodFillRange(),this.m_floodFillRange=[]},A.prototype.GetFloodFillRange=function(){return null==this.m_floodFillRange&&(this.m_floodFillRange=[]),this.m_floodFillRange},A.prototype.extendFloodFillSelection=function(e,t){if("header"===this.m_active.type)return;var i;if(null==(i={row:this.m_active.indexes.row,column:this.m_active.indexes.column}))return;let s,n=!1;s||(s=this.m_selection);let o,r=s[0].startIndex,l=s[0].endIndex;e.row>=r.row&&e.row<=l.row&&(n=!0,e.column>l.column?o="right":e.column<r.column&&(o="left"),e.row=l.row);let a=!1;e.column>=r.column&&e.column<=l.column&&(a=!0,e.row>l.row?o="bottom":e.row<r.row&&(o="top"));let h=r.row===l.row,d=r.column===l.column;if(h&&e.row===r.row&&a||d&&e.column===r.column&&n)return this.unhighlightFloodFillRange(),void(this.m_floodFillRange=[]);if((!n&&!a||e.column<=l.column&&!n)&&(e.column=l.column),n||a||(e.row>l.row?o="bottom":e.row<r.row&&(o="top")),o){let s=r,n=e;this._createRangeWithKeys(s,n,this._extendFloodFillSelectionCallback.bind(this,t,i,o))}else this.unhighlightFloodFillRange()},A.prototype._extendFloodFillSelectionCallback=function(e,t,i,s){let n=s;"top"===i?n.endIndex.row-=1:"bottom"===i?n.startIndex.row=this.m_selectionRange[0].endIndex.row+1:"left"===i?n.endIndex.column-=1:n.startIndex.column=this.m_selectionRange[0].endIndex.column+1;let o=[];this.unhighlightFloodFillRange(),o.push(n),this.m_floodFillRange=o,this.m_floodFillDirection="flood",this.highlightFloodFillRange(n)},A.prototype._addFloodfillAffordance=function(e){if(null==this.m_bottomFloodFillIconContainer){var t=e.target,i=this.findCell(t);if(i||(i=this.findHeader(t)),!i)return;this._attachFloodFillIcon()}},A.prototype._attachFloodFillIcon=function(){this.m_bottomFloodFillIconContainer=document.createElement("div"),this.m_bottomFloodFillIconContainer.className=this.getMappedStyle("toucharea");var e=document.createElement("div");e.className=this.getMappedStyle("floodfillaffordance"),e.setAttribute("role","button"),this.m_bottomFloodFillIconContainer.appendChild(e),this.m_databody.firstChild.appendChild(this.m_bottomFloodFillIconContainer),this.m_floodFillAffordanceHeight=this.m_bottomFloodFillIconContainer.firstElementChild.offsetHeight,this.m_floodFillAffordanceWidth=this.m_bottomFloodFillIconContainer.firstElementChild.offsetWidth,this.m_options.isFloodFillEnabled()&&(this.m_bottomFloodFillIconContainer.addEventListener("mouseover",this.handleFloodFillAffordanceMouseOver.bind(this)),this.m_bottomFloodFillIconContainer.addEventListener("mousedown",this.handleFloodFillAffordanceMouseDown.bind(this)),this.m_bottomFloodFillIconContainer.addEventListener("mouseup",this.handleFloodFillAffordanceMouseUp.bind(this)),this.m_bottomFloodFillIconContainer.addEventListener("mouseleave",this.handleFloodFillAffordanceMouseLeave.bind(this)))},A.prototype.handleFloodFillAffordanceMouseOver=function(e){if(0===e.buttons){e.currentTarget.parentNode.parentNode.style.cursor="crosshair",this.m_cursor="crosshair"}},A.prototype.handleFloodFillAffordanceMouseDown=function(){this.m_databodyDragState=!0,this.m_floodFillDragState=!0,this.m_selectionRange=null,this.m_floodFillRange=null;const e=[this.m_databody,this.m_databodyFrozenCol,this.m_databodyFrozenRow,this.m_databodyFrozenCorner];for(let t=0;t<e.length;t++)e[t]&&(e[t].style.cursor="crosshair");this.m_cursor="crosshair"},A.prototype.handleFloodFillAffordanceMouseUp=function(e){this.m_databodyDragState=!1,this.m_floodFillDragState=!1;e.currentTarget.parentNode.parentNode.style.cursor="default",this.m_cursor="default",this.m_selectionRange=null,this.m_floodFillRange=null},A.prototype.handleFloodFillAffordanceMouseLeave=function(e){if(0===e.buttons){this.m_databodyDragState=!1,this.m_floodFillDragState=!1;e.currentTarget.parentNode.parentNode.style.cursor="default",this.m_cursor="default"}},A.prototype._removeFloodFillAffordance=function(){this._isDatabodyCellActive()&&this.m_bottomFloodFillIconContainer&&this.m_bottomFloodFillIconContainer.parentNode&&(this.m_databody.style.cursor="default",this.m_cursor="default",this.m_bottomFloodFillIconContainer.parentNode.removeChild(this.m_bottomFloodFillIconContainer))},A.prototype._moveFloodFillAffordance=function(){var e=this.getResources().isRTLMode()?"right":"left",t=this.GetSelection();if(t.length>0){var i=this._getTouchSelectionAffordanceSize();if(null!=this.m_bottomFloodFillIconContainer){var s=this._getCellByIndex(t[t.length-1].endIndex);if(s)if(this.setElementDir(this.m_bottomFloodFillIconContainer,this.getElementDir(s,"top")+this.getElementHeight(s)-i+this.m_floodFillAffordanceHeight+1,"top"),this.setElementDir(this.m_bottomFloodFillIconContainer,this.getElementDir(s,e)+this.getElementWidth(s)-(i-this.m_floodFillAffordanceWidth)+1,e),s.classList.contains(this.getMappedStyle("frozenCell"))){this._getCellContainer(s).firstChild.appendChild(this.m_bottomFloodFillIconContainer)}else this.m_databody.firstChild.appendChild(this.m_bottomFloodFillIconContainer);else this._removeFloodFillAffordance()}}},A.prototype.handleDragStart=function(e){let t,i=e.target,s=this.findHeader(i);if(s){let i=this.getHeaderCellAxis(s),n=this.getHeaderCellLevel(s),o=this.getHeaderCellIndex(s);if(this.m_options._isDragEnabled(i)){let r,l,a,h=this.m_selection,d=0,m=0,c=1,u=this.m_options.options.dnd.drag,_="row"===i||"rowEnd"===i?u.rows.dataTypes:u.columns.dataTypes,p="row"===i||"rowEnd"===i?"rows":"columns",g=[],f=[],C=[],y=JSON.parse(JSON.stringify(h));y.sort((e,t)=>e.startIndex[i]<t.startIndex[i]?-1:1),"row"===i||"rowEnd"===i?(a=-1!==this.m_endRowEndHeader,this.m_rowHeader&&(r=this.m_rowHeaderLevelCount-1),this.m_rowEndHeader&&(l=this.m_rowEndHeaderLevelCount-1)):(a=-1!==this.m_endColEndHeader,this.m_colHeader&&(r=this.m_columnHeaderLevelCount-1),this.m_endColHeader&&(l=this.m_columnEndHeaderLevelCount-1));let E="row"===i||"rowEnd"===i?"row":"column";[g,f]=this._getHeadersInSelection(n,y,E,a),g&&g[r]&&C.push(...g[r]),f&&f[l]&&C.push(...f[l]),[t,c,d,m]=this._getCellsForDndContainer(E,y,C,c),this._cellsDragged=t,this.m_dragIndex=o,this.m_dragHeader=s,this._setDragRowsData(e,_);const v=this.m_utils.containsCSSClassName(s,this.getMappedStyle("endheadercell"));this._setDragImage(e,E,t,d,m,c,v,g,f),this._draggedElements=[];for(let e=0;e<h.length;e++){let t=this.getElementsInRange(h[e]);this._draggedElements.push(...t);for(let e=0;e<t.length;e++)this._highlightElement(t[e],["dragSourceOpaque"]);this._applyBorderClassesAroundRange(t,h[e],!1,"Selected")}const w=s[[this.getResources().getMappedAttribute("context")]];"expanded"===w.metadata.expanded&&null!==w.metadata.treeDepth&&this._disableChildElements(i);let b={range:y,axis:E};return this._invokeDndCallback("drag",p,"dragStart",e,b)}e.preventDefault()}},A.prototype._getHeadersInSelection=function(e,t,i){let s={},n={};for(let o=0;o<t.length;o++){let r=[...this.getHeadersByRange(t[o],i)];for(let e=r.length-1;e>=0;e--)this.m_utils.containsCSSClassName(r[e],this.getMappedStyle("selected"))||r.splice(e,1);[s,n]=this._getHeadersUnderLevel(e,r,i,s,n)}return[s,n]},A.prototype._getHeadersUnderLevel=function(e,t,i,s,n){let o="row"===i?this.m_rowHeaderLevelCount:this.m_columnHeaderLevelCount,r="row"===i?this.m_rowEndHeaderLevelCount:this.m_columnEndHeaderLevelCount;for(let i=0;i<t.length;i++){let l=this.getHeaderCellLevel(t[i]);const a=this.m_utils.containsCSSClassName(t[i],this.getMappedStyle("endheadercell"));a?a&&(r>1&&l>=e||1===r)&&(n[l]||(n[l]=[]),n[l].push(t[i])):(o>1&&l>=e||1===o)&&(s[l]||(s[l]=[]),s[l].push(t[i]))}return[s,n]},A.prototype.handleRowDragEnd=function(e){return this._destroyDragImage(),this._unhighlightDragSource(),this._removeDropTargetLine("row"),this._removeDropTargetClass(),this._enableChildElements(),this.m_databodyReorder=!1,this._removeDragStyle("row"),this.m_dragIndex=null,this._invokeDndCallback("drag","rows","dragEnd",e,this._cellsDragged)},A.prototype.handleRowDragOver=function(e){let t;if(this.m_pivotInProgress)this._handlePivotDragOverOnHeader(e);else if(this.m_dragFrozenIndicator){let i=this.m_freezeIndicatorAxis,s=this._getOverIndex(e,i);if("column"===i){if(this.m_utils.containsCSSClassName(e.target,this.getMappedStyle("endheadercell")))return t;s=-1}null!=s&&this.handleFreezeIndicatorDragOver(e,s,i)}else{this.m_databodyReorder=!0;let i="row",s=this._getOverIndex(e,i),n=-1===s?0:s,o=this.getResources().isRTLMode()?"right":"left",r=this._getHeaderByIndex(n,i,this.m_rowHeaderLevelCount-1),l=this._isHeaderWithinSelection(r,i);if(void 0!==s&&this.m_dragIndex!==s){if(this.m_utils.containsCSSClassName(r,this.getMappedStyle("disabledElement")))this._removeDropTargetLine(i),this._removeDropTargetClass(),this.m_dropRowIndex=null;else{let a=this._getRelativePosition(e,i,r,!0),h=this._getDropContext(e,this.m_dropRowIndex,"row");if(t=this._invokeDropCallback("rows","dragOver",e,h),(!1===t||e.defaultPrevented)&&(this._removeDropTargetLine(i),this._removeDropTargetClass(),!l))if("inside"===a)this._highlightElement(r,["dropTarget"]),this._highlightCellsAlongAxis(s,i,"index","add",["dropTarget"]);else{let e=this.getElementDir(r,"top");e+=-1===s?0:this.getElementHeight(r),this._hasFrozenRows()&&s>this.m_frozenRowIndex&&(e+=this.getElementHeight(this.m_databodyFrozenRow)),this._addDropTargetLine(i,e,o,0,n)}}return t}}},A.prototype.handleDatabodyDragOver=function(e){if(this.m_pivotInProgress)this._removePivotDropTargetLine();else if(this.m_dragFrozenIndicator){let t=this.m_freezeIndicatorAxis,i=this._getOverIndex(e,t);null!=i&&this.handleFreezeIndicatorDragOver(e,i[t],t)}else{let t;this.m_databodyReorder=!0,t=this._matchDragDataType(e,"rows")?"row":"column";let i=this._getOverIndex(e,t),s=this.getResources().isRTLMode()?"right":"left";if(i){let n=JSON.parse(JSON.stringify(i));-1===i[t]&&(n[t]=0);let o=this._getCellByIndex(n);if(o&&!this.m_utils.containsCSSClassName(o,this.getMappedStyle("dragSourceOpaque"))){let r,l=this._getRelativePosition(e,t,o,!1),a=this.m_utils.containsCSSClassName(o,"selected");if(this.m_utils.containsCSSClassName(o,this.getMappedStyle("disabledElement")))this._removeDropTargetLine(t),this._removeDropTargetClass(),"row"===t?this.m_dropRowIndex=null:this.m_dropColumnIndex=null;else if(r="row"===t?this._invokeDropCallback("rows","dragOver",e,{index:this.m_dropRowIndex,position:l,axis:"row"}):this._invokeDropCallback("columns","dragOver",e,{index:this.m_dropColumnIndex,position:l,axis:"column"}),(!1===r||e.defaultPrevented)&&(this._removeDropTargetLine(t),this._removeDropTargetClass(),!a)){let e;"inside"===l?this._highlightCellsAlongAxis(i,t,"index","add",["dropTarget"]):"row"===t?(e=this.getElementDir(o,"top"),e+=-1===i[t]?0:this.getElementHeight(o),this._hasFrozenRows()&&i[t]>this.m_frozenRowIndex&&(e+=this.getElementHeight(this.m_databodyFrozenRow)),this._addDropTargetLine(t,e,s,0,n[t])):(e=this.getElementDir(o,s),e+=-1===i[t]?0:this.getElementWidth(o),this._hasFrozenColumns()&&i[t]>this.m_frozenColIndex&&(e+=this.getElementWidth(this.m_databodyFrozenCol)),this._addDropTargetLine(t,0,s,e,n[t]))}return r}}}},A.prototype.handleDatabodyDrop=function(e){let t=e.target.getBoundingClientRect(),i=this.getResources().isRTLMode()?"right":"left",s="after";if(this.m_dragFrozenIndicator){let t,i=this.m_freezeIndicatorAxis;s=this._getRelativePosition(e,i,null,!1),"row"===i?(t=this.m_dropRowIndex,this.m_dropRowIndex=null):(t=this.m_dropColumnIndex,this.m_dropColumnIndex=null),"before"===s&&(t-=1),this.handleFreezeIndicatorDrop(t,i,e)}else{let n,o,r;if(n=this._matchDragDataType(e,"rows")?"row":"column",this._destroyDragImage(),this._removeDropTargetLine(n),this._removeDropTargetClass(),"row"===n){o=this.m_dropRowIndex,e.clientY-t.top<.4*t.height&&(s="before"),this.m_dropRowIndex=null,r={index:o,position:s,axis:"row"}}else{o=this.m_dropColumnIndex,Math.abs(e.clientX-t[i])<.4*t.width&&(s="before"),this.m_dropColumnIndex=null,r={index:o,position:s,axis:"column"}}this._unhighlightDragSource(),this._enableChildElements(),this._resetDragInternals(),null!==o&&this._invokeDropCallback(`${n}s`,"drop",e,r)}this._isSelectionEnabled()&&this.m_utils.isTouchDevice()&&this.m_selection.length>0&&this._moveTouchSelectionAffordance()},A.prototype.handleRowDragEnter=function(e){if(this._getOverIndex(e,"row"),this.m_dropRowIndex){let t=this._getDropContext(e,this.m_dropRowIndex,"row");return this._invokeDropCallback("rows","dragEnter",e,t)}},A.prototype.handleDatabodyDragEnter=function(e){let t;t=this._matchDragDataType(e,"rows")?"row":"column";let i=this._getOverIndex(e,t);if(i){let s=JSON.parse(JSON.stringify(i));-1===i[t]&&(s[t]=0);let n=this._getCellByIndex(s);if(n){let s={index:i,position:this._getRelativePosition(e,t,n,!1),axis:t};if(this.m_dropRowIndex)return this._invokeDropCallback("rows","dragEnter",e,s)}}},A.prototype.handleRowDragLeave=function(e){let t=this._getDropContext(e,this.m_dropRowIndex,"row");var i=this._invokeDndCallback("drop","rows","dragLeave",e,t);return this.m_dropRowIndex=null,i},A.prototype.handleRowDrag=function(e){return!this.m_dragImageAttached&&this.m_utils.isTouchDevice()&&(document.body.appendChild(this.m_dndContainer),this.m_dragImageAttached=!0),this._invokeDndCallback("drag","rows","drag",e)},A.prototype.handleRowDrop=function(e){if(this.m_pivotInProgress)this._handlePivotDropOnHeader(e);else{let t=this.m_dropRowIndex;if(null===this.m_dropRowIndex&&(t=this._getOverIndex(e,"row")),this.m_dragFrozenIndicator){let i=this.m_freezeIndicatorAxis,s=t;if("column"===i){if(this.m_utils.containsCSSClassName(e.target,this.getMappedStyle("endheadercell")))return;s=-1}else{"before"===this._getDropContext(e,s,"row").position&&(s-=1)}this.m_dropRowIndex=null,this.handleFreezeIndicatorDrop(s,i,e)}else if(this._destroyDragImage(),this._removeDropTargetLine("row"),this._removeDropTargetClass(),this.m_dropRowIndex=null,this._unhighlightDragSource(),this._enableChildElements(),this._resetDragInternals(),null!==t){let i=this._getDropContext(e,t,"row");this._invokeDropCallback("rows","drop",e,i)}this._isSelectionEnabled()&&this.m_utils.isTouchDevice()&&this.m_selection.length>0&&this._moveTouchSelectionAffordance()}},A.prototype.handleColumnDragEnd=function(e){let t="column";return this._destroyDragImage(),this._unhighlightDragSource(),this._removeDragStyle(t),this._removeDropTargetLine(t),this._removeDropTargetClass(),this._enableChildElements(),this.m_dragIndex=null,this._invokeDndCallback("drag","columns","dragEnd",e)},A.prototype.handleColumnDragOver=function(e){let t;if(this.m_pivotInProgress)this._handlePivotDragOverOnHeader(e);else{let i=this._getOverIndex(e,"column");if(this.m_dragFrozenIndicator){let s=this.m_freezeIndicatorAxis;if("row"===s){if(this.m_utils.containsCSSClassName(e.target,this.getMappedStyle("endheadercell")))return t;i=-1}null!=i&&this.handleFreezeIndicatorDragOver(e,i,s)}else{this.m_databodyReorder=!0;let s="column",n=-1===i?0:i,o=this.getResources().isRTLMode()?"right":"left",r=this._getHeaderByIndex(n,s,this.m_columnHeaderLevelCount-1);if(this.m_utils.containsCSSClassName(r,this.getMappedStyle("disabledElement")))this._removeDropTargetLine(s),this._removeDropTargetClass(),this.m_dropColumnIndex=null;else if(void 0!==i&&r){let l=this._getRelativePosition(e,s,r,!0),a={axis:"column",position:l,index:this.m_dropColumnIndex};if(t=this._invokeDropCallback("columns","dragOver",e,a),!1===t||e.defaultPrevented)if(this._removeDropTargetLine(s),this._removeDropTargetClass(),"inside"===l)this._highlightElement(r,["dropTarget"]),this._highlightCellsAlongAxis(i,s,"index","add",["dropTarget"]);else{let e=this.getElementDir(r,o);e+=-1===i?0:this.getElementWidth(r),this._hasFrozenColumns()&&i>this.m_frozenColIndex&&(e+=this.getElementWidth(this.m_databodyFrozenCol)),this._addDropTargetLine(s,0,o,e,n)}return t}}}},A.prototype.handleColumnDragEnter=function(e){this._getOverIndex(e,"column");let t=this._getDropContext(e,this.m_dropColumnIndex,"column");return this._invokeDropCallback("columns","dragEnter",e,t)},A.prototype.handleColumnDragLeave=function(e){let t=this._getDropContext(e,this.m_dropColumnIndex,"column");var i=this._invokeDndCallback("drop","columns","dragLeave",e,t);return this.m_dropColumnIndex=null,i},A.prototype.handleColumnDrag=function(e){return this._invokeDndCallback("drag","columns","drag",e)},A.prototype.handleColumnDrop=function(e){if(this.m_pivotInProgress)this._handlePivotDropOnHeader(e);else{let t=this.m_dropColumnIndex;if(null===this.m_dropColumnIndex&&(t=this._getOverIndex(e,"column")),this.m_dragFrozenIndicator){let i=this.m_freezeIndicatorAxis,s=t;if("row"===i){if(this.m_utils.containsCSSClassName(e.target,this.getMappedStyle("endheadercell")))return;s=-1}else{"before"===this._getDropContext(e,s,"column").position&&(s-=1)}this.handleFreezeIndicatorDrop(s,i,e)}else if(this._destroyDragImage(),this._removeDropTargetLine("column"),this._removeDropTargetClass(),this._unhighlightDragSource(),this._enableChildElements(),this._resetDragInternals(),null!==t){let i=this._getDropContext(e,t,"column");this._invokeDropCallback("columns","drop",e,i)}}this.m_dropColumnIndex=null,this._isSelectionEnabled()&&this.m_utils.isTouchDevice()&&this.m_selection.length>0&&this._moveTouchSelectionAffordance()},A.prototype._computeDndContainerOffsetHeight=function(e,t,i,s){let n=0;if("row"===e)for(let e=0;e<t.length;e++){n+=t[e].offsetHeight}else{let e=t[0].offsetHeight;i&&(e+=s[0].offsetHeight),n=this.m_databody.offsetHeight+e}return n},A.prototype._computeDndContainerOffsetWidth=function(e,t,i,s){let n=0;if("row"===e){let e=t[0].offsetWidth;i&&(e+=s[0].offsetWidth),n=this.m_databody.offsetWidth+e}else for(let e=0;e<t.length;e++){n+=t[e].offsetWidth}return n},A.prototype._getCellsForDndContainer=function(e,t,i,s){let n,o,r=[],l=this.getResources().isRTLMode()?"right":"left",a=this.m_databody.scrollLeft,h=this.m_databody.scrollTop,d=0,m=0;o="row"===e?-1!==this.m_endRowEndHeader:-1!==this.m_endColEndHeader,n="row"===e?"width":"height";let c=Math.abs(a);"column"===e&&(l="top",c=h);for(let a=0,h=0;a<t.length;a++)for(let u=t[a].startIndex[e];u<=t[a].endIndex[e];u++){let t,a=this._getAxisCellsByIndex(u,e);i[h]&&r.push(i[h]);for(let e=0;e<a.length;e++)if(this.getElementDir(a[e],l)>c){t=e-1;break}a=a.slice(t,a.length);let _=0,p=this.getElementDir(this.m_databody,n);"row"===e&&this._hasFrozenColumns()&&(p+=this.getElementWidth(this.m_databodyFrozenCol)),"column"===e&&this._hasFrozenRows()&&(p+=this.getElementHeight(this.m_databodyFrozenRow));for(let e=0;e<a.length;e++)if(_+=this.getElementDir(a[e],n),_>p){t=e;break}t>0&&(a=a.slice(0,t+1)),r.push(...a),o&&r.push(i[Math.ceil(i.length/2+h)]),"row"!==e||d?"column"===e&&(d+=this.getElementDir(i[h],"width")):d=this._computeContainerDimension(r,"width"),"column"!==e||m?"row"===e&&(m+=this.getElementDir(i[h],"height")):m=this._computeContainerDimension(r,"height"),h+=1,s=a.length}return[r,s,d,m]},A.prototype._computeContainerDimension=function(e,t){let i=0;for(let s=0;s<e.length;s++)i+=this.getElementDir(e[s],t);return i},A.prototype._setDragImage=function(e,t,i,s,n,o,r,l,a){let h=this.getResources().isRTLMode()?"right":"left",d=this._populateDndContainer(i,t,h,o,l,a,s,n),m=Math.max(0,e.offsetX),c=Math.max(0,e.offsetY);r?(m="row"===t&&"left"===h?s-m:m,c="column"===t?n-c:c):m="row"===t&&"left"===h?m:s-m,e.dataTransfer.setDragImage(d,m,c)},A.prototype._computeDndContainerCellCountInRow=function(e,t){let i,s=e,n=1;return i="row"===t||"rowEnd"===t?-1!==this.m_endRowEndHeader:-1!==this.m_endColEndHeader,i&&(n=2),s+=n,s},A.prototype._populateDndContainer=function(e,t,i,s,n,o,r,l){let a=document.getElementById("dndContainer");a||(a=document.createElement("div"),a.setAttribute("id","dndContainer"),a.setAttribute("class","dndContainer"));let h=[this.getMappedStyle("focus"),this.getMappedStyle("hover"),this.getMappedStyle("active"),this.getMappedStyle("topSelected"),this.getMappedStyle("startSelected"),this.getMappedStyle("bottomSelected"),this.getMappedStyle("endSelected"),this.getMappedStyle("selected")],d=0,m=0,c=0,u=0;this._headersDragged=[];let _=this._computeDndContainerCellCountInRow(s,t);[u,c]=this._appendNestedHeadersToContainer(i,t,a,d,m,n,!1),m=u,d=c;for(let s=0;s<e.length;s++){let n=e[s],o=n.cloneNode(!0);o.classList.remove(...h),o.setAttribute("draggable",!1),o.style.top=`${d}px`,o.style[i]=`${m}px`,"row"===t?(s%_==0?m=u+n.offsetWidth:m+=n.offsetWidth,s%_==_-1&&(d+=n.offsetHeight,s===e.length-1?d=0:m=u)):(s%_==0?d=c+n.offsetHeight:d+=n.offsetHeight,s%_==_-1&&(m+=n.offsetWidth,s===e.length-1?m=0:d=c)),a.appendChild(o),n.classList.add("drag-source-opaque")}return[u,c]=this._appendNestedHeadersToContainer(i,t,a,d,m,o,!0),a.style.width=`${r}px`,a.style.height=`${l}px`,"column"===t?a.style.height=`${l+c}px`:a.style.width=`${r+u}px`,this.m_utils.isTouchDevice()?(this.m_dragImageAttached=!1,this.m_dndContainer=a):document.body.appendChild(a),a},A.prototype._appendNestedHeadersToContainer=function(e,t,i,s,n,o,r){let l;r?(this.m_rowEndHeaderLevelCount||this.m_columnEndHeaderLevelCount)&&(l="row"===t?this.m_rowEndHeaderLevelCount-1:this.m_columnEndHeaderLevelCount-1):l="row"===t?this.m_rowHeaderLevelCount-1:this.m_columnHeaderLevelCount-1;let a=Object.keys(o),h=[this.getMappedStyle("focus"),this.getMappedStyle("hover"),this.getMappedStyle("active"),this.getMappedStyle("selected")];r&&(a=a.reverse());for(let r=0;r<a.length;r++){let d=parseInt(a[r],10);if(d!==l){let r=o[d].length;for(let l=0;l<o[d].length;l++){let a=o[d][l];this._headersDragged.push(a);let m=a.cloneNode(!0);m.classList.remove(...h),m.style.top=`${s}px`,m.style[e]=`${n}px`,"row"===t?(l%r==0?s=a.offsetHeight:s+=a.offsetHeight,l===r-1&&(n+=a.offsetWidth,s=0)):(l%r==0?n=a.offsetWidth:n+=a.offsetWidth,l===r-1&&(n=0,s+=a.offsetHeight)),i.appendChild(m),a.classList.add("drag-source-opaque")}}}return[n,s]},A.prototype._destroyDragImage=function(){let e=document.getElementById("dndContainer");e&&e.parentNode.removeChild(e),this.m_dragImageAttached=!1,this.m_dndContainer=null},A.prototype._setDragRowsData=function(e,t){if(t){let i=e.dataTransfer,s=JSON.stringify(this.m_selection);if("string"==typeof t)i.setData(t,s);else for(let e=0;e<t.length;e++)i.setData(t[e],s)}},A.prototype._getOverIndex=function(e,t){let i,s,n,o=e.target,r=this.getResources().isRTLMode()?"right":"left",l=o.getBoundingClientRect(),a=this.findHeader(o),h=!1,d=!1;if(a?(s=a[this.getResources().getMappedAttribute("context")],n=s.index,"column"===t?this.m_dropColumnIndex=n:this.m_dropRowIndex=n,h=this._isParentNode(s),d=this._isLeafNode(s)):(i=this.findCell(o),i&&(s=i[this.getResources().getMappedAttribute("context")],n=s.indexes,"column"===t?this.m_dropColumnIndex=s.indexes[t]:this.m_dropRowIndex=s.indexes[t])),void 0!==n){let o,m="width";if("column"===t?o=Math.abs(e.clientX-l[r]):(o=e.clientY-l.top,m="height"),a&&(h||d))o<.25*l[m]&&(n-=1);else if(o<.4*l[m])if(a)n-=1;else if(i&&void 0!==n){let e=s.indexes.row,i=s.indexes.column;n="row"===t?this.createIndex(e-1,i):this.createIndex(e,i-1)}}return n},A.prototype._getRelativePosition=function(e,t,i,s){let n,o=e.target,r=this.getResources().isRTLMode()?"right":"left",l=o.getBoundingClientRect(),a=!1,h=!1,d="before";if(s){let e=i[this.getResources().getMappedAttribute("context")];a=this._isParentNode(e),h=this._isLeafNode(e)}let m="width";return"column"===t?n=Math.abs(e.clientX-l[r]):(n=e.clientY-l.top,m="height"),i&&(a||h)?n>=.25*l[m]&&n<=.75*l[m]?d="inside":n>.75*l[m]&&(d="after"):n>.4*l[m]&&(d="after"),d},A.prototype._addDropTargetLine=function(e,t,i,s,n){let o="row"===e?"rowDropTargetLine":"colDropTargetLine";this.m_dropTarget=document.createElement("div"),this.m_dropHeaderTarget=document.createElement("div"),this.m_dropEndHeaderTarget=document.createElement("div"),this._setAttribute(this.m_dropTarget,"index",n);let r=this.m_databody,l=this.m_rowHeader,a=this.m_rowEndHeader;"column"===e&&(l=this.m_colHeader,a=this.m_colEndHeader),"row"===e&&this._hasFrozenRows()&&n<=this.m_frozenRowIndex?(r=this.m_databodyFrozenRow,l=this.m_rowHeaderFrozen,a=this.m_rowEndHeaderFrozen):"column"===e&&this._hasFrozenColumns()&&n<=this.m_frozenColIndex&&(r=this.m_databodyFrozenCol,l=this.m_colHeaderFrozen,a=this.m_colEndHeaderFrozen);const h=function(t,s,n,o,r,a,h,d,m){let c="row"===e?this._getCornerDimensions("height"):this._getCornerDimensions("width");if("row"===e){let e=Math.abs(this.getElementDir(l.firstChild,"top"));0!==e&&(s-=e),t=s+=c,n=s,this._hasFrozenColumns()&&(h+=this.getElementWidth(this.m_databodyFrozenCol))}else{let e=Math.abs(this.getElementDir(l.firstChild,i));0!==e&&(r-=e),o=r+=c,a=r,this._hasFrozenRows()&&(h+=this.getElementHeight(this.m_databodyFrozenRow))}return[t,s,n,o,r,a,h,d,m]}.bind(this);this._addVisualIndicator(e,t,i,s,o,this.m_dropTarget,this.m_dropHeaderTarget,this.m_dropEndHeaderTarget,r,l,a,h),this._addDnDVisualIndicatorEventListener()},A.prototype._addVisualIndicator=function(e,t,i,s,n,o,r,l,a,h,d,m){let c,u="width",_="width";"row"===e?c=-1!==this.m_endRowEndHeader:(u="height",_="height",c=-1!==this.m_endColEndHeader);let[p,g,f,C,y,E,v,w,b]=this._calculateVisualIndicatorPosition(a,h,d,t,s,i,e);m&&"function"==typeof m&&([p,g,f,C,y,E,v,w,b]=m(p,g,f,C,y,E,v,w,b)),this._setVisualIndicatorStyle(o,n,p,i,C,v,u),this._setVisualIndicatorStyle(r,n,g,i,y,w,_),c&&this._setVisualIndicatorStyle(l,n,f,i,E,b,_),this.m_root.appendChild(o),this.m_root.appendChild(r),c&&this.m_root.appendChild(l)},A.prototype._addDnDVisualIndicatorEventListener=function(){this.m_dropTarget.addEventListener("dragover",this.handleDropTargetDragOver.bind(this),!1),this.m_dropHeaderTarget.addEventListener("dragover",this.handleDropTargetDragOver.bind(this),!1),this.m_dropEndHeaderTarget.addEventListener("dragover",this.handleDropTargetDragOver.bind(this),!1),this.m_dropTarget.addEventListener("drop",this.handleDropTargetDrop.bind(this),!1),this.m_dropHeaderTarget.addEventListener("drop",this.handleDropTargetDrop.bind(this),!1),this.m_dropEndHeaderTarget.addEventListener("drop",this.handleDropTargetDrop.bind(this),!1)},A.prototype._setVisualIndicatorStyle=function(e,t,i,s,n,o,r){this.m_utils.addCSSClassName(e,this.getMappedStyle(t)),this.setElementDir(e,i,"top"),this.setElementDir(e,n,s),"width"===r?this.setElementWidth(e,o):this.setElementHeight(e,o)},A.prototype._calculateVisualIndicatorPosition=function(e,t,i,s,n,o,r){let l=s,a=n,h=s,d=n,m=s,c=n,u=0,_=0,p=0,g="row"===r?this.getElementWidth.bind(this):this.getElementHeight.bind(this);return u=g(e.firstChild),_=g(t.firstChild),p=g(i.firstChild),"column"===r?l+=_:a+=_,"row"===r&&this.m_rowEndHeader?c=n+this.getElementDir(this.m_rowEndHeader,o):"column"===r&&this.m_colEndHeader&&(m=s+this.getElementDir(this.m_colEndHeader,"top")),[l,h,m,a,d,c,u,_,p]},A.prototype._getCornerDimensions=function(e){let t=0,i=0;return this.m_corner&&(t=this.getElementHeight(this.m_corner),i=this.getElementWidth(this.m_corner)),e?"height"===e?t:i:[t,i]},A.prototype._setDropTargetLineStyle=function(e,t,i,s,n,o,r){this.m_utils.addCSSClassName(e,this.getMappedStyle(t)),this.setElementDir(e,i,"top"),this.setElementDir(e,n,s),"width"===r?this.setElementWidth(e,o):this.setElementHeight(e,o)},A.prototype._removeDropTargetLine=function(){this._removeDropTargetEventListeners(),this._remove(this.m_dropTarget),this._remove(this.m_dropHeaderTarget),this.m_dropEndHeaderTarget&&this._remove(this.m_dropEndHeaderTarget)},A.prototype._removeDropTargetEventListeners=function(){this.m_dropTarget&&(this.m_dropTarget.removeEventListener("dragover",this.handleDropTargetDragOver,!1),this.m_dropTarget.removeEventListener("drop",this.handleDropTargetDrop,!1)),this.m_dropHeaderTarget&&(this.m_dropHeaderTarget.removeEventListener("dragover",this.handleDropTargetDragOver,!1),this.m_dropHeaderTarget.removeEventListener("drop",this.handleDropTargetDrop,!1)),this.m_dropEndHeaderTarget&&(this.m_dropEndHeaderTarget.removeEventListener("dragover",this.handleDropTargetDragOver,!1),this.m_dropEndHeaderTarget.removeEventListener("drop",this.handleDropTargetDrop,!1))},A.prototype._removeDropTargetClass=function(){let e=document.querySelectorAll(`.${this.getMappedStyle("dropTarget")}`);e&&e.length&&this._unhighlightElementsByClassName(e,["dropTarget"])},A.prototype._isHeaderWithinSelection=function(e,t){let i=this.getHeaderCellIndex(e),s=!1;if(this.m_selection&&this.m_selection.length)for(let n=0;n<this.m_selection.length;n++){let o=this._getHeadersWithinSelection(this.m_selection[n],i,t);for(let t=0;t<o.length;t++)if(o[t]===e&&o[o.length-1]!==e){s=!0;break}}return s},A.prototype._invokeDndCallback=function(e,t,i,s,n){let o,r=this.m_options.options.dnd[e];if(r&&r[t]){let e=r[t][i];if(e&&"function"==typeof e)try{this.m_customElement?e(s,n):o=e(s,n)}catch(e){throw new Error(e)}}return o},A.prototype._invokeDropCallback=function(e,t,i,s){var n=this._invokeDndCallback("drop",e,t,i,s);return void 0===n&&this._matchDragDataType(i,e)&&i.preventDefault(),n},A.prototype._matchDragDataType=function(e,t){var i=e.dataTransfer.types,s=this.m_options.options.dnd.drop;if(s&&s[t]&&s[t].dataTypes)for(var n=s[t].dataTypes,o="string"==typeof n?[n]:n,r=0;r<i.length;r++)if(o.indexOf(i[r])>=0)return!0;return!1},A.prototype.handleCancelDrag=function(){this._unhighlightDragSource(),this._enableChildElements(),this._resetDragInternals()},A.prototype._resetDragInternals=function(){this._draggedElements=[],this._cellsDragged=[],this._headersDragged=[],this.m_dragIndex=null,this.m_dragHeader=null,this.m_databodyReorder=!1},A.prototype._disableChildElements=function(e){const t=this.getResources().getMappedAttribute("context");let i="row"===e?this.m_rowHeader:this.m_colHeader;i=i.querySelectorAll(`.${this.getResources().getMappedStyle("headercell")}`);let s=this._getLogicalChildHeaderNodes(i,e,this.m_dragHeader,this.m_dragIndex+1);for(let i=0;i<s.length;i++){let n=s[i][t].index;this._highlightCellsAlongAxis(n,e,"index","add",["disabledElement"]),this._highlightElement(s[i],["disabledElement"])}},A.prototype._getLogicalChildHeaderNodes=function(e,t,i,s){const n=this.getResources().getMappedAttribute("context");let o=[];if("row"===t){let t=i[n].metadata.treeDepth;for(let i=s;i<e.length;i++){if(!(t<e[i][n].metadata.treeDepth))break;o.push(e[i])}}else{let t=i[n].level;for(let i=s;i<e.length;i++){if(!(t<e[i][n].level))break;o.push(e[i])}}return o},A.prototype._enableChildElements=function(){let e=this.getMappedStyle("disabledElement"),t=document.querySelectorAll(`.${e}`);this._unhighlightElementsByClassName(t,["disabledElement"])},A.prototype._unhighlightDragSource=function(){let e=["draggableItem","dragSourceOpaque"];this._draggedElements?.length&&this._unhighlightElementsByClassName(this._draggedElements,e)},A.prototype._removeDragStyle=function(e){let t="row"===e?this.m_rowHeader:this.m_rowEndHeader,i="row"===e?this.m_colHeader:this.m_colEndHeader,s=this.getMappedStyle("dragging"),n=t.firstChild.querySelectorAll(`.${s}`);this._unhighlightElementsByClassName(n,["dragging"]),-1!==this.m_endRowEndHeader&&(n=i.firstChild.querySelectorAll(`.${s}`),this._unhighlightElementsByClassName(n,["dragging"]))},A.prototype._getDropContext=function(e,t,i){let s=e.target,n=this.findHeader(s);return{index:t,axis:i,position:this._getRelativePosition(e,i,n,!0)}},A.prototype.handleDropTargetDragOver=function(e){if(this.m_dragFrozenIndicator)return void e.preventDefault();let t=e.target,i=this.m_utils.containsCSSClassName(t,this.getMappedStyle("rowDropTargetLine"))?"row":"column",s={axis:i,position:"after",index:this._getAttribute(this.m_dropTarget,"index")},n="row"===i||"rowEnd"===i?"rows":"columns";this._invokeDropCallback(n,"dragOver",e,s)},A.prototype.handleDropTargetDrop=function(e){let t=e.target,i=this.m_utils.containsCSSClassName(t,this.getMappedStyle("rowDropTargetLine"))?"row":"column",s=this._getAttribute(this.m_dropTarget,"index");if("row"===i?this.m_dropRowIndex=null:this.m_dropColumnIndex=null,this.m_dragFrozenIndicator)return void this.handleFreezeIndicatorDrop(s,i,e);let n="row"===i||"rowEnd"===i?"rows":"columns";if(this._destroyDragImage(),this._removeDropTargetLine(i),this._removeDropTargetClass(),this._unhighlightDragSource(),this._enableChildElements(),this._resetDragInternals(),null!==s){let t={axis:i,position:"after",index:s};this._invokeDropCallback(n,"drop",e,t)}},A.prototype._populateFrozenContainer=function(e,t,i,s,n,o,r,l){let a=document.createDocumentFragment(),h=this._addCellsToFragment(a,t,i,s,n,o,r,l);return this._populateDatabody(e,a),this.m_initialized||this._setScrollerDimension(e.parentElement,h.totalRowHeight,h.totalColumnWidth),h},A.prototype._addFrozenIndicator=function(e,t,i,s,n){const o="row"===e?"rowFrozenIndicator":"colFrozenIndicator",r="FrozenIndicator",l=this.createSubId(`databody${e}${r}`),a=this.createSubId(`${e}header${r}`),h=this.createSubId(`${e}endHeader${r}`);if(null===document.getElementById(l)){const t=this._createFrozenIndicatorElement(l);"row"===e?this.m_databodyRowFrozenTarget=t:this.m_databodyColFrozenTarget=t,this._setAttribute(t,"index",n)}if(null===document.getElementById(a)){const t=this._createFrozenIndicatorElement(a);"row"===e?this.m_rowHeaderFrozenTarget=t:this.m_colHeaderFrozenTarget=t}if(null===document.getElementById(h)){const t=this._createFrozenIndicatorElement(h);"row"===e?this.m_rowEndHeaderFrozenTarget=t:this.m_colEndHeaderFrozenTarget=t}const d=function(t,s,n,o,r,l,a,h,d){let m="row"===e?this.getElementWidth.bind(this):this.getElementHeight.bind(this);return this._hasFrozenRows()&&this._hasFrozenColumns()?a+=m(this.m_databodyFrozenCorner.firstChild):this._hasFrozenRows()&&"column"===e?a+=m(this.m_databodyFrozenRow.firstChild):this._hasFrozenColumns()&&"row"===e&&(a+=m(this.m_databodyFrozenCol.firstChild)),"row"===e&&-1===this.m_endRowHeader&&this.m_headerLabels.column&&this.m_headerLabels.column.length&&(o=this._hasFrozenColumns()?this.getElementDir(this.m_databodyFrozenCol,i):this.getElementDir(this.m_databody,i)),"column"===e&&-1===this.m_endColHeader&&this.m_headerLabels.row&&this.m_headerLabels.row.length&&(t=this.getElementHeight(this.m_headerLabels.row[0])),[t,s,n,o,r,l,a,h,d]}.bind(this);"row"===e?this._addVisualIndicator(e,t,i,s,o,this.m_databodyRowFrozenTarget,this.m_rowHeaderFrozenTarget,this.m_rowEndHeaderFrozenTarget,this.m_databodyFrozenRow,this.m_rowHeaderFrozen,this.m_rowEndHeaderFrozen,d):this._addVisualIndicator(e,t,i,s,o,this.m_databodyColFrozenTarget,this.m_colHeaderFrozenTarget,this.m_colEndHeaderFrozenTarget,this.m_databodyFrozenCol,this.m_colHeaderFrozen,this.m_colEndHeaderFrozen,d)},A.prototype._addFreezeVisualIndicatorEventListener=function(e){e.addEventListener("mousedown",this.handleFreezeIndicatorMouseDown.bind(this),!1),e.addEventListener("mouseup",this.handleFreezeIndicatorMouseUpOrOut.bind(this),!1),e.addEventListener("mouseout",this.handleFreezeIndicatorMouseUpOrOut.bind(this),!1),e.addEventListener("dragstart",this.handleFreezeIndicatorDragStart.bind(this),!1),e.addEventListener("dragend",this.handleFreezeIndicatorDragEnd.bind(this),!1),e.addEventListener("drop",this.handleFreezeIndicatorDrop.bind(this),!1)},A.prototype._removeFrozenIndicator=function(e){if("column"===e){let e=-1!==this.m_endColEndHeader;this.m_root.removeChild(this.m_databodyColFrozenTarget),this.m_root.removeChild(this.m_colHeaderFrozenTarget),e&&this.m_root.removeChild(this.m_colEndHeaderFrozenTarget)}else{let e=-1!==this.m_endRowEndHeader;this.m_root.removeChild(this.m_databodyRowFrozenTarget),this.m_root.removeChild(this.m_rowHeaderFrozenTarget),e&&this.m_root.removeChild(this.m_rowEndHeaderFrozenTarget)}},A.prototype._setFrozenContainerDimension=function(e,t,i,s,n,o){const r=this.getResources().isRTLMode()?"right":"left",l=this.m_databodyFrozenCol,a=this.m_databodyFrozenRow,h=this.m_databodyFrozenCorner,d=this.m_colHeader,m=this.m_colEndHeader,c=this.m_rowHeader,u=this.m_rowEndHeader,_=t,p=e;let g,f,C,y=0,E=0;if(this._hasFrozenColumns()&&(y=this.getElementWidth(l),!y&&(-1!==this.m_endColHeader||-1!==this.m_endColEndHeader))){const e=-1!==this.m_endColHeader?this.m_colHeaderFrozen:this.m_colEndHeaderFrozen;for(let t=0;t<e.firstChild.childElementCount;t++){let i=e.firstChild.childNodes[t];y+=this.getElementWidth(i)}}if(this._hasFrozenRows()&&(E=this.getElementHeight(a),!E&&(-1!==this.m_endRowHeader||-1!==this.m_endRowEndHeader))){const e=-1!==this.m_endRowHeader?this.m_rowHeaderFrozen:this.m_rowEndHeaderFrozen;for(let t=0;t<e.firstChild.childElementCount;t++){let i=e.firstChild.childNodes[t];E+=this.getElementHeight(i)}}if(this._hasFrozenColumns()&&this._hasFrozenRows()&&(f=this.getElementHeight(h),g=this.getElementWidth(h),y||(y=g),E||(E=f)),l&&(C=n),this._hasFrozenColumns()&&this._hasFrozenRows()&&(this._setElementDimension(h,n,i,f,g),C=f+n),this._hasFrozenColumns()&&this._setElementDimension(l,C,i,_,y),this.m_colHeaderFrozen){let e=this.getElementHeight(this.m_colHeaderFrozen);this._setElementDimension(this.m_colHeaderFrozen,0,i,e,y)}if(this.m_colEndHeaderFrozen){let e=this.getElementHeight(this.m_colEndHeaderFrozen);this._setElementDimension(this.m_colEndHeaderFrozen,t+n+E,i,e,y)}const v=this.m_frozenColIndex;if(this._hasFrozenColumns()&&this._addFrozenIndicator("column",0,r,i+y,v),i+=y,this.setElementDir(d,i,r),this.setElementDir(m,i,r),this.setElementHeight(d,n),this.setElementHeight(m,o),a&&this._setElementDimension(a,n,i,E,p),this.m_rowHeaderFrozen){let e=this.getElementWidth(this.m_rowHeaderFrozen);this._setElementDimension(this.m_rowHeaderFrozen,n,0,E,e)}if(this.m_rowEndHeaderFrozen){let t=this.getElementWidth(this.m_rowEndHeaderFrozen);this._setElementDimension(this.m_rowEndHeaderFrozen,n,e+i,E,t)}const w=this.m_frozenRowIndex;return this._hasFrozenRows()&&this._addFrozenIndicator("row",n+E,r,0,w),n+=E,this.setElementDir(c,n,"top"),this.setElementDir(u,n,"top"),this.setElementWidth(c,i-y),this.setElementWidth(u,s),[i,n]},A.prototype._setElementDimension=function(e,t,i,s,n){const o=this.getResources().isRTLMode()?"right":"left";null!==n&&this.setElementWidth(e,n),null!==s&&this.setElementHeight(e,s),null!==t&&this.setElementDir(e,t,"top"),null!==i&&this.setElementDir(e,i,o)},A.prototype._buildFrozenHeaders=function(e,t,i,s){let n=s.start,o={headerStart:s.start,endHeaderStart:s.start,headerFetchCount:0,endHeaderFetchCount:0};if(null===this.m_options._getFreezeIndex(e)||-1===this.m_options._getFreezeIndex(e)||!this._isFreezeFeasible(e,t,i,n,0)){o={headerStart:n,endHeaderStart:n},t&&(o.headerFetchCount=t.getCount()),i&&(o.endHeaderFetchCount=i.getCount()),"column"===e?this.m_frozenColIndex=this.m_options.isFreezeEnabled(e)?-1:null:this.m_frozenRowIndex=this.m_options.isFreezeEnabled(e)?-1:null;let s=this.m_rowHeaderFrozen,r=this.m_rowEndHeaderFrozen;return"column"===e&&(s=this.m_colHeaderFrozen,r=this.m_colEndHeaderFrozen),s&&(this.m_root.removeChild(s),"column"===e?this.m_colHeaderFrozen=null:this.m_rowHeaderFrozen=null),r&&(this.m_root.removeChild(r),"column"===e?this.m_colEndHeaderFrozen=null:this.m_rowEndHeaderFrozen=null),o}return o=this._buildFrozenAxisHeaders(e,t,i,s,o),o},A.prototype._isFreezeFeasible=function(e,t,i,s,n){let o=!1;if(t&&i){if("column"===e&&!this.m_initialized&&(this.m_frozenColIndex>=t.getCount()||this.m_frozenColIndex>=i.getCount())||"row"===e&&!this.m_initialized&&(this.m_frozenRowIndex>=t.getCount()||this.m_frozenRowIndex>=i.getCount()))return o;const r=t.getExtent(s,n),l=i.getExtent(s,n);if(r.more.after||l.more.after)return o;let a=r.extent,h=l.extent;a===h||1===a||1===h?o=!0:a>h?(h+=i.getExtent(s+1,n).extent,a===h&&(o=!0)):(a+=t.getExtent(s+1,n).extent,a===h&&(o=!0));const d=r.extent>l.extent?r.extent:l.extent;if(o&&d>1){const t="row"===e?this.m_frozenRowIndex:this.m_frozenColIndex;let i=this._adjustFrozenIndexBasedOnExtent(t,d);"row"===e?this.m_frozenRowIndex=i:this.m_frozenColIndex=i}}else t&&(!this.m_initialized&&("column"===e&&this.m_frozenColIndex<t.getCount()||"row"===e&&this.m_frozenRowIndex<t.getCount())||this.m_initialized)||i&&(!this.m_initialized&&("column"===e&&this.m_frozenColIndex<i.getCount()||"row"===e&&this.m_frozenRowIndex<i.getCount())||this.m_initialized)?o=!0:t||i||(o=!0);return o},A.prototype._adjustFrozenIndexBasedOnExtent=function(e,t){let i;return i=e>=t?e+(t-e%t)-1:t-1,i},A.prototype._buildFrozenAxisHeaders=function(e,t,i,s,n){let o=s.start,r=this.getDataSource().getCount(e),l=this.buildRowHeaders.bind(this),a=this.buildRowEndHeaders.bind(this),h=this.m_frozenRowIndex,d=this.m_rowHeaderFrozen,m=this.m_rowEndHeaderFrozen;if("column"===e&&(h=this.m_frozenColIndex,d=this.m_colHeaderFrozen,m=this.m_colEndHeaderFrozen,l=this.buildColumnHeaders.bind(this),a=this.buildColumnEndHeaders.bind(this)),null!=t){let i=t.getCount();if(n.headerFetchCount=i,null!==h&&-1!==h&&(!1===this.m_initialized&&(i-=h+1),d&&d.firstChild&&!d.firstChild.childNodes.length)){l(d,t,o,r,!1,!1,h+1,!0);let s=d.firstChild.querySelectorAll(`.${this.getMappedStyle("groupingcontainer")}`);o=this._calculateFrozenIndex(h+1,s),i=t.getCount()-o,"column"===e?(this.m_endColHeaderPixel=0,this.m_frozenColIndex=o-1):(this.m_endRowHeaderPixel=0,this.m_frozenRowIndex=o-1),n.headerFetchCount=i,n.headerStart=o}}if(null!=i){let t=i.getCount();if(n.endHeaderFetchCount=t,null!==h&&-1!==h&&(!1===this.m_initialized&&(t-=h+1),m&&m.firstChild&&!m.firstChild.childNodes.length)){o=s.start,a(m,i,o,r,!1,!1,h+1,!0),"column"===e?this.m_endColEndHeaderPixel=0:this.m_endRowEndHeaderPixel=0,o=h+1;let l=m.firstChild.querySelectorAll(`.${this.getMappedStyle("groupingcontainer")}`);o=this._calculateFrozenIndex(h+1,l),t=i.getCount()-o,n.endHeaderFetchCount=t,n.endHeaderStart=o,"column"===e?this.m_frozenColIndex=o-1:this.m_frozenRowIndex=o-1}}return n},A.prototype._handleFreezeRow=function(e){let t;if(this._isSelectionEnabled()&&this.isMultipleSelection()&&this.m_selection&&this.m_selection.length){let e=[],i=[];-1===this.m_endRowHeader&&-1===this.m_endRowEndHeader||([e,i]=this._getHeadersInSelection(this.m_rowHeaderLevelCount-1,this.m_selection,"row"),-1!==this.m_endRowHeader&&e&&Object.keys(e).length?(e=e[Object.keys(e)],t=e[e.length-1]):-1!==this.m_endRowEndHeader&&i&&Object.keys(i).length&&(i=i[0],t=i[i.length-1]))}t||(t=this.findHeader(e.target));let i,s="row",n=!0;const o=this.getResources().getMappedAttribute("context");if(null===t){let r,l;i=this.findCell(e.target),this._isSelectionEnabled()&&this.isMultipleSelection()&&this.m_selection&&this.m_selection.length&&(i=this._getCellByIndex(this.m_selection[0].endIndex));const a=i[o].indexes;let h=!1;if(a.row<this.m_frozenRowIndex+1&&(h=!0),-1!==this.m_endRowHeader&&-1!==this.m_endRowEndHeader){let e=this._isDynamicFreezeFeasible(a.row,s,h);n=e.isFeasible,r=e.headerIndex,l=e.endHeaderIndex,t=this._getMaxExtentNestedHeader(s,r,l,h)}else-1!==this.m_endRowHeader?s="row":-1!==this.m_endRowEndHeader&&(s="rowEnd"),t=this.getHeaderFromCell(i,s)}else{let e,i=t[o].index,r=!1;if(i<this.m_frozenRowIndex+1&&(r=!0),-1!==this.m_endRowHeader&&-1!==this.m_endRowEndHeader){let o=this._isDynamicFreezeFeasible(i,s,r);n=o.isFeasible,i=o.headerIndex,e=o.endHeaderIndex,t=this._getMaxExtentNestedHeader(s,i,e,r)}}if(n){this._mutateRowFrozenContainer(t,i,s),this.deleteAndApplyHiddenIndicators();let n={event:e,ui:{frozenCount:this.m_frozenRowIndex+1}};this.fireEvent("rowFreeze",n)}},A.prototype._handleFreezeCol=function(e){let t;if(this._isSelectionEnabled()&&this.isMultipleSelection()&&this.m_selection&&this.m_selection.length){let e,i;-1===this.m_endColHeader&&-1===this.m_endColEndHeader||([e,i]=this._getHeadersInSelection(this.m_columnHeaderLevelCount-1,this.m_selection,"column"),-1!==this.m_endColHeader&&e&&Object.keys(e).length?(e=e[Object.keys(e)],t=e[e.length-1]):-1!==this.m_endColEndHeader&&i&&Object.keys(i).length&&(i=i[0],t=i[i.length-1]))}t||(t=this.findHeader(e.target));let i,s="column",n=!0;const o=this.getResources().getMappedAttribute("context");if(null===t){i=this.findCell(e.target),this._isSelectionEnabled()&&this.isMultipleSelection()&&this.m_selection&&this.m_selection.length&&(i=this._getCellByIndex(this.m_selection[0].endIndex));let r,l,a=i[o].indexes,h=!1;if(a.column<this.m_frozenColIndex+1&&(h=!0),-1!==this.m_endColHeader&&-1!==this.m_endColEndHeader){let e=this._isDynamicFreezeFeasible(a.column,s,h);n=e.isFeasible,r=e.headerIndex,l=e.endHeaderIndex,t=this._getMaxExtentNestedHeader(s,r,l,h)}else-1!==this.m_endColHeader?s="column":-1!==this.m_endColEndHeader&&(s="columnEnd"),t=this.getHeaderFromCell(i,s)}else{let e,i=t[o].index,r=!1;if(i<this.m_frozenColIndex+1&&(r=!0),-1!==this.m_endColHeader&&-1!==this.m_endColEndHeader){let o=this._isDynamicFreezeFeasible(i,s,r);n=o.isFeasible,i=o.headerIndex,e=o.endHeaderIndex,t=this._getMaxExtentNestedHeader(s,i,e,r)}}if(n){this._mutateColumnFrozenContainer(t,i,s),this.deleteAndApplyHiddenIndicators();let n={event:e,ui:{frozenCount:this.m_frozenColIndex+1}};this.fireEvent("columnFreeze",n)}},A.prototype._getMaxExtentNestedHeader=function(e,t,i,s){let n,o=t,r=s?this.m_colHeaderFrozen:this.m_colHeader,l=s?this.m_colEndHeaderFrozen:this.m_colEndHeader,a="column"===e?this.m_columnHeaderLevelCount:this.m_rowHeaderLevelCount,h="column"===e?this.m_startColHeader:this.m_startRowHeader;"row"===e&&(r=s?this.m_rowHeaderFrozen:this.m_rowHeader,l=s?this.m_rowEndHeaderFrozen:this.m_rowEndHeader);let d=r;return t<i&&(o=i,a="column"===e?this.m_columnEndHeaderLevelCount:this.m_rowEndHeaderLevelCount,d=l,h="column"===e?this.m_startColEndHeader:this.m_startRowEndHeader),n=this._getHeaderByIndexFromRoot(o,a-1,d,a,h),n},A.prototype._isDynamicFreezeFeasible=function(e,t,i){let s=!1,n=e,o=e,r=this.m_frozenRowIndex,l=i?this.m_rowHeaderFrozen:this.m_rowHeader,a=i?this.m_rowEndHeaderFrozen:this.m_rowEndHeader,h=this.m_rowHeaderLevelCount,d=this.m_rowEndHeaderLevelCount;"column"===t&&(r=this.m_frozenColIndex,l=i?this.m_colHeaderFrozen:this.m_colHeader,a=i?this.m_colEndHeaderFrozen:this.m_colEndHeader,h=this.m_columnHeaderLevelCount,d=this.m_columnEndHeaderLevelCount),i||(1===h&&(n=e-(r+1)),1===d&&(o=e-(r+1)));let m,c,u=1,_=1,p=n,g=o;h>1&&(m=this._getHeaderContainer(n,0,l,h),u=this._getExtent(m,t),p=this._getAttribute(m,"start",!0)+u),d>1&&(c=this._getHeaderContainer(o,0,a,d),_=this._getExtent(c,t),g=this._getAttribute(c,"start",!0)+_),u!==_&&1!==u&&1!==_&&p!==g||(s=!0);const f=u>_?u:_;return s&&f>1&&(f===u?n=this._adjustFrozenIndexBasedOnExtent(n,f):o=this._adjustFrozenIndexBasedOnExtent(o,f)),{isFeasible:s,headerIndex:n,endHeaderIndex:o}},A.prototype._getOutermostHeaderFromNestedHeaders=function(e){let t=!1;const i=this.getMappedStyle("groupingcontainer"),s=this.getMappedStyle("endheadercell"),n=this.getMappedStyle("headercell");for(;e.parentNode.classList.contains(i);)e.classList.contains(s)&&(t=!0),e=e.parentNode;return e.classList.contains(i)&&(e=t?e.querySelector(`.${s}`):e.querySelector(`.${n}`)),e},A.prototype._mutateColumnFrozenContainer=function(e,t,i){const s=this.getResources().getMappedAttribute("context");if(e){e=this._getOutermostHeaderFromNestedHeaders(e);let t=this.getHeaderCellIndex(e),n=e[s].extent;n>1&&(t+=n-1);const o=this.m_utils.containsCSSClassName(e,this.getMappedStyle("frozenHeader"));this._hasFrozenColumns()?o?t!==this.m_frozenColIndex&&this._removeCellsFromFrozenColumnContainer(t,e):this._appendCellsToFrozenColumnContainer(t,e,!1):null!==this.m_frozenColIndex&&-1!==this.m_frozenColIndex||this._createColumnFrozenSectionAndMutate(i,t,e);let r=this._getElementFromActiveObject(this.m_active);this._setActive(r,this.m_active)}else{let e=t[s].indexes.column;if(null===this.m_frozenColIndex||-1===this.m_frozenColIndex)this._createColumnFrozenSectionAndMutate(i,e,null);else{let i=!1;this.m_utils.containsCSSClassName(t,this.getMappedStyle("frozenCell"))&&(this.m_databodyFrozenCorner?.querySelector(`#${t.id}`)||this.m_databodyFrozenCol?.querySelector(`#${t.id}`))&&(i=!0),i?this._removeCellsFromFrozenColumnContainer(e):this._appendCellsToFrozenColumnContainer(e,null,!1),this._setActive(t,this._createActiveObject(t))}}this._isSelectionEnabled()&&this.m_utils.isTouchDevice()&&this.m_selection.length>0&&this._moveTouchSelectionAffordance()},A.prototype._createColumnFrozenSectionAndMutate=function(e,t,i){this._createFrozenHeaderElements("column",this.getMappedStyle("colHeaderFrozen"),this.getMappedStyle("colEndHeaderFrozen"));const s=this._createDatabodyElement("databodyFrozenCol");if(this.m_root.insertBefore(s,this.m_status),this.m_databodyFrozenCol=s,this._hasFrozenRows()){const e=this._createDatabodyElement("databodyFrozenCorner");this.m_root.insertBefore(e,this.m_status),this.m_databodyFrozenCorner=e}this._addListenersOnFrozenSections(null,null,this.m_colHeaderFrozen,this.m_colEndHeaderFrozen),this._appendCellsToFrozenColumnContainer(t,i,!0)},A.prototype._mutateRowFrozenContainer=function(e,t,i){const s=this.getResources().getMappedAttribute("context");if(e){e=this._getOutermostHeaderFromNestedHeaders(e);let t=this.getHeaderCellIndex(e),n=e[s].extent;n>1&&(t+=n-1);const o=this.m_utils.containsCSSClassName(e,this.getMappedStyle("frozenHeader"));this._hasFrozenRows()?o?t!==this.m_frozenRowIndex&&this._removeCellsFromFrozenRowContainer(t):this._appendCellsToFrozenRowContainer(t,e,!1):null!==this.m_frozenRowIndex&&-1!==this.m_frozenRowIndex||this._createRowFrozenSectionAndMutate(i,t,e);let r=this._getElementFromActiveObject(this.m_active);this._setActive(r,this.m_active)}else{let e=t[s].indexes.row;if(null===this.m_frozenRowIndex||-1===this.m_frozenRowIndex)this._createRowFrozenSectionAndMutate(i,e,null);else{let i=!1;this.m_utils.containsCSSClassName(t,this.getMappedStyle("frozenCell"))&&(this.m_databodyFrozenRow?.querySelector(`#${t.id}`)||this.m_databodyFrozenCorner?.querySelector(`#${t.id}`))&&(i=!0),i?this._removeCellsFromFrozenRowContainer(e):this._appendCellsToFrozenRowContainer(e,null,!1)}this._setActive(t,this.m_active)}this._isSelectionEnabled()&&this.m_utils.isTouchDevice()&&this.m_selection.length>0&&this._moveTouchSelectionAffordance()},A.prototype._createRowFrozenSectionAndMutate=function(e,t,i){this._createFrozenHeaderElements("row",this.getMappedStyle("rowHeaderFrozen"),this.getMappedStyle("rowEndHeaderFrozen"));const s=this._createDatabodyElement("databodyFrozenRow");if(this.m_root.insertBefore(s,this.m_status),this.m_databodyFrozenRow=s,this._hasFrozenColumns()){const e=this._createDatabodyElement("databodyFrozenCorner");this.m_root.insertBefore(e,this.m_status),this.m_databodyFrozenCorner=e}this._addListenersOnFrozenSections(this.m_rowHeaderFrozen,this.m_rowEndHeaderFrozen,null,null),this._appendCellsToFrozenRowContainer(t,i,!0)},A.prototype._updateFrozenSection=function(e,t){if(-1===e||null==e)this._handleUnFreeze(t);else if(this.m_options.isFreezeEnabled(t)){let i=this.createIndex(0,e);"row"===t&&(i=this.createIndex(e,0));let s,n,o=null,r=this._getCellByIndex(i),l=!0,a=!1;if("column"===t){if(e<this.m_frozenColIndex+1&&(a=!0),-1!==this.m_endColHeader&&-1!==this.m_endColEndHeader){let i=this._isDynamicFreezeFeasible(e,t,a);l=i.isFeasible,s=i.headerIndex,n=i.endHeaderIndex,o=this._getMaxExtentNestedHeader(t,s,n,a)}else(-1!==this.m_endColHeader&&e>this.m_endColHeader||-1!==this.m_endColEndHeader&&e>this.m_endColEndHeader)&&(l=!1);l&&this._mutateColumnFrozenContainer(o,r,t)}else{if(e<this.m_frozenRowIndex+1&&(a=!0),-1!==this.m_endRowHeader&&-1!==this.m_endRowEndHeader){let i=this._isDynamicFreezeFeasible(e,t,a);l=i.isFeasible,s=i.headerIndex,n=i.endHeaderIndex,o=this._getMaxExtentNestedHeader(t,s,n,a)}else(-1!==this.m_endRowHeader&&e>this.m_endRowHeader||-1!==this.m_endRowEndHeader&&e>this.m_endRowEndHeader)&&(l=!1);l&&this._mutateRowFrozenContainer(o,r,t)}}},A.prototype._appendCellsToFrozenColumnContainer=function(e,t,i){const s=this.m_frozenColIndex,n="column",o=this.getResources().isRTLMode()?"right":"left";let r=this.getElementWidth(this.m_databodyFrozenCol),l=this.getElementDir(this.m_databodyFrozenCol,o);i&&(l=this.getElementDir(this.m_databody,o));let a=this.getElementWidth(this.m_databody);this.m_databodyFrozenRow&&this._hasFrozenRows()&&(a=this.getElementWidth(this.m_databodyFrozenRow));let h=r,d=e+1,m=0;null!==s&&(m=s+1);let c=e,u=e+1,_=e+1;null!==s&&-1!==s||(u=this.m_columnHeaderLevelCount>1?e+1:0,_=this.m_columnEndHeaderLevelCount>1?e+1:0),d-=m;let p=[],{cells:g,cellsDimensionToAdjust:f}=this._getCellsToFreeze(m,c,n),C=!1;0===f&&(C=!0);let{headers:y,endHeaders:E}=this._getColumnHeadersToFreeze(t,e,c,m);if(this.m_databodyFrozenCorner){if(p=this._getFrozenAxisCells(n,c),C){let e=p[p.length-1];f=this.getElementDir(e,o)+this.getElementWidth(e)}for(let e=0;e<p.length;e++)this.setElementDir(p[e],h,o),this.m_databodyFrozenCorner.firstChild.appendChild(p[e]),e%d==d-1?h=r:h+=this.getElementWidth(p[e])}let v=h;g.length?h=this._appendElementsToFrozenContainer(n,g,this.m_databodyFrozenCol,v,o,this.getMappedStyle("frozenCell"),d):h+=f,this._appendElementsToFrozenContainer(n,y,this.m_colHeaderFrozen,v,o,this.getMappedStyle("frozenHeader"),d),E.length&&this._appendElementsToFrozenContainer(n,E,this.m_colEndHeaderFrozen,v,o,this.getMappedStyle("frozenHeader"),d),c+1<=this.m_endCol&&(this._shiftCellsAlongAxis(n,-f,c+1,!0),this.m_databodyFrozenRow&&this._hasFrozenRows()&&this._shiftFrozenCellsAlongAxis(n,-f,c+1,!0),this._shiftHeadersAlongAxisInContainer(this.m_colHeader.firstChild,u,-f,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colheadercell")),this._shiftHeadersAlongAxisInContainer(this.m_colEndHeader.firstChild,_,-f,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colendheadercell"))),this.m_endColPixel-=f,this.m_endColHeaderPixel-=f,this.m_endColEndHeaderPixel-=f;let w=l+h,b=a-f;if(b=b<0?0:b,this.m_endRowEndHeader){const e=this.getElementDir(this.m_rowEndHeader,o);h=h>e?e-l:h,w=l+h}this._setElementDimension(this.m_databody,null,w,null,b),this._setElementDimension(this.m_colHeader,null,w,null,b),this.m_colEndHeader&&this._setElementDimension(this.m_colEndHeader,null,w,null,b),i?(this._setElementDimension(this.m_databodyFrozenCol,this.getElementDir(this.m_databody,"top"),l,this.getElementHeight(this.m_databody),h),this._setElementDimension(this.m_colHeaderFrozen,this.getElementDir(this.m_colHeader,"top"),l,this.getElementHeight(this.m_colHeader),h),this.m_colEndHeader&&this._setElementDimension(this.m_colEndHeaderFrozen,this.getElementDir(this.m_colEndHeader,"top"),l,this.getElementHeight(this.m_colEndHeader),h),this.m_databodyFrozenCorner&&this._setElementDimension(this.m_databodyFrozenCorner,this.getElementDir(this.m_databodyFrozenRow,"top"),this.getElementDir(this.m_databodyFrozenRow,o),this.getElementHeight(this.m_databodyFrozenRow),h)):(this.setElementWidth(this.m_databodyFrozenCol,h),this.setElementWidth(this.m_colHeaderFrozen,h),this.m_colEndHeaderFrozen&&this.setElementWidth(this.m_colEndHeaderFrozen,h),this.m_databodyFrozenCorner&&this.setElementWidth(this.m_databodyFrozenCorner,h)),this.m_databodyFrozenRow&&this._setElementDimension(this.m_databodyFrozenRow,null,w,null,b),this._addFrozenIndicator(n,0,o,l+h,c),this.m_frozenColIndex=c},A.prototype._appendCellsToFrozenRowContainer=function(e,t,i){const s=this.m_frozenRowIndex,n="row",o=this.getResources().isRTLMode()?"right":"left";let r=this.getElementHeight(this.m_databodyFrozenRow),l=this.getElementDir(this.m_databodyFrozenRow,"top");i&&(l=this.getElementDir(this.m_databody,"top"));let a=this.getElementHeight(this.m_databody);this.m_databodyFrozenCol&&this._hasFrozenColumns()&&(a=this.getElementHeight(this.m_databodyFrozenCol));let h=r,d=e+1,m=0;null!==s&&(m=s+1);let c=e,u=e+1,_=e+1;null!==s&&-1!==s||(u=this.m_rowHeaderLevelCount>1?e+1:0,_=this.m_rowEndHeaderLevelCount>1?e+1:0),d-=m;let p=[],{cells:g,cellsDimensionToAdjust:f}=this._getCellsToFreeze(m,c,n),C=!1;0===f&&(C=!0);let{headers:y,endHeaders:E}=this._getRowHeadersToFreeze(t,e,c,m);if(this.m_databodyFrozenCorner){p=this._getFrozenAxisCells(n,c);for(let e=0;e<p.length;e++)this.setElementDir(p[e],h,"top"),this.m_databodyFrozenCorner.firstChild.appendChild(p[e]),e%(this.m_frozenColIndex+1)===this.m_frozenColIndex&&(h+=this.getElementHeight(p[e]),C&&(f+=this.getElementHeight(p[e])))}let v=r;g.length&&(h=this._appendElementsToFrozenContainer(n,g,this.m_databodyFrozenRow,v,"top",this.getMappedStyle("frozenCell"),d)),this._appendElementsToFrozenContainer(n,y,this.m_rowHeaderFrozen,v,"top",this.getMappedStyle("frozenHeader"),d),E.length&&this._appendElementsToFrozenContainer(n,E,this.m_rowEndHeaderFrozen,v,"top",this.getMappedStyle("frozenHeader"),d),c+1<=this.m_endRow&&(this._shiftCellsAlongAxis(n,-f,c+1,!0),this.m_databodyFrozenCol&&this._hasFrozenColumns()&&this._shiftFrozenCellsAlongAxis(n,-f,c+1,!0),this._shiftHeadersAlongAxisInContainer(this.m_rowHeader.firstChild,u,-f,"top",this.getMappedStyle("rowheadercell")),this._shiftHeadersAlongAxisInContainer(this.m_rowEndHeader.firstChild,_,-f,"top",this.getMappedStyle("rowendheadercell"))),this.m_endRowPixel-=f,this.m_endRowHeaderPixel-=f,this.m_endRowEndHeaderPixel-=f;let w=l+h,b=a-f;if(b=b<0?0:b,this.m_endColEndHeader){const e=this.getElementDir(this.m_colEndHeader,"top");h=h>e?e-l:h,w=l+h}this._setElementDimension(this.m_databody,w,null,b,null),this._setElementDimension(this.m_rowHeader,w,null,b,null),this.m_rowEndHeader&&this._setElementDimension(this.m_rowEndHeader,w,null,b,null),i?(this._setElementDimension(this.m_databodyFrozenRow,l,this.getElementDir(this.m_databody,o),h,this.getElementWidth(this.m_databody)),this._setElementDimension(this.m_rowHeaderFrozen,l,this.getElementDir(this.m_rowHeader,o),h,this.getElementWidth(this.m_rowHeader)),this.m_rowEndHeader&&this._setElementDimension(this.m_rowEndHeaderFrozen,l,this.getElementDir(this.m_rowEndHeader,o),h,this.getElementWidth(this.m_rowEndHeader)),this.m_databodyFrozenCorner&&this._setElementDimension(this.m_databodyFrozenCorner,l,this.getElementDir(this.m_databodyFrozenCol,o),h,this.getElementWidth(this.m_databodyFrozenCol))):(this.setElementHeight(this.m_databodyFrozenRow,h),this.setElementHeight(this.m_rowHeaderFrozen,h),this.m_rowEndHeaderFrozen&&this.setElementHeight(this.m_rowEndHeaderFrozen,h),this.m_databodyFrozenCorner&&this.setElementHeight(this.m_databodyFrozenCorner,h)),this.m_databodyFrozenCol&&this._setElementDimension(this.m_databodyFrozenCol,w,null,b,null),this._addFrozenIndicator(n,w,o,0,c),this.m_frozenRowIndex=c},A.prototype._getCellsToFreeze=function(e,t,i){const s="row"===i?this.getElementHeight.bind(this):this.getElementWidth.bind(this);let n=0,o=[];for(let r=e,l=0;r<=t;r+=1,l+=1){let e=this._getAxisCellsByIndex(r,i);e=e.filter(e=>!e.classList.contains(this.getMappedStyle("frozenCell"))),e.length&&(n+=s(e[0]),o.push(...e))}return{cells:o,cellsDimensionToAdjust:n}},A.prototype._getColumnHeadersToFreeze=function(e,t,i,s){let n=[],o=[];if(-1!==this.m_endColHeader)if(1===this.m_columnHeaderLevelCount)for(let e=s;e<=i;e++){let t=this._getHeadersByIndex(e,"column");n.push(...t)}else{let i=!1,o=s,r=e;for(this.m_utils.containsCSSClassName(r,this.getMappedStyle("headercell"))||(r=this._getHeaderByIndex(t,"column",0));!i;){let e=this._getHeaderContainer(o,0,this.m_colHeader,this.m_columnHeaderLevelCount);e.querySelector(`#${r.id}`)?i=!0:o+=this._getAttribute(e,"extent",!0),n.push(e)}}if(-1!==this.m_endColEndHeader)if(1===this.m_columnEndHeaderLevelCount)for(let e=s;e<=i;e++){let t=this._getHeadersByIndex(e,"columnEnd");o.push(...t)}else{let i=!1,n=s;let r=e;for(this.m_utils.containsCSSClassName(e,this.getMappedStyle("endheadercell"))||(r=this._getHeaderByIndex(t,"columnEnd",0));!i;){let e=this._getHeaderContainer(n,0,this.m_colEndHeader,this.m_columnEndHeaderLevelCount);e.querySelector(`#${r.id}`)?i=!0:n+=this._getAttribute(e,"extent",!0),o.push(e)}}return{headers:n,endHeaders:o}},A.prototype._getRowHeadersToFreeze=function(e,t,i,s){let n=[],o=[];if(-1!==this.m_endRowHeader)if(1===this.m_rowHeaderLevelCount)for(let e=s;e<=i;e++){let t=this._getHeadersByIndex(e,"row");n.push(...t)}else{let i=!1,o=s,r=e;for(this.m_utils.containsCSSClassName(r,this.getMappedStyle("headercell"))||(r=this._getHeaderByIndex(t,"row",0));!i;){let e=this._getHeaderContainer(o,0,this.m_rowHeader,this.m_rowHeaderLevelCount);e.querySelector(`#${r.id}`)?i=!0:o+=this._getAttribute(e,"extent",!0),n.push(e)}}if(-1!==this.m_endRowEndHeader)if(1===this.m_rowEndHeaderLevelCount)for(let e=s;e<=i;e++){let t=this._getHeadersByIndex(e,"rowEnd");o.push(...t)}else{let i=!1,n=s;let r=e;for(this.m_utils.containsCSSClassName(e,this.getMappedStyle("endheadercell"))||(r=this._getHeaderByIndex(t,"rowEnd",0));!i;){let e=this._getHeaderContainer(n,0,this.m_rowEndHeader,this.m_rowEndHeaderLevelCount);e.querySelector(`#${r.id}`)?i=!0:n+=this._getAttribute(e,"extent",!0),o.push(e)}}return{headers:n,endHeaders:o}},A.prototype._removeCellsFromFrozenColumnContainer=function(e){const t=this.m_frozenColIndex,i="column",s=this.getResources().isRTLMode()?"right":"left";let n=this.getElementWidth(this.m_databodyFrozenCol),o=this.getElementWidth(this.m_databody);this.m_databodyFrozenRow&&this._hasFrozenRows()&&(o=this.getElementWidth(this.m_databodyFrozenRow));const r=this.getElementDir(this.m_databodyFrozenCol,s);let l=-1===e?t+1:t-e,a=0,h=[],d=[],m=this.m_columnHeaderLevelCount>1?t+1:e+1,c=this.m_columnEndHeaderLevelCount>1?t+1:e+1,{headers:u,endHeaders:_}=this._getColumnHeadersToUnFreeze(e+1),p=0;null!==this.m_frozenRowIndex&&(p=this.m_frozenRowIndex+1);for(let t=p;t<=this.m_endRow;t++)for(let i=e+1;i<=this.m_frozenColIndex;i++){let e=this._getFrozenCellByIndex(this.createIndex(t,i),"row");t===p&&(a+=this.getElementWidth(e)),h.push(e)}let g=a;for(let t=p,i=0;i<=e;i++){let e=this._getFrozenCellByIndex(this.createIndex(t,i),"row");g+=this.getElementWidth(e)}if(!g)for(let t=0,i=0;t<=e;t++){let e=this._getFrozenCellByIndex(this.createIndex(t,i),"row",!0);e&&(g+=this.getElementWidth(e))}let f=0;if(this.m_databodyFrozenCorner){let t=this.m_databodyFrozenRow.firstChild.firstChild;d=this._getFrozenAxisCells(i,e+1,!0);for(let e=0;e<d.length;e++)this.setElementDir(d[e],f,s),this.m_databodyFrozenRow.firstChild.insertBefore(d[e],t),e%l==l-1?f=0:f+=this.getElementWidth(d[e])}if(!h.length&&d.length){let e=d[d.length-1];a=this.getElementWidth(e)+this.getElementDir(e,s),g+=a}f=0;let C=this.m_databody.firstChild.firstChild;for(let e=0;e<h.length;e++)this.setElementDir(h[e],f,s),this.m_utils.removeCSSClassName(h[e],this.getMappedStyle("frozenCell")),this.m_databody.firstChild.insertBefore(h[e],C),e%l==l-1?f=0:f+=this.getElementWidth(h[e]);let y=this.m_colHeader.firstChild.firstChild;const E=this.getMappedStyle("frozenHeader");f=-a,n=g;let v=n-a;if(this.m_columnHeaderLevelCount>1&&(f=-v),this._insertFrozenElementsToContainer(i,u,this.m_colHeader,y,f,s,E,l),this.m_colEndHeader){f=-a,this.m_columnEndHeaderLevelCount>1&&(f=-v);let e=this.m_colEndHeader.firstChild.firstChild;this._insertFrozenElementsToContainer(i,_,this.m_colEndHeader,e,f,s,E,l)}t+1<=this.m_endCol&&(this._shiftCellsAlongAxis(i,a,t+1,!0),this.m_databodyFrozenRow&&this._shiftFrozenCellsAlongAxis(i,a,t+1,!0)),this._shiftHeadersAlongAxisInContainer(this.m_colHeader.firstChild,m,a,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colheadercell")),this._shiftHeadersAlongAxisInContainer(this.m_colEndHeader.firstChild,c,a,this.getResources().isRTLMode()?"right":"left",this.getMappedStyle("colendheadercell")),this.m_endColPixel+=a,this.m_endColHeaderPixel+=a,this.m_endColEndHeaderPixel+=a;let w=v+r,b=o+a;if(this.m_endRowEndHeader){const e=this.getElementDir(this.m_rowEndHeader,s);b=w+b>e?e-w:b}this._setElementDimension(this.m_databody,null,w,null,b),this._setElementDimension(this.m_colHeader,null,w,null,b),this.m_colEndHeader&&this._setElementDimension(this.m_colEndHeader,null,w,null,b),this.setElementWidth(this.m_databodyFrozenCol,v),this.setElementWidth(this.m_colHeaderFrozen,v),this.m_colEndHeaderFrozen&&this.setElementWidth(this.m_colEndHeaderFrozen,v),this.m_databodyFrozenRow&&this._setElementDimension(this.m_databodyFrozenRow,null,w,null,b),this.m_databodyFrozenCorner&&this.setElementWidth(this.m_databodyFrozenCorner,v),-1===e?this._removeFrozenIndicator(i):this._addFrozenIndicator(i,0,s,w,e),this.m_frozenColIndex=e},A.prototype._removeCellsFromFrozenRowContainer=function(e){const t=this.m_frozenRowIndex,i="row",s=this.getResources().isRTLMode()?"right":"left";let n=this.getElementHeight(this.m_databodyFrozenRow),o=this.getElementDir(this.m_databodyFrozenRow,"top"),r=this.getElementHeight(this.m_databody);this.m_databodyFrozenCol&&this._hasFrozenColumns()&&(r=this.getElementHeight(this.m_databodyFrozenCol));let l=-1===e?t+1:t-e,a=0,h=[],d=[],{headers:m,endHeaders:c}=this._getRowHeadersToUnFreeze(e+1),u=this.m_rowHeaderLevelCount>1?t+1:e+1,_=this.m_rowEndHeaderLevelCount>1?t+1:e+1,p=0;this._hasFrozenColumns()&&(p=this.m_frozenColIndex+1);for(let t=e+1;t<=this.m_frozenRowIndex;t++)for(let e=p;e<=this.m_endCol;e++){let i=this._getFrozenCellByIndex(this.createIndex(t,e),"column");e===p&&(a+=this.getElementHeight(i)),h.push(i)}let g=a;for(let t=0,i=p;t<=e;t++){let e=this._getFrozenCellByIndex(this.createIndex(t,i),"column");e&&(g+=this.getElementHeight(e))}if(!g)for(let t=0,i=0;t<=e;t++){let e=this._getFrozenCellByIndex(this.createIndex(t,i),"column",!0);e&&(g+=this.getElementHeight(e))}let f=0;if(this.m_databodyFrozenCorner){let t=this.m_databodyFrozenCol.firstChild.firstChild;d=this._getFrozenAxisCells(i,e+1,!0);for(let e=0;e<d.length;e++)this.setElementDir(d[e],f,"top"),this.m_databodyFrozenCol.firstChild.insertBefore(d[e],t),(e+1)%(this.m_frozenColIndex+1)==0&&(f+=this.getElementHeight(d[e]))}if(!h.length&&d.length){let e=d[d.length-1];a=this.getElementHeight(e)+this.getElementDir(e,"top"),g+=a}f=0;let C=this.m_databody.firstChild.firstChild;for(let e=0;e<h.length;e++)this.setElementDir(h[e],f,"top"),this.m_utils.removeCSSClassName(h[e],this.getMappedStyle("frozenCell")),this.m_databody.firstChild.insertBefore(h[e],C),(e+1)%Math.floor(h.length/l)==0&&(f+=this.getElementHeight(h[e]));let y=this.m_rowHeader.firstChild.firstChild;const E=this.getMappedStyle("frozenHeader");n=g;let v=n-a;if(f=-a,this.m_rowHeaderLevelCount>1&&(f=-v),this._insertFrozenElementsToContainer(i,m,this.m_rowHeader,y,f,"top",E,l),this.m_rowEndHeader){f=-a,this.m_rowEndHeaderLevelCount>1&&(f=-v);let e=this.m_rowEndHeader.firstChild.firstChild;this._insertFrozenElementsToContainer(i,c,this.m_rowEndHeader,e,f,"top",E,l)}t+1<=this.m_endRow&&(this._shiftCellsAlongAxis(i,a,t+1,!0),this.m_databodyFrozenCol&&this._shiftFrozenCellsAlongAxis(i,a,t+1,!0)),this._shiftHeadersAlongAxisInContainer(this.m_rowHeader.firstChild,u,a,"top",this.getMappedStyle("rowheadercell")),this._shiftHeadersAlongAxisInContainer(this.m_rowEndHeader.firstChild,_,a,"top",this.getMappedStyle("rowendheadercell"));let w=v+o,b=r+a;if(this.m_endColEndHeader){const e=this.getElementDir(this.m_colEndHeader,"top");b=w+b>e?e-w:b}this.m_endRowPixel+=a,this.m_endRowHeaderPixel+=a,this.m_endRowEndHeaderPixel+=a,this._setElementDimension(this.m_databody,w,null,b,null),this._setElementDimension(this.m_rowHeader,w,null,b,null),this.m_rowEndHeader&&this._setElementDimension(this.m_rowEndHeader,w,null,b,null),this.setElementHeight(this.m_databodyFrozenRow,v),this.setElementHeight(this.m_rowHeaderFrozen,v),this.m_rowEndHeaderFrozen&&this.setElementHeight(this.m_rowEndHeaderFrozen,v),this.m_databodyFrozenCol&&this._setElementDimension(this.m_databodyFrozenCol,w,null,b,null),this.m_databodyFrozenCorner&&this.setElementHeight(this.m_databodyFrozenCorner,v),-1===e?this._removeFrozenIndicator(i):this._addFrozenIndicator(i,w,s,0,e),this.m_frozenRowIndex=e},A.prototype._getColumnHeadersToUnFreeze=function(e){let t=[],i=[];if(this.m_colHeaderFrozen&&-1!==this.m_endColHeader)if(1===this.m_columnHeaderLevelCount)for(let i=e;i<=this.m_frozenColIndex;i++){let e=this._getHeadersByIndex(i,"column");t.push(...e)}else for(let i=e;i<=this.m_frozenColIndex;){let e=this._getHeaderContainer(i,0,this.m_colHeaderFrozen,this.m_columnHeaderLevelCount);t.push(e);i+=this._getAttribute(e,"extent",!0)}if(this.m_colEndHeaderFrozen&&-1!==this.m_endColEndHeader)if(1===this.m_columnEndHeaderLevelCount)for(let t=e;t<=this.m_frozenColIndex;t++){let e=this._getHeadersByIndex(t,"columnEnd");i.push(...e)}else for(let t=e;t<=this.m_frozenColIndex;){let e=this._getHeaderContainer(t,0,this.m_colEndHeaderFrozen,this.m_columnEndHeaderLevelCount);i.push(e);t+=this._getAttribute(e,"extent",!0)}return{headers:t,endHeaders:i}},A.prototype._getRowHeadersToUnFreeze=function(e){let t=[],i=[];if(this.m_rowHeaderFrozen&&-1!==this.m_endRowHeader)if(1===this.m_rowHeaderLevelCount)for(let i=e;i<=this.m_frozenRowIndex;i++){let e=this._getHeadersByIndex(i,"row");t.push(...e)}else for(let i=e;i<=this.m_frozenRowIndex;){let e=this._getHeaderContainer(i,0,this.m_rowHeaderFrozen,this.m_rowHeaderLevelCount);t.push(e);i+=this._getAttribute(e,"extent",!0)}if(this.m_rowEndHeaderFrozen&&-1!==this.m_endRowEndHeader)if(1===this.m_rowEndHeaderLevelCount)for(let t=e;t<=this.m_frozenRowIndex;t++){let e=this._getHeadersByIndex(t,"rowEnd");i.push(...e)}else for(let t=e;t<=this.m_frozenRowIndex;){let e=this._getHeaderContainer(t,0,this.m_rowEndHeaderFrozen,this.m_rowEndHeaderLevelCount);i.push(e);t+=this._getAttribute(e,"extent",!0)}return{headers:t,endHeaders:i}},A.prototype._appendElementsToFrozenContainer=function(e,t,i,s,n,o,r){let l=this.getElementHeight.bind(this);"column"===e&&(l=this.getElementWidth.bind(this));for(let e=0;e<t.length;e++)o===this.getMappedStyle("frozenHeader")&&t[e].classList.contains(this.getMappedStyle("groupingcontainer"))?(this._adjustContainerElementsDirValue(t[e],s,n,o,!1),i.firstChild.appendChild(t[e])):(this.setElementDir(t[e],s,n),this.m_utils.addCSSClassName(t[e],o),i.firstChild.appendChild(t[e]),(e+1)%Math.floor(t.length/r)==0&&(s+=l(t[e])));return s},A.prototype._adjustContainerElementsDirValue=function(e,t,i,s,n){let o=e.childNodes;for(let e=0;e<o.length;e++)if(o[e].classList&&(o[e].classList.contains(this.getMappedStyle("headercell"))||o[e].classList.contains(this.getMappedStyle("endheadercell")))){let r=this.getElementDir(o[e],i)+t;n?this.m_utils.removeCSSClassName(o[e],s):this.m_utils.addCSSClassName(o[e],s),this.setElementDir(o[e],r,i)}else this._adjustContainerElementsDirValue(o[e],t,i,s,n);return t},A.prototype._insertFrozenElementsToContainer=function(e,t,i,s,n,o,r,l){let a=this.getElementHeight.bind(this);"column"===e&&(a=this.getElementWidth.bind(this));for(let e=0;e<t.length;e++)r===this.getMappedStyle("frozenHeader")&&t[e].classList.contains(this.getMappedStyle("groupingcontainer"))?(this._adjustContainerElementsDirValue(t[e],n,o,r,!0),i.firstChild.insertBefore(t[e],s)):(this.setElementDir(t[e],n,o),this.m_utils.removeCSSClassName(t[e],r),i.firstChild.insertBefore(t[e],s),(e+1)%(t.length/l)==0&&(n+=a(t[e])))},A.prototype._getFrozenAxisCells=function(e,t,i){const s=this.m_frozenRowIndex,n=this.m_frozenColIndex;let o=0,r=s,l=n+1,a=t,h=[];null===n&&(l=0),"row"!==e||i||(s&&(o=s+1),r=t,l=0,a=n),i&&(o="row"===e?t:0,l="row"===e?0:t,a=n,r=s);for(let t=o;t<=r;t++)for(let s=l;s<=a;s++){let n=this._getFrozenCellByIndex(this.createIndex(t,s),e,i);n&&h.push(n)}return h},A.prototype._createFrozenHeaderElements=function(e,t,i){const s=this.getMappedStyle("scroller")+(this.m_utils.isTouchDeviceNotIOS()?" "+this.getMappedStyle("scroller-mobile"):"");let n;n="column"===e?"frozenColumn":"frozenRow";const o=this._createHeaderElement(n,t,s,!1);if(this.m_root.insertBefore(o,this.m_status),"column"===e?this.m_colHeaderFrozen=o:this.m_rowHeaderFrozen=o,"column"===e&&this.m_colEndHeader||"row"===e&&this.m_rowEndHeader){const t=this._createHeaderElement(n,i,s,!0);this.m_root.insertBefore(t,this.m_status),"column"===e?this.m_colEndHeaderFrozen=t:this.m_rowEndHeaderFrozen=t}},A.prototype._handleUnFreeze=function(e,t){if("column"===e&&-1!==this.m_frozenColIndex){if(this._removeCellsFromFrozenColumnContainer(-1),this.m_root.removeChild(this.m_databodyFrozenCol),this.m_databodyFrozenCol=null,this._hasFrozenRows()&&(this.m_root.removeChild(this.m_databodyFrozenCorner),this.m_databodyFrozenCorner=null),this.m_colHeaderFrozen&&(this.m_root.removeChild(this.m_colHeaderFrozen),this.m_colHeaderFrozen=null),this.m_colEndHeaderFrozen&&(this.m_root.removeChild(this.m_colEndHeaderFrozen),this.m_colEndHeaderFrozen=null),this.deleteAndApplyHiddenIndicators(),t){let e={event:t,ui:{frozenCount:0}};this.fireEvent("columnFreeze",e)}}else if("row"===e&&-1!==this.m_frozenRowIndex&&(this._removeCellsFromFrozenRowContainer(-1),this.m_root.removeChild(this.m_databodyFrozenRow),this.m_databodyFrozenRow=null,this._hasFrozenColumns()&&(this.m_root.removeChild(this.m_databodyFrozenCorner),this.m_databodyFrozenCorner=null),this.m_rowHeaderFrozen&&(this.m_root.removeChild(this.m_rowHeaderFrozen),this.m_rowHeaderFrozen=null),this.m_rowEndHeaderFrozen&&(this.m_root.removeChild(this.m_rowEndHeaderFrozen),this.m_rowEndHeaderFrozen=null),this.deleteAndApplyHiddenIndicators(),t)){let e={event:t,ui:{frozenCount:0}};this.fireEvent("rowFreeze",e)}},A.prototype._hasFrozenRows=function(){let e=!1;return null!==this.m_frozenRowIndex&&-1!==this.m_frozenRowIndex&&(e=!0),e},A.prototype._hasFrozenColumns=function(){let e=!1;return null!==this.m_frozenColIndex&&-1!==this.m_frozenColIndex&&(e=!0),e},A.prototype.handleFreezeIndicatorDragStart=function(e){const t=e.target,i=this.m_utils.containsCSSClassName(t,this.getMappedStyle("rowFrozenIndicator"))?"row":"column";let s;this.m_dragFrozenIndicator=!0,this.m_freezeIndicatorAxis=i,this._setFreezeIndicatorDragImage(e,i),s="row"===i?[this.m_rowHeaderFrozenTarget,this.m_databodyRowFrozenTarget,this.m_rowEndHeaderFrozenTarget]:[this.m_colHeaderFrozenTarget,this.m_databodyColFrozenTarget,this.m_colEndHeaderFrozenTarget],s.forEach(e=>{e&&e.classList.add(this.getMappedStyle("disabledElement"))})},A.prototype._setFreezeIndicatorDragImage=function(e,t){const i=this.getResources().isRTLMode()?"right":"left";let s=document.getElementById("dndContainer");s||(s=document.createElement("div"),s.setAttribute("id","dndContainer"),s.setAttribute("class","dndContainer"));let n=0,o=0,r=0,l=0,a=Math.max(0,e.offsetX),h=Math.max(0,e.offsetY);if("row"===t){if(this.m_rowHeaderFrozenTarget){let e=this.m_rowHeaderFrozenTarget.cloneNode(!0);e.style.top=`${n}px`,e.style[i]=`${o}px`,o+=this.getElementWidth(this.m_rowHeaderFrozenTarget),s.appendChild(e)}e.target===this.m_databodyRowFrozenTarget&&(a+=o);let t=this.m_databodyRowFrozenTarget.cloneNode(!0);if(t.style.top=`${n}px`,t.style[i]=`${o}px`,s.appendChild(t),o+=this.getElementWidth(this.m_databodyRowFrozenTarget),this.m_rowEndHeaderFrozenTarget){e.target===this.m_rowEndHeaderFrozenTarget&&(a+=o);let t=this.m_rowEndHeaderFrozenTarget.cloneNode(!0);t.style.top=`${n}px`,t.style[i]=`${o}px`,o+=this.getElementWidth(this.m_rowEndHeaderFrozenTarget),s.appendChild(t)}l=this.getElementHeight(this.m_databodyRowFrozenTarget),r=o}else{if(this.m_colHeaderFrozenTarget){let e=this.m_colHeaderFrozenTarget.cloneNode(!0);e.style.top=`${n}px`,e.style[i]=`${o}px`,n+=this.getElementHeight(this.m_colHeaderFrozenTarget),s.appendChild(e)}e.target===this.m_databodyColFrozenTarget&&(h+=n);let t=this.m_databodyColFrozenTarget.cloneNode(!0);if(t.style.top=`${n}px`,t.style[i]=`${o}px`,s.appendChild(t),n+=this.getElementHeight(this.m_databodyColFrozenTarget),this.m_colEndHeaderFrozenTarget){e.target===this.m_colEndHeaderFrozenTarget&&(h+=n);let t=this.m_colEndHeaderFrozenTarget.cloneNode(!0);t.style.top=`${n}px`,t.style[i]=`${o}px`,n+=this.getElementHeight(this.m_colEndHeaderFrozenTarget),s.appendChild(t)}r=this.getElementWidth(this.m_databodyColFrozenTarget),l=n}s.style.width=`${r}px`,s.style.height=`${l}px`,document.body.appendChild(s),e.dataTransfer.setDragImage(s,a,h)},A.prototype.handleFreezeIndicatorDragEnd=function(e){e.target.classList.remove(this.getMappedStyle("dragging")),this._clearFreezeIndicatorDrag(this.m_freezeIndicatorAxis)},A.prototype.handleFreezeIndicatorDragOver=function(e,t,i){this._removeDropTargetLine(i),this._removeDropTargetClass();let s,n=-1===t?0:t,o=this.getResources().isRTLMode()?"right":"left",r=this._getHeaderByIndex(n,i,"row"===i?this.m_rowHeaderLevelCount:this.m_columnHeaderLevelCount);if(r)s=r;else{let e={row:0,column:0};e[i]=n,s=this._getCellByIndex(e)}let l=this.getElementDir(s,"row"===i?"top":o);"row"===i?(l+=-1===t?0:this.getElementHeight(s),this._hasFrozenRows()&&t>this.m_frozenRowIndex&&(l+=this.getElementHeight(this.m_databodyFrozenRow)),this._addDropTargetLine(i,l,o,0,n)):(l+=-1===t?0:this.getElementWidth(s),this._hasFrozenColumns()&&t>this.m_frozenColIndex&&(l+=this.getElementWidth(this.m_databodyFrozenCol)),this._addDropTargetLine(i,0,o,l,n)),e.preventDefault()},A.prototype.handleFreezeIndicatorDrop=function(e,t,i){if(this._clearFreezeIndicatorDrag(t),this._updateFrozenSection(e,t),"row"===t){const e={event:i,ui:{frozenCount:this.m_frozenRowIndex+1}};this.fireEvent("rowFreeze",e)}else{const e={event:i,ui:{frozenCount:this.m_frozenColIndex+1}};this.fireEvent("columnFreeze",e)}},A.prototype._clearFreezeIndicatorDrag=function(e){let t;this._destroyDragImage(),this._removeDropTargetLine(e),this._removeDropTargetClass(),this.m_dragFrozenIndicator=!1,this.m_freezeIndicatorAxis=null,t="row"===e?[this.m_rowHeaderFrozenTarget,this.m_databodyRowFrozenTarget,this.m_rowEndHeaderFrozenTarget]:[this.m_colHeaderFrozenTarget,this.m_databodyColFrozenTarget,this.m_colEndHeaderFrozenTarget],t.forEach(e=>{e&&e.classList.remove(this.getMappedStyle("disabledElement"))})},A.prototype.handleFreezeIndicatorMouseDown=function(e){null==this.m_active&&this.m_root.focus();e.target.classList.add(this.getMappedStyle("dragging"))},A.prototype.handleFreezeIndicatorMouseUpOrOut=function(e){e.target.classList.remove(this.getMappedStyle("dragging"))},A.prototype._createFrozenIndicatorElement=function(e){const t=document.createElement("div");return t.id=e,this.m_utils.isTouchDevice()||(t.setAttribute("draggable",!0),t.classList.add(this.getMappedStyle("draggableItem")),this._addFreezeVisualIndicatorEventListener(t)),t},A.prototype.showStatusText=function(e){const t=this;"block"===this.m_status.style.display||this.m_showStatusTimeout||(this.m_showStatusTimeout=setTimeout(function(){const i=t.getResources().getTranslatedText("msgFetchingData");let s,n;if(t.m_status.setAttribute("aria-label",i),t.m_status.style.display="block",e){const e=document.createElement("div");e.className=t.getMappedStyle("loadingicon"),t.m_status.appendChild(e),s=t.getWidth()/2-t.m_status.offsetWidth/2,n=t.getHeight()/2-t.m_status.offsetHeight/2}else{s=0,n=0;const e=document.createDocumentFragment();t.buildSkeletonGrid(e),t.m_status.appendChild(e)}t.getResources().isRTLMode()?t.m_status.style.right=s+"px":t.m_status.style.left=s+"px",t.m_status.style.top=n+"px",t.m_showStatusTimeout=null},this.getShowStatusDelay()))},A.prototype.buildSkeletonGrid=function(e){const t=this.getWidth(),i=this.getHeight(),s=this.getDefaultColumnWidth(),n=this.getDefaultRowHeight(),o=Math.max(1,Math.ceil(i/n)),r=Math.max(1,Math.ceil(t/s));let l=0;for(let t=0;t<o;t++){let i=0;for(let a=0;a<r;a++){const h=this.createSkeletonCell(s,n,i,l);a===r-1&&h.classList.add(this.getMappedStyle("borderVerticalNone")),t===o-1&&h.classList.add(this.getMappedStyle("borderHorizontalNone")),e.appendChild(h),i+=s}l+=n}},A.prototype.isSkeletonSupport=function(){return"skeleton"===this.getResources().getDefaultOption("loadIndicator")},A.prototype.getShowStatusDelay=function(){const e=p.getCSSTimeUnitAsMillis(this.getResources().getDefaultOption("showIndicatorDelay"));return isNaN(e)?0:e},A.prototype.hideStatusText=function(){this.m_showStatusTimeout&&(clearTimeout(this.m_showStatusTimeout),this.m_showStatusTimeout=null),this.m_status.style.display="none",this.m_utils.empty(this.m_status),this.isSkeletonSupport()&&this._removeAllSkeletons()},A.prototype._removeAllSkeletons=function(){this._resetSkeletonProperties();const e=this._getAllSkeletonContainers(this.m_root);if(e.length>0)for(let t=0;t<e.length;t++)this._remove(e[t])},A.prototype.addSkeletonCells=function(e,t,i,s,n,o,r,l,a,h){const d=this.getDefaultColumnWidth(),m=this.getDefaultRowHeight(),c=document.createDocumentFragment(),u=document.createDocumentFragment(),_=document.createDocumentFragment(),p=[],g=[];let f,C,y=o,E=r;const v=this.m_databody.firstChild;let w,b;if(this._hasFrozenRows()&&(w=this.m_databodyFrozenRow.firstChild),this._hasFrozenColumns()&&(b=this.m_databodyFrozenCol.firstChild),!this._databodyEmptyState()){for(let o=0;o<t;o++){E=r,f=a?s+o:s+(t-1-o),"column"===e&&this._hasFrozenRows()&&f===this.m_frozenRowIndex+1&&(y-=m*(this.m_frozenRowIndex+1));for(let s=0;s<i;s++){if(C=h?n+s:n+(i-1-s),null==g[o]||null==p[s]){const e=this._getCellOrHeaderByIndex(f,"row"),t=this._getCellOrHeaderByIndex(C,"column");if(e){const t=e[this.getResources().getMappedAttribute("context")];t&&(g[o]=this._getCellDimension(null,f,t.keys?t.keys.row:t.key,"row","height"))}if(t){const e=t[this.getResources().getMappedAttribute("context")];e&&(p[s]=this._getCellDimension(null,C,e.keys?e.keys.column:e.key,"column","width"))}null==g[o]&&(g[o]=m),null==p[s]&&(p[s]=d)}"row"===e&&this._hasFrozenColumns()&&C===this.m_frozenColIndex+1&&(E-=d*(this.m_frozenColIndex+1));const r=this.createIndex(f,C);if(l||!this._skeletonSetHas(r)){const e=this.createSkeletonCell(p[s],g[o],h?E:E-p[s],a?y:y-g[o]);this._addIndexToSkeletonSet(r),s===i-1&&this.m_utils.addCSSClassName(e,this.getMappedStyle("borderVerticalNone")),o===t-1&&this.m_utils.addCSSClassName(e,this.getMappedStyle("borderHorizontalNone")),this._hasFrozenColumns()&&C<this.m_frozenColIndex+1?_.appendChild(e):this._hasFrozenRows()&&f<this.m_frozenRowIndex+1?u.appendChild(e):c.appendChild(e)}E=h?E+p[s]:E-p[s]}y=a?y+g[o]:y-g[o]}this.m_skeletonRowStart=s,this.m_skeletonRowEnd=s+t-1,this.m_skeletonColStart=n,this.m_skeletonColEnd=n+i-1,this.m_skeletonColStartPixel=h?r:E,this.m_skeletonColEndPixel=h?E:r,this.m_skeletonRowStartPixel=a?o:y,this.m_skeletonRowEndPixel=a?y:o}if(c.childElementCount>0){let e=this._getAllSkeletonContainers(v);e=0===e.length?this._createSkeletonContainer():e[0],e.appendChild(c),v.appendChild(e)}if(_.childElementCount>0){let e=this._getAllSkeletonContainers(b);e=0===e.length?this._createSkeletonContainer():e[0],e.appendChild(_),b.appendChild(e)}if(u.childElementCount>0){let e=this._getAllSkeletonContainers(w);e=0===e.length?this._createSkeletonContainer():e[0],e.appendChild(u),w.appendChild(e)}if(!l)if("row"===e){if(this.m_hasRowHeader&&this.createHeaderSkeletonCells(this.m_rowHeader,"row",t,this.m_rowHeaderLevelWidths,0,o,a),this.m_hasRowEndHeader&&this.createHeaderSkeletonCells(this.m_rowEndHeader,"row",t,this.m_rowEndHeaderLevelWidths,0,o,a),this._databodyEmptyState()){const e=this.m_databody.firstChild;this.m_skeletonRowStart=s,this.m_skeletonRowEnd=s+t-1,a?(this.m_skeletonRowStartPixel=o,this.m_skeletonRowEndPixel=o+t*this.getDefaultRowHeight()):(this.m_skeletonRowStartPixel=o-t*this.getDefaultRowHeight(),this.m_skeletonRowEndPixel=o),this._isHighWatermarkScrolling()&&(this._setScrollerDimension(e,this.m_skeletonRowEndPixel,this._getMaxRightPixel()),this.m_scrollHeight=this.getElementHeight(e)-Math.min(this.getElementHeight(e),this.getElementHeight(this.m_databody)-(this.m_hasHorizontalScroller?this.m_utils.getScrollbarSize():0)))}}else if("column"===e&&(this.m_hasColHeader&&this.createHeaderSkeletonCells(this.m_colHeader,"column",i,this.m_columnHeaderLevelHeights,r,0,h),this.m_hasColEndHeader&&this.createHeaderSkeletonCells(this.m_colEndHeader,"column",i,this.m_columnEndHeaderLevelHeights,r,0,h),this._databodyEmptyState())){const e=this.m_databody.firstChild;this.m_skeletonColStart=n,this.m_skeletonColEnd=n+i-1,h?(this.m_skeletonColStartPixel=r,this.m_skeletonColEndPixel=r+i*this.getDefaultColumnWidth()):(this.m_skeletonColStartPixel=r-i*this.getDefaultColumnWidth(),this.m_skeletonColEndPixel=r),this._isHighWatermarkScrolling()&&(this._setScrollerDimension(e,this._getMaxBottomPixel(),this.m_skeletonColEndPixel),this.m_scrollWidth=this.getElementWidth(e)-Math.min(this.getElementWidth(e),this.getElementWidth(this.m_databody)-(this.m_hasVerticalScroller?this.m_utils.getScrollbarSize():0)))}},A.prototype.createSkeletonCell=function(e,t,i,s){const n=this.getResources().isRTLMode()?"right":"left",o=document.createElement("div");o.className=this.getMappedStyle("skeletonCell");const r=document.createElement("div");return r.classList.add(this.getMappedStyle("skeleton"),this.getMappedStyle("skeletonAnimation")),o.appendChild(r),this.setElementHeight(o,t),this.setElementWidth(o,e),this.setElementDir(o,s,"top"),this.setElementDir(o,i,n),o},A.prototype.createHeaderSkeletonCells=function(e,t,i,s,n,o,r){let l=i,a=s.length,h=this.getDefaultColumnWidth(),d=this.getDefaultRowHeight();"column"===t&&(l=s.length,a=i);const m=document.createDocumentFragment();let c=o;for(let e=0;e<l;e++){let i=n;for(let n=0;n<a;n++){let o;"row"===t?h=s[n]:d=s[e],r?(o=this.createSkeletonCell(h,d,i,c),i+=h):"row"===t?(o=this.createSkeletonCell(h,d,i,c-d),i+=h):(o=this.createSkeletonCell(h,d,i-h,c),i-=h),m.appendChild(o)}r||"column"===t?c+=d:c-=d}if(m.childElementCount>0){let t=this._getAllSkeletonContainers(e);t=0===t.length?this._createSkeletonContainer():t[0],t.appendChild(m),e.firstChild.appendChild(t)}},A.prototype.loadSkeletons=function(e,t,i,s,n,o){let r,l,a,h,d,m=this.getFetchSize("row"),c=this.getFetchSize("column"),u=!0,_=!0;const p=this._getViewportLeft(),g=this._getViewportRight(),f=this._getViewportTop()<0?0:this._getViewportTop(),C=this._getViewportBottom(),y=null!=this.m_skeletonRowStart?this.m_skeletonRowStart:this._getMaxTop(),E=null!=this.m_skeletonRowStartPixel?this.m_skeletonRowStartPixel:this._getMaxTopPixel(),v=null!=this.m_skeletonRowEnd?this.m_skeletonRowEnd:this._getMaxBottom(),w=null!=this.m_skeletonRowEndPixel?this.m_skeletonRowEndPixel:this._getMaxBottomPixel(),b=null!=this.m_skeletonColStart?this.m_skeletonColStart:this._getMaxLeft(),H=null!=this.m_skeletonColStartPixel?this.m_skeletonColStartPixel:this._getMaxLeftPixel(),x=null!=this.m_skeletonColEnd?this.m_skeletonColEnd:this._getMaxRight(),S=null!=this.m_skeletonColEndPixel?this.m_skeletonColEndPixel:this._getMaxRightPixel();if(this.m_prevScrollLeft>t&&H>p)r=i,h=n,m=Math.max(v,this._getMaxBottom(),0)-Math.min(y,r)+1,l=Math.min(b-c,s),a=Math.min(H,o+c*this.getDefaultColumnWidth()),_=!1,d="column";else if(!(this.m_prevScrollLeft<t&&S<=g)||this.m_stopColumnHeaderFetch&&this.m_stopColumnEndHeaderFetch&&this.m_stopColumnFetch)if(this.m_prevScrollTop>e&&E>f)l=s,a=o,c=Math.max(x,this._getMaxRight(),0)-Math.min(b,l)+1,r=Math.min(y-m,i),h=Math.min(E,n+m*this.getDefaultRowHeight()),u=!1,d="row";else{if(!(this.m_prevScrollTop<e&&w<=C)||this.m_stopRowHeaderFetch&&this.m_stopRowEndHeaderFetch&&this.m_stopRowFetch)return;this._isHighWatermarkScrolling()?(r=this._getMaxBottom()+1,l=this._getMaxLeft(),u=i>=this._getMaxTop(),h=u?this._getMaxBottomPixel():this._getMaxTopPixel(),a=this._getMaxLeftPixel(),m=A.SKELETON_DEFAULT_COUNT,c=this._getMaxRight()-this._getMaxLeft()+1):(l=s,a=o,c=Math.max(x,this._getMaxRight(),0)-Math.min(b,l)+1,r=Math.max(v+1,i),h=Math.max(w,n),m=this.getFetchCount("row",r)),d="row"}else this._isHighWatermarkScrolling()?(m=this._getMaxBottom()-this._getMaxTop()+1,c=A.SKELETON_DEFAULT_COUNT,r=this._getMaxTop(),l=this._getMaxRight()+1,_=l>=this._getMaxLeft(),h=this._getMaxTopPixel(),a=_?this._getMaxRightPixel():this._getMaxLeftPixel()):(r=i,h=n,m=Math.max(v,this._getMaxBottom(),0)-Math.min(y,r)+1,l=Math.max(x+1,s),a=Math.max(S,o),c=this.getFetchCount("column",l)),d="column";(!this._isHighWatermarkScrolling()||null==this.m_skeletonRowStart&&null==this.m_skeletonColStart)&&this.addSkeletonCells(d,m,c,r,l,h,a,!1,u,_)},A.prototype.loadSkeletonsOnHeaderLoad=function(e,t,i,s){let n=i&&i.getCount()||s&&s.getCount();if(0===n||!this.isSkeletonSupport())return;let o=n,r=this.isLongScroll()?this.getFetchSize("column"):this.m_endCol-this.m_startCol+1,l=t,a=this.m_startCol,h=l>=this.m_startRow,d=!0,m=!this.isLongScroll()&&h?this.m_endRowPixel:this.m_startRowPixel,c=this.m_startColPixel;"column"===e&&(o=this.isLongScroll()?this.getFetchSize("row"):this.m_endRow-this.m_startRow+1,r=n,l=this.m_startRow,a=t,h=!0,d=a>=this.m_startCol,m=this.m_startRowPixel,c=!this.isLongScroll()&&d?this.m_endColPixel:this.m_startColPixel),this.isLongScroll()&&(h=!0,d=!0),this.isHeaderFetchComplete()&&!this.m_headerInvalid&&(this.hideStatusText(),this.addSkeletonCells(e,o,r,l,a,m,c,!0,h,d))},A.prototype._addIndexToSkeletonSet=function(e){const t="r"+e.row+"c"+e.column;this.m_skeletonSet.add(t)},A.prototype._skeletonSetHas=function(e){const t="r"+e.row+"c"+e.column;return this.m_skeletonSet.has(t)},A.prototype._getAllNonSkeletonContainerNodes=function(e){return e.querySelectorAll(`:scope > div:not(.${this.getMappedStyle("skeletonContainer")})`)},A.prototype._removeAllNonSkeletonContainerNodes=function(e){this._getAllNonSkeletonContainerNodes(e).forEach(e=>{this._remove(e)})},A.prototype._getAllSkeletonContainers=function(e){return e.querySelectorAll(`.${this.getMappedStyle("skeletonContainer")}`)},A.prototype._createSkeletonContainer=function(){const e=document.createElement("div");return e.classList.add(this.getMappedStyle("skeletonContainer")),e},A.prototype._scrollSkeletonHeadersIntoViewport=function(e,t,i,s){const n={index:s?e+A.SKELETON_DEFAULT_COUNT:Math.max(0,e-A.SKELETON_DEFAULT_COUNT),axis:t,level:i};this.scrollToHeader(n),n.index=s?e+1:e-1,this.m_scrollHeaderAfterFetch=n},A.prototype._scrollSkeletonCellsIntoViewport=function(e,t,i,s){let n=e,o=t;"column"===i?(o=s?t+A.SKELETON_DEFAULT_COUNT:Math.max(0,t-A.SKELETON_DEFAULT_COUNT),t=s?t+1:t-1):(n=s?e+A.SKELETON_DEFAULT_COUNT:Math.max(0,e-A.SKELETON_DEFAULT_COUNT),e=s?e+1:e-1),this.scrollToIndex(this.createIndex(n,o),!1),this.m_scrollIndexAfterFetch=this.createIndex(e,t)},A.prototype._resetSkeletonProperties=function(){this.m_skeletonRowStart=null,this.m_skeletonRowEnd=null,this.m_skeletonColStart=null,this.m_skeletonColEnd=null,this.m_skeletonColStartPixel=null,this.m_skeletonColEndPixel=null,this.m_skeletonRowStartPixel=null,this.m_skeletonRowEndPixel=null,this.m_skeletonSet=new Set},A.prototype.handleCornerDragStart=function(e){let t=e.target,i=this.findLabel(t);const s=this.getResources().isRTLMode()?"right":"left",n=this.getResources().getMappedAttribute("context");if(i&&this.m_options._isDragEnabledOnLabel(i[n].axis)){this.m_pivotInProgress=!0,this.m_utils.addCSSClassName(i,this.getMappedStyle("dragging"));const t=i[n].axis,o=i[n].level;this.m_dragLabel=i;let r=0,l=0,a="column"===t||"columnEnd"===t?"width":"height",h=[];h.push(i),h=this._getDropHeaderTargets(t,o,h),h=this._getHeadersInView(h,t);let d=h.length;"column"===t||"columnEnd"===t?(r=this._computeContainerDimension(h,a),l=this.getElementHeight(h[1])):"row"!==t&&"rowEnd"!==t||(l=this._computeContainerDimension(h,a),r=this.getElementWidth(h[1])),this._headersDragged=h;let m=this._populateContainer(h,t,s,d,r,l),c=Math.max(0,e.offsetX),u=Math.max(0,e.offsetY);e.dataTransfer.setDragImage(m,c,u);let _=this.m_options.options.dnd.drag,p="row"===t||"rowEnd"===t?_.rowLabels.dataTypes:_.columnLabels.dataTypes;this._setDragLabelData(e,p);for(let e=0;e<h.length;e++)this._highlightElement(h[e],["dragSourceOpaque","selected"]);let g={level:o,axis:t};this._invokeDndCallback("drag",`${t}Labels`,"dragStart",e,g)}},A.prototype._getHeadersInView=function(e,t){let i="column"===t||"columnEnd"===t?"width":"height",s=this.getElementDir(this.m_databody,i);("column"===t||"columnEnd"===t)&&null!==this.m_frozenColIndex&&this.m_frozenColIndex>=0?s+=this.getElementDir(this.m_databodyFrozenCol,i):("row"===t||"rowEnd"===t)&&null!==this.m_frozenRowIndex&&this.m_frozenRowIndex>=0&&(s+=this.getElementDir(this.m_databodyFrozenRow,i));let n=0,o=0;for(let t=0;t<e.length;t++)if(n+=this.getElementDir(e[t],i),n>s){o=t;break}return o>0&&(e=e.slice(0,o+1)),e},A.prototype._highlightHeaderRange=function(e,t,i,s){if(0===i)"column"===t||"columnEnd"===t?s.push("topFloodfill"):s.push("startFloodfill");else{let e=[];const n=this.m_headerLabels[t][i-1];e.push(n),e=this._getDropHeaderTargets(t,i-1,e),e=this._getHeadersInView(e,t);for(let t=0;t<e.length;t++)this._highlightElement(e[t],s)}let n=[],o=[];"column"===t||"columnEnd"===t?(n.push("startFloodfill"),o.push("endFloodfill")):(n.push("topFloodfill"),o.push("bottomFloodfill")),this._highlightElement(e[0],n);for(let t=0;t<e.length;t++)this._highlightElement(e[t],s),t===e.length-1&&this._highlightElement(e[t],o)},A.prototype._populateContainer=function(e,t,i,s,n,o){let r=document.getElementById("dndContainer");r||(r=document.createElement("div"),r.setAttribute("id","dndContainer"),r.setAttribute("class","dndContainer"));let l=[this.getMappedStyle("focus"),this.getMappedStyle("hover"),this.getMappedStyle("active"),this.getMappedStyle("topSelected"),this.getMappedStyle("startSelected"),this.getMappedStyle("bottomSelected"),this.getMappedStyle("endSelected"),this.getMappedStyle("selected")],a=0,h=0,d=s;h=0,a=0;for(let s=0;s<e.length;s++){let n=e[s],o=n.cloneNode(!0);o.classList.remove(...l),o.setAttribute("draggable",!1),o.style.top=`${a}px`,o.style[i]=`${h}px`,"column"===t||"columnEnd"===t?(s%d==0?h=0+n.offsetWidth:h+=n.offsetWidth,s%d==d-1&&(a+=n.offsetHeight,s===e.length-1?a=0:h=0)):(s%d==0?a=0+n.offsetHeight:a+=n.offsetHeight,s%d==d-1&&(h+=n.offsetWidth,s===e.length-1?h=0:a=0)),r.appendChild(o),n.classList.add("drag-source-opaque")}return r.style.width=`${n}px`,r.style.height=`${o}px`,"row"===t||"rowEnd"===t?r.style.height=`${o+0}px`:r.style.width=`${n+0}px`,this.m_utils.isTouchDevice()?(this.m_dragImageAttached=!1,this.m_dndContainer=r):document.body.appendChild(r),r},A.prototype.handleCornerDragEnd=function(){const e=this.getResources().getMappedAttribute("context"),t=this.m_dragLabel[e].axis;this.m_utils.removeCSSClassName(this.m_dragLabel,this.getMappedStyle("dragging")),this._unhighlightElementsByClassName(this._headersDragged,["draggableItem","dragSourceOpaque","selected"]),this._destroyDragImage(),this._resetPivotDragInternals(),this._removePivotDropTargetLine(),this._enableChildElements(),this._removeDragStyle(t),this.m_dragLabel=null,this.m_pivotInProgress=!1},A.prototype.handleCornerDragOver=function(e){const t=this.getResources().getMappedAttribute("context"),i=this.getResources().isRTLMode()?"right":"left";let s,n,o,r,l,a=this.findLabel(e.target);if(a){if(s=a[t].axis,n=a[t].level,!this._matchDragDataType(e,`${a[t].axis}Labels`))return void this._removePivotDropTargetLine();e.preventDefault(),l=this._getLabelRelativePosition(e,s,a),o=this.getElementDir(a,"top")+("after"===l?this.getElementHeight(a):0),"columnEnd"===s&&(o+=this.getElementDir(this.m_rowHeaderScrollbarSpacer,"top")),r=this.getElementDir(a,i)+("after"===l?this.getElementWidth(a):0),"rowEnd"===s&&(r+=this.getElementDir(this.m_columnHeaderScrollbarSpacer,i))}else{const e=this.m_dragLabel;if(!e)return;const h=e[t].axis;l="after","column"===h&&-1===this.m_endRowHeader?(a=this.m_headerLabels[h][this.m_columnHeaderLevelCount-1],s="row",n=a[t].level,o=this.getElementDir(a,"top")+this.getElementHeight(a),r=this.getElementDir(a,i)+this.getElementWidth(a)):"row"===h&&-1===this.m_endColHeader&&(a=this.m_headerLabels[h][this.m_rowHeaderLevelCount-1],s="column",l="before",n=a[t].level,o=0,r=this.getElementDir(a,i))}if(a){this._addPivotDropTargetLine(s,o,i,r,l,a);let t={level:n,axis:s,position:l};this._invokeDropCallback(`${s}Labels`,"dragOver",e,t)}},A.prototype._addPivotDropTargetLine=function(e,t,i,s,n,o){let r="column"===e||"columnEnd"===e?"rowDropTargetLine":"colDropTargetLine";const l=o[this.getResources().getMappedAttribute("context")].level;this._removePivotDropTargetLine(),this.m_pivotDropTarget=document.createElement("div"),this.m_pivotDropHeaderTarget=document.createElement("div"),this._setAttribute(this.m_pivotDropTarget,"level",l),this._setAttribute(this.m_pivotDropTarget,"axis",e);let a=o,h=this.m_colHeader;"columnEnd"===e?h=this.m_colEndHeader:"row"===e?h=this.m_rowHeader:"rowEnd"===e&&(h=this.m_rowEndHeader);const d=function(t,i,s,o,r,a){if(("column"===e||"row"===e)&&"column"===e&&this._isHeaderLabelCollision()&&l===this.m_columnHeaderLevelCount-1&&"after"===n){let i=this._getHeaderByIndex(0,e,l);t=this.getElementDir(i,"top")+this.getElementHeight(i)}let h="row"===e||"rowEnd"===e?this._getCornerDimensions("height"):this._getCornerDimensions("width");return"column"===e||"columnEnd"===e?(s=h,null!==this.m_frozenColIndex&&this.m_frozenColIndex>=0&&(r+=this.getElementDir(this.m_databodyFrozenCol,"width"))):(t=h,null!==this.m_frozenRowIndex&&this.m_frozenRowIndex>=0&&(r+=this.getElementDir(this.m_databodyFrozenRow,"height"))),[t,i,s,o,r,a]}.bind(this);this._addPivotVisualIndicator(e,t,i,s,r,this.m_pivotDropTarget,this.m_pivotDropHeaderTarget,h,a,d),this._addPivotVisualIndicatorEventListener()},A.prototype._addPivotVisualIndicator=function(e,t,i,s,n,o,r,l,a,h){let d="width",m="width";"row"!==e&&"rowEnd"!==e||(d="height",m="height");let[c,u,_,p,g,f]=this._calculatePivotVisualIndicatorPosition(l,a,t,s,i,e);h&&"function"==typeof h&&([c,u,_,p,g,f]=h(c,u,_,p,g,f)),this._setVisualIndicatorStyle(o,n,c,i,_,g,d),this._setVisualIndicatorStyle(r,n,u,i,p,f,m),this.m_root.appendChild(o),this.m_root.appendChild(r)},A.prototype._calculatePivotVisualIndicatorPosition=function(e,t,i,s,n,o){let r=i,l=s,a="row"===o||"rowEnd"===o?this.getElementDir(t,"top"):i,h="row"===o||"rowEnd"===o?s:this.getElementDir(t,n),d=0,m=0,c="column"===o||"columnEnd"===o?this.getElementWidth.bind(this):this.getElementHeight.bind(this);return d=c(e),m=c(t),[r,a,l,h,d,m]},A.prototype._getLabelRelativePosition=function(e,t){let i,s=e.target,n=this.getResources().isRTLMode()?"right":"left",o=s.getBoundingClientRect(),r="before",l="width";return"row"===t||"rowEnd"===t?i=Math.abs(e.clientX-o[n]):(i=Math.abs(e.clientY-o.top),l="height"),i>.4*o[l]&&(r="after"),r},A.prototype.handleCornerDrop=function(e){let t=this.findLabel(e.target);const i=this.getResources().getMappedAttribute("context");let s,n,o;if(this._destroyDragImage(),this._removePivotDropTargetLine(),this._removeDropTargetClass(),this._unhighlightDragSource(),this._enableChildElements(),this.m_pivotInProgress=!1,this.m_utils.removeCSSClassName(this.m_dragLabel,this.getMappedStyle("dragging")),t){if(!this._matchDragDataType(e,`${t[i].axis}Labels`))return;s=t[i].level,n=t[i].axis,o=this._getLabelRelativePosition(e,n,t)}else{const e=this.m_dragLabel[i].axis;o="after","column"===e&&-1===this.m_endRowHeader?(t=this.m_headerLabels[e][this.m_columnHeaderLevelCount-1],n="row"):"row"===e&&-1===this.m_endColHeader&&(o="before",t=this.m_headerLabels[e][this.m_rowHeaderLevelCount-1],n="column"),t&&(s=t[i].level)}if(t){let t={level:s,axis:n,position:o};this._invokeDropCallback(`${n}Labels`,"drop",e,t)}},A.prototype.handleCornerDragEnter=function(e){e.preventDefault()},A.prototype._removePivotDropTargetLine=function(){this._remove(this.m_pivotDropTarget),this._remove(this.m_pivotDropHeaderTarget),this.m_pivotDropTarget=null,this.m_pivotDropHeaderTarget=null},A.prototype._addPivotVisualIndicatorEventListener=function(){this.m_pivotDropTarget.addEventListener("dragover",this.handlePivotDropTargetDragOver.bind(this),!1),this.m_pivotDropHeaderTarget.addEventListener("dragover",this.handlePivotDropTargetDragOver.bind(this),!1),this.m_pivotDropTarget.addEventListener("dragEnter",this.handlePivotDropTargetDragEnter,!1),this.m_pivotDropHeaderTarget.addEventListener("dragEnter",this.handlePivotDropTargetDragEnter,!1),this.m_pivotDropTarget.addEventListener("drop",this.handlePivotDropTargetDrop.bind(this),!1),this.m_pivotDropHeaderTarget.addEventListener("drop",this.handlePivotDropTargetDrop.bind(this),!1)},A.prototype._removePivotVisualIndicatorEventListeners=function(){this.m_pivotDropTarget&&(this.m_pivotDropTarget.removeEventListener("dragover",this.handlePivotDropTargetDragOver,!1),this.m_pivotDropTarget.removeEventListener("drop",this.handlePivotDropTargetDrop,!1),this.m_pivotDropTarget.removeEventListener("dragEnter",this.handlePivotDropTargetDragEnter,!1)),this.m_pivotDropHeaderTarget&&(this.m_pivotDropHeaderTarget.removeEventListener("dragover",this.handlePivotDropTargetDragOver,!1),this.m_pivotDropHeaderTarget.removeEventListener("drop",this.handlePivotDropTargetDrop,!1),this.m_pivotDropHeaderTarget.removeEventListener("dragEnter",this.handlePivotDropTargetDragEnter,!1))},A.prototype._resetPivotDragInternals=function(){this._headersDragged=[],this.m_dragLabel=null},A.prototype._getDropHeaderTargets=function(e,t,i){const s=this.getResources().getMappedAttribute("context");let n=this.m_startColHeader,o=this.m_endColHeader;"columnEnd"===e?(n=this.m_startColEndHeader,o=this.m_endColEndHeader):"row"===e?(n=this.m_startRowHeader,o=this.m_endRowHeader):"rowEnd"===e&&(n=this.m_startRowEndHeader,o=this.m_endRowEndHeader);for(let r=n;r<=o;){let n=this._getHeaderByIndex(r,e,t);if(!n)break;i.push(n),r+=n[s].extent}return i},A.prototype.handlePivotDropTargetDragOver=function(e){e.preventDefault();let t=this._getAttribute(this.m_pivotDropTarget,"axis"),i={level:this._getAttribute(this.m_pivotDropTarget,"level"),axis:t,position:"after"};this._invokeDropCallback(`${t}Labels`,"dragOver",e,i)},A.prototype.handlePivotDropTargetDrop=function(e){e.preventDefault();let t=this._getAttribute(this.m_pivotDropTarget,"axis"),i=this._getAttribute(this.m_pivotDropTarget,"level");this._destroyDragImage(),this._removePivotDropTargetLine(),this._removeDropTargetClass(),this._unhighlightDragSource(),this._enableChildElements();let s={level:i,axis:t,position:"after"};this._invokeDropCallback(`${t}Labels`,"drop",e,s)},A.prototype.handlePivotDropTargetDragEnter=function(e){e.preventDefault()},A.prototype._handlePivotDragOverOnHeader=function(e){let t=this.findHeader(e.target);if(t){const i=this.getResources().isRTLMode()?"right":"left",s=this.getResources().getMappedAttribute("context"),n=t[s];let o,r,l,a,h,d=this.m_headerLabels[n.axis][n.level];if(d&&this._matchDragDataType(e,`${d[s].axis}Labels`)){e.preventDefault(),o=d[s].axis,r=d[s].level,h=this._getLabelRelativePosition(e,o,d),l=this.getElementDir(d,"top")+("after"===h?this.getElementHeight(d):0),"columnEnd"===o&&(l+=this.getElementDir(this.m_rowHeaderScrollbarSpacer,"top")),a=this.getElementDir(d,i)+("after"===h?this.getElementWidth(d):0),"rowEnd"===o&&(a+=this.getElementDir(this.m_columnHeaderScrollbarSpacer,i)),this._addPivotDropTargetLine(o,l,i,a,h,d);let t={level:r,axis:o,position:h};this._invokeDropCallback(`${o}Labels`,"dragOver",e,t)}}},A.prototype._handlePivotDropOnHeader=function(e){let t=this.findHeader(e.target);if(t){const i=this.getResources().getMappedAttribute("context"),s=t[i];let n=this.m_headerLabels[s.axis][s.level];if(n&&this._matchDragDataType(e,`${n[i].axis}Labels`)){let t=n[i].level,s=n[i].axis,o={level:t,axis:s,position:this._getLabelRelativePosition(e,s,n)};this._invokeDropCallback(`${s}Labels`,"drop",e,o)}}},A.prototype._setDragLabelData=function(e,t){if(t){let i=e.dataTransfer;const s=this.getResources().getMappedAttribute("context"),n={axis:this.m_dragLabel[s].axis,level:this.m_dragLabel[s].level,data:this.m_dragLabel[s].data};let o=JSON.stringify(n);if("string"==typeof t)i.setData(t,o);else for(let e=0;e<t.length;e++)i.setData(t[e],o)}},A.prototype.setHiddenColumns=function(e){void 0!==e&&(this.m_hiddenColumns=null===e?[]:e)},A.prototype.setHiddenRows=function(e){void 0!==e&&(this.m_hiddenRows=null===e?[]:e)},A.prototype.getHiddenIndicatorByIndex=function(e,t,i){let s;if(s=i?t.querySelectorAll(`.${this.getResources().getMappedStyle("colHeaderHiddenIndicator")},\n      .${this.getResources().getMappedStyle("rowHeaderHiddenIndicator")}`):t.querySelectorAll(`.${this.getResources().getMappedStyle("colHiddenIndicator")},\n      .${this.getResources().getMappedStyle("rowHiddenIndicator")}`),s=Array.from(s),s.length>0){const t=s.find(t=>this._getAttribute(t,"hiddenIndicatorIndex",!0)===e);if(t)return t}return null},A.prototype.getActiveDatabodyIndicators=function(){const e=this.getResources().getMappedStyle("colHiddenIndicator"),t=this.getResources().getMappedStyle("rowHiddenIndicator"),i=[];return this.m_root.querySelectorAll(`.${e}, .${t}`).forEach(e=>i.push(this._getAttribute(e,"hiddenIndicatorIndex",!0))),i.length>0?i:null},A.prototype.getIndexesByHeader=function(e){let t=e[this.getResources().getMappedAttribute("context")],i=[],s=t.index,n=t.extent;for(let e=s;e<s+n;e++)i.push(e);return i},A.prototype.applyHiddenIndicatorToRange=function(e,t,i,s){const n=this.getResources().isRTLMode()?"right":"left";let o,r,l;"column"===s?(o=this.m_hiddenColumns,r=this.m_columnHeaderLevelCount,l="width"):"row"===s&&(o=this.m_hiddenRows,r=this.m_rowHeaderLevelCount,l="height"),o.sort((e,t)=>e-t);let a="column"===s?this.m_hiddenColumns:this.m_hiddenRows;for(let h=e;h<=t;h++)if(a.includes(h)){let e,t=-1===h?0:h,a="column"===s?this.m_hasColHeader||this.m_hasColEndHeader:this.m_hasRowHeader||this.m_hasRowEndHeader;if(1===r&&a){let e=this._getHeaderByIndex(t,s,0);if(e){let o="column"===s?this.getElementDir(e,n):this.getElementDir(e,"top");o+=-1===h?0:this.getElementDir(e,l),this.renderHiddenAxisVisualIndicator(s,"column"===s?0:o,n,"column"===s?o:0,t,i)}}else{let r,a=this._getHeadersByIndex(h,s);for(let h=a.length-1;h>=0;h--)if(e=a[h],r=this.getIndexesByHeader(e),this.isArraySubset(r,o)){let a=this.getElementDir(e,"top"),d=this.getElementDir(e,n);d+=-1===h?0:this.getElementDir(e,l),this.renderHiddenAxisVisualIndicator(s,a,n,d,t,i),o=o.filter(e=>!r.includes(e))}}}},A.prototype.renderHiddenAxisVisualIndicator=function(e,t,i,s,n,o){let r,l,a;const h="column"===e&&this._hasFrozenColumns()&&n<=this.m_frozenColIndex||"row"===e&&this._hasFrozenRows()&&n<=this.m_frozenRowIndex;let d,m,c,u,_,p;r="column"===e?h?this.m_colHeaderFrozen:this.m_colHeader:h?this.m_rowHeaderFrozen:this.m_rowHeader,l="column"===e?h?this.m_colEndHeaderFrozen:this.m_colEndHeader:h?this.m_rowEndHeaderFrozen:this.m_rowEndHeader,a="column"===e?h?this.m_databodyFrozenCol:this.m_databody:h?this.m_databodyFrozenRow:this.m_databody,"row"===e?(m="width",d="width",c="rowHeaderHiddenIndicator",u="rowHiddenIndicator",_=this.m_hasRowHeader,p=this.m_hasRowEndHeader):"column"===e&&(m="height",d="height",c="colHeaderHiddenIndicator",u="colHiddenIndicator",_=this.m_hasColHeader,p=this.m_hasColEndHeader);let g=0,f=0,C=0;C=this.getElementDir(this.m_databody.firstChild,m);let y="row"===e?s:t;g=this.getElementDir(r.firstChild,d)-y,f=this.getElementDir(l.firstChild,d)-y;let E=0,v=0;if(this.isFirstOrFirstNonHiddenIndex(n+1,e)?(E=2,v=1):this.isLastOrLastNonHiddenIndex(n-1,e)&&(E=-2,v=-1),_){let o=document.createElement("div");this._setAttribute(o,"hiddenIndicatorIndex",n),this._setVisualIndicatorStyle(o,c,"row"===e?t+E-2:t,i,"row"===e?s:s+E-2,g,d),r.firstChild.appendChild(o)}if(p){let o=document.createElement("div");this._setAttribute(o,"hiddenIndicatorIndex",n),this._setVisualIndicatorStyle(o,c,"row"===e?t+E-2:0,i,"row"===e?0:s+E-2,f,d),l.firstChild.appendChild(o)}if(o&&o.includes(n)){let o=document.createElement("div");this._setAttribute(o,"hiddenIndicatorIndex",n),this._setVisualIndicatorStyle(o,u,"row"===e?t+v-1:0,i,"row"===e?0:s+v-1,C,m),a.firstChild.appendChild(o);let r="column"===e?this._hasFrozenRows():this._hasFrozenColumns(),l="column"===e?this._hasFrozenColumns()&&n<=this.m_frozenColIndex:this._hasFrozenRows()&&n<=this.m_frozenRowIndex;if(r)if(l){let o=document.createElement("div"),r=0,l=this.m_databodyFrozenCorner;r=this.getElementDir(l.firstChild,m),this._setAttribute(o,"hiddenIndicatorIndex",n),this._setVisualIndicatorStyle(o,u,"row"===e?t+v-1:0,i,"row"===e?0:s+v-1,r,m),l.firstChild.appendChild(o)}else{let o=document.createElement("div"),r=0,l=this.m_databodyFrozenRow;r=this.getElementDir(l.firstChild,m),this._setAttribute(o,"hiddenIndicatorIndex",n),this._setVisualIndicatorStyle(o,u,"row"===e?t+v-1:0,i,"row"===e?0:s+v-1,r,m),l.firstChild.appendChild(o)}}},A.prototype.isHidden=function(e,t){let i;return"column"===e||"columnEnd"===e?i=this.m_hiddenColumns:"row"!==e&&"rowEnd"!==e||(i=this.m_hiddenRows),!!i.includes(t)},A.prototype.isHeaderHidden=function(e){let t,i,s,n,o,r=[];if(e&&(t=e[this.getResources().getMappedAttribute("context")],i=t.extent,n=t.axis,s=t.index),"column"===n||"columnEnd"===n?o=this.m_hiddenColumns:"row"!==n&&"rowEnd"!==n||(o=this.m_hiddenRows),1===i){if(o.includes(s))return!0}else if(r=this.getIndexesByHeader(e),this.isArraySubset(r,o))return!0;return!1},A.prototype.arrayIndices=function(e,t){let i;i=this._isCountUnknownOrHighwatermark("column")?this._getMaxRight():Math.max(0,this.getDataSource().getCount("column")-1);let s=[];if(t.left)for(let t=0;t<=e;t++)s.push(t);else if(t.right)for(let t=e;t<=i;t++)s.push(t);return s},A.prototype.isArraySubset=function(e,t){return e.every(e=>t.includes(e))},A.prototype.hiddenColumnsInDirection=function(e,t){let i=new Set(this.arrayIndices(e,t));return this.m_hiddenColumns.filter(e=>i.has(e))},A.prototype.isFirstOrFirstNonHiddenIndex=function(e,t){let i;if("column"===t||"columnEnd"===t?i=this.m_hiddenColumns:"row"!==t&&"rowEnd"!==t||(i=this.m_hiddenRows),e>=0){for(let t=0;t<=e-1;t++)if(!i.includes(t))return!1;return!0}return!1},A.prototype.findNextNonHiddenIndex=function(e,t){let i,s=e;for("column"===t||"columnEnd"===t?i=this.m_hiddenColumns:"row"!==t&&"rowEnd"!==t||(i=this.m_hiddenRows);i.includes(s)&&s>0;)s-=1;return s},A.prototype.isLastOrLastNonHiddenIndex=function(e,t){if(e>=0){let i,s;this._isCountUnknownOrHighwatermark(t)?"column"===t||"columnEnd"===t?i=this._getMaxRight():"row"!==t&&"rowEnd"!==t||(i=this._getMaxBottom()):i=Math.max(0,this.getDataSource().getCount(t)-1),"column"===t||"columnEnd"===t?s=this.m_hiddenColumns:"row"!==t&&"rowEnd"!==t||(s=this.m_hiddenRows);for(let t=i;t>=e+1;t--)if(!s.includes(t))return!1;return!0}return!1},A.prototype.getVisibleCellIndexInDirection=function(e,t,i){let s,n=t;if("column"===e||"columnEnd"===e?s=this.m_hiddenColumns:"row"!==e&&"rowEnd"!==e||(s=this.m_hiddenRows),i.right||i.down)for(;s.includes(n);)n+=1;else if(i.left||i.up)for(;s.includes(n);)n-=1;return n},A.prototype._handleHideAxis=function(e,t){let i,s,n,o,r=this.findHeader(e.target),l=this.findCell(e.target),a=this.m_selection,h=this.m_options.options.selectionMode,d=h.cell,m=h.row,c=[];if("column"===t?(i="multiple"===d,s=this.m_hiddenColumns):"row"===t&&(i="multiple"===m||"multiple"===d,s=this.m_hiddenRows),a.length&&i)for(let e=0;e<a.length;e++){let i=a[e].startIndex[t],s=a[e].endIndex[t];for(let e=i;e<=s;e++)c.push(e)}else if("single"===d)if(a.length){let e=a[0].startIndex[t];c.push(e)}else r&&(c=this.getIndexesByHeader(r));else if("none"===d&&"none"===m)r?c=this.getIndexesByHeader(r):l&&c.push(this._getIndex(l,t));else{if(("column"!==t||"multiple"!==m)&&"single"!==m)return;if(!r)return;c=this.getIndexesByHeader(r)}for(let e=0;e<c.length;e++){let i=c[e];s.includes(i)||s.push(i),this.shiftAxisForHidability(i,!0,t)}this.focusNextVisibleAxis(r,l,e,t),this.deleteAndApplyHiddenIndicators(c,t),this.fillViewport(),"column"===t?(n={event:e,ui:{hiddenColumns:new Set(this.m_hiddenColumns)}},o="columnHide"):"row"===t&&(n={event:e,ui:{hiddenRows:new Set(this.m_hiddenRows)}},o="rowHide"),this.fireEvent(o,n)},A.prototype.focusNextVisibleAxis=function(e,t,i,s){let n,o;if(e)n=this._getIndex(e,s);else{if(!t)return;n=this._getIndex(t,s)}o=this.isLastOrLastNonHiddenIndex(n,s)?"column"===s?this.getVisibleCellIndexInDirection("column",n,{left:!0}):this.getVisibleCellIndexInDirection("row",n,{up:!0}):"column"===s?this.getVisibleCellIndexInDirection("column",n,{right:!0}):this.getVisibleCellIndexInDirection("row",n,{down:!0});let r=this.getResources().getMappedAttribute("context");if(e){let t=e[r].level;var l=this._getHeaderByIndex(o,s,t);this._setActive(l,{type:"header",index:o,level:t,axis:s})}else if(t){let e="column"===s?t[r].indexes.row:t[r].indexes.column,n="column"===s?this.createIndex(e,o):this.createIndex(o,e);this._setActiveByIndex(n,i)}},A.prototype._updateHiddenSection=function(e,t){let i="column"===t?this.m_hiddenColumns:this.m_hiddenRows,s=i.filter(t=>!e.includes(t)),n=e.filter(e=>!i.includes(e));"column"===t?this.m_hiddenColumns=e:"row"===t&&(this.m_hiddenRows=e);for(let e=0;e<n.length;e++){let i=n[e];this.shiftAxisForHidability(i,!0,t)}for(let e=0;e<s.length;e++){let i=s[e];this.shiftAxisForHidability(i,!1,t)}if(this.deleteAndApplyHiddenIndicators(n,t),this.fillViewport(),this.m_active&&("row"===t||"column"===t)){const e="row"===t?{down:!0}:{right:!0},i="row"===t?this.m_hiddenRows:this.m_hiddenColumns;let s,n;i.length&&("cell"===this.m_active.type&&this.m_active.indexes&&i.includes(this.m_active.indexes[t])?(this.m_shouldFocus=!1,s=this.getVisibleCellIndexInDirection(t,this.m_active.indexes[t],e),n="row"===t?this._getCellByIndex(this.createIndex(s,this.m_active.indexes.column)):this._getCellByIndex(this.createIndex(this.m_active.indexes.row,s)),this._setActive(n)):"header"===this.m_active.type&&this.m_active.index&&i.includes(this.m_active.index)&&(this.m_shouldFocus=!1,s=this.getVisibleCellIndexInDirection(t,this.m_active.index,e),n=this._getHeaderCellByIndex(s,t),this._setActive(n,{type:"header",index:this.m_active.index,level:this.m_active.level,axis:t})))}},A.prototype.containsHiddenItems=function(e,t){let i,s="column"===t?this.m_hiddenColumns:this.m_hiddenRows;return i=e.filter(e=>s.includes(e)),i.sort((e,t)=>e-t),i},A.prototype._handleUnhideAxis=function(e,t,i){let s,n,o="column"===t?this.m_hiddenColumns:this.m_hiddenRows,r=[];if(null==i){let i=this.findHeader(e.target),s=this.findCell(e.target),n=this.getAxisSelectionIndexArray(t),l=this.m_selection,a=this.m_options.options.selectionMode,h=a.cell,d=a.row,m=this.containsHiddenItems(n,t);const c=e=>{let t=[],i=[];for(let s=0;s<e.length;s++){let n=0;for(;o.includes(e[s]-1-n);)t.push(e[s]-1-n),n+=1;let r=0;for(;o.includes(e[s]+1+r);)i.push(e[s]+1+r),r+=1}return[...t,...i]};let u,_,p=this.areAllAxisElementsSelectedViaOtherAxis(t);if("column"===t?(u="multiple"===h,_=this._getMaxRight()):"row"===t&&(u="multiple"===d||"multiple"===h,_=this._getMaxBottom()),!0===p)r=[...o];else if(l.length&&u)for(let e=0;e<n.length;e++){let i=n[e];if(m.length){r=m;break}if(this.isFirstOrFirstNonHiddenIndex(i,t)&&this.isLastOrLastNonHiddenIndex(i,t))r=c([i]);else if(this.isFirstOrFirstNonHiddenIndex(i,t)){let e=[];for(let t=0;t<=i-1;t++)e.push(t);r=e}else if(this.isLastOrLastNonHiddenIndex(i,t)){let e=[];for(let t=i+1;t<=_;t++)e.push(t);r=e}}else if("single"===h)l.length?r=c(n):i&&(n=this.getIndexesByHeader(i),r=c(n));else if("none"===h&&"none"===d)i?(n=this.getIndexesByHeader(i),r=c(n)):s&&(n.push(this._getIndex(s,"column")),r=c(n));else{if(("column"!==t||"multiple"!==d)&&"single"!==d)return;if(!i)return;n=this.getIndexesByHeader(i),r=c(n)}}else r=[i];this.unhighlightSelection();for(let e=0;e<r.length;e++){let i=r[e],s=o.indexOf(i);-1!==s&&o.splice(s,1),this.shiftAxisForHidability(i,!1,t)}this.deleteAndApplyHiddenIndicators(),this.applySelection(),this._resetHeaderHighLight(),this.resizeGrid(),"column"===t?(s={event:e,ui:{hiddenColumns:new Set(this.m_hiddenColumns)}},n="columnHide"):"row"===t&&(s={event:e,ui:{hiddenRows:new Set(this.m_hiddenRows)}},n="rowHide"),this.fireEvent(n,s)},A.prototype.shiftAxisForHidability=function(e,t,i){var s;let n,o,r,l,a,h,d,m;"column"===i?(s=this.getResources().isRTLMode()?"right":"left",n=this.getMappedStyle("colheadercell"),o=this.getMappedStyle("colendheadercell"),a="width",r=this.m_startRow,l=e):"row"===i&&(s="top",n=this.getMappedStyle("rowheadercell"),o=this.getMappedStyle("rowendheadercell"),a="height",r=e,l=this.m_startCol);let c,u,_,p,g,f,C,y=this.createIndex(r,l);if(h=this._getCellByIndex(y),m=h[this.getResources().getMappedAttribute("context")],d="column"===i?m.keys.column:m.keys.row,c="column"===i?this.getElementWidth(h):this.getElementHeight(h),_=this.m_sizingManager.getSize(i,d),u=t?0:_,g=u-c,0!==g){let t,h,d,m,c,u,_=!1;if("column"===i?(t=this.m_databodyFrozenCol,h=this.m_endRowEndHeader,d=this.m_hasColHeader,m=this.m_hasColEndHeader,u=this.m_frozenColIndex,c=l,this._hasFrozenColumns()&&e<=this.m_frozenColIndex?(_=!0,f=this.m_colHeaderFrozen,C=this.m_colEndHeaderFrozen):(f=this.m_colHeader,C=this.m_colEndHeader)):"row"===i&&(t=this.m_databodyFrozenRow,h=this.m_endColEndHeader,d=this.m_hasRowHeader,m=this.m_hasRowEndHeader,u=this.m_frozenRowIndex,c=r,this._hasFrozenRows()&&e<=this.m_frozenRowIndex?(_=!0,f=this.m_rowHeaderFrozen,C=this.m_rowEndHeaderFrozen):(f=this.m_rowHeader,C=this.m_rowEndHeader)),null==this.m_databody.firstChild||_){if(_&&t){let e=this.getElementDir(t,a),n=this.getElementDir(t,s);if(-1!==h){let t="column"===i?this.m_rowEndHeader:this.m_colEndHeader,o=this.getElementDir(t,s);g=n+e+g>o?o-(n+e):g}p=e+g,this.setElementDir(t,p,a),this.m_databodyFrozenCorner&&this.setElementDir(this.m_databodyFrozenCorner,p,a)}}else{p=this.getElementDir(this.m_databody.firstChild,a)+g,this.setElementDir(this.m_databody.firstChild,p,a),this.m_databodyFrozenRow&&this.setElementWidth(this.m_databodyFrozenRow.firstChild,p)}let y=!1;d&&(this._shiftHeadersAlongAxisInContainer(f.firstChild,c,g,s,n,i,!0),_||("column"===i?this.m_endColHeaderPixel+=g:this.m_endRowHeaderPixel+=g)),m&&(this._shiftHeadersAlongAxisInContainer(C.firstChild,c,g,s,o,i,!0),_||("column"===i?this.m_endColEndHeaderPixel+=g:this.m_endRowEndHeaderPixel+=g)),_?("column"===i&&this.m_databodyFrozenCol||"row"===i&&this.m_databodyFrozenRow)&&(y=!0,this._shiftCellsAlongAxis(i,g,c,null,u,y,!0)):(this._shiftCellsAlongAxis(i,g,c,!1,void 0,void 0,!0),(this.m_databodyFrozenRow||this.m_databodyFrozenCol)&&this._shiftFrozenCellsAlongAxis(i,g,c,!1,!0),"column"===i?this.m_endColPixel+=g:this.m_endRowPixel+=g),this.manageResizeScrollbars()}},A.prototype.deleteAndApplyHiddenIndicators=function(e,t){let i="column"===t?this.m_startCol:this.m_startRow,s="column"===t?this.m_endCol:this.m_endRow;this.deleteAllHiddenVisualIndicators(t),t?this.applyHiddenIndicatorToRange(i,s,e,t):(this.applyHiddenIndicatorToRange(this.m_startCol,this.m_endCol,e,"column"),this.applyHiddenIndicatorToRange(this.m_startRow,this.m_endRow,e,"row"))},A.prototype.deleteAllHiddenVisualIndicators=function(e){this.deleteDatabodyHiddenVisualIndicators(),"column"===e?this.m_root.querySelectorAll(`.${this.getResources().getMappedStyle("colHeaderHiddenIndicator")}`).forEach(e=>this._remove(e)):"row"===e?this.m_root.querySelectorAll(`.${this.getResources().getMappedStyle("rowHeaderHiddenIndicator")}`).forEach(e=>this._remove(e)):this.m_root.querySelectorAll(`.${this.getResources().getMappedStyle("rowHeaderHiddenIndicator")},\n            .${this.getResources().getMappedStyle("colHeaderHiddenIndicator")}`).forEach(e=>this._remove(e))},A.prototype.deleteDatabodyHiddenVisualIndicators=function(){if(this.m_databody){this.m_databody.firstChild.querySelectorAll(`.${this.getResources().getMappedStyle("colHiddenIndicator")},\n            .${this.getResources().getMappedStyle("rowHiddenIndicator")}`).forEach(e=>this._remove(e))}if(this._hasFrozenColumns()){this.m_databodyFrozenCol.firstChild.querySelectorAll(`.${this.getResources().getMappedStyle("colHiddenIndicator")},\n                        .${this.getResources().getMappedStyle("rowHiddenIndicator")}`).forEach(e=>this._remove(e))}if(this._hasFrozenRows()){this.m_databodyFrozenRow.firstChild.querySelectorAll(`.${this.getResources().getMappedStyle("colHiddenIndicator")},\n                           .${this.getResources().getMappedStyle("rowHiddenIndicator")}`).forEach(e=>this._remove(e))}if(this._hasFrozenColumns()&&this._hasFrozenRows()){this.m_databodyFrozenCorner.firstChild.querySelectorAll(`.${this.getResources().getMappedStyle("colHiddenIndicator")},\n                         .${this.getResources().getMappedStyle("rowHiddenIndicator")}`).forEach(e=>this._remove(e))}},A.prototype.updateHiddenAxisForInsertion=function(e,t,i){let s=!1,n="row"===i?this.m_hiddenRows:this.m_hiddenColumns;for(let i=0;i<n.length;i++)n[i]>=e&&(n[i]+=t,s=!0);if(s){let e;"column"===i?(e={event:null,ui:{hiddenColumns:new Set(this.m_hiddenColumns)}},this.fireEvent("columnHide",e)):"row"===i&&(e={event:null,ui:{hiddenRows:new Set(this.m_hiddenRows)}},this.fireEvent("rowHide",e))}},A.prototype.updateHiddenAxisForDeletion=function(e,t){let i=!1,s="row"===t?this.m_hiddenRows:this.m_hiddenColumns;if(e.forEach(e=>{let n=s.indexOf(t=>t===e);-1!==n&&(i=!0,s.splice(n,1));let o=s.map(t=>t>e?(i=!0,t-1):t);"column"===t?this.m_hiddenColumns=o:"row"===t&&(this.m_hiddenRows=o)}),i){let e;"column"===t?(e={event:null,ui:{hiddenColumns:new Set(this.m_hiddenColumns)}},this.fireEvent("columnHide",e)):"row"===t&&(e={event:null,ui:{hiddenRows:new Set(this.m_hiddenRows)}},this.fireEvent("rowHide",e))}},A.prototype.canHide=function(e){let t,i,s,n=this.m_selection;"column"===e||"columnEnd"===e?(t=this.m_endCol-this.m_startCol+1,s=this.m_hiddenColumns,i=s.length):"row"!==e&&"rowEnd"!==e||(t=this.m_endRow-this.m_startRow+1,s=this.m_hiddenRows,i=s.length);let o,r,l,a=[];if(n.length&&this.isMultipleSelection()){if("column"===e||"columnEnd"===e){if(this.areAllAxisElementsSelectedViaOtherAxis("column"))return!1;l="column"}else if("row"===e||"rowEnd"===e){if(this.areAllAxisElementsSelectedViaOtherAxis("row"))return!1;l="row"}for(let e=0;e<n.length;e++){let t=n[e].startIndex[l],i=n[e].endIndex[l];for(let e=t;e<=i;e++)s.includes(e)||a.push(e)}o=a.length}else o=1;return r=t-i-o,r>0},A.prototype.isHiddenAdjacent=function(e){let t,i=e.cell,s=e.header,n=e.index,o=e.axis;if("column"===o||"columnEnd"===o?t=this.m_hiddenColumns:"row"!==o&&"rowEnd"!==o||(t=this.m_hiddenRows),i){let e=n-1,i=n+1;return!(!t||!t.includes(e))||!(!t||!t.includes(i))}if(s){let e=[],i=[];for(let s=0;s<n.length;s++){let o=0;for(;t&&t.includes(n[s]-1-o);)e.push(n[s]-1-o),o+=1;let r=0;for(;t&&t.includes(n[s]+1+r);)i.push(n[s]+1+r),r+=1}return e.length>0||i.length>0}return!1},A.prototype.getAxisSelectionIndexArray=function(e){let t=this.m_selection,i=[];if(t.length&&!this.areAllAxisElementsSelectedViaOtherAxis(e)){for(let s=0;s<t.length;s++){let n=t[s].startIndex[e],o=t[s].endIndex[e];for(let e=n;e<=o;e++)i.push(e)}i.sort((e,t)=>e-t)}return i},A.prototype.areAllAxisElementsSelectedViaOtherAxis=function(e){let t=this.m_selection,i=this.m_options.options.selectionMode,s=i.cell,n=i.row,o="multiple"===n||"single"===n;if(t.length&&("multiple"===s||"column"===e&&o))for(let i=0;i<t.length;i++){let s=t[i].startIndex[e],n=t[i].endIndex[e];if(0===s&&-1===n||null==s&&null==n)return!0}return!1},A.prototype._getCellHidabilityContextMenuCapability=function(e,t){let i=this.m_options.options.selectionMode,s=i.cell,n=i.row,o=!1,r=!1,l=this.getAxisSelectionIndexArray(t);const a=this.getResources().getMappedAttribute("context");let h,d;if("column"===t||"columnEnd"===t?(h="column",d=this.m_hiddenColumns):"row"!==t&&"rowEnd"!==t||(h="row",d=this.m_hiddenRows),this._isSelectionEnabled())if(this.isMultipleSelection())if("multiple"===s){if(this.canHide(t)&&(o=!0),l.length>0){let e=l[0],i=l[l.length-1];(this.containsHiddenItems(l,t).length>0||this.isFirstOrFirstNonHiddenIndex(e,t)||this.isLastOrLastNonHiddenIndex(i,t))&&(r=!0)}}else this.areAllAxisElementsSelectedViaOtherAxis(h)&&d.length>0&&(r=!0);else"single"===s||"single"===n?(this.canHide(t)&&(o=!0),this.isHiddenAdjacent({cell:!0,index:l[0],axis:t})&&(r=!0)):this.areAllAxisElementsSelectedViaOtherAxis(h)&&d.length>0&&(r=!0);else if("none"===s&&"none"===n){this.canHide(t)&&(o=!0);let i=e[a].indexes.column;this.isHiddenAdjacent({cell:!0,index:i,axis:t})&&(r=!0)}return{canHide:o,canUnhide:r}},A.prototype._getHeaderHidabilityContextMenuCapability=function(e,t){let i,s,n,o,r=this.m_options.options.selectionMode,l=r.cell,a=r.row,h=!1,d=!1,m=this.getAxisSelectionIndexArray(t),c=this.m_utils.containsCSSClassName(e,this.getMappedStyle("selected"));if("column"===t||"columnEnd"===t?(i="multiple"===l,s="multiple"===a,n="column",o=this.m_hiddenColumns):"row"!==t&&"rowEnd"!==t||(s="multiple"===l,i="multiple"===a||s,n="row",o=this.m_hiddenRows),this._isSelectionEnabled()&&i)if(c&&this.canHide(t)&&(h=!0),m.length>0){let e,i=m[0],s=m[m.length-1];this._isCountUnknownOrHighwatermark(t)?"column"===t||"columnEnd"===t?e=this._getMaxRight():"row"!==t&&"rowEnd"!==t||(e=this._getMaxBottom()):e=Math.max(0,this.getDataSource().getCount(t)-1),(this.containsHiddenItems(m,n).length>0||this.isFirstOrFirstNonHiddenIndex(i,n)&&0!==i||this.isLastOrLastNonHiddenIndex(s,n)&&s!==e)&&(d=!0)}else this.areAllAxisElementsSelectedViaOtherAxis(n)&&o.length>0&&(d=!0);else if(s||"single"===l||"single"===a||"none"===l&&"none"===a){let i=e[this.getResources().getMappedAttribute("context")].index;h=!0,this.isHiddenAdjacent({header:!0,index:[i],axis:t})&&o.length>0&&(d=!0)}return{canHide:h,canUnhide:d}},A.prototype._buildFilterIcon=function(e){const t=document.createElement("div");t.classList.add(this.getMappedStyle("iconContainer"),this.getMappedStyle("filterIcon"));const i=document.createElement("div");return i.classList.add(this.getMappedStyle("icon"),this.getMappedStyle("clickableicon")),"filtered"===e.metadata.filter?i.classList.add(this.getMappedStyle("filtered")):(i.classList.add(this.getMappedStyle("filterable")),t.classList.add(this.getMappedStyle("iconHidden"))),i.setAttribute("title",this.getResources().getTranslatedText("labelFilter")),t.appendChild(i),t.addEventListener("mouseover",this._handleFilterContainerMouseOver.bind(this)),t},A.prototype._handleFilterContainerMouseOver=function(e){const t=e.target,i=this.findHeader(t),s=this._getFilterIcon(i),n=this._getFilterContainer(i);e.currentTarget.classList.contains(this.getMappedStyle("filterIcon"))&&(e.currentTarget.classList.add(this.getMappedStyle("hover")),s.classList.add(this.getMappedStyle("hover")),n&&n.classList.remove(this.getMappedStyle("iconHidden")))},A.prototype._handleFilterMouseOut=function(e){if(!this._databodyEmpty()){const t=e.target,i=this.findHeader(t),s=this._getFilterIcon(i),n=i[this.getResources().getMappedAttribute("context")];s&&s.classList.remove(this.getMappedStyle("hover"));const o=this._getFilterContainer(i);o&&(o.classList.remove(this.getMappedStyle("hover")),"filtered"!==n.metadata.filter&&o.classList.add(this.getMappedStyle("iconHidden")))}},A.prototype._getFilterIcon=function(e){return this._getFilterContainer(e).firstChild},A.prototype._getFilterContainer=function(e){return e.querySelector("."+this.getMappedStyle("filterIcon"))},A.prototype._handleHeaderFilter=function(e,t){if(!this._databodyEmpty()){const i=e.target;let s=this.findHeader(i);if(null==s){null!=this.findCell(i)&&(s=this.getHeaderFromCell(i,t))}null!=s&&this._fireFilterRequestEvent(e,s)}},A.prototype._fireFilterRequestEvent=function(e,t){const i=t[this.getResources().getMappedAttribute("context")],s=t[this.getResources().getMappedAttribute("metadata")];var n={event:e,ui:{item:this.buildHeaderTemplateContext(i,s).item,axis:this._getAxis(t),anchor:t,launcher:this._getFilterIcon(t)}};this.fireEvent("filterRequest",n)},A.prototype._isFilterIcon=function(e){return e.classList.contains(this.getMappedStyle("filterable"))||e.classList.contains(this.getMappedStyle("filtered"))||e.classList.contains(this.getMappedStyle("filterIcon"))}});
//# sourceMappingURL=ojdatagrid.js.map