/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojcore-base","ojs/ojcustomelement-registry","ojs/ojcontext","ojs/ojlogger","ojs/ojthemeutils"],function(e,t,r,i,n,s){"use strict";t=t&&Object.prototype.hasOwnProperty.call(t,"default")?t.default:t,i=i&&Object.prototype.hasOwnProperty.call(i,"default")?i.default:i;const o={};class a{static isValidCustomElementName(e){const t=a._RESERVED_TAGS.has(e),r=a._ELEMENT_NAME_REGEXP.test(e);return!t&&r&&!e.startsWith("oj-bind-",0)}static getSupportedTypes(e){if(!e)return{};let t=o[e];if(!t){t={};const r=e.toLowerCase(),i=r.match(/(?=[^|])(?:[^|]*<[^>]+>)*[^|]*/g);let n=0;i.forEach(e=>{const r=e.trim();"any"===r||"boolean"===r||"number"===r||"string"===r||"array"===r||"object"===r||"null"===r?t[r]=1:0===r.indexOf("array<")?t.array=1:0===r.indexOf("object<")?t.object=1:t.other=1,n++}),t.typeCount=n,o[r]=t}return t}static getUniqueId(e){if(e)return e;const t=a._UNIQUE+a._UNIQUE_INCR;return a._UNIQUE_INCR+=1,t}static comparePropertyValues(e,r,i){return e?t.Object.compareValues(r,i):r===i}}a._UNIQUE_INCR=0,a._UNIQUE="_oj",a._RESERVED_TAGS=new Set(["annotation-xml","color-profile","font-face","font-face-src","font-face-uri","font-face-format","font-face-name","missing-glyph"]),a._ELEMENT_NAME_REGEXP=/^[a-z][.0-9_a-z]*-[-.0-9_a-z]*$/;const l={accessKey:"accesskey",autocapitalize:"autocapitalize",autofocus:"autofocus",class:"class",contentEditable:"contenteditable",dir:"dir",draggable:"draggable",enterKeyHint:"enterkeyhint",hidden:"hidden",id:"id",inputMode:"inputmode",lang:"lang",role:"role",slot:"slot",spellcheck:"spellcheck",style:"style",tabIndex:"tabindex",translate:"translate",title:"title"};class c extends Error{constructor(e,t){super(`${e.localName} with id '${e.id||""}': ${t}`),Error.captureStackTrace&&Error.captureStackTrace(this,c),this.name="JetElementError"}}const d=/^\s*\[[^]*\]\s*$/,u=/^\s*\{[^]*\}\s*$/,p=/^(?:\{\{)([^]+)(?:\}\})$/,h=/^(?:\[\[)([^]+)(?:\]\])$/,g={};Object.keys(l).forEach(function(e){const t=l[e];e!==t&&(g[t]=e)});class m{static getExpressionInfo(e){let t,r=!1;if(e){const i=e.trim();let n=p.exec(i);t=n?.[1],t||(r=!0,n=h.exec(i),t=n?.[1])}return{downstreamOnly:r,expr:t}}static attributeToPropertyValue(e,t,r,i){if(null!=r)try{return m.coerceValue(e,t,r,i.type)}catch(r){throw new c(e,`Error while parsing parsing attribute ${t}. ${r.stack||r}`)}}static parseAttributeValue(e,t,r,i,n=null){if(!i)throw new Error(`Unable to parse ${t}='${r}' for ${e} with id '${n}'.         This attribute only supports data bound values. Check the API doc for supported types`);const s=a.getSupportedTypes(i),o=d.test(r),l=u.test(r);if(s.array&&o||s.object&&l||s.any&&(o||l))try{return JSON.parse(r)}catch(i){throw new Error(`Unable to parse ${t}='${r}' for ${e} with id '${n}'           to a JSON Object. Check the value for correct JSON syntax, e.g. double quoted strings. ${i}`)}else{if(s.string||s.any)return r;if(s.boolean)return m.parseBooleanValue(e,t,r,i,n);if(s.number&&!isNaN(r))return Number(r)}throw new Error(`Unable to parse ${t}='${r}' for ${e} with id '${n}'       to a ${i}.`)}static parseBooleanValue(e,t,r,i,n){if(null==r||"true"===r||""===r||r.toLowerCase()===t)return!0;if("false"===r)return!1;throw new Error(`Unable to parse ${t}='${r}' for ${e} with id '${n}' to a ${i}.`)}static coerceValue(e,t,r,i){const n=e.tagName.toLowerCase();return m.parseAttributeValue(n,t,r,i,e.id)}static coerceBooleanValue(e,t,r,i){return m.parseBooleanValue(e.tagName.toLowerCase(),t,r,i,e.id)}static isGlobalOrData(e){return Object.prototype.hasOwnProperty.call(l,e)||e.startsWith("data-")||e.startsWith("aria-")}static getGlobalAttrForProp(e){return l[e]||e}static getGlobalPropForAttr(e){return g[e]||e}static getGlobalValuePropForAttr(e){return"contenteditable"===e.toLowerCase()?"isContentEditable":m.getGlobalPropForAttr(e)}}function _(e,t){let r=e.cache;return r||(r=new Map,e.cache=r),r.has(t)||r.set(t,e(t)),r.get(t)}m.attributeToPropertyName=_.bind(null,e=>e.toLowerCase().replace(/-(.)/g,(e,t)=>t.toUpperCase())),m.propertyNameToAttribute=_.bind(null,e=>e.replace(/([A-Z])/g,e=>`-${e.toLowerCase()}`)),m.eventTypeToEventListenerProperty=_.bind(null,e=>"on"+e.substr(0,1).toUpperCase()+e.substr(1)),m.isEventListenerProperty=_.bind(null,e=>/^on[A-Z]/.test(e)),m.isEventListenerAttr=_.bind(null,e=>/^on-[a-z]/.test(e)),m.eventListenerPropertyToEventType=_.bind(null,e=>e.substr(2,1).toLowerCase()+e.substr(3)),m.propertyNameToChangeEventType=_.bind(null,e=>`${e}Changed`),m.propertyNameToChangedCallback=_.bind(null,e=>`on${e[0].toUpperCase()}${e.substr(1)}Changed`),m.eventTriggerToEventType=_.bind(null,e=>`oj${e.substr(0,1).toUpperCase()}${e.substr(1)}`),m.eventAttrToPreactPropertyName=_.bind(null,e=>e.toLowerCase().split("-").reduce((e,t,r)=>{return r>1?e+((i=t).charAt(0).toUpperCase()+i.substr(1)):e+t;var i},""));const b=Symbol("childBindingProvider"),C=Symbol("cachedBindingProvider"),E=new Set,y="oj-subtree-hidden",f="oj-pending-subtree-hidden",P=Symbol("ojSlotWhitespace");class v{static subtreeShown(e,t,r){v._legacySubtreeShownOnceCB?.(e,t),e.classList.remove(y);const i=v._legacySubtreeShownInstanceCB,n=i?T(e=>i(e,t)):null;N(e,n,r?null:B)}static getElementInfo(e){return e?`${e.tagName.toLowerCase()} with id '${e.id}'`:""}static getElementState(e){let t=e[v._ELEMENT_STATE_KEY];if(!t&&r.isElementRegistered(e.tagName)){t=new(0,r.getElementRegistration(e.tagName).stateClass)(e),Object.defineProperty(e,v._ELEMENT_STATE_KEY,{value:t})}return t??null}static getElementBridge(e){let t=e[v._ELEMENT_BRIDGE_KEY];if(void 0===t&&r.isElementRegistered(e.tagName)){t=null;const i=r.getElementRegistration(e.tagName).bridgeProto;if(void 0!==i){t=Object.create(i);const n=r.getElementDescriptor(e.tagName);t.initializeBridge(e,n)}Object.defineProperty(e,v._ELEMENT_BRIDGE_KEY,{value:t})}return t??null}static getSlotMap(e){const t={},i=e.childNodes,n=i.length>0?r.getMetadata(e.localName):null;for(let r=0;r<i.length;r++){const s=i[r];if(v.isSlotable(s)){const r=v.getSlotAssignment(s);t[r]||(t[r]=[]),v._possiblyApplyImplicitContext(s,r,n),t[r].push(s),s[C]=v._getBindingProviderTypeForSlot(e,s)}}return t}static getSlotAssignment(e){const t=null!=e.__oj_slots?e.__oj_slots:e.getAttribute&&e.getAttribute("slot");return t||""}static isSlotable(e){const t=1===e.nodeType||3===e.nodeType&&!!e.nodeValue.trim();return t||(e[P]=!0),t}static getElementProperty(e,t){if(r.isElementRegistered(e.tagName)){let r=e[v.VCOMP_INSTANCE];return r?v.getPropertyValue(r.props,t):e.getProperty(t)}return e[t]}static getPropertyValue(e,t){let r=e;const i=t.split(".");try{i.forEach(e=>r=r[e])}catch{return}return r}static allowSlotRelocation(e){v._ALLOW_RELOCATION_COUNT+=e?1:-1}static canRelocateNode(e,t){const r=v.getElementState(e);if(!r.getSlotMap()||v._ALLOW_RELOCATION_COUNT>0)return!0;const i=r.getSlotSet();if(r.isPostCreateCallbackOrComplete()&&(i.has(t)||t[P])){if(e.hasAttribute("data-oj-preact"))throw new c(e,`${t.localName} cannot be relocated as a child of this element.`);if("preact"===r.getBindingProviderType())return!1}return!0}static cleanComponentBindings(e){v.getElementState(e)?.getBindingProviderCleanNode()(e)}static getClassSet(e){if(e){const t=e.split(/\s+/).filter(e=>e.length>0);if(t.length>0)return new Set(t)}return E}static _possiblyApplyImplicitContext(e,t,r){e?.nodeType===Node.ELEMENT_NODE&&r.slots?.[t]?.implicitBusyContext&&e.setAttribute("data-oj-context","")}static _getBindingProviderTypeForSlot(e,t){return t[C]||1===t.nodeType&&t.getAttribute("data-oj-binding-provider")||v.getElementState(e)?.getBindingProviderType()}static markPendingSubtreeHidden(e){e.classList.add(f)}static unmarkPendingSubtreeHidden(e){e.classList.remove(f)}static registerLegacySubtreeCallbacks(e,t,r){v._legacySubtreeShownInstanceCB=e,v._legacySubtreeShownOnceCB=t,v._legacySubtreeHiddenInstanceCB=r}static parseAttrValue(e,t,i,n,s){if(null==n)return n;function o(r){return m.attributeToPropertyValue(e,t,r,s)}var a=r.getElementDescriptor(e.tagName).parseFunction;return a?a(n,i,s,function(e){return o(e)}):o(n)}}v._ELEMENT_STATE_KEY="_ojElementState",v._ELEMENT_BRIDGE_KEY="_ojBridge",v._ALLOW_RELOCATION_COUNT=0,v.VCOMP_INSTANCE=Symbol("vcompInstance"),v.subtreeHidden=function(e){const t=v._legacySubtreeHiddenInstanceCB;N(e,t?T(t):null,null),e.classList.add(y)};const S="oj-defer";function B(e){if(e.localName===S){if(!e._activate)throw new Error("subtreeShown called before module ojs/ojdefer was loaded");e._activate()}}function T(e){return t=>{v.allowSlotRelocation(!0);try{e(t)}finally{v.allowSlotRelocation(!1)}}}function N(e,t,r){if((t||r)&&!function(e){let t=e;for(;t;){if(t.nodeType===Node.DOCUMENT_NODE)return!1;if(t.nodeType===Node.ELEMENT_NODE&&t.classList.contains(y))return!0;t=t.parentNode}return!0}(e)){n(e);const t=[".oj-component-initnode"];r&&t.push(S);const s=[];t.forEach(function(e){s.push(`.${y} ${e}`),s.push(`.${f} ${e}`)}),r&&s.push(`${S}.${y}`);const o=t.join(","),a=s.join(",");var i=function(e,t){const r=[];let i=0;for(var n=0;n<t.length;n++){for(var s=t[n];i<e.length&&e[i]!==s;)r.push(e[i]),i+=1;i+=1}for(;i<e.length;)r.push(e[i]),i+=1;return r}(e.querySelectorAll(o),e.querySelectorAll(a));i.forEach(e=>n(e))}function n(e){t?.(e),r?.(e)}}class k{constructor(e){this.dirtyProps=new Set,this._componentState=w.WaitingToCreate,this._outerClasses=new Set,this.Element=e}startCreationCycle(){this._isInErrorState()||(null!=this._preCreatedPromise&&this._componentState!==w.WaitingToCreate||this._updateComponentState(w.Creating),this._registerBusyState())}pauseCreationCycle(){this._resolveBusyState()}resetCreationCycle(){this._updateComponentState(w.WaitingToCreate),this._bindingProviderPromise=null,this._preCreatedPromise=null,this._createdPromise=null}isComplete(){return this._componentState===w.Complete}isCreating(){return this._componentState===w.Creating}isPostCreateCallbackOrComplete(){return this._componentState===w.PostCreateCallback||this.isComplete()}canHandleAttributes(){return!this._isInErrorState()&&this._componentState!==w.WaitingToCreate}beginApplyingBindings(){this.isComplete()||(this._bindingProviderType="knockout",this._updateComponentState(w.ApplyingBindings))}allowPropertySets(){return this._componentState===w.Creating||this._componentState===w.ApplyingBindings||this._componentState===w.BindingsApplied||this._componentState===w.PostCreateCallback||this._componentState===w.Complete}allowPropertyChangedEvents(){return this._componentState===w.BindingsApplied||this._componentState===w.PostCreateCallback||this._componentState===w.Complete}getTrackChildrenOption(){const e=r.getElementDescriptor(this.Element.tagName).metadata;return e?.extension?._TRACK_CHILDREN??"none"}setCreateCallback(e){this._isInErrorState()||(this._updateComponentState(w.WaitingForBindings),this._preCreatedPromise||(this._preCreatedPromise=this.GetPreCreatedPromise()),this._createdPromise=this._preCreatedPromise.then(()=>{if(!this._isInErrorState()){const t=e();return this._updateComponentState(w.PostCreateCallback),t}return Promise.reject()}),this._createdPromise.then(()=>{this._updateComponentState(w.Complete)},e=>{if(this._updateComponentState(w.Incomplete),e)throw e}))}setBindingsDisposedCallback(e){this._disposedCallback=e}resolveBindingProvider(e){this._bpClean=e.__CleanNode,this._resolveBindingProviderCallback&&(this._bindingsApplied(),this._resolveBindingProviderCallback(e),this._resolveBindingProviderCallback=null,this._rejectBindingProviderCallback=null),this._bindingProvider=e}rejectBindingProvider(e){this._rejectBindingProviderCallback&&(this._rejectBindingProviderCallback(e),this._resolveBindingProviderCallback=null,this._rejectBindingProviderCallback=null)}disposeBindingProvider(){this.isComplete()?this._disposedCallback?.():(this.rejectBindingProvider(),this._updateComponentState(w.BindingsDisposed))}setBindingProviderCallback(e){this._bindingProviderCallback=e}getBindingProviderPromise(){const e=this.getBindingProviderType();if(!this._bindingProviderPromise)if(s.verifyThemeVersion(),"none"===e||"preact"===e)this._bindingsApplied(),this._bindingProviderPromise=Promise.resolve(null);else{if("knockout"!==e)throw new c(this.Element,`Unknown binding provider '${e}'.`);this._bindingProvider?(this._bindingsApplied(),this._bindingProviderPromise=Promise.resolve(this._bindingProvider)):this._bindingProviderPromise=new Promise((e,t)=>{this._resolveBindingProviderCallback=e,this._rejectBindingProviderCallback=t})}return this._bindingProviderPromise}getBindingProvider(){return this._bindingProvider}getBindingProviderType(){return this._bindingProviderType||(this._bindingProviderType=k._walkBindingProviders(this.Element)),this._bindingProviderType}getUseKoFlag(){return void 0===this._useKoFlag&&(this._useKoFlag=k._findKoUseFlag(this.Element)),this._useKoFlag}getBindingProviderCleanNode(){return this._bpClean||k._NOOP}getDescriptiveText(){let e=this.GetDescriptiveValue("aria-label")||this.GetDescriptiveValue("title")||this.GetDescriptiveLabelByValue("labelled-by")||this.GetDescriptiveValue("label-hint")||this.GetDescriptiveLabelByValue("aria-labelledby");return e=e?e.trim().replace(/\s+/g," "):"",e}getSlotMap(e){return!this._slotMap&&e&&(this._slotMap=v.getSlotMap(this.Element)),this._slotMap}getSlotSet(){if(!this._slotSet){const e=Object.keys(this._slotMap);let t=[];e.forEach(e=>t=t.concat(this._slotMap[e])),this._slotSet=new Set(t)}return this._slotSet}setOuterClasses(e){this.PatchClasses(this._outerClasses,e),this._outerClasses=e}PatchClasses(e,t){e.forEach(e=>{t.has(e)||this.Element.classList.remove(e)}),t.forEach(t=>{e.has(t)||this.Element.classList.add(t)})}GetCreatedPromise(){return this._createdPromise}GetPreCreatedPromise(){let e=this.getBindingProviderPromise();return"none"!==this.getTrackChildrenOption()&&(e=e.then(e=>this._getTrackedChildrenPromises(e))),e}IsTransferAttribute(e){return!1}GetDescriptiveValue(e){const t=m.attributeToPropertyName(e),i=r.getElementProperties(this.Element);let n;return n=i&&i[t]?this.Element[t]:this.IsTransferAttribute(e)?this.GetDescriptiveTransferAttributeValue(e):this.Element.getAttribute(e),n}GetDescriptiveTransferAttributeValue(e){return""}GetDescriptiveLabelByValue(e){const t=this.GetDescriptiveValue(e);if(t){const e=document.getElementById(t);if(e)return e.textContent}return null}_updateComponentState(e){if(this._componentState!==w.BindingsDisposed){switch(e){case w.WaitingToCreate:this.Element.classList.remove("oj-complete"),this._createdPromise=null;break;case w.Complete:this.Element.classList.add("oj-complete"),this._resolveBusyState();break;case w.BindingsDisposed:case w.Incomplete:this.Element.classList.add("oj-incomplete"),this._resolveBusyState()}this._componentState=e}}_bindingsApplied(){this._updateComponentState(w.BindingsApplied),this._bindingProviderCallback?.()}_registerBusyState(){const e=i.getContext(this.Element).getBusyContext();if(this._resolveCreatedBusyState)throw new c(this.Element,"Registering busy state before previous state is resolved.");this._resolveCreatedBusyState=e.addBusyState({description:v.getElementInfo(this.Element)+" is being upgraded."})}_resolveBusyState(){this._resolveCreatedBusyState&&(this._resolveCreatedBusyState(),this._resolveCreatedBusyState=null)}static _findKoUseFlag(e){return!!e.querySelector(":scope > template[data-oj-use-ko]")}static _walkBindingProviders(e,t=e){let r=e[C];if(r)return r;if(r=e.getAttribute("data-oj-binding-provider"),!r){const i=e.parentElement;if(null==i){if(e!==document.documentElement)throw new c(t,"Cannot determine binding provider for a disconnected subtree.");r="knockout"}else r=i[b]??k._walkBindingProviders(i,t)}return e[C]=r,r}_getTrackedChildrenPromises(e){const t=this.getTrackChildrenOption(),s=i.getContext(this.Element).getBusyContext(),o=this._getChildrenToTrack(this.Element,t,[]).map(t=>{if(!e){const e=s.addBusyState({description:`Waiting for element ${t.localName} to be defined.`}),i=setInterval(()=>{n.warn(`Waiting for element ${t.localName} to be defined.`)},2e4);return customElements.whenDefined(t.localName).then(()=>(e(),clearInterval(i),r.isElementRegistered(t.tagName)?v.getElementState(t).GetCreatedPromise():null)).catch(r=>{throw e(),clearInterval(i),new Error(`Error defining element ${t.localName} : ${r}`)})}return r.isElementRegistered(t.tagName)?v.getElementState(t).GetCreatedPromise():null});return Promise.all(o)}_getChildrenToTrack(e,t,r){const i=e.childNodes;for(let e=0;e<i.length;e++){const n=i[e];a.isValidCustomElementName(n.localName)?r.push(n):"nearestCustomElement"===t&&this._getChildrenToTrack(n,t,r)}return r}_isInErrorState(){return this._componentState===w.Incomplete||this._componentState===w.BindingsDisposed}}var w;k._NOOP=()=>{},function(e){e[e.WaitingToCreate=0]="WaitingToCreate",e[e.Creating=1]="Creating",e[e.WaitingForBindings=2]="WaitingForBindings",e[e.ApplyingBindings=3]="ApplyingBindings",e[e.BindingsApplied=4]="BindingsApplied",e[e.PostCreateCallback=5]="PostCreateCallback",e[e.Complete=6]="Complete",e[e.Incomplete=7]="Incomplete",e[e.BindingsDisposed=8]="BindingsDisposed"}(w||(w={}));const A=Symbol("custom element null"),j=Symbol("custom element empty string"),O=Symbol("custom element undefined"),I="__oj_private_do_not_use_value",L="__oj_private_do_not_use_checked",$=new Map([["value",I],["checked",L]]),D=e=>e===A?null:e===j?"":e!==O&&""!==e?e:void 0,V=Symbol("ojBindConvertedNode");e.AttributeUtils=m,e.CACHED_BINDING_PROVIDER=C,e.CHILD_BINDING_PROVIDER=b,e.CustomElementUtils=v,e.ElementState=k,e.ElementUtils=a,e.JetElementError=c,e.LifecycleElementState=class extends k{constructor(){super(...arguments),this._connectCallbacks=[],this._disconnectCallbacks=[]}addLifecycleCallbacks(e,t){e&&this._connectCallbacks.push(e),t&&this._disconnectCallbacks.push(t)}removeLifecycleCallbacks(e,t){e&&(this._connectCallbacks=this._connectCallbacks.filter(t=>t!=e)),t&&(this._disconnectCallbacks=this._disconnectCallbacks.filter(e=>e!=t))}executeLifecycleCallbacks(e){(e?this._connectCallbacks:this._disconnectCallbacks).forEach(e=>e())}},e.OJ_BIND_CONVERTED_NODE=V,e.addPrivatePropGetterSetters=(e,t)=>{"value"!==t&&"checked"!==t||Object.defineProperty(e,$.get(t),{get(){return this[t]},set(e){this[t]=D(e)}})},e.convertPrivatePropFromPreact=(e,t)=>e===I?{prop:"value",value:D(t)}:e===L?{prop:"checked",value:D(t)}:{prop:e,value:t},e.publicToPrivateName=$,e.toSymbolizedValue=e=>null===e?A:""===e?j:void 0===e?O:e,e.transformPreactValue=(e,t,r,i)=>{let n=i;return"value"!==t&&"checked"!==t&&""===n&&(n=((e,t,r)=>{if((!e||"preact"===v.getElementState(e).getBindingProviderType())&&(!a.getSupportedTypes(t.type).string||t.enumValues))return;return r})(e,r,n)),n},Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=ojcustomelement-utils.js.map