/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["ojs/ojlogger","ojs/ojobservable","ojs/ojurlpathadapter"],function(t,e,r){"use strict";let o,i;r=r&&Object.prototype.hasOwnProperty.call(r,"default")?r.default:r;let s=[];var n=function(){let t=o;const e=[];for(;t;){let r=t._activeState;if(!r){r=t._getPendingState({path:""}),r&&e.push(r);break}e.push({path:r.path||"",params:r.params,pathParams:r.pathParams}),t=t.childRouter}return e};const a=/^{(\w+)}$/;function h(t){const e=t.match(a);if(e)return e[1];throw Error(`no path parameter found for segment ${t}`)}function u(t,s,n){if(s=s||{},this._name="/",this._urlOffset=0,this.beforeStateChange=new e.BehaviorSubject({accept:function(){}}),this.currentState=new e.BehaviorSubject({complete:function(){}}),this._noHistory="skip"===s.history,this._noHistoryOffset=0,this._parentRouter=n,n)this._name=n._name+n._activeState.path+"/",this._urlOffset=n._urlOffset+n._activeState.pathParams.length+1,n._noHistory&&(this._noHistoryOffset=n._noHistoryOffset+n._activeState.pathParams.length+1);else{if(o)throw Error("Only one root CoreRouter instance may exist at a time");o=this,i=s.urlAdapter||new r,this._setupNavigationListener()}this.childRouter=void 0,this._configure(t)}return u.prototype.reconfigure=function(t,e){const r=this._routes;let o=e||this._getActiveRoutes();return o&&!Array.isArray(o)&&(o=[o]),this._configure(t),this.go(...o).catch(t=>{throw this._configure(r),t})},u.prototype._configure=function(t=[]){this._routes=t.map(function(t){let e=t.path,r=[];if("string"==typeof e){const t=e.split("/");e=t.shift(),r=t.map(h)}const o={path:e,detail:t.detail||{},pathParams:r,redirect:t.redirect};let i=e;if("string"==typeof e)i=new RegExp("^"+e+"$");else if(!(e instanceof RegExp))throw Error("Router path must be a string or RegExp");return o._match=i,Object.freeze(o),o},this)},u.prototype.sync=function(){return this._execute(this._getRouteSegment()||{path:"",params:{}}).then(t=>{var e=t,r=this.childRouter;return r&&(e=r.sync()),e})},u.prototype._getRouteSegment=function(){let t;if(this._noHistory)t=s[this._noHistoryOffset];else{let e=i.getRoutesForUrl();t=e[this._urlOffset];const r=this._getRoutePathParams(t&&t.path);e=i.getRoutesForUrl({offset:this._urlOffset,pathParams:r}),t=e[this._urlOffset]}return t},u.prototype.go=function(...e){let r;if(e.forEach(function(t){var e=t.params;e&&Object.keys(e).forEach(function(t){"object"==typeof e[t]&&(r=Promise.reject('"params" object may only contain scalar values'))})}),!r){const o=e.map(t=>t.path).join("/");t.info(`Navigating router(${this._name}) to ${o}`);const a=i.getUrlForRoutes(n()),h=s;if(this._noHistory)t.info(`Navigating non-history tracking router(${this._name}) to ${o}`),s=s.slice(0,this._noHistoryOffset).concat(e);else{s=[];const t=this._getParentRoutes().concat(this._getPendingState(e[0]),e.slice(1)),r=i.getUrlForRoutes(t);a!==r&&window.history.pushState(null,"path",r)}r=this.sync().catch(t=>{throw this._noHistory?s=h:window.history.replaceState(null,"path",a),t})}return r},u.prototype._execute=function(t){const e=this._getPendingState(t);let r;return e?(r=this._prepublish(e),this._isCurrentState(e)||(r=r.then(()=>this._publish(e)))):r=Promise.reject(`Router(${this._name}) has no state matching "${t.path}"`),r},u.prototype._prepublish=function(t){if(!this.beforeStateChange)throw Error(`Router(${this._name}) has already been destroyed`);let e=[];this.beforeStateChange.next({state:t,accept:function(t){e.push(t)}});let r=Promise.all(e).then(()=>t);return this.childRouter&&(r=r.then(()=>this.childRouter._prepublish(t))),r=r.then(t=>r!==this._activeSync?Promise.reject("sync overridden"):t),this._activeSync=r,r},u.prototype._publish=function(t){var e=[];return this.childRouter=null,this._activeState=t,this.currentState.next({state:t,complete:function(t){e.push(t)}}),Promise.all(e).then(()=>t)},u.prototype._setupNavigationListener=function(){this===o&&(this._popstateHandler=()=>this.sync(),window.addEventListener("popstate",this._popstateHandler,!1))},u.prototype._isCurrentState=function(t){var e,r,o=this._activeState;return!!o&&(e=o,r=t,i.getUrlForRoutes([e])===i.getUrlForRoutes([r]))},u.prototype._getPendingState=function(t){var e,r=t.path,o=t.params||{};let i=this._routes.find(t=>t._match.test(r));return i&&i.redirect&&(r=i.redirect,i=this._getPendingState({path:r,params:o})),i&&(e={path:r,params:o,detail:i.detail,pathParams:i.pathParams,redirect:i.redirect,_match:i._match},Object.freeze(e)),e},u.prototype._getRoutePathParams=function(t=""){const e=this._getPendingState({path:t});return e?e.pathParams:[]},u.prototype._getParentRoutes=function(){return n().slice(0,this._urlOffset)},u.prototype._getActiveRoutes=function(){return n().slice(this._urlOffset)},u.prototype.createChildRouter=function(t,e={}){this._noHistory&&(e.history="skip");const r=this._activeState;if(!r)throw Error(`Router(${this._name}) has no current state. Call sync() on the router first.`);if(this.childRouter&&"skip"!==e.history)throw Error(`Router(${this._name}) state(${r.path}) already has a child router`);const o=new u(t,e,this);return this.childRouter=o,o},u.prototype.destroy=function(){this.childRouter&&this.childRouter.destroy(),console.debug(`destroying Router(${this._name})`),this.beforeStateChange=null,this.currentState=null,this._parentRouter.childRouter=null,this===o&&(window.removeEventListener("popstate",this._popstateHandler,!1),o=null)},u});
//# sourceMappingURL=ojcorerouter.js.map