/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(["exports","ojs/ojconverterutils-i18n","ojs/ojconverter","ojs/ojlocaledata","ojs/ojconverter-nativedatetime","ojs/ojconfig","ojs/ojcore-base","ojs/ojconverter-preferences","ojs/ojavailabletimezones","ojs/ojconverter-datetimeerror"],function(t,e,o,r,n,i,a,s,u,l){"use strict";o=o&&Object.prototype.hasOwnProperty.call(o,"default")?o.default:o,a=a&&Object.prototype.hasOwnProperty.call(a,"default")?a.default:a;const c=function(t){this.Init(t)};oj.Object.createSubclass(c,o,"oj.DateTimeConverter"),c.prototype.Init=function(t){c.superclass.Init.call(this,t)},c.prototype.format=function(t){return c.superclass.format.call(this,t)},c.prototype.isHourInDaySet=function(){oj.Assert.failedInAbstractFunction()},c.prototype.isHourInAMPMSet=function(){oj.Assert.failedInAbstractFunction()},c.prototype.isMinuteSet=function(){oj.Assert.failedInAbstractFunction()},c.prototype.isSecondSet=function(){oj.Assert.failedInAbstractFunction()},c.prototype.isMilliSecondSet=function(){oj.Assert.failedInAbstractFunction()},c.prototype.isYearSet=function(){oj.Assert.failedInAbstractFunction()},c.prototype.isMonthSet=function(){oj.Assert.failedInAbstractFunction()},c.prototype.isDaySet=function(){oj.Assert.failedInAbstractFunction()},c.prototype.isDayNameSet=function(){oj.Assert.failedInAbstractFunction()},c.prototype.calculateWeek=function(t){oj.Assert.failedInAbstractFunction()},c.prototype.parse=function(t){return c.superclass.parse.call(this,t)},c.prototype.compareISODates=function(t,e){return c.superclass.compareISODates.call(this,t,e)},c.prototype.getAvailableTimeZones=function(){return c.superclass.getAvailableTimeZones.call(this)};const p=function(){var t,o={s:46,m:46,h:23,d:7,w:4,M:12},a="local",s="zulu",u="offset";function l(t,e){return t.getFullYear()===e.getFullYear()}function c(t,e){return e.getFullYear()-t.getFullYear()==1}function p(t,e){return l(t,e)&&t.getMonth()===e.getMonth()}function m(t,e){return l(t,e)?e.getMonth()-t.getMonth()==1:!!c(t,e)&&(11===t.getMonth()&&0===e.getMonth())}function d(t,o){var r=t.getDate(),n=o.getDate();return m(t,o)&&(n+=e.OraI18nUtils._getDaysInMonth(t.getFullYear(),t.getMonth())),n-r}function f(t,o){var r=t._ojLocale_,n=e.OraI18nUtils.getBCP47Region(r),i=t.supplemental.weekData.firstDay,a=i[n];void 0===a&&(a=i["001"]);var s=o-a;return s<0&&(s+=7),s}function y(t,e,o){if(!p(e,o)&&!m(e,o))return!1;var r=d(e,o)+f(t,e.getDay());return r>=7&&r<=13}function h(t,e){return l(t,e)&&p(t,e)&&t.getDate()===e.getDate()}function v(t,e){return!(!p(t,e)&&!m(t,e))&&1===d(t,e)}function O(t,e){return v(e,t)}function g(t){var e=function(t){return 4800*t/146097}(t/864e5),o=e/12;return{year:Math.round(o),month:Math.round(e),week:Math.round(t/6048e5),day:Math.round(t/864e5),hour:Math.round(t/36e5),minute:Math.round(t/6e4),second:Math.round(t/1e3),millisecond:t}}function I(t,o,r){var n=e.OraI18nUtils._IsoStrParts(t),i=e.OraI18nUtils._IsoStrParts(o);return r?(n=Date.UTC(n[0],n[1]-1,n[2],0,0,0,0),i=Date.UTC(i[0],i[1]-1,i[2],0,0,0,0)):(n=Date.UTC(n[0],n[1]-1,n[2],n[3],n[4],n[5],n[6]),i=Date.UTC(i[0],i[1]-1,i[2],i[3],i[4],i[5],i[6])),n-i}function D(t,e){return new Intl.DateTimeFormat(i.getLocale(),e).format(t)}function S(t,o,r){var i=o.timeZone,l=e.OraI18nUtils.getISOStrFormatInfo(t).format;if(l===u||l===s){var c=new Date(t);return e.OraI18nUtils.dateToLocalIso(c)}return l===a&&!i?t:function(t,o,r){var i={isoStrFormat:"zulu",timeZone:o.timeZone},a=n.NativeParserImpl.parseImpl(t,null,i,r),s=new Date(a.value);return e.OraI18nUtils.dateToLocalIso(s)}(t,o,r)}function w(t,o,r){var n,a,s,u,l=[],c=e.OraI18nUtils.isoToLocalDate(o),p=e.OraI18nUtils.isoToLocalDate(t),m=i.getLocale();if(h(p,c))l=[0,"day","auto"],n=new Intl.RelativeTimeFormat(m,{numeric:l[2]}).format(l[0],l[1]);else if(v(p,c))l=[1,"day","auto"],n=new Intl.RelativeTimeFormat(m,{numeric:l[2]}).format(l[0],l[1]);else if(O(p,c))l=[-1,"day","auto"],n=new Intl.RelativeTimeFormat(m,{numeric:l[2]}).format(l[0],l[1]);else{var d=I(o,t,!0);if(!((d/=864e5)>1&&d<7))return D(c,{year:"numeric",month:"numeric",day:"numeric"});n=D(c,{weekday:"long"})}return r?n:(a=D(c,{hour:"numeric",minute:"numeric"}),n+(s=new Intl.DateTimeFormat(i.getLocale(),{dateStyle:"long",timeStyle:"short"}).formatToParts(new Date),u=s.findIndex(t=>"hour"===t.type)-1,s[u]?s[u].value:" ")+a)}function T(t,o,r,n){var a=e.OraI18nUtils.getGetOption(r,"OraDateTimeConverter.formatRelative")("dateField","string",["day","week","month","year","hour","minute","second"]),s=e.OraI18nUtils.isoToLocalDate(t),u=e.OraI18nUtils.isoToLocalDate(o),D=I(o,t,!1),S=g(Math.abs(D)),w=[];switch(a){case"day":w=h(s,u)?[0,"day","auto"]:v(s,u)?[1,"day","auto"]:O(s,u)?[-1,"day","auto"]:[D>0?S.day:-S.day,"day","always"];break;case"week":w=function(t,e,o){if(e>o){var r=e;e=o,o=r}if(!p(e,o)&&!m(e,o))return!1;var n=d(e,o)+f(t,e.getDay());return n>=0&&n<=6}(n,s,u)?[0,"week","auto"]:y(n,s,u)?[1,"week","auto"]:function(t,e,o){return y(t,o,e)}(n,s,u)?[-1,"week","auto"]:[D>0?S.week:-S.week,"week","always"];break;case"month":p(s,u)?w=[0,"month","auto"]:m(s,u)?w=[1,"month","auto"]:w=m(u,s)?[-1,"month","auto"]:[D>0?S.month:-S.month,"month","always"];break;case"year":w=l(s,u)?[0,"year","auto"]:c(s,u)?[1,"year","auto"]:function(t,e){return c(e,t)}(s,u)?[-1,"year","auto"]:[D>0?S.year:-S.year,"year","always"];break;case"hour":w=[D>0?S.hour:-S.hour,"hour","auto"];break;case"minute":w=[D>0?S.minute:-S.minute,"minute","auto"];break;case"second":w=[D>0?S.second:-S.second,"second","auto"]}return new Intl.RelativeTimeFormat(i.getLocale(),{numeric:w[2]}).format(w[0],w[1])}function _(t,r,n){var a=e.OraI18nUtils.dateToLocalIso(new Date);if("number"==typeof t)t=e.OraI18nUtils.dateToLocalIso(new Date(t));else{if("string"!=typeof t)return null;if(""===e.OraI18nUtils.trim(t))return null}void 0===n&&(n={formatUsing:"displayName"});var s=e.OraI18nUtils.getGetOption(n,"OraDateTimeConverter.formatRelative"),u=s("relativeTime","string",["fromNow","toNow"],"fromNow"),l=s("dateField","string",["day","week","month","year","hour","minute","second"]);if(t=S(t,n,r),"toNow"===u){var c=a;a=t,t=c}return"calendar"===s("formatUsing","string",["displayName","calendar"],"displayName")?w(a,t,s("dateOnly","boolean",[!0,!1],!1)):void 0!==l?T(a,t,n,r):function(t,e,r,n){var a=I(e,t,!1),s=g(Math.abs(a));null===r&&(r=(s.second<o.s?"second":s.minute<o.m&&"minute")||s.hour<o.h&&"hour"||s.day<o.d&&"day"||s.week<o.w&&"week"||s.month<o.M&&"month"||"year");var u=new Intl.RelativeTimeFormat(i.getLocale(),{numeric:n}),l=a>=0?s[r]:-s[r];return u.format(l,r)}(a,t,null,"auto")}return{getInstance:function(){return t||(t={formatRelative:function(t,e){return _(t,r.__getBundle(),e)}}),t}}}(),m=e.IntlConverterUtils,d=function(t){let e=t?d.mapOptions(t):null;const o=s.getMergedDateTimePreferencesWithOptions(e),r=0===Object.keys(o).length?{year:"numeric",month:"numeric",day:"numeric"}:o;this.Init(r)};a.Object.createSubclass(d,c,"oj.IntlDateTimeConverter"),d._DEFAULT_DATE=new Date(1998,10,29,15,45,31),d.prototype.Init=function(t){d.superclass.Init.call(this,t),this._initConverter()},d.prototype._getWrapped=function(){return this._wrapped},d.prototype._initConverter=function(){var t=this.getOptions();t.numberingSystem="latn",t.calendar="gregory",t.pattern?this._wrapped=new n.NativeDateTimePatternConverter(t):this._wrapped=new n.NativeDateTimeConverter(t)},d.prototype.format=function(t){if(null==t||"string"==typeof t&&0===a.StringUtils.trim(""+t).length)return"";let o=t;if("number"==typeof t)o=e.OraI18nUtils.dateToLocalIso(new Date(t));else{if("string"!=typeof t)return null;o=e.OraI18nUtils.trim(t)}try{return this._getWrapped().format(o)}catch(t){throw this._processConverterError(t)}},d.prototype.formatRelative=function(t,e){return p.getInstance().formatRelative(t,e)},d.prototype.getHint=function(){return null},d.prototype.getOptions=function(){return d.superclass.getOptions.call(this)},d.prototype.resolvedOptions=function(){if(!this._resolvedOptions){const t=this._getWrapped().resolvedOptions();this._resolvedOptions={};const e=Object.keys(t);let o=0;for(o=0;o<e.length;o++){const r=e[o];"timeStyle"===r?this._resolvedOptions.timeFormat=t[r]:"dateStyle"===r?this._resolvedOptions.dateFormat=t[r]:"fractionalSecondDigits"===r?this._resolvedOptions.millisecond="numeric":"twoDigitYearStart"===r?this._resolvedOptions["two-digit-year-start"]=t[r]:this._resolvedOptions[r]=t[r]}this._resolvedOptions.dateFormat&&this._resolvedOptions.timeFormat?this._resolvedOptions.formatType="datetime":this._resolvedOptions.dateFormat?this._resolvedOptions.formatType="date":this._resolvedOptions.timeFormat&&(this._resolvedOptions.formatType="time");const r=["hour","minute","second","millisecond","day","month","year","weekday","timeZoneName","dayPeriod"];if(this._resolvedOptions.dateFormat||this._resolvedOptions.timeFormat){const t=Object.keys(this._resolvedOptions);r.forEach(e=>{t.includes(e)&&delete this._resolvedOptions[e]})}}return this._resolvedOptions},d.prototype.isHourInDaySet=function(){var t=this.resolvedOptions(),e=t.hour,o=t.hour12;return!(!e||o)},d.prototype.isHourInAMPMSet=function(){var t=this.resolvedOptions(),e=t.hour,o=t.hour12;return!(!e||!o)},d.prototype.isMinuteSet=function(){return this._isOptionSet("minute")},d.prototype.isSecondSet=function(){return this._isOptionSet("second")},d.prototype.isMilliSecondSet=function(){return this._isOptionSet("millisecond")},d.prototype.isYearSet=function(){return this._isOptionSet("year")},d.prototype.isMonthSet=function(){return this._isOptionSet("month")},d.prototype.isDaySet=function(){return this._isOptionSet("day")},d.prototype.isDayNameSet=function(){return this._isOptionSet("weekday")},d.prototype.calculateWeek=function(t){var o,r=e.OraI18nUtils._IsoStrParts(t),n=new Date(Date.UTC(r[0],r[1]-1,r[2]));return n.setUTCDate(n.getUTCDate()+4-(n.getUTCDay()||7)),o=n.getTime(),n.setUTCMonth(0),n.setUTCDate(1),Math.floor(Math.round((o-n)/864e5)/7)+1},d.prototype.parse=function(t){if(null===t||""===t||void 0===t)return null;var o,r=this._wrapped.resOptions.isoStrFormat,n=this._wrapped.resOptions.timeZone,i="";if(e.OraI18nUtils._ISO_DATE_REGEXP.test(t)&&(-1!==(i=t.substring(t.indexOf("T"))).indexOf("Z")&&!n))return t;try{o=this._getWrapped().parse(t)}catch(t){throw this._processConverterError(t)}var a=-1===(i=o.substring(o.indexOf("T"))).indexOf("Z")&&-1===i.indexOf("+")&&-1===i.indexOf("-");return!n&&r&&a&&(o=e.OraI18nUtils.convertISOString(o,r)),o},d.prototype.compareISODates=function(t,o){const r=new Date,n=r.getMonth()+1;let i=e.OraI18nUtils.zeroPad(n.toString(),2,!0);const a=r.getDate();let s=e.OraI18nUtils.zeroPad(a.toString(),2,!0);const u=r.getFullYear()+"-"+i+"-"+s;let l=t,c=o;const p=0===l.indexOf("T"),m=0===c.indexOf("T"),d=-1===l.indexOf("T"),f=-1===c.indexOf("T"),y="T00:00:00";p?l=u+l:d&&(l+=y),m?c=u+c:f&&(c+=y);const h=new Date(l),v=new Date(c);return h.getTime()-v.getTime()},d.prototype._processConverterError=function(t){const{summary:e,detail:o}=l._processConverterError(t,this.format.bind(this),"datetime");return m.__getConverterError(e,o)},d.prototype._isOptionSet=function(t){return!!this.resolvedOptions()[t]},d.prototype.getAvailableTimeZones=function(){return u.AvailableTimeZones.getAvailableTimeZonesImpl()},d.isECMAOptionSet=function(t){return t.year||t.month||t.day||t.weekday||t.hour||t.minute||t.second||t.millisecond||t.dayPeriod||t.timeZoneName},d.mapOptions=function(t){let e={};const o=Object.keys(t);let r=0;var n=d.isECMAOptionSet(t);for(o.includes("formatType")||!t.dateFormat&&!t.timeFormat||n||(e.dateStyle=t.dateFormat||"short"),r=0;r<o.length;r++){const i=o[r];"formatType"!==i||n?"millisecond"===i?e.fractionalSecondDigits=3:"two-digit-year-start"===i?e.twoDigitYearStart=t[i]:e[i]=t[i]:("datetime"!==t[i]&&"date"!==t[i]||(e.dateStyle=t.dateFormat||"short"),"datetime"!==t[i]&&"time"!==t[i]||(e.timeStyle=t.timeFormat||"short"))}return e},t.DateTimeConverter=c,t.IntlDateTimeConverter=d,t.RelativeDateTimeFormatter=p,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=ojconverter-datetime.js.map