/**
 * @license
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates.
 * Licensed under The Universal Permissive License (UPL), Version 1.0
 * as shown at https://oss.oracle.com/licenses/upl/
 * @ignore
 */
define(['require', 'touchr', 'ojs/ojdatasource-common', 'ojs/ojdatacollection-utils', 'ojs/ojinputnumber', 'ojs/ojmenu', 'ojs/ojmenuselectmany', 'ojs/ojdialog', 'ojs/ojbutton', 'ojdnd', 'ojs/ojcore-base', '@oracle/oraclejet-preact/hooks/UNSAFE_useFormVariantContext', 'ojs/ojcomponentcore', 'ojs/ojcontext', 'ojs/ojdatacollection-common', 'ojs/ojdomutils', 'ojs/ojconfig', 'ojs/ojcustomelement-utils', 'ojs/ojkeyboardfocus-utils', 'jquery', 'ojs/ojlogger', 'ojs/ojthemeutils', 'ojs/ojtranslationbundleutils'], function (require, touchr, ojdatasourceCommon, ojdatacollectionUtils, ojinputnumber, ojmenu, ojmenuselectmany, ojdialog, ojbutton, ojdnd, oj, UNSAFE_useFormVariantContext, Components, Context, DataCollectionUtils, DomUtils, ojconfig, ojcustomelementUtils, ojkeyboardfocusUtils, $, ojlogger, ThemeUtils, ojtranslationbundleutils) { 'use strict';

  function _interopNamespace(e) {
    if (e && e.__esModule) { return e; } else {
      var n = {};
      if (e) {
        Object.keys(e).forEach(function (k) {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () {
              return e[k];
            }
          });
        });
      }
      n['default'] = e;
      return n;
    }
  }

  oj = oj && Object.prototype.hasOwnProperty.call(oj, 'default') ? oj['default'] : oj;
  Context = Context && Object.prototype.hasOwnProperty.call(Context, 'default') ? Context['default'] : Context;
  $ = $ && Object.prototype.hasOwnProperty.call($, 'default') ? $['default'] : $;

  // eslint-disable-next-line wrap-iife
  (function () {
var __oj_data_grid_metadata = 
{
  "properties": {
    "bandingInterval": {
      "type": "object",
      "properties": {
        "column": {
          "type": "number",
          "value": 0
        },
        "row": {
          "type": "number",
          "value": 0
        }
      }
    },
    "cell": {
      "type": "object",
      "properties": {
        "alignment": {
          "type": "object",
          "properties": {
            "horizontal": {
              "type": "function|string",
              "value": "auto"
            },
            "vertical": {
              "type": "function|string",
              "value": "auto"
            }
          }
        },
        "className": {
          "type": "function|string"
        },
        "editable": {
          "type": "function|string",
          "enumValues": [
            "disable",
            "enable"
          ],
          "value": "enable"
        },
        "renderer": {
          "type": "function"
        },
        "style": {
          "type": "function|string"
        }
      }
    },
    "currentCell": {
      "type": "object",
      "writeback": true
    },
    "data": {
      "type": "DataGridProvider",
      "extension": {
        "webelement": {
          "exceptionStatus": [
            {
              "type": "unsupported",
              "since": "13.0.0",
              "description": "Data sets from a DataProvider cannot be sent to WebDriverJS; use ViewModels or page variables instead."
            }
          ]
        }
      }
    },
    "dataTransferOptions": {
      "type": "object",
      "properties": {
        "copy": {
          "type": "string",
          "enumValues": [
            "disable",
            "enable"
          ],
          "value": "disable"
        },
        "cut": {
          "type": "string",
          "enumValues": [
            "disable",
            "enable"
          ],
          "value": "disable"
        },
        "fill": {
          "type": "string",
          "enumValues": [
            "disable",
            "enable"
          ],
          "value": "disable"
        },
        "headerLabelCut": {
          "type": "string",
          "enumValues": [
            "disable",
            "enable"
          ],
          "value": "disable"
        },
        "paste": {
          "type": "string",
          "enumValues": [
            "disable",
            "enable"
          ],
          "value": "disable"
        }
      }
    },
    "dnd": {
      "type": "object",
      "properties": {
        "drag": {
          "type": "object",
          "properties": {
            "columnEndLabels": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "drag": {
                  "type": "function"
                },
                "dragEnd": {
                  "type": "function"
                },
                "dragStart": {
                  "type": "function"
                }
              }
            },
            "columnLabels": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "drag": {
                  "type": "function"
                },
                "dragEnd": {
                  "type": "function"
                },
                "dragStart": {
                  "type": "function"
                }
              }
            },
            "columns": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "drag": {
                  "type": "function"
                },
                "dragEnd": {
                  "type": "function"
                },
                "dragStart": {
                  "type": "function"
                }
              }
            },
            "rowEndLabels": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "drag": {
                  "type": "function"
                },
                "dragEnd": {
                  "type": "function"
                },
                "dragStart": {
                  "type": "function"
                }
              }
            },
            "rowLabels": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "drag": {
                  "type": "function"
                },
                "dragEnd": {
                  "type": "function"
                },
                "dragStart": {
                  "type": "function"
                }
              }
            },
            "rows": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "drag": {
                  "type": "function"
                },
                "dragEnd": {
                  "type": "function"
                },
                "dragStart": {
                  "type": "function"
                }
              }
            }
          }
        },
        "drop": {
          "type": "object",
          "properties": {
            "columnEndLabels": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "dragEnter": {
                  "type": "function"
                },
                "dragLeave": {
                  "type": "function"
                },
                "dragOver": {
                  "type": "function"
                },
                "drop": {
                  "type": "function"
                }
              }
            },
            "columnLabels": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "dragEnter": {
                  "type": "function"
                },
                "dragLeave": {
                  "type": "function"
                },
                "dragOver": {
                  "type": "function"
                },
                "drop": {
                  "type": "function"
                }
              }
            },
            "columns": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "dragEnter": {
                  "type": "function"
                },
                "dragLeave": {
                  "type": "function"
                },
                "dragOver": {
                  "type": "function"
                },
                "drop": {
                  "type": "function"
                }
              }
            },
            "rowEndLabels": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "dragEnter": {
                  "type": "function"
                },
                "dragLeave": {
                  "type": "function"
                },
                "dragOver": {
                  "type": "function"
                },
                "drop": {
                  "type": "function"
                }
              }
            },
            "rowLabels": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "dragEnter": {
                  "type": "function"
                },
                "dragLeave": {
                  "type": "function"
                },
                "dragOver": {
                  "type": "function"
                },
                "drop": {
                  "type": "function"
                }
              }
            },
            "rows": {
              "type": "object",
              "properties": {
                "dataTypes": {
                  "type": "string|Array<string>"
                },
                "dragEnter": {
                  "type": "function"
                },
                "dragLeave": {
                  "type": "function"
                },
                "dragOver": {
                  "type": "function"
                },
                "drop": {
                  "type": "function"
                }
              }
            }
          }
        },
        "reorder": {
          "type": "object",
          "properties": {
            "row": {
              "type": "string",
              "enumValues": [
                "disable",
                "enable"
              ],
              "value": "disable"
            }
          }
        }
      }
    },
    "editMode": {
      "type": "string",
      "writeback": true,
      "enumValues": [
        "cellEdit",
        "cellNavigation",
        "none"
      ],
      "value": "none"
    },
    "frozenColumnCount": {
      "type": "number",
      "writeback": true,
      "value": 0
    },
    "frozenRowCount": {
      "type": "number",
      "writeback": true,
      "value": 0
    },
    "gridlines": {
      "type": "object",
      "properties": {
        "horizontal": {
          "type": "string",
          "enumValues": [
            "hidden",
            "visible"
          ],
          "value": "visible"
        },
        "vertical": {
          "type": "string",
          "enumValues": [
            "hidden",
            "visible"
          ],
          "value": "visible"
        }
      }
    },
    "header": {
      "type": "object",
      "properties": {
        "column": {
          "type": "object",
          "properties": {
            "alignment": {
              "type": "object",
              "properties": {
                "horizontal": {
                  "type": "function|string",
                  "value": "auto"
                },
                "vertical": {
                  "type": "function|string",
                  "value": "auto"
                }
              }
            },
            "className": {
              "type": "function|string"
            },
            "filterable": {
              "type": "function|string",
              "enumValues": [
                "auto",
                "disable"
              ],
              "value": "disable"
            },
            "freezable": {
              "type": "string",
              "enumValues": [
                "disable",
                "enable"
              ],
              "value": "disable"
            },
            "hidable": {
              "type": "string",
              "value": "disable"
            },
            "label": {
              "type": "object",
              "properties": {
                "alignment": {
                  "type": "object",
                  "properties": {
                    "horizontal": {
                      "type": "function|string",
                      "value": "auto"
                    },
                    "vertical": {
                      "type": "function|string",
                      "value": "auto"
                    }
                  }
                },
                "className": {
                  "type": "function|string"
                },
                "renderer": {
                  "type": "function"
                },
                "sortable": {
                  "type": "function|string",
                  "enumValues": [
                    "auto",
                    "disable"
                  ],
                  "value": "disable"
                },
                "style": {
                  "type": "function|string"
                }
              }
            },
            "renderer": {
              "type": "function"
            },
            "resizable": {
              "type": "object",
              "properties": {
                "height": {
                  "type": "string",
                  "enumValues": [
                    "disable",
                    "enable"
                  ],
                  "value": "disable"
                },
                "width": {
                  "type": "string|function",
                  "enumValues": [
                    "disable",
                    "enable"
                  ],
                  "value": "disable"
                }
              }
            },
            "sortable": {
              "type": "function|string",
              "enumValues": [
                "auto",
                "disable",
                "enable"
              ],
              "value": "auto"
            },
            "style": {
              "type": "function|string"
            }
          }
        },
        "columnEnd": {
          "type": "object",
          "properties": {
            "alignment": {
              "type": "object",
              "properties": {
                "horizontal": {
                  "type": "function|string",
                  "value": "auto"
                },
                "vertical": {
                  "type": "function|string",
                  "value": "auto"
                }
              }
            },
            "className": {
              "type": "function|string"
            },
            "label": {
              "type": "object",
              "properties": {
                "alignment": {
                  "type": "object",
                  "properties": {
                    "horizontal": {
                      "type": "function|string",
                      "value": "auto"
                    },
                    "vertical": {
                      "type": "function|string",
                      "value": "auto"
                    }
                  }
                },
                "className": {
                  "type": "function|string"
                },
                "renderer": {
                  "type": "function"
                },
                "sortable": {
                  "type": "function|string",
                  "enumValues": [
                    "auto",
                    "disable"
                  ],
                  "value": "disable"
                },
                "style": {
                  "type": "function|string"
                }
              }
            },
            "renderer": {
              "type": "function"
            },
            "resizable": {
              "type": "object",
              "properties": {
                "height": {
                  "type": "string",
                  "enumValues": [
                    "disable",
                    "enable"
                  ],
                  "value": "disable"
                },
                "width": {
                  "type": "string|function",
                  "enumValues": [
                    "disable",
                    "enable"
                  ],
                  "value": "disable"
                }
              }
            },
            "style": {
              "type": "function|string"
            }
          }
        },
        "row": {
          "type": "object",
          "properties": {
            "alignment": {
              "type": "object",
              "properties": {
                "horizontal": {
                  "type": "function|string",
                  "value": "auto"
                },
                "vertical": {
                  "type": "function|string",
                  "value": "auto"
                }
              }
            },
            "className": {
              "type": "function|string"
            },
            "freezable": {
              "type": "string",
              "enumValues": [
                "disable",
                "enable"
              ],
              "value": "disable"
            },
            "hidable": {
              "type": "string",
              "value": "disable"
            },
            "label": {
              "type": "object",
              "properties": {
                "alignment": {
                  "type": "object",
                  "properties": {
                    "horizontal": {
                      "type": "function|string",
                      "value": "auto"
                    },
                    "vertical": {
                      "type": "function|string",
                      "value": "auto"
                    }
                  }
                },
                "className": {
                  "type": "function|string"
                },
                "renderer": {
                  "type": "function"
                },
                "sortable": {
                  "type": "function|string",
                  "enumValues": [
                    "auto",
                    "disable"
                  ],
                  "value": "disable"
                },
                "style": {
                  "type": "function|string"
                }
              }
            },
            "renderer": {
              "type": "function"
            },
            "resizable": {
              "type": "object",
              "properties": {
                "height": {
                  "type": "string|function",
                  "enumValues": [
                    "disable",
                    "enable"
                  ],
                  "value": "disable"
                },
                "width": {
                  "type": "string",
                  "enumValues": [
                    "disable",
                    "enable"
                  ],
                  "value": "disable"
                }
              }
            },
            "sortable": {
              "type": "function|string",
              "enumValues": [
                "auto",
                "disable",
                "enable"
              ],
              "value": "auto"
            },
            "style": {
              "type": "function|string"
            }
          }
        },
        "rowEnd": {
          "type": "object",
          "properties": {
            "alignment": {
              "type": "object",
              "properties": {
                "horizontal": {
                  "type": "function|string",
                  "value": "auto"
                },
                "vertical": {
                  "type": "function|string",
                  "value": "auto"
                }
              }
            },
            "className": {
              "type": "function|string"
            },
            "label": {
              "type": "object",
              "properties": {
                "alignment": {
                  "type": "object",
                  "properties": {
                    "horizontal": {
                      "type": "function|string",
                      "value": "auto"
                    },
                    "vertical": {
                      "type": "function|string",
                      "value": "auto"
                    }
                  }
                },
                "className": {
                  "type": "function|string"
                },
                "renderer": {
                  "type": "function"
                },
                "sortable": {
                  "type": "function|string",
                  "enumValues": [
                    "auto",
                    "disable"
                  ],
                  "value": "disable"
                },
                "style": {
                  "type": "function|string"
                }
              }
            },
            "renderer": {
              "type": "function"
            },
            "resizable": {
              "type": "object",
              "properties": {
                "height": {
                  "type": "string|function",
                  "enumValues": [
                    "disable",
                    "enable"
                  ],
                  "value": "disable"
                },
                "width": {
                  "type": "string",
                  "enumValues": [
                    "disable",
                    "enable"
                  ],
                  "value": "disable"
                }
              }
            },
            "style": {
              "type": "function|string"
            }
          }
        }
      }
    },
    "hiddenColumns": {
      "type": "object",
      "writeback": true
    },
    "hiddenRows": {
      "type": "object",
      "writeback": true
    },
    "scrollPolicy": {
      "type": "string",
      "enumValues": [
        "auto",
        "loadMoreOnScroll",
        "scroll"
      ],
      "value": "auto"
    },
    "scrollPolicyOptions": {
      "type": "object",
      "properties": {
        "maxColumnCount": {
          "type": "number",
          "value": 500
        },
        "maxRowCount": {
          "type": "number",
          "value": 500
        }
      }
    },
    "scrollPosition": {
      "type": "object",
      "writeback": true,
      "value": {
        "x": 0,
        "y": 0
      },
      "properties": {
        "columnIndex": {
          "type": "number"
        },
        "columnKey": {
          "type": "any"
        },
        "offsetX": {
          "type": "number"
        },
        "offsetY": {
          "type": "number"
        },
        "rowIndex": {
          "type": "number"
        },
        "rowKey": {
          "type": "any"
        },
        "x": {
          "type": "number"
        },
        "y": {
          "type": "number"
        }
      }
    },
    "scrollToKey": {
      "type": "string",
      "enumValues": [
        "always",
        "auto",
        "capability",
        "never"
      ],
      "value": "auto"
    },
    "selection": {
      "type": "Array<Object>",
      "writeback": true,
      "value": []
    },
    "selectionMode": {
      "type": "object",
      "properties": {
        "cell": {
          "type": "string",
          "enumValues": [
            "multiple",
            "none",
            "single"
          ],
          "value": "none"
        },
        "row": {
          "type": "string",
          "enumValues": [
            "multiple",
            "none",
            "single"
          ],
          "value": "none"
        }
      }
    },
    "translations": {
      "type": "object",
      "value": {},
      "properties": {
        "accessibleActionableMode": {
          "type": "string"
        },
        "accessibleCollapsed": {
          "type": "string"
        },
        "accessibleColumnContext": {
          "type": "string"
        },
        "accessibleColumnEndHeaderContext": {
          "type": "string"
        },
        "accessibleColumnEndHeaderLabelContext": {
          "type": "string"
        },
        "accessibleColumnHeaderContext": {
          "type": "string"
        },
        "accessibleColumnHeaderLabelContext": {
          "type": "string"
        },
        "accessibleColumnHierarchicalFull": {
          "type": "string"
        },
        "accessibleColumnHierarchicalPartial": {
          "type": "string"
        },
        "accessibleColumnHierarchicalUnknown": {
          "type": "string"
        },
        "accessibleColumnSelected": {
          "type": "string"
        },
        "accessibleColumnSpanContext": {
          "type": "string"
        },
        "accessibleContainsControls": {
          "type": "string"
        },
        "accessibleExpanded": {
          "type": "string"
        },
        "accessibleFirstColumn": {
          "type": "string"
        },
        "accessibleFirstRow": {
          "type": "string"
        },
        "accessibleLastColumn": {
          "type": "string"
        },
        "accessibleLastRow": {
          "type": "string"
        },
        "accessibleLevelContext": {
          "type": "string"
        },
        "accessibleLevelHierarchicalContext": {
          "type": "string"
        },
        "accessibleMultiCellSelected": {
          "type": "string"
        },
        "accessibleNavigationMode": {
          "type": "string"
        },
        "accessibleRangeSelectModeOff": {
          "type": "string"
        },
        "accessibleRangeSelectModeOn": {
          "type": "string"
        },
        "accessibleRowCollapsed": {
          "type": "string"
        },
        "accessibleRowContext": {
          "type": "string"
        },
        "accessibleRowEndHeaderContext": {
          "type": "string"
        },
        "accessibleRowEndHeaderLabelContext": {
          "type": "string"
        },
        "accessibleRowExpanded": {
          "type": "string"
        },
        "accessibleRowHeaderContext": {
          "type": "string"
        },
        "accessibleRowHeaderLabelContext": {
          "type": "string"
        },
        "accessibleRowHierarchicalFull": {
          "type": "string"
        },
        "accessibleRowHierarchicalPartial": {
          "type": "string"
        },
        "accessibleRowHierarchicalUnknown": {
          "type": "string"
        },
        "accessibleRowSelected": {
          "type": "string"
        },
        "accessibleRowSpanContext": {
          "type": "string"
        },
        "accessibleSelectionAffordanceBottom": {
          "type": "string"
        },
        "accessibleSelectionAffordanceTop": {
          "type": "string"
        },
        "accessibleSortAscending": {
          "type": "string"
        },
        "accessibleSortDescending": {
          "type": "string"
        },
        "accessibleSortable": {
          "type": "string"
        },
        "accessibleStateSelected": {
          "type": "string"
        },
        "accessibleSummaryEstimate": {
          "type": "string"
        },
        "accessibleSummaryExact": {
          "type": "string"
        },
        "accessibleSummaryExpanded": {
          "type": "string"
        },
        "collapsedText": {
          "type": "string"
        },
        "columnWidth": {
          "type": "string"
        },
        "expandedText": {
          "type": "string"
        },
        "labelCopyCells": {
          "type": "string"
        },
        "labelCut": {
          "type": "string"
        },
        "labelCutCells": {
          "type": "string"
        },
        "labelDisableNonContiguous": {
          "type": "string"
        },
        "labelEnableNonContiguous": {
          "type": "string"
        },
        "labelFillCells": {
          "type": "string"
        },
        "labelFilter": {
          "type": "string"
        },
        "labelFilterCol": {
          "type": "string"
        },
        "labelFreezeCol": {
          "type": "string"
        },
        "labelFreezeRow": {
          "type": "string"
        },
        "labelHideColumn": {
          "type": "string"
        },
        "labelHideRow": {
          "type": "string"
        },
        "labelPaste": {
          "type": "string"
        },
        "labelPasteCells": {
          "type": "string"
        },
        "labelResize": {
          "type": "string"
        },
        "labelResizeColumn": {
          "type": "string"
        },
        "labelResizeDialogApply": {
          "type": "string"
        },
        "labelResizeDialogCancel": {
          "type": "string"
        },
        "labelResizeDialogSubmit": {
          "type": "string"
        },
        "labelResizeFitToContent": {
          "type": "string"
        },
        "labelResizeHeight": {
          "type": "string"
        },
        "labelResizeRow": {
          "type": "string"
        },
        "labelResizeWidth": {
          "type": "string"
        },
        "labelSelectMultiple": {
          "type": "string"
        },
        "labelSortAsc": {
          "type": "string"
        },
        "labelSortCol": {
          "type": "string"
        },
        "labelSortColAsc": {
          "type": "string"
        },
        "labelSortColDsc": {
          "type": "string"
        },
        "labelSortDsc": {
          "type": "string"
        },
        "labelSortRow": {
          "type": "string"
        },
        "labelSortRowAsc": {
          "type": "string"
        },
        "labelSortRowDsc": {
          "type": "string"
        },
        "labelUnfreezeCol": {
          "type": "string"
        },
        "labelUnfreezeRow": {
          "type": "string"
        },
        "labelUnhideColumn": {
          "type": "string"
        },
        "labelUnhideRow": {
          "type": "string"
        },
        "msgFetchingData": {
          "type": "string"
        },
        "msgNoData": {
          "type": "string"
        },
        "msgReadOnly": {
          "type": "string"
        },
        "resizeColumnDialog": {
          "type": "string"
        },
        "resizeRowDialog": {
          "type": "string"
        },
        "rowHeight": {
          "type": "string"
        },
        "tooltipRequired": {
          "type": "string"
        }
      }
    }
  },
  "methods": {
    "getContextByNode": {},
    "getProperty": {},
    "refresh": {},
    "setProperties": {},
    "setProperty": {},
    "getNodeBySubId": {},
    "getSubIdByNode": {}
  },
  "events": {
    "ojBeforeCurrentCell": {},
    "ojBeforeEdit": {},
    "ojBeforeEditEnd": {},
    "ojCellResize": {},
    "ojCollapseRequest": {},
    "ojCopyRequest": {},
    "ojCutRequest": {},
    "ojExpandRequest": {},
    "ojFillRequest": {},
    "ojFilterRequest": {},
    "ojHeaderLabelCutRequest": {},
    "ojPasteRequest": {},
    "ojResize": {},
    "ojScroll": {},
    "ojSort": {},
    "ojSortLabelRequest": {},
    "ojSortRequest": {}
  },
  "extension": {}
};
    __oj_data_grid_metadata.extension._WIDGET_NAME = 'ojDataGrid';
    __oj_data_grid_metadata.extension._BINDING = {
      provide: new Map([[UNSAFE_useFormVariantContext.FormVariantContext, 'embedded']])
    };
    oj.CustomElementBridge.register('oj-data-grid', {
      metadata: oj.CollectionUtils.mergeDeep(__oj_data_grid_metadata, {
        properties: {
          userAssistanceDensity: {
            binding: {
              provide: [
                { name: 'containerUserAssistanceDensity', default: 'compact' },
                { name: 'userAssistanceDensity', default: 'compact' }
              ]
            }
          }
        }
      })
    });
  })();

  /**
   * @export
   * This class captures all translation resources and style classes used by the DataGrid.
   * This should be populated with information extracted through the framework and set on the DataGrid.
   * Internal.  Developers should never use this class.
   * @constructor
   * @ignore
   */
  const DataGridResources = function (
    rtlMode,
    translationFunction,
    defaultOptions,
    widgetName
  ) {
    this.rtlMode = rtlMode;
    this.translationFunction = translationFunction;
    this.defaultOptions = defaultOptions;
    this.widgetName = widgetName;
    this.styles = {};
    this.styles.datagrid = 'oj-datagrid';
    this.styles.cell = 'oj-datagrid-cell';
    this.styles.banded = 'oj-datagrid-banded';
    this.styles.row = 'oj-datagrid-row';
    this.styles.databody = 'oj-datagrid-databody';
    this.styles.topcorner = 'oj-datagrid-top-corner';
    this.styles.bottomcorner = 'oj-datagrid-bottom-corner';
    this.styles.rowheaderspacer = 'oj-datagrid-row-header-spacer';
    this.styles.colheaderspacer = 'oj-datagrid-column-header-spacer';
    this.styles.status = 'oj-datagrid-status';
    this.styles.loadingicon = 'oj-icon oj-datagrid-loading-icon';
    this.styles.emptytext = 'oj-datagrid-empty-text';
    this.styles.header = 'oj-datagrid-header';
    this.styles.endheader = 'oj-datagrid-end-header';
    this.styles.groupingcontainer = 'oj-datagrid-header-grouping';
    this.styles.headercell = 'oj-datagrid-header-cell';
    this.styles.rowheader = 'oj-datagrid-row-header';
    this.styles.colheader = 'oj-datagrid-column-header';
    this.styles.colheadercell = 'oj-datagrid-column-header-cell';
    this.styles.rowheadercell = 'oj-datagrid-row-header-cell';
    this.styles.endheadercell = 'oj-datagrid-end-header-cell';
    this.styles.rowendheader = 'oj-datagrid-row-end-header';
    this.styles.colendheader = 'oj-datagrid-column-end-header';
    this.styles.colendheadercell = 'oj-datagrid-column-end-header-cell';
    this.styles.rowendheadercell = 'oj-datagrid-row-end-header-cell';
    this.styles.headerlabel = 'oj-datagrid-header-label';
    this.styles.rowheaderlabel = 'oj-datagrid-row-header-label';
    this.styles.columnheaderlabel = 'oj-datagrid-column-header-label';
    this.styles.rowendheaderlabel = 'oj-datagrid-row-end-header-label';
    this.styles.columnendheaderlabel = 'oj-datagrid-column-end-header-label';
    this.styles['scroller-mobile'] = 'oj-datagrid-scroller-touch';
    this.styles.scroller = 'oj-datagrid-scroller';
    this.styles.scrollers = 'oj-datagrid-scrollers';
    this.styles.scrollbarForce = 'oj-scrollbar-force';
    this.styles.focus = 'oj-focus';
    this.styles.hover = 'oj-hover';
    this.styles.active = 'oj-active';
    this.styles.selected = 'oj-selected';
    this.styles.topSelected = 'oj-datagrid-selected-top';
    this.styles.bottomSelected = 'oj-datagrid-selected-bottom';
    this.styles.startSelected = 'oj-datagrid-selected-start';
    this.styles.endSelected = 'oj-datagrid-selected-end';
    this.styles.topEdit = 'oj-datagrid-cell-edit-top';
    this.styles.bottomEdit = 'oj-datagrid-cell-edit-bottom';
    this.styles.startEdit = 'oj-datagrid-cell-edit-start';
    this.styles.endEdit = 'oj-datagrid-cell-edit-end';
    this.styles.topEditInvalid = 'oj-datagrid-cell-edit-top-invalid';
    this.styles.bottomEditInvalid = 'oj-datagrid-cell-edit-bottom-invalid';
    this.styles.startEditInvalid = 'oj-datagrid-cell-edit-start-invalid';
    this.styles.endEditInvalid = 'oj-datagrid-cell-edit-end-invalid';
    this.styles.topFloodfill = 'oj-datagrid-floodfill-top';
    this.styles.bottomFloodfill = 'oj-datagrid-floodfill-bottom';
    this.styles.startFloodfill = 'oj-datagrid-floodfill-start';
    this.styles.endFloodfill = 'oj-datagrid-floodfill-end';
    this.styles.topResized = 'oj-datagrid-resized-top';
    this.styles.bottomResized = 'oj-datagrid-resized-bottom';
    this.styles.endResized = 'oj-datagrid-resized-end';
    this.styles.startResized = 'oj-datagrid-resized-start';
    this.styles.disabled = 'oj-disabled';
    this.styles.enabled = 'oj-enabled';
    this.styles.default = 'oj-default';
    this.styles.sortIcon = 'oj-datagrid-sort-icon';
    this.styles.sortascending = 'oj-datagrid-sort-ascending-icon';
    this.styles.sortdescending = 'oj-datagrid-sort-descending-icon';
    this.styles.sortdefault = 'oj-datagrid-sort-default-icon';
    this.styles.icon = 'oj-component-icon';
    this.styles.clickableicon = 'oj-clickable-icon-nocontext';
    this.styles.info = 'oj-helper-hidden-accessible';
    this.styles.rowexpander = 'oj-rowexpander';
    this.styles.cut = 'oj-datagrid-cut';
    this.styles.selectaffordance = 'oj-datagrid-touch-selection-affordance';
    this.styles.selectaffordancetopcornerbounded =
      'oj-datagrid-touch-selection-affordance-top-corner-bounded';
    this.styles.selectaffordancebottomcornerbounded =
      'oj-datagrid-touch-selection-affordance-bottom-corner-bounded';
    this.styles.selectaffordancetoprow = 'oj-datagrid-touch-selection-affordance-top-row';
    this.styles.selectaffordancebottomrow = 'oj-datagrid-touch-selection-affordance-bottom-row';
    this.styles.selectaffordancetopcolumn = 'oj-datagrid-touch-selection-affordance-top-column';
    this.styles.selectaffordancebottomcolumn = 'oj-datagrid-touch-selection-affordance-bottom-column';
    this.styles.floodfillaffordance = 'oj-datagrid-floodfill-affordance';
    this.styles.toucharea = 'oj-datagrid-touch-area';
    this.styles.readOnly = 'oj-read-only';
    this.styles.editable = 'oj-datagrid-editable';
    this.styles.cellEdit = 'oj-datagrid-cell-edit';
    this.styles.draggable = 'oj-draggable';
    this.styles.drag = 'oj-drag';
    this.styles.drop = 'oj-drop';
    this.styles.activedrop = 'oj-active-drop';
    this.styles.validdrop = 'oj-valid-drop';
    this.styles.invaliddrop = 'oj-invalid-drop';
    this.styles.formcontrol = 'oj-form-control-inherit';
    this.styles.borderHorizontalNone = 'oj-datagrid-border-horizontal-none';
    this.styles.borderVerticalNone = 'oj-datagrid-border-vertical-none';
    this.styles.borderHorizontalSmall = 'oj-datagrid-small-content-border-horizontal';
    this.styles.borderVerticalSmall = 'oj-datagrid-small-content-border-vertical';
    this.styles.offsetOutline = 'oj-datagrid-focus-offset';
    this.styles.depth = 'oj-datagrid-depth-';
    this.styles.popupHeader = 'oj-datagrid-popup-header';
    this.styles.popupContent = 'oj-datagrid-popup-content';
    this.styles.popupFooter = 'oj-datagrid-popup-footer';
    this.styles.dialogTitle = 'oj-dialog-title';
    this.styles.resizeDialog = 'oj-datagrid-resize-dialog';
    this.styles.headerAllSelected = 'oj-selected';
    this.styles.headerPartialSelected = 'oj-partial-selected';
    this.styles.disclosureContainer = 'oj-datagrid-disclosure-icon-container';
    this.styles.disclosureIcon = 'oj-datagrid-disclosure-icon';
    this.styles.expanded = 'oj-datagrid-expanded-icon';
    this.styles.collapsed = 'oj-datagrid-collapsed-icon';
    this.styles.spacer = 'oj-datagrid-tree-spacer';
    this.styles.hierarchicalTree = 'oj-datagrid-hierarchical-tree';
    this.styles.hierarchicalGroup = 'oj-datagrid-hierarchical-group';
    this.styles.iconContainer = 'oj-datagrid-icon-container';
    this.styles.requiredIcon = 'oj-datagrid-required-icon';
    this.styles.noDataContainer = 'oj-datagrid-no-data-container';
    this.styles.draggableItem = 'oj-datagrid-draggable';
    this.styles.dragSourceOpaque = 'drag-source-opaque';
    this.styles.rowDropTargetLine = 'oj-datagrid-row-drop-target-line';
    this.styles.colDropTargetLine = 'oj-datagrid-col-drop-target-line';
    this.styles.dragging = 'oj-datagrid-drag-active';
    this.styles.dropTarget = 'oj-datagrid-drop-target';
    this.styles.disabledElement = 'oj-datagrid-disabled-element';
    this.styles.databodyFrozenCol = 'oj-datagrid-databody-frozen-column';
    this.styles.databodyFrozenRow = 'oj-datagrid-databody-frozen-row';
    this.styles.databodyFrozenCorner = 'oj-datagrid-databody-frozen-corner';
    this.styles.colHeaderFrozen = 'oj-datagrid-column-header-frozen';
    this.styles.rowHeaderFrozen = 'oj-datagrid-row-header-frozen';
    this.styles.colEndHeaderFrozen = 'oj-datagrid-column-end-header-frozen';
    this.styles.rowEndHeaderFrozen = 'oj-datagrid-row-end-header-frozen';
    this.styles.rowFrozenIndicator = 'oj-datagrid-row-frozen-indicator';
    this.styles.colFrozenIndicator = 'oj-datagrid-col-frozen-indicator';
    this.styles.frozenHeader = 'oj-datagrid-header-frozen';
    this.styles.frozenCell = 'oj-datagrid-cell-frozen';
    this.styles.skeletonContainer = 'oj-datagrid-skeleton-container';
    this.styles.skeletonCell = 'oj-datagrid-skeleton-cell';
    this.styles.skeleton = 'oj-datagrid-skeleton';
    this.styles.skeletonAnimation = 'oj-animation-skeleton';
    this.styles.colHiddenIndicator = 'oj-datagrid-col-hidden-indicator';
    this.styles.rowHiddenIndicator = 'oj-datagrid-row-hidden-indicator';
    this.styles.colHeaderHiddenIndicator = 'oj-datagrid-col-header-hidden-indicator';
    this.styles.rowHeaderHiddenIndicator = 'oj-datagrid-row-header-hidden-indicator';
    this.styles.filterIcon = 'oj-datagrid-filter-icon';
    this.styles.filterable = 'oj-datagrid-filterable-icon';
    this.styles.filtered = 'oj-datagrid-filtered-icon';
    this.styles.headerCellContent = 'oj-datagrid-header-cell-content';
    this.styles.headerLabelCellContent = 'oj-datagrid-header-label-cell-content';
    this.styles.iconHidden = 'oj-datagrid-icon-hidden';
    this.styles.validationError = 'oj-datagrid-cell-validation-error';

    this.commands = {};
    this.commands.sortCol = 'oj-datagrid-sortCol';
    this.commands.sortColAsc = 'oj-datagrid-sortColAsc';
    this.commands.sortColDsc = 'oj-datagrid-sortColDsc';
    this.commands.sortRow = 'oj-datagrid-sortRow';
    this.commands.sortRowAsc = 'oj-datagrid-sortRowAsc';
    this.commands.sortRowDsc = 'oj-datagrid-sortRowDsc';
    this.commands.resize = 'oj-datagrid-resize';
    this.commands.resizeWidth = 'oj-datagrid-resizeWidth';
    this.commands.resizeHeight = 'oj-datagrid-resizeHeight';
    this.commands.resizeFitToContent = 'oj-datagrid-resizeFitToContent';
    this.commands.cut = 'oj-datagrid-cut';
    this.commands.paste = 'oj-datagrid-paste';
    this.commands.cutCells = 'oj-datagrid-cutCells';
    this.commands.copyCells = 'oj-datagrid-copyCells';
    this.commands.pasteCells = 'oj-datagrid-pasteCells';
    this.commands.autoFill = 'oj-datagrid-fillCells';
    this.commands.discontiguousSelection = 'oj-datagrid-discontiguousSelection';
    this.commands.freezeCol = 'oj-datagrid-freezeCol';
    this.commands.freezeRow = 'oj-datagrid-freezeRow';
    this.commands.unfreezeCol = 'oj-datagrid-unfreezeCol';
    this.commands.unfreezeRow = 'oj-datagrid-unfreezeRow';
    this.commands.hideCol = 'oj-datagrid-hideCol';
    this.commands.unhideCol = 'oj-datagrid-unhideCol';
    this.commands.hideRow = 'oj-datagrid-hideRow';
    this.commands.unhideRow = 'oj-datagrid-unhideRow';
    this.commands.filterCol = 'oj-datagrid-filterCol';

    this.attributes = {};
    this.attributes.busyContext = Context._OJ_CONTEXT_ATTRIBUTE; // 'data-oj-context'
    this.attributes.context = 'data-oj-cellContext';
    this.attributes.resizable = 'data-oj-resizable';
    this.attributes.sortable = 'data-oj-sortable';
    this.attributes.sortDir = 'data-oj-sortdir';
    this.attributes.expander = 'data-oj-expander';
    this.attributes.expanderIndex = 'data-oj-expander-index';
    this.attributes.container = Components._OJ_CONTAINER_ATTR;
    this.attributes.extent = 'data-oj-extent';
    this.attributes.start = 'data-oj-start';
    this.attributes.depth = 'data-oj-depth';
    this.attributes.level = 'data-oj-level';
    this.attributes.metadata = 'data-oj-metaData';
    this.attributes.hiddenIndicatorIndex = 'data-oj-hiddenIndicatorIndex';
    this.attributes.filterable = 'data-oj-filterable';
    this.attributes.readOnly = 'data-oj-readOnly';
  };

  oj._registerLegacyNamespaceProp('DataGridResources', DataGridResources);

  /**
   * Set whether the reading direction is right to left.
   * @param {boolean} rtl true if reading direction is right to left, false otherwise.
   * @export
   */
  DataGridResources.prototype.setRTLMode = function (rtl) {
    this.rtlMode = rtl;
  };

  /**
   * Whether the reading direction is right to left.
   * @return {boolean} true if reading direction is right to left, false otherwise.
   * @export
   */
  DataGridResources.prototype.isRTLMode = function () {
    return this.rtlMode === 'rtl';
  };

  /**
   * Gets the translated text
   * @param {string} key the key to the translated text
   * @param {Array=} args optional arguments to format the translated text
   * @return {string|null} the translated text
   * @export
   */
  DataGridResources.prototype.getTranslatedText = function (key, args) {
    return this.translationFunction(key, args);
  };

  /**
   * Gets the default option
   * @param {string} key the key to the default option
   * @return {Object|null} the value of the option
   * @export
   */
  DataGridResources.prototype.getDefaultOption = function (key) {
    return this.defaultOptions[key];
  };

  /**
   * Gets the mapped style class
   * @param {string} key the key to the style class
   * @return {string|null} the style class
   * @export
   */
  DataGridResources.prototype.getMappedStyle = function (key) {
    if (key != null) {
      return this.styles[key];
    }
    return null;
  };

  /**
   * Gets the mapped command class
   * @param {string} key the key to the command class
   * @return {string|null} the command class
   * @export
   */
  DataGridResources.prototype.getMappedCommand = function (key) {
    if (key != null) {
      return this.commands[key];
    }
    return null;
  };

  /**
   * Gets the mapped attribute
   * @param {string} key the key to the attribute
   * @return {string|null} the attribute
   * @export
   */
  DataGridResources.prototype.getMappedAttribute = function (key) {
    if (key != null) {
      return this.attributes[key];
    }
    return null;
  };

  /**
   * @constructor
   * @private
   */
  const DataProviderDataGridDataSource = function (dataprovider) {
    this.dataprovider = dataprovider;

    this.pendingHeaderCallback = {};
    if (dataprovider.options && dataprovider.options.implicitSort) {
      this.currentSortCriteria = dataprovider.options.implicitSort;
    }
    this.sortUpdated = false;

    var fetchByOffset = this.dataprovider.getCapability('fetchByOffset');

    if (fetchByOffset != null) {
      this.fetchByOffset = fetchByOffset.implementation === 'randomAccess';
    } else {
      this.fetchByOffset = false;
    }
    this._registerEventListeners();

    DataProviderDataGridDataSource.superclass.constructor.call(this);
  };

  oj.Object.createSubclass(
    DataProviderDataGridDataSource,
    oj.DataGridDataSource,
    'DataProviderDataGridDataSource'
  );

  DataProviderDataGridDataSource.prototype._registerEventListeners = function () {
    this._mutationListener = this._handleDataProviderMutationEvent.bind(this);
    this._refreshListener = this._handleDataProviderRefreshEvent.bind(this);

    this.dataprovider.addEventListener('mutate', this._mutationListener);
    this.dataprovider.addEventListener('refresh', this._refreshListener);
  };

  DataProviderDataGridDataSource.prototype._handleDataProviderMutationEvent = function (event) {
    var eventDetail = event.detail;
    var adds = eventDetail.add;
    var i;
    if (adds != null) {
      var addEvent = {
        indexes: [],
        keys: []
      };
      var dataArray = [];
      var metadataArray = [];
      var indexesArray = [];
      for (i = 0; i < adds.data.length; i++) {
        addEvent.source = this;
        addEvent.operation = 'insert';
        addEvent.keys.push({ row: adds.metadata[i].key, column: null });
        addEvent.indexes.push({ row: adds.indexes[i], column: -1 });

        indexesArray.push(adds.indexes[i]);
        dataArray.push(adds.data[i]);
        metadataArray.push(adds.metadata[i]);

        if (i === adds.data.length - 1 || adds.indexes[i + 1] !== adds.indexes[i] + 1) {
          addEvent.result = new SingleCellSet(indexesArray, metadataArray, dataArray, this.columns);
          this.handleEvent('change', addEvent);
          addEvent = {};
          addEvent.indexes = [];
          addEvent.keys = [];
          dataArray = [];
          metadataArray = [];
          indexesArray = [];
        }
      }
    }

    var removes = event.detail.remove;
    if (removes != null) {
      var removeEvent = {
        source: this,
        operation: 'delete',
        keys: [],
        indexes: []
      };
      for (i = 0; i < removes.data.length; i++) {
        removeEvent.keys.push({ row: removes.metadata[i].key, column: null });
        removeEvent.indexes.push({ row: removes.indexes[i], column: -1 });
      }
      this.handleEvent('change', removeEvent);
    }

    var updates = event.detail.update;
    if (updates != null) {
      for (i = 0; i < updates.data.length; i++) {
        var updateEvent = {
          source: this,
          operation: 'update',
          keys: { row: updates.metadata[i].key, column: null },
          indexes: { row: updates.indexes[i], column: -1 }
        };
        updateEvent.result = new SingleCellSet(
          [updates.indexes[i]],
          [updates.metadata[i]],
          [updates.data[i]],
          this.columns
        );
        this.handleEvent('change', updateEvent);
      }
    }
  };

  function SingleCellSet(indexes, metadata, data, columns) {
    this.indexes = indexes;
    this.data = data;
    this.metadata = metadata;
    this.columns = columns;
  }

  SingleCellSet.prototype.getData = function (indexes) {
    var self = this;
    var returnObj = {};
    Object.defineProperty(returnObj, 'data', {
      enumerable: true,
      get: function () {
        return self.data[indexes.row - self.getStart('row')][self.columns[indexes.column]];
      },
      set: function (newValue) {
        self.data[indexes.row - self.getStart('row')][self.columns[indexes.column]] = newValue;
      }
    });
    return returnObj;
  };

  SingleCellSet.prototype.getMetadata = function (indexes) {
    var self = this;
    var metadata = self.metadata[indexes.row - self.getStart('row')];
    metadata.keys = { row: metadata.key, column: self.columns[indexes.column] };
    return metadata;
  };

  SingleCellSet.prototype.getStart = function (axis) {
    if (axis === 'row') {
      return this.indexes[0];
    }
    return 0;
  };

  SingleCellSet.prototype.getCount = function (axis) {
    if (axis === 'row') {
      return this.data.length;
    } else if (axis === 'column') {
      return this.columns.length;
    }
    return 0;
  };

  SingleCellSet.prototype.getExtent = function () {
    return {
      row: { extent: 1, more: { before: false, after: false } },
      column: { extent: 1, more: { before: false, after: false } }
    };
  };

  DataProviderDataGridDataSource.prototype._handleDataProviderRefreshEvent = function () {
    this._asyncIterator = null;
    this.handleEvent('change', { operation: 'refresh' });
  };

  DataProviderDataGridDataSource.prototype.fetchHeaders = function (
    headerRange,
    callbacks,
    callbackObjects
  ) {
    if (callbacks != null) {
      var axis = headerRange.axis;
      var callback = {
        headerRange: headerRange,
        callbacks: callbacks,
        callbackObjects: callbackObjects
      };
      this.pendingHeaderCallback[axis] = callback;
    }
  };

  DataProviderDataGridDataSource.prototype._processPendingHeaderCallbacks = function (axis) {
    // check if there's callback remaining for the axis
    var pendingCallback = this.pendingHeaderCallback[axis];
    if (pendingCallback != null) {
      // todo: check whether pending header range matches result
      var headerRange = pendingCallback.headerRange;
      var callbacks = pendingCallback.callbacks;
      var callbackObjects = pendingCallback.callbackObjects;
      this._handleHeaderFetchSuccess(headerRange, callbacks, callbackObjects);

      // clear any pending callback
      this.pendingHeaderCallback[axis] = null;
    }
  };

  DataProviderDataGridDataSource.prototype._handleHeaderFetchSuccess = function (
    headerRange,
    callbacks,
    callbackObjects
  ) {
    var axis = headerRange.axis;
    var start = headerRange.start;
    var count = headerRange.count;
    var headerSet;

    if (axis === 'column' && this.columns != null) {
      var end = Math.min(this.columns.length, start + count);
      headerSet = new DataProviderHeaderSet(start, end, this.columns, this.currentSortCriteria);
    } else {
      headerSet = null;
    }

    if (callbacks != null && callbacks.success) {
      callbacks.success.call(callbackObjects.success, headerSet, headerRange, null);
    }
  };

  function DataProviderCellSet(response, cellRanges, columns) {
    this.response = response;
    this.results = response.results;
    this.cellRanges = cellRanges;
    this.columns = columns;

    this._setBounds(response, cellRanges, columns);
  }

  DataProviderCellSet.prototype._setBounds = function (response, cellRanges, columns) {
    for (var i = 0; i < cellRanges.length; i += 1) {
      var cellRange = cellRanges[i];
      if (cellRange.axis === 'row') {
        this.rowStart = response.fetchParameters.offset
          ? response.fetchParameters.offset
          : cellRange.start;
        this.rowEnd = this.rowStart + response.results.length - 1;
      } else if (cellRange.axis === 'column') {
        this.colStart = cellRange.start;
        this.colEnd = Math.min(
          this.colStart + cellRange.count - 1,
          this.colStart + columns.length - 1
        );
      }
    }
  };

  DataProviderCellSet.prototype.getData = function (indexes) {
    var self = this;
    var returnObj = {};
    Object.defineProperty(returnObj, 'data', {
      enumerable: true,
      get: function () {
        return self.results[indexes.row - self.rowStart].data[self.columns[indexes.column]];
      },
      set: function (newValue) {
        self.results[indexes.row - self.rowStart].data[self.columns[indexes.column]] = newValue;
      }
    });
    return returnObj;
  };

  DataProviderCellSet.prototype.getMetadata = function (indexes) {
    var self = this;
    var metadata = self.results[indexes.row - self.rowStart].metadata;
    metadata.keys = {
      row: this.results[indexes.row - this.rowStart].metadata.key,
      column: this.columns[indexes.column]
    };
    return metadata;
  };

  DataProviderCellSet.prototype.getCount = function (axis) {
    if (axis === 'row') {
      return this.rowEnd - this.rowStart + 1;
    } else if (axis === 'column') {
      return this.colEnd - this.colStart + 1;
    }
    return 0;
  };

  DataProviderCellSet.prototype.getExtent = function () {
    return {
      row: { extent: 1, more: { before: false, after: false } },
      column: { extent: 1, more: { before: false, after: false } }
    };
  };

  DataProviderDataGridDataSource.prototype.setUpColumns = function (response) {
    if (this.columns == null || this.columns.length === 0) {
      var columns = [];
      if (response.results.length) {
        var propertyNames = Object.keys(response.results[0].data);
        for (var i = 0; i < propertyNames.length; i++) {
          columns.push(propertyNames[i]);
        }
      }
      this.columns = columns;
    }
  };

  DataProviderDataGridDataSource.prototype.getRangeInfo = function (cellRanges) {
    var rangeInfo = {};
    for (var i = 0; i < cellRanges.length; i += 1) {
      var cellRange = cellRanges[i];
      if (cellRange.axis === 'row') {
        rangeInfo.rowStart = cellRange.start;
        rangeInfo.rowEnd = rangeInfo.rowStart + cellRange.count - 1;
      } else if (cellRange.axis === 'column') {
        rangeInfo.colStart = cellRange.start;
        rangeInfo.colEnd = rangeInfo.colStart + cellRange.count - 1;
      }
    }
    return rangeInfo;
  };

  DataProviderDataGridDataSource.prototype._createResults = function (response) {
    response.results = [];
    for (var i = 0; i < response.value.data.length; i++) {
      var item = {
        data: response.value.data[i],
        metadata: response.value.metadata[i]
      };
      response.results.push(item);
    }
  };

  DataProviderDataGridDataSource.prototype.handleFetchResult = function (
    cellRanges,
    callbacks,
    callbackObjects,
    response
  ) {
    // normalize fetchByOffset vs fetchFirst

    var fetchResponse = response[0];

    if (!fetchResponse.results) {
      this._createResults(fetchResponse);
      fetchResponse.fetchParameters = fetchResponse.value.fetchParameters;
    }

    this.setUpColumns(fetchResponse);

    this._processPendingHeaderCallbacks('column');
    this._processPendingHeaderCallbacks('row');

    var cellSet = new DataProviderCellSet(fetchResponse, cellRanges, this.columns);

    if (callbacks != null && callbacks.success != null) {
      var success = callbackObjects ? callbackObjects.success : null;
      callbacks.success.call(success, cellSet, cellRanges);
    }
  };

  DataProviderDataGridDataSource.prototype.fetchCells = function (
    cellRanges,
    callbacks,
    callbackObjects
  ) {
    var self = this;

    this.getCount('row');

    var rangeInfo = self.getRangeInfo(cellRanges);
    var size = rangeInfo.rowEnd - rangeInfo.rowStart + 1;

    if (self.fetchByOffset) {
      var offset = rangeInfo.rowStart;
      self._fetchPromise = self.dataprovider.fetchByOffset({
        size: size,
        offset: offset,
        sortCriteria: self.currentSortCriteria
      });
    } else {
      if (self._asyncIterator == null || this.sortUpdated) {
        // Create a clientId symbol that uniquely identify this consumer so that
        // DataProvider which supports it can optimize resources
        self._clientId = self._clientId || Symbol();

        self._asyncIterator = self.dataprovider
          .fetchFirst({
            clientId: self._clientId,
            size: size,
            sortCriteria: self.currentSortCriteria
          })
          [Symbol.asyncIterator]();
      }
      self._fetchPromise = self._asyncIterator.next();
    }

    this.sortUpdated = false;

    Promise.all([self._fetchPromise, self._getCountPromise]).then(
      self.handleFetchResult.bind(self, cellRanges, callbacks, callbackObjects)
    );
  };

  DataProviderDataGridDataSource.prototype.getCapability = function (feature) {
    if (feature === 'sort') {
      var dpSort = this.dataprovider.getCapability(feature).attributes;
      if (dpSort === 'multiple' || dpSort === 'single') {
        return 'column';
      }
      return dpSort;
    }
    return 'none';
  };

  DataProviderDataGridDataSource.prototype.getCount = function (axis) {
    var self = this;
    if (axis === 'row') {
      if (self.totalRowCount === undefined) {
        self._getCountPromise = this.dataprovider.getTotalSize();
        self._getCountPromise.then(function (rowCount) {
          self.totalRowCount = rowCount;
        });
      } else {
        return self.totalRowCount;
      }
    } else if (axis === 'column') {
      if (this.columns != null) {
        return this.columns.length;
      }
    }
    return -1;
  };

  DataProviderDataGridDataSource.prototype.getCountPrecision = function () {
    return 'estimate';
  };

  DataProviderDataGridDataSource.prototype.indexes = function () {
    return { row: -1, column: -1 };
  };

  DataProviderDataGridDataSource.prototype.keys = function () {
    return { row: null, column: null };
  };

  DataProviderDataGridDataSource.prototype.move = function () {
    return false;
  };

  DataProviderDataGridDataSource.prototype.moveOK = function () {
    return 'invalid';
  };

  DataProviderDataGridDataSource.prototype.sort = function (criteria, callbacks, callbackObjects) {
    this.sortUpdated = true;
    this.currentSortCriteria = [{ attribute: criteria.key, direction: criteria.direction }];

    if (callbackObjects == null) {
      // eslint-disable-next-line no-param-reassign
      callbackObjects = {};
    }

    if (callbacks != null && callbacks.success != null) {
      callbacks.success.call(callbackObjects.success);
    }
  };

  function DataProviderHeaderSet(start, end, headers, sortCriteria) {
    this.start = start;
    this.end = end;
    this.headers = headers;
    this.sortCriteria = sortCriteria;
  }

  DataProviderHeaderSet.prototype.getData = function (index) {
    return this.headers[index];
  };

  DataProviderHeaderSet.prototype.getMetadata = function (index) {
    var data = this.getData(index);
    var returnObj = { key: data };

    if (this.sortCriteria != null) {
      for (var i = 0; i < this.sortCriteria.length; i++) {
        if (this.sortCriteria[i].attribute === data) {
          returnObj.sortDirection = this.sortCriteria[i].direction;
        }
      }
    }

    return returnObj;
  };

  DataProviderHeaderSet.prototype.getLevelCount = function () {
    return 1;
  };

  DataProviderHeaderSet.prototype.getExtent = function () {
    return { extent: 1, more: { before: false, after: false } };
  };

  DataProviderHeaderSet.prototype.getLabel = function () {
    return null;
  };

  DataProviderHeaderSet.prototype.getDepth = function () {
    return 1;
  };

  DataProviderHeaderSet.prototype.getCount = function () {
    return Math.max(0, this.end - this.start);
  };

  /**
   * This class contains all utility methods used by the Grid.
   * @param {Object} dataGrid the dataGrid using the utils
   * @constructor
   * @private
   */
  const DvtDataGridKeyboardHandler = function (dataGrid) {
    this.grid = dataGrid;
  };

  /**
   * Get the action of a particular keydown event given information about the state of the frid
   * @param {Event} event
   * @param {Object} capabilities
   * @returns {string}
   */
  DvtDataGridKeyboardHandler.prototype.getAction = function (event, capabilities) {
    var keyCode = event.keyCode;
    var ctrlKey = this.grid.m_utils.ctrlEquivalent(event);
    var shiftKey = event.shiftKey;
    var altKey = event.altKey;
    var keyCodes = this.grid.keyCodes;

    var cellOrHeader = capabilities.cellOrHeader;
    var readOnly = capabilities.readOnly;
    var currentMode = capabilities.currentMode;
    var activeMove = capabilities.activeMove;
    var activeDrag = capabilities.activeDrag;
    var rowMove = capabilities.rowMove;
    var columnSort = capabilities.columnSort;
    let rowSort = capabilities.rowSort;
    var selection = capabilities.selection;
    var selectionMode = capabilities.selectionMode;
    var multipleSelection = capabilities.multipleSelection;
    var expandCollapse = capabilities.expandCollapse;
    var copy = capabilities.copyCells;
    var cut = capabilities.cutCells;
    var paste = capabilities.pasteCells;
    var fill = capabilities.fill;

    switch (keyCode) {
      case keyCodes.TAB_KEY:
        if (currentMode === 'actionable') {
          if (shiftKey) {
            return 'TAB_PREV_IN_CELL';
          }
          return 'TAB_NEXT_IN_CELL';
        }
        if (currentMode === 'edit') {
          return shiftKey ? 'TAB_PREV_IN_CELL_OR_FOCUS_LEFT' : 'TAB_NEXT_IN_CELL_OR_FOCUS_RIGHT';
        }
        if (!readOnly) {
          if (shiftKey) {
            return 'FOCUS_LEFT';
          }
          return 'FOCUS_RIGHT';
        }
        break;
      case keyCodes.ENTER_KEY:
        if (currentMode === 'actionable') {
          return 'NO_OP';
        }
        if ((cellOrHeader === 'column' && columnSort) || (cellOrHeader === 'row' && rowSort)) {
          return 'SORT';
        }
        if ((!altKey && readOnly && currentMode === 'navigation') || cellOrHeader !== 'cell') {
          // enter actionable mode on headers since they cannot be edited
          return 'ACTIONABLE';
        }
        if (!readOnly && !altKey) {
          if (shiftKey) {
            return 'FOCUS_UP';
          }
          return 'FOCUS_DOWN';
        }
        if (altKey && readOnly && currentMode === 'navigation') {
          return 'EDITABLE';
        }
        if (!readOnly) {
          if (currentMode === 'navigation' || currentMode === 'edit') {
            return 'EDIT';
          }
        }
        break;
      case keyCodes.ESC_KEY:
        if (currentMode === 'actionable') {
          return 'EXIT_ACTIONABLE';
        }
        if (activeMove) {
          return 'CANCEL_REORDER';
        }
        if (activeDrag) {
          return 'CANCEL_DRAG';
        }
        if (!readOnly) {
          if (currentMode === 'navigation') {
            return 'EXIT_EDITABLE';
          }
          if (currentMode === 'edit') {
            return 'CANCEL_EDIT';
          }
        } else if (this.grid.m_discontiguousSelection) {
          return 'SELECT_DISCONTIGUOUS';
        }
        break;
      case keyCodes.SPACE_KEY:
        if (
          cellOrHeader.indexOf('row') !== -1 &&
          selection &&
          ((selectionMode === 'cell' && multipleSelection) || selectionMode === 'row') &&
          currentMode === 'navigation'
        ) {
          return 'SELECT_ROW';
        }
        if (
          cellOrHeader.indexOf('column') !== -1 &&
          selection &&
          selectionMode === 'cell' &&
          multipleSelection &&
          currentMode === 'navigation'
        ) {
          return 'SELECT_COLUMN';
        }
        if (cellOrHeader === 'cell') {
          if (readOnly && currentMode === 'navigation') {
            if (ctrlKey && selection && selectionMode === 'cell' && multipleSelection) {
              return 'SELECT_COLUMN';
            }
            if (
              shiftKey &&
              selection &&
              ((selectionMode === 'cell' && multipleSelection) || selectionMode === 'row')
            ) {
              return 'SELECT_ROW';
            }
          } else if (currentMode === 'navigation') {
            return 'DATA_ENTRY';
          }
        }
        break;
      case keyCodes.PAGEUP_KEY:
        if (currentMode === 'navigation') {
          return 'FOCUS_ROW_FIRST';
        }
        break;
      case keyCodes.PAGEDOWN_KEY:
        if (currentMode === 'navigation') {
          return 'FOCUS_ROW_LAST';
        }
        break;
      case keyCodes.END_KEY:
        if (currentMode === 'navigation') {
          if (ctrlKey && cellOrHeader === 'cell') {
            return 'FOCUS_LAST_CELL_IN_GRID';
          }
          return 'FOCUS_COLUMN_LAST';
        }
        break;
      case keyCodes.HOME_KEY:
        if (currentMode === 'navigation') {
          if (ctrlKey && cellOrHeader === 'cell') {
            return 'FOCUS_FIRST_CELL_IN_GRID';
          }
          return 'FOCUS_COLUMN_FIRST';
        }
        break;
      case keyCodes.LEFT_KEY:
        if (ctrlKey && expandCollapse && this.grid._isHeaderExpanded(event.target)) {
          return 'COLLAPSE';
        }
        if (currentMode === 'actionable') {
          return 'NO_OP';
        }
        if (currentMode === 'navigation') {
          if (shiftKey && selection && selectionMode === 'cell' && multipleSelection) {
            return 'SELECT_EXTEND_LEFT';
          }
          if (ctrlKey) {
            return 'FOCUS_LEFT_NON_EMPTY_CELL';
          }
          return 'FOCUS_LEFT';
        }
        break;
      case keyCodes.UP_KEY:
        if (currentMode === 'actionable') {
          return 'NO_OP';
        }
        if (currentMode === 'navigation') {
          if (shiftKey && selection && multipleSelection) {
            return 'SELECT_EXTEND_UP';
          }
          if (ctrlKey) {
            return 'FOCUS_UP_NON_EMPTY_CELL';
          }
          return 'FOCUS_UP';
        }
        break;
      case keyCodes.RIGHT_KEY:
        if (ctrlKey && expandCollapse && this.grid._isHeaderCollapsed(event.target)) {
          return 'EXPAND';
        }
        if (currentMode === 'actionable') {
          return 'NO_OP';
        }
        if (currentMode === 'navigation') {
          if (shiftKey && selection && selectionMode === 'cell' && multipleSelection) {
            return 'SELECT_EXTEND_RIGHT';
          }
          if (ctrlKey) {
            return 'FOCUS_RIGHT_NON_EMPTY_CELL';
          }
          return 'FOCUS_RIGHT';
        }
        break;
      case keyCodes.DOWN_KEY:
        if (currentMode === 'actionable') {
          return 'NO_OP';
        }
        if (currentMode === 'navigation') {
          if (shiftKey && selection && multipleSelection) {
            return 'SELECT_EXTEND_DOWN';
          }
          if (ctrlKey) {
            return 'FOCUS_DOWN_NON_EMPTY_CELL';
          }
          return 'FOCUS_DOWN';
        }
        break;
      case keyCodes.F2_KEY:
        if (currentMode === 'actionable') {
          return 'EXIT_ACTIONABLE';
        }
        if (cellOrHeader !== 'cell') {
          return 'ACTIONABLE';
        }
        if (readOnly && currentMode === 'navigation') {
          return 'EDITABLE';
        }
        if (!readOnly && currentMode === 'navigation') {
          return 'EDIT';
        } else if (!readOnly && currentMode === 'edit') {
          return 'CANCEL_EDIT';
        }
        break;
      case keyCodes.F8_KEY:
        if (shiftKey && selection && multipleSelection) {
          return 'SELECT_DISCONTIGUOUS';
        }
        break;
      case keyCodes.F10_KEY:
        if (shiftKey) {
          return 'NO_OP';
        }
        break;
      case keyCodes.V_KEY:
        if (currentMode === 'navigation' && ctrlKey) {
          if (rowMove) {
            return 'PASTE';
          }
          if (paste) {
            return 'PASTE_CELLS';
          }
        }
        if (!readOnly && currentMode === 'navigation' && cellOrHeader === 'cell') {
          return 'DATA_ENTRY';
        }
        break;
      case keyCodes.X_KEY:
        if (currentMode === 'navigation' && ctrlKey) {
          if (rowMove) {
            return 'CUT';
          }
          if (cut) {
            return 'CUT_CELLS';
          }
        }
        if (!readOnly && currentMode === 'navigation' && cellOrHeader === 'cell') {
          return 'DATA_ENTRY';
        }
        break;
      case keyCodes.C_KEY:
        if (currentMode === 'navigation' && ctrlKey && copy) {
          return 'COPY_CELLS';
        }
        if (!readOnly && currentMode === 'navigation' && cellOrHeader === 'cell') {
          return 'DATA_ENTRY';
        }
        break;
      case keyCodes.D_KEY:
        if (currentMode === 'navigation' && ctrlKey && fill) {
          return 'FILL';
        } else if (!readOnly && currentMode === 'navigation' && cellOrHeader === 'cell' && !ctrlKey) {
          return 'DATA_ENTRY';
        }
        break;
      case keyCodes.R_KEY:
        if (currentMode === 'navigation' && ctrlKey && altKey && capabilities.filterCol) {
          return 'FILTER_COLUMN';
        } else if (currentMode === 'navigation' && ctrlKey && fill) {
          return 'FILL';
        } else if (!readOnly && currentMode === 'navigation' && cellOrHeader === 'cell' && !ctrlKey) {
          return 'DATA_ENTRY';
        }
        break;
      case keyCodes.SHIFT_KEY:
      case keyCodes.CTRL_KEY:
      case keyCodes.ALT_KEY:
        break;

      case keyCodes.A_KEY:
        if (ctrlKey && selection && multipleSelection && currentMode === 'navigation') {
          return 'SELECT_ALL';
        }
      // eslint-disable-next-line no-fallthrough
      case keyCodes.NUM5_KEY:
        if (ctrlKey && altKey && currentMode === 'navigation') {
          return 'READ_CELL';
        }
      // eslint-disable-next-line no-fallthrough
      default:
        if (
          (keyCode < keyCodes.F1_KEY || keyCode > keyCodes.F15_KEY) &&
          !readOnly &&
          currentMode === 'navigation' &&
          cellOrHeader === 'cell' &&
          !ctrlKey
        ) {
          return 'DATA_ENTRY';
        }
        break;
    }
    return 'NO_OP';
  };
  // incase of noData
  DvtDataGridKeyboardHandler.prototype.getNoDataAction = function (event, capabilities) {
    var keyCode = event.keyCode;
    var shiftKey = event.shiftKey;
    var keyCodes = this.grid.keyCodes;

    var currentMode = capabilities.currentMode;

    switch (keyCode) {
      case keyCodes.TAB_KEY:
        if (currentMode === 'actionable') {
          if (shiftKey) {
            return 'TAB_PREV_IN_CELL';
          }
          return 'TAB_NEXT_IN_CELL';
        }
        break;
      case keyCodes.ESC_KEY:
        if (currentMode === 'actionable') {
          return 'EXIT_ACTIONABLE';
        }
        break;
      case keyCodes.F2_KEY:
        if (currentMode === 'actionable') {
          return 'EXIT_ACTIONABLE';
        }
        return 'ACTIONABLE';
      case keyCodes.UP_KEY:
        if (currentMode === 'navigation') {
          return 'FOCUS_COLUMN_HEADER';
        }
        break;
      case keyCodes.DOWN_KEY:
        if (currentMode === 'navigation') {
          return 'FOCUS_COLUMN_END_HEADER';
        }
        break;
      case keyCodes.LEFT_KEY:
        if (currentMode === 'navigation') {
          return 'FOCUS_ROW_HEADER';
        }
        break;
      case keyCodes.RIGHT_KEY:
        if (currentMode === 'navigation') {
          return 'FOCUS_ROW_END_HEADER';
        }
        break;
      default:
        break;
    }
    return 'NO_OP';
  };

  /**
   * The DvtDataGridOptions object provides convenient methods to access the options passed to the Grid.
   * @param {Object=} options - options set on the grid.
   * @param {Function=} rendererWrapperFunction - callback function used to fix renderer function for custom element.
   * @constructor
   * @private
   */
  const DvtDataGridOptions = function (options, rendererWrapperFunction) {
    this.options = options;
    this.rendererWrapperFunction = rendererWrapperFunction;
  };

  /**
   * Helper method to extract properties
   * @param {string=} arg1 - key to extract in object
   * @param {string=} arg2 - key to extract in the value of object[arg1]
   * @param {string=} arg3 - key to extract in the value of object[arg1][arg2]
   * @param {string=} arg4 - key to extract in the value of object[arg1][arg2][arg3]
   * @param {string=} arg5 - key to extract in the value of object[arg1][arg2][arg3][arg4]
   * @return {string|number|Object|boolean|null}
   */
  DvtDataGridOptions.prototype.extract = function (arg1, arg2, arg3, arg4, arg5) {
    if (arg1 != null) {
      var val1 = this.options[arg1];
      if (arg2 != null && val1 != null) {
        var val2 = val1[arg2];
        if (arg3 != null && val2 != null) {
          var val3 = val2[arg3];
          if (arg4 != null && val3 != null) {
            var val4 = val3[arg4];
            if (arg5 != null && val4 != null) {
              return val4[arg5];
            }
            return val4;
          }
          return val3;
        }
        return val2;
      }
      return val1;
    }
    return null;
  };

  /**
   * Evaluate the a function, if it is a constant return it
   * @param {string|number|Object|boolean|null} value - function or string of the raw property
   * @param {Object} obj - object to pass into value if it is a function
   * @return {string|number|Object|boolean|null} the evaluated value(obj) if value a function, else return value
   */
  DvtDataGridOptions.prototype.evaluate = function (value, obj) {
    if (typeof value === 'function') {
      return value.call(this, obj);
    }
    return value;
  };

  /**
   * Get the property that was set on the option
   * @param {string} prop - the property to get from options
   * @param {string|undefined} axis - subobject to get row/column/cell/rowEnd/columnEnd
   * @return {string|number|Object|boolean|null} the raw value of the property
   */
  DvtDataGridOptions.prototype.getRawProperty = function (prop, axis, label) {
    var arg1;
    var arg2;
    var arg3;
    var arg4;

    if (axis === 'row' || axis === 'column' || axis === 'rowEnd' || axis === 'columnEnd') {
      arg1 = 'header';
      arg2 = axis;
      if (label) {
        arg3 = 'label';
        arg4 = prop;
      } else {
        arg3 = prop;
      }
    } else if (axis === 'cell') {
      arg1 = 'cell';
      arg2 = prop;
    }

    return this.extract(arg1, arg2, arg3, arg4);
  };

  /**
   * Get the evaluated property of the options
   * @param {string} prop - the property to get from options
   * @param {string=} axis - subobject to get row/column/cell
   * @param {Object=} obj - object to pass into property if it is a function
   * @return the evaluated property
   */
  DvtDataGridOptions.prototype.getProperty = function (prop, axis, obj, label) {
    if (obj === undefined) {
      return this.extract(prop, axis, label);
    }

    return this.evaluate(this.getRawProperty(prop, axis, label), obj);
  };

  // //////////////////////// Grid options /////////////////////////////////

  /**
   * Get the row banding interval from the grid options
   * @return {string|number|Object|boolean} the row banding interval
   */
  DvtDataGridOptions.prototype.getRowBandingInterval = function () {
    var bandingInterval = this.getProperty('bandingInterval', 'row');
    if (bandingInterval != null) {
      return bandingInterval;
    }
    return 0;
  };

  /**
   * Get the column banding interval from the grid options
   * @return {string|number|Object|boolean} the column banding interval
   */
  DvtDataGridOptions.prototype.getColumnBandingInterval = function () {
    var bandingInterval = this.getProperty('bandingInterval', 'column');
    if (bandingInterval != null) {
      return bandingInterval;
    }
    return 0;
  };

  /**
   * Get the empty text from the grid options
   * @return {string|number|Object|boolean|null} the empty text
   */
  DvtDataGridOptions.prototype.getEmptyText = function () {
    return this.getProperty('emptyText');
  };

  /**
   * Get the horizontal gridlines from the grid options
   * @return {string|number|Object|boolean|null} horizontal gridlines visible/hidden
   */
  DvtDataGridOptions.prototype.getHorizontalGridlines = function () {
    var horizontalGridlines = this.extract('gridlines', 'horizontal');
    if (horizontalGridlines != null) {
      return horizontalGridlines;
    }
    return 'visible';
  };

  /**
   * Get the vertical gridlines from the grid options
   * @return {string|number|Object|boolean|null} vertical gridlines visible/hidden
   */
  DvtDataGridOptions.prototype.getVerticalGridlines = function () {
    var verticalGridlines = this.extract('gridlines', 'vertical');
    if (verticalGridlines != null) {
      return verticalGridlines;
    }
    return 'visible';
  };

  /**
   * Get the scroll to key from the grid options
   * @return {string|null} scroll to key behavior capability/never/auto/always
   */
  DvtDataGridOptions.prototype.getScrollToKey = function () {
    var scrollToKey = this.getProperty('scrollToKey');
    if (scrollToKey != null) {
      return scrollToKey;
    }
    return 'auto';
  };

  /**
   * Get the scroll position from the grid options
   * @return {string|number|Object|boolean|null} scrollPositionObject
   */
  DvtDataGridOptions.prototype.getScrollPosition = function () {
    var scrollPosition = this.getProperty('scrollPosition');
    if (scrollPosition != null) {
      return scrollPosition;
    }
    return null;
  };

  /**
   * Get the selection mode cardinality (none, single multiple)
   * @return {string|number|Object|boolean|null} none/single/multiple
   */
  DvtDataGridOptions.prototype.getSelectionCardinality = function () {
    var mode = this.getProperty('selectionMode');
    if (mode == null) {
      return 'none';
    }

    var key = this.getSelectionMode();
    var val = mode[key];
    if (val != null) {
      return val;
    }
    return 'none';
  };

  /**
   * Get the selection mode (row,cell)
   * @return {string|number|Object|boolean|null} row/cell
   */
  DvtDataGridOptions.prototype.getSelectionMode = function () {
    var mode = this.getProperty('selectionMode');
    if (mode == null) {
      return 'cell';
    }

    var cardinality = mode.row;
    if (cardinality != null && cardinality !== 'none') {
      return 'row';
    }
    return 'cell';
  };

  /**
   * Get the current selection from the grid options
   * @return {Array|null} the current selection from options
   */
  DvtDataGridOptions.prototype.getSelection = function () {
    return this.getProperty('selection');
  };

  /**
   * Get the current cell from the grid options
   * @return {Object|null} the current cell from options
   */
  DvtDataGridOptions.prototype.getCurrentCell = function () {
    return this.getProperty('currentCell');
  };

  /**
   * Get the editMode (none,cell)
   * @return {string|number|Object|boolean|null} default/enter
   */
  DvtDataGridOptions.prototype.getEditMode = function () {
    return this.getProperty('editMode');
  };

  // //////////////////////// Grid header/cell options /////////////////////////////////
  /**
   * Is the given header sortable
   * @param {string} axis - axis to check if sort enabled
   * @param {Object} obj - header context
   * @return {string|number|Object|boolean|null} default or null
   */
  DvtDataGridOptions.prototype.isSortable = function (axis, obj, isLabel) {
    return this.getProperty('sortable', axis, obj, isLabel);
  };

  /**
   * Is the given header resizable
   * @param {string} axis - axis to check if resizing enabled
   * @param {string} dir - width/height
   * @return {string|number|Object|boolean|null} enable, disable, or null
   */
  DvtDataGridOptions.prototype.isResizable = function (axis, dir, obj) {
    var v = this.extract('header', axis, 'resizable', dir);
    if (obj != null) {
      return this.evaluate(v, obj);
    }
    return v;
  };

  /**
   * Gets the dnd rorderable option
   * @param {string} axis the axis to get the reorder property from
   * @return {string|number|Object|boolean|null} enable, disable, or null
   */
  DvtDataGridOptions.prototype.isMoveable = function (axis) {
    return this.extract('dnd', 'reorder', axis);
  };

  DvtDataGridOptions.prototype._isDragEnabled = function (axis) {
    let isEnabled = false;
    let dragAxis = axis === 'row' || axis === 'rowEnd' ? 'rows' : 'columns';
    let isDraggable = this.getProperty('dnd').drag;
    if (isDraggable && isDraggable[dragAxis]) {
      isEnabled = true;
    }
    return isEnabled;
  };

  DvtDataGridOptions.prototype._isDragEnabledOnLabel = function (axis) {
    let isEnabled = false;
    let dragAxis = axis === 'row' || axis === 'rowEnd' ? 'rowLabels' : 'columnLabels';
    let isDraggable = this.getProperty('dnd').drag;
    if (isDraggable && isDraggable[dragAxis]) {
      isEnabled = true;
    }
    return isEnabled;
  };

  /**
   * Gets the floodfill option
   * @return {string|null} enable, disable, or null
   */
  DvtDataGridOptions.prototype.isFloodFillEnabled = function () {
    let isEnabled = false;
    let floodFill = this.extract('dataTransferOptions', 'fill');
    if (floodFill === 'enable') {
      isEnabled = true;
    }
    return isEnabled;
  };

  /**
   * Gets the copy option
   * @return {string|null} enable, disable, or null
   */
  DvtDataGridOptions.prototype.isCopyEnabled = function () {
    let isEnabled = false;
    let copy = this.extract('dataTransferOptions', 'copy');
    if (copy === 'enable') {
      isEnabled = true;
    }

    return isEnabled;
  };

  /**
   * Gets the cut option
   * @return {string|null} enable, disable, or null
   */
  DvtDataGridOptions.prototype.isCutEnabled = function () {
    let isEnabled = false;
    let cut = this.extract('dataTransferOptions', 'cut');
    if (cut === 'enable') {
      isEnabled = true;
    }

    return isEnabled;
  };

  DvtDataGridOptions.prototype._isLabelCutEnabled = function () {
    let isEnabled = false;
    let cut = this.extract('dataTransferOptions', 'headerLabelCut');
    if (cut === 'enable') {
      isEnabled = true;
    }
    return isEnabled;
  };

  /**
   * Gets the paste option
   * @return {string|null} enable, disable, or null
   */
  DvtDataGridOptions.prototype.isPasteEnabled = function () {
    let isEnabled = false;
    let paste = this.extract('dataTransferOptions', 'paste');
    if (paste === 'enable') {
      isEnabled = true;
    }

    return isEnabled;
  };

  /**
   * Is freeze enabled
   * @param {string} axis - axis to check if freeze enabled
   * @return {string} enable, disable
   */
  DvtDataGridOptions.prototype.isFreezeEnabled = function (axis) {
    let isEnabled = false;
    // handling virtual scroll to not support freeze currently.
    if (this.getProperty('scrollPolicy') === 'scroll') {
      return false;
    }
    let v = this.extract('header', axis, 'freezable');
    if (v === 'enable') {
      isEnabled = true;
    }
    return isEnabled;
  };

  DvtDataGridOptions.prototype._getFreezeIndex = function (axis) {
    let freezeIndex = null;
    // handling virtual scroll to not support freeze currently.
    if (this.getProperty('scrollPolicy') === 'scroll') {
      return freezeIndex;
    }
    if (axis === 'row') {
      freezeIndex = this.getProperty('frozenRowCount');
    } else {
      freezeIndex = this.getProperty('frozenColumnCount');
    }
    // freezeIndex is freezeCount - 1
    if (freezeIndex !== null) {
      freezeIndex = parseInt(freezeIndex, 10) - 1;
    }
    return freezeIndex;
  };

  /**
   * Is hide enabled
   * @param {string} axis - axis to check if hide enabled
   * @return {string} enable, disable
   */
  DvtDataGridOptions.prototype.isHideEnabled = function (axis) {
    let isEnabled = false;
    let hide = this.extract('header', axis, 'hidable');
    if (hide === 'enable') {
      isEnabled = true;
    }
    return isEnabled;
  };

  DvtDataGridOptions.prototype._getHiddenIndices = function (axis) {
    let hiddenIndices;

    if (axis === 'column') {
      hiddenIndices = this.getProperty('hiddenColumns');
    } else if (axis === 'row') {
      hiddenIndices = this.getProperty('hiddenRows');
    }

    return hiddenIndices;
  };
  /**
   * Get the inline style property on an object
   * @param {string} axis - axis to get style of
   * @param {Object} obj - context
   * @return {string|number|Object|boolean|null} inline style
   */
  DvtDataGridOptions.prototype.getInlineStyle = function (axis, obj, label) {
    return this.getProperty('style', axis, obj, label);
  };

  /**
   * Get the style class name property on an object
   * @param {string} axis - axis to get class name of
   * @param {Object} obj - context
   * @return {string|number|Object|boolean|null} class name
   */
  DvtDataGridOptions.prototype.getStyleClass = function (axis, obj, label) {
    return this.getProperty('className', axis, obj, label);
  };

  /**
   * Get the editable property on an object
   * @param {string} axis - axis to get editable
   * @param {Object} obj - context
   * @return {string} - editablility
   */
  DvtDataGridOptions.prototype.isEditable = function (axis, obj, label) {
    return this.getProperty('editable', axis, obj, label);
  };

  /**
   * Get the renderer of an axis
   * @param {string} axis - axis to get style of
   * @param {boolean} label - whether its a label or not.
   * @return {string|number|Object|boolean|null} axis renderer
   */
  DvtDataGridOptions.prototype.getRenderer = function (axis, label) {
    // return type expected to be function, so just return without further
    // evaluation
    if (this.rendererWrapperFunction) {
      return this.rendererWrapperFunction(this.getRawProperty('renderer', axis, label));
    }
    return this.getRawProperty('renderer', axis, label);
  };

  /**
   * Get the scroll mode
   * @return {string} the scroll mode, which can be either "scroll", "loadMoreOnScroll", "auto".
   */
  DvtDataGridOptions.prototype.getScrollPolicy = function () {
    var mode = this.getProperty('scrollPolicy');
    if (mode == null) {
      mode = 'auto';
    }

    return mode;
  };

  /**
   * Get the scroll policy options
   */
  DvtDataGridOptions.prototype.getScrollPolicyOptions = function () {
    return this.getProperty('scrollPolicyOptions');
  };

  /**
   * Is the given header filterable
   * @param {string} axis - axis to check if filter enabled
   * @param {Object} obj - header context
   * @return {'auto'|'disable'} auto, disable
   */
  DvtDataGridOptions.prototype.isFilterEnabled = function (axis, obj) {
    return this.getProperty('filterable', axis, obj);
  };

  DvtDataGridOptions.prototype.getAlignment = function (property, axis, obj, label) {
    let v;
    if (axis === 'cell') {
      v = this.extract('cell', 'alignment', property);
    } else if (label) {
      v = this.extract('header', axis, 'label', 'alignment', property);
    } else {
      v = this.extract('header', axis, 'alignment', property);
    }
    if (v == null) {
      v = 'auto';
    }
    if (obj != null) {
      return this.evaluate(v, obj);
    }
    return v;
  };

  DvtDataGridOptions.prototype.getHorizontalAlignment = function (axis, contextObj, isLabel) {
    return this.getAlignment('horizontal', axis, contextObj, isLabel);
  };

  DvtDataGridOptions.prototype.getVeticalAlignment = function (axis, contextObj, isLabel) {
    return this.getAlignment('vertical', axis, contextObj, isLabel);
  };

  /**
   * Class used to keep track of whcih elements have been resized, has an object
   * containing two objects 'row' and 'column', which should have objects of
   * index:{size}. this.sizes = {axis:{index:{size}}}
   * @constructor
   * @private
   */
  const DvtDataGridSizingManager = function () {
    this.sizes = { column: new Map(), row: new Map() };
  };

  /**
   * Set a size in the sizes object in the sizing manager
   * @param {string} axis - column/row
   * @param {any} headerKey - key of the element
   * @param {number} size - the size to put in the object
   */
  DvtDataGridSizingManager.prototype.setSize = function (axis, headerKey, size) {
    this.sizes[axis].set(headerKey, size);
  };

  /**
   * Get a size from the sizing manager for a given axis and index,
   * @param {string} axis - column/row
   * @param {any} headerKey - key of the element
   * @return {number|null} a size if it exists
   */
  DvtDataGridSizingManager.prototype.getSize = function (axis, headerKey) {
    // get does reference comparison
    var size = this.sizes[axis].get(headerKey);
    if (size != null) {
      return size;
    }

    // if reference comparison does not work we should check using compare values
    this.sizes[axis].forEach(function (value, key) {
      if (size == null && oj.Object.compareValues(key, headerKey)) {
        size = value;
      }
    });

    return size;
  };

  /**
   * Empty the sizing manager sizes
   */
  DvtDataGridSizingManager.prototype.clear = function () {
    this.sizes.column.clear();
    this.sizes.row.clear();
  };

  /**
   * This class contains all utility methods used by the Grid.
   * @param {Object} dataGrid the dataGrid using the utils
   * @constructor
   * @private
   */
  const DvtDataGridUtils = function (dataGrid) {
    this.scrollbarSize = -1;
    this.dataGrid = dataGrid;
  };

  /**
   * Get the maximum scrollable browser height
   * @returns {Number}
   */
  DvtDataGridUtils.prototype._getMaxDivHeightForScrolling = function () {
    if (this.m_maxDivHeightForScrolling == null) {
      this._setMaxValuesForScrolling();
    }
    return this.m_maxDivHeightForScrolling;
  };

  /**
   * Get the maximum scrollable browser width
   * @returns {Number}
   */
  DvtDataGridUtils.prototype._getMaxDivWidthForScrolling = function () {
    if (this.m_maxDivWidthForScrolling == null) {
      this._setMaxValuesForScrolling();
    }
    return this.m_maxDivWidthForScrolling;
  };
  /**
   * Set the maximum scrollable browser height
   */
  DvtDataGridUtils.prototype._setMaxValuesForScrolling = function () {
    this._calculateBrowserDefinedValues();
  };

  DvtDataGridUtils.prototype._calculateBrowserDefinedValues = function () {
    var div1 = document.createElement('div');
    div1.style.width = '1000000000px';
    div1.style.height = '1000000000px';
    div1.style.display = 'none';

    var scrollDiv = document.createElement('div');
    scrollDiv.style.width = '100px';
    scrollDiv.style.height = '100px';
    scrollDiv.style.overflow = 'scroll';
    scrollDiv.style.position = 'absolute';
    scrollDiv.style.top = '-9999px';

    document.body.appendChild(scrollDiv); // @HTMLUpdateOK

    let remove = false;
    // ie lets the value go forever without actual support, so we hard cap it at 1 million pixels
    if (DataCollectionUtils.isIE() || DataCollectionUtils.isEdge()) {
      this.m_maxDivHeightForScrolling = 1000000;
      this.m_maxDivWidthForScrolling = 1000000;
    } else {
      remove = true;
      document.body.appendChild(div1); // @HTMLUpdateOK
      // for some reason chrome stops rendering absolutely positioned content at half the value on osx
      this.m_maxDivHeightForScrolling = parseInt(
        parseFloat(window.getComputedStyle(div1).height) / 2,
        10
      );
      this.m_maxDivWidthForScrolling = parseInt(
        parseFloat(window.getComputedStyle(div1).width) / 2,
        10
      );
    }

    // Get the scrollbar width/height
    this.scrollbarSize = scrollDiv.offsetWidth - scrollDiv.clientWidth;

    if (remove) {
      document.body.removeChild(div1);
    }
    document.body.removeChild(scrollDiv);
  };

  /**
   * Gets the size of the native scrollbar
   */
  DvtDataGridUtils.prototype.getScrollbarSize = function () {
    if (this.scrollbarSize === -1) {
      this._calculateBrowserDefinedValues();
    }
    return this.scrollbarSize;
  };

  /**
   * Determine if the current agent is touch device
   */
  DvtDataGridUtils.prototype.isTouchDevice = function () {
    if (this.isTouch == null) {
      this.isTouch = DataCollectionUtils.isMobileTouchDevice();
    }

    return this.isTouch;
  };

  /**
   * Determine if the current agent is touch device
   */
  DvtDataGridUtils.prototype.isTouchDeviceNotIOS = function () {
    if (this.isTouchNotIOS == null) {
      let isTouch = this.isTouchDevice();
      if (isTouch) {
        this.isTouchNotIOS = !DataCollectionUtils.isIos();
      } else {
        this.isTouchNotIOS = false;
      }
    }
    return this.isTouchNotIOS;
  };

  /**
   * Adds a CSS className to the dom node if it doesn't already exist in the classNames list,
   * or does nothing if it already exists.
   * @param {Element|Node|null|undefined} domElement DOM Element to add style class name to
   * @param {string|null} className Name of style class to add
   * @return {boolean|null} <code>true</code> if the style class was added
   */

  DvtDataGridUtils.prototype.addCSSClassName = function (domElement, className) {
    if (className != null && className !== '' && domElement != null && domElement.classList != null) {
      domElement.classList.add(className);
    }
  };

  /**
   * Removes a CSS className from the dom node if it exists in the classNames list.
   * @param {Element|Node|null|undefined} domElement DOM Element to remove style class name from
   * @param {string|null} className Name of style class to remove
   * @return {boolean|null} <code>true</code> if the style class was removed
   */

  DvtDataGridUtils.prototype.removeCSSClassName = function (domElement, className) {
    if (className != null && className !== '' && domElement != null && domElement.classList != null) {
      domElement.classList.remove(className);
    }
  };

  /**
   * @param {Element|Node|null|undefined} domElement DOM Element to check for the style <code>className</code>
   * @param {string} className the CSS className to check for
   * @return {boolean} <code>true</code> if the className is in the element's list of classes
   */

  DvtDataGridUtils.prototype.containsCSSClassName = function (domElement, className) {
    var exists = false;
    if (className != null && domElement != null && domElement.classList != null) {
      exists = domElement.classList.contains(className);
    }
    return exists;
  };

  /**
   * Returns either the ctrl key or the command key in Mac OS
   * @param {Event} event
   */
  DvtDataGridUtils.prototype.ctrlEquivalent = function (event) {
    return DataCollectionUtils.isMac() ? event.metaKey : event.ctrlKey;
  };

  /**
   * Gets the scroll left of an element.  This method abstracts the inconsistency of scrollLeft
   * behavior in RTL mode between browsers.
   * @param {Element} element the dom element to retrieve scroll left
   * @private
   */
  DvtDataGridUtils.prototype.getElementScrollLeft = function (element) {
    return Math.abs(element.scrollLeft);
  };

  /**
   * Sets the scroll left of an element.  This method abstracts the inconsistency of scrollLeft
   * behavior in RTL mode between browsers.
   * @param {Element} element the dom element to set scroll left
   * @param {number} scrollLeft the scroll left of the dom element
   * @private
   */
  DvtDataGridUtils.prototype.setElementScrollLeft = function (element, scrollLeft) {
    DomUtils.setScrollLeft(element, scrollLeft);
  };

  /**
   * Determines the what mousewheel event the browser recognizes
   * All modern browsers support wheel event
   * @return {string} The event which the browser uses to track mosuewheel events
   * @private
   */
  DvtDataGridUtils.prototype.getMousewheelEvent = function () {
    return 'wheel';
  };

  /**
   * The standard wheel event and WheelEvent API now uses deltaMode and just deltaX and deltaY as the
   * properties for determining scroll.
   * @param {Event} event the mousewheel scroll event
   * @return {Object} change in X and Y if applicable through a mousewheel event, properties are deltaX, deltaY
   * @private
   */
  DvtDataGridUtils.prototype.getMousewheelScrollDelta = function (event) {
    var scrollConstant = -1;
    var deltaMode = event.deltaMode;

    if (deltaMode === event.DOM_DELTA_PIXEL) {
      scrollConstant = -1;
    } else if (deltaMode === event.DOM_DELTA_LINE || deltaMode === event.DOM_DELTA_PAGE) {
      // only on firefox now, we will scroll 40 times the number of lines they
      // they want to scroll
      scrollConstant = -40;
    }
    var deltaX = event.deltaX * scrollConstant;
    var deltaY = event.deltaY * scrollConstant;

    return { deltaX: deltaX, deltaY: deltaY };
  };

  /**
   * Empty out (clear all children and attributes) from an element
   * @param {Element} elem the dom element to empty out
   * @private
   */
  DvtDataGridUtils.prototype.empty = function (elem) {
    while (elem.firstChild) {
      this.dataGrid._remove(elem.firstChild);
    }
  };

  /**
   * Return whether the node is editable or clickable
   * @param {Node|Element} node Node
   * @param {Element} databody Databody
   * @return {boolean} true or false
   * @private
   */
  DvtDataGridUtils.prototype._isNodeEditableOrClickable = function (node, databody) {
    while (node != null && node !== databody) {
      var nodeName = node.nodeName;

      // If the node is a text node, move up the hierarchy to only operate on elements
      // (on at least the mobile browsers, the node may be a text node)
      if (node.nodeType === 3) {
        // 3 is Node.TEXT_NODE
        // eslint-disable-next-line no-param-reassign
        node = node.parentNode;
      } else {
        var tabIndex = parseInt(node.getAttribute('tabIndex'), 10);
        // datagrid overrides the tab index, so we should check if the data-oj-tabindex is populated
        var origTabIndex = parseInt(
          node.getAttribute(this.dataGrid.getResources().getMappedAttribute('tabindex')),
          10
        );

        if (tabIndex != null && tabIndex >= 0) {
          if (
            this.containsCSSClassName(node, this.dataGrid.getResources().getMappedStyle('cell')) ||
            this.containsCSSClassName(
              node,
              this.dataGrid.getResources().getMappedStyle('headerlabel')
            ) ||
            this.containsCSSClassName(
              node,
              this.dataGrid.getResources().getMappedStyle('headercell')
            ) ||
            this.containsCSSClassName(
              node,
              this.dataGrid.getResources().getMappedStyle('endheadercell')
            )
          ) {
            // this is the cell element
            return false;
          }

          return true;
        } else if (nodeName.match(/^INPUT|SELECT|OPTION|BUTTON|^A\b|TEXTAREA/)) {
          // ignore elements with tabIndex == -1
          if (tabIndex !== -1 || origTabIndex !== -1) {
            return true;
          }
        }

        // eslint-disable-next-line no-param-reassign
        node = node.parentNode;
      }
    }
    return false;
  };

  /**
   * On certain browser the outline is postioned differently and requires offset. Chrome/Safari on Mac.
   * @return {boolean} true if the outline needs to be offset
   * @private
   */
  DvtDataGridUtils.prototype.shouldOffsetOutline = function () {
    if (DataCollectionUtils.isMac() && DataCollectionUtils.isWebkit()) {
      return true;
    }
    return false;
  };

  /**
   * Creates a new DataGrid
   * @constructor
   * @private
   */
  const DvtDataGrid = function (root) {
    this.m_root = root;

    this.MAX_COLUMN_THRESHOLD = 20;
    this.MAX_ROW_THRESHOLD = 30;

    this.m_utils = new DvtDataGridUtils(this);

    this.m_discontiguousSelection = false;

    this.m_sizingManager = new DvtDataGridSizingManager();

    this.m_keyboardHandler = new DvtDataGridKeyboardHandler(this);

    this.m_rowHeaderWidth = null;
    this.m_rowEndHeaderWidth = null;
    this.m_colHeaderHeight = null;
    this.m_colEndHeaderHeight = null;

    // a mapping of style class+inline style combo to a dimension
    // to reduce the need to do excessive offsetWidth/offsetHeight
    this.m_styleClassDimensionMap = { width: {}, height: {} };

    // cached whether row/column count are unknown
    this.m_isEstimateRowCount = undefined;
    this.m_isEstimateColumnCount = undefined;
    this.m_stopRowFetch = false;
    this.m_stopRowHeaderFetch = false;
    this.m_stopRowEndHeaderFetch = false;
    this.m_stopColumnFetch = false;
    this.m_stopColumnHeaderFetch = false;
    this.m_stopColumnEndHeaderFetch = false;

    this.m_fetchingForUpdate = false;

    // not done initializing until initial headers/cells are fetched
    this.m_initialized = false;
    this.m_shouldFocus = null;
    this.m_renderCount = 0;

    this.callbacks = {};

    this._setupActions();

    this.m_readinessStack = [];
    this.m_modelEvents = [];

    this.m_databodyMap = new Map();
  };

  // keyCodes for data grid keyboard
  DvtDataGrid.prototype.keyCodes = {
    TAB_KEY: 9,
    ENTER_KEY: 13,
    SHIFT_KEY: 16,
    CTRL_KEY: 17,
    ALT_KEY: 18,
    ESC_KEY: 27,
    SPACE_KEY: 32,
    PAGEUP_KEY: 33,
    PAGEDOWN_KEY: 34,
    END_KEY: 35,
    HOME_KEY: 36,
    LEFT_KEY: 37,
    UP_KEY: 38,
    RIGHT_KEY: 39,
    DOWN_KEY: 40,
    NUM5_KEY: 53,
    V_KEY: 86,
    X_KEY: 88,
    C_KEY: 67,
    D_KEY: 68,
    R_KEY: 82,
    F1_KEY: 112,
    F2_KEY: 113,
    F8_KEY: 119,
    F10_KEY: 121,
    F15_KEY: 126,
    A_KEY: 65
  };

  // constants for update animation
  DvtDataGrid.UPDATE_ANIMATION_FADE_INOUT = 1;
  DvtDataGrid.UPDATE_ANIMATION_SLIDE_INOUT = 2;
  DvtDataGrid.UPDATE_ANIMATION_DURATION = 250;

  // constants for expand/collapse animation
  DvtDataGrid.EXPAND_ANIMATION_DURATION = 500;
  DvtDataGrid.COLLAPSE_ANIMATION_DURATION = 400;

  // swipe gesture constants
  DvtDataGrid.MAX_OVERSCROLL_PIXEL = 50;
  DvtDataGrid.BOUNCE_ANIMATION_DURATION = 500;
  DvtDataGrid.DECELERATION_FACTOR = 0.0006;
  DvtDataGrid.TAP_AND_SCROLL_RESET = 300;
  // related to timing and x/y position of events
  DvtDataGrid.MIN_SWIPE_DURATION = 200;
  DvtDataGrid.MAX_SWIPE_DURATION = 400;
  DvtDataGrid.MIN_SWIPE_DISTANCE = 10;
  // for the actual transition animation
  DvtDataGrid.MIN_SWIPE_TRANSITION_DURATION = 100;
  DvtDataGrid.MAX_SWIPE_TRANSITION_DURATION = 500;

  // constants for touch gestures
  DvtDataGrid.CONTEXT_MENU_TAP_HOLD_DURATION = 750;
  DvtDataGrid.HEADER_TAP_SHORT_HOLD_DURATION = 300;

  // when filling viewport fetch when this close to the edge
  DvtDataGrid.FETCH_PIXEL_THRESHOLD = 5;

  // visibility constants
  DvtDataGrid.VISIBILITY_STATE_HIDDEN = 'hidden';

  DvtDataGrid.VISIBILITY_STATE_REFRESH = 'refresh';

  DvtDataGrid.VISIBILITY_STATE_RENDER = 'render';

  DvtDataGrid.VISIBILITY_STATE_VISIBLE = 'visible';

  // Default spacer width
  DvtDataGrid.SPACER_DEFAULT_WIDTH = 2;

  // Default skeleton row or column count
  DvtDataGrid.SKELETON_DEFAULT_COUNT = 3;
  /**
   * Sets options on DataGrid
   * @param {Object} options - the options to set on the data grid
   * @param {Function} rendererWrapperFunction - callback function used to fix renderer function for custom element
   */
  DvtDataGrid.prototype.SetOptions = function (options, rendererWrapperFunction) {
    this.m_options = new DvtDataGridOptions(options, rendererWrapperFunction);
  };

  /**
   * Sets the original event after a sort event for use in selectionChanged events
   * @param {Event} event - sort event to store
   */
  DvtDataGrid.prototype.SetSortOriginalEvent = function (event) {
    if (this.m_sortColumnInfo) {
      this.m_sortColumnInfo.originalEvent = event;
    }
  };

  /**
   * Update options on DataGrid
   * @param {Object} options - the options to set on the data grid
   * @param {Object=} flags - contains modified subkey
   */
  DvtDataGrid.prototype.UpdateOptions = function (options, flags) {
    var candidates = Object.keys(options);
    var candidate;
    var i;

    // We should check each updated option (candidate) from the list of updated options (first loop)
    // against options already presented in the internal DvtDataGridOptions (this.m_options) object in
    // purpose to keep them in sync.
    for (i = 0; i < candidates.length; i++) {
      candidate = candidates[i];
      if (candidate in this.m_options.options) {
        if (this.m_options.options[candidate] !== options[candidate]) {
          this.m_options.options[candidate] = options[candidate];
        }
      }
    }

    // now update it
    for (i = 0; i < candidates.length; i++) {
      candidate = candidates[i];
      if (!this._updateDataGrid(candidate, flags)) {
        // should not get here because refresh is handled by external wrapper
        this.empty();
        this.refresh(this.m_root);
        break;
      }
    }
  };

  /**
   * Partial update for DataGrid
   * @private
   * @param {string} option - the option to update the data grid based on
   * @param {Object=} flags - contains modified subKey if applicable
   * @return {boolean} true if redraw is not required otherwise return false
   */
  DvtDataGrid.prototype._updateDataGrid = function (option, flags) {
    var obj;

    switch (option) {
      // updates the data grid can make without refresh
      case 'bandingInterval':
        this._removeBanding();
        this.updateColumnBanding();
        this.updateRowBanding();
        break;
      case 'currentCell':
        obj = this.m_options.getCurrentCell();
        this._updateActive(obj, true, false);
        break;
      case 'editMode':
        this.m_editMode = this.m_options.getEditMode();
        break;
      case 'gridlines':
        this._updateGridlines();
        break;
      case 'header':
        obj = this.m_options.options.header;
        this._updateHeaderOptions(obj, flags);
        break;
      case 'scrollPosition':
        obj = this.m_options.getScrollPosition();
        this._updateScrollPosition(obj);
        break;
      case 'selection':
        obj = this.m_options.getSelection();
        this._updateSelection(obj);
        break;
      case 'selectionMode':
        this._clearSelection(null);
        break;
      case 'frozenColumnCount':
        obj = this.m_options._getFreezeIndex('column');
        this._updateFrozenSection(obj, 'column');
        break;
      case 'frozenRowCount':
        obj = this.m_options._getFreezeIndex('row');
        this._updateFrozenSection(obj, 'row');
        break;
      case 'hiddenColumns':
        obj = this.m_options._getHiddenIndices('column');
        this._updateHiddenSection(Array.from(obj), 'column');
        break;
      case 'hiddenRows':
        obj = this.m_options._getHiddenIndices('row');
        this._updateHiddenSection(Array.from(obj), 'row');
        break;
      // just refresh
      default:
        return false;
    }
    return true;
  };

  /**
   * Update selection from option
   * @private
   * @param {Object} selection the selection from options
   */
  DvtDataGrid.prototype._updateSelection = function (selection) {
    // selection should not be null
    if (selection == null) {
      return;
    }

    // check whether selection is enabled
    if (this._isSelectionEnabled()) {
      // don't clear the selection so the old one can be passed in
      // sets the new selection
      this.SetSelection(selection);
    }
  };

  /**
   * Update header resizable and sortable options, all others refresh the grid for now
   * @private
   * @param {Object} headerObject
   * @param {Object=} flags
   */
  DvtDataGrid.prototype._updateHeaderOptions = function (headerObject, flags) {
    if (flags == null || flags.subkey == null) {
      // should not get here as handled by outisde wrapper
      return;
    }

    var subKey = flags.subkey;
    var subKeyArray = subKey.split('.');
    var axis = subKeyArray[0];
    var option = subKeyArray[1];
    var headers;

    if (axis === 'column' && this.m_colHeader != null && this.m_colHeader.firstChild != null) {
      headers = this.m_colHeader.firstChild.childNodes;
    } else if (axis === 'row' && this.m_rowHeader != null && this.m_rowHeader.firstChild != null) {
      headers = this.m_rowHeader.firstChild.childNodes;
    } else if (
      axis === 'columnEnd' &&
      this.m_colEndHeader != null &&
      this.m_colEndHeader.firstChild != null
    ) {
      headers = this.m_colEndHeader.firstChild.childNodes;
    } else if (
      axis === 'rowEnd' &&
      this.m_rowEndHeader != null &&
      this.m_rowEndHeader.firstChild != null
    ) {
      headers = this.m_rowEndHeader.firstChild.childNodes;
    }

    if (headers != null) {
      for (var i = 0; i < headers.length; i++) {
        var header = headers[i];
        var headerContext = header[this.getResources().getMappedAttribute('context')];
        headerContext.index = this.getHeaderCellIndex(header);

        if (option === 'resizable') {
          if (this._isHeaderResizeEnabled(axis, headerContext)) {
            this._setAttribute(header, option, 'true');
          } else {
            this._setAttribute(header, option, 'false');
          }
        } else if (option === 'sortable') {
          const horizontalAlignment = this.m_options.getHorizontalAlignment(axis, headerContext);
          var hasSortContainer = this._getSortContainer(header) != null;
          if (this._isSortEnabled(axis, headerContext)) {
            if (!hasSortContainer) {
              var sortIcon = this._buildSortIcon(headerContext, header);
              if (this._shouldAppendIcon(horizontalAlignment, axis, headerContext)) {
                header.appendChild(sortIcon); // @HTMLUpdateOK
              } else {
                header.insertBefore(sortIcon, header.childNodes[0]); // @HTMLUpdateOK
              }
            }
            this._setAttribute(header, option, 'true');
          } else {
            if (hasSortContainer) {
              this._remove(this._getSortContainer(header));
            }
            this._setAttribute(header, option, 'false');
          }
        }
      }
    }
  };

  /**
   * Update gridlines
   * @private
   */
  DvtDataGrid.prototype._updateGridlines = function () {
    var horizontalGridlines = this.m_options.getHorizontalGridlines();
    var verticalGridlines = this.m_options.getVerticalGridlines();
    var dir = this.getResources().isRTLMode() ? 'right' : 'left';

    if (this.m_databody && this.m_databody.firstChild) {
      let cells = this.m_databody.firstChild.querySelectorAll('.' + this.getMappedStyle('cell'));
      let lastRow = this._getLastAxis('row');
      let lastColumn = this._getLastAxis('column');
      for (let i = 0; i < cells.length; i++) {
        let cell = cells[i];
        let indexes = this.getCellIndexes(cell);
        if (
          verticalGridlines === 'hidden' ||
          (indexes.column === lastColumn &&
            (this.getRowHeaderWidth() + this.getElementDir(cell, dir) + this.getElementWidth(cell) >=
              this.getWidth() ||
              this.m_endRowEndHeader > -1))
        ) {
          this.m_utils.addCSSClassName(cell, this.getMappedStyle('borderVerticalNone'));
        } else {
          this.m_utils.removeCSSClassName(cell, this.getMappedStyle('borderVerticalNone'));
        }

        if (
          horizontalGridlines === 'hidden' ||
          (indexes.row === lastRow &&
            (this.getRowBottom(cell, null) >= this.getHeight() || this.m_endColEndHeader > -1))
        ) {
          this.m_utils.addCSSClassName(cell, this.getMappedStyle('borderHorizontalNone'));
        } else {
          this.m_utils.removeCSSClassName(cell, this.getMappedStyle('borderHorizontalNone'));
        }
      }
    }
  };

  /**
   * Updates the borders of cells along the grid edges for focus ring spacing to be appropriated correctly
   * @param {string=} activeValue current border value
   */
  DvtDataGrid.prototype._updateEdgeCellBorders = function (activeValue) {
    if (this.m_active != null && this.m_active.type === 'cell') {
      var activeCell = this._getActiveElement();
      if (activeCell != null) {
        if ((this._isCellEditable() && activeValue === '') || activeValue !== '') {
          let className = 'Edit';
          let metadata = this.getResources().getMappedAttribute('metadata');
          if (
            activeCell[metadata]?.metadata?.validity === 'invalidShown' &&
            this.m_currentMode !== 'navigation'
          ) {
            className = 'EditInvalid';
          }
          this._applyBorderClassesAroundRange(
            activeCell,
            { startIndex: this.m_active.indexes },
            activeValue === '',
            className
          );
        }

        if (this._isLastRow(this.m_active.indexes.row)) {
          if (activeValue === 'none') {
            this.m_utils.addCSSClassName(activeCell, this.getMappedStyle('borderHorizontalNone'));
          } else {
            this.m_utils.removeCSSClassName(activeCell, this.getMappedStyle('borderHorizontalNone'));
          }
        }

        if (this._isLastColumn(this.m_active.indexes.column)) {
          if (activeValue === 'none') {
            this.m_utils.addCSSClassName(activeCell, this.getMappedStyle('borderVerticalNone'));
          } else {
            this.m_utils.removeCSSClassName(activeCell, this.getMappedStyle('borderVerticalNone'));
          }
        }
      }
    }
  };

  /**
   * Sets resources on DataGrid
   * @param {Object} resources - the resources to set on the data grid
   */
  DvtDataGrid.prototype.SetResources = function (resources) {
    this.m_resources = resources;
  };

  /**
   * Gets resources from DataGrid
   * @return {Object} the resources set on the data grid
   */
  DvtDataGrid.prototype.getResources = function () {
    return this.m_resources;
  };

  /**
   * Gets start row header index from DataGrid
   * @return {number} the start row header index
   */
  DvtDataGrid.prototype.getStartRowHeader = function () {
    return this.m_startRowHeader;
  };

  /**
   * Gets start column header index from DataGrid
   * @return {number} the start column header index
   */
  DvtDataGrid.prototype.getStartColumnHeader = function () {
    return this.m_startColHeader;
  };

  /**
   * Gets start row end header index from DataGrid
   * @return {number} the start row end header index
   */
  DvtDataGrid.prototype.getStartRowEndHeader = function () {
    return this.m_startRowEndHeader;
  };

  /**
   * Gets start column end header index from DataGrid
   * @return {number} the start column end header index
   */
  DvtDataGrid.prototype.getStartColumnEndHeader = function () {
    return this.m_startColEndHeader;
  };

  /**
   * Gets mapped style from the resources
   * @private
   * @param {string} key the key to get style on
   * @return {string} the style from the resources
   */
  DvtDataGrid.prototype.getMappedStyle = function (key) {
    return this.getResources().getMappedStyle(key);
  };

  /**
   * Sets the data source on DataGrid
   * @param {Object} dataSource - the data source to set on the data grid
   */
  DvtDataGrid.prototype.SetDataSource = function (dataSource) {
    // if we are setting a new data source be sure to clear out any old
    // model events
    this.m_modelEvents = [];

    this.m_dataSource = dataSource;
  };

  /**
   * Gets the data source from the DataGrid
   * @return {Object} the data source set on the data grid
   */
  DvtDataGrid.prototype.getDataSource = function () {
    return this.m_dataSource;
  };

  /**
   * Set the internal visibility of datagrid
   * @param {string} state a string for the visibility
   */
  DvtDataGrid.prototype.setVisibility = function (state) {
    this.m_visibility = state;
  };

  /**
   * Get the internal visibility of datagrid
   * @return {string} visibility
   */
  DvtDataGrid.prototype.getVisibility = function () {
    if (this.m_visibility == null) {
      if (this.m_root.offsetParent != null) {
        this.setVisibility(DvtDataGrid.VISIBILITY_STATE_VISIBLE);
      } else {
        this.setVisibility(DvtDataGrid.VISIBILITY_STATE_HIDDEN);
      }
    }
    return this.m_visibility;
  };

  /**
   * Set the callback for remove
   * @param {Function} callback a callback for the remove function
   */
  DvtDataGrid.prototype.SetOptionCallback = function (callback) {
    this.m_setOptionCallback = callback;
  };

  /**
   * Set the callback for remove
   * @param {Function} callback a callback for the remove function
   */
  DvtDataGrid.prototype.SetContextCallback = function (callback) {
    this.m_contextCallback = callback;
  };

  /**
   * Set the callback for custom element
   * @param {Function} callback a callback
   */
  DvtDataGrid.prototype.SetCustomElementCallback = function (callback) {
    this.m_isCustomElementCallback = callback;
  };

  /**
   * Set the callback for remove
   * @param {Function} callback a callback for the remove function
   */
  DvtDataGrid.prototype.SetRemoveCallback = function (callback) {
    this.m_removeCallback = callback;
  };

  /**
   * Set the callback for add or remove of id
   * @param {Function} callback a callback for the unique id function
   */
  DvtDataGrid.prototype.SetUniqueIdCallback = function (callback) {
    this._uniqueIdCallback = callback;
  };

  /**
   * Set the callback for compare values
   * @param {Function} callback a callback for the compare values function
   */
  DvtDataGrid.prototype.SetCompareValuesCallback = function (callback) {
    this._compareValuesCallback = callback;
  };

  /**
   * Set the callback for subtreeAttached that should be called when adding content to the dom
   * @param {Function} callback a callback for the subtree attached function
   */
  DvtDataGrid.prototype.SetSubtreeAttachedCallback = function (callback) {
    this.m_subtreeAttachedCallback = callback;
  };

  /**
   * Set the callback for updating scroll position on refresh
   * @param {Function} callback a callback for the update scroll position
   */
  DvtDataGrid.prototype.SetUpdateScrollPostionOnRefreshCallback = function (callback) {
    this.m_updateScrollPostionOnRefreshCallback = callback;
  };

  /**
   * Remove an element from the DOM, if it is not being reattached
   * @param {Element} element the element to remove
   */
  DvtDataGrid.prototype._remove = function (element) {
    if (element != null) {
      this._uniqueIdCallback(element, true);

      // callback allows jQuery to clean the node on a remove
      this.m_removeCallback.call(null, element);
    }
  };

  /**
   * Remove all elements in an array of elements
   * @param {Array} elems an array of the elements that need to be removed
   */
  DvtDataGrid.prototype._removeFromArray = function (elems) {
    for (var i = 0; i < elems.length; i++) {
      this._remove(elems[i]);
    }
  };

  /**
   * Set the callback for signifying not ready
   * @param {Function} callback a callback for the not ready function
   */
  DvtDataGrid.prototype.SetNotReadyCallback = function (callback) {
    this.m_notReady = callback;
  };

  /**
   * Set the callback for signifying ready
   * @param {Function} callback a callback for the make ready function
   */
  DvtDataGrid.prototype.SetMakeReadyCallback = function (callback) {
    this.m_makeReady = callback;
  };

  /**
   * Invoke whenever a task is started. Moves the component out of the ready state if necessary.
   */
  DvtDataGrid.prototype._signalTaskStart = function () {
    if (this.m_readinessStack) {
      if (this.m_readinessStack.length === 0) {
        this.m_notReady();
      }
      this.m_readinessStack.push(1);
    }
  };

  /**
   * Invoke whenever a task finishes. Resolves the readyPromise if component is ready to move into ready state.
   */
  DvtDataGrid.prototype._signalTaskEnd = function () {
    if (this.m_readinessStack && this.m_readinessStack.length > 0) {
      this.m_readinessStack.pop();
      if (this.m_readinessStack.length === 0) {
        this.m_makeReady();
      }
    }
  };

  /**
   * Get the indexes from the data source and call back to a function once they are available.
   * The callback should be a function(keys, indexes)
   * @param {Object} keys the keys to find the index of with properties row, column
   * @param {Function} callback the callback to pass the keys back to
   * @private
   */
  DvtDataGrid.prototype._indexes = function (keys, callback) {
    var self = this;
    var indexes = this.getDataSource().indexes(keys);

    if (typeof indexes.then === 'function') {
      // start async indexes call
      self._signalTaskStart();
      indexes.then(
        function (obj) {
          callback.call(self, obj, keys);
          // end async indexes call
          self._signalTaskEnd();
        },
        function () {
          callback.call(self, { row: -1, column: -1 }, keys);
          // end async indexes call
          self._signalTaskEnd();
        }
      );
    } else {
      callback.call(self, indexes, keys);
    }
  };

  /**
   * Get the keys from the data source and call back to a function once they are available.
   * The callback should be a function(indexes, keys)
   * @param {Object} indexes the indexes to find the keys of with properties row, column
   * @param {Function} callback the callback to pass the indexes back to
   * @private
   */
  DvtDataGrid.prototype._keys = function (indexes, callback) {
    var self = this;
    var localKeys = this._getLocalKeys(indexes);
    if (localKeys !== undefined) {
      callback.call(self, localKeys, indexes);
      return;
    }

    // check for individual stuff
    var keys = this.getDataSource().keys(indexes);
    if (typeof keys.then === 'function') {
      // start async call
      self._signalTaskStart();
      keys.then(
        function (obj) {
          callback.call(self, obj, indexes);
          // end async indexes call
          self._signalTaskEnd();
        },
        function () {
          callback.call(self, { row: null, column: null }, indexes);
          // end async indexes call
          self._signalTaskEnd();
        }
      );
    } else {
      callback.call(self, keys, indexes);
    }
  };

  /**
   * Get keys from the dom based on indexes if possible
   * @param {Object} indexes the indexes to find the keys of with properties row, column
   * @return {Object} keys
   */
  DvtDataGrid.prototype._getLocalKeys = function (indexes) {
    var cell = this._getCellByIndex(indexes);
    if (cell) {
      return this.getCellKeys(cell);
    }

    var rowIndex = indexes.row;
    var columnIndex = indexes.column;
    var rowKey;
    var columnKey;
    if (rowIndex !== undefined) {
      if (rowIndex === -1) {
        rowKey = null;
      } else {
        var rowElement = this._getCellOrHeaderByIndex(rowIndex, 'row');
        if (rowElement) {
          rowKey = this._getKey(rowElement, 'row');
        }
      }

      if (rowKey === undefined) {
        return undefined;
      }
    }

    if (columnIndex !== undefined) {
      if (columnIndex === -1) {
        columnKey = null;
      } else {
        var columnElement = this._getCellOrHeaderByIndex(columnIndex, 'column');
        if (columnElement) {
          columnKey = this._getKey(columnElement, 'column');
        }
      }

      if (columnKey === undefined) {
        return undefined;
      }
    }

    return this.createIndex(rowKey, columnKey);
  };

  /**
   * Register a callback when creating the header context or cell context.
   * @param {function(Object)} callback the callback function to inject addition or modify
   *        properties in the context.
   */
  DvtDataGrid.prototype.SetCreateContextCallback = function (callback) {
    this.m_createContextCallback = callback;
  };

  /**
   * Register the focusable callbacks for handling focus classNames
   * @param {function()} focusInHandler
   * @param {function()} focusOutHandler
   */
  DvtDataGrid.prototype.SetFocusableCallback = function (focusInHandler, focusOutHandler) {
    this.m_focusInHandler = focusInHandler;
    this.m_focusOutHandler = focusOutHandler;
  };

  /**
   * Register a callback when creating the header context or cell context.
   * @param {function(Object)} callback the callback function to inject addition or modify
   *        properties in the context.
   */
  DvtDataGrid.prototype.SetFixContextCallback = function (callback) {
    this.m_fixContextCallback = callback;
  };

  /**
   * Sets root custom element
   * @param {Element} customElement root custom element
   */
  DvtDataGrid.prototype.SetCustomElement = function (customElement) {
    this.m_customElement = customElement;
  };

  /**
   * Whether high-water mark scrolling is used
   * @return {boolean} true if high-water mark scrolling is used, false otherwise
   * @private
   */
  DvtDataGrid.prototype._isHighWatermarkScrolling = function () {
    return this.m_options.getScrollPolicy() !== 'scroll';
  };

  /**
   * Destructor method that should be called when the widget is destroyed. Removes event
   * listeners on the document.
   */
  DvtDataGrid.prototype.destroy = function () {
    delete this.m_fetching;
    this._removeDataSourceEventListeners();
    this._removeDomEventListeners();
    delete this.m_styleClassDimensionMap;
    this.m_styleClassDimensionMap = { width: {}, height: {} };
  };

  /**
   * Adds data source event listeners
   * @private
   */
  DvtDataGrid.prototype._addDataSourceEventListeners = function () {
    this._removeDataSourceEventListeners();

    if (this.m_dataSource != null) {
      this.m_handleModelEventListener = this.handleModelEvent.bind(this);
      this.m_handleExpandEventListener = this.handleExpandEvent.bind(this);
      this.m_handleCollapseEventListener = this.handleCollapseEvent.bind(this);

      this.m_dataSource.on('change', this.m_handleModelEventListener, this);
      // if it's not flattened datasource, these will be ignored
      this.m_dataSource.on('expand', this.m_handleExpandEventListener, this);
      this.m_dataSource.on('collapse', this.m_handleCollapseEventListener, this);
    }
  };

  /**
   * Remove data source event listeners
   * @private
   */
  DvtDataGrid.prototype._removeDataSourceEventListeners = function () {
    if (this.m_dataSource != null) {
      this.m_dataSource.off('change', this.m_handleModelEventListener);
      this.m_dataSource.off('expand', this.m_handleExpandEventListener);
      this.m_dataSource.off('collapse', this.m_handleCollapseEventListener);
    }
  };

  /**
   * Adds event listeners registered on the document or the root element
   * @private
   */
  DvtDataGrid.prototype._addDomEventListeners = function () {
    if (!this.m_handleDatabodyKeyDown) {
      this.m_handleDatabodyKeyDown = this.handleDatabodyKeyDown.bind(this);
    }
    if (!this.m_handleDatabodyKeyUp) {
      this.m_handleDatabodyKeyUp = this.handleDatabodyKeyUp.bind(this);
    }
    if (!this.m_handleRootFocus) {
      this.m_handleRootFocus = this.handleRootFocus.bind(this);
    }
    if (!this.m_handleRootBlur) {
      this.m_handleRootBlur = this.handleRootBlur.bind(this);
    }

    this.m_root.addEventListener('keydown', this.m_handleDatabodyKeyDown, false);
    this.m_root.addEventListener('keyup', this.m_handleDatabodyKeyUp, false);
    this.m_root.addEventListener('focus', this.m_handleRootFocus, true);
    this.m_root.addEventListener('blur', this.m_handleRootBlur, true);
  };

  /**
   * Remove dom event listeners
   * @private
   */
  DvtDataGrid.prototype._removeDomEventListeners = function () {
    document.removeEventListener('mousemove', this.m_docMouseMoveListener, false);
    document.removeEventListener('mouseup', this.m_docMouseUpListener, false);
    // unregister all listeners

    if (this.m_root != null) {
      if (this.m_handleDatabodyKeyDown) {
        this.m_root.removeEventListener('keydown', this.m_handleDatabodyKeyDown, false);
      }
      if (this.m_handleDatabodyKeyUp) {
        this.m_root.removeEventListener('keyup', this.m_handleDatabodyKeyUp, false);
      }
      if (this.m_handleRootFocus) {
        this.m_root.removeEventListener('focus', this.m_handleRootFocus, true);
      }
      if (this.m_handleRootBlur) {
        this.m_root.removeEventListener('blur', this.m_handleRootBlur, true);
      }
    }
  };

  /**
   * Get the DataGrid root element
   * @return {Element} the root element
   */
  DvtDataGrid.prototype.getRootElement = function () {
    return this.m_root;
  };

  /**
   * Get the cached width of the root element. If not cached, sets the cached width.
   * @return {number} the cached width of the root element
   * @protected
   */
  DvtDataGrid.prototype.getWidth = function () {
    if (this.m_width == null) {
      // clientWidth since we use border box and care about the content of our root div
      this.m_width = this.getRootElement().clientWidth;
    }

    return this.m_width;
  };

  /**
   * Get the cached height of the root element. If not cached, sets the cached height.
   * @return {number} the cached height of the root element
   * @protected
   */
  DvtDataGrid.prototype.getHeight = function () {
    if (this.m_height == null) {
      // clientHeight since we use border box and care about the content of our root div
      this.m_height = this.getRootElement().clientHeight;
    }

    return this.m_height;
  };

  /**
   * Get the viewport width, which is defined as 1.5 the size of the width of Grid
   * @return {number} the viewport width
   */
  DvtDataGrid.prototype.getViewportWidth = function () {
    var width = this.getWidth();
    return Math.round(width * 1.5);
  };

  /**
   * Get the viewport height, which is defined as 1.5 the size of the height of Grid
   * @return {number} the viewport height
   */
  DvtDataGrid.prototype.getViewportHeight = function () {
    var height = this.getHeight();
    return Math.round(height * 1.5);
  };

  /**
   * Get viewport top
   * @return {number} the viewport top
   */
  DvtDataGrid.prototype._getViewportTop = function () {
    return this.m_currentScrollTop;
  };

  /**
   * Get viewport bottom
   * @return {number} the viewport bottom
   */
  DvtDataGrid.prototype._getViewportBottom = function () {
    var top = this._getViewportTop();
    var databodyHeight = this.getElementHeight(this.m_databody);
    var scrollbarSize = this.m_utils.getScrollbarSize();

    return this.m_hasHorizontalScroller ? top + databodyHeight - scrollbarSize : top + databodyHeight;
  };

  /**
   * Get viewport left
   * @return {number} the viewport left
   */
  DvtDataGrid.prototype._getViewportLeft = function () {
    return this.m_currentScrollLeft;
  };

  /**
   * Get viewport right
   * @return {number} the viewport right
   */
  DvtDataGrid.prototype._getViewportRight = function () {
    var left = this._getViewportLeft();
    var databodyWidth = this.getElementWidth(this.m_databody);
    var scrollbarSize = this.m_utils.getScrollbarSize();

    return this.m_hasVerticalScroller ? left + databodyWidth - scrollbarSize : left + databodyWidth;
  };

  /**
   * Calculate the fetch size for rows or columns
   * @param {string} axis - the axis 'row'/'column' to get fetch size on
   * @return {number} the fetch size
   */
  DvtDataGrid.prototype.getFetchSize = function (axis) {
    // get the cached fetch size, this should be clear when the size changes
    if (axis === 'row') {
      if (this.m_rowFetchSize == null) {
        this.m_rowFetchSize = Math.max(
          1,
          Math.round(this.getViewportHeight() / this.getDefaultRowHeight())
        );
      }

      return this.m_rowFetchSize;
    }
    if (axis === 'column') {
      if (this.m_columnFetchSize == null) {
        this.m_columnFetchSize = Math.max(
          1,
          Math.round(this.getViewportWidth() / this.getDefaultColumnWidth())
        );
      }
      return this.m_columnFetchSize;
    }

    return 0;
  };

  /**
   * If the empty text option is 'default' return default empty translated text,
   * otherwise return the emptyText set in the options
   * @return {string} the empty text
   */
  DvtDataGrid.prototype.getEmptyText = function () {
    var emptyText = this.m_options.getEmptyText();
    if (emptyText == null) {
      var resources = this.getResources();
      emptyText = resources.getTranslatedText('msgNoData');
    }
    return emptyText;
  };

  /**
   * Build an empty text div and populate it with empty text
   * @return {Element} the empty text element
   * @private
   */
  DvtDataGrid.prototype._buildEmptyText = function () {
    let databody;
    // if there is no dataprovider, trying to create databody to insert empty state text
    // see buildgrid function for the flow.
    if (this.getDataSource() == null) {
      let width = this.getWidth();
      let height = this.getHeight();
      databody = this.buildDatabody(true)[0];
      this.setElementWidth(databody, width);
      this.setElementHeight(databody, height);
      this.m_root.insertBefore(databody, this.m_status); // @HTMLUpdateOK
    }
    const templateEngine = this._getTemplateEngine();
    const noDataTemplate = this._getItemTemplateBySlotName('noData');
    databody = this.m_databody;
    if (noDataTemplate && templateEngine != null) {
      let noDataContent = document.createElement('div');
      // prettier-ignore
      noDataContent.setAttribute( // @HTMLUpdateOK
        this.getResources().getMappedAttribute('container'),
        this.getResources().widgetName
      );
      noDataContent.setAttribute(this.getResources().getMappedAttribute('busyContext'), ''); // @HTMLUpdateOK
      noDataContent.id = this.createSubId('noData');
      this.m_utils.addCSSClassName(noDataContent, this.getMappedStyle('noDataContainer'));
      var nodes = templateEngine.execute(this.getRootElement(), noDataTemplate, {}, null, databody);
      nodes.forEach(function (node) {
        noDataContent.appendChild(node); // @HTMLUpdateOK
      });
      this._removeFocusFromChildElements({}, noDataContent);
      return noDataContent; // returning
    }
    var emptyText = this.getEmptyText();
    var empty = document.createElement('div');
    empty.id = this.createSubId('empty');
    empty.className = this.getMappedStyle('emptytext');
    empty.textContent = emptyText;
    this.m_empty = empty;
    return empty;
  };

  /**
   * Determine the size of the buffer that triggers fetching of rows. For example,
   * if the size of the buffer is zero, then the fetch will be triggered when the
   * scroll position reached the end of where the current range ends
   * @return {number} the row threshold
   */
  DvtDataGrid.prototype.getRowThreshold = function () {
    return 0;
  };

  /**
   * Determine the size of the buffer that triggers fetching of columns. For example,
   * if the size of the buffer is zero, then the fetch will be triggered when the
   * scroll position reached the end of where the current range ends.
   * @return {number} the column threshold
   */
  DvtDataGrid.prototype.getColumnThreshold = function () {
    return 0;
  };

  /*
   * Caches the default datagrid dimensions located in the style sheet, creates
   * just one div to reduce createElement calls. This function should get called once on create.
   * Values found in style are:
   *  column width
   *  row height
   */
  DvtDataGrid.prototype.setDefaultDimensions = function () {
    var div = document.createElement('div');
    div.style.visibilty = 'hidden';

    var resources = this.getResources();
    // we can avoid a repaint by using both row and headercell here because this isn't where the col height and row width are set
    div.className =
      resources.getMappedStyle('rowheadercell') +
      ' ' +
      resources.getMappedStyle('colheadercell') +
      ' ' +
      resources.getMappedStyle('headercell');
    this.m_root.appendChild(div); // @HTMLUpdateOK
    // can use offset due to fixes in chrome partial pixel rounding fixes
    this.m_defaultColumnWidth = div.offsetWidth;
    this.m_defaultRowHeight = div.offsetHeight;

    // minimize reflows
    this.getViewportWidth();
    this.getViewportHeight();

    this.m_root.removeChild(div);
  };

  /**
   * Get the default row height which comes from the style sheet
   * @return {number} the default row height
   */
  DvtDataGrid.prototype.getDefaultRowHeight = function () {
    if (this.m_defaultRowHeight == null) {
      this.setDefaultDimensions();
    }
    return this.m_defaultRowHeight;
  };

  /**
   * Get the default column width which comes from the stylesheet
   * @return {number} the default column width
   */
  DvtDataGrid.prototype.getDefaultColumnWidth = function () {
    if (this.m_defaultColumnWidth == null) {
      this.setDefaultDimensions();
    }
    return this.m_defaultColumnWidth;
  };

  /**
   * Gets the header dimension for an axis, for rows this would be height, for columns, width
   * @param {Element} elem the header element to get dimension of
   * @param {string|null} key the row or column key
   * @param {string} axis row or column
   * @param {string} dimension width ro height
   */
  DvtDataGrid.prototype._getHeaderDimension = function (elem, key, axis, dimension) {
    var value = this.m_sizingManager.getSize(axis, key);
    if (value != null) {
      return value;
    }

    // check if inline style set on element
    if (elem.style[dimension] !== '') {
      value = this.getElementDir(elem, dimension);
      // in the event that row height is set via an additional style only on row header store the value
      this.m_sizingManager.setSize(axis, key, value);
      return value;
    }

    // check style class mapping, mapping prevents multiple offsetHeight calls on headers with the same class name
    var className = elem.className;
    value = this.m_styleClassDimensionMap[dimension][className];
    if (value == null) {
      // exhausted all options, use offsetHeight then, remove element in the case of shim element
      value = this.getElementDir(elem, dimension);
    }

    // the value isn't the default the cell will use meaning it's from an external
    // class, so store it in the sizing manager cell can pick it up, header and cell dimension can vary on em
    this.m_sizingManager.setSize(axis, key, value);

    this.m_styleClassDimensionMap[dimension][className] = value;
    return value;
  };

  /**
   * Helper method to create subid based on the root element's id
   * @param {string} subId - the id to append to the root element id
   * @return {string} the subId to append to the root element id
   */
  DvtDataGrid.prototype.createSubId = function (subId) {
    // id empty string if not set, enver null
    var id = this.getRootElement().id;
    return [id, subId].join(':');
  };

  /**
   * Checks whether header fetching is completed
   * @return {boolean} true if header fetching completed, else false
   */
  DvtDataGrid.prototype.isHeaderFetchComplete = function () {
    return this.m_fetching.row === false && this.m_fetching.column === false;
  };

  /**
   * Checks whether header AND cell fetching is completed
   * @return {boolean} true if header AND cell fetching completed, else false
   */
  DvtDataGrid.prototype.isFetchComplete = function () {
    return this.m_fetching != null && this.isHeaderFetchComplete() && this.m_fetching.cells === false;
  };

  /**
   * Checks whether the index is the last row
   * @param {number} index
   * @return {boolean} true if it's the last row, false otherwise
   */
  DvtDataGrid.prototype._isLastRow = function (index) {
    if (this._isCountUnknown('row')) {
      // if row count is unknown, then the last row is if the index is before the last row fetched
      // and there's no more rows from datasource
      return index === this.m_endRow && this.m_stopRowFetch;
    }

    // if column count is known, then just check the index with the total column count
    return index + 1 === this.getDataSource().getCount('row');
  };

  /**
   * Checks whether the index is the last column
   * @param {number} index
   * @return {boolean} true if it's the last column, false otherwise
   */
  DvtDataGrid.prototype._isLastColumn = function (index) {
    if (this._isCountUnknown('column')) {
      // if column count is unknown, then the last column is if the index is the last column fetched
      // and there's no more columns from datasource
      return index === this.m_endCol && this.m_stopColumnFetch;
    }

    // if column count is known, then just check the index with the total column count
    return index + 1 === this.getDataSource().getCount('column');
  };

  DvtDataGrid.prototype._getLastAxis = function (axis) {
    if (this._isCountUnknown(axis)) {
      if (axis === 'row' ? this.m_stopRowFetch : this.m_stopColumnFetch) {
        return axis === 'row' ? this.m_endRow : this.m_endCol;
      }
      return axis === 'row' ? this.m_endRow + 1 : this.m_endCol + 1;
    }
    return this.getDataSource().getCount(axis) - 1;
  };

  /**
   * Removes all of the datagrid children built by DvtDataGrid, this excludes context menus/popups
   */
  DvtDataGrid.prototype.empty = function () {
    // remove everything that will be rebuilt
    if (this.m_empty) {
      this._remove(this.m_empty);
    }
    if (this.m_corner) {
      this._remove(this.m_corner);
    }
    if (this.m_bottomCorner) {
      this._remove(this.m_bottomCorner);
    }
    if (this.m_columnHeaderScrollbarSpacer) {
      this._remove(this.m_columnHeaderScrollbarSpacer);
    }
    if (this.m_rowHeaderScrollbarSpacer) {
      this._remove(this.m_rowHeaderScrollbarSpacer);
    }

    this.m_root.removeChild(this.m_placeHolder);
    this.m_root.removeChild(this.m_status);
    this.m_root.removeChild(this.m_accSummary);
    this.m_root.removeChild(this.m_accInfo);
    this.m_root.removeChild(this.m_stateInfo);
    this.m_root.removeChild(this.m_contextInfo);
    // elements that may contain other components
    this._remove(this.m_colHeader);
    this._remove(this.m_rowHeader);
    this._remove(this.m_colEndHeader);
    this._remove(this.m_rowEndHeader);
    this._remove(this.m_databody);
    this._remove(this.m_databodyFrozenCol);
    this._remove(this.m_databodyFrozenRow);
    this._remove(this.m_databodyFrozenCorner);
    this._remove(this.m_colHeaderFrozen);
    this._remove(this.m_colEndHeaderFrozen);
    this._remove(this.m_rowHeaderFrozen);
    this._remove(this.m_rowEndHeaderFrozen);

    this._clearDatabodyMap();
  };

  /**
   * Re-renders the data grid. Resets all the necessary properties.
   * @param {Element} root - the root dom element for the DataGrid.
   */
  DvtDataGrid.prototype.refresh = function (root) {
    this.resetInternal();
    this.render(root);
  };

  /**
   * Resets internal state of data grid.
   * @private
   */
  DvtDataGrid.prototype.resetInternal = function () {
    this.m_initialized = false;
    this.m_readinessStack = [];
    this._signalTaskStart();
    this._signalTaskEnd();

    // databody map
    this._clearDatabodyMap();

    // cursor
    this.m_cursor = null;

    // dom elements
    this.m_corner = null;
    this.m_bottomCorner = null;
    this.m_columnHeaderScrollbarSpacer = null;
    this.m_rowHeaderScrollbarSpacer = null;
    this.m_colHeader = null;
    this.m_colEndHeader = null;
    this.m_rowHeader = null;
    this.m_rowEndHeader = null;
    this.m_databody = null;
    this.m_empty = null;
    this.m_accInfo = null;
    this.m_accSummary = null;
    this.m_contextInfo = null;
    this.m_placeHolder = null;
    this.m_stateInfo = null;
    this.m_status = null;
    this.m_headerLabels = { row: [], column: [], rowEnd: [], columnEnd: [] };
    this.m_rowHeaderFrozen = null;
    this.m_rowEndHeaderFrozen = null;
    this.m_colHeaderFrozen = null;
    this.m_colEndHeaderFrozen = null;
    this.m_databodyFrozenCorner = null;
    this.m_databodyFrozenRow = null;
    this.m_databodyFrozenCol = null;

    // fetching
    this.m_isEstimateRowCount = undefined;
    this.m_isEstimateColumnCount = undefined;
    this.m_stopRowFetch = false;
    this.m_stopRowHeaderFetch = false;
    this.m_stopRowEndHeaderFetch = false;
    this.m_stopColumnFetch = false;
    this.m_stopColumnHeaderFetch = false;
    this.m_stopColumnEndHeaderFetch = false;
    this.m_rowFetchSize = null;
    this.m_columnFetchSize = null;
    this.m_fetching = null;
    this.m_processingModelEvent = false;
    this.m_processingEventQueue = false;
    this.m_animating = false;
    this.m_fetchingForUpdate = false;

    // dimensions
    this.m_sizingManager.clear();
    this.m_styleClassDimensionMap = { width: {}, height: {} };
    this.m_height = null;
    this.m_width = null;
    this.m_scrollHeight = null;
    this.m_scrollWidth = null;
    this.m_avgRowHeight = undefined;
    this.m_avgColWidth = undefined;
    this.m_defaultColumnWidth = null;
    this.m_defaultRowHeight = null;
    this.m_colHeaderHeight = null;
    this.m_colEndHeaderHeight = null;
    this.m_rowHeaderWidth = null;
    this.m_rowEndHeaderWidth = null;
    this.m_rowHeaderLevelWidths = [];
    this.m_rowEndHeaderLevelWidths = [];
    this.m_columnHeaderLevelHeights = [];
    this.m_columnEndHeaderLevelHeights = [];
    this.m_collisionResize = false;

    // active
    this.m_active = null;
    this.m_prevActive = null;
    this.m_trueIndex = {};

    // dnd
    this.m_headerDragState = false;
    this.m_databodyDragState = false;
    this.m_databodyMove = false;
    this.m_moveRow = null;
    this.m_moveRowHeader = null;
    this.m_dropTarget = null;
    this.m_dropTargetHeader = null;

    // cut/copy/paste/fill
    this.m_floodFillDragState = false;
    this.m_dataTransferAction = null;

    // selection
    this.m_discontiguousSelection = false;
    this.m_selectionFrontier = null;

    // event listeners
    this.m_docMouseMoveListener = null;
    this.m_docMouseUpListener = null;
    this.m_modelEvents = [];

    // scrolling
    this.m_hasHorizontalScroller = null;
    this.m_hasVerticalScroller = null;
    this.m_currentScrollLeft = null;
    this.m_currentScrollTop = null;
    this.m_prevScrollLeft = null;
    this.m_prevScrollTop = null;
    this.m_handleScrollOverflow = null;
    // this.m_scrollOnRefreshEvent = false;
    this._clearScrollPositionTimeout();
    this._requiresInitPostScrollFillViewport = false;

    // resizing
    this.m_resizing = false;
    this.m_resizingElement = null;
    this.m_resizingElementSibling = null;
    this.m_resizingElementMin = null;

    // data states
    this.m_startRow = null;
    this.m_startCol = null;
    this.m_endRow = null;
    this.m_endCol = null;
    this.m_startRowPixel = null;
    this.m_startColPixel = null;
    this.m_endRowPixel = null;
    this.m_endColPixel = null;
    this.m_startRowHeader = null;
    this.m_startColHeader = null;
    this.m_endRowHeader = null;
    this.m_endColHeader = null;
    this.m_startRowHeaderPixel = null;
    this.m_startColHeaderPixel = null;
    this.m_endRowHeaderPixel = null;
    this.m_endColHeaderPixel = null;
    this.m_rowHeaderLevelCount = null;
    this.m_columnHeaderLevelCount = null;
    this.m_startRowEndHeader = null;
    this.m_startColEndHeader = null;
    this.m_endRowEndHeader = null;
    this.m_endColEndHeader = null;
    this.m_startRowEndHeaderPixel = null;
    this.m_startColEndHeaderPixel = null;
    this.m_endRowEndHeaderPixel = null;
    this.m_endColEndHeaderPixel = null;
    this.m_rowEndHeaderLevelCount = null;
    this.m_columnEndHeaderLevelCount = null;
    this.m_sortColumnInfo = null;
    this.m_sortRowInfo = null;
    this.m_expandCollapseInfo = null;
    this.m_resizeRequired = null;
    this.m_externalFocus = null;
    this.m_currentMode = null;
    this.m_editMode = null;

    this.m_hasCells = null;
    this.m_hasRowHeader = null;
    this.m_hasRowEndHeader = null;
    this.m_hasColHeader = null;
    this.m_hasColEndHeader = null;
    this.m_isLongScroll = null;
    this.m_longScrollRow = null;
    this.m_longScrollColumn = null;
    this.m_longScrollRowPixel = null;
    this.m_longScrollColumnPixel = null;

    this.m_addBorderBottom = null;
    this.m_addBorderRight = null;

    this.m_sortContainerWidth = null;
    this.m_sortContainerHeight = null;

    this._resetSkeletonProperties();
    this._destroyEditableClone();
    this._clearFocusoutTimeout();
    this._clearFocusoutBusyState();
  };

  /**
   * DataGrid should initialize if there's no outstanding fetch, it is unitialized
   * and the databody is attached to the root.
   * @private
   * @returns {boolean} true if we have the properties that signify an end to initialize
   */
  DvtDataGrid.prototype._shouldInitialize = function () {
    return this.isFetchComplete() && !this.m_initialized && this.m_databody.parentNode != null;
  };

  /**
   * Handle the end of datagrid initialization whether at the end of rendering or fetching
   * @private
   * @param {boolean=} hasData false if there is no data and thus should skip resizing
   */
  DvtDataGrid.prototype._handleInitialization = function (hasData) {
    if (hasData === true) {
      this.resizeGrid();
      if (!this._databodyEmptyState() && this.m_startRow === 0 && this.m_startCol === 0) {
        this.fillViewport();
      } else {
        this._requiresInitPostScrollFillViewport = true;
      }

      if (this.isFetchComplete()) {
        this._updateActive(this.m_options.getCurrentCell(), !!this.m_focusOnRefresh, true);
        this.m_initialized = true;
        this.fireEvent('ready', {});
        this._runModelEventQueue();
      }
    } else {
      this.m_initialized = true;
      this.fireEvent('ready', {});
      this._runModelEventQueue();
    }
  };

  /**
   * Run the events in the model event list
   * The queue shifts the first event and runs that.
   * The event is expected to call _runModelEventQueue
   * once it completes
   * If the queue is empty, stop processing
   * Usage: After any animation related event chain
   *        completes, run the event queue.
   *        During the event queue, queued events
   *        should also have a call back to _runModelEventQueue
   *        at its completion. See handleExpandEvent for an example
   * @private
   */
  DvtDataGrid.prototype._runModelEventQueue = function () {
    var event;
    // Run the event queue generally after initialization
    // or animations are complete.
    // m_modelEvents acts as the queue and will
    // be initialized normally. In the case that
    // the m_modelEvent queue is accessed before
    // it is initialized, it will act as length 0 queue
    if (this.m_modelEvents != null) {
      this.m_processingEventQueue = true;
      if (this.m_modelEvents.length === 0) {
        this.m_processingEventQueue = false;
        return;
      }

      event = this.m_modelEvents.shift();

      if (event.operation === 'expand') {
        this.handleExpandEvent(event, true);
      } else if (event.operation === 'collapse') {
        this.handleCollapseEvent(event, true);
      } else {
        this.handleModelEvent(event, true);
      }
    } else {
      this.m_processingEventQueue = false;
    }
  };

  /**
   * Renders the DataGrid, initializes DataGrid properties.
   * @param {Element} root - the root dom element for the DataGrid.
   */
  DvtDataGrid.prototype.render = function (root) {
    this.m_renderCount += 1;
    this.m_timingStart = new Date();
    this.m_fetching = {};

    // since headers and cells are independently fetched, they could be returned
    // at a different time, therefore we'll need var to keep track the current range
    // for each one of them
    this.m_startRow = 0;
    this.m_startCol = 0;
    this.m_endRow = -1;
    this.m_endCol = -1;
    this.m_startRowPixel = 0;
    this.m_startColPixel = 0;
    this.m_endRowPixel = 0;
    this.m_endColPixel = 0;

    this.m_startRowHeader = 0;
    this.m_startColHeader = 0;
    this.m_endRowHeader = -1;
    this.m_endColHeader = -1;
    this.m_startRowHeaderPixel = 0;
    this.m_startColHeaderPixel = 0;
    this.m_endRowHeaderPixel = 0;
    this.m_endColHeaderPixel = 0;

    this.m_startRowEndHeader = 0;
    this.m_startColEndHeader = 0;
    this.m_endRowEndHeader = -1;
    this.m_endColEndHeader = -1;
    this.m_startRowEndHeaderPixel = 0;
    this.m_startColEndHeaderPixel = 0;
    this.m_endRowEndHeaderPixel = 0;
    this.m_endColEndHeaderPixel = 0;

    this.m_currentScrollLeft = 0;
    this.m_currentScrollTop = 0;
    this.m_prevScrollLeft = 0;
    this.m_prevScrollTop = 0;
    this.m_handleScrollOverflow = false;

    this.m_rowHeaderLevelWidths = [];
    this.m_rowEndHeaderLevelWidths = [];
    this.m_columnHeaderLevelHeights = [];
    this.m_columnEndHeaderLevelHeights = [];

    this.m_frozenColIndex = null;
    this.m_frozenRowIndex = null;
    this._resetSkeletonProperties();

    var enginePromise = this._loadTemplateEngine();

    if (enginePromise) {
      this._signalTaskStart('loading template engine');
      enginePromise.then(() => {
        this._signalTaskEnd();
        this.m_renderCount -= 1;
        if (this.m_renderCount === 0) {
          this.buildGrid(root);
        }
      });
    } else {
      this.m_renderCount -= 1;
      this.buildGrid(root);
    }
  };

  /**
   * Initiate loading of the template engine.  An error is thrown if the template engine failed to load.
   * @return {Promise} resolves to the template engine, or null if:
   *                   1) there's no need because no templates are specified
   *                   2) this.m_options.data is not an instance of a data grid provider
   * @private
   * @memberof oj.ojDataGrid
   */
  DvtDataGrid.prototype._loadTemplateEngine = function () {
    var slotMap = this._getSlotMap();
    // Greater then 1 for having data provider case because datagridcontextmenu is always returned if there is dataprovider.
    if (
      (this._isDataGridProvider() && Object.keys(slotMap).length > 1) ||
      (this.getDataSource() == null && Object.keys(slotMap).length > 0)
    ) {
      var templateOptions = {
        customElement: this.m_customElement
      };
      return new Promise((resolve) => {
        ojconfig.__getTemplateEngine(templateOptions).then(
          (engine) => {
            this.m_engine = engine;
            resolve(engine);
          },
          function (reason) {
            throw new Error('Error loading template engine: ' + reason);
          }
        );
      });
    }

    return null;
  };

  /**
   * Retrieve the template engine, returns null if it has not been loaded yet
   * @private
   * @memberof oj.ojDataGrid
   */
  DvtDataGrid.prototype._getTemplateEngine = function () {
    return this.m_engine;
  };

  DvtDataGrid.prototype._cleanTemplateNodes = function (node) {
    var templateEngine = this._getTemplateEngine();
    if (templateEngine != null) {
      templateEngine.clean(node, this.m_root);
    }
  };

  /**
   * Returns true if instance of DataGridProvider
   * @private
   * @memberof oj.ojDataGrid
   */
  DvtDataGrid.prototype._isDataGridProvider = function () {
    return (
      this.m_options.options.data &&
      this.m_options.options.data.fetchByOffset &&
      !this.m_options.options.data.fetchFirst
    );
  };

  /**
   * Returns the slot map object.
   * @return {object} slot Map
   * @private
   * @memberof oj.ojDataGrid
   */
  DvtDataGrid.prototype._getSlotMap = function () {
    return ojcustomelementUtils.CustomElementUtils.getSlotMap(this.m_root);
  };

  /**
   * Returns the inline template element inside oj-data-grid by it's slotName
   * @return {Element|null} the inline template element
   * @param {slotName} string The name of slot to be returned.
   * @private
   * @memberof oj.ojDataGrid
   */
  DvtDataGrid.prototype._getItemTemplateBySlotName = function (slotName) {
    var slotMap = this._getSlotMap();
    var slot = slotMap[slotName];
    if (slot && slot.length > 0 && slot[0].tagName.toLowerCase() === 'template') {
      return slot[0];
    }
    return null;
  };

  /**
   * Builds the DataGrid, adds root children (headers, databody, corners),
   * initializes event listeners, and sets inital scroll position.
   * @param {Element} root - the root dom element for the DataGrid.
   */
  DvtDataGrid.prototype.buildGrid = function (root) {
    this.m_root = root;
    // class name set on component create
    this.m_root.setAttribute('role', 'application');
    if (this._isCellEditable()) {
      this.m_utils.addCSSClassName(this.m_root, this.getMappedStyle('editable'));
    } else {
      this.m_utils.addCSSClassName(this.m_root, this.getMappedStyle('readOnly'));
    }
    // this.m_root.setAttribute("aria-describedby", this.createSubId("summary"));

    this.setDefaultDimensions();

    // set a tab index so it can be focus and keyboard navigation to work
    // eslint-disable-next-line no-param-reassign
    root.tabIndex = 0;

    var status = this.buildStatus();
    root.appendChild(status); // @HTMLUpdateOK
    this.m_status = status;

    var accSummary = this.buildAccSummary();
    root.appendChild(accSummary); // @HTMLUpdateOK
    this.m_accSummary = accSummary;

    var accInfo = this.buildAccInfo();
    root.appendChild(accInfo); // @HTMLUpdateOK
    this.m_accInfo = accInfo;

    var stateInfo = this.buildStateInfo();
    root.appendChild(stateInfo); // @HTMLUpdateOK
    this.m_stateInfo = stateInfo;

    var contextInfo = this.buildContextInfo();
    root.appendChild(contextInfo); // @HTMLUpdateOK
    this.m_contextInfo = contextInfo;

    var placeHolder = this.buildPlaceHolder();
    root.appendChild(placeHolder); // @HTMLUpdateOK
    this.m_placeHolder = placeHolder;

    this.m_headerLabels = { row: [], column: [], rowEnd: [], columnEnd: [] };

    if (this.getDataSource() != null) {
      // in the event that the empty text was set when there was no datasource
      this.m_empty = null;

      var rtl = this.getResources().isRTLMode();

      var returnObj = this.buildHeaders(
        'column',
        this.getMappedStyle('colheader'),
        this.getMappedStyle('colendheader')
      );
      var colHeader = returnObj.root;
      var colEndHeader = returnObj.endRoot;
      let colHeaderFrozen = returnObj.frozenHeader;
      let colEndHeaderFrozen = returnObj.frozenEndHeader;

      root.insertBefore(colHeader, status); // @HTMLUpdateOK
      root.insertBefore(colEndHeader, status); // @HTMLUpdateOK
      if (colHeaderFrozen) {
        root.insertBefore(colHeaderFrozen, status); // @HTMLUpdateOK
      }
      if (colEndHeaderFrozen) {
        root.insertBefore(colEndHeaderFrozen, status); // @HTMLUpdateOK
      }

      returnObj = this.buildHeaders(
        'row',
        this.getMappedStyle('rowheader'),
        this.getMappedStyle('rowendheader')
      );
      var rowHeader = returnObj.root;
      var rowEndHeader = returnObj.endRoot;
      const rowHeaderFrozen = returnObj.frozenHeader;
      const rowEndHeaderFrozen = returnObj.frozenEndHeader;

      root.insertBefore(rowHeader, status); // @HTMLUpdateOK
      root.insertBefore(rowEndHeader, status); // @HTMLUpdateOK
      if (rowHeaderFrozen) {
        root.insertBefore(rowHeaderFrozen, status); // @HTMLUpdateOK
      }
      if (rowEndHeaderFrozen) {
        root.insertBefore(rowEndHeaderFrozen, status); // @HTMLUpdateOK
      }

      const databodyArr = this.buildDatabody();
      for (let i = 0; i < databodyArr.length; i++) {
        root.insertBefore(databodyArr[i], status); // @HTMLUpdateOK
      }
      const databody = databodyArr[0];

      if (rtl) {
        colHeader.style.direction = 'rtl';
        databody.style.direction = 'rtl';
      }

      this.m_isResizing = false;
      this.m_resizingElement = null;
      this.m_resizingElementMin = null;
      this.m_databodyDragState = false;

      // store the listeners so we can remove them later (bind creates a new function)
      this.m_docMouseMoveListener = this.handleMouseMove.bind(this);
      this.m_docMouseUpListener = this.handleMouseUp.bind(this);

      // touch event handling
      if (this.m_utils.isTouchDevice()) {
        // databody touch listeners
        databody.addEventListener('touchstart', this.handleTouchStart.bind(this), { passive: true });
        databody.addEventListener('touchmove', this.handleTouchMove.bind(this), { passive: false });
        databody.addEventListener('touchend', this.handleTouchEnd.bind(this), false);
        databody.addEventListener('touchcancel', this.handleTouchCancel.bind(this), false);

        // column header listeners
        colHeader.addEventListener('touchstart', this.handleHeaderTouchStart.bind(this), {
          passive: true
        });
        colHeader.addEventListener('touchmove', this.handleHeaderTouchMove.bind(this), {
          passive: false
        });
        colHeader.addEventListener('touchend', this.handleHeaderTouchEnd.bind(this), false);
        colHeader.addEventListener('touchcancel', this.handleHeaderTouchCancel.bind(this), false);

        // row header listeners
        rowHeader.addEventListener('touchstart', this.handleHeaderTouchStart.bind(this), {
          passive: true
        });
        rowHeader.addEventListener('touchmove', this.handleHeaderTouchMove.bind(this), {
          passive: false
        });
        rowHeader.addEventListener('touchend', this.handleHeaderTouchEnd.bind(this), false);
        rowHeader.addEventListener('touchcancel', this.handleHeaderTouchCancel.bind(this), false);

        // column end header listeners
        colEndHeader.addEventListener('touchstart', this.handleHeaderTouchStart.bind(this), {
          passive: true
        });
        colEndHeader.addEventListener('touchmove', this.handleHeaderTouchMove.bind(this), {
          passive: false
        });
        colEndHeader.addEventListener('touchend', this.handleHeaderTouchEnd.bind(this), false);
        colEndHeader.addEventListener('touchcancel', this.handleHeaderTouchCancel.bind(this), false);

        // row end header listeners
        rowEndHeader.addEventListener('touchstart', this.handleHeaderTouchStart.bind(this), {
          passive: true
        });
        rowEndHeader.addEventListener('touchmove', this.handleHeaderTouchMove.bind(this), {
          passive: false
        });
        rowEndHeader.addEventListener('touchend', this.handleHeaderTouchEnd.bind(this), false);
        rowEndHeader.addEventListener('touchcancel', this.handleHeaderTouchCancel.bind(this), false);
      } else {
        // non-touch event listening

        var mousewheelEvent = this.m_utils.getMousewheelEvent();
        // databody listeners
        databody.addEventListener(mousewheelEvent, this.handleDatabodyMouseWheel.bind(this), {
          passive: false
        });
        databody.addEventListener('mousedown', this.handleDatabodyMouseDown.bind(this), false);
        databody.addEventListener('mousemove', this.handleDatabodyMouseMove.bind(this), false);
        databody.addEventListener('mouseup', this.handleDatabodyMouseUp.bind(this), false);
        databody.addEventListener('mouseout', this.handleDatabodyMouseOut.bind(this), false);
        databody.addEventListener('mouseover', this.handleDatabodyMouseOver.bind(this), false);
        databody.addEventListener('dblclick', this.handleDatabodyDoubleClick.bind(this), false);

        // header listeners
        rowHeader.addEventListener(mousewheelEvent, this.handleDatabodyMouseWheel.bind(this), {
          passive: false
        });
        colHeader.addEventListener(mousewheelEvent, this.handleDatabodyMouseWheel.bind(this), {
          passive: false
        });
        rowHeader.addEventListener('mousedown', this.handleHeaderMouseDown.bind(this), false);
        colHeader.addEventListener('mousedown', this.handleHeaderMouseDown.bind(this), false);
        rowHeader.addEventListener('mouseover', this.handleHeaderMouseOver.bind(this), false);
        colHeader.addEventListener('mouseover', this.handleHeaderMouseOver.bind(this), false);
        rowHeader.addEventListener('mousemove', this.handleRowHeaderMouseMove.bind(this), false);
        colHeader.addEventListener('mousemove', this.handleColumnHeaderMouseMove.bind(this), false);
        rowHeader.addEventListener('mouseup', this.handleHeaderMouseUp.bind(this), false);
        colHeader.addEventListener('mouseup', this.handleHeaderMouseUp.bind(this), false);
        rowHeader.addEventListener('mouseout', this.handleHeaderMouseOut.bind(this), false);
        colHeader.addEventListener('mouseout', this.handleHeaderMouseOut.bind(this), false);
        rowHeader.addEventListener('click', this.handleHeaderClick.bind(this), false);
        rowHeader.addEventListener('dblclick', this.handleHeaderDoubleClick.bind(this), false);
        colHeader.addEventListener('click', this.handleHeaderClick.bind(this), false);
        colHeader.addEventListener('dblclick', this.handleHeaderDoubleClick.bind(this), false);

        // end header listeners
        rowEndHeader.addEventListener(mousewheelEvent, this.handleDatabodyMouseWheel.bind(this), {
          passive: false
        });
        colEndHeader.addEventListener(mousewheelEvent, this.handleDatabodyMouseWheel.bind(this), {
          passive: false
        });
        rowEndHeader.addEventListener('mousedown', this.handleHeaderMouseDown.bind(this), false);
        colEndHeader.addEventListener('mousedown', this.handleHeaderMouseDown.bind(this), false);
        rowEndHeader.addEventListener('mouseover', this.handleHeaderMouseOver.bind(this), false);
        colEndHeader.addEventListener('mouseover', this.handleHeaderMouseOver.bind(this), false);
        rowEndHeader.addEventListener('mousemove', this.handleRowHeaderMouseMove.bind(this), false);
        colEndHeader.addEventListener(
          'mousemove',
          this.handleColumnHeaderMouseMove.bind(this),
          false
        );
        rowEndHeader.addEventListener('mouseup', this.handleHeaderMouseUp.bind(this), false);
        colEndHeader.addEventListener('mouseup', this.handleHeaderMouseUp.bind(this), false);
        rowEndHeader.addEventListener('mouseout', this.handleHeaderMouseOut.bind(this), false);
        colEndHeader.addEventListener('mouseout', this.handleHeaderMouseOut.bind(this), false);
        rowEndHeader.addEventListener('click', this.handleHeaderClick.bind(this), false);
        rowEndHeader.addEventListener('dblclick', this.handleHeaderDoubleClick.bind(this), false);
        colEndHeader.addEventListener('click', this.handleHeaderClick.bind(this), false);
        colEndHeader.addEventListener('dblclick', this.handleHeaderDoubleClick.bind(this), false);
      }
      this._addDnDEventListener(rowHeader, rowEndHeader, colHeader, colEndHeader, databody);
      this._addListenersOnFrozenSections(
        rowHeaderFrozen,
        rowEndHeaderFrozen,
        colHeaderFrozen,
        colEndHeaderFrozen
      );
      // check if data is fetched and size the grid
      if (this._shouldInitialize()) {
        this._handleInitialization(true);
      }
    } else {
      // if no datasource render empty text
      var empty = this._buildEmptyText();
      this.m_databody.firstChild.appendChild(empty); // @HTMLUpdateOK
      this._handleInitialization(false);
    }
  };

  DvtDataGrid.prototype._addDnDEventListener = function (
    rowHeader,
    rowEndHeader,
    colHeader,
    colEndHeader,
    databody
  ) {
    if (rowHeader) {
      rowHeader.addEventListener('drag', this.handleRowDrag.bind(this), false);
      rowHeader.addEventListener('dragstart', this.handleDragStart.bind(this), false);
      rowHeader.addEventListener('dragend', this.handleRowDragEnd.bind(this), false);
      rowHeader.addEventListener('dragover', this.handleRowDragOver.bind(this), false);
      rowHeader.addEventListener('dragenter', this.handleRowDragEnter.bind(this), false);
      rowHeader.addEventListener('dragleave', this.handleRowDragLeave.bind(this), false);
      rowHeader.addEventListener('drop', this.handleRowDrop.bind(this), false);
    }
    if (colHeader) {
      colHeader.addEventListener('dragstart', this.handleDragStart.bind(this), false);
      colHeader.addEventListener('dragend', this.handleColumnDragEnd.bind(this), false);
      colHeader.addEventListener('dragover', this.handleColumnDragOver.bind(this), false);
      colHeader.addEventListener('dragenter', this.handleColumnDragEnter.bind(this), false);
      colHeader.addEventListener('dragleave', this.handleColumnDragLeave.bind(this), false);
      colHeader.addEventListener('drop', this.handleColumnDrop.bind(this), false);
    }
    if (rowEndHeader) {
      rowEndHeader.addEventListener('drag', this.handleRowDrag.bind(this), false);
      rowEndHeader.addEventListener('dragstart', this.handleDragStart.bind(this), false);
      rowEndHeader.addEventListener('dragend', this.handleRowDragEnd.bind(this), false);
      rowEndHeader.addEventListener('dragover', this.handleRowDragOver.bind(this), false);
      rowEndHeader.addEventListener('dragenter', this.handleRowDragEnter.bind(this), false);
      rowEndHeader.addEventListener('dragleave', this.handleRowDragLeave.bind(this), false);
      rowEndHeader.addEventListener('drop', this.handleRowDrop.bind(this), false);
    }
    if (colEndHeader) {
      colEndHeader.addEventListener('dragstart', this.handleDragStart.bind(this), false);
      colEndHeader.addEventListener('dragend', this.handleColumnDragEnd.bind(this), false);
      colEndHeader.addEventListener('dragover', this.handleColumnDragOver.bind(this), false);
      colEndHeader.addEventListener('dragenter', this.handleColumnDragEnter.bind(this), false);
      colEndHeader.addEventListener('dragleave', this.handleColumnDragLeave.bind(this), false);
      colEndHeader.addEventListener('drop', this.handleColumnDrop.bind(this), false);
    }
    if (databody) {
      databody.addEventListener('dragover', this.handleDatabodyDragOver.bind(this), false);
      databody.addEventListener('dragenter', this.handleDatabodyDragEnter.bind(this), false);
      databody.addEventListener('drop', this.handleDatabodyDrop.bind(this), false);
    }
  };

  DvtDataGrid.prototype._addListenersOnFrozenSections = function (
    rowHeaderFrozen,
    rowEndHeaderFrozen,
    colHeaderFrozen,
    colEndHeaderFrozen
  ) {
    const mousewheelEvent = this.m_utils.getMousewheelEvent();
    let sections = [this.m_databodyFrozenCorner, this.m_databodyFrozenCol, this.m_databodyFrozenRow];
    sections = sections.filter((section) => section);

    for (let i = 0; i < sections.length; i++) {
      let section = sections[i];
      if (this.m_utils.isTouchDevice()) {
        // databody touch listeners
        section.addEventListener('touchstart', this.handleTouchStart.bind(this), { passive: true });
        section.addEventListener('touchmove', this.handleTouchMove.bind(this), { passive: false });
        section.addEventListener('touchend', this.handleTouchEnd.bind(this), false);
        section.addEventListener('touchcancel', this.handleTouchCancel.bind(this), false);
      } else {
        section.addEventListener(mousewheelEvent, this.handleDatabodyMouseWheel.bind(this), {
          passive: false
        });
        section.addEventListener('mousedown', this.handleDatabodyMouseDown.bind(this), false);
        section.addEventListener('mousemove', this.handleDatabodyMouseMove.bind(this), false);
        section.addEventListener('mouseup', this.handleDatabodyMouseUp.bind(this), false);
        section.addEventListener('mouseout', this.handleDatabodyMouseOut.bind(this), false);
        section.addEventListener('mouseover', this.handleDatabodyMouseOver.bind(this), false);
        section.addEventListener('dblclick', this.handleDatabodyDoubleClick.bind(this), false);
        section.addEventListener('dragover', this.handleDatabodyDragOver.bind(this), false);
        section.addEventListener('dragenter', this.handleDatabodyDragEnter.bind(this), false);
        section.addEventListener('drop', this.handleDatabodyDrop.bind(this), false);
      }
    }

    if (rowHeaderFrozen) {
      if (this.m_utils.isTouchDevice()) {
        rowHeaderFrozen.addEventListener('touchstart', this.handleHeaderTouchStart.bind(this), {
          passive: true
        });
        rowHeaderFrozen.addEventListener('touchmove', this.handleHeaderTouchMove.bind(this), {
          passive: false
        });
        rowHeaderFrozen.addEventListener('touchend', this.handleHeaderTouchEnd.bind(this), false);
        rowHeaderFrozen.addEventListener(
          'touchcancel',
          this.handleHeaderTouchCancel.bind(this),
          false
        );
      } else {
        rowHeaderFrozen.addEventListener(mousewheelEvent, this.handleDatabodyMouseWheel.bind(this), {
          passive: false
        });
        rowHeaderFrozen.addEventListener('mousedown', this.handleHeaderMouseDown.bind(this), false);
        rowHeaderFrozen.addEventListener('mouseover', this.handleHeaderMouseOver.bind(this), false);
        rowHeaderFrozen.addEventListener(
          'mousemove',
          this.handleRowHeaderMouseMove.bind(this),
          false
        );
        rowHeaderFrozen.addEventListener('mouseup', this.handleHeaderMouseUp.bind(this), false);
        rowHeaderFrozen.addEventListener('mouseout', this.handleHeaderMouseOut.bind(this), false);
        rowHeaderFrozen.addEventListener('click', this.handleHeaderClick.bind(this), false);
        rowHeaderFrozen.addEventListener('dblclick', this.handleHeaderDoubleClick.bind(this), false);
      }
    }
    if (colHeaderFrozen) {
      if (this.m_utils.isTouchDevice()) {
        colHeaderFrozen.addEventListener('touchstart', this.handleHeaderTouchStart.bind(this), {
          passive: true
        });
        colHeaderFrozen.addEventListener('touchmove', this.handleHeaderTouchMove.bind(this), {
          passive: false
        });
        colHeaderFrozen.addEventListener('touchend', this.handleHeaderTouchEnd.bind(this), false);
        colHeaderFrozen.addEventListener(
          'touchcancel',
          this.handleHeaderTouchCancel.bind(this),
          false
        );
      } else {
        colHeaderFrozen.addEventListener(mousewheelEvent, this.handleDatabodyMouseWheel.bind(this), {
          passive: false
        });
        colHeaderFrozen.addEventListener('mousedown', this.handleHeaderMouseDown.bind(this), false);
        colHeaderFrozen.addEventListener('mouseover', this.handleHeaderMouseOver.bind(this), false);
        colHeaderFrozen.addEventListener(
          'mousemove',
          this.handleColumnHeaderMouseMove.bind(this),
          false
        );
        colHeaderFrozen.addEventListener('mouseup', this.handleHeaderMouseUp.bind(this), false);
        colHeaderFrozen.addEventListener('mouseout', this.handleHeaderMouseOut.bind(this), false);
        colHeaderFrozen.addEventListener('click', this.handleHeaderClick.bind(this), false);
        colHeaderFrozen.addEventListener('dblclick', this.handleHeaderDoubleClick.bind(this), false);
      }
    }
    // end header listeners
    if (rowEndHeaderFrozen) {
      if (this.m_utils.isTouchDevice()) {
        rowEndHeaderFrozen.addEventListener('touchstart', this.handleHeaderTouchStart.bind(this), {
          passive: true
        });
        rowEndHeaderFrozen.addEventListener('touchmove', this.handleHeaderTouchMove.bind(this), {
          passive: false
        });
        rowEndHeaderFrozen.addEventListener('touchend', this.handleHeaderTouchEnd.bind(this), false);
        rowEndHeaderFrozen.addEventListener(
          'touchcancel',
          this.handleHeaderTouchCancel.bind(this),
          false
        );
      } else {
        rowEndHeaderFrozen.addEventListener(
          mousewheelEvent,
          this.handleDatabodyMouseWheel.bind(this),
          {
            passive: false
          }
        );
        rowEndHeaderFrozen.addEventListener(
          'mousedown',
          this.handleHeaderMouseDown.bind(this),
          false
        );
        rowEndHeaderFrozen.addEventListener(
          'mouseover',
          this.handleHeaderMouseOver.bind(this),
          false
        );
        rowEndHeaderFrozen.addEventListener(
          'mousemove',
          this.handleRowHeaderMouseMove.bind(this),
          false
        );
        rowEndHeaderFrozen.addEventListener('mouseup', this.handleHeaderMouseUp.bind(this), false);
        rowEndHeaderFrozen.addEventListener('mouseout', this.handleHeaderMouseOut.bind(this), false);
        rowEndHeaderFrozen.addEventListener('click', this.handleHeaderClick.bind(this), false);
        rowEndHeaderFrozen.addEventListener(
          'dblclick',
          this.handleHeaderDoubleClick.bind(this),
          false
        );
      }
    }
    if (colEndHeaderFrozen) {
      if (this.m_utils.isTouchDevice()) {
        colEndHeaderFrozen.addEventListener('touchstart', this.handleHeaderTouchStart.bind(this), {
          passive: true
        });
        colEndHeaderFrozen.addEventListener('touchmove', this.handleHeaderTouchMove.bind(this), {
          passive: false
        });
        colEndHeaderFrozen.addEventListener('touchend', this.handleHeaderTouchEnd.bind(this), false);
        colEndHeaderFrozen.addEventListener(
          'touchcancel',
          this.handleHeaderTouchCancel.bind(this),
          false
        );
      } else {
        colEndHeaderFrozen.addEventListener(
          mousewheelEvent,
          this.handleDatabodyMouseWheel.bind(this),
          {
            passive: false
          }
        );
        colEndHeaderFrozen.addEventListener(
          'mousedown',
          this.handleHeaderMouseDown.bind(this),
          false
        );
        colEndHeaderFrozen.addEventListener(
          'mouseover',
          this.handleHeaderMouseOver.bind(this),
          false
        );
        colEndHeaderFrozen.addEventListener(
          'mousemove',
          this.handleColumnHeaderMouseMove.bind(this),
          false
        );
        colEndHeaderFrozen.addEventListener('mouseup', this.handleHeaderMouseUp.bind(this), false);
        colEndHeaderFrozen.addEventListener('mouseout', this.handleHeaderMouseOut.bind(this), false);
        colEndHeaderFrozen.addEventListener('click', this.handleHeaderClick.bind(this), false);
        colEndHeaderFrozen.addEventListener(
          'dblclick',
          this.handleHeaderDoubleClick.bind(this),
          false
        );
      }
    }
    this._addDnDEventListener(
      rowHeaderFrozen,
      rowEndHeaderFrozen,
      colHeaderFrozen,
      colEndHeaderFrozen
    );
  };

  /**
   * Handle resize of grid to a new width and height.
   * @param {number} width the new width
   * @param {number} height the new height
   */
  DvtDataGrid.prototype.HandleResize = function (width, height) {
    // can either get the client width or subtract the border width.
    // eslint-disable-next-line no-param-reassign
    width = this.getRootElement().clientWidth;
    // eslint-disable-next-line no-param-reassign
    height = this.getRootElement().clientHeight;
    // don't do anything if nothing has changed
    if (width !== this.m_width || height !== this.m_height) {
      // assign new width and height
      this.m_width = width;
      this.m_height = height;

      this.m_rowFetchSize = null;
      this.m_columnFetchSize = null;

      // if it's not initialize (or fetching), then just skip now
      // handleCellsFetchSuccess will attempt to fill the viewport
      if (this.m_initialized) {
        // call resize logic
        this.resizeGrid();
        if (this.isFetchComplete()) {
          this.m_resizeRequired = true;
          // check viewport
          this.fillViewport();
        }
      }
    }
  };

  /**
   * Size the headers, scroller, databody based on current width and height.
   * @private
   */
  DvtDataGrid.prototype.resizeGrid = function () {
    var width = this.getWidth();
    var height = this.getHeight();
    var colHeader = this.m_colHeader;
    var colEndHeader = this.m_colEndHeader;
    var rowHeader = this.m_rowHeader;
    var rowEndHeader = this.m_rowEndHeader;
    var databody = this.m_databody;
    var databodyScroller = databody.firstChild;
    const databodyFrozenCol = this.m_databodyFrozenCol;
    const databodyFrozenRow = this.m_databodyFrozenRow;
    let databodyFrozenColumnWidth = 0;
    let databodyFrozenRowHeight = 0;

    // cache these since they will be used in multiple places and we want to minimize reflow
    var colHeaderHeight = this.getColumnHeaderHeight();
    var colEndHeaderHeight = this.getColumnEndHeaderHeight();
    var rowHeaderWidth = this.getRowHeaderWidth();
    var rowEndHeaderWidth = this.getRowEndHeaderWidth();

    if (databodyFrozenCol) {
      databodyFrozenColumnWidth = this.getElementWidth(databodyFrozenCol);
    }
    if (databodyFrozenRow) {
      databodyFrozenRowHeight = this.getElementHeight(databodyFrozenRow);
    }

    if (this._hasFrozenColumns() && this._hasFrozenRows()) {
      if (!databodyFrozenColumnWidth) {
        databodyFrozenColumnWidth = this.getElementWidth(this.m_databodyFrozenCorner);
      }
      if (!databodyFrozenRowHeight) {
        databodyFrozenRowHeight = this.getElementHeight(this.m_databodyFrozenCorner);
      }
    }

    if (this.m_headerLabels.row && this.m_headerLabels.row.length && colHeaderHeight === 0) {
      colHeaderHeight = this._getCellDimension(
        this.m_headerLabels.row[0],
        0,
        null,
        'column',
        'height'
      );
      this.m_colHeaderHeight = colHeaderHeight;
    }
    if (this.m_headerLabels.column && this.m_headerLabels.column.length && rowHeaderWidth === 0) {
      rowHeaderWidth = this._getCellDimension(this.m_headerLabels.column[0], 0, null, 'row', 'width');
      this.m_rowHeaderWidth = rowHeaderWidth;
    }
    // adjusted to make the databody wrap the databody content, and the scroller to fill the remaing part of the grid
    // this way our scrollbars are always at the edges of our viewport
    var availableHeight = height - colHeaderHeight - colEndHeaderHeight - databodyFrozenRowHeight;
    var availableWidth = width - rowHeaderWidth - rowEndHeaderWidth - databodyFrozenColumnWidth;

    var scrollbarSize = this.m_utils.getScrollbarSize();

    var shouldBuildEmpty = this._databodyEmpty();
    var empty;
    var emptyHeight;
    var emptyWidth;

    // check if there's no data
    if (shouldBuildEmpty) {
      // could be getting here in the handle resize of an empty grid
      if (this.m_empty == null) {
        empty = this._buildEmptyText();
        emptyHeight = this.getElementHeight(empty);
        emptyWidth = this.getElementWidth(empty);
        databodyScroller = databody.firstChild;
        if (emptyHeight > this.getElementHeight(databodyScroller)) {
          this.setElementHeight(databodyScroller, Math.max(emptyHeight, availableHeight));
        }
        if (emptyWidth > this.getElementWidth(databodyScroller)) {
          this.setElementWidth(databodyScroller, Math.max(emptyWidth, availableWidth));
        }
        this.m_databody.firstChild.appendChild(empty); // @HTMLUpdateOK
      } else {
        empty = this.m_empty;
      }
    }

    var databodyContentWidth = this.getElementWidth(databody.firstChild);
    var databodyContentHeight = this.getElementHeight(databody.firstChild);
    // determine which scrollbars are required, if needing one forces need of the other, allows rendering within the root div
    var isDatabodyHorizontalScrollbarRequired =
      this.isDatabodyHorizontalScrollbarRequired(availableWidth);
    var isDatabodyVerticalScrollbarRequired;

    if (isDatabodyHorizontalScrollbarRequired) {
      isDatabodyVerticalScrollbarRequired = this.isDatabodyVerticalScrollbarRequired(
        availableHeight - scrollbarSize
      );
      databody.style.overflow = 'auto';
    } else {
      isDatabodyVerticalScrollbarRequired = this.isDatabodyVerticalScrollbarRequired(availableHeight);
      if (isDatabodyVerticalScrollbarRequired) {
        isDatabodyHorizontalScrollbarRequired = this.isDatabodyHorizontalScrollbarRequired(
          availableWidth - scrollbarSize
        );
        databody.style.overflow = 'auto';
      } else {
        // for an issue where same size child causes scrollbars (similar code used in resizing already)
        // Adding timeout to address firefox async scrolling and pixel perfect scroll bar issues:
        // If the datagrid doesn't need scrolling, ff will skip the async scroll event, so we need to manually handle
        // it with a timeout. Flag added here and handleScroll so that either will execute, but only once.
        this.m_handleScrollOverflow = false;
        var self = this;
        setTimeout(function () {
          // Need to check this in case the state has changed during the timeout period.
          if (
            !self.m_handleScrollOverflow &&
            !self.m_hasVerticalScroller &&
            !self.m_hasHorizontalScroller
          ) {
            databody.style.overflow = 'hidden';
            self.m_handleScrollOverflow = true;
          }
        }, 10);
      }
    }

    this.m_hasHorizontalScroller = isDatabodyHorizontalScrollbarRequired;
    this.m_hasVerticalScroller = isDatabodyVerticalScrollbarRequired;

    var databodyHeight;
    var rowHeaderHeight;
    var databodyWidth;
    var columnHeaderWidth;

    if (this.m_endColEndHeader !== -1) {
      databodyHeight = Math.min(
        databodyContentHeight + (isDatabodyHorizontalScrollbarRequired ? scrollbarSize : 0),
        availableHeight
      );
      rowHeaderHeight = isDatabodyHorizontalScrollbarRequired
        ? databodyHeight - scrollbarSize
        : databodyHeight;
    } else {
      databodyHeight = availableHeight;
      rowHeaderHeight = Math.min(
        databodyContentHeight,
        isDatabodyHorizontalScrollbarRequired ? databodyHeight - scrollbarSize : databodyHeight
      );
    }

    if (this.m_endRowEndHeader !== -1) {
      databodyWidth = Math.min(
        databodyContentWidth + (isDatabodyVerticalScrollbarRequired ? scrollbarSize : 0),
        availableWidth
      );
      columnHeaderWidth = isDatabodyVerticalScrollbarRequired
        ? databodyWidth - scrollbarSize
        : databodyWidth;
    } else {
      databodyWidth = availableWidth;
      columnHeaderWidth = Math.min(
        databodyContentWidth,
        isDatabodyVerticalScrollbarRequired ? databodyWidth - scrollbarSize : databodyWidth
      );
    }

    var rowEndHeaderDir =
      rowHeaderWidth +
      columnHeaderWidth +
      databodyFrozenColumnWidth +
      (isDatabodyVerticalScrollbarRequired ? scrollbarSize : 0);
    var columnEndHeaderDir =
      colHeaderHeight +
      rowHeaderHeight +
      databodyFrozenRowHeight +
      (isDatabodyHorizontalScrollbarRequired ? scrollbarSize : 0);

    var dir = this.getResources().isRTLMode() ? 'right' : 'left';

    this.setElementDir(rowHeader, 0, dir);
    this.setElementDir(rowHeader, colHeaderHeight, 'top');
    this.setElementHeight(rowHeader, rowHeaderHeight);

    this.setElementDir(rowEndHeader, rowEndHeaderDir, dir);
    this.setElementDir(rowEndHeader, colHeaderHeight, 'top');
    this.setElementHeight(rowEndHeader, rowHeaderHeight);

    this.setElementDir(colHeader, rowHeaderWidth, dir);
    this.setElementWidth(colHeader, columnHeaderWidth);

    this.setElementDir(colEndHeader, rowHeaderWidth, dir);
    this.setElementDir(colEndHeader, columnEndHeaderDir, 'top');
    this.setElementWidth(colEndHeader, columnHeaderWidth);

    [rowHeaderWidth, colHeaderHeight] = this._setFrozenContainerDimension(
      databodyWidth,
      databodyHeight,
      rowHeaderWidth,
      rowEndHeaderWidth,
      colHeaderHeight,
      colEndHeaderHeight
    );

    this.setElementDir(databody, colHeaderHeight, 'top');
    this.setElementDir(databody, rowHeaderWidth, dir);
    this.setElementWidth(databody, databodyWidth);
    this.setElementHeight(databody, databodyHeight);

    // cache the scroll width and height to minimize reflow
    this.m_scrollWidth = databodyContentWidth - columnHeaderWidth;
    this.m_scrollHeight = databodyContentHeight - rowHeaderHeight;

    this.buildCorners();

    // check if we need to remove border on the last column header/add borders to headers and cells
    this._adjustHeaderBorders();
    this._updateGridlines();

    // now we do not need to resize
    this.m_resizeRequired = false;
  };

  /**
   * Size the databody scroller based on whatever dimensions are available.
   * @private
   */
  DvtDataGrid.prototype._sizeDatabodyScroller = function () {
    var databody = this.m_databody;
    var scroller = databody.firstChild;
    var isEmptyState = this._databodyEmptyState();
    var endRowPixel = 0;
    var endColPixel = 0;

    if (isEmptyState) {
      // min is 1 so that the scrollbars show up
      endRowPixel = Math.max(Math.max(this.m_endRowHeaderPixel, this.m_endRowEndHeaderPixel), 1);
      endColPixel = Math.max(Math.max(this.m_endColHeaderPixel, this.m_endColEndHeaderPixel), 1);
    } else {
      endRowPixel = this.m_endRowPixel;
      endColPixel = this.m_endColPixel;
    }

    this._setScrollerDimension(scroller, endRowPixel, endColPixel);

    if (this.m_initialized) {
      this.m_scrollWidth =
        this.getElementWidth(scroller) -
        Math.min(
          this.getElementWidth(scroller),
          this.getElementWidth(databody) -
            (this.m_hasVerticalScroller ? this.m_utils.getScrollbarSize() : 0)
        );
      this.m_scrollHeight =
        this.getElementHeight(scroller) -
        Math.min(
          this.getElementHeight(scroller),
          this.getElementHeight(databody) -
            (this.m_hasHorizontalScroller ? this.m_utils.getScrollbarSize() : 0)
        );
    }
  };

  DvtDataGrid.prototype._setScrollerDimension = function (scroller, endRowPixel, endColPixel) {
    let isHWS = this._isHighWatermarkScrolling();
    let maxHeight = this.m_utils._getMaxDivHeightForScrolling();
    let maxWidth = this.m_utils._getMaxDivWidthForScrolling();
    let rowCount = this.getDataSource().getCount('row');
    let colCount = this.getDataSource().getCount('column');
    let totalHeight = 0;
    let totalWidth = 0;

    totalHeight = rowCount !== -1 && !isHWS ? rowCount * this.m_avgRowHeight : endRowPixel;
    totalWidth = colCount !== -1 && !isHWS ? colCount * this.m_avgColWidth : endColPixel;

    this.setElementHeight(scroller, Math.min(maxHeight, totalHeight));
    this.setElementWidth(scroller, Math.min(maxWidth, totalWidth));
  };

  /**
   * Adjust the last header on specific axis properties
   * @private
   * @param {number} headerIndex
   * @param {number} headerLevels
   * @param {Element} container
   * @param {number} startIndex
   * @param {string} className
   * @param {boolean} remove
   */
  DvtDataGrid.prototype._adjustLastHeadersAlongAxis = function (
    headerIndex,
    headerLevels,
    container,
    startIndex,
    className,
    remove,
    axis
  ) {
    var i = 0;
    while (i < headerLevels) {
      let lastHeader = this._getHeaderByIndex(headerIndex, axis, i);
      if (remove) {
        this.m_utils.removeCSSClassName(lastHeader, className);
      } else {
        this.m_utils.addCSSClassName(lastHeader, className);
      }
      i += this.getHeaderCellDepth(lastHeader);
    }
  };

  /**
   * Adjust the last header and the spacer along a given axis
   *
   * @param {Element} container
   * @param {Function} lastFunction
   * @param {number} endHeaderIndex
   * @param {boolean} dimensionCheck
   * @param {Element} spacer
   * @param {string} className
   * @param {number} headerLevels
   * @param {number} startIndex
   */
  DvtDataGrid.prototype._adjustHeaderBordersAlongAxis = function (
    container,
    lastFunction,
    endHeaderIndex,
    dimensionCheck,
    spacer,
    className,
    headerLevels,
    startIndex,
    axis
  ) {
    if (container != null && endHeaderIndex >= 0) {
      if (dimensionCheck) {
        this.m_utils.addCSSClassName(spacer, className);
      } else {
        this.m_utils.removeCSSClassName(spacer, className);
      }
      if (lastFunction(endHeaderIndex)) {
        this._adjustLastHeadersAlongAxis(
          endHeaderIndex,
          headerLevels,
          container,
          startIndex,
          className,
          dimensionCheck,
          axis
        );
      }
    }
  };

  /**
   * Adjust the border style/width setting on the headers using classNames so that they can be overwritten
   * @private
   */
  DvtDataGrid.prototype._adjustHeaderBorders = function () {
    var scrollbarSize = this.m_utils.getScrollbarSize();
    var width = this.getWidth();
    var height = this.getHeight();
    var colHeaderHeight = this.getColumnHeaderHeight();
    var colHeaderWidth = this.getElementWidth(this.m_colHeader);
    var colEndHeaderHeight = this.getColumnEndHeaderHeight();
    var rowHeaderWidth = this.getRowHeaderWidth();
    var rowHeaderHeight = this.getElementHeight(this.m_rowHeader);
    var rowEndHeaderWidth = this.getRowEndHeaderWidth();

    var widthCheck =
      rowHeaderWidth +
        colHeaderWidth +
        rowEndHeaderWidth +
        (this.m_hasVerticalScroller ? scrollbarSize : 0) <
      width;
    var heightCheck =
      colHeaderHeight +
        rowHeaderHeight +
        colEndHeaderHeight +
        (this.m_hasHorizontalScroller ? scrollbarSize : 0) <
      height;

    var bw;
    var style;
    var i;
    var tags;
    var lastFunction;

    if (widthCheck && this.m_endRowEndHeader >= 0) {
      bw = true;
      this.m_addBorderRight = true;
    } else if (this.m_addBorderRight === true) {
      bw = false;
    }

    if (bw != null) {
      style = this.getMappedStyle('borderVerticalSmall');
      if (this.m_columnHeaderScrollbarSpacer != null) {
        if (bw) {
          this.m_utils.addCSSClassName(this.m_columnHeaderScrollbarSpacer, style);
        } else {
          this.m_utils.removeCSSClassName(this.m_columnHeaderScrollbarSpacer, style);
        }
      }
      if (this.m_bottomCorner != null) {
        if (bw) {
          this.m_utils.addCSSClassName(this.m_bottomCorner, style);
        } else {
          this.m_utils.removeCSSClassName(this.m_bottomCorner, style);
        }
      }
      tags = Array.from(this.m_rowEndHeader.firstChild.childNodes);
      if (this.m_rowEndHeaderFrozen?.firstChild?.childNodes?.length) {
        tags.push(...this.m_rowEndHeaderFrozen.firstChild.childNodes);
      }
      for (i = 0; i < tags.length; i++) {
        if (bw) {
          this.m_utils.addCSSClassName(tags[i], style);
        } else {
          this.m_utils.removeCSSClassName(tags[i], style);
        }
      }
    } else {
      style = this.getMappedStyle('borderVerticalNone');
      lastFunction = this._isLastColumn.bind(this);
      let startColHeaderIndex = this.m_startColHeader;
      let startColEndHeaderIndex = this.m_startColEndHeader;

      if (this._hasFrozenColumns()) {
        startColHeaderIndex = this.m_frozenColIndex + 1;
        startColEndHeaderIndex = startColHeaderIndex;
      }
      this._adjustHeaderBordersAlongAxis(
        this.m_colHeader,
        lastFunction,
        this.m_endColHeader,
        widthCheck,
        this.m_columnHeaderScrollbarSpacer,
        style,
        this.m_columnHeaderLevelCount,
        startColHeaderIndex,
        'column'
      );
      this._adjustHeaderBordersAlongAxis(
        this.m_colEndHeader,
        lastFunction,
        this.m_endColEndHeader,
        widthCheck,
        this.m_bottomCorner,
        style,
        this.m_columnEndHeaderLevelCount,
        startColEndHeaderIndex,
        'columnEnd'
      );
    }

    bw = null;

    if (heightCheck && this.m_endColEndHeader >= 0) {
      this.m_addBorderBottom = true;
      bw = true;
    } else if (this.m_addBorderBottom === true) {
      bw = false;
    }

    if (bw != null) {
      style = this.getMappedStyle('borderHorizontalSmall');
      if (this.m_rowHeaderScrollbarSpacer != null) {
        if (bw) {
          this.m_utils.addCSSClassName(this.m_rowHeaderScrollbarSpacer, style);
        } else {
          this.m_utils.removeCSSClassName(this.m_rowHeaderScrollbarSpacer, style);
        }
      }
      if (this.m_bottomCorner != null) {
        if (bw) {
          this.m_utils.addCSSClassName(this.m_bottomCorner, style);
        } else {
          this.m_utils.removeCSSClassName(this.m_bottomCorner, style);
        }
      }
      tags = Array.from(this.m_colEndHeader.firstChild.childNodes);
      if (this.m_colEndHeaderFrozen?.firstChild?.childNodes?.length) {
        tags.push(...this.m_colEndHeaderFrozen.firstChild.childNodes);
      }
      const groupingContainerStyle = this.getMappedStyle('groupingcontainer');
      // Identify if the endHeader is a groupingcontainer and apply style to the first child.
      for (i = 0; i < tags.length; i++) {
        let tag = tags[i];
        if (tag.classList.contains(groupingContainerStyle)) {
          tag = tag.firstChild;
        }
        if (bw) {
          this.m_utils.addCSSClassName(tag, style);
        } else {
          this.m_utils.removeCSSClassName(tag, style);
        }
      }
    } else {
      style = this.getMappedStyle('borderHorizontalNone');
      lastFunction = this._isLastRow.bind(this);
      let startRowHeaderIndex = this.m_startRowHeader;
      let startRowEndHeaderIndex = this.m_startRowEndHeader;

      if (this.m_frozenRowIndex !== null) {
        startRowHeaderIndex = this.m_frozenRowIndex + 1;
        startRowEndHeaderIndex = startRowHeaderIndex;
      }
      this._adjustHeaderBordersAlongAxis(
        this.m_rowHeader,
        lastFunction,
        this.m_endRowHeader,
        heightCheck,
        this.m_rowHeaderScrollbarSpacer,
        style,
        this.m_rowHeaderLevelCount,
        startRowHeaderIndex,
        'row'
      );
      this._adjustHeaderBordersAlongAxis(
        this.m_rowEndHeader,
        lastFunction,
        this.m_endRowEndHeader,
        heightCheck,
        this.m_bottomCorner,
        style,
        this.m_rowEndHeaderLevelCount,
        startRowEndHeaderIndex,
        'rowEnd'
      );
    }
  };

  /**
   * @private
   */
  DvtDataGrid.prototype._isHeaderLabelCollision = function () {
    return (
      this.m_headerLabels.column[this.m_columnHeaderLevelCount - 1] &&
      this.m_headerLabels.row[this.m_rowHeaderLevelCount - 1]
    );
  };

  /**
   * Build the corners of the grid. If they exist, removes them and rebuilds them.
   * @private
   */
  DvtDataGrid.prototype.buildCorners = function () {
    var scrollbarSize = this.m_utils.getScrollbarSize();
    var width = this.getWidth();
    var height = this.getHeight();
    var colHeaderHeight = this.getColumnHeaderHeight();
    var colHeaderWidth = this.getElementWidth(this.m_colHeader);
    var colEndHeaderHeight = this.getColumnEndHeaderHeight();
    var rowHeaderWidth = this.getRowHeaderWidth();
    var rowEndHeaderWidth = this.getRowEndHeaderWidth();
    var rowHeaderHeight = this.getElementHeight(this.m_rowHeader);
    var dir = this.getResources().isRTLMode() ? 'right' : 'left';
    var corner;
    var bottomCorner;
    var label;
    var i;

    let labelWidth;
    let labelHeight;
    let buildEndCorners = true;
    let chScrollbarSpacerTop = 0;
    let chScrollbarSpacerDirVal;
    let chScrollbarSpacerWidth;
    let chScrollbarSpacerHeight = colHeaderHeight;
    let rhScrollbarSpacerTop;
    let rhScrollbarSpacerDirVal = 0;
    let rhScrollbarSpacerWidth = rowHeaderWidth;
    let rhScrollbarSpacerHeight;

    let databodyFrozenColumnWidth = 0;
    let databodyFrozenRowHeight = 0;
    const databodyFrozenCol = this.m_databodyFrozenCol;
    const databodyFrozenRow = this.m_databodyFrozenRow;

    if (databodyFrozenCol) {
      databodyFrozenColumnWidth = this.getElementWidth(databodyFrozenCol);
    }
    if (databodyFrozenRow) {
      databodyFrozenRowHeight = this.getElementHeight(databodyFrozenRow);
    }

    // rather than removing and appending the nodes every time just adjust the live ones
    if (this.m_endRowHeader !== -1 && this.m_endColHeader !== -1) {
      labelHeight = this.m_headerLabels.column.length
        ? this.m_columnHeaderLevelHeights[this.m_columnHeaderLevelCount - 1]
        : this.m_colHeaderHeight;
      labelWidth = this.m_headerLabels.row.length
        ? this.m_rowHeaderLevelWidths[this.m_rowHeaderLevelCount - 1]
        : this.m_rowHeaderWidth;

      // frozenRowDatabody container's height to be added to row,col header heights
      rhScrollbarSpacerTop = rowHeaderHeight + colHeaderHeight + databodyFrozenRowHeight;
      rhScrollbarSpacerHeight =
        colEndHeaderHeight + (this.m_hasHorizontalScroller ? scrollbarSize : 0);

      // frozenColumnDatabody container's width to be added to row,col header widths
      chScrollbarSpacerDirVal = rowHeaderWidth + colHeaderWidth + databodyFrozenColumnWidth;
      chScrollbarSpacerWidth = rowEndHeaderWidth + (this.m_hasVerticalScroller ? scrollbarSize : 0);
    } else if (this.m_endRowHeader !== -1 && this.m_endColHeader === -1) {
      labelHeight = colHeaderHeight;

      rhScrollbarSpacerTop = rowHeaderHeight + colHeaderHeight + databodyFrozenRowHeight;
      rhScrollbarSpacerHeight =
        colEndHeaderHeight + (this.m_hasHorizontalScroller ? scrollbarSize : 0);

      chScrollbarSpacerDirVal = rowHeaderWidth;
      chScrollbarSpacerWidth =
        rowEndHeaderWidth +
        colHeaderWidth +
        databodyFrozenColumnWidth +
        (this.m_hasVerticalScroller ? scrollbarSize : 0);
    } else if (this.m_endRowHeader === -1 && this.m_endColHeader !== -1) {
      labelWidth = rowHeaderWidth;

      rhScrollbarSpacerTop = colHeaderHeight;
      rhScrollbarSpacerHeight =
        colEndHeaderHeight +
        rowHeaderHeight +
        databodyFrozenRowHeight +
        (this.m_hasHorizontalScroller ? scrollbarSize : 0);

      chScrollbarSpacerDirVal = rowHeaderWidth + colHeaderWidth + databodyFrozenColumnWidth;
      chScrollbarSpacerWidth = rowEndHeaderWidth + (this.m_hasVerticalScroller ? scrollbarSize : 0);
    } else {
      buildEndCorners = false;
    }
    if (buildEndCorners) {
      if (this.m_corner != null) {
        corner = this.m_corner;
      } else {
        corner = document.createElement('div');
        corner.id = this.createSubId('corner');
        corner.className = this.getMappedStyle('topcorner');
      }

      this.setElementWidth(corner, rowHeaderWidth);
      this.setElementHeight(corner, colHeaderHeight);

      if (this.m_corner == null) {
        this._attachEventListenersOnCorner(corner);
        this.m_root.appendChild(corner); // @HTMLUpdateOK
        this.m_corner = corner;

        if (labelHeight) {
          for (i = 0; i < this.m_headerLabels.row.length; i++) {
            label = this.m_headerLabels.row[i];
            if (label != null) {
              this.setElementHeight(label, labelHeight);
              corner.appendChild(label); // @HTMLUpdateOK
            }
          }
        }
        if (labelWidth) {
          for (i = 0; i < this.m_headerLabels.column.length; i++) {
            label = this.m_headerLabels.column[i];
            if (label != null) {
              this.setElementWidth(label, labelWidth);
              corner.appendChild(label); // @HTMLUpdateOK
            }
          }
        }
        this.m_subtreeAttachedCallback(corner);

        if (this._isHeaderLabelCollision()) {
          let item = this.m_headerLabels.row[this.m_rowHeaderLevelCount - 1];
          let h = this.getElementHeight(item);
          this.m_colHeaderHeight += h;
          this.m_columnHeaderLevelHeights[this.m_columnHeaderLevelCount - 1] += h;

          this.resizeColumnHeightsAndShift(h, this.m_columnHeaderLevelCount - 1, false);
          this.setElementHeight(this.m_colHeader, this.m_colHeaderHeight);
          if (this.m_colHeaderFrozen) {
            this.setElementHeight(this.m_colHeaderFrozen, this.m_colHeaderHeight);
          }

          this.manageResizeScrollbars();
          return;
        }
      } else {
        let isTouchDevice = this.m_utils.isTouchDevice();
        if (isTouchDevice) {
          corner.addEventListener('touchstart', this.handleHeaderLabelMouseDown.bind(this), false);
          corner.addEventListener('touchmove', this.handleHeaderLabelMouseMove.bind(this), false);
        } else {
          corner.addEventListener('mousedown', this.handleHeaderLabelMouseDown.bind(this), false);
          corner.addEventListener('mousemove', this.handleHeaderLabelMouseMove.bind(this), false);
        }
      }
      this._buildCornerOnHeaderAxisDisabled(
        'row',
        dir,
        rhScrollbarSpacerDirVal,
        rhScrollbarSpacerTop,
        rhScrollbarSpacerWidth,
        rhScrollbarSpacerHeight
      );
      this._buildCornerOnHeaderAxisDisabled(
        'column',
        dir,
        chScrollbarSpacerDirVal,
        chScrollbarSpacerTop,
        chScrollbarSpacerWidth,
        chScrollbarSpacerHeight
      );
    } else {
      this.m_headerLabels.row = [];
      this.m_headerLabels.column = [];
    }

    if (this.m_corner != null && corner == null) {
      this.m_root.removeChild(this.m_corner);
      this.m_corner = null;
    }

    if (
      (this.m_hasHorizontalScroller && this.m_hasVerticalScroller) ||
      (this.m_hasVerticalScroller && this.m_endColEndHeader !== -1) ||
      (this.m_hasHorizontalScroller && this.m_endRowEndHeader !== -1) ||
      (this.m_endRowEndHeader !== -1 && this.m_endColEndHeader !== -1)
    ) {
      // render bottom corner (for both scrollbars) if needed
      if (this.m_bottomCorner != null) {
        bottomCorner = this.m_bottomCorner;
      } else {
        bottomCorner = document.createElement('div');
        bottomCorner.id = this.createSubId('bcorner');
        bottomCorner.className = this.getMappedStyle('bottomcorner');
      }

      this.setElementDir(
        bottomCorner,
        rowHeaderHeight + colHeaderHeight + databodyFrozenRowHeight,
        'top'
      );
      this.setElementDir(
        bottomCorner,
        rowHeaderWidth + colHeaderWidth + databodyFrozenColumnWidth,
        dir
      );
      if (this.m_endRowEndHeader !== -1) {
        this.setElementWidth(
          bottomCorner,
          rowEndHeaderWidth + (this.m_hasVerticalScroller ? scrollbarSize : 0)
        );
      } else {
        this.setElementWidth(
          bottomCorner,
          width - colHeaderWidth - rowHeaderWidth - databodyFrozenColumnWidth
        );
      }

      if (this.m_endColEndHeader !== -1) {
        this.setElementHeight(
          bottomCorner,
          colEndHeaderHeight + (this.m_hasHorizontalScroller ? scrollbarSize : 0)
        );
      } else {
        this.setElementHeight(
          bottomCorner,
          height - rowHeaderHeight - colHeaderHeight - databodyFrozenRowHeight
        );
      }

      if (this.m_bottomCorner == null) {
        this.m_root.appendChild(bottomCorner); // @HTMLUpdateOK
        this.m_bottomCorner = bottomCorner;
      }
    }
    // remove bottom corner on resize if not neccessary
    if (this.m_bottomCorner != null && bottomCorner == null) {
      this.m_root.removeChild(this.m_bottomCorner);
      this.m_bottomCorner = null;
    }
  };

  DvtDataGrid.prototype._attachEventListenersOnCorner = function (corner) {
    if (this.m_utils.isTouchDevice()) {
      corner.addEventListener('touchstart', this.handleCornerMouseDown.bind(this), false);
    } else {
      corner.addEventListener('mousedown', this.handleCornerMouseDown.bind(this), false);
      corner.addEventListener('mouseover', this.handleCornerMouseOver.bind(this), false);
      corner.addEventListener('mouseout', this.handleCornerMouseOut.bind(this), false);
    }
    if (this.m_options._isLabelCutEnabled()) {
      this._attachDndListenersOnLabelSection(corner);
    } else {
      corner.addEventListener('click', this.handleCornerClick.bind(this), false);
    }
  };

  DvtDataGrid.prototype._attachDndListenersOnLabelSection = function (section) {
    section.addEventListener('dragstart', this.handleCornerDragStart.bind(this), false);
    section.addEventListener('dragend', this.handleCornerDragEnd.bind(this), false);
    section.addEventListener('dragover', this.handleCornerDragOver.bind(this), false);
    section.addEventListener('drop', this.handleCornerDrop.bind(this), false);
    section.addEventListener('dragenter', this.handleCornerDragEnter.bind(this), false);
  };

  DvtDataGrid.prototype._buildCornerOnHeaderAxisDisabled = function (
    disabledHeaderAxis,
    dir,
    dirValue,
    topValue,
    width,
    height
  ) {
    let datagridHeaderScrollbarSpacer =
      disabledHeaderAxis === 'column'
        ? this.m_columnHeaderScrollbarSpacer
        : this.m_rowHeaderScrollbarSpacer;
    let headerScrollbarSpacer;
    let hasScroller = false;
    if (disabledHeaderAxis === 'column') {
      if (this.m_hasVerticalScroller || this.m_endRowEndHeader !== -1) {
        hasScroller = true;
        if (this.m_columnHeaderScrollbarSpacer != null) {
          headerScrollbarSpacer = this.m_columnHeaderScrollbarSpacer;
        } else {
          headerScrollbarSpacer = document.createElement('div');
          headerScrollbarSpacer.id = this.createSubId('chSbSpacer');
          headerScrollbarSpacer.className = this.getMappedStyle('colheaderspacer');
        }
      }
    } else if (disabledHeaderAxis === 'row') {
      if (this.m_hasHorizontalScroller || this.m_endColEndHeader !== -1) {
        hasScroller = true;
        if (this.m_rowHeaderScrollbarSpacer != null) {
          headerScrollbarSpacer = this.m_rowHeaderScrollbarSpacer;
        } else {
          headerScrollbarSpacer = document.createElement('div');
          headerScrollbarSpacer.id = this.createSubId('rhSbSpacer');
          headerScrollbarSpacer.className = this.getMappedStyle('rowheaderspacer');
        }
      }
    }
    if (hasScroller) {
      this.setElementDir(headerScrollbarSpacer, dirValue, dir);
      this.setElementDir(headerScrollbarSpacer, topValue, 'top');
      this.setElementWidth(headerScrollbarSpacer, width);
      this.setElementHeight(headerScrollbarSpacer, height);
      let headerLabels;
      let label;
      if (datagridHeaderScrollbarSpacer == null) {
        if (this.m_utils.isTouchDevice()) {
          headerScrollbarSpacer.addEventListener(
            'touchstart',
            this.handleCornerMouseDown.bind(this),
            { passive: true }
          );
        } else {
          headerScrollbarSpacer.addEventListener(
            'mousedown',
            this.handleCornerMouseDown.bind(this),
            false
          );
          headerScrollbarSpacer.addEventListener(
            'mouseover',
            this.handleCornerMouseOver.bind(this),
            false
          );
          headerScrollbarSpacer.addEventListener(
            'mouseout',
            this.handleCornerMouseOut.bind(this),
            false
          );
          this._attachDndListenersOnLabelSection(headerScrollbarSpacer);
          if (this.isResizeEnabled() !== 'disable') {
            headerScrollbarSpacer.addEventListener(
              'mousedown',
              this.handleHeaderLabelMouseDown.bind(this),
              false
            );
            headerScrollbarSpacer.addEventListener(
              'mousemove',
              this.handleHeaderLabelMouseMove.bind(this),
              false
            );
          }
        }
        this.m_root.appendChild(headerScrollbarSpacer); // @HTMLUpdateOK
        if (disabledHeaderAxis === 'column') {
          this.m_columnHeaderScrollbarSpacer = headerScrollbarSpacer;
          headerLabels = this.m_headerLabels.rowEnd;
        } else {
          this.m_rowHeaderScrollbarSpacer = headerScrollbarSpacer;
          headerLabels = this.m_headerLabels.columnEnd;
        }
        if (headerLabels.length) {
          for (let i = 0; i < headerLabels.length; i++) {
            label = headerLabels[i];
            if (label != null) {
              headerScrollbarSpacer.appendChild(label); // @HTMLUpdateOK
            }
          }
        }
        this.m_subtreeAttachedCallback(headerScrollbarSpacer);
      }
    } else if (disabledHeaderAxis === 'column') {
      if (this.m_columnHeaderScrollbarSpacer != null) {
        this.m_root.removeChild(this.m_columnHeaderScrollbarSpacer);
      }
      this.m_columnHeaderScrollbarSpacer = null;
      this.m_headerLabels.rowEnd = [];
    } else {
      if (this.m_rowHeaderScrollbarSpacer != null) {
        this.m_root.removeChild(this.m_rowHeaderScrollbarSpacer);
      }
      this.m_rowHeaderScrollbarSpacer = null;
      this.m_headerLabels.columnEnd = [];
    }
  };

  /**
   * Move to a desired scoll position object
   * @private
   */
  DvtDataGrid.prototype._updateScrollPosition = function (scrollPositionObject) {
    this._scrollToScrollPositionObject(scrollPositionObject);
  };

  /**
   * Set the scrollPosition attribute on the grid
   * @private
   */
  DvtDataGrid.prototype._setScrollPosition = function () {
    this.m_setOptionCallback(
      'scrollPosition',
      this._createScrollPositionObject(this.m_currentScrollLeft, this.m_currentScrollTop),
      {
        _context: {
          writeback: true,
          internalSet: true
        }
      }
    );
  };

  /**
   * Set the scrollPosition minus the keys
   * @private
   */
  DvtDataGrid.prototype._clearScrollPositionKeys = function () {
    var newPos = this.m_options.getScrollPosition();
    newPos.rowKey = undefined;
    newPos.columnKey = undefined;
    // do not writeback it will be updated once the sync has completed
    this.m_setOptionCallback('scrollPosition', newPos, { _context: { internalSet: true } });
  };

  /**
   * Create a scroll position object from x,y coordinates
   * @private
   */
  DvtDataGrid.prototype._createScrollPositionObject = function (x, y) {
    var scrollPositionObject = { x: x, y: y };
    var dir = this.getResources().isRTLMode() ? 'right' : 'left';

    var cell = this._getCellAtPixel(x, y);
    if (cell != null) {
      scrollPositionObject.rowIndex = this._getIndex(cell, 'row');
      scrollPositionObject.columnIndex = this._getIndex(cell, 'column');
      scrollPositionObject.rowKey = this._getKey(cell, 'row');
      scrollPositionObject.columnKey = this._getKey(cell, 'column');
      scrollPositionObject.offsetX = x - this.getElementDir(cell, dir);
      scrollPositionObject.offsetY = y - this.getElementDir(cell, 'top');
    } else {
      var rowHeader = this._getHeaderAtPixel(y, 'row');
      if (rowHeader != null) {
        scrollPositionObject.rowIndex = this._getIndex(rowHeader);
        scrollPositionObject.rowKey = this._getKey(rowHeader);
        scrollPositionObject.offsetY = y - this.getElementDir(rowHeader, 'top');
      }

      var columnHeader = this._getHeaderAtPixel(x, 'column');
      if (columnHeader != null) {
        scrollPositionObject.columnIndex = this._getIndex(columnHeader);
        scrollPositionObject.columnKey = this._getKey(columnHeader);
        scrollPositionObject.offsetX = x - this.getElementDir(columnHeader, dir);
      }
    }

    return scrollPositionObject;
  };

  /**
   * Get a cell at x,y coordinates
   * @private
   */
  DvtDataGrid.prototype._getCellAtPixel = function (x, y) {
    var cells = this.m_databody.firstChild.querySelectorAll('.' + this.getMappedStyle('cell'));
    var dir = this.getResources().isRTLMode() ? 'right' : 'left';

    for (var i = 0; i < cells.length; i++) {
      var cell = cells[i];
      var cellLeft = this.getElementDir(cell, dir);
      var cellRight = cellLeft + this.getElementWidth(cell);

      if (cellLeft <= x && x < cellRight) {
        var cellTop = this.getElementDir(cell, 'top');
        var cellBottom = cellTop + this.getElementHeight(cell);
        if (cellTop <= y && y < cellBottom) {
          return cell;
        }
      }
    }
    return null;
  };

  DvtDataGrid.prototype._getAxisInnerMostHeaders = function (axis) {
    var className = this.getMappedStyle('headercell');
    var root;
    var levelCount;

    switch (axis) {
      case 'row':
        root = this.m_rowHeader;
        levelCount = this.m_rowHeaderLevelCount;
        break;
      case 'column':
        root = this.m_colHeader;
        levelCount = this.m_columnHeaderLevelCount;
        break;
      case 'rowEnd':
        root = this.m_rowEndHeader;
        levelCount = this.m_rowEndHeaderLevelCount;
        break;
      case 'columnEnd':
        root = this.m_colEndHeader;
        levelCount = this.m_columnEndHeaderLevelCount;
        break;
      default:
        break;
    }

    var returnArr = [];
    if (root) {
      var headers = root.getElementsByClassName(className);
      for (var i = 0; i < headers.length; i++) {
        var header = headers[i];
        var context = header[this.getResources().getMappedAttribute('context')];
        if (context.level + context.depth === levelCount) {
          returnArr.push(header);
        }
      }
    }
    return returnArr;
  };

  /**
   * Get a header at a given coordinate and axis
   * @private
   */
  DvtDataGrid.prototype._getHeaderAtPixel = function (pixel, axis) {
    var self = this;
    var headers;
    var endheaders;
    var dir;
    var dimension;

    headers = this._getAxisInnerMostHeaders(axis);
    endheaders = this._getAxisInnerMostHeaders(axis + 'End');

    if (axis === 'row') {
      dir = 'top';
      dimension = 'height';
    } else if (axis === 'column') {
      dir = this.getResources().isRTLMode() ? 'right' : 'left';
      dimension = 'width';
    }

    function loop(elements) {
      for (var i = 0; i < elements.length; i++) {
        var header = elements[i];
        var start = self.getElementDir(header, dir);
        var end = start + self.getElementDir(header, dimension);

        if (start <= pixel && pixel < end) {
          return header;
        }
      }
      return undefined;
    }

    var header = loop(headers);
    if (header == null) {
      header = loop(endheaders);
    }

    return header;
  };

  /**
   * See if we have reached our desired scroll position
   * @private
   */
  DvtDataGrid.prototype._checkScrollPosition = function () {
    if (this.m_desiredScrollPositionObject != null) {
      this._scrollToScrollPositionObject(this.m_desiredScrollPositionObject);
    } else {
      this._setScrollPosition();
    }
  };

  /**
   * See if the row/column keys are already fetched
   * @private
   */
  DvtDataGrid.prototype._areKeysLocallyAvailable = function (rowKey, columnKey) {
    var isKeyAvailable = true;
    if (rowKey) {
      if (this._getCellOrHeaderByKey(rowKey, 'row') == null) {
        isKeyAvailable = false;
      }
    }

    if (columnKey) {
      if (this._getCellOrHeaderByKey(columnKey, 'column') == null) {
        isKeyAvailable = false;
      }
    }

    return isKeyAvailable;
  };

  /**
   * Call initiate scroll to scroll to a scroll position object
   */
  DvtDataGrid.prototype._scrollToScrollPositionObject = function (scrollPositionObject) {
    var x = scrollPositionObject.x;
    var y = scrollPositionObject.y;
    var rowIndex = scrollPositionObject.rowIndex;
    var columnIndex = scrollPositionObject.columnIndex;
    var rowKey = scrollPositionObject.rowKey;
    var columnKey = scrollPositionObject.columnKey;
    var offsetX = scrollPositionObject.offsetX ? scrollPositionObject.offsetX : 0;
    var offsetY = scrollPositionObject.offsetY ? scrollPositionObject.offsetY : 0;
    var dir = this.getResources().isRTLMode() ? 'right' : 'left';

    var scrollToKey = this.m_options.getScrollToKey();
    // ignore the value if key is specified and scrollByKey behavior is 'never'
    if (scrollToKey === 'never' && (rowKey || columnKey)) {
      return;
    }

    // also ignore the value if it is a DataProvider that is not capable of returning results immediately
    // and (one of the) keys are not already fetched yet
    if (scrollToKey !== 'always') {
      // for scrollToKey values 'auto' or 'capability'
      var ds = this.getDataSource();
      if (ds instanceof DataProviderDataGridDataSource) {
        if (!this._areKeysLocallyAvailable(rowKey, columnKey)) {
          var capability = this.m_options.getProperty('data').getCapability('fetchFirst');
          if (capability == null || capability.iterationSpeed !== 'immediate') {
            return;
          }
        }
      }
    }

    var self = this;
    var indexFromKeyPromise = this._getIndexFromKeyPromise(rowKey, columnKey);

    indexFromKeyPromise.then(function (returnObj) {
      // scrollTop and s
      var newScrollX = Math.floor(
        self._getPositionEstimate(
          'column',
          dir,
          columnKey,
          returnObj.columnIndexFromKey,
          columnIndex,
          x,
          offsetX,
          self.m_currentScrollLeft,
          self._getMaxRightPixel(),
          self.m_avgColWidth
        )
      );
      var newScrollY = Math.floor(
        self._getPositionEstimate(
          'row',
          'top',
          rowKey,
          returnObj.rowIndexFromKey,
          rowIndex,
          y,
          offsetY,
          self.m_currentScrollTop,
          self._getMaxBottomPixel(),
          self.m_avgRowHeight
        )
      );

      // make sure scroll is not the same, and that we aren't trying to scroll
      // out of bounds if we are at the boundry.
      if (
        (newScrollX !== self.m_currentScrollLeft &&
          (self.m_currentScrollLeft !== self.m_scrollWidth ||
            newScrollX < self.m_currentScrollLeft)) ||
        (newScrollY !== self.m_currentScrollTop &&
          (self.m_currentScrollTop !== self.m_scrollHeight || newScrollY < self.m_currentScrollTop))
      ) {
        if (self.m_desiredScrollPositionObject == null) {
          self._signalTaskStart('begin scrolling to new desired location');
        }
        self.m_desiredScrollPositionObject = scrollPositionObject;
        self._setScrollPositionTimeout();
        self._initiateScroll(newScrollX, newScrollY);
        self._requiresInitPostScrollFillViewport = false;
      } else {
        if (self.m_desiredScrollPositionObject != null) {
          self._signalTaskEnd('reached desired location');
        }
        self.m_desiredScrollPositionObject = null;
        self._setScrollPosition();
        if (self._requiresInitPostScrollFillViewport) {
          self._requiresInitPostScrollFillViewport = false;
          self.fillViewport();
        }
      }
    });
  };

  // These methods exist for issues with pixel perfect scrolling when zoomed
  // there isn't a great way to guarantee cross browser that the pixel we want
  // to scroll to is actually a possible value as scrollTop/Left in the browser when zoomed
  // That means when scrollTo is called there's a chance that a scroll event is
  // 1) not fired at all becauxse it is not a possible value
  // 2) fired but ends up infinite looping trying to get to that impossible value
  // Timeout is 300ms which is long, but this should be a rare catch, and I noticed in chrome
  // that it can take up to 300ms or longer between initiateScroll and the handler
  // if it takes longer end result is scrollPosition will come up short of its goal
  // also touch devices don't allow the zoom issues because only zoom in

  /**
   * @private
   */
  DvtDataGrid.prototype._setScrollPositionTimeout = function () {
    if (!this.m_utils.isTouchDeviceNotIOS()) {
      // prettier-ignore
      this.pendingScrollTimeout = setTimeout( // @HTMLUpdateOK
        function () {
          if (this.m_desiredScrollPositionObject != null) {
            this._signalTaskEnd('reached desired location');
          }
          this.m_desiredScrollPositionObject = null;
          this._setScrollPosition();
        }.bind(this),
        300
      );
    }
  };

  /**
   * @private
   */
  DvtDataGrid.prototype._clearScrollPositionTimeout = function () {
    if (this.pendingScrollTimeout != null) {
      clearTimeout(this.pendingScrollTimeout);
      this.pendingScrollTimeout = null;
    }
  };

  /**
   * Estimate the location of the scroll based on key/index/x,y following the jsdoc guidelines
   * @private
   */
  DvtDataGrid.prototype._getPositionEstimate = function (
    axis,
    dir,
    key,
    indexFromKey,
    index,
    pos,
    offset,
    current,
    max,
    average
  ) {
    var newScrollPos;
    var isHighWatermark = this._isHighWatermarkScrolling();
    var element;

    // indexFromKey === -1 means that the key is definitely not in the data source
    // indexFromKey === null means that the key is possibly not in the data source
    if (key != null && indexFromKey !== -1) {
      element = this._getCellOrHeaderByKey(key, axis);
      if (element != null) {
        newScrollPos = this.getElementDir(element, dir) + offset;
      } else if (isHighWatermark) {
        newScrollPos = max;
      } else if (indexFromKey != null) {
        newScrollPos = average * indexFromKey + offset;
      }

      if (newScrollPos != null) {
        return newScrollPos;
      }

      // if key specified and virtual scrolling but no index found, switch to index check
    }

    if (index != null) {
      element = this._getCellOrHeaderByIndex(index, axis);
      if (element != null) {
        newScrollPos = this.getElementDir(element, dir) + offset;
      } else if (isHighWatermark) {
        newScrollPos = max;
      } else {
        newScrollPos = average * index;
      }
    } else if (pos != null) {
      newScrollPos = pos;
    } else {
      newScrollPos = current;
    }

    return newScrollPos;
  };

  /**
   * Determine if horizontal scrollbar is needed
   * @param {number} expectedWidth - databody width
   * @return {boolean} true if horizontal scrollbar required
   */
  DvtDataGrid.prototype.isDatabodyHorizontalScrollbarRequired = function (expectedWidth) {
    var databody = this.m_databody;
    var scroller = databody.firstChild;
    if (this.getElementWidth(scroller) > expectedWidth) {
      return true;
    }
    return false;
  };

  /**
   * Determine if vertical scrollbar is needed
   * @param {number} expectedHeight - databody height
   * @return {boolean} true if vertical scrollbar required
   * @private
   */
  DvtDataGrid.prototype.isDatabodyVerticalScrollbarRequired = function (expectedHeight) {
    var databody = this.m_databody;
    var scroller = databody.firstChild;
    if (this.getElementHeight(scroller) > expectedHeight) {
      return true;
    }
    return false;
  };

  /**
   * todo: merge with buildAccInfo, we just need one status role div.
   * Build a status bar div
   * @return {Element} the root of the status bar
   * @private
   */
  DvtDataGrid.prototype.buildStatus = function () {
    var root = document.createElement('div');
    root.id = this.createSubId('status');
    root.className = this.getMappedStyle('status');
    root.setAttribute('role', 'status');
    return root;
  };

  /**
   * Build the offscreen div used by screenreader for action such as sort
   * @return {Element} the root of the accessibility info div
   */
  DvtDataGrid.prototype.buildAccInfo = function () {
    var root = document.createElement('div');
    root.id = this.createSubId('info');
    root.className = this.getMappedStyle('info');
    root.setAttribute('role', 'status');

    return root;
  };

  /**
   * Build the offscreen div used by screenreader for summary description
   * @return {Element} the root of the accessibility summary div
   */
  DvtDataGrid.prototype.buildAccSummary = function () {
    var root = document.createElement('div');
    root.id = this.createSubId('summary');
    root.className = this.getMappedStyle('info');

    return root;
  };

  /**
   * Build the offscreen div used by screenreader for state information
   * @return {Element} the root of the accessibility state info div
   */
  DvtDataGrid.prototype.buildStateInfo = function () {
    var root = document.createElement('div');
    root.id = this.createSubId('state');
    root.className = this.getMappedStyle('info');

    return root;
  };

  /**
   * Build the offscreen div used by screenreader for cell context information
   * @return {Element} the root of the accessibility context info div
   */
  DvtDataGrid.prototype.buildContextInfo = function () {
    var root = document.createElement('div');
    root.id = this.createSubId('context');
    root.className = this.getMappedStyle('info');

    return root;
  };

  /**
   * Build the offscreen div used by screenreader used for reading current cell context information
   * @return {Element} the root of the accessibility current cell context info div
   */
  DvtDataGrid.prototype.buildPlaceHolder = function () {
    var root = document.createElement('div');
    root.id = this.createSubId('placeHolder');
    root.className = this.getMappedStyle('info');

    return root;
  };

  /**
   * Sets the text on the offscreen div.  The text contains a summary text describing the grid
   * including structure information
   * @private
   */
  DvtDataGrid.prototype.populateAccInfo = function () {
    var summary = this.getResources().getTranslatedText('accessibleSummaryExact', {
      rownum: this.m_endRow + 1,
      colnum: this.m_endCol + 1
    });

    // if it's hierarchical, then include specific accessible info about what's expanded
    if (this.getDataSource().getExpandedKeys) {
      var summaryExpanded = this.getResources().getTranslatedText('accessibleSummaryExpanded', {
        num: this.getDataSource().getExpandedKeys().length
      });
      summary = summary + '. ' + summaryExpanded;
    }

    // add instruction text
    summary += '. ';

    // set the summary text on the screen reader div
    this.m_accSummary.textContent = summary;
  };

  /**
   * Implements Accessible interface.
   * Sets accessible information on the DataGrid.
   * This is currently used by the Row Expander to alert screenreader of such
   * information as depth, expanded state, index etc
   * @param {Object} context an object containing attribute context or state to set m_accessibleContext/state
   */
  DvtDataGrid.prototype.SetAccessibleContext = function (context) {
    if (context != null) {
      // got row context info
      if (context.context != null) {
        // save it for updateContextInfo to consume later
        this.m_accessibleContext = context.context;
      }

      // got disclosure state info
      if (context.state != null) {
        this.m_stateInfo.textContent = context.state;
      }

      // got ancestors info
      if (context.ancestors != null && this._isDatabodyCellActive()) {
        var label = '';
        var ancestors = context.ancestors;
        var col = this.m_active.indexes.column;
        if (col != null && col >= 0) {
          // constructs the appropriate parent context info text
          for (var i = 0; i < ancestors.length; i++) {
            if (i > 0) {
              label = label.concat(', ');
            }
            var parent = ancestors[i];
            var rowCells = this._getAxisCellsByKey(parent.key, 'row');
            if (rowCells != null) {
              var cell = rowCells[0];
              // we are just going to extract any text content (or find first aria-label if null?)
              var text = cell.textContent;
              // remove any carriage return, tab etc.
              if (text != null) {
                text = text.replace(/\n|<br\s*\/?>/gi, '').trim();
              } else {
                text = '';
              }
              label = label.concat(parent.label).concat(' ').concat(text);
            }
          }
        }

        // prepend to existing context info
        this.m_accessibleContext = label.concat(', ').concat(this.m_accessibleContext);
      }
    }
  };

  /**
   * Sets the accessibility state info text
   * @param {Array} items the message key
   * @private
   */
  DvtDataGrid.prototype._updateStateInfo = function (items) {
    // allows pause after the data is read out before the state
    var text = '. ';
    for (var i = 0; i < items.length; i++) {
      var state = this.getResources().getTranslatedText(items[i].key, items[i].args);
      if (state != null) {
        // for the original period we will just add text otherwise need a comma
        text = text.length === 2 ? text + state : text + ', ' + state;
      }
    }

    // end state with a period
    // 2 for the original period
    text = text.length === 2 ? text : text + '. ';

    this.m_stateInfo.textContent = text;
  };

  /**
   * Sets the accessibility context info text
   * @param {Object} context the context info about the cell
   * @param {number=} context.row the row index
   * @param {number=} context.column the column index
   * @param {number=} context.level the level of the header if there is one
   * @param {number=} context.rowHeader the rowHeader index
   * @param {number=} context.columnHeader the rowHeader index
   * @param {string=} skip whether to skip row or column
   * @private
   */
  DvtDataGrid.prototype._updateContextInfo = function (context, skip) {
    var row;
    var column;

    if (context.indexes) {
      row = context.indexes.row;
      column = context.indexes.column;
    }

    var level = context.level;
    var rowHeader = context.rowHeader;
    var rowEndHeader = context.rowEndHeader;
    var columnHeader = context.columnHeader;
    var columnEndHeader = context.columnEndHeader;
    var rowHeaderLabel = context.rowHeaderLabel;
    var rowEndHeaderLabel = context.rowEndHeaderLabel;
    var columnHeaderLabel = context.columnHeaderLabel;
    var columnEndHeaderLabel = context.columnEndHeaderLabel;
    var info = '';
    var endContextText = '. ';

    // row context.  Skip if there is an outstanding accessible row context
    if (this.m_accessibleContext == null && !isNaN(row) && skip !== 'row') {
      info = this._updateAccessibleInfoString(info, 'accessibleRowContext', { index: row + 1 });
    }

    // column context
    if (!isNaN(column) && skip !== 'column') {
      info = this._updateAccessibleInfoString(info, 'accessibleColumnContext', { index: column + 1 });
    }

    // rowHeader context
    if (!isNaN(rowHeader)) {
      info = this._updateAccessibleInfoString(info, 'accessibleRowHeaderContext', {
        index: rowHeader + 1
      });
    }

    // columnHeader context
    if (!isNaN(columnHeader)) {
      info = this._updateAccessibleInfoString(info, 'accessibleColumnHeaderContext', {
        index: columnHeader + 1
      });
    }

    // rowEndHeader context
    if (!isNaN(rowEndHeader)) {
      info = this._updateAccessibleInfoString(info, 'accessibleRowEndHeaderContext', {
        index: rowEndHeader + 1
      });
    }

    // columnEndHeader context
    if (!isNaN(columnEndHeader)) {
      info = this._updateAccessibleInfoString(info, 'accessibleColumnEndHeaderContext', {
        index: columnEndHeader + 1
      });
    }

    // rowHeaderLabel context
    if (!isNaN(rowHeaderLabel)) {
      info = this._updateAccessibleInfoString(info, 'accessibleRowHeaderLabelContext', {
        level: rowHeaderLabel + 1
      });
    }

    // columnHeaderLabel context
    if (!isNaN(columnHeaderLabel)) {
      info = this._updateAccessibleInfoString(info, 'accessibleColumnHeaderLabelContext', {
        level: columnHeaderLabel + 1
      });
    }

    // rowEndHeaderLabel context
    if (!isNaN(rowEndHeaderLabel)) {
      info = this._updateAccessibleInfoString(info, 'accessibleRowEndHeaderLabelContext', {
        level: rowEndHeaderLabel + 1
      });
    }

    // columnEndHeaderLabel context
    if (!isNaN(columnEndHeaderLabel)) {
      info = this._updateAccessibleInfoString(info, 'accessibleColumnEndHeaderLabelContext', {
        level: columnEndHeaderLabel + 1
      });
    }

    // level context
    if (!isNaN(level)) {
      info = this._updateAccessibleInfoString(info, 'accessibleLevelContext', { level: level + 1 });
    }

    // Put a period at the end of the context readout
    info = info.length === 0 ? info : info + endContextText;

    // merge with accesssible context (from row expander)
    if (this.m_accessibleContext != null) {
      info += this.m_accessibleContext;
      // reset
      this.m_accessibleContext = null;
    }

    this.m_contextInfo.textContent = info;
  };

  /**
   * @private
   */
  DvtDataGrid.prototype._updateAccessibleInfoString = function (
    info,
    translation,
    translationParams
  ) {
    var spacerText = ', ';
    var text = this.getResources().getTranslatedText(translation, translationParams);
    if (text != null) {
      return info.length === 0 ? text : info + spacerText + text;
    }
    return info;
  };

  /**
   * Determine whether the row/column count is unknown.
   * @param {string} axis the row/column axis
   * @return {boolean|undefined} true if the count for the axis is unknown, false otherwise
   * @private
   */
  DvtDataGrid.prototype._isCountUnknown = function (axis) {
    var datasource = this.getDataSource();
    if (axis === 'row' || axis === 'rowEnd') {
      var rowPrecision = datasource.getCountPrecision('row');
      var rowCount = datasource.getCount('row');
      if (rowPrecision === 'estimate' || rowCount < 0) {
        this.m_isEstimateRowCount = true;
      } else {
        this.m_isEstimateRowCount = false;
      }
      return this.m_isEstimateRowCount;
    } else if (axis === 'column' || axis === 'columnEnd') {
      var colPrecision = datasource.getCountPrecision('column');
      var colCount = datasource.getCount('column');
      if (colPrecision === 'estimate' || colCount < 0) {
        this.m_isEstimateColumnCount = true;
      } else {
        this.m_isEstimateColumnCount = false;
      }
      return this.m_isEstimateColumnCount;
    }

    // unrecognize axis, just assume the count is known
    return false;
  };

  /**
   * Convenient method which returns true if row count is unknown or high-water mark scrolling is used.
   * @param {string} axis the row/column axis
   * @return {boolean} true if count is unknown or high-water mark scrolling is used, false otherwise.
   * @private
   */
  DvtDataGrid.prototype._isCountUnknownOrHighwatermark = function (axis) {
    return this._isCountUnknown(axis) || this._isHighWatermarkScrolling();
  };

  /**
   * Set display to none
   * @param {Element} root
   * @private
   */
  DvtDataGrid.prototype._hideHeader = function (root) {
    // eslint-disable-next-line no-param-reassign
    root.style.display = 'none';
  };

  /**
   * Set display
   * @param {Element} root
   * @private
   */
  DvtDataGrid.prototype._showHeader = function (root) {
    // eslint-disable-next-line no-param-reassign
    root.style.display = '';
  };

  /**
   * Build a header div
   * @param {string} axis - 'row' or 'column'
   * @param {string} styleClass - class to set on the header
   * @param {string} endStyleClass - class to set on the end header
   * @return {Object} contains the root and endRoot of the header axis
   */
  DvtDataGrid.prototype.buildHeaders = function (axis, styleClass, endStyleClass) {
    var scrollerClassName =
      this.getMappedStyle('scroller') +
      (this.m_utils.isTouchDeviceNotIOS() ? ' ' + this.getMappedStyle('scroller-mobile') : '');

    let root = this._createHeaderElement(axis, styleClass, scrollerClassName, false);
    let endRoot = this._createHeaderElement(axis, endStyleClass, scrollerClassName, true);

    const freezeIndex = this.m_options._getFreezeIndex(axis);

    if (axis === 'column') {
      this.m_colHeader = root;
      this.m_colEndHeader = endRoot;
    } else if (axis === 'row') {
      this.m_rowHeader = root;
      this.m_rowEndHeader = endRoot;
    }

    let frozenHeader;
    let frozenEndHeader;

    if (axis === 'column' && freezeIndex !== null) {
      this.m_frozenColIndex = freezeIndex;
      frozenHeader = this._createHeaderElement(
        'frozenColumn',
        this.getMappedStyle('colHeaderFrozen'),
        scrollerClassName,
        false
      );
      this.m_colHeaderFrozen = frozenHeader;
      if (this.m_colEndHeader) {
        frozenEndHeader = this._createHeaderElement(
          'frozenColumn',
          this.getMappedStyle('colEndHeaderFrozen'),
          scrollerClassName,
          true
        );
        this.m_colEndHeaderFrozen = frozenEndHeader;
      }
    }
    if (axis === 'row' && freezeIndex !== null) {
      this.m_frozenRowIndex = freezeIndex;
      frozenHeader = this._createHeaderElement(
        'frozenRow',
        this.getMappedStyle('rowHeaderFrozen'),
        scrollerClassName,
        false
      );
      this.m_rowHeaderFrozen = frozenHeader;
      if (this.m_rowEndHeader) {
        frozenEndHeader = this._createHeaderElement(
          'frozenRow',
          this.getMappedStyle('rowEndHeaderFrozen'),
          scrollerClassName,
          true
        );
        this.m_rowEndHeaderFrozen = frozenEndHeader;
      }
    }

    if (!this._isHighWatermarkScrolling()) {
      var self = this;
      var scrollPosition = this.m_options.getScrollPosition();
      this._getIndexesFromScrollPosition(scrollPosition).then(function (fetchIndexes) {
        var index = fetchIndexes[axis];
        if (axis === 'column') {
          self.m_startColHeader = index;
          self.m_startColEndHeader = index;
        } else if (axis === 'row') {
          self.m_startRowHeader = index;
          self.m_startRowEndHeader = index;
        }
        let count = null;

        self.m_fetching[axis] = false;
        if (freezeIndex !== null) {
          count = self.getFetchSize(axis) + index;
          index = 0;
        }
        self.fetchHeaders(axis, index, root, endRoot, count, null);
      });
      this.m_fetching[axis] = true;
    } else {
      var index = 0;
      this.fetchHeaders(axis, index, root, endRoot, null, null);
    }

    return {
      root: root,
      endRoot: endRoot,
      frozenHeader: frozenHeader,
      frozenEndHeader: frozenEndHeader
    };
  };

  DvtDataGrid.prototype._createHeaderElement = function (
    axis,
    styleClass,
    scrollerClassName,
    isEndHeader
  ) {
    let root = document.createElement('div');
    root.id = isEndHeader ? this.createSubId(axis + 'EndHeader') : this.createSubId(axis + 'Header');
    let headerClassName = isEndHeader
      ? this.getMappedStyle('endheader')
      : this.getMappedStyle('header');
    root.className = styleClass + ' ' + headerClassName;
    let scroller = document.createElement('div');
    scroller.className = scrollerClassName;
    root.appendChild(scroller); // @HTMLUpdateOK
    return root;
  };

  /**
   * Fetch the headers by calling the fetch headers method on the data source. Pass
   * callbacks for success and error to the data source.
   * @param {string} axis - 'row' or 'column'
   * @param {number} start - index to start fetching at
   * @param {Element|DocumentFragment} header - the root element of the axis header
   * @param {Element|DocumentFragment} endHeader - the root element of the axis endHeader
   * @param {number|null=} fetchSize - number of headers to fetch
   * @param {Object=} callbacks - the optional callbacks to invoke when the fetch success or fail
   * @protected
   */
  DvtDataGrid.prototype.fetchHeaders = function (
    axis,
    start,
    header,
    endHeader,
    fetchSize,
    callbacks
  ) {
    // check if we are already fetching
    if (this.m_fetching[axis]) {
      return;
    }

    // fetch size could be explicitly specified.  If not, use the calculated one.
    if (fetchSize == null) {
      // eslint-disable-next-line no-param-reassign
      fetchSize = this.getFetchCount(axis, start);
    }

    var headerRange = {
      axis: axis,
      start: start,
      count: fetchSize,
      header: header,
      endHeader: endHeader
    };

    this.m_fetching[axis] = headerRange;

    var successCallback;
    // check if overriding callbacks are specified
    if (callbacks != null && callbacks.success != null) {
      successCallback = callbacks.success;
    } else {
      successCallback = this.handleHeadersFetchSuccess;
    }

    if (!this.m_initialized || !this.isSkeletonSupport()) {
      this.showStatusText(!this.isSkeletonSupport());
    }

    // start fetch
    this._signalTaskStart();
    this.getDataSource().fetchHeaders(
      headerRange,
      {
        success: successCallback,
        error: this.handleHeadersFetchError
      },
      {
        success: this,
        error: this
      }
    );
  };

  /**
   * Checks whether header fetch result match the request
   * @param {Object} headerRange the header range for the response
   * @protected
   */
  DvtDataGrid.prototype.isHeaderFetchResponseValid = function (headerRange) {
    var axis = headerRange.axis;
    if (this.m_fetching == null) {
      return false;
    }

    // do object reference check, imagine fetching 20 2 consecutive times but
    // the data changed in bewteeen and we accidentally accept the first because
    // the counts are the same
    return headerRange === this.m_fetching[axis];
  };

  /**
   * Checks whether the result is within the current viewport
   * @param {Object} headerRange
   * @private
   */
  DvtDataGrid.prototype.isHeaderFetchResponseInViewport = function (headerRange) {
    if (!this.m_initialized) {
      // initial scroll these are not defined so just return true, or if not inited or if no databody
      return true;
    }

    // the goal of this method is to make sure we haven't scrolled further since the last fetch
    // so our request is still valid, we run a massive risk of running loops if our logic is wrong otherwise
    // as in we continue to request the same thing but it is never valid.
    var axis = headerRange.axis;
    var start = headerRange.start;
    var returnVal;

    if (axis === 'row') {
      returnVal = this._getLongScrollStart(this.m_currentScrollTop, this.m_prevScrollTop, axis);
    } else {
      returnVal = this._getLongScrollStart(this.m_currentScrollLeft, this.m_prevScrollLeft, axis);
    }

    // return true if the viewport fits inside the fetched range
    return returnVal.start === start;
  };

  /**
   * Handle a successful call to the data source fetchHeaders
   * @param {Object} startResults a headerSet object returned from the data source
   * @param {Object} headerRange {"axis":,"start":,"count":,"header":}
   * @param {Object} endResults a headerSet object returned from the data source
   * @param {boolean} rowInsert if this is triggered by a row insert event
   * @protected
   */
  DvtDataGrid.prototype.handleHeadersFetchSuccess = function (
    startResults,
    headerRange,
    endResults,
    rowInsert
  ) {
    var scrollOptions = this.m_options.getScrollPolicyOptions();
    var maxRowCount = scrollOptions ? scrollOptions.maxRowCount : null;
    var maxColumnCount = scrollOptions ? scrollOptions.maxColumnCount : null;

    // validate result matches what we currently asks for
    if (!this.isHeaderFetchResponseValid(headerRange)) {
      // end fetch
      this._signalTaskEnd();
      // not valid, so ignore result
      return;
    }

    var axis = headerRange.axis;

    // checks if the response covers the viewport
    if (this.isLongScroll() && !this.isHeaderFetchResponseInViewport(headerRange)) {
      // clear cells fetching flag
      this.m_fetching[axis] = false;
      // store that the header is invalid for the case when there are no cells
      this.m_headerInvalid = true;
      // end fetch
      this._signalTaskEnd();
      return;
    }

    // remove fetching message
    this.m_fetching[axis] = false;

    var root = headerRange.header;
    var endRoot = headerRange.endHeader;
    var start = headerRange.start;

    let hiddenCount = axis === 'column' ? this.m_hiddenColumns.length : this.m_hiddenRows.length;
    // subtracting hidden columns length to render only visible columns
    var count = this.getDataSource().getCount(axis) - hiddenCount;

    if (axis === 'column') {
      if (this.m_frozenColIndex === null) {
        this.m_frozenColIndex = this.m_options._getFreezeIndex(axis);
      }

      let { headerStart, endHeaderStart, headerFetchCount, endHeaderFetchCount } =
        this._buildFrozenHeaders(axis, startResults, endResults, headerRange, count);
      if (startResults != null && headerFetchCount > 0) {
        start = headerStart;
        let fetchCount = headerFetchCount;
        this.buildColumnHeaders(root, startResults, start, count, false, false, fetchCount, false);
        if (
          startResults.getCount() < headerRange.count ||
          (maxColumnCount && maxColumnCount > 0 && maxColumnCount === start + startResults.getCount())
        ) {
          this.m_stopColumnHeaderFetch = true;
        }
      } else {
        this.m_stopColumnHeaderFetch = true;
      }
      if (this.m_endColHeader < 0) {
        this._hideHeader(root);
        this.m_stopColumnHeaderFetch = true;
        this.m_startColHeader = 0;
      } else {
        this.m_hasColHeader = true;
        this._buildHeaderLabels(axis, startResults);
      }

      if (endResults != null && endHeaderFetchCount > 0) {
        start = endHeaderStart;
        let fetchCount = endHeaderFetchCount;
        this.buildColumnEndHeaders(
          endRoot,
          endResults,
          start,
          count,
          false,
          false,
          fetchCount,
          false
        );
        if (
          endResults.getCount() < headerRange.count ||
          (maxColumnCount && maxColumnCount > 0 && maxColumnCount === start + endResults.getCount())
        ) {
          this.m_stopColumnEndHeaderFetch = true;
        }
      } else {
        this.m_stopColumnEndHeaderFetch = true;
      }
      if (this.m_endColEndHeader < 0) {
        this._hideHeader(endRoot);
        this.m_stopColumnEndHeaderFetch = true;
        this.m_startColEndHeader = 0;
      } else {
        this.m_hasColEndHeader = true;
        this._buildHeaderLabels('columnEnd', endResults);
      }
    } else if (axis === 'row') {
      if (this.m_frozenRowIndex === null) {
        this.m_frozenRowIndex = this.m_options._getFreezeIndex('row');
      }
      let { headerStart, endHeaderStart, headerFetchCount, endHeaderFetchCount } =
        this._buildFrozenHeaders(axis, startResults, endResults, headerRange, count);
      if (startResults != null && headerFetchCount > 0) {
        start = headerStart;
        const fetchCount = headerFetchCount;
        this.buildRowHeaders(root, startResults, start, count, rowInsert, false, fetchCount, false);
        if (
          startResults.getCount() < headerRange.count ||
          (maxRowCount && maxRowCount > 0 && maxRowCount === start + startResults.getCount())
        ) {
          this.m_stopRowHeaderFetch = true;
        }
      } else {
        this.m_stopRowHeaderFetch = true;
      }
      if (this.m_endRowHeader < 0) {
        this._hideHeader(root);
        this.m_stopRowHeaderFetch = true;
        this.m_startRowHeader = 0;
      } else {
        this.m_hasRowHeader = true;
        this._buildHeaderLabels(axis, startResults);
      }

      if (endResults != null && endHeaderFetchCount > 0) {
        start = endHeaderStart;
        const fetchCount = endHeaderFetchCount;
        this.buildRowEndHeaders(
          endRoot,
          endResults,
          start,
          count,
          rowInsert,
          false,
          fetchCount,
          false
        );
        if (
          endResults.getCount() < headerRange.count ||
          (maxRowCount && maxRowCount > 0 && maxRowCount === start + endResults.getCount())
        ) {
          this.m_stopRowEndHeaderFetch = true;
        }
      } else {
        this.m_stopRowEndHeaderFetch = true;
      }
      if (this.m_endRowEndHeader < 0) {
        this._hideHeader(endRoot);
        this.m_stopRowEndHeaderFetch = true;
        this.m_startRowEndHeader = 0;
      } else {
        this.m_hasRowEndHeader = true;
        this._buildHeaderLabels('rowEnd', endResults);
      }
    }

    if (this.isFetchComplete()) {
      this.hideStatusText();
      if (this._shouldInitialize() && !rowInsert) {
        this._handleInitialization(true);
      }
    }

    if (this.m_initialized) {
      if (this.isSkeletonSupport()) {
        this.loadSkeletonsOnHeaderLoad(axis, start, startResults, endResults);
      }
      // if there are no cells and we are initialized then size the scroller
      this._sizeDatabodyScroller();

      // we cannot syncScroller here. On touch this will trigger a refetch before the fetchCells has been called and will
      // cause an infinite loop. We always call fetchCells after fetchHeaders which calls syncScroller
      // check if we need to sync header scroll position
    }

    // end fetch
    this._signalTaskEnd();
  };

  DvtDataGrid.prototype._calculateFrozenIndex = function (index, groupingContainer) {
    let frozenIndex = index;
    if (groupingContainer && groupingContainer.length) {
      let extent = 0;
      for (let i = 0; i < groupingContainer.length; i++) {
        let group = groupingContainer[i];
        if (this._getAttribute(group, 'level', 10) === 0) {
          extent += this._getAttribute(group, 'extent', 10);
        }
      }
      frozenIndex = extent;
    }
    return frozenIndex;
  };

  /**
   * Handle an unsuccessful call to the data source fetchHeaders
   * @param {Error} error - the error returned from the data source
   * @param {Object} headerRange - keys of {axis,start,count,header}
   */
  DvtDataGrid.prototype.handleHeadersFetchError = function (error, headerRange) {
    // remove fetching message
    var axis = headerRange.axis;
    this.m_fetching[axis] = false;
    // end fetch
    this._signalTaskEnd();
  };

  /**
   * Build a header context object for a header and return it
   * The header elem and the data can be set to null for cases where there are no headers
   * but varying height and width are desired
   * @param {string} axis - 'row' or 'column'
   * @param {number} index - the index of the header
   * @param {Object|null} data - the data the cell contains
   * @param {Object} metadata - the metadata the cell contains
   * @param {Element|null} elem - the header element
   * @param {number} level - the header level
   * @param {number} extent - the header extent
   * @param {number} depth - the header depth
   * @param {Element|null} headerContentDiv - header content wrapper div
   * @return {Object} the header context object, keys of {axis,index,data,datagrid}
   */
  DvtDataGrid.prototype.createHeaderContext = function (
    axis,
    index,
    data,
    metadata,
    elem,
    level,
    extent,
    depth,
    headerContentDiv
  ) {
    var headerContext = {
      axis: axis,
      index: index,
      data: data
    };
    headerContext.component = this;
    headerContext.datasource = this.m_options.getProperty('data');
    headerContext.level = level;
    headerContext.depth = depth;
    headerContext.extent = extent;

    if (headerContentDiv && (axis === 'row' || axis === 'column')) {
      headerContext.contentElement = headerContentDiv;
    }

    // set the parent element to the content div
    if (elem != null) {
      headerContext.parentElement = elem;
    }

    // merge properties from metadata into cell context
    // the properties in metadata would have precedence
    var props = Object.keys(metadata);
    for (var i = 0; i < props.length; i++) {
      var prop = props[i];
      headerContext[prop] = metadata[prop];
    }

    // invoke callback to allow ojDataGrid to change datagrid reference
    if (this.m_createContextCallback != null) {
      this.m_createContextCallback.call(this, headerContext);
    }

    return this.m_fixContextCallback.call(this, headerContext);
  };

  /**
   * Build a label context object for a header label and return it
   */
  DvtDataGrid.prototype._createLabelContext = function (
    axis,
    level,
    data,
    elem,
    metadata,
    labelContentDiv
  ) {
    var labelContext = {
      axis: axis,
      level: level,
      data: data
    };
    labelContext.component = this;
    labelContext.datasource = this.m_options.getProperty('data');

    if (labelContentDiv && (axis === 'row' || axis === 'column')) {
      labelContext.contentElement = labelContentDiv;
    }
    // set the parent element to the content div
    if (elem != null) {
      labelContext.parentElement = elem;
    }

    // invoke callback to allow ojDataGrid to change datagrid reference
    if (this.m_createContextCallback != null) {
      this.m_createContextCallback.call(this, labelContext);
    }

    if (this._isDataGridProvider() && metadata != null) {
      // merge properties from metadata into cell context
      // the properties in metadata would have precedence
      var props = Object.keys(metadata);
      for (var i = 0; i < props.length; i++) {
        var prop = props[i];
        labelContext[prop] = metadata[prop];
      }
    }

    return this.m_fixContextCallback.call(this, labelContext);
  };

  DvtDataGrid.prototype._buildHeaderLabels = function (axis, headerSet) {
    if (this.m_headerLabels[axis].length === 0) {
      if (headerSet && headerSet.getLabel) {
        var count = headerSet.getLevelCount();
        var dir;

        if (axis === 'rowEnd') {
          dir = this.getResources().isRTLMode() ? 'left' : 'right';
        } else if (axis === 'row') {
          dir = this.getResources().isRTLMode() ? 'right' : 'left';
        } else if (axis === 'column') {
          dir = 'top';
        } else if (axis === 'columnEnd') {
          dir = 'bottom';
        }
        var dirValue = 0;

        if (count > 0) {
          for (var i = 0; i < count; i++) {
            var label = document.createElement('div');
            var labelData = headerSet.getLabel(i);
            var labelMetadata;
            if (this._isDataGridProvider()) {
              labelMetadata = headerSet.getLabelMetadata(i);
            }
            var dimension = this._getLabelDimension(axis, i);

            let labelContentDiv;
            if (axis === 'row' || axis === 'column') {
              labelContentDiv = document.createElement('div');
              labelContentDiv.classList.add(this.getMappedStyle('headerLabelCellContent'));
            }
            if (labelData != null) {
              var labelContext = this._createLabelContext(
                axis,
                i,
                labelData,
                label,
                labelMetadata,
                labelContentDiv
              );
              // prettier-ignore
              label.setAttribute( // @HTMLUpdateOK
                this.getResources().getMappedAttribute('container'),
                this.getResources().widgetName
              );
              label.setAttribute(this.getResources().getMappedAttribute('busyContext'), ''); // @HTMLUpdateOK
              this._createUniqueId(label);
              label[this.getResources().getMappedAttribute('context')] = labelContext;

              const horizontalAlignment = this.m_options.getHorizontalAlignment(
                axis,
                labelContext,
                true
              );
              const verticalAlignment = this.m_options.getVeticalAlignment(axis, labelContext, true);

              // set alignment before inline stlye to ensure inline styles win
              if (horizontalAlignment !== 'auto') {
                const horizontalAlignmentStyle =
                  this._getHorizontalAlignmentStyle(horizontalAlignment);
                label.style.justifyContent = horizontalAlignmentStyle.justifyContent;
                label.style.textAlign = horizontalAlignmentStyle.textAlign;
              }

              if (verticalAlignment !== 'auto') {
                label.style.alignItems = this._getVerticalAlignmentStyle(verticalAlignment);
              }

              var inlineStyle = this.m_options.getInlineStyle(axis, labelContext, true);
              if (inlineStyle != null) {
                DataCollectionUtils.applyMergedInlineStyles(label, inlineStyle, '');
              }

              label.className =
                this.getMappedStyle('headerlabel') +
                ' ' +
                this.getMappedStyle(axis.toLowerCase() + 'headerlabel');
              var styleClass = this.m_options.getStyleClass(axis, labelContext, true);
              if (styleClass != null) {
                label.className += ' ' + styleClass;
              }

              if (axis === 'row' || axis === 'rowEnd') {
                if (axis === 'rowEnd') {
                  label.style.height = '100%';
                }
                this.setElementWidth(label, dimension);
                this.setElementDir(label, dirValue, dir);
                this.setElementDir(label, 0, 'bottom');
              } else {
                if (axis === 'columnEnd') {
                  label.style.width = '100%';
                }
                this.setElementHeight(label, dimension);
                this.setElementDir(label, dirValue, dir);
                this.setElementDir(label, 0, this.getResources().isRTLMode() ? 'left' : 'right');
              }
              if (
                this.m_options.isResizable(axis, 'width') === 'enable' ||
                this.m_options.isResizable(axis, 'height') === 'enable'
              ) {
                this._setAttribute(label, 'resizable', 'true');
              }
              var renderer = this.getRendererOrTemplate(axis, true);
              this._renderContent(
                renderer,
                labelContext,
                label,
                labelData,
                this.buildLabelTemplateContext(labelContext, labelMetadata || {})
              );
              this.m_headerLabels[axis][i] = label;
              if (this._isDataGridProvider() && this._isSortEnabled(axis, labelContext, true)) {
                const iconAppend = this._shouldAppendIcon(horizontalAlignment, axis, labelContext);
                if (
                  labelMetadata.metadata.sortDirection != null &&
                  labelMetadata.metadata.sortDirection !== 'unsorted'
                ) {
                  const labelAxisObj = {
                    level: labelContext.level,
                    axis: axis,
                    direction: labelMetadata.metadata.sortDirection
                  };

                  if (axis === 'column' && this.m_sortRowInfo == null) {
                    this.m_sortRowInfo = labelAxisObj;
                    this.m_sortRowInfo.type = 'label';
                  } else if (axis === 'row' && this.m_sortColumnInfo == null) {
                    this.m_sortColumnInfo = labelAxisObj;
                    this.m_sortColumnInfo.type = 'label';
                  }
                }

                var sortIcon = this._buildLabelSortIcon(labelContext, label, axis);
                if (iconAppend) {
                  label.appendChild(sortIcon); // @HTMLUpdateOK
                } else {
                  label.prepend(sortIcon); // @HTMLUpdateOK
                }
                this._setAttribute(label, 'sortable', 'true');
              }
            }
            dirValue += dimension;
          }
        }
      }
    }
  };

  DvtDataGrid.prototype.buildLabelTemplateContext = function (context, labelMetaData) {
    return {
      item: {
        data: context.data,
        metadata: labelMetaData.metadata
      },
      datasource: context.datasource
    };
  };

  DvtDataGrid.prototype.buildHeaderTemplateContext = function (context, headerMetaData) {
    return {
      item: {
        data: context.data,
        depth: context.depth,
        extent: context.extent,
        index: context.index,
        level: context.level,
        metadata: headerMetaData.metadata,
        axis: context.axis
      },
      datasource: context.datasource
    };
  };

  DvtDataGrid.prototype.buildCellTemplateContext = function (context, cellMetaData) {
    return {
      item: {
        columnExtent: context.extents.column,
        columnIndex: context.indexes.column,
        data: context.data,
        metadata: cellMetaData.metadata,
        rowExtent: context.extents.row,
        rowIndex: context.indexes.row
      },
      datasource: context.datasource,
      mode: context.mode
    };
  };

  DvtDataGrid.prototype.getRendererOrTemplate = function (axis, label) {
    var renderer = this.m_options.getRenderer(axis, label);
    var templateString;
    if (renderer) {
      return renderer;
    }
    var template;
    if (axis === 'cell') {
      templateString = 'cellTemplate';
    } else {
      templateString = label ? axis + 'HeaderLabelTemplate' : axis + 'HeaderTemplate';
    }
    template = this._getItemTemplateBySlotName(templateString);
    if (template) {
      return template;
    } else if (axis === 'row' || axis === 'column') {
      templateString = label ? axis + 'HeaderLabelContentTemplate' : axis + 'HeaderContentTemplate';
      template = this._getItemTemplateBySlotName(templateString);
      if (template) {
        return template;
      }
    }
    return null;
  };
  /**
   * Construct the column headers
   * @param {Element} headerRoot
   * @param {Object} headerSet
   * @param {number} start
   * @param {number} totalCount
   * @param {boolean} insert
   * @param {boolean} returnAsFragment
   * @param {number} fetchCount
   * @param {boolean} isFrozen
   * @returns {DocumentFragment|Object|undefined}
   */
  DvtDataGrid.prototype.buildColumnHeaders = function (
    headerRoot,
    headerSet,
    start,
    totalCount,
    insert,
    returnAsFragment,
    fetchCount,
    isFrozen
  ) {
    if (this.m_columnHeaderLevelCount == null) {
      this.m_columnHeaderLevelCount = headerSet.getLevelCount();
    }
    if (this.m_columnHeaderLevelCount === 0) {
      return undefined;
    }

    var axis = 'column';
    let count = fetchCount;
    if (count === undefined) {
      count = headerSet.getCount();
    }
    var isAppend = start > this.m_endColHeader;
    // eslint-disable-next-line no-param-reassign
    insert = false;
    var reference = null;
    var atPixel = isAppend ? this.m_endColHeaderPixel : this.m_startColHeaderPixel;
    var currentEnd = this.m_endColHeader;
    var levelCount = this.m_columnHeaderLevelCount;
    var rootClassName = this.getMappedStyle('colheader') + ' ' + this.getMappedStyle('header');
    var cellClassName =
      this.getMappedStyle('headercell') + ' ' + this.getMappedStyle('colheadercell');
    if (isFrozen) {
      cellClassName += ` ${this.getMappedStyle('frozenHeader')}`;
    }
    // eslint-disable-next-line no-param-reassign
    returnAsFragment = false;

    var returnObj = this.buildAxisHeaders(
      headerRoot,
      headerSet,
      axis,
      start,
      count,
      isAppend,
      insert,
      reference,
      atPixel,
      currentEnd,
      levelCount,
      rootClassName,
      cellClassName,
      returnAsFragment
    );

    /*
      if (returnAsFragment) {
        return returnObj;
      }
      */

    var totalColumnWidth = returnObj.totalHeaderDimension;
    var totalColumnHeight = returnObj.totalLevelDimension;

    if (totalColumnWidth !== 0 && (this.m_avgColWidth === 0 || this.m_avgColWidth == null)) {
      // the average column width should only be set once, it will only change when the column width varies between columns, but
      // in such case the new average column width would not be any more precise than previous one.
      // Also, hidden columns are not included in calculating average column width
      this.m_avgColWidth = totalColumnWidth / returnObj.visibleHeaderCount;
    }

    if (!this.m_colHeaderHeight) {
      this.m_colHeaderHeight = totalColumnHeight;
      this.setElementHeight(headerRoot, this.m_colHeaderHeight);
    }

    // whether this is adding columns to the left or right
    if (!isAppend) {
      // to the left
      this.m_startColHeader -= count;
      this.m_startColHeaderPixel -= totalColumnWidth;
    } else {
      // to the right, in case of long scroll this should alwats be the end header of the set
      this.m_endColHeader = start + count - 1;
      this.m_endColHeaderPixel += totalColumnWidth;
    }

    if (totalCount === -1) {
      // eslint-disable-next-line no-param-reassign
      totalCount = this.m_endColHeader;
    }

    // stop subsequent fetching if high-water mark scrolling is used and we have reach the last row, flag it.
    if (
      !this._isCountUnknown('column') &&
      this._isHighWatermarkScrolling() &&
      this.m_endColHeader + 1 >= totalCount
    ) {
      this.m_stopColumnHeaderFetch = true;
    } else {
      this.m_stopColumnHeaderFetch = returnObj.stopFetch;
    }

    // if virtual scrolling may have to adjust at the beginning
    if (this.m_startColHeader === 0 && this.m_startColHeaderPixel !== 0) {
      this._shiftHeadersAlongAxisInContainer(
        headerRoot.firstChild,
        0,
        this.m_startColHeaderPixel * -1,
        this.getResources().isRTLMode() ? 'right' : 'left',
        this.getMappedStyle('colheadercell')
      );
      this.m_endColHeaderPixel -= this.m_startColHeaderPixel;
      this.m_startColHeaderPixel = 0;
    }

    if (!this.m_initialized && this.m_startColHeader > 0) {
      var newStartEstimate = Math.round(this.m_avgColWidth * this.m_startColHeader);
      this._shiftHeadersAlongAxisInContainer(
        headerRoot.firstChild,
        this.m_startColHeader,
        newStartEstimate - this.m_startColHeaderPixel,
        this.getResources().isRTLMode() ? 'right' : 'left',
        this.getMappedStyle('colheadercell')
      );
      this.m_endColHeaderPixel = newStartEstimate + totalColumnWidth;
      this.m_startColHeaderPixel = newStartEstimate;
    }

    return undefined;
  };

  /**
   * Construct the column end headers
   * @param {Element} headerRoot
   * @param {Object} headerSet
   * @param {number} start
   * @param {number} totalCount
   * @param {boolean} insert
   * @param {boolean} returnAsFragment
   * @param {number} fetchCount
   * @param {boolean} isFrozen
   * @returns {DocumentFragment|Object|undefined}
   */
  DvtDataGrid.prototype.buildColumnEndHeaders = function (
    headerRoot,
    headerSet,
    start,
    totalCount,
    insert,
    returnAsFragment,
    fetchCount,
    isFrozen
  ) {
    if (this.m_columnEndHeaderLevelCount == null) {
      this.m_columnEndHeaderLevelCount = headerSet.getLevelCount();
    }
    if (this.m_columnEndHeaderLevelCount === 0) {
      return undefined;
    }

    var axis = 'columnEnd';
    let count = fetchCount;
    if (count === undefined) {
      count = headerSet.getCount();
    }
    var isAppend = start > this.m_endColEndHeader;
    // eslint-disable-next-line no-param-reassign
    insert = false;
    var reference = null;
    var atPixel = isAppend ? this.m_endColEndHeaderPixel : this.m_startColEndHeaderPixel;
    var currentEnd = this.m_endColEndHeader;
    var levelCount = this.m_columnEndHeaderLevelCount;
    var rootClassName = this.getMappedStyle('colendheader') + ' ' + this.getMappedStyle('endheader');
    var cellClassName =
      this.getMappedStyle('endheadercell') + ' ' + this.getMappedStyle('colendheadercell');
    if (isFrozen) {
      cellClassName += ` ${this.getMappedStyle('frozenHeader')}`;
    }
    // eslint-disable-next-line no-param-reassign
    returnAsFragment = false;

    var returnObj = this.buildAxisHeaders(
      headerRoot,
      headerSet,
      axis,
      start,
      count,
      isAppend,
      insert,
      reference,
      atPixel,
      currentEnd,
      levelCount,
      rootClassName,
      cellClassName,
      returnAsFragment
    );
    /*
      if (returnAsFragment) {
        return returnObj;
      }
  */
    var totalColumnWidth = returnObj.totalHeaderDimension;
    var totalColumnHeight = returnObj.totalLevelDimension;

    if (totalColumnWidth !== 0 && (this.m_avgColWidth === 0 || this.m_avgColWidth == null)) {
      // the average column width should only be set once, it will only change when the column width varies between columns, but
      // in such case the new average column width would not be any more precise than previous one.
      this.m_avgColWidth = totalColumnWidth / returnObj.visibleHeaderCount;
    }

    if (!this.m_colEndHeaderHeight) {
      this.m_colEndHeaderHeight = totalColumnHeight;
      this.setElementHeight(headerRoot, this.m_colEndHeaderHeight);
    }

    // whether this is adding columns to the left or right
    if (!isAppend) {
      // to the left
      this.m_startColEndHeader -= count;
      this.m_startColEndHeaderPixel -= totalColumnWidth;
    } else {
      // to the right, in case of long scroll this should alwats be the end header of the set
      this.m_endColEndHeader = start + (count - 1);
      this.m_endColEndHeaderPixel += totalColumnWidth;
    }

    if (totalCount === -1) {
      // eslint-disable-next-line no-param-reassign
      totalCount = this.m_endColEndHeader;
    }

    // stop subsequent fetching if high-water mark scrolling is used and we have reach the last row, flag it.
    if (
      !this._isCountUnknown('column') &&
      this._isHighWatermarkScrolling() &&
      this.m_endColEndHeader + 1 >= totalCount
    ) {
      this.m_stopColumnEndHeaderFetch = true;
    } else {
      this.m_stopColumnEndHeaderFetch = returnObj.stopFetch;
    }

    // if virtual scrolling may have to adjust at the beginning
    if (this.m_startColEndHeader === 0 && this.m_startColEndHeaderPixel !== 0) {
      this._shiftHeadersAlongAxisInContainer(
        headerRoot.firstChild,
        0,
        this.m_startColEndHeaderPixel * -1,
        this.getResources().isRTLMode() ? 'right' : 'left',
        this.getMappedStyle('colendheadercell')
      );
      this.m_endColEndHeaderPixel -= this.m_startColEndHeaderPixel;
      this.m_startColEndHeaderPixel = 0;
    }

    if (!this.m_initialized && this.m_startColEndHeader > 0) {
      var newStartEstimate = Math.round(this.m_avgColWidth * this.m_startColEndHeader);
      this._shiftHeadersAlongAxisInContainer(
        headerRoot.firstChild,
        this.m_startColEndHeader,
        newStartEstimate - this.m_startColEndHeaderPixel,
        this.getResources().isRTLMode() ? 'right' : 'left',
        this.getMappedStyle('colendheadercell')
      );
      this.m_endColEndHeaderPixel = newStartEstimate + totalColumnWidth;
      this.m_startColEndHeaderPixel = newStartEstimate;
    }

    return undefined;
  };

  /**
   * Construct the row headers
   * @param {Element} headerRoot
   * @param {Object} headerSet
   * @param {number} start
   * @param {number} totalCount
   * @param {boolean} insert
   * @param {boolean} returnAsFragment
   * @param {number} fetchCount
   * @param {boolean} isFrozen
   * @returns {DocumentFragment|Object|undefined}
   */
  DvtDataGrid.prototype.buildRowHeaders = function (
    headerRoot,
    headerSet,
    start,
    totalCount,
    insert,
    returnAsFragment,
    fetchCount,
    isFrozen
  ) {
    if (this.m_rowHeaderLevelCount == null) {
      this.m_rowHeaderLevelCount = headerSet.getLevelCount();
    }
    if (this.m_rowHeaderLevelCount === 0) {
      return undefined;
    }

    var axis = 'row';
    let count = fetchCount;
    if (count === undefined) {
      count = headerSet.getCount();
    }
    var isAppend = start > this.m_endRowHeader;
    var atPixel = isAppend ? this.m_endRowHeaderPixel : this.m_startRowHeaderPixel;
    var reference;

    if (insert) {
      reference = headerRoot.firstChild.childNodes[start - this.m_startRowHeader];
      atPixel = this.getElementDir(reference, 'top');
    } else {
      reference = null;
    }

    var currentEnd = this.m_endRowHeader;
    var levelCount = this.m_rowHeaderLevelCount;
    var rootClassName = this.getMappedStyle('rowheader') + ' ' + this.getMappedStyle('header');
    var cellClassName =
      this.getMappedStyle('headercell') + ' ' + this.getMappedStyle('rowheadercell');

    if (isFrozen) {
      cellClassName += ` ${this.getMappedStyle('frozenHeader')}`;
    }

    var returnObj = this.buildAxisHeaders(
      headerRoot,
      headerSet,
      axis,
      start,
      count,
      isAppend,
      insert,
      reference,
      atPixel,
      currentEnd,
      levelCount,
      rootClassName,
      cellClassName,
      returnAsFragment
    );

    var totalRowHeight = returnObj.totalHeaderDimension;
    var totalRowWidth = returnObj.totalLevelDimension;

    if (returnAsFragment) {
      return returnObj;
    }

    if (totalRowHeight !== 0 && (this.m_avgRowHeight === 0 || this.m_avgRowHeight == null)) {
      // the average row height should only be set once, it will only change when the row height varies between rows, but
      // in such case the new average row height would not be any more precise than previous one.
      this.m_avgRowHeight = totalRowHeight / returnObj.visibleHeaderCount;
    }

    if (!this.m_rowHeaderWidth) {
      this.m_rowHeaderWidth = totalRowWidth;
      this.setElementWidth(headerRoot, this.m_rowHeaderWidth);
    }

    if (isAppend) {
      // if appending a row header, make sure the previous fragment has a bottom border if it was the last
      if (this.m_endRowHeader !== -1 && count !== 0) {
        // get the last header in the scroller
        var prev = headerRoot.firstChild.childNodes[this.m_endRowHeader - this.m_startRowHeader];
        if (prev != null) {
          this.m_utils.removeCSSClassName(prev, this.getMappedStyle('borderHorizontalNone'));
        }
      }
      // in case of a long scroll the end should always be the start plus the count - 1 for 0 indexing
      this.m_endRowHeader = start + (count - 1);
      this.m_endRowHeaderPixel += totalRowHeight;
    } else if (insert) {
      if (start < this.m_startRowHeader) {
        // added before the start
        this.m_startRowHeader = start;
        this.m_startRowHeaderPixel = Math.max(0, this.m_startRowHeaderPixel - totalRowHeight);
      }
      // update the endRowHeader and endRowheaderPixel no matter where we insert
      this.m_endRowHeader += count;
      this.m_endRowHeaderPixel = Math.max(0, this.m_endRowHeaderPixel + totalRowHeight);
      this.pushRowHeadersDown(reference, totalRowHeight);
    } else {
      this.m_startRowHeader = Math.max(0, this.m_startRowHeader - count);
      // zero maximum is handled below by realigning when appropriate
      this.m_startRowHeaderPixel -= totalRowHeight;
    }

    if (totalCount === -1) {
      // eslint-disable-next-line no-param-reassign
      totalCount = this.m_endRowHeader;
    }

    // stop subsequent fetching if high-water mark scrolling is used and we have reach the last row, flag it.
    if (
      !this._isCountUnknown('row') &&
      this._isHighWatermarkScrolling() &&
      this.m_endRowHeader + 1 >= totalCount
    ) {
      this.m_stopRowHeaderFetch = true;
    } else {
      this.m_stopRowHeaderFetch = returnObj.stopFetch;
    }

    // if virtual scrolling may have to adjust at the beginning
    if (this.m_startRowHeader === 0 && this.m_startRowHeaderPixel !== 0) {
      this._shiftHeadersAlongAxisInContainer(
        headerRoot.firstChild,
        0,
        this.m_startRowHeaderPixel * -1,
        'top',
        this.getMappedStyle('rowheadercell')
      );
      this.m_endRowHeaderPixel -= this.m_startRowHeaderPixel;
      this.m_startRowHeaderPixel = 0;
    }

    if (!this.m_initialized && this.m_startRowHeader > 0) {
      var newStartEstimate = Math.round(this.m_avgRowHeight * this.m_startRowHeader);
      this._shiftHeadersAlongAxisInContainer(
        headerRoot.firstChild,
        this.m_startRowHeader,
        newStartEstimate - this.m_startRowHeaderPixel,
        'top',
        this.getMappedStyle('rowheadercell')
      );
      this.m_endRowHeaderPixel = newStartEstimate + totalRowHeight;
      this.m_startRowHeaderPixel = newStartEstimate;
    }

    return undefined;
  };

  /**
   * Construct the row end headers
   * @param {Element} headerRoot
   * @param {Object} headerSet
   * @param {number} start
   * @param {number} totalCount
   * @param {boolean} insert
   * @param {boolean} returnAsFragment
   * @param {number} fetchCount
   * @param {boolean} isFrozen
   * @returns {DocumentFragment|Object|undefined}
   */
  DvtDataGrid.prototype.buildRowEndHeaders = function (
    headerRoot,
    headerSet,
    start,
    totalCount,
    insert,
    returnAsFragment,
    fetchCount,
    isFrozen
  ) {
    if (this.m_rowEndHeaderLevelCount == null) {
      this.m_rowEndHeaderLevelCount = headerSet.getLevelCount();
    }
    if (this.m_rowEndHeaderLevelCount === 0) {
      return undefined;
    }

    var axis = 'rowEnd';
    let count = fetchCount;
    if (count === undefined) {
      count = headerSet.getCount();
    }
    // var count = headerSet.getCount();
    var isAppend = start > this.m_endRowEndHeader;
    var reference;
    var atPixel = isAppend ? this.m_endRowEndHeaderPixel : this.m_startRowEndHeaderPixel;

    if (insert) {
      reference = headerRoot.firstChild.childNodes[start - this.m_startRowEndHeader];
      atPixel = this.getElementDir(reference, 'top');
    } else {
      reference = null;
    }
    var currentEnd = this.m_endRowEndHeader;
    var levelCount = this.m_rowEndHeaderLevelCount;
    var rootClassName = this.getMappedStyle('rowendheader') + ' ' + this.getMappedStyle('endheader');
    var cellClassName =
      this.getMappedStyle('endheadercell') + ' ' + this.getMappedStyle('rowendheadercell');

    if (isFrozen) {
      cellClassName += ` ${this.getMappedStyle('frozenHeader')}`;
    }

    var returnObj = this.buildAxisHeaders(
      headerRoot,
      headerSet,
      axis,
      start,
      count,
      isAppend,
      insert,
      reference,
      atPixel,
      currentEnd,
      levelCount,
      rootClassName,
      cellClassName,
      returnAsFragment
    );

    if (returnAsFragment) {
      return returnObj;
    }

    var totalRowHeight = returnObj.totalHeaderDimension;
    var totalRowWidth = returnObj.totalLevelDimension;
    /*
      if (returnAsFragment) {
        return returnObj;
      }
      */

    if (totalRowHeight !== 0 && (this.m_avgRowHeight === 0 || this.m_avgRowHeight == null)) {
      // the average row height should only be set once, it will only change when the row height varies between rows, but
      // in such case the new average row height would not be any more precise than previous one.
      this.m_avgRowHeight = totalRowHeight / count;
    }

    if (!this.m_rowEndHeaderWidth) {
      this.m_rowEndHeaderWidth = totalRowWidth;
      this.setElementWidth(headerRoot, this.m_rowEndHeaderWidth);
    }

    if (isAppend) {
      // if appending a row header, make sure the previous fragment has a bottom border if it was the last
      if (this.m_endRowEndHeader !== -1 && count !== 0) {
        // get the last header in the scroller
        var prev =
          headerRoot.firstChild.childNodes[this.m_endRowEndHeader - this.m_startRowEndHeader];
        if (prev != null) {
          this.m_utils.removeCSSClassName(prev, this.getMappedStyle('borderHorizontalNone'));
        }
      }
      // in case of a long scroll the end should always be the start plus the count - 1 for 0 indexing
      this.m_endRowEndHeader = start + (count - 1);
      this.m_endRowEndHeaderPixel += totalRowHeight;
    } else if (insert) {
      if (start < this.m_startRowEndHeader) {
        // added before the start
        this.m_startRowEndHeader = start;
        this.m_startRowEndHeaderPixel = Math.max(0, this.m_startRowEndHeaderPixel - totalRowHeight);
      }
      // update the endRowEndHeader and endRowEndHeaderPixel no matter where we insert
      this.m_endRowEndHeader += count;
      this.m_endRowEndHeaderPixel = Math.max(0, this.m_endRowEndHeaderPixel + totalRowHeight);
      this.pushRowHeadersDown(reference, totalRowHeight);
    } else {
      this.m_startRowEndHeader = Math.max(0, this.m_startRowEndHeader - count);
      // zero maximum is handled below by realigning
      this.m_startRowEndHeaderPixel -= totalRowHeight;
    }

    if (totalCount === -1) {
      // eslint-disable-next-line no-param-reassign
      totalCount = this.m_endRowEndHeader;
    }

    // stop subsequent fetching if high-water mark scrolling is used and we have reach the last row, flag it.
    if (
      !this._isCountUnknown('row') &&
      this._isHighWatermarkScrolling() &&
      this.m_endRowEndHeader + 1 >= totalCount
    ) {
      this.m_stopRowEndHeaderFetch = true;
    } else {
      this.m_stopRowEndHeaderFetch = returnObj.stopFetch;
    }

    // if virtual scrolling may have to adjust at the beginning
    if (this.m_startRowEndHeader === 0 && this.m_startRowEndHeaderPixel !== 0) {
      this._shiftHeadersAlongAxisInContainer(
        headerRoot.firstChild,
        0,
        this.m_startRowEndHeaderPixel * -1,
        'top',
        this.getMappedStyle('rowendheadercell')
      );
      this.m_endRowEndHeaderPixel -= this.m_startRowEndHeaderPixel;
      this.m_startRowEndHeaderPixel = 0;
    }

    if (!this.m_initialized && this.m_startRowEndHeader > 0) {
      var newStartEstimate = Math.round(this.m_avgRowHeight * this.m_startRowEndHeader);
      this._shiftHeadersAlongAxisInContainer(
        headerRoot.firstChild,
        this.m_startRowEndHeader,
        newStartEstimate - this.m_startRowEndHeaderPixel,
        'top',
        this.getMappedStyle('rowendheadercell')
      );
      this.m_endRowEndHeaderPixel = newStartEstimate + totalRowHeight;
      this.m_startRowEndHeaderPixel = newStartEstimate;
    }

    return undefined;
  };

  /**
   * Build headers from the axis info provided
   * @param {Element} headerRoot
   * @param {Object} headerSet
   * @param {string} axis
   * @param {number} start
   * @param {number} count
   * @param {boolean} isAppend
   * @param {boolean} insert
   * @param {Element|null|undefined} reference
   * @param {number} atPixel
   * @param {number} currentEnd
   * @param {number} levelCount
   * @param {string} rootClassName
   * @param {string} cellClassName
   * @param {boolean} returnAsFragment
   * @returns {Object}
   */
  DvtDataGrid.prototype.buildAxisHeaders = function (
    headerRoot,
    headerSet,
    axis,
    start,
    count,
    isAppend,
    insert,
    reference,
    atPixel,
    currentEnd,
    levelCount,
    rootClassName,
    cellClassName,
    returnAsFragment
  ) {
    var columns = axis.indexOf('column') !== -1;
    var styleDir = columns ? 'height' : 'width';
    var stopFetch = false;
    var totalHeaderDimension = 0;
    var totalLevelDimension = 0;
    var left = 0;
    var top = 0;
    var scroller;
    var index;
    let hiddenInRangeCount = 0;

    if (!returnAsFragment) {
      // if unknown count and there's no more column, mark it so we won't try to fetch again
      if (count === 0 && this._isCountUnknown(axis)) {
        stopFetch = true;
        return {
          totalHeaderDimension: totalHeaderDimension,
          totalLevelDimension: totalLevelDimension,
          stopFetch: stopFetch
        };
      }
      scroller = headerRoot.firstChild;
      // add class name back if header populated later
      if (currentEnd === -1 && headerRoot.className === '') {
        // eslint-disable-next-line no-param-reassign
        headerRoot.className = rootClassName;
        // eslint-disable-next-line no-param-reassign
        headerRoot.style[styleDir] = '';
        scroller.style[styleDir] = '';
      }
    }

    var renderer = this.getRendererOrTemplate(axis);
    var fragment = document.createDocumentFragment();
    var x = 0;
    while (count - x > 0) {
      if (isAppend || insert) {
        index = start + x;
        left = columns ? atPixel + totalHeaderDimension : 0;
        top = columns ? 0 : atPixel + totalHeaderDimension;
      } else {
        index = start + (count - 1 - x);
        left = columns ? atPixel - totalHeaderDimension : 0;
        top = columns ? 0 : atPixel - totalHeaderDimension;
      }

      if (this.isHidden(axis, index)) {
        hiddenInRangeCount += 1;
      }

      var returnVal = this.buildLevelHeaders(
        fragment,
        index,
        0,
        left,
        top,
        isAppend,
        insert,
        renderer,
        headerSet,
        axis,
        cellClassName,
        levelCount
      );
      // increment the count over the extent of the header
      x += returnVal.count;
      totalHeaderDimension += returnVal.totalHeaderDimension;
      if (returnVal.totalLevelDimension > totalLevelDimension) {
        totalLevelDimension = returnVal.totalLevelDimension;
      }
    }

    if (returnAsFragment) {
      return fragment;
    }

    if (isAppend) {
      scroller.appendChild(fragment); // @HTMLUpdateOK
    } else if (insert) {
      scroller.insertBefore(fragment, reference); // @HTMLUpdateOK
    } else {
      scroller.insertBefore(fragment, scroller.firstChild); // @HTMLUpdateOK
    }

    if (!headerRoot.hasChildNodes() && !insert) {
      headerRoot.appendChild(scroller); // @HTMLUpdateOK
    }

    this.m_subtreeAttachedCallback(scroller);

    let visibleHeaderCount = count - hiddenInRangeCount;

    return {
      totalHeaderDimension: totalHeaderDimension,
      totalLevelDimension: totalLevelDimension,
      stopFetch: stopFetch,
      visibleHeaderCount
    };
  };

  /**
   * This method is used to call the renderer
   * @param {Function|undefined|null} renderer
   * @param {Object} context cellContext or headerContext
   * @param {Element} cell cell or header to append content to
   * @param {Object|string} data data for the cell
   * @param {Object|string} templateContext templateContext is template is used
   * @private
   */
  DvtDataGrid.prototype._renderContent = function (renderer, context, cell, data, templateContext) {
    let shouldAppendContentElement = false;
    let headerContentDiv = context.contentElement;
    if (renderer != null && typeof renderer === 'function') {
      const returnObj = renderer.call(this, context);
      let element = cell;
      let content = returnObj;
      // if insertContent is provided then returned string or HTMLElement should be wrapped in div.
      if (returnObj?.insert != null) {
        content = returnObj.insert;
      } else if (headerContentDiv != null) {
        if (returnObj?.insertContent != null) {
          element = headerContentDiv;
          content = returnObj.insertContent;
          shouldAppendContentElement = true;
        } else if (headerContentDiv.hasChildNodes()) {
          shouldAppendContentElement = true;
        }

        if (shouldAppendContentElement) {
          cell.appendChild(headerContentDiv); // @HTMLUpdateOK
        }
      }
      DataCollectionUtils.applyRendererContent(
        element,
        content,
        false,
        !this.m_isCustomElementCallback() ? this.m_subtreeAttachedCallback : null
      );
      this._removeFocusFromChildElements(context, cell);
    } else if (renderer != null && typeof renderer === 'object' && this.m_engine) {
      var nodes = this.m_engine.execute(this.m_root, renderer, templateContext, null);
      shouldAppendContentElement =
        renderer.slot === 'columnHeaderContentTemplate' ||
        renderer.slot === 'rowHeaderContentTemplate' ||
        renderer.slot === 'columnHeaderLabelContentTemplate' ||
        renderer.slot === 'rowHeaderLabelContentTemplate';

      for (var i = 0; i < nodes.length; i++) {
        if (shouldAppendContentElement) {
          headerContentDiv.appendChild(nodes[i]); // @HTMLUpdateOK
        } else {
          cell.appendChild(nodes[i]); // @HTMLUpdateOK
        }
      }
      if (shouldAppendContentElement) {
        cell.appendChild(headerContentDiv); // @HTMLUpdateOK
      }
      this._removeFocusFromChildElements(context, cell);
    } else {
      if (
        data != null &&
        typeof data === 'object' &&
        Object.prototype.hasOwnProperty.call(data, 'data')
      ) {
        // eslint-disable-next-line no-param-reassign
        data = data.data;
      }
      if (data == null) {
        // eslint-disable-next-line no-param-reassign
        data = '';
      }
      if (headerContentDiv) {
        headerContentDiv.appendChild(document.createTextNode(data.toString())); // @HTMLUpdateOK
        cell.appendChild(headerContentDiv); // @HTMLUpdateOK
      } else {
        cell.appendChild(document.createTextNode(data.toString())); // @HTMLUpdateOK
      }
    }
  };

  /**
   * When in edit mode make all focusable elements non-focusable, since we want to manage tab stops
   * @param {Object} context cellContext or headerContext
   * @param {Element} cell cell that we want to make children unfocusable
   * @private
   */
  DvtDataGrid.prototype._removeFocusFromChildElements = function (context, cell) {
    if (context.mode !== 'edit') {
      var self = this;
      this._signalTaskStart();
      var busyContext = this.m_contextCallback(cell).getBusyContext();
      busyContext.whenReady().then(function () {
        DataCollectionUtils.disableAllFocusableElements(cell);
        self._signalTaskEnd();
      });
    }
  };

  /**
   * Build headers along an axis recursively building them within the set
   * @param {DocumentFragment|Element|undefined} fragment the fragment to append the headers to
   * @param {number} index the index to begin rendering at
   * @param {number} level the level of the header to build at
   * @param {number} left the left value of the headers
   * @param {number} top the top value to start at
   * @param {boolean} isAppend is appending after
   * @param {boolean|undefined|null} insert is row or column insert
   * @param {Function|undefined|null} renderer header renderer
   * @param {Object} headerSet object
   * @param {string} axis column or row
   * @param {string} className string of the class names to be applied to the headers
   * @param {number} totalLevels the number of levels on the header
   * @returns {Object}
   */
  DvtDataGrid.prototype.buildLevelHeaders = function (
    fragment,
    index,
    level,
    left,
    top,
    isAppend,
    insert,
    renderer,
    headerSet,
    axis,
    className,
    totalLevels
  ) {
    var levelDimensionValue = 0;
    var totalLevelDimensionValue = 0;
    var totalHeaderDimensionValue = 0;
    var headerCount = 0;
    var dimensionAxis;
    var groupingRoot;
    var levelDimension;
    var levelDimensionCache;
    var headerDimension;
    var dimensionToAdjust;
    var dimensionToAdjustValue;
    var dimensionSecond;
    var dimensionSecondValue;
    var start;
    var end;
    var groupingContainer;
    var header;
    var i;
    var returnVal;
    let hidden;

    if (axis === 'row') {
      dimensionAxis = 'row';
      groupingRoot = this.m_rowHeader;
      levelDimension = 'width';
      levelDimensionCache = this.m_rowHeaderLevelWidths;
      headerDimension = 'height';
      dimensionToAdjust = 'top';
      dimensionToAdjustValue = top;
      dimensionSecond = this.getResources().isRTLMode() ? 'right' : 'left';
      dimensionSecondValue = left;
      start = this.m_startRowHeader;
      end = this.m_endRowHeader;
      if (this._hasFrozenRows() && index <= this.m_frozenRowIndex && this.m_rowHeaderFrozen) {
        groupingRoot = this.m_rowHeaderFrozen;
      }
    } else if (axis === 'rowEnd') {
      dimensionAxis = 'row';
      groupingRoot = this.m_rowEndHeader;
      levelDimension = 'width';
      levelDimensionCache = this.m_rowEndHeaderLevelWidths;
      headerDimension = 'height';
      dimensionToAdjust = 'top';
      dimensionToAdjustValue = top;
      dimensionSecond = this.getResources().isRTLMode() ? 'left' : 'right';
      dimensionSecondValue = left;
      start = this.m_startRowEndHeader;
      end = this.m_endRowEndHeader;
      if (this._hasFrozenRows() && index <= this.m_frozenRowIndex && this.m_rowEndHeaderFrozen) {
        groupingRoot = this.m_rowEndHeaderFrozen;
      }
    } else if (axis === 'column') {
      dimensionAxis = 'column';
      groupingRoot = this.m_colHeader;
      levelDimension = 'height';
      levelDimensionCache = this.m_columnHeaderLevelHeights;
      headerDimension = 'width';
      dimensionToAdjust = this.getResources().isRTLMode() ? 'right' : 'left';
      dimensionToAdjustValue = left;
      dimensionSecond = 'top';
      dimensionSecondValue = top;
      start = this.m_startColHeader;
      end = this.m_endColHeader;
      if (this._hasFrozenColumns() && index <= this.m_frozenColIndex && this.m_colHeaderFrozen) {
        groupingRoot = this.m_colHeaderFrozen;
      }
    } else {
      dimensionAxis = 'column';
      groupingRoot = this.m_colEndHeader;
      levelDimension = 'height';
      levelDimensionCache = this.m_columnEndHeaderLevelHeights;
      headerDimension = 'width';
      dimensionToAdjust = this.getResources().isRTLMode() ? 'right' : 'left';
      dimensionToAdjustValue = left;
      dimensionSecond = 'bottom';
      dimensionSecondValue = top;
      start = this.m_startColEndHeader;
      end = this.m_endColEndHeader;
      if (this._hasFrozenColumns() && index <= this.m_frozenColIndex && this.m_colEndHeaderFrozen) {
        groupingRoot = this.m_colEndHeaderFrozen;
      }
    }

    hidden = this.isHidden(axis, index);

    // get the extent info
    var extentInfo = headerSet.getExtent(index, level);
    var headerExtent = extentInfo.extent;
    var patchBefore = extentInfo.more.before;
    var patchAfter = extentInfo.more.after;
    var headerDepth = headerSet.getDepth(index, level);
    let headerContext;

    // if the data source says to patch before this header
    // and the index is 1 more than what is currently in the viewport
    // get the groupingContainer and add to it
    if (patchBefore && index === end + 1) {
      // get the grouping of the container at the previous index
      groupingContainer = this._getHeaderContainer(index - 1, level, groupingRoot, totalLevels);
      // increment the extent stored in the grouping container
      this._setAttribute(
        groupingContainer,
        'extent',
        this._getAttribute(groupingContainer, 'extent', true) + headerExtent
      );
      header = groupingContainer.firstChild;
      headerContext = header[this.getResources().getMappedAttribute('context')];
      headerContext.extent += headerExtent;
      levelDimensionValue = this.getElementDir(header, levelDimension);
      // add columns to that grouping container
      for (i = 0; i < headerExtent; ) {
        if (axis === 'column' || axis === 'columnEnd') {
          returnVal = this.buildLevelHeaders(
            groupingContainer,
            index + i,
            level + headerDepth,
            dimensionToAdjustValue,
            dimensionSecondValue + levelDimensionValue,
            isAppend,
            insert,
            renderer,
            headerSet,
            axis,
            className,
            totalLevels
          );
        } else {
          returnVal = this.buildLevelHeaders(
            groupingContainer,
            index + i,
            level + headerDepth,
            dimensionSecondValue + levelDimensionValue,
            dimensionToAdjustValue,
            isAppend,
            insert,
            renderer,
            headerSet,
            axis,
            className,
            totalLevels
          );
        }
        // increment the left and total and count and skip ahead to the next header
        dimensionToAdjustValue += returnVal.totalHeaderDimension;
        totalHeaderDimensionValue += returnVal.totalHeaderDimension;
        headerCount += returnVal.count;
        i += returnVal.count;
      }
      // adjust the header size based on the total of the new sizes passed back
      this.setElementDir(
        header,
        this.getElementDir(header, headerDimension) + totalHeaderDimensionValue,
        headerDimension
      );
      if (header.style.display === 'none' && totalHeaderDimensionValue !== 0) {
        header.style.display = '';
        this.deleteAndApplyHiddenIndicators();
      }
    } else if (patchAfter && index === start - 1) {
      // if the data source says to patch after this header
      // and the index is 1 less than what is currently in the viewport
      // get the groupingContainer and add to it
      // get the grouping of the container at the previous index
      groupingContainer = this._getHeaderContainer(index + 1, level, groupingRoot, totalLevels);
      // increment the extent stored in the grouping container
      this._setAttribute(
        groupingContainer,
        'extent',
        this._getAttribute(groupingContainer, 'extent', true) + headerExtent
      );
      // decrement the start stored in the grouping container, since inserting before
      this._setAttribute(
        groupingContainer,
        'start',
        this._getAttribute(groupingContainer, 'start', true) - headerExtent
      );
      header = groupingContainer.firstChild;
      headerContext = header[this.getResources().getMappedAttribute('context')];
      headerContext.extent += headerExtent;
      headerContext.index -= headerExtent;
      levelDimensionValue = this.getElementDir(header, levelDimension);
      for (i = 0; i < headerExtent; ) {
        if (axis === 'column' || axis === 'columnEnd') {
          returnVal = this.buildLevelHeaders(
            groupingContainer,
            index - i,
            level + headerDepth,
            dimensionToAdjustValue,
            dimensionSecondValue + levelDimensionValue,
            isAppend,
            insert,
            renderer,
            headerSet,
            axis,
            className,
            totalLevels
          );
        } else {
          returnVal = this.buildLevelHeaders(
            groupingContainer,
            index - i,
            level + headerDepth,
            dimensionSecondValue + levelDimensionValue,
            dimensionToAdjustValue,
            isAppend,
            insert,
            renderer,
            headerSet,
            axis,
            className,
            totalLevels
          );
        }
        dimensionToAdjustValue -= returnVal.totalHeaderDimension;
        totalHeaderDimensionValue += returnVal.totalHeaderDimension;
        headerCount += returnVal.count;
        i += returnVal.count;
      }
      this.setElementDir(
        header,
        this.getElementDir(header, headerDimension) + totalHeaderDimensionValue,
        headerDimension
      );
      if (header.style.display === 'none' && totalHeaderDimensionValue !== 0) {
        header.style.display = '';
        this.deleteAndApplyHiddenIndicators();
      }
      this.setElementDir(header, dimensionToAdjustValue, dimensionToAdjust);
    } else {
      // get the information from the headers
      var headerData = headerSet.getData(index, level);
      var headerMetadata = headerSet.getMetadata(index, level);

      // create the header element and append the content to it
      header = document.createElement('div');

      let headerContentDiv;
      if (axis === 'row' || axis === 'column') {
        headerContentDiv = document.createElement('div');
        headerContentDiv.classList.add(this.getMappedStyle('headerCellContent'));
      }

      // build headerContext to pass to renderer
      headerContext = this.createHeaderContext(
        axis,
        isAppend || insert ? index : index - headerExtent + 1,
        headerData,
        headerMetadata,
        header,
        level,
        headerExtent,
        headerDepth,
        headerContentDiv
      );
      // prettier-ignore
      header.setAttribute( // @HTMLUpdateOK
        this.getResources().getMappedAttribute('container'),
        this.getResources().widgetName
      );
      header.setAttribute(this.getResources().getMappedAttribute('busyContext'), ''); // @HTMLUpdateOK
      this._createUniqueId(header);
      header[this.getResources().getMappedAttribute('context')] = headerContext;
      header[this.getResources().getMappedAttribute('metadata')] = headerMetadata;
      header.extentInfo = extentInfo;
      var inlineStyle = this.m_options.getInlineStyle(axis, headerContext);
      var styleClass = this.m_options.getStyleClass(axis, headerContext);

      // add inline styles to the column header cell
      if (inlineStyle != null) {
        DataCollectionUtils.applyMergedInlineStyles(header, inlineStyle, '');
      }

      // add class names to the column header cell
      header.className = className;
      header.className += ' ' + this.getMappedStyle('depth') + headerDepth;
      if (styleClass != null) {
        header.className += ' ' + styleClass;
      }

      // position the element before getting its dimensions because of half pixel rounding issues in chrome/ie
      this.setElementDir(header, dimensionSecondValue, dimensionSecond);
      this.setElementDir(header, dimensionToAdjustValue, dimensionToAdjust);

      var dimensions = this._getHeaderDimensions(
        header,
        headerDimension,
        levelDimension,
        levelDimensionCache,
        level,
        dimensionAxis,
        headerContext.key,
        headerDepth
      );

      levelDimensionValue = dimensions[levelDimension];
      this.setElementDir(header, levelDimensionValue, levelDimension);

      // find the size in case it depends on the classes, will be set in the appropriate case
      var headerDimensionValue = dimensions[headerDimension];

      this._setAttribute(header, 'depth', headerDepth);

      // if this is an outer level then add a groupingContainer around it
      if (level !== totalLevels - 1) {
        groupingContainer = document.createElement('div');
        groupingContainer.className = this.getMappedStyle('groupingcontainer');
        groupingContainer.appendChild(header); // @HTMLUpdateOK
        this._setAttribute(
          groupingContainer,
          'start',
          isAppend || insert ? index : index - headerExtent + 1
        );
        this._setAttribute(groupingContainer, 'extent', headerExtent);
        this._setAttribute(groupingContainer, 'level', level);
      }

      if (level + headerDepth === totalLevels) {
        // set the px width on the header regardless of unit type currently on it
        if (hidden) {
          headerDimensionValue = 0;
          header.style.display = 'none';
        }
        this.setElementDir(header, headerDimensionValue, headerDimension);
        totalHeaderDimensionValue += headerDimensionValue;
        headerCount += 1;
        totalLevelDimensionValue = levelDimensionValue;
        if (!(isAppend || insert)) {
          dimensionToAdjustValue -= headerDimensionValue;
          this.setElementDir(header, dimensionToAdjustValue, dimensionToAdjust);
        }
      } else {
        for (i = 0; i < headerExtent; i++) {
          var nextIndex = isAppend || insert ? index + i : index - i;
          if (axis === 'column' || axis === 'columnEnd') {
            returnVal = this.buildLevelHeaders(
              groupingContainer,
              nextIndex,
              level + headerDepth,
              dimensionToAdjustValue,
              dimensionSecondValue + levelDimensionValue,
              isAppend,
              insert,
              renderer,
              headerSet,
              axis,
              className,
              totalLevels
            );
          } else {
            returnVal = this.buildLevelHeaders(
              groupingContainer,
              nextIndex,
              level + headerDepth,
              dimensionSecondValue + levelDimensionValue,
              dimensionToAdjustValue,
              isAppend,
              insert,
              renderer,
              headerSet,
              axis,
              className,
              totalLevels
            );
          }
          headerDimensionValue = returnVal.totalHeaderDimension;
          dimensionToAdjustValue =
            isAppend || insert
              ? dimensionToAdjustValue + headerDimensionValue
              : dimensionToAdjustValue - headerDimensionValue;
          totalHeaderDimensionValue += headerDimensionValue;
          headerCount += returnVal.count;
          i += returnVal.count - 1;
        }
        totalLevelDimensionValue = levelDimensionValue;
        if (returnVal && !isNaN(returnVal.totalLevelDimension)) {
          totalLevelDimensionValue += returnVal.totalLevelDimension;
        }
        if (!(isAppend || insert)) {
          this.setElementDir(header, dimensionToAdjustValue, dimensionToAdjust);
        }
        this.setElementDir(header, totalHeaderDimensionValue, headerDimension);
        // if all children headers of a nested header is hidden, hide parent header too
        if (this.isHeaderHidden(header)) {
          header.style.display = 'none';
        }
      }

      if (axis === 'columnEnd' && this.m_addBorderBottom) {
        this.m_utils.addCSSClassName(header, this.getMappedStyle('borderHorizontalSmall'));
      }

      if (axis === 'rowEnd' && this.m_addBorderRight) {
        this.m_utils.addCSSClassName(header, this.getMappedStyle('borderVerticalSmall'));
      }

      // add resizable attribute if resize enabled
      if (this._isHeaderResizeEnabled(axis, headerContext)) {
        this._setAttribute(header, 'resizable', 'true');
      }

      if (!this.m_isCustomElementCallback()) {
        // Temporarily add groupingContainer or header into this.m_root to have them in active DOM before rendering contents
        if (groupingContainer != null) {
          this.m_root.appendChild(groupingContainer); // @HTMLUpdateOK
        } else {
          this.m_root.appendChild(header); // @HTMLUpdateOK
        }
      }

      const horizontalAlignment = this.m_options.getHorizontalAlignment(axis, headerContext);
      const verticalAlignment = this.m_options.getVeticalAlignment(axis, headerContext);

      this._renderContent(
        renderer,
        headerContext,
        header,
        headerData,
        this.buildHeaderTemplateContext(headerContext, headerMetadata)
      );

      // set alignment before inline stlye to ensure inline styles win
      if (horizontalAlignment !== 'auto') {
        const horizontalAlignmentStyle = this._getHorizontalAlignmentStyle(horizontalAlignment);
        header.style.justifyContent = horizontalAlignmentStyle.justifyContent;
        header.style.textAlign = horizontalAlignmentStyle.textAlign;
      }

      if (verticalAlignment !== 'auto') {
        header.style.alignItems = this._getVerticalAlignmentStyle(verticalAlignment);
      }

      const iconAppend = this._shouldAppendIcon(horizontalAlignment, axis, headerContext);

      if (this._isRequired(headerContext)) {
        var requiredIcon = document.createElement('span');

        this.m_utils.addCSSClassName(requiredIcon, this.getMappedStyle('iconContainer'));
        this.m_utils.addCSSClassName(requiredIcon, this.getMappedStyle('requiredIcon'));

        requiredIcon.setAttribute('title', this.getResources().getTranslatedText('tooltipRequired'));

        header.appendChild(requiredIcon); // @HTMLUpdateOK
      }

      if (axis === 'column' || this._isDataGridProvider()) {
        // check if we need to render sort icons
        if (this._isSortEnabled(axis, headerContext)) {
          if (this._isDataGridProvider()) {
            if (
              headerMetadata.sortDirection != null &&
              ((axis === 'column' && this.m_sortColumnInfo == null) ||
                (axis === 'row' && this.m_sortRowInfo == null))
            ) {
              if (axis === 'row') {
                this.m_sortRowInfo = {};
                this.m_sortRowInfo.key = headerMetadata.key;
                this.m_sortRowInfo.direction = headerMetadata.sortDirection;
                this.m_sortRowInfo.axis = axis;
                this.m_sortRowInfo.type = 'header';
              } else {
                this.m_sortColumnInfo = {};
                this.m_sortColumnInfo.key = headerMetadata.key;
                this.m_sortColumnInfo.direction = headerMetadata.sortDirection;
                this.m_sortColumnInfo.axis = axis;
                this.m_sortColumnInfo.type = 'header';
              }
            }
          } else if (this.m_sortColumnInfo == null) {
            this.m_sortColumnInfo = {};
            this.m_sortColumnInfo.key = headerMetadata.key;
            this.m_sortColumnInfo.direction = headerMetadata.sortDirection;
            this.m_sortColumnInfo.axis = axis;
          }

          var sortIcon = this._buildSortIcon(headerContext, header, axis);
          if (iconAppend) {
            header.appendChild(sortIcon); // @HTMLUpdateOK
          } else {
            header.insertBefore(sortIcon, header.childNodes[0]); // @HTMLUpdateOK
          }
          this._setAttribute(header, 'sortable', 'true');
        }
      }

      if (axis === 'column' && this._isFilterEnabled(axis, headerContext)) {
        const filterIcon = this._buildFilterIcon(headerContext, header, axis);
        if (iconAppend) {
          header.appendChild(filterIcon); // @HTMLUpdateOK
        } else {
          header.insertBefore(filterIcon, header.childNodes[0]); // @HTMLUpdateOK
        }
        this._setAttribute(header, 'filterable', 'true');
      }

      if (this._isParentNode(headerContext)) {
        const disclousreIcon = this._buildDisclosureIcon(headerContext);
        if (this._isHierarchicalGroup(headerContext)) {
          this.m_utils.addCSSClassName(header, this.getMappedStyle('hierarchicalGroup'));
        } else {
          this.m_utils.addCSSClassName(header, this.getMappedStyle('hierarchicalTree'));
        }
        header.prepend(disclousreIcon); // @HTMLUpdateOK
        const spacer = this._buildSpacer(headerContext);
        header.prepend(spacer); // @HTMLUpdateOK
      } else if (this._isLeafNode(headerContext)) {
        this.m_utils.addCSSClassName(header, this.getMappedStyle('hierarchical'));
        const spacer = this._buildSpacer(headerContext);
        header.prepend(spacer); // @HTMLUpdateOK
      }

      // Moves groupingContainer/header from this.m_root to fragment
      if (isAppend || insert) {
        // if we are appending to the end, if there is a grouping container append that, if not just append the row header
        if (groupingContainer != null) {
          fragment.appendChild(groupingContainer); // @HTMLUpdateOK
        } else {
          fragment.appendChild(header); // @HTMLUpdateOK
        }
      } else if (groupingContainer != null) {
        // if we are not appending to the end
        // if there is a grouping container append that to the fragment
        // if the fragment already has a firstChild we want to insert before it
        if (fragment.firstChild) {
          // if the firstChild is a groupingContainer just insert before it
          if (
            this.m_utils.containsCSSClassName(
              fragment.firstChild,
              this.getMappedStyle('groupingcontainer')
            )
          ) {
            fragment.insertBefore(groupingContainer, fragment.firstChild); // @HTMLUpdateOK
          } else if (
            this.m_utils.containsCSSClassName(
              fragment.firstChild,
              this.getMappedStyle('headercell')
            ) ||
            this.m_utils.containsCSSClassName(
              fragment.firstChild,
              this.getMappedStyle('endheadercell')
            )
          ) {
            // if the firstChild is a cell need to insert after it
            fragment.insertBefore(groupingContainer, fragment.firstChild.nextSibling); // @HTMLUpdateOK
          }
        } else {
          fragment.appendChild(groupingContainer); // @HTMLUpdateOK
        }
      } else if (
        this.m_utils.containsCSSClassName(fragment, this.getMappedStyle('groupingcontainer'))
      ) {
        // if the fragment itself is a grouping container insert before the other grouping containers
        fragment.insertBefore(header, fragment.firstChild.nextSibling); // @HTMLUpdateOK
      } else {
        // otherwise just insert the header at the beginning of the fragment
        fragment.insertBefore(header, fragment.firstChild); // @HTMLUpdateOK
      }
    }

    // do not put borders on last header cell, treat the index as the index + extent
    // needs to be here and not in loop in case of pactching nested headers
    if (axis === 'column' || axis === 'columnEnd') {
      if (this._isLastColumn(index + (headerExtent - 1))) {
        this.m_utils.addCSSClassName(header, this.getMappedStyle('borderVerticalNone'));
      }
    } else if (this._isLastRow(index + (headerExtent - 1)) && !insert) {
      // do not put bottom border on last row, pass the index + extent to see if it's the last index
      this.m_utils.addCSSClassName(header, this.getMappedStyle('borderHorizontalNone'));
    }

    // return value is the totalHeight of the rendered headers at this level,
    // the total count of headers rendered at that level,
    // and the totalWidth of the levels underneath it
    return {
      totalLevelDimension: totalLevelDimensionValue,
      totalHeaderDimension: totalHeaderDimensionValue,
      count: headerCount
    };
  };

  DvtDataGrid.prototype._getHeaderDimensions = function (
    header,
    dimension,
    levelDimension,
    levelCache,
    level,
    axis,
    key,
    depth
  ) {
    var value = {};
    var levelDimensionValue = 0;
    for (var i = 0; i < depth; i++) {
      var cachedLevelDimension = levelCache[level + i];
      if (cachedLevelDimension == null) {
        levelDimensionValue = null;
        break;
      }
      levelDimensionValue += cachedLevelDimension;
    }

    if (levelDimensionValue == null) {
      value = this._computeElementWidthAndHeight(header);
    } else {
      value[levelDimension] = levelDimensionValue;
    }

    if (depth === 1) {
      // eslint-disable-next-line no-param-reassign
      levelCache[level] = value[levelDimension];
    }

    var dimensionValue = this.m_sizingManager.getSize(axis, key);
    if (dimensionValue != null) {
      value[dimension] = dimensionValue;
      return value;
    }

    // check if inline style set on element
    if (header.style[dimension] !== '') {
      if (value[dimension] == null) {
        value[dimension] = this.getElementDir(header, dimension);
      }
      // in the event that row height is set via an additional style only on row header store the value
      this.m_sizingManager.setSize(axis, key, value[dimension]);
      return value;
    }

    // check style class mapping, mapping prevents multiple offsetHeight calls on headers with the same class name
    var className = header.className;
    if (value[dimension] == null) {
      value[dimension] = this.m_styleClassDimensionMap[dimension][className];
      if (value[dimension] == null) {
        // exhausted all options, use offsetHeight then, remove element in the case of shim element
        value[dimension] = this.getElementDir(header, dimension);
      }
    }

    // the value isn't the default the cell will use meaning it's from an external
    // class, so store it in the sizing manager cell can pick it up, header and cell dimension can vary on em
    this.m_sizingManager.setSize(axis, key, value[dimension]);

    this.m_styleClassDimensionMap[dimension][className] = value[dimension];
    return value;
  };

  /**
   * Get the header dimension at a particular level, which will be cached if set once at that level
   * This permits the user to set the level width on the first row header at that width using renderers.
   * If it is not cached get the width
   * @param {number} level the level to get the dimension of
   * @param {Element} element the row header to get the dimension of if not cached
   * @param {Object} cache the  cache to look in
   * @param {string} dimension width/height
   * @param {number} depth
   * @returns {number} the dimension of that level
   * @private
   */
  DvtDataGrid.prototype._getHeaderLevelDimension = function (
    level,
    element,
    cache,
    dimension,
    depth
  ) {
    var width = 0;

    for (var i = 0; i < depth; i++) {
      var cachedWidth = cache[level + i];
      if (cachedWidth == null) {
        width = null;
        break;
      }
      width += cachedWidth;
    }

    if (width != null) {
      return width;
    }

    width = this.getElementDir(element, dimension);
    if (depth === 1) {
      // eslint-disable-next-line no-param-reassign
      cache[level] = width;
    }
    return width;
  };

  /**
   * Get the header container surrounding the headers.
   * The structure of a container is as follows:
   * firstChild: header at that level
   * subsequent children: grouping containers except at the innermost level
   * @param {number|string} index
   * @param {number|string} level
   * @param {Element} root
   * @param {number} totalLevels
   * @returns {Element|null}
   * @private
   */
  DvtDataGrid.prototype._getHeaderContainer = function (index, level, root, totalLevels) {
    const header = this._getHeaderByIndexFromRoot(index, level, root, totalLevels, 0);
    if (header) {
      return header.parentNode;
    }
    return null;
  };

  DvtDataGrid.prototype._getChildElementCountByClassName = function (element, className) {
    if (element == null) {
      return 0;
    }

    let count = 0;
    if (className) {
      count += Array.from(element.children).filter((child) =>
        this.m_utils.containsCSSClassName(child, className)
      ).length;
    }

    return count;
  };

  DvtDataGrid.prototype._getHeaderPreviousSibling = function (element) {
    if (!element || !element.previousSibling) {
      return null;
    }

    const headerStyle = this.getMappedStyle('headercell');
    const endHeaderStyle = this.getMappedStyle('endheadercell');
    const groupingContainerStyle = this.getMappedStyle('groupingcontainer');

    const prevSibling = element.previousSibling;

    if (
      prevSibling.classList.contains(headerStyle) ||
      prevSibling.classList.contains(endHeaderStyle) ||
      prevSibling.classList.contains(groupingContainerStyle)
    ) {
      return prevSibling;
    }
    return this._getHeaderPreviousSibling(prevSibling);
  };

  DvtDataGrid.prototype._getHeaderLastChild = function (headersContainer) {
    let lastChild = headersContainer.lastChild;
    const headerStyle = this.getMappedStyle('headercell');
    const endHeaderStyle = this.getMappedStyle('endheadercell');
    const groupingContainerStyle = this.getMappedStyle('groupingcontainer');

    if (!lastChild) {
      return null;
    }

    while (
      lastChild &&
      !(
        lastChild.classList.contains(headerStyle) ||
        lastChild.classList.contains(endHeaderStyle) ||
        lastChild.classList.contains(groupingContainerStyle)
      )
    ) {
      lastChild = lastChild.previousSibling;
    }

    return lastChild;
  };

  DvtDataGrid.prototype._getHeaderByIndex = function (index, axis, level) {
    let headerDetails = this._getHeaderDetails(index, axis);
    let root = headerDetails.root;
    let totalLevels = headerDetails.totalLevels;
    let startIndex = headerDetails.startIndex;
    return this._getHeaderByIndexFromRoot(index, level, root, totalLevels, startIndex);
  };

  DvtDataGrid.prototype._getHeaderDetails = function (index, axis) {
    let root;
    let totalLevels;
    let startIndex;

    let frozenRoot;
    let hasFrozen;
    let frozenIndex;
    if (axis === 'column') {
      root = this.m_colHeader;
      totalLevels = this.m_columnHeaderLevelCount;
      startIndex = this.m_startColHeader;
      frozenRoot = this.m_colHeaderFrozen;
      hasFrozen = this._hasFrozenColumns();
      frozenIndex = this.m_frozenColIndex;
    } else if (axis === 'columnEnd') {
      root = this.m_colEndHeader;
      totalLevels = this.m_columnEndHeaderLevelCount;
      startIndex = this.m_startColEndHeader;
      frozenRoot = this.m_colEndHeaderFrozen;
      hasFrozen = this._hasFrozenColumns();
      frozenIndex = this.m_frozenColIndex;
    } else if (axis === 'row') {
      root = this.m_rowHeader;
      totalLevels = this.m_rowHeaderLevelCount;
      startIndex = this.m_startRowHeader;
      frozenRoot = this.m_rowHeaderFrozen;
      hasFrozen = this._hasFrozenRows();
      frozenIndex = this.m_frozenRowIndex;
    } else if (axis === 'rowEnd') {
      root = this.m_rowEndHeader;
      totalLevels = this.m_rowEndHeaderLevelCount;
      startIndex = this.m_startRowEndHeader;
      frozenRoot = this.m_rowEndHeaderFrozen;
      hasFrozen = this._hasFrozenRows();
      frozenIndex = this.m_frozenRowIndex;
    }

    if (hasFrozen) {
      if (index <= frozenIndex) {
        root = frozenRoot;
      } else {
        startIndex += frozenIndex + 1;
      }
    }
    return { root, totalLevels, startIndex };
  };

  DvtDataGrid.prototype._getHeadersByIndex = function (index, axis) {
    let headers = [];
    let headerDetails = this._getHeaderDetails(index, axis);
    let root = headerDetails.root;
    let totalLevels = headerDetails.totalLevels;
    let startIndex = headerDetails.startIndex;

    let depth = 1;
    for (let level = totalLevels - 1; level >= 0; level -= depth) {
      let header = this._getHeaderByIndexFromRoot(index, level, root, totalLevels, startIndex);
      if (header) {
        depth = this.getHeaderCellDepth(header);
        headers.push(header);
      }
    }

    return headers;
  };

  /**
   * Get the header at a particular index and level for a root
   * @param {number|string} index
   * @param {number|string} level
   * @param {Element} root
   * @param {number} totalLevels
   * @param {number} startIndex for that level
   * @returns {Element|null}
   * @private
   */
  DvtDataGrid.prototype._getHeaderByIndexFromRoot = function (
    index,
    level,
    root,
    totalLevels,
    startIndex
  ) {
    let relativeIndex;
    if (level < 0) {
      return null;
    }
    const allHeaders = root.querySelectorAll(
      `.${this.getMappedStyle('headercell')},.${this.getMappedStyle('endheadercell')}`
    );
    // if there is only one level just get the header by index in the row header
    if (totalLevels === 1) {
      relativeIndex = index - startIndex;
      return allHeaders[relativeIndex];
    }
    for (let i = 0; i < allHeaders.length; i++) {
      const headerContext = allHeaders[i][this.getResources().getMappedAttribute('context')];
      const headerIndex = headerContext.index;
      const headerExtent = headerContext.extent;
      const headerDepth = headerContext.depth;
      const headerLevel = headerContext.level;
      if (index >= headerIndex && index < headerIndex + headerExtent) {
        if (level >= headerLevel && level < headerLevel + headerDepth) {
          return allHeaders[i];
        }
      }
    }
    return null;
  };

  /**
   * Get the attribute value that we have set in our mapping attribute
   * @param {Element} element
   * @param {string} attributeKey
   * @param {boolean} parse
   * @returns {number|string}
   */
  DvtDataGrid.prototype._getAttribute = function (element, attributeKey, parse) {
    var value = element.getAttribute(this.getResources().getMappedAttribute(attributeKey));
    if (parse) {
      return parseInt(value, 10);
    }
    return value;
  };

  /**
   * Set a mapped attribute
   * @param {Element} element
   * @param {string} attributeKey
   * @param {string|number|boolean} value
   */
  DvtDataGrid.prototype._setAttribute = function (element, attributeKey, value) {
    element.setAttribute(this.getResources().getMappedAttribute(attributeKey), value); // @HTMLUpdateOK
  };

  /**
   * Build the databody, fetching cells as well
   * @return {Element} the root of databody
   */
  DvtDataGrid.prototype.buildDatabody = function (hasNoData) {
    let root = this._createDatabodyElement('databody');
    this.m_databody = root;
    const rowFreezeIndex = this.m_frozenRowIndex;
    const colFreezeIndex = this.m_frozenColIndex;

    let databodyFrozenCol;
    let databodyFrozenRow;
    let databodyFrozenCorner;
    if (this._hasFrozenColumns() && this._hasFrozenRows()) {
      databodyFrozenCorner = this._createDatabodyElement('databodyFrozenCorner');
      this.m_databodyFrozenCorner = databodyFrozenCorner;
    }
    if (this._hasFrozenColumns()) {
      databodyFrozenCol = this._createDatabodyElement('databodyFrozenCol');
      this.m_databodyFrozenCol = databodyFrozenCol;
    }
    if (this._hasFrozenRows()) {
      databodyFrozenRow = this._createDatabodyElement('databodyFrozenRow');
      this.m_databodyFrozenRow = databodyFrozenRow;
    }
    if (!hasNoData) {
      root.addEventListener('scroll', this.handleScroll.bind(this), false);

      if (!this._isHighWatermarkScrolling()) {
        var self = this;
        var scrollPosition = this.m_options.getScrollPosition();
        this._getIndexesFromScrollPosition(scrollPosition).then(function (fetchIndexes) {
          var rowIndex = fetchIndexes.row;
          var columnIndex = fetchIndexes.column;
          let colCount = null;
          let rowCount = null;

          self.m_startRow = rowIndex;
          self.m_startCol = columnIndex;

          self.m_fetching.cells = false;

          if (colFreezeIndex !== null || rowFreezeIndex !== null) {
            if (colFreezeIndex !== null) {
              colCount = self.getFetchSize('column') + columnIndex;
              columnIndex = 0;
            }
            if (rowFreezeIndex !== null) {
              rowCount = self.getFetchSize('row') + rowIndex;
              rowIndex = 0;
            }
          }
          self.fetchCells(root, rowIndex, columnIndex, rowCount, colCount);
        });
        this.m_fetching.cells = true;
      } else {
        var rowIndex = 0;
        var columnIndex = 0;
        this.fetchCells(root, rowIndex, columnIndex);
      }
    }

    let returnElems = [];
    returnElems.push(root);
    if (databodyFrozenCol) {
      returnElems.push(databodyFrozenCol);
    }
    if (databodyFrozenRow) {
      returnElems.push(databodyFrozenRow);
    }

    if (databodyFrozenCorner) {
      returnElems.push(databodyFrozenCorner);
    }
    return returnElems;
  };

  DvtDataGrid.prototype._createDatabodyElement = function (id) {
    var root = document.createElement('div');
    root.id = this.createSubId(id);
    root.className = this.getMappedStyle(id) + ' ' + this.getMappedStyle('scrollbarForce');
    // workaround for mozilla , where overflow div would make it focusable
    root.tabIndex = '-1';
    var scroller = document.createElement('div');
    scroller.className =
      this.getMappedStyle('scroller') +
      (this.m_utils.isTouchDeviceNotIOS() ? ' ' + this.getMappedStyle('scroller-mobile') : '');
    root.appendChild(scroller); // @HTMLUpdateOK
    return root;
  };

  DvtDataGrid.prototype._getIndexFromKeyPromise = function (rowKey, columnKey) {
    var self = this;
    return new Promise(function (resolve) {
      if (rowKey != null || columnKey != null) {
        self._indexes({ row: rowKey, column: columnKey }, function (indexes) {
          resolve({ rowIndexFromKey: indexes.row, columnIndexFromKey: indexes.column });
        });
      } else {
        resolve({ rowIndexFromKey: null, columnIndexFromKey: null });
      }
    });
  };

  DvtDataGrid.prototype._getIndexesFromScrollPosition = function (scrollPosition) {
    var self = this;
    var rowKey = scrollPosition.rowKey;
    var columnKey = scrollPosition.columnKey;
    var indexFromKeyPromise = this._getIndexFromKeyPromise(rowKey, columnKey);
    return indexFromKeyPromise.then(function (indexesFromKey) {
      var returnObj = {};
      if (indexesFromKey.rowIndexFromKey != null && indexesFromKey.rowIndexFromKey > 0) {
        returnObj.row = indexesFromKey.rowIndexFromKey;
      } else if (scrollPosition.rowIndex != null) {
        returnObj.row = scrollPosition.rowIndex;
      } else if (scrollPosition.y != null) {
        returnObj.row = Math.round(scrollPosition.y / self.getDefaultRowHeight());
      } else {
        returnObj.row = 0;
      }

      if (indexesFromKey.columnIndexFromKey != null && indexesFromKey.columnIndexFromKey > 0) {
        returnObj.column = indexesFromKey.columnIndexFromKey;
      } else if (scrollPosition.columnIndex != null) {
        returnObj.column = scrollPosition.columnIndex;
      } else if (scrollPosition.x != null) {
        returnObj.column = Math.round(scrollPosition.x / self.getDefaultColumnWidth());
      } else {
        returnObj.column = 0;
      }

      return returnObj;
    });
  };

  /**
   * Get the fetch count which is limited by the scollPolicyOptions max count along the axis
   * @private
   */
  DvtDataGrid.prototype.getFetchCount = function (axis, start) {
    var count = this.getFetchSize(axis);
    if (this._isHighWatermarkScrolling()) {
      var prop = axis === 'row' ? 'maxRowCount' : 'maxColumnCount';
      var maxCount = this.m_options.getScrollPolicyOptions();
      if (maxCount && maxCount[prop] != null && maxCount[prop] > 0) {
        count = Math.max(Math.min(count, maxCount[prop] - start), 0);
      }
    }
    return count;
  };

  /**
   * Fetch cells to put in the databody. Calls fetch cells on the data source,
   * setting callbacks for success and failure.
   * @param {Element} databody - the root of the databody element
   * @param {number} rowStart - the row to start fetching at
   * @param {number} colStart - the column to start fetching at
   * @param {number|null=} rowCount - the total number of rows in the data source, if undefined then calculated
   * @param {number|null=} colCount - the total number of columns in the data source, if undefined then calculated
   * @param {Object=} callbacks - specifies success and error callbacks.  If undefined then default callbacks are used
   * @protected
   */
  DvtDataGrid.prototype.fetchCells = function (
    databody,
    rowStart,
    colStart,
    rowCount,
    colCount,
    callbacks
  ) {
    var successCallback;

    // checks if we are already fetching cells
    if (this.m_fetching.cells) {
      return;
    }

    if (rowCount == null) {
      // eslint-disable-next-line no-param-reassign
      rowCount = this.getFetchCount('row', rowStart);
    }

    if (colCount == null) {
      // eslint-disable-next-line no-param-reassign
      colCount = this.getFetchCount('column', colStart);
    }

    var rowRange = {
      axis: 'row',
      start: rowStart,
      count: rowCount
    };
    var columnRange = {
      axis: 'column',
      start: colStart,
      count: colCount,
      databody: databody
    };

    this.m_fetching.cells = { rowRange: rowRange, columnRange: columnRange };

    // if there is a override success callback specified, use it, otherwise use default one
    if (callbacks != null && callbacks.success != null) {
      successCallback = callbacks.success;
    } else {
      successCallback = this.handleCellsFetchSuccess;
    }

    if (!this.isSkeletonSupport()) {
      this.showStatusText(!this.isSkeletonSupport());
    }

    // start fetch
    this._signalTaskStart();
    this.getDataSource().fetchCells(
      [rowRange, columnRange],
      {
        success: successCallback,
        error: this.handleCellsFetchError
      },
      {
        success: this,
        error: this
      }
    );
  };

  /**
   * Checks whether the response matches the current request
   * @param {Object} cellRange the cell range of the response
   * @protected
   */
  DvtDataGrid.prototype.isCellFetchResponseValid = function (cellRange) {
    if (this.m_fetching == null) {
      return false;
    }

    var responseRowRange = cellRange[0];
    var responseColumnRange = cellRange[1];
    var requestCellRanges = this.m_fetching.cells;

    // do object reference check, imagine fetching 20 2 consecutive times but
    // the data changed in bewteeen and we accidentally accept the first because
    // the counts are the same
    return (
      responseRowRange === requestCellRanges.rowRange &&
      responseColumnRange === requestCellRanges.columnRange
    );
  };

  /**
   * Returns true if this is a long scroll (or initial scroll)
   * @return {boolean} true if it is a long or initial scroll, false otherwise
   */
  DvtDataGrid.prototype.isLongScroll = function () {
    return this.m_isLongScroll;
  };

  /**
   * Checks whether the result is within the current viewport
   * @param {Object} cellSet - a CellSet object which encapsulates the result set of cells
   * @param {Array.<Object>} cellRange - [rowRange, columnRange] - [{"axis":,"start":,"count":},{"axis":,"start":,"count":,"databody":,"scroller":}]
   * @private
   */
  DvtDataGrid.prototype.isCellFetchResponseInViewport = function (cellSet, cellRange) {
    if (
      isNaN(this.m_avgRowHeight) ||
      isNaN(this.m_avgColWidth) ||
      this.m_empty != null ||
      !this.m_initialized
    ) {
      // initial scroll these are not defined so just return true, or if not inited or if no databody
      return true;
    }

    // the goal of this method is to make sure we haven't scrolled further since the last fetch
    // so our request is still valid, we run a massive risk of running loops if our logic is wrong otherwise
    // as in we continue to request the same thing but it is never valid.

    var rowRange = cellRange[0];
    var rowStart = rowRange.start;

    var columnRange = cellRange[1];
    var columnStart = columnRange.start;

    var rowReturnVal = this._getLongScrollStart(this.m_currentScrollTop, this.m_prevScrollTop, 'row');
    var columnReturnVal = this._getLongScrollStart(
      this.m_currentScrollLeft,
      this.m_prevScrollLeft,
      'column'
    );

    // return true if the viewport fits inside the fetched range
    return rowReturnVal.start === rowStart && columnReturnVal.start === columnStart;
  };

  /**
   * Handle a successful call to the data source fetchCells. Create new row and
   * cell DOM elements when necessary and then insert them into the databody.
   * @param {Object} cellSet - a CellSet object which encapsulates the result set of cells
   * @param {Array.<Object>} cellRange - [rowRange, columnRange] - [{"axis":,"start":,"count":},{"axis":,"start":,"count":,"databody":}]
   * @param {boolean=} rowInsert - if this is triggered by a row insert event
   * @protected
   */
  DvtDataGrid.prototype.handleCellsFetchSuccess = function (cellSet, cellRange, rowInsert) {
    var scrollOptions = this.m_options.getScrollPolicyOptions();
    var maxRowCount = scrollOptions ? scrollOptions.maxRowCount : null;
    var maxColumnCount = scrollOptions ? scrollOptions.maxColumnCount : null;
    var totalRowCount = this.getDataSource().getCount('row');
    var totalColumnCount = this.getDataSource().getCount('column');

    // if rowInsert is specified we can skip a couple of checks
    if (rowInsert === undefined) {
      // eslint-disable-next-line no-param-reassign
      rowInsert = false;

      // checks whether result matches what we requested
      if (!this.isCellFetchResponseValid(cellRange)) {
        // end fetch
        this._signalTaskEnd();
        // ignore result if it is not valid
        return;
      }

      // checks if the response covers the viewport or the headers were invalid
      if (
        this.isLongScroll() &&
        (!this.isCellFetchResponseInViewport(cellSet, cellRange) || this.m_headerInvalid)
      ) {
        // clear cells fetching flag
        this.m_fetching.cells = false;
        this.m_headerInvalid = false;

        // ignore the response and fetch another set for the current viewport
        this.handleLongScroll(this.m_currentScrollLeft, this.m_currentScrollTop);

        // end fetch
        this._signalTaskEnd();
        return;
      }

      this.m_isLongScroll = false;
      this.m_longScrollRow = null;
      this.m_longScrollColumn = null;
      this.m_longScrollRowPixel = null;
      this.m_longScrollColumnPixel = null;
    }

    var rowRange = cellRange[0];
    var rowStart = rowRange.start;
    var rowCount = cellSet.getCount('row');

    // for short fetch it would be equal for long fetch it would be > (bottom) or < (top)
    var rowRangeNeedsUpdate =
      rowCount > 0 && (rowStart > this.m_endRow || rowStart + rowCount <= this.m_startRow);

    let frozenRowIndex = this.m_frozenRowIndex;
    if (
      this.m_initialized &&
      this._hasFrozenRows() &&
      rowStart < frozenRowIndex &&
      this.m_rowHeaderFrozen
    ) {
      rowStart = frozenRowIndex + 1;
    }
    // if no results returned and count is unknown, flag it so we won't try to fetch again
    // OR if highwater mark scrolling is used and count is known and we have reach the last row, stop fetching
    // OR if result set is less than what's requested, then assumes we have fetched the last row
    if (
      (rowCount === 0 && this._isCountUnknown('row') && rowRange.count > 0) ||
      (rowRangeNeedsUpdate &&
        this._isHighWatermarkScrolling() &&
        !this._isCountUnknown('row') &&
        this.m_endRow + rowCount + 1 >= totalRowCount) ||
      rowCount < rowRange.count ||
      (this._isHighWatermarkScrolling() &&
        maxRowCount &&
        maxRowCount > 0 &&
        rowStart + rowCount === maxRowCount)
    ) {
      this.m_stopRowFetch = true;
    }

    var columnRange = cellRange[1];
    var columnStart = columnRange.start;
    var columnCount = cellSet.getCount('column');

    let frozenColumnIndex = this.m_frozenColIndex;
    if (
      this.m_initialized &&
      this._hasFrozenColumns() &&
      columnStart < frozenColumnIndex &&
      this.m_colHeaderFrozen
    ) {
      columnStart = frozenColumnIndex + 1;
    }
    var columnRangeNeedsUpdate =
      columnCount > 0 &&
      (columnStart > this.m_endCol || columnStart + columnCount === this.m_startCol);

    // if no results returned and count is unknown, flag it so we won't try to fetch again
    // OR if highwater mark scrolling is used and count is known and we have reach the last column, stop fetching
    // OR if result set is less than what's requested, then assumes we have fetched the last column
    if (
      (columnCount === 0 && this._isCountUnknown('column') && columnRange.count > 0) ||
      (columnRangeNeedsUpdate &&
        this._isHighWatermarkScrolling() &&
        !this._isCountUnknown('column') &&
        this.m_endCol + columnCount + 1 >= totalColumnCount) ||
      columnCount < columnRange.count ||
      (this._isHighWatermarkScrolling() &&
        maxColumnCount &&
        maxColumnCount > 0 &&
        columnStart + columnCount === maxColumnCount)
    ) {
      this.m_stopColumnFetch = true;
    }

    var databody = this.m_databody;
    if (databody == null) {
      // try to search for it in the param
      databody = columnRange.databody;
    }

    var databodyContent = databody.firstChild;
    var isAppend;
    var top;
    var left;
    var fragment;
    var addResult;
    var totalColumnWidth;
    var totalRowHeight;
    var avgWidth;
    var avgHeight;
    // if these are new rows (append or insert in the middle)
    if (rowRangeNeedsUpdate || rowInsert) {
      // whether this is adding rows to bottom (append) or top (insert)
      isAppend = !!(!rowInsert && rowStart >= this.m_startRow);

      if (isAppend) {
        top = this.m_endRowPixel;
      } else if (rowInsert) {
        var referenceCell = this._getCellByIndex({
          row: rowStart + rowCount,
          column: this.m_startCol
        });
        top = this.getElementDir(referenceCell, 'top');
      } else {
        top = this.m_startRowPixel;
      }

      left = columnStart >= this.m_startCol ? this.m_startColPixel : this.m_endColPixel;

      let colStartInit = columnStart;
      let rowStartInit = rowStart;
      let rowCountInit = rowCount;
      let colCountInit = columnCount;

      if (this.m_initialized === false) {
        if (
          this._hasFrozenRows() &&
          this._hasFrozenColumns() &&
          this.m_colHeaderFrozen !== null &&
          this.m_rowHeaderFrozen !== null
        ) {
          addResult = this._populateFrozenContainer(
            this.m_databodyFrozenCorner.firstChild,
            cellSet,
            rowStart,
            top,
            columnStart,
            left,
            frozenRowIndex + 1,
            frozenColumnIndex + 1
          );
          columnStart = frozenColumnIndex + 1;
          rowStart = frozenRowIndex + 1;
          rowCount = rowCountInit - (frozenRowIndex + 1);
          columnCount = colCountInit - (frozenColumnIndex + 1);
          // if the viewport is filled with frozen section, then update endRowPixel so that fillviewport is handled properly.
          if (columnCount === 0) {
            this.m_endRowPixel += addResult.totalRowHeight;
          }
        }
        if (this._hasFrozenRows() && this.m_rowHeaderFrozen !== null) {
          addResult = this._populateFrozenContainer(
            this.m_databodyFrozenRow.firstChild,
            cellSet,
            rowStartInit,
            top,
            columnStart,
            left,
            frozenRowIndex + 1,
            columnCount
          );
          rowCount = rowCountInit - (frozenRowIndex + 1);
          rowStart = frozenRowIndex + 1;
        }
        if (this._hasFrozenColumns() && this.m_colHeaderFrozen !== null) {
          addResult = this._populateFrozenContainer(
            this.m_databodyFrozenCol.firstChild,
            cellSet,
            rowStart,
            top,
            colStartInit,
            left,
            rowCount,
            frozenColumnIndex + 1
          );

          columnCount = colCountInit - (frozenColumnIndex + 1);
          columnStart = frozenColumnIndex + 1;
          // if the viewport is filled with frozen section, then update endRowPixel so that fillviewport is handled properly.
          if (columnCount === 0) {
            this.m_endRowPixel += addResult.totalRowHeight;
          }
        }
      } else if (
        this._hasFrozenColumns() &&
        this.m_colHeaderFrozen !== null &&
        this.m_databodyFrozenCol.firstChild.childElementCount
      ) {
        addResult = this._populateFrozenContainer(
          this.m_databodyFrozenCol.firstChild,
          cellSet,
          rowStart,
          top,
          this.m_startCol,
          left,
          rowCount,
          frozenColumnIndex + 1
        );
        columnCount = colCountInit - (frozenColumnIndex + 1);
        columnStart = frozenColumnIndex + 1;
        // if the viewport is filled with frozen section, then update endRowPixel so that fillviewport is handled properly.
        if (columnCount === 0) {
          this.m_endRowPixel += addResult.totalRowHeight;
        }
      }
      fragment = document.createDocumentFragment();
      // left shall remain as calculated previously as the databody shall be shifted by the width of the frozen section.
      addResult = this._addCellsToFragment(
        fragment,
        cellSet,
        rowStart,
        top,
        columnStart,
        left,
        rowCount,
        columnCount
      );
      totalColumnWidth = addResult.totalColumnWidth;
      totalRowHeight = addResult.totalRowHeight;
      avgWidth = addResult.avgWidth;
      avgHeight = totalRowHeight / rowCount;
      this._populateDatabody(databodyContent, fragment);

      if (isAppend) {
        // make sure there is a bottom border if adding a row to the bottom
        if (this.m_endRow !== -1 && rowCount !== 0) {
          // get the previous last row
          this._highlightCellsAlongAxis(this.m_endRow, 'row', 'index', 'remove', [
            'borderHorizontalNone'
          ]);
        }
        // update row range info if neccessary
        this.m_endRow = rowStart + (rowCount - 1);
        this.m_endRowPixel += totalRowHeight;
      } else if (rowInsert) {
        // update row range info if neccessary
        if (rowStart < this.m_startRow) {
          // added in the middle
          this.m_startRow = rowStart;
          this.m_startRowPixel = Math.max(0, this.m_startRowPixel - totalRowHeight);
        }
        // update the endRow and endRowPixel no matter where we insert
        this.m_endRow += rowCount;
        this.m_endRowPixel += totalRowHeight;
        this.pushRowsDown(rowStart + rowCount, totalRowHeight);
      } else {
        // update row range info if neccessary
        this.m_startRow -= rowCount;
        // zero maximum is handled by realigning
        this.m_startRowPixel -= totalRowHeight;
      }
    } else if (columnRangeNeedsUpdate) {
      // whether this is adding cols to right (append) or left (insert)
      isAppend = columnStart >= this.m_startCol;

      left = isAppend ? this.m_endColPixel : this.m_startColPixel;
      top = rowStart >= this.m_startRow ? this.m_startRowPixel : this.m_endRowPixel;
      // if databody doesnt have any cells, pick the left value of the last child in frozen row.
      if (
        !this.m_databody.firstChild.childElementCount &&
        isAppend &&
        this._hasFrozenRows() &&
        this.m_initialized
      ) {
        const dir = this.getResources().isRTLMode() ? 'right' : 'left';
        const lastChild = this.m_databodyFrozenRow.firstChild.lastChild;
        left = this.getElementDir(lastChild, dir) + this.getElementWidth(lastChild);
      }
      if (this._hasFrozenRows() && this.m_rowHeaderFrozen !== null) {
        this._populateFrozenContainer(
          this.m_databodyFrozenRow.firstChild,
          cellSet,
          this.m_startRow,
          top,
          columnStart,
          left,
          frozenRowIndex + 1,
          columnCount
        );
        rowCount -= frozenRowIndex + 1;
        rowStart = frozenRowIndex + 1;
      }
      fragment = document.createDocumentFragment();
      addResult = this._addCellsToFragment(
        fragment,
        cellSet,
        rowStart,
        top,
        columnStart,
        left,
        rowCount,
        columnCount
      );

      this._populateDatabody(databodyContent, fragment);
      totalColumnWidth = addResult.totalColumnWidth;
    }

    // added to only do this on initialization
    // check to see if the average width and height has change and update the canvas and the scroller accordingly
    if (avgWidth != null && (this.m_avgColWidth === 0 || this.m_avgColWidth == null)) {
      // the average column width should only be set once, it will only change when the column width varies between columns, but
      // in such case the new average column width would not be any more precise than previous one.
      this.m_avgColWidth = avgWidth;
    }

    if (avgHeight != null && (this.m_avgRowHeight === 0 || this.m_avgRowHeight == null)) {
      // the average row height should only be set once, it will only change when the row height varies between rows, but
      // in such case the new average row height would not be any more precise than previous one.
      this.m_avgRowHeight = avgHeight;
    }

    // update column range info if neccessary
    if (columnRangeNeedsUpdate) {
      // add to left or to right
      if (columnStart < this.m_startCol) {
        this.m_startCol -= columnCount;
        this.m_startColPixel -= totalColumnWidth;
      } else {
        // in virtual fetch end should always be set to last
        this.m_endCol = columnStart + (columnCount - 1);
        this.m_endColPixel += totalColumnWidth;
      }
    }

    this._sizeDatabodyScroller();

    if (this.m_endCol >= 0 && this.m_endRow >= 0) {
      this.m_hasCells = true;
    } else {
      this.m_startCol = 0;
      this.m_startRow = 0;
    }

    // if virtual scrolling we may need to adjust when the user hits the beginning
    if (this.m_startCol === 0 && this.m_startColPixel !== 0) {
      this._shiftCellsAlongAxis('column', -this.m_startColPixel, 0, true);
      this.m_endColPixel -= this.m_startColPixel;
      this.m_startColPixel = 0;
    }
    if (this.m_startRow === 0 && this.m_startRowPixel !== 0) {
      this._shiftCellsAlongAxis('row', -this.m_startRowPixel, 0, true);
      this.m_endRowPixel -= this.m_startRowPixel;
      this.m_startRowPixel = 0;
    }

    var newStartEstimate;
    if (!this.m_initialized && this.m_startCol > 0) {
      newStartEstimate = Math.round(this.m_avgColWidth * this.m_startCol);
      this._shiftCellsAlongAxis(
        'column',
        newStartEstimate - this.m_startColPixel,
        this.m_startCol,
        true
      );
      this.m_endColPixel = newStartEstimate + totalColumnWidth;
      this.m_startColPixel = newStartEstimate;
    }
    if (!this.m_initialized && this.m_startRow > 0) {
      newStartEstimate = Math.round(this.m_avgRowHeight * this.m_startRow);
      this._shiftCellsAlongAxis(
        'row',
        newStartEstimate - this.m_startRowPixel,
        this.m_startRow,
        true
      );
      this.m_endRowPixel = newStartEstimate + totalRowHeight;
      this.m_startRowPixel = newStartEstimate;
    }

    // fetch is done
    this.m_fetching.cells = false;

    // size the grid if fetch is done
    if (this.isFetchComplete()) {
      this.hideStatusText();

      if (!this.m_initialized) {
        // force bitmap (to GPU) to be generated now rather than when doing actual 3d translation to minimize
        // the delay, this should only be done once
        if (
          this.m_utils.isTouchDeviceNotIOS() &&
          Object.prototype.hasOwnProperty.call(window, 'WebKitCSSMatrix')
        ) {
          const TRANSLATE3D = 'translate3d(0, 0, 0)';
          databodyContent.style.transform = TRANSLATE3D;
          if (this.m_rowHeader != null) {
            this.m_rowHeader.firstChild.style.transform = TRANSLATE3D;
          }
          if (this.m_colHeader != null) {
            this.m_colHeader.firstChild.style.transform = TRANSLATE3D;
          }
          if (this.m_rowEndHeader != null) {
            this.m_rowEndHeader.firstChild.style.transform = TRANSLATE3D;
          }
          if (this.m_colEndHeader != null) {
            this.m_colEndHeader.firstChild.style.transform = TRANSLATE3D;
          }
        }
        this._updateScrollPosition(this.m_options.getScrollPosition());
      } else if (this._checkScroll) {
        this._checkScrollPosition();
      }

      // highlight focus cell or header if specified
      if (this.m_scrollIndexAfterFetch != null) {
        this.scrollToIndex(this.m_scrollIndexAfterFetch);
        // wait for the scroll event to be fired to avoid using cell.focus() to bring into view, the case where it's in the viewport but hasn't been scrolled to yet
      } else if (this.m_scrollHeaderAfterFetch != null) {
        // if the there is a header that needs to be scrolled to after fetch scroll to the header
        this.scrollToHeader(this.m_scrollHeaderAfterFetch);
      } else if (
        !this.isActionableMode() &&
        this._getActiveElement() != null &&
        !this.m_utils.containsCSSClassName(this._getActiveElement(), this.getMappedStyle('focus'))
      ) {
        // highliht the active cell if we are virtualized scroll and scrolled away from the active and came back
        // also on a move event insert this will preserve the active cell
        if (this.m_shouldFocus !== true) {
          this.m_shouldFocus = false;
        }
        this._highlightActive();
        this._manageMoveCursor();
      }

      // apply current selection range to newly fetched cells
      // this is more efficient than looping over ranges when rendering cell
      if (this._isSelectionEnabled()) {
        this.applySelection(rowStart, rowStart + rowCount, columnStart, columnStart + columnCount);
      }

      // update accessibility info
      this.populateAccInfo();

      // initialize/resize/fillViewport/trigger ready event
      if (this._shouldInitialize()) {
        this._handleInitialization(true);
      } else if (this.m_initialized) {
        // cases that require resize internally on fetch:
        // 1: the datagrid root node grew / resize required
        // 2: a delete triggered a fillViewport that shrunk and expanded the databody, the check that the end pixel was below the databody height then beyond it
        if (
          this.m_resizeRequired === true ||
          this.m_endRowPixel - totalRowHeight < this.getElementHeight(databody)
        ) {
          this.resizeGrid();
        }

        var cleanDirection;
        // clean up rows outside of viewport (for non high-water mark scrolling only)
        if (rowRangeNeedsUpdate) {
          if (isAppend) {
            cleanDirection = 'top';
          } else if (!rowInsert) {
            cleanDirection = 'bottom';
          }
        } else if (columnRangeNeedsUpdate) {
          // add to left or to right
          if (columnStart === this.m_startCol) {
            cleanDirection = 'right';
          } else {
            cleanDirection = 'left';
          }
        }
        this._cleanupViewport(cleanDirection);

        this.fillViewport();
        if (this.isFetchComplete()) {
          this.fireEvent('ready', {});
        }
      }
    }

    // update any row/column selections if necessary.
    if (this._isSelectionEnabled() && this.isMultipleSelection()) {
      this._resetHeaderHighLight();
    }

    // for the databody hidden indicator on vertical scroll for newly fetched cells
    let databodyIndicatorIndex = this.getActiveDatabodyIndicators();

    let hiddenIndicatorAxis;
    if (!(rowRangeNeedsUpdate && columnRangeNeedsUpdate)) {
      if (rowRangeNeedsUpdate) {
        hiddenIndicatorAxis = 'row';
      } else if (columnRangeNeedsUpdate) {
        hiddenIndicatorAxis = 'column';
      }
    }
    // applying visual indicator for default hidden items
    this.deleteAndApplyHiddenIndicators(databodyIndicatorIndex, hiddenIndicatorAxis);

    // end fetch
    this._signalTaskEnd();
    // this.dumpRanges();
  };

  /**
   * Set the Z index values before a given row index
   * @param {string} axis
   * @param {number} index
   * @param {boolean} startHeaders
   * @param {boolean} endHeaders
   */
  DvtDataGrid.prototype._setZIndexBefore = function (axis, index, startHeaders, endHeaders) {
    if (axis !== 'row') {
      return;
    }

    var start = this.m_startRow;
    var maxPixel = this.m_currentScrollTop;
    var dir = 'top';

    for (var i = index; i >= start; i--) {
      var cells = this._getAxisCellsByIndex(i, axis);
      if (this.getElementDir(cells[0], dir) < maxPixel) {
        break;
      }

      for (var j = 0; j < cells.length; j++) {
        cells[j].style.zIndex = 10;
      }

      var header;
      if (startHeaders) {
        header = this._getHeaderByIndex(i, 'row', 0);
        if (header) {
          header.style.zIndex = 10;
        }
      }

      if (endHeaders) {
        header = this._getHeaderByIndex(i, 'rowEnd', 0);
        if (header) {
          header.style.zIndex = 10;
        }
      }
    }
  };

  DvtDataGrid.prototype._onEndEvent = function (endEvents, target, handler, duration) {
    var transitionTimer;

    function listener() {
      if (transitionTimer) {
        clearTimeout(transitionTimer);
        transitionTimer = undefined;
      }
      // remove handler
      target.removeEventListener(endEvents, listener);

      handler();
    }

    // add transition end listener
    target.addEventListener(endEvents, listener);

    transitionTimer = setTimeout(listener, duration + 100);
  };

  /**
   * Insert rows with animation.
   * @param {DocumentFragment|undefined} cellsFragment
   * @param {DocumentFragment|undefined} rowHeaderFragment
   * @param {number} rowStart the starting row index
   * @private
   */
  DvtDataGrid.prototype._insertRowsWithAnimation = function (
    cellsFragment,
    rowHeaderFragment,
    rowEndHeaderFragment,
    rowStart,
    rowCount,
    totalRowHeight,
    columnStart,
    columnCount
  ) {
    var self = this;
    var i;
    var rowHeaderContent;
    var referenceRowHeader;
    var rowEndHeaderContent;
    var referenceRowEndHeader;
    var rowHeader;
    var newTop;
    var deltaY;
    var rowEndHeader;
    var insertStartPixel = 0;
    var referenceCellTop = 0;
    var referenceCellsIndex = 0;
    var referenceCells;

    // animation start
    self._signalTaskStart();
    var isAppend = rowStart > this.m_endRow;
    var databodyContent = this.m_databody.firstChild;
    var rowHeaderSupport = rowHeaderFragment != null;
    var rowEndHeaderSupport = rowEndHeaderFragment != null;

    // row to be inserted after is the reference row
    if (rowStart > 0) {
      referenceCellsIndex = rowStart - 1;
      referenceCells = this._getAxisCellsByIndex(rowStart - 1, 'row');
      referenceCellTop = this.getElementDir(referenceCells[0], 'top');
      insertStartPixel = referenceCellTop + this.getElementHeight(referenceCells[0]);
    }

    // all inherited animated rows should be hidden under previous rows in view
    this._setZIndexBefore('row', referenceCellsIndex, rowHeaderSupport, rowEndHeaderSupport);

    if (rowHeaderSupport) {
      rowHeaderContent = this.m_rowHeader.firstChild;
      referenceRowHeader = rowHeaderContent.childNodes[rowStart - this.m_startRow - 1];
    }

    if (rowEndHeaderSupport) {
      rowEndHeaderContent = this.m_rowEndHeader.firstChild;
      referenceRowEndHeader = rowEndHeaderContent.childNodes[rowStart - this.m_startRow - 1];
    }

    // loop over the fragment and assign proper top values to the fragment and then hide them
    // with transform behind the reference row
    for (i = 0; i < cellsFragment.childNodes.length; i++) {
      var cell = cellsFragment.childNodes[i];
      newTop = insertStartPixel + this.getElementDir(cell, 'top');
      deltaY = referenceCellTop - newTop - this.getElementHeight(cell);

      // move row to actual new position
      this.setElementDir(cell, newTop, 'top');

      // move row to behind reference row
      this.addTransformMoveStyle(cell, 0, 0, 'linear', 0, deltaY, 0);
    }

    if (rowHeaderSupport) {
      for (i = 0; i < rowHeaderFragment.childNodes.length; i++) {
        rowHeader = rowHeaderFragment.childNodes[i];
        newTop = insertStartPixel + this.getElementDir(rowHeader, 'top');
        deltaY = referenceCellTop - newTop - this.getElementHeight(rowHeader);
        this.setElementDir(rowHeader, newTop, 'top');
        this.addTransformMoveStyle(rowHeader, 0, 0, 'linear', 0, deltaY, 0);
      }
    }

    if (rowEndHeaderSupport) {
      for (i = 0; i < rowEndHeaderFragment.childNodes.length; i++) {
        rowEndHeader = rowEndHeaderFragment.childNodes[i];
        newTop = insertStartPixel + this.getElementDir(rowEndHeader, 'top');
        deltaY = referenceCellTop - newTop - this.getElementHeight(rowEndHeader);
        this.setElementDir(rowEndHeader, newTop, 'top');
        this.addTransformMoveStyle(rowEndHeader, 0, 0, 'linear', 0, deltaY, 0);
      }
    }

    // loop over the row after the insert point, assign new top values, but keep
    // them where they are using transforms
    for (i = rowStart; i <= this.m_endRow; i++) {
      var rowCells = this._getAxisCellsByIndex(i - this.m_startRow, 'row');
      // if (rowCells.length) {
      newTop = totalRowHeight + this.getElementDir(rowCells[0], 'top');
      // }
      deltaY = -totalRowHeight;

      for (var j = 0; j < rowCells.length; j++) {
        // move row to actual new position
        this.setElementDir(rowCells[j], newTop, 'top');

        // move row to original position
        this.addTransformMoveStyle(rowCells[j], 0, 0, 'linear', 0, deltaY, 0);
      }

      if (rowHeaderSupport) {
        rowHeader = rowHeaderContent.childNodes[i];
        this.setElementDir(rowHeader, newTop, 'top');
        this.addTransformMoveStyle(rowHeader, 0, 0, 'linear', 0, deltaY, 0);
      }
      if (rowEndHeaderSupport) {
        rowEndHeader = rowEndHeaderContent.childNodes[i];
        this.setElementDir(rowEndHeader, newTop, 'top');
        this.addTransformMoveStyle(rowEndHeader, 0, 0, 'linear', 0, deltaY, 0);
      }
    }

    this._modifyAxisCellContextIndex('row', rowStart, this.m_endRow - rowStart + 1, rowCount);

    // need to resize first in order to ensure visible region is big enough to handle new rows
    this.m_endRow += rowCount;
    this.m_endRowPixel += totalRowHeight;
    if (rowHeaderSupport) {
      this.m_endRowHeader += rowHeaderFragment.childNodes.length;
      this.m_endRowHeaderPixel += totalRowHeight;
    }
    if (rowEndHeaderSupport) {
      this.m_endRowEndHeader += rowEndHeaderFragment.childNodes.length;
      this.m_endRowEndHeaderPixel += totalRowHeight;
    }

    // find the row in which the new rows will be inserted and insert
    databodyContent.appendChild(cellsFragment); // @HTMLUpdateOK
    if (isAppend) {
      if (rowHeaderSupport) {
        rowHeaderContent.appendChild(rowHeaderFragment); // @HTMLUpdateOK
      }
      if (rowEndHeaderSupport) {
        rowEndHeaderContent.appendChild(rowEndHeaderFragment); // @HTMLUpdateOK
      }
    } else {
      if (rowHeaderSupport) {
        rowHeaderContent.insertBefore(rowHeaderFragment, referenceRowHeader.nextSibling); // @HTMLUpdateOK
      }
      if (rowEndHeaderSupport) {
        rowEndHeaderContent.insertBefore(rowEndHeaderFragment, referenceRowEndHeader.nextSibling); // @HTMLUpdateOK
      }
    }
    this.setElementHeight(databodyContent, this.getElementHeight(databodyContent) + totalRowHeight);
    this.resizeGrid();
    this.updateRowBanding();
    this._refreshDatabodyMap();

    if (this._isSelectionEnabled()) {
      this.applySelection(rowStart, rowStart + rowCount, columnStart, columnStart + columnCount);
    }

    var lastAnimatedElement = this._getCellByIndex(
      this.createIndex(rowStart + (rowCount - 1), this.m_endCol)
    );
    function transitionListener() {
      self._handleAnimationEnd();
    }

    this.m_animating = true;

    // must grab duration outside of timeout otherwise processingEventQueue flag would have been reset already
    // note we set the animation duration to 1 instead of 0 because some browsers don't invoke transition end listener if duration is 0
    var duration = self.m_processingEventQueue ? 1 : DvtDataGrid.EXPAND_ANIMATION_DURATION;

    this._onEndEvent('transitionend', lastAnimatedElement, transitionListener, duration);

    setTimeout(function () {
      var _duration = DvtDataGrid.EXPAND_ANIMATION_DURATION;
      var timing = 'ease-out';
      // add animation rules to the inserted rows
      for (var ii = rowStart; ii <= self.m_endRow; ii++) {
        var _rowCells = self._getAxisCellsByIndex(ii, 'row');
        for (var jj = 0; jj < _rowCells.length; jj++) {
          self.addTransformMoveStyle(_rowCells[jj], _duration + 'ms', 0, timing, 0, 0, 0);
        }
        if (rowHeaderSupport) {
          self.addTransformMoveStyle(
            rowHeaderContent.childNodes[ii],
            _duration + 'ms',
            0,
            timing,
            0,
            0,
            0
          );
        }
        if (rowEndHeaderSupport) {
          self.addTransformMoveStyle(
            rowEndHeaderContent.childNodes[ii],
            _duration + 'ms',
            0,
            timing,
            0,
            0,
            0
          );
        }
      }
    }, 0);
  };

  /**
   * Add cells to the fragment passed in
   * @param {DocumentFragment|undefined} fragment
   * @param {Object} cellSet
   * @param {number} rowStart the starting row index
   * @param {number} topStart the starting top value
   * @param {number} columnStart the starting column index
   * @param {number} leftStart the starting left (right) value
   * @private
   */
  DvtDataGrid.prototype._addCellsToFragment = function (
    fragment,
    cellSet,
    rowStart,
    topStart,
    columnStart,
    leftStart,
    rowCount,
    columnCount
  ) {
    var dir = this.getResources().isRTLMode() ? 'right' : 'left';

    let hiddenItemsInRange = 0;

    var renderer = this.getRendererOrTemplate('cell');
    var columnBandingInterval = this.m_options.getColumnBandingInterval();
    var rowBandingInterval = this.m_options.getRowBandingInterval();
    var horizontalGridlines = this.m_options.getHorizontalGridlines();
    var verticalGridlines = this.m_options.getVerticalGridlines();

    if (rowCount === null || rowCount === undefined) {
      // eslint-disable-next-line no-param-reassign
      rowCount = cellSet.getCount('row');
    }
    if (columnCount === null || columnCount === undefined) {
      // eslint-disable-next-line no-param-reassign
      columnCount = cellSet.getCount('column');
    }

    var rowAppend = rowStart >= this.m_startRow;
    var columnAppend = columnStart >= this.m_startCol;

    var totalWidth = 0;
    var totalHeight = 0;
    var top = topStart;

    var tempArray = [];
    var heights = [];

    for (var i = 0; i < rowCount; i += 1) {
      var left = leftStart;
      var rowIndex = rowAppend ? rowStart + i : rowStart + (rowCount - 1 - i);
      var applyRowBanding = Math.floor(rowIndex / rowBandingInterval) % 2 === 1;
      var height;
      var extents;
      var cell;
      var cellContext;

      for (var j = 0; j < columnCount; j += extents.column) {
        var width = 0;
        height = 0;
        var columnIndex = columnAppend ? columnStart + j : columnStart + (columnCount - 1 - j);
        var cellExtent;

        if (cellSet.getExtent) {
          cellExtent = cellSet.getExtent(this.createIndex(rowIndex, columnIndex));
        } else {
          cellExtent = {
            row: { extent: 1, more: { before: false, after: false } },
            column: { extent: 1, more: { before: false, after: false } }
          };
        }
        extents = { row: cellExtent.row.extent, column: cellExtent.column.extent };

        if (!columnAppend) {
          columnIndex = columnIndex - extents.column + 1;
        }
        // cannot directly modify rowIndex because outside of this loop
        var tempRowIndex = rowAppend ? rowIndex : rowIndex - extents.row + 1;

        var indexes = this.createIndex(tempRowIndex, columnIndex);

        if (tempArray[i] && tempArray[i][j]) {
          // update the left value since that cell exists already
          width = tempArray[i][j].width;
          left = columnAppend ? left + width : left - width;
        } else {
          var patched = this._patchExistingCells(cellExtent, columnIndex, tempRowIndex, tempArray);
          if (patched) {
            width = patched.width;
            // cell = patched.cell;
            // cellContext = cell[this.getResources().getMappedAttribute('context')];
          } else {
            var cellData = cellSet.getData(this.createIndex(tempRowIndex, columnIndex));
            var cellMetadata = cellSet.getMetadata(this.createIndex(tempRowIndex, columnIndex));

            cell = document.createElement('div');
            cellContext = this.createCellContext(indexes, cellData, cellMetadata, cell, extents);
            // prettier-ignore
            cell.setAttribute( // @HTMLUpdateOK
              this.getResources().getMappedAttribute('container'),
              this.getResources().widgetName
            );
            cell.setAttribute(this.getResources().getMappedAttribute('busyContext'), ''); // @HTMLUpdateOK
            this._createUniqueId(cell);
            cell[this.getResources().getMappedAttribute('context')] = cellContext;
            cell[this.getResources().getMappedAttribute('metadata')] = cellMetadata;

            const horizontalAlignment = this.m_options.getHorizontalAlignment('cell', cellContext);
            const verticalAlignment = this.m_options.getVeticalAlignment('cell', cellContext);

            // set alignment before inline stlye to ensure inline styles win
            if (horizontalAlignment !== 'auto') {
              const horizontalAlignmentStyle = this._getHorizontalAlignmentStyle(horizontalAlignment);
              cell.style.justifyContent = horizontalAlignmentStyle.justifyContent;
              cell.style.textAlign = horizontalAlignmentStyle.textAlign;
            }

            if (verticalAlignment !== 'auto') {
              cell.style.alignItems = this._getVerticalAlignmentStyle(verticalAlignment);
            }
            if (cellMetadata.metadata?.validity !== undefined) {
              let validity = cellMetadata.metadata.validity;
              if (validity === 'invalidShown') {
                let validityContainer = document.createElement('div');
                this.m_utils.addCSSClassName(
                  validityContainer,
                  this.getMappedStyle('validationError')
                );
                cell.appendChild(validityContainer);
                cell.setAttribute('aria-invalid', true);
              }
            }
            // before setting our own styles, else we will overwrite them
            var inlineStyle = this.m_options.getInlineStyle('cell', cellContext);
            if (inlineStyle != null) {
              DataCollectionUtils.applyMergedInlineStyles(cell, inlineStyle, '');
            }

            // don't want developer setting height or width through inline styles on cell
            // should be done through header styles, or through the stylesheet
            if (cell.style.height !== '') {
              cell.style.height = '';
            }
            if (cell.style.width !== '') {
              cell.style.width = '';
            }

            this.m_utils.addCSSClassName(cell, this.getMappedStyle('cell'));
            this.m_utils.addCSSClassName(cell, this.getMappedStyle('formcontrol'));

            if (
              (this._hasFrozenColumns() && columnIndex <= this.m_frozenColIndex) ||
              (this._hasFrozenRows() && tempRowIndex <= this.m_frozenRowIndex)
            ) {
              this.m_utils.addCSSClassName(cell, this.getMappedStyle('frozenCell'));
            }

            if (DataCollectionUtils.isIos()) {
              cell.setAttribute(
                'aria-labelledby',
                this.getLabelledBy(this._createActiveObject(cell), null, cell, true)
              );
              cell.setAttribute('role', 'text');
            }

            // determine if the newly fetched row should be banded
            if (applyRowBanding || Math.floor(columnIndex / columnBandingInterval) % 2 === 1) {
              this.m_utils.addCSSClassName(cell, this.getMappedStyle('banded'));
            }

            var inlineStyleClass = this.m_options.getStyleClass('cell', cellContext);
            if (inlineStyleClass != null) {
              cell.className += ' ' + inlineStyleClass;
            }

            if (this._isGridEditable()) {
              let isEditable = this.m_options.isEditable('cell', cellContext);
              if (isEditable === 'disable') {
                this._setAttribute(cell, 'readOnly', true);
                this.m_utils.addCSSClassName(cell, this.getMappedStyle('readOnly'));
              }
            }

            // get the row height
            var k;
            for (k = 0; k < extents.row; k++) {
              var rowKey =
                k === 0
                  ? cellContext.keys.row
                  : this._getKey(this._getHeaderByIndex(tempRowIndex + k, 'row', 0), 'row');
              heights[i + k] = this._getCellDimension(
                cell,
                tempRowIndex + k,
                rowKey,
                'row',
                'height'
              );
              if (this.isHidden('row', tempRowIndex)) {
                heights[i + k] = 0;
                cell.style.display = 'none';
              }
              height += heights[i + k];
            }

            // set the px height on the cell
            this.setElementHeight(cell, height);

            for (k = 0; k < extents.column; k++) {
              var columnKey =
                k === 0
                  ? cellContext.keys.column
                  : this._getKey(this._getHeaderByIndex(columnIndex + k, 'column', 0), 'column');
              width += this._getCellDimension(cell, columnIndex, columnKey, 'column', 'width');
            }

            if (this.isHidden('column', columnIndex)) {
              width = 0;
              cell.style.display = 'none';
              hiddenItemsInRange += 1;
            }

            // set the px width on the cell regardless of unit type currently on it
            this.setElementWidth(cell, width);

            // do not put borders on far edge column, edge row, turn off gridlines
            if (
              !cell.classList.contains(this.getMappedStyle('frozenCell')) &&
              (verticalGridlines === 'hidden' ||
                (this._isLastColumn(columnIndex + (extents.column - 1)) &&
                  (this.getRowHeaderWidth() + left + width >= this.getWidth() ||
                    this.m_endRowEndHeader !== -1)))
            ) {
              this.m_utils.addCSSClassName(cell, this.getMappedStyle('borderVerticalNone'));
            }

            if (horizontalGridlines === 'hidden') {
              this.m_utils.addCSSClassName(cell, this.getMappedStyle('borderHorizontalNone'));
            } else if (this._isLastRow(tempRowIndex + (extents.row - 1))) {
              if (
                (this.getRowBottom(cell, top + height) >= this.getHeight() ||
                  this.m_endColEndHeader !== -1) &&
                !cell.classList.contains(this.getMappedStyle('frozenCell'))
              ) {
                this.m_utils.addCSSClassName(cell, this.getMappedStyle('borderHorizontalNone'));
              }
            }

            if (rowAppend) {
              this.setElementDir(cell, top, 'top');
            } else {
              this.setElementDir(cell, top - height, 'top');
            }

            if (columnAppend) {
              this.setElementDir(cell, left, dir);
            } else {
              this.setElementDir(cell, left - width, dir);
            }

            if (this.m_isCustomElementCallback()) {
              // add cell to live DOM while rendering, row is now in live DOM so do this first
              this.m_root.appendChild(cell); // @HTMLUpdateOK
            }

            this._renderContent(
              renderer,
              cellContext,
              cell,
              cellData,
              this.buildCellTemplateContext(cellContext, cellMetadata)
            );

            fragment.appendChild(cell);
          }

          // store the extents that were rendered with this
          this._updateTempArray(tempArray, { width: width }, i, j, extents.row, extents.column);

          left = columnAppend ? left + width : left - width;

          if (i === 0) {
            totalWidth += width;
          }
        }
      }

      height = heights[i];

      top = rowAppend ? top + height : top - height;
      totalHeight += height;
    }

    totalHeight = heights.reduce(function (total, num) {
      return total + num;
    }, 0);
    var avgWidth = totalWidth / (columnCount - hiddenItemsInRange);
    return { avgWidth: avgWidth, totalRowHeight: totalHeight, totalColumnWidth: totalWidth };
  };

  /**
   * Change the appropriate cell dimension as patching occurs
   * @param {number} axisExtent
   * @param {number} otherAxisExtent
   * @param {number} columnIndex
   * @param {number} rowIndex
   * @param {Array} tempArray
   * @param {string} axis
   * @param {string} dimension
   * @param {boolean} isBefore
   * @private
   */
  DvtDataGrid.prototype._updateCellDimension = function (
    axisExtent,
    otherAxisExtent,
    columnIndex,
    rowIndex,
    tempArray,
    axis,
    dimension,
    isBefore
  ) {
    var dimensionDelta = 0;
    var otherDimension = dimension === 'width' ? 'height' : 'width';

    var cell = this._getCellByIndex(this.createIndex(rowIndex, columnIndex));
    var cellDimension = this.getElementDir(cell, dimension);
    var cellContext = cell[this.getResources().getMappedAttribute('context')];
    cellContext.extents[axis] += axisExtent;

    var axisIndex;

    if (axis === 'row') {
      axisIndex = rowIndex;
    } else if (axis === 'column') {
      axisIndex = columnIndex;
    }

    for (var k = 1; k <= axisExtent; k++) {
      var key = this._getKey(
        this._getHeaderByIndex(isBefore ? axisIndex - k : axisIndex + k, axis, 0),
        axis
      );
      dimensionDelta += this._getCellDimension(
        cell,
        isBefore ? axisIndex - k : axisIndex + k,
        key,
        axis,
        dimension
      );
      for (var j = 0; j < otherAxisExtent; j++) {
        var addRowIndex;
        var addColumnIndex;

        if (axis === 'row') {
          addRowIndex = isBefore ? rowIndex - k : rowIndex + k;
          addColumnIndex = columnIndex + j;
        } else {
          addRowIndex = rowIndex + j;
          addColumnIndex = isBefore ? columnIndex - k : columnIndex + k;
        }
        this._addIndexToDatabodyMap(this.createIndex(addRowIndex, addColumnIndex), cell.id);
      }
    }

    if (isBefore) {
      var dir;
      if (dimension === 'width') {
        if (this.getResources().isRTLMode()) {
          dir = 'right';
        } else {
          dir = 'left';
        }
      } else {
        dir = 'top';
      }

      this.setElementDir(cell, this.getElementDir(cell, dir) - dimensionDelta, dir);
      cellContext.indexes[axis] -= axisExtent;
    }

    this.setElementDir(cell, cellDimension + dimensionDelta, dimension);

    var returnObj = {};
    returnObj[dimension] = dimensionDelta;
    returnObj[otherDimension] = this.getElementDir(cell, otherDimension);
    returnObj.cell = cell;
    return returnObj;
  };

  /**
   * Patch cells as more data is fetched
   * @param {Object} cellExtent
   * @param {number} columnIndex
   * @param {number} rowIndex
   * @param {Array} tempArray
   * @private
   */
  DvtDataGrid.prototype._patchExistingCells = function (
    cellExtent,
    columnIndex,
    rowIndex,
    tempArray
  ) {
    var columnExtent = cellExtent.column.extent;
    var rowExtent = cellExtent.row.extent;

    var patchRowBefore = cellExtent.row.more.before;
    var patchRowAfter = cellExtent.row.more.after;
    var patchColumnBefore = cellExtent.column.more.before;
    var patchColumnAfter = cellExtent.column.more.after;

    if (columnIndex - 1 === this.m_endCol && patchColumnBefore) {
      return this._updateCellDimension(
        columnExtent,
        rowExtent,
        this.m_endCol,
        rowIndex,
        tempArray,
        'column',
        'width',
        false
      );
    } else if (rowIndex - 1 === this.m_endRow && patchRowBefore) {
      return this._updateCellDimension(
        rowExtent,
        columnExtent,
        columnIndex,
        this.m_endRow,
        tempArray,
        'row',
        'height',
        false
      );
    } else if (columnIndex + columnExtent === this.m_startCol && patchColumnAfter) {
      return this._updateCellDimension(
        columnExtent,
        rowExtent,
        this.m_startCol,
        rowIndex,
        tempArray,
        'column',
        'width',
        true
      );
    } else if (rowIndex + rowExtent === this.m_startRow && patchRowAfter) {
      return this._updateCellDimension(
        rowExtent,
        columnExtent,
        columnIndex,
        this.m_startRow,
        tempArray,
        'row',
        'height',
        true
      );
    }

    return false;
  };

  /**
   * Fill spots in the temporary array with the tempObj
   * @param {Array} tempArray
   * @param {any} tempObj
   * @param {number} i
   * @param {number} j
   * @param {number} iExtent
   * @param {number} jExtent
   * @private
   */
  DvtDataGrid.prototype._updateTempArray = function (tempArray, tempObj, i, j, iExtent, jExtent) {
    // store the extents that were rendered with this
    for (var k = 0; k < iExtent; k++) {
      if (tempArray[i + k] == null) {
        // eslint-disable-next-line no-param-reassign
        tempArray[i + k] = [];
      }
      for (var l = 0; l < jExtent; l++) {
        // eslint-disable-next-line no-param-reassign
        tempArray[i + k][j + l] = tempObj;
      }
    }
  };

  /**
   * Get a cells dimension
   * @param {Element} cell
   * @param {number} index
   * @param {string|null} key
   * @param {string} axis
   * @param {string} dimension
   * @private
   */
  DvtDataGrid.prototype._getCellDimension = function (cell, index, key, axis, dimension) {
    var headerClassName;
    var endHeader;
    var dimensionOf;

    if (axis === 'row') {
      headerClassName =
        this.getMappedStyle('rowheadercell') + ' ' + this.getMappedStyle('headercell');
      endHeader = this.m_endRowHeader;
    } else if (axis === 'column') {
      headerClassName =
        this.getMappedStyle('colheadercell') + ' ' + this.getMappedStyle('headercell');
      endHeader = this.m_endColHeader;
    }

    // use a shim element so that we don't have to manage class name ordering
    // in the case of no headers this gets called everytime, so added firstPass to make sure it's only the first time
    // initialized doesn't matter because of scroll behavior
    if (endHeader === -1) {
      var shimHeaderContext = this.createHeaderContext(
        axis,
        index,
        null,
        { key: key },
        null,
        0,
        0,
        1
      );
      var inlineStyle = this.m_options.getInlineStyle(axis, shimHeaderContext);
      var styleClass = this.m_options.getStyleClass(axis, shimHeaderContext);
      dimensionOf = document.createElement('div');
      if (inlineStyle != null) {
        DataCollectionUtils.applyMergedInlineStyles(dimensionOf, inlineStyle, '');
      }
      dimensionOf.className = headerClassName + ' ' + styleClass;
    } else {
      dimensionOf = cell;
    }

    return this._getHeaderDimension(dimensionOf, key, axis, dimension);
  };

  /**
   * Get a label dimension
   * @private
   */
  DvtDataGrid.prototype._getLabelDimension = function (axis, level) {
    let dimensions;
    let dimension;
    let start;
    if (axis === 'column') {
      dimensions = this.m_columnHeaderLevelHeights;
      dimension = 'height';
      start = this.m_startColHeader;
    } else if (axis === 'columnEnd') {
      dimensions = this.m_columnEndHeaderLevelHeights;
      dimension = 'height';
      start = this.m_startColEndHeader;
    } else if (axis === 'row') {
      dimensions = this.m_rowHeaderLevelWidths;
      dimension = 'width';
      start = this.m_startRowHeader;
    } else {
      dimensions = this.m_rowEndHeaderLevelWidths;
      dimension = 'width';
      start = this.m_startRowEndHeader;
    }

    let value = dimensions[level];
    if (value != null) {
      return value;
    }

    // could not find a value which means the level has not yet been rendered by a header with depth 1
    // so we find a header that is at that level and we know that it at least covers that level
    // we subtract all of the known level dimensions from that headers dimension and then divide the
    // remaining space up evenly, the alternative is to use a shim header and render it to get its width
    // but that requires the application to define every header dimension for each level?
    const header = this._getHeaderByIndex(start, axis, level);
    const context = header[this.getResources().getMappedAttribute('context')];
    const headerLevel = context.level;
    const headerDepth = context.depth;
    const headerValue = this.getElementDir(header, dimension);
    let dimSum = 0;
    let missingDimension = 0;
    for (let i = headerLevel; i < headerLevel + headerDepth; i++) {
      let dimVal = dimensions[i];
      if (dimVal != null) {
        dimSum += dimVal;
      } else {
        missingDimension += 1;
      }
    }
    // should never happen
    if (missingDimension === 0) {
      return headerValue;
    }

    // ensure non negative for safety
    value = Math.max(0, Math.round((headerValue - dimSum) / missingDimension));
    dimensions[level] = value;
    return value;
  };

  /**
   * Adjusts everything in the grid pushing cells and headers based on indexes/dimensions to remove
   * @private
   */
  DvtDataGrid.prototype._modifyAndPushCells = function (
    indexes,
    dimensions,
    axis,
    databody,
    headerRoot,
    endHeaderRoot,
    isAdd,
    frozenIndexChange
  ) {
    let ltr = this.getResources().isRTLMode() ? 'right' : 'left';
    let dir = axis === 'row' ? 'top' : ltr;
    let contextString = this.getResources().getMappedAttribute('context');
    let modifier = isAdd ? 1 : -1;

    let makeAdjustments = function (items, getIndex, setter) {
      items.forEach((item) => {
        let index = getIndex(item);
        let indexChange = 0;
        if (isAdd) {
          if (index >= indexes[0]) {
            indexChange = indexes.length;
          }
        } else {
          for (indexChange; indexChange < indexes.length; indexChange++) {
            if (indexes[indexChange] >= index) {
              break;
            }
          }
        }
        if (indexes.length === 0 && frozenIndexChange > 0) {
          indexChange += frozenIndexChange;
        }
        if (indexChange > 0) {
          let dimensionChange = dimensions.length
            ? dimensions
                .slice(0, indexChange)
                .reduce((accumulator, currentValue) => accumulator + currentValue)
            : 0;
          dimensionChange *= modifier;
          indexChange *= modifier;
          if (frozenIndexChange && indexes.length) {
            indexChange += frozenIndexChange * modifier;
          }
          setter(item, dimensionChange, indexChange, index);
        }
      });
    };

    let cells = databody.firstChild.querySelectorAll('.' + this.getMappedStyle('cell'));
    makeAdjustments(
      cells,
      (item) => item[contextString].indexes[axis],
      (item, dimensionChange, indexChange) => {
        if (dimensionChange !== 0) {
          let newDimension = this.getElementDir(item, dir) + dimensionChange;
          this.setElementDir(item, newDimension, dir);
        }
        // eslint-disable-next-line no-param-reassign
        item[contextString].indexes[axis] += indexChange;
      }
    );

    if (headerRoot) {
      let headers = headerRoot.querySelectorAll('.' + this.getMappedStyle('headercell'));
      makeAdjustments(
        headers,
        (item) => item[contextString].index,
        (item, dimensionChange, indexChange) => {
          if (dimensionChange !== 0) {
            let newDimension = this.getElementDir(item, dir) + dimensionChange;
            this.setElementDir(item, newDimension, dir);
          }
          // eslint-disable-next-line no-param-reassign
          item[contextString].index += indexChange;
        }
      );

      let groupings = headerRoot.querySelectorAll('.' + this.getMappedStyle('groupingcontainer'));
      makeAdjustments(
        groupings,
        (item) => this._getAttribute(item, 'start', true),
        (item, dimensionChange, indexChange, index) => {
          this._setAttribute(item, 'start', index + indexChange);
        }
      );
    }

    if (endHeaderRoot) {
      let endheaders = endHeaderRoot.querySelectorAll('.' + this.getMappedStyle('endheadercell'));
      makeAdjustments(
        endheaders,
        (item) => item[contextString].index,
        (item, dimensionChange, indexChange) => {
          if (dimensionChange !== 0) {
            let newDimension = this.getElementDir(item, dir) + dimensionChange;
            this.setElementDir(item, newDimension, dir);
          }
          // eslint-disable-next-line no-param-reassign
          item[contextString].index += indexChange;
        }
      );

      let endGroupings = endHeaderRoot.querySelectorAll(
        '.' + this.getMappedStyle('groupingcontainer')
      );
      makeAdjustments(
        endGroupings,
        (item) => this._getAttribute(item, 'start', true),
        (item, dimensionChange, indexChange, index) => {
          this._setAttribute(item, 'start', index + indexChange);
        }
      );
    }
  };

  /**
   * Push the row and all of its next siblings down.
   * @param {number} rowIndex the starting row to push down.
   * @param {number} adjustment the amount in pixel to push down.
   * @private
   */
  DvtDataGrid.prototype.pushRowsDown = function (rowIndex, adjustment) {
    while (rowIndex <= this.m_endRow) {
      var cells = this._getAxisCellsByIndex(rowIndex, 'row');
      if (cells.length > 0) {
        for (var i = 0; i < cells.length; i++) {
          var cell = cells[i];
          var top = this.getElementDir(cell, 'top') + adjustment;
          cell.style.top = top + 'px';
        }
      }
      // eslint-disable-next-line no-param-reassign
      rowIndex += 1;
    }
  };

  /**
   * Push the row header and all of its next siblings up.
   * @param {number} rowIndex the starting row to push up.
   * @param {number} adjustment the amount in pixel to push up.
   * @private
   */
  DvtDataGrid.prototype.pushRowsUp = function (rowIndex, adjustment) {
    this.pushRowsDown(rowIndex, -adjustment);
  };

  /**
   * Push the row header and all of its next siblings down.
   * @param {Element} rowHeader the starting rowHeader to push down.
   * @param {number} adjustment the amount in pixel to push down.
   * @private
   */
  DvtDataGrid.prototype.pushRowHeadersDown = function (rowHeader, adjustment) {
    while (rowHeader) {
      var top = this.getElementDir(rowHeader, 'top') + adjustment;
      // eslint-disable-next-line no-param-reassign
      rowHeader.style.top = top + 'px';
      // eslint-disable-next-line no-param-reassign
      rowHeader = rowHeader.nextSibling;
    }
  };

  /**
   * Push the row and all of its next siblings up.
   * @param {Element} rowHeader the starting rowHeader to push up.
   * @param {number} adjustment the amount in pixel to push up.
   * @private
   */
  DvtDataGrid.prototype.pushRowHeadersUp = function (rowHeader, adjustment) {
    this.pushRowHeadersDown(rowHeader, -adjustment);
  };

  /**
   * Build a cell context object for a cell and return it
   * @param {Object} indexes - the row and column index of the cell
   * @param {Object} data - the data the cell contains
   * @param {Object} metadata - the metadata the cell contains
   * @param {Element} elem - the cell element
   * @return {Object} the cell context object, keys of {indexes,data,keys,datagrid}
   */
  DvtDataGrid.prototype.createCellContext = function (indexes, data, metadata, elem, extents) {
    // set the parent to the cell content div
    var cellContext = {
      parentElement: elem,
      indexes: indexes,
      cell: data
    };
    if (this._isDataGridProvider()) {
      cellContext.data = data;
    } else {
      cellContext.data =
        data != null && typeof data === 'object' && Object.prototype.hasOwnProperty.call(data, 'data')
          ? data.data
          : data;
    }
    cellContext.component = this;
    cellContext.datasource = this.m_options.getProperty('data');
    cellContext.mode = 'navigation';
    cellContext.extents = extents;

    // merge properties from metadata into cell context
    // the properties in metadata would have precedence
    var props = Object.keys(metadata);
    for (var i = 0; i < props.length; i++) {
      var prop = props[i];
      cellContext[prop] = metadata[prop];
    }

    // invoke callback to allow ojDataGrid to change datagrid reference
    if (this.m_createContextCallback != null) {
      this.m_createContextCallback.call(this, cellContext);
    }

    return this.m_fixContextCallback.call(this, cellContext);
  };

  /**
   * Creates a unique ID
   * @private
   */
  DvtDataGrid.prototype._createUniqueId = function (cell) {
    return this._uniqueIdCallback(cell, false);
  };

  /**
   * Gets the width of the row header
   * @return {number} the width of the row header in pixel.
   * @protected
   */
  DvtDataGrid.prototype.getRowHeaderWidth = function () {
    if (this.m_rowHeaderWidth === null) {
      // check if there's no row header
      return 0;
    }
    return this.m_rowHeaderWidth;
  };

  /**
   * Gets the height of the column header
   * @return {number} the height of the column header in pixel.
   * @protected
   */
  DvtDataGrid.prototype.getColumnHeaderHeight = function () {
    if (this.m_colHeaderHeight === null) {
      // check if there's no column header
      return 0;
    }
    return this.m_colHeaderHeight;
  };

  /**
   * Gets the width of the row end header
   * @return {number} the width of the row end header in pixel.
   * @protected
   */
  DvtDataGrid.prototype.getRowEndHeaderWidth = function () {
    if (this.m_endRowEndHeader === -1) {
      // check if there's no row header
      return 0;
    }
    return this.m_rowEndHeaderWidth;
  };

  /**
   * Gets the height of the column end header
   * @return {number} the height of the column end header in pixel.
   * @protected
   */
  DvtDataGrid.prototype.getColumnEndHeaderHeight = function () {
    if (this.m_endColEndHeader === -1) {
      // check if there's no column header
      return 0;
    }
    return this.m_colEndHeaderHeight;
  };

  /**
   * Gets the bottom value relative to the datagrid in pixel.
   * @param {Element} row the row element
   * @param {number|undefined|null} bottom the bottom value in pixel relative to the databody
   * @return {number} the bottom value relative to the datagrid in pixels.
   * @private
   */
  DvtDataGrid.prototype.getRowBottom = function (row, bottom) {
    // gets the height of the column header, if any
    var colHeaderHeight = this.getColumnHeaderHeight();
    // if a bottom value is specified use that
    if (bottom != null) {
      return colHeaderHeight + bottom;
    }

    // otherwise try find it from the row element
    var top = this.getElementDir(row, 'top');
    var height = this.calculateRowHeight(row);
    if (!isNaN(top) && !isNaN(height)) {
      return colHeaderHeight + top + height;
    }

    return colHeaderHeight;
  };

  /**
   * Handle an unsuccessful call to the data source fetchCells
   * @param {Error} errorStatus - the error returned from the data source
   * @param {Array.<Object>} cellRange - [rowRange, columnRange] - [{"axis":,"start":,"count":},{"axis":,"start":,"count":,"databody":,"scroller":}]
   */
  DvtDataGrid.prototype.handleCellsFetchError = function (errorStatus, cellRange) {
    // remove fetch message
    this.m_fetching.cells = false;

    // hide status message
    this.hideStatusText();

    // update datagrid in responds to failed fetch
    if (this.m_databody.firstChild == null || !this.m_initialized) {
      // if it's initial fetch, then show no data
      if (this._shouldInitialize()) {
        this._handleInitialization(false);
      }
    } else {
      // failed while fetching more data.  stop any future fetching
      var rowRange = cellRange[0];
      var columnRange = cellRange[1];

      if (columnRange.start + (columnRange.count - 1) > this.m_endCol) {
        this.m_stopColumnFetch = true;
        // stop header fetch as well
        this.m_stopColumnHeaderFetch = true;
        this.m_stopColumnEndHeaderFetch = true;
      }

      if (rowRange.start + (rowRange.count - 1) > this.m_endRow) {
        this.m_stopRowFetch = true;
        // stop header fetch as well
        this.m_stopRowHeaderFetch = true;
        this.m_stopRowEndHeaderFetch = true;
      }
    }

    // end fetch
    this._signalTaskEnd();
  };

  /** ******************* focusable/editable element related methods *****************/

  DvtDataGrid.prototype._isFocusableElementBeforeCell = function (elem) {
    // if element is null or if we reach the root of DataGrid or if it is the cell
    if (
      elem == null ||
      elem === this.getRootElement() ||
      this.m_utils.containsCSSClassName(elem, this.getMappedStyle('cell'))
    ) {
      return false;
    }

    var tagName = elem.tagName;
    if (
      tagName === 'INPUT' ||
      tagName === 'TEXTAREA' ||
      tagName === 'SELECT' ||
      tagName === 'BUTTON' ||
      tagName === 'A' ||
      this.m_utils.containsCSSClassName(elem, this.getMappedStyle('active')) ||
      (elem.getAttribute('tabIndex') != null &&
        parseInt(elem.getAttribute('tabIndex'), 10) >= 0 &&
        this.findCell(elem) !== elem)
    ) {
      return true;
    }
    return this._isFocusableElementBeforeCell(elem.parentNode);
  };

  /**
   * Enables all focusable elements contained by the element, and sets focus to the first
   * @param {Element} elem
   * @param {boolean=} shouldSelect - should try to select content of first focusable element
   * @return {boolean} true if focus is set successfully, false otherwise
   */
  DvtDataGrid.prototype._setFocusToFirstFocusableElement = function (elem, event, shouldSelect) {
    // enable all focusable elements
    DataCollectionUtils.enableAllFocusableElements(elem);
    var elems = DataCollectionUtils.getFocusableElementsInNode(elem);
    if (elems.length > 0) {
      var firstElement = elems[0];
      firstElement.focus();
      if (event) {
        event.preventDefault();
      }
      if (firstElement.setSelectionRange && firstElement.value) {
        try {
          // ensure focus at the end
          firstElement.setSelectionRange(firstElement.value.length, firstElement.value.length);
        } catch (e) {
          // invalid state error
        }
      }
      if (shouldSelect === true && typeof elems[0].select === 'function') {
        firstElement.select();
      }
      return true;
    }

    return false;
  };

  /** ************************************ scrolling/virtualization ************************************/

  /**
   * Handle a scroll event calling scrollTo
   * @param {Event} event - the scroll event triggering the method
   */
  DvtDataGrid.prototype.handleScroll = function (event) {
    this._clearScrollPositionTimeout();

    // Adding to address firefox async scrolling and pixel perfect scroll bar issues:
    // If the datagrid doesn't need scrolling, ff will skip the async scroll event
    // If the handleScroll is called properly, it'll set the databody attribute as usual
    // Flag added here and resizeGrid setTimeout function so that either will execute, but only once.
    if (!this.m_handleScrollOverflow) {
      if (!this.m_hasVerticalScroller && !this.m_hasHorizontalScroller) {
        this.m_databody.style.overflow = 'hidden';
      }
      this.m_handleScrollOverflow = true;
    }

    // prevent scrolling when animating sort
    if (this.m_animating) {
      event.preventDefault();
      return;
    }

    // scroll on touch is handled directly by touch handlers
    if (this.m_utils.isTouchDeviceNotIOS()) {
      return;
    }

    if (this.m_silentScroll === true) {
      this.m_silentScroll = false;
      return;
    }

    var scroller = event.target;
    var scrollLeft = this.m_utils.getElementScrollLeft(scroller);
    var scrollTop = scroller.scrollTop;

    this.scrollTo(scrollLeft, scrollTop);
  };

  /**
   * Retrieve the maximum scrollable width.
   * @return {number} the maximum scrollable width.  Returns MAX_VALUE
   *         if canvas size is unknown.
   * @private
   */
  DvtDataGrid.prototype._getMaxScrollWidth = function () {
    if (this._isCountUnknownOrHighwatermark('column') && !this.m_stopColumnFetch) {
      return Number.MAX_VALUE;
    }
    return this.m_scrollWidth;
  };

  /**
   * Retrieve the maximum scrollable height.
   * @return {number} the maximum scrollable width.  Returns MAX_VALUE
   *         if canvas size is unknown.
   * @private
   */
  DvtDataGrid.prototype._getMaxScrollHeight = function () {
    if (this._isCountUnknownOrHighwatermark('row') && !this.m_stopRowFetch) {
      return Number.MAX_VALUE;
    }
    return this.m_scrollHeight;
  };

  /**
   * Handle a programtic scroll
   * @param {Object} options an object containing the scrollTo information
   * @param {Object} options.position scroll to an x,y location which is relative to the origin of the grid
   * @param {Object} options.position.scrollX the x position of the scrollable region, this should always be positive
   * @param {Object} options.position.scrollY the Y position of the scrollable region, this should always be positive
   *
   */
  DvtDataGrid.prototype.scroll = function (options) {
    if (options.position != null) {
      var scrollPosObj = {};
      scrollPosObj.x = Math.max(0, Math.min(this.m_scrollWidth, options.position.scrollX));
      scrollPosObj.y = Math.max(0, Math.min(this.m_scrollHeight, options.position.scrollY));
      this._scrollToScrollPositionObject(scrollPosObj);
    }
  };

  /**
   * Used by mouse wheel and touch scrolling to set the scroll position,
   * since the deltas are obtained instead of new scroll position.
   * @param {number} deltaX - the change in X position
   * @param {number} deltaY - the change in Y position
   */
  DvtDataGrid.prototype.scrollDelta = function (deltaX, deltaY) {
    // Make sure to adjust the scroller size in case the scroller is no longer the same size.
    this._adjustScrollerSize();

    var scrollLeft = Math.max(
      0,
      Math.min(this._getMaxScrollWidth(), this.m_currentScrollLeft - deltaX)
    );
    var scrollTop = Math.max(
      0,
      Math.min(this._getMaxScrollHeight(), this.m_currentScrollTop - deltaY)
    );
    this._initiateScroll(scrollLeft, scrollTop);
  };

  /**
   * Used by touch scrolling to adjust the scroll position to prevent diagonal scrolling,
   * since the deltas are obtained instead of new scroll position.
   * @param {number} diffX - the change in X position
   * @param {number} diffY - the change in Y position
   * @returns {Array} adjusted diffX, diffY
   */
  DvtDataGrid.prototype.adjustTouchScroll = function (diffX, diffY) {
    // prevent 'diagonal' scrolling
    if (this.m_utils.isTouchDevice()) {
      if (diffX !== 0 && diffY !== 0) {
        // direction depends on which way moves the most
        if (Math.abs(diffX) > Math.abs(diffY)) {
          // eslint-disable-next-line no-param-reassign
          diffY = 0;
          this.m_extraScrollOverY = null;
        } else {
          // eslint-disable-next-line no-param-reassign
          diffX = 0;
          this.m_extraScrollOverX = null;
        }
      }
    }

    return [diffX, diffY];
  };

  /**
   * Initiate a scroll, this will differentiate between scrolling on touch vs desktop
   * @param {number} scrollLeft
   * @param {number} scrollTop
   */
  DvtDataGrid.prototype._initiateScroll = function (scrollLeft, scrollTop) {
    if (!this.m_utils.isTouchDeviceNotIOS()) {
      this.m_utils.setElementScrollLeft(this.m_databody, scrollLeft);
      this.m_databody.scrollTop = scrollTop;
      // scroll to be enabled, if all regions within the grid are frozen and scroll is initiated.
      if (
        !this.m_databody.firstChild.childElementCount &&
        (this._hasFrozenColumns() || this._hasFrozenRows())
      ) {
        this.scrollTo(scrollLeft, scrollTop);
      }
    } else {
      // for touch we'll call scrollTo directly instead of relying on scroll event to fire due to performance
      // or if the scroll position of the databody was already set properly from mousewheel etc, then just sync everything up
      // in scrollTo
      this.scrollTo(scrollLeft, scrollTop);
    }
  };

  /**
   * Initiate a scroll on attached call with current scroll values
   */
  DvtDataGrid.prototype._initiateScrollOnAttached = function () {
    this._initiateScroll(this.m_currentScrollLeft, this.m_currentScrollTop);
  };

  /**
   * Disable touch scroll animation by setting durations to 0
   * @private
   */
  DvtDataGrid.prototype._disableTouchScrollAnimation = function () {
    this.m_databody.firstChild.style.transitionDuration = '0ms';
    this.m_rowHeader.firstChild.style.transitionDuration = '0ms';
    this.m_colHeader.firstChild.style.transitionDuration = '0ms';
    this.m_rowEndHeader.firstChild.style.transitionDuration = '0ms';
    this.m_colEndHeader.firstChild.style.transitionDuration = '0ms';
  };

  /**
   * Should the datagrid long scroll using appropriate params if no databody but headers.
   * @param {number} scrollLeft - the position the scroller left should be
   * @param {number} scrollTop - the position the scroller top should be
   * @returns {boolean} true if long scroll should init
   */
  DvtDataGrid.prototype._shouldLongScroll = function (scrollLeft, scrollTop) {
    // only long scroll if virtual scrolling
    if (this._isHighWatermarkScrolling()) {
      return false;
    }

    return (
      scrollLeft + this.getViewportWidth() < this._getMaxLeftPixel() ||
      scrollTop + this.getViewportHeight() < this._getMaxTopPixel() ||
      scrollLeft > this._getMaxRightPixel() ||
      scrollTop > this._getMaxBottomPixel()
    );
  };

  /**
   * Set the scroller position, using translate3d when permitted
   * @param {number} scrollLeft - the position the scroller left should be
   * @param {number} scrollTop - the position the scroller top should be
   */
  DvtDataGrid.prototype.scrollTo = function (scrollLeft, scrollTop) {
    this.m_prevScrollLeft = this.m_currentScrollLeft;
    this.m_currentScrollLeft = scrollLeft;
    this.m_prevScrollTop = this.m_currentScrollTop;
    this.m_currentScrollTop = scrollTop;

    // checkSCroll and isFetchComplete below handle the fact that the fetchCells can return sync or async
    // and we want the last time it happens to actually update the value.
    this._checkScroll = false;

    // check if this is a long scroll
    // don't do this for touch, the check must be done AFTER transition ends otherwise
    // animation will become sluggish, see _syncScroller
    if (!this.m_utils.isTouchDeviceNotIOS()) {
      if (this._shouldLongScroll(scrollLeft, scrollTop)) {
        this.handleLongScroll(scrollLeft, scrollTop);
      } else {
        this.fillViewport();
      }
      this._checkScroll = true;
    }

    // update header and databody scroll position
    this._syncScroller();

    // check if we need to adjust scroller dimension
    this._adjustScrollerSize();

    // check if there's a cell to focus
    if (this.m_cellToFocus != null) {
      var cell = this.m_cellToFocus;
      this.m_cellToFocus = null;
      this._setActive(cell, this._createActiveObject(cell), null, false, false, true);
    }

    // if there's an index we wanted to sctoll to after fetch it has now been scrolled to by scrollToIndex, so highlight it
    if (this.m_scrollIndexAfterFetch != null) {
      if (this._isInViewport(this.m_scrollIndexAfterFetch) === DvtDataGrid.INSIDE) {
        if (
          this._isDatabodyCellActive() &&
          this.m_scrollIndexAfterFetch.row === this.m_active.indexes.row &&
          this.m_scrollIndexAfterFetch.column === this.m_active.indexes.column
        ) {
          this._highlightActive();
        }
        // should be able to scroll to index without highlighting it
        this.m_scrollIndexAfterFetch = null;
      }
    }

    // do the same for headers
    if (this.m_scrollHeaderAfterFetch != null) {
      let axis = 'row';
      const index = this.m_scrollHeaderAfterFetch.index;
      if (
        this.m_scrollHeaderAfterFetch.axis === 'column' ||
        this.m_scrollHeaderAfterFetch.axis === 'columnEnd'
      ) {
        axis = 'column';
      }
      if (this._isAxisIndexInViewport(index, axis) === DvtDataGrid.INSIDE) {
        if (
          !this._isDatabodyCellActive() &&
          this.m_scrollHeaderAfterFetch.axis === this.m_active.axis &&
          this.m_scrollHeaderAfterFetch.index === this.m_active.index &&
          this.m_scrollHeaderAfterFetch.level === this.m_active.level
        ) {
          this._highlightActive();
        }
        // should be able to scroll to index without highlighting it
        this.m_scrollHeaderAfterFetch = null;
      }
    }

    if (!this.m_utils.isTouchDeviceNotIOS()) {
      // If detect an actual scroll, fire scroll event
      if (this.m_prevScrollTop !== scrollTop || this.m_prevScrollLeft !== scrollLeft) {
        this.fireEvent('scroll', { event: null, ui: { scrollX: scrollLeft, scrollY: scrollTop } });
      }
    }
    if (!this.m_utils.isTouchDeviceNotIOS() && this.isFetchComplete()) {
      this._checkScrollPosition();
    }
  };

  /**
   * Callback to run when the final transition ends
   * @private
   */
  DvtDataGrid.prototype._scrollTransitionEnd = function () {
    // center touch affordances if row selection multiple
    if (this._isSelectionEnabled()) {
      this._scrollTouchSelectionAffordance();
    }

    // Fire scroll event after physical scrolling finishes
    this.fireEvent('scroll', {
      event: null,
      ui: {
        scrollX: this.m_currentScrollLeft,
        scrollY: this.m_currentScrollTop
      }
    });

    // check how the viewport needs to be filled, through long scroll or HWS fillViewport.
    // This should be replaced once we optimize sort going to the newly sorted location.
    if (this._shouldLongScroll(this.m_currentScrollLeft, this.m_currentScrollTop)) {
      this.handleLongScroll(this.m_currentScrollLeft, this.m_currentScrollTop);
    } else {
      this.fillViewport();
    }

    this._checkScroll = true;

    if (this.isFetchComplete()) {
      this._checkScrollPosition();
    }
  };

  /**
   * Perform the bounce back animation when a swipe gesture causes over scrolling
   * @private
   */
  DvtDataGrid.prototype._bounceBack = function () {
    var scrollLeft = this.m_currentScrollLeft;
    var scrollTop = this.m_currentScrollTop;

    var databody = this.m_databody.firstChild;
    var colHeader = this.m_colHeader.firstChild;
    var rowHeader = this.m_rowHeader.firstChild;
    var colEndHeader = this.m_colEndHeader.firstChild;
    var rowEndHeader = this.m_rowEndHeader.firstChild;

    databody.style.transitionDuration = DvtDataGrid.BOUNCE_ANIMATION_DURATION + 'ms';
    rowHeader.style.transitionDuration = DvtDataGrid.BOUNCE_ANIMATION_DURATION + 'ms';
    rowEndHeader.style.transitionDuration = DvtDataGrid.BOUNCE_ANIMATION_DURATION + 'ms';
    colHeader.style.transitionDuration = DvtDataGrid.BOUNCE_ANIMATION_DURATION + 'ms';
    colEndHeader.style.transitionDuration = DvtDataGrid.BOUNCE_ANIMATION_DURATION + 'ms';

    // process to run after bounce back animation ends
    if (this.m_scrollTransitionEnd == null) {
      this.m_scrollTransitionEnd = this._scrollTransitionEnd.bind(this);
    }
    this._onEndEvent(
      'transitionend',
      databody,
      this.m_scrollTransitionEnd,
      DvtDataGrid.BOUNCE_ANIMATION_DURATION
    );

    // scroll back to actual scrollLeft/scrollTop positions
    if (this.getResources().isRTLMode()) {
      databody.style.transform = 'translate3d(' + scrollLeft + 'px, ' + -scrollTop + 'px, 0)';
      colHeader.style.transform = 'translate3d(' + scrollLeft + 'px, 0, 0)';
      colEndHeader.style.transform = 'translate3d(' + scrollLeft + 'px, 0, 0)';
    } else {
      databody.style.transform = 'translate3d(' + -scrollLeft + 'px, ' + -scrollTop + 'px, 0)';
      colHeader.style.transform = 'translate3d(' + -scrollLeft + 'px, 0, 0)';
      colEndHeader.style.transform = 'translate3d(' + -scrollLeft + 'px, 0, 0)';
    }
    rowHeader.style.transform = 'translate3d(0, ' + -scrollTop + 'px, 0)';
    rowEndHeader.style.transform = 'translate3d(0, ' + -scrollTop + 'px, 0)';

    // reset
    this.m_extraScrollOverX = null;
    this.m_extraScrollOverY = null;
  };

  /**
   * Make sure the databody/headers and the scroller are in sync, which could happen when scrolling
   * stopped awaiting fetch to complete.
   * @private
   */
  DvtDataGrid.prototype._syncScroller = function () {
    var scrollLeft = this.m_currentScrollLeft;
    var scrollTop = this.m_currentScrollTop;

    var databody = this.m_databody.firstChild;
    var colHeader = this.m_colHeader.firstChild;
    var rowHeader = this.m_rowHeader.firstChild;
    var colEndHeader = this.m_colEndHeader.firstChild;
    var rowEndHeader = this.m_rowEndHeader.firstChild;

    let databodyFrozenCol;
    let databodyFrozenRow;
    if (this.m_databodyFrozenCol) {
      databodyFrozenCol = this.m_databodyFrozenCol.firstChild;
    }
    if (this.m_databodyFrozenRow) {
      databodyFrozenRow = this.m_databodyFrozenRow.firstChild;
    }

    // use translate3d for smoother scrolling
    // this checks determine whether this is webkit and translated3d is supported
    if (
      this.m_utils.isTouchDeviceNotIOS() &&
      Object.prototype.hasOwnProperty.call(window, 'WebKitCSSMatrix')
    ) {
      this._checkScroll = false;

      // check if the swipe gesture causes over scrolling of scrollable area
      if (this.m_extraScrollOverX != null || this.m_extraScrollOverY != null) {
        // swipe horizontal or vertical
        if (this.m_extraScrollOverX != null) {
          scrollLeft += this.m_extraScrollOverX;
        } else {
          scrollTop += this.m_extraScrollOverY;
        }

        // bounce back animation function
        if (this.m_bounceBack == null) {
          this.m_bounceBack = this._bounceBack.bind(this);
        }

        this._onEndEvent('transitionend', databody, this.m_bounceBack, 500);
      } else if (databody.style.transitionDuration === '0ms') {
        // no transition, just call the handler directly
        this._scrollTransitionEnd();
      } else {
        if (this.m_scrollTransitionEnd == null) {
          this.m_scrollTransitionEnd = this._scrollTransitionEnd.bind(this);
        }
        this._onEndEvent(
          'transitionend',
          databody,
          this.m_scrollTransitionEnd,
          databody.style.transitionDuration
        );
      }

      // actual scrolling of databody and headers
      if (this.getResources().isRTLMode()) {
        databody.style.transform = 'translate3d(' + scrollLeft + 'px, ' + -scrollTop + 'px, 0)';
        colHeader.style.transform = 'translate3d(' + scrollLeft + 'px, 0, 0)';
        colEndHeader.style.transform = 'translate3d(' + scrollLeft + 'px, 0, 0)';
      } else {
        databody.style.transform = 'translate3d(' + -scrollLeft + 'px, ' + -scrollTop + 'px, 0)';
        colHeader.style.transform = 'translate3d(' + -scrollLeft + 'px, 0, 0)';
        colEndHeader.style.transform = 'translate3d(' + -scrollLeft + 'px, 0, 0)';
      }
      rowHeader.style.transform = 'translate3d(0, ' + -scrollTop + 'px, 0)';
      rowEndHeader.style.transform = 'translate3d(0, ' + -scrollTop + 'px, 0)';
    } else {
      var dir = this.getResources().isRTLMode() ? 'right' : 'left';
      this.setElementDir(colHeader, -scrollLeft, dir);
      this.setElementDir(colEndHeader, -scrollLeft, dir);
      this.setElementDir(rowHeader, -scrollTop, 'top');
      this.setElementDir(rowEndHeader, -scrollTop, 'top');
      if (databodyFrozenRow) {
        this.setElementDir(databodyFrozenRow, -scrollLeft, dir);
      }
      if (databodyFrozenCol) {
        this.setElementDir(databodyFrozenCol, -scrollTop, 'top');
      }
    }
  };

  /**
   * Adjust the scroller when we scroll to the ends of the scroller.  The scroller dimension might
   * need adjustment due to 1) variable column width or row height due to custom sizing 2) the row
   * or column count is not exact.
   * @private
   */
  DvtDataGrid.prototype._adjustScrollerSize = function () {
    var scrollerContent = this.m_databody.firstChild;
    var scrollerContentHeight = this.getElementHeight(scrollerContent);
    var scrollerContentWidth = this.getElementWidth(scrollerContent);
    var emptyBodyContent = this._getEmptyElement();
    var emptyBodyContentHeight = 0;
    var emptyBodyContentWidth = 0;
    if (emptyBodyContent) {
      emptyBodyContentHeight = this.getElementHeight(emptyBodyContent);
      emptyBodyContentWidth = this.getElementWidth(emptyBodyContent);
    }

    // if (1) actual content is higher than scroller (regardless of the current position) OR
    //    (2) we have reached the last row and the actual content is shorter than scroller
    if (
      this._getMaxBottomPixel() > scrollerContentHeight ||
      (this.getDataSource().getCount('row') === this._getMaxBottom() + 1 &&
        !this._isCountUnknown('row') &&
        this._getMaxBottom() > -1)
    ) {
      this.setElementHeight(
        scrollerContent,
        Math.max(this._getMaxBottomPixel(), emptyBodyContentHeight)
      );
    }

    // if (1) actual content is wider than scroller (regardless of the current position) OR
    //    (2) we have reached the last column and the actual content is narrower than scroller
    if (
      this._getMaxRightPixel() > scrollerContentWidth ||
      (this.getDataSource().getCount('column') === this._getMaxRight() + 1 &&
        !this._isCountUnknown('column') &&
        this._getMaxRight() > -1)
    ) {
      this.setElementWidth(
        scrollerContent,
        Math.max(this._getMaxRightPixel(), emptyBodyContentWidth)
      );
    }
  };

  /**
   * Get the starting position based on scroll
   * @param {number} scrollDir
   * @param {number} prevScrollDir
   * @param {string} axis
   * @returns {Object} contains start and startPixel
   */
  DvtDataGrid.prototype._getLongScrollStart = function (scrollDir, prevScrollDir, axis) {
    var scrollerDimension;
    var maxDimension;
    var maxScroll;
    var avgDimension;
    var scrollbarSize;
    var start;
    var startPixel;
    var total;

    // totals must be 0 or higher for long scroll
    if (prevScrollDir !== scrollDir) {
      if (axis === 'row') {
        scrollerDimension = this.getElementHeight(this.m_databody.firstChild);
        maxDimension = this.m_utils._getMaxDivHeightForScrolling();
        maxScroll = this._getMaxScrollHeight();
        avgDimension = this.m_avgRowHeight;
        scrollbarSize = this.m_hasHorizontalScroller ? this.m_utils.getScrollbarSize() : 0;
        total = Math.max(Math.max(this.getDataSource().getCount(axis), this.m_endRow), 0);
      } else if (axis === 'column') {
        scrollerDimension = this.getElementWidth(this.m_databody.firstChild);
        maxDimension = this.m_utils._getMaxDivWidthForScrolling();
        maxScroll = this._getMaxScrollWidth();
        avgDimension = this.m_avgColWidth;
        scrollbarSize = this.m_hasVerticalScroller ? this.m_utils.getScrollbarSize() : 0;
        total = Math.max(Math.max(this.getDataSource().getCount(axis), this.m_endCol), 0);
      }

      var oversizeRatio = Math.max(Math.min(scrollDir / scrollerDimension, 1), 0);
      var fetchSize = this.getFetchSize(axis);
      start = Math.floor(total * oversizeRatio);
      startPixel =
        maxDimension <= scrollerDimension ? Math.min(scrollDir, maxScroll) : start * avgDimension;

      if (
        oversizeRatio === 1 ||
        scrollDir + fetchSize * avgDimension > scrollerDimension - scrollbarSize
      ) {
        start = Math.max(total - fetchSize, 0);
        startPixel = Math.max(scrollerDimension - fetchSize * avgDimension, 0);
      }
    } else if (axis === 'row') {
      start = this.m_longScrollRow != null ? this.m_longScrollRow : this.m_startRow;
      startPixel =
        this.m_longScrollRowPixel != null ? this.m_longScrollRowPixel : this.m_startRowPixel;
    } else if (axis === 'column') {
      start = this.m_longScrollColumn != null ? this.m_longScrollColumn : this.m_startCol;
      startPixel =
        this.m_longScrollColumnPixel != null ? this.m_longScrollColumnPixel : this.m_startColPixel;
    }

    return { start: start, startPixel: startPixel };
  };

  /**
   * Handle scroll to position that is completely outside of the current row/column range
   * For example, in Chrome it is possible to cause a "jump" back to the start position
   * This might also be needed if we decide to use delay scroll (to detect long scroll) to avoid
   * excessive fetching.
   * @param {number} scrollLeft - the position the scroller left should be
   * @param {number} scrollTop - the position the scroller top should be
   */
  DvtDataGrid.prototype.handleLongScroll = function (scrollLeft, scrollTop) {
    this.m_isLongScroll = true;

    // _getLongScrollStart should be involked when fetch is in progress to cache scroll indexes
    const rowReturnVal = this._getLongScrollStart(scrollTop, this.m_prevScrollTop, 'row');
    this.m_longScrollRow = rowReturnVal.start;
    this.m_longScrollRowPixel = rowReturnVal.startPixel;

    const columnReturnVal = this._getLongScrollStart(scrollLeft, this.m_prevScrollLeft, 'column');
    this.m_longScrollColumn = columnReturnVal.start;
    this.m_longScrollColumnPixel = columnReturnVal.startPixel;

    if (this.isSkeletonSupport()) {
      this.loadSkeletons(
        scrollTop,
        scrollLeft,
        this.m_longScrollRow,
        this.m_longScrollColumn,
        this.m_longScrollRowPixel,
        this.m_longScrollColumnPixel
      );
    }

    if (this.isFetchComplete() && this._isScrollBackToEditable(true)) {
      const startRow = this.m_longScrollRow;
      const startRowPixel = this.m_longScrollRowPixel;
      const startCol = this.m_longScrollColumn;
      const startColPixel = this.m_longScrollColumnPixel;
      let needsResetVars = true;
      // reset vars after fetch return to handle component resize in the intermediate
      let resetVars = () => {
        if (needsResetVars) {
          needsResetVars = false;
          // need to redraw header borders
          this.m_resizeRequired = true;
          // reset ranges, just cleaned up to only set if the header is present
          if (this.m_hasCells) {
            this.m_startRow = startRow;
            this.m_endRow = -1;
            this.m_startRowPixel = startRowPixel;
            this.m_endRowPixel = startRowPixel;
            this.m_startCol = startCol;
            this.m_endCol = -1;
            this.m_startColPixel = startColPixel;
            this.m_endColPixel = startColPixel;
          }

          if (this.m_hasRowHeader) {
            this.m_startRowHeader = startRow;
            this.m_endRowHeader = -1;
            this.m_startRowHeaderPixel = startRowPixel;
            this.m_endRowHeaderPixel = startRowPixel;
          }
          if (this.m_hasRowEndHeader) {
            this.m_startRowEndHeader = startRow;
            this.m_endRowEndHeader = -1;
            this.m_startRowEndHeaderPixel = startRowPixel;
            this.m_endRowEndHeaderPixel = startRowPixel;
          }
          if (this.m_hasColHeader) {
            this.m_startColHeader = startCol;
            this.m_endColHeader = -1;
            this.m_startColHeaderPixel = startColPixel;
            this.m_endColHeaderPixel = startColPixel;
          }
          if (this.m_hasColEndHeader) {
            this.m_startColEndHeader = startCol;
            this.m_endColEndHeader = -1;
            this.m_startColEndHeaderPixel = startColPixel;
            this.m_endColEndHeaderPixel = startColPixel;
          }

          this.m_stopRowFetch = false;
          this.m_stopRowHeaderFetch = false;
          this.m_stopRowEndHeaderFetch = false;
          this.m_stopColumnFetch = false;
          this.m_stopColumnHeaderFetch = false;
          this.m_stopColumnEndHeaderFetch = false;
        }
      };
      // custom success callback so that we can reset all ranges and fields
      // initiate fetch of headers and cells
      this.fetchHeaders('row', startRow, this.m_rowHeader, this.m_rowEndHeader, undefined, {
        success: function (headerSet, headerRange, endHeaderSet) {
          resetVars();
          this.handleHeadersFetchSuccessForLongScroll(headerSet, headerRange, endHeaderSet);
        }
      });
      this.fetchHeaders('column', startCol, this.m_colHeader, this.m_colEndHeader, undefined, {
        success: function (headerSet, headerRange, endHeaderSet) {
          resetVars();
          this.handleHeadersFetchSuccessForLongScroll(headerSet, headerRange, endHeaderSet);
        }
      });
      this.fetchCells(this.m_databody, startRow, startCol, null, null, {
        success: function (cellSet, cellRange) {
          resetVars();
          this.handleCellsFetchSuccessForLongScroll(
            cellSet,
            cellRange,
            startRow,
            startCol,
            startRowPixel,
            startColPixel
          );
        }
      });
    }
  };

  /**
   * Handle a successful call to the data source fetchHeaders for long scroll
   * @param {Object} headerSet - the result of the fetch
   * @param {Object} headerRange - {"axis":,"start":,"count":,"header":}
   * @param {Object} endHeaderSet - the result of the fetch
   * @protected
   */
  DvtDataGrid.prototype.handleHeadersFetchSuccessForLongScroll = function (
    headerSet,
    headerRange,
    endHeaderSet
  ) {
    let headerContent = this.m_rowHeader.firstChild;
    let endHeaderContent = this.m_rowEndHeader.firstChild;
    if (headerRange.axis === 'column') {
      headerContent = this.m_colHeader.firstChild;
      endHeaderContent = this.m_colEndHeader.firstChild;
    }
    if (headerContent != null) {
      this._removeAllNonSkeletonContainerNodes(headerContent);
    }
    if (endHeaderContent != null) {
      this._removeAllNonSkeletonContainerNodes(endHeaderContent);
    }
    this.handleHeadersFetchSuccess(headerSet, headerRange, endHeaderSet, false);
  };

  /**
   * Handle a successful call to the data source fetchCells. Create new row and
   * cell DOM elements when necessary and then insert them into the databody.
   * @param {Object} cellSet - a CellSet object which encapsulates the result set of cells
   * @param {Array.<Object>} cellRange - [rowRange, columnRange] - [{"axis":,"start":,"count":},{"axis":,"start":,"count":,"databody":,"scroller":}]
   * @param {number} startRow the row to start insert at
   * @param {number} startCol the col to start insert at
   * @param {number} startRowPixel the row pixel to start insert at
   * @param {number} startColPixel the col pixel to start insert at
   * @protected
   */
  DvtDataGrid.prototype.handleCellsFetchSuccessForLongScroll =
    // eslint-disable-next-line no-unused-vars
    function (cellSet, cellRange, startRow, startCol, startRowPixel, startColPixel) {
      const databodyContent = this.m_databody.firstChild;
      if (databodyContent != null && !this._getEmptyElement()) {
        const cells = this._getAllNonSkeletonContainerNodes(databodyContent);
        cells.forEach((cell) => {
          this._remove(cell);
        });
      }
      // now calls fetch success proc
      this.handleCellsFetchSuccess(cellSet, cellRange);
    };

  /**
   * Method to clean up the viewport in one direction, left cleans the first columns, top the first rows etc.
   * This is seperate from fill viewport so that in both the synchronus and asynchronus
   * fetch case the cleanuo happens after we get the data fpor the next area.
   * @param {string|null|undefined} direction left/right/top/bottom
   */
  DvtDataGrid.prototype._cleanupViewport = function (direction) {
    if (this._isHighWatermarkScrolling() || !this._isScrollBackToEditable()) {
      return;
    }

    // direction can be null if there are no cells fetched
    if (direction == null) {
      if (this.m_prevScrollLeft > this.m_currentScrollLeft) {
        // eslint-disable-next-line no-param-reassign
        direction = 'right';
      } else if (this.m_prevScrollLeft < this.m_currentScrollLeft) {
        // eslint-disable-next-line no-param-reassign
        direction = 'left';
      } else if (this.m_prevScrollTop > this.m_currentScrollTop) {
        // eslint-disable-next-line no-param-reassign
        direction = 'bottom';
      } else if (this.m_prevScrollTop < this.m_currentScrollTop) {
        // eslint-disable-next-line no-param-reassign
        direction = 'top';
      }
    }

    // the viewport is the scroller, width and height
    var viewportLeft = this._getViewportLeft();
    var viewportRight = this._getViewportRight();
    var viewportTop = this._getViewportTop();
    var viewportBottom = this._getViewportBottom();

    if (direction === 'top' && viewportTop > this._getMaxTopPixel()) {
      this.removeRowsFromTop(this.m_databody);
      this.removeRowHeadersFromTop();
    } else if (direction === 'bottom' && viewportBottom < this._getMaxBottomPixel()) {
      this.removeRowsFromBottom(this.m_databody);
      this.removeRowHeadersFromBottom();
    } else if (direction === 'left' && viewportLeft > this._getMaxLeftPixel()) {
      this.removeColumnsFromLeft(this.m_databody);
      this.removeColumnHeadersFromLeft();
    } else if (direction === 'right' && viewportRight < this._getMaxRightPixel()) {
      this.removeColumnsFromRight(this.m_databody);
      this.removeColumnHeadersFromRight();
    }
  };

  /**
   * Make sure the viewport is filled of cells, this method has been modified to just fill
   * and so that it will always follow a fetchHeaders call with a fetchCells call to keep them in sync.
   */
  DvtDataGrid.prototype.fillViewport = function () {
    var fetchStart;
    var fetchSize;

    // load skeletons
    const rowReturnVal = this._getLongScrollStart(
      this.m_currentScrollTop,
      this.m_prevScrollTop,
      'row'
    );
    const columnReturnVal = this._getLongScrollStart(
      this.m_currentScrollLeft,
      this.m_prevScrollLeft,
      'column'
    );
    if (this.isSkeletonSupport()) {
      this.loadSkeletons(
        this.m_currentScrollTop,
        this.m_currentScrollLeft,
        rowReturnVal.start,
        columnReturnVal.start,
        rowReturnVal.startPixel,
        columnReturnVal.startPixel
      );
    }

    if (this.isFetchComplete()) {
      // the viewport is the scroller, width and height
      // fetch slightly before the edge for the zoomed browser case as the pixel mapping isn't perfect
      var viewportLeft = this._getViewportLeft();
      var viewportRight = this._getViewportRight() + DvtDataGrid.FETCH_PIXEL_THRESHOLD;
      var viewportTop = this._getViewportTop();
      var viewportBottom = this._getViewportBottom() + DvtDataGrid.FETCH_PIXEL_THRESHOLD;

      if (this._getMaxBottomPixel() <= viewportBottom) {
        if (!this.m_stopRowHeaderFetch || !this.m_stopRowEndHeaderFetch || !this.m_stopRowFetch) {
          fetchStart = Math.max(0, this._getMaxBottom() + 1);
          fetchSize = Math.max(0, this.getFetchCount('row', fetchStart));
          this.fetchHeaders('row', fetchStart, this.m_rowHeader, this.m_rowEndHeader, fetchSize);
          this.fetchCells(
            this.m_databody,
            fetchStart,
            this.m_startCol,
            fetchSize,
            this.m_endCol - this.m_startCol + 1
          );
          return;
        }
      }

      if (
        (this._getMaxTopPixel() > viewportTop || this.m_currentScrollTop === 0) &&
        this._getMaxTop() > 0
      ) {
        fetchStart = Math.max(0, this._getMaxTop() - this.getFetchSize('row'));
        fetchSize = Math.max(0, this._getMaxTop() - fetchStart);
        this.fetchHeaders('row', fetchStart, this.m_rowHeader, this.m_rowEndHeader, fetchSize);
        this.fetchCells(
          this.m_databody,
          fetchStart,
          this.m_startCol,
          fetchSize,
          this.m_endCol - this.m_startCol + 1
        );
        return;
      }

      if (this._getMaxRightPixel() <= viewportRight) {
        if (
          !this.m_stopColumnHeaderFetch ||
          !this.m_stopColumnEndHeaderFetch ||
          !this.m_stopColumnFetch
        ) {
          fetchStart = Math.max(0, this._getMaxRight() + 1);
          fetchSize = Math.max(0, this.getFetchCount('column', fetchStart));
          this.fetchHeaders('column', fetchStart, this.m_colHeader, this.m_colEndHeader, fetchSize);
          this.fetchCells(
            this.m_databody,
            this.m_startRow,
            fetchStart,
            this.m_endRow - this.m_startRow + 1,
            fetchSize
          );
          return;
        }
      }

      if (
        (this._getMaxLeftPixel() > viewportLeft || this.m_currentScrollLeft === 0) &&
        this._getMaxLeft() > 0
      ) {
        fetchStart = Math.max(0, this._getMaxLeft() - this.getFetchSize('column'));
        fetchSize = Math.max(0, this._getMaxLeft() - fetchStart);
        this.fetchHeaders('column', fetchStart, this.m_colHeader, this.m_colEndHeader, fetchSize);
        this.fetchCells(
          this.m_databody,
          this.m_startRow,
          fetchStart,
          this.m_endRow - this.m_startRow + 1,
          fetchSize
        );
      }
    }
  };

  /**
   * @returns {number} last column or column start or end header
   */
  DvtDataGrid.prototype._getMaxRight = function () {
    return Math.max(this.m_endCol, this.m_endColHeader, this.m_endColEndHeader);
  };

  /**
   * @returns {number} first column or column start or end header
   */
  DvtDataGrid.prototype._getMaxLeft = function () {
    return Math.max(this.m_startCol, this.m_startColHeader, this.m_startColEndHeader);
  };

  /**
   * @returns {number} last column or column start or end header pixel
   */
  DvtDataGrid.prototype._getMaxRightPixel = function () {
    return Math.max(this.m_endColPixel, this.m_endColHeaderPixel, this.m_endColEndHeaderPixel);
  };

  /**
   * @returns {number} first column or column start or end header pixel
   */
  DvtDataGrid.prototype._getMaxLeftPixel = function () {
    return Math.max(this.m_startColPixel, this.m_startColHeaderPixel, this.m_startColEndHeaderPixel);
  };

  /**
   * @returns {number} last row or row start or end header
   */
  DvtDataGrid.prototype._getMaxBottom = function () {
    return Math.max(this.m_endRow, this.m_endRowHeader, this.m_endRowEndHeader);
  };

  /**
   * @returns {number} first row or row start or end header
   */
  DvtDataGrid.prototype._getMaxTop = function () {
    return Math.max(this.m_startRow, this.m_startRowHeader, this.m_startRowEndHeader);
  };

  /**
   * @returns {number} last row or row start or end header pixel
   */
  DvtDataGrid.prototype._getMaxBottomPixel = function () {
    return Math.max(this.m_endRowPixel, this.m_endRowHeaderPixel, this.m_endRowEndHeaderPixel);
  };

  /**
   * @returns {number} first row or row start or end header pixel
   */
  DvtDataGrid.prototype._getMaxTopPixel = function () {
    return Math.max(this.m_startRowPixel, this.m_startRowHeaderPixel, this.m_startRowEndHeaderPixel);
  };

  /**
   * If we are about to remove a cell that is being edited, try to handle it first
   * @private
   */
  DvtDataGrid.prototype._isScrollBackToEditable = function (longScroll) {
    var currentMode = this._getCurrentMode();
    var cell = this._getActiveElement();
    if (currentMode === 'edit' && (longScroll || this._isCellGoingToBeRemoved(cell))) {
      return this._handleExitEdit(null, cell);
    }
    return true;
  };

  /**
   * Check if the cell is supposed to be removed
   * @private
   * @param {Element|null} cell
   */
  DvtDataGrid.prototype._isCellGoingToBeRemoved = function (cell) {
    if (!this._isHighWatermarkScrolling()) {
      if (this.m_endRow - this.m_startRow > this.MAX_ROW_THRESHOLD) {
        var top = this.getElementDir(cell.parentNode, 'top');
        var height = this.getElementHeight(cell);
        if (
          top + height < this.m_currentScrollTop ||
          top < this.m_currentScrollTop + this.getViewportHeight()
        ) {
          return true;
        }
      }
      if (this.m_endCol - this.m_startCol > this.MAX_COLUMN_THRESHOLD) {
        var left = this.getElementDir(cell, 'left');
        var width = this.getElementWidth(cell);
        if (
          left + width < this.m_currentScrollLeft ||
          left < this.m_currentScrollLeft + this.getViewportHeight()
        ) {
          return true;
        }
      }
    }
    return undefined;
  };

  /**
   * Remove cells along a given axis
   * @param {string} axis
   * @param {number} threshold
   * @param {boolean} isFromEnd
   * @private
   */
  DvtDataGrid.prototype._removeCellsAlongAxis = function (axis, threshold, isFromEnd) {
    var j;
    var axisStart;
    var axisEnd;
    var axisLevelCount;
    var dimension;
    var axisStartPixel;
    var axisEndPixel;
    var currentScroll;
    var otherAxis;
    var otherAxisStart;
    var otherAxisEnd;
    var dir;
    var totalDimensionChange = 0;
    var totalCountChange = 0;

    if (axis === 'row') {
      axisStart = this.m_startRow;
      axisEnd = this.m_endRow;
      axisLevelCount = this.m_rowHeaderLevelCount;
      dimension = 'height';
      axisStartPixel = this.m_startRowPixel;
      axisEndPixel = this.m_endRowPixel;
      currentScroll = this.m_currentScrollTop;
      otherAxis = 'column';
      otherAxisStart = this.m_startCol;
      otherAxisEnd = this.m_endCol;
      dir = 'top';
      j = isFromEnd ? axisEnd : axisStart;
    } else {
      axisStart = this.m_startCol;
      axisEnd = this.m_endCol;
      axisLevelCount = this.m_columnHeaderLevelCount;
      dimension = 'width';
      axisStartPixel = this.m_startColPixel;
      axisEndPixel = this.m_endColPixel;
      currentScroll = this.m_currentScrollLeft;
      otherAxis = 'row';
      otherAxisStart = this.m_startRow;
      otherAxisEnd = this.m_endRow;
      dir = this.getResources().isRTLMode() ? 'right' : 'left';
      j = isFromEnd ? axisEnd : axisStart;
    }

    while (j <= axisEnd && j >= axisStart) {
      var key = this._getKey(this._getHeaderByIndex(j, axis, axisLevelCount - 1), axis);
      if (key == null) {
        key = this._getKey(
          this._getCellByIndex(
            axis === 'column'
              ? this.createIndex(this.m_startRow, j)
              : this.createIndex(j, this.m_startCol)
          ),
          axis
        );
      }

      var dimensionValue = this.isHidden(axis, j)
        ? 0
        : this._getCellDimension(null, j, key, axis, dimension);
      if (
        isFromEnd
          ? axisEndPixel - dimensionValue - totalDimensionChange > threshold
          : axisStartPixel + dimensionValue + totalDimensionChange < currentScroll - threshold
      ) {
        var otherExtent;
        for (var i = otherAxisStart; i <= otherAxisEnd; i += otherExtent) {
          var cell = this._getCellByIndex(
            axis === 'column' ? this.createIndex(i, j) : this.createIndex(j, i)
          );
          var cellContext = cell[this.getResources().getMappedAttribute('context')];
          var axisExtent = cellContext.extents[axis];
          otherExtent = cellContext.extents[otherAxis];

          if (axisExtent === 1) {
            this._remove(cell);
            // remove hidden indicator div belonging to cell (if any) along the axis
            if (this.isHidden(axis, j)) {
              this._remove(this.getHiddenIndicatorByIndex(j, this.m_databody.firstChild, false));
            }
          } else {
            cellContext.extents[axis] -= 1;
            this.setElementDir(cell, this.getElementDir(cell, dimension) - dimensionValue, dimension);
            if (!isFromEnd) {
              cellContext.indexes[axis] += 1;
              this.setElementDir(cell, this.getElementDir(cell, dir) + dimensionValue, dir);
            }
          }

          for (var k = 0; k < otherExtent; k++) {
            var index = axis === 'column' ? this.createIndex(i + k, j) : this.createIndex(j, i + k);
            this._removeIndexFromDatabodyMap(index);
          }
        }
        totalDimensionChange += dimensionValue;
        totalCountChange += 1;
        j = isFromEnd ? j - 1 : j + 1;
      } else {
        break;
      }
    }

    return { dimensionChange: totalDimensionChange, extentChange: totalCountChange };
  };

  /**
   * Removes all of the headers in the containing div up until the right value is less than the scroll position minus the threshold.
   * It is recuresively called on inner levels in the multi-level header case.
   * @param {Element} headersContainer
   * @param {Element|null} firstChild
   * @param {number} startPixel
   * @param {number} threshold
   * @param {string} className
   * @param {string} dimension
   * @param {string} dir
   * @param {number} scrollPosition
   * @returns {Object} object with keys extentChange, which denotes how many header
   *      indexes were removed under the parent and dimensionChange which is the
   *      total dimensions of the headers removed
   */
  DvtDataGrid.prototype.removeHeadersFromStartOfContainer = function (
    headersContainer,
    firstChild,
    startPixel,
    threshold,
    className,
    dimension,
    dir,
    scrollPosition
  ) {
    const context = this.getResources().getMappedAttribute('context');
    var removedHeaders = 0;
    var removedDimensionValue = 0;
    // To make sure we don't get other children divs (like visual indicator)
    // get elements with the header class name
    let headerElements = Array.from(headersContainer.children).filter((element) => {
      return (
        this.m_utils.containsCSSClassName(element, className) ||
        this.m_utils.containsCSSClassName(element, this.getMappedStyle('groupingcontainer'))
      );
    });
    var element = firstChild == null ? headerElements[0] : firstChild.nextSibling;

    if (element == null) {
      return { extentChange: 0, dimensionChange: 0 };
    }

    var isHeader = this.m_utils.containsCSSClassName(element, className);
    var header = isHeader ? element : element.firstChild;
    var dimensionValue = this.getElementDir(header, dimension);

    while (startPixel + dimensionValue < scrollPosition - threshold) {
      this._remove(element);
      if (isHeader) {
        let axis = element[context].axis;
        let elementIndex = element[context].index;
        // remove header/endHeader hidden indicator div belonging to element (if any)
        // along the axis from start on scroll
        if (this.isHidden(axis, elementIndex)) {
          this._remove(this.getHiddenIndicatorByIndex(elementIndex, headersContainer, true));
        }
      }

      /* eslint-disable no-loop-func */
      headerElements.shift();
      removedDimensionValue += dimensionValue;
      removedHeaders += isHeader ? 1 : this._getAttribute(element, 'extent', true);
      // eslint-disable-next-line no-param-reassign
      startPixel += dimensionValue;

      element = firstChild == null ? headerElements[0] : firstChild.nextSibling;
      if (element == null) {
        return { extentChange: removedHeaders, dimensionChange: removedDimensionValue };
      }
      isHeader = this.m_utils.containsCSSClassName(element, className);
      header = isHeader ? element : element.firstChild;
      dimensionValue = this.getElementDir(header, dimension);
    }

    if (!isHeader) {
      var returnVal = this.removeHeadersFromStartOfContainer(
        element,
        element.firstChild,
        startPixel,
        threshold,
        className,
        dimension,
        dir,
        scrollPosition
      );
      this._setAttribute(
        element,
        'start',
        this._getAttribute(element, 'start', true) + returnVal.extentChange
      );
      this._setAttribute(
        element,
        'extent',
        this._getAttribute(element, 'extent', true) - returnVal.extentChange
      );
      this.setElementDir(header, this.getElementDir(header, dir) + returnVal.dimensionChange, dir);
      this.setElementDir(
        header,
        this.getElementDir(header, dimension) - returnVal.dimensionChange,
        dimension
      );

      header[context].index += returnVal.extentChange;
      header[context].extent -= returnVal.extentChange;

      removedHeaders += returnVal.extentChange;
      removedDimensionValue += returnVal.dimensionChange;
    }

    return { extentChange: removedHeaders, dimensionChange: removedDimensionValue };
  };

  /**
   * Removes all of the headers in the containing div up until the right value is less than the specified threshold.
   * It is recuresively called on inner levels in the multi-level header case.
   * @param {Element} headersContainer
   * @param {number} endPixel
   * @param {number} threshold
   * @param {string} className
   * @param {string} dimension
   * @returns {Object} object with keys extentChange, which denotes how many header
   *      indexes were removed under the parent and dimensionChange which is the
   *      total width of the headers removed
   */
  DvtDataGrid.prototype.removeHeadersFromEndOfContainer = function (
    headersContainer,
    endPixel,
    threshold,
    className,
    dimension
  ) {
    const context = this.getResources().getMappedAttribute('context');
    var removedHeaders = 0;
    var removedHeadersDimension = 0;
    // for hidden columns, visual indicator is appended as a child to the header container, so to avoid having them as a last child,
    // we are getting elements with the header class name
    let headerElements = Array.from(headersContainer.children).filter((element) => {
      return (
        this.m_utils.containsCSSClassName(element, className) ||
        this.m_utils.containsCSSClassName(element, this.getMappedStyle('groupingcontainer'))
      );
    });
    // get the last child of all header elements.
    let element = headerElements[headerElements.length - 1];
    var isHeader = this.m_utils.containsCSSClassName(element, className);
    var header = isHeader ? element : element.firstChild;
    var dimensionValue = this.getElementDir(header, dimension);

    while (endPixel - dimensionValue > threshold) {
      this._remove(element);

      if (isHeader) {
        let axis = element[context].axis;
        let elementIndex = element[context].index;
        if (this.isHidden(axis, elementIndex)) {
          this._remove(this.getHiddenIndicatorByIndex(elementIndex, headersContainer, true));
        }
      }
      /* eslint-disable no-loop-func */
      headerElements.pop();
      removedHeadersDimension += dimensionValue;
      removedHeaders += isHeader ? 1 : this._getAttribute(element, 'extent', true);

      // eslint-disable-next-line no-param-reassign
      endPixel -= dimensionValue;

      element = headerElements[headerElements.length - 1];
      isHeader = this.m_utils.containsCSSClassName(element, className);
      header = isHeader ? element : element.firstChild;
      dimensionValue = this.getElementDir(header, dimension);
    }

    if (!isHeader) {
      var returnVal = this.removeHeadersFromEndOfContainer(
        element,
        endPixel,
        threshold,
        className,
        dimension
      );

      this._setAttribute(
        element,
        'extent',
        this._getAttribute(element, 'extent', true) - returnVal.extentChange
      );
      this.setElementDir(
        header,
        this.getElementDir(header, dimension) - returnVal.dimensionChange,
        dimension
      );

      header[context].extent -= returnVal.extentChange;

      removedHeaders += returnVal.extentChange;
      removedHeadersDimension += returnVal.dimensionChange;
    }

    return { extentChange: removedHeaders, dimensionChange: removedHeadersDimension };
  };

  /**
   * Remove column start and end headers to the left of the current viewport
   */
  DvtDataGrid.prototype.removeColumnHeadersFromLeft = function () {
    var colThreshold;
    var returnVal;

    // clean up left column headers
    if (this.m_endColHeader - this.m_startColHeader > this.MAX_COLUMN_THRESHOLD) {
      var colHeaderContent = this.m_colHeader.firstChild;
      colThreshold = this.getColumnThreshold();
      if (this.m_startColHeaderPixel <= this.m_currentScrollLeft - colThreshold) {
        returnVal = this.removeHeadersFromStartOfContainer(
          colHeaderContent,
          null,
          this.m_startColHeaderPixel,
          colThreshold,
          this.getMappedStyle('colheadercell'),
          'width',
          this.getResources().isRTLMode() ? 'right' : 'left',
          this.m_currentScrollLeft
        );

        this.m_startColHeaderPixel += returnVal.dimensionChange;
        this.m_startColHeader += returnVal.extentChange;
      }
    }

    if (this.m_endColEndHeader - this.m_startColEndHeader > this.MAX_COLUMN_THRESHOLD) {
      var colEndHeaderContent = this.m_colEndHeader.firstChild;
      colThreshold = this.getColumnThreshold();
      if (this.m_startColEndHeaderPixel < this.m_currentScrollLeft - colThreshold) {
        returnVal = this.removeHeadersFromStartOfContainer(
          colEndHeaderContent,
          null,
          this.m_startColEndHeaderPixel,
          colThreshold,
          this.getMappedStyle('colendheadercell'),
          'width',
          this.getResources().isRTLMode() ? 'right' : 'left',
          this.m_currentScrollLeft
        );

        this.m_startColEndHeaderPixel += returnVal.dimensionChange;
        this.m_startColEndHeader += returnVal.extentChange;
      }
    }
  };

  /**
   * Remove cells to the left of the current viewport
   * @param {Element} databody - the root of the databody
   */
  DvtDataGrid.prototype.removeColumnsFromLeft = function (databody) {
    // clean up right column headers
    if (this.m_endCol - this.m_startCol > this.MAX_COLUMN_THRESHOLD) {
      var cells = databody.firstChild.querySelectorAll('.' + this.getMappedStyle('cell'));
      var colThreshold = this.getColumnThreshold();

      // no rows in databody, nothing to remove
      if (cells.length < 1) {
        return;
      }

      var returnVal = this._removeCellsAlongAxis('column', colThreshold, false);
      this.m_startColPixel += returnVal.dimensionChange;
      this.m_startCol += returnVal.extentChange;
    }
  };

  /**
   * Remove column start and end headers to the right of the current viewport
   */
  DvtDataGrid.prototype.removeColumnHeadersFromRight = function () {
    var colHeaderContent;
    var returnVal;
    var colThreshold = this.m_currentScrollLeft + this.getViewportWidth() + this.getColumnThreshold();

    // clean up right column headers
    if (this.m_endColHeader - this.m_startColHeader > this.MAX_COLUMN_THRESHOLD) {
      colHeaderContent = this.m_colHeader.firstChild;
      // don't clean up if end of row header is not below the bottom of viewport
      if (this.m_endColHeaderPixel > colThreshold) {
        if (this.m_stopColumnHeaderFetch) {
          this.m_stopColumnHeaderFetch = false;
        }

        returnVal = this.removeHeadersFromEndOfContainer(
          colHeaderContent,
          this.m_endColHeaderPixel,
          colThreshold,
          this.getMappedStyle('colheadercell'),
          'width'
        );

        this.m_endColHeaderPixel -= returnVal.dimensionChange;
        this.m_endColHeader -= returnVal.extentChange;
      }
    }

    // clean up right column end headers
    if (this.m_endColEndHeader - this.m_startColEndHeader > this.MAX_COLUMN_THRESHOLD) {
      colHeaderContent = this.m_colEndHeader.firstChild;
      // don't clean up if end of row header is not below the bottom of viewport
      if (this.m_endColEndHeaderPixel > colThreshold) {
        if (this.m_stopColumnEndHeaderFetch) {
          this.m_stopColumnEndHeaderFetch = false;
        }

        returnVal = this.removeHeadersFromEndOfContainer(
          colHeaderContent,
          this.m_endColEndHeaderPixel,
          colThreshold,
          this.getMappedStyle('colendheadercell'),
          'width'
        );

        this.m_endColEndHeaderPixel -= returnVal.dimensionChange;
        this.m_endColEndHeader -= returnVal.extentChange;
      }
    }
  };

  /**
   * Remove cells to the right of the current viewport
   * @param {Element} databody - the root of the databody
   */
  DvtDataGrid.prototype.removeColumnsFromRight = function (databody) {
    // clean up right column headers
    if (this.m_endCol - this.m_startCol > this.MAX_COLUMN_THRESHOLD) {
      var cells = databody.firstChild.querySelectorAll('.' + this.getMappedStyle('cell'));
      var threshold = this.m_currentScrollLeft + this.getViewportWidth() + this.getColumnThreshold();

      // don't clean up if end of row header is not below the bottom of viewport
      // no rows in databody, nothing to remove
      if (this.m_endColPixel <= threshold || cells.length < 1) {
        return;
      }

      if (this.m_stopColumnFetch) {
        this.m_stopColumnFetch = false;
      }

      var returnVal = this._removeCellsAlongAxis('column', threshold, true);
      this.m_endColPixel -= returnVal.dimensionChange;
      this.m_endCol -= returnVal.extentChange;
    }
  };

  /**
   * Remove row start and end headers above the current viewport
   */
  DvtDataGrid.prototype.removeRowHeadersFromTop = function () {
    var returnVal;
    var rowThreshold;

    if (this.m_endRowHeader - this.m_startRowHeader > this.MAX_ROW_THRESHOLD) {
      var rowHeaderContent = this.m_rowHeader.firstChild;
      rowThreshold = this.getRowThreshold();
      if (!(this.m_startRowHeaderPixel >= this.m_currentScrollTop - rowThreshold)) {
        returnVal = this.removeHeadersFromStartOfContainer(
          rowHeaderContent,
          null,
          this.m_startRowHeaderPixel,
          rowThreshold,
          this.getMappedStyle('rowheadercell'),
          'height',
          'top',
          this.m_currentScrollTop
        );

        this.m_startRowHeaderPixel += returnVal.dimensionChange;
        this.m_startRowHeader += returnVal.extentChange;
      }
    }

    if (this.m_endRowEndHeader - this.m_startRowEndHeader > this.MAX_ROW_THRESHOLD) {
      var rowEndHeaderContent = this.m_rowEndHeader.firstChild;
      rowThreshold = this.getRowThreshold();
      if (!(this.m_startRowEndHeaderPixel >= this.m_currentScrollTop - rowThreshold)) {
        returnVal = this.removeHeadersFromStartOfContainer(
          rowEndHeaderContent,
          null,
          this.m_startRowEndHeaderPixel,
          rowThreshold,
          this.getMappedStyle('rowendheadercell'),
          'height',
          'top',
          this.m_currentScrollTop
        );

        this.m_startRowEndHeaderPixel += returnVal.dimensionChange;
        this.m_startRowEndHeader += returnVal.extentChange;
      }
    }
  };

  /**
   * Remove rows/cells above the current viewport
   * @param {Element} databody - the root of the databody
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype.removeRowsFromTop = function (databody) {
    if (this.m_endRow - this.m_startRow > this.MAX_ROW_THRESHOLD) {
      var rowThreshold = this.getRowThreshold();
      if (this.m_startRowPixel >= this.m_currentScrollTop - rowThreshold) {
        return;
      }

      // remove all rows from top until the threshold is reached
      var returnVal = this._removeCellsAlongAxis('row', rowThreshold, false);
      this.m_startRowPixel += returnVal.dimensionChange;
      this.m_startRow += returnVal.extentChange;
    }
  };

  /**
   * Remove row start and end headers below the current viewport
   */
  DvtDataGrid.prototype.removeRowHeadersFromBottom = function () {
    var returnVal;
    var rowThreshold = this.m_currentScrollTop + this.getViewportHeight() + this.getRowThreshold();

    // clean up bottom row headers
    if (this.m_endRowHeader - this.m_startRowHeader > this.MAX_ROW_THRESHOLD) {
      var rowHeaderContent = this.m_rowHeader.firstChild;
      // don't clean up if end of row header is not below the bottom of viewport
      if (!(this.m_endRowHeaderPixel <= rowThreshold)) {
        if (this.m_stopRowHeaderFetch) {
          this.m_stopRowHeaderFetch = false;
        }

        returnVal = this.removeHeadersFromEndOfContainer(
          rowHeaderContent,
          this.m_endRowHeaderPixel,
          rowThreshold,
          this.getMappedStyle('rowheadercell'),
          'height'
        );

        this.m_endRowHeaderPixel -= returnVal.dimensionChange;
        this.m_endRowHeader -= returnVal.extentChange;
      }
    }

    // clean up bottom row headers
    if (this.m_endRowEndHeader - this.m_startRowEndHeader > this.MAX_ROW_THRESHOLD) {
      var rowEndHeaderContent = this.m_rowEndHeader.firstChild;
      // don't clean up if end of row header is not below the bottom of viewport
      if (!(this.m_endRowEndHeaderPixel <= rowThreshold)) {
        if (this.m_stopRowEndHeaderFetch) {
          this.m_stopRowEndHeaderFetch = false;
        }

        returnVal = this.removeHeadersFromEndOfContainer(
          rowEndHeaderContent,
          this.m_endRowEndHeaderPixel,
          rowThreshold,
          this.getMappedStyle('rowendheadercell'),
          'height'
        );

        this.m_endRowEndHeaderPixel -= returnVal.dimensionChange;
        this.m_endRowEndHeader -= returnVal.extentChange;
      }
    }
  };

  /**
   * Remove rows/cells below the current viewport
   * @param {Element} databody - the root of the databody
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype.removeRowsFromBottom = function (databody) {
    if (this.m_endRow - this.m_startRow > this.MAX_ROW_THRESHOLD) {
      var threshold = this.m_currentScrollTop + this.getViewportHeight() + this.getRowThreshold();

      // don't clean up if end of row header is not below the bottom of viewport
      if (this.m_endRowPixel <= threshold) {
        return;
      }

      if (this.m_stopRowFetch) {
        this.m_stopRowFetch = false;
      }

      var returnVal = this._removeCellsAlongAxis('row', threshold, true);
      this.m_endRowPixel -= returnVal.dimensionChange;
      this.m_endRow -= returnVal.extentChange;
    }
  };

  /** ********************************* end scrolling/virtualization ************************************/

  /** ********************************* start dom event handling ***************************************/
  /**
   * Handle the context menu gesture
   * @param {Event} event the event of the context menu gesture
   * @param {string} eventType keyboard/touch/mouse
   * @param {Function} callback where to pass the data back
   */
  DvtDataGrid.prototype.handleContextMenuGesture = function (event, eventType, callback) {
    let index;
    let capabilities;
    let launcher;

    const disable = 'disable';
    // if we are on a touch device and in a cell we need to set the correct active
    // and call focus before triggering the context menu to open. headers take
    // care of this by setting active in the 300ms callback for tap+short hold
    const target = /** @type {Element} */ (event.originalEvent.target);
    let isHeader = false;
    let isLabel = false;
    let isCell = false;

    let element = this.findCell(target);
    if (element) {
      isCell = true;
    }

    if (element === null) {
      element = this.findHeader(target);
      if (element) {
        isHeader = true;
      }
    }

    if (element === null) {
      element = this.findLabel(target);
      if (element) {
        isLabel = true;
      }
    }

    if (eventType === 'touch' && element != null) {
      index = isHeader ? this.getHeaderCellIndex(element) : this.getCellIndexes(element);
      let insideSelection = isHeader
        ? this._isHeaderInsideSelection(index, this.getHeaderCellAxis(element))
        : this._isContainSelection(index);
      // if right click and inside multiple selection or current active do not change anything
      if (
        !this.isMultipleSelection() ||
        !insideSelection ||
        (this._isDatabodyCellActive() &&
          index.row !== this.m_active.indexes.row &&
          index.column !== this.m_active.indexes.column)
      ) {
        if (this._isSelectionEnabled()) {
          this.handleDatabodyClickSelection(event.originalEvent);
        } else {
          // activate on a tap
          this.handleDatabodyClickActive(event.originalEvent);
        }
      }
    }

    // first check if we are invoking on an editable or clickable element, if so bail
    if (this.m_utils._isNodeEditableOrClickable(target, this.m_root)) {
      return;
    }

    // enable and disable context menu items depending on capability of the datasource and options
    // if the action was performed on a cell
    if (element && isCell) {
      index = this.getCellIndexes(element);
      // if fired from inside a multiple selection
      if (this.isMultipleSelection() && this._isContainSelection(index)) {
        launcher = this._getActiveElement();
        // if there is an active cell we want that to be the launcher of the context menu so
        // that focus can be restored to it. If it fired form the keyboard open with launcher and context
        // of the active cell, if right click or touch open with the context of the clicked cell
        if (this._isDatabodyCellActive()) {
          // handle the case where the active element is no longer rendered (ie scrolled off viewport in virtual scroll)
          // we may have focus loss in this case on escape key but the context menu will open. alternative is to do
          // work that anytime focus scrolls off the screen the root node becomes focusable and will go back to the active node
          // but this is consistant with current offscreen focus behavior.
          if (launcher == null) {
            launcher = element;
          }
          capabilities = this._getCellCapability(launcher);
        } else {
          // there is the case where header is active and entire row/column selected
          // the launcher will be the active header, and the context of the menu will be relative to the active header
          capabilities = this._getHeaderOrLabelCapability(launcher, element);
        }
      } else {
        // open on the cell with its context
        launcher = element;
        capabilities = this._getCellCapability(launcher);
      }
      if (this.m_selectionFrontier && this.m_selectionFrontier.axis === 'row') {
        capabilities.resizeWidth = disable;
      } else if (this.m_selectionFrontier && this.m_selectionFrontier.axis === 'column') {
        capabilities.resizeHeight = disable;
      }
    } else if (element && (isHeader || isLabel)) {
      capabilities = this._getHeaderOrLabelCapability(element);
      const axis = this.getHeaderCellAxis(element);
      if (
        (axis === 'column' || axis === 'columnEnd') &&
        this.m_selectionFrontier &&
        this.m_selectionFrontier.axis === 'column'
      ) {
        capabilities.resizeHeight = disable;
      } else if (
        (axis === 'row' || axis === 'rowEnd') &&
        this.m_selectionFrontier &&
        this.m_selectionFrontier.axis === 'row'
      ) {
        capabilities.resizeWidth = disable;
      }
      launcher = element;
    } else {
      // not a header, cell, or label so don't do anything
      capabilities = {
        resize: disable,
        resizeWidth: disable,
        resizeHeight: disable,
        sortRow: disable,
        sortCol: disable,
        cut: disable,
        paste: disable,
        sortColAsc: disable,
        sortColDsc: disable,
        sortRowAsc: disable,
        sortRowDsc: disable,
        filterCol: disable
      };
      launcher = element;
    }

    callback.call(null, { capabilities: capabilities, launcher: launcher }, event, eventType);
  };
  /**
   * Get the capabilities for context menu opened on a cell
   * @param {Element} cell the cell whose context we want
   * @return {Object} capabilities object with props resize, resizeWidth, resizeHeight, sortRow, sortCol, cut, paste
   * @private
   */
  DvtDataGrid.prototype._getCellCapability = function (cell) {
    let sameColumn = true;
    let sameRow = true;
    const disable = 'disable';
    const enable = 'enable';
    const capabilities = {
      resize: disable,
      resizeWidth: disable,
      resizeHeight: disable,
      sortRow: disable,
      sortCol: disable,
      cut: disable,
      cutCells: disable,
      copyCells: disable,
      paste: disable,
      pasteCells: disable,
      autoFill: disable,
      sortColAsc: disable,
      sortColDsc: disable,
      sortRowAsc: disable,
      sortRowDsc: disable,
      freezeRow: disable,
      freezeCol: disable,
      unfreezeRow: disable,
      unfreezeCol: disable,
      hideCol: disable,
      unhideCol: disable,
      hideRow: disable,
      unhideRow: disable,
      filterCol: disable,
      resizeFitToContent: enable
    };

    if (this.m_options.isCopyEnabled()) {
      capabilities.copyCells = enable;
    }
    if (this.m_options.isCutEnabled()) {
      capabilities.cutCells = enable;
    }
    if (this.m_options.isPasteEnabled()) {
      capabilities.pasteCells = enable;
    }
    const selection = this.m_selection;
    const selectionType = this.m_options.options.selectionMode;
    const cellSelection = selectionType.cell;
    const rowSelection = selectionType.row;
    if (cellSelection === 'single' || (cellSelection === 'none' && rowSelection === 'none')) {
      capabilities.resizeFitToContent = disable;
    } else {
      const selectedHeaders = new Set();
      this._populateSelectedHeaderSet(selectedHeaders);
      if (selectedHeaders.size === 0) {
        capabilities.resizeFitToContent = disable;
      }
    }

    let multipleCellsInSelection = false;

    if (!this.m_discontiguousSelection && selection && selection.length === 1) {
      const startRow = selection[0].startIndex.row;
      const startColumn = selection[0].startIndex.column;
      const endRow = selection[0].endIndex.row;
      const endColumn = selection[0].endIndex.column;
      if (startRow !== endRow || startColumn !== endColumn) {
        multipleCellsInSelection = true;
      }
    }
    if (this.m_options.isFloodFillEnabled() && multipleCellsInSelection) {
      capabilities.autoFill = enable;
    }

    const context = this.getResources().getMappedAttribute('context');
    if (this.m_options.isFreezeEnabled('column')) {
      capabilities.freezeCol = enable;
      if (cell[context].indexes.column === this.m_frozenColIndex) {
        capabilities.freezeCol = disable;
      }
      capabilities.unfreezeCol = disable;
      if (this._hasFrozenColumns()) {
        capabilities.unfreezeCol = enable;
      }
    }

    if (this.m_options.isHideEnabled('row')) {
      const returnObj = this._getCellHidabilityContextMenuCapability(cell, 'row');
      if (returnObj.canHide) {
        capabilities.hideRow = enable;
      }
      if (returnObj.canUnhide) {
        capabilities.unhideRow = enable;
      }
    }

    if (this.m_options.isHideEnabled('column')) {
      const returnObj = this._getCellHidabilityContextMenuCapability(cell, 'column');
      if (returnObj.canHide) {
        capabilities.hideCol = enable;
      }
      if (returnObj.canUnhide) {
        capabilities.unhideCol = enable;
      }
    }

    if (this.m_options.isFreezeEnabled('row')) {
      capabilities.freezeRow = enable;
      if (cell[context].indexes.row === this.m_frozenRowIndex) {
        capabilities.freezeRow = disable;
      }
      capabilities.unfreezeRow = disable;
      if (this._hasFrozenRows()) {
        capabilities.unfreezeRow = enable;
      }
    }
    const rowHeader = this.getHeaderFromCell(cell, 'row');
    const columnHeader = this.getHeaderFromCell(cell, 'column');
    const resizable = this.getResources().getMappedAttribute('resizable');
    const sortable = this.getResources().getMappedAttribute('sortable');

    if (columnHeader != null && sameColumn) {
      if (columnHeader.getAttribute(resizable) === 'true') {
        capabilities.resize = enable;
        capabilities.resizeWidth = enable;
      }
      if (columnHeader.getAttribute(sortable) === 'true') {
        capabilities.sortCol = enable;
        capabilities.sortColAsc = enable;
        capabilities.sortColDsc = enable;
        const sorted = columnHeader.getAttribute(this.getResources().getMappedAttribute('sortDir'));
        if (sorted === 'ascending') {
          capabilities.sortColAsc = disable;
        } else if (sorted === 'descending') {
          capabilities.sortColDsc = disable;
        }
      }
    }
    if (rowHeader != null && sameRow) {
      if (this._isMoveEnabled('row')) {
        capabilities.cut = enable;
        capabilities.paste = enable;
      }
      if (rowHeader.getAttribute(sortable) === 'true') {
        capabilities.sortRow = enable;
        capabilities.sortRowAsc = enable;
        capabilities.sortRowDsc = enable;
      }
      if (rowHeader != null) {
        if (rowHeader.getAttribute(resizable) === 'true') {
          capabilities.resize = enable;
          capabilities.resizeHeight = enable;
        }
        if (rowHeader.getAttribute(sortable) === 'true') {
          capabilities.sortRow = enable;
        }
      }
    }
    return capabilities;
  };

  /**
   * Get the capabilities for context menu opened on a element
   * @param {Element} element header or label whose context we want
   * @return {Object} capabilities object with props resizeWidth, resizeHeight, sortRow, sortCol
   * @private
   */
  DvtDataGrid.prototype._getHeaderOrLabelCapability = function (element) {
    let sameColumn = true;
    let sameRow = true;
    const disable = 'disable';
    const enable = 'enable';
    const isLabel = this.findLabel(element);
    const capabilities = {
      resize: disable,
      resizeWidth: disable,
      resizeHeight: disable,
      sortRow: disable,
      sortCol: disable,
      cut: disable,
      paste: disable,
      sortColAsc: disable,
      sortColDsc: disable,
      sortRowAsc: disable,
      sortRowDsc: disable,
      freezeRow: disable,
      freezeCol: disable,
      unfreezeRow: disable,
      unfreezeCol: disable,
      hideCol: disable,
      unhideCol: disable,
      hideRow: disable,
      unhideRow: disable,
      filterCol: disable,
      resizeFitToContent: enable
    };

    const axis = this.getHeaderCellAxis(element) || this.getHeaderLabelAxis(element);
    const resizable = this.getResources().getMappedAttribute('resizable');
    const sortable = this.getResources().getMappedAttribute('sortable');
    const filterable = this.getResources().getMappedAttribute('filterable');
    const context = this.getResources().getMappedAttribute('context');
    if (element !== null) {
      if ((axis === 'column' || axis === 'columnEnd') && sameColumn) {
        if (element.getAttribute(resizable) === 'true') {
          capabilities.resizeWidth = enable;
          capabilities.resize = enable;
        }
        capabilities.resizeHeight = this.m_options.isResizable(axis, 'height');
        if (element.getAttribute(sortable) === 'true' && !isLabel) {
          capabilities.sortCol = enable;
          capabilities.sortColAsc = enable;
          capabilities.sortColDsc = enable;
          var sorted = element.getAttribute(this.getResources().getMappedAttribute('sortDir'));
          if (sorted === 'ascending') {
            capabilities.sortColAsc = disable;
          } else if (sorted === 'descending') {
            capabilities.sortColDsc = disable;
          }
        }
        if (element.getAttribute(sortable) === 'true' && isLabel) {
          capabilities.sortRow = enable;
          capabilities.sortRowAsc = enable;
          capabilities.sortRowDsc = enable;
          let labelSortDir = element.getAttribute(this.getResources().getMappedAttribute('sortDir'));
          if (labelSortDir === 'ascending') {
            capabilities.sortRowAsc = disable;
          } else if (labelSortDir === 'descending') {
            capabilities.sortRowDsc = disable;
          }
        }
        if (this.m_options.isFreezeEnabled('column') && !isLabel) {
          capabilities.freezeCol = enable;
          if (element[context].index === this.m_frozenColIndex) {
            capabilities.freezeCol = disable;
          }
          capabilities.unfreezeCol = disable;
          if (this._hasFrozenColumns()) {
            capabilities.unfreezeCol = enable;
          }
        }
        if (isLabel && this.m_options._isLabelCutEnabled()) {
          capabilities.cutCells = enable;
        }
        if (element.getAttribute(filterable) === 'true') {
          capabilities.filterCol = enable;
        }
      } else if (sameRow) {
        if (this._isMoveEnabled('row')) {
          capabilities.cut = enable;
          capabilities.paste = enable;
        }
        if (element.getAttribute(resizable) === 'true') {
          capabilities.resize = enable;
          capabilities.resizeHeight = enable;
        }
        capabilities.resizeWidth = this.m_options.isResizable(axis, 'width');
        if (element.getAttribute(sortable) === 'true' && !isLabel) {
          capabilities.sortRow = enable;
          capabilities.sortRowAsc = enable;
          capabilities.sortRowDsc = enable;
          let isRowSorted = element.getAttribute(this.getResources().getMappedAttribute('sortDir'));
          if (isRowSorted === 'ascending') {
            capabilities.sortRowAsc = disable;
          } else if (isRowSorted === 'descending') {
            capabilities.sortRowDsc = disable;
          }
        }
        if (element.getAttribute(sortable) === 'true' && isLabel) {
          capabilities.sortCol = enable;
          capabilities.sortColAsc = enable;
          capabilities.sortColDsc = enable;
          let labelSortDir = element.getAttribute(this.getResources().getMappedAttribute('sortDir'));
          if (labelSortDir === 'ascending') {
            capabilities.sortColAsc = disable;
          } else if (labelSortDir === 'descending') {
            capabilities.sortColDsc = disable;
          }
        }
        if (this.m_options.isFreezeEnabled('row') && !isLabel) {
          capabilities.freezeRow = enable;
          if (element[context].index === this.m_frozenRowIndex) {
            capabilities.freezeRow = disable;
          }
          capabilities.unfreezeRow = disable;
          if (this._hasFrozenRows()) {
            capabilities.unfreezeRow = enable;
          }
        }
        if (isLabel && this.m_options._isLabelCutEnabled()) {
          capabilities.cutCells = enable;
        }
      }

      if (this.m_options.isHideEnabled(axis)) {
        const returnObj = this._getHeaderHidabilityContextMenuCapability(element, axis);
        if (returnObj.canHide) {
          if (axis === 'column' || axis === 'columnEnd') {
            capabilities.hideCol = enable;
          } else if (axis === 'row' || axis === 'rowEnd') {
            capabilities.hideRow = enable;
          }
        }
        if (returnObj.canUnhide) {
          if (axis === 'column' || axis === 'columnEnd') {
            capabilities.unhideCol = enable;
          } else if (axis === 'row' || axis === 'rowEnd') {
            capabilities.unhideRow = enable;
          }
        }
      }
    }
    capabilities.resize =
      capabilities.resizeHeight === enable || capabilities.resizeWidth === enable ? enable : disable;

    return capabilities;
  };

  /**
   * Handle the callback from the widget to resize or sort.
   * @param {Event} event - the original contextmenu event
   * @param {string} id - the id returned from the context menu
   * @param value - the value set in the dialog on resizing
   */
  DvtDataGrid.prototype.handleContextMenuReturn = function (event, id, value) {
    var target;
    var direction;

    // the target is the active element at all times
    if (this.m_active != null) {
      target = this._getActiveElement();
    }

    if (
      id === this.m_resources.getMappedCommand('resizeHeight') ||
      id === this.m_resources.getMappedCommand('resizeWidth')
    ) {
      if (this.isResizeEnabled()) {
        // target may not be (event.target)
        this.handleContextMenuResize(event, id, value, target);
      }
    } else if (id === this.m_resources.getMappedCommand('resizeFitToContent')) {
      let element = this.findCell(event.target);
      if (!element) {
        element = this.findHeader(event.target);
      }
      if (!element) {
        element = this.findLabel(event.target);
      }
      if (element) {
        this.m_resizingElement = element;
      }

      if (this.isResizeEnabled()) {
        this._getHeadersForResizeFitToContent(event);
      }
    } else if (
      id === this.m_resources.getMappedCommand('sortColAsc') ||
      id === this.m_resources.getMappedCommand('sortColDsc')
    ) {
      direction = id === this.m_resources.getMappedCommand('sortColAsc') ? 'ascending' : 'descending';
      if (this.m_utils.containsCSSClassName(target, this.getMappedStyle('cell'))) {
        target = this.getHeaderFromCell(target, 'column');
      }
      if (this._isDOMElementSortable(target)) {
        if (this.m_utils.containsCSSClassName(target, this.getMappedStyle('headerlabel'))) {
          this._handleHeaderLabelSort(target, this.findLabel(target), direction);
        } else {
          this._handleCellSort(event, direction, target);
        }
      }
    } else if (
      id === this.m_resources.getMappedCommand('sortRowAsc') ||
      id === this.m_resources.getMappedCommand('sortRowDsc')
    ) {
      direction = id === this.m_resources.getMappedCommand('sortRowAsc') ? 'ascending' : 'descending';
      if (this.m_utils.containsCSSClassName(target, this.getMappedStyle('cell'))) {
        target = this.getHeaderFromCell(target, 'row');
      }
      if (this._isDOMElementSortable(target)) {
        if (this.m_utils.containsCSSClassName(target, this.getMappedStyle('headerlabel'))) {
          this._handleHeaderLabelSort(target, this.findLabel(target), direction);
        } else {
          this._handleCellSort(event, direction, target);
        }
      }
    } else if (id === this.m_resources.getMappedCommand('cut')) {
      this._handleCut(event, target);
    } else if (id === this.m_resources.getMappedCommand('paste')) {
      this._handlePaste(event, target);
    } else if (id === this.m_resources.getMappedCommand('cutCells')) {
      this._handleCutCells(event, target);
    } else if (id === this.m_resources.getMappedCommand('copyCells')) {
      this._handleCopyCells(event, target);
    } else if (id === this.m_resources.getMappedCommand('pasteCells')) {
      this._handlePasteCells(event, target);
    } else if (id === this.m_resources.getMappedCommand('autoFill')) {
      this._handleAutofill(event, target);
    } else if (id === this.m_resources.getMappedCommand('discontiguousSelection')) {
      // handle discontiguous selection context menu
      this.setDiscontiguousSelectionMode(value);
    } else if (id === this.m_resources.getMappedCommand('freezeRow')) {
      this._handleFreezeRow(event, target);
    } else if (id === this.m_resources.getMappedCommand('freezeCol')) {
      this._handleFreezeCol(event, target);
    } else if (id === this.m_resources.getMappedCommand('unfreezeCol')) {
      this._handleUnFreeze('column', event);
    } else if (id === this.m_resources.getMappedCommand('unfreezeRow')) {
      this._handleUnFreeze('row', event);
    } else if (id === this.m_resources.getMappedCommand('hideCol')) {
      this._handleHideAxis(event, 'column');
    } else if (id === this.m_resources.getMappedCommand('unhideCol')) {
      this._handleUnhideAxis(event, 'column');
    } else if (id === this.m_resources.getMappedCommand('hideRow')) {
      this._handleHideAxis(event, 'row');
    } else if (id === this.m_resources.getMappedCommand('unhideRow')) {
      this._handleUnhideAxis(event, 'row');
    } else if (id === this.m_resources.getMappedCommand('filterCol')) {
      this._handleHeaderFilter(event, 'column');
    }
  };

  /**
   * Determined if sort is supported for the specified axis.
   * @param {string} axis the axis which we check whether sort is supported.
   * @param {Object} context headerContext | labelContext  the header/label context object
   * @param {boolean} isLabel true if label
   * @private
   */
  DvtDataGrid.prototype._isSortEnabled = function (axis, context, isLabel = false) {
    var capability = this.getDataSource().getCapability('sort');
    let sortable = this.m_options.isSortable(axis, context, isLabel);
    if (
      (sortable === 'enable' || sortable === 'auto') &&
      (capability === 'full' || capability === axis)
    ) {
      if (this._isDataGridProvider()) {
        if (context.metadata.sortDirection != null) {
          return true;
        }
        return false;
      }

      return true;
    }

    return false;
  };

  /**
   * Checks if an element is a parentNode of a traditional hierarchy.
   * @param {Object} headerContext the header context object
   * @private
   */
  DvtDataGrid.prototype._isParentNode = function (headerContext) {
    if (this._isDataGridProvider()) {
      return headerContext.metadata.expanded && headerContext.metadata.expanded !== null;
    }
    return false;
  };

  DvtDataGrid.prototype._isRequired = function (headerContext) {
    if (this._isDataGridProvider()) {
      return headerContext.metadata.showRequired === true;
    }
    return false;
  };

  DvtDataGrid.prototype._isFilterEnabled = function (axis, headerContext) {
    const filterable = this.m_options.isFilterEnabled(axis, headerContext);
    if (filterable !== 'disable' && this._isDataGridProvider()) {
      return headerContext.metadata.filter != null;
    }
    return false;
  };

  /**
   * Checks if an element is a parentNode of a hierarichal group.
   * @param {Object} headerContext the header context object
   * @private
   */
  DvtDataGrid.prototype._isHierarchicalGroup = function (headerContext) {
    return headerContext.metadata.treeDepth == null;
  };

  /**
   * Checks if an element is a leafNode of a traditional hierarchy.
   * @param {Object} headerContext the header context object
   * @private
   */
  DvtDataGrid.prototype._isLeafNode = function (headerContext) {
    if (!headerContext.metadata) {
      return false;
    }
    const treeDepth = headerContext.metadata.treeDepth;
    if (this._isDataGridProvider()) {
      return treeDepth != null && treeDepth !== 0;
    }
    return false;
  };

  /**
   * Determined if sort is supported for the specified element.
   * @param {Element|undefined} element to check if sorting should be on
   * @private
   */
  DvtDataGrid.prototype._isDOMElementSortable = function (element) {
    if (element == null) {
      return false;
    }
    let elem = this.findHeader(element) || this.findLabel(element);
    if (elem == null) {
      return false;
    }
    return elem.getAttribute(this.getResources().getMappedAttribute('sortable')) === 'true';
  };

  /**
   * Check if selection enabled by options on the grid
   * @return {boolean} true if selection enabled
   * @private
   */
  DvtDataGrid.prototype._isSelectionEnabled = function () {
    return this.m_options.getSelectionCardinality() !== 'none';
  };

  /**
   * Check whether multiple row/cell selection is allowed by options on the grid
   * @return {boolean} true if multipl selection enabled
   */
  DvtDataGrid.prototype.isMultipleSelection = function () {
    return this.m_options.getSelectionCardinality() === 'multiple';
  };

  /**
   * Check if resizing enabled on any header by options on the grid
   * @return {boolean} true if resize enabled
   */
  DvtDataGrid.prototype.isResizeEnabled = function () {
    return (
      this.m_options.isResizable('row', 'width') ||
      this.m_options.isResizable('row', 'height') ||
      this.m_options.isResizable('column', 'width') ||
      this.m_options.isResizable('column', 'height') ||
      this.m_options.isResizable('rowEnd', 'width') ||
      this.m_options.isResizable('rowEnd', 'height') ||
      this.m_options.isResizable('columnEnd', 'width') ||
      this.m_options.isResizable('columnEnd', 'height')
    );
  };

  /**
   * Check if resizing enabled on a specific header
   * @param {string} axis the axis which we check whether sort is supported.
   * @param {Object} headerContext the header context object
   * @return {boolean} true if resize enabled
   */
  DvtDataGrid.prototype._isHeaderResizeEnabled = function (axis, headerContext) {
    var resizable;
    if (axis === 'column' || axis === 'columnEnd') {
      resizable = this.m_options.isResizable(axis, 'width', headerContext);
      return resizable === 'enable';
    } else if (axis === 'row' || axis === 'rowEnd') {
      resizable = this.m_options.isResizable(axis, 'height', headerContext);
      return resizable === 'enable';
    }
    return false;
  };

  /**
   * Handle mousemove events on the document
   * @param {Event} event - mousemove event on the document
   */
  DvtDataGrid.prototype.handleMouseMove = function (event) {
    if (this.isResizeEnabled() && this.m_databodyDragState === false) {
      this.handleResize(event);
    }
  };

  /**
   * Handle row header mousemove events on the document
   * @param {Event} event - mousemove event on the document
   */
  DvtDataGrid.prototype.handleRowHeaderMouseMove = function (event) {
    if (event.buttons === 0) {
      this.handleMouseUp(event);
    }
    if (this.m_databodyMove && !this._isDataGridProvider()) {
      this._handleMove(event);
    } else if (
      this.m_headerDragState &&
      ((this.m_selectionFrontier &&
        this.m_selectionFrontier.axis &&
        this.m_selectionFrontier.axis.indexOf('row') !== -1) ||
        (this.m_deselectInfo &&
          this.m_deselectInfo.axis &&
          this.m_deselectInfo.axis.indexOf('row') !== -1))
    ) {
      this.extendSelectionHeader(event.target, event, true, this.m_deselectInProgress);
    } else if (!this.m_isResizing) {
      // if it is resizing use the mouse move on the document
      this.handleMouseMove(event);
    }
  };

  /**
   * Handle row header mousemove events on the document
   * @param {Event} event - mousemove event on the document
   */
  DvtDataGrid.prototype.handleColumnHeaderMouseMove = function (event) {
    if (event.buttons === 0) {
      this.handleMouseUp(event);
    }
    if (
      this.m_headerDragState &&
      ((this.m_selectionFrontier &&
        this.m_selectionFrontier.axis &&
        this.m_selectionFrontier.axis.indexOf('column') !== -1) ||
        (this.m_deselectInfo &&
          this.m_deselectInfo.axis &&
          this.m_deselectInfo.axis.indexOf('column') !== -1))
    ) {
      this.extendSelectionHeader(event.target, event, true, this.m_deselectInProgress);
    } else if (!this.m_isResizing) {
      // if it is resizing use the mouse move on the document
      this.handleMouseMove(event);
    }
  };

  DvtDataGrid.prototype.handleHeaderLabelMouseMove = function (event) {
    if (!this.m_isResizing) {
      // if it is resizing use the mouse move on the document
      this.handleMouseMove(event);
    }
  };

  /**
   * Handle mousedown events on the headers
   * @param {Event} event - mousedown event on the headers
   */
  DvtDataGrid.prototype.handleHeaderMouseDown = function (event) {
    // removing hidden column indicator in databody after hiding a column
    // on mousedown on headers
    this.deleteDatabodyHiddenVisualIndicators();
    var processed;

    const header = this.findHeader(event.target);
    if (header == null) {
      return;
    }

    this.m_shouldFocus = false;

    var target = /** @type {Element} */ (event.target);
    const activeElement = this._getActiveElement();

    if (this._isEditOrEnter()) {
      if (this._leaveEditing(event, activeElement, false) === false) {
        return;
      }
    }

    var selectionMode = this.m_options.getSelectionMode();
    // only perform events on left mouse, (right in rtl culture)
    if (event.button === 0) {
      // if mousedown in an icon it the click event will handle mousedown/up
      if (this._isSortIcon(target) && this._isDOMElementSortable(target)) {
        this.handleHeaderClickActive(event, null, true);
        this._handleSortIconMouseDown(target, header);
        return;
      } else if (this._isFilterIcon(target) && this._isDOMElementFilterable(target)) {
        this.handleHeaderClickActive(event, null, true);
        return;
      } else if (this._isDisclosureIcon(target)) {
        this.handleHeaderClickActive(event, null, true);
        return;
      }
      // handle resize movements first if we're on the border
      if (this.isResizeEnabled()) {
        processed = this.handleResizeMouseDown(event);
        this._highlightResizeMouseDown();
      }

      // if our move is enabled make sure our row has the active cell in it
      var ctrlKey = this.m_utils.ctrlEquivalent(event);
      if (
        !this._isDataGridProvider() &&
        !this.m_isResizing &&
        !ctrlKey &&
        this._isMoveOnElementEnabled(this.findHeader(target))
      ) {
        this.m_databodyMove = true;
        this.m_currentX = event.pageX;
        this.m_currentY = event.pageY;
        processed = true;
      }

      let axis = this.getHeaderCellAxis(header);

      if (this.m_utils.containsCSSClassName(header, this.getMappedStyle('draggableItem'))) {
        this.m_utils.addCSSClassName(header, this.getMappedStyle('dragging'));
      }

      if (
        this._isDataGridProvider() &&
        this.m_options._isDragEnabled(axis) &&
        this.shouldHoverHeader(header) &&
        this.m_selection &&
        this.m_selection.length
      ) {
        if (this._setHeaderDraggable(header)) {
          return;
        }
      }
    }
    // activate header on click or right click
    // checking the cursor value to not change selection on resize cursor.
    if (!this.m_isResizing && this.manageHeaderCursor(event, false) === 'default') {
      if (!this.m_root.contains(document.activeElement) || document.activeElement === this.m_root) {
        this.m_externalFocus = true;
      }

      var cellContext = header[this.getResources().getMappedAttribute('context')];

      // if click or right click we want to adjust the selction
      // no else so that we can select a cell in the same row as long as no drag
      // check if selection is enabled
      if (
        this._isSelectionEnabled() &&
        this.isMultipleSelection() &&
        !(selectionMode === 'row' && cellContext.axis.indexOf('row') === -1) &&
        !this.m_databodyMove
      ) {
        // only allow drag on left click
        if (event.button === 0) {
          this.m_headerDragState = true;
        }

        this.handleHeaderClickSelection(event);
      } else if (
        selectionMode === 'row' &&
        cellContext.axis.indexOf('row') !== -1 &&
        this._isSelectionEnabled()
      ) {
        // for single row based selection only
        this.handleHeaderClickSelection(event);
      } else {
        // remove current selection and just make header active.
        this.handleHeaderClickActive(event);
      }
    }

    if (this.m_options.isFloodFillEnabled()) {
      if (this.m_bottomFloodFillIconContainer && this.m_bottomFloodFillIconContainer.parentNode) {
        this.m_bottomFloodFillIconContainer.parentNode.removeChild(
          this.m_bottomFloodFillIconContainer
        );
        this.m_bottomFloodFillIconContainer.removeEventListener(
          'mouseover',
          this.handleDatabodyMouseMove
        );
      }
    }

    if (processed === true) {
      event.preventDefault();
    }
  };

  DvtDataGrid.prototype.handleHeaderLabelMouseDown = function (event) {
    var processed;
    // headerLabelmousedown is attached on corner as well.
    // Disabling resize on mousedown on empty corner cell.
    const label = this.find(event.target, 'headerlabel');
    const context = this.getResources().getMappedAttribute('context');
    if (event.button === 0) {
      if (this._isSortIcon(event.target) && this._isDOMElementSortable(event.target)) {
        this._handleSortIconMouseDown(event.target, label);
        this._handleHeaderLabelSort(event, label);
      }
    }
    if (label && this.m_options._isDragEnabledOnLabel(label[context].axis)) {
      label.setAttribute('draggable', true);
    }
    if (label && this.isResizeEnabled()) {
      processed = this.handleResizeMouseDown(event);
      this._highlightResizeMouseDown();
    }
    if (processed === true) {
      event.preventDefault();
    }
  };

  /**
   * Handle mouseup events on the document
   * @param {Event} event - mouseup event on the document
   */
  DvtDataGrid.prototype.handleMouseUp = function (event) {
    // toggle off the drag state
    this.m_headerDragState = false;
    this.m_databodyDragState = false;
    this.m_deselectInProgress = false;

    // if we mouseup outside the grid we want to cancel the selection and return the row
    if (this.m_databodyMove) {
      this._handleMoveMouseUp(event, false);
    } else if (this.isResizeEnabled()) {
      this.handleResizeMouseUp(event);
    }

    this.m_databodyMove = false;
  };

  DvtDataGrid.prototype.shouldHoverHeader = function (header) {
    const headerAxis = header == null ? null : this.getHeaderCellAxis(header);
    const headerLevel = header === null ? null : this.getHeaderCellLevel(header);
    const isRow = headerAxis === 'row' || headerAxis === 'rowEnd';
    const selectionMode = this.m_options.getSelectionMode();
    return (
      this._isSelectionEnabled() &&
      ((this.isMultipleSelection() && selectionMode === 'cell') ||
        (selectionMode === 'row' &&
          isRow &&
          (this.isMultipleSelection() ||
            (headerLevel !== null && headerLevel === this.m_rowHeaderLevelCount - 1))))
    );
  };

  DvtDataGrid.prototype.handleHeaderMouseOver = function (event) {
    var target = /** @type {Element} */ (event.target);
    var header = this.findHeader(target);
    // on mouse over header icons should be visible
    if (this._isDOMElementSortable(event.target)) {
      const sortContainer = this._getSortContainer(header);
      if (sortContainer) {
        sortContainer.classList.remove(this.getMappedStyle('iconHidden'));
      }
    }
    if (this._isDOMElementFilterable(event.target)) {
      const filterContainer = this._getFilterContainer(header);
      if (filterContainer) {
        filterContainer.classList.remove(this.getMappedStyle('iconHidden'));
      }
    }
    if (
      !this.m_isResizing &&
      this.manageHeaderCursor(event, false) === 'default' &&
      this.shouldHoverHeader(header)
    ) {
      this.m_utils.addCSSClassName(header, this.getMappedStyle('hover'));
    }
    let axis = this.getHeaderCellAxis(header);
    if (
      this._isDataGridProvider() &&
      this.shouldHoverHeader(header) &&
      this.m_options._isDragEnabled(axis) &&
      this.m_selection &&
      this.m_selection.length
    ) {
      this._setHeaderDraggable(header);
    }
  };

  DvtDataGrid.prototype.handleHeaderMouseOut = function (event) {
    var target = /** @type {Element} */ (event.target);
    this.m_utils.removeCSSClassName(this.findHeader(target), this.getMappedStyle('hover'));
    if (!this.m_isResizing && this.m_resizingElement) {
      this.m_resizingElement.style.cursor = '';
      if (this.m_resizingElementSibling != null) {
        this.m_resizingElementSibling.style.cursor = '';
      }
    }
    if (this._isDOMElementSortable(event.target)) {
      this._handleSortMouseOut(event);
    }
    if (this._isDOMElementFilterable(event.target)) {
      this._handleFilterMouseOut(event);
    }
  };

  /**
   * Event handler for when header mouse up event
   * @protected
   * @param {Event} event - header mouse up event
   */
  DvtDataGrid.prototype.handleHeaderMouseUp = function (event) {
    // handle anchor change while in header drag mode
    this.handleDragAnchorChange(event);

    // toggle off the drag state
    this.m_headerDragState = false;
    this.m_databodyDragState = false;
    this.m_deselectInProgress = false;

    if (this.m_floodFillDragState) {
      this.unhighlightFloodFillRange();
      this.m_selectionRange = null;
      this.m_floodFillRange = null;
      this.m_floodFillDirection = null;
      this.m_databody.style.cursor = 'default';
      this.m_cursor = 'default';
    }
    if (this.m_databodyMove) {
      this._handleMoveMouseUp(event, true);
    }

    let header = this.findHeader(event.target);
    let axis = this.getHeaderCellAxis(header);

    if (
      this._isDataGridProvider() &&
      this.m_options._isDragEnabled(axis) &&
      this.shouldHoverHeader(header) &&
      this.m_selection &&
      this.m_selection.length
    ) {
      this._setHeaderDraggable(header);
    }

    if (this.m_utils.containsCSSClassName(header, this.getMappedStyle('dragging'))) {
      this.m_utils.removeCSSClassName(header, this.getMappedStyle('dragging'));
    }
  };

  DvtDataGrid.prototype.handleCornerMouseDown = function (event) {
    this.deleteDatabodyHiddenVisualIndicators();
    let target = /** @type {Element} */ (event.target);
    let end =
      this.m_utils.containsCSSClassName(target, this.getMappedStyle('rowendheaderlabel')) ||
      this.m_utils.containsCSSClassName(target, this.getMappedStyle('columnendheaderlabel'));
    let label = this.findLabel(target);
    let clearSelection;
    if (label != null) {
      clearSelection = end; // endlabels to clear selection.
      if (this.m_options._isDragEnabledOnLabel()) {
        clearSelection = true;
      }
      this._setActive(label, this._createActiveObject(label), event, clearSelection);
      if (!this._isSortIcon(event.target)) {
        this.handleHeaderLabelMouseDown(event);
      }
    }
  };

  DvtDataGrid.prototype.handleCornerMouseOver = function (event) {
    var target = /** @type {Element} */ (event.target);
    let label = this.findLabel(target);
    const context = this.getResources().getMappedAttribute('context');
    if (label && this.m_options._isDragEnabledOnLabel(label[context].axis)) {
      this.m_utils.addCSSClassName(label, this.getMappedStyle('draggableItem'));
      label.setAttribute('draggable', true);
    } else if (this._isSelectionEnabled() && this.isMultipleSelection()) {
      if (label) {
        this.m_utils.addCSSClassName(label, this.getMappedStyle('hover'));
      } else {
        this.m_utils.addCSSClassName(this.find(target, 'topcorner'), this.getMappedStyle('hover'));
      }
    }

    if (this._isDOMElementSortable(target)) {
      const sortContainer = this._getSortContainer(label);
      if (sortContainer) {
        sortContainer.classList.remove(this.getMappedStyle('iconHidden'));
      }
    }

    if (!this.m_isResizing && label !== null) {
      // if it is resizing use the mouse move on the document
      this.handleMouseMove(event);
    }
  };

  DvtDataGrid.prototype.handleCornerMouseMove = function (event) {
    var target = /** @type {Element} */ (event.target);
    let label = this.findLabel(target);
    if (!this.m_isResizing && label !== null) {
      // if it is resizing use the mouse move on the document
      this.handleMouseMove(event);
    }
  };

  DvtDataGrid.prototype.handleCornerMouseOut = function (event) {
    var target = /** @type {Element} */ (event.target);
    let label = this.findLabel(target);
    if (label) {
      if (this._isDOMElementSortable(target)) {
        this._handleSortMouseOut(event);
      }
      this.m_utils.removeCSSClassName(label, this.getMappedStyle('hover'));
      this.m_utils.removeCSSClassName(label, this.getMappedStyle('draggableItem'));
      label.setAttribute('draggable', false);
    } else {
      this.m_utils.removeCSSClassName(this.find(target, 'topcorner'), this.getMappedStyle('hover'));
    }
  };

  /**
   * Event handler for when the top left corner is clicked
   * @protected
   * @param {Event} event - click event on the top left corner
   */
  DvtDataGrid.prototype.handleCornerClick = function (event) {
    this._handleSelectAll(event);
  };

  /**
   * Event handler for when row/column header is clicked
   * @protected
   * @param {Event} event - click event on the headers
   */
  DvtDataGrid.prototype.handleHeaderClick = function (event) {
    var target = /** @type {Element} */ (event.target);
    if (this._isSortIcon(target) && this._isDOMElementSortable(target)) {
      this._removeTouchSelectionAffordance();
      this._handleHeaderSort(event);
      event.preventDefault();
    } else if (this._isFilterIcon(target) && this._isDOMElementFilterable(target)) {
      this._removeTouchSelectionAffordance();
      this._handleHeaderFilter(event);
      event.preventDefault();
    } else if (this._isDisclosureIcon(event.target)) {
      this._removeTouchSelectionAffordance();
      this._handleExpandCollapseRequest(event);
      event.preventDefault();
    }
  };

  /**
   * Event handler for when row/column header is double clicked
   * @protected
   * @param {Event} event - click event on the headers
   */
  DvtDataGrid.prototype.handleHeaderDoubleClick = function (event) {
    // checking if the element exists in the dom on refreshing after the first click
    if (document.contains(event.target)) {
      let isHeaderLabel = false;
      let isColumnHiddenIndicator = this.m_utils.containsCSSClassName(
        event.target,
        this.getMappedStyle('colHeaderHiddenIndicator')
      );
      let isRowHiddenIndicator = this.m_utils.containsCSSClassName(
        event.target,
        this.getMappedStyle('rowHeaderHiddenIndicator')
      );
      let axis;
      if (isColumnHiddenIndicator) {
        axis = 'column';
      } else if (isRowHiddenIndicator) {
        axis = 'row';
      }

      if (isColumnHiddenIndicator || isRowHiddenIndicator) {
        let hiddenIndex = this._getAttribute(event.target, 'hiddenIndicatorIndex', true);
        this._handleUnhideAxis(event, axis, hiddenIndex);
        return;
      }

      // setting this.m_cursor as it would have been reset to default in mouseup.
      this.m_cursor = this.manageHeaderCursor(event, isHeaderLabel);
      let resizeCursor = this.m_cursor === 'col-resize' || this.m_cursor === 'row-resize';
      if (resizeCursor) {
        if (!this.m_resizingElement) {
          this.m_resizingElement = this.findHeader(event.target);
        }

        if (this.isResizeEnabled()) {
          this._getHeadersForResizeFitToContent(event);
        }
      }
    }
  };

  DvtDataGrid.prototype._getHeadersForResizeFitToContent = function (event) {
    let resizingElementAxis = this.getHeaderCellAxis(this.m_resizingElement);
    const context = this.m_resizingElement[this.getResources().getMappedAttribute('context')];
    const selectionAxis = this._getSelectionAxis(resizingElementAxis);
    const headersSet = new Set();
    let isHeader = false;
    let isLabel = false;
    let isCell = false;

    let element = this.findCell(this.m_resizingElement);
    if (element) {
      isCell = true;
    }

    if (element === null) {
      element = this.findHeader(this.m_resizingElement);
      if (element) {
        isHeader = true;
      }
    }

    if (element === null) {
      element = this.findLabel(this.m_resizingElement);
      if (element) {
        isLabel = true;
      }
    }
    if (isHeader) {
      if (
        this._isSelectionEnabled() &&
        this.isMultipleSelection() &&
        this.m_selection.length !== 0 &&
        this._isHeaderSelected(context, selectionAxis)
      ) {
        this.m_selection.forEach((selection) => {
          const selectedHeaders = this._getHeadersWithinSelection(
            selection,
            selection.startIndex[selectionAxis],
            resizingElementAxis
          );
          selectedHeaders.forEach((header) => headersSet.add(header));
        });
      } else {
        headersSet.add(this.m_resizingElement);
      }
    } else if (isLabel) {
      const level = context.level;
      resizingElementAxis = context.axis;
      const cells = this._getHeadersByLevel(resizingElementAxis, level);
      if (cells.length > 0) {
        this.handleResizeFitToContent(event, cells[0], isLabel, cells);
      }
      return;
    } else if (isCell) {
      this._populateSelectedHeaderSet(headersSet);
    }
    headersSet.forEach((header) => {
      this.handleResizeFitToContent(event, header, isLabel);
    });
  };

  /**
   * Based on selection state will add every selected header to set.
   * @return {Set} headerSet
   */
  DvtDataGrid.prototype._populateSelectedHeaderSet = function (headersSet) {
    const selectionType = this.m_options.options.selectionMode;
    const cellSelection = selectionType.cell;
    this.m_selection.forEach((selection) => {
      const selectedHeaders = this._getHeadersWithinSelection(
        selection,
        selection.startIndex.row,
        'row'
      );
      selectedHeaders.forEach((header) => headersSet.add(header));
    });
    if (cellSelection === 'multiple') {
      this.m_selection.forEach((selection) => {
        const selectedHeaders = this._getHeadersWithinSelection(
          selection,
          selection.startIndex.column,
          'column'
        );
        selectedHeaders.forEach((header) => headersSet.add(header));
      });
    }
  };

  /**
   * Method that returns headers by a given level and axis.
   * @return {string} axis - (row, column)
   * @return {number} level
   * @return {Array} headers - click event on the headers
   */
  DvtDataGrid.prototype._getHeadersByLevel = function (axis, level) {
    const headers =
      axis === 'column'
        ? this.m_root.querySelectorAll(
            `.${this.getMappedStyle('colheadercell')},.${this.getMappedStyle('colendheadercell')}`
          )
        : this.m_root.querySelectorAll(
            `.${this.getMappedStyle('rowheadercell')},.${this.getMappedStyle('rowendheadercell')}`
          );

    return [...headers].filter(
      (header) => header[this.getResources().getMappedAttribute('context')].level === level
    );
  };

  DvtDataGrid.prototype._getHeadersWithinSelection = function (
    selection,
    resizingElementIndex,
    resizingElementAxis
  ) {
    let headers = [];
    let headerLevel;
    let genericAxis;
    if (resizingElementAxis === 'column') {
      headerLevel = this.m_columnHeaderLevelCount - 1;
      genericAxis = 'column';
    } else if (resizingElementAxis === 'columnEnd') {
      headerLevel = this.m_columnEndHeaderLevelCount - 1;
      genericAxis = 'column';
    } else if (resizingElementAxis === 'row') {
      headerLevel = this.m_rowHeaderLevelCount - 1;
      genericAxis = 'row';
    } else {
      headerLevel = this.m_rowEndHeaderLevelCount - 1;
      genericAxis = 'row';
    }
    let startIndex;
    let endIndex;
    // corner selection
    if (
      selection.startIndex.column === 0 &&
      selection.endIndex.column === -1 &&
      selection.startIndex.row === 0 &&
      selection.endIndex.row === -1
    ) {
      let count =
        genericAxis === 'row'
          ? this.m_endRowHeader - this.m_startRowHeader
          : this.m_endColHeader - this.m_startColHeader;
      startIndex = 0;
      endIndex = count;
    } else if (
      (selection.startIndex.column === 0 && selection.endIndex.column === -1) ||
      selection.startIndex.column === undefined
    ) {
      // row headers if multiple columns selected
      if (
        selection.startIndex.row <= resizingElementIndex &&
        resizingElementIndex <= selection.endIndex.row &&
        (resizingElementAxis === 'row' || resizingElementAxis === 'rowEnd')
      ) {
        startIndex = selection.startIndex.row;
        endIndex = selection.endIndex.row;
      }
    } else if (
      (selection.startIndex.row === 0 && selection.endIndex.row === -1) ||
      selection.startIndex.row === undefined
    ) {
      // column headers if multiple rows selected
      if (
        selection.startIndex.column <= resizingElementIndex &&
        resizingElementIndex <= selection.endIndex.column &&
        (resizingElementAxis === 'column' || resizingElementAxis === 'columnEnd')
      ) {
        startIndex = selection.startIndex.column;
        endIndex = selection.endIndex.column;
      }
    }
    for (let i = startIndex; i <= endIndex; i++) {
      let headerCell = this._getHeaderByIndex(i, resizingElementAxis, headerLevel);
      if (headerCell) {
        headers.push(headerCell);
      }
    }
    return headers;
  };

  DvtDataGrid.prototype._setHeaderDraggable = function (header) {
    let isHeaderWithinSelection = false;
    if (this.m_selection && this.m_selection.length) {
      // if headers from across axis selected drag cannot be performed.
      if (this._isSelectionAcrossAxis()) {
        return false;
      }
      if (this.m_utils.containsCSSClassName(header, this.getMappedStyle('selected'))) {
        isHeaderWithinSelection = true;
      }
    }
    if (isHeaderWithinSelection) {
      this.m_utils.addCSSClassName(header, this.getMappedStyle('draggableItem'));
      header.setAttribute('draggable', true);
    }
    return isHeaderWithinSelection;
  };

  /**
   * Checks if both row and column are selected.
   * Drag operation checks selection to enable/disable drag.
   */
  DvtDataGrid.prototype._isSelectionAcrossAxis = function () {
    let selectionAxis;
    let isSelectionAcrossAxis = false;
    for (let i = 0; i < this.m_selection.length; i++) {
      let selection = this.m_selection[i];
      if (selectionAxis) {
        if (
          (selection.endIndex.row === -1 && selectionAxis !== 'column') ||
          (selection.endIndex.column === -1 && selectionAxis !== 'row')
        ) {
          isSelectionAcrossAxis = true;
          break;
        }
      }
      if (selection.endIndex.row === -1) {
        selectionAxis = 'column';
      } else if (selection.endIndex.column === -1) {
        selectionAxis = 'row';
      }
    }
    return isSelectionAcrossAxis;
  };

  /**
   * Event handler for when mouse down anywhere in the databody
   * @protected
   * @param {Event} event - mousedown event on the databody
   */
  DvtDataGrid.prototype.handleDatabodyMouseDown = function (event) {
    // removing hidden column indicator in databody after hiding a column
    // on mousedown elsewhere in databody
    this.deleteDatabodyHiddenVisualIndicators();
    var target = /** @type {Element} */ (event.target);
    var cell = this.findCell(target);
    if (cell == null && !this._getEmptyElement()) {
      this.m_scrollbarFocus = true;
      return;
    }

    this.m_shouldFocus = false;

    const activeElement = this._getActiveElement();
    if (this._isEditOrEnter()) {
      if (cell !== activeElement) {
        if (this._leaveEditing(event, activeElement, false) === false) {
          return;
        }
      } else {
        return;
      }
    }

    var ctrlKey = this.m_utils.ctrlEquivalent(event);
    // only perform events on left mouse, (right in rtl culture)
    if (event.button === 0 && !ctrlKey) {
      if (this._isMoveOnElementEnabled(cell)) {
        this.m_databodyMove = true;
        this.m_currentX = event.pageX;
        this.m_currentY = event.pageY;
      }
    }

    if (!this.m_root.contains(document.activeElement) || document.activeElement === this.m_root) {
      this.m_externalFocus = true;
    }

    if (this._isGridEditable()) {
      this.m_shouldFocus = !this._isFocusableElementBeforeCell(target);
    }

    // if click or right click we want to adjust the selction
    // no else so that we can select a cell in the same row as long as no drag
    // check if selection is enabled
    if (this._isSelectionEnabled()) {
      // only allow drag on left click
      if (this.isMultipleSelection() && event.button === 0) {
        this.m_databodyDragState = true;
      }
      this.handleDatabodyClickSelection(event);
    } else {
      // if selection is disable, we'll still need to highlight the active cell
      this.handleDatabodyClickActive(event);
    }
  };

  DvtDataGrid.prototype.handleDatabodyMouseOut = function (event) {
    if (!this.m_databodyMove) {
      var target = /** @type {Element} */ (event.target);
      var targetCell = this.findCell(target);
      this._setCellHover(targetCell, 'remove');
    }
  };

  DvtDataGrid.prototype.handleDatabodyMouseOver = function (event) {
    if (!this.m_databodyMove) {
      var target = /** @type {Element} */ (event.target);
      var targetCell = this.findCell(target);
      this._setCellHover(targetCell, 'add');
    }
  };

  DvtDataGrid.prototype._setCellHover = function (targetCell, addOrRemove) {
    if (targetCell != null && this._isSelectionEnabled()) {
      var selectionMode = this.m_options.getSelectionMode();
      if (selectionMode === 'cell') {
        if (addOrRemove === 'add') {
          this.m_utils.addCSSClassName(targetCell, this.getMappedStyle('hover'));
        } else {
          this.m_utils.removeCSSClassName(targetCell, this.getMappedStyle('hover'));
        }
      } else if (selectionMode === 'row') {
        var index = this._getIndex(targetCell, 'row');
        var returnObj = this._getSelectionStartAndEnd(
          this.createIndex(index, this.m_startCol),
          this.createIndex(index, this.m_endCol),
          0
        );
        for (var i = returnObj.min.row; i <= returnObj.max.row; i++) {
          this._highlightCellsAlongAxis(i, 'row', 'index', addOrRemove, ['hover']);
        }
      }
    }
  };

  DvtDataGrid.prototype.handleDatabodyDoubleClick = function (event) {
    if (this._isGridEditable()) {
      var target = event.target;
      var cell = this.findCell(target);
      var currentMode = this._getCurrentMode();
      if (currentMode === 'edit') {
        var activeCell = this._getActiveElement();
        if (cell === activeCell) {
          // if the active cell is being edited and it is the target do not eat the double click
          return;
        }
        if (!this._handleExitEdit(event, activeCell)) {
          return;
        }
      }
      this._handleEditable(event, cell);
      this._handleEdit(event, cell);
    }
  };

  /**
   * Event handler for when mouse move anywhere in the databody
   * @protected
   * @param {Event} event - mousemove event on the databody
   */
  DvtDataGrid.prototype.handleDatabodyMouseMove = function (event) {
    // handle move first because it should happen first on the second click
    if (event.buttons === 0) {
      this.handleMouseUp(event);
    }
    if (this.m_databodyMove) {
      this._handleMove(event);
    } else if (this.m_databodyDragState) {
      if (!this.m_floodFillDragState) {
        this.handleDatabodySelectionDrag(event);
      } else if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
        if (!this.m_selectionRange) {
          this.m_selectionRange = this.GetSelection();
        }
        this.handleDatabodyFloodFillDrag(event);
      }
    } else if (
      this.m_headerDragState &&
      ((this.m_selectionFrontier &&
        this.m_selectionFrontier.axis &&
        (this.m_selectionFrontier.axis.indexOf('row') !== -1 ||
          this.m_selectionFrontier.axis.indexOf('column') !== -1)) ||
        (this.m_deselectInfo &&
          this.m_deselectInfo.axis &&
          (this.m_deselectInfo.axis.indexOf('row') !== -1 ||
            this.m_deselectInfo.axis.indexOf('column') !== -1)))
    ) {
      this.extendSelectionHeader(event.target, event, true, this.m_deselectInProgress);
    }
  };

  /**
   * Event handler for when mouse down anywhere in the databody
   * @protected
   * @param {Event} event - mouseup event on the databody
   */
  DvtDataGrid.prototype.handleDatabodyMouseUp = function (event) {
    this.m_databodyDragState = false;
    this.m_headerDragState = false;
    this.m_deselectInProgress = false;
    if (this.m_databodyMove) {
      this._handleMoveMouseUp(event, true);
    }
    if (this.m_options.isFloodFillEnabled() && this.m_floodFillDragState) {
      this._handleFloodFillMouseUp(event);
      this.m_floodFillDragState = false;
    }
  };

  DvtDataGrid.prototype.handleDatabodyKeyUp = function (event) {
    if (this.m_deselectInProgress) {
      this.m_deselectInProgress = event.shiftKey;
    }
  };

  /**
   * Event handler for when user press down a key in the databody
   * @protected
   * @param {Event} event - keydown event on the databody
   */
  DvtDataGrid.prototype.handleDatabodyKeyDown = function (event) {
    var action;
    // var keyCode = event.keyCode;
    var ctrlKey = this.m_utils.ctrlEquivalent(event);
    // no longer fire keydown, just check if row expander handled the event already
    // also ignore if the component is animating
    if (
      (event.defaultPrevented && ctrlKey && (this.keyCodes.LEFT_KEY || this.keyCodes.RIGHT_KEY)) ||
      this.m_animating
    ) {
      return;
    }
    let element = this._getActiveElement();

    // check if header is active
    if (this.m_active != null && this.m_active.type === 'header') {
      action = this._getActionFromKeyDown(event, this.m_active.axis, false);
    } else if (this.m_active != null && this.m_active.type === 'label') {
      action = this._getActionFromKeyDown(event, this.m_active.axis, true);
    } else if (this.m_active != null && this.m_active.type === 'empty') {
      action = this._getActionFromNoDataKeydown(event);
    } else {
      action = this._getActionFromKeyDown(event, 'cell', false);
    }

    if (action != null) {
      if (action.call(this, event, element)) {
        event.preventDefault();
      }
    }
  };

  /**
   * Find top and left offset of an element relative to the (0,0) point on the page
   * @param {Element} element - the element to find left and top offset of
   * @return {Array.<number>} - [leftOffset, topOffset]
   */
  DvtDataGrid.prototype.findPos = function (element) {
    if (element) {
      const rect = element.getBoundingClientRect();
      return [rect.x, rect.y];
    }
    return [0, 0];
  };

  /**
   * Find top and left offset relative to the enclosing header
   * @param {Element} element - the event target
   * @param {Element} header - the enclosing header element
   * @param {Element} headerOffset - initial return value
   * @return {Array.<number>} - [leftOffset, topOffset]
   */
  DvtDataGrid.prototype._findHeaderOffset = function (element, header, headerOffset) {
    if (!headerOffset) {
      // eslint-disable-next-line no-param-reassign
      headerOffset = [0, 0];
    }
    if (element !== header) {
      while (!element.offsetParent) {
        // eslint-disable-next-line no-param-reassign
        element = element.parentElement;
      }
      if (element.offsetLeft) {
        // eslint-disable-next-line no-param-reassign
        headerOffset[0] += parseInt(element.offsetLeft, 10);
      }
      if (element.offsetTop) {
        // eslint-disable-next-line no-param-reassign
        headerOffset[1] += parseInt(element.offsetTop, 10);
      }
      return this._findHeaderOffset(element.offsetParent, header, headerOffset);
    }
    return headerOffset;
  };

  /**
   * Event handler for when mouse wheel is used on the databody
   * @param {Event} event - mousewheel event on the databody
   */
  DvtDataGrid.prototype.handleDatabodyMouseWheel = function (event) {
    var axis;
    var header = this.find(event.target, 'header');
    if (header == null) {
      header = this.find(event.target, 'endheader');
    }
    if (header) {
      axis = header === this.m_rowHeader || header === this.m_rowEndHeader ? 'row' : 'column';
    }
    // prevent scrolling of the page, unless there are no more rows, consistant with table/listview
    if (
      axis === 'row' &&
      (!this.m_stopRowHeaderFetch || !this.m_stopRowEndHeaderFetch || !this.m_stopRowFetch)
    ) {
      event.preventDefault();
    } else if (
      axis === 'column' &&
      (!this.m_stopColumnHeaderFetch || !this.m_stopColumnEndHeaderFetch || !this.m_stopColumnFetch)
    ) {
      event.preventDefault();
    }

    // prevent scroll if animating sort
    if (this.m_animating) {
      return;
    }

    var delta = this.m_utils.getMousewheelScrollDelta(event);

    var deltaX = delta.deltaX;
    var deltaY = delta.deltaY;

    if (header === null && event.target.classList.contains(this.getMappedStyle('frozenCell'))) {
      let container = this._getCellContainer(event.target);
      if (container.classList.contains(this.getMappedStyle('databodyFrozenRow'))) {
        deltaY = 0;
      } else if (container.classList.contains(this.getMappedStyle('databodyFrozenCol'))) {
        deltaX = 0;
      } else if (container.classList.contains(this.getMappedStyle('databodyFrozenCorner'))) {
        deltaX = 0;
        deltaY = 0;
      }
    }
    // prevent horizontal/vertical scroll on row/column headers respectively.
    if (axis === 'row') {
      deltaX = 0;
    } else if (axis === 'column') {
      deltaY = 0;
    }
    var scrollTop = Math.max(
      0,
      Math.min(this._getMaxScrollHeight(), this.m_currentScrollTop - deltaY)
    );
    // The below check is to ensure double scrolling is avoided when scrolling over row headers.
    if (
      this._getMaxScrollHeight() !== scrollTop &&
      scrollTop !== 0 &&
      (this.find(event.target, 'header') || this.find(event.target, 'databodyFrozenCol'))
    ) {
      event.preventDefault();
    }
    this.scrollDelta(deltaX, deltaY);
  };
  /** ************** touch related methods ********************/

  /**
   * Event handler for when touch is started on the databody
   * @param {Event} event - touchstart event on the databody
   */
  DvtDataGrid.prototype.handleTouchStart = function (event) {
    var fingerCount = event.touches.length;
    var target = /** @type {Element} */ (event.touches[0].target);

    // move = one finger swipe (or two?)
    if (fingerCount === 1) {
      // get the coordinates of the touch
      this.m_startX = event.touches[0].pageX;
      this.m_startY = event.touches[0].pageY;

      // need these to detect whether touch is hold and move vs. swipe
      this.m_currentX = this.m_startX;
      this.m_currentY = this.m_startY;
      this.m_prevX = this.m_startX;
      this.m_prevY = this.m_startY;
      this.m_startTime = new Date().getTime();

      // flag it
      this.m_touchActive = true;

      // if multiple select enabled check to see if the touch start was on a select affordance
      if (this.isMultipleSelection()) {
        // if the target is not the container, but rather the icon itself, choose the container instead
        if (target.classList.contains(this.getMappedStyle('selectaffordance'))) {
          target = target.parentNode;
        }

        // determine which icon was clicked on
        var dir = null;
        if (target === this.m_topSelectIconContainer) {
          dir = 'top';
        } else if (target === this.m_bottomSelectIconContainer) {
          dir = 'bottom';
        }

        if (dir) {
          // keeps track of multiple select mode
          this.m_touchMultipleSelect = true;
          var selection = this.GetSelection();
          if (dir === 'top') {
            // anchor is bottom right of selection for selecting top affordance
            this.m_touchSelectAnchor = selection[selection.length - 1].endIndex;
          } else {
            // anchor is top left of selection for selecting bottom affordance
            this.m_touchSelectAnchor = selection[selection.length - 1].startIndex;
          }
        }
      }

      // if not multiple select, check for row reorder
      if (!this.m_touchMultipleSelect && this._isMoveOnElementEnabled(this.findCell(target))) {
        this.m_databodyMove = true;
      }
    } else {
      // more than one finger touched so cancel
      this.handleTouchCancel(event);
    }
  };

  /**
   * Event handler for when touch moves on the databody
   * @param {Event} event - touchmove event on the databody
   */
  DvtDataGrid.prototype.handleTouchMove = function (event) {
    var target = /** @type {Element} */ (event.target);

    if (this.m_touchActive) {
      if (event.cancelable) {
        event.preventDefault();
      }
      this.m_currentX = event.touches[0].pageX;
      this.m_currentY = event.touches[0].pageY;

      var diffX = this.m_currentX - this.m_prevX;
      var diffY = this.m_currentY - this.m_prevY;
      var diff = this.adjustTouchScroll(diffX, diffY);
      // eslint-disable-next-line no-param-reassign
      diffX = diff[0];
      // eslint-disable-next-line no-param-reassign
      diffY = diff[1];

      if (this.getResources().isRTLMode()) {
        diffX *= -1;
      }

      if (this.m_touchMultipleSelect) {
        this.handleDatabodySelectionDrag(event);
        if (!this.m_utils.isTouchDeviceNotIOS()) {
          event.preventDefault();
        }
      } else if (this.m_databodyMove) {
        this._removeTouchSelectionAffordance();
        this._handleMove(event);
        if (!this.m_utils.isTouchDeviceNotIOS()) {
          event.preventDefault();
        }
      } else if (this._isEditOrEnter() && this.m_utils.isTouchDeviceNotIOS()) {
        var cell = this._getActiveElement();
        if (this.findCell(target) !== cell) {
          this._handleNonSwipeScroll(diffX, diffY);
        }
      } else {
        this._handleNonSwipeScroll(diffX, diffY);
      }

      this.m_prevX = this.m_currentX;
      this.m_prevY = this.m_currentY;
    } else {
      this.handleTouchCancel(event);
    }
  };

  /**
   * Event handler for when touch ends on the databody
   * @param {Event} event - touchend event on the databody
   */
  DvtDataGrid.prototype.handleTouchEnd = function (event) {
    var target = /** @type {Element} */ (event.target);
    var cell;

    if (this._isEditOrEnter()) {
      cell = this._getActiveElement();
      if (this.findCell(target) !== cell) {
        this._leaveEditing(event, cell, false);
      } else {
        this.handleTouchCancel(event);
        return;
      }
    }

    this.m_shouldFocus = false;

    if (
      this.m_lastTapTime != null &&
      this.m_startTime - this.m_lastTapTime < 250 &&
      this.m_lastTapTarget === target
    ) {
      this.m_lastTapTime = null;
      this.m_lastTapTarget = null;
      cell = this.findCell(target);
      if (cell != null) {
        this._handleEditable(event, cell);
        this._handleEdit(event, cell);
        if (event.cancelable) {
          event.preventDefault();
        }
      }
    } else {
      this.m_lastTapTarget = event.target;
      this.m_lastTapTime = new Date().getTime();
    }

    if (this.m_touchActive && !event.defaultPrevented) {
      if (this.m_touchMultipleSelect) {
        if (event.cancelable) {
          event.preventDefault();
        }
        this.m_touchMultipleSelect = false;
      } else {
        var duration = this.m_lastTapTime - this.m_startTime;
        if (this.m_currentX === this.m_startX && this.m_currentY === this.m_startY) {
          // this means we performed a tap within the row with the active cell
          // and it wasn't actually a move, also only change selection on a tap
          // outside of the current selection, if it was longer than context menu the
          // handleContextMenuGesture will have changed this
          this.m_databodyMove = false;
          if (this._isSelectionEnabled() && duration < DvtDataGrid.CONTEXT_MENU_TAP_HOLD_DURATION) {
            this.handleDatabodyClickSelection(event);
            return;
          }

          // activate on a tap
          this.handleDatabodyClickActive(event);
          return;
        }

        if (this.m_databodyMove) {
          if (event.cancelable) {
            event.preventDefault();
          }
          this.m_databodyMove = false;
          this._handleMoveMouseUp(event, true);
          return;
        }
        if (this.m_utils.isTouchDeviceNotIOS()) {
          this._handleSwipe(event);
        }
      }
    }

    this.handleTouchCancel(event);
  };

  /**
   * Calculate the momentum based on the distance and duration of the swipe
   * @param {number} current the current touch position
   * @param {number} start the start touch position
   * @param {number} time the duration of the swipe
   * @param {number} currentScroll the current scroll position
   * @param {number} maxScroll the maximum scroll position
   * @param {boolean=} rtl true if right to left, false if left to right, undefined if determining momentum in Y direction
   * @return {Object} an object with three keys:
   *                      destination - the point to scroll to with the momentum
   *                      overScroll - the pixel amount that is scrolled beyond the scrollable region
   *                      duration - the duration of the scroll to that destination
   * @private
   */
  DvtDataGrid.prototype._calculateMomentum = function (
    current,
    start,
    time,
    currentScroll,
    maxScroll,
    rtl
  ) {
    var distance = current - start;
    var speed = Math.abs(distance) / time;
    var destination =
      ((speed * speed) / (2 * DvtDataGrid.DECELERATION_FACTOR)) * (distance < 0 ? -1 : 1);
    var duration = speed / DvtDataGrid.DECELERATION_FACTOR;
    var overScroll;

    if (rtl) {
      destination *= -1;
    }

    // if the distance overshoots, then we'll have to adjust and recalculate the duration
    if (currentScroll - destination > maxScroll) {
      // too far bottom/right
      overScroll = Math.max(DvtDataGrid.MAX_OVERSCROLL_PIXEL * -1, destination);
      destination = currentScroll - maxScroll;
      distance = maxScroll - currentScroll;
      duration = distance / speed;
    } else if (currentScroll - destination < 0) {
      // too far top/left
      overScroll = Math.min(DvtDataGrid.MAX_OVERSCROLL_PIXEL, destination);
      destination = currentScroll;
      distance = currentScroll;
      duration = distance / speed;
    }

    return {
      destination: Math.round(destination),
      // durations can be up to 4s currently let's cap them at 500ms
      duration: Math.min(
        Math.max(DvtDataGrid.MIN_SWIPE_TRANSITION_DURATION, duration),
        DvtDataGrid.MAX_SWIPE_TRANSITION_DURATION
      ),
      overScroll: overScroll
    };
  };

  /**
   * Event handler for when touch is cancelled on the databody
   * @param {Event} event - touchcancel event on the databody
   */
  DvtDataGrid.prototype.handleTouchCancel = function (event) {
    if (this.m_databodyMove) {
      this._handleMoveMouseUp(event, false);
      this.m_databodyMove = false;
    }
    this.m_touchSelectAnchor = null;
    this.m_touchMultipleSelect = false;
    // reset the variables back to default values
    this.m_touchActive = false;
    this.m_startX = 0;
    this.m_startY = 0;
    this.m_prevX = 0;
    this.m_prevY = 0;
    this.m_currentX = 0;
    this.m_currentY = 0;
    this.m_startTime = 0;
  };

  /**
   * Event handler for when touch is started on the header
   * @param {Event} event - touchstart event on the header
   */
  DvtDataGrid.prototype.handleHeaderTouchStart = function (event) {
    // store start time of touch
    this.m_touchStart = new Date().getTime();

    var fingerCount = event.touches.length;
    var target = /** @type {Element} */ (event.target);

    // move = one finger swipe (or two?)
    if (fingerCount === 1) {
      // get the coordinates of the touch
      this.m_startX = event.touches[0].pageX;
      this.m_startY = event.touches[0].pageY;

      // need these to detect whether touch is hold and move vs. swipe
      this.m_currentX = this.m_startX;
      this.m_currentY = this.m_startY;
      this.m_prevX = this.m_startX;
      this.m_prevY = this.m_startY;

      // flag it
      this.m_touchActive = true;
      var header = this.findHeader(target);

      if (this.isResizeEnabled()) {
        this.handleResize(event);
        this.handleResizeMouseDown(event);
        this._highlightResizeMouseDown();
      }

      // allow row reorder on headers if our move is enabled make sure our row has the active cell in it
      if (!this.m_isResizing && this._isMoveOnElementEnabled(header)) {
        this.m_databodyMove = true;
      }
      let axis = this.getHeaderCellAxis(header);
      if (this._isDataGridProvider() && this.m_options._isDragEnabled(axis)) {
        this.m_utils.addCSSClassName(header, this.getMappedStyle('draggableItem'));
        header.setAttribute('draggable', true);
      }
    } else {
      // more than one finger touched so cancel
      this.handleHeaderTouchCancel(event);
    }
  };

  /**
   * Event handler for when touch moves on the header
   * @param {Event} event - touchmove event on the header
   */
  DvtDataGrid.prototype.handleHeaderTouchMove = function (event) {
    if (this.m_touchActive) {
      if (event.cancelable) {
        event.preventDefault();
      }

      this.m_currentX = event.touches[0].pageX;
      this.m_currentY = event.touches[0].pageY;

      var diffX = this.m_currentX - this.m_prevX;
      var diffY = this.m_currentY - this.m_prevY;

      if (this.m_isResizing && this.isResizeEnabled()) {
        this.handleResize(event);
      } else if (this.m_databodyMove) {
        this._removeTouchSelectionAffordance();
        this._handleMove(event);
      } else if (this.m_databodyReorder) {
        this._removeTouchSelectionAffordance();
      } else {
        var target = /** @type {Element} */ (event.target);
        // can't swipe column headers in Y and row headers in X
        var header = this.findHeader(target);
        var axis = this.getHeaderCellAxis(header);
        if (axis === 'column' || axis === 'columnEnd') {
          this._handleNonSwipeScroll(diffX, 0);
        } else {
          this._handleNonSwipeScroll(0, diffY);
        }
      }

      this.m_prevX = this.m_currentX;
      this.m_prevY = this.m_currentY;
    } else {
      this.handleTouchCancel(event);
    }
  };

  /**
   * Event handler for when touch ends on the header
   * @param {Event} event - touchend event on the header
   */
  DvtDataGrid.prototype.handleHeaderTouchEnd = function (event) {
    var header;

    if (this.m_touchActive && !event.defaultPrevented) {
      var target = /** @type {Element} */ (event.target);
      // if resizing handle resize first so that we don't conflict and forget to end
      if (this.m_isResizing && this.isResizeEnabled()) {
        this.handleResizeMouseUp(event);
        if (this.m_currentX !== this.m_startX && this.m_currentY !== this.m_startY) {
          if (event.cancelable) {
            event.preventDefault();
          }
        }
      } else if (this.m_currentX === this.m_startX && this.m_currentY === this.m_startY) {
        // if a short tap select
        var selectionMode = this.m_options.getSelectionMode();
        header = this.findHeader(target);
        var cellContext = header[this.getResources().getMappedAttribute('context')];
        var rootId = this.m_root.getAttribute('id');
        var contextMenu = document.querySelector('#' + rootId + 'contextmenu');
        // check custom context menu from slot and check if any context menu is already opened.
        if (contextMenu === null) {
          contextMenu = this._getSlotMap()?.contextMenu?.[0];
        }
        if (contextMenu && contextMenu.style.display === 'none') {
          // if touch in an icon it the click event will handle mousedown/up
          if (this._isSortIcon(target) && this._isDOMElementSortable(target)) {
            if (event.cancelable) {
              event.preventDefault();
            }
            this._removeTouchSelectionAffordance();
            this._handleSortIconMouseDown(target, header);
            this._handleHeaderSort(event);
          } else if (this._isFilterIcon(target) && this._isDOMElementFilterable(target)) {
            if (event.cancelable) {
              event.preventDefault();
            }
            this._removeTouchSelectionAffordance();
            this._handleHeaderFilter(event);
          } else if (this._isDisclosureIcon(target)) {
            this._removeTouchSelectionAffordance();
            this._handleExpandCollapseRequest(event);
            event.preventDefault();
          } else if (
            this._isSelectionEnabled() &&
            this.isMultipleSelection() &&
            !(selectionMode === 'row' && cellContext.axis.indexOf('row') === -1) &&
            !this.m_databodyMove
          ) {
            // if click or right click we want to adjust the selction
            // no else so that we can select a cell in the same row as long as no drag
            // check if selection is enabled
            // only allow drag on left click
            if (event.button === 0) {
              this.m_headerDragState = true;
            }
            this.handleHeaderClickSelection(event);
          } else if (
            selectionMode === 'row' &&
            cellContext.axis.indexOf('row') !== -1 &&
            this._isSelectionEnabled()
          ) {
            // for single row based selection only
            this.handleHeaderClickSelection(event);
          } else {
            // if not selecting, just make active.
            this.handleHeaderClickActive(event);
          }
        }
      } else if (this.m_databodyMove) {
        // if reordering a row
        if (event.cancelable) {
          event.preventDefault();
        }
        this.m_databodyMove = false;
        this._handleMoveMouseUp(event, true);
      } else if (this.m_databodyReorder) {
        if (event.cancelable) {
          event.preventDefault();
        }
        this.m_databodyReorder = false;
        header = this.findHeader(target);
        let axis = this.getHeaderCellAxis(header);
        if (axis === 'row') {
          this.handleRowDragEnd(event);
        } else {
          this.handleColumnDragEnd(event);
        }
      } else {
        // handle potential swipe
        header = this.findHeader(target);
        this._handleSwipe(event, this.getHeaderCellAxis(header));
      }
      // tap and long hold shows context menu, through the wrapper layer
    }
    this.handleHeaderTouchCancel(event);
  };

  /**
   * Event handler for when touch is cancelled on the header
   * @param {Event} event - touchcancel event on the header
   */
  DvtDataGrid.prototype.handleHeaderTouchCancel = function (event) {
    if (this.m_databodyMove) {
      this._handleMoveMouseUp(event, false);
      this.m_databodyMove = false;
    }
    // reset the variables back to default values
    this.m_touchActive = false;
    this.m_startX = 0;
    this.m_startY = 0;
    this.m_prevX = 0;
    this.m_prevY = 0;
    this.m_currentX = 0;
    this.m_currentY = 0;
  };

  /**
   * Handle a touch scroll that is a slow drag
   * @param {number} diffX
   * @param {number} diffY
   */
  DvtDataGrid.prototype._handleNonSwipeScroll = function (diffX, diffY) {
    var time = new Date().getTime();
    // for non-swipe scroll use 0ms to prevent jiggling
    this._disableTouchScrollAnimation();

    var diff = this.adjustTouchScroll(diffX, diffY);
    // eslint-disable-next-line no-param-reassign
    diffX = diff[0];
    // eslint-disable-next-line no-param-reassign
    diffY = diff[1];

    this.scrollDelta(diffX, diffY);

    // reset start position if this is a tap and scroll, so that we can handle
    // user doing a swipe at the end
    if (time - this.m_startTime > DvtDataGrid.TAP_AND_SCROLL_RESET) {
      this.m_startX = this.m_currentX;
      this.m_startY = this.m_currentY;
      this.m_startTime = new Date().getTime();
    }
  };

  /**
   * Event handler for when touch swipe may have been detected
   * @param {Event} event - touchcancel event on the header
   * @param {string|null=} axis - if a header the header axis so we don't swipe in the direction
   */
  DvtDataGrid.prototype._handleSwipe = function (event, axis) {
    var duration = new Date().getTime() - this.m_startTime;
    var rtl = this.getResources().isRTLMode();
    var diffX = this.m_currentX - this.m_startX;
    var diffY = this.m_currentY - this.m_startY;

    // if right to left the difference is the opposite on swipe
    if (rtl) {
      diffX *= -1;
    }
    if (
      Math.abs(diffX) < DvtDataGrid.MIN_SWIPE_DISTANCE &&
      Math.abs(diffY) < DvtDataGrid.MIN_SWIPE_DISTANCE &&
      duration < DvtDataGrid.MIN_SWIPE_DURATION
    ) {
      // detect whether this is a swipe
      if (event.cancelable) {
        event.preventDefault();
      }
      // center touch affordances if row selection multiple
      if (this._isSelectionEnabled()) {
        this._scrollTouchSelectionAffordance();
      }
    } else if (duration < DvtDataGrid.MAX_SWIPE_DURATION) {
      // swipe case
      if (event.cancelable) {
        event.preventDefault();
      }

      var momentumX;
      if (axis !== 'row' && axis !== 'rowEnd') {
        // calculate momentum
        momentumX = this._calculateMomentum(
          this.m_currentX,
          this.m_startX,
          duration,
          this.m_currentScrollLeft,
          this.m_scrollWidth,
          rtl
        );
        if (!isNaN(momentumX.overScroll)) {
          // don't overscroll if there's more rows to fetch
          if (momentumX.overScroll > 0 || this.m_stopColumnFetch) {
            this.m_extraScrollOverX = momentumX.overScroll * -1;
          }
        }
      } else {
        momentumX = { duration: 0, destination: 0 };
        diffX = 0;
      }

      var momentumY;
      if (axis !== 'column' && axis !== 'columnEnd') {
        momentumY = this._calculateMomentum(
          this.m_currentY,
          this.m_startY,
          duration,
          this.m_currentScrollTop,
          this.m_scrollHeight
        );
        if (!isNaN(momentumY.overScroll)) {
          // don't overscroll if there's more rows to fetch
          if (momentumY.overScroll > 0 || this.m_stopRowFetch) {
            this.m_extraScrollOverY = momentumY.overScroll * -1;
          }
        }
      } else {
        momentumY = { duration: 0, destination: 0 };
        diffY = 0;
      }

      if (this.m_utils.isTouchDeviceNotIOS()) {
        var transitionDuration = Math.max(momentumX.duration, momentumY.duration);
        this.m_databody.firstChild.style.transitionDuration = transitionDuration + 'ms';
        this.m_rowHeader.firstChild.style.transitionDuration = transitionDuration + 'ms';
        this.m_colHeader.firstChild.style.transitionDuration = transitionDuration + 'ms';
        this.m_rowEndHeader.firstChild.style.transitionDuration = transitionDuration + 'ms';
        this.m_colEndHeader.firstChild.style.transitionDuration = transitionDuration + 'ms';
      }

      diffX += momentumX.destination;
      diffY += momentumY.destination;
      var diff = this.adjustTouchScroll(diffX, diffY);
      diffX = diff[0];
      diffY = diff[1];

      this.scrollDelta(diffX, diffY);
    }
  };

  /** *********** end touch related methods ********************/

  /**
   * Callback on a widget listener
   * @param {string} functionName - the function name to look up in the callbacks
   * @param {Object} details - the object to pass into the callback function
   * @return {boolean|undefined} true if event passes, false if vetoed
   */
  DvtDataGrid.prototype.fireEvent = function (functionName, details) {
    if (functionName == null || details == null) {
      return undefined;
    }

    var callback = this.callbacks[functionName];
    if (callback != null) {
      return callback(details);
    }
    return true;
  };

  /**
   * Add a callback function to the callbacks object
   * @param {string} functionName - the function name to callback on
   * @param {Object.<Function>} handler - the function to callback to
   */
  DvtDataGrid.prototype.addListener = function (functionName, handler) {
    this.callbacks[functionName] = handler;
  };
  /** ********************************* end dom event handling ***************************************/

  /**
   * Set the style height on an element in pixels
   * @param {Element} elem - the element to set height on
   * @param {number} height - the pixel height to set the element to
   */
  DvtDataGrid.prototype.setElementHeight = function (elem, height) {
    // eslint-disable-next-line no-param-reassign
    elem.style.height = height + 'px';
  };

  /**
   * Get a number of the style height of an element
   * @param {Element|undefined|null} elem - the element to get height on
   * @return {number} the style height of the element
   */
  DvtDataGrid.prototype.getElementHeight = function (elem) {
    return this.getElementDir(elem, 'height');
  };

  /**
   * Set the style width on an element in pixels
   * @param {Element} elem - the element to set width on
   * @param {number} width - the pixel width to set the element to
   */
  DvtDataGrid.prototype.setElementWidth = function (elem, width) {
    // eslint-disable-next-line no-param-reassign
    elem.style.width = width + 'px';
  };

  /**
   * Get a number of the style pixel width of an element
   * @param {Element|undefined|null} elem - the element to get width on
   * @return {number} the style width of the element
   */
  DvtDataGrid.prototype.getElementWidth = function (elem) {
    return this.getElementDir(elem, 'width');
  };

  /**
   * Set the style left/right/top/bottom on an element in pixels
   * @param {Element|undefined|null} elem - the element to set width on
   * @param {number} pix - the pixel width to set the element to
   * @param {string} dir - 'left','right','top,'bottom'
   */
  DvtDataGrid.prototype.setElementDir = function (elem, pix, dir) {
    // eslint-disable-next-line no-param-reassign
    elem.style[dir] = pix + 'px';
  };

  /**
   * Get a number of the style left/right/top/bottom of an element
   * @param {Element|undefined|null} elem - the element to get style left/right/top/bottom on
   * @param {string} dir - 'left','right','top,'bottom'
   * @return {number} the style left/right/top/bottom of the element
   */
  DvtDataGrid.prototype.getElementDir = function (elem, dir) {
    var value;
    if (elem.style[dir].indexOf('px') > -1 && elem.style[dir].indexOf('e') === -1) {
      // parseFloat does better with big numbers
      return parseFloat(elem.style[dir]);
    }

    if (!document.body.contains(elem)) {
      // eslint-disable-next-line no-param-reassign
      elem.style.visibility = 'hidden';
      this.m_root.appendChild(elem); // @HTMLUpdateOK
      // Started using offset again because of how it handles large numbers and limits on BoundingClient
      // Note that on chrome and IE offsetHeight will round differently if the top value is at a decimal
      // pixel value greater or less than .5
      value = Math.round(elem['offset' + dir.charAt(0).toUpperCase() + dir.slice(1)]);
      this.m_root.removeChild(elem);
      // eslint-disable-next-line no-param-reassign
      elem.style.visibility = '';
    } else {
      value = Math.round(elem['offset' + dir.charAt(0).toUpperCase() + dir.slice(1)]);
    }
    return value;
  };

  DvtDataGrid.prototype._computeElementWidthAndHeight = function (elem) {
    var value = {};
    if (elem.style.width.indexOf('px') > -1 && elem.style.width.indexOf('e') === -1) {
      // parseFloat does better with big numbers
      value.width = parseFloat(elem.style.width);
    }
    if (elem.style.height.indexOf('px') > -1 && elem.style.height.indexOf('e') === -1) {
      // parseFloat does better with big numbers
      value.height = parseFloat(elem.style.height);
    }
    if (value.width == null || value.height == null) {
      if (!document.body.contains(elem)) {
        // eslint-disable-next-line no-param-reassign
        elem.style.visibility = 'hidden';
        this.m_root.appendChild(elem); // @HTMLUpdateOK
        value.width = Math.round(elem.offsetWidth);
        value.height = Math.round(elem.offsetHeight);
        this.m_root.removeChild(elem);
        // eslint-disable-next-line no-param-reassign
        elem.style.visibility = '';
      } else {
        value.width = Math.round(elem.offsetWidth);
        value.height = Math.round(elem.offsetHeight);
      }
    }
    return value;
  };

  /** *********************** Model change event *****************************************/
  /**
   * @private
   */
  DvtDataGrid.BEFORE = 1;

  /**
   * @private
   */
  DvtDataGrid.AFTER = 2;

  /**
   * @private
   */
  DvtDataGrid.INSIDE = 3;

  /**
   * Checks whether an index (row/column) is within the range of the current viewport.
   * @param {Object} indexes the row and column indexes
   * @return {number} BEFORE if the index is before the current viewport, AFTER if the index is after
   *         the current viewport, INSIDE if the index is within the current viewport
   * @private
   */
  DvtDataGrid.prototype._isInViewport = function (indexes) {
    var rowIndex = indexes.row;
    var columnIndex = indexes.column;

    if (rowIndex === -1 && columnIndex === -1) {
      // actually, this is an invalid index... should throw an error?
      return -1;
    }

    // if row index wasn't specified, just verify the column range
    if (rowIndex === -1) {
      return this._isColumnIndexInViewport(columnIndex);
    }

    // if column index wasn't specified, just verify the row range
    if (columnIndex === -1) {
      return this._isRowIndexInViewport(rowIndex);
    }

    // both row and column index are defined, then check both ranges
    if (
      columnIndex >= this.m_startCol &&
      columnIndex <= this.m_endCol &&
      rowIndex >= this.m_startRow &&
      rowIndex <= this.m_endRow
    ) {
      return DvtDataGrid.INSIDE;
    }

    // undefined
    return -1;
  };

  /**
   * @private
   */
  DvtDataGrid.prototype._isAxisIndexInViewport = function (index, axis) {
    if (index === -1) {
      return -1;
    }
    if (axis === 'column') {
      return this._isColumnIndexInViewport(index);
    } else if (axis === 'row') {
      return this._isRowIndexInViewport(index);
    }
    return -1;
  };

  DvtDataGrid.prototype._isColumnIndexInViewport = function (index) {
    if (index < this.m_startCol) {
      return DvtDataGrid.BEFORE;
    }
    if (index > this.m_endCol) {
      return DvtDataGrid.AFTER;
    }
    // if it's not before or after, it must be inside
    return DvtDataGrid.INSIDE;
  };

  /**
   * @private
   */
  DvtDataGrid.prototype._isRowIndexInViewport = function (index) {
    if (index < this.m_startRow) {
      return DvtDataGrid.BEFORE;
    }
    if (index > this.m_endRow) {
      return DvtDataGrid.AFTER;
    }
    // if it's not before or after, it must be inside
    return DvtDataGrid.INSIDE;
  };

  /**
   * Checks whether any part of the cell is in the viewport
   * @param {number} left
   * @param {number} right
   * @param {number} top
   * @param {number} bottom
   * @return {boolean} true if cell is in the viewport
   * @private
   */
  DvtDataGrid.prototype._isCellBoundaryInViewport = function (left, right, top, bottom) {
    var viewportTop = this._getViewportTop();
    var viewportBottom = this._getViewportBottom();
    var viewportLeft = this._getViewportLeft();
    var viewportRight = this._getViewportRight();

    return (
      ((bottom <= viewportBottom && bottom > viewportTop) ||
        (top >= viewportTop && top < viewportBottom)) &&
      ((right <= viewportRight && right > viewportLeft) ||
        (left >= viewportLeft && left < viewportRight))
    );
  };

  /**
   * @param {Object} event the model event
   * @return {boolean} true if event is queued, false otherwise
   * @private
   */
  DvtDataGrid.prototype.queueModelEvent = function (event) {
    // in case if the model event arrives before the grid is fully rendered or the event arrives during processing
    // of model queue or we are in the middle of processing/animation model event, queue the event and handle it later
    if (
      !this.m_initialized ||
      this.m_processingEventQueue ||
      this.m_animating ||
      this.m_processingModelEvent ||
      (this._isEditOrEnter() && this._isActiveWithinUpdateRange(event))
    ) {
      if (this.m_modelEvents == null) {
        this.m_modelEvents = [];
      }
      this.m_modelEvents.push(event);
      return true;
    } else if (this.m_modelEvents.length) {
      this.m_modelEvents.push(event);
    }

    return false;
  };

  DvtDataGrid.prototype._isActiveWithinUpdateRange = function (event) {
    const ranges = event.detail.ranges;
    if (this.m_active != null) {
      const type = this.m_active.type;
      if (type === 'label' || type === 'empty') {
        return false;
      }
      for (let i = 0; i < ranges.length; i++) {
        let range = ranges[i];
        if (type === 'cell') {
          if (
            this.m_active.indexes.column >= range.columnOffset &&
            this.m_active.indexes.row >= range.rowOffset &&
            (range.columnCount === -1 ||
              this.m_active.indexes.column < range.columnOffset + range.columnCount) &&
            (range.rowCount === -1 || this.m_active.indexes.row < range.rowOffset + range.rowCount)
          ) {
            return true;
          }
        } else if (type === 'header') {
          if (
            range.columnOffset === 0 &&
            range.columnCount === -1 &&
            this.m_active.index >= range.rowOffset &&
            this.m_active.index < range.rowOffset + range.rowCount
          ) {
            return true;
          } else if (
            range.rowOffset === 0 &&
            range.rowCount === -1 &&
            this.m_active.index >= range.columnOffset &&
            this.m_active.index < range.columnOffset + range.columnCount
          ) {
            return true;
          }
        }
      }
    }

    return false;
  };

  /**
   * Model event handler
   * @param {Object} event the model change event
   * @param {boolean} fromQueue whether this is invoked from model queue processing, optional
   * @protected
   */
  DvtDataGrid.prototype.handleModelEvent = function (event, fromQueue) {
    // in case if the model event arrives before the grid is fully rendered,
    // queue the event and handle it later
    if (fromQueue === undefined && this.queueModelEvent(event)) {
      return;
    }

    var operation = event.operation;
    var keys = event.keys;
    var indexes = event.indexes;
    var cellSet = event.result;
    var headerSet = event.header;
    var endHeaderSet = event.endheader;
    var requiresAnimation = false;

    this.m_processingModelEvent = true;

    if (event.detail) {
      // handle new event
      if (operation === 'delete') {
        this._handleDeleteRangeEvent(event.detail);
        this.m_processingModelEvent = false;
      }
      if (operation === 'insert') {
        this._handleInsertRangeEvent(event.detail);
      }
      if (operation === 'update') {
        this._handleUpdateRangeEvent(event.detail);
      }
      if (operation === 'refresh') {
        this._handleModelRefreshEvent(event.detail);
        this.m_processingModelEvent = false;
      }
    } else if (operation === 'insert') {
      this._adjustActive(operation, indexes);
      this.m_shouldFocus = true;
      this._adjustSelectionOnModelChange(operation, keys, indexes);

      if (cellSet != null) {
        // range insert event with cellset returned
        this._handleModelInsertRangeEvent(cellSet, headerSet, endHeaderSet);
        requiresAnimation = true;
      } else {
        this._handleModelInsertEvent(indexes, keys);
      }
    } else if (operation === 'update') {
      this._handleModelUpdateEvent(indexes, keys, cellSet);
      requiresAnimation = true;
    } else if (operation === 'delete') {
      // adjust selection if neccessary
      // do this before the rows in the databody is mutate
      // (easier this way because of animation delays, plus the selection is immediately updated
      // to reflect the updated state)
      let element;
      if (this._isEditOrEnter()) {
        element = this._getCellByIndex(this.m_active.indexes);
      }
      if (element) {
        let index = this.getCellIndexes(element);
        let shouldDelete = false;
        indexes.forEach((deleteIndex) => {
          if (deleteIndex.row === index.row || deleteIndex.column === index.column) {
            shouldDelete = true;
          }
        });
        if (shouldDelete) {
          this._handleExitEditable(event, element);
          this._handleExitEdit(event, element);
        }
      }
      this._adjustSelectionOnModelChange(operation, keys, indexes);

      if (!Array.isArray(keys)) {
        // eslint-disable-next-line no-param-reassign
        keys = new Array(keys);
      }
      this._handleModelDeleteEventWithAnimation(event, keys);
      if (keys.length > 0) {
        requiresAnimation = true;
      }
    } else if (operation === 'refresh' || operation === 'reset') {
      this._handleModelRefreshEvent();
    } else if (operation === 'sync') {
      this._handleModelSyncEvent(event);
    }

    if (!event.detail) {
      this.m_processingModelEvent = false;
    }

    // Need to rerun the queued events if
    // coming from the queue. If no animation
    // was involved in the current event,
    // we can directly call _runModelEventQueue
    // from here. Animation events will call
    // _runModelEventQueue at the end of their
    // transition function.
    if (!requiresAnimation && fromQueue && !this.m_processingModelEvent) {
      this._runModelEventQueue();
    }
  };

  /**
   * Adjust selection ranges if neccessary on insert or delete.
   * @param {string} operation the model event operation which triggers selection adjustment.
   * @param {Object} indexes the indexes that identify the rows that got inserted/deleted.
   * @private
   */
  DvtDataGrid.prototype._adjustActive = function (operation, indexes) {
    var activeRowIndex;
    var activeHeader;

    if (this.m_active != null) {
      if (this.m_active.type === 'cell') {
        activeHeader = false;
        activeRowIndex = this.m_active.indexes.row;
      } else if (this.m_active.type === 'header' && this.m_active.axis === 'row') {
        activeHeader = true;
        activeRowIndex = this.m_active.index;
      } else {
        return;
      }
    } else {
      return;
    }

    if (!Array.isArray(indexes)) {
      // eslint-disable-next-line no-param-reassign
      indexes = new Array(indexes);
    }

    // if we are getting this from a move event
    if (this.m_moveActive === true) {
      if (operation === 'insert') {
        if (!activeHeader) {
          this.m_active.indexes.row = indexes[0].row;
        } else {
          this.m_active.index = indexes[0].row;
        }
        return;
      } else if (operation === 'delete' && indexes[0].row === activeRowIndex) {
        // do not clear the active since we know the active should be the
        // same once the moved row is returned via insert
        return;
      }
    }

    var adjustment = operation === 'insert' ? 1 : -1;

    for (var i = 0; i < indexes.length; i++) {
      var rowIndex = this._isDataGridProvider() ? indexes[i] : indexes[i].row;
      if (rowIndex < activeRowIndex && this.m_active) {
        if (!activeHeader) {
          this.m_active.indexes.row += adjustment;
        } else {
          this.m_active.index += adjustment;
        }
      } else if (rowIndex === activeRowIndex && operation === 'delete') {
        this._setActive(null, null);
      }
    }
  };

  /**
   * Adjust selection ranges if neccessary on insert or delete.
   * @param {string} operation the model event operation which triggers selection adjustment.
   * @param {Object} keys the keys that identify the rows that got inserted/deleted.
   * @param {Object} indexes the indexes that identify the rows that got inserted/deleted.
   * @private
   */
  DvtDataGrid.prototype._adjustSelectionOnModelChange = function (operation, keys, indexes) {
    // make it an array if it's a single entry event
    if (!Array.isArray(keys)) {
      // eslint-disable-next-line no-param-reassign
      keys = new Array(keys);
    }

    if (!Array.isArray(indexes)) {
      // eslint-disable-next-line no-param-reassign
      indexes = new Array(indexes);
    }

    var selection = this.GetSelection();

    if (keys == null || indexes == null || keys.length !== indexes.length || selection.length === 0) {
      // on a move reset the selection
      if (this.m_moveActive && operation === 'insert') {
        if (this._isSelectionEnabled() && this._isDatabodyCellActive()) {
          var movedRow;
          if (this.m_options.getSelectionMode() === 'cell') {
            movedRow = this.createRange(
              this.m_active.indexes,
              this.m_active.indexes,
              keys[0],
              keys[0]
            );
          } else {
            movedRow = this.createRange(indexes[0], indexes[0], keys[0], keys[0]);
          }
          this.m_selectionFrontier = this.m_active.indexes;
          selection.push(movedRow);
        }
        this.m_moveActive = false;
      }
      // we are done
      return;
    }

    var adjustment = operation === 'insert' ? 1 : -1;

    for (var i = 0; i < keys.length; i++) {
      var rowKey = keys[i].row;
      var rowIndex = indexes[i].row;
      var newRowKey;

      // have to do this backwards since we'll be mutating the array at the same time
      for (var j = selection.length - 1; j >= 0; j--) {
        var range = selection[j];
        var startRowKey = range.startKey.row;
        var endRowKey = range.endKey.row;
        var startRowIndex = range.startIndex.row;
        var endRowIndex = range.endIndex.row;

        if (startRowKey === rowKey) {
          if (endRowKey === rowKey) {
            // single row in range, and it has been deleted, so remove from selection
            if (operation === 'delete') {
              selection.splice(j, 1);
              // eslint-disable-next-line no-continue
              continue;
            }
          }

          // adjust start key, index stays the same
          // adjust end index, end key stays the same
          // get the key of the next row, which will become the new start key
          newRowKey = this._getKey(
            this._getAxisCellsByIndex(range.startIndex.row + 1, 'row')[0],
            'row'
          );
          range.startKey.row = newRowKey;
          range.endIndex.row += adjustment;
        } else if (endRowKey === rowKey) {
          // adjust end key and end index
          // get the key of the next row, which will become the new start key
          newRowKey = this._getKey(
            this._getAxisCellsByIndex(range.startIndex.row - 1, 'row')[0],
            'row'
          );
          range.endKey.row = newRowKey;
          range.endIndex.row += adjustment;
        } else if (rowIndex <= startRowIndex) {
          // before start index, so adjust both start and end index
          range.startIndex.row += adjustment;
          range.endIndex.row += adjustment;
        } else if (rowIndex < endRowIndex) {
          // something in between start and end selection, adjust the end index
          range.endIndex.row += adjustment;
        }
      }
    }
  };

  DvtDataGrid.prototype._simpleAdjustSelectionOnChange = function (operation, indexes, axis) {
    let selection = this.GetSelection();
    let adjustment = operation === 'insert' ? 1 : -1;

    for (let i = 0; i < indexes.length; i++) {
      let index = indexes[i];

      for (let j = selection.length - 1; j >= 0; j--) {
        let range = selection[j];
        let startIndex = range.startIndex[axis];
        let endIndex = range.endIndex[axis];

        if (startIndex === index) {
          if (endIndex === index) {
            if (operation === 'delete') {
              selection.splice(j, 1);
              // eslint-disable-next-line no-continue
              continue;
            }
          }
          if (operation === 'delete') {
            let newKey = this._getKey(
              this._getAxisCellsByIndex(range.startIndex[axis] + 1, axis)[0],
              axis
            );
            range.startKey[axis] = newKey;
          } else {
            range.startIndex[axis] += adjustment;
          }
          range.endIndex[axis] += adjustment;
        } else if (endIndex === index) {
          if (operation === 'delete') {
            let newKey = this._getKey(
              this._getAxisCellsByIndex(range.endIndex[axis] - 1, axis)[0],
              axis
            );
            if (range.endKey === undefined) {
              range.endKey = { row: null, column: null };
            }
            range.endKey[axis] = newKey;
          }
          range.endIndex[axis] += adjustment;
        } else if (index < startIndex) {
          range.startIndex[axis] += adjustment;
          range.endIndex[axis] += adjustment;
        } else if (index < endIndex) {
          range.endIndex[axis] += adjustment;
        }
      }
    }
  };

  /**
   * Handles model insert range event from datagrid provider
   * @private
   */
  DvtDataGrid.prototype._handleInsertRangeEvent = function (eventDetail) {
    let axis = eventDetail.axis;
    let ranges = eventDetail.ranges;
    if (ranges.length === 0) {
      this.fillViewport();
      return;
    }

    // sort ranges forwards to ensure we add in correct order as order is relative to final
    ranges.sort(function (a, b) {
      return a.offset - b.offset;
    });

    let range = ranges.shift();

    let start = range.offset;
    let count = range.count;
    let flag = this._isAxisIndexInViewport(start, axis);
    if (flag === DvtDataGrid.INSIDE) {
      let startRow = start;
      let rowCount = count;
      let startCol = this.m_startCol;
      let colCount = this.m_endCol - this.m_startCol + 1;
      if (axis === 'column') {
        startRow = this.m_startRow;
        rowCount = this.m_endRow - this.m_startRow + 1;
        startCol = start;
        colCount = count;
      }
      let headerFragment = document.createDocumentFragment();
      let endHeaderFragment = document.createDocumentFragment();
      let promiseResolve;
      let promise = new Promise(function (resolve) {
        promiseResolve = resolve;
      });
      let commonProps = {
        axis: axis,
        range: range,
        headerFragment: headerFragment,
        endHeaderFragment: endHeaderFragment,
        totalDimension: 0,
        promiseResolve: promiseResolve
      };

      this.fetchHeaders(axis, start, headerFragment, endHeaderFragment, count, {
        success: this._handleInsertRangeHeaderFetchSuccess.bind(this, commonProps),
        error: this.handleCellsFetchError
      });
      this.fetchCells(this.m_databody, startRow, startCol, rowCount, colCount, {
        success: this._handleInsertRangeCellFetchSuccess.bind(this, commonProps),
        error: this.handleCellsFetchError
      });
      promise.then(this._handleInsertRangeEvent.bind(this, eventDetail));
    } else if (flag === DvtDataGrid.BEFORE) {
      let avg = this.m_avgRowHeight;
      let total = avg * count;
      let headerRoot = this.m_rowHeader;
      let endHeaderRoot = this.m_rowEndHeader;
      if (axis === 'row') {
        if (this.m_endRow >= 0) {
          this.m_startRow += count;
          this.m_endRow += count;
          this.m_startRowPixel += total;
          this.m_endRowPixel += total;
        }
        if (this.m_endRowHeader >= 0) {
          this.m_startRowHeader += count;
          this.m_endRowHeader += count;
          this.m_startRowHeaderPixel += total;
          this.m_endRowHeaderPixel += total;
        }
        if (this.m_endRowEndHeader >= 0) {
          this.m_startRowEndHeader += count;
          this.m_endRowEndHeader += count;
          this.m_startRowEndHeaderPixel += total;
          this.m_endRowEndHeaderPixel += total;
        }
      } else {
        avg = this.m_avgColWidth;
        total = avg * count;
        headerRoot = this.m_colHeader;
        endHeaderRoot = this.m_colEndHeader;
        if (this.m_endCol >= 0) {
          this.m_startCol += count;
          this.m_endCol += count;
          this.m_startColPixel += total;
          this.m_endColPixel += total;
        }
        if (this.m_endColHeader >= 0) {
          this.m_startColHeader += count;
          this.m_endColHeader += count;
          this.m_startColHeaderPixel += total;
          this.m_endColHeaderPixel += total;
        }
        if (this.m_endColEndHeader >= 0) {
          this.m_startColEndHeader += count;
          this.m_endColEndHeader += count;
          this.m_startColEndHeaderPixel += total;
          this.m_endColEndHeaderPixel += total;
        }
      }

      let indexes = new Array(count).fill(start).map((x, y) => x + y);
      let dimensions = new Array(count).fill(avg);
      this._modifyAndPushCells(
        indexes,
        dimensions,
        axis,
        this.m_databody,
        headerRoot,
        endHeaderRoot,
        true
      );
      this._refreshDatabodyMap();
      this._handleInsertRangeEvent(eventDetail);
    } else if (flag === DvtDataGrid.AFTER) {
      if (axis === 'row') {
        this.m_stopRowFetch = false;
        this.m_stopRowHeaderFetch = false;
        this.m_stopRowEndHeaderFetch = false;
      } else {
        this.m_stopColumnFetch = false;
        this.m_stopColumnHeaderFetch = false;
        this.m_stopColumnEndHeaderFetch = false;
      }
      this._handleInsertRangeEvent(eventDetail);
    }
  };

  /**
   * Handles model insert range event from datagrid provider
   * @private
   */
  DvtDataGrid.prototype._handleUpdateRangeEvent = function (eventDetail) {
    let ranges = eventDetail.ranges;
    if (ranges.length === 0) {
      this._resetEditableClone();
      this.applySelection();
      this._resetHeaderHighLight();
      this.fillViewport();
      return;
    }

    // sort ranges forwards to ensure we add in correct order as order is relative to final
    ranges.sort(function (a, b) {
      return a.offset - b.offset;
    });

    let range = ranges.shift();

    let rowStart = range.rowOffset;
    let columnStart = range.columnOffset;
    let rowCount = range.rowCount === -1 ? this._getMaxBottom() + 1 : range.rowCount;
    let columnCount = range.columnCount === -1 ? this._getMaxRight() + 1 : range.columnCount;
    let rowEnd = rowStart + rowCount - 1;
    let columnEnd = columnStart + columnCount - 1;

    let rowStartFlag = this._isAxisIndexInViewport(rowStart, 'row');
    let rowEndFlag = this._isAxisIndexInViewport(rowEnd, 'row');
    let columnStartFlag = this._isAxisIndexInViewport(columnStart, 'column');
    let columnEndFlag = this._isAxisIndexInViewport(columnEnd, 'column');

    // if a portion of the range is in the viewport
    if (
      rowStartFlag !== DvtDataGrid.AFTER &&
      rowEndFlag !== DvtDataGrid.BEFORE &&
      columnStartFlag !== DvtDataGrid.AFTER &&
      columnEndFlag !== DvtDataGrid.BEFORE
    ) {
      if (rowStartFlag === DvtDataGrid.BEFORE) {
        rowStart = this._getMaxTop();
      }
      if (rowEndFlag === DvtDataGrid.AFTER) {
        rowEnd = this._getMaxBottom();
      }
      if (columnStartFlag === DvtDataGrid.BEFORE) {
        columnStart = this._getMaxLeft();
      }
      if (columnEndFlag === DvtDataGrid.AFTER) {
        columnEnd = this._getMaxRight();
      }

      rowCount = rowEnd - rowStart + 1;
      columnCount = columnEnd - columnStart + 1;

      let axis;
      let rerenderHeaders = false;
      if (range.rowCount === -1 || range.columnCount === -1) {
        rerenderHeaders = true;
        axis = range.rowCount === -1 ? 'column' : 'row';
      }

      let axisStart;
      let axisCount;
      if (axis === 'row') {
        axisStart = rowStart;
        axisCount = rowCount;
      } else if (axis === 'column') {
        axisStart = columnStart;
        axisCount = columnCount;
      }
      const headerFragment = document.createDocumentFragment();
      const endHeaderFragment = document.createDocumentFragment();

      let promiseResolve;
      const promise = new Promise(function (resolve) {
        promiseResolve = resolve;
      });
      const commonProps = {
        axis,
        range,
        headerFragment,
        endHeaderFragment,
        totalDimension: 0,
        promiseResolve: promiseResolve
      };

      this.m_fetchingForUpdate = true;
      if (rerenderHeaders) {
        commonProps.editHeader = true;
        this.fetchHeaders(axis, axisStart, headerFragment, undefined, axisCount, {
          success: this._handleInsertRangeHeaderFetchSuccess.bind(this, commonProps),
          error: this.handleHeadersFetchError
        });
        this.fetchCells(this.m_databody, rowStart, columnStart, rowCount, columnCount, {
          success: this._handleUpdateEditableHeader.bind(this, commonProps),
          error: this.handleCellsFetchError
        });
      } else {
        this.fetchCells(this.m_databody, rowStart, columnStart, rowCount, columnCount, {
          success: this._handleUpdateRangeFetchSuccess.bind(this, commonProps),
          error: this.handleCellsFetchError
        });
      }
      promise.then(this._handleUpdateRangeEvent.bind(this, eventDetail));
    } else {
      this._handleUpdateRangeEvent(eventDetail);
    }
  };

  DvtDataGrid.prototype._handleUpdateEditableHeader = function (props, cellSet, cellRange) {
    this.m_fetchingForUpdate = false;
    let commonProps = props;
    let range = commonProps.range;
    let axis = commonProps.axis;
    let editHeader = commonProps.editHeader;
    let offset;
    let count;
    if (axis === 'column') {
      offset = range.columnOffset;
      count = range.columnCount;
    } else if (axis === 'row') {
      offset = range.rowOffset;
      count = range.rowCount;
    }
    let ranges = [
      {
        offset,
        count
      }
    ];
    let eventDetail = { axis, ranges, editHeader };
    let hasBrowserFocus = this.m_root.contains(document.activeElement);

    this._handleDeleteRangeEvent(eventDetail);
    // handleInsertRangeCellFetchSuccess expects { offset, count } as commonProps.range
    delete commonProps.range;
    commonProps.range = { offset, count };
    this._handleInsertRangeCellFetchSuccess(commonProps, cellSet, cellRange);

    if (this._isActiveWithinUpdateRange({ detail: { ranges: [range] } })) {
      if (!hasBrowserFocus) {
        this.m_shouldFocus = false;
      }
      this._highlightActive();
    }

    this._runModelEventQueue();
    if (!this.m_modelEvents?.length) {
      this.m_processingModelEvent = false;
    }
    this._signalTaskEnd();
  };

  DvtDataGrid.prototype._handleInsertRangeHeaderFetchSuccess = function (
    commonProps,
    headerSet,
    headerRange,
    endHeaderSet
  ) {
    const axis = headerRange.axis;

    this._signalTaskEnd();
    this.m_fetching[axis] = false;

    const dir = this.getResources().isRTLMode() ? 'right' : 'left';
    const start = headerRange.start;
    const count = commonProps.range.count;
    const headerFragment = commonProps.headerFragment;
    const endHeaderFragment = commonProps.endHeaderFragment;
    const insertDimension = axis === 'row' ? 'top' : dir;

    this.updateHiddenAxisForInsertion(start, count, axis);

    let insertReference;
    let insertPixel;
    let headerCount;
    let c = 0;
    let index;
    let returnVal;
    let className;
    let renderer;
    let levelCount;
    let leftPixel;
    let topPixel;
    let totalDimension = 0;
    if (headerSet != null) {
      className = this.getMappedStyle('headercell');
      if (axis === 'row') {
        levelCount = this.m_rowHeaderLevelCount;
        className += ' ' + this.getMappedStyle('rowheadercell');
      } else {
        levelCount = this.m_columnHeaderLevelCount;
        className += ' ' + this.getMappedStyle('colheadercell');
      }

      insertReference = this._getHeaderByIndex(start, axis, levelCount - 1);
      insertPixel = this.getElementDir(insertReference, insertDimension);

      // insert reference for the last frozen header will return regular headers.
      // Since the dir value would start from zero for the reference header,
      // we have to handle this special case by checking the dimension on the frozen section.

      if (axis === 'column' && this._hasFrozenColumns() && start === this.m_frozenColIndex + 1) {
        if (this.m_colHeaderFrozen) {
          insertPixel = this.getElementWidth(this.m_colHeaderFrozen);
        } else if (this.m_colEndHeaderFrozen) {
          insertPixel = this.getElementWidth(this.m_colEndHeaderFrozen);
        }
      } else if (axis === 'row' && this._hasFrozenRows() && start === this.m_frozenRowIndex + 1) {
        if (this.m_rowHeaderFrozen) {
          insertPixel = this.getElementHeight(this.m_rowHeaderFrozen);
        } else if (this.m_rowEndHeaderFrozen) {
          insertPixel = this.getElementHeight(this.m_rowEndHeaderFrozen);
        }
      }

      headerCount = headerSet.getCount();
      renderer = this.getRendererOrTemplate(axis);

      while (headerCount - c > 0) {
        if (axis === 'row') {
          leftPixel = 0;
          topPixel = insertPixel + totalDimension;
        } else {
          leftPixel = insertPixel + totalDimension;
          topPixel = 0;
        }

        index = start + c;
        if (
          (axis === 'column' && this._hasFrozenColumns() && index <= this.m_frozenColIndex + 1) ||
          (axis === 'row' && this._hasFrozenRows() && index <= this.m_frozenRowIndex + 1)
        ) {
          className = `${className} ${this.getMappedStyle('frozenHeader')}`;
        }
        returnVal = this.buildLevelHeaders(
          headerFragment,
          index,
          0,
          leftPixel,
          topPixel,
          false,
          true,
          renderer,
          headerSet,
          axis,
          className,
          levelCount
        );
        c += returnVal.count;
        totalDimension += returnVal.totalHeaderDimension;
      }
      if (totalDimension > commonProps.totalDimension) {
        // eslint-disable-next-line no-param-reassign
        commonProps.totalDimension = totalDimension;
      }
    }

    totalDimension = 0;
    c = 0;
    if (endHeaderSet != null) {
      className = this.getMappedStyle('endheadercell');

      if (axis === 'row') {
        levelCount = this.m_rowEndHeaderLevelCount;
        className += ' ' + this.getMappedStyle('rowendheadercell');
      } else {
        levelCount = this.m_columnEndHeaderLevelCount;
        className += ' ' + this.getMappedStyle('colendheadercell');
      }

      const endAxis = `${axis}End`;

      insertReference = this._getHeaderByIndex(start, endAxis, levelCount - 1);
      insertPixel = this.getElementDir(insertReference, insertDimension);

      headerCount = endHeaderSet.getCount();
      renderer = this.getRendererOrTemplate(endAxis);
      while (headerCount - c > 0) {
        if (axis === 'row') {
          leftPixel = 0;
          topPixel = insertPixel + totalDimension;
        } else {
          leftPixel = insertPixel + totalDimension;
          topPixel = 0;
        }

        index = start + c;
        returnVal = this.buildLevelHeaders(
          endHeaderFragment,
          index,
          0,
          leftPixel,
          topPixel,
          true,
          false,
          renderer,
          endHeaderSet,
          endAxis,
          className,
          levelCount
        );
        c += returnVal.count;
        totalDimension += returnVal.totalHeaderDimension;
      }
      if (totalDimension > commonProps.totalDimension) {
        // eslint-disable-next-line no-param-reassign
        commonProps.totalDimension = totalDimension;
      }
    }
  };

  DvtDataGrid.prototype._handleInsertRangeCellFetchSuccess = function (
    commonProps,
    cellSet,
    cellRanges
  ) {
    const range = commonProps.range;
    const axis = commonProps.axis;
    const dontModifySelection = commonProps.editHeader;
    const newHeaderElements = commonProps.headerFragment;
    const newEndHeaderElements = commonProps.endHeaderFragment;
    let totalDimension = commonProps.totalDimension;
    const dir = this.getResources().isRTLMode() ? 'right' : 'left';
    const newCellElements = document.createDocumentFragment();
    const newFrozenColCellElements = document.createDocumentFragment();
    const newFrozenRowCellElements = document.createDocumentFragment();
    const newFrozenCornerCellElements = document.createDocumentFragment();
    let headerRoot = this.m_rowHeader;
    let endHeaderRoot = this.m_rowEndHeader;
    let frozenDatabody = this.m_databodyFrozenRow;
    let frozenHeaderRoot = this.m_rowHeaderFrozen;
    let frozenEndHeaderRoot = this.m_rowEndHeaderFrozen;
    if (axis === 'column') {
      headerRoot = this.m_colHeader;
      endHeaderRoot = this.m_colEndHeader;
      frozenDatabody = this.m_databodyFrozenCol;
      frozenHeaderRoot = this.m_colHeaderFrozen;
      frozenEndHeaderRoot = this.m_colEndHeaderFrozen;
    }

    if (!this.m_modelEvents?.length) {
      this.m_processingModelEvent = false;
    }
    this._signalTaskEnd();
    this.m_fetching.cells = false;
    if (!dontModifySelection) {
      this.unhighlightSelection();
    }
    if (cellSet) {
      const rowRange = cellRanges[0];
      let rowStart = rowRange.start;
      const columnRange = cellRanges[1];
      let columnStart = columnRange.start;
      let rowCount = cellSet.getCount('row');
      let columnCount = cellSet.getCount('column');

      const insertReference = this._getCellByIndex(this.createIndex(rowStart, columnStart));
      let topPixel;
      let leftPixel;
      if (insertReference) {
        topPixel = axis === 'row' ? this.getElementDir(insertReference, 'top') : this.m_startRowPixel;
        leftPixel = axis === 'row' ? this.m_startColPixel : this.getElementDir(insertReference, dir);
        if (
          axis === 'column' &&
          this._hasFrozenColumns() &&
          columnStart === this.m_frozenColIndex + 1
        ) {
          leftPixel = this.getElementWidth(this.m_databodyFrozenCol);
        }
        if (axis === 'row' && this._hasFrozenRows() && rowStart === this.m_frozenRowIndex + 1) {
          topPixel = this.getElementHeight(this.m_databodyFrozenRow);
        }
      } else {
        topPixel = axis === 'row' ? this._getMaxBottomPixel() : this.m_startRowPixel;
        leftPixel = axis === 'row' ? this.m_startColPixel : this._getMaxRightPixel();
      }

      if (axis === 'column') {
        // if insert is within frozen section.
        if (this._hasFrozenColumns() && columnStart <= this.m_frozenColIndex + 1) {
          if (this.m_databodyFrozenCorner) {
            this._addCellsToFragment(
              newFrozenCornerCellElements,
              cellSet,
              rowStart,
              topPixel,
              columnStart,
              leftPixel,
              this.m_frozenRowIndex + 1,
              null
            );
            rowStart = this.m_frozenRowIndex + 1;
            rowCount -= this.m_frozenRowIndex + 1;
          }
          const returnVal = this._addCellsToFragment(
            newFrozenColCellElements,
            cellSet,
            rowStart,
            topPixel,
            columnStart,
            leftPixel,
            rowCount,
            columnCount
          );
          totalDimension = Math.max(totalDimension, returnVal.totalColumnWidth);
        } else {
          // if insert is outside the frozen section but frozen rows exists; we need to populate frozen rows section.
          if (this._hasFrozenRows()) {
            this._addCellsToFragment(
              newFrozenRowCellElements,
              cellSet,
              rowStart,
              topPixel,
              columnStart,
              leftPixel,
              this.m_frozenRowIndex + 1,
              null
            );
            rowStart = this.m_frozenRowIndex + 1;
            rowCount -= this.m_frozenRowIndex + 1;
          }
          const returnVal = this._addCellsToFragment(
            newCellElements,
            cellSet,
            rowStart,
            topPixel,
            columnStart,
            leftPixel,
            rowCount,
            null
          );
          totalDimension = Math.max(
            totalDimension,
            axis === 'row' ? returnVal.totalRowHeight : returnVal.totalColumnWidth
          );
        }
      } else if (axis === 'row') {
        // if insert is within frozen section.
        if (this._hasFrozenRows() && rowStart <= this.m_frozenRowIndex + 1) {
          if (this.m_databodyFrozenCorner) {
            this._addCellsToFragment(
              newFrozenCornerCellElements,
              cellSet,
              rowStart,
              topPixel,
              columnStart,
              leftPixel,
              null,
              this.m_frozenColIndex + 1
            );
            columnStart = this.m_frozenColIndex + 1;
            columnCount -= this.m_frozenColIndex + 1;
          }
          const returnVal = this._addCellsToFragment(
            newFrozenRowCellElements,
            cellSet,
            rowStart,
            topPixel,
            columnStart,
            leftPixel,
            rowCount,
            columnCount
          );
          totalDimension = Math.max(totalDimension, returnVal.totalRowHeight);
        } else {
          // if insert is outside the frozen section but frozen columns exists; we need to populate frozen columns section.
          if (this._hasFrozenColumns()) {
            this._addCellsToFragment(
              newFrozenColCellElements,
              cellSet,
              rowStart,
              topPixel,
              columnStart,
              leftPixel,
              null,
              this.m_frozenColIndex + 1
            );
            columnStart = this.m_frozenColIndex + 1;
            columnCount -= this.m_frozenColIndex + 1;
          }
          const returnVal = this._addCellsToFragment(
            newCellElements,
            cellSet,
            rowStart,
            topPixel,
            columnStart,
            leftPixel,
            null,
            columnCount
          );
          totalDimension = Math.max(totalDimension, returnVal.totalRowHeight);
        }
      }
    }

    let frozenCellStyle = this.getMappedStyle('frozenCell');
    if (newFrozenCornerCellElements.childNodes && newFrozenCornerCellElements.childNodes.length) {
      for (let i = 0; i <= newFrozenCornerCellElements.childNodes.length; i++) {
        let cell = newFrozenCornerCellElements.childNodes[i];
        this.m_utils.addCSSClassName(cell, frozenCellStyle);
      }
    }
    if (newFrozenColCellElements.childNodes && newFrozenColCellElements.childNodes.length) {
      for (let i = 0; i <= newFrozenColCellElements.childNodes.length; i++) {
        let cell = newFrozenColCellElements.childNodes[i];
        this.m_utils.addCSSClassName(cell, frozenCellStyle);
      }
    }
    if (newFrozenRowCellElements.childNodes && newFrozenRowCellElements.childNodes.length) {
      for (let i = 0; i <= newFrozenRowCellElements.childNodes.length; i++) {
        let cell = newFrozenRowCellElements.childNodes[i];
        this.m_utils.addCSSClassName(cell, frozenCellStyle);
      }
    }

    const offset = range.offset;
    const count = range.count;
    let indexes = new Array(count).fill(offset).map((x, y) => x + y);
    let dimensions = 0;
    let frozenDimensions = 0;
    // dimensions are populated based on the section that the insert happens within.
    // The check `offset <= this.m_frozenAxisIndex + 1` is to handle case, where only frozen sections
    // are available and insert is done at the end of the frozen section.
    if (this._hasFrozenColumns() || this._hasFrozenRows()) {
      if (
        (axis === 'column' && this._hasFrozenColumns() && offset <= this.m_frozenColIndex + 1) ||
        (axis === 'row' && this._hasFrozenRows() && offset <= this.m_frozenRowIndex + 1)
      ) {
        frozenDimensions = new Array(count).fill(totalDimension / count);
      } else {
        dimensions = new Array(count).fill(totalDimension / count);
      }
    } else {
      dimensions = new Array(count).fill(totalDimension / count);
    }

    let hasData = newCellElements.childNodes.length;
    let hasHeaders = newHeaderElements.childNodes.length;
    let hasEndHeaders = newEndHeaderElements.childNodes.length;
    let databodyContent = this.m_databody.firstChild;

    let frozenIndexes = [];
    // identify frozen section indexes and separate it out from regular indexes.
    for (let i = indexes.length - 1; i >= 0; i--) {
      let index = indexes[i];
      if (
        (axis === 'column' && this._hasFrozenColumns() && index <= this.m_frozenColIndex + 1) ||
        (axis === 'row' && this._hasFrozenRows() && index <= this.m_frozenRowIndex + 1)
      ) {
        frozenIndexes.push(index);
        indexes.splice(i, 1);
      }
    }

    this._modifyAndPushCells(
      indexes,
      dimensions,
      axis,
      this.m_databody,
      headerRoot,
      endHeaderRoot,
      true,
      frozenIndexes.length
    );
    if (axis === 'column' && this.m_databodyFrozenRow) {
      this._modifyAndPushCells(
        indexes,
        dimensions,
        axis,
        this.m_databodyFrozenRow,
        null,
        null,
        true,
        frozenIndexes.length
      );
    } else if (axis === 'row' && this.m_databodyFrozenCol) {
      this._modifyAndPushCells(
        indexes,
        dimensions,
        axis,
        this.m_databodyFrozenCol,
        null,
        null,
        true,
        frozenIndexes.length
      );
    }
    if (frozenIndexes.length) {
      this._modifyAndPushCells(
        frozenIndexes,
        frozenDimensions,
        axis,
        frozenDatabody,
        frozenHeaderRoot,
        frozenEndHeaderRoot,
        true
      );
      if (this.m_databodyFrozenCorner) {
        this._modifyAndPushCells(
          frozenIndexes,
          frozenDimensions,
          axis,
          this.m_databodyFrozenCorner,
          null,
          null,
          true
        );
      }
      if (axis === 'column') {
        this.m_frozenColIndex += frozenIndexes.length;
      } else {
        this.m_frozenRowIndex += frozenIndexes.length;
      }
    }

    if (!dontModifySelection) {
      this._simpleAdjustSelectionOnChange('insert', indexes, axis);
    }

    let shouldRefreshDatabodyMap = false;
    if (newCellElements.childNodes.length) {
      databodyContent.appendChild(newCellElements); // @HTMLUpdateOK
      shouldRefreshDatabodyMap = true;
    }

    if (newFrozenColCellElements.childNodes.length) {
      databodyContent = this.m_databodyFrozenCol.firstChild;
      databodyContent.appendChild(newFrozenColCellElements); // @HTMLUpdateOK
      shouldRefreshDatabodyMap = true;
    }
    if (newFrozenRowCellElements.childNodes.length) {
      databodyContent = this.m_databodyFrozenRow.firstChild;
      databodyContent.appendChild(newFrozenRowCellElements); // @HTMLUpdateOK
      shouldRefreshDatabodyMap = true;
    }
    if (newFrozenCornerCellElements.childNodes.length) {
      this.m_databodyFrozenCorner.firstChild.appendChild(newFrozenCornerCellElements); // @HTMLUpdateOK
      shouldRefreshDatabodyMap = true;
    }
    if (shouldRefreshDatabodyMap) {
      this._refreshDatabodyMap();
    }

    this._insertHeaders(axis, offset, newHeaderElements, newEndHeaderElements);

    this.hideStatusText();

    if (axis === 'row') {
      if (hasData) {
        this.m_endRow += count;
        this.m_endRowPixel += totalDimension;
        this.m_stopRowFetch = false;
      }
      if (hasHeaders) {
        this.m_endRowHeader += count;
        if (!this._hasFrozenRows() || (this._hasFrozenRows() && offset > this.m_frozenRowIndex + 1)) {
          this.m_endRowHeaderPixel += totalDimension;
        }
        this.m_stopRowHeaderFetch = false;
      }
      if (hasEndHeaders) {
        this.m_endRowEndHeader += count;
        this.m_endRowEndHeaderPixel += totalDimension;
        this.m_stopRowEndHeaderFetch = false;
      }

      if (this._hasFrozenRows() && offset <= this.m_frozenRowIndex + 1) {
        let frozenDatabodyContentHeight =
          this.getElementHeight(this.m_databodyFrozenRow) + totalDimension;
        this.setElementHeight(this.m_databodyFrozenRow, frozenDatabodyContentHeight);
        if (this.m_databodyFrozenCorner) {
          this.setElementHeight(this.m_databodyFrozenCorner, frozenDatabodyContentHeight);
        }
      } else {
        let databodyContentHeight = this.getElementHeight(databodyContent) + totalDimension;
        this.setElementHeight(databodyContent, databodyContentHeight);
      }
      this.updateRowBanding();
    } else if (axis === 'column') {
      if (hasData) {
        this.m_endCol += count;
        this.m_endColPixel += totalDimension;
        this.m_stopColumnFetch = false;
      }
      if (hasHeaders) {
        this.m_endColHeader += count;
        if (
          !this._hasFrozenColumns() ||
          (this._hasFrozenColumns() && offset > this.m_frozenColIndex + 1)
        ) {
          this.m_endColHeaderPixel += totalDimension;
        }
        this.m_stopColumnHeaderFetch = false;
      }
      if (hasEndHeaders) {
        this.m_endColEndHeader += count;
        this.m_endColEndHeaderPixel += totalDimension;
        this.m_stopColumnEndHeaderFetch = false;
      }
      if (this._hasFrozenColumns() && offset <= this.m_frozenColIndex + 1) {
        let frozenDatabodyContentWidth =
          this.getElementWidth(this.m_databodyFrozenCol) + totalDimension;
        this.setElementWidth(this.m_databodyFrozenCol, frozenDatabodyContentWidth);
        if (this.m_databodyFrozenCorner) {
          this.setElementWidth(this.m_databodyFrozenCorner, frozenDatabodyContentWidth);
        }
      } else {
        let databodyContentWidth = this.getElementWidth(databodyContent) + totalDimension;
        this.setElementWidth(databodyContent, databodyContentWidth);
      }
      this.updateColumnBanding();
    }

    this.deleteAndApplyHiddenIndicators();

    if (!dontModifySelection) {
      this.applySelection();
      this._resetHeaderHighLight();
      this.resizeGrid();
    }

    commonProps.promiseResolve();
  };

  DvtDataGrid.prototype._insertHeaders = function (
    axis,
    offset,
    newHeaderElements,
    newEndHeaderElements
  ) {
    let headerRoot = this.m_rowHeader;
    let endHeaderRoot = this.m_rowEndHeader;
    if (this._hasFrozenRows() && offset <= this.m_frozenRowIndex) {
      headerRoot = this.m_rowHeaderFrozen;
      endHeaderRoot = this.m_rowEndHeaderFrozen;
    }
    let startLevelCount = this.m_rowHeaderLevelCount;
    let endLevelCount = this.m_rowEndHeaderLevelCount;
    let insertReference;
    let axisStart = this.m_startRowHeader;
    let endAxisStart = this.m_startRowEndHeader;
    let headerDimension = 'height';
    let dimensionToAdjust = 'top';
    if (axis === 'column') {
      headerRoot = this.m_colHeader;
      endHeaderRoot = this.m_colEndHeader;
      if (this._hasFrozenColumns() && offset <= this.m_frozenColIndex) {
        headerRoot = this.m_colHeaderFrozen;
        endHeaderRoot = this.m_colEndHeaderFrozen;
      }
      startLevelCount = this.m_columnHeaderLevelCount;
      endLevelCount = this.m_columnEndHeaderLevelCount;
      axisStart = this.m_startColHeader;
      endAxisStart = this.m_startColEndHeader;
      headerDimension = 'width';
      dimensionToAdjust = this.getResources().isRTLMode() ? 'right' : 'left';
    }

    let insertGroupingContainer = (
      container,
      root,
      levelCount,
      start,
      dimension,
      adjustDimension,
      groupingAxis
    ) => {
      while (container.childNodes.length) {
        let groupingContainer = container.firstChild;
        let header;
        if (
          this.m_utils.containsCSSClassName(
            groupingContainer,
            this.getMappedStyle('groupingcontainer')
          )
        ) {
          header = groupingContainer.firstChild;
          if (
            header == null ||
            this.m_utils.containsCSSClassName(header, this.getMappedStyle('groupingcontainer'))
          ) {
            container.removeChild(groupingContainer);
            // eslint-disable-next-line no-continue
            continue;
          }
        } else {
          header = groupingContainer;
        }
        let extentInfo = header.extentInfo;
        let patchBefore = extentInfo.more.before;
        let patchAfter = extentInfo.more.after;
        let context = header[this.getResources().getMappedAttribute('context')];
        let index = context.index;
        let extent = context.extent;
        let level = context.level;

        if (patchBefore) {
          let existingGroupingContainer = this._getHeaderContainer(
            index - 1,
            level,
            root,
            levelCount
          );
          let existingHeader = existingGroupingContainer.firstChild;
          let existingHeaderContext =
            existingHeader[this.getResources().getMappedAttribute('context')];
          context.extent += existingHeaderContext.extent;
          context.index = existingHeaderContext.index;

          let existingExtent = this._getAttribute(existingGroupingContainer, 'extent', true);
          this._setAttribute(existingGroupingContainer, 'extent', existingExtent + extent);

          let existingDimension = this.getElementDir(existingHeader, dimension);
          let addDimension = this.getElementDir(header, dimension);
          this.setElementDir(header, existingDimension + addDimension, dimension);

          let existingDir = this.getElementDir(existingHeader, adjustDimension);
          this.setElementDir(header, existingDir, adjustDimension);
          existingGroupingContainer.replaceChild(header, existingHeader);
        } else if (patchAfter) {
          let existingGroupingContainer = this._getHeaderContainer(
            index + extent,
            level,
            root,
            levelCount
          );
          let existingHeader = existingGroupingContainer.firstChild;
          let existingHeaderContext =
            existingHeader[this.getResources().getMappedAttribute('context')];
          context.extent += existingHeaderContext.extent;
          context.index = existingHeaderContext.index - extent;

          let existingExtent = this._getAttribute(existingGroupingContainer, 'extent', true);
          this._setAttribute(existingGroupingContainer, 'extent', existingExtent + extent);

          let existingStart = this._getAttribute(existingGroupingContainer, 'start', true);
          this._setAttribute(existingGroupingContainer, 'start', existingStart - extent);

          let existingDimension = this.getElementDir(existingHeader, dimension);
          let addDimension = this.getElementDir(header, dimension);
          this.setElementDir(header, existingDimension + addDimension, dimension);

          let existingDir = this.getElementDir(existingHeader, adjustDimension);
          this.setElementDir(header, existingDir - addDimension, adjustDimension);
          existingGroupingContainer.replaceChild(header, existingHeader);
        } else {
          let existingGroupingContainer = this._getHeaderContainer(index, level, root, levelCount);
          if (existingGroupingContainer) {
            // the container exists, insert the header
            let prevHeader = this._getHeaderByIndex(index - 1, groupingAxis, level);
            if (prevHeader === null || prevHeader.parentNode !== existingGroupingContainer) {
              let insertAt =
                level === levelCount - 1
                  ? existingGroupingContainer.childNodes[1]
                  : existingGroupingContainer.childNodes[0];
              existingGroupingContainer.insertBefore(header, insertAt); // @HTMLUpdateOK
            } else if (
              prevHeader.nextSibling &&
              prevHeader.nextSibling.parentNode === existingGroupingContainer
            ) {
              existingGroupingContainer.insertBefore(header, prevHeader.nextSibling); // @HTMLUpdateOK
            } else {
              existingGroupingContainer.appendChild(header); // @HTMLUpdateOK
            }
          } else {
            // the container doesn't exist insert the whole container after the previous one
            let previousGroupingContainer = this._getHeaderContainer(
              index - 1,
              level,
              root,
              levelCount
            );
            if (previousGroupingContainer === null) {
              let scroller = root.firstChild;
              if (scroller.firstChild) {
                scroller.insertBefore(groupingContainer, scroller.firstChild); // @HTMLUpdateOK
              } else {
                scroller.appendChild(groupingContainer); // @HTMLUpdateOK
              }
            } else if (previousGroupingContainer.nextSibling) {
              // prettier-ignore
              previousGroupingContainer.parentNode.insertBefore( // @HTMLUpdateOK
                groupingContainer,
                previousGroupingContainer.nextSibling
              );
            } else {
              previousGroupingContainer.parentNode.appendChild(groupingContainer); // @HTMLUpdateOK
            }
          }
        }

        if (patchBefore || patchAfter) {
          let innerGroupingContainer = groupingContainer.querySelector(
            '.' + this.getMappedStyle('groupingcontainer')
          );
          if (innerGroupingContainer) {
            insertGroupingContainer(
              innerGroupingContainer,
              root,
              levelCount,
              start,
              dimension,
              adjustDimension,
              groupingAxis
            );
          }
        }
      }
    };

    if (newHeaderElements.childNodes.length) {
      if (startLevelCount === 1) {
        insertReference = this._getHeaderByIndex(offset, axis, startLevelCount - 1);
        // prettier-ignore
        headerRoot.firstChild.insertBefore( // @HTMLUpdateOK
          newHeaderElements,
          insertReference
        );
      } else {
        insertGroupingContainer(
          newHeaderElements,
          headerRoot,
          startLevelCount,
          axisStart,
          headerDimension,
          dimensionToAdjust,
          axis
        );
      }
    }

    if (newEndHeaderElements.childNodes.length) {
      let endAxis = axis + 'End';
      if (endLevelCount === 1) {
        insertReference = this._getHeaderByIndex(offset, endAxis, startLevelCount - 1);
        // prettier-ignore
        endHeaderRoot.firstChild.insertBefore( // @HTMLUpdateOK
          newEndHeaderElements,
          insertReference
        );
      } else {
        insertGroupingContainer(
          newEndHeaderElements,
          endHeaderRoot,
          endLevelCount,
          endAxisStart,
          headerDimension,
          dimensionToAdjust,
          endAxis
        );
      }
    }
  };

  /**
   * Handles model insert event
   * @param {Object} indexes the indexes that identifies the row that got updated.
   * @param {Object} keys the key that identifies the row that got updated.
   * @private
   */
  DvtDataGrid.prototype._handleModelInsertEvent = function (indexes, keys) {
    // checks if the new row/column is in the viewport
    var flag = this._isInViewport(indexes);
    // If the model inserted is just the next model fetch it
    if (
      flag === DvtDataGrid.INSIDE ||
      (flag === DvtDataGrid.AFTER && indexes.row === this.m_endRow + 1)
    ) {
      // an insert can only be a insert new row or new column.  A cell insert is
      // automatically treated as row insert, keys['row'/'column'] can be the number 0
      if (keys.row != null) {
        // if we have added to an empty grid just refresh, so we can fetch all headers
        if (this._databodyEmpty()) {
          this.empty();
          this.refresh(this.m_root);
        } else {
          // move all rows up an index
          this._modifyAxisCellContextIndex('row', indexes.row, this.m_endRow - indexes.row + 1, 1);
          this._refreshDatabodyMap();

          this.fetchHeaders('row', indexes.row, this.m_rowHeader, this.m_rowEndHeader, 1, {
            success: this._handleHeaderInsertsFetchSuccess
          });
          this.fetchCells(
            this.m_databody,
            indexes.row,
            this.m_startCol,
            1,
            this.m_endCol - this.m_startCol + 1,
            {
              success: this._handleCellInsertsFetchSuccess
            }
          );
        }
      }
      // else if (keys['column'] != null)
      // {
      // todo: handle column insert
      // }
    } else {
      if (flag === DvtDataGrid.BEFORE) {
        // move all rows up an index
        this._modifyAxisCellContextIndex('row', 0, this.m_endRow + 1, 1);
        this._refreshDatabodyMap();

        this.m_startRow += 1;
        this.m_startRowHeader += 1;
        this.m_endRow += 1;
        this.m_endRowHeader += 1;
        this.m_startRowPixel += this.m_avgRowHeight;
        this.m_startRowHeaderPixel += this.m_avgRowHeight;
        this.m_endRowPixel += this.m_avgRowHeight;
        this.m_endRowHeaderPixel += this.m_avgRowHeight;
        var row = this.m_databody.firstChild.firstChild;
        if (row != null) {
          this.pushRowsDown(row, this.m_avgRowHeight);
        }
        var rowHeader = this.m_rowHeader.firstChild.firstChild;
        if (rowHeader != null) {
          this.pushRowsDown(rowHeader, this.m_avgRowHeight);
        }
        var rowEndHeader = this.m_rowEndHeader.firstChild.firstChild;
        if (rowEndHeader != null) {
          this.pushRowsDown(rowEndHeader, this.m_avgRowHeight);
        }
      }

      this.scrollToIndex(indexes);
    }
  };

  /**
   * Handle a successful call to the data source fetchCells. Update the row and
   * cell DOM elements when necessary.
   * @param {Object} cellSet - a CellSet object which encapsulates the result set of cells
   * @param {Array.<Object>} cellRanges - [rowRange, columnRange] - [{"axis":,"start":,"count":},{"axis":,"start":,"count":,"databody":,"scroller":}]
   */
  DvtDataGrid.prototype._handleCellInsertsFetchSuccess = function (cellSet, cellRanges) {
    // so that grid will be resize
    // this.m_initialized = false;
    this.m_resizeRequired = true;

    // insert the row
    this.handleCellsFetchSuccess(cellSet, cellRanges, this.m_endRow >= cellRanges[0].start);

    // make sure the new row is in range
    var rowStart = cellRanges[0].start;
    this._scrollRowIntoViewport(rowStart);

    // clean up rows outside of viewport (for non high-water mark scrolling only)
    if (!this._isHighWatermarkScrolling()) {
      this._cleanupViewport('top');
    }
    this.updateRowBanding();
    this.m_stopRowFetch = false;
    if (this.m_endRowHeader !== -1) {
      this.m_stopRowHeaderFetch = false;
    }
    if (this.m_endRowEndHeader !== -1) {
      this.m_stopRowEndHeaderFetch = false;
    }
    // Need to fill viewport in the case of a silent delete of multiple records with an insert following.
    // i.e. a splice of the data which removes 2 models silently and adds 1 back in, need to add the last model to fill view
    this.fillViewport();
  };

  /**
   * Handle a successful call to the data source fetchHeaderss. Update the row header DOM elements when necessary.
   * @param {Object} headerSet - a HeaderSet object which encapsulates the result set of cells
   * @param {Object} headerRanges - [rowRange, columnRange] - [{"axis":,"start":,"count":},{"axis":,"start":,"count":,"databody":,"scroller":}]
   */
  DvtDataGrid.prototype._handleHeaderInsertsFetchSuccess = function (
    headerSet,
    headerRanges,
    endHeaderSet
  ) {
    // so that grid will be resize
    this.m_resizeRequired = true;
    // insert the row
    this.handleHeadersFetchSuccess(
      headerSet,
      headerRanges,
      endHeaderSet,
      this.m_endRowHeader >= headerRanges.start
    );
  };

  /**
   * Scrolls the row with index into the viewport
   * @param {number} index the row index
   * @private
   */
  DvtDataGrid.prototype._scrollRowIntoViewport = function (index) {
    var rowCells = this._getAxisCellsByIndex(index, 'row');
    if (rowCells == null) {
      // something is wrong the newly inserted row does not exists
      return;
    }

    var viewportTop = this._getViewportTop();
    var viewportBottom = this._getViewportBottom();

    var rowTop = this.getElementDir(rowCells[0], 'top');
    var diff = viewportTop - rowTop;

    if (diff > 0) {
      // row added to top, scroll up
      this.scrollDelta(0, diff);
    } else {
      diff = viewportBottom - rowTop;
      if (diff < 0) {
        // row added to bottom, scroll down
        this.scrollDelta(0, diff);
      }
    }
  };

  /**
   * Handles model range insert event
   * @param {Object} cellSet the range of cells inserted.
   * @param {Object=} headerSet the row headers.
   * @param {Object=} endHeaderSet the row end headers.
   * @private
   */
  DvtDataGrid.prototype._handleModelInsertRangeEvent = function (cellSet, headerSet, endHeaderSet) {
    var rowHeaderFragment;
    var c;
    var index;
    var totalRowHeight;
    var returnVal;
    var className;
    var renderer;
    var rowEndHeaderFragment;
    var empty = this._getEmptyElement();

    // reconstruct the cell ranges from result
    var rowStart = cellSet.getStart('row');
    var columnStart = cellSet.getStart('column');
    var columnCount = cellSet.getCount('column');

    // do not insert if not in viewport yet
    if (rowStart > this.m_endRow + 1) {
      return;
    }

    // if empty refresh to get headers
    if (empty) {
      this.empty();
      this.refresh(this.m_root);
    } else {
      // create  a fragment with all of the row headers
      if (headerSet != null) {
        rowHeaderFragment = document.createDocumentFragment();
        var headerCount = headerSet.getCount();
        // add the headers to the row header
        totalRowHeight = 0;
        c = 0;
        className = this.getMappedStyle('headercell') + ' ' + this.getMappedStyle('rowheadercell');
        renderer = this.getRendererOrTemplate('row');
        while (headerCount - c > 0) {
          index = rowStart + c;
          returnVal = this.buildLevelHeaders(
            rowHeaderFragment,
            index,
            0,
            0,
            totalRowHeight,
            true,
            rowStart !== this.m_endRowHeader + 1,
            renderer,
            headerSet,
            'row',
            className,
            this.m_rowHeaderLevelCount
          );
          c += returnVal.count;
          totalRowHeight += returnVal.totalHeaderDimension;
        }
      }

      // create  a fragment with all of the row headers
      if (endHeaderSet != null) {
        rowEndHeaderFragment = document.createDocumentFragment();
        var headerEndCount = endHeaderSet.getCount();
        // add the headers to the row header
        totalRowHeight = 0;
        c = 0;
        className =
          this.getMappedStyle('endheadercell') + ' ' + this.getMappedStyle('rowendheadercell');
        renderer = this.getRendererOrTemplate('rowEnd');
        while (headerEndCount - c > 0) {
          index = rowStart + c;
          returnVal = this.buildLevelHeaders(
            rowEndHeaderFragment,
            index,
            0,
            0,
            totalRowHeight,
            true,
            rowStart !== this.m_endRowEndHeader + 1,
            renderer,
            endHeaderSet,
            'rowEnd',
            className,
            this.m_rowEndHeaderLevelCount
          );
          c += returnVal.count;
          totalRowHeight += returnVal.totalHeaderDimension;
        }
      }

      var newCellElements = document.createDocumentFragment();
      returnVal = this._addCellsToFragment(newCellElements, cellSet, rowStart, 0, columnStart, 0);
      if (
        newCellElements.childNodes.length === 0 &&
        (rowHeaderFragment == null || rowHeaderFragment.childNodes.length === 0) &&
        (rowEndHeaderFragment == null || rowEndHeaderFragment.childNodes.length === 0)
      ) {
        return;
      }
      this._insertRowsWithAnimation(
        newCellElements,
        rowHeaderFragment,
        rowEndHeaderFragment,
        rowStart,
        cellSet.getCount('row'),
        returnVal.totalRowHeight,
        columnStart,
        columnCount
      );
    }
  };

  /**
   * Handles model update event
   * @param {Object} indexes the indexes that identifies the row that got updated.
   * @param {Object} keys the key that identifies the row that got updated.
   * @private
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype._handleModelUpdateEvent = function (indexes, keys, cellSet) {
    // if the new row/column is in the viewport
    var flag = this._isInViewport(indexes);
    if (flag === DvtDataGrid.INSIDE) {
      if (cellSet != null) {
        var renderer = this.getRendererOrTemplate('cell');
        var columnBandingInterval = this.m_options.getColumnBandingInterval();
        this._updateCellsInRow(
          cellSet,
          cellSet.getStart('row'),
          renderer,
          this.m_startCol,
          columnBandingInterval
        );
      } else {
        // if there is a row header update it
        if (this.m_endRowHeader !== -1) {
          // fetch the updated row header and row
          this.fetchHeaders('row', indexes.row, this.m_rowHeader, this.m_rowEndHeader, 1, {
            success: this._handleHeaderUpdatesFetchSuccess,
            error: this.handleHeadersFetchError
          });
        }

        this.fetchCells(
          this.m_databody,
          indexes.row,
          this.m_startCol,
          1,
          this.m_endCol - this.m_startCol + 1,
          {
            success: this._handleCellUpdatesFetchSuccess,
            error: this.handleCellsFetchError
          }
        );
      }
    }

    // if it's not in range then do nothing
  };

  /**
   * Handle a successful call to the data source fetchHeaderss. Update the row header DOM elements when necessary.
   * @param {Object} headerSet - a HeaderSet object which encapsulates the result set of cells
   * @param {Array} headerRange - [rowRange, columnRange] - [{"axis":,"start":,"count":},{"axis":,"start":,"count":,"databody":,"scroller":}]
   * @param {Object} endHeaderSet - a HeaderSet object which encapsulates the result set of cells
   * @private
   */
  DvtDataGrid.prototype._handleHeaderUpdatesFetchSuccess = function (
    headerSet,
    headerRange,
    endHeaderSet
  ) {
    var axis = headerRange.axis;
    this.m_fetching[axis] = false;
    var rowStart = headerRange.start;

    this._replaceHeaders(
      this.buildRowHeaders.bind(this),
      headerSet,
      this.m_rowHeader,
      rowStart,
      this.m_startRowHeader
    );
    this._replaceHeaders(
      this.buildRowEndHeaders.bind(this),
      endHeaderSet,
      this.m_rowEndHeader,
      rowStart,
      this.m_startRowEndHeader
    );

    var row = this.m_rowHeader.firstChild.childNodes[rowStart - this.m_startRowHeader];

    if (
      this.m_active != null &&
      this.m_active.type === 'header' &&
      (this.m_active.axis === 'row' || this.m_active.axis === 'rowEnd') &&
      this._getKey(row, 'row') === this.m_active.key
    ) {
      this._highlightActive();
    }
    // end fetch
    this._signalTaskEnd();
    // should animate the fragment in the future like updateCells
  };

  /**
   * Replace the headers on update
   * @param {Function} buildFunction
   * @param {Object|null|undefined} headerSet
   * @param {Element} root
   * @param {number} index
   * @param {number} start
   * @private
   */
  DvtDataGrid.prototype._replaceHeaders = function (buildFunction, headerSet, root, index, start) {
    if (headerSet != null) {
      var fragment = buildFunction(root, headerSet, index, 1, true, true);
      var headerContent = root.firstChild;
      var row = headerContent.childNodes[index - start];
      headerContent.replaceChild(fragment, row);
    }
  };

  /**
   * Handle a successful call to the data source fetchCells. Update the row and
   * cell DOM elements when necessary.
   * @param {Object} cellSet - a CellSet object which encapsulates the result set of cells
   * @param {Array.<Object>} cellRange - [rowRange, columnRange] - [{"axis":,"start":,"count":},{"axis":,"start":,"count":,"databody":,"scroller":}]
   * @private
   */
  DvtDataGrid.prototype._handleCellUpdatesFetchSuccess = function (cellSet, cellRange) {
    // fetch complete
    this.m_fetching.cells = false;

    var rowStart = cellRange[0].start;

    var renderer = this.getRendererOrTemplate('cell');
    var columnBandingInterval = this.m_options.getColumnBandingInterval();

    // update the cells in the row
    this._updateCellsInRow(cellSet, rowStart, renderer, this.m_startCol, columnBandingInterval);

    // end fetch
    this._signalTaskEnd();
  };

  /**
   * Retrieves the update animation duration.
   * @return {number} the animation duration.
   * @private
   */
  DvtDataGrid.prototype._getUpdateAnimationDuration = function () {
    return DvtDataGrid.UPDATE_ANIMATION_DURATION;
  };

  /**
   * Adds cells to a row. Iterate over the cells passed in, create new div elements
   * for them settign appropriate styles, and append or prepend them to the row based on the start column.
   * @param {Object} cellSet - the result set of cell data
   * @param {number} rowIndex - the index of the row element
   * @param {function(Object)} renderer - the cell renderer
   * @param {number} columnStart - the index to start start adding at
   * @param {number} columnBandingInterval - the column banding interval
   * @private
   */
  DvtDataGrid.prototype._updateCellsInRow =
    // eslint-disable-next-line no-unused-vars
    function (cellSet, rowIndex, renderer, columnStart, columnBandingInterval) {
      var fragment;
      var animationDuration = this._getUpdateAnimationDuration();

      var cells = this._getAxisCellsByIndex(rowIndex, 'row');
      var top = this.getElementDir(cells[0], 'top');

      // check whether animation should be used
      if (animationDuration === 0) {
        // clear the content of the row first
        this._removeFromArray(cells);

        fragment = document.createDocumentFragment();
        this._addCellsToFragment(fragment, cellSet, rowIndex, top, columnStart, this.m_startColPixel);
        this._populateDatabody(this.m_databody.firstChild, fragment);

        // re-apply selection and active cell since content changed
        if (this._isSelectionEnabled()) {
          this.applySelection();
        }
        this._highlightActive();

        // hide fetching text now that we are done
        this.hideStatusText();
      } else {
        var self = this;
        // animation start
        self._signalTaskStart();

        // clear the content of the row and refill it with new data
        this._removeFromArray(cells);

        fragment = document.createDocumentFragment();
        this._addCellsToFragment(fragment, cellSet, rowIndex, top, columnStart, this.m_startColPixel);
        cells = fragment.childNodes;

        // hide the row
        var width = this.getElementWidth(this.m_databody);
        for (var i = 0; i < cells.length; i++) {
          this.addTransformMoveStyle(cells[i], 0, 0, 'linear', width, 0, 0);
        }

        this._populateDatabody(this.m_databody.firstChild, fragment);

        cells = this._getAxisCellsByIndex(rowIndex, 'row');

        // hide fetching text now that we are done
        this.hideStatusText();

        var listener = function () {
          for (var ii = 0; ii < cells.length; ii++) {
            self.removeTransformMoveStyle(cells[ii]);
          }

          // re-apply selection and active cell since content changed
          if (self._isSelectionEnabled()) {
            self.applySelection();
          }
          self._highlightActive();

          // end animation
          self._signalTaskEnd();

          // runQueue if applicable
          self._runModelEventQueue();
        };

        this._onEndEvent('transitionend', cells[cells.length - 1], listener, animationDuration);

        setTimeout(function () {
          // kick off animation
          for (var ii = 0; ii < cells.length; ii++) {
            self.addTransformMoveStyle(cells[ii], animationDuration + 'ms', 0, 'linear', 0, 0, 0);
          }
        }, 0);
      }
    };

  /**
   * @private
   */
  DvtDataGrid.prototype._handleUpdateRangeFetchSuccess = function (commonProps, cellSet, cellRange) {
    // fetch complete
    this.m_fetching.cells = false;
    this.m_fetchingForUpdate = false;

    const rowStart = cellRange[0].start;
    const rowCount = cellSet.getCount('row');
    const rowEnd = rowStart + rowCount - 1;

    const columnStart = cellRange[1].start;
    const columnCount = cellSet.getCount('column');
    const columnEnd = columnStart + columnCount - 1;

    const hasBrowserFocus = this.m_root.contains(document.activeElement);

    this._splitRange(cellSet, rowStart, rowEnd, columnStart, columnEnd);
    // hide fetching text now that we are done
    this.hideStatusText();

    if (
      this.m_active != null &&
      this.m_active.type === 'cell' &&
      this._isActiveWithinUpdateRange({ detail: { ranges: [commonProps.range] } })
    ) {
      if (!hasBrowserFocus) {
        this.m_shouldFocus = false;
      }
      this._highlightActive();
    }

    this._runModelEventQueue();
    if (!this.m_modelEvents?.length) {
      this.m_processingModelEvent = false;
    }
    // end fetch
    this._signalTaskEnd();

    commonProps.promiseResolve();
  };

  /**
   * Splits the cellSet based on rowStart,colStart and populates different sections in the grid.
   * @param {Object} cellSet - the result set of cell data
   * @param {number} rowStart
   * @param {number} rowEnd
   * @param {number} colStart
   * @param {number} colEnd
   * @private
   */
  DvtDataGrid.prototype._splitRange = function (cellSet, rowStart, rowEnd, colStart, colEnd) {
    let tmpRowEnd = rowEnd < this.m_frozenRowIndex ? rowEnd : this.m_frozenRowIndex;
    let tmpColEnd = colEnd < this.m_frozenColIndex ? colEnd : this.m_frozenColIndex;
    if (
      this.m_frozenRowIndex !== null &&
      this.m_frozenColIndex !== null &&
      rowStart <= this.m_frozenRowIndex &&
      colStart <= this.m_frozenColIndex
    ) {
      this._fetchAndMutateCellsByRange(
        cellSet,
        this.m_databodyFrozenCorner,
        rowStart,
        tmpRowEnd,
        colStart,
        tmpColEnd
      );
      if (rowEnd > this.m_frozenRowIndex) {
        this._fetchAndMutateCellsByRange(
          cellSet,
          this.m_databodyFrozenCol,
          this.m_frozenRowIndex + 1,
          rowEnd,
          colStart,
          tmpColEnd
        );
      }
      if (colEnd > this.m_frozenColIndex) {
        this._fetchAndMutateCellsByRange(
          cellSet,
          this.m_databodyFrozenRow,
          rowStart,
          tmpRowEnd,
          this.m_frozenColIndex + 1,
          colEnd
        );
      }
      if (rowEnd > this.m_frozenRowIndex) {
        // eslint-disable-next-line no-param-reassign
        rowStart = this.m_frozenRowIndex + 1;
      }
      if (colEnd > this.m_frozenColIndex) {
        // eslint-disable-next-line no-param-reassign
        colStart = this.m_frozenColIndex + 1;
      }
    } else if (
      this.m_databodyFrozenCol &&
      this.m_frozenColIndex !== null &&
      colStart <= this.m_frozenColIndex
    ) {
      this._fetchAndMutateCellsByRange(
        cellSet,
        this.m_databodyFrozenCol,
        rowStart,
        rowEnd,
        colStart,
        tmpColEnd
      );
      // eslint-disable-next-line no-param-reassign
      colStart = this.m_frozenColIndex + 1;
    } else if (
      this.m_databodyFrozenRow &&
      this.m_frozenRowIndex !== null &&
      rowStart <= this.m_frozenRowIndex
    ) {
      this._fetchAndMutateCellsByRange(
        cellSet,
        this.m_databodyFrozenRow,
        rowStart,
        tmpRowEnd,
        colStart,
        colEnd
      );
      // eslint-disable-next-line no-param-reassign
      rowStart = this.m_frozenRowIndex + 1;
    }

    let frozenColExists = this.m_frozenColIndex !== null && this.m_frozenColIndex !== -1;
    let frozenRowExists = this.m_frozenRowIndex !== null && this.m_frozenRowIndex !== -1;

    // * If no frozen section, mutate the rest of the databody
    // * If either of them exists, then check if the row/col End exceeds the frozen region and mutate the rest of the databody
    // * ensure check for frozenAxisExists as 1 > null alone shall pass
    if (
      (!frozenColExists && !frozenRowExists) ||
      ((frozenColExists || frozenRowExists) &&
        (!frozenRowExists || rowEnd > this.m_frozenRowIndex) &&
        (!frozenColExists || colEnd > this.m_frozenColIndex))
    ) {
      this._fetchAndMutateCellsByRange(cellSet, this.m_databody, rowStart, rowEnd, colStart, colEnd);
    }
  };

  /**
   * Fetch cells and populate container based on range provided.
   * @param {Object} cellSet - the result set of cell data
   * @param {Element} container
   * @param {number} rowStart
   * @param {number} rowEnd
   * @param {number} colStart
   * @param {number} colEnd
   * @private
   */
  DvtDataGrid.prototype._fetchAndMutateCellsByRange = function (
    cellSet,
    container,
    rowStart,
    rowEnd,
    columnStart,
    columnEnd
  ) {
    let cells = this._getCellsInRange(rowStart, columnStart, rowEnd, columnEnd);
    const top = this.getElementDir(cells[0], 'top');
    const ltr = this.getResources().isRTLMode() ? 'right' : 'left';
    const left = this.getElementDir(cells[0], ltr);
    const rowCount = rowEnd - rowStart + 1;
    const colCount = columnEnd - columnStart + 1;

    // clear the content of the row first
    this._removeFromArray(cells);

    let fragment = document.createDocumentFragment();
    this._addCellsToFragment(fragment, cellSet, rowStart, top, columnStart, left, rowCount, colCount);
    this._populateDatabody(container.firstChild, fragment);
  };

  DvtDataGrid.prototype._removeAndModifyCells = function (cells, axis) {
    cells.forEach((cell) => {
      let cellContext = cell[this.getResources().getMappedAttribute('context')];
      let extent = cellContext.extents[axis];
      if (extent === 1) {
        this._remove(cell);
      } else {
        cellContext.extent[axis] -= 1;
      }
    });
  };

  DvtDataGrid.prototype._removeAndModifyHeaders = function (
    headers,
    dimension,
    dimensionToSet,
    dir,
    index
  ) {
    headers.forEach((header) => {
      let headerContext = header[this.getResources().getMappedAttribute('context')];
      let extent = headerContext.extent;
      let parent = header.parentNode;
      if (extent === 1) {
        this._remove(header);
        if (
          parent.childNodes.length === 0 &&
          !parent.classList.contains(this.getMappedStyle('scroller'))
        ) {
          this._remove(parent);
        }
      } else {
        let headerDim = this.getElementDir(header, dimensionToSet);
        this.setElementDir(header, headerDim - dimension, dimensionToSet);
        headerContext.extent -= 1;
        let start = headerContext.index;
        if (start === index) {
          headerContext.index += 1;
          let headerDir = this.getElementDir(header, dir);
          this.setElementDir(header, headerDir + dimension, dir);
        }
        if (parent.classList.contains(this.getMappedStyle('groupingcontainer'))) {
          let groupExtent = this._getAttribute(parent, 'extent', true);
          let groupStart = this._getAttribute(parent, 'start', true);
          this._setAttribute(parent, 'extent', groupExtent - 1);
          if (start === index) {
            this._setAttribute(parent, 'start', groupStart + 1);
          }
        }
      }
    });
  };

  DvtDataGrid.prototype._handleDeleteRangeEvent = function (eventDetail) {
    let ranges = eventDetail.ranges;
    // use set to ensure unique indexes
    let indexSet = new Set();
    let axis = eventDetail.axis;
    let dontModifySelection = eventDetail.editHeader;
    let ltr = this.getResources().isRTLMode() ? 'right' : 'left';
    let selection = this.m_selection;
    // unhighlight borders around selection range
    for (let i = 0; i < selection.length; i++) {
      this._applyBorderClassesAroundRange(
        this.getElementsInRange(selection[i]),
        selection[i],
        false,
        'Selected'
      );
    }
    // extract all indexes that need to be removed
    ranges.forEach(function (range) {
      let start = range.offset;
      let count = range.count;
      for (var i = 0; i < count; i++) {
        indexSet.add(start + i);
      }
    });

    // sort indexes backwards to ensure we remove in correct order
    let indexes = Array.from(indexSet);
    indexes.sort(function (a, b) {
      return b - a;
    });

    // values to track through removal process
    let beforeDeletedDimension = 0;
    let insideDeletedDimension = 0;
    let beforeDeletedCount = 0;
    let insideDeletedCount = 0;
    let frozenSectionDimension = 0;
    let databodyDimension = 0;

    // row/column conditional vars
    let frozenDatabody = this.m_databodyFrozenRow;
    let headerRoot = this.m_rowHeader;
    let frozenHeaderRoot = this.m_rowHeaderFrozen;
    let endHeaderRoot = this.m_rowEndHeader;
    let frozenEndHeaderRoot = this.m_rowEndHeaderFrozen;
    let avgDimension = this.m_avgRowHeight;
    let hasData = this.m_endRow !== -1;
    let hasHeaders = this.m_endRowHeader !== -1;
    let hasEndHeaders = this.m_endRowEndHeader !== -1;
    let dimensionToRetrieve = 'height';
    let dirToSet = 'top';
    if (axis === 'column') {
      frozenDatabody = this.m_databodyFrozenCol;
      headerRoot = this.m_colHeader;
      frozenHeaderRoot = this.m_colHeaderFrozen;
      endHeaderRoot = this.m_colEndHeader;
      frozenEndHeaderRoot = this.m_colEndHeaderFrozen;
      avgDimension = this.m_avgColWidth;
      hasData = this.m_endCol !== -1;
      hasHeaders = this.m_endColHeader !== -1;
      hasEndHeaders = this.m_endColEndHeader !== -1;
      dimensionToRetrieve = 'width';
      dirToSet = ltr;
    }

    // track dimensions in array reverse the order of indexes for future modification of dom
    let dimensions = [];
    let frozenSectionDimensions = [];
    let element;
    if (this._isEditOrEnter()) {
      element = this._getCellByIndex(this.m_active.indexes);
    }
    if (element) {
      let index = this.getCellIndexes(element);
      let shouldDelete = false;
      indexes.forEach((deleteIndex) => {
        if (
          (axis === 'row' && deleteIndex === index.row) ||
          (axis === 'column' && deleteIndex === index.column)
        ) {
          shouldDelete = true;
        }
      });
      if (shouldDelete) {
        this._handleExitEditable(eventDetail, element);
        this._handleExitEdit(eventDetail, element);
      }
    }
    // we don't want to modify cells multiple times
    // first we remove all cells/headers while the have the correct index
    // we track the dimension change at each index
    // then we will shift all of the cells/headers up based on that
    // this means the only cells acted on multiple times are nested headers
    for (let i = 0; i < indexes.length; i++) {
      let index = indexes[i];
      let dimension = 0;
      let flag = this._isAxisIndexInViewport(index, axis);

      if (flag === DvtDataGrid.BEFORE || flag === DvtDataGrid.INSIDE) {
        if (flag === DvtDataGrid.BEFORE) {
          beforeDeletedCount += 1;
          dimension = avgDimension;
          beforeDeletedDimension += dimension;
        } else if (flag === DvtDataGrid.INSIDE) {
          insideDeletedCount += 1;
          dimension = this.getElementDir(
            this._getCellOrHeaderByIndex(index, axis),
            dimensionToRetrieve
          );

          let cells = this._getAxisCellsByIndex(index, axis);
          if (cells != null) {
            if (this.m_selectionRange && this.m_selectionRange.length) {
              this.unhighlightFloodFillRange(this.m_selectionRange[0]);
            }
            this._removeAndModifyCells(cells, axis);
          }

          let headers = this._getHeadersByIndex(index, axis);
          if (headers.length) {
            this._removeAndModifyHeaders(headers, dimension, dimensionToRetrieve, dirToSet, index);
          }

          let endHeaders;
          if (axis === 'column') {
            endHeaders = this._getHeadersByIndex(index, 'columnEnd');
          } else if (axis === 'row') {
            endHeaders = this._getHeadersByIndex(index, 'rowEnd');
          }

          if (endHeaders.length) {
            this._removeAndModifyHeaders(endHeaders, dimension, dimensionToRetrieve, dirToSet, index);
          }
          if (
            (axis === 'column' && this._hasFrozenColumns() && index <= this.m_frozenColIndex) ||
            (axis === 'row' && this._hasFrozenRows() && index <= this.m_frozenRowIndex)
          ) {
            frozenSectionDimension += dimension;
          } else {
            databodyDimension += dimension;
          }
        }
        if (
          (axis === 'column' && this._hasFrozenColumns() && index <= this.m_frozenColIndex) ||
          (axis === 'row' && this._hasFrozenRows() && index <= this.m_frozenRowIndex)
        ) {
          frozenSectionDimensions.unshift(dimension);
        } else {
          insideDeletedDimension += dimension;
          dimensions.unshift(dimension);
        }
      } else if (flag === DvtDataGrid.AFTER && this.m_options.getScrollPolicy() === 'scroll') {
        // only concerned with after rows if virtual scroll
        databodyDimension += dimension;
      }
    }

    this.updateHiddenAxisForDeletion(indexes, axis);

    // we want to walk indexes in order to push things up and modify their context objects
    indexes.reverse();
    // identify frozen section indexes and separate it out from regular indexes.
    let frozenIndexes = [];
    for (let i = indexes.length - 1; i >= 0; i--) {
      let index = indexes[i];
      if (
        (axis === 'column' && this._hasFrozenColumns() && index <= this.m_frozenColIndex) ||
        (axis === 'row' && this._hasFrozenRows() && index <= this.m_frozenRowIndex)
      ) {
        frozenIndexes.push(index);
        indexes.splice(i, 1);
      }
    }
    frozenIndexes.reverse();
    this._modifyAndPushCells(
      indexes,
      dimensions,
      axis,
      this.m_databody,
      headerRoot,
      endHeaderRoot,
      false,
      frozenIndexes.length
    );
    if (axis === 'column' && this.m_databodyFrozenRow) {
      this._modifyAndPushCells(
        indexes,
        dimensions,
        axis,
        this.m_databodyFrozenRow,
        null,
        null,
        false,
        frozenIndexes.length
      );
    } else if (axis === 'row' && this.m_databodyFrozenCol) {
      this._modifyAndPushCells(
        indexes,
        dimensions,
        axis,
        this.m_databodyFrozenCol,
        null,
        null,
        false,
        frozenIndexes.length
      );
    }
    if (frozenIndexes.length) {
      this._modifyAndPushCells(
        frozenIndexes,
        frozenSectionDimensions,
        axis,
        frozenDatabody,
        frozenHeaderRoot,
        frozenEndHeaderRoot,
        false
      );
      if (this.m_databodyFrozenCorner) {
        this._modifyAndPushCells(
          frozenIndexes,
          frozenSectionDimensions,
          axis,
          this.m_databodyFrozenCorner,
          null,
          null,
          false
        );
      }
      if (axis === 'column') {
        this.m_frozenColIndex -= frozenIndexes.length;
      } else {
        this.m_frozenRowIndex -= frozenIndexes.length;
      }
    }

    // cells in grid are now accurate refresh db map
    this._refreshDatabodyMap();
    if (!dontModifySelection) {
      this._adjustActive('delete', indexes);
      this._simpleAdjustSelectionOnChange('delete', indexes.reverse(), axis);

      let cell;
      let activeIndex = {};
      if (this.m_active && this.m_active.type === 'cell') {
        Object.assign(activeIndex, this.m_active.indexes);
        cell = this._getCellByIndex(activeIndex);
        if (axis === 'row') {
          while (!cell && activeIndex.row - 1 > 0) {
            activeIndex.row -= 1;
            cell = this._getCellByIndex(activeIndex);
          }
        }
      }

      if (cell) {
        this._setActiveByIndex(activeIndex, eventDetail);
        this._highlightActive();
      }
    }

    var databodyContent = this.m_databody.firstChild;

    if (axis === 'row') {
      if (hasData) {
        this.m_startRow -= beforeDeletedCount;
        this.m_endRow = this.m_endRow - beforeDeletedCount - insideDeletedCount;
        this.m_startRowPixel -= beforeDeletedDimension;
        this.m_endRowPixel = this.m_endRowPixel - beforeDeletedDimension - insideDeletedDimension;
        this.m_stopRowFetch = false;
      }
      if (hasHeaders) {
        this.m_startRowHeader -= beforeDeletedCount;
        this.m_endRowHeader = this.m_endRowHeader - beforeDeletedCount - insideDeletedCount;
        this.m_startRowHeaderPixel -= beforeDeletedDimension;
        this.m_endRowHeaderPixel =
          this.m_endRowHeaderPixel - beforeDeletedDimension - insideDeletedDimension;
        this.m_stopRowHeaderFetch = false;
      }
      if (hasEndHeaders) {
        this.m_startRowEndHeader -= beforeDeletedCount;
        this.m_endRowEndHeader = this.m_endRowEndHeader - beforeDeletedCount - insideDeletedCount;
        this.m_startRowEndHeaderPixel -= beforeDeletedDimension;
        this.m_endRowEndHeaderPixel =
          this.m_endRowEndHeaderPixel - beforeDeletedDimension - insideDeletedDimension;
        this.m_stopRowEndHeaderFetch = false;
      }
      var databodyContentHeight = this.getElementHeight(databodyContent) - databodyDimension;
      this.setElementHeight(databodyContent, databodyContentHeight);
      if (this.m_databodyFrozenCol) {
        this.setElementHeight(this.m_databodyFrozenCol, databodyContentHeight);
      }
      if (this.m_databodyFrozenRow) {
        var frozenDatabodyContentHeight =
          this.getElementHeight(this.m_databodyFrozenRow) - frozenSectionDimension;
        this.setElementHeight(this.m_databodyFrozenRow, frozenDatabodyContentHeight);
        if (this.m_databodyFrozenCorner) {
          this.setElementHeight(this.m_databodyFrozenCorner, frozenDatabodyContentHeight);
        }
      }

      this.updateRowBanding();
    } else if (axis === 'column') {
      if (hasData) {
        this.m_startCol -= beforeDeletedCount;
        this.m_endCol = this.m_endCol - beforeDeletedCount - insideDeletedCount;
        this.m_startColPixel -= beforeDeletedDimension;
        this.m_endColPixel = this.m_endColPixel - beforeDeletedDimension - insideDeletedDimension;
        this.m_stopColumnFetch = false;
      }
      if (hasHeaders) {
        this.m_startColHeader -= beforeDeletedCount;
        this.m_endColHeader = this.m_endColHeader - beforeDeletedCount - insideDeletedCount;
        this.m_startColHeaderPixel -= beforeDeletedDimension;
        this.m_endColHeaderPixel =
          this.m_endColHeaderPixel - beforeDeletedDimension - insideDeletedDimension;
        this.m_stopColumnHeaderFetch = false;
      }
      if (hasEndHeaders) {
        this.m_startColEndHeader -= beforeDeletedCount;
        this.m_endColEndHeader = this.m_endColEndHeader - beforeDeletedCount - insideDeletedCount;
        this.m_startColEndHeaderPixel -= beforeDeletedDimension;
        this.m_endColEndHeaderPixel =
          this.m_endColEndHeaderPixel - beforeDeletedDimension - insideDeletedDimension;
        this.m_stopColumnEndHeaderFetch = false;
      }
      var databodyContentWidth = this.getElementWidth(databodyContent) - databodyDimension;
      this.setElementWidth(databodyContent, databodyContentWidth);
      if (this.m_databodyFrozenRow) {
        this.setElementWidth(this.m_databodyFrozenRow, databodyContentWidth);
      }
      if (this.m_databodyFrozenCol) {
        var frozenDatabodyContentWidth =
          this.getElementWidth(this.m_databodyFrozenCol) - frozenSectionDimension;
        this.setElementWidth(this.m_databodyFrozenCol, frozenDatabodyContentWidth);
        if (this.m_databodyFrozenCorner) {
          this.setElementWidth(this.m_databodyFrozenCorner, frozenDatabodyContentWidth);
        }
      }
      this.updateColumnBanding();
    }

    if (!dontModifySelection) {
      this.applySelection();

      if (this.m_utils.isTouchDevice()) {
        if (this.GetSelection().length) {
          this._moveTouchSelectionAffordance();
        } else {
          this._removeTouchSelectionAffordance(true);
        }
      }
      this.resizeGrid();
      // this.setHiddenColumnsDisplayAndWidth();
      this.deleteAndApplyHiddenIndicators();
      this.m_resizeRequired = true;
      let self = this;
      Promise.resolve().then(() => {
        if (self.m_modelEvents != null && self.m_modelEvents.length === 0) {
          self.fillViewport();
        }
      });
    }
  };

  /**
   * Handles model delete event with animation
   * @param {Array} keys the key that identifies the row that got deleted.
   * @private
   */
  DvtDataGrid.prototype._handleModelDeleteEventWithAnimation = function (event, keys) {
    this._collapseRowsWithAnimation(event, keys);
  };

  /**
   * Helper method to process animated rows in responce on the model delete event
   * @param {Object} keys set of keys that identifies rows that got deleted.
   * @private
   */
  DvtDataGrid.prototype._collapseRowsWithAnimation = function (event, keys) {
    var rowCells;
    var i;
    var j;
    var row;
    var rowHeadersToRemove;
    var rowEndHeadersToRemove;
    var rowHeader;
    var rowEndHeader;
    let indexes = event.indexes;

    if (keys.length === 0) {
      return;
    }

    var self = this;
    // animation start
    self._signalTaskStart();
    // note we set the duration to 1 instead of 0 because some browsers do not invoke transition end listener if duration is 0
    var duration = this.m_processingEventQueue ? 1 : DvtDataGrid.COLLAPSE_ANIMATION_DURATION;
    var rowsToRemove = [];
    var totalRowHeight = 0;
    var rowHeaderSupport = this.m_endRowHeader !== -1;
    var rowEndHeaderSupport = this.m_endRowEndHeader !== -1;
    var databodyContent = this.m_databody.firstChild;

    var referenceCellsIndex =
      this._getIndex(this._getAxisCellsByKey(keys[0].row, 'row')[0], 'row') - 1;

    // all inherited animated rows should be hidden under previous rows in view
    for (i = referenceCellsIndex; i >= this.m_startRow; i--) {
      rowCells = this._getAxisCellsByIndex(i, 'row');
      if (
        this.getElementDir(rowCells[0], 'top') + this.getElementHeight(rowCells[0]) <
        this.m_currentScrollTop
      ) {
        break;
      }

      for (j = 0; j < rowCells.length; j++) {
        rowCells[j].style.zIndex = 10;
      }
    }

    if (rowHeaderSupport) {
      rowHeadersToRemove = [];
      var referenceRowHeader = this._findHeaderByKey(
        keys[0].row,
        this.m_rowHeader,
        this.getMappedStyle('rowheadercell')
      ).previousSibling;
      row = referenceRowHeader;
      while (row) {
        if (this.getElementDir(row, 'top') + this.getElementHeight(row) < this.m_currentScrollTop) {
          break;
        }
        row.style.zIndex = 10;
        row = row.previousSibling;
      }
    }

    if (rowEndHeaderSupport) {
      rowEndHeadersToRemove = [];
      var referenceRowEndHeader = this._findHeaderByKey(
        keys[0].row,
        this.m_rowEndHeader,
        this.getMappedStyle('rowendheadercell')
      ).previousSibling;
      row = referenceRowEndHeader;
      while (row) {
        if (this.getElementDir(row, 'top') + this.getElementHeight(row) < this.m_currentScrollTop) {
          break;
        }
        row.style.zIndex = 10;
        row = row.previousSibling;
      }
    }

    // get the rows we need to remove and set the new top to align row bottom with
    // the reference row bottom, but keep it where it is for the time being
    for (i = 0; i < keys.length; i++) {
      var rowKey = keys[i].row;
      rowCells = this._getAxisCellsByKey(rowKey, 'row');
      if (rowCells.length) {
        rowsToRemove.push(rowCells);
        totalRowHeight += this.getElementHeight(rowCells[0]);
        for (j = 0; j < rowCells.length; j++) {
          this.setElementDir(
            rowCells[j],
            this.getElementDir(rowCells[j], 'top') - totalRowHeight,
            'top'
          );
          this.addTransformMoveStyle(rowCells[j], 0, 0, 'linear', 0, totalRowHeight, 0);
        }
      }
      if (rowHeaderSupport) {
        rowHeader = this._findHeaderByKey(
          rowKey,
          this.m_rowHeader,
          this.getMappedStyle('rowheadercell')
        );
        if (rowHeader != null) {
          rowHeadersToRemove.push(rowHeader);
          this.setElementDir(rowHeader, this.getElementDir(rowHeader, 'top') - totalRowHeight, 'top');
          this.addTransformMoveStyle(rowHeader, 0, 0, 'linear', 0, totalRowHeight, 0);
        }
      }
      if (rowEndHeaderSupport) {
        rowEndHeader = this._findHeaderByKey(
          rowKey,
          this.m_rowEndHeader,
          this.getMappedStyle('rowendheadercell')
        );
        if (rowEndHeader != null) {
          rowEndHeadersToRemove.push(rowEndHeader);
          this.setElementDir(
            rowEndHeader,
            this.getElementDir(rowEndHeader, 'top') - totalRowHeight,
            'top'
          );
          this.addTransformMoveStyle(rowEndHeader, 0, 0, 'linear', 0, totalRowHeight, 0);
        }
      }
    }

    // for all the rows after the collapse change the top values appropriately
    for (i = referenceCellsIndex + keys.length + 1; i <= this.m_endRow; i++) {
      // change the row top but keep it where it is
      rowCells = this._getAxisCellsByIndex(i, 'row');
      for (j = 0; j < rowCells.length; j++) {
        this.setElementDir(
          rowCells[j],
          this.getElementDir(rowCells[j], 'top') - totalRowHeight,
          'top'
        );
        this.addTransformMoveStyle(rowCells[j], 0, 0, 'linear', 0, totalRowHeight, 0);
      }
      if (rowHeaderSupport) {
        rowHeader = rowHeader.nextSibling;
        this.setElementDir(rowHeader, this.getElementDir(rowHeader, 'top') - totalRowHeight, 'top');
        this.addTransformMoveStyle(rowHeader, 0, 0, 'linear', 0, totalRowHeight, 0);
      }
      if (rowEndHeaderSupport) {
        rowEndHeader = rowEndHeader.nextSibling;
        this.setElementDir(
          rowEndHeader,
          this.getElementDir(rowEndHeader, 'top') - totalRowHeight,
          'top'
        );
        this.addTransformMoveStyle(rowEndHeader, 0, 0, 'linear', 0, totalRowHeight, 0);
      }
    }

    // listen to the last rows transition end
    var lastAnimationElement = this._getCellByIndex(this.createIndex(this.m_endRow, this.m_endCol));
    function transitionListener() {
      if (rowsToRemove.length) {
        self._modifyAxisCellContextIndex(
          'row',
          referenceCellsIndex + keys.length + 1,
          self.m_endRow - (referenceCellsIndex + keys.length),
          -1 * keys.length
        );
      }

      if (rowHeaderSupport && rowHeadersToRemove.length) {
        self._modifyAxisHeaderContextIndex(
          'row',
          referenceCellsIndex + keys.length + 1,
          self.m_endRow - (referenceCellsIndex + keys.length),
          -1 * keys.length
        );
      }

      if (rowEndHeaderSupport && rowEndHeadersToRemove.length) {
        self._modifyAxisHeaderContextIndex(
          'rowEnd',
          referenceCellsIndex + keys.length + 1,
          self.m_endRow - (referenceCellsIndex + keys.length),
          -1 * keys.length
        );
      }

      for (var ii = 0; ii < rowsToRemove.length; ii++) {
        for (var jj = 0; jj < rowsToRemove[ii].length; jj++) {
          self._remove(rowsToRemove[ii][jj]);
        }
        if (rowHeaderSupport) {
          self._remove(rowHeadersToRemove[ii]);
        }
        if (rowEndHeaderSupport) {
          self._remove(rowEndHeadersToRemove[ii]);
        }
      }

      self._adjustActive('delete', indexes);
      self._refreshDatabodyMap();
      if (self._isEditOrEnter()) {
        self._highlightActiveObject(self.m_active, self.m_prevActive);
        self._updateEdgeCellBorders('');
      }

      // clean up the variables no longer need because event animation handling
      self.m_endRow -= rowsToRemove.length;
      self.m_endRowPixel -= totalRowHeight;
      self.m_stopRowFetch = false;
      if (rowHeaderSupport) {
        self.m_endRowHeader -= rowHeadersToRemove.length;
        self.m_endRowHeaderPixel -= totalRowHeight;
        self.m_stopRowHeaderFetch = false;
      }
      if (rowEndHeaderSupport) {
        self.m_endRowEndHeader -= rowHeadersToRemove.length;
        self.m_endRowEndHeaderPixel -= totalRowHeight;
        self.m_stopRowEndHeaderFetch = false;
      }

      self.setElementHeight(databodyContent, self.m_endRowPixel - self.m_startRowPixel);
      self.resizeGrid();
      self.updateRowBanding();
      if (self.m_modelEvents != null && self.m_modelEvents.length === 0 && !self.m_moveActive) {
        self.fillViewport();
      }
      self._handleAnimationEnd();
    }
    // if (lastAnimationElement) {
    self._onEndEvent('transitionend', lastAnimationElement, transitionListener, duration);

    // animate all rows
    this.m_animating = true;

    setTimeout(function () {
      for (i = referenceCellsIndex + 1; i <= self.m_endRow; i++) {
        // change the row top but keep it where it is
        rowCells = self._getAxisCellsByIndex(i, 'row');
        for (j = 0; j < rowCells.length; j++) {
          self.addTransformMoveStyle(rowCells[j], duration + 'ms', 0, 'ease-out', 0, 0, 0);
        }
        if (rowHeaderSupport) {
          rowHeader = self._getHeaderByIndex(i, 'row', 0);
          self.addTransformMoveStyle(rowHeader, duration + 'ms', 0, 'ease-out', 0, 0, 0);
        }
        if (rowEndHeaderSupport) {
          rowEndHeader = self._getHeaderByIndex(i, 'rowEnd', 0);
          self.addTransformMoveStyle(rowEndHeader, duration + 'ms', 0, 'ease-out', 0, 0, 0);
        }
      }
    }, 0);
    // } else {
    //  transitionListener();
    // }
  };

  /**
   * Clean up the datagrid animations by resetting transform vars and z-index
   * @private
   */
  DvtDataGrid.prototype._handleAnimationEnd = function () {
    // cleanRows
    var i;
    var databodyContent = this.m_databody.firstChild;
    var rowHeaderContent = this.m_rowHeader.firstChild;
    var rowEndHeaderContent = this.m_rowEndHeader.firstChild;
    for (i = 0; i < databodyContent.childNodes.length; i++) {
      this.removeTransformMoveStyle(databodyContent.childNodes[i]);
      databodyContent.childNodes[i].style.zIndex = '';
    }

    if (this.m_endRowHeader !== -1) {
      for (i = 0; i < rowHeaderContent.childNodes.length; i++) {
        this.removeTransformMoveStyle(rowHeaderContent.childNodes[i]);
        rowHeaderContent.childNodes[i].style.zIndex = '';
      }
    }

    if (this.m_endRowEndHeader !== -1) {
      for (i = 0; i < rowEndHeaderContent.childNodes.length; i++) {
        this.removeTransformMoveStyle(rowEndHeaderContent.childNodes[i]);
        rowEndHeaderContent.childNodes[i].style.zIndex = '';
      }
    }
    // end animation
    this.m_animating = false;

    // check event queue for outstanding model events
    this._runModelEventQueue();

    // if we signal ready before emptying the queue there may be outstanding events to immediately follow
    this._signalTaskEnd();
  };

  /**
   * Get a cell or header from a given key and axis, gets the first cell with that key
   * @private
   */
  DvtDataGrid.prototype._getCellOrHeaderByKey = function (key, axis) {
    var element = null;
    var cells = this._getAxisCellsByKey(key, axis, true);
    if (cells != null && cells.length > 0) {
      element = cells[0];
    }

    if (element == null) {
      if (axis === 'row') {
        element = this._findHeaderByKey(key, this.m_rowHeader, this.getMappedStyle('rowheadercell'));
        if (element == null) {
          element = this._findHeaderByKey(
            key,
            this.m_rowEndHeader,
            this.getMappedStyle('rowendheadercell')
          );
        }
      } else if (axis === 'column') {
        element = this._findHeaderByKey(key, this.m_colHeader, this.getMappedStyle('colheadercell'));
        if (element == null) {
          element = this._findHeaderByKey(
            key,
            this.m_colEndHeader,
            this.getMappedStyle('colendheadercell')
          );
        }
      }
    }
    return element;
  };

  /**
   * Find the header element by key inside a given root and className
   * @param {string|null} key the key
   * @param {DocumentFragment|Element} root
   * @param {string} className
   * @return {Element|null} the row element
   * @private
   */
  DvtDataGrid.prototype._findHeaderByKey = function (key, root, className) {
    if (root == null) {
      return null;
    }
    var sections = [];
    var headers = [];
    sections.push(root);

    if (this._hasFrozenRows() && (root === this.m_rowHeader || root === this.m_rowEndHeader)) {
      let section = root === this.m_rowHeader ? this.m_rowHeaderFrozen : this.m_rowEndHeaderFrozen;
      sections.push(section);
    }
    if (this._hasFrozenColumns() && (root === this.m_colHeader || root === this.m_colEndHeader)) {
      let section = root === this.m_colHeader ? this.m_colHeaderFrozen : this.m_colEndHeaderFrozen;
      sections.push(section);
    }

    for (let i = 0; i < sections.length; i++) {
      headers.push(...sections[i].getElementsByClassName(className));
    }

    for (var i = 0; i < headers.length; i++) {
      var header = headers[i];
      var headerKey = this._getKey(header);
      if (this._shallowThenDeepCompare(headerKey, key)) {
        return header;
      }
    }

    // can't find it, the row is not in viewport
    return null;
  };

  /**
   * Handles model refresh event
   * @private
   */
  DvtDataGrid.prototype._handleModelRefreshEvent = function (detail) {
    let left;
    let top;
    if (detail != null) {
      const eventDetail = {};
      eventDetail.ranges = [];
      let fullRefresh = true;
      if (
        detail.disregardAfterColumnOffset != null &&
        this._getCellOrHeaderByIndex(detail.disregardAfterColumnOffset, 'column')
      ) {
        eventDetail.axis = 'column';
        const offset = detail.disregardAfterColumnOffset + 1;
        eventDetail.ranges.push({
          offset: offset,
          count: this.m_endCol - detail.disregardAfterColumnOffset
        });
        fullRefresh = false;
      }
      if (
        detail.disregardAfterRowOffset != null &&
        this._getCellOrHeaderByIndex(detail.disregardAfterRowOffset, 'row')
      ) {
        eventDetail.axis = 'row';
        const offset = detail.disregardAfterRowOffset + 1;
        eventDetail.ranges.push({
          offset: offset,
          count: this.m_endRow - detail.disregardAfterRowOffset
        });
        fullRefresh = false;
      }

      if (detail.preserved) {
        if (detail.preserved === 'columns') {
          left = this.m_currentScrollLeft;
        }
        if (detail.preserved === 'rows') {
          top = this.m_currentScrollTop;
        }
      }

      if (!fullRefresh) {
        this._handleDeleteRangeEvent(eventDetail);
        return;
      }
    }
    var visibility = this.getVisibility();
    this.m_focusOnRefresh = this.m_root.contains(document.activeElement);

    this.m_updateScrollPostionOnRefreshCallback(left, top);

    // if we are visible, make sure we are visible, and just refresh the datagrid
    // if we are hidden we want to change the state to refresh so the wrapper know to call refresh when we are shown.
    // if we are already in state refresh we do not need to update.
    // if we are in state render we do not want to update that.
    if (visibility === DvtDataGrid.VISIBILITY_STATE_VISIBLE) {
      this.empty();
      // if the app developer doesn't notify the grid that it has become hidden
      // check to make sure, if it isn't hidden, refresh if it is
      // supported in IE9+
      if (this.m_root.offsetParent != null) {
        this.refresh(this.m_root);
      } else {
        this.setVisibility(DvtDataGrid.VISIBILITY_STATE_REFRESH);
      }
    } else if (visibility === DvtDataGrid.VISIBILITY_STATE_HIDDEN) {
      this.empty();
      this.setVisibility(DvtDataGrid.VISIBILITY_STATE_REFRESH);
    }
  };

  /**
   * Handles data source fetch end (model sync) event
   * @param {Object} event the model event
   * @private
   */
  DvtDataGrid.prototype._handleModelSyncEvent = function (event) {
    // Currently these are set to zero for now, may come from the event later
    var startRow = 0;
    var startRowPixel = 0;
    var startCol = 0;
    var startColPixel = 0;
    var pageSize = event.pageSize;

    // cancel previous fetch calls
    this.m_fetching = {};

    // reset ranges
    this.m_startRow = startRow;
    this.m_endRow = -1;
    this.m_startRowHeader = startRow;
    this.m_endRowHeader = -1;
    this.m_startRowEndHeader = startRow;
    this.m_endRowEndHeader = -1;
    this.m_startRowPixel = startRowPixel;
    this.m_endRowPixel = startRowPixel;
    this.m_startRowHeaderPixel = startRowPixel;
    this.m_endRowHeaderPixel = startRowPixel;
    this.m_startRowEndHeaderPixel = startRowPixel;
    this.m_endRowEndHeaderPixel = startRowPixel;
    this.m_startCol = startCol;
    this.m_endCol = -1;

    this.m_startColHeader = startCol;
    this.m_endColHeader = -1;
    this.m_startColEndHeader = startCol;
    this.m_endColEndHeader = -1;

    this.m_startColPixel = startColPixel;
    this.m_endColPixel = startColPixel;

    this.m_startColHeaderPixel = startColPixel;
    this.m_endColHeaderPixel = startColPixel;

    this.m_startColEndHeaderPixel = startColPixel;
    this.m_endColEndHeaderPixel = startColPixel;

    this.m_rowHeaderLevelCount = undefined;
    this.m_columnHeaderLevelCount = undefined;
    this.m_rowEndHeaderLevelCount = undefined;
    this.m_columnEndHeaderLevelCount = undefined;

    this.m_avgRowHeight = undefined;
    this.m_avgColWidth = undefined;

    this.m_isEstimateRowCount = undefined;
    this.m_isEstimateColumnCount = undefined;
    this.m_stopRowFetch = false;
    this.m_stopRowHeaderFetch = false;
    this.m_stopRowEndHeaderFetch = false;
    this.m_stopColumnFetch = false;
    this.m_stopColumnHeaderFetch = false;
    this.m_stopColumnEndHeaderFetch = false;

    this._clearScrollPositionKeys();

    // clear selections
    this.m_selection = null;
    this.m_selectionRange = null;
    this.m_active = null;
    this.m_prevActive = null;
    this.m_trueIndex = {};

    if (this.m_empty != null) {
      this.m_databody.firstChild.removeChild(this.m_empty);
      this.m_empty = null;
    }

    this._showHeader(this.m_rowHeader);
    this._showHeader(this.m_colHeader);
    this._showHeader(this.m_rowEndHeader);
    this._showHeader(this.m_colEndHeader);

    this._emptyHeaders();
    this._emptyHeaderLabels();
    var databodyContent = this.m_databody.firstChild;
    if (databodyContent != null) {
      this._emptyDatabody(databodyContent);
    }

    this.m_initialized = false;
    this.fetchHeaders('row', startRow, this.m_rowHeader, this.m_rowEndHeader, pageSize, {
      success: function (headerSet, headerRange, endHeaderSet) {
        this.handleHeadersFetchSuccess(headerSet, headerRange, endHeaderSet, false);
      }
    });
    this.fetchHeaders('column', startCol, this.m_colHeader, this.m_colEndHeader, undefined, {
      success: function (headerSet, headerRange, endHeaderSet) {
        this.handleHeadersFetchSuccess(headerSet, headerRange, endHeaderSet, false);
      }
    });

    this.fetchCells(this.m_databody, startRow, startCol, pageSize, null, {
      success: function (cellSet, cellRange) {
        this.handleCellsFetchSuccess(cellSet, cellRange);
      }
    });
  };

  /**
   * Empties the headers
   * @private
   */
  DvtDataGrid.prototype._emptyHeaders = function () {
    var rowHeaderContent = this.m_rowHeader.firstChild;
    var rowEndHeaderContent = this.m_rowEndHeader.firstChild;
    if (rowHeaderContent != null) {
      this.m_utils.empty(rowHeaderContent);
    }
    if (rowEndHeaderContent != null) {
      this.m_utils.empty(rowEndHeaderContent);
    }

    var columnHeaderContent = this.m_colHeader.firstChild;
    var columnEndHeaderContent = this.m_colEndHeader.firstChild;
    if (columnHeaderContent != null) {
      this.m_utils.empty(columnHeaderContent);
    }
    if (columnEndHeaderContent != null) {
      this.m_utils.empty(columnEndHeaderContent);
    }
  };

  /**
   * Empties the headerLabels
   * @private
   */
  DvtDataGrid.prototype._emptyHeaderLabels = function () {
    var rowHeaderLabels = this.m_headerLabels.row;
    var rowEndHeaderLabels = this.m_headerLabels.rowEnd;
    var columnHeaderLabels = this.m_headerLabels.column;
    var columnEndHeaderLabels = this.m_headerLabels.columnEnd;
    if (rowHeaderLabels && rowHeaderLabels.length) {
      rowHeaderLabels.forEach((rowLabel) => {
        this.m_utils.empty(rowLabel);
      });
    }
    if (rowEndHeaderLabels && rowEndHeaderLabels.length) {
      rowEndHeaderLabels.forEach((rowEndLabel) => {
        this.m_utils.empty(rowEndLabel);
      });
    }
    if (columnHeaderLabels && columnHeaderLabels.length) {
      columnHeaderLabels.forEach((columnLabel) => {
        this.m_utils.empty(columnLabel);
      });
    }
    if (columnEndHeaderLabels && columnEndHeaderLabels.length) {
      columnEndHeaderLabels.forEach((columnEndLabel) => {
        this.m_utils.empty(columnEndLabel);
      });
    }
  };

  /** ********************************** active cell navigation ******************************/
  /**
   * Sets the active cell by index
   * @param {Object} index row and column index
   * @param {Event=} event the DOM event causing the active cell change
   * @param {boolean=} clearSelection true if we should clear the selection on active change
   * @param {boolean=} silent
   * @param {boolean=} shouldNotScroll
   * @private
   * @return {boolean} true if active was changed, false if not
   */
  DvtDataGrid.prototype._setActiveByIndex = function (
    index,
    event,
    clearSelection,
    silent,
    shouldNotScroll
  ) {
    let cell = this._getCellByIndex(index);
    return this._setActive(
      cell,
      { type: 'cell', indexes: index },
      event,
      clearSelection,
      silent,
      shouldNotScroll
    );
  };

  /**
   * Updates the active cell based on external set, do not fire events
   * @param {Object} activeObject set by application could be sparse
   * @param {boolean} shouldFocus
   * @param {boolean=} shouldNotScroll
   * @private
   */
  DvtDataGrid.prototype._updateActive = function (activeObject, shouldFocus, shouldNotScroll) {
    // the activeObject is potentially sparse, try to get an element from it
    var newActiveElement;

    if (activeObject == null) {
      this._setActive(null, null, null, true, false, shouldNotScroll);
    } else if (activeObject.keys != null) {
      newActiveElement = this._getCellByKeys(activeObject.keys);
    } else if (activeObject.indexes != null) {
      newActiveElement = this._getCellByIndex(activeObject.indexes);
    } else if (activeObject.axis != null) {
      var level = activeObject.level == null ? 0 : activeObject.level;
      if (activeObject.axis === 'column') {
        if (activeObject.key != null) {
          newActiveElement = this._findHeaderByKey(
            activeObject.key,
            this.m_colHeader,
            this.getMappedStyle('colheadercell')
          );
        } else if (activeObject.index != null) {
          newActiveElement = this._getHeaderByIndex(activeObject.index, activeObject.axis, level);
        } else if (activeObject.type === 'label') {
          newActiveElement = this._getLabel(activeObject.axis, activeObject.level);
        }
      } else if (activeObject.axis === 'row') {
        if (activeObject.key != null) {
          newActiveElement = this._findHeaderByKey(
            activeObject.key,
            this.m_rowHeader,
            this.getMappedStyle('rowheadercell')
          );
        } else if (activeObject.index != null) {
          newActiveElement = this._getHeaderByIndex(activeObject.index, activeObject.axis, level);
        } else if (activeObject.type === 'label') {
          newActiveElement = this._getLabel(activeObject.axis, activeObject.level);
        }
      } else if (activeObject.axis === 'columnEnd') {
        if (activeObject.key != null) {
          newActiveElement = this._findHeaderByKey(
            activeObject.key,
            this.m_colEndHeader,
            this.getMappedStyle('colendheadercell')
          );
        } else if (activeObject.index != null) {
          newActiveElement = this._getHeaderByIndex(activeObject.index, activeObject.axis, level);
        } else if (activeObject.type === 'label') {
          newActiveElement = this._getLabel(activeObject.axis, activeObject.level);
        }
      } else if (activeObject.axis === 'rowEnd') {
        if (activeObject.key != null) {
          newActiveElement = this._findHeaderByKey(
            activeObject.key,
            this.m_rowEndHeader,
            this.getMappedStyle('rowendheadercell')
          );
        } else if (activeObject.index != null) {
          newActiveElement = this._getHeaderByIndex(activeObject.index, activeObject.axis, level);
        } else if (activeObject.type === 'label') {
          newActiveElement = this._getLabel(activeObject.axis, activeObject.level);
        }
      }
    }

    if (newActiveElement != null) {
      if (!shouldFocus) {
        this.m_shouldFocus = false;
      }
      this._setActive(newActiveElement, activeObject, null, true, false, shouldNotScroll);
    }
  };

  /**
   * Sets the active cell or header by element
   * @param {Element|null} element to set active to
   * @param {Event|null=} event the DOM event causing the active cell change
   * @param {boolean|null=} clearSelection true if we should clear the selection on active change
   * @param {boolean|null=} silent true if we should not fire events
   * @param {boolean|null=} shouldNotScroll true if we should not scroll before setting active (in case it came froma  scroll event, prevent loop)
   * @param {boolean|null=} shouldNotFocusIn true coming from case where somthing is already focused and would just like to set active
   * @returns {boolean} true if active was changed, false if not
   */
  DvtDataGrid.prototype._setActive = function (
    element,
    cellInfo,
    event,
    clearSelection,
    silent,
    shouldNotScroll,
    shouldNotFocusIn
  ) {
    if (cellInfo != null && !shouldNotScroll) {
      this._scrollToActive(cellInfo);
    }

    var active;

    // element always non-null for labels
    if (element != null) {
      active = this._createActiveObject(element);
      // see if the active cell is actually changing
      if (this._compareActive(active, this.m_active)) {
        // fire vetoable beforeCurrentCell event
        if (silent || this._fireBeforeCurrentCellEvent(active, this.m_active, event)) {
          this.m_prevActive = this.m_active;
          this.m_active = active;

          // Disable previous active element's focusable content
          const prevActiveElement = this._getElementFromActiveObject(this.m_prevActive);
          if (prevActiveElement) {
            DataCollectionUtils.disableAllFocusableElements(prevActiveElement);
          }

          if (event && (event.type === 'mousedown' || event.type === 'touchend')) {
            this.m_trueIndex = null;
          }

          if (clearSelection && this._isSelectionEnabled()) {
            this._clearSelection(event);
          }
          this.deleteDatabodyHiddenVisualIndicators();
          this._unhighlightActiveObject(this.m_prevActive);
          this._highlightActiveObject(this.m_active, this.m_prevActive, null, shouldNotScroll);
          this._manageMoveCursor();
          if (this._isGridEditable()) {
            if (active.type === 'cell') {
              this._setEditableClone(element);
              this._updateEdgeCellBorders('');
            }
          }
          if (!silent) {
            this._fireCurrentCellEvent(active, event);
          }
          if (
            this.m_options.isFloodFillEnabled() &&
            this._isSelectionEnabled() &&
            !this.m_discontiguousSelection &&
            this.m_active.type === 'cell' &&
            event
          ) {
            this._addFloodfillAffordance(event);
            this._moveFloodFillAffordance();
          }
          return true;
        }
      } else {
        // still wanted to make sure the cell was highlighted even if focus hasn't actually changed
        this._highlightActive(null, shouldNotFocusIn);
      }
    } else if (!this.m_scrollIndexAfterFetch && !this.m_scrollHeaderAfterFetch) {
      if (silent || this._fireBeforeCurrentCellEvent(active, this.m_active, event)) {
        this.m_prevActive = this.m_active;
        this.m_active = null;
        this._unhighlightActiveObject(this.m_prevActive);
        if (!silent) {
          this._fireCurrentCellEvent(active, event);
        }
      }
      return true;
    }
    return false;
  };

  /**
   * Create an active object from an element active object contains:
   * For header: type, axis, index, key, level
   * For cell: indexes, keys
   * @param {Element} element - the element to create an active object from
   * @return {Object} an active object
   */
  DvtDataGrid.prototype._createActiveObject = function (element) {
    var context = element[this.getResources().getMappedAttribute('context')];
    if (
      this.m_utils.containsCSSClassName(element, this.getMappedStyle('headercell')) ||
      this.m_utils.containsCSSClassName(element, this.getMappedStyle('endheadercell'))
    ) {
      return {
        type: 'header',
        axis: context.axis,
        index: this.getHeaderCellIndex(element),
        key: context.key,
        level: context.level
      };
    }
    if (this.m_utils.containsCSSClassName(element, this.getMappedStyle('headerlabel'))) {
      return {
        type: 'label',
        axis: context.axis,
        level: context.level
      };
    }
    // for empty/NoData
    if (
      this.m_utils.containsCSSClassName(element, this.getMappedStyle('noDataContainer')) ||
      this.m_utils.containsCSSClassName(element, this.getMappedStyle('emptytext'))
    ) {
      return {
        type: 'empty'
      };
    }

    return {
      type: 'cell',
      indexes: {
        row: context.indexes.row,
        column: context.indexes.column
      },
      keys: {
        row: context.keys.row,
        column: context.keys.column
      },
      extents: {
        row: context.extents.row,
        column: context.extents.column
      }
    };
  };

  /**
   * Retrieve the active element.
   * @return {Element|null} the active cell or header cell
   * @private
   */
  DvtDataGrid.prototype._getActiveElement = function () {
    return this._getElementFromActiveObject(this.m_active);
  };

  /**
   * Retrieve the element based on an active object.
   * @param {Object} active the object to get the element of
   * @return {Element|null} the active cell or header cell
   * @private
   */
  DvtDataGrid.prototype._getElementFromActiveObject = function (active) {
    if (active != null) {
      if (active.type === 'header') {
        if (active.axis === 'row') {
          let root = this.m_rowHeader;
          if (this._hasFrozenRows() && active.index <= this.m_frozenRowIndex) {
            root = this.m_rowHeaderFrozen;
          }
          return this._findHeaderByKey(active.key, root, this.getMappedStyle('rowheadercell'));
        } else if (active.axis === 'column') {
          let root = this.m_colHeader;
          if (this._hasFrozenColumns() && active.index <= this.m_frozenColIndex) {
            root = this.m_colHeaderFrozen;
          }
          return this._findHeaderByKey(active.key, root, this.getMappedStyle('colheadercell'));
        } else if (active.axis === 'rowEnd') {
          let root = this.m_rowEndHeader;
          if (this._hasFrozenRows() && active.index <= this.m_frozenRowIndex) {
            root = this.m_rowEndHeaderFrozen;
          }
          return this._findHeaderByKey(active.key, root, this.getMappedStyle('rowendheadercell'));
        } else if (active.axis === 'columnEnd') {
          let root = this.m_colEndHeader;
          if (this._hasFrozenColumns() && active.index <= this.m_frozenColIndex) {
            root = this.m_colEndHeaderFrozen;
          }
          return this._findHeaderByKey(active.key, root, this.getMappedStyle('colendheadercell'));
        }
      } else if (active.type === 'label') {
        return this._getLabel(active.axis, active.level);
      } else if (active.type === 'empty') {
        return this._getEmptyElement();
      } else {
        return this._getCellByIndex(active.indexes);
      }
    }
    return null;
  };

  /**
   * Compare two active objects to see if they are equal
   * @param {Object} active1 an active object
   * @param {Object} active2 a comparison active object
   * @return {boolean} true if not equal
   */
  DvtDataGrid.prototype._compareActive = function (active1, active2) {
    if (active1 == null && active2 == null) {
      return false;
    } else if ((active1 == null && active2 != null) || (active1 != null && active2 == null)) {
      return true;
    } else if (active1.type === active2.type) {
      if (active1.type === 'empty') {
        return true;
      } else if (active1.type === 'header') {
        if (
          active1.index !== active2.index ||
          active1.key !== active2.key ||
          active1.axis !== active2.axis ||
          active1.level !== active2.level
        ) {
          return true;
        }
      } else if (active1.type === 'label') {
        if (active1.axis !== active2.axis || active1.level !== active2.level) {
          return true;
        }
      } else if (
        active1.indexes.row !== active2.indexes.row ||
        active1.indexes.column !== active2.indexes.column ||
        active1.keys.row !== active2.keys.row ||
        active1.keys.column !== active2.keys.column
      ) {
        return true;
      }
    } else {
      return true;
    }
    return false;
  };

  /**
   * Fires an event before the current cell changes
   * @param {Object|undefined} newActive the new active information
   * @param {Object} oldActive the new active information
   * @param {Event|undefined} event the DOM event
   * @private
   * @return {boolean|undefined} true if event should continue
   */
  DvtDataGrid.prototype._fireBeforeCurrentCellEvent = function (newActive, oldActive, event) {
    // the event contains the context info
    var details = {
      event: event,
      ui: {
        currentCell: newActive,
        previousCurrentCell: oldActive
      }
    };

    return this.fireEvent('beforeCurrentCell', details);
  };

  /**
   * Fires an event to tell the datagrid to update the currentCell option
   * @param {Object|undefined} active the new active information
   * @param {Event|undefined} event the DOM event
   * @private
   */
  DvtDataGrid.prototype._fireCurrentCellEvent = function (active, event) {
    // the event contains the context info
    var details = {
      event: event,
      ui: active
    };

    return this.fireEvent('currentCell', details);
  };

  /**
   * Is the databody cell active
   * @return {boolean} true if active element is a cell
   * @private
   */
  DvtDataGrid.prototype._isDatabodyCellActive = function () {
    return this.m_active != null && this.m_active.type === 'cell';
  };

  /**
   * Update the context info based on active changess
   * @param {Object} activeObject
   * @param {Object} prevActiveObject
   */
  DvtDataGrid.prototype._updateActiveContext = function (activeObject, prevActiveObject) {
    var axis;
    var level;
    var skip;
    var contextObj = {};

    if (activeObject.type === 'header') {
      axis = activeObject.axis;
      var index = activeObject.index;
      level = activeObject.level;

      if (activeObject.axis === 'row') {
        if (this.m_rowHeaderLevelCount > 1) {
          if (
            prevActiveObject == null
              ? true
              : !(level === prevActiveObject.level && axis === prevActiveObject.axis)
          ) {
            contextObj.level = level;
          }
        }
        if (
          prevActiveObject == null
            ? true
            : !(index === prevActiveObject.index && axis === prevActiveObject.axis)
        ) {
          contextObj.rowHeader = index;
        }
      } else if (axis === 'column') {
        if (this.m_columnHeaderLevelCount > 1) {
          if (
            prevActiveObject == null
              ? true
              : !(level === prevActiveObject.level && axis === prevActiveObject.axis)
          ) {
            contextObj.level = level;
          }
        }
        if (
          prevActiveObject == null
            ? true
            : !(index === prevActiveObject.index && axis === prevActiveObject.axis)
        ) {
          contextObj.columnHeader = index;
        }
      } else if (activeObject.axis === 'rowEnd') {
        if (this.m_rowEndHeaderLevelCount > 1) {
          if (
            prevActiveObject == null
              ? true
              : !(level === prevActiveObject.level && axis === prevActiveObject.axis)
          ) {
            contextObj.level = level;
          }
        }
        if (
          prevActiveObject == null
            ? true
            : !(index === prevActiveObject.index && axis === prevActiveObject.axis)
        ) {
          contextObj.rowEndHeader = index;
        }
      } else if (axis === 'columnEnd') {
        if (this.m_columnEndHeaderLevelCount > 1) {
          if (
            prevActiveObject == null
              ? true
              : !(level === prevActiveObject.level && axis === prevActiveObject.axis)
          ) {
            contextObj.level = level;
          }
        }
        if (
          prevActiveObject == null
            ? true
            : !(index === prevActiveObject.index && axis === prevActiveObject.axis)
        ) {
          contextObj.columnEndHeader = index;
        }
      }
      // update context info
      this._updateContextInfo(contextObj, skip);
    } else if (activeObject.type === 'cell') {
      // check whether the prev and current active cell is in the same row/column so that we can
      // skip row/column header info in aria-labelledby (to make the description more brief)
      if (
        prevActiveObject != null &&
        prevActiveObject.type === 'cell' &&
        activeObject != null &&
        !this.m_externalFocus
      ) {
        if (activeObject.indexes.row === prevActiveObject.indexes.row) {
          skip = 'row';
        } else if (activeObject.indexes.column === prevActiveObject.indexes.column) {
          skip = 'column';
        }
      }
      // update context info
      this._updateContextInfo(activeObject, skip);
    } else if (activeObject.type === 'label') {
      axis = activeObject.axis;
      level = activeObject.level;

      if (
        prevActiveObject == null ||
        prevActiveObject.type !== 'label' ||
        (prevActiveObject.type === 'label' && prevActiveObject.axis !== axis) ||
        this.m_externalFocus
      ) {
        if (axis === 'column') {
          contextObj.columnHeaderLabel = level;
        } else if (axis === 'row') {
          contextObj.rowHeaderLabel = level;
        } else if (axis === 'rowEnd') {
          contextObj.rowEndHeaderLabel = level;
        } else if (axis === 'columnEnd') {
          contextObj.columnEndHeaderLabel = level;
        }
      }

      this._updateContextInfo(contextObj, skip);
    }
  };

  /**
   * Handles click to make a cell active
   * @param {Event} event
   * @private
   */
  DvtDataGrid.prototype.handleDatabodyClickActive = function (event) {
    var target = /** @type {Element} */ (event.target);
    var cell = this.findCell(target);
    if (cell != null) {
      this._setActive(cell, this._createActiveObject(cell), event);
    }
    const noDataSlotElement = this._getEmptyElement();
    if (noDataSlotElement) {
      this._setActive(noDataSlotElement, this._createActiveObject(noDataSlotElement), event);
    }
  };

  /**
   * Handles click to select a header
   * @param {Event} event
   */
  DvtDataGrid.prototype.handleHeaderClickActive = function (event, activeOnly, shouldNotScroll) {
    var target = /** @type {Element} */ (event.target);
    var header = this.findHeader(target);
    if (header != null) {
      if (!activeOnly) {
        this._clearSelection(event);
      }
      this._setActive(header, this._createActiveObject(header), event, null, null, shouldNotScroll);
    }
  };

  /**
   * Scroll to the active object
   * @param {Object} activeObject
   */
  DvtDataGrid.prototype._scrollToActive = function (activeObject) {
    if (activeObject.type === 'header') {
      this.scrollToHeader(activeObject);
    } else if (activeObject.type === 'cell') {
      this.scrollToIndex(activeObject.indexes);
    }
    // do nothing if label
  };

  /**
   * Retrieve cell by keys, this is rarely used, more common to look up cells by index within the data grid
   * @param {Object} keys
   * @return {Element|null} the active cell
   * @private
   */
  DvtDataGrid.prototype._getCellByKeys = function (keys) {
    if (
      keys == null ||
      keys.row == null ||
      keys.column == null ||
      this.m_databody == null ||
      this.m_databody.firstChild == null
    ) {
      return null;
    }

    var databodyContent = this.m_databody.firstChild;
    var cells = databodyContent.getElementsByClassName(this.getMappedStyle('cell'));
    for (var i = 0; i < cells.length; i++) {
      var cell = cells[i];
      var rowKey = this._getKey(cell, 'row');
      if (this._shallowThenDeepCompare(rowKey, keys.row)) {
        var columnKey = this._getKey(cell, 'column');
        if (this._shallowThenDeepCompare(columnKey, keys.column)) {
          return cell;
        }
      }
    }

    return null;
  };

  /**
   * @param {any} value1
   * @param {any} value2
   * @return {boolean}
   * @private
   */
  DvtDataGrid.prototype._shallowThenDeepCompare = function (value1, value2) {
    if (value1 === value2) {
      return true;
    }
    return this._compareValuesCallback(value1, value2);
  };

  /**
   * Retrieve the keys of a cell
   * @param {Element} cell
   * @return {Object}
   */
  DvtDataGrid.prototype.getCellKeys = function (cell) {
    var cellContext = cell[this.getResources().getMappedAttribute('context')];
    return this.createIndex(cellContext.keys.row, cellContext.keys.column);
  };

  /**
   * Retrieve the indexes of a cell
   * @param {Element} cell
   * @return {Object}
   */
  DvtDataGrid.prototype.getCellIndexes = function (cell) {
    var cellContext = cell[this.getResources().getMappedAttribute('context')];
    return this.createIndex(cellContext.indexes.row, cellContext.indexes.column);
  };

  /**
   * Retrieve the extents of a cell
   * @param {Element} cell
   * @return {Object}
   */
  DvtDataGrid.prototype.getCellExtents = function (cell) {
    var cellContext = cell[this.getResources().getMappedAttribute('context')];
    return this.createIndex(cellContext.extents.row, cellContext.extents.column);
  };

  /**
   * Retrieve the end indexes of a cell (index + extent - 1)
   * @param {Element} cell
   * @return {Object}
   */
  DvtDataGrid.prototype.getCellEndIndexes = function (cell) {
    var cellIndexes = this.getCellIndexes(cell);
    var cellExtents = this.getCellExtents(cell);
    return this.createIndex(
      cellIndexes.row + (cellExtents.row - 1),
      cellIndexes.column + (cellExtents.column - 1)
    );
  };

  /**
   * Retrieve the index of a cell/header along a given axis
   * @param {Element|undefined|null} element
   * @param {string=} axis
   * @return {number|null}
   */
  DvtDataGrid.prototype._getIndex = function (element, axis) {
    if (element != null) {
      if (axis != null && this.m_utils.containsCSSClassName(element, this.getMappedStyle('cell'))) {
        var cellContext = element[this.getResources().getMappedAttribute('context')];
        if (axis === 'row') {
          return cellContext.indexes.row;
        }
        if (axis === 'column') {
          return cellContext.indexes.column;
        }
      } else {
        return this.getHeaderCellIndex(element);
      }
    }
    return null;
  };

  /**
   * Retrieve the extent of a cell along a given axis
   * @param {Element|undefined|null} element
   * @param {string} axis
   * @return {number|null}
   */
  DvtDataGrid.prototype._getExtent = function (element, axis) {
    if (element != null) {
      if (axis != null && this.m_utils.containsCSSClassName(element, this.getMappedStyle('cell'))) {
        var cellContext = element[this.getResources().getMappedAttribute('context')];
        if (axis === 'row') {
          return cellContext.extents.row;
        }
        if (axis === 'column') {
          return cellContext.extents.column;
        }
      } else {
        return parseInt(this._getAttribute(element, 'extent', true), 10);
      }
    }
    return null;
  };

  /**
   * Retrieve the index of a header cell
   * @param {Element} header header cell element
   * @return {number}
   */
  DvtDataGrid.prototype.getHeaderCellIndex = function (header) {
    var levelCount;
    var start;
    var index;
    let frozenRoot;
    let headerElement = header;
    let className = this.getMappedStyle('headercell');

    var axis = this.getHeaderCellAxis(header);
    switch (axis) {
      case 'column':
        levelCount = this.m_columnHeaderLevelCount;
        start = this.m_startColHeader;
        if (this._hasFrozenColumns()) {
          frozenRoot = this.m_colHeaderFrozen;
        }
        break;
      case 'row':
        levelCount = this.m_rowHeaderLevelCount;
        start = this.m_startRowHeader;
        if (this._hasFrozenRows()) {
          frozenRoot = this.m_rowHeaderFrozen;
        }
        break;
      case 'columnEnd':
        levelCount = this.m_columnEndHeaderLevelCount;
        start = this.m_startColEndHeader;
        if (this._hasFrozenColumns()) {
          frozenRoot = this.m_colEndHeaderFrozen;
        }
        className = this.getMappedStyle('endheadercell');
        break;
      case 'rowEnd':
        levelCount = this.m_rowEndHeaderLevelCount;
        start = this.m_startRowEndHeader;
        if (this._hasFrozenRows()) {
          frozenRoot = this.m_rowEndHeaderFrozen;
        }
        className = this.getMappedStyle('endheadercell');
        break;
      default:
        return -1;
    }

    // if there are multiple levels on the row header
    if (levelCount > 1) {
      // get the groupingContainer's start value and set thtat to the index
      index = /** @type {number} */ (this._getAttribute(header.parentNode, 'start', true));
      // if this is the groupingContainer's first child rturn that value
      if (header === header.parentNode.firstChild) {
        return index;
      }
      // decrement the index by one for the first header element at the level above it
      index -= 1;
    } else {
      index = start;
    }

    // To get header Index, make sure we don't get other children divs (like visual indicator)
    // check divs if they aren't hiddenIndicators by 'colHeaderHiddenIndicator' class name
    // eslint-disable-next-line no-param-reassign
    headerElement = this._getHeaderPreviousSibling(headerElement);
    while (headerElement) {
      index += 1;
      // eslint-disable-next-line no-param-reassign
      headerElement = this._getHeaderPreviousSibling(headerElement);
    }

    if (
      levelCount === 1 &&
      frozenRoot !== undefined &&
      frozenRoot.querySelector(`#${header.id}`) === null
    ) {
      index += this._getChildElementCountByClassName(frozenRoot.firstChild, className);
    }

    return index;
  };

  /**
   * Retrieve the axis of a header cell
   * @param {Element|undefined|null} header header cell element
   * @return {string|null} row or column
   */
  DvtDataGrid.prototype.getHeaderCellAxis = function (header) {
    if (this.m_utils.containsCSSClassName(header, this.getMappedStyle('colheadercell'))) {
      return 'column';
    } else if (this.m_utils.containsCSSClassName(header, this.getMappedStyle('rowheadercell'))) {
      return 'row';
    } else if (this.m_utils.containsCSSClassName(header, this.getMappedStyle('rowendheadercell'))) {
      return 'rowEnd';
    } else if (this.m_utils.containsCSSClassName(header, this.getMappedStyle('colendheadercell'))) {
      return 'columnEnd';
    }
    return null;
  };

  /**
   * Retrieve the level of a header cell
   * @param {Element} header header cell element
   * @return {number|string} row or column
   */
  DvtDataGrid.prototype.getHeaderCellLevel = function (header) {
    if (this.m_utils.containsCSSClassName(header, this.getMappedStyle('colheadercell'))) {
      if (this.m_columnHeaderLevelCount === 1) {
        return 0;
      }
    } else if (this.m_utils.containsCSSClassName(header, this.getMappedStyle('rowheadercell'))) {
      if (this.m_rowHeaderLevelCount === 1) {
        return 0;
      }
    } else if (this.m_utils.containsCSSClassName(header, this.getMappedStyle('colendheadercell'))) {
      if (this.m_columnEndHeaderLevelCount === 1) {
        return 0;
      }
    } else if (this.m_utils.containsCSSClassName(header, this.getMappedStyle('rowendheadercell'))) {
      if (this.m_rowEndHeaderLevelCount === 1) {
        return 0;
      }
    }

    var level = this._getAttribute(header.parentNode, 'level', true);
    if (header === header.parentNode.firstChild) {
      return level;
    }
    // plus one case is if we are on the innermost level the headers do not have their own
    // grouping containers so if it is the first child it is the level of the grouping container
    // but all subsequent children are the next level in
    return level + this.getHeaderCellDepth(header.parentNode.firstChild);
  };

  /**
   * Retrieve the depth of a header cell
   * @param {Element} header header cell element
   * @return {string|number|null} row or column depth
   */
  DvtDataGrid.prototype.getHeaderCellDepth = function (header) {
    return this._getAttribute(header, 'depth', true);
  };

  DvtDataGrid.prototype.getHeaderLabelLevel = function (headerLabel) {
    let context = headerLabel[this.getResources().getMappedAttribute('context')];
    if (context) {
      return context.level;
    }
    return null;
  };

  /**
   * Retrieve the axis of a header cell
   * @param {Element|undefined|null} header header cell element
   * @return {string|null} row or column
   */
  DvtDataGrid.prototype.getHeaderLabelAxis = function (headerLabel) {
    let context = headerLabel[this.getResources().getMappedAttribute('context')];
    if (context) {
      return context.axis;
    }
    return null;
  };

  /**
   * Get resize header mode.
   * @param {Element|undefined|null} element header/header label element
   * @return {string|null} row or column
   */
  DvtDataGrid.prototype._getResizeHeaderMode = function (element) {
    var resizeHeaderMode = 'row';
    if (
      this.m_utils.containsCSSClassName(element, this.getMappedStyle('colheadercell')) ||
      this.m_utils.containsCSSClassName(element, this.getMappedStyle('colendheadercell')) ||
      this.m_utils.containsCSSClassName(element, this.getMappedStyle('columnheaderlabel')) ||
      this.m_utils.containsCSSClassName(element, this.getMappedStyle('columnendheaderlabel'))
    ) {
      resizeHeaderMode = 'column';
    }
    return resizeHeaderMode;
  };

  /**
   * Find the cell or header element (recursively if needed)
   * @private
   * @param {Element} elem
   * @return {Element|undefined|null}
   */
  DvtDataGrid.prototype.findCellOrHeader = function (elem) {
    var cell = this.findCell(elem);
    if (cell == null) {
      cell = this.findHeader(elem);
    }
    return cell;
  };

  /**
   * Find the cell element (recursively if needed)
   * @private
   * @param {Element} elem
   * @return {Element|undefined|null}
   */
  DvtDataGrid.prototype.findCell = function (elem) {
    return this.find(elem, 'cell');
  };

  /**
   * Find the label element (recursively if needed)
   * @private
   * @param {Element} elem
   * @return {Element|undefined|null}
   */
  DvtDataGrid.prototype.findLabel = function (elem) {
    return this.find(elem, 'headerlabel');
  };

  /**
   * Find the cell element (recursively if needed)
   * @param {Element|undefined|null} elem
   * @param {string} key
   * @param {string=} className
   * @return {Element|undefined|null}
   */
  DvtDataGrid.prototype.find = function (elem, key, className) {
    // if element is null or if we reach the root of DataGrid
    if (elem == null || elem === this.getRootElement()) {
      return null;
    }

    // recursively walk up the element and find the class name that matches the cell class name
    if (className == null) {
      // eslint-disable-next-line no-param-reassign
      className = this.getMappedStyle(key);
    }

    if (className == null) {
      return null;
    }

    // if the element contains the cell class name, then it's a cell, otherwise go up
    if (this.m_utils.containsCSSClassName(elem, className)) {
      return elem;
    }
    return this.find(elem.parentNode, key, className);
  };

  /**
   * Highlight the current active element
   * @param {Array=} classNames string of classNames to add to active element
   * @param {boolean|null=} shouldNotFocusIn true coming from case where somthing is already focused and would just like to set active
   * @private
   */
  DvtDataGrid.prototype._highlightActive = function (classNames, shouldNotFocusIn) {
    this._highlightActiveObject(this.m_active, this.m_prevActive, classNames, null, shouldNotFocusIn);
  };

  /**
   * Unhighlight the current active element
   * @param {Array=} classNames string of classNames to remove from active element
   * @private
   */
  DvtDataGrid.prototype._unhighlightActive = function (classNames) {
    this._unhighlightActiveObject(this.m_active, classNames);
  };

  /**
   * Highlight the specified object
   * @param {Object} activeObject active to unhighlight
   * @param {Object} prevActiveObject last active to base aria properties on
   * @param {Array=} classNames string of classNames to add to active element
   * @param {boolean|null=} shouldNotScroll boolean if element should be scrolled into view
   * @param {boolean|null=} shouldNotFocusIn true coming from case where somthing is already focused and would just like to set active
   * @private
   */
  DvtDataGrid.prototype._highlightActiveObject = function (
    activeObject,
    prevActiveObject,
    classNames,
    shouldNotScroll,
    shouldNotFocusIn
  ) {
    if (classNames == null && this.m_utils.shouldOffsetOutline()) {
      // eslint-disable-next-line no-param-reassign
      classNames = ['offsetOutline'];
    }
    if (activeObject != null) {
      var element = this._getElementFromActiveObject(activeObject);
      // possible in the virtual case
      if (element != null) {
        if (!shouldNotFocusIn) {
          this.m_focusInHandler(element);
        }
        if (classNames != null) {
          this._highlightElement(element, classNames);
        }
        if (this._isCellEditable() && activeObject.type === 'cell') {
          this._applyBorderClassesAroundRange(
            element,
            { startIndex: activeObject.indexes },
            true,
            'Edit'
          );
        }
        this._setAriaProperties(activeObject, prevActiveObject, element, shouldNotScroll);
      }
    }
  };

  /**
   * Unhighlight the specified object
   * @param {Object} activeObject to unhighlight
   * @param {Array=} classNames string of classNames to remove from active element
   * @private
   */
  DvtDataGrid.prototype._unhighlightActiveObject = function (activeObject, classNames) {
    if (classNames == null && this.m_utils.shouldOffsetOutline()) {
      // eslint-disable-next-line no-param-reassign
      classNames = ['offsetOutline'];
    }
    if (activeObject != null) {
      var element = this._getElementFromActiveObject(activeObject);
      if (element != null) {
        this.m_focusOutHandler(element);
        if (classNames != null) {
          this._unhighlightElement(element, classNames);
        }
        if (this._isGridEditable() && activeObject.type === 'cell') {
          this._applyBorderClassesAroundRange(
            element,
            { startIndex: activeObject.indexes },
            false,
            'Edit'
          );
        }
        this._unsetAriaProperties(element);
      }
    }
  };

  /**
   * Highlight all the cells in a row
   * @param {number|string|null} value key/index
   * @param {string} axis
   * @param {string} indexOrKey
   * @param {string} addOrRemove
   * @param {Array} classNames
   */
  DvtDataGrid.prototype._highlightCellsAlongAxis = function (
    value,
    axis,
    indexOrKey,
    addOrRemove,
    classNames
  ) {
    var cells =
      indexOrKey === 'key'
        ? this._getAxisCellsByKey(/** @type {string} */ (value), axis)
        : this._getAxisCellsByIndex(/** @type {number} */ (value), axis);

    for (var i = 0; i < cells.length; i++) {
      if (addOrRemove === 'add') {
        this._highlightElement(cells[i], classNames);
      } else {
        this._unhighlightElement(cells[i], classNames);
      }
    }
  };

  /**
   * Highlight an element adding classes in the provided array
   * @param {Element} element
   * @param {Array} classNames
   */
  DvtDataGrid.prototype._highlightElement = function (element, classNames) {
    for (var i = 0; i < classNames.length; i++) {
      var className = this.getMappedStyle(classNames[i]);
      this.m_utils.addCSSClassName(element, className);
    }
  };

  /**
   * Unhighlight an element removing classes in the provided array
   * @param {Element} element
   * @param {Array} classNames
   */
  DvtDataGrid.prototype._unhighlightElement = function (element, classNames) {
    for (var i = 0; i < classNames.length; i++) {
      var className = this.getMappedStyle(classNames[i]);
      this.m_utils.removeCSSClassName(element, className);
    }
  };

  /**
   * Unhighlight elements removing classes in the provided array
   * @param {Array} elements
   * @param {Array} classNames
   */
  DvtDataGrid.prototype._unhighlightElementsByClassName = function (elements, classNames) {
    if (elements.length && classNames.length) {
      for (var i = 0; i < elements.length; i++) {
        this._unhighlightElement(elements[i], classNames);
      }
    }
  };

  /**
   * Reset all wai-aria properties on a cell or header.
   * @param {Object} activeObject active to unhighlight
   * @param {Object} prevActiveObject last active to base aria properties on
   * @param {Element} element the element to reset all wai-aria properties
   * @param {boolean|null=} shouldNotScroll boolean if element should be scrolled into view
   * @private
   */
  DvtDataGrid.prototype._setAriaProperties = function (
    activeObject,
    prevActiveObject,
    element,
    shouldNotScroll
  ) {
    var label = this.getLabelledBy(activeObject, prevActiveObject, element);
    this._updateActiveContext(activeObject, prevActiveObject);

    element.setAttribute('tabIndex', 0);
    element.setAttribute('aria-labelledby', label);
    element.setAttribute('role', 'application');

    // check to see if we should focus on the cell later
    if (
      (this.m_cellToFocus == null || this.m_cellToFocus !== element) &&
      this.m_shouldFocus !== false
    ) {
      element.focus({ preventScroll: shouldNotScroll });
    }
    this.m_shouldFocus = null;
  };

  /**
   * Reset all wai-aria properties on a cell or header.
   * @param {Element} element the element to reset all wai-aria properties.
   */
  DvtDataGrid.prototype._unsetAriaProperties = function (element) {
    if (element != null) {
      // reset focus index
      element.setAttribute('tabIndex', -1);
      // remove aria related attributes
      element.removeAttribute('aria-labelledby');
      element.removeAttribute('role');
      if (DataCollectionUtils.isIos()) {
        element.setAttribute('role', 'text');
      }
    }
  };

  /**
   * Returns the wai-aria labelled by property for a cell
   * @param {Object} activeObject
   * @param {Object} prevActiveObject
   * @param {Element} element
   * @param {boolean | undefined} isIosRender for accessibility in ios on render need header and label info but not state or context
   * @return {string} the wai-aria labelled by property for the cell
   */
  DvtDataGrid.prototype.getLabelledBy = function (
    activeObject,
    prevActiveObject,
    element,
    isIosRender
  ) {
    var previousElement;
    var key;
    var previousRowIndex;
    var previousColumnIndex;
    var label = '';
    var statesArray = [];
    const elementMetadata = element[this.getResources().getMappedAttribute('metadata')];

    if (activeObject.type === 'header') {
      // get the previous active header to compare what the screen reader needs to read for parent Ids,
      // should only need this if multi level header
      if (prevActiveObject != null && prevActiveObject.type === 'header' && !this.m_externalFocus) {
        // remove optimization
        previousElement = this._getHeaderByIndex(
          prevActiveObject.index,
          prevActiveObject.axis,
          prevActiveObject.level
        );
      }

      label = [
        this.createSubId('context'),
        this._getHeaderAndParentIds(element, previousElement)
      ].join(' ');
      var direction = element.getAttribute(this.getResources().getMappedAttribute('sortDir'));
      if (direction === 'ascending') {
        key = 'accessibleSortAscending';
      } else if (direction === 'descending') {
        key = 'accessibleSortDescending';
      } else if (this._getAttribute(element, 'sortable')) {
        key = 'accessibleSortable';
      }

      if (key != null) {
        statesArray.push({ key: key, args: { id: '' } });
      }

      if (elementMetadata && elementMetadata.metadata) {
        if (elementMetadata.metadata.expanded === 'expanded') {
          statesArray.push({ key: 'accessibleExpanded', args: {} });
        } else if (elementMetadata.metadata.expanded === 'collapsed') {
          statesArray.push({ key: 'accessibleCollapsed', args: {} });
        }
        const treeDepth = elementMetadata.metadata.treeDepth;
        if (treeDepth != null) {
          let isDone;
          let endHeader;
          let startHeader;
          if (activeObject.axis === 'row') {
            isDone = this.m_stopRowHeaderFetch && this.m_stopRowEndHeaderFetch && this.m_stopRowFetch;
            endHeader = this.m_endRowHeader;
            startHeader = this.m_startRowHeader;
          } else if (activeObject.axis === 'column') {
            endHeader = this.m_endColHeader;
            startHeader = this.m_startColHeader;
            isDone =
              this.m_stopColumnHeaderFetch &&
              this.m_stopColumnEndHeaderFetch &&
              this.m_stopColumnFetch;
          }
          statesArray.push({
            key: 'accessibleLevelHierarchicalContext',
            args: { level: treeDepth + 1 }
          });
          let setSize;
          let posInSet;
          let state = '';
          const headers = [
            ...this.m_root.querySelectorAll('.oj-datagrid-' + activeObject.axis + '-header-cell')
          ];
          if (treeDepth > 0) {
            let parentIndex;
            let nextParentIndex;
            headers.forEach((header) => {
              const headerContext = header[this.getResources().getMappedAttribute('context')];
              const headerMetadata = headerContext.metadata;
              if (headerMetadata.treeDepth < treeDepth && headerContext.index > activeObject.index) {
                if (!nextParentIndex || headerContext.index < nextParentIndex) {
                  nextParentIndex = headerContext.index;
                }
              }
              if (
                headerMetadata.treeDepth === treeDepth - 1 &&
                headerContext.index < activeObject.index
              ) {
                if (!parentIndex || headerContext.index > parentIndex) {
                  parentIndex = headerContext.index;
                }
              }
            });
            if (parentIndex != null && nextParentIndex != null) {
              state = 'Full';
            } else if (parentIndex != null && nextParentIndex == null) {
              nextParentIndex = endHeader + 1;
              if (isDone) {
                state = 'Full';
              } else {
                state = 'Partial';
              }
            } else if (parentIndex == null && nextParentIndex != null) {
              parentIndex = startHeader - 1;
              state = 'Unknown';
            } else {
              parentIndex = startHeader - 1;
              nextParentIndex = endHeader + 1;
              state = 'Unknown';
            }
            setSize = 0;
            posInSet = 0;
            headers.forEach((header) => {
              const headerContext = header[this.getResources().getMappedAttribute('context')];
              const headerMetadata = headerContext.metadata;
              if (headerMetadata.treeDepth === treeDepth) {
                if (headerContext.index <= activeObject.index && headerContext.index > parentIndex) {
                  posInSet += 1;
                }
                if (headerContext.index > parentIndex && headerContext.index < nextParentIndex) {
                  setSize += 1;
                }
              }
            });
          } else {
            setSize = 0;
            posInSet = 1;
            const seenRoot = this.m_startRowHeader === 0;
            if (!seenRoot) {
              state = 'Unknown';
            } else if (isDone) {
              state = 'Full';
            } else {
              state = 'Partial';
            }
            headers.forEach((header) => {
              const headerContext = header[this.getResources().getMappedAttribute('context')];
              const headerMetadata = headerContext.metadata;
              if (headerMetadata.treeDepth === treeDepth) {
                setSize += 1;
                if (headerContext.index < activeObject.index) {
                  posInSet += 1;
                }
              }
            });
          }
          const translationKey = this._getHierarchicalTranslationKey(state, activeObject.axis);
          statesArray.push({ key: translationKey, args: { posInSet: posInSet, setSize: setSize } });
        }
      }
      if (statesArray.length !== 0) {
        label = label + ' ' + this.createSubId('state');
      }

      element.setAttribute('tabIndex', 0);
    } else if (activeObject.type === 'label') {
      label = [this.createSubId('context'), this._getActiveElement().id].join(' ');
    } else if (activeObject.type === 'empty') {
      label = this._getActiveElement().id;
    } else {
      if (prevActiveObject != null) {
        if (prevActiveObject.type === 'header') {
          previousRowIndex = prevActiveObject.axis === 'row' ? prevActiveObject.index : null;
          previousColumnIndex = prevActiveObject.axis === 'column' ? prevActiveObject.index : null;
        } else if (prevActiveObject.type === 'cell') {
          previousRowIndex = prevActiveObject.indexes.row;
          previousColumnIndex = prevActiveObject.indexes.column;
        }
      }

      // Add the header labels
      var row = this._getHeaderLabelledBy(
        'row',
        this.m_rowHeaderLevelCount,
        this.m_endRowHeader,
        activeObject.indexes.row,
        previousRowIndex,
        element
      );
      var rowEnd = this._getHeaderLabelledBy(
        'rowEnd',
        this.m_rowEndHeaderLevelCount,
        this.m_endRowEndHeader,
        activeObject.indexes.row,
        previousRowIndex,
        element
      );
      var column = this._getHeaderLabelledBy(
        'column',
        this.m_columnHeaderLevelCount,
        this.m_endColHeader,
        activeObject.indexes.column,
        previousColumnIndex,
        element
      );
      var columnEnd = this._getHeaderLabelledBy(
        'columnEnd',
        this.m_columnEndHeaderLevelCount,
        this.m_endColEndHeader,
        activeObject.indexes.column,
        previousColumnIndex,
        element
      );

      // we want extent information at the end of the readout so put it in the state info
      var rowExtent = activeObject.extents.row;
      var columnExtent = activeObject.extents.column;
      if (rowExtent > 1) {
        statesArray.push({ key: 'accessibleRowSpanContext', args: { extent: rowExtent } });
      }
      if (columnExtent > 1) {
        statesArray.push({ key: 'accessibleColumnSpanContext', args: { extent: columnExtent } });
      }

      if (isIosRender) {
        label = [row, rowEnd, column, columnEnd, element.id].join(' ');
      } else {
        label = [
          this.createSubId('context'),
          row,
          rowEnd,
          column,
          columnEnd,
          element.id,
          this.createSubId('state')
        ].join(' ');
      }
      // remove double spaces rather than check everytime
      label = label.replace(/ +(?= )/g, '');
    }

    if (this.m_externalFocus === true) {
      if (this.m_root.id != null) {
        label = [this.m_root.id, label].join(' ');
      }
      label = [this.createSubId('summary'), label].join(' ');
      this.m_externalFocus = false;
    }

    let focusableElems = DataCollectionUtils.getActionableElementsInNode(element);
    if (focusableElems && focusableElems.length > 0) {
      statesArray.push({ key: 'accessibleContainsControls' });
    }

    this._updateStateInfo(statesArray);

    return label;
  };
  /**
   * Returns translation key based on state and axis
   * @param {string} state 'Full', 'Partial', 'Unknown'
   * @param {string} axis the axis along which to find the header, 'row', 'column'
   */
  DvtDataGrid.prototype._getHierarchicalTranslationKey = function (state, axis) {
    const uppercaseAxis = axis.charAt(0).toUpperCase() + axis.slice(1);
    return 'accessible' + uppercaseAxis + 'Hierarchical' + state;
  };

  /**
   * Returns the header that is in line with a cell along an axis.
   * Key Note: in the case of row, we return the row not the headercell
   * @param {Element|undefined|null} cell the element for the cell
   * @param {string} axis the axis along which to find the header, 'row', 'column'
   * @param {boolean=} lastContained true to get the last header contained by the cell along an axis
   * @return {Element} the header Element along the axis
   */
  DvtDataGrid.prototype.getHeaderFromCell = function (cell, axis, lastContained) {
    var index;
    var extent;
    var level;

    if (axis === 'row') {
      if (this.m_rowHeader != null) {
        index = this._getIndex(cell, 'row');
        extent = this._getExtent(cell, 'row');
        level = this.m_rowHeaderLevelCount - 1;
      }
    } else if (axis === 'column') {
      if (this.m_colHeader != null) {
        index = this._getIndex(cell, 'column');
        extent = this._getExtent(cell, 'column');
        level = this.m_columnHeaderLevelCount - 1;
      }
    } else if (axis === 'rowEnd') {
      if (this.m_rowEndHeader != null) {
        index = this._getIndex(cell, 'row');
        extent = this._getExtent(cell, 'row');
        level = this.m_rowEndHeaderLevelCount - 1;
      }
    } else if (axis === 'columnEnd') {
      if (this.m_colEndHeader != null) {
        index = this._getIndex(cell, 'column');
        extent = this._getExtent(cell, 'column');
        level = this.m_columnEndHeaderLevelCount - 1;
      }
    }

    if (index != null && level != null && index > -1) {
      if (lastContained) {
        index += extent - 1;
      }
      return this._getHeaderByIndex(index, axis, level);
    }

    return null;
  };

  /**
   * Creates a range object given the start and end index, will add in keys if they are passed in
   * @param {Object} range - the start index of the range a range object representing the start and end index
   * @return {Object} a range object representing the start and end index
   * @private
   */
  DvtDataGrid.prototype._trimRangeForSelectionMode = function (range) {
    if (this.m_options.getSelectionMode() === 'row') {
      // drop the column index
      return this.createRange(
        this.createIndex(range.startIndex.row),
        this.createIndex(range.endIndex.row)
      );
    }
    return range;
  };

  /**
   * Creates a range object given the start and end index, will add in keys if they are passed in
   * @param {Object} startIndex - the start index of the range
   * @param {Object=} endIndex - the end index of the range.  Optional, if not specified it represents a single cell/row
   * @param {Object=} startKey - the start key of the range.  Optional, if not specified it represents a single cell/row
   * @param {Object=} endKey - the end key of the range.  Optional, if not specified it represents a single cell/row
   * @return {Object} a range object representing the start and end index, along with the start and end key.
   */
  DvtDataGrid.prototype.createRange = function (startIndex, endIndex, startKey, endKey) {
    var startRow;
    var endRow;
    var startColumn;
    var endColumn;
    var startRowKey;
    var endRowKey;
    var startColumnKey;
    var endColumnKey;

    if (endIndex) {
      // -1 means unbound
      if (startIndex.row < endIndex.row || endIndex.row === -1) {
        startRow = startIndex.row;
        endRow = endIndex.row;
        if (startKey) {
          startRowKey = startKey.row;
          endRowKey = endKey.row;
        }
      } else {
        startRow = endIndex.row;
        endRow = startIndex.row;
        if (startKey) {
          startRowKey = endKey.row;
          endRowKey = startKey.row;
        }
      }

      // row based selection does not have column specified for range
      if (!isNaN(startIndex.column) && !isNaN(endIndex.column)) {
        // -1 means unbound
        if (startIndex.column < endIndex.column || endIndex.column === -1) {
          startColumn = startIndex.column;
          endColumn = endIndex.column;
          if (startKey) {
            startColumnKey = startKey.column;
            endColumnKey = endKey.column;
          }
        } else {
          startColumn = endIndex.column;
          endColumn = startIndex.column;
          if (startKey) {
            startColumnKey = endKey.column;
            endColumnKey = startKey.column;
          }
        }

        // eslint-disable-next-line no-param-reassign
        startIndex = {
          row: startRow,
          column: startColumn
        };
        // eslint-disable-next-line no-param-reassign
        endIndex = {
          row: endRow,
          column: endColumn
        };
        if (startKey) {
          // eslint-disable-next-line no-param-reassign
          startKey = {
            row: startRowKey,
            column: startColumnKey
          };
          // eslint-disable-next-line no-param-reassign
          endKey = {
            row: endRowKey,
            column: endColumnKey
          };
        }
      } else {
        // eslint-disable-next-line no-param-reassign
        startIndex = {
          row: startRow
        };
        // eslint-disable-next-line no-param-reassign
        endIndex = {
          row: endRow
        };
        if (startKey) {
          // eslint-disable-next-line no-param-reassign
          startKey = {
            row: startRowKey,
            column: startColumnKey
          };
          // eslint-disable-next-line no-param-reassign
          endKey = {
            row: endRowKey,
            column: endColumnKey
          };
        }
      }
    }

    if (startKey) {
      return { startIndex: startIndex, endIndex: endIndex, startKey: startKey, endKey: endKey };
    }

    return { startIndex: startIndex, endIndex: endIndex };
  };

  /**
   * Creates a range object given the start and end index
   * @param {Object} startIndex - the start index of the range
   * @param {Object|undefined|null} endIndex - the end index of the range.
   * @param {Function} callback - the callback for the range to call when its fully fetched
   * @private
   */
  DvtDataGrid.prototype._createRangeWithKeys = function (startIndex, endIndex, callback) {
    this._keys(startIndex, this._createRangeStartKeyCallback.bind(this, endIndex, callback));
  };

  /**
   * Creates a range object given the start and end index
   * @param {Object|null|undefined} endIndex - the end index of the range.
   * @param {Function} callback - the callback for the range to call when its fully fetched
   * @param {Object} startKey - the start key of the range
   * @param {Object} startIndex - the start index of the range
   * @private
   */
  DvtDataGrid.prototype._createRangeStartKeyCallback = function (
    endIndex,
    callback,
    startKey,
    startIndex
  ) {
    // keys will be the same
    if (
      endIndex != null &&
      startIndex != null &&
      endIndex.row === startIndex.row &&
      endIndex.column === startIndex.column
    ) {
      this._createRangeEndKeyCallback(startKey, startIndex, callback, startKey, startIndex);
    } else if (endIndex) {
      // new keys needed
      this._keys(
        endIndex,
        this._createRangeEndKeyCallback.bind(this, startKey, startIndex, callback)
      );
    } else {
      // create range from single key
      callback.call(this, {
        startIndex: startIndex,
        endIndex: startIndex,
        startKey: startKey,
        endKey: startKey
      });
    }
  };

  /**
   * Creates a range object given the start and end index
   * @param {Object} startKey - the start key of the range
   * @param {Object} startIndex - the start index of the range
   * @param {Function} callback - the callback for the range to call when its fully fetched
   * @param {Object} endKey - the end key of the range.
   * @param {Object} endIndex - the end index of the range.
   * @private
   */
  DvtDataGrid.prototype._createRangeEndKeyCallback = function (
    startKey,
    startIndex,
    callback,
    endKey,
    endIndex
  ) {
    callback.call(this, this.createRange(startIndex, endIndex, startKey, endKey));
  };

  /**
   * Retrieve the end index of the range, return start index if end index is undefined
   * @param {Object} range
   * @return {Object}
   */
  DvtDataGrid.prototype.getEndIndex = function (range) {
    return range.endIndex == null ? range.startIndex : range.endIndex;
  };

  /**
   * Grabs all the elements in the databody which are within the specified range.
   * @param {Object} range - the range in which to get the elements
   * @param {number=} startRow
   * @param {number=} endRow
   * @param {number=} startCol
   * @param {number=} endCol
   * @return {Array}
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype.getElementsInRange = function (range, startRow, endRow, startCol, endCol) {
    var rangeStartColumn;
    var rangeEndColumn;
    var i;
    var j;
    var cell;

    if (startRow == null) {
      // eslint-disable-next-line no-param-reassign
      startRow = this.m_startRow;
    }
    if (endRow == null) {
      // eslint-disable-next-line no-param-reassign
      endRow = this.m_endRow + 1;
    }

    var startIndex = range.startIndex;
    var endIndex = this.getEndIndex(range);

    var rangeStartRow = startIndex.row;
    var rangeEndRow = endIndex.row;
    // index = -1 means unbounded index
    if (rangeEndRow === -1) {
      rangeEndRow = Number.MAX_VALUE;
    }

    // check if in the rendered range
    if (endRow < rangeStartRow || rangeEndRow < startRow) {
      return null;
    }

    if (!isNaN(startIndex.column) && !isNaN(endIndex.column)) {
      rangeStartColumn = startIndex.column;
      rangeEndColumn = endIndex.column;
      // index = -1 means unbounded index
      if (rangeEndColumn === -1) {
        rangeEndColumn = Number.MAX_VALUE;
      }

      // check if in the rendered range
      if (this.m_endCol + 1 < rangeStartColumn || rangeEndColumn < this.m_startCol) {
        return null;
      }
    }

    var nodes = [];
    // now walk the databody to find the nodes in range
    var databodyContent = this.m_databody.firstChild;
    if (databodyContent == null) {
      return null;
    }

    // the range is within the databody, calculate the relative position
    rangeStartRow = Math.max(this.m_startRow, rangeStartRow);
    rangeEndRow = Math.min(this.m_endRow, rangeEndRow);

    // cell case
    if (!isNaN(rangeStartColumn) && !isNaN(rangeEndColumn)) {
      rangeStartColumn = Math.max(this.m_startCol, rangeStartColumn);
      rangeEndColumn = Math.min(this.m_endCol, rangeEndColumn);
      for (i = rangeStartRow; i <= rangeEndRow; i += 1) {
        for (j = rangeStartColumn; j <= rangeEndColumn; j += 1) {
          cell = this._getCellByIndex(this.createIndex(i, j));
          if (cell != null && nodes.indexOf(cell) === -1) {
            nodes.push(cell);
          }
        }
      }
    } else {
      // row case
      rangeStartColumn = Math.max(0, this.m_startCol);
      rangeEndColumn = Math.max(rangeStartColumn, this.m_endCol);
      for (i = rangeStartRow; i <= rangeEndRow; i += 1) {
        for (j = rangeStartColumn; j <= rangeEndColumn; j += 1) {
          cell = this._getCellByIndex(this.createIndex(i, j));
          if (cell != null && nodes.indexOf(cell) === -1) {
            nodes.push(cell);
          }
        }
      }
    }

    return nodes;
  };

  DvtDataGrid.prototype._getRangeInView = function (range) {
    // removes nulls and negatives from range, and ensures there is an end index to work with
    let startIndex = range.startIndex;
    let endIndex = this.getEndIndex(range);

    let rangeStartRow = startIndex.row;
    let rangeEndRow = endIndex.row;
    let rangeStartColumn = startIndex.column;
    let rangeEndColumn = endIndex.column;

    if (rangeEndRow === -1) {
      rangeEndRow = Number.MAX_VALUE;
    }
    if (rangeEndColumn === -1) {
      rangeEndColumn = Number.MAX_VALUE;
    }

    rangeStartRow = Math.max(this.m_startRow, rangeStartRow);
    rangeEndRow = Math.min(this.m_endRow, rangeEndRow);

    if (isNaN(startIndex.column) || isNaN(endIndex.column)) {
      rangeStartColumn = Math.max(0, this.m_startCol);
      rangeEndColumn = Math.max(rangeStartColumn, this.m_endCol);
    }

    rangeStartColumn = Math.max(this.m_startCol, rangeStartColumn);
    rangeEndColumn = Math.min(this.m_endCol, rangeEndColumn);

    return this.createRange(
      this.createIndex(rangeStartRow, rangeStartColumn),
      this.createIndex(rangeEndRow, rangeEndColumn)
    );
  };

  // eslint-disable-next-line consistent-return
  DvtDataGrid.prototype._applyBorderClassesAroundRange = function (
    elementsInRange,
    range,
    shouldAddClasses,
    classSuffix
  ) {
    // make sure we have a databody and elements in the range
    let databodyContent = this.m_databody.firstChild;
    if (databodyContent == null || elementsInRange == null || elementsInRange.length === 0) {
      return;
    }

    let normalizedRange = this._getRangeInView(range);
    let rangeStartRow = normalizedRange.startIndex.row;
    let rangeStartColumn = normalizedRange.startIndex.column;
    let rangeEndRow = normalizedRange.endIndex.row;
    let rangeEndColumn = normalizedRange.endIndex.column;

    // we use a different border for these
    let isFirstRow = this.isFirstOrFirstNonHiddenIndex(rangeStartRow, 'row');
    let isFirstColumn = this.isFirstOrFirstNonHiddenIndex(rangeStartColumn, 'column');
    let startBorderRowIndex = isFirstRow
      ? rangeStartRow
      : this.getVisibleCellIndexInDirection('row', rangeStartRow - 1, { up: true });
    let endBorderRowIndex = rangeEndRow;
    let startBorderColumnIndex = isFirstColumn
      ? rangeStartColumn
      : this.getVisibleCellIndexInDirection('column', rangeStartColumn - 1, { left: true });
    let endBorderColumnIndex = rangeEndColumn;

    for (let i = rangeStartRow; i <= rangeEndRow; i++) {
      let startCell = this._getCellByIndex(this.createIndex(i, startBorderColumnIndex));
      let endCell = this._getCellByIndex(this.createIndex(i, endBorderColumnIndex));
      let startClassPrefix = isFirstColumn ? 'start' : 'end';
      let endClassPrefix = 'end';
      let startClass = startClassPrefix + classSuffix;
      let endClass = endClassPrefix + classSuffix;
      if (shouldAddClasses) {
        this._highlightElement(startCell, [startClass]);
        this._highlightElement(endCell, [endClass]);
      } else {
        this._unhighlightElement(startCell, [startClass]);
        this._unhighlightElement(endCell, [endClass]);
      }
    }

    for (let i = rangeStartColumn; i <= rangeEndColumn; i++) {
      let startCell = this._getCellByIndex(this.createIndex(startBorderRowIndex, i));
      let endCell = this._getCellByIndex(this.createIndex(endBorderRowIndex, i));
      let startClassPrefix = isFirstRow ? 'top' : 'bottom';
      let endClassPrefix = 'bottom';
      let startClass = startClassPrefix + classSuffix;
      let endClass = endClassPrefix + classSuffix;
      if (shouldAddClasses) {
        this._highlightElement(startCell, [startClass]);
        this._highlightElement(endCell, [endClass]);
      } else {
        this._unhighlightElement(startCell, [startClass]);
        this._unhighlightElement(endCell, [endClass]);
      }
    }
  };

  /**
   * Read the full content of the active cell (or frontier cell) to the screen reader
   * @protected
   * @returns {boolean} true if there is content to read out
   */
  DvtDataGrid.prototype.readCurrentContent = function () {
    var current;
    var currentCell;

    if (this.m_active == null) {
      return false;
    }

    if (this.m_active.type === 'header') {
      current = {};
      if (this.m_active.axis === 'row') {
        if (this.m_rowHeaderLevelCount > 1) {
          current.level = this.m_active.level;
        }
        current.rowHeader = this.m_active.index;
      } else {
        if (this.m_columnHeaderLevelCount > 1) {
          current.level = this.m_active.level;
        }
        current.columnHeader = this.m_active.index;
      }
      currentCell = this._getActiveElement();
    } else if (this.m_active.type === 'cell') {
      current = this.m_active.indexes;
      if (this._isSelectionEnabled() && this.isMultipleSelection()) {
        if (this.m_selectionFrontier != null) {
          current = this.m_selectionFrontier;
        }
      }
      // make sure there is an active cell or frontier cell
      if (current == null) {
        return false;
      }

      // find the cell div
      var range = this.createRange(current);
      var cell = this.getElementsInRange(range);
      if (cell == null || cell.length === 0) {
        return false;
      }

      currentCell = cell[0];
    } else {
      currentCell = this._getActiveElement();
    }

    this._updateActiveContext(this.m_active, this.m_prevActive);

    // Fill in the placeholder div aria-labelledby with the currentCell label so that it
    // will read out the contents of the current cell when focus is shifted to the
    // place holder div. Set tabIndex to -1 so that it can be focused but not tabbed into.
    this.m_placeHolder.tabIndex = -1;
    var labelledBy = currentCell.getAttribute('aria-labelledby');
    this.m_placeHolder.setAttribute('aria-labelledby', labelledBy + ' ' + currentCell.id);

    // Since JAWS screen reader requires changing focus in order to
    // trigger a read command, we are toggling between the placeholder
    // div and the currentCell.
    if (this.m_placeHolder === document.activeElement) {
      currentCell.focus();
    } else {
      this.m_placeHolder.focus();
    }
    return true;
  };

  /**
   * Enter actionable mode
   * @param {Element|undefined|null} element to set actionable
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._enterActionableMode = function (element, event, shouldApplyFocus) {
    if (!this.isActionableMode()) {
      this._enteringActionableMode = true;
      if (
        !shouldApplyFocus ||
        (shouldApplyFocus && this._setFocusToFirstFocusableElement(element, event))
      ) {
        this.m_focusOutHandler(element);
        this.setActionableMode(true);
      }
    }
    this._enteringActionableMode = false;
    return false;
  };

  /**
   * Exit actionable mode on the active cell if in actionable mode
   */
  DvtDataGrid.prototype._exitActionableMode = function () {
    if (this.isActionableMode()) {
      var elem = this._getActiveElement();
      this.setActionableMode(false);
      DataCollectionUtils.disableAllFocusableElements(elem);
      this.m_focusInHandler(elem);
    }
  };
  /**
   * Re render a cell
   * @param {Element|undefined|null} cell
   * @param {string} mode
   * @param {string} classToToggle class to toggle on or off before rerendering
   * @param {Element|null=} editableClone
   */
  DvtDataGrid.prototype._reRenderCell = function (cell, mode, classToToggle, editableClone) {
    var renderer = this.getRendererOrTemplate('cell');
    var cellContext = cell[this.getResources().getMappedAttribute('context')];
    var cellMetaData = cell[this.getResources().getMappedAttribute('metadata')];
    cellContext.mode = mode;

    // empty the cell
    this.m_utils.empty(cell);

    // now that the cell is empty toggle the appropraite edit classes so that alignment never has to shift
    if (this.m_utils.containsCSSClassName(cell, classToToggle)) {
      this.m_utils.removeCSSClassName(cell, classToToggle);
    } else {
      this.m_utils.addCSSClassName(cell, classToToggle);
    }

    if (editableClone) {
      while (editableClone.hasChildNodes()) {
        cell.appendChild(editableClone.firstChild);
      }
      this._destroyEditableClone();
    } else {
      this._renderContent(
        renderer,
        cellContext,
        cell,
        cellContext.data,
        this.buildCellTemplateContext(cellContext, cellMetaData)
      );
    }
  };

  DvtDataGrid.prototype._resetEditableClone = function () {
    if (this._isGridEditable()) {
      if (this.m_active && this.m_active.type === 'cell') {
        let elem = this._getActiveElement();
        if (elem) {
          this._setEditableClone(elem);
        }
      }
    }
  };

  /**
   * Set the editable clone property
   * @param {Element|undefined|null} element to clone
   */
  DvtDataGrid.prototype._setEditableClone = function (element) {
    this._destroyEditableClone();
    if (element != null) {
      var clone = element.cloneNode(false);
      clone.removeAttribute('id');
      this._createUniqueId(clone);
      clone[this.getResources().getMappedAttribute('context')] =
        element[this.getResources().getMappedAttribute('context')];
      clone[this.getResources().getMappedAttribute('metadata')] =
        element[this.getResources().getMappedAttribute('metadata')];
      clone[this.getResources().getMappedAttribute('context')].parentElement = clone;
      this.m_root.appendChild(clone);
      this._reRenderCell(clone, 'edit', this.getMappedStyle('cellEdit'), null);
      // we can keep the editable clone around, no where should we look for it later
      clone.style.display = 'none';
      clone[this.getResources().getMappedAttribute('context')].parentElement = element;
      this.m_editableClone = clone;
    }
  };

  /**
   * Remove editable clone and cleanup
   */
  DvtDataGrid.prototype._destroyEditableClone = function () {
    if (this.m_editableClone) {
      if (this.m_editableClone.parentNode != null) {
        this._remove(this.m_editableClone);
      } else {
        this._cleanTemplateNodes(this.m_editableClone);
      }
      delete this.m_editableClone;
    }
  };

  /**
   *
   * @param {number} keyCode
   * @return {boolean}
   */
  DvtDataGrid.prototype.isArrowKey = function (keyCode) {
    return (
      keyCode === this.keyCodes.UP_KEY ||
      keyCode === this.keyCodes.DOWN_KEY ||
      keyCode === this.keyCodes.LEFT_KEY ||
      keyCode === this.keyCodes.RIGHT_KEY
    );
  };

  /**
   * Creates an index object for the cell/row
   * @param {*} row - the start index of the range
   * @param {*} column - the end index of the range.  Optional, if not specified it represents a single cell/row
   * @return {Object} an index object
   */
  DvtDataGrid.prototype.createIndex = function (row, column) {
    var returnObj = {};
    if (row !== undefined) {
      returnObj.row = row;
    }
    if (column !== undefined) {
      returnObj.column = column;
    }
    return returnObj;
  };

  /**
   * Checks if the corners of a selection matches the selection frontier index and parameter index
   * @param {string} axis - the axis of the selection if header
   * @param {number} index - one index of the selection
   * @param {Object} selection - selection being checked
   * @return {boolean} true or false whether or not the corners are matched
   */
  DvtDataGrid.prototype.checkCorners = function (axis, index, selection) {
    // ignore nested headers
    if (
      (this.m_selectionFrontier.axis === 'column' &&
        this.m_columnHeaderLevelCount !== this.m_selectionFrontier.level) ||
      (this.m_selectionFrontier.axis === 'row' &&
        this.m_rowHeaderLevelCount !== this.m_selectionFrontier.level) ||
      (this.m_selectionFrontier.axis === 'rowEnd' &&
        this.m_rowEndHeaderLevelCount !== this.m_selectionFrontier.level) ||
      (this.m_selectionFrontier.axis === 'columnEnd' &&
        this.m_columnEndHeaderLevelCount !== this.m_selectionFrontier.level)
    ) {
      return true;
    }
    if (axis.indexOf('row') !== -1) {
      return (
        (index === selection.startIndex.row &&
          this.m_selectionFrontier.end === selection.endIndex.row) ||
        (index === selection.endIndex.row &&
          this.m_selectionFrontier.end === selection.startIndex.row)
      );
    } else if (axis.indexOf('column') !== -1) {
      return (
        (index === selection.startIndex.column &&
          this.m_selectionFrontier.end === selection.endIndex.column) ||
        (index === selection.endIndex.column &&
          this.m_selectionFrontier.end === selection.startIndex.column)
      );
    }

    return false;
  };

  /**
   * Handles arrow keys navigation on label
   * @param {number} keyCode description
   * @param {Event} event the DOM event that caused the arrow key
   * @param {boolean} isExtend boolean if we are extending a selection
   * @param {boolean} jumpToHeaders jump to opposite labels if possible
   * @return  boolean true if the event was processed
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype.handleLabelFocusChange = function (keyCode, event, isExtend, jumpToHeaders) {
    var newElement;
    var newIndex;
    var start;
    var levelCount;

    // ensure that there's no outstanding fetch requests
    if (!this.isFetchComplete()) {
      // act like it's processed until we finish the fetch
      return true;
    }

    if (this.getResources().isRTLMode()) {
      if (keyCode === this.keyCodes.LEFT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.RIGHT_KEY;
      } else if (keyCode === this.keyCodes.RIGHT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.LEFT_KEY;
      }
    }

    var axis = this.m_active.axis;
    var level = this.m_active.level;

    if (axis === 'column') {
      start = this.m_startColHeader;
      levelCount = this.m_columnHeaderLevelCount;
    } else if (axis === 'row') {
      start = this.m_startRowHeader;
      levelCount = this.m_rowHeaderLevelCount;
    }
    if (axis === 'columnEnd') {
      // treat up and down keys opposite of column Headers
      if (keyCode === this.keyCodes.DOWN_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.UP_KEY;
      } else if (keyCode === this.keyCodes.UP_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.DOWN_KEY;
      }
      start = this.m_startColEndHeader;
      levelCount = this.m_columnEndHeaderLevelCount;
    }
    if (axis === 'rowEnd') {
      // treat right and left oppostie of row headers
      if (keyCode === this.keyCodes.LEFT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.RIGHT_KEY;
      } else if (keyCode === this.keyCodes.RIGHT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.LEFT_KEY;
      }
      start = this.m_startRowEndHeader;
      levelCount = this.m_rowEndHeaderLevelCount;
    }

    switch (keyCode) {
      case this.keyCodes.DOWN_KEY:
        if (axis === 'row' || axis === 'rowEnd') {
          newElement = this._getHeaderByIndex(start, axis, level);
          if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
            // unhighlight and clear selection
            this._clearSelection(event);
            this.m_selectionFrontier = {};
          }
          this._setActive(
            newElement,
            {
              type: 'header',
              index: start,
              level: level,
              axis: axis
            },
            event
          );
        }
        if (axis === 'column' || axis === 'columnEnd') {
          newElement = this.m_headerLabels[axis][level + 1];
          if (newElement) {
            this._setActive(newElement, { type: 'label', level: level + 1, axis: axis }, event);
          } else if (
            axis === 'column' &&
            level === levelCount - 1 &&
            this.m_headerLabels.row.length
          ) {
            newElement = this.m_headerLabels.row[this.m_headerLabels.row.length - 1];
            this._setActive(
              newElement,
              {
                type: 'label',
                level: this.m_headerLabels.row.length - 1,
                axis: 'row'
              },
              event
            );
          } else if (level === levelCount - 1) {
            newIndex = axis === 'column' ? this.m_startRowHeader : this.m_endRowHeader;
            newElement = this._getHeaderByIndex(newIndex, 'row', this.m_rowHeaderLevelCount - 1);
            if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
              // unhighlight and clear selection
              this._clearSelection(event);
              this.m_selectionFrontier = {};
            }
            if (newElement) {
              this._setActive(
                newElement,
                {
                  type: 'header',
                  index: newIndex,
                  level: level,
                  axis: 'row'
                },
                event
              );
            }
          }
        }
        break;
      case this.keyCodes.UP_KEY:
        if (axis === 'row' && level === levelCount - 1 && this.m_headerLabels.column.length) {
          newElement = this.m_headerLabels.column[this.m_headerLabels.column.length - 1];
          this._setActive(
            newElement,
            {
              type: 'label',
              level: this.m_headerLabels.column.length - 1,
              axis: 'column'
            },
            event
          );
        }
        if (axis === 'column' || axis === 'columnEnd') {
          newElement = this.m_headerLabels[axis][level - 1];
          if (newElement) {
            this._setActive(newElement, { type: 'label', level: level - 1, axis: axis }, event);
          }
        }
        break;
      case this.keyCodes.RIGHT_KEY:
        if (axis === 'row' || axis === 'rowEnd') {
          newElement = this.m_headerLabels[axis][level + 1];
          if (newElement) {
            this._setActive(newElement, { type: 'label', level: level + 1, axis: axis }, event);
          } else if (level === levelCount - 1) {
            newIndex = axis === 'row' ? this.m_startColHeader : this.m_endColHeader;
            while (this.isHidden('column', newIndex)) {
              newIndex = axis === 'row' ? newIndex + 1 : newIndex - 1;
            }
            newElement = this._getHeaderByIndex(newIndex, 'column', this.m_columnHeaderLevelCount);
            if (newElement) {
              if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
                // unhighlight and clear selection
                this._clearSelection(event);
                this.m_selectionFrontier = {};
              }
              this._setActive(
                newElement,
                {
                  type: 'header',
                  index: newIndex,
                  level: level,
                  axis: 'column'
                },
                event
              );
            }
          }
        }
        if (axis === 'column' || axis === 'columnEnd') {
          newIndex = start;
          newElement = this._getHeaderByIndex(newIndex, axis, level);
          // iterate through headers to find the visible element to focus
          while (newElement != null && this.isHeaderHidden(newElement)) {
            newIndex =
              level !== levelCount - 1
                ? this._getAttribute(newElement.parentNode, 'start', true) +
                  this._getAttribute(newElement.parentNode, 'extent', true)
                : newIndex + 1;
            newElement = this._getHeaderByIndex(newIndex, axis, level);
          }

          if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
            // unhighlight and clear selection
            this._clearSelection(event);
            this.m_selectionFrontier = {};
          }
          this._setActive(
            newElement,
            {
              type: 'header',
              index: start,
              level: level,
              axis: axis
            },
            event
          );
        }
        break;

      case this.keyCodes.LEFT_KEY:
        if (axis === 'row' || axis === 'rowEnd') {
          newElement = this.m_headerLabels[axis][level - 1];
          if (newElement) {
            this._setActive(newElement, { type: 'label', level: level - 1, axis: axis }, event);
          }
        }
        break;
      default:
        break;
    }
    return true;
  };

  /**
   * Handles arrow keys navigation on header
   * @param {number} keyCode description
   * @param {Event} event the DOM event that caused the arrow key
   * @param {boolean} isExtend boolean if we are extending a selection
   * @param {boolean} jumpToHeaders jump to opposite headers if possible
   * @return  boolean true if the event was processed
   */
  DvtDataGrid.prototype.handleHeaderFocusChange = function (
    keyCode,
    event,
    isExtend,
    jumpToHeaders,
    skipEmpty
  ) {
    var newCellIndex;
    var newElement;
    var newIndex;
    var newLevel;
    var end;
    var levelCount;
    var stopFetch;
    let start;

    let emptyElement = this._getEmptyElement();

    if (this.getResources().isRTLMode()) {
      if (keyCode === this.keyCodes.LEFT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.RIGHT_KEY;
      } else if (keyCode === this.keyCodes.RIGHT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.LEFT_KEY;
      }
    }

    var axis = this.m_active.axis;
    var index = this.m_active.index;
    var level = this.m_active.level;
    var elem = this._getActiveElement();
    var depth = elem != null ? this._getAttribute(elem, 'depth', true) : 1;

    // if cell mode, need to set values properly to check corners
    if (!axis && !index && this.m_active) {
      axis = this.m_selectionFrontier.axis;
      index = this.m_active.indexes[axis];
    }

    // if shiftkey active and we're navigating headers, as long as we don't leave headers, set isExtend to active.
    if (event.shiftKey && !isExtend && this.m_selectionFrontier && this.isMultipleSelection()) {
      // eslint-disable-next-line no-param-reassign
      isExtend = this.checkHeaderToDatabody(axis, keyCode);
    }

    // if extending and anchors are the same, use the selectionFrontier
    if (
      isExtend &&
      this.isArrowKey(keyCode) &&
      this.isHeaderSelectionType(this.m_selectionFrontier) &&
      this.checkCorners(axis, index, this.m_selection[this.m_selection.length - 1])
    ) {
      axis = this.m_selectionFrontier.axis;
      index = this.m_selectionFrontier.index;
      level = this.m_selectionFrontier.level;

      if (index === -1) {
        index = this.m_active.indexes[axis];
      }

      // don't allow changing levels if anchor is a cell.
      if (this.m_active.type === 'cell') {
        if (
          ((keyCode === this.keyCodes.LEFT_KEY || keyCode === this.keyCodes.RIGHT_KEY) &&
            axis.indexOf('row') !== -1) ||
          ((keyCode === this.keyCodes.UP_KEY || keyCode === this.keyCodes.DOWN_KEY) &&
            axis.indexOf('column') !== -1)
        ) {
          return undefined;
        }
      }
    }

    if (axis === 'column') {
      end = this.m_endColHeader;
      levelCount = this.m_columnHeaderLevelCount;
      stopFetch = this.m_stopColumnHeaderFetch;
      start = this.m_startColHeader;
    } else if (axis === 'row') {
      end = this.m_endRowHeader;
      levelCount = this.m_rowHeaderLevelCount;
      stopFetch = this.m_stopRowHeaderFetch;
      start = this.m_startRowHeader;
    }
    if (axis === 'columnEnd') {
      // treat up and down keys opposite of column Headers
      if (keyCode === this.keyCodes.DOWN_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.UP_KEY;
      } else if (keyCode === this.keyCodes.UP_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.DOWN_KEY;
      }
      end = this.m_endColEndHeader;
      levelCount = this.m_columnEndHeaderLevelCount;
      stopFetch = this.m_stopColumnEndHeaderFetch;
      start = this.m_startColEndHeader;
    }
    if (axis === 'rowEnd') {
      // treat right and left oppostie of row headers
      if (keyCode === this.keyCodes.LEFT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.RIGHT_KEY;
      } else if (keyCode === this.keyCodes.RIGHT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.LEFT_KEY;
      }
      end = this.m_endRowEndHeader;
      levelCount = this.m_rowEndHeaderLevelCount;
      stopFetch = this.m_stopRowEndHeaderFetch;
      start = this.m_startRowEndHeader;
    }

    // ensure that there's no outstanding fetch requests
    if (!this.isFetchComplete()) {
      // if thre is outstating fetch and skeletons are loaded then scroll them into viewport
      // with right and down key, fetch is triggered before key down on last column/row
      // so need to scroll skeleton into viewport here
      if (this.m_skeletonSet.size > 0 && !isExtend) {
        if (levelCount === 1 || level === levelCount - 1) {
          newIndex = index + 1;
        } else {
          newIndex =
            elem != null
              ? this._getAttribute(elem.parentNode, 'start', true) +
                this._getAttribute(elem.parentNode, 'extent', true)
              : index + 1;
        }
        if (keyCode === this.keyCodes.RIGHT_KEY && newIndex === this.m_endCol + 1) {
          this._scrollSkeletonHeadersIntoViewport(newIndex - 1, axis, level, true);
        } else if (keyCode === this.keyCodes.DOWN_KEY && newIndex === this.m_endRow + 1) {
          this._scrollSkeletonHeadersIntoViewport(newIndex - 1, axis, level, true);
        }
      }
      // act like it's processed until we finish the fetch
      return true;
    }

    // get the selection frontier current header element
    if (
      isExtend &&
      this.isArrowKey(keyCode) &&
      this.isHeaderSelectionType(this.m_selectionFrontier)
    ) {
      elem = this._getHeaderByIndex(index, axis, level);
      depth = elem != null ? this._getAttribute(elem, 'depth', true) : 1;
    }
    var focusFunc = this._isSelectionEnabled()
      ? this.selectAndFocus.bind(this)
      : this._setActiveByIndex.bind(this);

    switch (keyCode) {
      case this.keyCodes.LEFT_KEY:
        if (axis === 'column' || axis === 'columnEnd') {
          if (index > 0 && !this.isFirstOrFirstNonHiddenIndex(index, axis)) {
            if (jumpToHeaders && this.m_headerLabels[axis][level]) {
              this._setActive(
                this.m_headerLabels[axis][level],
                {
                  type: 'label',
                  level: level,
                  axis: axis
                },
                event
              );
              break;
            }
            if (
              axis === 'column' &&
              jumpToHeaders &&
              this.m_headerLabels.row[this.m_rowHeaderLevelCount - 1]
            ) {
              this._setActive(
                this.m_headerLabels.row[this.m_rowHeaderLevelCount - 1],
                {
                  type: 'label',
                  level: this.m_rowHeaderLevelCount - 1,
                  axis: 'row'
                },
                event
              );
              break;
            }
            newElement = this._getHeaderByIndex(index - 1, axis, level);
            newIndex =
              newElement != null && level !== levelCount - 1
                ? this._getAttribute(newElement.parentNode, 'start', true) -
                  this._getAttribute(newElement.parentNode, 'extent', true)
                : index - 1;

            // iterate through headers to find the visible element to focus
            let i = 1;
            while (newElement != null && this.isHeaderHidden(newElement)) {
              newIndex = index - 1 - i;
              newElement = this._getHeaderByIndex(newIndex, axis, level);
              i += 1;
            }
            newIndex =
              newElement != null && level !== levelCount - 1
                ? this._getAttribute(newElement.parentNode, 'start', true)
                : this.findNextNonHiddenIndex(newIndex, axis);

            newLevel = newElement != null ? this.getHeaderCellLevel(newElement) : level;
            if (newIndex < 0) {
              break;
            }

            if (isExtend) {
              this.extendSelectionHeader(newElement, event, true);
            } else if (newIndex < start) {
              this._scrollSkeletonHeadersIntoViewport(index, axis, level, false);
            } else {
              if (
                this._isSelectionEnabled() &&
                !this.m_discontiguousSelection &&
                this.m_options.getSelectionMode() !== 'row'
              ) {
                // unhighlight and clear selection
                this._clearSelection(event);
                this.m_selectionFrontier = {};
              }
              this._setActive(
                newElement,
                {
                  type: 'header',
                  index: newIndex,
                  level: newLevel,
                  axis: axis
                },
                event
              );
              this._highlightActive();
            }
          } else if (this.m_headerLabels[axis][level]) {
            this._setActive(
              this.m_headerLabels[axis][level],
              {
                type: 'label',
                level: level,
                axis: axis
              },
              event
            );
          } else if (axis === 'column' && this.m_headerLabels.row[this.m_rowHeaderLevelCount - 1]) {
            this._setActive(
              this.m_headerLabels.row[this.m_rowHeaderLevelCount - 1],
              {
                type: 'label',
                level: this.m_rowHeaderLevelCount - 1,
                axis: 'row'
              },
              event
            );
          }
        } else if ((axis === 'row' || axis === 'rowEnd') && level > 0) {
          // moving down a level in the header
          newElement = this._getHeaderByIndex(index, axis, level - 1);
          newIndex = this._getAttribute(newElement.parentNode, 'start', true);
          newLevel = this.getHeaderCellLevel(newElement);

          if (isExtend) {
            this.extendSelectionHeader(newElement, event, true);
          } else {
            if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
              // unhighlight and clear selection
              this._clearSelection(event);
              this.m_selectionFrontier = {};
            }
            this._setActive(
              newElement,
              {
                type: 'header',
                index: newIndex,
                level: newLevel,
                axis: axis
              },
              event
            );
            this._highlightActive();
          }
        }
        break;
      case this.keyCodes.RIGHT_KEY:
        if (axis === 'rowEnd' && jumpToHeaders && this.m_endRowHeader !== -1) {
          newElement = this._getHeaderByIndex(index, axis, this.m_rowHeaderLevelCount);
          if (isExtend) {
            this.extendSelectionHeader(newElement, event, true);
          } else {
            if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
              // unhighlight and clear selection
              this._clearSelection(event);
              this.m_selectionFrontier = {};
            }
            this._setActive(
              newElement,
              {
                type: 'header',
                index: index,
                level: this.m_rowHeaderLevelCount,
                axis: axis
              },
              event
            );
            this._highlightActive();
          }
        } else if (axis === 'row' && jumpToHeaders && this.m_endRowEndHeader !== -1) {
          newElement = this._getHeaderByIndex(index, axis, this.m_rowEndHeaderLevelCount);
          if (isExtend) {
            this.extendSelectionHeader(newElement, event, true);
          } else {
            if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
              // unhighlight and clear selection
              this._clearSelection(event);
              this.m_selectionFrontier = {};
            }
            this._setActive(
              newElement,
              {
                type: 'header',
                index: index,
                level: this.m_rowEndHeaderLevelCount,
                axis: axis
              },
              event
            );
            this._highlightActive();
          }
        } else if (axis === 'row' || axis === 'rowEnd') {
          if (level + depth >= levelCount && !isExtend) {
            // row header, move to databody
            // make the first cell of the current row active
            // no need to scroll since it will be in the viewport
            this.m_trueIndex = { row: index };
            if (skipEmpty) {
              if (axis === 'row') {
                let focusItem = this._getEmptyCellNeighborIndex(
                  {
                    row: index,
                    column: -1
                  },
                  { right: true },
                  this._getMaxRight(),
                  this.m_endRowEndHeader
                );
                if (focusItem) {
                  if (focusItem.cell) {
                    focusFunc(focusItem.cell, event);
                  } else if (focusItem.header) {
                    // Focus Row End-Header
                    let header = this._getHeaderByIndex(
                      this.m_trueIndex.row,
                      'rowEnd',
                      this.m_rowEndHeaderLevelCount - 1
                    );
                    this._setActive(
                      header,
                      {
                        type: 'header',
                        index: index,
                        level: this.m_rowEndHeaderLevelCount - 1,
                        axis: 'rowEnd'
                      },
                      event,
                      true
                    );
                  }
                }
              } else if (axis === 'rowEnd') {
                let focusItem = this._getEmptyCellNeighborIndex(
                  {
                    row: index,
                    column: this.m_endCol + 1
                  },
                  { left: true },
                  this._getMaxLeft(),
                  this.m_startRowHeader
                );
                if (focusItem.cell) {
                  focusFunc(focusItem.cell, event);
                } else if (focusItem.header) {
                  // Focus Row End-Header
                  let header = this._getHeaderByIndex(
                    this.m_trueIndex.row,
                    'row',
                    this.m_rowHeaderLevelCount - 1
                  );
                  this._setActive(
                    header,
                    {
                      type: 'header',
                      index: index,
                      level: this.m_rowHeaderLevelCount - 1,
                      axis: 'row'
                    },
                    event,
                    true
                  );
                }
              }
            } else if (emptyElement) {
              this._setActive(emptyElement, { type: 'empty' }, event, true);
            } else {
              let lastVisibleIndex;
              let firstVisibleIndex;

              if (axis === 'row') {
                // gets the first visible cell of the current row
                for (let i = 0; i <= this.getDataSource().getCount('column') - 1; i++) {
                  if (!this.isHidden('column', i)) {
                    firstVisibleIndex = i;
                    break;
                  }
                }
                newCellIndex = this.createIndex(index, firstVisibleIndex);
              } else if (this._isHighWatermarkScrolling()) {
                lastVisibleIndex = this.getVisibleCellIndexInDirection('column', this.m_endCol, {
                  left: true
                });
                newCellIndex = this.createIndex(index, lastVisibleIndex);
              } else {
                lastVisibleIndex = this.getVisibleCellIndexInDirection(
                  'column',
                  this.getDataSource().getCount('column') - 1,
                  { left: true }
                );
                newCellIndex = this.createIndex(index, lastVisibleIndex);
              }
              if (this._isSelectionEnabled()) {
                this.selectAndFocus(newCellIndex, event);
              } else {
                let cell = this._getCellByIndex(newCellIndex);
                let shouldNotScroll = cell.classList.contains(this.getMappedStyle('frozenCell'));
                this._setActiveByIndex(newCellIndex, event, null, null, shouldNotScroll);
                this._highlightActive();
              }
            }
          } else {
            // moving down a level in the header
            let visibleIndex = this.getVisibleCellIndexInDirection(axis, index, {
              right: true
            });
            newElement = this._getHeaderByIndex(visibleIndex, axis, level + depth);
            newIndex = this._getAttribute(newElement.parentNode, 'start', true);
            newLevel = this.getHeaderCellLevel(newElement);
            if (isExtend) {
              this.extendSelectionHeader(newElement, event, true);
            } else {
              if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
                // unhighlight and clear selection
                this._clearSelection(event);
                this.m_selectionFrontier = {};
              }
              this._setActive(
                newElement,
                {
                  type: 'header',
                  index: newIndex,
                  level: newLevel,
                  axis: axis
                },
                event
              );
              this._highlightActive();
            }
          }
        } else if (
          axis === 'column' &&
          jumpToHeaders &&
          this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount - 1]
        ) {
          this._setActive(
            this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount - 1],
            {
              type: 'label',
              level: this.m_rowEndHeaderLevelCount - 1,
              axis: 'rowEnd'
            },
            event
          );
        } else {
          newIndex =
            elem != null && level !== levelCount - 1
              ? this._getAttribute(elem.parentNode, 'start', true) +
                this._getAttribute(elem.parentNode, 'extent', true)
              : index + 1;
          newElement = this._getHeaderByIndex(newIndex, axis, level);

          // iterate through headers to find the visible element to focus
          while (newElement != null && this.isHeaderHidden(newElement)) {
            newIndex =
              level !== levelCount - 1
                ? this._getAttribute(newElement.parentNode, 'start', true) +
                  this._getAttribute(newElement.parentNode, 'extent', true)
                : newIndex + 1;
            newElement = this._getHeaderByIndex(newIndex, axis, level);
          }
          newLevel = newElement != null ? this.getHeaderCellLevel(newElement) : level;

          if (
            !(newIndex > end && stopFetch) &&
            (this._isCountUnknown('column') || newIndex < this.getDataSource().getCount('column'))
          ) {
            if (isExtend) {
              this.extendSelectionHeader(newElement, event, true);
            } else {
              if (
                this._isSelectionEnabled() &&
                !this.m_discontiguousSelection &&
                this.m_options.getSelectionMode() !== 'row'
              ) {
                // unhighlight and clear selection
                this._clearSelection(event);
                this.m_selectionFrontier = {};
              }
              this._setActive(
                newElement,
                {
                  type: 'header',
                  index: newIndex,
                  level: newLevel,
                  axis: axis
                },
                event
              );
              this._highlightActive();
            }
          } else if (
            axis === 'column' &&
            this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount - 1]
          ) {
            this._setActive(
              this.m_headerLabels.rowEnd[this.m_rowEndHeaderLevelCount - 1],
              {
                type: 'label',
                level: this.m_rowEndHeaderLevelCount - 1,
                axis: 'rowEnd'
              },
              event
            );
          }
        }
        break;
      case this.keyCodes.UP_KEY:
        if (axis === 'row' || axis === 'rowEnd') {
          if (jumpToHeaders && this.m_headerLabels[axis][level]) {
            this._setActive(
              this.m_headerLabels[axis][level],
              {
                type: 'label',
                level: level,
                axis: axis
              },
              event
            );
            break;
          }
          if (
            axis === 'row' &&
            jumpToHeaders &&
            this.m_headerLabels.column[this.m_columnHeaderLevelCount - 1]
          ) {
            this._setActive(
              this.m_headerLabels.column[this.m_columnHeaderLevelCount - 1],
              {
                type: 'label',
                level: this.m_columnHeaderLevelCount - 1,
                axis: 'column'
              },
              event
            );
            break;
          }
          if (index > 0 && !this.isFirstOrFirstNonHiddenIndex(index, axis)) {
            newElement = this._getHeaderByIndex(index - 1, axis, level);
            newIndex =
              newElement != null && level !== levelCount - 1
                ? this._getAttribute(newElement.parentNode, 'start', true) -
                  this._getAttribute(newElement.parentNode, 'extent', true)
                : index - 1;
            // iterate through headers to find the visible element to focus
            let i = 1;
            while (newElement != null && this.isHeaderHidden(newElement)) {
              newIndex = index - 1 - i;
              newElement = this._getHeaderByIndex(newIndex, axis, level);
              i += 1;
            }

            newIndex =
              newElement != null && level !== levelCount - 1
                ? this._getAttribute(newElement.parentNode, 'start', true)
                : this.findNextNonHiddenIndex(newIndex, axis);

            newLevel = newElement != null ? this.getHeaderCellLevel(newElement) : level;
            if (newIndex < 0) {
              break;
            }

            if (isExtend) {
              this.extendSelectionHeader(newElement, event, true);
            } else if (newIndex < start) {
              this._scrollSkeletonHeadersIntoViewport(index, axis, level, false);
            } else {
              if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
                // unhighlight and clear selection
                this.m_selectionFrontier = {};
                this._clearSelection(event);
              }
              this._setActive(
                newElement,
                {
                  type: 'header',
                  index: newIndex,
                  level: newLevel,
                  axis: axis
                },
                event
              );
              this._highlightActive();
            }
          } else if (this.m_headerLabels[axis][level]) {
            this._setActive(
              this.m_headerLabels[axis][level],
              {
                type: 'label',
                level: level,
                axis: axis
              },
              event
            );
          } else if (
            axis === 'row' &&
            this.m_headerLabels.column[this.m_columnHeaderLevelCount - 1]
          ) {
            this._setActive(
              this.m_headerLabels.column[this.m_columnHeaderLevelCount - 1],
              {
                type: 'label',
                level: this.m_columnHeaderLevelCount - 1,
                axis: 'column'
              },
              event
            );
          }
        } else if ((axis === 'column' || axis === 'columnEnd') && level > 0) {
          // moving down a level in the header
          newElement = this._getHeaderByIndex(index, axis, level - 1);
          newIndex = this._getAttribute(newElement.parentNode, 'start', true);
          newLevel = this.getHeaderCellLevel(newElement);
          if (isExtend) {
            this.extendSelectionHeader(newElement, event, true);
          } else {
            if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
              // unhighlight and clear selection
              this.m_selectionFrontier = {};
              this._clearSelection(event);
            }
            this._setActive(
              newElement,
              {
                type: 'header',
                index: newIndex,
                level: newLevel,
                axis: axis
              },
              event
            );
            this._highlightActive();
          }
        }
        break;
      case this.keyCodes.DOWN_KEY:
        if (axis === 'columnEnd' && jumpToHeaders && this.m_endColHeader !== -1) {
          newElement = this._getHeaderByIndex(index, axis, this.m_columnHeaderLevelCount);
          if (isExtend) {
            this.extendSelectionHeader(newElement, event, true);
          } else {
            if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
              // unhighlight and clear selection
              this.m_selectionFrontier = {};
              this._clearSelection(event);
            }
            this._setActive(
              newElement,
              {
                type: 'header',
                index: index,
                level: this.m_columnHeaderLevelCount,
                axis: axis
              },
              event
            );
            this._highlightActive();
          }
        } else if (axis === 'column' && jumpToHeaders && this.m_endColEndHeader !== -1) {
          newElement = this._getHeaderByIndex(index, axis, this.m_columnEndHeaderLevelCount);
          if (isExtend) {
            this.extendSelectionHeader(newElement, event, true);
          } else {
            if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
              // unhighlight and clear selection
              this._clearSelection(event);
              this.m_selectionFrontier = {};
            }
            this._setActive(
              newElement,
              {
                type: 'header',
                index: index,
                level: this.m_columnEndHeaderLevelCount,
                axis: axis
              },
              event
            );
            this._highlightActive();
          }
        } else if (axis === 'column' || axis === 'columnEnd') {
          if (level + depth >= levelCount && !isExtend) {
            // column header, move to databody
            // make the cell of the first row and current column active
            // no need to scroll since it will be in the viewport
            this.m_trueIndex = { column: index };
            if (skipEmpty) {
              if (axis === 'column') {
                let focusItem = this._getEmptyCellNeighborIndex(
                  {
                    row: 0,
                    column: this.m_trueIndex.column
                  },
                  { down: true },
                  this._getMaxBottom(),
                  this.m_endColEndHeader
                );
                if (focusItem) {
                  if (focusItem.cell) {
                    focusFunc(focusItem.cell, event);
                  } else if (focusItem.header) {
                    // Focus Column End-Header
                    let header = this._getHeaderByIndex(
                      this.m_trueIndex.column,
                      'columnEnd',
                      this.m_columnEndHeaderLevelCount - 1
                    );
                    this._setActive(
                      header,
                      {
                        type: 'header',
                        index: index,
                        level: this.m_columnEndHeaderLevelCount - 1,
                        axis: 'columnEnd'
                      },
                      event,
                      true
                    );
                  }
                }
              } else if (axis === 'columnEnd') {
                let focusItem = this._getEmptyCellNeighborIndex(
                  {
                    row: this.m_endRow + 1,
                    column: this.m_trueIndex.column
                  },
                  { up: true },
                  this._getMaxTop(),
                  this.m_startColHeader
                );
                if (focusItem) {
                  if (focusItem.cell) {
                    focusFunc(focusItem.cell, event);
                  } else if (focusItem.header) {
                    // Focus Column Header
                    let header = this._getHeaderByIndex(
                      this.m_trueIndex.column,
                      'column',
                      this.m_columnHeaderLevelCount - 1
                    );
                    this._setActive(
                      header,
                      {
                        type: 'header',
                        index: index,
                        level: this.m_columnHeaderLevelCount - 1,
                        axis: 'column'
                      },
                      event,
                      true
                    );
                  }
                }
              }
            } else if (emptyElement) {
              this._setActive(emptyElement, { type: 'empty' }, event, true);
            } else {
              if (axis === 'column') {
                let firstVisibleRowIndex = this.getVisibleCellIndexInDirection('row', 0, {
                  down: true
                });
                newCellIndex = this.createIndex(firstVisibleRowIndex, index);
              } else if (this._isHighWatermarkScrolling()) {
                newCellIndex = this.createIndex(this.m_endRow, index);
              } else {
                let lastVisibleRowIndex = this.getVisibleCellIndexInDirection(
                  'row',
                  this.getDataSource().getCount('row') - 1,
                  { up: true }
                );
                newCellIndex = this.createIndex(lastVisibleRowIndex, index);
              }
              if (this._isSelectionEnabled()) {
                this.selectAndFocus(newCellIndex, event);
              } else {
                this._setActiveByIndex(newCellIndex, event);
                this._highlightActive();
              }
            }
          } else {
            // moving down a level in the header, get the visible cell index to focus
            index = this.getVisibleCellIndexInDirection('column', index, { down: true });
            newElement = this._getHeaderByIndex(index, axis, level + depth);
            newIndex = this._getAttribute(newElement.parentNode, 'start', true);
            newLevel = this.getHeaderCellLevel(newElement);
            if (isExtend) {
              this.extendSelectionHeader(newElement, event, true);
            } else {
              if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
                // unhighlight and clear selection
                this._clearSelection(event);
                this.m_selectionFrontier = {};
              }
              this._setActive(
                newElement,
                {
                  type: 'header',
                  index: newIndex,
                  level: newLevel,
                  axis: axis
                },
                event
              );
              this._highlightActive();
            }
          }
        } else if (
          axis === 'row' &&
          jumpToHeaders &&
          this.m_headerLabels.columnEnd[this.m_columnEndHeaderLevelCount - 1]
        ) {
          this._setActive(
            this.m_headerLabels.columnEnd[this.m_columnEndHeaderLevelCount - 1],
            {
              type: 'label',
              level: this.m_columnEndHeaderLevelCount - 1,
              axis: 'columnEnd'
            },
            event
          );
        } else {
          newIndex =
            elem != null && level !== levelCount - 1
              ? this._getAttribute(elem.parentNode, 'start', true) +
                this._getAttribute(elem.parentNode, 'extent', true)
              : index + 1;
          newElement = this._getHeaderByIndex(newIndex, axis, level);

          // iterate through headers to find the visible element to focus
          while (newElement != null && this.isHeaderHidden(newElement)) {
            newIndex =
              level !== levelCount - 1
                ? this._getAttribute(newElement.parentNode, 'start', true) +
                  this._getAttribute(newElement.parentNode, 'extent', true)
                : newIndex + 1;
            newElement = this._getHeaderByIndex(newIndex, axis, level);
          }
          newLevel = newElement != null ? this.getHeaderCellLevel(newElement) : level;

          if (
            !(newIndex > end && stopFetch) &&
            (this._isCountUnknown('row') || newIndex < this.getDataSource().getCount('row'))
          ) {
            if (isExtend) {
              this.extendSelectionHeader(newElement, event, true);
            } else {
              if (this._isSelectionEnabled() && !this.m_discontiguousSelection) {
                // unhighlight and clear selection
                this._clearSelection(event);
                this.m_selectionFrontier = {};
              }
              this._setActive(
                newElement,
                {
                  type: 'header',
                  index: newIndex,
                  level: newLevel,
                  axis: axis
                },
                event
              );
              this._highlightActive();
            }
          } else if (
            axis === 'row' &&
            this.m_headerLabels.columnEnd[this.m_columnEndHeaderLevelCount - 1]
          ) {
            this._setActive(
              this.m_headerLabels.columnEnd[this.m_rowEndHeaderLevelCount - 1],
              {
                type: 'label',
                level: this.m_columnEndHeaderLevelCount - 1,
                axis: 'columnEnd'
              },
              event
            );
          }
        }
        break;
      case this.keyCodes.PAGEUP_KEY:
        if (axis === 'row' || axis === 'rowEnd') {
          // selects the first available row header
          elem = this._getHeaderByIndex(0, axis, level);
          this._setActive(elem, { type: 'header', index: 0, level: level, axis: axis }, event);
        }
        break;
      case this.keyCodes.PAGEDOWN_KEY:
        if (axis === 'row' || axis === 'rowEnd') {
          // selects the last available row header
          if (!this._isCountUnknown('row') && !this._isHighWatermarkScrolling()) {
            index = Math.max(0, this.getDataSource().getCount('row') - 1);
          } else {
            index = Math.max(0, end);
          }
          elem = this._getHeaderByIndex(index, axis, level);
          this._setActive(elem, { type: 'header', index: index, level: level, axis: axis }, event);
        }
        break;
      case this.keyCodes.HOME_KEY:
        if (axis === 'column' || axis === 'columnEnd') {
          let firstVisibleIndex;
          // gets the first visible cell of the current row
          for (let i = 0; i <= index; i++) {
            if (!this.isHidden(axis, i)) {
              firstVisibleIndex = i;
              break;
            }
          }
          elem = this._getHeaderByIndex(firstVisibleIndex, axis, level);
          this._setActive(
            elem,
            { type: 'header', index: firstVisibleIndex, level: level, axis: axis },
            event
          );
        }
        break;
      case this.keyCodes.END_KEY:
        if (axis === 'column' || axis === 'columnEnd') {
          let lastColIndex;
          // selects the last cell of the current row
          if (!this._isCountUnknown('column') && !this._isHighWatermarkScrolling()) {
            lastColIndex = Math.max(0, this.getDataSource().getCount('column') - 1);
          } else {
            lastColIndex = Math.max(0, end);
          }
          // Check to get last visible index to focus on END keydown
          for (let i = lastColIndex; i >= index; i--) {
            if (!this.isHidden(axis, i)) {
              lastColIndex = i;
              break;
            }
          }
          // selects the first cell of the current row
          elem = this._getHeaderByIndex(lastColIndex, axis, level);
          this._setActive(
            elem,
            { type: 'header', index: lastColIndex, level: level, axis: axis },
            event
          );
        }
        break;
      default:
        break;
    }
    return true;
  };

  /**
   * Check if the focus is changing from header to databody
   * Get the label of the header
   * @param {string} axis
   * @param {number} keyCode
   * @returns {boolean} True if the header is not leaving the databody
   */
  DvtDataGrid.prototype.checkHeaderToDatabody = function (axis, keyCode) {
    if (
      !(
        (axis === 'row' &&
          this.m_rowHeaderLevelCount === this.m_selectionFrontier.level &&
          keyCode === this.keyCodes.RIGHT_KEY) ||
        (axis === 'rowEnd' &&
          this.m_rowEndHeaderLevelCount === this.m_selectionFrontier.level &&
          keyCode === this.keyCodes.LEFT_KEY) ||
        (axis === 'column' &&
          this.m_columnHeaderLevelCount === this.m_selectionFrontier.level &&
          keyCode === this.keyCodes.DOWN_KEY) ||
        (axis === 'columnEnd' &&
          this.m_columnEndHeaderLevelCount === this.m_selectionFrontier.level &&
          keyCode === this.keyCodes.UP_KEY)
      )
    ) {
      return true;
    }

    return false;
  };

  /**
   * Get the label of the header
   * @param {string} axis
   * @param {Element} root
   * @param {number} levelCount
   * @param {number} start
   * @param {number} end
   * @param {number} currentIndex
   * @param {number} previousIndex
   * @param {Element} element
   * @returns {string}
   */
  DvtDataGrid.prototype._getHeaderLabelledBy = function (
    axis,
    levelCount,
    end,
    currentIndex,
    previousIndex,
    element
  ) {
    var previousElement;
    if (end !== -1 && (currentIndex !== previousIndex || this.m_externalFocus)) {
      var columnEndHeader = this.getHeaderFromCell(element, axis);
      if (previousIndex != null) {
        previousElement = this._getHeaderByIndex(previousIndex, axis, levelCount - 1);
      }
      return this._getHeaderAndParentIds(columnEndHeader, previousElement);
    }
    return '';
  };

  /**
   * Get the Id's in a string to put in the accessibility labelledby
   * @param {Element=} header
   * @param {Element=} previousHeader
   * @returns {string}
   */
  DvtDataGrid.prototype._getHeaderAndParentIds = function (header, previousHeader) {
    var idString = '';
    var previousParents = [];

    if (header == null) {
      // header not rendered
      return '';
    }

    var parents = this._getHeaderAndParents(header);
    if (previousHeader != null) {
      previousParents = this._getHeaderAndParents(previousHeader);
    }
    for (var i = 0; i < parents.length; i++) {
      // always add the header that we are focusing
      if (previousParents[i] !== parents[i] || i === parents.length - 1) {
        idString += (idString === '' ? '' : ' ') + parents[i].id;
      }
    }
    return idString;
  };

  /**
   * Get the nested headers above the header and including the header.
   * Puts them in an array starting with the outermost.
   * @param {Element} header
   * @returns {Array}
   */
  DvtDataGrid.prototype._getHeaderAndParents = function (header) {
    var headers = [header];
    var axis = this.getHeaderCellAxis(header);
    var level = this.getHeaderCellLevel(header);
    var headerLabel = this._getLabel(axis, level);
    var headerLevels;

    if (axis === 'row') {
      headerLevels = this.m_rowHeaderLevelCount;
    } else if (axis === 'column') {
      headerLevels = this.m_columnHeaderLevelCount;
    } else if (axis === 'rowEnd') {
      headerLevels = this.m_rowEndHeaderLevelCount;
    } else if (axis === 'columnEnd') {
      headerLevels = this.m_columnEndHeaderLevelCount;
    }

    if (headerLabel) {
      headers.unshift(headerLabel);
    }

    if (headerLevels === 1) {
      return headers;
    } else if (level === headerLevels - 1) {
      // eslint-disable-next-line no-param-reassign
      header = header.parentNode.firstChild;
      headers.unshift(header);
      level -= 1;
      headerLabel = this._getLabel(axis, level);
      if (headerLabel) {
        headers.unshift(headerLabel);
      }
    }

    while (level > 0) {
      // eslint-disable-next-line no-param-reassign
      header = header.parentNode.parentNode.firstChild;
      headers.unshift(header);
      level -= 1;
      headerLabel = this._getLabel(axis, level);
      if (headerLabel) {
        headers.unshift(headerLabel);
      }
    }
    return headers;
  };

  /**
   * Checks if the input selection Frontier is type header
   * @param {Object} selectionFrontier
   * @returns {boolean} true if type header, false otherwise
   */
  DvtDataGrid.prototype.isHeaderSelectionType = function (selectionFrontier) {
    if (selectionFrontier && selectionFrontier.axis) {
      return true;
    }

    return false;
  };

  // returns true if a cell is empty.
  // empty cell is either a node without children or text content.

  DvtDataGrid.prototype._isChildEmpty = function (cell) {
    if (cell) {
      let data = cell.textContent.trim();
      if (cell.children.length > 0 || data.length > 0) {
        return false;
      }
      return true;
    }
    return false;
  };

  // eslint-disable-next-line consistent-return
  DvtDataGrid.prototype._isNeighborCellEmpty = function (cell, axis) {
    let rowIndex = this._getIndex(cell, 'row');
    let columnIndex = this._getIndex(cell, 'column');

    if (axis === 'row') {
      let prevColIndex = this.getVisibleCellIndexInDirection('column', columnIndex - 1, {
        left: true
      });
      let nextColIndex = this.getVisibleCellIndexInDirection('column', columnIndex + 1, {
        right: true
      });
      let previousCell = this._getCellByIndex({ row: rowIndex, column: prevColIndex });
      let nextCell = this._getCellByIndex({ row: rowIndex, column: nextColIndex });

      // On Ctrl arrow,
      // to focus neighbor cell of empty cell, we are checking
      // if current index prev/next cell is empty and current index cell not empty
      // Also, if there are any empty hidden columns, we are not following Ctrl + Arrow behavior
      if (
        (this._isChildEmpty(previousCell) || this._isChildEmpty(nextCell)) &&
        !this._isChildEmpty(cell) &&
        !this.isHidden('column', columnIndex)
      ) {
        return true;
      }
    } else if (axis === 'column') {
      let previousCell = this._getCellByIndex({ row: rowIndex - 1, column: columnIndex });
      let nextCell = this._getCellByIndex({ row: rowIndex + 1, column: columnIndex });

      if (
        (this._isChildEmpty(previousCell) || this._isChildEmpty(nextCell)) &&
        !this._isChildEmpty(cell)
      ) {
        return true;
      }
    }
    return false;
  };

  // Given the direction of arrow,
  // checks and returns the empty cell neighbor index if any
  // else returns respective start/end headers
  // eslint-disable-next-line consistent-return
  DvtDataGrid.prototype._getEmptyCellNeighborIndex = function (
    currentIndex,
    arrow,
    viewportLength,
    headerIndex
  ) {
    let row = currentIndex.row;
    let column = currentIndex.column;
    let focusItem = Object.create({});
    let axis;
    let index;
    let rowDelta;
    let colDelta;
    let delta;
    let cell;
    let focusCell;
    let rowAxis = arrow.left || arrow.right;
    let columnAxis = arrow.up || arrow.down;
    let iIncrement = arrow.right || arrow.down;
    let iDecrement = arrow.left || arrow.up;
    if (rowAxis) {
      axis = 'row';
      index = column;
      rowDelta = row;
    } else if (columnAxis) {
      axis = 'column';
      index = row;
      colDelta = column;
    }
    if (iIncrement) {
      delta = 1;
      focusCell = viewportLength;
    } else if (iDecrement) {
      delta = -1;
      focusCell = viewportLength - 1;
    }
    let i = index;
    let range;
    while (iDecrement ? i >= viewportLength : i <= viewportLength) {
      if (iIncrement) {
        range = i < viewportLength;
      } else if (iDecrement) {
        range = i > viewportLength;
      }
      if (rowAxis) {
        if (i === viewportLength) {
          colDelta = focusCell;
        } else {
          colDelta = i + delta;
        }
      } else if (columnAxis) {
        if (i === viewportLength) {
          rowDelta = focusCell;
        } else {
          rowDelta = i + delta;
        }
      }
      cell = this._getCellByIndex({ row: rowDelta, column: colDelta });
      if (range && this._isNeighborCellEmpty(cell, axis)) {
        focusItem.cell = this.createIndex(rowDelta, colDelta);
        return focusItem;
      } else if (i === viewportLength) {
        let limit;
        if (iIncrement) {
          limit = (arrow.right ? this._isLastColumn(i) : this._isLastRow(i)) && headerIndex !== -1;
        } else if (iDecrement) {
          limit = i === 0;
        }
        if (limit) {
          focusItem.header = true;
          return focusItem;
        }
        focusItem.cell = this.createIndex(rowDelta, colDelta);
        return focusItem;
      }
      i += delta;
    }
    return null;
  };

  /**
   * Handles arrow keys navigation on empty databody
   * @param {number} keyCode description
   * @param {boolean} isExtend
   * @param {Event} event the DOM event causing the arrow keys
   * @param {boolean} changeRegions
   * @param {boolean} jumpToHeaders jump to headers if possible
   */
  DvtDataGrid.prototype.handleNoDataFocusChange = function (keyCode, isExtend, event, changeRegions) {
    let header;

    if (this.m_active == null) {
      return null;
    }

    if (this.getResources().isRTLMode()) {
      if (keyCode === this.keyCodes.LEFT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.RIGHT_KEY;
      } else if (keyCode === this.keyCodes.RIGHT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.LEFT_KEY;
      }
    }

    switch (keyCode) {
      case this.keyCodes.UP_KEY:
        if (!isExtend && changeRegions && this.m_endColHeader !== -1) {
          header = this._getHeaderByIndex(
            this.m_startColHeader,
            'column',
            this.m_columnHeaderLevelCount - 1
          );
          this._setActive(
            header,
            {
              type: 'header',
              index: this.m_startColHeader,
              level: this.m_columnHeaderLevelCount - 1,
              axis: 'column'
            },
            event,
            true
          );
        }
        break;
      case this.keyCodes.DOWN_KEY:
        if (this.m_endColEndHeader !== -1 && changeRegions) {
          header = this._getHeaderByIndex(
            this.m_startColEndHeader,
            'columnEnd',
            this.m_columnEndHeaderLevelCount - 1
          );
          this._setActive(
            header,
            {
              type: 'header',
              index: this.m_startColEndHeader,
              level: this.m_columnEndHeaderLevelCount - 1,
              axis: 'columnEnd'
            },
            event,
            true
          );
        }
        break;
      case this.keyCodes.LEFT_KEY:
        if (!isExtend && changeRegions && this.m_endRowHeader !== -1) {
          header = this._getHeaderByIndex(
            this.m_startRowHeader,
            'row',
            this.m_rowHeaderLevelCount - 1
          );
          this._setActive(
            header,
            {
              type: 'header',
              index: this.m_startRowHeader,
              level: this.m_rowHeaderLevelCount - 1,
              axis: 'row'
            },
            event,
            true
          );
        }
        break;
      case this.keyCodes.RIGHT_KEY:
        if (this.m_endRowEndHeader !== -1 && changeRegions) {
          // navigate from empty databody to row end header
          header = this._getHeaderByIndex(
            this.m_startRowEndHeader,
            'rowEnd',
            this.m_rowEndHeaderLevelCount - 1
          );
          this._setActive(
            header,
            {
              type: 'header',
              index: this.m_startRowEndHeader,
              level: this.m_rowEndHeaderLevelCount - 1,
              axis: 'rowEnd'
            },
            event,
            true
          );
        }
        break;
      default:
        break;
    }
    return true;
  };

  /**
   * Handles arrow keys navigation on cell
   * @param {number} keyCode description
   * @param {boolean} isExtend
   * @param {Event} event the DOM event causing the arrow keys
   * @param {boolean} changeRegions
   * @param {boolean} jumpToHeaders jump to headers if possible
   */
  DvtDataGrid.prototype.handleFocusChange = function (
    keyCode,
    isExtend,
    event,
    changeRegions,
    jumpToHeaders,
    skipEmpty = false,
    cellExtreme = false
  ) {
    var currentCellIndex;
    var newCellIndex;
    var header;
    var rowExtent = 1;
    var columnExtent = 1;

    if (this.getResources().isRTLMode()) {
      if (keyCode === this.keyCodes.LEFT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.RIGHT_KEY;
      } else if (keyCode === this.keyCodes.RIGHT_KEY) {
        // eslint-disable-next-line no-param-reassign
        keyCode = this.keyCodes.LEFT_KEY;
      }
    }

    // ensure that there's no outstanding fetch requests
    if (!this.isFetchComplete() && this.m_fetchingForUpdate === false) {
      // with right and down key fetch is triggered before key down on last column/row
      // so need to scroll skeleton into viewport here
      if (this.m_skeletonSet.size > 0 && !isExtend) {
        currentCellIndex = this.m_active.indexes;
        const column = currentCellIndex.column;
        const row = currentCellIndex.row;
        if (keyCode === this.keyCodes.RIGHT_KEY && column + 1 === this.m_endCol + 1) {
          this._scrollSkeletonCellsIntoViewport(row, column, 'column', true);
        } else if (keyCode === this.keyCodes.DOWN_KEY && row + 1 === this.m_endRow + 1) {
          this._scrollSkeletonCellsIntoViewport(row, column, 'row', true);
        }
      }
      // act as if processed to prevent page scrolling before fetch done
      return true;
    }

    if (isExtend) {
      currentCellIndex = this.m_selectionFrontier;
      // if extending and selection frontier has an axis component, we are in header realm
      if (this.isHeaderSelectionType(this.m_selectionFrontier)) {
        this.handleHeaderFocusChange(keyCode, event, isExtend, jumpToHeaders);
        return undefined;
      }
    } else {
      currentCellIndex = this.m_active.indexes;
    }

    if (currentCellIndex == null) {
      return undefined;
    }

    if (this.m_trueIndex == null) {
      this.m_trueIndex = {};
    }

    var focusFunc;
    var row;
    var column;
    var currentCell;
    var cellContext;

    // invoke different function for handling focusing on active cell depending on whether selection is enabled
    focusFunc = this._isSelectionEnabled()
      ? this.selectAndFocus.bind(this)
      : this._setActiveByIndex.bind(this);
    row = currentCellIndex.row;
    column = currentCellIndex.column;
    currentCell = this._getCellByIndex(currentCellIndex);
    if (currentCell) {
      cellContext = currentCell[this.getResources().getMappedAttribute('context')];
      rowExtent = cellContext.extents.row;
      columnExtent = cellContext.extents.column;
    }

    // navigation to cell using arrow keys.  We are using index instead of dom element
    // because the dom element might not be there in all cases
    switch (keyCode) {
      case this.keyCodes.LEFT_KEY:
        if (!this.m_trueIndex.row && !isExtend) {
          this.m_trueIndex = { row: row };
        }
        if (skipEmpty) {
          // eslint-disable-next-line block-scoped-var
          let currentRow = cellContext.indexes.row;
          // eslint-disable-next-line block-scoped-var
          let currentColumn = cellContext.indexes.column;
          // get empty cell neighbor index in current row
          let focusItem = this._getEmptyCellNeighborIndex(
            { row: currentRow, column: currentColumn },
            { left: true },
            this._getMaxLeft(),
            this.m_startRowHeader
          );
          // if there is an empty cell, focus neighbor cell else focus row start header
          if (focusItem) {
            if (focusItem.cell) {
              focusFunc(focusItem.cell, event);
            } else if (focusItem.header) {
              header = this._getHeaderByIndex(
                this.m_trueIndex.row,
                'row',
                this.m_rowHeaderLevelCount - 1
              );
              this._setActive(
                header,
                {
                  type: 'header',
                  index: this.m_trueIndex.row,
                  level: this.m_rowHeaderLevelCount - 1,
                  axis: 'row'
                },
                event,
                true
              );
            }
          }
        } else if (column > 0 && !(jumpToHeaders && this.m_endRowHeader !== -1)) {
          // for left and right key in row selection mode, we'll be only shifting active cell and
          // selection will not be affected
          if (this.m_options.getSelectionMode() === 'row') {
            // ensure active cell index is used for row since it might use frontier if extended
            newCellIndex = this.createIndex(this.m_trueIndex.row, column - 1);
            this._setActiveByIndex(newCellIndex, event);
          } else {
            if (isExtend) {
              newCellIndex = this.createIndex(row, column - 1);
              this.extendSelection(newCellIndex, event, keyCode);
            } else if (column - 1 < this.m_startCol) {
              this._scrollSkeletonCellsIntoViewport(row, column, 'column', false);
            } else {
              let visibleColumnIndex = column - 1;
              let rowStartHeader = false;
              while (this.isHidden('column', visibleColumnIndex)) {
                if (visibleColumnIndex === 0) {
                  visibleColumnIndex = this.getVisibleCellIndexInDirection(
                    'column',
                    visibleColumnIndex,
                    {
                      right: true
                    }
                  );
                  rowStartHeader = true;
                  break;
                }
                visibleColumnIndex -= 1;
              }
              if (rowStartHeader && changeRegions) {
                header = this._getHeaderByIndex(
                  this.m_trueIndex.row,
                  'row',
                  this.m_rowHeaderLevelCount - 1
                );
                this._setActive(
                  header,
                  {
                    type: 'header',
                    index: this.m_trueIndex.row,
                    level: this.m_rowHeaderLevelCount - 1,
                    axis: 'row'
                  },
                  event,
                  true
                );
              } else {
                newCellIndex = this.createIndex(this.m_trueIndex.row, visibleColumnIndex);
                focusFunc(newCellIndex, event);
              }
            }

            // announce to screen reader that we have reached first column
            if (column - 1 === 0) {
              this._setAccInfoText('accessibleFirstColumn');
            }
          }
        } else if (!isExtend && changeRegions) {
          // reached the first column, go to row header if available
          header = this._getHeaderByIndex(
            this.m_trueIndex.row,
            'row',
            this.m_rowHeaderLevelCount - 1
          );
          if (this.m_discontiguousSelection) {
            this.discontiguousHeaderSetActiveFromDatabody(
              event,
              'row',
              header,
              this.m_rowHeaderLevelCount
            );
          } else {
            this._setActive(
              header,
              {
                type: 'header',
                index: this.m_trueIndex.row,
                level: this.m_rowHeaderLevelCount - 1,
                axis: 'row'
              },
              event,
              true
            );
          }
        }
        break;
      case this.keyCodes.RIGHT_KEY:
        if (!this.m_trueIndex.row && !isExtend) {
          this.m_trueIndex = { row: row };
        }
        if (skipEmpty) {
          // eslint-disable-next-line block-scoped-var
          let currentRow = cellContext.indexes.row;
          // eslint-disable-next-line block-scoped-var
          let currentColumn = cellContext.indexes.column;
          // get empty cell neighbor Index in current row
          let focusItem = this._getEmptyCellNeighborIndex(
            { row: currentRow, column: currentColumn },
            { right: true },
            this._getMaxRight(),
            this.m_endRowEndHeader
          );
          // if there is an empty cell, focus neighbor cell else focus row end-header
          if (focusItem) {
            if (focusItem.cell) {
              focusFunc(focusItem.cell, event);
            } else if (focusItem.header) {
              header = this._getHeaderByIndex(
                this.m_trueIndex.row,
                'rowEnd',
                this.m_rowEndHeaderLevelCount - 1
              );
              this._setActive(
                header,
                {
                  type: 'header',
                  index: this.m_trueIndex.row,
                  level: this.m_rowEndHeaderLevelCount - 1,
                  axis: 'rowEnd'
                },
                event,
                true
              );
            }
          }
        }
        // if condition for unknown count and known count cases on whether we have reached the end
        else if (
          !this._isLastColumn(column + (columnExtent - 1)) &&
          !(jumpToHeaders && this.m_endRowEndHeader !== -1)
        ) {
          // for left and right key in row selection mode, we'll be only shifting active cell and
          // selection will not be affected
          if (this.m_options.getSelectionMode() === 'row') {
            // ensure active cell index is used for row since it might use frontier if extended
            newCellIndex = this.createIndex(this.m_trueIndex.row, column + columnExtent);
            this._setActiveByIndex(newCellIndex, event);
          } else {
            if (isExtend) {
              newCellIndex = this.createIndex(row, column + 1);
              this.extendSelection(newCellIndex, event, keyCode);
            } else {
              let visibleColumnIndex = column + columnExtent;
              let rowEndHeader = false;
              while (this.isHidden('column', visibleColumnIndex)) {
                if (this._isLastColumn(visibleColumnIndex)) {
                  visibleColumnIndex = this.getVisibleCellIndexInDirection(
                    'column',
                    visibleColumnIndex,
                    {
                      left: true
                    }
                  );
                  rowEndHeader = true;
                  break;
                }
                visibleColumnIndex += 1;
              }
              if (rowEndHeader && this.m_endRowEndHeader !== -1) {
                header = this._getHeaderByIndex(
                  this.m_trueIndex.row,
                  'rowEnd',
                  this.m_rowEndHeaderLevelCount - 1
                );
                this._setActive(
                  header,
                  {
                    type: 'header',
                    index: this.m_trueIndex.row,
                    level: this.m_rowEndHeaderLevelCount - 1,
                    axis: 'rowEnd'
                  },
                  event,
                  true
                );
              } else {
                newCellIndex = this.createIndex(this.m_trueIndex.row, visibleColumnIndex);
                focusFunc(newCellIndex, event);
              }
            }

            // announce to screen reader that we have reached last column
            if (this._isLastColumn(column + columnExtent)) {
              this._setAccInfoText('accessibleLastColumn');
            }
          }
        } else if (this.m_endRowEndHeader !== -1 && changeRegions) {
          // reached the last column, go to row end header if available
          header = this._getHeaderByIndex(
            this.m_trueIndex.row,
            'rowEnd',
            this.m_rowEndHeaderLevelCount - 1
          );
          if (this.m_discontiguousSelection) {
            this.discontiguousHeaderSetActiveFromDatabody(
              event,
              'rowEnd',
              header,
              this.m_rowEndHeaderLevelCount
            );
          } else {
            this._setActive(
              header,
              {
                type: 'header',
                index: this.m_trueIndex.row,
                level: this.m_rowEndHeaderLevelCount - 1,
                axis: 'rowEnd'
              },
              event,
              true
            );
          }
        } else if (!isExtend) {
          // if anchor cell is in the last column, and they arrow right (without Shift), then collapse the range to just the focus cell.  (Matches Excel and intuition.)
          focusFunc(currentCellIndex, event);
        }
        break;
      case this.keyCodes.UP_KEY:
        if (!this.m_trueIndex.column && !isExtend) {
          this.m_trueIndex = { column: column };
        }
        if (skipEmpty) {
          // eslint-disable-next-line block-scoped-var
          let currentRow = cellContext.indexes.row;
          // eslint-disable-next-line block-scoped-var
          let currentColumn = cellContext.indexes.column;
          // get empty cell neighbor Index in current column
          let focusItem = this._getEmptyCellNeighborIndex(
            { row: currentRow, column: currentColumn },
            { up: true },
            this._getMaxTop(),
            this.m_startColHeader
          );
          // if there is an empty cell, focus neighbor cell else focus column start header
          if (focusItem) {
            if (focusItem.cell) {
              focusFunc(focusItem.cell, event);
            } else if (focusItem.header) {
              header = this._getHeaderByIndex(
                this.m_trueIndex.column,
                'column',
                this.m_columnHeaderLevelCount - 1
              );
              this._setActive(
                header,
                {
                  type: 'header',
                  index: this.m_trueIndex.column,
                  level: this.m_columnHeaderLevelCount - 1,
                  axis: 'column'
                },
                event,
                true
              );
            }
          }
        } else if (row > 0 && !(jumpToHeaders && this.m_endColHeader !== -1)) {
          if (isExtend) {
            newCellIndex = this.createIndex(row - 1, column);
            this.extendSelection(newCellIndex, event, keyCode);
          } else if (row - 1 < this.m_startRow) {
            this._scrollSkeletonCellsIntoViewport(row, column, 'row', false);
          } else {
            let visibleRowIndex = this.getVisibleCellIndexInDirection('row', row - 1, { up: true });
            // if 'row' is the first visible index, need to focus header
            if (visibleRowIndex === -1 && changeRegions) {
              header = this._getHeaderByIndex(
                this.m_trueIndex.column,
                'column',
                this.m_columnHeaderLevelCount - 1
              );
              this._setActive(
                header,
                {
                  type: 'header',
                  index: this.m_trueIndex.column,
                  level: this.m_columnHeaderLevelCount - 1,
                  axis: 'column'
                },
                event,
                true
              );
            } else {
              // focus visible databody cell
              newCellIndex = this.createIndex(visibleRowIndex, this.m_trueIndex.column);
              focusFunc(newCellIndex, event);
            }
          }

          // announce to screen reader that we have reached first row
          if (row - 1 === 0) {
            this._setAccInfoText('accessibleFirstRow');
          }
        } else if (!isExtend && changeRegions) {
          // if in multiple selection don't clear the selection
          header = this._getHeaderByIndex(
            this.m_trueIndex.column,
            'column',
            this.m_columnHeaderLevelCount - 1
          );
          if (this.m_discontiguousSelection) {
            this.discontiguousHeaderSetActiveFromDatabody(
              event,
              'column',
              header,
              this.m_columnHeaderLevelCount
            );
          } else {
            this._setActive(
              header,
              {
                type: 'header',
                index: this.m_trueIndex.column,
                level: this.m_columnHeaderLevelCount - 1,
                axis: 'column'
              },
              event,
              true
            );
          }
        }
        break;
      case this.keyCodes.DOWN_KEY:
        if (!this.m_trueIndex.column && !isExtend) {
          this.m_trueIndex = { column: column };
        }
        if (skipEmpty) {
          // eslint-disable-next-line block-scoped-var
          let currentRow = cellContext.indexes.row;
          // eslint-disable-next-line block-scoped-var
          let currentColumn = cellContext.indexes.column;
          // get empty cell neighbor Index in current column
          let focusItem = this._getEmptyCellNeighborIndex(
            { row: currentRow, column: currentColumn },
            { down: true },
            this._getMaxBottom(),
            this.m_endColEndHeader
          );
          // if there is an empty cell, focus neighbor cell else focus column end header
          if (focusItem) {
            if (focusItem.cell) {
              focusFunc(focusItem.cell, event);
            } else if (focusItem.header) {
              header = this._getHeaderByIndex(
                this.m_trueIndex.column,
                'columnEnd',
                this.m_columnEndHeaderLevelCount - 1
              );
              this._setActive(
                header,
                {
                  type: 'header',
                  index: this.m_trueIndex.column,
                  level: this.m_columnEndHeaderLevelCount - 1,
                  axis: 'columnEnd'
                },
                event,
                true
              );
            }
          }
        } else if (
          !this._isLastRow(row + (rowExtent - 1)) &&
          !(jumpToHeaders && this.m_endColEndHeader !== -1)
        ) {
          if (isExtend) {
            newCellIndex = this.createIndex(row + 1, column);
            this.extendSelection(newCellIndex, event, keyCode);
          } else {
            let visibleRowIndex = this.getVisibleCellIndexInDirection('row', row + rowExtent, {
              down: true
            });
            // if it's last visible row
            if (visibleRowIndex > this._getLastAxis('row') && changeRegions) {
              header = this._getHeaderByIndex(
                this.m_trueIndex.column,
                'columnEnd',
                this.m_columnEndHeaderLevelCount - 1
              );
              this._setActive(
                header,
                {
                  type: 'header',
                  index: this.m_trueIndex.column,
                  level: this.m_columnEndHeaderLevelCount - 1,
                  axis: 'columnEnd'
                },
                event,
                true
              );
            } else {
              newCellIndex = this.createIndex(visibleRowIndex, this.m_trueIndex.column);
              focusFunc(newCellIndex, event);
            }
          }

          // announce to screen reader that we have reached last row
          if (this._isLastRow(row + rowExtent)) {
            this._setAccInfoText('accessibleLastRow');
          }
        } else if (this.m_endColEndHeader !== -1 && changeRegions) {
          // reached the last column, go to column end header if available
          header = this._getHeaderByIndex(
            this.m_trueIndex.column,
            'columnEnd',
            this.m_columnEndHeaderLevelCount - 1
          );
          if (this.m_discontiguousSelection) {
            this.discontiguousHeaderSetActiveFromDatabody(
              event,
              'columnEnd',
              header,
              this.m_columnEndHeaderLevelCount
            );
          } else {
            this._setActive(
              header,
              {
                type: 'header',
                index: this.m_trueIndex.column,
                level: this.m_columnEndHeaderLevelCount - 1,
                axis: 'columnEnd'
              },
              event,
              true
            );
          }
        } else if (!isExtend) {
          // if anchor cell is in the last row, and they arrow down (without Shift), then collapse the range to just the focus cell.  (Matches Excel and intuition.)
          focusFunc(currentCellIndex, event);
        }
        break;
      case this.keyCodes.HOME_KEY: {
        let rowIndex = 0;
        let colIndex = 0;
        // Check to get first visible index to focus on HOME keydown
        for (let i = 0; i <= column; i++) {
          if (!this.isHidden('column', i)) {
            colIndex = i;
            break;
          }
        }

        if (cellExtreme) {
          var firstCellIndex = this.createIndex(rowIndex, colIndex);
          focusFunc(firstCellIndex, event);
        } else {
          if (!this.m_trueIndex.row) {
            this.m_trueIndex = { row: row };
          }
          // selects the first cell of the current row
          newCellIndex = this.createIndex(this.m_trueIndex.row, colIndex);
          focusFunc(newCellIndex, event);
        }
        break;
      }
      case this.keyCodes.END_KEY: {
        if (!this.m_trueIndex.row) {
          this.m_trueIndex = { row: row, column: column };
        }
        let lastColIndex;
        if (!this._isCountUnknown('column') && !this._isHighWatermarkScrolling()) {
          lastColIndex = Math.max(0, this.getDataSource().getCount('column') - 1);
        } else {
          lastColIndex = Math.max(0, this.m_endCol);
        }
        // Check to get last visible index to focus on END keydown
        for (let i = lastColIndex; i >= column; i--) {
          if (!this.isHidden('column', i)) {
            lastColIndex = i;
            break;
          }
        }
        if (cellExtreme) {
          let lastCellIndex;
          if (!this._isCountUnknown('column') && !this._isHighWatermarkScrolling()) {
            lastCellIndex = this.createIndex(
              Math.max(0, this.getDataSource().getCount('row') - 1),
              lastColIndex
            );
          } else {
            lastCellIndex = this.createIndex(Math.max(0, this.m_endRow), lastColIndex);
          }
          focusFunc(lastCellIndex, event);
        } else {
          // selects the last cell of the current row
          if (!this._isCountUnknown('column') && !this._isHighWatermarkScrolling()) {
            newCellIndex = this.createIndex(this.m_trueIndex.row, lastColIndex);
          } else {
            newCellIndex = this.createIndex(this.m_trueIndex.row, Math.max(0, lastColIndex));
          }
          focusFunc(newCellIndex, event);
        }
        break;
      }
      case this.keyCodes.PAGEUP_KEY:
        if (!this.m_trueIndex.column) {
          this.m_trueIndex = { column: column };
        }
        // selects the first cell of the current column
        newCellIndex = this.createIndex(0, column);
        focusFunc(newCellIndex, event);
        break;
      case this.keyCodes.PAGEDOWN_KEY:
        if (!this.m_trueIndex.column) {
          this.m_trueIndex = { column: column };
        }
        // selects the last cell of the current column
        if (!this._isCountUnknown('column') && !this._isHighWatermarkScrolling()) {
          newCellIndex = this.createIndex(
            Math.max(0, this.getDataSource().getCount('row') - 1),
            this.m_trueIndex.column
          );
        } else {
          newCellIndex = this.createIndex(Math.max(0, this.m_endRow), this.m_trueIndex.column);
        }
        focusFunc(newCellIndex, event);
        break;
      default:
        break;
    }

    return true;
  };

  /**
   * Scrolls to an  index
   * @param {Object} index - the end index of the selection.
   * @param {boolean|null=} ignoreHighlight - true if we want to ignore highlighting a cell
   * @param {boolean|null=} scrollToOrigin - true if we align the viewport with the origin
   */
  DvtDataGrid.prototype.scrollToIndex = function (index, ignoreHighlight, scrollToOrigin) {
    var scrollRows;
    var row = index.row;
    var column = index.column;
    var cell;

    if (ignoreHighlight) {
      this.m_shouldFocus = false;
    }
    if (scrollToOrigin) {
      // eslint-disable-next-line no-param-reassign
      index.scrollToOrigin = true;
    }

    var dir = this.getResources().isRTLMode() ? 'right' : 'left';

    var deltaX = 0;
    var deltaY = 0;
    var viewportTop = this._getViewportTop();
    var viewportBottom = this._getViewportBottom();
    var viewportLeft = this._getViewportLeft();
    var viewportRight = this._getViewportRight();

    // check if index is completely outside of rendered
    if (row < this.m_startRow || row > this.m_endRow) {
      var scrollTop;
      if (row < this.m_startRow) {
        scrollTop = this.m_avgRowHeight * row;
      } else {
        scrollTop = this.m_avgRowHeight * (row + 1) - viewportBottom + viewportTop;
      }
      deltaY = this.m_currentScrollTop - scrollTop;

      // remember to focus on the row after fetch
      this.m_scrollIndexAfterFetch = index;
      scrollRows = true;
    } else {
      // it's rendered, find location and scroll to it
      cell = this._getCellByIndex(index);
      let frozenCellStyle = this.getMappedStyle('frozenCell');
      var rowHeight;
      if (cell === null) {
        // can't guarantee the actual cell is there just one with the same row index
        // we know we can't get the extent of the cell either since it is not there
        // so we know to scroll to the top + height of the key (not height of cell
        // as it can span multiple rows)
        cell = this._getFirstCellWithMatchingStartIndex(row, 'row');
        rowHeight = this.m_sizingManager.getSize('row', this._getKey(cell, 'row'));
      } else {
        rowHeight = this.getElementHeight(cell);
      }
      var rowTop = this.getElementDir(cell, 'top');

      // If we are scrolling to a row position, align it to the top row of the viewport
      // if specified
      if (scrollToOrigin || index.scrollToOrigin) {
        deltaY = viewportTop - rowTop;
      } else if (rowTop + rowHeight > viewportBottom) {
        deltaY = viewportBottom - (rowTop + rowHeight);
      } else if (rowTop < viewportTop) {
        deltaY = viewportTop - rowTop;
      }
      if (cell && cell.classList.contains(frozenCellStyle)) {
        let container = this._getCellContainer(cell);
        if (
          container.classList.contains(this.getMappedStyle('databodyFrozenRow')) ||
          container.classList.contains(this.getMappedStyle('databodyFrozenCorner'))
        ) {
          deltaY = 0;
        }
      }
    }

    // if column is defined and it's not already a fetch outside of rendered
    // use scrollRows to know it was not pre-defined
    // if initial Scroll, we should adjust the column
    if (!isNaN(column) && scrollRows !== true) {
      // check if index is completely outside of rendered
      // approximate scroll position
      if (column < this.m_startCol || column > this.m_endCol) {
        var scrollLeft;
        let hiddenColumnsInDirection;
        let hiddenLength;
        if (column < this.m_startCol) {
          hiddenColumnsInDirection = this.hiddenColumnsInDirection(column, { left: true });
          hiddenLength = hiddenColumnsInDirection.length;
          scrollLeft = this.m_avgColWidth * (column - hiddenLength);
        } else {
          hiddenColumnsInDirection = this.hiddenColumnsInDirection(column, { right: true });
          hiddenLength = hiddenColumnsInDirection.length;
          scrollLeft =
            this.m_avgColWidth * (column - hiddenLength + 1) - viewportRight + viewportLeft;
        }
        deltaX = this.m_currentScrollLeft - scrollLeft;

        // remember to focus on the cell after fetch
        this.m_scrollIndexAfterFetch = index;
      } else {
        // it's rendered, find location and scroll to it
        cell = this._getCellByIndex(index);
        var cellWidth;
        if (cell === null) {
          // see comment for row heights above
          cell = this._getFirstCellWithMatchingStartIndex(column, 'column');
          cellWidth = this.m_sizingManager.getSize('column', this._getKey(cell, 'column'));
        } else {
          cellWidth = this.getElementWidth(cell);
        }
        var cellLeft = this.getElementDir(cell, dir);

        if (scrollToOrigin || index.scrollToOrigin) {
          deltaX = viewportLeft - cellLeft;
        } else if (cellLeft < viewportLeft) {
          deltaX = viewportLeft - cellLeft;
        } else if (cellLeft + cellWidth > viewportRight) {
          deltaX = viewportRight - (cellLeft + cellWidth);
        }
        let frozenCellStyle = this.getMappedStyle('frozenCell');
        if (cell && cell.classList.contains(frozenCellStyle)) {
          let container = this._getCellContainer(cell);
          if (
            container.classList.contains(this.getMappedStyle('databodyFrozenCol')) ||
            container.classList.contains(this.getMappedStyle('databodyFrozenCorner'))
          ) {
            deltaX = 0;
          }
        }
      }
    }

    // scroll if either horiz or vert scroll pos has changed
    if (deltaX !== 0 || deltaY !== 0) {
      cell = this._getCellByIndex(index);

      // this.m_shouldFocus for second call after initial scroll.
      if (cell != null && ignoreHighlight !== true && this.m_shouldFocus !== false) {
        // delay focus on cell until databody has scrolled (by the scroll event handler)
        // if we are not highlighting, ignore this
        this.m_cellToFocus = cell;
      }
      this.scrollDelta(deltaX, deltaY);
    } else if (this.m_scrollIndexAfterFetch != null) {
      // if there's an index we wanted to scroll to after fetch it has now been scrolled to by scrollToIndex, so highlight it
      // this.m_shouldFocus for second call after initial scroll.
      if (!ignoreHighlight && this.m_shouldFocus !== false) {
        if (this._setActiveByIndex(this.m_scrollIndexAfterFetch, null, false, false, true)) {
          this.m_scrollIndexAfterFetch = null;
        }
      } else {
        this.m_scrollIndexAfterFetch = null;
      }
    }
  };

  /**
   * Scrolls to an  index
   * @param {Object} headerInfo
   * @param {string} headerInfo.axis
   * @param {number} headerInfo.index
   * @param {number} headerInfo.level
   */
  DvtDataGrid.prototype.scrollToHeader = function (headerInfo) {
    var startIndex;
    var endIndex;
    var averageDiff;
    var currentScroll;
    var newScroll;
    var headerMin;
    var headerDiff;
    var header;
    var viewportMin;
    var viewportMax;
    var axis = headerInfo.axis;
    var index = headerInfo.index;
    var level = headerInfo.level;
    var delta = 0;

    if (axis === 'row') {
      startIndex = this.m_startRowHeader;
      endIndex = this.m_endRowHeader;
      averageDiff = this.m_avgRowHeight;
      currentScroll = this.m_currentScrollTop;
      viewportMin = this._getViewportTop();
      viewportMax = this._getViewportBottom();
    } else if (axis === 'column') {
      startIndex = this.m_startColHeader;
      endIndex = this.m_endColHeader;
      averageDiff = this.m_avgColWidth;
      currentScroll = this.m_currentScrollLeft;
      viewportMin = this._getViewportLeft();
      viewportMax = this._getViewportRight();
    } else if (axis === 'rowEnd') {
      startIndex = this.m_startRowEndHeader;
      endIndex = this.m_endRowEndHeader;
      averageDiff = this.m_avgRowHeight;
      currentScroll = this.m_currentScrollTop;
      viewportMin = this._getViewportTop();
      viewportMax = this._getViewportBottom();
    } else if (axis === 'columnEnd') {
      startIndex = this.m_startColEndHeader;
      endIndex = this.m_endColEndHeader;
      averageDiff = this.m_avgColWidth;
      currentScroll = this.m_currentScrollLeft;
      viewportMin = this._getViewportLeft();
      viewportMax = this._getViewportRight();
    }

    var viewportDiff = viewportMax - viewportMin;

    // check if index is completely outside of rendered
    if (index < startIndex || index > endIndex) {
      if (index < startIndex) {
        newScroll = averageDiff * index;
      } else {
        newScroll = averageDiff * (index + 1) - viewportDiff;
      }
      delta = currentScroll - newScroll;

      // remember to focus on the row after fetch
      this.m_scrollHeaderAfterFetch = headerInfo;
    } else {
      if (axis === 'row' || axis === 'rowEnd') {
        header = this._getHeaderByIndex(index, axis, level);
        headerMin = this.getElementDir(header, 'top');
        headerDiff = this.getElementHeight(header);
      } else if (axis === 'column' || axis === 'columnEnd') {
        header = this._getHeaderByIndex(index, axis, level);
        headerMin = this.getElementDir(header, this.getResources().isRTLMode() ? 'right' : 'left');
        headerDiff = this.getElementWidth(header);
      }

      if (viewportDiff > headerDiff) {
        if (headerMin + headerDiff > viewportMax) {
          delta = viewportMax - (headerMin + headerDiff);
        } else if (headerMin < viewportMin) {
          delta = viewportMin - headerMin;
        }
      } else {
        delta = viewportMin - headerMin;
      }
    }
    if (header) {
      let frozenHeaderStyle = this.getMappedStyle('frozenHeader');
      if (header.classList.contains(frozenHeaderStyle)) {
        delta = 0;
      }
    }

    // scroll if either horiz or vert scroll pos has changed
    if (delta !== 0) {
      if (header != null && this.m_shouldFocus !== false) {
        // delay focus on cell until databody has scrolled (by the scroll event handler)
        this.m_cellToFocus = header;
      }
      if (axis === 'row' || axis === 'rowEnd') {
        this.scrollDelta(0, delta);
      } else {
        this.scrollDelta(delta, 0);
      }
    } else if (this.m_scrollHeaderAfterFetch != null) {
      // if there's an index we wanted to sctoll to after fetch it has now been scrolled to by scrollToIndex, so highlight it
      this._updateActive(headerInfo, true, true);
      this.m_scrollHeaderAfterFetch = null;
    }
  };

  /**
   * Locate the header element.  Look up recursively from its parent if neccessary.
   * @param {Element|undefined|null} elem the starting point to locate the header element
   * @param {string=} headerCellClassName the name of the header cell class name
   * @param {string=} endHeaderCellClassName the name of the header cell class name
   * @return {Element|null|undefined} the header element
   * @private
   */
  DvtDataGrid.prototype.findHeader = function (elem, headerCellClassName, endHeaderCellClassName) {
    if (headerCellClassName == null) {
      // eslint-disable-next-line no-param-reassign
      headerCellClassName = this.getMappedStyle('headercell');
    }

    if (endHeaderCellClassName == null) {
      // eslint-disable-next-line no-param-reassign
      endHeaderCellClassName = this.getMappedStyle('endheadercell');
    }

    if (headerCellClassName != null) {
      if (
        this.m_utils.containsCSSClassName(elem, headerCellClassName) ||
        this.m_utils.containsCSSClassName(elem, endHeaderCellClassName)
      ) {
        // found header element
        return elem;
      } else if (elem.parentNode) {
        // recursive call with parent node
        return this.findHeader(elem.parentNode, headerCellClassName, endHeaderCellClassName);
      } else if (elem === this.m_root) {
        // short circuit to terminal when root is reached
        return null;
      }
    }

    // all other case returns null
    return null;
  };

  /**
   * Ensures row banding is set on the proper rows
   * @private
   */
  DvtDataGrid.prototype.updateRowBanding = function () {
    var rowBandingInterval = this.m_options.getRowBandingInterval();
    if (rowBandingInterval > 0) {
      var cells = this.m_databody.firstChild.querySelectorAll('.' + this.getMappedStyle('cell'));
      var bandingClass = this.getMappedStyle('banded');
      for (var i = 0; i < cells.length; i++) {
        var cell = cells[i];
        var index = this._getIndex(cell, 'row');
        if (Math.floor(index / rowBandingInterval) % 2 === 1) {
          if (!this.m_utils.containsCSSClassName(cell, bandingClass)) {
            this.m_utils.addCSSClassName(cell, bandingClass);
          }
        } else if (this.m_utils.containsCSSClassName(cell, bandingClass)) {
          this.m_utils.removeCSSClassName(cell, bandingClass);
        }
      }
    }
  };

  /**
   * Ensures column banding is set on the proper rows
   * @private
   */
  DvtDataGrid.prototype.updateColumnBanding = function () {
    var columnBandingInterval = this.m_options.getColumnBandingInterval();
    if (columnBandingInterval > 0) {
      var cells = this.m_databody.firstChild.querySelectorAll('.' + this.getMappedStyle('cell'));
      var bandingClass = this.getMappedStyle('banded');
      for (var i = 0; i < cells.length; i += 1) {
        var cell = cells[i];
        var index = this._getIndex(cell, 'column');
        if (Math.floor(index / columnBandingInterval) % 2 === 1) {
          if (!this.m_utils.containsCSSClassName(cell, bandingClass)) {
            this.m_utils.addCSSClassName(cell, bandingClass);
          }
        } else if (this.m_utils.containsCSSClassName(cell, bandingClass)) {
          this.m_utils.removeCSSClassName(cell, bandingClass);
        }
      }
    }
  };

  /**
   * Remove banding (both row and column)
   * @private
   */
  DvtDataGrid.prototype._removeBanding = function () {
    var cells = this.m_databody.firstChild.querySelectorAll('.' + this.getMappedStyle('cell'));
    var bandingClass = this.getMappedStyle('banded');

    for (var i = 0; i < cells.length; i++) {
      if (this.m_utils.containsCSSClassName(cells[i], bandingClass)) {
        this.m_utils.removeCSSClassName(cells[i], bandingClass);
      }
    }
  };

  /**
   * Sets the accessibility status text
   * @param {string} key the message key
   * @param {Object|Array|null=} args to pass into the translator
   * @private
   */
  DvtDataGrid.prototype._setAccInfoText = function (key, args) {
    var text = this.getResources().getTranslatedText(key, args);
    if (text != null) {
      this.m_accInfo.textContent = text;
    }
  };

  /**
   * Handles expand event from the flattened datasource.
   * @param {Object} event the expand event
   * @param {boolean} fromQueue whether this is invoked from processing the model event queue, optional.
   * @private
   */
  DvtDataGrid.prototype.handleExpandEvent = function (event, fromQueue) {
    if (fromQueue === undefined && this.queueModelEvent(event)) {
      // tag the event for discovery later
      // eslint-disable-next-line no-param-reassign
      event.operation = 'expand';
      return;
    }

    // rowKey = event['rowKey'];
    // rowCells = this._getAxisCellsByKey(rowKey, 'row');
    // for (i = 0; i < rowCells.length; i++)
    // {
    //    rowCells[i].setAttribute("aria-expanded", true);
    // }

    // update screen reader alert
    this._setAccInfoText('accessibleRowExpanded');
    this.populateAccInfo();
    if (fromQueue) {
      this._runModelEventQueue();
    }
  };

  /**
   * Handles collapse event from the flattened datasource.
   * @param {Object} event the collapse event
   * @param {boolean} fromQueue whether this is invoked from processing the model event queue, optional.
   * @private
   */
  DvtDataGrid.prototype.handleCollapseEvent = function (event, fromQueue) {
    if (fromQueue === undefined && this.queueModelEvent(event)) {
      // tag the event for discovery later
      // eslint-disable-next-line no-param-reassign
      event.operation = 'collapse';
      return;
    }

    // rowKey = event['rowKey'];
    // rowCells = this._getAxisCellsByKey(rowKey, 'row');
    // for (i = 0; i < rowCells.length; i++)
    // {
    //    rowCells[i].setAttribute("aria-expanded", false);
    // }

    // update screen reader alert
    this._setAccInfoText('accessibleRowCollapsed');
    this.populateAccInfo();
    if (fromQueue) {
      this._runModelEventQueue();
    }
  };

  /**
   * Retrieve the key from an element.
   * @param {Element|Node|undefined} element the element to retrieve the key from.
   * @param {string=} axis
   * @return {string|null} the key of the element
   * @private
   */
  DvtDataGrid.prototype._getKey = function (element, axis) {
    // make sure the element has a context
    if (element != null && element[this.getResources().getMappedAttribute('context')]) {
      if (axis != null && this.m_utils.containsCSSClassName(element, this.getMappedStyle('cell'))) {
        return element[this.getResources().getMappedAttribute('context')].keys[axis];
      }
      return element[this.getResources().getMappedAttribute('context')].key;
    }
    return null;
  };

  /**
   * Retrieve the active axis key.
   * @param {string} axis
   * @param {boolean=} prev if we want the previous row key instead
   * @return {string|null} the key of the active row
   * @private
   */
  DvtDataGrid.prototype._getActiveKey = function (axis, prev) {
    if (prev && this.m_prevActive != null) {
      if (
        this.m_prevActive.type === 'header' &&
        (this.m_prevActive.axis === axis || this.m_prevActive.axis === axis + 'End')
      ) {
        return this.m_prevActive.key;
      } else if (this.m_prevActive.type === 'cell') {
        return this.m_prevActive.keys[axis];
      }
    } else if (this.m_active != null) {
      if (
        this.m_active.type === 'header' &&
        (this.m_active.axis === axis || this.m_active.axis === axis + 'End')
      ) {
        return this.m_active.key;
      } else if (this.m_active.type === 'cell') {
        return this.m_active.keys[axis];
      }
    }
    return null;
  };

  // /////////////////// move methods////////////////////////
  /**
   * Handles cut event from the flattened datasource.
   * @param {Event} event the cut event
   * @param {Element=} target the target element
   * @return {boolean} true if the event was processed here
   * @private
   */
  DvtDataGrid.prototype._handleCut = function (event, target) {
    if (target == null) {
      // eslint-disable-next-line no-param-reassign
      target = /** @type {Element} */ (event.target);
    }
    var cell = this.findCellOrHeader(target);

    if (this._isMoveOnElementEnabled(cell)) {
      if (this.m_cutCells != null) {
        for (var i = 0; i < this.m_cutCells.length; i++) {
          this.m_utils.removeCSSClassName(this.m_cutCells[i], this.getMappedStyle('cut'));
        }
      }

      var rowKey = this._getKey(cell, 'row');
      // cut row header with row
      this.m_cutCells = this._getAxisCellsByKey(rowKey, 'row');
      this.m_cutRowHeader = this._findHeaderByKey(
        rowKey,
        this.m_rowHeader,
        this.getMappedStyle('rowheadercell')
      );
      this.m_cutRowEndHeader = this._findHeaderByKey(
        rowKey,
        this.m_rowEndHeader,
        this.getMappedStyle('rowendheadercell')
      );

      this._highlightCellsAlongAxis(rowKey, 'row', 'key', 'add', ['cut']);
      if (this.m_cutRowHeader !== null) {
        this.m_utils.addCSSClassName(this.m_cutRowHeader, this.getMappedStyle('cut'));
      }
      if (this.m_cutRowEndHeader !== null) {
        this.m_utils.addCSSClassName(this.m_cutRowEndHeader, this.getMappedStyle('cut'));
      }

      return true;
    }
    return false;
  };

  /**
   * Handles cut cells event.
   * @param {Event} event the cut event
   * @param {Element=} target the target element
   * @return {boolean} true if the event was processed here
   * @private
   */
  DvtDataGrid.prototype._handleCutCells = function (event, target) {
    if (target == null) {
      // eslint-disable-next-line no-param-reassign
      target = /** @type {Element} */ (event.target);
    }

    const cell = this.findCell(event.target);
    const label = this.findLabel(event.target);
    const header = this.findHeader(event.target);
    if (this._isDataGridProvider()) {
      this.m_dataTransferAction = 'cut';
      let details = {
        event: event,
        ui: {
          action: this.m_dataTransferAction
        }
      };

      if (
        (cell || header) &&
        this.m_options.isCutEnabled() &&
        this._isSelectionEnabled() &&
        this.m_selection?.length &&
        !label
      ) {
        // if previously cut/copy without pasting, unhighlight that range.
        if (this.m_selectionRange && this.m_selectionRange.length) {
          this.unhighlightFloodFillRange(this.m_selectionRange[0]);
        }
        let selection = this.m_selection[this.m_selection.length - 1];
        this.m_selectionRange = [selection];

        details.ui.sourceRange = this.m_selectionRange[0];

        let cutRequestEvent = this.fireEvent('cutRequest', details);
        if (!cutRequestEvent) {
          return true;
        }
        this.highlightFloodFillRange(selection);
        if (this.m_options.isFloodFillEnabled()) {
          this._removeFloodFillAffordance();
        }
      } else if (label && this.m_options._isLabelCutEnabled()) {
        const context = this.getResources().getMappedAttribute('context');
        if (label) {
          const level = label[context].level;
          const axis = label[context].axis;
          details.ui.level = level;
          details.ui.axis = axis;

          let headers = [];
          headers.push(label);

          headers = this._getDropHeaderTargets(axis, level, headers);
          headers = this._getHeadersInView(headers, axis);
          this._headersDragged = headers;
          let classArray =
            axis === 'row' || axis === 'rowEnd' ? ['endFloodfill'] : ['bottomFloodfill'];
          this._highlightHeaderRange(headers, axis, level, classArray);
          this.fireEvent('headerLabelCutRequest', details);
        }
      }
    }
    return true;
  };

  /**
   * Handles copy cells event.
   * @param {Event} event the copy event
   * @param {Element=} target the target element
   * @return {boolean} true if the event was processed here
   * @private
   */
  DvtDataGrid.prototype._handleCopyCells = function (event, target) {
    if (target == null) {
      // eslint-disable-next-line no-param-reassign
      target = /** @type {Element} */ (event.target);
    }

    if (
      this._isDataGridProvider() &&
      this._isSelectionEnabled() &&
      this.m_options.isCopyEnabled() &&
      this.m_selection?.length
    ) {
      // if previously cut/copy without pasting, unhighlight that range.
      if (this.m_selectionRange && this.m_selectionRange.length) {
        this.unhighlightFloodFillRange(this.m_selectionRange[0]);
      }
      let selection = this.m_selection[this.m_selection.length - 1];
      this.m_selectionRange = [selection];
      this.m_dataTransferAction = 'copy';
      let details = {
        event: event,
        ui: {
          action: this.m_dataTransferAction,
          sourceRange: this.m_selectionRange[0]
        }
      };

      let copyRequestEvent = this.fireEvent('copyRequest', details);
      if (!copyRequestEvent) {
        return true;
      }
      this.highlightFloodFillRange(selection);
      if (this.m_options.isFloodFillEnabled()) {
        this._removeFloodFillAffordance();
      }
      return true;
    }
    return false;
  };

  /**
   * Handles paste event.
   * @param {Event} event the paste event
   * @param {Element=} target the target element
   *
   * @private
   */
  DvtDataGrid.prototype._handlePaste = function (event, target) {
    if (target == null) {
      // eslint-disable-next-line no-param-reassign
      target = /** @type {Element} */ (event.target);
    }
    if (this.m_cutCells != null) {
      for (var i = 0; i < this.m_cutCells.length; i++) {
        this.m_utils.removeCSSClassName(this.m_cutCells[i], this.getMappedStyle('cut'));
      }

      if (this.m_cutRowHeader !== null) {
        // remove css from row header too
        this.m_utils.removeCSSClassName(this.m_cutRowHeader, this.getMappedStyle('cut'));
        this.m_cutRowHeader = null;
      }
      if (this.m_cutRowEndHeader !== null) {
        // remove css from row header too
        this.m_utils.removeCSSClassName(this.m_cutRowEndHeader, this.getMappedStyle('cut'));
        this.m_cutRowEndHeader = null;
      }

      var pasteRowKey = this._getKey(this.findCellOrHeader(target), 'row');
      var cutRowKey = this._getKey(this.m_cutCells[0], 'row');
      if (cutRowKey !== pasteRowKey) {
        if (this._isSelectionEnabled()) {
          // unhighlight and clear selection
          this._clearSelection(event);
        }
        if (this._isDatabodyCellActive()) {
          this._unhighlightActive();
        }
        this.m_moveActive = true;
        this.getDataSource().move(cutRowKey, pasteRowKey);
      }
      this.m_cutCells = null;
    }
    return true;
  };

  /**
   * Handles paste cells event.
   * @param {Event} event the paste event
   * @param {Element=} target the target element
   *
   * @private
   */
  DvtDataGrid.prototype._handlePasteCells = function (event, target) {
    if (target == null) {
      // eslint-disable-next-line no-param-reassign
      target = /** @type {Element} */ (event.target);
    }
    if (this._isDataGridProvider() && this.m_options.isPasteEnabled()) {
      if (
        this.m_selectionRange &&
        this._isSelectionEnabled() &&
        !this.m_discontiguousSelection &&
        this.m_selection.length === 1
      ) {
        let details = {
          event: event,
          ui: {
            action: this.m_dataTransferAction,
            sourceRange: this.m_selectionRange[0],
            targetRange: this.m_selection[0]
          }
        };

        let pasteRequestEvent = this.fireEvent('pasteRequest', details);
        if (!pasteRequestEvent) {
          return true;
        }
        this.unhighlightFloodFillRange(this.m_selectionRange[0]);
        this.m_selectionRange = null;
        this.m_dataTransferAction = null;
      } else if (!this.m_selectionRange) {
        let details = {
          event: event,
          ui: {
            action: 'unknown',
            sourceRange: {},
            targetRange: this.m_selection[0]
          }
        };
        let pasteRequestEvent = this.fireEvent('pasteRequest', details);
        if (!pasteRequestEvent) {
          return true;
        }
        this.m_selectionRange = null;
        this.m_dataTransferAction = null;
      }
    }
    return true;
  };

  /**
   * triggers autofill event.
   * @param {Event} event the fill event
   * @param {Element=} target the target element
   *
   * @private
   */
  DvtDataGrid.prototype._handleAutofill = function (event, target) {
    if (target == null) {
      // eslint-disable-next-line no-param-reassign
      target = /** @type {Element} */ (event.target);
    }

    if (
      this._isDataGridProvider() &&
      this._isSelectionEnabled() &&
      !this.m_discontiguousSelection &&
      this.m_options.isFloodFillEnabled() &&
      this.m_selection.length === 1
    ) {
      let fillDirection = 'down';
      if (event.type === 'keydown') {
        fillDirection = event.keyCode === this.keyCodes.D_KEY ? 'down' : 'end';
      }
      let selectionStart = this.m_selection[0].startIndex;
      let selectionEnd = this.m_selection[0].endIndex;
      let sourceRange = this.createRange(selectionStart, selectionEnd);
      let targetRange = this.createRange(selectionStart, selectionEnd);
      let validKeyDown = false;
      if (fillDirection === 'down') {
        sourceRange.endIndex.row = sourceRange.startIndex.row;
        targetRange.startIndex.row = sourceRange.startIndex.row + 1;
        if (
          targetRange.startIndex.row >= sourceRange.startIndex.row &&
          targetRange.startIndex.row <= targetRange.endIndex.row
        ) {
          validKeyDown = true;
        }
      } else {
        sourceRange.endIndex.column = sourceRange.startIndex.column;
        targetRange.startIndex.column = sourceRange.startIndex.column + 1;
        if (
          targetRange.startIndex.column >= sourceRange.startIndex.column &&
          targetRange.startIndex.column <= targetRange.endIndex.column
        ) {
          validKeyDown = true;
        }
      }

      if (validKeyDown) {
        var details = {
          event: event,
          ui: {
            action: fillDirection,
            sourceRange: sourceRange,
            targetRange: targetRange
          }
        };

        let fillRequestEvent = this.fireEvent('fillRequest', details);
        if (!fillRequestEvent) {
          return true;
        }
      }
      this.unhighlightFloodFillRange(this.m_selection[0]);
      this._removeFloodFillAffordance();
      this.m_selectionRange = null;
      this.m_dataTransferAction = null;
      this.m_floodFillDirection = null;
      return true;
    }
    return false;
  };

  /**
   * Handles canceling a reorder
   * @param {Object} event the cut event
   * @param {Element=} target the target element
   *
   * @private
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype._handleCancelReorder = function (event, target) {
    if (this.m_cutCells != null) {
      for (var i = 0; i < this.m_cutCells.length; i++) {
        this.m_utils.removeCSSClassName(this.m_cutCells[i], this.getMappedStyle('cut'));
      }
      this.m_cutCells = null;

      if (this.m_cutRowHeader !== null) {
        this.m_utils.removeCSSClassName(this.m_cutRowHeader, this.getMappedStyle('cut'));
        this.m_cutRowHeader = null;
      }
      if (this.m_cutRowEndHeader !== null) {
        this.m_utils.removeCSSClassName(this.m_cutRowEndHeader, this.getMappedStyle('cut'));
        this.m_cutRowEndHeader = null;
      }
      return true;
    } else if (this.m_dataTransferAction !== null) {
      if (this.m_selectionRange && this.m_selectionRange.length) {
        this.unhighlightFloodFillRange(this.m_selectionRange[0]);
        this.m_selectionRange = null;
      } else {
        this.unhighlightDraggedHeaders();
        this._headersDragged = [];
      }
      this.m_dataTransferAction = null;
    }
    return undefined;
  };

  DvtDataGrid.prototype.unhighlightDraggedHeaders = function () {
    let classArray = ['bottomFloodfill', 'startFloodfill', 'topFloodfill', 'endFloodfill'];
    this._unhighlightElementsByClassName(this._headersDragged, classArray);
    const context = this.getResources().getMappedAttribute('context');
    let labelContext = this._headersDragged[0][context];
    if (labelContext.level !== 0) {
      let prevLevelLabel = this.m_headerLabels[labelContext.axis][labelContext.level - 1];
      let headers = [];
      headers.push(prevLevelLabel);
      headers = this._getDropHeaderTargets(labelContext.axis, labelContext.level - 1, headers);
      if (labelContext.axis === 'column' || labelContext.axis === 'columnEnd') {
        this._unhighlightElementsByClassName(headers, ['bottomFloodfill']);
      } else {
        this._unhighlightElementsByClassName(headers, ['endFloodfill']);
      }
    }
  };

  /**
   * Handles cut event from the flattened datasource.
   * @param {Object} event the cut event
   * @private
   */
  DvtDataGrid.prototype._handleMove = function (event) {
    // initialize the move
    if (this.m_moveCells == null) {
      var target = /** @type {Element} */ (event.target);
      var cell = this.findCellOrHeader(target);

      // get the move row key to set the move row/rowHeader
      var rowKey = this._getKey(cell, 'row');
      this.m_originalMoveIndex = this._getIndex(cell, 'row');
      this.m_moveIndex = /** @type {number} */ (this.m_originalMoveIndex);

      this.m_moveCells = this._getAxisCellsByIndex(this.m_moveIndex, 'row');
      this.m_moveRowHeader = this._findHeaderByKey(
        rowKey,
        this.m_rowHeader,
        this.getMappedStyle('rowheadercell')
      );
      this.m_moveRowEndHeader = this._findHeaderByKey(
        rowKey,
        this.m_rowEndHeader,
        this.getMappedStyle('rowendheadercell')
      );

      // add the move style class to the css
      this._highlightCellsAlongAxis(this.m_moveIndex, 'row', 'index', 'add', ['drag']);

      this.m_originalTop = this.getElementDir(this.m_moveCells[0], 'top');

      this.m_dropTarget = document.createElement('div');
      this.m_utils.addCSSClassName(this.m_dropTarget, this.getMappedStyle('drop'));
      this.setElementHeight(this.m_dropTarget, this.calculateRowHeight(this.m_moveCells[0]));
      this.setElementDir(this.m_dropTarget, this.m_originalTop, 'top');
      this.m_databody.firstChild.appendChild(this.m_dropTarget); // @HTMLUpdateOK

      this._addHeaderDropTarget(this.m_moveRowHeader, this.m_rowHeader, false);
      this._addHeaderDropTarget(this.m_moveRowEndHeader, this.m_rowEndHeader, true);
    }

    // calculate the change in Y direction
    if (!this.m_utils.isTouchDevice()) {
      this.m_prevY = this.m_currentY;
      this.m_currentY = event.pageY;
    }
    var deltaY = this.m_currentY - this.m_prevY;
    var height = this.calculateRowHeight(this.m_moveCells[0]);

    // adjust the top height of the moveRow and moveRowHeader
    for (var i = 0; i < this.m_moveCells.length; i++) {
      this.setElementDir(
        this.m_moveCells[i],
        this.getElementDir(this.m_moveCells[i], 'top') + deltaY,
        'top'
      );
    }
    if (this.m_moveRowHeader !== null) {
      this.setElementDir(
        this.m_moveRowHeader,
        this.getElementDir(this.m_moveRowHeader, 'top') + deltaY,
        'top'
      );
    }
    if (this.m_moveRowEndHeader !== null) {
      this.setElementDir(
        this.m_moveRowEndHeader,
        this.getElementDir(this.m_moveRowEndHeader, 'top') + deltaY,
        'top'
      );
    }

    var nextSiblingIndex = this.m_moveIndex + 1;
    var previousSiblingIndex = this.m_moveIndex - 1;
    var nextSibling = this._getCellByIndex(this.createIndex(nextSiblingIndex, this.m_startCol));
    var previousSibling = this._getCellByIndex(
      this.createIndex(previousSiblingIndex, this.m_startCol)
    );

    // see if the element has crossed the halfway point of the next row
    if (
      nextSibling != null &&
      this.getElementDir(nextSibling, 'top') <
        this.getElementDir(this.m_moveCells[0], 'top') + height / 2
    ) {
      this._moveDropRows('nextSibling', nextSiblingIndex);
    } else if (
      previousSibling != null &&
      this.getElementDir(previousSibling, 'top') >
        this.getElementDir(this.m_moveCells[0], 'top') - height / 2
    ) {
      this._moveDropRows('previousSibling', previousSiblingIndex);
    }
  };

  /**
   * Add drop header target
   * @param {Element|null|undefined} moveHeader
   * @param {boolean} isEnd
   * @private
   */
  DvtDataGrid.prototype._addHeaderDropTarget = function (moveHeader, root, isEnd) {
    var dropTarget;
    if (moveHeader !== null) {
      // need to store the height inline if not already because top values will be changing
      if (moveHeader.style.height == null) {
        this.setElementHeight(moveHeader, this.calculateRowHeight(moveHeader));
      }
      this.m_utils.addCSSClassName(moveHeader, this.getMappedStyle('drag'));
      dropTarget = document.createElement('div');
      this.m_utils.addCSSClassName(dropTarget, this.getMappedStyle('drop'));
      this.setElementHeight(dropTarget, this.calculateRowHeight(moveHeader));
      this.setElementDir(dropTarget, this.m_originalTop, 'top');
      root.firstChild.appendChild(dropTarget); // @HTMLUpdateOK

      if (isEnd) {
        this.m_dropTargetEndHeader = dropTarget;
      } else {
        this.m_dropTargetHeader = dropTarget;
      }
    }
  };

  /**
   * Determined if move is supported for the specified axis.
   * @param {string} sibling nextSibling/previosusSibling
   * @private
   */
  DvtDataGrid.prototype._moveDropRows = function (sibling, index) {
    var newTop;
    var newSiblingTop;
    var headerScroller;
    var endHeaderScroller;
    var siblingCells;

    // move the drop target and the adjacent row
    if (sibling === 'nextSibling') {
      siblingCells = this._getAxisCellsByIndex(index, 'row');
      newTop = this.m_originalTop + this.calculateRowHeight(siblingCells[0]);
      newSiblingTop = this.m_originalTop;
    } else {
      siblingCells = this._getAxisCellsByIndex(index, 'row');
      newTop = this.getElementDir(siblingCells[0], 'top');
      newSiblingTop = newTop + this.calculateRowHeight(siblingCells[0]);
    }

    this.setElementDir(this.m_dropTarget, newTop, 'top');

    for (var i = 0; i < siblingCells.length; i++) {
      this.setElementDir(siblingCells[i], newSiblingTop, 'top');
    }

    if (this.m_moveRowHeader !== null) {
      headerScroller = this.m_moveRowHeader.parentNode;
      this.setElementDir(this.m_dropTargetHeader, newTop, 'top');
      this.setElementDir(this.m_moveRowHeader[sibling], newSiblingTop, 'top');
    }
    if (this.m_moveRowEndHeader !== null) {
      endHeaderScroller = this.m_moveRowEndHeader.parentNode;
      this.setElementDir(this.m_dropTargetEndHeader, newTop, 'top');
      this.setElementDir(this.m_moveRowEndHeader[sibling], newSiblingTop, 'top');
    }

    // store the new top value
    this.m_originalTop = newTop;

    this._highlightCellsAlongAxis(this.m_moveIndex + 1, 'row', 'index', 'remove', ['activedrop']);

    // move the moveRow and rowHeader so we can continue to pull the adjacent header
    if (sibling === 'nextSibling') {
      this._modifyAxisCellContextIndex('row', this.m_moveIndex, 1, 1);
      this._modifyAxisCellContextIndex('row', this.m_moveIndex + 1, 1, -1);
      this.m_moveIndex += 1;

      if (this.m_moveRowHeader !== null && headerScroller) {
        // prettier-ignore
        headerScroller.insertBefore( // @HTMLUpdateOK
          this.m_moveRowHeader,
          this.m_moveRowHeader[sibling][sibling]
        );
      }
      if (this.m_moveRowEndHeader !== null && endHeaderScroller) {
        // prettier-ignore
        endHeaderScroller.insertBefore( // @HTMLUpdateOK
          this.m_moveRowEndHeader,
          this.m_moveRowEndHeader[sibling][sibling]
        );
      }
    } else {
      this._modifyAxisCellContextIndex('row', this.m_moveIndex, 1, -1);
      this._modifyAxisCellContextIndex('row', this.m_moveIndex - 1, 1, 1);
      this.m_moveIndex -= 1;

      if (this.m_moveRowHeader !== null && headerScroller) {
        // prettier-ignore
        headerScroller.insertBefore( // @HTMLUpdateOK
          this.m_moveRowHeader,
          this.m_moveRowHeader[sibling]
        );
      }
      if (this.m_moveRowEndHeader !== null && endHeaderScroller) {
        // prettier-ignore
        endHeaderScroller.insertBefore( // @HTMLUpdateOK
          this.m_moveRowEndHeader,
          this.m_moveRowEndHeader[sibling]
        );
      }
    }

    this._refreshDatabodyMap();

    this._highlightCellsAlongAxis(this.m_moveIndex + 1, 'row', 'index', 'add', ['activedrop']);
  };

  /**
   * Determined if move is supported for the specified axis.
   * @param {string} axis the axis which we check whether move is supported.
   * @private
   */
  DvtDataGrid.prototype._isMoveEnabled = function (axis) {
    var capability = this.getDataSource().getCapability('move');
    var moveable = this.m_options.isMoveable('row');
    if (moveable === 'enable' && (capability === 'full' || capability === axis)) {
      return true;
    }

    return false;
  };

  /**
   * Handles a mouse up after move
   * @param {Event} event MouseUp Event
   * @param {boolean} validUp true if in the databody or rowHeader
   * @private
   */
  DvtDataGrid.prototype._handleMoveMouseUp = function (event, validUp) {
    if (this.m_moveCells != null) {
      // remove the the drop target div from the databody/rowHeader
      this._remove(this.m_dropTarget);
      if (this.m_moveRowHeader !== null) {
        this._remove(this.m_dropTargetHeader);
      }
      if (this.m_moveRowEndHeader !== null) {
        this._remove(this.m_dropTargetEndHeader);
      }
      if (this.m_active != null && this.m_active.axis !== 'column') {
        this.m_moveActive = true;
      }

      // clear selection
      if (this._isSelectionEnabled()) {
        // unhighlight and clear selection
        this._clearSelection(event);
      }

      var moveCell = this.m_moveCells[0];
      var moveCellKey = this._getKey(moveCell, 'row');

      // if the mousup was in the rowHeader or databody
      if (validUp === true) {
        var insertIndex = this.m_moveIndex + 1;
        var insertKey = this._getKey(
          this._getCellByIndex(this.createIndex(insertIndex, this.m_startCol)),
          'row'
        );
        this.getDataSource().move(moveCellKey, insertKey);
      } else {
        this.getDataSource().move(moveCellKey, moveCellKey);
      }
      this.m_moveCells = null;
      this.m_originalMoveIndex = null;
      this.m_moveIndex = null;
    }
    this.m_databodyMove = false;
  };

  DvtDataGrid.prototype._handleFloodFillMouseUp = function (event) {
    if (this.m_floodFillRange && this.m_floodFillRange.length) {
      var details = {
        event: event,
        ui: {
          action: this.m_floodFillDirection,
          sourceRange: this.m_selectionRange[0],
          targetRange: this.m_floodFillRange[0]
        }
      };

      let fillRequestEvent = this.fireEvent('fillRequest', details);
      if (!fillRequestEvent) {
        return true;
      }
      this.unhighlightFloodFillRange();
    }
    this.m_selectionRange = null;
    this.m_floodFillRange = null;
    this.m_floodFillDirection = null;
    const sections = [
      this.m_databody,
      this.m_databodyFrozenCol,
      this.m_databodyFrozenRow,
      this.m_databodyFrozenCorner
    ];
    for (let i = 0; i < sections.length; i++) {
      if (sections[i]) {
        sections[i].style.cursor = 'default';
      }
    }
    this.m_cursor = 'default';
    return true;
  };

  /**
   * Check if a row can be moved, meaning it is the active row and move is enabled
   * @param {Element|null|undefined} cell the row to move
   * @returns {boolean} true if the row can be moved
   */
  DvtDataGrid.prototype._isMoveOnElementEnabled = function (cell) {
    if (cell != null && this._isMoveEnabled('row')) {
      if (this._getActiveKey('row') === this._getKey(cell, 'row')) {
        return true;
      }
    }
    return false;
  };

  /**
   * Applies the draggable class to the new active row and row header, removes it if the active has changed
   */
  DvtDataGrid.prototype._manageMoveCursor = function () {
    if (!this._isDataGridProvider()) {
      var activeKey = this._getActiveKey('row');
      var prevActiveKey = this._getActiveKey('row', true);

      var className = this.getMappedStyle('draggable');
      var rowHeaderStyle = this.getMappedStyle('rowheadercell');
      var rowEndHeaderStyle = this.getMappedStyle('rowendheadercell');

      if (prevActiveKey != null) {
        this._highlightCellsAlongAxis(prevActiveKey, 'row', 'key', 'remove', ['draggable']);

        var prevActiveRowHeader = this._findHeaderByKey(
          prevActiveKey,
          this.m_rowHeader,
          rowHeaderStyle
        );
        if (this.m_utils.containsCSSClassName(prevActiveRowHeader, className)) {
          this.m_utils.removeCSSClassName(prevActiveRowHeader, className);
        }

        prevActiveRowHeader = this._findHeaderByKey(
          prevActiveKey,
          this.m_rowEndHeader,
          rowEndHeaderStyle
        );
        if (this.m_utils.containsCSSClassName(prevActiveRowHeader, className)) {
          this.m_utils.removeCSSClassName(prevActiveRowHeader, className);
        }
      }

      if (activeKey != null) {
        var activeCells = this._getAxisCellsByKey(activeKey, 'row');
        // if move enabled and draggable class name
        if (this._isMoveOnElementEnabled(activeCells[0])) {
          this._highlightCellsAlongAxis(activeKey, 'row', 'key', 'add', ['draggable']);

          var activeRowHeader = this._findHeaderByKey(activeKey, this.m_rowHeader, rowHeaderStyle);
          this.m_utils.addCSSClassName(activeRowHeader, className);

          var activeRowEndHeader = this._findHeaderByKey(
            activeKey,
            this.m_rowEndHeader,
            rowEndHeaderStyle
          );
          this.m_utils.addCSSClassName(activeRowEndHeader, className);
        }
      }
    }
  };

  /**
   * Handles focus on the root and its children by setting focus class on the root
   * @param {Event} event
   */
  DvtDataGrid.prototype.handleRootFocus = function (event, isPopupFocusin) {
    this.m_utils.addCSSClassName(this.m_root, this.getMappedStyle('focus'));
    this._clearFocusoutTimeout();
    this._clearFocusoutBusyState();
    // if nothing is active, and came from the outside of the datagrid, activate first cell
    const target = event.target;
    if (!isPopupFocusin) {
      this._clearOpenPopupListeners();
      if (
        !this.m_root.contains(document.activeElement) ||
        (document.activeElement === this.m_root && this.m_root.tabIndex === 0) ||
        (document.activeElement === this.m_databody &&
          this.m_scrollbarFocus &&
          this.m_root.tabIndex === 0)
      ) {
        this._exitActionableMode();
        this.m_externalFocus = true;

        if (this._isCellEditable()) {
          this._setAccInfoText('accessibleEditableMode');
        } else if (this._isGridEditable()) {
          this._setAccInfoText('accessibleNavigationMode');
        }

        var shouldNotScroll = false;
        if (this.m_scrollbarFocus === true) {
          this.m_shouldFocus = false;
          this.m_scrollbarFocus = false;
          shouldNotScroll = true;
        }
        // if databody is empty
        let emptyElement = this._getEmptyElement();
        if (this.m_active == null && emptyElement) {
          // no data slot
          this._setActive(emptyElement, { type: 'empty' }, event, null, null, shouldNotScroll, true);
        } else if (this.m_active == null && !this._databodyEmpty()) {
          var newCellIndex;
          let firstVisibleColumn = this.getVisibleCellIndexInDirection('column', 0, { right: true });
          let firstVisibleRow = this.getVisibleCellIndexInDirection('row', 0, { down: true });
          newCellIndex = this.createIndex(firstVisibleRow, firstVisibleColumn);

          if (!shouldNotScroll) {
            // make sure it's visible
            this.scrollToIndex(newCellIndex);
          }

          // focus a cell, do not select it unless user actively selects something
          this._setActiveByIndex(newCellIndex, event, null, null, shouldNotScroll);
        } else if (this.m_active != null) {
          this._highlightActive();
        }
      } else if (
        !this.m_utils.containsCSSClassName(target, this.getMappedStyle('cell')) &&
        !this.m_utils.containsCSSClassName(target, this.getMappedStyle('headercell')) &&
        !this.m_utils.containsCSSClassName(target, this.getMappedStyle('headerlabel')) &&
        !this.m_utils.containsCSSClassName(target, this.getMappedStyle('endheadercell')) &&
        !this.m_utils.containsCSSClassName(target, this.getMappedStyle('noDataContainer')) &&
        !this._isEditOrEnter()
      ) {
        if (!this._enteringActionableMode) {
          let element = this._getOwnedContentFromTarget(target);
          if (element) {
            this.m_shouldFocus = false;
            const active = this._createActiveObject(element);
            this._setActive(element, active, event, null, null, null, true);
            DataCollectionUtils.enableAllFocusableElements(element);
            this._enterActionableMode(element, null, false);
          }
        }
      } else {
        this._exitActionableMode();
      }
      this.m_root.tabIndex = -1;
    }
  };

  DvtDataGrid.prototype._getOwnedContentFromTarget = function (target) {
    let element = this.findCellOrHeader(target);
    if (element === null) {
      element = this.findLabel(target);
    }
    if (element === null) {
      element = this.find(target, 'noDataContainer');
    }
    return element;
  };

  DvtDataGrid.prototype._handlePopupFocusout = function (event) {
    this.handleRootBlur(event, true);
  };

  DvtDataGrid.prototype._handlePopupFocusin = function (event) {
    this.handleRootFocus(event, true);
  };

  /**
   * Handles blur on the root and its children by removing focus class on the root
   * @param {Event} event
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype.handleRootBlur = function (event, isPopupFocusout) {
    // There is no cross-browser way to tell if the whole grid is out of focus on blur today.
    // document.activeElement returns null in chrome and firefox on blur events.
    // relatedTarget doesn't return a value in firefox and IE though there a tickets to fix.
    // We could implement a non-timeout solution that exiting and re-entering
    // the grid via tab key would not read the summary text upon re-entry (initial would work)
    this._clearFocusoutTimeout();
    if (!isPopupFocusout) {
      // Components that open popups (such as ojSelect, ojCombobox, ojInputDate, etc.) will trigger
      // focusout, but we don't want to change mode in those cases since the user is still editing.
      this._clearOpenPopupListeners();
      var openPopup = ojkeyboardfocusUtils.getLogicalChildPopup(this.m_root);
      if (openPopup != null) {
        // setup focus listeners on popup
        this._openPopup = openPopup;
        // eslint-disable-next-line no-param-reassign
        isPopupFocusout = false;
        this._handlePopupFocusinListener = this._handlePopupFocusin.bind(this);
        this._handlePopupFocusoutListener = this._handlePopupFocusout.bind(this);
        openPopup.addEventListener('focusin', this._handlePopupFocusinListener);
        openPopup.addEventListener('focusout', this._handlePopupFocusoutListener);
        return;
      }
    }
    this._setFocusoutBusyState();
    // prettier-ignore
    this.m_focusoutTimeout = setTimeout( // @HTMLUpdateOK
      function () {
        if (!this.m_root.contains(document.activeElement) || isPopupFocusout === true) {
          this.m_root.tabIndex = 0;
          var active = this._getActiveElement();
          if (active != null) {
            this._unsetAriaProperties(active);
            if (this._isEditOrEnter() && !this.m_animating) {
              this._leaveEditing(event, active, false, false);
            }
            this._exitActionableMode();
          }
        }
        this._clearFocusoutBusyState();
      }.bind(this),
      100
    );

    // don't change the color on move
    if (this.m_moveRow == null) {
      this.m_utils.removeCSSClassName(this.m_root, this.getMappedStyle('focus'));
    }
  };

  DvtDataGrid.prototype._clearOpenPopupListeners = function () {
    if (this._openPopup != null) {
      this._openPopup.removeEventListener('focusin', this._handlePopupFocusinListener);
      this._openPopup.removeEventListener('focusout', this._handlePopupFocusoutListener);
      this._openPopup = null;
    }
    this._handlePopupFocusinListener = null;
    this._handlePopupFocusoutListener = null;
  };

  /**
   * @private
   */
  DvtDataGrid.prototype._handlePopupFocusout = function (event) {
    this.handleRootBlur(event, true);
  };

  /**
   * @private
   */
  DvtDataGrid.prototype._handlePopupFocusin = function (event) {
    this.handleRootFocus(event, true);
  };

  DvtDataGrid.prototype._clearFocusoutTimeout = function () {
    if (this.m_focusoutTimeout) {
      clearTimeout(this.m_focusoutTimeout);
      this.m_focusoutTimeout = null;
    }
  };

  DvtDataGrid.prototype._setFocusoutBusyState = function () {
    if (!this.m_focusoutResolveFunc) {
      var msg = 'is handling focusout.';
      var busyContext = Context.getContext(this.m_root).getBusyContext();
      var options = {
        description: "Datagrid component '" + msg
      };
      this.m_focusoutResolveFunc = busyContext.addBusyState(options);
    }
  };

  DvtDataGrid.prototype._clearFocusoutBusyState = function () {
    if (this.m_focusoutResolveFunc) {
      this.m_focusoutResolveFunc();
      this.m_focusoutResolveFunc = null;
    }
  };

  /**
   * Calculate the a row's height using top or endRowPixel
   * @param {Element|undefined|null} row the row to calculate height on
   * @return {number} the row height
   */
  DvtDataGrid.prototype.calculateRowHeight = function (row) {
    if (row.style.height !== '') {
      return this.getElementHeight(row);
    }
    if (row.nextSibling != null) {
      return this.getElementDir(row.nextSibling, 'top') - this.getElementDir(row, 'top');
    }
    return this.m_endRowPixel - this.getElementDir(row, 'top');
  };

  /**
   * @return {boolean} true if the databody is empty
   */
  DvtDataGrid.prototype._databodyEmpty = function () {
    if (
      (this.m_databody.firstChild == null || this.m_databody.firstChild.firstChild == null) &&
      !this._hasFrozenColumns() &&
      !this._hasFrozenRows()
    ) {
      return true;
    }
    return false;
  };

  DvtDataGrid.prototype._databodyEmptyState = function () {
    if (
      this.m_databody.firstChild == null ||
      this.m_databody.firstChild.firstChild == null ||
      this._getEmptyElement()
    ) {
      return true;
    }
    return false;
  };

  DvtDataGrid.prototype._getEmptyElement = function () {
    // returning empty tag
    let noDataSlot = this.m_databody.querySelector('.' + this.getMappedStyle('noDataContainer'));
    let defaultEmptyText = this.m_databody.querySelector('.' + this.getMappedStyle('emptytext'));
    var emptyTag = noDataSlot || defaultEmptyText;
    return emptyTag;
  };

  /**
   * Add set of required animation rules to the element
   * @param {Element} target the element to which animation rules will be added
   * @param {number|string} duration the duration of animation
   * @param {number|string} delay the delay of animation
   * @param {string} timing the easing function
   * @param {number|string} x the final position (in pixels) of the current animation
   * @param {number|string} y the final position (in pixels) of the current animation
   * @param {number|string} z the final position (in pixels) of the current animation
   * @private
   */
  DvtDataGrid.prototype.addTransformMoveStyle = function (target, duration, delay, timing, x, y, z) {
    // eslint-disable-next-line no-param-reassign
    target.style.transitionDelay = delay;
    // eslint-disable-next-line no-param-reassign
    target.style.transitionTimingFunction = timing;
    // eslint-disable-next-line no-param-reassign
    target.style.transitionDuration = duration;
    // eslint-disable-next-line no-param-reassign
    target.style.transform = 'translate3d(' + x + 'px,' + y + 'px,' + z + 'px)';
  };

  /**
   * Add set of required animation rules to the element
   * @param {Element} target the element to which animation rules will be added
   * @private
   */
  DvtDataGrid.prototype.removeTransformMoveStyle = function (target) {
    // eslint-disable-next-line no-param-reassign
    target.style.transitionDelay = '';
    // eslint-disable-next-line no-param-reassign
    target.style.transitionTimingFunction = '';
    // eslint-disable-next-line no-param-reassign
    target.style.transitionDuration = '';
    // eslint-disable-next-line no-param-reassign
    target.style.transform = '';
  };

  /**
   * Clears the databody map and repopulates it based on what's in the databody
   * @private
   */
  DvtDataGrid.prototype._refreshDatabodyMap = function () {
    this._clearDatabodyMap();
    this._addNodesToDatabodyMap(this.m_databody.firstChild.childNodes);
    if (this.m_databodyFrozenCol) {
      this._addNodesToDatabodyMap(this.m_databodyFrozenCol.firstChild.childNodes);
    }
    if (this.m_databodyFrozenCorner) {
      this._addNodesToDatabodyMap(this.m_databodyFrozenCorner.firstChild.childNodes);
    }
    if (this.m_databodyFrozenRow) {
      this._addNodesToDatabodyMap(this.m_databodyFrozenRow.firstChild.childNodes);
    }
  };

  /**
   * Adds a fragment to the databody content and fills the data body mapKey
   * @param {Element} databodyContent
   * @param {Element|DocumentFragment} fragment
   * @private
   */
  DvtDataGrid.prototype._populateDatabody = function (databodyContent, fragment) {
    this._addNodesToDatabodyMap(fragment.childNodes);
    databodyContent.appendChild(fragment); // @HTMLUpdateOK
    this.m_subtreeAttachedCallback(databodyContent);
  };

  /**
   * Empties the databody and clears the databody map
   * @param {Element} databodyContent
   * @private
   */
  DvtDataGrid.prototype._emptyDatabody = function (databodyContent) {
    this._clearDatabodyMap();
    this.m_utils.empty(databodyContent);
  };

  /**
   * Adds an array of nodes to the databody map
   * @param {NodeList|Array} nodes
   * @private
   */
  DvtDataGrid.prototype._addNodesToDatabodyMap = function (nodes) {
    for (var i = 0; i < nodes.length; i++) {
      var node = nodes[i];
      if (this.m_utils.containsCSSClassName(node, this.getMappedStyle('cell'))) {
        var indexes = this.getCellIndexes(node);
        var extents = this.getCellExtents(node);
        var id = node.id;
        this._addToDatabodyMap(indexes, id, extents);
      }
    }
  };

  /**
   * Adds an index, id pair to the databody map along with its extents
   * @param {Object} indexes
   * @param {string} id
   * @param {Object} extents
   * @private
   */
  DvtDataGrid.prototype._addToDatabodyMap = function (indexes, id, extents) {
    var rowExtent = extents.row;
    var columnExtent = extents.column;

    for (var i = 0; i < rowExtent; i++) {
      for (var j = 0; j < columnExtent; j++) {
        this._addIndexToDatabodyMap(this.createIndex(indexes.row + i, indexes.column + j), id);
      }
    }
  };

  /**
   * Adds an index, id pair to the databody map
   * @param {Object} indexes
   * @param {string} id
   * @private
   */
  DvtDataGrid.prototype._addIndexToDatabodyMap = function (indexes, id) {
    var mapKey = 'r' + indexes.row + 'c' + indexes.column;
    this.m_databodyMap.set(mapKey, id); // quoted to make the closure compiler happy
  };

  /**
   * Removes an index, id pair from the databody map
   * @param {Object} indexes
   * @returns {boolean}
   * @private
   */
  DvtDataGrid.prototype._removeIndexFromDatabodyMap = function (indexes) {
    var mapKey = 'r' + indexes.row + 'c' + indexes.column;
    return this.m_databodyMap.delete(mapKey); // quoted to make the closure compiler happy
  };

  /**
   * Gets an id from the databody based on the index
   * @param {Object} indexes
   * @return the id at the index
   * @private
   */
  DvtDataGrid.prototype._getFromDatabodyMap = function (indexes) {
    var mapKey = 'r' + indexes.row + 'c' + indexes.column;
    return this.m_databodyMap.get(mapKey); // quoted to make the closure compiler happy
  };

  /**
   * Clears the databody map
   * @returns {boolean} the map
   * @private
   */
  DvtDataGrid.prototype._clearDatabodyMap = function () {
    return this.m_databodyMap.clear(); // quoted to make the closure compiler happy
  };

  /**
   * Update the cellContext.indexes of a range of cells
   * @param {string} axis row/column
   * @param {number} atIndex startIndex along the axis
   * @param {number} count number of cells after the start to modify
   * @param {number} value value to increment/decremnt the index value by
   * @private
   */
  DvtDataGrid.prototype._modifyAxisCellContextIndex = function (axis, atIndex, count, value) {
    for (var i = atIndex; i < atIndex + count; i++) {
      var axisCells = this._getAxisCellsByIndex(i, axis);
      for (var j = 0; j < axisCells.length; j++) {
        var cell = axisCells[j];
        var cellContext = cell[this.getResources().getMappedAttribute('context')];
        cellContext.indexes[axis] += value;
      }
    }
  };

  DvtDataGrid.prototype._modifyAxisHeaderContextIndex = function (axis, atIndex, count, value) {
    for (var i = atIndex; i < atIndex + count; i++) {
      var headers;
      if (axis === 'row') {
        headers = this._getHeadersByIndex(i, 'row');
      } else {
        headers = this._getHeadersByIndex(i, 'rowEnd');
      }
      for (var j = 0; j < headers.length; j++) {
        var header = headers[j];
        var headerContext = header[this.getResources().getMappedAttribute('context')];
        headerContext.index += value;
      }
    }
  };

  /**
   * Get a cell or header by index along a given axis, will return first cell on that axis
   * @private
   */
  DvtDataGrid.prototype._getCellOrHeaderByIndex = function (index, axis) {
    var element = null;
    var cells = this._getAxisCellsByIndex(index, axis, true);
    if (cells != null && cells.length > 0) {
      element = cells[0];
    }
    if (element == null) {
      if (axis === 'row') {
        element = this._getHeaderByIndex(index, axis);
        if (element == null) {
          element = this._getHeaderByIndex(index, 'rowEnd');
        }
      }
      if (axis === 'column') {
        element = this._getHeaderByIndex(index, axis);
        if (element == null) {
          element = this._getHeaderByIndex(index, 'columnEnd');
        }
      }
    }
    return element;
  };

  /**
   * Get a label by axis and level
   * @param {string} axis
   * @param {number} level
   * @returns {Element|null}
   */
  DvtDataGrid.prototype._getLabel = function (axis, level) {
    return this.m_headerLabels[axis][level];
  };

  /**
   * Get a cell by index
   * @param {Object} indexes
   * @returns {Element|null}
   */
  DvtDataGrid.prototype._getCellByIndex = function (indexes) {
    var id = this._getFromDatabodyMap(indexes);
    let cell = null;
    if (id != null) {
      // databody isn't necessarily attached to the document
      let sections = [
        this.m_databody,
        this.m_databodyFrozenCorner,
        this.m_databodyFrozenCol,
        this.m_databodyFrozenRow
      ];
      sections = sections.filter((section) => section);
      for (let i = 0; i < sections.length; i++) {
        cell = sections[i].querySelector(`#${id}`);
        if (cell) {
          break;
        }
      }
    }
    return cell;
  };

  DvtDataGrid.prototype._getCellContainer = function (cell) {
    let container = this.m_databody;
    let sections = [this.m_databodyFrozenCorner, this.m_databodyFrozenCol, this.m_databodyFrozenRow];
    sections = sections.filter((section) => section);
    for (let i = 0; i < sections.length; i++) {
      let element = sections[i].querySelector(`#${cell.id}`);
      if (element) {
        container = sections[i];
        break;
      }
    }
    return container;
  };

  DvtDataGrid.prototype._getFrozenCellByIndex = function (indexes, axis, corner) {
    var id = this._getFromDatabodyMap(indexes);
    if (id != null) {
      let frozenCell;
      if (corner) {
        frozenCell = this.m_databodyFrozenCorner.querySelector('#' + id);
      } else if (axis === 'row') {
        frozenCell = this.m_databodyFrozenCol.querySelector('#' + id);
      } else if (axis === 'column') {
        frozenCell = this.m_databodyFrozenRow.querySelector('#' + id);
      }
      return frozenCell;
    }
    return null;
  };

  DvtDataGrid.prototype._getCellsInRange = function (startRow, startColumn, endRow, endColumn) {
    let cells = [];
    for (let i = startRow; i <= endRow; i++) {
      for (let j = startColumn; j <= endColumn; j++) {
        let cell = this._getCellByIndex(this.createIndex(i, j));
        if (cell) {
          cells.push(cell);
        }
      }
    }
    return cells;
  };

  DvtDataGrid.prototype._getFirstCellWithMatchingStartIndex = function (index, axis) {
    // find the first cell that has the given axis index as its startIndex
    let startAxisIndex = axis === 'row' ? this.m_startCol : this.m_startRow;
    let endAxisIndex = axis === 'row' ? this.m_endCol : this.m_endRow;
    let indexes;
    let cell;
    for (let i = startAxisIndex; i <= endAxisIndex; i++) {
      indexes = this.createIndex(axis === 'row' ? index : i, axis === 'row' ? i : index);
      cell = this._getCellByIndex(indexes);
      // this will be actual start index
      if (this._getIndex(cell, axis) === index) {
        return cell;
      }
    }

    return null;
  };

  /**
   * Get all the cells along an axis by index
   * @param {number} index
   * @param {string} axis row/column
   * @param {boolean=} breakOnFirstFind
   * @returns {Array|null}
   * @private
   */
  DvtDataGrid.prototype._getAxisCellsByIndex = function (index, axis, breakOnFirstFind) {
    var start = axis === 'row' ? this.m_startCol : this.m_startRow;
    var end = axis === 'row' ? this.m_endCol : this.m_endRow;
    var axisExtent;
    var cells = [];

    for (var i = start; i <= end; i += axisExtent) {
      var cell = this._getCellByIndex(
        this.createIndex(axis === 'row' ? index : i, axis === 'row' ? i : index)
      );
      if (cell != null) {
        axisExtent = this.getCellExtents(cell)[axis === 'row' ? 'column' : 'row'];
        cells.push(cell);
        if (breakOnFirstFind) {
          break;
        }
      } else {
        axisExtent = 1;
      }
    }
    return cells;
  };

  /**
   * Get all the cells along an axis by key
   * @param {string|null} key
   * @param {string} axis row/column
   * @param {boolean=} breakOnFirstFind
   * @returns {Array|null}
   * @private
   */
  DvtDataGrid.prototype._getAxisCellsByKey = function (key, axis, breakOnFirstFind) {
    if (key == null || this.m_databody == null || this.m_databody.firstChild == null) {
      return null;
    }

    var matchingCells = [];
    let container = [
      this.m_databody,
      this.m_databodyFrozenCorner,
      this.m_databodyFrozenCol,
      this.m_databodyFrozenRow
    ];
    container = container.filter((section) => section);
    let cells = [];
    for (let i = 0; i < container.length; i++) {
      cells.push(...container[i].firstChild.querySelectorAll('.' + this.getMappedStyle('cell')));
    }

    for (var i = 0; i < cells.length; i++) {
      var cell = cells[i];
      if (this.m_utils.containsCSSClassName(cell, this.getMappedStyle('cell'))) {
        var axisKey = this._getKey(cell, axis);
        if (axisKey === key) {
          matchingCells.push(cell);
          if (breakOnFirstFind) {
            break;
          }
        }
      }
    }

    // can't find it, the row is not in viewport
    return matchingCells;
  };

  /**
   * Determined if filtering is supported for the specified element.
   * @param {Element|undefined} element to check if filtering should be on
   * @private
   */
  DvtDataGrid.prototype._isDOMElementFilterable = function (element) {
    if (element == null) {
      return false;
    }
    var header = this.findHeader(element);
    if (header == null) {
      return false;
    }
    return header.getAttribute(this.getResources().getMappedAttribute('filterable')) === 'true';
  };

  /**
   * Get horizontal alignment styles
   * @param {string} horizontalAlignment
   * @private
   */
  DvtDataGrid.prototype._getHorizontalAlignmentStyle = function (horizontalAlignment) {
    const obj = {
      justifyContent: horizontalAlignment,
      textAlign: horizontalAlignment
    };
    if (horizontalAlignment === 'start') {
      obj.justifyContent = 'flex-start';
      obj.textAlign = 'start';
    } else if (horizontalAlignment === 'end') {
      obj.justifyContent = 'flex-end';
      obj.textAlign = 'end';
    }
    return obj;
  };

  /**
   * Get horizontal alignment styles
   * @param {string} verticalAlignment
   * @private
   */
  DvtDataGrid.prototype._getVerticalAlignmentStyle = function (verticalAlignment) {
    if (verticalAlignment === 'top') {
      return 'flex-start';
    } else if (verticalAlignment === 'bottom') {
      return 'flex-end';
    }
    return 'center';
  };

  /**
   * Check whether icon should be appended
   * @param {string} horizontalAlignment header content horizontal alignment
   * @param {string} axis row or column
   * @param {Object} headerContext header context object
   */
  DvtDataGrid.prototype._shouldAppendIcon = function (horizontalAlignment, axis, headerContext) {
    if (
      horizontalAlignment === 'start' ||
      horizontalAlignment === 'center' ||
      (this.getResources().isRTLMode() && horizontalAlignment === 'right') ||
      (!this.getResources().isRTLMode() && horizontalAlignment === 'left') ||
      (horizontalAlignment === 'auto' && (axis === 'row' || this._isParentNode(headerContext)))
    ) {
      return true;
    }
    return false;
  };

  /**
   * Build the actions object which maps actions to the methods to invoke because of them
   */
  DvtDataGrid.prototype._setupActions = function () {
    this.actions = {
      ACTIONABLE: this._handleActionable,
      EXIT_ACTIONABLE: this._handleExitActionable,
      TAB_NEXT_IN_CELL: DataCollectionUtils.handleActionableTab,
      TAB_PREV_IN_CELL: DataCollectionUtils.handleActionablePrevTab,
      TAB_NEXT_IN_CELL_OR_FOCUS_RIGHT: this._handleEditableTab,
      TAB_PREV_IN_CELL_OR_FOCUS_LEFT: this._handleEditablePrevTab,
      EDITABLE: this._handleEditable, // if editable go into edit, if not go into actionable
      EXIT_EDITABLE: this._handleExitEditable,
      DATA_ENTRY: this._handleDataEntry,
      EDIT: this._handleEdit,
      EXIT_EDIT: this._handleExitEdit,
      CANCEL_EDIT: this._handleCancelEdit,
      NO_OP: this._handleNoOp,
      FOCUS_LEFT: this._handleFocusLeft,
      FOCUS_LEFT_NON_EMPTY_CELL: this._handleFocusLeftNonEmptyCell,
      FOCUS_RIGHT: this._handleFocusRight,
      FOCUS_RIGHT_NON_EMPTY_CELL: this._handleFocusRightNonEmptyCell,
      FOCUS_UP: this._handleFocusUp,
      FOCUS_UP_NON_EMPTY_CELL: this._handleFocusUpNonEmptyCell,
      FOCUS_DOWN: this._handleFocusDown,
      FOCUS_DOWN_NON_EMPTY_CELL: this._handleFocusDownNonEmptyCell,
      FOCUS_ROW_FIRST: this._handleFocusRowFirst,
      FOCUS_ROW_LAST: this._handleFocusRowLast,
      FOCUS_COLUMN_FIRST: this._handleFocusColumnFirst,
      FOCUS_COLUMN_LAST: this._handleFocusColumnLast,
      FOCUS_COLUMN_HEADER: this._handleFocusColumnHeader,
      FOCUS_COLUMN_END_HEADER: this._handleFocusColumnEndHeader,
      FOCUS_ROW_HEADER: this._handleFocusRowHeader,
      FOCUS_ROW_END_HEADER: this._handleFocusRowEndHeader,
      FOCUS_FIRST_CELL_IN_GRID: this._handleFocusFirstCellInGrid,
      FOCUS_LAST_CELL_IN_GRID: this._handleFocusLastCellInGrid,
      READ_CELL: this.readCurrentContent,
      SORT: this._handleSortKey,
      EXPAND: this._handleExpandKey,
      COLLAPSE: this._handleCollapseKey,
      SELECT_DISCONTIGUOUS: this._handleSelectDiscontiguous,
      SELECT_EXTEND_LEFT: this._handleExtendSelectionLeft,
      SELECT_EXTEND_RIGHT: this._handleExtendSelectionRight,
      SELECT_EXTEND_UP: this._handleExtendSelectionUp,
      SELECT_EXTEND_DOWN: this._handleExtendSelectionDown,
      SELECT_ROW: this._handleSelectRow,
      SELECT_COLUMN: this._handleSelectColumn,
      SELECT_ALL: this._handleSelectAll,
      CUT: this._handleCut,
      CUT_CELLS: this._handleCutCells,
      COPY_CELLS: this._handleCopyCells,
      CANCEL_REORDER: this._handleCancelReorder,
      PASTE: this._handlePaste,
      PASTE_CELLS: this._handlePasteCells,
      FILL: this._handleAutofill,
      CANCEL_DRAG: this.handleCancelDrag,
      FILTER_COLUMN: this._handleFilterKey
    };
  };

  /**
   * Get the function for a given keydown event.
   * @param {Event} event
   * @param {string} cellOrHeader 'cell'/'header'
   * @returns {Function|undefined} the function to invoke due to the keydown
   */
  DvtDataGrid.prototype._getActionFromKeyDown = function (event, cellOrHeader, label) {
    var capabilities = {
      cellOrHeader: cellOrHeader,
      isLabel: label,
      readOnly: !this._isCellEditable(),
      currentMode: this._getCurrentMode(),
      activeMove: this.m_cutCells != null || this.m_dataTransferAction != null,
      rowMove: this._isMoveEnabled('row'),
      columnSort:
        cellOrHeader === 'column' ? this._isDOMElementSortable(this._getActiveElement()) : false,
      rowSort: cellOrHeader === 'row' ? this._isDOMElementSortable(this._getActiveElement()) : false,
      selection: this._isSelectionEnabled(),
      selectionMode: this.m_options.getSelectionMode(),
      multipleSelection: this.isMultipleSelection(),
      expandCollapse: this._isTargetExpandCollapseEnabled(event.target)
    };
    if (this._isDataGridProvider()) {
      capabilities.cutCells = true;
      capabilities.copyCells = true;
      capabilities.pasteCells = true;
      capabilities.activeDrag = !!(this._cellsDragged && this._cellsDragged.length);
      capabilities.filterCol = this._isDOMElementFilterable(this._getActiveElement());
    }
    if (this.m_options.isFloodFillEnabled()) {
      capabilities.fill = true;
    }
    return this.actions[this.m_keyboardHandler.getAction(event, capabilities)];
  };

  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype._getActionFromNoDataKeydown = function (event) {
    var capabilities = {
      readOnly: !this._isCellEditable(),
      currentMode: this._getCurrentMode()
    };
    return this.actions[this.m_keyboardHandler.getNoDataAction(event, capabilities)];
  };

  // ////////////////////////////////// ACTIONABLE METHODS/////////////////////////
  /**
   * Determine if the data grid is in actionable mode.
   * @return returns true if the data grid is in actionable mode, false otherwise.
   * @protected
   */
  DvtDataGrid.prototype.isActionableMode = function () {
    return this.m_currentMode === 'actionable';
  };

  /**
   * Sets whether the data grid is in actionable mode or reverts it to navigation mode
   * @param {boolean} flag true to set grid to actionable mode, false otherwise
   * @protected
   */
  DvtDataGrid.prototype.setActionableMode = function (flag) {
    if (flag) {
      this.m_currentMode = 'actionable';
    } else {
      this.m_currentMode = 'navigation';
    }

    // update screen reader alert
    this._setAccInfoText(
      this.isActionableMode() ? 'accessibleActionableMode' : 'accessibleNavigationMode'
    );
  };

  /**
   * Enter actionable mode
   * @param {Event} event the event triggering actionable mode
   * @param {Element|undefined|null} element to set actionable
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleActionable = function (event, element) {
    this._enterActionableMode(element, event, true);
    return false;
  };

  /**
   * Exit actionable mode on the active cell if in actionable mode
   * @param {Event} event the event exiting actionable mode
   * @param {Element|undefined|null} element to unset actionable
   * @returns {boolean} false
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype._handleExitActionable = function (event, element) {
    this._exitActionableMode();
    this._highlightActive();
    return false;
  };

  // ////////////////////////////////// EDITING METHODS/////////////////////////
  /**
   * Get the edit mode values can be none/cell
   * @returns {string}  none or cell
   * @private
   */
  DvtDataGrid.prototype._getEditMode = function () {
    if (this.m_editMode == null) {
      this.m_editMode = this.m_options.getEditMode();
    }
    return this.m_editMode;
  };

  /**
   * Get the current mode of the datagrid
   * @returns {string} navigation/actionable/enter/edit
   * @private
   */
  DvtDataGrid.prototype._getCurrentMode = function () {
    if (this.m_currentMode == null) {
      this.m_currentMode = 'navigation';
    }
    return this.m_currentMode;
  };

  /**
   * Is the current mode edit or enter
   * @returns {boolean} true if edit or enter
   * @private
   */
  DvtDataGrid.prototype._isEditOrEnter = function () {
    var c = this._getCurrentMode();
    return c === 'edit';
  };

  /**
   * Can the grid as a whole be editable
   * @returns {boolean} true if the edit mode is cell
   * @private
   */
  DvtDataGrid.prototype._isGridEditable = function () {
    var editMode = this._getEditMode();
    if (editMode === 'cellNavigation' || editMode === 'cellEdit') {
      return true;
    }
    return false;
  };

  /**
   * Is the grid in ediable or readOnly mode
   * @returns {boolean} true if the edit mode is cell and editable enabled
   * @private
   */
  DvtDataGrid.prototype._isCellEditable = function () {
    var editMode = this._getEditMode();
    if (editMode === 'cellEdit') {
      return true;
    }
    return false;
  };

  /**
   * Enter editable mode
   * @param {Event} event the event triggering editable mode
   * @param {Element|undefined|null} element
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleEditable = function (event, element) {
    if (this._isGridEditable()) {
      this.m_editMode = null;
      this.m_setOptionCallback('editMode', 'cellEdit', {
        _context: {
          writeback: true,
          internalSet: true
        }
      });
      this.m_utils.removeCSSClassName(this.m_root, this.getMappedStyle('readOnly'));
      this.m_utils.addCSSClassName(this.m_root, this.getMappedStyle('editable'));
      this._updateEdgeCellBorders('');
      this._setAccInfoText('accessibleEditableMode');
      this._setEditableClone(element);
    } else {
      this._handleActionable(event, element);
    }
    return false;
  };

  /**
   * Exit editable mode
   * @param {Event} event the event triggering editable mode
   * @param {Element|undefined|null} element
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype._handleExitEditable = function (event, element) {
    this.m_editMode = null;
    this.m_setOptionCallback('editMode', 'cellNavigation', {
      _context: {
        writeback: true,
        internalSet: true
      }
    });
    this.m_utils.addCSSClassName(this.m_root, this.getMappedStyle('readOnly'));
    this.m_utils.removeCSSClassName(this.m_root, this.getMappedStyle('editable'));
    this._updateEdgeCellBorders('none');
    this._setAccInfoText('accessibleNavigationMode');
    this._destroyEditableClone();
  };

  /**
   * Enter enter mode
   * @param {Event} event the event triggering enter mode
   * @param {Element|undefined|null} element
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleDataEntry = function (event, element) {
    var details = {
      event: event,
      ui: {
        cell: element,
        cellContext: element[this.getResources().getMappedAttribute('context')]
      }
    };

    var isReadOnly = this._getAttribute(element, 'readOnly');
    var rerender = !isReadOnly ? this.fireEvent('beforeEdit', details) : false;

    if (rerender) {
      this._removeFloodFillAffordance();
      this._reRenderCell(element, 'edit', this.getMappedStyle('cellEdit'), this.m_editableClone);
      if (this._setFocusToFirstFocusableElement(element, undefined, true)) {
        this.m_currentMode = 'edit';
      } else {
        // if there was nothing to edit remove the edit class
        this.m_utils.removeCSSClassName(element, this.getMappedStyle('cellEdit'));
      }
    } else {
      this.showReadOnlyPopup(element);
    }
    return false;
  };

  /**
   * Enter edit mode
   * @param {Event} event the event triggering edit mode
   * @param {Element|undefined|null} element
   * @param {boolean=} shouldSelect - should try to select content of first focusable element
   * @returns {boolean} true if edit mode entered
   */
  DvtDataGrid.prototype._handleEdit = function (event, element, shouldSelect) {
    var details = {
      event: event,
      ui: {
        cell: element,
        cellContext: element[this.getResources().getMappedAttribute('context')]
      }
    };
    var isReadOnly = this._getAttribute(element, 'readOnly');
    var rerender = !isReadOnly ? this.fireEvent('beforeEdit', details) : false;

    if (rerender) {
      this._removeFloodFillAffordance();
      this._reRenderCell(element, 'edit', this.getMappedStyle('cellEdit'), this.m_editableClone);
      this.m_currentMode = 'edit';
      this._updateEdgeCellBorders('');
      var self = this;
      var busyContext = Context.getContext(element).getBusyContext();
      busyContext.whenReady().then(function () {
        // focus on first focusable item in the cell
        var setFocus = self._setFocusToFirstFocusableElement(element, undefined, shouldSelect);
        if (!setFocus) {
          // if there was nothing to edit remove the edit class
          self.m_utils.removeCSSClassName(element, self.getMappedStyle('cellEdit'));
          self.m_currentMode = 'navigation';
        }
      });
    } else {
      rerender = false;
      this._enterActionableMode(element, null, true);
      if (!this.isActionableMode()) {
        this.showReadOnlyPopup(element);
      }
    }
    return rerender;
  };

  DvtDataGrid.prototype.showReadOnlyPopup = function (element) {
    const rootId = this.m_root.getAttribute('id');
    let popup = document.getElementById(rootId + 'popup');

    if (popup === null) {
      popup = document.createElement('oj-popup');
      popup.id = rootId + 'popup';
      popup.setAttribute('data-oj-binding-provider', 'none');
      var popupText = document.createElement('span');
      let text = this.getResources().getTranslatedText('msgReadOnly');
      popupText.textContent = text;
      popup.appendChild(popupText); // @HTMLUpdateOK

      const position = {
        my: {
          horizontal: 'center',
          vertical: 'bottom'
        },
        at: {
          horizontal: 'center',
          vertical: 'top'
        },
        collision: 'none'
      };
      popup.setAttribute('position', JSON.stringify(position));
      popup.setAttribute('tail', 'none');
      this.m_root.appendChild(popup); // @HTMLUpdateOK
    }

    if (popup) {
      const busyContext = Context.getContext(popup).getBusyContext();
      busyContext.whenReady().then(() => {
        popup.open(element);
      });
    } else {
      popup.open(element);
    }
  };

  /**
   * Exit edit mode
   * @param {Event} event
   * @param {Element|undefined|null} element
   * @returns {boolean} true if editing left successully
   */
  DvtDataGrid.prototype._handleExitEdit = function (event, element) {
    return this._leaveEditing(event, element, false);
  };

  /**
   * Cancel an edit
   * @param {Event} event
   * @param {Element|undefined|null} element
   * @returns {boolean} true if editing cancelled successully
   */
  DvtDataGrid.prototype._handleCancelEdit = function (event, element) {
    if (this._leaveEditing(event, element, true)) {
      this._setEditableClone(element);
      return true;
    }
    return false;
  };

  /**
   * Leave editing
   * @param {Event} event the event triggering actionable mode
   * @param {Element|undefined|null} element
   * @param {boolean} cancel
   * @param {boolean} shouldFocus
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._leaveEditing = function (event, element, cancel, shouldFocus) {
    const cellContext = element[this.getResources().getMappedAttribute('context')];
    var details = {
      event: event,
      ui: {
        cell: element,
        cellContext: cellContext,
        cancelEdit: cancel
      }
    };
    if (cellContext.metadata?.validity === 'invalidShown') {
      this._applyBorderClassesAroundRange(
        element,
        { startIndex: this.m_active.indexes },
        false,
        'EditInvalid'
      );
    }

    if (!cancel) {
      DataCollectionUtils.disableAllFocusableElements(element);
      if (shouldFocus === false) {
        this.m_shouldFocus = shouldFocus;
      }
      this._highlightActive();
    }
    var rerender = this.fireEvent('beforeEditEnd', details);
    if (rerender) {
      this.m_currentMode = 'navigation';
      DataCollectionUtils.disableAllFocusableElements(element);
      if (shouldFocus === false) {
        this.m_shouldFocus = shouldFocus;
      }
      this._highlightActive();
      this._reRenderCell(
        element,
        'navigation',
        this.getMappedStyle('cellEdit'),
        this.m_editableClone
      );
    } else {
      rerender = false;
      this._scrollToActive(this.m_active);
      // focus on first focusable item in the cell
      this._setFocusToFirstFocusableElement(element);
    }

    this._runModelEventQueue();
    return rerender;
  };

  // ////////////////////////////////// FOCUS METHODS/////////////////////////
  /**
   * Handles all the various focus changes by keystroke
   * @param {Event} event
   * @param {Element} element
   * @param {number} keyCode
   * @param {boolean} isExtend
   * @param {boolean} jumpToHeaders
   * @returns {boolean} true if event processed
   */
  DvtDataGrid.prototype._handleFocusKey = function (
    event,
    element,
    keyCode,
    isExtend,
    jumpToHeaders,
    skipEmpty,
    cellExtreme
  ) {
    var changeFocus = true;
    var changeRegions = true;
    var editing;

    if (this.m_active != null) {
      if (this.m_active.type === 'cell') {
        if (this._isEditOrEnter()) {
          editing = true;
          changeFocus = this._leaveEditing(event, element, false);
          changeRegions = false;
        } else if (this.isActionableMode()) {
          this._exitActionableMode();
        }

        if (changeFocus) {
          if (this.m_options.isFloodFillEnabled()) {
            this._removeFloodFillAffordance();
          }
          var oldActive = this.m_active;
          var returnVal = this.handleFocusChange(
            keyCode,
            isExtend,
            event,
            changeRegions,
            jumpToHeaders,
            skipEmpty,
            cellExtreme
          );
          if (
            this._isGridEditable() &&
            oldActive !== this.m_active &&
            editing &&
            this.m_utils.isTouchDevice()
          ) {
            return this._handleEdit(event, this._getActiveElement(), true);
          }
          return returnVal;
        }
        return true;
      } else if (this.m_active.type === 'header') {
        return this.handleHeaderFocusChange(keyCode, event, isExtend, jumpToHeaders, skipEmpty);
      } else if (this.m_active.type === 'label') {
        return this.handleLabelFocusChange(keyCode, event, isExtend, jumpToHeaders);
      } else if (this.m_active.type === 'empty') {
        return this.handleNoDataFocusChange(keyCode, isExtend, event, changeRegions);
      }
    }
    return false;
  };

  /**
   * Handle a focus to the left element
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusLeft = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.LEFT_KEY, false, false);
  };

  /**
   * Handle a focus to the left non-empty element
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusLeftNonEmptyCell = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.LEFT_KEY, false, false, true);
  };

  /**
   * Handle a focus to the right element
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusRight = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.RIGHT_KEY, false, false);
  };

  /**
   * Handle a focus to the right non-empty element
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusRightNonEmptyCell = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.RIGHT_KEY, false, false, true);
  };

  /**
   * Handle a focus to the up element
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusUp = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.UP_KEY, false, false);
  };

  /**
   * Handle a focus to a non empty element upside, ctrl + up arrow
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusUpNonEmptyCell = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.UP_KEY, false, false, true);
  };

  /**
   * Handle a focus to the down element
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusDown = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.DOWN_KEY, false, false);
  };

  /**
   * Handle a focus to the down non empty element, ctrl + down arrow
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusDownNonEmptyCell = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.DOWN_KEY, false, false, true);
  };

  /**
   * Handle a focus to the first row same column
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusRowFirst = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.PAGEUP_KEY, false, false);
  };

  /**
   * Handle a focus to the last row same column
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusRowLast = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.PAGEDOWN_KEY, false, false);
  };

  /**
   * Handle a focus to the first column same row
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusColumnFirst = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.HOME_KEY, false, false);
  };

  /**
   * Handle a focus to the last column same row
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusColumnLast = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.END_KEY, false, false);
  };

  /**
   * Handle a focus to the row header
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusRowHeader = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.LEFT_KEY, false, true);
  };

  /**
   * Handle a focus to the row end header
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusRowEndHeader = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.RIGHT_KEY, false, true);
  };

  /**
   * Handle a focus to the column header
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusColumnHeader = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.UP_KEY, false, true);
  };

  /**
   * Handle a focus to the column end header
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusColumnEndHeader = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.DOWN_KEY, false, true);
  };

  /**
   * Handle a focus to the first cell in grid
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusFirstCellInGrid = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.HOME_KEY, false, false, false, true);
  };

  /**
   * Handle a focus to the last cell in grid
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleFocusLastCellInGrid = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.END_KEY, false, false, false, true);
  };

  // ///////////////////// SELECTION METHODS ////////////////////////////
  /**
   * Handle a selection of the whole row
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} true if processed
   */
  DvtDataGrid.prototype._handleSelectRow = function (event, element) {
    var start;
    var end;
    var level;
    var index;
    var extent = 1;

    if (
      !this._isSelectionEnabled() ||
      (!this.isMultipleSelection() && this.m_options.getSelectionMode() !== 'row')
    ) {
      return false;
    }

    if (this.m_utils.containsCSSClassName(element, this.getMappedStyle('cell'))) {
      index = this.m_active.indexes.row;
      start = index;
      end = index;
      level = this.m_rowHeaderLevelCount - 1;
    } else {
      if (
        this.m_active == null ||
        this.m_active.type !== 'header' ||
        this.m_active.axis.indexOf('row') === -1
      ) {
        return false;
      }
      index = this.m_active.index;
      level = this.m_active.level;
      if (this.m_rowHeaderLevelCount - 1 === level) {
        start = index;
        end = index;
      } else {
        var elem = this._getActiveElement();
        start = this._getAttribute(elem.parentNode, 'start', true);
        extent = this._getAttribute(elem.parentNode, 'extent', true);
        end = start + extent - 1;
      }
    }

    if (this.m_selectionFrontier) {
      if (this.m_selectionFrontier.axis && this.m_selectionFrontier.axis.indexOf('column') !== -1) {
        this._handleSelectAll(event);
        return true;
      }
    }

    // set the frontier as it would be with header selection
    this.setHeaderSelectionFrontier('row', end, index, level, element, true);

    if (this._shouldDeselectHeader(index, extent, 'row')) {
      var rangeStart = this.createIndex(index, 0);
      var rangeEnd = this.createIndex(index + extent - 1, -1);
      var returnObj = this._getSelectionStartAndEnd(rangeStart, rangeEnd, 0);
      var range = this.createRange(
        this.createIndex(returnObj.min.row, 0),
        this.createIndex(returnObj.max.row, -1)
      );
      var trimmedRange = this._trimRangeForSelectionMode(range);
      this.m_deselectInfo = { selection: this.GetSelection() };
      this._deselectRange(trimmedRange, event);
      return true;
    }

    // handle the space key in headers
    this._selectEntireRow(start, end, event);

    // announce to screen reader, no need to include context info
    this._setAccInfoText('accessibleRowSelected', { row: index + 1 });
    return true;
  };

  /**
   * Handle a selection of the whole column
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} true if processed
   */
  DvtDataGrid.prototype._handleSelectColumn = function (event, element) {
    var start;
    var end;
    var level;
    var index;
    var extent = 1;

    if (
      !this._isSelectionEnabled() ||
      !this.isMultipleSelection() ||
      this.m_options.getSelectionMode() !== 'cell'
    ) {
      return false;
    }

    if (this.m_utils.containsCSSClassName(element, this.getMappedStyle('cell'))) {
      index = this.m_active.indexes.column;
      start = index;
      end = index;
      level = this.m_columnHeaderLevelCount - 1;
    } else {
      if (
        this.m_active == null ||
        this.m_active.type !== 'header' ||
        this.m_active.axis.indexOf('column') === -1
      ) {
        return false;
      }
      index = this.m_active.index;
      level = this.m_active.level;
      if (this.m_columnHeaderLevelCount - 1 === level) {
        start = index;
        end = index;
      } else {
        var elem = this._getActiveElement();
        start = this._getAttribute(elem.parentNode, 'start', true);
        extent = this._getAttribute(elem.parentNode, 'extent', true);
        end = start + extent - 1;
      }
    }

    if (this.m_selectionFrontier) {
      if (this.m_selectionFrontier.axis && this.m_selectionFrontier.axis.indexOf('row') !== -1) {
        this._handleSelectAll(event);
        return true;
      }
    }

    // set the frontier as it would be with header selection
    this.setHeaderSelectionFrontier('column', end, index, level, element, true);

    if (this._shouldDeselectHeader(index, extent, 'column')) {
      var rangeStart = this.createIndex(0, index);
      var rangeEnd = this.createIndex(-1, index + extent - 1);
      var returnObj = this._getSelectionStartAndEnd(rangeStart, rangeEnd, 0);
      var range = this.createRange(
        this.createIndex(0, returnObj.min.column),
        this.createIndex(-1, returnObj.max.column)
      );
      var trimmedRange = this._trimRangeForSelectionMode(range);
      this.m_deselectInfo = { selection: this.GetSelection() };
      this._deselectRange(trimmedRange, event);
      return true;
    }

    // handle the space key in headers
    this._selectEntireColumn(start, end, event);

    // announce to screen reader, no need to include context info
    this._setAccInfoText('accessibleColumnSelected', { column: index + 1 });
    return true;
  };

  /**
   * Handle entering discontiguous selection
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} true if processed
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype._handleSelectDiscontiguous = function (event, element) {
    this.setDiscontiguousSelectionMode(!this.m_discontiguousSelection);
    return true;
  };

  /**
   * Handle extend selection left
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} true if processed
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype._handleExtendSelectionLeft = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.LEFT_KEY, true, false);
  };

  /**
   * Handle extend selection right
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} true if processed
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype._handleExtendSelectionRight = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.RIGHT_KEY, true, false);
  };

  /**
   * Handle extend selection up
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} true if processed
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype._handleExtendSelectionUp = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.UP_KEY, true, false);
  };

  /**
   * Handle extend selection down
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} true if processed
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype._handleExtendSelectionDown = function (event, element) {
    return this._handleFocusKey(event, element, this.keyCodes.DOWN_KEY, true, false);
  };

  /**
   * Handle sort key
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} true if processed
   */
  DvtDataGrid.prototype._handleSortKey = function (event, element) {
    // sort, first check if the column is sortable
    if (element.getAttribute(this.getResources().getMappedAttribute('sortable')) === 'true') {
      this._handleKeyboardSort(element, event);
      return true;
    }

    // enter actionable mode but don't prevent default so the action is taken
    return this._handleActionable(event, element);
  };

  /**
   * Handle expand key
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} true if processed
   */
  DvtDataGrid.prototype._handleExpandKey = function (event, element) {
    // expand, first check if the column is collapsed
    if (this._isHeaderCollapsed(element)) {
      this._handleExpandCollapseRequest(event);
      return true;
    }
    return false;
  };

  /**
   * Handle collapse key
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} true if processed
   */
  DvtDataGrid.prototype._handleCollapseKey = function (event, element) {
    // collapse, first check if the column is expanded
    if (this._isHeaderExpanded(element)) {
      this._handleExpandCollapseRequest(event);
      return true;
    }
    return false;
  };

  /**
   * Enter editable mode
   * @param {Event} event the event triggering actionable mode
   * @param {Element} element to set actionable
   * @returns {boolean} false
   */
  // eslint-disable-next-line no-unused-vars
  DvtDataGrid.prototype._handleNoOp = function (event, element) {
    return false;
  };

  /**
   * Handle filter key
   * @param {Event} event the event causing the action
   * @returns {boolean} true if processed
   */
  DvtDataGrid.prototype._handleFilterKey = function (event) {
    this._handleHeaderFilter(event, 'column');
    return true;
  };

  /**
   * Handle a focus to the right element when in editable mode
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleEditableTab = function (event, element) {
    var focusElems = DataCollectionUtils.getFocusableElementsInNode(element);
    if (focusElems && focusElems.indexOf(document.activeElement) < focusElems.length - 1) {
      return false;
    }

    return this._handleFocusRight(event, element);
  };

  /**
   * Handle a focus to the left element when in editable mode
   * @param {Event} event the event causing the action
   * @param {Element} element target cell or header of the event
   * @returns {boolean} false
   */
  DvtDataGrid.prototype._handleEditablePrevTab = function (event, element) {
    var focusElems = DataCollectionUtils.getFocusableElementsInNode(element);
    if (focusElems && focusElems.indexOf(document.activeElement) > 0) {
      return false;
    }

    return this._handleFocusLeft(event, element);
  };

  DvtDataGrid.RESIZE_OFFSET = 5;
  DvtDataGrid.RESIZE_TOUCH_OFFSET = 8;

  /**
   * Handles what to do when the mouse moves. Sets the cursor based on .manageHeaderCursor(),
   * If this.m_isResizing is set to true, treats movement as resizing, calling .handleResizeMouseMove()
   * @param {Event} event - a mousemove event
   */
  DvtDataGrid.prototype.handleResize = function (event) {
    // if not resizing, monitor the cursor position, otherwise handle resizing
    if (this.m_isResizing === false) {
      var header = this.find(event.target, 'header');
      var headerLabel = this.find(event.target, 'headerlabel');
      if (header == null) {
        header = this.find(event.target, 'endheader');
      }

      // only if we are inside our grid's headers, multiple grid case
      if (
        (header != null &&
          (header === this.m_rowHeader ||
            header === this.m_colHeader ||
            header === this.m_rowEndHeader ||
            header === this.m_colEndHeader ||
            header === this.m_colHeaderFrozen ||
            header === this.m_colEndHeaderFrozen ||
            header === this.m_rowHeaderFrozen ||
            header === this.m_rowEndHeaderFrozen)) ||
        headerLabel != null
      ) {
        let isHeaderLabel = false;
        if (headerLabel) {
          isHeaderLabel = true;
        }
        this.m_cursor = this.manageHeaderCursor(event, isHeaderLabel);
        if (this.m_resizingElement != null) {
          if (this.m_cursor === 'default') {
            this.m_resizingElement.style.cursor = '';
            if (
              this._isSelectionEnabled() &&
              ((header && this.shouldHoverHeader(header)) || headerLabel)
            ) {
              this.m_utils.addCSSClassName(event.target, this.getMappedStyle('hover'));
            }
            if (this.m_resizingElementSibling != null) {
              this.m_resizingElementSibling.style.cursor = '';
            }
          } else {
            this.m_resizingElement.style.cursor = this.m_cursor;
            this.m_utils.removeCSSClassName(event.target, this.getMappedStyle('hover'));
            if (this.m_resizingElementSibling != null) {
              this.m_resizingElementSibling.style.cursor = this.m_cursor;
            }
          }
        }
      }
    } else {
      this.handleResizeMouseMove(event);
    }
  };

  /**
   * On mousedown, if the cursor was set to row/col -resize, set the required resize values.
   * @param {Event} event - a mousedown event
   * @return {boolean} true if event processed
   */
  DvtDataGrid.prototype.handleResizeMouseDown = function (event) {
    if (this.m_cursor === 'col-resize' || this.m_cursor === 'row-resize') {
      this.m_isResizing = true;
      if (this.m_utils.isTouchDevice()) {
        this.m_lastMouseX = event.touches[0].pageX;
        this.m_lastMouseY = event.touches[0].pageY;
      } else {
        document.addEventListener('mousemove', this.m_docMouseMoveListener, false);
        document.addEventListener('mouseup', this.m_docMouseUpListener, false);
        this.m_lastMouseX = event.pageX;
        this.m_lastMouseY = event.pageY;
      }

      this.m_overResizeLeft = 0;
      this.m_overResizeMinLeft = 0;
      this.m_overResizeTop = 0;
      this.m_overResizeMinTop = 0;
      this.m_overResizeRight = 0;
      this.m_overResizeBottom = 0;
      this.m_orginalResizeDimensions = {
        width: this.getElementWidth(this.m_resizingElement),
        height: this.getElementHeight(this.m_resizingElement)
      };

      return true;
    }
    return false;
  };

  DvtDataGrid.prototype._resizeSelectedHeaders = function (
    event,
    oldWidth,
    oldHeight,
    newWidth,
    newHeight,
    size
  ) {
    let resizingElement = this.m_resizingElement;
    let resizingElementAxis = this.getHeaderCellAxis(this.m_resizingElement);
    let resizeHeaderMode = this._getResizeHeaderMode(this.m_resizingElement);
    let resizingElementLevel = this.getHeaderCellLevel(this.m_resizingElement);
    let allowResizeWithinSelection = false;
    if (
      (resizingElementAxis === 'column' &&
        resizingElementLevel === this.m_columnHeaderLevelCount - 1) ||
      (resizingElementAxis === 'row' && resizingElementLevel === this.m_rowHeaderLevelCount - 1) ||
      (resizingElementAxis === 'columnEnd' &&
        resizingElementLevel === this.m_columnEndHeaderLevelCount - 1) ||
      (resizingElementAxis === 'rowEnd' && resizingElementLevel === this.m_rowEndHeaderLevelCount - 1)
    ) {
      allowResizeWithinSelection = true;
    }
    const selectedHeadersSet = new Set();
    const context = this.m_resizingElement[this.getResources().getMappedAttribute('context')];
    const selectionAxis = this._getSelectionAxis(resizingElementAxis);
    if (
      this.m_selection &&
      this.m_selection.length &&
      allowResizeWithinSelection &&
      !this.m_discontiguousSelection &&
      this._isHeaderSelected(context, selectionAxis)
    ) {
      this.m_selection.forEach((selection) => {
        const selectedHeaders = this._getHeadersWithinSelection(
          selection,
          selection.startIndex[selectionAxis],
          resizingElementAxis
        );
        selectedHeaders.forEach((header) => selectedHeadersSet.add(header));
      });
    }
    if (selectedHeadersSet.size !== 0) {
      selectedHeadersSet.forEach((currentHeader) => {
        let currentHeaderContext = currentHeader[this.getResources().getMappedAttribute('context')];
        let currentHeaderIndex = currentHeaderContext.index;
        let currentHeaderKey = currentHeaderContext.key;
        let dimensionValue = resizeHeaderMode === 'column' ? newWidth : newHeight;
        let dimension = resizeHeaderMode === 'column' ? 'width' : 'height';
        if (resizingElement !== currentHeader) {
          this.m_resizingElement = currentHeader;
          let elementDir = this.getElementDir(currentHeader, dimension);
          if (this.isHidden(resizeHeaderMode, currentHeaderIndex)) {
            this.m_sizingManager.setSize(resizeHeaderMode, currentHeaderKey, dimensionValue);
            dimensionValue = 0;
          }
          if (resizeHeaderMode === 'column') {
            this.resizeColWidth(elementDir, dimensionValue);
          } else {
            this.resizeRowHeight(elementDir, dimensionValue);
          }
        }

        // set the information we want to callback with in the resize event and callback
        this._fireResizeEvent(event, oldWidth, oldHeight, newWidth, newHeight, size);
      });
    } else {
      if (resizeHeaderMode === 'column') {
        this.resizeColWidth(this.getElementDir(this.m_resizingElement, 'width'), newWidth);
      } else {
        this.resizeRowHeight(this.getElementDir(this.m_resizingElement, 'height'), newHeight);
      }
      this._fireResizeEvent(event, oldWidth, oldHeight, newWidth, newHeight, size);
    }
    this._fireCellResizeEvent(event, oldWidth, oldHeight, newWidth, newHeight, selectedHeadersSet);
  };

  /**
   * Returns the selection axis for a header.
   * @param {'row' | 'rowEnd' | 'column' | 'columnEnd'} resizingElementAxis - region where resize happened
   * @return {'row' | 'column'} selection axis
   */
  DvtDataGrid.prototype._getSelectionAxis = function (resizingElementAxis) {
    let selectionAxis = resizingElementAxis;
    if (selectionAxis === 'rowEnd') {
      selectionAxis = 'row';
    } else if (selectionAxis === 'columnEnd') {
      selectionAxis = 'column';
    }
    return selectionAxis;
  };

  DvtDataGrid.prototype._fireCellResizeEvent = function (
    event,
    oldWidth,
    oldHeight,
    newWidth,
    newHeight,
    selectedHeadersSet
  ) {
    const details = {
      event: event,
      ui: {}
    };
    let dimension;
    const resizeHeaderMode = this._getResizeHeaderMode(this.m_resizingElement);
    const resizingElementIndex = this.getHeaderCellIndex(this.m_resizingElement);
    const resizingElementLevel = this.getHeaderCellLevel(this.m_resizingElement);
    const resizingElementAxis = this.getHeaderCellAxis(this.m_resizingElement);
    const isHeaderLabel = this.find(this.m_resizingElement, 'headerlabel');
    const context = this.m_resizingElement[this.getResources().getMappedAttribute('context')];
    let allowResizeWithinSelection = false;
    if (
      (resizingElementAxis === 'column' &&
        resizingElementLevel === this.m_columnHeaderLevelCount - 1) ||
      (resizingElementAxis === 'row' && resizingElementLevel === this.m_rowHeaderLevelCount - 1) ||
      (resizingElementAxis === 'columnEnd' &&
        resizingElementLevel === this.m_columnEndHeaderLevelCount - 1) ||
      (resizingElementAxis === 'rowEnd' && resizingElementLevel === this.m_rowEndHeaderLevelCount - 1)
    ) {
      allowResizeWithinSelection = true;
    }
    if (newWidth !== oldWidth) {
      if ((resizeHeaderMode === 'column' || resizeHeaderMode === 'columnEnd') && !isHeaderLabel) {
        // index based
        dimension = 'columnWidth';
        details.ui.size = this.getElementWidth(
          this._getHeaderByIndex(
            resizingElementIndex + context.extent - 1,
            'column',
            this.m_columnHeaderLevelCount - 1
          )
        );
      } else if (isHeaderLabel) {
        let isRowEndHeaderLabel = this.m_utils.containsCSSClassName(
          this.m_resizingElement,
          this.getMappedStyle('rowendheaderlabel')
        );
        dimension = isRowEndHeaderLabel ? 'rowEndHeaderWidth' : 'rowHeaderWidth';
        details.ui.levels = [
          resizeHeaderMode.includes('row') ? context.level : this.m_rowHeaderLevelCount - 1
        ];
        details.ui.size = newWidth;
      } else {
        let isRowEndHeader = this.m_utils.containsCSSClassName(
          this.m_resizingElement,
          this.getMappedStyle('rowendheadercell')
        );
        dimension = isRowEndHeader ? 'rowEndHeaderWidth' : 'rowHeaderWidth';
        details.ui.levels = [context.level + context.depth - 1];
        details.ui.size = isRowEndHeader
          ? this.m_rowEndHeaderLevelWidths[context.level + context.depth - 1]
          : this.m_rowHeaderLevelWidths[context.level + context.depth - 1];
      }
      details.ui.dimension = dimension;
    } else if (newHeight !== oldHeight) {
      if ((resizeHeaderMode === 'row' || resizeHeaderMode === 'rowEnd') && !isHeaderLabel) {
        // index based
        dimension = 'rowHeight';
        details.ui.size = this.getElementHeight(
          this._getHeaderByIndex(
            resizingElementIndex + context.extent - 1,
            'row',
            this.m_rowHeaderLevelCount - 1
          )
        );
      } else if (isHeaderLabel) {
        let isColumnEndHeaderLabel = this.m_utils.containsCSSClassName(
          this.m_resizingElement,
          this.getMappedStyle('columnendheaderlabel')
        );
        dimension = isColumnEndHeaderLabel ? 'columnEndHeaderHeight' : 'columnHeaderHeight';
        details.ui.levels = [
          resizeHeaderMode.includes('column') ? context.level : this.m_columnHeaderLevelCount - 1
        ];
        details.ui.size = newHeight;
      } else {
        let isColumnEndHeader = this.m_utils.containsCSSClassName(
          this.m_resizingElement,
          this.getMappedStyle('colendheadercell')
        );
        dimension = isColumnEndHeader ? 'columnEndHeaderHeight' : 'columnHeaderHeight';
        details.ui.levels = [context.level + context.depth - 1];
        details.ui.size = isColumnEndHeader
          ? this.m_columnEndHeaderLevelHeights[context.level + context.depth - 1]
          : this.m_columnHeaderLevelHeights[context.level + context.depth - 1];
      }
      details.ui.dimension = dimension;
    } else {
      return;
    }
    const selectionAxis = this._getSelectionAxis(resizingElementAxis);
    if (
      this.m_selection &&
      this.m_selection.length &&
      allowResizeWithinSelection &&
      !this.m_discontiguousSelection &&
      (dimension === 'rowHeight' || dimension === 'columnWidth')
    ) {
      const indices = [];
      if (!this._isHeaderSelected(context, selectionAxis)) {
        indices.push(resizingElementIndex + context.extent - 1);
      } else {
        selectedHeadersSet.forEach((header) => {
          const headerContext = header[this.getResources().getMappedAttribute('context')];
          indices.push(this.getHeaderCellIndex(header) + headerContext.extent - 1);
        });
      }
      details.ui.indices = indices;
    } else if (dimension === 'rowHeight' || dimension === 'columnWidth') {
      details.ui.indices = [];
      details.ui.indices.push(resizingElementIndex + context.extent - 1);
    }
    this.fireEvent('cellResize', details);
  };

  DvtDataGrid.prototype._fireResizeEvent = function (
    event,
    oldWidth,
    oldHeight,
    newWidth,
    newHeight,
    size
  ) {
    let details = {
      event: event,
      ui: {
        header: this._getKey(this.m_resizingElement),
        oldDimensions: {
          width: oldWidth,
          height: oldHeight
        },
        newDimensions: {
          width: newWidth,
          height: newHeight
        },
        // deprecating this part in 2.1.0
        size: size
      }
    };
    this.fireEvent('resize', details);
  };

  /**
   * On mouseup, if we were resizing, handle cursor and callback firing.
   * @param {Event} event - a mouseup event
   */
  DvtDataGrid.prototype.handleResizeMouseUp = function (event) {
    if (this.m_isResizing === true) {
      var newWidth = this.getElementWidth(this.m_resizingElement);
      var newHeight = this.getElementHeight(this.m_resizingElement);
      let oldWidth = this.m_orginalResizeDimensions.width;
      let oldHeight = this.m_orginalResizeDimensions.height;
      let resizingElement = this.m_resizingElement;
      let size =
        this.m_cursor === 'col-resize' ? resizingElement.style.width : resizingElement.style.height;
      if (
        newWidth !== this.m_orginalResizeDimensions.width ||
        newHeight !== this.m_orginalResizeDimensions.height
      ) {
        if (this.m_cursor === 'col-resize' || this.m_cursor === 'row-resize') {
          this._resizeSelectedHeaders(event, oldWidth, oldHeight, newWidth, newHeight, size);
        }
      }

      resizingElement.style.cursor = '';
      this._unhighlightResizeBorderColor();
      // no longer resizing
      this.m_isResizing = false;
      this.m_cursor = 'default';
      if (this.m_resizingElementSibling != null) {
        this.m_resizingElementSibling.style.cursor = '';
      }

      this.m_resizingElement = null;
      this.m_resizingElementMin = null;
      this.m_resizingElementSibling = null;
      this.m_orginalResizeDimensions = null;

      document.removeEventListener('mousemove', this.m_docMouseMoveListener, false);
      document.removeEventListener('mouseup', this.m_docMouseUpListener, false);
      // unregister all listeners
    }
  };

  /**
   * Check if has data-resizable attribute is set to 'true' on a header
   * @param {Element|undefined|null} element - element to check if has data-resizable true
   * @return {boolean} true if data-resizable attribute is 'true'
   */
  DvtDataGrid.prototype._isDOMElementResizable = function (element) {
    if (element == null) {
      return false;
    }
    return element.getAttribute(this.getResources().getMappedAttribute('resizable')) === 'true';
  };

  /**
   * Determine what the document cursor should be for header cells.
   * @param {Event} event - a mousemove event
   * @return {string} the cursor type for a given mouse location
   */
  DvtDataGrid.prototype.manageHeaderCursor = function (event, isLabel) {
    var cursorX;
    var cursorY;
    var offsetPixel;
    var widthResizable;
    var heightResizable;
    var siblingResizable;
    var sibling;
    var parent;

    // determine the element/header type that should be used for resizing if applicable
    var elem;
    elem = isLabel ? this.find(event.target, 'headerlabel') : this.find(event.target, 'headercell');
    if (!elem && !isLabel) {
      elem = this.find(event.target, 'endheadercell');
    }

    if (!elem) {
      return 'default';
    }

    var resizeHeaderMode = isLabel ? this.getHeaderLabelAxis(elem) : this.getHeaderCellAxis(elem);
    var index = isLabel ? this.getHeaderLabelLevel(elem) : this.getHeaderCellIndex(elem);
    var level = isLabel ? index : this.getHeaderCellLevel(elem);

    if (resizeHeaderMode === 'column') {
      heightResizable = this.m_options.isResizable(resizeHeaderMode, 'height') === 'enable';
      widthResizable = this._isDOMElementResizable(elem);
      // previous is the previous index same level
      if (!isLabel) {
        let previousIndex = this.getVisibleCellIndexInDirection('column', index - 1, { left: true });
        sibling = this._getHeaderByIndex(previousIndex, 'column', level);
        if (!sibling) {
          if (this.m_headerLabels.column.length) {
            sibling = this._getLabel('column', level);
            if (level === this.m_columnHeaderLevelCount - 1 && this._isHeaderLabelCollision()) {
              sibling = this.m_headerLabels.row[this.m_rowHeaderLevelCount - 1];
            }
          } else {
            sibling = this._getLabel('row', level);
          }
        }
        siblingResizable = this._isDOMElementResizable(sibling);
        // parent is the previous level the same index
        parent = this._getHeaderByIndex(index, 'column', level - 1);
      } else {
        sibling = null;
        siblingResizable = null;
        parent = this.m_headerLabels.column[index - 1];
      }
    } else if (resizeHeaderMode === 'row') {
      widthResizable = this.m_options.isResizable(resizeHeaderMode, 'width') === 'enable';
      if (isLabel) {
        heightResizable = this.m_options.isResizable(resizeHeaderMode, 'height') === 'enable';
      } else {
        heightResizable = this._isDOMElementResizable(elem);
      }
      // previous is the previous index same level
      if (!isLabel) {
        sibling = this._getHeaderByIndex(index - 1, 'row', level);
        siblingResizable = this._isDOMElementResizable(sibling);
        // parent is the previous level the same index
        parent = this._getHeaderByIndex(index, 'row', level - 1);
      } else {
        parent = this.m_headerLabels.row[index - 1];
        // parent is the previous level the same index
        if (
          this._isHeaderLabelCollision() &&
          elem === this.m_headerLabels.row[this.m_rowHeaderLevelCount - 1]
        ) {
          sibling = this.m_headerLabels.column[this.m_columnHeaderLevelCount - 1];
        }
      }
    } else if (resizeHeaderMode === 'columnEnd') {
      heightResizable = this.m_options.isResizable(resizeHeaderMode).height === 'enable';
      widthResizable = this._isDOMElementResizable(elem);
      // previous is the previous index same level
      if (!isLabel) {
        let previousIndex = this.getVisibleCellIndexInDirection('column', index - 1, { left: true });
        sibling = this._getHeaderByIndex(previousIndex, 'columnEnd', level);
        if (!sibling) {
          sibling = this._getLabel('columnEnd', level);
        }
        siblingResizable = this._isDOMElementResizable(sibling);
        // parent is the previous level the same index
        parent = this._getHeaderByIndex(index, 'columnEnd', level - 1);
      } else {
        sibling = null;
        siblingResizable = null;
        parent = this.m_headerLabels.columnEnd[index - 1];
      }
    } else if (resizeHeaderMode === 'rowEnd') {
      widthResizable = this.m_options.isResizable(resizeHeaderMode).width === 'enable';
      heightResizable = this._isDOMElementResizable(elem);
      // previous is the previous index same level
      if (!isLabel) {
        sibling = this._getHeaderByIndex(index - 1, 'rowEnd', level);
        siblingResizable = this._isDOMElementResizable(sibling);
        // parent is the previous level the same index
        parent = this._getHeaderByIndex(index, 'rowEnd', level - 1);
      } else {
        sibling = this.m_headerLabels.rowEnd[index - 1];
        siblingResizable = this._isDOMElementResizable(sibling);
      }
    }

    // touch requires an area 24px for touch gestures
    if (this.m_utils.isTouchDevice()) {
      cursorX = event.touches[0].pageX;
      cursorY = event.touches[0].pageY;
      offsetPixel = DvtDataGrid.RESIZE_TOUCH_OFFSET;
    } else {
      cursorX = event.offsetX;
      cursorY = event.offsetY;
      offsetPixel = DvtDataGrid.RESIZE_OFFSET;
      var headerOffset = this._findHeaderOffset(event.target, elem);
      cursorX += headerOffset[0];
      cursorY += headerOffset[1];
    }

    var edges = this.getHeaderEdgePixels(elem);
    var rtl = this.getResources().isRTLMode();
    var end = resizeHeaderMode === 'columnEnd' || resizeHeaderMode === 'rowEnd';

    var leftEdgeCheck = cursorX < edges[0] + offsetPixel;
    var topEdgeCheck = cursorY < edges[1] + offsetPixel;
    var rightEdgeCheck = cursorX > edges[2] - offsetPixel;
    var bottomEdgeCheck = cursorY > edges[3] - offsetPixel;

    // check to see if resizable was enabled on the grid and then check the position of the cursor to the element border
    // we always choose the element preceding the border (so for rows the header before the bottom border)
    if (resizeHeaderMode === 'column' || resizeHeaderMode === 'columnEnd') {
      // can we resize the width of this header
      if (widthResizable && (rtl ? leftEdgeCheck : rightEdgeCheck)) {
        this.m_resizingElement = elem;
        return 'col-resize';
      } else if (siblingResizable && (rtl ? rightEdgeCheck : leftEdgeCheck)) {
        // can we resize the width of the previous header
        this.m_resizingElement = sibling;
        this.m_resizingElementSibling = elem;
        if (this.m_resizingElement !== null) {
          return 'col-resize';
        }
      } else if (heightResizable) {
        // can we resize the height of this header
        if ((!end && bottomEdgeCheck) || (end && topEdgeCheck)) {
          this.m_resizingElement = elem;
          return 'row-resize';
        } else if (((!end && topEdgeCheck) || (end && bottomEdgeCheck)) && level !== 0) {
          // can we resize the height of the parent header
          this.m_resizingElement = parent;
          this.m_resizingElementSibling = elem;
          return 'row-resize';
        }
      }
    } else if (resizeHeaderMode === 'row' || resizeHeaderMode === 'rowEnd') {
      if (heightResizable && bottomEdgeCheck) {
        this.m_resizingElement = elem;
        return 'row-resize';
      } else if (siblingResizable && topEdgeCheck && !isLabel) {
        this.m_resizingElement = sibling;
        this.m_resizingElementSibling = elem;
        if (this.m_resizingElement !== null) {
          return 'row-resize';
        }
      } else if (parent && topEdgeCheck && isLabel && sibling) {
        this.m_resizingElement = parent;
        this.m_resizingElementSibling = elem;
        if (this.m_resizingElement !== null) {
          return 'row-resize';
        }
      }
      if (widthResizable) {
        if (
          (!end && (rtl ? leftEdgeCheck : rightEdgeCheck)) ||
          (end && (rtl ? rightEdgeCheck : leftEdgeCheck))
        ) {
          this.m_resizingElement = elem;
          return 'col-resize';
        } else if (
          ((!end && (rtl ? rightEdgeCheck : leftEdgeCheck)) ||
            (end && (rtl ? leftEdgeCheck : rightEdgeCheck))) &&
          level !== 0
        ) {
          this.m_resizingElement = parent;
          this.m_resizingElementSibling = elem;
          if (this.m_resizingElement !== null) {
            return 'col-resize';
          }
        }
      }
    }
    return 'default';
  };

  /**
   * On mousemove see which type of resizing we are doing and call the appropriate resizer after calculating
   * the new elements width based on current and last X and Y page coordinates.
   * @param {Event} event - a mousemove event
   */
  DvtDataGrid.prototype.handleResizeMouseMove = function (event) {
    var resizeHeaderMode;
    var oldElementWidth;
    var newElementWidth;
    var oldElementHeight;
    var newElementHeight;

    // update stored mouse position
    this.m_currentMouseX = event.pageX;
    this.m_currentMouseY = event.pageY;

    if (this.m_utils.isTouchDevice()) {
      this.m_currentMouseX = event.touches[0].pageX;
      this.m_currentMouseY = event.touches[0].pageY;
    } else {
      this.m_currentMouseX = event.pageX;
      this.m_currentMouseY = event.pageY;
    }

    // check to see if we are resizing a column or row
    resizeHeaderMode = this._getResizeHeaderMode(this.m_resizingElement);

    var end =
      this.m_utils.containsCSSClassName(
        this.m_resizingElement,
        this.getMappedStyle('endheadercell')
      ) ||
      this.m_utils.containsCSSClassName(
        this.m_resizingElement,
        this.getMappedStyle('columnendheaderlabel')
      );
    let isHeaderLabel = this.find(this.m_resizingElement, 'headerlabel');
    // handle width resizing for columns/rows
    if (this.m_cursor === 'col-resize') {
      if (resizeHeaderMode === 'column') {
        end = isHeaderLabel ? false : end;
        oldElementWidth = this.getElementWidth(this.m_resizingElement);
        newElementWidth = this.getNewElementWidth(
          'column',
          oldElementWidth,
          end,
          null,
          isHeaderLabel
        );

        if (isHeaderLabel) {
          this.resizeRowWidth(newElementWidth, newElementWidth - oldElementWidth, end, isHeaderLabel);
        } else {
          this.resizeColWidth(oldElementWidth, newElementWidth);
        }
      } else if (resizeHeaderMode === 'row') {
        if (
          this.m_utils.containsCSSClassName(
            this.m_resizingElement,
            this.getMappedStyle('rowendheaderlabel')
          )
        ) {
          end = true;
        }
        oldElementWidth = this.getElementWidth(this.m_resizingElement);
        newElementWidth = this.getNewElementWidth('row', oldElementWidth, end, null, isHeaderLabel);

        this.resizeRowWidth(newElementWidth, newElementWidth - oldElementWidth, end, isHeaderLabel);
      }
    } else if (this.m_cursor === 'row-resize') {
      // handle height resizing for columns/rows
      if (resizeHeaderMode === 'row') {
        oldElementHeight = this.getElementHeight(this.m_resizingElement);
        newElementHeight = this.getNewElementHeight(
          'row',
          oldElementHeight,
          end,
          null,
          isHeaderLabel
        );

        if (isHeaderLabel) {
          this.resizeColHeight(newElementHeight, newElementHeight - oldElementHeight, end);
        } else {
          this.resizeRowHeight(oldElementHeight, newElementHeight);
        }
      } else if (resizeHeaderMode === 'column') {
        oldElementHeight = this.getElementHeight(this.m_resizingElement);
        newElementHeight = this.getNewElementHeight(
          'column',
          oldElementHeight,
          end,
          null,
          isHeaderLabel
        );
        this.resizeColHeight(newElementHeight, newElementHeight - oldElementHeight, end);
      }
    }

    // rebuild the corners
    this.buildCorners();

    // re-align touch affordances
    if (this.m_utils.isTouchDevice()) {
      this._moveTouchSelectionAffordance();
    }

    // update the last mouse X/Y
    this.m_lastMouseX = this.m_currentMouseX;
    this.m_lastMouseY = this.m_currentMouseY;
  };

  /**
   * Resize the width of column headers, and the column cells. Also resize the
   * scroller and databody accordingly. Set the left(or right) style value on all
   * cells/columns following(preceeding) the resizing element. Update the end
   * column pixel as well.
   * @param {number} oldElementWidth - the elements width prior to resizing
   * @param {number} newElementWidth - the elements width after resizing
   */
  DvtDataGrid.prototype.resizeColWidth = function (oldElementWidth, newElementWidth) {
    var newScrollerWidth;
    var widthChange = newElementWidth - oldElementWidth;
    const dir = this.getResources().isRTLMode() ? 'right' : 'left';
    if (widthChange !== 0) {
      let isFrozenSectionResize = false;
      if (this.m_resizingElement.classList.contains(this.getMappedStyle('frozenHeader'))) {
        isFrozenSectionResize = true;
      }
      if (this.m_databody.firstChild != null && !isFrozenSectionResize) {
        let oldScrollerWidth = this.getElementWidth(this.m_databody.firstChild);
        newScrollerWidth = oldScrollerWidth + widthChange;
        this.setElementWidth(this.m_databody.firstChild, newScrollerWidth);
        if (this.m_databodyFrozenRow) {
          this.setElementWidth(this.m_databodyFrozenRow.firstChild, newScrollerWidth);
        }
      } else if (isFrozenSectionResize && this.m_databodyFrozenCol) {
        let oldScrollerWidth = this.getElementWidth(this.m_databodyFrozenCol);
        let scrollerDir = this.getElementDir(this.m_databodyFrozenCol, dir);
        if (this.m_endRowEndHeader !== -1) {
          let endHeaderDir = this.getElementDir(this.m_rowEndHeader, dir);
          let newWidth = scrollerDir + oldScrollerWidth + widthChange;
          widthChange =
            newWidth > endHeaderDir ? endHeaderDir - (scrollerDir + oldScrollerWidth) : widthChange;
        }
        newScrollerWidth = oldScrollerWidth + widthChange;
        this.setElementWidth(this.m_databodyFrozenCol, newScrollerWidth);
        this.setElementWidth(this.m_databodyFrozenCol, newScrollerWidth);
        if (this.m_databodyFrozenCorner) {
          this.setElementWidth(this.m_databodyFrozenCorner, newScrollerWidth);
          this.setElementWidth(this.m_databodyFrozenCorner, newScrollerWidth);
        }
      }

      // helper to update all elements this effects
      this.resizeColumnWidthAndShift(widthChange);
      this.deleteAndApplyHiddenIndicators();
      if (!isFrozenSectionResize) {
        this.m_endColPixel += widthChange;
        this.m_endColHeaderPixel += widthChange;
        this.m_endColEndHeaderPixel += widthChange;
        if (newScrollerWidth != null) {
          this.m_avgColWidth = newScrollerWidth / this.getDataSource().getCount('column');
        }
      }

      this.manageResizeScrollbars();
    }
  };

  /**
   * Resize the height of row headers, and the rows cells. Also resize the
   * scroller and databody accordingly. Update the end row pixel as well.
   * @param {number} oldElementHeight - the elements height prior to resizing
   * @param {number} newElementHeight - the elements height after resizing
   */
  DvtDataGrid.prototype.resizeRowHeight = function (oldElementHeight, newElementHeight) {
    var newScrollerHeight;
    var heightChange = newElementHeight - oldElementHeight;
    const dir = 'top';

    if (heightChange !== 0) {
      let isFrozenSectionResize = false;
      if (this.m_resizingElement.classList.contains(this.getMappedStyle('frozenHeader'))) {
        isFrozenSectionResize = true;
      }
      if (this.m_databody.firstChild != null && !isFrozenSectionResize) {
        let oldScrollerHeight = this.getElementHeight(this.m_databody.firstChild);
        newScrollerHeight = oldScrollerHeight + heightChange;
        this.setElementHeight(this.m_databody.firstChild, newScrollerHeight);
      } else if (isFrozenSectionResize && this.m_databodyFrozenRow) {
        let oldScrollerHeight = this.getElementHeight(this.m_databodyFrozenRow);
        let scrollerDir = this.getElementDir(this.m_databodyFrozenRow, dir);
        if (this.m_endColEndHeader !== -1) {
          let endHeaderDir = this.getElementDir(this.m_colEndHeader, dir);
          let newHeight = scrollerDir + oldScrollerHeight + heightChange;
          heightChange =
            newHeight > endHeaderDir
              ? endHeaderDir - (scrollerDir + oldScrollerHeight)
              : heightChange;
        }
        newScrollerHeight = oldScrollerHeight + heightChange;
        this.setElementHeight(this.m_databodyFrozenRow, newScrollerHeight);
        this.setElementHeight(this.m_databodyFrozenRow, newScrollerHeight);
        if (this.m_databodyFrozenCorner) {
          this.setElementHeight(this.m_databodyFrozenCorner, newScrollerHeight);
          this.setElementHeight(this.m_databodyFrozenCorner, newScrollerHeight);
        }
      }

      // set row height on the appropriate databody row, set the new value in the sizingManager
      this.resizeRowHeightAndShift(heightChange);
      this.deleteAndApplyHiddenIndicators();
      if (!isFrozenSectionResize) {
        this.m_endRowPixel += heightChange;
        this.m_endRowHeaderPixel += heightChange;
        this.m_endRowEndHeaderPixel += heightChange;
        if (newScrollerHeight != null) {
          this.m_avgRowHeight = newScrollerHeight / this.getDataSource().getCount('row');
        }
      }
      this.manageResizeScrollbars();
    }
  };

  /**
   * Resize the height of column headers. Also resize the scroller and databody
   * accordingly.
   * @param {number} newElementHeight - the column header height after resizing
   * @param {number} heightChange - the change in height
   * @param {boolean} end
   */
  DvtDataGrid.prototype.resizeColHeight = function (newElementHeight, heightChange, end) {
    if (heightChange !== 0) {
      var oldHeight;
      var level;
      var axis;
      // shift header label if there is no collision and if the resizing element
      // is not header label.
      var adjustLabel = true;
      var isHeaderLabel = this.find(this.m_resizingElement, 'headerlabel');
      if (isHeaderLabel) {
        axis = this.getHeaderLabelAxis(this.m_resizingElement);
        if (axis === 'column' || axis === 'columnEnd') {
          level = this.getHeaderLabelLevel(this.m_resizingElement);
        } else if (axis === 'row' || axis === 'rowEnd') {
          level = this.m_columnHeaderLevelCount - 1;
          adjustLabel = false;
        }
      } else {
        level =
          this.getHeaderCellLevel(this.m_resizingElement) +
          (this.getHeaderCellDepth(this.m_resizingElement) - 1);
        axis = this.getHeaderCellAxis(this.m_resizingElement);
      }
      if (end) {
        this.m_columnEndHeaderLevelHeights[level] += heightChange;
      } else {
        oldHeight = this.m_columnHeaderLevelHeights[level];
        this.m_columnHeaderLevelHeights[level] += heightChange;
      }
      if (
        !end &&
        level === this.m_columnHeaderLevelCount - 1 &&
        this.m_headerLabels.row.length &&
        this._isHeaderLabelCollision()
      ) {
        adjustLabel = false;
      }
      this.resizeColumnHeightsAndShift(heightChange, level, end, adjustLabel);

      if (!end) {
        this.m_colHeaderHeight += heightChange;
        this.setElementHeight(this.m_colHeader, this.m_colHeaderHeight);
        if (this.m_colHeaderFrozen) {
          this.setElementHeight(this.m_colHeaderFrozen, this.m_colHeaderHeight);
        }
        if (this.m_headerLabels.column.length === 0 && level !== -1) {
          this._resizeHeaderLabelDirs(level, heightChange, ['row'], 'height');
        } else if (
          this.m_columnHeaderLevelCount != null &&
          level === this.m_columnHeaderLevelCount - 1
        ) {
          if (this.m_headerLabels.row.length) {
            var rowHeightChange;
            var colHeight;
            if (isHeaderLabel) {
              if (axis === 'column') {
                colHeight = newElementHeight;
                this.m_collisionResize = true;
              } else if (axis === 'row') {
                rowHeightChange = heightChange;
                this.m_collisionResize = true;
              } else if (axis === 'rowEnd') {
                if (this._isHeaderLabelCollision()) {
                  // rowEndHeader resizing resizes the columnheader+rowHeader at the collision level
                  // newElementHeight is derived based on deducting it with height value of all
                  // columnHeaderLabels at the levels above collision level.
                  let columnHeaderLabelsHeight = 0;
                  for (let i = 0; i < this.m_columnHeaderLevelCount - 1; i++) {
                    columnHeaderLabelsHeight += this.getElementHeight(this.m_headerLabels.column[i]);
                  }
                  let newHeight = this.m_colHeaderHeight - columnHeaderLabelsHeight;
                  let dimension = this._calculateCollisionDimension(
                    newHeight,
                    oldHeight,
                    isHeaderLabel,
                    axis
                  );
                  rowHeightChange = dimension.rowHeightChange;
                  colHeight = dimension.colHeight;
                } else {
                  rowHeightChange = heightChange;
                  colHeight = this.m_colHeaderHeight;
                }
              }
            } else if (this._isHeaderLabelCollision()) {
              let dimension = this._calculateCollisionDimension(
                newElementHeight,
                oldHeight,
                true,
                axis
              );
              rowHeightChange = dimension.rowHeightChange;
              colHeight = dimension.colHeight;
            } else {
              rowHeightChange = heightChange;
              colHeight = newElementHeight;
            }

            var columnHeaderLabelZero = this._getLabel('column', this.m_columnHeaderLevelCount - 1);
            if (columnHeaderLabelZero) {
              this.setElementHeight(columnHeaderLabelZero, colHeight);
            }
            this._resizeHeaderLabelDirs(
              this.m_rowHeaderLevelCount - 1,
              rowHeightChange,
              ['row'],
              'height'
            );
          } else {
            let resizeClass = ['bottomResized'];
            let columnHeaderLabel = this._getLabel('column', this.m_columnHeaderLevelCount - 1);
            this._highlightElement(columnHeaderLabel.parentNode, resizeClass);
            // deduct newElementHeight with height of all other columnheaders above last level
            // as height changes shall affect only the last level; if resizingElement is rowEndHeaderLabel.
            let columnHeaderLabelsHeight = 0;
            if (axis === 'rowEnd') {
              for (let i = 0; i < this.m_columnHeaderLevelCount - 1; i++) {
                columnHeaderLabelsHeight += this.getElementHeight(this.m_headerLabels.column[i]);
              }
            }
            let newHeight = newElementHeight - columnHeaderLabelsHeight;
            this.setElementHeight(columnHeaderLabel, newHeight);
          }
        } else if (level < 0) {
          let rowHeaderLabel = this._getLabel('row', this.m_rowHeaderLevelCount - 1);
          let columnClass = ['bottomResized'];
          if (rowHeaderLabel && level < 0) {
            this._highlightElement(rowHeaderLabel.parentNode, columnClass);
            for (let i = 0; i < this.m_rowHeaderLevelCount; i++) {
              rowHeaderLabel = this._getLabel('row', i);
              this.setElementHeight(rowHeaderLabel, newElementHeight);
            }
          }
        }
        let rowEndHeaderLabel = this._getLabel('rowEnd', this.m_rowEndHeaderLevelCount - 1);
        let columnClass = ['bottomResized'];
        if (rowEndHeaderLabel) {
          // if columnHeader is unavailable then can assign the newElementHeight else
          // needs to be assigned with colHeaderHeight as newElementHeight need not always be equal
          // to corner height.
          let endHeaderLabelHeight =
            this.m_endColHeader === -1 ? newElementHeight : this.m_colHeaderHeight;
          this._highlightElement(rowEndHeaderLabel.parentNode, columnClass);
          for (let i = 0; i < this.m_rowEndHeaderLevelCount; i++) {
            rowEndHeaderLabel = this._getLabel('rowEnd', i);
            this.setElementHeight(rowEndHeaderLabel, endHeaderLabelHeight);
          }
        }
      } else {
        this.m_colEndHeaderHeight += heightChange;
        this.setElementHeight(this.m_colEndHeader, this.m_colEndHeaderHeight);
        if (this.m_colEndHeaderFrozen) {
          this.setElementHeight(this.m_colEndHeaderFrozen, this.m_colEndHeaderHeight);
        }
      }
      this.deleteAndApplyHiddenIndicators();
      this.manageResizeScrollbars();
    }
  };

  /**
   * Calculate dimension of the colliding rows and columns.
   * @param {number} newElementHeight - the element's height after resizing
   * @param {number} oldHeight - the element's height prior to resizing
   */
  DvtDataGrid.prototype._calculateCollisionDimension = function (
    newElementHeight,
    oldHeight,
    isHeaderLabel,
    axis
  ) {
    let dimension = {};
    let rowHeightChange;
    let colHeight;
    let minHeightValue = this._getMinValue('height', axis, isHeaderLabel);
    if (this.m_collisionResize) {
      let collisionRowHeight = this.getElementDir(
        this.m_headerLabels.row[this.m_rowHeaderLevelCount - 1],
        'height'
      );
      let collisionColumnHeight = this.getElementDir(
        this.m_headerLabels.column[this.m_columnHeaderLevelCount - 1],
        'height'
      );
      let totalHeight = collisionRowHeight + collisionColumnHeight;
      let columnPercentage = collisionColumnHeight / totalHeight;
      let rowPercentage = collisionRowHeight / totalHeight;
      if (collisionRowHeight === minHeightValue && collisionColumnHeight === minHeightValue) {
        rowHeightChange = Math.floor(newElementHeight / 2) - Math.floor(oldHeight / 2);
        colHeight = Math.ceil(newElementHeight / 2);
        this.m_collisionResize = false;
      } else if (columnPercentage > rowPercentage) {
        colHeight = Math.floor(newElementHeight * columnPercentage);
        rowHeightChange = newElementHeight - colHeight - collisionRowHeight;
        if (collisionRowHeight + rowHeightChange < this._getMinValue('height', axis, isHeaderLabel)) {
          rowHeightChange = 0;
        }
      } else {
        rowHeightChange = Math.floor(newElementHeight * rowPercentage) - collisionRowHeight;
        if (collisionRowHeight + rowHeightChange < this._getMinValue('height', axis, isHeaderLabel)) {
          rowHeightChange = 0;
        }
        colHeight = newElementHeight - (collisionRowHeight + rowHeightChange);
        colHeight = Math.max(colHeight, this._getMinValue('height', axis, isHeaderLabel));
      }
    } else {
      rowHeightChange = Math.floor(newElementHeight / 2) - Math.floor(oldHeight / 2);
      colHeight = Math.ceil(newElementHeight / 2);
    }
    dimension.colHeight = colHeight;
    dimension.rowHeightChange = rowHeightChange;
    return dimension;
  };

  /**
   * Resize the width of row headers. Also resize the scroller and databody
   * accordingly.
   * @param {number} newElementWidth - the row header width after resizing
   * @param {number} widthChange - the change in width
   * @param {boolean} end
   */
  DvtDataGrid.prototype.resizeRowWidth = function (newElementWidth, widthChange, end, isHeaderLabel) {
    if (widthChange !== 0) {
      var level;
      if (isHeaderLabel) {
        let axis = this.getHeaderLabelAxis(this.m_resizingElement);
        if (axis === 'column' || axis === 'columnEnd') {
          level = this.m_rowHeaderLevelCount - 1;
        } else if (axis === 'row' || axis === 'rowEnd') {
          level = this.getHeaderLabelLevel(this.m_resizingElement);
        }
      } else {
        level =
          this.getHeaderCellLevel(this.m_resizingElement) +
          (this.getHeaderCellDepth(this.m_resizingElement) - 1);
      }

      if (end) {
        this.m_rowEndHeaderLevelWidths[level] += widthChange;
      } else {
        this.m_rowHeaderLevelWidths[level] += widthChange;
      }
      this.resizeRowWidthsAndShift(widthChange, level, end);

      if (!end) {
        this.m_rowHeaderWidth += widthChange;
        // no row headers
        if (level < 0) {
          let rowClass = this.getResources().isRTLMode() ? ['startResized'] : ['endResized'];
          let columnHeaderLabel = this._getLabel('column', this.m_columnHeaderLevelCount - 1);
          this._highlightElement(columnHeaderLabel.parentNode, rowClass);
          for (let i = 0; i < this.m_columnHeaderLevelCount; i++) {
            columnHeaderLabel = this._getLabel('column', i);
            this.setElementWidth(columnHeaderLabel, newElementWidth);
          }
        } else {
          this.setElementWidth(this.m_rowHeader, this.m_rowHeaderWidth);
          if (this.m_rowHeaderFrozen) {
            this.setElementWidth(this.m_rowHeaderFrozen, this.m_rowHeaderWidth);
          }
          if (
            level === this.m_rowHeaderLevelCount - 1 ||
            (this.m_headerLabels.row.length === 0 && this.m_headerLabels.column.length)
          ) {
            this._resizeHeaderLabelDirs(level, widthChange, ['column'], 'width');
          }
        }
        let columnEndHeaderLabel = this._getLabel('columnEnd', this.m_columnEndHeaderLevelCount - 1);
        let rowClass = this.getResources().isRTLMode() ? ['startResized'] : ['endResized'];
        if (columnEndHeaderLabel) {
          this._highlightElement(columnEndHeaderLabel.parentNode, rowClass);
          let endHeaderLabelWidth = this.getElementWidth(columnEndHeaderLabel) + widthChange;
          for (let i = 0; i < this.m_columnEndHeaderLevelCount; i++) {
            columnEndHeaderLabel = this._getLabel('columnEnd', i);
            this.setElementWidth(columnEndHeaderLabel, endHeaderLabelWidth);
          }
        }
      } else {
        this.m_rowEndHeaderWidth += widthChange;
        this.setElementWidth(this.m_rowEndHeader, this.m_rowEndHeaderWidth);
        if (this.m_rowEndHeaderFrozen) {
          this.setElementWidth(this.m_rowEndHeaderFrozen, this.m_rowEndHeaderWidth);
        }
      }
      this.deleteAndApplyHiddenIndicators();
      this.manageResizeScrollbars();
    }
  };

  DvtDataGrid.prototype._resizeHeaderLabelDirs = function (level, dimensionChange, axes, dir) {
    for (var j = 0; j < axes.length; j++) {
      var axis = axes[j];
      for (var i = 0; i < this.m_headerLabels[axis].length; i++) {
        var label = this.m_headerLabels[axis][i];
        if (label != null) {
          var newDir = this.getElementDir(label, dir) + dimensionChange;
          this.setElementDir(label, newDir, dir);
        }
      }
      this._highlightResizeLabelDirs(axis, level);
    }
  };

  DvtDataGrid.prototype._highlightResizeLabelDirs = function (axis, level) {
    let rowClass = this.getResources().isRTLMode() ? ['startResized'] : ['endResized'];
    let classArray = axis === 'column' ? rowClass : ['bottomResized'];
    if (
      this.m_corner &&
      ((axis === 'column' && level === this.m_columnHeaderLevelCount - 1) ||
        (axis === 'row' && level === this.m_rowHeaderLevelCount - 1))
    ) {
      this._highlightElement(this.m_corner, classArray);
    }
    let endRowHeaderLabel = this._getLabel('rowEnd', this.m_columnHeaderLevelCount - 1);
    if (endRowHeaderLabel) {
      this._highlightElement(endRowHeaderLabel.parentNode, classArray);
    }
  };
  /**
   * Unhighlight Resize border color.
   */
  DvtDataGrid.prototype._unhighlightResizeBorderColor = function () {
    let elems = this.m_root.querySelectorAll(`.oj-datagrid-resized-start,
    .oj-datagrid-resized-end, .oj-datagrid-resized-top, .oj-datagrid-resized-bottom`);
    this._unhighlightElementsByClassName(elems, [
      'startResized',
      'endResized',
      'topResized',
      'bottomResized'
    ]);
  };

  /**
   * Determine what the new element width should be based on minimum values.
   * Accounts for the overshoot potential of passing up the boundaries set.
   * @param {string} axis - the axis along which we need a new width
   * @param {number} oldElementWidth - the element width prior to resizing
   * @param {boolean} end
   * @param {number=} deltaWidth
   * @return {number} the element width after resizing
   */
  DvtDataGrid.prototype.getNewElementWidth = function (
    axis,
    oldElementWidth,
    end,
    deltaWidth,
    isHeaderLabel
  ) {
    // to account for the 24px resizing width
    const minWidth = this._getResizeMinWidth(axis, this.m_resizingElement, isHeaderLabel, false);
    if (deltaWidth == null) {
      // eslint-disable-next-line no-param-reassign
      deltaWidth = this.getResources().isRTLMode()
        ? this.m_lastMouseX - this.m_currentMouseX
        : this.m_currentMouseX - this.m_lastMouseX;
    }

    if (end && axis === 'row') {
      // eslint-disable-next-line no-param-reassign
      deltaWidth *= -1;
    }
    var newElementWidth =
      oldElementWidth +
      deltaWidth +
      this.m_overResizeLeft +
      this.m_overResizeMinLeft +
      this.m_overResizeRight;

    // check to make sure the element exceeds the minimum width
    if (newElementWidth < minWidth) {
      this.m_overResizeMinLeft += deltaWidth - minWidth + oldElementWidth;
      newElementWidth = minWidth;
    } else {
      this.m_overResizeMinLeft = 0;
      this.m_overResizeLeft = 0;
    }
    // check to make sure row header width don't exceed half of the grid width
    if (axis === 'row') {
      const maxHeaderWidth = this._getResizeMaxWidth(oldElementWidth);
      if (newElementWidth > maxHeaderWidth) {
        this.m_overResizeRight += deltaWidth - maxHeaderWidth + oldElementWidth;
        newElementWidth = maxHeaderWidth;
      } else {
        this.m_overResizeRight = 0;
      }
    }
    return newElementWidth;
  };

  /**
   * Calculates min width resize should be limited to.
   * @param {string} axis axis string
   * @param {Element} elem optional element that is being resized
   * @param {boolean} isHeaderLabel boolean if this is header label
   * @param {boolean} isCell boolean if this is cell
   * @return {number}
   */
  DvtDataGrid.prototype._getResizeMinWidth = function (axis, elem, isHeaderLabel, isCell) {
    return this._getMinValue('width', axis, isHeaderLabel, isCell, elem);
  };

  /**
   * Calculates max width resize should be limited to.
   * @param {number} oldElementWidth width of old element
   * @return {number}
   */
  DvtDataGrid.prototype._getResizeMaxWidth = function (oldElementWidth) {
    // this is the total width of the other headers (nested/end/start)
    const otherHeadersWidth =
      this.getRowHeaderWidth() + this.getRowEndHeaderWidth() - oldElementWidth;
    // allow headers to grow to entire grid minus scroller and extra header area, minus 1 to make sure some databody is shown
    return Math.round(this.getWidth() - this.m_utils.getScrollbarSize() - 1) - otherHeadersWidth;
  };

  /**
   * Determine what the new element height should be based on minimum values.
   * Accounts for the overshoot potential of passing up the boundries set.
   * @param {string} axis - the axis along which we need a new width
   * @param {number} oldElementHeight - the element height prior to resizing
   * @param {boolean} end
   * @param {number=} deltaHeight
   * @return {number} the element height after resizing
   */
  DvtDataGrid.prototype.getNewElementHeight = function (
    axis,
    oldElementHeight,
    end,
    deltaHeight,
    isHeaderLabel
  ) {
    const minHeight = this._getResizeMinHeight(
      axis,
      this.m_resizingElement,
      isHeaderLabel,
      false,
      end
    );
    if (deltaHeight == null) {
      // eslint-disable-next-line no-param-reassign
      deltaHeight = this.m_currentMouseY - this.m_lastMouseY;
    }
    if (end && axis === 'column') {
      // eslint-disable-next-line no-param-reassign
      deltaHeight *= -1;
    }
    var newElementHeight =
      oldElementHeight +
      deltaHeight +
      this.m_overResizeTop +
      this.m_overResizeMinTop +
      this.m_overResizeBottom;

    // Check to make sure the element height exceeds the minimum height
    if (newElementHeight < minHeight) {
      this.m_overResizeMinTop += deltaHeight - minHeight + oldElementHeight;
      newElementHeight = minHeight;
    } else {
      this.m_overResizeMinTop = 0;
      this.m_overResizeTop = 0;
    }
    // check to make sure column header width don't exceed half of the grid height
    if (axis === 'column') {
      const maxHeaderHeight = this._getResizeMaxHeight(oldElementHeight);
      if (newElementHeight > maxHeaderHeight) {
        this.m_overResizeBottom += deltaHeight - maxHeaderHeight + oldElementHeight;
        newElementHeight = maxHeaderHeight;
      } else {
        this.m_overResizeBottom = 0;
      }
    }
    return newElementHeight;
  };

  /**
   * Calculates max height resize should be limited to.
   * @param {number} oldElementHeight height of old element
   * @return {number}
   */
  DvtDataGrid.prototype._getResizeMaxHeight = function (oldElementHeight) {
    var otherHeadersHeight =
      this.getColumnHeaderHeight() + this.getColumnEndHeaderHeight() - oldElementHeight;
    return Math.round(this.getHeight() - this.m_utils.getScrollbarSize() - 1) - otherHeadersHeight;
  };

  /**
   * Calculates min height resize should be limited to.
   * @param {string} axis axis string
   * @param {Element} elem element that is being resized
   * @param {boolean} isHeaderLabel boolean if this is header label
   * @param {boolean} isCell boolean if this is cell
   * @param {boolean} end is end element rowEnd/colEnd
   * @return {number}
   */
  DvtDataGrid.prototype._getResizeMinHeight = function (axis, elem, isHeaderLabel, isCell, end) {
    let minHeight = 0;
    const headerLabelMinValue = this._getMinValue('height', axis, true, isCell, elem);
    if (isHeaderLabel) {
      minHeight = headerLabelMinValue;
      if (
        this.getHeaderLabelAxis(elem) === 'rowEnd' &&
        this.m_headerLabels.column &&
        this.m_headerLabels.column.length
      ) {
        if (this._isHeaderLabelCollision()) {
          // the collision row+column label min value
          minHeight = 2 * headerLabelMinValue;
        }
        // add the column header labels' heights above the collision cells to the minValue.
        for (let i = 0; i < this.m_columnHeaderLevelCount - 1; i++) {
          minHeight += this.getElementHeight(this.m_headerLabels.column[i]);
        }
      }
    } else {
      minHeight = this._getMinValue('height', axis, isHeaderLabel, isCell, elem);
    }
    if (
      axis === 'column' &&
      !end &&
      this.getHeaderCellLevel(elem) + this.getHeaderCellDepth(elem) ===
        this.m_columnHeaderLevelCount &&
      this._isHeaderLabelCollision()
    ) {
      minHeight = 2 * headerLabelMinValue;
    }
    return minHeight;
  };

  /**
   * Determine what the minimum value for the resizing element is
   * @param {string} dimension - the width or height
   * @param {string} axis - the axis
   * @param {boolean} isHeaderLabel
   * @param {boolean} isCell
   * @param {Element} elem the element we want to operate on if provided if not default to resizing element
   * @return {number} the minimum height for the element
   * @private
   */
  DvtDataGrid.prototype._getMinValue = function (
    dimension,
    axis,
    isHeaderLabel,
    isCell,
    elem = this.m_resizingElement
  ) {
    var inner;
    var innerDimensionValue;
    var paddingBorder = this._getCellPaddingBorder(dimension, elem);
    var minCompareValue = paddingBorder;
    if (isHeaderLabel || isCell) {
      return Math.max(
        this.m_utils.isTouchDevice()
          ? 2 * DvtDataGrid.RESIZE_TOUCH_OFFSET
          : 2 * DvtDataGrid.RESIZE_OFFSET,
        minCompareValue
      );
    }
    var level = this.getHeaderCellLevel(elem);
    var depth = this.getHeaderCellDepth(elem);
    var sortable = this.getResources().getMappedAttribute('sortable');
    if (elem.getAttribute(sortable) === 'true') {
      this._setSortContainerSize(this._getSortContainer(elem), paddingBorder);
    }
    if (axis === 'column' && elem.getAttribute(sortable) === 'true') {
      minCompareValue =
        dimension === 'width' ? this.m_sortContainerWidth : this.m_sortContainerHeight;
    }
    var minValue = Math.max(
      this.m_utils.isTouchDevice()
        ? 2 * DvtDataGrid.RESIZE_TOUCH_OFFSET
        : 2 * DvtDataGrid.RESIZE_OFFSET,
      minCompareValue
    );
    if (
      (axis === 'column' &&
        (this.m_columnHeaderLevelCount === 1 ||
          (dimension === 'width' && this.m_columnHeaderLevelCount === level + 1) ||
          (dimension === 'height' && depth === 1))) ||
      (axis === 'row' && this.m_endRowHeader === -1) ||
      (axis === 'column' && this.m_endColHeader === -1) ||
      (axis === 'row' &&
        (this.m_rowHeaderLevelCount === 1 ||
          (dimension === 'height' && this.m_rowHeaderLevelCount === level + 1) ||
          (dimension === 'width' && depth === 1)))
    ) {
      return minValue;
    }

    var index = this.getHeaderCellIndex(elem);
    var extent = this._getAttribute(elem.parentNode, 'extent', true);
    var currentDimensionValue = this.getElementDir(elem, dimension);

    if (axis === 'column') {
      if (dimension === 'width') {
        let visibleInnerIndex = index + (extent - 1);
        while (this.isHidden('column', visibleInnerIndex)) {
          visibleInnerIndex -= 1;
        }
        inner = this._getHeaderByIndex(visibleInnerIndex, axis, this.m_columnHeaderLevelCount - 1);
        innerDimensionValue = this.getElementDir(inner, dimension);
      } else {
        innerDimensionValue = this._getHeaderLevelDimension(
          level + (depth - 1),
          elem,
          this.m_columnHeaderLevelHeights,
          'height',
          1
        );
      }
    } else if (axis === 'row') {
      if (dimension === 'height') {
        inner = this._getHeaderByIndex(index + (extent - 1), axis, this.m_rowHeaderLevelCount - 1);
        innerDimensionValue = this.getElementDir(inner, dimension);
      } else {
        innerDimensionValue = this._getHeaderLevelDimension(
          level + (depth - 1),
          elem,
          this.m_rowHeaderLevelWidths,
          'width',
          1
        );
      }
    }
    return currentDimensionValue - (innerDimensionValue - minValue);
  };

  DvtDataGrid.prototype._getLabelMinValue = function (dimension) {
    var elem = this.m_resizingElement;
    var paddingBorder = this._getCellPaddingBorder(dimension, elem);
    var minCompareValue = paddingBorder;
    return Math.max(
      this.m_utils.isTouchDevice()
        ? 2 * DvtDataGrid.RESIZE_TOUCH_OFFSET
        : 2 * DvtDataGrid.RESIZE_OFFSET,
      minCompareValue
    );
  };
  /**
   * Set the sort container size
   * @param {Element} elem
   * @param {Number} size
   * @returns {Number}
   */
  DvtDataGrid.prototype._setSortContainerSize = function (elem, size) {
    this.m_sortContainerWidth = this.getElementWidth(elem) + size;
    this.m_sortContainerHeight = this.getElementHeight(elem);
  };
  /**
   * Get the cell padding + border size along a certain dimenison
   * @param {string} dimension
   * @param {Element} elem
   * @returns {Number}
   */
  DvtDataGrid.prototype._getCellPaddingBorder = function (dimension, elem) {
    if (this.m_resizingElementMin == null) {
      var cssExpand = ['top', 'right', 'bottom', 'left'];
      var i = dimension === 'width' ? 1 : 0;
      var val = 0;
      var style = window.getComputedStyle(elem);
      for (; i < 4; i += 2) {
        val += parseFloat(style.getPropertyValue('padding-' + cssExpand[i]));
        val += parseFloat(style.getPropertyValue('border-' + cssExpand[i] + '-width'));
      }
      this.m_resizingElementMin = Math.round(val);
    }
    return this.m_resizingElementMin;
  };

  /**
   * Manages the databody and scroller sizing when the scrollbars are added and
   * removed scrollbars from the grid. This allows the grid container to maintain
   * size as it renders scrollbars inside rahther than out. Method mimics resizeGrid
   */
  DvtDataGrid.prototype.manageResizeScrollbars = function () {
    var width = this.getWidth();
    var height = this.getHeight();
    var colHeader = this.m_colHeader;
    var colEndHeader = this.m_colEndHeader;
    var rowHeader = this.m_rowHeader;
    var rowEndHeader = this.m_rowEndHeader;
    var databody = this.m_databody;
    var databodyScroller = databody.firstChild;
    const databodyFrozenCol = this.m_databodyFrozenCol;
    const databodyFrozenRow = this.m_databodyFrozenRow;
    let databodyFrozenColumnWidth = 0;
    let databodyFrozenRowHeight = 0;

    // cache these since they will be used in multiple places and we want to minimize reflow
    var colHeaderHeight = this.getColumnHeaderHeight();
    var colEndHeaderHeight = this.getColumnEndHeaderHeight();
    var rowHeaderWidth = this.getRowHeaderWidth();
    var rowEndHeaderWidth = this.getRowEndHeaderWidth();

    if (databodyFrozenCol) {
      databodyFrozenColumnWidth = this.getElementWidth(databodyFrozenCol);
    }
    if (databodyFrozenRow) {
      databodyFrozenRowHeight = this.getElementHeight(databodyFrozenRow);
    }

    if (this.m_endRowHeader === -1 && this.m_endColHeader !== -1) {
      let columnHeaderLabel = this._getLabel('column', this.m_columnHeaderLevelCount - 1);
      if (columnHeaderLabel) {
        rowHeaderWidth = this.getElementWidth(columnHeaderLabel);
      }
    } else if (this.m_endRowHeader !== -1 && this.m_endColHeader === -1) {
      let rowHeaderLabel = this._getLabel('row', this.m_rowHeaderLevelCount - 1);
      if (rowHeaderLabel) {
        colHeaderHeight = this.getElementHeight(rowHeaderLabel);
      }
    }
    // adjusted to make the databody wrap the databody content, and the scroller to fill the remaing part of the grid
    // this way our scrollbars are always at the edges of our viewport
    var availableHeight = height - colHeaderHeight - colEndHeaderHeight - databodyFrozenRowHeight;
    var availableWidth = width - rowHeaderWidth - rowEndHeaderWidth - databodyFrozenColumnWidth;

    var scrollbarSize = this.m_utils.getScrollbarSize();
    var dir = this.getResources().isRTLMode() ? 'right' : 'left';
    var isEmpty = this._databodyEmpty();
    var empty;

    // check if there's no data
    if (isEmpty) {
      // could be getting here in the handle resize of an empty grid
      if (this.m_empty == null) {
        empty = this._buildEmptyText();
        var emptyHeight = this.getElementHeight(empty);
        var emptyWidth = this.getElementWidth(empty);
        if (emptyHeight > this.getElementHeight(databodyScroller)) {
          this.setElementHeight(databodyScroller, emptyHeight);
        }
        if (emptyWidth > this.getElementWidth(databodyScroller)) {
          this.setElementWidth(databodyScroller, emptyWidth);
        }
        this.m_databody.firstChild.appendChild(empty);
      } else {
        empty = this.m_empty;
        this.setElementDir(empty, this.m_endColHeader >= 0 ? colHeaderHeight : 0, 'top');
      }
    }

    var databodyContentWidth = this.getElementWidth(databody.firstChild);
    var databodyContentHeight = this.getElementHeight(databody.firstChild);
    // determine which scrollbars are required, if needing one forces need of the other, allows rendering within the root div
    var isDatabodyHorizontalScrollbarRequired =
      this.isDatabodyHorizontalScrollbarRequired(availableWidth);
    var isDatabodyVerticalScrollbarRequired;

    if (isDatabodyHorizontalScrollbarRequired) {
      isDatabodyVerticalScrollbarRequired = this.isDatabodyVerticalScrollbarRequired(
        availableHeight - scrollbarSize
      );
      databody.style.overflow = 'auto';
    } else {
      isDatabodyVerticalScrollbarRequired = this.isDatabodyVerticalScrollbarRequired(availableHeight);
      if (isDatabodyVerticalScrollbarRequired) {
        isDatabodyHorizontalScrollbarRequired = this.isDatabodyHorizontalScrollbarRequired(
          availableWidth - scrollbarSize
        );
        databody.style.overflow = 'auto';
      } else {
        // for an issue where same size child causes scrollbars (similar code used in resizing already)
        databody.style.overflow = 'hidden';
      }
    }

    this.m_hasHorizontalScroller = isDatabodyHorizontalScrollbarRequired;
    this.m_hasVerticalScroller = isDatabodyVerticalScrollbarRequired;

    var databodyHeight;
    var rowHeaderHeight;
    if (this.m_endColEndHeader !== -1) {
      databodyHeight = Math.min(
        databodyContentHeight + (isDatabodyHorizontalScrollbarRequired ? scrollbarSize : 0),
        availableHeight
      );
      rowHeaderHeight = isDatabodyHorizontalScrollbarRequired
        ? databodyHeight - scrollbarSize
        : databodyHeight;
    } else {
      databodyHeight = availableHeight;
      rowHeaderHeight = Math.min(
        databodyContentHeight,
        isDatabodyHorizontalScrollbarRequired ? databodyHeight - scrollbarSize : databodyHeight
      );
    }

    var databodyWidth;
    var columnHeaderWidth;

    if (this.m_endRowEndHeader !== -1) {
      databodyWidth = Math.min(
        databodyContentWidth + (isDatabodyVerticalScrollbarRequired ? scrollbarSize : 0),
        availableWidth
      );
      columnHeaderWidth = isDatabodyVerticalScrollbarRequired
        ? databodyWidth - scrollbarSize
        : databodyWidth;
    } else {
      databodyWidth = availableWidth;
      columnHeaderWidth = Math.min(
        databodyContentWidth,
        isDatabodyVerticalScrollbarRequired ? databodyWidth - scrollbarSize : databodyWidth
      );
    }

    var rowEndHeaderDir =
      rowHeaderWidth +
      columnHeaderWidth +
      databodyFrozenColumnWidth +
      (isDatabodyVerticalScrollbarRequired ? scrollbarSize : 0);
    var columnEndHeaderDir =
      colHeaderHeight +
      rowHeaderHeight +
      databodyFrozenRowHeight +
      (isDatabodyHorizontalScrollbarRequired ? scrollbarSize : 0);

    this.setElementDir(rowHeader, 0, dir);
    this.setElementDir(rowHeader, colHeaderHeight, 'top');
    this.setElementHeight(rowHeader, rowHeaderHeight);

    this.setElementDir(rowEndHeader, rowEndHeaderDir, dir);
    this.setElementDir(rowEndHeader, colHeaderHeight, 'top');
    this.setElementHeight(rowEndHeader, rowHeaderHeight);

    this.setElementDir(colHeader, rowHeaderWidth, dir);
    this.setElementWidth(colHeader, columnHeaderWidth);

    this.setElementDir(colEndHeader, rowHeaderWidth, dir);
    this.setElementDir(colEndHeader, columnEndHeaderDir, 'top');
    this.setElementWidth(colEndHeader, columnHeaderWidth);

    [rowHeaderWidth, colHeaderHeight] = this._setFrozenContainerDimension(
      databodyWidth,
      databodyHeight,
      rowHeaderWidth,
      rowEndHeaderWidth,
      colHeaderHeight,
      colEndHeaderHeight
    );

    this.setElementDir(databody, colHeaderHeight, 'top');
    this.setElementDir(databody, rowHeaderWidth, dir);
    this.setElementWidth(databody, databodyWidth);
    this.setElementHeight(databody, databodyHeight);

    if (this.m_endRowHeader === -1 && this.m_endColHeader !== -1 && this.m_rowHeaderScrollbarSpacer) {
      this.setElementDir(this.m_rowHeaderScrollbarSpacer, colHeaderHeight, 'top');
      this.setElementHeight(this.m_rowHeaderScrollbarSpacer, databodyHeight + colEndHeaderHeight);
      this.setElementWidth(this.m_rowHeaderScrollbarSpacer, rowHeaderWidth);
    } else if (
      this.m_endRowHeader !== -1 &&
      this.m_endColHeader === -1 &&
      this.m_columnHeaderScrollbarSpacer
    ) {
      this.setElementDir(this.m_columnHeaderScrollbarSpacer, rowHeaderWidth, 'left');
      this.setElementWidth(this.m_columnHeaderScrollbarSpacer, databodyWidth + rowEndHeaderWidth);
      this.setElementHeight(this.m_columnHeaderScrollbarSpacer, colHeaderHeight);
    }

    // cache the scroll width and height to minimize reflow
    this.m_scrollWidth = databodyContentWidth - columnHeaderWidth;
    this.m_scrollHeight = databodyContentHeight - rowHeaderHeight;

    this.buildCorners();

    // check if we need to remove border on the last column header/add borders to headers
    this._adjustHeaderBorders();
    this._updateGridlines();

    // on touch devices the scroller doesn't automatically scroll into view when resizing the last columns or rows to be smaller
    if (this.m_utils.isTouchDevice()) {
      var deltaX = 0;
      var deltaY = 0;

      // if the visible window plus the scrollLeft is bigger than the scrollable region maximum, rescroll the window
      if (this.m_currentScrollLeft > this.m_scrollWidth) {
        deltaX = this.m_scrollWidth - this.m_currentScrollLeft;
      }

      if (this.m_currentScrollTop > this.m_scrollHeight) {
        deltaY = this.m_scrollHeight - this.m_currentScrollTop;
      }

      if (deltaX !== 0 || deltaY !== 0) {
        if (this.m_utils.isTouchDeviceNotIOS()) {
          // eliminate bounce back for touch scroll
          this._disableTouchScrollAnimation();
        }
        var delta = this.adjustTouchScroll(deltaX, deltaY);
        deltaX = delta[0];
        deltaY = delta[1];

        this.scrollDelta(deltaX, deltaY);
      }
    }
  };

  /**
   * Resizes all cell in the resizing element's column, and updates the left(right)
   * postion on the cells and column headers that follow(preceed) that column.
   * @param {number} widthChange - the change in width of the resizing element
   */
  DvtDataGrid.prototype.resizeColumnWidthAndShift = function (widthChange) {
    var dir = this.getResources().isRTLMode() ? 'right' : 'left';
    var colHeaderDisplay = this.m_colHeader.style.display;
    var colEndHeaderDisplay = this.m_colEndHeader.style.display;
    let isFrozenSectionResize = this.m_resizingElement.classList.contains(
      this.getMappedStyle('frozenHeader')
    );
    let corner = false;
    // hide the databody and col header for performance
    if (!isFrozenSectionResize) {
      this.m_databody.style.display = 'none';
      this.m_colHeader.style.display = 'none';
      this.m_colEndHeader.style.display = 'none';
      if (this.m_databodyFrozenRow) {
        this.m_databodyFrozenRow.style.display = 'none';
      }
    } else {
      this.m_databodyFrozenCol.style.display = 'none';
      this.m_colHeaderFrozen.style.display = 'none';
      this.m_colEndHeaderFrozen.style.display = 'none';
      if (this.m_databodyFrozenCorner) {
        this.m_databodyFrozenCorner.style.display = 'none';
        corner = true;
      }
    }

    // get the index of the header, if it is a nested header make it the last child index
    var index = this.getHeaderCellIndex(this.m_resizingElement);
    if (
      this.m_columnHeaderLevelCount > 1 &&
      this.m_resizingElement === this.m_resizingElement.parentNode.firstChild &&
      this.m_resizingElement.nextSibling != null
    ) {
      // has children
      index += this._getAttribute(this.m_resizingElement.parentNode, 'extent', true) - 1;
      while (this.isHidden('column', index)) {
        index -= 1;
      }
    }

    var rangeIndex = this.createIndex(-1, index);
    var cells = this.getElementsInRange(this.createRange(rangeIndex, rangeIndex));

    var classArray;

    if (cells) {
      for (let i = 0; i < cells.length; i++) {
        classArray = this.getResources().isRTLMode() ? ['startResized'] : ['endResized'];
        this._highlightElement(cells[i], classArray);
      }
    }
    let headerContainer = this.m_colHeader.firstChild;
    let endHeaderContainer = this.m_colEndHeader.firstChild;
    if (isFrozenSectionResize) {
      headerContainer = this.m_colHeaderFrozen.firstChild;
      endHeaderContainer = this.m_colEndHeaderFrozen.firstChild;
    }
    // move column headers within the container and adjust the widths appropriately
    this._shiftHeadersAlongAxisInContainer(
      headerContainer,
      index,
      widthChange,
      dir,
      this.getMappedStyle('colheadercell'),
      'column'
    );

    // move column headers within the container and adjust the widths appropriately
    this._shiftHeadersAlongAxisInContainer(
      endHeaderContainer,
      index,
      widthChange,
      dir,
      this.getMappedStyle('colendheadercell'),
      'column'
    );

    // shift the cells widths and left/right values in the databody
    if (!isFrozenSectionResize) {
      this._shiftCellsAlongAxis('column', widthChange, index);
      if (this.m_databodyFrozenRow) {
        this._shiftFrozenCellsAlongAxis('column', widthChange, index, false);
      }
    } else {
      this._shiftCellsAlongAxis('column', widthChange, index, null, this.m_frozenColIndex, corner);
    }

    // restore visibility
    if (!isFrozenSectionResize) {
      this.m_databody.style.display = '';
      this.m_colHeader.style.display = colHeaderDisplay;
      this.m_colEndHeader.style.display = colEndHeaderDisplay;
      if (this.m_databodyFrozenRow) {
        this.m_databodyFrozenRow.style.display = '';
      }
    } else {
      this.m_databodyFrozenCol.style.display = '';
      this.m_colHeaderFrozen.style.display = colHeaderDisplay;
      this.m_colEndHeaderFrozen.style.display = colEndHeaderDisplay;
      if (this.m_databodyFrozenCorner) {
        this.m_databodyFrozenCorner.style.display = '';
      }
    }
  };

  /**
   * Moves cells inside of all rows/columns starting at a certain index, will also resize the given index.
   