/*!
 Splitter - a jQuery UI based widget for dynamically dividing the available space for two sub regions horizontally or vertically.
 Copyright (c) 2010, 2024, Oracle and/or its affiliates. All rights reserved.
 */
!function(t,e,i,s,o){"use strict";const r="a-Splitter",a="."+r,n="a-Splitter-barH",l="a-Splitter-barV",h="."+n+",."+l,d="a-Splitter-thumb",p="."+d,f="u-RTL",c="is-focused",b="is-active",u="is-collapsed",m="is-disabled",g="button",z="aria-label",S="aria-expanded",_="aria-controls",E="aria-disabled",v="aria-orientation",$="aria-valuenow",C="aria-valuemin",A="aria-valuemax",x="role",w="separator",P="button";var T="title";function L(t){return s.getMessage("APEX.SPLITTER."+t)}function O(t,...e){return s.formatMessage("APEX.SPLITTER."+t,...e)}t.widget("apex.splitter",{widgetEventPrefix:"splitter",options:{orientation:"horizontal",positionedFrom:"begin",minSize:60,position:100,noCollapse:!1,dragCollapse:!0,collapsed:!1,snap:!1,inc:10,realTime:!1,iframeFix:!1,restoreText:null,collapseText:null,title:null,change:null},lastPos:null,bar$:null,before$:null,after$:null,horiz:!0,fromEnd:!1,barSize:1,_create:function(){var s,n,l,h,d,u,m=this,z=this.options,S=this.element,_=e.htmlBuilder(),E=t.ui.keyCode,v=!!z.snap&&[1*z.snap,1*z.snap],$=z.noCollapse?0:1,C=null;if(2!==S.children().length)throw new Error("Splitter must have exactly two children.");if("horizontal"!==z.orientation&&"vertical"!==z.orientation)throw new Error("Orientation bad value");if("begin"!==z.positionedFrom&&"end"!==z.positionedFrom)throw new Error("PositionedFrom bad value");if(z.minSize<$&&(z.minSize=$,i.warn("Option minSize adjusted")),this.horiz="horizontal"===z.orientation,this.fromEnd="end"===z.positionedFrom,u=this.horiz?"left":"top",this.before$=S.children().eq(0),this.after$=S.children().eq(1),S.addClass(r+" resize"),"rtl"===S.css("direction")&&(S.addClass(f),this.horiz&&(this.before$=S.children().eq(1),this.after$=S.children().eq(0),this.fromEnd=!this.fromEnd)),S.parent(a).length>0||this.before$.is(a)||this.after$.is(a))throw new Error("Child of splitter cannot be a splitter");this.before$[0].id||(this.before$[0].id=(S[0].id||"splitter")+"_first"),this.after$[0].id||(this.after$[0].id=(S[0].id||"splitter")+"_second"),z.position<z.minSize&&(z.position=z.minSize),this.lastPos=z.position,z.snap&&(z.inc=z.snap),this._renderBar(_),this.bar$=t(_.toString()).insertAfter(S.children().eq(0)),this.horiz?this.barSize=this.bar$.width():this.barSize=this.bar$.height(),S.css({position:"relative"}).children().css({position:"absolute"}),this.horiz?(s=this.bar$.position()[u],n=0,l="e-resize",this.fromEnd?(h=E.LEFT,d=E.RIGHT):(h=E.RIGHT,d=E.LEFT)):(s=0,n=this.bar$.position()[u],l="s-resize",this.fromEnd?(h=E.UP,d=E.DOWN):(h=E.DOWN,d=E.UP)),this.bar$.css({left:s,top:n}).draggable({axis:m.horiz?"x":"y",containment:"parent",cancel:g,cursor:l,iframeFix:z.iframeFix,grid:v,scroll:!1,drag:function(t,e){var i;z.realTime&&(i=e.position[u],m.fromEnd&&(i=(m.horiz?S.width():S.height())-i-m.barSize),m._setPos(i,!1))},start:function(){m.bar$.addClass(b)},stop:function(t,e){var i=e.position[u];m.bar$.removeClass(b),m.fromEnd&&(i=(m.horiz?S.width():S.height())-i-m.barSize),m._setPos(i,!1)}}).on("click",(function(){t(this).find(p).trigger("focus")})),this.bar$.find(g).on("click",(function(t){let e=!1,i=!1;m.lastEnterDownAt&&Date.now()-m.lastEnterDownAt<200&&(i=!0),t.pointerType&&"mouse"===t.pointerType&&!m.thumbMouseEntered&&(e=!0),z.collapsed||i||!e?m._setPos(m._getPos(),!m._isCollapsed()):(t.preventDefault(),t.stopPropagation())})),apex.widget.util.TouchProxy.addTouchListeners(this.bar$[0]),this.bar$.find(p).on("focus",(function(){t(this).parent().addClass(c+" "+b)})).mouseenter((function(){m.thumbMouseEntered=!0})).mouseleave((function(){m.thumbMouseEntered=!1})).blur((function(){t(this).parent().removeClass(c+" "+b)})).keydown((function(t){var e,i,s=t.keyCode,r=null,a=!1;if("Enter"===t.key&&(m.lastEnterDownAt=Date.now()),m.horiz||s!==E.LEFT&&s!==E.RIGHT?!m.horiz||s!==E.UP&&s!==E.DOWN||o.ariaAlertMessage(L("VERTICAL_CANNOT_UP_DOWN")):o.ariaAlertMessage(L("HORIZ_CANNOT_LEFT_RIGHT")),s!==d||z.collapsed?s===h&&((r=m._getPos())<0?(z.noCollapse||(a=!0),r=0):r+=z.inc,e=m._getMaxPos(),r>e&&(r=e,o.ariaAlertMessage(O("MAX_SIZE_REACHED",Math.round(r))))):(r=m._getPos(),(r-=z.inc)<z.minSize&&z.noCollapse&&(r=z.minSize,o.ariaAlertMessage(O("MIN_SIZE_REACHED",r))),r<0&&(r=0)),null!==r)return i=r,m.fromEnd&&(i=(m.horiz?S.width():S.height())-i-m.barSize),m.bar$.css(u,i),C&&(clearTimeout(C),C=null),C=setTimeout((function(){C=null,m._setPos(r,a)}),100),!1})),this._on(!0,this._eventHandlers),z.disabled&&this._setOption("disabled",z.disabled),this.refresh()},_eventHandlers:{resize:function(i){var s,o,r,a,n=this.options,l=this.element;if(i.target===l[0]){if(s=l.height(),o=l.width(),0===s||0===o)throw new Error("Splitter needs to be in a component with size");a=l.offset(),this.horiz?(l.children().each((function(){e.setOuterHeight(t(this),s)})),this.fromEnd?(r=[a.left+n.minSize,a.top,a.left+o-this.barSize,a.top+s],n.dragCollapse&&!n.noCollapse||(r[2]-=n.minSize)):(r=[a.left,a.top,a.left+o-this.barSize-n.minSize,a.top+s],n.dragCollapse&&!n.noCollapse||(r[0]+=n.minSize+1))):(l.children().each((function(){e.setOuterWidth(t(this),o)})),this.fromEnd?(r=[a.left,a.top+n.minSize,a.left+o,a.top+s-this.barSize],n.dragCollapse&&!n.noCollapse||(r[3]-=n.minSize)):(r=[a.left,a.top,a.left+o,a.top+s-this.barSize-n.minSize],n.dragCollapse&&!n.noCollapse||(r[1]+=n.minSize+1))),this._setPos(n.position,n.collapsed),this.bar$.draggable("option","containment",r),l.children(".resize").filter(":visible").trigger("resize"),i.stopPropagation()}}},_destroy:function(){this.element.removeClass(r+" "+m+" "+f+" resize").children(h).remove(),this.element.children().css("position","")},refresh:function(){this.element.is(":visible")&&this.element.trigger("resize")},_setOption:function(e,s){const o=this.options;var r,a,n;if(!o.noCollapse||"collapsed"!==e&&"restoreText"!==e&&"collapseText"!==e){if("orientation"===e||"positionedFrom"===e||"noCollapse"===e)throw new Error("Readonly option: "+e);if("position"===e?this._setPos(1*s,this._isCollapsed()):"collapsed"===e?this._setPos(this._getPos(),!!s):"snap"===e?(s=!!s&&1*s,o.snap=s,r=!!s&&[s,s],this.bar$.draggable("option","grid",r),s&&(o.inc=s)):"inc"===e?(s*=1,o.snap&&(s=o.snap),o.inc=s):"disabled"===e?(o.disabled=s,n=this.bar$.find(p),o.noCollapse?s?n.removeAttr("tabindex"):n.attr("tabindex","0"):n[0].disabled=s,this.bar$.draggable("option","disabled",s),s?(this.element.addClass(m),this.bar$.addClass(m),n.attr(E,!0)):(n.removeAttr(E),this.bar$.removeClass(m),this.element.removeClass(m))):"minSize"===e?(s<(a=o.noCollapse?0:1)&&(s=a,i.warn("Option minSize adjusted")),o.minSize=s):t.Widget.prototype._setOption.apply(this,arguments),"title"===e){let t=this.bar$.find(p);this.bar$.attr(T,s),t.attr(z,this._thumbAriaLabel(o.collapsed))}else if("restoreText"===e&&o.collapsed&&!o.disabled){this.bar$.find(g).attr(z,this._thumbAriaLabel(o.collapsed))}else if("collapseText"!==e||o.collapsed||o.disabled)"iframeFix"===e?this.bar$.draggable("option","iframeFix",s):"dragCollapse"===e&&this.refresh();else{this.bar$.find(g).attr(z,this._thumbAriaLabel(o.collapsed))}}else i.warn("Setting "+e+" option on noCollapse splitter has no effect.")},_getAriaLabel:function(e){let i=e.attr(z);if(i)return i;let s=e.attr("aria-labelledby");return s?(i=t("#"+s).attr(z),i||""):""},_thumbAriaLabel:function(e){const i=this.options,s=this.fromEnd?this.after$[0].id:this.before$[0].id,o=t("#"+s);let r="";return r||(r=this._getAriaLabel(o)),r||(r=this._getAriaLabel(o.find(".resize[role='region']").first())),r||(r=i.title,r||(r=e?i.restoreText:i.collapseText),r)},_barAriaLabel:function(e,i){const s=this.options,o=this.fromEnd?this.after$[0].id:this.before$[0].id,r=t("#"+o);let a;return e===w?"":(i||(a=s.title),a||i&&(a=this._getAriaLabel(r)),a||i&&(a=this._getAriaLabel(r.find(".resize[role='region']").first())),a||(a=i?s.restoreText:s.collapseText),a)},_renderBar:function(t){const e=this.options;let i=this.horiz?n:l;this.fromEnd&&(i+=" a-Splitter--end"),e.noCollapse&&(e.collapsed=!1),e.collapsed&&(i+=" "+u),t.markup("<div").attr("class",i).optionalAttr(T,e.title).markup("><div></div>");const s=e.noCollapse?"span":"button",o="button"===s?" type='button'":" tabindex='0'",r=e.noCollapse?w:e.collapsed?P:w,a=r===P?"false":"",h=r===w?this.horiz?"vertical":"horizontal":"";t.markup("<"+s+o).attr("class",d).attr(x,r).optionalAttr(z,this._thumbAriaLabel(e.collapsed)).optionalAttr(_,e.collapsed?null:"begin"===e.positionedFrom?this.before$[0].id:this.after$[0].id).optionalAttr(S,a).optionalAttr(v,h).markup("></"+s+">"),t.markup("</div>")},_getPos:function(){var t=this.element,e=this.horiz?"left":"top",i=this.bar$.position()[e];return this.fromEnd&&(i=(this.horiz?t.width():t.height())-i-this.barSize),i},_isCollapsed:function(){return this.bar$.hasClass(u)},_getMaxPos:function(){var t=this.options,e=this.element;return this.horiz?e.width()-this.barSize-t.minSize:e.height()-this.barSize-t.minSize},_setPos:function(t,i){const s=this,r=this.options,a=this.element,n=this.bar$,l=n.find(p),h=this.horiz?"left":"top",d=this._isCollapsed(),f=this.lastPos,c=this.horiz?a.width():a.height(),b=this._getMaxPos();let m,g,E;function T(t,e,i){const a=i?"false":"true";let h;if(h=c-s.barSize-2*r.minSize<0?"button":t,l.attr(x,h).attr(z,s._thumbAriaLabel(i)),h===w)l.attr($,Math.round(e)).attr(C,r.minSize).attr(A,Math.round(b)).attr(_,"begin"===r.positionedFrom?s.before$[0].id:s.after$[0].id).attr(v,s.horiz?"vertical":"horizontal").removeAttr(S),n.removeAttr(x).removeAttr(z),s.lastValueNow!==e&&(o.ariaMessage(O("RESIZED_TO",Math.round(e))),s.lastValueNow=e);else{l.removeAttr($).removeAttr(C).removeAttr(A).removeAttr(v).attr(S,a);let t=s._barAriaLabel(P,i);t?n.attr(x,"region").attr(z,t):n.removeAttr(x).removeAttr(z)}i?l.removeAttr(_):l.attr(_,"begin"===r.positionedFrom?s.before$[0].id:s.after$[0].id)}if(r.noCollapse&&(i=!1),d&&!i&&(t=this.lastPos)<r.minSize&&(t=r.minSize),t<r.minSize?r.noCollapse?t=r.minSize:i=!0:t>b&&(t=b),r.noCollapse&&t<=0&&(t=0),t>0&&(this.lastPos=t),i&&(t=0,r.position=0),E=t,this.fromEnd&&(E=c-t-this.barSize),this.bar$.css(h,E),this.fromEnd?(m=this.after$,g=c-E-this.barSize):(m=this.before$,g=E),i?(this.bar$.addClass(u),m.hide(),T(P,g,!0)):(r.noCollapse?m.toggle(0!==t):(this.bar$.removeClass(u),m.show()),this.horiz?e.setOuterWidth(m,g):e.setOuterHeight(m,g),T(w,g,!1)),this.fromEnd?(m=this.before$,g=E):(m=this.after$,g=c-E-this.barSize),this.horiz?e.setOuterWidth(m,g):e.setOuterHeight(m,g),r.noCollapse&&m.toggle(0!==g),this.after$.css(h,E+this.barSize+"px"),this.before$.css(h,0),(!i&&t!==f||d!==i)&&(r.collapsed=i,r.position=t,a.children(".resize").filter(":visible").trigger("resize"),this._trigger("change",{},{position:r.position,collapsed:r.collapsed,lastPosition:this.lastPos})),i&&d!==i){let t=this._thumbAriaLabel(i);o.ariaAlertMessage(t?O("COLLAPSED_REGION",t):L("REGION_IS_COLLAPSED"))}if(!i&&d!==i){let t=this._thumbAriaLabel(i);o.ariaAlertMessage(t?O("RESTORED_REGION",t):L("REGION_IS_RESTORED"))}}});var M=0,R=0;t.apex.splitter.nextSplitter=function(e){var i,s,o,r=e?-1:1,d=t(document.activeElement);if(!(M>0||R>0))return(o=(s=t(a+" >."+n+","+a+" >."+l).filter(":visible").not(".ui-state-disabled").add(d)).index(d))>=0&&(o+=r,e&&d.parent().is(h)&&(o+=r),o>=0&&o<s.length&&(i=s.eq(o))),(i&&0===i.length&&!d.parent().is(h)||d.is("html,body"))&&(i=t(a+" >."+n+","+a+" >."+l).filter(":visible").not(".ui-state-disabled")[e?"last":"first"]()),i&&i.length>0?(i.children(p).trigger("focus"),!0):void 0},t((function(){t(document.body).on("menubeforeopen",(function(){R+=1})).on("menuafterclose",(function(){R-=1})).on("dialogopen",(function(){M+=1})).on("dialogclose",(function(){M-=1}))})),apex.message&&apex.message.addVisibilityCheck((function(e){var i=t("#"+e);i.parents(".a-Splitter").each((function(){i.is(":visible")||t(this).splitter("option","collapsed",!1)}))}))}(apex.jQuery,apex.util,apex.debug,apex.lang,apex.message);