/*!
 * Copyright (c) 2021, 2024, Oracle and/or its affiliates. All rights reserved.
 */
!function(e,t,i,a,s,o,n,r,l,h){"use strict";const c=t.APEX_FILES+`libraries/mapbox-gl-rtl-text/${h.mapboxGlRtlText}/mapbox-gl-rtl-text.js`,d="a-MapRegion-distance",p="maplibregl-ctrl maplibregl-ctrl-group",m="a-MapRegion-legendItem",u="a-Icon",g="icon-2d-mode",f="a-MapRegion-popup",y="a-MapRegion-popupTitle",v="a-MapRegion-popupContent",C="a-MapRegion--zoomControlsStart",b="u-hidden",_="osm-dark-matter",S="shared-component",w="polygons",M="lines",L="heatMap",x="3d",k="icon",T="url-image",I="Point",P="ADV_FORMATTING",A="TITLE_BODY",O="tooltip",F="infoWindow",R="Default",B={Default:{name:R,width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M10 2C6.7 2 4 4.7 4 8c0 4.6 5.4 9.7 5.7 9.9.2.2.5.2.7 0 .2-.2 5.6-5.3 5.6-9.9 0-3.3-2.7-6-6-6zm0 7.9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"}]},Camera:{name:"Camera",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M15 4h-1.2l-.9-1.2c-.4-.5-1-.8-1.6-.8H8.8c-.7 0-1.3.3-1.6.8L6.2 4H5c-1.1 0-2 .9-2 2v5c0 1.1.9 2 2 2h2.2l2.4 4.7c.1.2.4.3.7.2.1 0 .2-.1.2-.2l2.4-4.7H15c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-5 7c-1.4 0-2.5-1.1-2.5-2.5S8.6 6 10 6s2.5 1.1 2.5 2.5S11.4 11 10 11z"}]},Circle:{name:"Circle",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M10 2C6.7 2 4 4.7 4 8c0 2.5 1.6 4.7 3.9 5.6l1.6 4.1c.1.3.4.4.7.3l.3-.3 1.6-4.1c3.1-1.2 4.7-4.6 3.5-7.7C14.7 3.6 12.5 2 10 2zm0 8c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"}]},"Circle Alternative":{name:"Circle Alternative",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M10 2C6.7 2 4 4.7 4 8v9.5c0 .2.1.4.3.5h.2c.1 0 .3-.1.4-.2l3.7-4c3.2.8 6.5-1.2 7.3-4.4.8-3.2-1.2-6.5-4.4-7.3-.5 0-1-.1-1.5-.1zm0 8c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"}]},"Face Frown":{name:"Face Frown",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M10 2C6.7 2 4 4.7 4 8c0 3.7 5.4 9.6 5.6 9.8.2.2.5.2.7 0 .3-.2 5.7-6.1 5.7-9.8 0-3.3-2.7-6-6-6zM7.2 7c0-.4.3-.8.8-.8.4 0 .8.3.8.8s-.4.8-.8.8-.8-.4-.8-.8zm5 3.8c-.2.1-.4.1-.5-.1-.7-.9-2-1.1-3-.4-.2.1-.3.3-.4.4-.1.2-.4.2-.5.1-.2-.1-.2-.4-.1-.5 1-1.3 2.8-1.5 4-.6l.6.6c.1.1.1.4-.1.5zm-.2-3c-.4 0-.8-.3-.8-.8s.3-.8.8-.8.8.3.8.8-.4.8-.8.8z"}]},"Face Meh":{name:"Face Meh",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M10 2C6.7 2 4 4.7 4 8c0 3.7 5.4 9.6 5.6 9.8.2.2.5.2.7 0 .3-.2 5.7-6.1 5.7-9.8 0-3.3-2.7-6-6-6zM7.2 7c0-.4.3-.8.8-.8.4 0 .8.3.8.8s-.4.8-.8.8-.8-.4-.8-.8zm4.3 3.9h-3c-.2 0-.4-.2-.4-.4s.2-.4.4-.4h3c.2 0 .4.2.4.4s-.2.4-.4.4zm.5-3.1c-.4 0-.8-.3-.8-.8s.3-.8.8-.8.8.3.8.8-.4.8-.8.8z"}]},"Face Smile":{name:"Face Smile",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M10 2C6.7 2 4 4.7 4 8c0 3.7 5.4 9.6 5.6 9.8.2.2.5.2.7 0 .3-.2 5.7-6.1 5.7-9.8 0-3.3-2.7-6-6-6zM7.2 7c0-.4.3-.8.8-.8.4 0 .8.3.8.8s-.4.8-.8.8-.8-.4-.8-.8zm5.1 2.7c-1 1.3-2.8 1.5-4 .6l-.6-.6c-.1-.1-.1-.4.1-.5.2-.1.4-.1.5.1.7.9 2 1.1 3 .4.2-.1.3-.3.4-.4.1-.2.4-.2.5-.1s.2.4.1.5zM12 7.8c-.4 0-.8-.3-.8-.8s.3-.8.8-.8.8.3.8.8-.4.8-.8.8z"}]},Square:{name:"Square",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M14 2H6c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h2.1l1.5 3.7c.1.3.4.4.7.3l.3-.3 1.5-3.7H14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-4 8c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"}]},"Square Alternative":{name:"Square Alternative",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M14 2H6c-1.1 0-2 .9-2 2v13.5c0 .2.1.4.3.5h.2c.1 0 .3-.1.4-.2L8.4 14H14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-4 8c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z"}]},"Pin Circle":{name:"Pin Circle",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M10 2C7.2 2 5 4.2 5 7c0 2.6 1.9 4.7 4.5 5v5.6c0 .3.2.5.5.5s.5-.2.5-.5V12c2.7-.3 4.7-2.7 4.5-5.4-.3-2.7-2.4-4.6-5-4.6z"}]},Heart:{name:"Heart",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M16 5c0-.8-.3-1.6-.9-2.1-1.2-1.2-3.1-1.2-4.3 0l-.8.8-.8-.8C8 1.7 6.1 1.7 4.9 2.9c-1.2 1.1-1.2 3 0 4.2l4.6 4.6v5.8c0 .3.2.5.5.5s.5-.2.5-.5v-5.8l4.6-4.6c.6-.5.9-1.3.9-2.1z"}]},Pentagon:{name:"Pentagon",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M15 5.5l-4.7-3.4c-.2-.1-.4-.1-.6 0L5 5.5c-.2.2-.3.4-.2.6l1.8 5.6c.1.2.3.3.5.3h2.4v5.5c0 .3.2.5.5.5s.5-.2.5-.5V12h2.4c.2 0 .4-.1.5-.3l1.8-5.6c.1-.2 0-.4-.2-.6z"}]},"Pin Square":{name:"Pin Square",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M13 2H7c-1.1 0-2 .9-2 2v6c0 1.1.9 2 2 2h2.5v5.5c0 .3.2.5.5.5s.5-.2.5-.5V12H13c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2z"}]},Triangle:{name:"Triangle",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M15.9 11.2l-5.5-9c-.1-.2-.5-.3-.7-.1-.1 0-.1.1-.1.1l-5.5 9c-.1.2-.1.5.2.7 0 .1.1.1.2.1h5v5.5c0 .3.2.5.5.5s.5-.2.5-.5V12h5c.3 0 .5-.2.5-.5 0-.1 0-.2-.1-.3z"}]},Check:{name:"Check",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M10 2C6.7 2 4 4.7 4 8c0 3.7 5.4 9.6 5.6 9.8.2.2.5.2.7 0 .3-.2 5.7-6.1 5.7-9.8 0-3.3-2.7-6-6-6zm2.9 4.9l-3 3c-.2.1-.6.1-.8 0L7.6 8.4c-.2-.2-.2-.5 0-.7s.5-.2.7 0l1.1 1.1L12 6.2c.2-.2.5-.2.7 0s.3.5.2.7z"}]},Home:{name:"Home",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M17.8 7.6l-7.5-5.5c-.2-.1-.4-.1-.6 0L2.2 7.5c-.2.2-.3.5-.1.7.2.2.5.3.7.1L4 7.5v6c0 .3.2.5.5.5h3.2l1.9 3.7c.1.2.4.3.7.2.1 0 .2-.1.2-.2l1.9-3.7h3.2c.3 0 .5-.2.5-.5v-6l1.2.9c.2.2.5.1.7-.1.1-.3 0-.6-.2-.7z"},{type:"path",d:"M8.5 8.5v2c0 .3.2.5.5.5h2c.3 0 .5-.2.5-.5v-2c0-.3-.2-.5-.5-.5H9c-.3 0-.5.2-.5.5z",fill:"#fff"}]},Slash:{name:"Slash",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M17.9 2.1c-.2-.2-.5-.2-.7 0l-2.3 2.3C13 1.7 9.2 1.1 6.5 3.1 4.9 4.3 4 6.1 4 8c.1 1.9.8 3.8 1.9 5.4l-3.8 3.8c-.2.2-.2.5 0 .7s.5.2.7 0l15-15c.2-.2.2-.6.1-.8zM9.5 9.8c-1.1-.3-1.7-1.4-1.4-2.4S9.5 5.7 10.5 6c.7.2 1.2.7 1.4 1.4L9.5 9.8zM7.1 15c.8 1 1.6 2 2.6 2.8.2.2.5.2.7 0 .2-.1 5.6-5.2 5.6-9.8 0-.6-.1-1.1-.2-1.6L7.1 15z"}]},Shine:{name:"Shine",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M10 7c-2.2 0-4 1.8-4 4 0 2.3 3.2 6.4 3.6 6.8.2.2.5.2.7.1l.1-.1c.4-.5 3.6-4.5 3.6-6.8 0-2.2-1.8-4-4-4zm0 5c-.6 0-1-.4-1-1s.4-1 1-1 1 .4 1 1-.4 1-1 1zM3.6 4.9c-.2-.1-.5-.1-.7.1-.2.3-.1.6.1.7l1.9 1.4c0 .1.1.1.3.1.3 0 .5-.2.5-.5 0-.2-.1-.3-.2-.4L3.6 4.9zm4 .1c.1.2.3.3.5.3h.2c.3-.1.4-.4.3-.6l-.9-2.4c0-.2-.3-.4-.6-.3-.3.1-.4.4-.3.6L7.6 5zm9.5 0c-.2-.2-.5-.3-.7-.1l-1.9 1.4c-.2.2-.3.5-.1.7.1.1.2.2.4.2.1 0 .2 0 .3-.1L17 5.7c.2-.1.3-.4.1-.7zm-5.3.3h.2c.2 0 .4-.1.5-.3l.8-2.3c.1-.3 0-.5-.3-.6-.3-.1-.5 0-.6.3l-.8 2.3c-.2.2-.1.5.2.6z"}]},"Street View":{name:"Street View",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M14.7 11.6c-.3-.1-.5.1-.6.3s.1.5.3.6c1.6.5 2.6 1.2 2.6 1.9 0 1.2-2.9 2.5-7 2.5s-7-1.3-7-2.5c0-.7 1-1.4 2.6-1.9.3 0 .4-.3.3-.5-.1-.3-.4-.4-.6-.3-2.1.6-3.3 1.6-3.3 2.8 0 2 3.4 3.5 8 3.5s8-1.5 8-3.5c0-1.2-1.2-2.2-3.3-2.9z"},{type:"path",d:"M7.7 10.9c.2.2.3.5.3.7V14c0 .6.4 1 1 1h2c.6 0 1-.4 1-1v-2.4c0-.3.1-.5.3-.7l.1-.1c.4-.4.6-.9.6-1.4V7.8c0-.7-.3-1.3-.9-1.6-1.2 1.2-3.1 1.2-4.2 0-.6.3-.9.9-.9 1.6v1.6c0 .5.2 1 .6 1.4l.1.1z"},{type:"circle",cx:10,cy:4,r:2}]},"Flag Pennant":{name:"Flag Pennant",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M16.7 6.5L3.7 2c-.3-.1-.6.1-.7.3v15.2c0 .3.2.5.5.5s.5-.2.5-.5v-5.6l12.7-4.4c.3-.1.4-.4.3-.6-.1-.2-.2-.3-.3-.4z"}]},"Flag Swallowtail":{name:"Flag Swallowtail",width:20,height:20,"paint-order":"stroke",viewBox:"0 0 20 20",elements:[{type:"path",d:"M13.2 7l3.7-4.2c.2-.2.2-.5 0-.7-.2-.1-.3-.1-.4-.1h-13c-.3 0-.5.2-.5.5v15c0 .3.2.5.5.5s.5-.2.5-.5V12h12.5c.3 0 .5-.2.5-.5 0-.1 0-.2-.1-.3L13.2 7z"}]}},E={Burg:["#ffc6c4","#f4a3a8","#e38191","#cc607d","#ad466c","#8b3058","#672044"],BurgYl:["#fbe6c5","#f5ba98","#ee8a82","#dc7176","#c8586c","#9c3f5d","#70284a"],RedOr:["#f6d2a9","#f5b78e","#f19c7c","#ea8171","#dd686c","#ca5268","#b13f64"],OrYel:["#ecda9a","#efc47e","#f3ad6a","#f7945d","#f97b57","#f66356","#ee4d5a"],Peach:["#fde0c5","#facba6","#f8b58b","#f59e72","#f2855d","#ef6a4c","#eb4a40"],PinkYl:["#fef6b5","#ffdd9a","#ffc285","#ffa679","#fa8a76","#f16d7a","#e15383"],Mint:["#e4f1e1","#b4d9cc","#89c0b6","#63a6a0","#448c8a","#287274","#0d585f"],BluGrn:["#c4e6c3","#96d2a4","#6dbc90","#4da284","#36877a","#266b6e","#1d4f60"],DarkMint:["#d2fbd4","#a5dbc2","#7bbcb0","#559c9e","#3a7c89","#235d72","#123f5a"],Emrld:["#d3f2a3","#97e196","#6cc08b","#4c9b82","#217a79","#105965","#074050"],BluYl:["#f7feae","#b7e6a5","#7ccba2","#46aea0","#089099","#00718b","#045275"],Teal:["#d1eeea","#a8dbd9","#85c4c9","#68abb8","#4f90a6","#3b738f","#2a5674"],TealGrn:["#b0f2bc","#89e8ac","#67dba5","#4cc8a3","#38b2a3","#2c98a0","#257d98"],Purp:["#f3e0f7","#e4c7f1","#d1afe8","#b998dd","#9f82ce","#826dba","#63589f"],PurpOr:["#f9ddda","#f2b9c4","#e597b9","#ce78b3","#ad5fad","#834ba0","#573b88"],Sunset:["#f3e79b","#fac484","#f8a07e","#eb7f86","#ce6693","#a059a0","#5c53a5"],Magenta:["#f3cbd3","#eaa9bd","#dd88ac","#ca699d","#b14d8e","#91357d","#6c2167"],SunsetDark:["#fcde9c","#faa476","#f0746e","#e34f6f","#dc3977","#b9257a","#7c1d6f"],BrwnYl:["#ede5cf","#e0c2a2","#d39c83","#c1766f","#a65461","#813753","#541f3f"],ArmyRose:["#798234","#a3ad62","#d0d3a2","#fdfbe4","#f0c6c3","#df91a3","#d46780"],Fall:["#3d5941","#778868","#b5b991","#f6edbd","#edbb8a","#de8a5a","#ca562c"],Geyser:["#008080","#70a494","#b4c8a8","#f6edbd","#edbb8a","#de8a5a","#ca562c"],Temps:["#009392","#39b185","#9ccb86","#e9e29c","#eeb479","#e88471","#cf597e"],TealRose:["#009392","#72aaa1","#b1c7b3","#f1eac8","#e5b9ad","#d98994","#d0587e"],Tropic:["#009B9E","#42B7B9","#A7D3D4","#F1F1F1","#E4C1D9","#D691C1","#C75DAB"],Earth:["#A16928","#bd925a","#d6bd8d","#edeac2","#b5c8b8","#79a7ac","#2887a1"],Antique:["#855C75","#D9AF6B","#AF6458","#736F4C","#526A83","#625377","#7C7C7C"],Bold:["#7F3C8D","#11A579","#3969AC","#F2B701","#E73F74","#80BA5A","#A5AA99"],Pastel:["#66C5CC","#F6CF71","#F89C74","#DCB0F2","#87C55F","#9EB9F3","#B3B3B3"],Prism:["#5F4690","#1D6996","#38A6A5","#0F8554","#73AF48","#EDAD08","#666666"],Safe:["#88CCEE","#CC6677","#DDCC77","#117733","#332288","#AA4499","#888888"],Vivid:["#E58606","#5D69B1","#52BCA3","#99C945","#CC61B0","#24796C","#A5AA99"]},z={metric:6371.0088,imperial:3958.761333810546},D=0,$=24,N="#000000",Z="a-Icon icon-map-layer",V=["get","imageId"],H=["get","size"],G="zoomState",j="lngState",U="latState",W="bearingState",K="pitchState",q="-source",J="_legend_title",Y="APEX.MAPS.",X="_legend_item",Q="objectclick",ee="circledrawn",te="circleremoved",ie="map-rotate",ae="visibility",se="visible",oe="content",ne="elements",re="aria-labelledby",le="aria-label",he="crosshair",ce="pointer",de="circle-src",pe="measure-points-src",me="circle-lyr",ue="measure-points-lyr",ge="measure-lines-lyr",fe="Invalid layer ID",ye="Invalid feature ID",ve="Map initialization has not been completed",Ce={"elocation-osm-bright":"https://elocation.oracle.com/appidGC000110/mapviewer/pvt/res/style/osm-bright/style.json","elocation-osm-positron":"https://elocation.oracle.com/appidGC000110/mapviewer/pvt/res/style/osm-positron/style.json","elocation-osm-dark-matter":"https://elocation.oracle.com/appidGC000110/mapviewer/pvt/res/style/osm-dark-matter/style.json"},be={version:8,id:"elocation-osm-raster-tiles",name:"OSM Bright (Oracle)",metadata:{"sgtech:version":"19.1.0","sgtech:sources:type":"raster"},sources:{"elocation-osm-bright":{type:"raster",name:"OSM Bright (Oracle)",attribution:"",tiles:["https://elocation.oracle.com/appidGC000110/mapviewer/mcserver/ELOCATION_MERCATOR/osm_bright/{z}/{y}/{x}.png"],tileSize:256},"elocation-osm-positron":{type:"raster",name:"OSM Positron (Oracle)",attribution:"",tiles:["https://elocation.oracle.com/appidGC000110/mapviewer/mcserver/ELOCATION_MERCATOR/osm_positron/{z}/{y}/{x}.png"],tileSize:256},"elocation-bi-world-map":{type:"raster",name:"Bi World Map (Oracle)",attribution:"",tiles:["https://elocation.oracle.com/appidGC000110/mapviewer/mcserver/ELOCATION_MERCATOR/bi_world_map_mb/{z}/{y}/{x}.png"],tileSize:256},"elocation-osm-dark-matter":{type:"raster",name:"OSM Dark Matter (Oracle)",attribution:"",tiles:["https://elocation.oracle.com/appidGC000110/mapviewer/mcserver/ELOCATION_MERCATOR/osm_darkmatter/{z}/{y}/{x}.png"],tileSize:256},"elocation-world-map":{type:"raster",name:"World Map (Oracle)",attribution:"",tiles:["https://elocation.oracle.com/appidGC000110/mapviewer/mcserver/ELOCATION_MERCATOR/world_map_mb/{z}/{y}/{x}.png"],tileSize:256}},layers:[{id:"elocation-osm-bright-layer",type:"raster",source:"elocation-osm-bright",minzoom:0,maxzoom:18.01}]};function _e({scopedActions:e}){_e.numInstances=(_e.numInstances||0)+1;const t="activate-circle",i="clear-circle";this.onAdd=a=>{this.container=document.createElement("div"),this.container.className=p,this.canvas=a.getCanvasContainer(),this.startPos={},this.center=[],this.radius=null,this.geoJSONCircle=null,this.isDrawing=!1,this.isActive=!1,this.isKeyboard=!1,this.clearBtn$=null,this.startBtn$=null;const s="is-active";return this.addControls=()=>{let e=this,t="clear_cir_btn_"+_e.numInstances,i="start_cir_btn_"+_e.numInstances;e.clearBtn$=Ge(qe("CLEAR_CIRCLE"),"icon-ban",t,!1),e.startBtn$=Ge(qe("DRAW_CIRCLE"),"icon-draw-circle",i),e.clearBtn$.attr("disabled",!0),e.startBtn$.on("click",(function(){e.isActive=!e.isActive,e.isActive?(e.addListeners(),e.removeCircleLayer(),e.clearBtn$.attr("disabled",!0),o(this).addClass(s).attr("aria-pressed",!0)):e.clear(!0)})),e.clearBtn$.on("click",(function(){e.clear(!0)})),o(e.container).append(e.startBtn$),o(e.container).append(e.clearBtn$)},this.addActions=()=>{e.add([{name:t,shortcut:"C",action:()=>{this.isActive||(this.startBtn$.trigger("click"),this.begin(),this.drawShape())}},{name:i,shortcut:"D",action:()=>{this.clearBtn$.trigger("click")}}])},this.begin=e=>{if(e)this.isKeyboard=!1,this.startPos=Pe(e.originalEvent,this.canvas);else{let e=o(a.getCanvas());this.isKeyboard=!0,this.radius=30,this.startPos={x:e.width()/2,y:e.height()/2}}a.dragPan.disable(),this.center=[this.startPos.x,this.startPos.y],this.isDrawing=!0},this.createGeoJSONCircle=()=>{let e,t,i,s,o,n=this.center[1],r=this.center[0],l=[];for(let o=0;o<359;o++){let h,c,d;if(0===o)h=0,c=this.radius;else if(90===o)h=this.radius,c=0,e=a.unproject([h+r,c+n]).lng,s=Math.sign(e);else if(270===o)h=-1*this.radius,c=0,t=a.unproject([h+r,c+n]).lng,i=Math.sign(t);else{let e=o*(Math.PI/180);h=this.radius*Math.sin(e),c=h/Math.tan(e)}d=a.unproject([h+r,c+n]),l.push([d.lng,d.lat])}return l.push(l[0]),i>=0&&s>=0?o=e-t:(-1===i&&-1===s||-1===i&&s>=0)&&(o=Math.abs(t)+e),o>=360&&(this.isDrawing=!1),this.geoJSONCircle={type:"geojson",data:{type:"Feature",geometry:{type:"Polygon",coordinates:[l]}}},this.geoJSONCircle},this.drawShape=e=>{if(this.isDrawing){if(!this.isKeyboard){let t=Pe(e.originalEvent,this.canvas),i=Math.min(this.startPos.x,t.x),a=Math.max(this.startPos.x,t.x),s=Math.min(this.startPos.y,t.y),o=a-i,n=Math.max(this.startPos.y,t.y)-s;this.radius=Math.sqrt(Math.pow(o,2)+Math.pow(n,2))}a.getSource(de)?a.getSource(de).setData(this.createGeoJSONCircle().data):a.addSource(de,this.createGeoJSONCircle()),a.getLayer(me)||a.addLayer({id:me,type:"fill",source:de,layout:{},paint:{"fill-color":"#3887c8","fill-opacity":.3,"fill-outline-color":"#014c8a"}})}},this.keysHandler=e=>{if(this.isActive&&("Escape"===e.key?this.clear(!0):"Enter"===e.key&&(e.ctrlKey?(this.begin(),e.preventDefault()):this.isKeyboard&&(this.isKeyboard=!1,this.finish(),e.preventDefault())),this.isKeyboard)){let t,i,s,n,r={...this.startPos},l=this.radius,h=o(a.getCanvas()),c=h.width(),d=h.height();"ArrowUp"===e.key?e.shiftKey?l+=3:r.y-=3:"ArrowLeft"===e.key?r.x-=3:"ArrowDown"===e.key?e.shiftKey?l-=3:r.y+=3:"ArrowRight"===e.key&&(r.x+=3),t=r.x-l,i=r.x+l,s=r.y-l,n=r.y+l,t>0&&i<c&&s>0&&n<d&&l>=10&&(this.startPos={...r},this.radius=l,this.center=[this.startPos.x,this.startPos.y],this.drawShape()),e.preventDefault()}},this.fixPosition=()=>{if(this.isActive&&this.isKeyboard){let e=o(a.getCanvas()),t=e.width(),i=e.height();this.startPos.x+this.radius>t?this.startPos.x=t-this.radius:this.startPos.y+this.radius>i&&(this.startPos.y=i-this.radius),this.center=[this.startPos.x,this.startPos.y],this.drawShape()}},this.addListeners=()=>{a.on("mousedown",this.begin),a.on("mousemove",this.drawShape),o(document).on("mouseup",this.finish),o(document).on("keydown",this.keysHandler),a.dragPan.disable(),a.keyboard.disable()},this.removeListeners=()=>{a.off("mousedown",this.begin),a.off("mousemove",this.drawShape),o(document).off("mouseup",this.finish),o(document).off("keydown",this.keysHandler)},this.finish=()=>{!this.isKeyboard&&this.geoJSONCircle&&(this.clear(!1),o(this.container).trigger(ee,this.geoJSONCircle))},this.removeCircleLayer=()=>{this.geoJSONCircle=null,this.isKeyboard=!1,a.getLayer(me)&&a.removeLayer(me).removeSource(de),o(this.container).trigger(te,this.geoJSONCircle)},this.clear=e=>{a.dragPan.enable(),a.keyboard.enable(),this.removeListeners(),e&&this.removeCircleLayer(),this.clearBtn$.attr("disabled",e),this.startBtn$.removeClass(s).attr("aria-pressed",!1).trigger("focus"),this.isActive=!1,this.isDrawing=!1},this.addControls(),this.addActions(),this.container},this.onRemove=()=>{this.container.parentNode.removeChild(this.container),e.remove(i),e.remove(t)}}function Se({scopedActions:e}){Se.numInstances=(Se.numInstances||0)+1;const t="activate-rectangle";this.onAdd=i=>(this.container=document.createElement("div"),this.container.className=p,this.isActive=!1,this.isDrawing=!1,this.isKeyboard=!1,this.box=null,this.startPos={},this.endPos={},this.startLatLng=null,this.button$=null,this.canvasCont=i.getCanvasContainer(),this.addControls=()=>{let e=this,t="start_rect_btn_"+Se.numInstances;this.button$=Ge(qe("RECTANGLE_ZOOM"),"icon-zoom-draw",t),this.button$.on("click",(function(){e.isActive=!e.isActive,e.isActive?(e.addListeners(),i.getCanvas().style.cursor=he,o(this).addClass("is-active").attr("aria-pressed",!0)):e.deactivate()})),o(e.container).append(this.button$)},this.addAction=()=>{e.add({name:t,shortcut:"R",action:()=>{this.isActive||(this.button$.trigger("click"),this.begin(),this.drawRectangle())}})},this.begin=e=>{if(e){const{lngLat:t,originalEvent:i}=e;this.isKeyboard=!1,this.startLatLng=t,this.startPos=Pe(i,this.canvasCont)}else{let e=o(i.getCanvas()),t=e.width()/2,a=e.height()/2;this.isKeyboard=!0,this.startPos={x:t-20,y:a-20},this.endPos={x:t+20,y:a+20},this.startLatLng=i.unproject([this.startPos.x,this.startPos.y])}this.isDrawing=!0,i.dragPan.disable()},this.drawRectangle=e=>{if(i.getCanvas().style.cursor!==he&&(i.getCanvas().style.cursor=he),this.isDrawing){let t,i,a,s,o;this.isKeyboard||(this.endPos=Pe(e.originalEvent,this.canvasCont)),this.box||(this.box=document.createElement("div"),this.box.className="a-MapRegion-zoomOverlay",this.canvasCont.appendChild(this.box)),t=Math.min(this.startPos.x,this.endPos.x),i=Math.max(this.startPos.x,this.endPos.x),a=Math.min(this.startPos.y,this.endPos.y),s=Math.max(this.startPos.y,this.endPos.y),o="translate("+t+"px,"+a+"px)",this.box.style.transform=o,this.box.style.WebkitTransform=o,this.box.style.width=i-t+"px",this.box.style.height=s-a+"px"}},this.finish=e=>{let t={};if(this.isKeyboard?(t=i.unproject([this.endPos.x,this.endPos.y]),this.startLatLng=i.unproject([this.startPos.x,this.startPos.y])):t=e.lngLat,this.startLatLng.lat.toFixed(2)!==t.lat.toFixed(2)&&this.startLatLng.lng.toFixed(2)!==t.lng.toFixed(2)){let e=[[this.startLatLng.lng,this.startLatLng.lat],[t.lng,t.lat]],a=e.reduce((function(e,t){return e.extend(t)}),new maplibregl.LngLatBounds(e[0],e[0]));i.fitBounds(a,{padding:20,pitch:i.getPitch(),bearing:i.getBearing()})}this.deactivate()},this.deactivate=()=>{this.removeListeners(),i.getCanvas().style.cursor="",this.isDrawing=!1,this.isActive=!1,this.isKeyboard=!1,this.box&&(this.box.parentNode.removeChild(this.box),this.box=null),this.button$.removeClass("is-active").attr("aria-pressed",!1)},this.keysHandler=e=>{if(this.isActive&&("Escape"===e.key?this.deactivate():"Enter"===e.key&&(e.ctrlKey?(this.begin(),this.drawRectangle(),e.preventDefault()):this.isKeyboard&&(this.finish(),e.preventDefault())),this.isKeyboard)){let t={...this.startPos},a={...this.endPos},s=o(i.getCanvas()),n=s.width(),r=s.height();"ArrowUp"===e.key?(t.y-=3,e.shiftKey||(a.y-=3)):"ArrowLeft"===e.key?(a.x-=3,e.shiftKey||(t.x-=3)):"ArrowDown"===e.key?(t.y+=3,e.shiftKey||(a.y+=3)):"ArrowRight"===e.key&&(a.x+=3,e.shiftKey||(t.x+=3)),t.x>0&&t.x<n&&t.y>0&&t.y<r&&a.x>0&&a.x<n&&a.y>0&&a.y<r&&(this.startPos={...t},this.endPos={...a},this.drawRectangle()),e.preventDefault()}},this.fixPosition=()=>{if(this.isActive){let e=o(i.getCanvas()),t=e.width(),a=e.height(),s={...this.startPos},n={...this.endPos};s.x>t||this.endPos.x>t?(this.endPos.x=t,this.startPos.x=t,s.x>n.x?this.endPos.x-=s.x-n.x:this.startPos.x-=n.x-s.x):(s.y>a||this.endPos.y>a)&&(this.startPos.y=a,this.endPos.y=a,s.y>n.y?this.endPos.y-=s.y-n.y:this.startPos.y-=n.y-s.y),this.drawRectangle()}},this.addListeners=()=>{i.on("mousedown",this.begin),i.on("mousemove",this.drawRectangle),i.on("mouseup",this.finish),o(document).on("keydown",this.keysHandler),i.dragPan.disable(),i.keyboard.disable()},this.removeListeners=()=>{i.off("mousedown",this.begin),i.off("mousemove",this.drawRectangle),i.off("mouseup",this.finish),o(document).off("keydown",this.keysHandler),i.dragPan.enable(),i.keyboard.enable()},this.addControls(),this.addAction(),this.container),this.onRemove=()=>{this.container.parentNode.removeChild(this.container),e.remove(t)}}function we(t){we.numInstances=(we.numInstances||0)+1,this.tileLayer=t.tileLayer,this.unitSystem=t.unitSystem,this.onAdd=t=>(this.map=t,this.container=document.createElement("div"),this.container.className=p,this.isActive=!1,this.measureFeatures=[],this.mapContainerId=o(this.map.getContainer()).attr("id"),this.distanceContainer$=null,this.distanceRad=null,this.button$=null,this.addControls=()=>{let e=this,t="start_dist_btn_"+we.numInstances;this.button$=Ge(qe("DISTANCE_TOOL"),"icon-ruler",t),this.button$.on("click",(function(){e.isActive=!e.isActive,e.isActive?(e.map.getCanvas().style.cursor=he,o(this).addClass("is-active").attr("aria-pressed",!0),e.addLayers(),e.addDistanceContainer(),e.addEventListeners()):e.deactivate()})),o(e.container).append(this.button$)},this.watchCursor=e=>{let t=this.map.queryRenderedFeatures(e.point,{layers:[ue]});this.map.getCanvas().style.cursor=t.length?ce:he},this.setUnit=e=>{this.unitSystem=e,this.updateContainer()},this.updateDistance=e=>{let t={type:"Feature",geometry:{type:"LineString",coordinates:[]}},i=this.map.queryRenderedFeatures(e.point,{layers:[ue]});if(this.measureFeatures.length>1&&this.measureFeatures.pop(),i.length){let e=i[0].properties.id;this.measureFeatures=this.measureFeatures.filter((function(t){return t.properties.id!==e}))}else{let t={type:"Feature",geometry:{type:"Point",coordinates:[e.lngLat.lng,e.lngLat.lat]},properties:{id:String(Math.random())}};this.measureFeatures.push(t)}this.measureFeatures.length>1?(t.geometry.coordinates=this.measureFeatures.map((e=>e.geometry.coordinates)),this.measureFeatures.push(t),this.distanceRad=this.getTotalDistance(t),this.updateContainer()):(this.distanceContainer$.html(""),this.distanceRad=null),this.map.getSource(pe).setData({type:"FeatureCollection",features:this.measureFeatures})},this.updateContainer=()=>{if(this.distanceRad){let e=document.createElement("span"),t=qe("MILES"),i=qe("KM");this.distanceContainer$.html(""),e.textContent=qe("TOTAL_DISTANCE")+": "+this.radiansToUnits(this.distanceRad,this.unitSystem).toLocaleString()+" "+("imperial"===this.unitSystem?t:i),this.distanceContainer$.append(e)}},this.addLayers=()=>{let e=(We()?this.tileLayer.darkmodeName:this.tileLayer.name)===_?"#f0f0f0":"#000";this.measureFeatures=[],this.map.addSource(pe,{type:"geojson",data:{type:"FeatureCollection",features:this.measureFeatures}}),this.map.addLayer({id:ue,type:"circle",source:pe,paint:{"circle-radius":5,"circle-color":e},filter:["in","$type","Point"]}),this.map.addLayer({id:ge,type:"line",source:pe,layout:{"line-cap":"round","line-join":"round"},paint:{"line-color":e,"line-width":2},filter:["in","$type","LineString"]})},this.getTotalDistance=e=>{let t=0,i=e.geometry.coordinates,a=i[0];for(let e=1;e<i.length;e++)t+=this.getSegmentDistance(a,i[e]),a=i[e];return t},this.getSegmentDistance=(e,t)=>{let i=this.degreesToRad(t[1]-e[1]),a=this.degreesToRad(t[0]-e[0]),s=this.degreesToRad(e[1]),o=this.degreesToRad(t[1]),n=Math.pow(Math.sin(i/2),2)+Math.pow(Math.sin(a/2),2)*Math.cos(s)*Math.cos(o);return 2*Math.atan2(Math.sqrt(n),Math.sqrt(1-n))},this.degreesToRad=e=>e%360*Math.PI/180,this.radiansToUnits=(e,t)=>{let a;return t&&!Ye(t)&&i.warn("Unit system must be a string"),a=z[t||"metric"],a||i.error(t+" unit system is invalid"),e*a},this.removeLayers=()=>{this.measureFeatures=[],this.map.removeLayer(ue),this.map.removeLayer(ge),this.map.removeSource(pe)},this.addDistanceContainer=()=>{let t=o("#"+e.escapeCSS(this.mapContainerId));if(t.find("."+d).length<1){let e=We()?this.tileLayer.darkmodeName:this.tileLayer.name;this.distanceContainer$=o("<div class='"+d+"'></div>"),t.append(this.distanceContainer$),e===_?this.distanceContainer$.removeClass("a-MapRegion-distance--dark").addClass("a-MapRegion-distance--light"):this.distanceContainer$.removeClass("a-MapRegion-distance--light").addClass("a-MapRegion-distance--dark")}},this.removeDistanceContainer=()=>{this.distanceContainer$.remove()},this.addEventListeners=()=>{this.map.on("click",this.updateDistance),this.map.on("mousemove",this.watchCursor)},this.removeEventListeners=()=>{this.map.off("click",this.updateDistance),this.map.off("mousemove",this.watchCursor)},this.deactivate=()=>{this.map.getCanvas().style.cursor="",this.button$.removeClass("is-active").attr("aria-pressed",!1),this.removeLayers(),this.removeDistanceContainer(),this.removeEventListeners()},this.addControls(),this.container),this.onRemove=()=>{this.container.parentNode.removeChild(this.container),this.map=void 0}}function Me(){Me.numInstances=(Me.numInstances||0)+1,this.onAdd=e=>(this.map=e,this.container=document.createElement("div"),this.container.className=p,this.isActive=!0,this.layersIds=[],this.button$=null,this.addControls=()=>{let e="toggle_dim_btn_"+Me.numInstances,t=qe("TOGGLE_2D_MODE"),i=qe("TOGGLE_3D_MODE");this.button$=Ge(t,g,e,!1),this.button$.on("click",(()=>{this.isActive=!this.isActive,this.button$.find("span").removeClass(),this.isActive?(this.setExtrusionHeight(["get","height"]),this.button$.attr({title:t,"aria-label":t}).find("span").addClass(u+" "+g)):(this.setExtrusionHeight(0),this.button$.attr({title:i,"aria-label":i}).find("span").addClass(u+" icon-3d-mode"))})),o(this.container).append(this.button$)},this.setExtrusionHeight=e=>{this.layersIds.forEach((t=>{this.map.setPaintProperty(t,"fill-extrusion-height",e)}))},this.addLayerId=e=>{this.layersIds.push(e)},this.getButton=()=>this.button$,this.addControls(),this.container),this.onRemove=()=>{this.container.parentNode.removeChild(this.container),this.map=void 0}}function Le(e,t,i,a,s){this.width=Math.round(i+5),this.height=Math.round(t+5),this.data=new Uint8Array(this.width*this.height*4),this.fontFamily=e,this.iconPixels=t,this.faUnicode=a,this.fillColor=s,this.onAdd=()=>{this.context=Te(this.width,this.height)},this.render=()=>(this.context.clearRect(0,0,this.width,this.height),this.context.beginPath(),this.context.font=`${this.iconPixels}px ${this.fontFamily}`,this.context.fillStyle=this.fillColor,this.context.fillText(this.faUnicode,this.width/2,this.height/1.18),this.context.textAlign="center",this.context.fill(),this.data=this.context.getImageData(0,0,this.width,this.height).data,!0)}function xe(t){const{width:i,height:a}=t;this.width=Math.round(i),this.height=Math.round(a),this.data=new Uint8Array(this.width*this.height*4),this.svgShapeJSON=t,this.onAdd=()=>{this.context=Te(this.width,this.height)},this.render=()=>{let t=function(t){let i=e.htmlBuilder();i.markup('<svg xmlns="http://www.w3.org/2000/svg"'),Object.entries(t).forEach((([e,t])=>{if(t&&!["imgId",oe,ne].includes(e)){let a="height"===e||"width"===e?Math.round(t):t;i.attr(e,a)}})),i.markup(">").markup(Ie(t.elements)),t.content&&i.content(e.escapeHTML(t.content));return i.markup("</svg>"),i.toString()}(this.svgShapeJSON),i=new Image,a=new Blob([t],{type:"image/svg+xml"}),s=window.URL.createObjectURL(a);return i.onload=()=>{this.context.clearRect(0,0,this.width,this.height),this.context.drawImage(i,0,0),window.URL.revokeObjectURL(s)},i.src=s,this.data=this.context.getImageData(0,0,this.width,this.height).data,!0}}function ke(e){let t=e.tileLayer,i=t.type===S?We()?t.http_headers_dark:t.http_headers:e.useVectorTileLayers?{"x-oracle-pvtile":"OracleSpatial"}:null;if(!je(i))return(e,t)=>{let a={url:e};return"Tile"===t&&(a.credentials="include",a.headers=i),a}}function Te(e,t){let i=document.createElement("canvas");return i.width=e,i.height=t,i.getContext("2d",{willReadFrequently:!0})}function Ie(t){let i=e.htmlBuilder();for(let a=0;a<t.length;a++){let s=t[a];i.markup(`<${s.type}`),Object.entries(s).forEach((([e,t])=>{t&&!["type",oe,ne].includes(e)&&i.attr(e,t)})),i.markup(">"),s.elements&&i.markup(Ie(s.elements)),s.content&&i.content(e.escapeHTML(s.content)),i.markup(`</${s.type}>`)}return i.toString()}function Pe(e,t){let i=t.getBoundingClientRect();return new maplibregl.Point(e.clientX-i.left-t.clientLeft,e.clientY-i.top-t.clientTop)}async function Ae(e){if(e){let t=await fetch(e,{credentials:"omit",cache:"no-store",referrerPolicy:"no-referrer"});if(t.ok){let e=await t.json(),{sources:i={}}=e;return i.openmaptiles&&i.openmaptiles.attribution&&(i.openmaptiles.attribution=""),e}i.error("An error has occured while fetching: "+t.url+" Status: "+t.status)}}function Oe(e){let t=e.clusterFeatures.color;return t||(t=e.style.color),t}function Fe(e){let t=2.5,i=e.clusterFeatures;if(i){const{clusterSvgShapeSize:e=2.5}=i;t=e}return t>0&&t<=10?t:2.5}function Re(e,t){let i=e.style.color;return i||(i=t.color),i}function Be(e){return window.getComputedStyle(document.documentElement).getPropertyValue(`--a-palette-color-${e}`)}function Ee(e,t,i){let a;return a="feat"===e?!!t.style.color||!!i.color:!!t.clusterFeatures.color,a}function ze(e,t,i){let a=e.style.svg.strokeColor;return a||(a=t.strokeColor),!a&&i&&(a=N),a}function De(e,t){let a=e.style.svg.pointSvgShapeSize;return a||(a=t.pointSvgShapeSize?t.pointSvgShapeSize:1),a>50&&(i.warn("Shape Size of ( "+a+" ) exceeds maximum."),a=50),a>0?a:2}function $e(e){const{fillOpacity:t=1}=e.style.svg;return t>=0&&t<=1?t:1}function Ne(e){let t=window.getComputedStyle(e,":before").content.replace(/['"]/g,""),i=t.charCodeAt(0).toString(16);return"none"!==t?String.fromCharCode(parseInt(i,16)):null}function Ze(e){let t=document.createElement("span");return t.className=e,t.style.position="absolute",t.style.visibility="hidden",document.body.appendChild(t),t}function Ve(e,t){let i=e.min,a=e.max,s=Math.sign(i),o=Math.sign(a),n=0;return i!==a&&(s>=0&&o>=0?n=(a-i)/t:-1===s&&-1===o?n=(Math.abs(i)-Math.abs(a))/t:-1===s&&o>=0&&(n=(Math.abs(i)+a)/t)),n}function He(e,t,i){let a={};return e[i]?(a.type=P,a.content=e[i],a.columns=t.columns):t[i]&&(a.type=A,a.content=t[i]),a}function Ge(t,i,a,s=!0){let n=e.htmlBuilder();return n.markup("<button type='button'").attr("id",a).attr("title",t).attr(le,t),s&&n.attr("aria-pressed",!1),n.markup(">").markup("<span aria-hidden='true'").attr("class",`${u} ${i}`).markup(">").markup("</span>").markup("</button>"),o(n.toString())}function je(e){return Ye(e)&&(e=Je(e)),!e||0===Object.keys(e).length}function Ue(e){return["case",["!=",V,null],V,e]}function We(){return o("body").hasClass("apex-theme-vita-dark")}function Ke(e){let t,i=e,a=Math.sign(i[2]),s=Math.sign(i[0]);return s>=0&&a>=0?t=i[2]-i[0]:(-1===s&&-1===a||-1===s&&a>=0)&&(t=Math.abs(i[0])+i[2]),t>=360&&Math.abs(i[1])+Math.abs(i[3])>=170}function qe(e){return a.getMessage(Y+e)}function Je(e){try{return JSON.parse(e)}catch(e){return null}}function Ye(e){return"string"==typeof e}function Xe(e){return"boolean"==typeof e}function Qe(e){return"object"==typeof e}function et(e){return e===I||"Multipoint"===e}o.widget("apex.spatialMap",{widgetEventPrefix:"spatialMap",options:{regionStaticId:null,ajaxIdentifier:null,lazyLoading:!1,copyrightNotice:null,mapUnitSystem:"metric",layers:null,tileLayer:null,navigationBar:null,initPosition:{lon:0,lat:0,zoom:1,bearing:0,pitch:0,getFromBrowser:!1,basedOnFeatures:!1,basedOnFeaturesMaxZoom:!1},resetMapPosition:!1,itemsToSubmit:null,mapFeatures:{mousewheelZoom:!1,scaleBar:!1,circleTool:!1,browserLocation:!1,rectangleZoom:!1,distanceTool:!1,overviewMap:!1,infiniteMap:!1},mapStatusItem:null,layerMessages:null,customStyles:[],filterRegionId:null,mapData:null,legend:null,useVectorTileLayers:!1,initialized:null,click:null,objectclick:null,changed:null},_create:function(){let t=this.options,i=this.element;this._super(),this.mapContainerId=t.regionStaticId+"_map",this.regionContainer$=o("#"+e.escapeCSS(t.regionStaticId)+"_map_region"),this.componentContainer$=null,this.messagesContainer$=null,this.legendContainer$=null,this.overViewMapCont$=null,this.overViewMap=null,this.overviewSquare=null,this.rectangleZoomTool={},this.distanceTool={},this.circleTool=null,this.browserLocationTool=null,this.navControl=null,this.scaleBar=null,this.toggleDimensionsCtrl=null,this.attribution=null,this.map=null,this.svgStyles=B,this.topLayer=null,this.layersIds=[],this.lastMapStatusOnFetch={},this.colorNumDef=0,this.setDefaultColor=!1,this.tooltip=new maplibregl.Popup({closeButton:!1}),this.sessionStore=apex.storage.getScopedSessionStorage({prefix:"ORA_WWV_apex.spatialMap",useAppId:!0,usePageId:!0,regionId:t.regionStaticId}),this.scopedActions,l.create(t.regionStaticId,(function(e){e.type="SpatialMap",e.widgetName="spatialMap",e.filterRegionId=t.filterRegionId,e.widget=()=>i,r.makeInterfaceFromWidget(e,i,"spatialMap",[],["ajaxIdentifier","filterRegionId","regionStaticId"])})),this._render(),this._setSessionStoreInitPos(!t.resetMapPosition),this._initMap(t.resetMapPosition)},_setSessionStoreInitPos:function(e){let t=this.options;if(e)try{let e=parseFloat(this.sessionStore.getItem(G)),i=parseFloat(this.sessionStore.getItem(j)),a=parseFloat(this.sessionStore.getItem(U)),s=parseFloat(this.sessionStore.getItem(K)),o=parseFloat(this.sessionStore.getItem(W));e&&!isNaN(e)&&e>=1&&e<=18&&(t.initPosition.zoom=e),i&&a&&!isNaN(i)&&!isNaN(a)&&(t.initPosition.lon=i,t.initPosition.lat=a),s&&!isNaN(s)&&(t.initPosition.pitch=s),o&&!isNaN(o)&&(t.initPosition.bearing=o)}catch(e){i.warn("Failed to restore map state from session ",e)}else this._cleanupSessionStore()},_render:function(){let t=this.options,i=e.htmlBuilder(),a=this.regionContainer$.attr("data-map-height");i.markup("<div class='a-MapRegion-container'").attr("style","height:"+a).markup(">").markup("<div class='a-MapRegion-map' ").attr("id",this.mapContainerId).attr("data-action","useTool").markup("></div>").markup("</div>"),this.componentContainer$=o(i.toString()),this.regionContainer$.append(this.componentContainer$),t.legend&&this._addLegend(),t.layerMessages&&this._addMessagesContainer()},_getElocation:async function(){const{name:e,darkmodeName:t,type:i}=this.options.tileLayer;let a=o.extend(!0,{},be),s=We(),n="elocation-";function r(){a.layers[0].id=n+"-layer",a.layers[0].source=n,a.name=a.sources[n].name}if(n+=(s?t:e).toLowerCase().replace(/ +/g,"-"),i===S){const i="{api-key}",o="RASTER",l="OGCWMS",{url:h,url_dark:c,attribution:d,attribution_dark:p,api_key:m,api_key_dark:u,layer_type:g,layer_type_dark:f}=this.options.tileLayer;let y=this.options.copyrightNotice?null:s?p:d,v=s?c.replace(i,u):h.replace(i,m),C=s?f:g;if("VECTOR"===C)a=Ae(v);else if([o,l].includes(C)){if(C===l){let e=v.match(/(^|[&])version=([^&]*)/);v+="&request=GetMap&bbox={bbox-epsg-3857}&format=image/png&"+(null!==e&&parseFloat(e[2])>=1.3?"crs":"srs")+"=EPSG:3857&width=256&height=256"}a.sources[n]={type:o.toLowerCase(),name:s?t:e,attribution:y||"",tiles:[v],tileSize:256},r()}}else{let e=Ce[n];this.options.useVectorTileLayers&&e?a=Ae(e):r()}return a},_initMap:function(e){const{lon:t,lat:i,zoom:a,pitch:s,bearing:o}=this.options.initPosition;let r=this,l=this.options,h=l.mapFeatures,d={container:r.mapContainerId,renderWorldCopies:h.infiniteMap,trackResize:!0,center:[t,i],attributionControl:!1,transformRequest:ke(l),bearing:o,pitch:s,zoom:a,...this._getMinMaxZoomLevels(),locale:{"Map.Title":qe("MAP")}};(async()=>{d.style=await r._getElocation(),"unavailable"===maplibregl.getRTLTextPluginStatus()&&(maplibregl.setRTLTextPlugin(c,!0),window.addEventListener("unhandledrejection",(function(e){e.reason.message.startsWith("RTL Text Plugin failed to import scripts from")&&"loaded"===maplibregl.getRTLTextPluginStatus()&&e.preventDefault()}))),r.map=new maplibregl.Map(d),this.scopedActions=n.createContext("activateTools",r.map.getContainer()),r._addNavControl(l.navigationBar.type),r._addCopyrightNotice(),h.rectangleZoom&&r._addRectangleTool(),h.scaleBar&&r._addScaleTool(),h.overviewMap&&r._addOverviewMap(),h.browserLocation&&r._addBrowserLocation(),h.circleTool&&r._addCircleTool(),h.distanceTool&&r._addDistanceTool(),h.mousewheelZoom||r.map.scrollZoom.disable(),l.customStyles&&r._addCustomSvgStyles(l.customStyles),r.map.on("load",(function(){const{basedOnFeatures:t,getFromBrowser:i}=l.initPosition;l.lazyLoading?r._fetch(!1,(()=>{!i&&t&&e&&r._fitBounds(l.mapData.map.bbox,l.initPosition.basedOnFeaturesMaxZoom)})):(r._addLayers(),!i&&t&&e&&r._fitBounds(l.mapData.map.bbox,l.initPosition.basedOnFeaturesMaxZoom),r.lastMapStatusOnFetch=r.getMapStatus(),r.lastMapStatusOnFetch.center=r.map.getCenter()),i&&e&&r.browserLocationTool.trigger(),r._addMapHandlers(),r._storeMapPosition(),r._trigger("initialized",{},{})}))})()},_storeMapPosition:function(){const e=this.map.getCenter(),{bbox:t,zoom:i}=this.getMapBboxAndZoomLevel();this.sessionStore.setItem(G,i),this.sessionStore.setItem(j,e.lng),this.sessionStore.setItem(U,e.lat),this.options.mapStatusItem&&this._updateMapStatusItem({bbox:t,zoom:i})},_getMinMaxZoomLevels:function(){const{type:e,zoom_min:t=D,zoom_max:i=$,zoom_min_dark:a=D,zoom_max_dark:s=$}=this.options.tileLayer;let o=e===S,n=We();return{minZoom:o?n?a:t:D,maxZoom:o?n?s:i:18}},_addCopyrightNotice:function(){let e,t=this.options;this.attribution=new maplibregl.AttributionControl({customAttribution:t.copyrightNotice}),this.map.addControl(this.attribution),e=o(this.attribution._container).find("button"),e.attr({type:"button",title:qe("TOGGLE_COPYRIGHT"),"aria-label":qe("TOGGLE_COPYRIGHT")})},_addMapHandlers:function(){let t=this,i=!1;r.onElementResize(e.escapeCSS(t.mapContainerId),(()=>{t._resize(),this.circleTool&&this.circleTool.fixPosition(),je(this.rectangleZoomTool)||this.rectangleZoomTool.fixPosition()})),r.onVisibilityChange(t.regionContainer$[0],(e=>{e&&t._resize()})),o(t.map.getCanvas()).on("keyup",(function(e){t.map.keyboard.isEnabled()&&["ArrowUp","ArrowDown","ArrowLeft","ArrowRight"].includes(e.code)&&(i=!0)})),t.map.on("click",(function(e){t.topLayer=t._getTopLayer(e.point),t.topLayer||t._trigger("click",{},{...e.lngLat})})).on("mousemove",(function(e){t.topLayer=t._getTopLayer(e.point)})).on("rotate",(function(){const{pitch:e,bearing:i}=t.getMapPitchAndBearing();t.sessionStore.setItem(K,e),t.sessionStore.setItem(W,i),t.overViewMap&&(t.overViewMap.setPitch(e),t.overViewMap.setBearing(i))})).on("rotateend",(function(){t._fireMapChangedEvent(ie),t._fetchOnMapRotated()})).on("dragend",(function(){t._fireMapChangedEvent("map-drag"),t._fetchOnMapDragged()})).on("move",(function(){if(t._storeMapPosition(),t.overViewMap){const e=t.map.getCenter(),{zoom:i}=t.getMapBboxAndZoomLevel();t.overViewMap.setCenter(e),t.overViewMap.setZoom(i-3),t.overviewSquare.setLngLat(e)}})).on("moveend",(function(){i&&(t._fireMapChangedEvent("map-drag"),t._fetchOnMapDragged(),i=!1)})).on("zoomend",(function(){t._fireMapChangedEvent("map-zoom"),t._fetchOnZoomChanged()})).on("resize",(function(){t._fireMapChangedEvent("map-resized"),t._fetchOnMapDragged()}))},_fetchOnZoomChanged:function(){let e=this.options.layers,t=this.map.getZoom();if(e){let i=!1;for(let a=0;a<e.length;a++){let s=e[a].id;if(this._isHiddenLayer(s))this._hideLegendItem(s);else{const{lng:o,lat:n}=this.map.getCenter(),{lng:r,lat:l}=this.lastMapStatusOnFetch.center;this._showLegendItem(s),!i&&(!this.map.getLayer(s)&&!e[a]._isFetched||e[a].useSpatialIndex&&this._isVisibleLayer(s)&&(t<this.lastMapStatusOnFetch.zoom||Math.round(o)!==Math.round(r)||Math.round(n)!==Math.round(l)))&&(this._fetch(!0),i=!0)}}}i.info(`Map Region ${this.options.regionStaticId}: Zoom level changed to ${t}`)},_fetchOnMapRotated:function(){let e=this.options.layers;const{bbox:t}=this.lastMapStatusOnFetch;if(e&&!Ke(t)){let t=!1;for(let i=0;i<e.length;i++){let a=e[i].id;if(this._isHiddenLayer(a))this._hideLegendItem(a);else if(this._showLegendItem(a),!t&&e[i].useSpatialIndex&&this._isVisibleLayer(a)){const{pitch:e,bearing:i}=this.getMapPitchAndBearing(),{pitch:a,bearing:s}=this.lastMapStatusOnFetch;e===a&&i===s||(this._fetch(!0),t=!0)}}}},_fetchOnMapDragged:function(){let e=this.options.layers;if(e){const{bbox:t}=this.getMapBboxAndZoomLevel(),{bbox:i}=this.lastMapStatusOnFetch;if((t[0]<i[0]||t[1]<i[1]||t[2]>i[2]||t[3]>i[3])&&!Ke(i)){let t=!1;for(let i=0;i<e.length;i++){let a=e[i].id;this._isHiddenLayer(a)?this._hideLegendItem(a):(this._showLegendItem(a),!t&&e[i].useSpatialIndex&&this._isVisibleLayer(a)&&(this._fetch(!0),t=!0))}}}},_getTopLayer:function(e){let t,i=this.map.queryRenderedFeatures(e,{layers:this.layersIds});return i.length>0&&(t=i[0].layer.id),t},_fireMapChangedEvent:function(e,t){let i,a=[];const{bbox:s,zoom:o}=this.getMapBboxAndZoomLevel(),{pitch:n,bearing:r}=this.getMapPitchAndBearing();this.options.layers&&this.options.layers.forEach((e=>{a.push({id:e.id,name:e.name,visible:this._isVisibleLayer(e.id)&&!this._isHiddenLayer(e.id)})})),i={changeType:e,layers:a,bbox:s,zoom:o,pitch:n,bearing:r},t&&(i.circle=t),this._trigger("changed",{},i)},_isVisibleLayer:function(e){let t=e.toString(),i=!1;return this.map.getLayer(t)&&(i=this.map.getLayoutProperty(t,ae)===se),i},_isHiddenLayer:function(e){let t=this.options.layers.find((t=>Number(t.id)===Number(e))),i=!1;if(t){let e=Math.round(this.map.getZoom());const{minZoom:a,maxZoom:s}=this._getMinMaxZoomLevels(),{minZoom:o=a,maxZoom:n=s}=t;i=!(e>=o&&e<=n)}return i},_bboxToGeoJSON:function(e){return{type:"Polygon",coordinates:[[[e[0],e[1]],[e[2],e[1]],[e[2],e[3]],[e[0],e[3]],[e[0],e[1]]]]}},_updateMapStatusItem:function(e){apex.item(this.options.mapStatusItem).setValue(JSON.stringify(this._bboxToGeoJSON(e.bbox)))},_addLayers:async function(){let t,i=this.options,a=i.mapData.map.series,s=!1,n=!1;const r=i.regionStaticId+"_adding_layers";e.delayLinger.start(r,(()=>{t=e.showSpinner(this.regionContainer$)}));for(let e=0;e<a.length;e++){let t=a[e].id.toString(),o=this._getLayerInfo(a[e].id),r=a[e].features.length>0,l=t+q,h={};r||this._addMessageItem(o,a[e].noDataFoundMessage),h=await this._getGeoJSONData(a[e],o),this.map.getLayer(t)?(this.map.getSource(l).setData(h),s=!0):(o._isFetched=!0,r&&h&&(a[e].style.layerType===x&&this._addExtrusionCtrl(),this.map.addSource(l,this._getSourceObject(h,a[e].clusterFeatures)),this.map.addLayer(await this._getLayerObject(a[e],h,o)),i.legend&&a[e].legend&&this._addLegendItem(a[e],o,h),this._addMessageItem(o,a[e].moreDataFoundMessage),this._addLayerHandlers(a[e]),o.activePopups={},this.layersIds.push(t),n=!0))}if(s&&n)for(let e=0;e<a.length;e++){let t=a[e].id.toString();if(this.map.getLayer(t)&&this.map.moveLayer(t),i.legend&&a[e].legend){let e=o(`#${t+X}`);this.legendContainer$.prepend(e)}}e.delayLinger.finish(r,(()=>{t&&t.remove()}))},_getSourceObject:function(e,t){const{clusterRadius:i=80}=t||{};return{type:"geojson",data:e,buffer:1,generateId:!0,cluster:!!t,clusterMaxZoom:14,clusterRadius:i}},_getLayerObject:async function(e,t,i){const{minZoom:a,maxZoom:s}=this._getMinMaxZoomLevels(),{minZoom:o=a,maxZoom:n=s}=i;let r=e.clusterFeatures,l=e.id.toString(),h=l+"-cluster",c=["get","fill"],d={id:l,source:l+q,minzoom:o>.5?o-.5:o,maxzoom:n<$-.49?n+.49:n,layout:{}};if(e.style.useColorSpectrum&&(c=function(e,t){const{style:{layerType:i}}=e;let a=[],s=t;if(i===L){let e=1/s.length;a=["interpolate",["linear"],["heatmap-density"],0,"rgba(33,102,172,0)"];for(let t=0;t<s.length;t++)a.push(e*(t+1)),a.push(s[t])}else if(i===w||i===x){let t=Ve(e.valueColumn,s.length);if(a=["interpolate",["linear"],["get","value"]],0!==t)for(let i=0;i<s.length;i++){let o=e.valueColumn.min+t*(i+1);a.push(o),a.push(s[i])}else a=s[0]}return a}(e,t.spectrumColors)),t.layerType===T){let t=H;r&&(t=["case",["!=",H,null],H,.05*Fe(e)],this.map.hasImage(h)||await this._addUrlImage(r.clusterImageUrl,h)),d.type="symbol",d.layout={"icon-image":Ue(h),"icon-size":t,"icon-overlap":"always","text-overlap":"always","icon-anchor":"bottom"},d.paint={"icon-opacity":$e(e)}}else if(t.layerType===k){if(r){let t=Oe(e);t||(t=Be(this.colorNumDef)),await this._addFontIcon(h,r.clusterIconCssClasses,t)}d.type="symbol",d.layout={"icon-image":Ue(h),"icon-overlap":"always","text-overlap":"always","icon-anchor":"bottom"},d.paint={"icon-opacity":$e(e)}}else if("svg"===t.layerType){if(r){const{strokeColor:t,strokeWidth:i}=e.style.svg;let a=Ee("cluster",e)?Oe(e):Be(this.colorNumDef),s=t||N,o=r.clusterSvgShape;this.svgStyles[o]||(o=R),this._addSvgShape({imageId:h,name:o,color:a,size:Fe(e),stroke:s,opacity:$e(e),strokeWidth:i})}d.type="symbol",d.layout={"icon-image":Ue(h),"icon-overlap":"always","text-overlap":"always","icon-anchor":"bottom"}}else if(t.layerType===w)d.type="fill",d.paint={"fill-color":c,"fill-opacity":$e(e)},t.features[0].properties.stroke&&(d.paint["fill-outline-color"]=["get","stroke"]);else if(t.layerType===M){const t={solid:[1],dotted:[.1,2],dashed:[2,4],"dot-dashed":[.1,2,2,2]},i={solid:[1],dotted:[.1,1],dashed:[1,2],"dot-dashed":[.001,2,1,2]},{strokeWidth:a=4,strokeStyle:s}=e.style.svg;d.type="line",d.layout={"line-join":"round","line-cap":"round"},d.paint={"line-color":c,"line-width":a,"line-dasharray":["step",["zoom"],["literal",i[s]],1,["literal",i[s]],4,["literal",t[s]]]}}else if(t.layerType===L){let t=1,i=3;if(e.valueColumn){let a=Ve(e.valueColumn,10);t=function(e,t){let i=["interpolate",["linear"],["get","value"]];if(0!==e)for(let a=0;a<=10;a++){let s=t+e*a;i.push(s),i.push(.7*(a+1))}else i=1;return i}(a,e.valueColumn.min),i=function(e,t){let i=["interpolate",["linear"],["zoom"],1,["interpolate",["linear"],["get","value"]],12,["interpolate",["linear"],["get","value"]]];if(0!==e)for(let a=0;a<10;a++){let s=t+e*a;i[4].push(s),i[4].push(.4*(a+1)),i[6].push(s),i[6].push(3*(a+1))}else i=3;return i}(a,e.valueColumn.min)}d.type="heatmap",d.paint={"heatmap-weight":t,"heatmap-intensity":1,"heatmap-color":c,"heatmap-radius":i,"heatmap-opacity":$e(e)}}else t.layerType===x&&(d.type="fill-extrusion",d.paint={"fill-extrusion-color":c,"fill-extrusion-height":["get","height"],"fill-extrusion-opacity":$e(e)},this.toggleDimensionsCtrl.addLayerId(l));return d.layout.visibility=se,d},_getGeoJSONData:async function(e,t){let a=this.colorNumDef<15?this.colorNumDef+1:1,s=Be(a),o={type:"FeatureCollection",features:[],layerType:e.style.layerType};if(e.style.useColorSpectrum){let t=function(e){let t=[];const{colorSpectrum:i,colorSpectrumName:a}=e.style;i?i.replace(/\s/g,"").replace(/(#[0-9A-Fa-f]{6})|(#[0-9A-Fa-f]{3})|(rgb\(\d+,\d+,\d+\))/g,(function(e,i,a,s){return t.push(i||a||s),""})):t=E[a];return t}(e);if(!(t.length>0))return void i.error("Invalid custom color scheme.");o.spectrumColors=t}for(let i=0;i<e.features.length;i++)o.features.push(await this._getGeoJSONFeat(e,e.features[i],t,s));return this.setDefaultColor&&(this.colorNumDef=a,this.setDefaultColor=!1,t.defaultColor=s),o},_getGeoJSONFeat:async function(e,t,i,a){let s=e.style.layerType,o=!!i.defaultColor,n={type:"Feature",properties:{tooltip:He(i,t,O),infoWindow:He(i,t,F)},geometry:t.geometry};if(t.id&&(n.properties.id=t.id),t.link&&(n.properties.link=t.link),s===w)if(e.style.useColorSpectrum)n.properties.value=t.featureValue,n.properties.stroke=ze(e,t,!1);else{let s=Ee("feat",e,t);s?n.properties.fill=Re(e,t):(n.properties.fill=o?i.defaultColor:a,this.setDefaultColor=!o),n.properties.stroke=ze(e,t,!s)}else if(s===M){let s=ze(e,t,!1);s?n.properties.fill=s:(n.properties.fill=o?i.defaultColor:a,this.setDefaultColor=!o)}else if("svg"===s){let s,r,l=Ee("feat",e,t),h=function(e,t){let i=e.style.svg.pointSvgShape;return i||(i=t.pointSvgShape?t.pointSvgShape:R),i}(e,t),c=De(e,t);this.svgStyles[h]||(h=R),l?(r=Re(e,t),s=ze(e,t,!1)):(r=o?i.defaultColor:a,this.setDefaultColor=!o,s=ze(e,t,!!B[h])),n.properties.imageId=e.id+"-"+h+"-"+r+"-"+c+(s?`-${s}`:""),this._addSvgShape({imageId:n.properties.imageId,name:h,color:r,size:c,stroke:s,strokeWidth:e.style.svg.strokeWidth,opacity:$e(e)})}else if(s===T){let i=e.style.icon.imageUrl,a=t.pointImageUrl,s=i||a,r=.1*De(e,t);Ee("feat",e,t)||o||(this.setDefaultColor=!0),n.properties.imageId=s,n.properties.size=r,this.map.hasImage(n.properties.imageId)||await this._addUrlImage(s,n.properties.imageId)}else if(s===k){let s=function(e,t){let i=e.style.icon.cssClasses;return i||(i=t.cssClasses?t.cssClasses:Z),i}(e,t),r=Re(e,t);r||(r=o?i.defaultColor:a,this.setDefaultColor=!o),n.properties.imageId=s.replace(/\s/g,"-")+"-"+r,await this._addFontIcon(n.properties.imageId,s,r)}else if(s===L)n.properties.value=t.featureValue;else if(s===x)if(n.properties.height=t.featureValue3d,e.style.useColorSpectrum)n.properties.value=t.featureValue;else{let s=Re(e,t);s?n.properties.fill=s:(n.properties.fill=o?i.defaultColor:a,this.setDefaultColor=!o)}return n},_addFontIcon:function(e,t,i){if(!this.map.hasImage(e))return new Promise((a=>{let s,n,r,l,h=Ze(t),c=Ne(h);c||(h.remove(),h=Ze(Z),c=Ne(h)),setTimeout((()=>{s=window.getComputedStyle(h,":before").getPropertyValue("font-family"),n=2*o(h).height(),r=2*o(h).width(),l=new Le(s,n,r,c,i),h.remove(),this.map.addImage(e,l,{pixelRatio:2}),a()}),700)}))},_addSvgShape:function(e){if(!this.map.hasImage(e.imageId)){let t,i,a=o.extend(!0,{},this.svgStyles[e.name]);const{size:s,color:n,opacity:r,stroke:l,strokeWidth:h}=e;i=h?h/s:null,a.width*=2*s,a.height*=2*s,a.fill=n,a["fill-opacity"]=r,a.stroke=l,a["stroke-width"]=i,t=new xe(a),this.map.addImage(e.imageId,t,{pixelRatio:2})}},_addUrlImage:async function(e,t){try{let i=await this.map.loadImage(e);i&&this.map.addImage(t,i.data)}catch(e){i.error("Invalid image URL.",e)}},_addExtrusionCtrl:function(){let e=this;if(!e.toggleDimensionsCtrl){let t;e.toggleDimensionsCtrl=new Me,e.map.addControl(e.toggleDimensionsCtrl),t=e.toggleDimensionsCtrl.getButton(),t.on("click",(function(){e.toggleDimensionsCtrl.isActive?e.map.getPitch()<40&&(e._setMapPitch(40),e._fireMapChangedEvent(ie)):e.map.getPitch()>0&&(e._setMapPitch(0),e._fireMapChangedEvent(ie))})),e.map.getPitch()<40&&(e._setMapPitch(40),e._fireMapChangedEvent(ie))}},_setMapPitch:function(e){this.map.setPitch(e),this.overViewMap&&this.overViewMap.setPitch(e),this.sessionStore.setItem(K,e)},_addMessagesContainer:function(){const{position:e,selector:t}=this.options.layerMessages;this.messagesContainer$||(this.messagesContainer$=o(`<div class='a-MapRegion-messages' role='region' aria-label='${qe("MAP_MESSAGES")}'></div>`)),"top"===e?this.regionContainer$.prepend(this.messagesContainer$):"bottom"===e?this.regionContainer$.append(this.messagesContainer$):"selector"===e&&o(t).append(this.messagesContainer$)},_addMessageItem:function(t,i){if(this.messagesContainer$&&i){let a,s,n=e.htmlBuilder();n.markup("<div class='a-MapRegion-message'>").markup("<span class='a-MapRegion-messageText' role='alert'>"),t.label?n.markup(t.label):n.content(t.name),n.markup(`: ${i}`).markup("</span></div>"),a=o(n.toString()),n.clear(),n.markup("<button class='a-MapRegion-messageClose'>").markup("<span class='"+u+" icon-remove'").attr(le,qe("REMOVE_MESSAGE")).markup("></span>").markup("</button>"),s=o(n.toString()),s.on("click",(function(e){e.preventDefault(),o(this).parent().remove()})),a.prepend(s),this.messagesContainer$.append(a)}},_addLegend:function(){const{title:t,cssClasses:i=""}=this.options.legend;let a=e.htmlBuilder(),s="a-MapRegion-legend "+i;a.markup("<div").attr("class",s.trim()).attr("id",this.options.regionStaticId+"_legend").markup(">"),t&&a.markup(this._getLegendTitle()),a.markup("</div>"),this.legendContainer$=o(a.toString()),this._positionLegend()},_getLegendTitle:function(){let t=e.htmlBuilder();return t.markup("<div class='a-MapRegion-legendTitle' ").attr("id",this.options.regionStaticId+J).markup(">").markup(this.options.legend.title).markup("</div>"),t.toString()},_positionLegend:function(){const{position:e,selector:t}=this.options.legend;"start"===e?this.componentContainer$.prepend(this.legendContainer$):"end"===e?this.componentContainer$.append(this.legendContainer$):"selector"===e&&o(t).append(this.legendContainer$)},_updateLegendContainer:function(){let t=this.options;if(t.legend){const{title:i,cssClasses:a=""}=t.legend;let s,n="a-MapRegion-legend "+a,r=t.regionStaticId+J,l=o("#"+e.escapeCSS(r)),h=this.legendContainer$.find("."+m);this.legendContainer$.removeClass(),this.legendContainer$.addClass(n),i?0===l.length?(this.legendContainer$.prepend(this._getLegendTitle()),h.each((function(){s=o(this).attr(re).split(" "),o(this).attr(re,r+" "+s[0])}))):l.text(i):l.length>0&&(l.remove(),h.each((function(){s=o(this).attr(re).split(" "),o(this).attr(re,s[1])}))),this._positionLegend()}else this._cleanUpLegend();setTimeout((()=>{this._resize()}),200)},_getLegendColor:function(e,t,i){let a,s=t.spectrumColors;if(t.layerType===M){let t=ze(e,e.features[0],!1);a=t||i}else if(s)a=s[s.length-1];else{let t=Re(e,e.features[0]);a=t||i}return a},_addLegendItem:function(t,i,a){let s,n=this,r=e.htmlBuilder(),l=n._getLegendColor(t,a,i.defaultColor),h=i.iconCssClasses,c=t.id+X,d=c+"_label",p=c+"_checkbox",u="";this.options.legend.title&&(u+=this.options.regionStaticId+J),u+=" "+d,r.markup("<div class='"+m+"' ").attr("id",c).attr(re,u.trim()).attr("style",`--a-map-legend-selector-color:${l}`).markup(">").markup("<input type='checkbox' class='a-MapRegion-legendSelector is-checked' checked").attr("id",p).markup("/>").markup("<label  class='a-MapRegion-legendLabel' ").attr("id",d).attr("for",p).markup(">").markup(i.label||e.escapeHTML(i.name)),h&&r.markup("<span class='a-MapRegion-legendIcon "+h+"' aria-hidden='true' ></span>"),r.markup("</label></div>"),this.legendContainer$.append(r.toString()),s=o("#"+p),t.allowHide?(this.legendContainer$.find("."+m).addClass("a-MapRegion-legendItem--hideable"),s.on("keydown",(function(e){"Enter"===e.key&&s.prop("checked",!s.is(":checked")).trigger("change")})).on("change",(function(){this.checked?(n.map.setLayoutProperty(t.id,ae,se),o(this).find(".a-MapRegion-legendSelector").addClass("is-checked"),n._fetchOnMapDragged(),n._fetchOnZoomChanged(),n._fetchOnMapRotated()):(n.map.setLayoutProperty(t.id,ae,"none"),o(this).find(".a-MapRegion-legendSelector").removeClass("is-checked"),n.closeAllInfoWindows(t.id)),n._fireMapChangedEvent("toggle-layer")}))):s.on("click",(function(e){e.preventDefault()}))},_hideLegendItem:function(e){let t=o("#"+e+X);t.hasClass(b)||t.addClass(b)},_showLegendItem:function(e){o("#"+e+X).removeClass(b)},_addLayerHandlers:function(e){let t=this,i=e.id.toString();t.map.on("click",i,(function(e){i===t.topLayer&&(e.features[0].properties.link?t._redirect(e.features[0],e.lngLat):t._showInfoWindow(e.features[0],e.lngLat,!0))})).on("mousemove",i,(function(a){if(i!==t.topLayer)t.tooltip.remove(),t.map.getCanvas().style.cursor="";else{const{infoWindow:i={},tooltip:s={},link:o,cluster:n=!1}=a.features[0].properties;t.distanceTool.isActive||t.rectangleZoomTool.isActive||je(i)&&je(s)&&!n&&!o||(t.map.getCanvas().style.cursor=ce),t._showTooltip(e,a.features[0],a.lngLat,!0)}})).on("mouseleave",i,(function(){t.rectangleZoomTool.isActive||t.distanceTool.isActive||(t.map.getCanvas().style.cursor=""),t.tooltip.remove()}))},_showTooltip:function(t,i,o,n){let r=e.htmlBuilder(),l=this._getLayerInfo(t.id),h=[],c={};const d=`${f} a-MapRegion-popup--tooltip`,{label:p,name:m}=l;if(i.properties.cluster){let o=s.formatCompactNumber(i.properties.point_count);const{clusterTooltip:n}=t.clusterFeatures;if(n)c={extraSubstitutions:{COUNT:o,LAYER:p||e.escapeHTML(m)},defaultEscapeFilter:"RAW"},r.markup("<div class='"+d+"'>").markup(n).markup("</div>");else{let e=a.formatMessageNoEscape(Y+"LAYER_NAME",p||m);r.markup("<div class='"+d+"'>").markup("<div class='"+y+"'>"),p?r.markup(e):r.content(e),r.markup("</div><div class='"+v+"'>").content(a.formatMessage(Y+"POINTS_COUNT",o)).markup("</div></div>")}}else{let t=i.properties.tooltip;if(Ye(t)&&(t=Je(t)),t){let i=t.content;if(i)if(t.type===P&&i.template){const{cssClasses:a="",template:s}=i;let o=`${d} ${e.applyTemplate(a,{directives:!1,defaultEscapeFilter:"RAW"})}`;r.markup("<div").attr("class",o.trim()).markup(">").markup(s).markup("</div>"),c={extraSubstitutions:{...t.columns}}}else if(t.type===A){let e=a.formatMessageNoEscape(Y+"LAYER_NAME",p||m);r.markup("<div class='"+d+"'>").markup("<div class='"+y+"'>"),p?r.markup(e):r.content(e),r.markup("</div><div class='"+v+"'>").content(i).markup("</div></div>")}}}r.html&&(h=this._getPopupCoords(i,o),this.tooltip.options.anchor=this._getAnchor(et(i.geometry.type)?"top":"bottom",{lng:h[0],lat:h[1]}),this.tooltip.options.focusAfterOpen=n,this.tooltip.setLngLat(h).setHTML(e.applyTemplate(r.toString(),c)).addTo(this.map))},_showInfoWindow:function(t,i,a){let s=o.extend({},t.properties),n=this._getPopupCoords(t,i),r={};if(s.cluster)delete s.cluster,delete s.point_count_abbreviated;else if(delete s.imageId,!this.distanceTool.isActive){let i=s.infoWindow;if(Ye(i)&&(i=Je(i)),i&&i.type){let l=e.htmlBuilder(),h=i.content;const c=`${f} a-MapRegion-popup--info`;if(i.type===P){const{cssClasses:t="",template:a}=h;if(a){let s=`${c} ${e.applyTemplate(t,{directives:!1,defaultEscapeFilter:"RAW"})}`;l.markup("<div").attr("class",s.trim()).markup(">").markup(a).markup("</div>"),r={extraSubstitutions:{...i.columns}}}}else i.type===A&&(l.markup("<div class='"+c+"'>"),h.title&&l.markup("<div class='"+y+"'>").content(h.title).markup("</div>"),h.body&&l.markup("<div class='"+v+"'>").content(h.body).markup("</div>"),l.markup("</div>"));if(l.html){let i=this._getLayerInfo(parseInt(t.layer.id,10)),h=new maplibregl.Popup({closeOnClick:!0,focusAfterOpen:a,anchor:this._getAnchor(et(t.geometry.type)?"top":"bottom",{lng:n[0],lat:n[1]})}).setLngLat(n).setHTML(e.applyTemplate(l.toString(),r)).addTo(this.map);o(h.getElement()).find(".maplibregl-popup-close-button").html("<span class='a-Icon icon-remove' aria-hidden='true'>"),s.id?(i.activePopups[s.id]=h,h.on("close",(function(){delete i.activePopups[s.id]}))):(je(i.activePopups)||i.activePopups.infoWindow.remove(),i.activePopups.infoWindow=h)}}}this._trigger(Q,{},{...s,lng:n[0],lat:n[1],layer:t.layer.id})},_getAnchor:function(e,t){let i=this.map.project(t),a=this.map.getContainer();const s=100;return i.x<s||i.x>a.offsetWidth-s||i.y<s||i.y>a.offsetHeight-s?"":e},_redirect:function(e,t){let i=o.extend({},e.properties),a=this._getPopupCoords(e,t);delete i.imageId,this._trigger(Q,{},{...i,lng:a[0],lat:a[1]}),apex.navigation.redirect(i.link)},_getPopupCoords:function(e,t){let i=[];if(e.geometry.type===I){if(i=e.geometry.coordinates.slice(),t)for(;Math.abs(t.lng-i[0])>180;)i[0]+=t.lng>i[0]?360:-360}else i[0]=t.lng,i[1]=t.lat;return i},_getLayerInfo:function(e){let t=this.options.layers.findIndex((t=>t.id===e));return this.options.layers[t]},_cleanupMessages:function(){this.messagesContainer$&&(this.messagesContainer$.empty(),this.messagesContainer$.remove(),this.messagesContainer$=null)},_cleanUpLegend:function(){this.legendContainer$&&(this.legendContainer$.remove(),this.legendContainer$=null)},_cleanupSessionStore:function(){[G,j,U,K,W].forEach((e=>{this.sessionStore.removeItem(e)}))},_destroy:function(){this.componentContainer$&&(this.componentContainer$.empty(),this.componentContainer$.remove()),this._cleanupMessages(),r.offElementResize(e.escapeCSS(this.mapContainerId)),r.offVisibilityChange(this.regionContainer$[0])},_clean:function(e){this._destroy(),this._cleanUpLegend(),this._removeOverviewMap(),this.map?(this.map.remove(),this.map=null):i.warn(ve),this.topLayer=null,this.layersIds=[],this.svgStyles=B,this.lastMapStatusOnFetch={},this.colorNumDef=0,this.setDefaultColor=!1,this.tooltip.remove(),this.rectangleZoomTool={},this.navControl=null,this.scaleBar=null,this.browserLocationTool=null,this.circleTool=null,this.distanceTool={},this.attribution=null,this.toggleDimensionsCtrl=null,e&&this._cleanupSessionStore()},_reset:function(e){this._clean(e),this._setSessionStoreInitPos(!e),this._render(),this._initMap(e)},_setOption:function(t,i){let a=this.options;if(this._super(t,i),"tileLayer"!==t||je(i))if("navigationBar"!==t||je(i))if("mapFeatures"!==t||je(i))if("layerMessages"===t&&Qe(i))if(je(i))this._cleanupMessages(),a.layerMessages=null;else{const{position:e,selector:t}=i;e&&(a.layerMessages={position:e,selector:t},this.map&&this._addMessagesContainer())}else if("mapUnitSystem"===t&&Ye(i)){let e=i.toLowerCase();z[e]&&(a.mapUnitSystem=e,this.map&&(this.scaleBar&&this.scaleBar.setUnit(e),je(this.distanceTool)||this.distanceTool.setUnit(e)))}else"mapStatusItem"===t&&Ye(i)?a.mapStatusItem=e.escapeCSS(i):"customStyles"===t&&Qe(i)?(a.customStyles=i,this._addCustomSvgStyles(i)):"legend"===t&&Qe(i)&&(a.legend=je(i)?null:i,this.map&&(a.legend?(a.legend.title&&(a.legend.title=e.escapeHTML(i.title)),this.legendContainer$?this._updateLegendContainer():(this._addLegend(),setTimeout((()=>{this._resize()}),200),a.mapData.map.series.forEach((e=>{if(e.legend){let t=this.map.getSource(e.id.toString()+q);t&&this._addLegendItem(e,this._getLayerInfo(e.id),t._data)}})))):this.legendContainer$&&(a.mapData.map.series.forEach((e=>{let t=e.id.toString();!this._isVisibleLayer(t)&&this.map.getLayer(t)&&this.map.setLayoutProperty(t,ae,se)})),this._updateLegendContainer())));else{const{rectangleZoom:e,scaleBar:t,overviewMap:s,infiniteMap:n,browserLocation:r,circleTool:l,distanceTool:h,mousewheelZoom:c}=i;if(Xe(e)&&(a.mapFeatures.rectangleZoom=e,this.map&&(e?this._addRectangleTool():je(this.rectangleZoomTool)||(this.map.removeControl(this.rectangleZoomTool),this.rectangleZoomTool={}))),Xe(t)&&(a.mapFeatures.scaleBar=t,this.map&&(t?this._addScaleTool():this.scaleBar&&(this.map.removeControl(this.scaleBar),this.scaleBar=null))),Xe(s)&&(a.mapFeatures.overviewMap=s,this.map&&(s?this._addOverviewMap():this._removeOverviewMap())),Xe(n)&&this.map&&(a.mapFeatures.infiniteMap=n,this.map.setRenderWorldCopies(n),this.overViewMap)){let e=this.map.getCenter();this.overViewMap.setCenter(e),this.overviewSquare.setLngLat(e)}Xe(r)&&(a.mapFeatures.browserLocation=r,this.map&&(r?this._addBrowserLocation():this.browserLocationTool&&(this.map.removeControl(this.browserLocationTool),this.browserLocationTool=null))),Xe(l)&&(a.mapFeatures.circleTool=l,this.map&&(l?this._addCircleTool():this.circleTool&&(this.circleTool.removeCircleLayer(),o(this.circleTool.container).off(ee),o(this.circleTool.container).off(te),this.map.removeControl(this.circleTool),this.circleTool=null))),Xe(h)&&(a.mapFeatures.distanceTool=h,this.map&&(h?this._addDistanceTool():je(this.distanceTool)||(this.distanceTool.isActive&&this.distanceTool.deactivate(),this.map.removeControl(this.distanceTool),this.distanceTool={}))),Xe(c)&&(a.mapFeatures.mousewheelZoom=c,this.map&&(c?this.map.scrollZoom.enable():this.map.scrollZoom.disable()))}else a.navigationBar=i,this.map&&(a.navigationBar.type&&(this._removeNavControl(),this._addNavControl(a.navigationBar.type)),a.navigationBar.position&&this._setNavControlPosition(a.navigationBar.position));else{const{name:e,darkmodeName:t}=i;e&&(a.tileLayer.name=e,this.map&&!We()&&this._reset(!1)),t&&(a.tileLayer.darkmodeName=t,this.map&&We()&&this._reset(!1))}},_addNavControl:function(t){if("none"!==t){let i="full"===t||"no-compass"===t,a="full"===t,s=this.options.navigationBar.position;this.navControl=new maplibregl.NavigationControl({showZoom:i,showCompass:a}),this.map.addControl(this.navControl,s),"top-left"===s&&o("#"+e.escapeCSS(this.mapContainerId)).addClass(C),setTimeout((()=>{let e=o(this.navControl._container);if(a){let t=qe("ZOOM_IN"),i=qe("ZOOM_OUT");e.find(".maplibregl-ctrl-zoom-in").attr({title:t,"aria-label":t}),e.find(".maplibregl-ctrl-zoom-out").attr({title:i,"aria-label":i})}if(a){let t=qe("RESET_BEARING_TO_NORTH");e.find(".maplibregl-ctrl-compass").attr({title:t,"aria-label":t})}}),200)}},_setNavControlPosition:function(t){if(this.navControl){let i=o("#"+e.escapeCSS(this.mapContainerId));"top-left"===t?i.hasClass()||i.addClass(C):i.removeClass(C),this.options.navigationBar.position=t,this._removeNavControl(),this._addNavControl(this.options.navigationBar.type)}},_addRectangleTool:function(){je(this.rectangleZoomTool)&&(this.rectangleZoomTool=new Se({scopedActions:this.scopedActions}),this.map.addControl(this.rectangleZoomTool))},_addScaleTool:function(){this.scaleBar||(this.scaleBar=new maplibregl.ScaleControl({maxWidth:100,unit:this.options.mapUnitSystem}),this.map.addControl(this.scaleBar))},_addBrowserLocation:function(){if(!this.browserLocationTool){let e=qe("FIND_MY_LOCATION");this.browserLocationTool=new maplibregl.GeolocateControl({positionOptions:{enableHighAccuracy:!0},trackUserLocation:!0}),this.map.addControl(this.browserLocationTool),setTimeout((()=>{o(this.browserLocationTool._container).find(".maplibregl-ctrl-geolocate").attr({title:e,"aria-label":e})}),200)}},_addCircleTool:function(){this.circleTool||(this.circleTool=new _e({scopedActions:this.scopedActions}),this.map.addControl(this.circleTool),o(this.circleTool.container).on(ee,((e,t)=>{this._fireMapChangedEvent("circle-drawn",t)})),o(this.circleTool.container).on(te,(()=>{this._fireMapChangedEvent("circle-removed")})))},_addDistanceTool:function(){if(je(this.distanceTool)){let e=this.options;this.distanceTool=new we({tileLayer:e.tileLayer,unitSystem:e.mapUnitSystem}),this.map.addControl(this.distanceTool)}},_addCustomSvgStyles:function(e){if(Ye(e)&&(e=Je(e)),e)if(Array.isArray(e)){this.options.customStyles=e;for(let t=0;t<e.length;t++)e[t].name&&(this.svgStyles[e[t].name]=e[t])}else i.error("Custom SVG styles must be an array of objects.")},_addOverviewMap:function(){if(!this.overViewMap){const{pitch:t,bearing:i}=this.getMapPitchAndBearing(),{minZoom:a}=this._getMinMaxZoomLevels();let s=this.options,n=e.escapeCSS(s.regionStaticId)+"_overview_map",r=document.createElement("div"),l=this.map.getCenter(),h=this.map.getZoom(),c={container:n,dragPan:!1,keyboard:!1,scrollZoom:!1,dragRotate:!1,touchZoomRotate:!1,doubleClickZoom:!1,center:l,zoom:h-3,attributionControl:!1,transformRequest:ke(s),pitch:t,bearing:i,locale:{"Map.Title":qe("MAP")}};(async()=>{c.style=await this._getElocation(),this.overViewMapCont$=o("<div id='"+n+"' class='a-MapRegion-overview'></div>"),o("#"+e.escapeCSS(this.mapContainerId)).append(this.overViewMapCont$),this.overViewMap=new maplibregl.Map(c),o(this.overViewMap.getCanvas()).css("cursor","default"),r.className="a-MapRegion-overviewSquare",this.overviewSquare=new maplibregl.Marker({element:r}).setLngLat(l).addTo(this.overViewMap),this.map.setMinZoom(a+3),this.overViewMap.setMinZoom(a)})()}},_removeOverviewMap:function(){if(this.overViewMap){const{minZoom:e}=this._getMinMaxZoomLevels();this.overViewMap.remove(),this.overViewMap=null,this.overViewMapCont$.remove(),this.overViewMapCont$=null,this.map.setMinZoom(e)}},_removeNavControl:function(){this.navControl&&(o("#"+e.escapeCSS(this.mapContainerId)).removeClass(C),this.map.removeControl(this.navControl),this.navControl=null)},_fetch:function(t,a){if(this.map){let i,s,o=this.options;if(o.itemsToSubmit&&(s=o.itemsToSubmit.replaceAll("#",""),s=s.split(",")),this.lastMapStatusOnFetch=this.getMapStatus(),this.lastMapStatusOnFetch.center=this.map.getCenter(),t){let e=20;e/=Math.pow(2,this.lastMapStatusOnFetch.zoom-1),this.lastMapStatusOnFetch.bbox[0]-=e,this.lastMapStatusOnFetch.bbox[1]-=e,this.lastMapStatusOnFetch.bbox[2]+=e,this.lastMapStatusOnFetch.bbox[3]+=e}return i=apex.server.plugin(o.ajaxIdentifier,{pageItems:s,x01:"GET_FEATURES",x02:JSON.stringify({bbox:this.lastMapStatusOnFetch.bbox,zoom:Math.round(this.lastMapStatusOnFetch.zoom)})},{dataType:"json",loadingIndicatorPosition:"centered",refreshObject:"#"+e.escapeCSS(o.regionStaticId),loadingIndicator:this.element,queue:{name:"map-features-"+o.regionStaticId,action:"replace"}}),i.done((e=>{this.options.mapData={...e},this._addLayers()})),i.always((()=>{a&&a()})),i}i.warn(ve)},_fitBounds:function(e,t){if(this.map&&e){let i=[[e[0],e[1]],[e[2],e[3]]],a=i.reduce((function(e,t){return e.extend(t)}),new maplibregl.LngLatBounds(i[0],i[0]));setTimeout((()=>{this.map.fitBounds(a,{padding:20,maxZoom:t||$})}),200)}},_getSerie:function(e){let t=this.options.mapData.map.series,i=t.findIndex((t=>t.id===e));return t[i]},_resize:function(){this.map&&this.map.resize(),this.overViewMap&&this.overViewMap.resize()},refresh:function(){return this._fetch()},focus:function(){o("#"+e.escapeCSS(this.mapContainerId)).find(".maplibregl-canvas").first().trigger("focus")},getLayers:function(){let e=o.extend(!0,[],this.options.layers);for(let t=0;t<e.length;t++)delete e[t].activePopups;return e},getLayerIdByName(e){let t=this.options.layers,i=t.findIndex((t=>t.name===e));return i>-1?t[i].id:null},getFeature:function(e,t){let a=this._getSerie(e),s={};if(a){let e=a.features,o=e.findIndex((e=>e.id===t));e[o]?s=e[o]:i.error(ye)}else i.error(fe);return s},addFeature:function(e,t){let a=this._getSerie(e);if(a)if(a.features.push(t),this.map){let i=e.toString(),s=this.map.getSource(i+q);s&&(async()=>{s._data.features.push(await this._getGeoJSONFeat(a,t,this._getLayerInfo(e),Be(1))),this.map.getSource(i+q).setData(s._data),this._fireMapChangedEvent("feature-added")})()}else i.warn(ve);else i.error(fe)},updateFeature:function(e,t){if(t.id){let a=this._getSerie(e);if(a){let s=a.features.findIndex((e=>e.id===t.id));if(a.features[s])if(a.features[s]=t,this.map){let i=e.toString(),o=this.map.getSource(i+q);if(o){let n=o._data;n.features[s]&&(async()=>{n.features[s]=await this._getGeoJSONFeat(a,t,this._getLayerInfo(e),Be(1)),this.map.getSource(i+q).setData(n),this._fireMapChangedEvent("feature-updated")})()}}else i.warn(ve)}else i.error(fe)}},removeFeature:function(e,t){let a=this._getSerie(e);if(a){let s=a.features.findIndex((e=>e.id===t));if(s>-1)if(a.features.splice(s,1),this.map){let t=e.toString(),i=this.map.getSource(t+q);i&&(i._data.features.splice(s,1),this.map.getSource(t+q).setData(i._data),this._fireMapChangedEvent("feature-removed"))}else i.warn(ve);else i.error(ye)}else i.error(fe)},displayPopup:function(e,t,a,s=!0,o={}){if(this.map)if(e===O||e===F){let n=this.map.getSource(t.toString()+q);if(n){let r=n._data,l=r.features.findIndex((e=>e.properties.id===a)),h=r.features[l];if(h){if(h.geometry.type!==I&&je(o))return void i.error(`LngLat object is required for geometry type '${h.geometry.type}'.`);if(e===O)this.closeTooltip(),this._showTooltip(this._getSerie(t),h,o,s);else{this._getLayerInfo(t).activePopups[a]||(h.layer={id:t},this._showInfoWindow(h,o,s))}}else i.error(ye)}else i.error(fe)}else i.error(`'${e}' is not a valid popup type.`);else i.warn(ve)},closeTooltip:function(){this.tooltip&&this.tooltip.remove()},closeInfoWindow:function(e,t){let i=this._getLayerInfo(e);if(i){let e=i.activePopups;e&&e[t]&&e[t].remove()}},closeAllInfoWindows:function(e){const{layers:t}=this.options;let i=e?t.filter((t=>t.id===e)):t;for(let e=0;e<i.length;e++)i[e].activePopups&&Object.values(i[e].activePopups).forEach((e=>{e.remove()}))},getMapBboxAndZoomLevel:function(){let e={};if(this.map){let t=this.map.getBounds();e={bbox:[t.getWest(),t.getSouth(),t.getEast(),t.getNorth()],zoom:this.map.getZoom()}}else i.warn(ve);return e},getMapCenterAndZoomLevel:function(){let e={};return this.map?e={center:this.map.getCenter(),zoom:this.map.getZoom()}:i.warn(ve),e},getMapPitchAndBearing:function(){let e={};if(this.map){let t=this.map.getBearing(),i=Object.is(t,-0)?0:t;e={pitch:this.map.getPitch(),bearing:i}}else i.warn(ve);return e},setZoomLevel:function(e){this.map?Number.isInteger(e)?this.map.setZoom(e):i.warn("Argument most be a number"):i.warn(ve)},setCenter:function(e){this.map?e&&Array.isArray(e)?(this.map.setCenter(e),this._fireMapChangedEvent("map-drag"),this._fetchOnMapDragged()):i.error("Argument must be an array"):i.warn(ve)},getMapObject:function(){return this.map},getCircle:function(){let e=null;return this.circleTool&&(e=this.circleTool.geoJSONCircle),e},clearCircle:function(){this.circleTool&&this.circleTool.clear(!0)},reset:function(){this._reset(!0)},getMapStatus:function(){let e={};return this.map?e={...this.getMapBboxAndZoomLevel(),...this.getMapPitchAndBearing()}:i.warn(ve),e}})}(apex.util,apex.env,apex.debug,apex.lang,apex.locale,apex.jQuery,apex.actions,apex.widget.util,apex.region,apex.libVersions);