/*!
 * Copyright (c) 2021, 2024, Oracle and/or its affiliates.
 */
!function(t,e,a,o,r,i,s,n){"use strict";const l="miniMap",c="apex-minimap",m=o.APEX_FILES+`libraries/maplibre-gl-js/${n.maplibre}/`,u=o.APEX_FILES+`libraries/mapbox-gl-rtl-text/${n.mapboxGlRtlText}/mapbox-gl-rtl-text.js`,p="elocation-osm-bright",d={"elocation-osm-bright":"https://elocation.oracle.com/appidGC000110/mapviewer/pvt/res/style/osm-bright/style.json","elocation-osm-positron":"https://elocation.oracle.com/appidGC000110/mapviewer/pvt/res/style/osm-positron/style.json","elocation-osm-dark-matter":"https://elocation.oracle.com/appidGC000110/mapviewer/pvt/res/style/osm-dark-matter/style.json"},h={version:8,id:"elocation-osm-raster-tiles",name:"OSM Bright (Oracle)",metadata:{"sgtech:version":"19.1.0","sgtech:sources:type":"raster"},sources:{"elocation-osm-bright":{type:"raster",name:"OSM Bright (Oracle)",attribution:"",tiles:["https://elocation.oracle.com/appidGC000110/mapviewer/mcserver/ELOCATION_MERCATOR/osm_bright/{z}/{y}/{x}.png"],tileSize:256},"elocation-osm-positron":{type:"raster",name:"OSM Positron (Oracle)",attribution:"",tiles:["https://elocation.oracle.com/appidGC000110/mapviewer/mcserver/ELOCATION_MERCATOR/osm_positron/{z}/{y}/{x}.png"],tileSize:256},"elocation-bi-world-map":{type:"raster",name:"Bi World Map (Oracle)",attribution:"",tiles:["https://elocation.oracle.com/appidGC000110/mapviewer/mcserver/ELOCATION_MERCATOR/bi_world_map_mb/{z}/{y}/{x}.png"],tileSize:256},"elocation-osm-dark-matter":{type:"raster",name:"OSM Dark Matter (Oracle)",attribution:"",tiles:["https://elocation.oracle.com/appidGC000110/mapviewer/mcserver/ELOCATION_MERCATOR/osm_darkmatter/{z}/{y}/{x}.png"],tileSize:256},"elocation-world-map":{type:"raster",name:"World Map (Oracle)",attribution:"",tiles:["https://elocation.oracle.com/appidGC000110/mapviewer/mcserver/ELOCATION_MERCATOR/world_map_mb/{z}/{y}/{x}.png"],tileSize:256}},layers:[{id:"elocation-osm-bright-layer",type:"raster",source:p,minzoom:0,maxzoom:18.01}]};t.widget("apex."+l,{widgetEventPrefix:l,options:{background:"default",center:[0,0],zoom:16,marker:!0,markerColor:"",controls:!1,interactive:!0,tooltip:"",useCustomBackground:!1,customBackgroundName:"",customBackgroundType:"",customBackgroundUrl:"",customBackgroundAttribution:"",customBackgroundApiKey:"",customBackgroundHeaders:"",customBackgroundMinZoom:0,customBackgroundMaxZoom:18},_create:function(){let t=this.element;t.hasClass(c)?s.warn("Map is already initialized."):(t.attr("data-map-height")?this._setMapHeight():this._setAutoHeight(),this._createMap(),t.addClass(c))},_getCreateOptions:function(){let t={},e=this.element;return e[0].hasAttribute("data-background")&&(t.background=e.data("background")),e[0].hasAttribute("data-center")&&(t.center=e.data("center")),e[0].hasAttribute("data-zoom")&&(t.zoom=e.data("zoom")),e[0].hasAttribute("data-marker")&&(t.marker=e.data("marker")),e[0].hasAttribute("data-marker-color")&&(t.markerColor=e.data("marker-color")),e[0].hasAttribute("data-controls")&&(t.controls=e.data("controls")),e[0].hasAttribute("data-interactive")&&(t.interactive=e.data("interactive")),e[0].hasAttribute("data-tooltip")&&(t.tooltip=e.data("tooltip")),e[0].hasAttribute("data-custom-map-bg")&&(t.useCustomBackground=e.data("custom-map-bg")),e[0].hasAttribute("data-custom-map-bg-name")&&(t.customBackgroundName=e.data("custom-map-bg-name")),e[0].hasAttribute("data-custom-map-bg-type")&&(t.customBackgroundType=e.data("custom-map-bg-type")),e[0].hasAttribute("data-custom-map-bg-url")&&(t.customBackgroundUrl=e.data("custom-map-bg-url")),e[0].hasAttribute("data-custom-map-bg-attribution")&&(t.customBackgroundAttribution=e.data("custom-map-bg-attribution")),e[0].hasAttribute("data-custom-map-bg-api-key")&&(t.customBackgroundApiKey=e.data("custom-map-bg-api-key")),e[0].hasAttribute("data-custom-map-bg-http-headers")&&(t.customBackgroundHeaders=e.data("custom-map-bg-http-headers")),e[0].hasAttribute("data-custom-map-bg-zoom-min")&&(t.customBackgroundMinZoom=e.data("custom-map-bg-zoom-min")),e[0].hasAttribute("data-custom-map-bg-zoom-max")&&(t.customBackgroundMaxZoom=e.data("custom-map-bg-zoom-max")),t},_setOption:function(t,e){let o=this.element;if(this._super(t,e),this.map)switch(t){case"background":(async()=>{let t=await this._getElocation();this.map.setStyle(t),o[0].hasAttribute("data-background")&&o.data("background",e)})();break;case"center":this.map.setCenter(e),this.marker&&this.marker.setLngLat(e).addTo(this.map),o[0].hasAttribute("data-center")&&o.data("center",e);break;case"zoom":this.map.setZoom(e),o[0].hasAttribute("data-zoom")&&o.data("zoom",e);break;case"marker":this.marker?e||(this.marker.remove(),this.marker=null,this.popup=null):e&&this._createMapMarker(),o[0].hasAttribute("data-marker")&&o.data("marker",e);break;case"markerColor":this.marker&&(this.marker.remove(),this.marker=null,this.popup=null,this._createMapMarker()),o[0].hasAttribute("data-marker-color")&&o.data("marker-color",e);break;case"tooltip":this.popup?e?this.popup.setHTML(a.applyTemplate(e)):(this.popup.setText(""),this.popup.remove(),this.popup=null):e&&this.marker&&this._createMapPopup(),o[0].hasAttribute("data-tooltip")&&o.data("tooltip",e);break;case"controls":this.controls?e||(this.map.removeControl(this.controls),this.controls=null):e&&this._createMapControls(),o[0].hasAttribute("data-controls")&&o.data("controls",e);break;case"interactive":this.map.remove(),this.map=null,this.marker=null,this.popup=null,this.controls=null,this.attribution=null,this._createMap(),o[0].hasAttribute("data-interactive")&&o.data("interactive",e)}else s.warn("miniMap map object is not initialized yet.")},_destroy:function(){this.map.remove(),this.element.empty(),this.element.removeClass(c),this.map=null,this.marker=null,this.popup=null,this.controls=null,this.attribution=null},_setAutoHeight:function(){let t=this.element;t[0].style.height&&0!==t.height()||setTimeout((function(){t.css("height",t.width()*(2/3))}),20)},_loadMaplibreFiles:function(){let e=t.Deferred();var a;return"undefined"==typeof maplibregl?(0===t("link[href='"+m+"maplibre-gl-apex.css']").length&&t("<link/>",{rel:"stylesheet",type:"text/css",href:m+"maplibre-gl-apex.css"}).appendTo("head"),a=function(){e.resolve()},"undefined"==typeof require?i.loadScript({path:m+"maplibre-gl.js"},(function(){a()})):(require.config({paths:{maplibre:m+"maplibre-gl"},shim:{maplibre:{exports:["maplibregl"]}}}),require(["maplibre"],(function(t){window.maplibregl=t,a()})))):e.resolve(),e.promise()},_getElocationName:function(){const e="elocation-";let a=this.options,o="";return o=a.useCustomBackground?e+a.customBackgroundName.toLowerCase().replace(/ +/g,"-"):a.background&&"default"!==a.background?e+a.background:t("body").hasClass("apex-theme-vita-dark")?"elocation-osm-dark-matter":p,o},_useVectorTyleLayers:function(){let t=this._getElocationName()||"";return!!d[t]},_getElocation:async function(){let e=t.extend(!0,{},h),a=this._getElocationName()||"";function o(){e.layers[0].id=a+"-layer",e.layers[0].source=a,e.name=e.sources[a].name}async function r(t){if(t){let e=await fetch(t,{credentials:"omit",cache:"no-store",referrerPolicy:"no-referrer"});if(e.ok){let t=await e.json(),{sources:a={}}=t;return a.openmaptiles&&a.openmaptiles.attribution&&(a.openmaptiles.attribution=""),t}s.error("An error has occured while fetching: "+e.url+" Status: "+e.status)}}if(this.options.useCustomBackground){const t="OGCWMS",i=this.options.customBackgroundType;let s=this.options.customBackgroundUrl.replace("{api-key}",this.options.customBackgroundApiKey);if("VECTOR"===i)e=r(s);else if(["RASTER",t].includes(i)){if(i===t){let t=s.match(/(^|[&])version=([^&]*)/);s+="&request=GetMap&bbox={bbox-epsg-3857}&format=image/png&"+(null!==t&&parseFloat(t[2])>=1.3?"crs":"srs")+"=EPSG:3857&width=256&height=256"}e.sources[a]={type:"raster",name:this.options.customBackgroundName,attribution:"",tiles:[s],tileSize:256},o()}}else this._useVectorTyleLayers()?e=r(d[a]):o();return e},_addCopyrightNotice:function(){const{customBackgroundAttribution:e}=this.options;let a,o=this.options,i=this.map,s=apex.lang.getMessage("APEX.MAPS.TOGGLE_COPYRIGHT"),n=e||null,l=!o.background||"default"===o.background||o.background.includes("osm"),c=o.useCustomBackground?n:l?r.getMessage("APEX.MAPS.OSM_MAP_COPYRIGHT"):r.getMessage("APEX.MAPS.ORACLE_MAP_COPYRIGHT");this.attribution=new maplibregl.AttributionControl({customAttribution:c}),i.addControl(this.attribution),a=t(this.attribution._container).find("button"),a.attr({type:"button",title:s,"aria-label":s})},_createMapMarker:function(){let t=this.options,e=this.map;t.marker&&(this.marker=new maplibregl.Marker({color:t.markerColor||"var(--a-palette-primary, #006BD8)"}).setLngLat(t.center).addTo(e),this._createMapPopup())},_createMapPopup:function(){let e=this,o=this.options;o.marker&&o.tooltip&&(this.popup=new maplibregl.Popup({offset:25}).setHTML(a.applyTemplate(o.tooltip)),this.marker.setPopup(this.popup),this.popup.on("open",(function(){e.popup&&e.popup.getElement()&&t(e.popup.getElement()).css("color","#000")})))},_createMapControls:function(){let t=this.options,e=this.map;t.controls&&(this.controls=new maplibregl.NavigationControl({showCompass:t.interactive}),e.addControl(this.controls))},_createMap:function(){let t,a=this,o=a.options,i=this._useVectorTyleLayers(),s={};function n(){let t=o.useCustomBackground?function(){let t={},e=/([^=]+)=([^,]+),?/g,a=e.exec(o.customBackgroundHeaders);for(;a;)t[a[1]]=a[2],a=e.exec(o.customBackgroundHeaders);return Object.keys(t).length>0?t:null}():i?{"x-oracle-pvtile":"OracleSpatial"}:null;if(t)return(e,a)=>{let o={url:e};return"Tile"===a&&(o.credentials="include",o.headers=t),o}}function l(){let t=Number.isInteger(o.customBackgroundMinZoom),e=Number.isInteger(o.customBackgroundMaxZoom);return{minZoom:o.useCustomBackground?t?o.customBackgroundMinZoom:null:0,maxZoom:o.useCustomBackground?e?o.customBackgroundMaxZoom:null:18}}(async()=>{t=await a._getElocation(),s={container:a.element[0],style:t,center:o.center,zoom:o.zoom,interactive:o.interactive,attributionControl:!1,locale:{"Map.Title":r.getMessage("APEX.MAPS.MAP")},transformRequest:n(),...l()},await a._loadMaplibreFiles(),"unavailable"===maplibregl.getRTLTextPluginStatus()&&(maplibregl.setRTLTextPlugin(u,!0),window.addEventListener("unhandledrejection",(function(t){t.reason.message.startsWith("RTL Text Plugin failed to import scripts from")&&"loaded"===maplibregl.getRTLTextPluginStatus()&&t.preventDefault()}))),a.map=new maplibregl.Map(s),a._createMapMarker(),a._createMapControls(),a._addCopyrightNotice()})(),e.util.onElementResize(a.element[0],(function(){a.map&&a.map.resize()})),a.element.closest(".js-regionDialog").on("dialogresize",(function(){a.map&&a.map.resize()})),e.util.onVisibilityChange(a.element[0],(function(){a._setAutoHeight(),a.map&&a.map.resize()}))},_setMapHeight:function(){let t=this.element.attr("data-map-height");t&&this.element.css("block-size",t)}})}(apex.jQuery,apex.widget,apex.util,apex.env,apex.lang,apex.server,apex.debug,apex.libVersions);